(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13346,        463]
NotebookOptionsPosition[      9087,        336]
NotebookOutlinePosition[     11822,        406]
CellTagsIndexPosition[     11729,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Infinity" :> Documentation`HelpLookup["paclet:ref/Infinity"], 
          "N" :> Documentation`HelpLookup["paclet:ref/N"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Infinity\"\>", 
       2->"\<\"N\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Defining Numerical Values", "Title",
 CellTags->{"S2.5.11", "11.1"},
 CellID->20675],

Cell[TextData[{
 "If you make a definition such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will use the value you give for any ",
 Cell[BoxData["f"], "InlineFormula"],
 " function it encounters. In some cases, however, you may want to define a \
value that is to be used specifically when you ask for numerical values. "
}], "Text",
 CellID->792],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "=", 
     StyleBox["value", "TI"]}], Cell[
    "define a value to be used whenever possible", "TableText"]},
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], "]", "=", 
     StyleBox["value", "TI"]}], Cell[
    "define a value to be used for numerical approximation", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22361],

Cell["Defining ordinary and numerical values. ", "Caption",
 CellID->31754],

Cell[TextData[{
 "This defines a numerical value for the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16398],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"f", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"-", "i"}]}], "/", 
     RowBox[{"i", "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "20"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->23146],

Cell[TextData[{
 "Defining the numerical value does not tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " anything about the ordinary value of ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "+", 
  RowBox[{"f", "[", "5", "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->26946],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "+", 
  RowBox[{"f", "[", "5", "]"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->21188]
}, Open  ]],

Cell[TextData[{
 "If you ask for a numerical approximation, however, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the numerical values you have defined. "
}], "MathCaption",
 CellID->19569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->8638],

Cell[BoxData["0.7932442999131621`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->27663]
}, Open  ]],

Cell[TextData[{
 "You can define numerical values for both functions and symbols. The \
numerical values are used by all numerical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions, including ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " and so on. "
}], "Text",
 CellID->15075],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], "]", "=", 
     StyleBox["value", "TI"]}], Cell["\<\
define a numerical value to be used when default numerical precision is \
requested\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     StyleBox["n", "TI"], ",", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"], "}", "]", "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "define a numerical value to be used when ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]digit precision and any accuracy is requested"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24515],

Cell["\<\
Defining numerical values that depend on numerical precision. \
\>", "Caption",
 CellID->11521],

Cell[TextData[{
 "This defines a numerical value for the symbol ",
 Cell[BoxData["const"], "InlineFormula"],
 ", using ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"4", "n"}], "+", "5"}]], "InlineFormula"],
 " terms in the product for ",
 Cell[BoxData["n"], "InlineFormula"],
 "\[Hyphen]digit precision. "
}], "MathCaption",
 CellID->475],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"const", ",", 
    RowBox[{"{", 
     RowBox[{"n_", ",", "Infinity"}], "}"}]}], "]"}], ":=", 
  RowBox[{"Product", "[", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"2", "^", 
      RowBox[{"-", "i"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "2", ",", 
      RowBox[{
       RowBox[{"4", "n"}], "+", "5"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->15615],

Cell[TextData[{
 "Here is the value of ",
 Cell[BoxData["const"], "InlineFormula"],
 ", computed to 30\[Hyphen]digit precision using the value you specified. "
}], "MathCaption",
 CellID->20528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"const", ",", "30"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->13234],

Cell[BoxData["0.577576190173204842557799443858461560191402560656`30."], \
"Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->12570]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats numerical values essentially like upvalues. When you define a \
numerical value for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively enters your definition as an upvalue for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " with respect to the numerical evaluation operation ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->905],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->192239898],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Defining Numerical Values - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/ModifyingBuiltInFunctions"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 53.5309866}", "context" -> "", 
    "keywords" -> {"N", "numerical values"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "If you make a definition such as f[x_]:=value, Mathematica will use the \
value you give for any f function it encounters. In some cases, however, you \
may want to define a value that is to be used specifically when you ask for \
numerical values. Defining ordinary and numerical values. This defines a \
numerical value for the function f. ", "synonyms" -> {"2.5.11"}, "title" -> 
    "Defining Numerical Values", "type" -> "Tutorial", "uri" -> 
    "tutorial/DefiningNumericalValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.11"->{
  Cell[1930, 60, 90, 2, 70, "Title",
   CellTags->{"S2.5.11", "11.1"},
   CellID->20675]},
 "11.1"->{
  Cell[1930, 60, 90, 2, 70, "Title",
   CellTags->{"S2.5.11", "11.1"},
   CellID->20675]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.11", 11513, 389},
 {"11.1", 11615, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1305, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1930, 60, 90, 2, 70, "Title",
 CellTags->{"S2.5.11", "11.1"},
 CellID->20675],
Cell[2023, 64, 484, 14, 70, "Text",
 CellID->792],
Cell[2510, 80, 750, 22, 70, "DefinitionBox",
 CellID->22361],
Cell[3263, 104, 75, 1, 70, "Caption",
 CellID->31754],
Cell[3341, 107, 147, 5, 70, "MathCaption",
 CellID->16398],
Cell[3491, 114, 353, 13, 70, "Input",
 CellID->23146],
Cell[3847, 129, 233, 8, 70, "MathCaption",
 CellID->8714],
Cell[CellGroupData[{
Cell[4105, 141, 145, 5, 28, "Input",
 CellID->26946],
Cell[4253, 148, 233, 8, 36, "Output",
 CellID->21188]
}, Open  ]],
Cell[4501, 159, 204, 6, 70, "MathCaption",
 CellID->19569],
Cell[CellGroupData[{
Cell[4730, 169, 93, 3, 70, "Input",
 CellID->8638],
Cell[4826, 174, 173, 5, 36, "Output",
 CellID->27663]
}, Open  ]],
Cell[5014, 182, 502, 17, 70, "Text",
 CellID->15075],
Cell[5519, 201, 1160, 35, 70, "DefinitionBox",
 CellID->24515],
Cell[6682, 238, 105, 3, 70, "Caption",
 CellID->11521],
Cell[6790, 243, 333, 11, 70, "MathCaption",
 CellID->475],
Cell[7126, 256, 447, 16, 70, "Input",
 CellID->15615],
Cell[7576, 274, 194, 5, 70, "MathCaption",
 CellID->20528],
Cell[CellGroupData[{
Cell[7795, 283, 122, 4, 70, "Input",
 CellID->13234],
Cell[7920, 289, 211, 6, 36, "Output",
 CellID->12570]
}, Open  ]],
Cell[8146, 298, 584, 20, 70, "Text",
 CellID->905],
Cell[CellGroupData[{
Cell[8755, 322, 72, 1, 70, "RelatedTutorialsSection",
 CellID->192239898],
Cell[8830, 325, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[9060, 334, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

