(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25533,        886]
NotebookOptionsPosition[     19229,        693]
NotebookOutlinePosition[     22521,        773]
CellTagsIndexPosition[     22428,        767]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Format" :> Documentation`HelpLookup["paclet:ref/Format"], 
          "Infix" :> Documentation`HelpLookup["paclet:ref/Infix"], "Postfix" :> 
          Documentation`HelpLookup["paclet:ref/Postfix"], "PrecedenceForm" :> 
          Documentation`HelpLookup["paclet:ref/PrecedenceForm"], "Prefix" :> 
          Documentation`HelpLookup["paclet:ref/Prefix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Format\"\>", 2->"\<\"Infix\"\>", 
       3->"\<\"Postfix\"\>", 4->"\<\"PrecedenceForm\"\>", 
       5->"\<\"Prefix\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Defining Output Formats", "Title",
 CellTags->{"S2.9.16", "16.1"},
 CellID->9464],

Cell[TextData[{
 "Just as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to define how expressions should be evaluated, so also it \
allows you to define how expressions should be formatted for output. The \
basic idea is that whenever ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is given an expression to format for output, it first calls ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " to find out whether any special rules for formatting the expression have \
been defined. By assigning a value to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " you can therefore tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that you want a particular kind of expression to be output in a special \
way. "
}], "Text",
 CellID->19557],

Cell[TextData[{
 "This tells ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to format ",
 Cell[BoxData["bin"], "InlineFormula"],
 " objects in a special way. "
}], "MathCaption",
 CellID->28962],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{"bin", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14161],

Cell[TextData[{
 "Now ",
 Cell[BoxData["bin"], "InlineFormula"],
 " objects are output to look like binomial coefficients. "
}], "MathCaption",
 CellID->30524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bin", "[", 
  RowBox[{
   RowBox[{"i", "+", "j"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12549],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw6AOxjAQDkP0fyAJj
/f//gTSEZAWRzCBRMGBQQOOzgFWxoIkyAQkmIBcqDQVSaKqYseoFi7Ig+AwM
0sTrg/JBtslg1cX8H9P9IK4sFh9gV43qNnRb8OhDchsTFl8R1gliEudOZmj4
yxOlWmVIq5KAxiAnUarRQ52N6FhgBXLZ0cQ5yDINXRVtTGWFunkwu5E8U7Hl
fBBXEEizYIkl7OWFElGq0Ms/QQIuhJhCXKkJKWEZGAFBWPf8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{47, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237587486]
}, Open  ]],

Cell[TextData[{
 "Internally, however, ",
 Cell[BoxData["bin"], "InlineFormula"],
 " objects are still exactly the same. "
}], "MathCaption",
 CellID->330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31923],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"bin", "[", 
    RowBox[{
     RowBox[{"Plus", "[", 
      RowBox[{"i", ",", "j"}], "]"}], ",", "k"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->286150509]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Format"], "[", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], "]", ":=", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"]}], Cell[TextData[{
     "define ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], "1"]], "InlineFormula"],
     " to be formatted like ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Format"], "[", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ",", 
     StyleBox["form", "TI"], "]", ":=", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"]}], Cell[
    "give a definition only for a particular output form", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14333],

Cell["Defining your own rules for formatting. ", "Caption",
 CellID->22925],

Cell[TextData[{
 "By making definitions for ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ", you can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to format a particular expression so as to look like another expression. \
You can also tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to run a program to determine how a particular expression should be \
formatted. "
}], "Text",
 CellID->10910],

Cell[TextData[{
 "This specifies that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should run a simple program to determine how ",
 Cell[BoxData["xrep"], "InlineFormula"],
 " objects should be formatted."
}], "MathCaption",
 CellID->19737],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{"xrep", "[", "n_", "]"}], "]"}], ":=", 
  RowBox[{"StringJoin", "[", 
   RowBox[{"Table", "[", 
    RowBox[{"\"\<x\>\"", ",", 
     RowBox[{"{", "n", "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16336],

Cell[TextData[{
 "The strings are created when each ",
 Cell[BoxData["xrep"], "InlineFormula"],
 " is formatted. "
}], "MathCaption",
 CellID->18337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xrep", "[", "1", "]"}], "+", 
  RowBox[{"xrep", "[", "4", "]"}], "+", 
  RowBox[{"xrep", "[", "9", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1278],

Cell[BoxData[
 RowBox[{"\<\"x\"\>", "+", "\<\"xxxx\"\>", 
  "+", "\<\"xxxxxxxxx\"\>"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->934770105]
}, Open  ]],

Cell[TextData[{
 "Internally however the expression still contains ",
 Cell[BoxData["xrep"], "InlineFormula"],
 " objects. "
}], "MathCaption",
 CellID->7636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"xrep", "[", "n_", "]"}], "->", 
   RowBox[{"x", "^", "n"}]}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->30714],

Cell[BoxData[
 RowBox[{"x", "+", 
  SuperscriptBox["x", "4"], "+", 
  SuperscriptBox["x", "9"]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->196936549]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Prefix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prefix"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["h", "TI"], "]"}], Cell[TextData[{
     "prefix form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["h", "TI"], " ", 
       StyleBox["x", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Postfix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Postfix"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["h", "TI"], "]"}], Cell[TextData[{
     "postfix form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], " ", 
       StyleBox["h", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Infix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infix"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", ",", 
     StyleBox["h", "TI"], "]"}], Cell[TextData[{
     "infix form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], " ", 
       StyleBox["h", "TI"], " ", 
       StyleBox["y", "TI"], " ", 
       StyleBox["h", "TI"], 
       StyleBox["\[Ellipsis]", "TR"], "  "}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Prefix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prefix"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]", "]"}], Cell[TextData[{
     "standard prefix form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "@", 
       StyleBox["x", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Postfix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Postfix"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], "]", "]"}], Cell[TextData[{
     "standard postfix form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "//", 
       StyleBox["f", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Infix",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infix"], "[", 
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "]"}], Cell[TextData[{
     "standard infix form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "~", 
       StyleBox["f", "TI"], "~", 
       StyleBox["y", "TI"], "~", 
       StyleBox["f", "TI"], "~", 
       StyleBox["\[Ellipsis]", "TR"], "  "}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrecedenceForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrecedenceForm"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "an object to be parenthesized with a precedence level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31591],

Cell["Output forms for operators. ", "Caption",
 CellID->19949],

Cell[TextData[{
 "This prints with ",
 Cell[BoxData["f"], "InlineFormula"],
 " represented by the \[OpenCurlyDoubleQuote]prefix operator\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["<>"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prefix", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "\"\<<>\>\""}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->2505],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"<>", "x"}],
  Prefix[
   $CellContext`f[$CellContext`x], "<>"],
  Editable->False]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->511123994]
}, Open  ]],

Cell[TextData[{
 "Here is output with the \[OpenCurlyDoubleQuote]infix operator\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox["\[Precedes]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox["\[Succeeds]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->10004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Infix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    "\"\<\[Precedes]\[Succeeds]\>\""}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->16337],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "a", "\<\"\[Precedes]\[Succeeds]\"\>", 
   "b", "\<\"\[Precedes]\[Succeeds]\"\>", "c"}],
  Infix[{$CellContext`a, $CellContext`b, $CellContext`c}, 
   "\[Precedes]\[Succeeds]"],
  Editable->False]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->973831380]
}, Open  ]],

Cell[TextData[{
 "By default, the \[OpenCurlyDoubleQuote]infix operator\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox["\[Precedes]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox["\[Succeeds]", TraditionalForm]], "InlineMath"],
 " is assumed to have \[OpenCurlyDoubleQuote]higher precedence\
\[CloseCurlyDoubleQuote] than ",
 Cell[BoxData["^"], "InlineFormula"],
 ", so no parentheses are inserted. "
}], "MathCaption",
 CellID->28664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "^", "2"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->9970],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
    "a", "\<\"\[Precedes]\[Succeeds]\"\>", 
     "b", "\<\"\[Precedes]\[Succeeds]\"\>", "c"}],
    Infix[{$CellContext`a, $CellContext`b, $CellContext`c}, 
     "\[Precedes]\[Succeeds]"],
    Editable->False], ")"}], "2"]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1935725024]
}, Open  ]],

Cell[TextData[{
 "When you have an output form involving operators, the question arises of \
whether the arguments of some of them should be parenthesized. As discussed \
in \"",
 ButtonBox["Special Ways to Input Expressions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SpecialWaysToInputExpressions"],
 ", this depends on the \[OpenCurlyDoubleQuote]precedence\
\[CloseCurlyDoubleQuote] of the operators. When you set up output forms \
involving operators, you can use ",
 Cell[BoxData[
  ButtonBox["PrecedenceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecedenceForm"]], "InlineFormula"],
 " to specify the precedence to assign to each operator. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses integers from 1 to 1000 to represent \
\[OpenCurlyDoubleQuote]precedence levels\[CloseCurlyDoubleQuote]. The higher \
the precedence level for an operator, the less it needs to be parenthesized."
}], "Text",
 CellID->30568],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  FormBox["\[Precedes]", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox["\[Succeeds]", TraditionalForm]], "InlineMath"],
 " is treated as an operator with precedence ",
 Cell[BoxData["100"], "InlineFormula"],
 ". This precedence turns out to be low enough that parentheses are \
inserted."
}], "MathCaption",
 CellID->19281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrecedenceForm", "[", 
   RowBox[{"s", ",", "100"}], "]"}], "^", "2"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->7085],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylUssOgjAQXEqr4MWjxHjADzHe9CIHPqEhJnAwGuT/sbttEJdqAJv0MbPD
7C5tppvyetNNVej0XOtHWRXP9HSvDRUGAJCbuU7AnFtzopm3rdkVriFiGnBg
OCaVZOyR4YhUIWMRKwMpKt+8ZTCyGkSQQQte19KbQeCiOmwtSCvAVi0cnqvi
nU+pQznnyO1qvKrnvRhVAWL5X++Tc/q7phfzcaexyyJ8rgPl3DtAjHDTcwUa
ifs3fh/O7hhOv+Shbga3tXW97hnPs9ivM8YGP9hLj4Uuv18LwQtaUwic\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->370914003]
}, Open  ]],

Cell[TextData[{
 "When you make an assignment for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ", you are defining the output format for ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in all standard types of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. By making definitions for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 ", you can specify formats to be used in specific output forms."
}], "Text",
 CellID->18373],

Cell[TextData[{
 "This specifies the ",
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 " for the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28652],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{"x", ",", "TeXForm"}], "]"}], ":=", 
  "\"\<{\\\\bf x}\>\""}]], "Input",
 CellLabel->"In[11]:=",
 CellID->8194],

Cell[TextData[{
 "The output format for ",
 Cell[BoxData["x"], "InlineFormula"],
 " that you specified is now used whenever the TeX form is needed. "
}], "MathCaption",
 CellID->9876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->23826],

Cell["x^2+1", "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//TeXForm=",
 CellID->56048773]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->16609787],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Defining Output Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/OperatorsWithoutBuiltInMeanings"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LowLevelInputAndOutputRules"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 53.8591200}", "context" -> "", 
    "keywords" -> {
     "binding of operators", "C output", "defining output formats", "Format", 
      "Fortran output", "functions", "infix", "output formats", 
      "output forms", "parentheses", "Postfix", "PrecedenceForm", 
      "precedence levels", "Prefix", "special output for functions", 
      "TeX output"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Just as Mathematica allows you to define how expressions should be \
evaluated, so also it allows you to define how expressions should be \
formatted for output. The basic idea is that whenever Mathematica is given an \
expression to format for output, it first calls Format[expr] to find out \
whether any special rules for formatting the expression have been defined. By \
assigning a value to Format[expr] you can therefore tell Mathematica that you \
want a particular kind of expression to be output in a special way. This \
tells Mathematica to format bin objects in a special way. Now bin objects are \
output to look like binomial coefficients. ", "synonyms" -> {"2.9.16"}, 
    "title" -> "Defining Output Formats", "type" -> "Tutorial", "uri" -> 
    "tutorial/DefiningOutputFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.16"->{
  Cell[2205, 63, 87, 2, 70, "Title",
   CellTags->{"S2.9.16", "16.1"},
   CellID->9464]},
 "16.1"->{
  Cell[2205, 63, 87, 2, 70, "Title",
   CellTags->{"S2.9.16", "16.1"},
   CellID->9464]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.16", 22214, 756},
 {"16.1", 22315, 760}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1580, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2205, 63, 87, 2, 70, "Title",
 CellTags->{"S2.9.16", "16.1"},
 CellID->9464],
Cell[2295, 67, 1019, 30, 70, "Text",
 CellID->19557],
Cell[3317, 99, 202, 8, 70, "MathCaption",
 CellID->28962],
Cell[3522, 109, 318, 11, 70, "Input",
 CellID->14161],
Cell[3843, 122, 159, 5, 70, "MathCaption",
 CellID->30524],
Cell[CellGroupData[{
Cell[4027, 131, 142, 5, 28, "Input",
 CellID->12549],
Cell[4172, 138, 503, 12, 49, "Output",
 Evaluatable->False,
 CellID->237587486]
}, Open  ]],
Cell[4690, 153, 155, 5, 70, "MathCaption",
 CellID->330],
Cell[CellGroupData[{
Cell[4870, 162, 100, 3, 28, "Input",
 CellID->31923],
Cell[4973, 167, 407, 15, 50, "Output",
 CellID->286150509]
}, Open  ]],
Cell[5395, 185, 1201, 38, 70, "DefinitionBox",
 CellID->14333],
Cell[6599, 225, 75, 1, 70, "Caption",
 CellID->22925],
Cell[6677, 228, 492, 16, 70, "Text",
 CellID->10910],
Cell[7172, 246, 249, 8, 70, "MathCaption",
 CellID->19737],
Cell[7424, 256, 284, 9, 70, "Input",
 CellID->16336],
Cell[7711, 267, 149, 5, 70, "MathCaption",
 CellID->18337],
Cell[CellGroupData[{
Cell[7885, 276, 190, 6, 70, "Input",
 CellID->1278],
Cell[8078, 284, 229, 7, 36, "Output",
 CellID->934770105]
}, Open  ]],
Cell[8322, 294, 158, 5, 70, "MathCaption",
 CellID->7636],
Cell[CellGroupData[{
Cell[8505, 303, 170, 6, 70, "Input",
 CellID->30714],
Cell[8678, 311, 238, 8, 36, "Output",
 CellID->196936549]
}, Open  ]],
Cell[8931, 322, 3415, 112, 70, "DefinitionBox",
 CellID->31591],
Cell[12349, 436, 63, 1, 70, "Caption",
 CellID->19949],
Cell[12415, 439, 245, 8, 70, "MathCaption",
 CellID->19135],
Cell[CellGroupData[{
Cell[12685, 451, 158, 5, 70, "Input",
 CellID->2505],
Cell[12846, 458, 269, 10, 36, "Output",
 CellID->511123994]
}, Open  ]],
Cell[13130, 471, 297, 9, 70, "MathCaption",
 CellID->10004],
Cell[CellGroupData[{
Cell[13452, 484, 239, 8, 70, "Input",
 CellID->16337],
Cell[13694, 494, 385, 12, 36, "Output",
 CellID->973831380]
}, Open  ]],
Cell[14094, 509, 456, 12, 70, "MathCaption",
 CellID->28664],
Cell[CellGroupData[{
Cell[14575, 525, 87, 3, 70, "Input",
 CellID->9970],
Cell[14665, 530, 446, 14, 36, "Output",
 CellID->1935725024]
}, Open  ]],
Cell[15126, 547, 954, 21, 70, "Text",
 CellID->30568],
Cell[16083, 570, 377, 11, 70, "MathCaption",
 CellID->19281],
Cell[CellGroupData[{
Cell[16485, 585, 155, 5, 28, "Input",
 CellID->7085],
Cell[16643, 592, 512, 12, 36, "Output",
 Evaluatable->False,
 CellID->370914003]
}, Open  ]],
Cell[17170, 607, 759, 25, 70, "Text",
 CellID->18373],
Cell[17932, 634, 256, 10, 70, "MathCaption",
 CellID->28652],
Cell[18191, 646, 172, 6, 70, "Input",
 CellID->8194],
Cell[18366, 654, 183, 5, 70, "MathCaption",
 CellID->9876],
Cell[CellGroupData[{
Cell[18574, 663, 147, 5, 70, "Input",
 CellID->23826],
Cell[18724, 670, 162, 5, 50, "Output",
 CellID->56048773]
}, Open  ]],
Cell[CellGroupData[{
Cell[18923, 680, 71, 1, 70, "RelatedTutorialsSection",
 CellID->16609787],
Cell[18997, 683, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[19202, 691, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

