(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    367407,       6820]
NotebookOptionsPosition[    361497,       6639]
NotebookOutlinePosition[    364251,       6711]
CellTagsIndexPosition[    364156,       6705]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot"], "DensityPlot" :> 
          Documentation`HelpLookup["paclet:ref/DensityPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ContourPlot\"\>", 
       2->"\<\"DensityPlot\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Density and Contour Plots", "Title",
 CellTags->{"S1.9.5", "5.1"},
 CellID->14270],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DensityPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DensityPlot"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]], "}", ",", "{", 
     StyleBox["y", "TI"], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["max", "TI"]], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "make a density plot of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ContourPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ContourPlot"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {" ", Cell[TextData[{
     "make a contour plot of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29170],

Cell["Density and contour plots. ", "Caption",
 CellID->235],

Cell[TextData[{
 "This gives a density plot of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sin", "(", "x", ")"}], " ", 
    RowBox[{"sin", "(", "y", ")"}]}], TraditionalForm]], "InlineMath"],
 ". Lighter regions show higher values of the function. "
}], "MathCaption",
 CellID->21624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->28019],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1l0FqFEEUQDvexDC49QhTq0Cy9AgBd8bcwaWLIINkkaVnkEkWBV14hGSh
MAFBl+5CEEJwCN01r6Re+C78vJ7uqn79q/6vvDw+ffP2xTAMr/eGYYq7f4V4
uz7ZrE8eR/hqws3fxp8Xh6vF4V3jn/P9fxqfz7//anwx83XjXcjwx/r7Ej6r
zzf+Xsdv/KnO3/hrfb/GP+r7N97FFHk64gvjC+ML4wvj23/HkmF8YXxhfGF8
YXxhfJW3FOXRno74wvjC+ML49uukZBhfGF8YXxhfGF8YX63LFK1T59GejvjC
+ML49vugZBhfGF8YXxhfGF8YX+27FO1Dr1Pn0Z6O+ML49vu8ZBhfGF8YXxhf
GF8YX9WVFNUZ70OvU+fRno749nWsZBhfGF8YXxhfGF8YX9XNFNVR1xnvQ69T
59GejvjC+ML4wvjC+ML4wviqL6SoT7iOus54H3qdOo/2dOz7Ucl9Pyq570cl
9/2o5L4fldz3o9b3kri4L7huuq5433ldOm/2gh3xhfGF8YXxhfFVX09Rn3cf
dJ9wHXWd8T70OnUe7emIL4wvjC+Mr84tKTrHuM+7D7pPuI66zngfep06j/Z0
xBfGF8ZX57IUndN8jnGfdx90n3AddZ3xPvQ6dR7t6YgvjK/OnSk6h/qc5nOM
+7z7oPuE66jrjPeh16nzaE9HfHWuTtE52+dQn9N8jnGfdx90n3AddZ3xPvQ6
dR7t6Yhv9HeEz9k+h/qc5nOM+7z7IL5B3XRd8b7zunTe7JUcf8+/b0bil3m8
b40/VF5G9zlyP3xT719G4/o5R56PxvV9ju+n/9f/RiL5hY9W0wAPo5l4UGMb
B+b3d/X6UuMnz8v9rCf41fT6q/tn83J9v8Y2H/n1/H5fnmd9OU9c5/v16/D/
dcb1ezAPkd993d8Nf79n9F09Lv4w93le5wUm/3AUnUeecx7t5XmoF86v66a/
q5+zt/uNv5/rnL8P171uiXhczuNvR2LdVtvwuiPfwff5uuf3PNzP774ezJue
AODS5DY=
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxFmHd8l9UVh98XCTFRhAQQ0EwIISRpoEWpaGtRUXAWVIpYqww3FRmVqoxC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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJzNmHdQlOcWxhEkEEGsCBYyoJGAlBhQ1Bg5CthAmgIWJAawxIIlKEERRSCK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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->17903691,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "what colors to use for shading; ",
     Cell[BoxData[
      ButtonBox["Hue",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
     " uses a sequence of hues"
    }], "TableText"]},
   {
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "whether to draw a mesh", "TableText"]},
   {
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of initial sample points in each direction", "TableText"]},
   {
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivision steps to do", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26302],

Cell[TextData[{
 "Some options for ",
 StyleBox["DensityPlot", "MR"],
 "."
}], "Caption",
 CellID->17371],

Cell["You can include a mesh like this. ", "MathCaption",
 CellID->26576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "19"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->373779795],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->213971876]
}, Open  ]],

Cell[TextData[{
 "In a density plot, the color of each point represents the value at that \
point of the function being plotted. By default, the color ranges from black \
to white through intermediate shades of blue as the value of the function \
increases. In general, however, you can specify other \
\[OpenCurlyDoubleQuote]color maps\[CloseCurlyDoubleQuote] for the relation \
between the value at a point and its color. The option ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " allows you to specify a function which is applied to the function value to \
find the color at any point. The color function may return any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " color directive, such as ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ". A common setting to use is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"], "->", 
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->8850],

Cell["This uses different hues to represent different values. ", "MathCaption",
 CellID->50967099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->408299914],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1l0FqFEEUQDvexDC49QhTq0Cy9AgBd8bcwaWLIINkkaVnkEkWBV14hGSh
MAFBl+5CEEJwCN01r6Re+C78vJ7uqn79q/6vvDw+ffP2xTAMr/eGYYq7f4V4
uz7ZrE8eR/hqws3fxp8Xh6vF4V3jn/P9fxqfz7//anwx83XjXcjwx/r7Ej6r
zzf+Xsdv/KnO3/hrfb/GP+r7N97FFHk64gvjC+ML4wvj23/HkmF8YXxhfGF8
YXxhfJW3FOXRno74wvjC+ML49uukZBhfGF8YXxhfGF8YX63LFK1T59GejvjC
+ML49vugZBhfGF8YXxhfGF8YX+27FO1Dr1Pn0Z6O+ML49vu8ZBhfGF8YXxhf
GF8YX9WVFNUZ70OvU+fRno749nWsZBhfGF8YXxhfGF8YX9XNFNVR1xnvQ69T
59GejvjC+ML4wvjC+ML4wviqL6SoT7iOus54H3qdOo/2dOz7Ucl9Pyq570cl
9/2o5L4fldz3o9b3kri4L7huuq5433ldOm/2gh3xhfGF8YXxhfFVX09Rn3cf
dJ9wHXWd8T70OnUe7emIL4wvjC+Mr84tKTrHuM+7D7pPuI66zngfep06j/Z0
xBfGF8ZX57IUndN8jnGfdx90n3AddZ3xPvQ6dR7t6YgvjK/OnSk6h/qc5nOM
+7z7oPuE66jrjPeh16nzaE9HfHWuTtE52+dQn9N8jnGfdx90n3AddZ3xPvQ6
dR7t6Yhv9HeEz9k+h/qc5nOM+7z7IL5B3XRd8b7zunTe7JUcf8+/b0bil3m8
b40/VF5G9zlyP3xT719G4/o5R56PxvV9ju+n/9f/RiL5hY9W0wAPo5l4UGMb
B+b3d/X6UuMnz8v9rCf41fT6q/tn83J9v8Y2H/n1/H5fnmd9OU9c5/v16/D/
dcb1ezAPkd993d8Nf79n9F09Lv4w93le5wUm/3AUnUeecx7t5XmoF86v66a/
q5+zt/uNv5/rnL8P171uiXhczuNvR2LdVtvwuiPfwff5uuf3PNzP774ezJue
AODS5DY=
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxFmHd8l9UVh98XCTFRhAQQ0EwIISRpoEWpaGtRUXAWVIpYqww3FRmVqoxC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        "]]]}, {}, {}, {}}, {}},
   VertexColors->{
     Hue[0.913411070470043], 
     Hue[0.9499764906697052], 
     Hue[0.9500583399792704], 
     Hue[0.913649982151846], 
     Hue[0.8437033645254185], 
     Hue[0.7458896775635122], 
     Hue[0.6281395413236004], 
     Hue[0.5000000000000002], 
     Hue[0.37186045867639994`], 
     Hue[0.2541103224364881], 
     Hue[0.15629663547458184`], 
     Hue[0.08635001784815415], 
     Hue[0.04994166002072969], 
     Hue[0.05002350933029476], 
     Hue[0.0865889295299571], 
     Hue[0.9499764906697052], 
     Hue[0.9897760525019506], 
     Hue[0.9898651412267396], 
     Hue[0.9502365336338076], 
     Hue[0.8741032711694771], 
     Hue[0.7676381502704637], 
     Hue[0.6394732392029584], 
     Hue[0.5000000000000002], 
     Hue[0.360526760797042], 
     Hue[0.2323618497295367], 
     Hue[0.12589672883052322`], 
     Hue[0.04976346636619259], 
     Hue[0.010134858773260405`], 
     Hue[0.010223947498049358`], 
     Hue[0.05002350933029481], 
     Hue[0.9500583399792704], 
     Hue[0.9898651412267396], 
     Hue[0.9899542461564876], 
     Hue[0.9503184302443707], 
     Hue[0.8741713193788528], 
     Hue[0.7676868328089234], 
     Hue[0.6394986089468634], 
     Hue[0.5000000000000002], 
     Hue[0.3605013910531369], 
     Hue[0.23231316719107714`], 
     Hue[0.12582868062114744`], 
     Hue[0.049681569755629484`], 
     Hue[0.010045753843512317`], 
     Hue[0.010134858773260294`], 
     Hue[0.04994166002072963], 
     Hue[0.913649982151846], 
     Hue[0.9502365336338076], 
     Hue[0.9503184302443707], 
     Hue[0.9138890319015331], 
     Hue[0.8439019918838169], 
     Hue[0.7460317780552526], 
     Hue[0.628213593605965], 
     Hue[0.5000000000000002], 
     Hue[0.3717864063940353], 
     Hue[0.2539682219447477], 
     Hue[0.15609800811618332`], 
     Hue[0.08611096809846712], 
     Hue[0.04968156975562937], 
     Hue[0.04976346636619237], 
     Hue[0.08635001784815403], 
     Hue[0.8437033645254185], 
     Hue[0.8741032711694771], 
     Hue[0.8741713193788528], 
     Hue[0.8439019918838169], 
     Hue[0.7857494905779329], 
     Hue[0.7044287526808587], 
     Hue[0.6065331691083894], 
     Hue[0.5000000000000002], 
     Hue[0.39346683089161094`], 
     Hue[0.2955712473191416], 
     Hue[0.21425050942206733`], 
     Hue[0.1560980081161832], 
     Hue[0.12582868062114722`], 
     Hue[0.12589672883052289`], 
     Hue[0.15629663547458156`], 
     Hue[0.7458896775635122], 
     Hue[0.7676381502704637], 
     Hue[0.7676868328089234], 
     Hue[0.7460317780552526], 
     Hue[0.7044287526808587], 
     Hue[0.6462508816310696], 
     Hue[0.5762151590748938], 
     Hue[0.5000000000000001], 
     Hue[0.4237848409251064], 
     Hue[0.3537491183689306], 
     Hue[0.2955712473191414], 
     Hue[0.25396822194474744`], 
     Hue[0.2323131671910768], 
     Hue[0.2323618497295363], 
     Hue[0.2541103224364878], 
     Hue[0.6281395413236004], 
     Hue[0.6394732392029584], 
     Hue[0.6394986089468634], 
     Hue[0.628213593605965], 
     Hue[0.6065331691083894], 
     Hue[0.5762151590748938], 
     Hue[0.5397177125226803], 
     Hue[0.5000000000000001], 
     Hue[0.4602822874773198], 
     Hue[0.42378484092510627`], 
     Hue[0.3934668308916107], 
     Hue[0.371786406394035], 
     Hue[0.36050139105313656`], 
     Hue[0.36052676079704155`], 
     Hue[0.37186045867639955`], 
     Hue[0.5000000000000002], 
     Hue[0.5000000000000002], 
     Hue[0.5000000000000002], 
     Hue[0.5000000000000002], 
     Hue[0.5000000000000002], 
     Hue[0.5000000000000001], 
     Hue[0.5000000000000001], 
     Hue[0.5], 
     Hue[0.49999999999999994`], 
     Hue[0.4999999999999999], 
     Hue[0.49999999999999983`], 
     Hue[0.4999999999999998], 
     Hue[0.4999999999999998], 
     Hue[0.4999999999999998], 
     Hue[0.4999999999999998], 
     Hue[0.37186045867639994`], 
     Hue[0.360526760797042], 
     Hue[0.3605013910531369], 
     Hue[0.3717864063940353], 
     Hue[0.39346683089161094`], 
     Hue[0.4237848409251064], 
     Hue[0.4602822874773198], 
     Hue[0.49999999999999994`], 
     Hue[0.5397177125226801], 
     Hue[0.5762151590748935], 
     Hue[0.606533169108389], 
     Hue[0.6282135936059646], 
     Hue[0.639498608946863], 
     Hue[0.6394732392029581], 
     Hue[0.6281395413236001], 
     Hue[0.2541103224364881], 
     Hue[0.2323618497295367], 
     Hue[0.23231316719107714`], 
     Hue[0.2539682219447477], 
     Hue[0.2955712473191416], 
     Hue[0.3537491183689306], 
     Hue[0.42378484092510627`], 
     Hue[0.4999999999999999], 
     Hue[0.5762151590748935], 
     Hue[0.6462508816310691], 
     Hue[0.7044287526808583], 
     Hue[0.7460317780552521], 
     Hue[0.7676868328089229], 
     Hue[0.7676381502704633], 
     Hue[0.7458896775635119], 
     Hue[0.15629663547458184`], 
     Hue[0.12589672883052322`], 
     Hue[0.12582868062114744`], 
     Hue[0.15609800811618332`], 
     Hue[0.21425050942206733`], 
     Hue[0.2955712473191414], 
     Hue[0.3934668308916107], 
     Hue[0.49999999999999983`], 
     Hue[0.606533169108389], 
     Hue[0.7044287526808583], 
     Hue[0.7857494905779324], 
     Hue[0.8439019918838164], 
     Hue[0.8741713193788524], 
     Hue[0.8741032711694768], 
     Hue[0.8437033645254182], 
     Hue[0.08635001784815415], 
     Hue[0.04976346636619259], 
     Hue[0.049681569755629484`], 
     Hue[0.08611096809846712], 
     Hue[0.1560980081161832], 
     Hue[0.25396822194474744`], 
     Hue[0.371786406394035], 
     Hue[0.4999999999999998], 
     Hue[0.6282135936059646], 
     Hue[0.7460317780552521], 
     Hue[0.8439019918838164], 
     Hue[0.9138890319015327], 
     Hue[0.9503184302443705], 
     Hue[0.9502365336338074], 
     Hue[0.9136499821518459], 
     Hue[0.04994166002072969], 
     Hue[0.010134858773260405`], 
     Hue[0.010045753843512317`], 
     Hue[0.04968156975562937], 
     Hue[0.12582868062114722`], 
     Hue[0.2323131671910768], 
     Hue[0.36050139105313656`], 
     Hue[0.4999999999999998], 
     Hue[0.639498608946863], 
     Hue[0.7676868328089229], 
     Hue[0.8741713193788524], 
     Hue[0.9503184302443705], 
     Hue[0.9899542461564876], 
     Hue[0.9898651412267396], 
     Hue[0.9500583399792704], 
     Hue[0.05002350933029476], 
     Hue[0.010223947498049358`], 
     Hue[0.010134858773260294`], 
     Hue[0.04976346636619237], 
     Hue[0.12589672883052289`], 
     Hue[0.2323618497295363], 
     Hue[0.36052676079704155`], 
     Hue[0.4999999999999998], 
     Hue[0.6394732392029581], 
     Hue[0.7676381502704633], 
     Hue[0.8741032711694768], 
     Hue[0.9502365336338074], 
     Hue[0.9898651412267396], 
     Hue[0.9897760525019507], 
     Hue[0.9499764906697052], 
     Hue[0.0865889295299571], 
     Hue[0.05002350933029481], 
     Hue[0.04994166002072963], 
     Hue[0.08635001784815403], 
     Hue[0.15629663547458156`], 
     Hue[0.2541103224364878], 
     Hue[0.37186045867639955`], 
     Hue[0.4999999999999998], 
     Hue[0.6281395413236001], 
     Hue[0.7458896775635119], 
     Hue[0.8437033645254182], 
     Hue[0.9136499821518459], 
     Hue[0.9500583399792704], 
     Hue[0.9499764906697052], 
     Hue[0.913411070470043], 
     Hue[0.5863500178481542], 
     Hue[0.5295828537494198], 
     Hue[0.4704171462505803], 
     Hue[0.5295828537494198], 
     Hue[0.5101348587732605], 
     Hue[0.4898651412267395], 
     Hue[0.4704171462505801], 
     Hue[0.4704171462505803], 
     Hue[0.4898651412267395], 
     Hue[0.5101348587732604], 
     Hue[0.5295828537494196], 
     Hue[0.4704171462505801], 
     Hue[0.5295828537494196], 
     Hue[0.5863500178481539], 
     Hue[0.9601113494429655], 
     Hue[0.9361365904262475], 
     Hue[0.97964119372869], 
     Hue[1.], 
     Hue[0.02035880627130993], 
     Hue[0.], 
     Hue[0.039888650557034354`], 
     Hue[0.06386340957375249], 
     Hue[0.97964119372869], 
     Hue[0.9948616233362366], 
     Hue[0.9798193873832274], 
     Hue[0.9798193873832274], 
     Hue[0.02018061261677283], 
     Hue[0.005048362889621508], 
     Hue[0.020358806271309874`], 
     Hue[0.020180612616772665`], 
     Hue[0.5000000000000001], 
     Hue[0.5000000000000001], 
     Hue[0.49999999999999994`], 
     Hue[0.49999999999999994`], 
     Hue[0.02018061261677283], 
     Hue[0.], 
     Hue[0.9798193873832272], 
     Hue[1.], 
     Hue[0.02035880627130993], 
     Hue[0.005138376663763426], 
     Hue[0.020180612616772665`], 
     Hue[0.020358806271309874`], 
     Hue[0.9798193873832272], 
     Hue[0.9949516371103785], 
     Hue[0.9796411937286901], 
     Hue[0.9796411937286901], 
     Hue[0.039888650557034354`], 
     Hue[0.06386340957375243], 
     Hue[0.9601113494429657], 
     Hue[0.9361365904262475], 
     Hue[0.9361365904262475], 
     Hue[0.9948616233362366], 
     Hue[0.005138376663763426], 
     Hue[0.06386340957375243], 
     Hue[0.9949516371103786], 
     Hue[0.9949516371103786], 
     Hue[0.005138376663763371], 
     Hue[0.005048362889621453], 
     Hue[0.005048362889621508], 
     Hue[0.9949516371103785], 
     Hue[0.005048362889621453], 
     Hue[0.005138376663763371], 
     Hue[0.9948616233362366], 
     Hue[0.9948616233362366], 
     Hue[0.06386340957375249], 
     Hue[0.9361365904262475], 
     Hue[0.9386832763325886], 
     Hue[0.06131672366741127], 
     Hue[0.06131672366741127], 
     Hue[0.9386832763325886], 
     Hue[0.9258597455336218], 
     Hue[0.07414025446637815], 
     Hue[0.07414025446637815], 
     Hue[0.9258597455336218], 
     Hue[0.9258597455336218], 
     Hue[0.07414025446637815], 
     Hue[0.07414025446637815], 
     Hue[0.9258597455336218]}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->99961535,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 "A significant resource for customized color functions is the ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " function. ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 " provides many customized sets of colors which can be used directly by ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 "."
}], "Text",
 CellID->14636363],

Cell[TextData[{
 "This shows a list of the gradients which can be accessed using ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->77155740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ColorData", "[", "\"\<Gradients\>\"", "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->268503839],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"DarkRainbow\"\>", ",", "\<\"Rainbow\"\>", 
   ",", "\<\"Pastel\"\>", ",", "\<\"Aquamarine\"\>", 
   ",", "\<\"BrassTones\"\>", ",", "\<\"BrownCyanTones\"\>", 
   ",", "\<\"CherryTones\"\>", ",", "\<\"CoffeeTones\"\>", 
   ",", "\<\"FuchsiaTones\"\>", ",", "\<\"GrayTones\"\>", 
   ",", "\<\"GrayYellowTones\"\>", ",", "\<\"GreenPinkTones\"\>", 
   ",", "\<\"PigeonTones\"\>", ",", "\<\"RedBlueTones\"\>", 
   ",", "\<\"RustTones\"\>", ",", "\<\"SiennaTones\"\>", 
   ",", "\<\"ValentineTones\"\>", ",", "\<\"AlpineColors\"\>", 
   ",", "\<\"ArmyColors\"\>", ",", "\<\"AtlanticColors\"\>", 
   ",", "\<\"AuroraColors\"\>", ",", "\<\"AvocadoColors\"\>", 
   ",", "\<\"BeachColors\"\>", ",", "\<\"CandyColors\"\>", 
   ",", "\<\"CMYKColors\"\>", ",", "\<\"DeepSeaColors\"\>", 
   ",", "\<\"FallColors\"\>", ",", "\<\"FruitPunchColors\"\>", 
   ",", "\<\"IslandColors\"\>", ",", "\<\"LakeColors\"\>", 
   ",", "\<\"MintColors\"\>", ",", "\<\"NeonColors\"\>", 
   ",", "\<\"PearlColors\"\>", ",", "\<\"PlumColors\"\>", 
   ",", "\<\"RoseColors\"\>", ",", "\<\"SolarColors\"\>", 
   ",", "\<\"SouthwestColors\"\>", ",", "\<\"StarryNightColors\"\>", 
   ",", "\<\"SunsetColors\"\>", ",", "\<\"ThermometerColors\"\>", 
   ",", "\<\"WatermelonColors\"\>", ",", "\<\"RedGreenSplit\"\>", 
   ",", "\<\"DarkTerrain\"\>", ",", "\<\"GreenBrownTerrain\"\>", 
   ",", "\<\"LightTerrain\"\>", ",", "\<\"SandyTerrain\"\>", 
   ",", "\<\"BlueGreenYellow\"\>", ",", "\<\"LightTemperatureMap\"\>", 
   ",", "\<\"TemperatureMap\"\>", ",", "\<\"BrightBands\"\>", 
   ",", "\<\"DarkBands\"\>"}], "}"}]], "Output",
 ImageSize->{578, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->4038161]
}, Open  ]],

Cell[TextData[{
 "This ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 " is identical to the one above, but uses the ",
 Cell[BoxData["\"\<SolarColors\>\""], "InlineFormula"],
 " gradient."
}], "MathCaption",
 CellID->30833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"ColorData", "[", "\"\<SolarColors\>\"", "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->19711],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1l0FqFEEUQDvexDC49QhTq0Cy9AgBd8bcwaWLIINkkaVnkEkWBV14hGSh
MAFBl+5CEEJwCN01r6Re+C78vJ7uqn79q/6vvDw+ffP2xTAMr/eGYYq7f4V4
uz7ZrE8eR/hqws3fxp8Xh6vF4V3jn/P9fxqfz7//anwx83XjXcjwx/r7Ej6r
zzf+Xsdv/KnO3/hrfb/GP+r7N97FFHk64gvjC+ML4wvj23/HkmF8YXxhfGF8
YXxhfJW3FOXRno74wvjC+ML49uukZBhfGF8YXxhfGF8YX63LFK1T59GejvjC
+ML49vugZBhfGF8YXxhfGF8YX+27FO1Dr1Pn0Z6O+ML49vu8ZBhfGF8YXxhf
GF8YX9WVFNUZ70OvU+fRno749nWsZBhfGF8YXxhfGF8YX9XNFNVR1xnvQ69T
59GejvjC+ML4wvjC+ML4wviqL6SoT7iOus54H3qdOo/2dOz7Ucl9Pyq570cl
9/2o5L4fldz3o9b3kri4L7huuq5433ldOm/2gh3xhfGF8YXxhfFVX09Rn3cf
dJ9wHXWd8T70OnUe7emIL4wvjC+Mr84tKTrHuM+7D7pPuI66zngfep06j/Z0
xBfGF8ZX57IUndN8jnGfdx90n3AddZ3xPvQ6dR7t6YgvjK/OnSk6h/qc5nOM
+7z7oPuE66jrjPeh16nzaE9HfHWuTtE52+dQn9N8jnGfdx90n3AddZ3xPvQ6
dR7t6Yhv9HeEz9k+h/qc5nOM+7z7IL5B3XRd8b7zunTe7JUcf8+/b0bil3m8
b40/VF5G9zlyP3xT719G4/o5R56PxvV9ju+n/9f/RiL5hY9W0wAPo5l4UGMb
B+b3d/X6UuMnz8v9rCf41fT6q/tn83J9v8Y2H/n1/H5fnmd9OU9c5/v16/D/
dcb1ezAPkd993d8Nf79n9F09Lv4w93le5wUm/3AUnUeecx7t5XmoF86v66a/
q5+zt/uNv5/rnL8P171uiXhczuNvR2LdVtvwuiPfwff5uuf3PNzP774ezJue
AODS5DY=
   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxFmHd8l9UVh98XCTFRhAQQ0EwIISRpoEWpaGtRUXAWVIpYqww3FRmVqoxC
RGqd4N5CXTjraqkoiAOVigW3pRSpMioIWkGtWsHzfN7n/eSPk7vO+J5773vu
95fq0ecfP65VkiQd489u0X4WwrgkpEvI7iFFIV1ti0M6hxS69nmS2ZWGdLDf
Gn+2BSE90iT5KtovQ8pC9gxpG/KjkG4h3UN2hOwVUh7yw5Bq1/YN2UObfYzP
eO+QNuLoZBzGX4f8T/zdxQSWXuaAjx7a4KPWlpxq1GXtu5D/i/db8fQJqdcH
uLpEXtvN/RtjgXlnSEXID9ANnS/Mq3dIZUhVSF/xEbPOvQbffs6B8eiQg0J+
EnKgsRtCdoU0utbPHHqG/NgWf/vrg7X+5l+vr0axHeJecw4DjY3doc6B8eCQ
JrEPcA+w+ZlzjA8wJjEO0w5fh+sPjMeG/FR/x9niY7D2YDzSllwHmQ9rP1eX
+CeKFd8nGI/x7SFXhlwVcoQxsR+iHbkOtSW/422xP8qYB7l/nT2PYcbB3y9s
wXWamPA90hbfJ+uLczsl5BjzHmFurJ1q/th/KI5RIWcYjzgXhpwdck7Imc4N
D/nInEeHnO5eYLPe/piQXxmTGGdpd5L+ThLLeeqBZWzIL8X7a1vWNohrfMg4
dck7ifu8UQz/EcekkN8aL8c9wv24wNzI4zfqM57sHDabxD5RjIPdr4tDzhXj
VPGB/dqQ5pBLQj4xfj6eZJzp4j4/5GPz+F3INH2wNktdMF5uvCkhfwi5yPFw
z3ywa2PFcal25DHblj34vS1nuMWcZobckWR38+qQ3WIPN0c7Icnu7FRxbVN3
jnrTxbw1ZEbINSHXmSfYPzXvuSHXOweuG8UElttCrkhavo1p+r3FPMn75pDL
HN/qHDY36G+24yliZU+5CyND7hQr2KiX1Bhq473ag+X+kJuMM1+8nOEfbclp
nnmzdo/5YL9AO/A+nGTfOXv5XMifQh4LecQ5sDygLnk8ZP7YPOgc47uNSYxH
tbtLf3eJ5Un1wPK4uMH7hC1rrdMM38KQp9Ql77+KGyyLjA2WJcbLcc/T77Pm
Rh7PqMt4sXPYPK0/fC3VHlx/CbnPPX7eOTD+I2R5yN9CigLn7mmmu1xf4HrR
PMH+qrhZqwjdgjTLqzjN5l/R1yIxto35PdMs5gpzAO9rrjN+3TnyXumZgf3v
zjGuCh+FIS9Ev320y6J9O8l4BO8pb+t7xgfjP41BzHdDXnZttfhYe19dcl2j
Llj+ZUv8/yYZ12kfskea+XknZK3r4P3AdlVIu9B5I9p1Id2jXxryZvTbpNke
gh8uBO+AP+UciBxqQ6cppCTNuAvfBxwCTlPmGB7DuwMXgVd1cdzGOThJsXbw
hB3awqPgIfAPOApvPm/ufsaGY8BJ4F5wEDgWHAneUpVkXKnSfch5Xhex12jf
Sb81rvPO14mP97JWmzrHcCc4T4N467WBC8GN4B9wqt5iqBFv36SFk/UQNzwk
54O0fcTU17VK/TRp18/8cz7UT1wHOIZH8PYeJy7e/f76YO1gsfbXpsk5uMsu
9RvEMUAbcB3imHjwhMO1590YJNZD1QP7YY7Je6Dj/bUb6B7B1eAk1CTq6xxz
GGSMAs+mo/h4949JWrjOEO3hI0eJb4j55zzs2KSFDw0VxwmOwc57PNy88XGk
+E5UD7zDHOc8aZgYhzvOuV3+ro/QL/5OdgxuuAdcBD4zWv/4hTOMETfvzqlJ
C/c6zTyYg7fAkUaJHxxnaE8MeAn8hPefd3Cq8XjTzxXrmdrknCnnUGe59qFx
hyYtnGmssc9zDD8aLw7w8V7CNzbYHykmuAd8BU4FB5pg7AtcIyZcYrJ+wTvF
XMcZD9zwlIvEe6E2Y9W9WNyT9YvddPOHv010bz92Hny897zbvL/wq5nq5VwH
TgCHgd/M0C9zs8wHftJsDrMc59xotnHgDFeJD76Rcy7ay8R+hWvT1M250pWu
bdUPHAkuNEes3J315kV83vnr9A03uFlMzF1rPOZuMo8btCH2rdoQ7zbHxJmX
ZN9lsz7miut29cB7h2Mw3un4Gu0Ybxb7eO3n6zfnRvPFeLdj8PHO32cMeMKD
4oV33CM+5h4wpwXa3OLcAjE9rH3OaR4XE1wj51OPqJdzo0fFhG7OXx5zDYxP
6gscTzkGK7zjz8aGSywUy9OOwbvIMZiecUzsZx23lr/cL67FrhEbHrFEXPCR
peJa6lobecoT5rBEe/DBgXi74UcvifN6cyCnIrnQMrHCK14RH3xjuf7gDK+b
w3L1Fju3whxe0wZMK7WBQ60UKxwETgMPgYMVy0vaypHgIfClveQitXIKeBMc
Bt60zH1ZYTx+U3DnZoj7PWOAEY74vnrwqtXarXGcc6Y1Yl3rOOdGa81ntb7g
SMyDk/pLraROUsc/cm6k86MU5vle4VPrkiwvav567V4VI7h5q6izp2i7QX/Y
b0xafq9Sy6hj0+3zjVELNqnbynpLTUv9PTvBMTVxkvOb9cf4E9f39f85vM8z
nW82xmb3GdnieivrJP5P1/8YdbZqd7X9/I2nls11vM25ZufxWRc+a9KMw9J2
TDMuC2eGg8I/O/m/Kfjo3mIu036b8eGC8Eg4ZFf1q9Vnvlw/+ISHd04zHpn/
n45+he1X9jeZM/nCzeCXVfqFo3YTE/Nwzg7Olzr3tfrg+dY+3Ix+H2PsND5n
ASdrMDd+f8Kl6+032H5n/wv76G43Vok4PrPfqH/+P8Yd2uAd2OidGO858/7N
MF/e79GeOblPVCd1H7aoT58aSC2jjpWnWW16Qf+JOmVpprPQfoG1r9I+NYHa
hS01DW7GPsD1qA3UtDf1X2jtw54aR33DR5E+qRnUjndcL7LWVVpT8rpXLJ6X
7VNL8Ev9Wsr5ptn3v8q5tvZXOqZf6Dx2b4gVnC/aZx+oH+2sBcRub13uZp17
29xKrYE9o+3g77FS++s8T74LvgXuL/e4RH8l+tzufKl3g3tf7jy/qbizvdLs
/9fc/W+cR3+H+vld4r5WeU+7avuSe7pM//z+abTP3W3wLpR5FpxLhee7S51G
963c/SlQP/9tXmGf+UpjsX/V7s9O45Z7zpX6x2dV2nIOVfov1HaV96vc86r2
LqFfn2ZvD2fSaC1K+Wbcq3ZJtl89rBdN6r/lOdZ6lvyO7um55bWMc+vt/L+T
zEcvfTLX4Dw+6vVZI46OYqkTD7ZgojY16DOP2du78j29hcTq
        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJy9WHk01YsaPaabqENU4kkJKZE00OD2RcMlDdJwyy1J3cqQwqHIlfCkJIpM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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->71436831,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["This gives a contour plot of the function.", "MathCaption",
 CellID->168591347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->298956532],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyVnXm819P2/4+4hnANkUsh5F7iGuJKHPZBpVGEdCtEchVxVJKEQipDkSEy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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlk1sVGUUhu+tzMydO9CfaGi07RAx1tChXbmREjSWkpjiT0xoKd3Uoltd
607dsIYmphBYFlmIK6n/q067MjGBCot2ZbQQoJV0BjQZW98352ni4uSe+93z
ne+c97znfPf5mY/e/bAtSZLfJU9JHpaT5MdSklxIk6Sl938lNcmw3keLSdIj
/bBkWzIoaWLTK6my3ud32RckN6QfQF+SvijJpNf1PCLZsW9JRb5zyXwSe2zz
jZ63/E36Cn4q7O1JY69j+1KyR+9X9dySj4ZkL2urxVj3cw3dcW8WIo8x5ftS
JUkm9X5K9g8LEdcofo5LvsqS5HXJNfKy3wXpE3o+SCN+79uQvJIERt5nTJxz
LptlPb9F917jUQafF3T+TCkwbtd7Q7JPsj8N3XgaC+NzAx/2ZZ+D0l+UdEgf
0rNfclP6H4r301LkZD9NavSn1j/T+rjW1qV/Xoo8Bth7MA1sm9R5OFd9ZbOS
RhyPqfO0YnlP8pv062noy5zRAoOMHF2v28VYr1HrNeq9gi/7OaPnlOSK9nSn
cVY7edpmifOfEINtvcd18fkz+DFHDsC3vwpR66PS1wtRJ9foWeX0RRb6kPbd
1fpYGjY1uOl95sruXudQI5c7koEk6j8OB+zD67bd2cXPMYhjP+u8WdndT6Mm
9j8p27rkdDH6pgo3W5xh/+bgFjw0LlNtUfsqPWUu1cHBfn7VOb06bx6eujds
4zpk8M3Yr4L/kuw7yuHbeDxTCkwa4uQnpcCkS9+frsTZl4uBl9efgyd9zIAW
9b+o73OSEX3vlM938uCY/dUqsfcD+ezIAj9jdhvc3td6exY4+cz2PM6tar1b
72fbIu5VeuFeIXB3zHeoo3GzbW8e9sbCz2X6dJ0et+096u5aLMKlV7Po+Wv0
8T7yOluKXnWfnijGjLB+X7F9r2/n07DfYk8D/hqfR4Xg4lF4Xucs9+4TeO3v
tjNWm9ibP8cUy3f476bfbe++6kxjpnomVOHDSBZ1vcLMPs7cbpCHYzP2b+eB
v3EYgm/T9KR756dScNe8PQP/zL1z0t9oi1lqzIzdLPxaZFY5lpweNC8XmNNz
zIEBONNkJqzqrIFyzJJx+sQ1Mse26SXfSWNt4SdTHTbKEYd7f5r5U+HMFWb4
Ce6Cx9ShnZ4aZf0gc884luXzUTnO2CzHu3VzbQ+9M/+/WT5Jzzkec30ODJ1H
jVxm4ZZt7GuWnnTcF7izzM3r+HV/fEzfuSaeuwPMzHPcX/Y9kcUe+/H6eWZt
gXnrmX2yHPv/kX5M+i/cn7fgjvPuIvcp+sR5XQVrx2nemd/2/3IevuzHZ1Y4
1/3utR5mjTGxH/fxm3nU8odS/FvYr/vXHJmHDxfhZyexOz7fXXuzmJWeH76r
Joi1C5757Ar/DG/lcbeZO2vE5jw2mPmnmNHj8Mq88z1n7u2gm2Oucy+1LqAv
0Du+R3vp0wn8HaIfd/vyEHex8RgGE9dghDoa8yFysP0g/f+16t6sxDzq5z6+
SZz7uXu36Yc+eNtJLQvcd3X0Kj3QxN55nczjn8A4+C56LQsu+r/jb/49fA90
che4Jpeo6yVq5Bx8t/Rxv/RX4v/J/04PytGT5qN5exnunuZuMh82mWeHmb3r
zO0WPOihFkeYCTP8Y5jndeaMZ+Z/1GpKIA==
         "],
         VertexColors->None], 
        PolygonBox[{{1902, 3036, 1691, 323}, {2060, 2993, 1518, 341}, {2545, 
         1981, 404, 587}, {1922, 2404, 491, 342}, {1980, 2543, 587, 403}, {
         2993, 1817, 57, 1518}, {1923, 2405, 492, 343}, {3052, 2111, 169, 
         1732}, {1913, 3038, 1693, 331}, {1852, 2110, 402, 166}, {2639, 2638, 
         342, 492}, {2542, 1979, 403, 585}, {3038, 2619, 469, 1693}, {3036, 
         2612, 461, 1691}, {2040, 3008, 1606, 315}, {2588, 2012, 430, 611}, {
         3061, 3060, 331, 1513}, {3008, 2039, 12, 1606}, {1903, 2854, 1369, 
         323}, {2320, 2321, 603, 414}, {1818, 2994, 1521, 60}, {2855, 1902, 
         323, 1369}, {2994, 2064, 343, 1521}, {2135, 3017, 1634, 430}, {2380, 
         1903, 323, 469}, {2114, 3015, 1627, 169}, {2574, 2000, 422, 603}, {
         1978, 2540, 585, 402}, {2333, 2334, 611, 422}, {3017, 2134, 214, 
         1634}, {2637, 2636, 341, 491}, {1812, 2991, 1513, 57}, {3015, 2115, 
         414, 1627}, {2366, 1891, 315, 461}, {2112, 3052, 1732, 404}},
         VertexColors->None]}]}, 
     {RGBColor[0.3835508829694212, 0.21412461920646422`, 0.6561074819015902], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1V11oVnUcPnvPed9zzntcaSyY5uZ20YckQWVNnbOaRGstUyvDcqVmV35d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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtsVVUQhtfZ+2z3PnsTWkKJEGjTxkSJTUhQLhZCIYAvtaLWC6KUS4En
oL4JNDGCSMItxvAgRU1M9MEHWioXa1qQJwUMcldfFOQiilFEYms0gYTvz8/D
5Mysf2bW2jP/zGnoeK2tMwohdCJlZHwWwpIihN1JCFc42J6GsKYSwt1SCB1I
GSxBxoK/S+Bc/HuRY+gLkD1g3dgH0U8lxmYjrZF9Gsn1KFIfh9CAbCP/auw7
5F6O7MZ3HGe/ox+InKuNnO8kznkpD+FDzvrRr/K+v4jNwGvBz5NvAviD2JOx
y+DD5JrMWS16HfIBWCfxWyLnqCV+AjKW2HFINXoVUo0+CrlM7FJ9E/l+Ib6L
2B7sE8TuQgrsF7D3o9/gzbeJrWDX4f898X3g85EjiWNmgS/nTTPwPYl0oQ+p
pvyOQPq472X8v8H/Y+7rQZ/FeQP215Fz3yLHhdh3DOD/Oj6H8D2IPA/+XOG3
qGbPgFeBzwBrQh4CW0G+qcS/CP40+EjwJ8CmIwNgzdgt3HUGn3XYL3Hfd+Rr
QQax/8A+DXYWeZb4avxvgs0k/hHyPwU+V/3FXpf5jXrb58iizN+ob/sEqUW/
qO8mfmXk3tVV3Av1cA3Yj6r/A+QsuVdnOfs3ds9eIX4RsqxkDulbV+GzNPY3
i2s/peaCOPcfegdSj/1tybXbi3wVuYZnyNWP9KKfROaAHcX/h9gcbkrdE/VC
M9Cq2eDsbfR5+FzF/gx7O7mbInPzz4prJY42o/8P/mbiHoibQ9hvJObowswz
otlYHZmLx8BvxObkMvTHcnNZHBI364i5VjZHNbuaEc2GZli9XUmOJbF7XAV2
jhyfEruY/PvRB3P3Rm9ejP5q7lnUzOvueZlnW2/YA3acs4/AdhLzBfb61NzY
V3avHs/NbfWsG/v9wrtAM/cWvr+Sbyjym7ZiX8y9a9TDzdi/gQ9H7uEm7OvY
/2C3Y9erNhVzRd8wSfXOzSVxaC93rc+8m9TTPuKvVNyLbeC92Jewp2NvLZmr
DxfunTi7AbwRu533TiRngZ4XnnXNYAv+a1NzUTOh2e7m/h1lz7i4pRnTbIlj
NfiPqbjWqllN6h2n3bYZeS8z58Q17RBxb23mWoqD4t7fmr/YHFTtFuSeZdXw
CPhN8HOxd4Jq1Zp7llUzzapmWrOsmd0BNg2fTeAbkRGZa6zaaufuBO9JXRv5
qBZd93eTaqK7DqfetbpTb/sy9a7TGzULM3PXTjMxmvhRFe/SxsTcn5J7N2gG
hsH7CtdCO1C1fDIzt1TTqPCb9daaxNzQztGuEUcuk3tf6t6qpz+Dtef+r9JM
jMz9Bt2tnXEPO3jkBg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4736858560137007, 0.370844995028781, 0.7828030904142904], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1eMVVUUhs/ce889957zoBFRAaWqwwNBwUSFaALGBjoio9EBuwbLMKhB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW9oV2UUx5/t3p/3d+8liqaUqZtWWi/WrA1KJV/4oqXGlCwkS8mKpW7T
wuY2V9TyVYnLzJSWq4xMDbWMAqMXWVbUIoSKVObmSgvclpWD/hrS58t3Lw73
fJ9znvOc59xzvs+UBx9ZtKY0hLARiZE9Cd80hGIUwgfIZ8UQjiC9OJ1Efs5D
6M9CqMf23pgQRsC72NNREsIweHrmPfKdSMCxxLpcgn8Z0outBf869CF8zoO3
gVvAF0p91v3gmyKf+SL6evZn6A2c0c15ryB9xP4bfAr7Ddivxn8Ma++AB8Af
g48gb4ADeAz6+8hZ9g4iC8k1J2YX+svI14UQbsd1Kvpq9szB9x7WDnGf1eS0
Ad+FrD0FHkQuctZa5By2JeC56P+oRuC2xL663y3gfchm9FnIDuJfAh4i96PE
7yu6JvIdRqqwH2b/CfbXY59QdM1V6wvsKeMuPdiHI9dUdx8AJ7Fr0JT4Dsq9
grVe9AWsbeJu24hRRbwTqf/tOtULPAep0/2QWvSY+wxh78S+L/cdlHtvwf/y
C+INjp7/G7b78J+P77/4/Ap+AftjkevRi60cXBv8zzZkzkm5qMd09n7wyYJz
OAPuwH8ptvOqB+dVjv7fa5AD2EpG/+dhZBbxZiDfUZtpxP+d/cvAdbH7aTf+
pfgn+B5CdnPWHuRYwTUpx/de9uyKXcPXse3M3VsDsXuzEZ9lsXt0J/qrwsTe
ylon+nPIcWzdxNuauAa6e3PkXnybtU8i92QLeB2yGN9HwdsTz4BybQVH2A6y
9mnknCdia2TtYfR5nPc4uT2BHCD/Svacy3xH3a2EtV/A36fu9QC+Fn0qUo/v
Xu7UmrhH1W8LItdyP2sfRa7pFvTm1LmtRTYmrqnyWwGehN6UWr+DfKo478bM
s95D/CXYD2b+V03s+ZxcGzLPrmauSfOVO9frsb9J/OOpdXFILfinov+9euY0
e1tT53KWM86A21PXajB27afnnhX9g7Ho41JzTSVry1XLUf6qZm059nLwRc7q
wv48eAtSU3CN5rG3UfNf4p66EtsU1iawt7pg7pqZudfEYf+BF6eu5XWsrcC2
Sj0Vm7NWZu4J9YLWIuL9mJqbxhFvJrYCa1eg7+C+reT2oTg0MmeUYDuVutfL
8Bmfm/PEdcr5JfCaorlEHPZMYk5S/4mjxTXdRXOHOOfpzByg2W9GGvV/kGml
5rRV6Ctzc6N6XrV7gJg1o3z8B3p15lp+RbwG8NzU/141O536jrqbejhGbyua
O3THCvz7Ms+WZmB+6hqqduLch8BHsffE5oBJmf+Bal9gLSfWneBO8GYkAt+d
W+/j/B9S10y10szdhb4oN7drz7uJZ0yzpRpfRvxvE8+GZvpWbCPg8bHfoNng
P8FPFlyD7UWfqbP0JnSx/7aiuVOcKK7qT5yrOOvZxBwpbtQMH0v9ZuqtVM3b
sWXgyQVzoN4qvTF6WzSPb2Hbm3vWxVnKpSYztysncVtH5n+pO+X4zk7cS4qp
t+K1zFylN+PLxG+IuFscP5Ka88X1enPa2b8+N5eJYy7NPFOapb/Uw5k5SVyk
N28g80xplsS5m8A3Y59Rak5pSz3Dml29CUszc4i4Q29GBfZvEse+KvK/7y/6
LVQPTE7tI5tm8H/mqBrz
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5638208290579803, 0.5275653708510978, 0.9094986989269906], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG1sltUZx+8+vZ/nuV/2YbOiG7OaTSrRpcUty4YLYR+Wos5kIZtL3EuC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllsVVUUhndPb3vuOdcHNdEwCAhaER8KJkapIfpgakQTY9AHjSYQiNAy
WqBAESLQBFFbZlBooWWSQSMFClaEMCiBmBgGB1qBSKgRHBCsrYIG8fv9H1ay
/r2mvddee63dd+SkYROjEMIqKAPdk4TwdRzC3/kh3AV1z4XQAt1ZGEJTXgh9
kVWiU4HsIga/pCGMRb6hIISb4Ivg5cjfRv47eBr8VKgszzaD0b0bnSyyCmx2
gX8Cv4H8BngveCgxZmkvxCwGD4Tmob8CnXfx9R70Dr7K0SnDthx6EXk58i/h
T2VDaOdQR1kbDx4nQvaKdHJeE7+eeI/Cl0BDkRexVodtN6gUfjc++rCXNeBP
4M+zNhl+PbQPvAO8Cfk18E3wHvbUia8u6DB4YeSzXiVme6HPvBpcB/2K7ofs
vxPbseCXkd1A/wHwB5xvFfJRrPUHV4ErwS+BuxFvFWvN6J4EH8X2ELgNfBjc
Bl5DvOOcbT5rrfBPYzObWMsKvZc+6LQF7+lH+KX4X4D/qxmffSd0PHIOLiNv
xiagO5cc9YBfAn2O/zrk/fDdjP4J9F9F7efUd6q7rED+B/Kn8P8Y/nuCByH7
grXLuj90/sK2ApuRGeewFb4X8tLgPWxCfzN0Gt1a8C7pQ9szjnkf/BjVKHwh
tIRYi6HR2M8nxhJ8TQcnkWuwRrWTeK/VyFcmrlnVag14PL6ugCPibYRKkA+W
Pfqt+KhH3p2YH0fO8ST41VnXypvQEBSHE7OEWMeglfAzWbslcg3WgRcl3pty
Pib1HetuVcMzkC2NXcva82jiFWV9tr3Q1pxzoly0Er8hdg6VuxX4WwPuyrqW
9AbPwp+DzuS5xicRbwB4BLGGQ+vwdYa1Beh/hb9L4PtV//At3PmyxDWi2ngL
fzORz4CGoP8ROstj17DiqUZH6PzQw+TrCmvfpa5J1eI5fJQmrlnV6hD058Fn
WJvH3qax9nziN6y3+wzy4tQ1pNrpkfFb2wjene8z/wM/OPXbrS5wr1KNqjbV
s84jfyTnXlPP2p/YT0x99n+xP4Y8A34OvjHPZ5sFbS/wGUexnznovJDnHP6G
7oSca2OKeoh6H9SU8Rt7HX4QMQ5F9rEY3BN6qMBvZhiyLan3ckT3h+y1rGtH
NTw08Zl0lsc542zk25B/hqyJtQJsnwUvz/gN6e7Opu5NusPbU8eQb/Vw6d7G
2vV829wKfwc+i5Ffy3et1Me+W91hbeqYiqWe+23iHq/erpxPSd2j1ZsDeAXy
tbHfjnrycfyVx77bC5FrqSznXquaWoT9YtWEahUXA+EHpb5bvRnlqgifvfKd
s0ZkDanvZik6HcgOxJ4FurMucGfiXiqf7cT7AeqIfGfqXboz3ZV6mGp/U+K3
ojewA34nlJfvmTMu5x6m3qWZtlX9F2rJuKfXorswce9Qj+lQ74BqIs8E5XZt
6r0qx0+w1zbsL0V+E/2wPRU795qvrcgqY9e6dNYib0hcm1XoH9F8zPktakac
QH9c7NpQfkvhL2T91tQztddPib8n4z2rdqpyfquqocmpZ4xmi3quemlD1r1F
PbURf9ezvlvNoM3gVvYzIPIbrUw9UzRLlLMNyL9B3j/yDJ+q94n8YOScqFc2
5txb1DNbUs9QzU69Gc2y3rF7g2aaZq3+GPpbaOb2Rv/72H+PCepRsf8oyp1q
+n29P2z2R54RJ7OuQeVGf4C52M9JPbt0hoPIDmTdyzUzNYsfzHkWaSbfm/iO
5F81WK33Frs3TYf2g/elrl3leBu2lVnPep1Zs+N04r+AZoj2Jh//2yJ/MvYM
1+xWjapXbMm5l6tnjI19x9q/ZuZ/2vNjeA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6300908986968594, 0.6340429368813063, 0.9110094939193798], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mGuUl1UVxt+Z/+193/+nNJVuq0xrra5CENAFhkuaWau1FLKSEhhwiPtl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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsllUQhr+2f/m/8/1XooiaGKMCLqzeAIoou4heGEAwgkBZypawF8oq
QZDIvoMU6EKBFgHZF2lFooCCKC2giDdKNIoLIpsBb3xeXy4mmTnvzJw558xy
Hh04uvuo7CiK9kApaGOIoqfTUXQTYUVOFPWC/xXanxVFVVAP4Zko6pMbRbXI
Y5IoWsvaYnTzsPkB3UvgW+pE0S7wW3EUFYMvBS9A/gz+U6iAvSpYq4RvjM0t
bNcgH8H2T+SZ4B3x0R/7QdBkgjwJNQHbi00xuv9g0xH5Xuhz+MvgneHrQ2eQ
ryJPx7YGnxPr2GdvsI7IU4m/mni6Ef9ryAuQW2LzGHgJNoexrYHeZ6/10JK7
8a+EXwMtRJ6AXAJfHnxXE5Hb468b/ubirxn+ngU7gr/WYM3RmYe8CJoDP5a1
kWBfoz+W+Kaz3y6wCfgYgu16dG4iX4fy8XcR+Q78bWg7Z/keeQ/2e2PH+h7U
Gl+tMr77gI9SsDJoHtgMbBbje4Zw/L0Dvgx5eWJfG8Abcf4l+J+L/Bd4K/jj
4Efhe2IzELkflAffJ8exLUnsSzF2wnc76FCW7/hj+D/wmY3cjjO2CfYpXy2w
fwm+E9Qbua1iUL7EPstg4hkBNgwaBD4Y/Pe0fcrXOPCmyAPQL0S/khh+Rven
4LMcQ38csY1N/DYPotMA2+HYtEPuhc/OwWviT7CWoBugKuyvYF+O703Q29k+
wwD0f0TuAf8meEN8zWdtNvwV9s/F9iRrpeD9sGmJ3BX/s/DfAHw28pzEsS1m
j2/BvoHGw8/iTGczPpPOMrOOc+Fl5MEp58Qu5EcSv+2mlO/mlcS5qzt6Hbk7
1Bf+VeWk8hH7fPChUD9i7wt9QWwTod/SrgnVwkHoDfSHB991l5TfukPiXNab
58WuSdWi7lx7tUp8Nu2pWuwffDeqyWNgdVk7nuUcqgarUo5z3nJ08jN+c711
CfbFyA8h30a/FrkU+zLo3xy/iWpTd667Vo0WIa+FeoLdwqYa3cPQUrAD6CwE
exj9i/CVrC1Vr4LGZTnHFwTXpGpRb/hCxj1Pva6Q/Suxr4AWRfapXG2K/wdS
zlnFOhSb0lzHvB7bFejUQ3c88mh0RyXuHfVZWwe/PnFuqYYr0N0MTQJfzdqS
2G+mt9qG/h6w/VAJ2GR0yoJ7jvJ5OWs70K9KfNYT6O8A2wYVgheBNwB7HLrI
Xgk64+Fvx95POXUtcY9Qb8hVPXCW54Jrcxry1Ng5oVxYnu1eOiN2r1JPrUH3
jOLHfic2+4JjVqzq0afgType8G057o09g3NTPVK9b0TsWlAPPI08JHZtj0T+
CnkY8hT2G4X8YfAMUO9fh4/54DeCe2M1/lYhPw9Ngj8FFaG7DPy+bL/5BHxd
5TwpsPPqZ8jN0FmZ7RmzBXkzlIPufOSyjN9Eb3EO/QJs78S+X9XUVvDmyI3B
vwN/F/6t2LVVlm3fl9OuLe2hXtAluNepJxSDbQrODb1pCfIHwb1Kb6RZWsGe
+dmeqYr978RvpTMMjX1Huhv1EMW2O3h2KMZKdLcmfvtT4KPBN6Bfk+uaWYfu
k+x5PeUZJ740OLe0dl25G/tsac18bM9l3JuUk5q1qjHVlmbuamyfYO1ayjNy
CLoN47u1rXmgeRhc+/oDNEmcc8o11dQn6B6N3Ys1MxvF9iFb1VgNcm3sv4d6
eH7snFGuKEca46918Kytj79f0n4TvYX+MHqr8ozfXm+2SrMi7Vmumj2I/caM
3/r/mZlxjam2NDP1V9keXFv6s+ivtCW4dvVnWps4J5WLi1LutdNi14567jHN
0+C/j2pCf4+84FmqP0hd7M+p/2f5ze9Hrpf47dQDN6D7FPiNlP9Uh5A/gkpz
3FPb4O/FjHvXAXy0zXhNvGpCf7cC7Ltm+Q93ENvzGc8e+TgLdk/i2aUYioL/
QOpf+uPt4yyrM64tzUT1mp3Btah8a696SLt2pqDzJdjp4NpXj7iS9h9PfzvV
mGbppdh/Nc3U5fKVdu9UzV4glt2xe7t6+MLgP4r+JvpD6a/RIeO99OdQL90a
/JdU/ah338RHnOsefiNxTiuXtaZaGBN71qgmarE9G9zLCtG/oNyP/bfUnbVA
/5mM31Yz/j8Qbowr
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6963609603860735, 0.7405204861750756, 0.9125202472113142], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2Q1lUVx3+7z/Ps89zfE2lNQc04IaCOxosoI6BAIFIa1gwuZDqjyPuu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmeMlVUQhr97717ud74rMUYFTUyUooFEpLkQQToRAU0UwUCUvsCyS1NQ
ysLSQRMiSlVhTVj6oggrRUGaFBUQ6cREftgiKog/DJ3o8+blxyQzZ8qZM+ed
OafOoNE9RqWjKNoCFUALkiiano+iz7JRNIeFZSGKPoRK0L2TiaIW8P1yUdQy
FUUHodbIraDa6J9A3xZdjhiX4esS4704iq4h5+FnYDOa2M1YW4e8FqqL7inW
XocfRiJDkYugLPzL7D9D+xNzFHvdzdomfDdDx+D/Ze0UvqehqTWITfwnsd2P
z3r2v4H/VmxHQB/Dn8TnArG3I9eBv87an9jvwr8N/iniDUdXDi1CfxQqgi+G
JsMfgWYSux4+F/Gdyh7D4DsG16Jdynuthnanvef36E5B1diWoy/E/jDyJ8g3
0VfCr4BKVXvWFsSumWqlHLuRb3doMLrOrI0h14Xo341cwwTfPFQT/VLivwVf
nz0uqXasXcX3CpRkfQfL4ecRYzf8fGwehn8e+zHw3Vmrg1wX2lvgO65Ed1ox
086/Nnv3Rb8E2xehfsiHkYuo3xvY1Mb2Aag/fCX2HdB1hCZi+xo5r8K+NzGn
pV2jFeQzH/0+9IvZswG+DYOxUIX/LPRboQ3oJkCdse2U910p5gpiHdOdYD+F
td+Rv0TfinwGsd9U+BdYq0Bfjf0i1Q+6jG41clfp8e9KreYgt0u8Jr4R+x1E
PpQY26QetSDWcew3I99C3xO5A9QC+0fVH9i2hLrBPxb5bAH5n4zP2AXfZ4J1
rVnrBF+cM3ZOQAuwvx/72+gOYd8LfU+oMHLMHjn3mHpLdz6WpLbFxnZ1ge/m
LP4/FPiOusK/in9vbAtZW594D8WuQG4L3w56Ezli/+axe1S9uT5rrFzH/3zG
mHmIveepf9PuwceJ1yjxWTQDeqF/JG9s/Iy8H909rB1IGVOaLb8S71DGM2YJ
8tK88xc+pqJ7H/uR2NdkrRX8VdZ+xP5B7GsR715oVNY1Ui8sgtqn3ROzsX07
GPujU8bChZzPJkysjV0z1WoPPtPhn0U/IPLMEVa0p/YSZrrDN895VixLu7fm
47Mh7R5LyKUGVJr1HXcRtmPPph7EXEkuq4J7ewTyFGwnJ8aqeqoh+TWAuqSM
wSvYLkw8e4uJ2YR4Q4hXhu2StHu5aWzsqqfrIFclvsuxyNeCZ4JmgWo2Bdu5
0Mq0Z1qMba3g3tSM/hR+k2Ys/KjIs20O8vSMZ9x6+CpoCfJI9FvhtwTbfsRa
G3J/Ou+7E4aGxp6ZmpXKWb1+EdqRcs/vxHcPtAbfMtZuYrsPee0duQz5OPHG
cVcvEfMo/GDWxuM7nLWTyNuC99bML+M8k1TTlGfAEfQDYr8Fw2p4NvWNPQs0
o4bBNyWfqgLP9K+ERZ0x4xi30H+DvOGO3AfbNfEdrKRdy0us7Uy5prr7isSz
VBion/hOdBd3sbadWDuglcSbhM958ilM3OvLNaNin1FnGxO5lxvnXE/1xLf4
fgdtzBgzwn5l4lmpHhiXc0zFEoamYzsr+G3Sm1mXeIOlzxrj5xJjVNjUjHgF
2/aJZ11/bJaiKw/uvRH4v4duWt6zUz02IfGd6a5K8BmfuEfUG8XIE5Gfy1lX
CjXTPCbeavK5hnwi+E3UW6IZeiT4jDqb3sQDwXei2usN3xWMGe2nGJ8H11S1
rMx4FmnGabZpJhXlPYM0eyrI+YvgHLS37qADth2hPhnP1HPYn8k71kxqeB+6
5sgjs37Dvg4+k84iTJQgDw/Gpt7kdcJucG+rRzQbhiT+u2hGCMuTY7+NwvTA
2BgVNoXpQfgODH7bldNG/Q2Ce009qb/RT+RfnfIfaXfwH0d/G/WQsHw279yF
6ZHqBeWMrl+B775e7FoIA3/njGlhWRj+DdtfoKKsZ/KN4Bmk2aOZvxy+Ivjv
pz9Kaew/kv5G5Wm/zSWxeb3RfYMxJSzpzZmiuwvGknKqxr5e4t5YAx0NflP1
lgrj+ov9kXMv6E/2V84zULNPM0R3cybnv4Hu6GDwn0p/KfXwB5q/wX9FvSGN
4ZsEv82q4d5gzAqrmjlzg98MvRWaefobLM777dMf4SS6lsS8XXDnD4fvf7Hx
qz+Tajc78d9ENfwfZ4Z+IQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7626310198251067, 0.8469980066111449, 0.9140309911183699], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2QllUZx+/n9X7u+yanHATLEt2FBpqcBRYY8YPl4qjYiwjhjgiYJFCO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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhjf3nttzzzlKjMFClAgUgkUhIAWCmjiAQR7USqtUoKIC4hBp
mVRkaAuUQYkTKTLE1CgalVkRjMEYBwKG6UEZRJxIEA08GCEGhAJ+f34e1s1e
+19r7bPXXutft9u4+qq6XAihFYmQrVkIl9IQGlBKSkLYzfoe9poKIZSxV5GE
MACZjNPmdiFUxSFk6FfkQ9iAf1kxhOHsrQKPkOfwbSPGbHzXEuM39NvRf8S3
lfgZ693Yr0avxr4L/nXEe4Z4lfh8C74d6Y2OWejMz8fY7MV2KHoRLE59dgds
5uK7CpsG1nOQ/8CmceYazu6Pzxqwi/hHYF8gO8BexmYR59fwPXfh/w36l5w9
GPwP1k3szWZ9kr2F2M9DhhBrKzFPEetxbKrA2ti7AdtDnHEJ++uRGmz3g58i
/lLsB4H/A16KfR/woejn0OeC3Zp37l/AZ13Bb9CZdS9suoANZG8u5/VAaiLn
uJvOx2YV2FBkE3opcnfkHI0Gexg5zfkt4O/q28ALxNuM9CX2Ub0h9j3Qv0L/
Gsmxnk9O27CdyTc9C55n7y/WFbGxH4h/MPadddeLeef2I/a25Z3jC+iz8amL
rC9Fvwl5Gn09/j3xPYB92+V8Bb71l8RvczXf+yBYv8TfdgR4C/h54i3gPnne
6w7WdyI14APA+xB7f+K71etNVJvICux/ZW8Y/nuw3xG5ppX7gejdI7/BBdbT
M9fqVcgb6IOJuQC8GTnNegU+s/J+7+3Y/ol8WuIa6Ah+DH0T+r+cOY71eGJU
R36jxtg9oNofAT4D7DB6S4lzvo31fdgs4i492Xsndg6Vu43IWe5yBnk7uOf2
gD0Vu3Z+53tK8e8Efg16P85brNpGmjmrAvw2bM8nzsW14L2wH4E+HH10wXdt
QTbkfOeF+Fbi8xb6i5Hv1hWZnvMdu7EeG7uWq/CvQ78Z/77g05BGYh8jxonI
OZuP3py4N8dyh73Y7i76248iE7F9AnkU7CF8dmL7XeLaaw7uzXKkQ+QeVS9M
SG2rnqjVe6qHue8gZDLf0x+bfjnfaSr6J9hszJkTyhPXoGpPPTYBvHvR3KU7
HiL2wdRvuRJ9Crav4z8RPYf+fOaaVa2qZzukfgPlXjVdwP4n5PO830C1ME53
bOeaqASbRrxh7cyJY/BtVI0RexkxpoJ3BT+ObX3evfNZ0b2nHtqQmaPFzcex
74h9aWIuVA0sV62iz2A9E1nEemHi3DflzU0HdMfIHLUydo2rtsV5xzNzjLhF
Nd6b9b7EtTgJn+nYl2euHfXQHHElMib4zEdY1ybmavXoa9jXJ86dcvBKbA7V
eeL8xWAvJf421cB6vm1d6lnTSvxJYEvwGY8ecubSIezdkjeniutqM+dOnHeC
9cnM3D4I+xuJ1St1baiG+oD1ztyLI3Um2GPI/ZHPENc3I1sK5vwrOat94lkl
TlFvDEbaF9wjDal7WL0rjh0Ru+fUa6059/q9sWtZPa/ZVpa5dzTj3kN/H3kz
8kxULYzMPDtUE2fAzqbmTvWYemdi7FmlHtKsFUeKGzVzNQuaiq5dzYTDiXta
vayaVG82JK4N9ehw9FGJczEgcu29iv+anGtwsuo1cS2qBy6m/s+g/wqaoWNT
z3DNbuVQ3PI3+Pcl5ph5iWeqZqlmdDW2a1O/7U7u2Cn1ntaaofMz51C50xus
Fh+BL4+cozmpOV9crxlzLvXM16zXm/ycmNPF5ZpJHxLrSGIu1Ay5Dn0J/h/k
3AOzUte4alszb1fqHlNvqUfFHQsyz35xiL6lY+rZp29SLOVQuVPMstQzXLNb
M7YlM0eKG3exV4H9lMu6OOrJ2Jyut1RNN+q/V+bZI87X7NpXNFdqhultRmWe
7XojxVqWObZiKvcPJJ6NeoP/AaiCQ1U=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8221460330418445, 0.8668446776852414, 0.8873683185306166], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMVdUVx8/lnjvnnnMY6COghqZKFCion9BYlIdYFBKHmVG4UAqxMFKL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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtsX3MYx8//0p7/OaeXLGxTJSEys5kXaDNBZ3XZlqDtlm7L1pmuYSas
tdYlISyx9a4IEfbKxCUorxTLLowObbcuSNqaa9zatbNQSxATfL759sWTPN/f
cz2/33M55zc0rWpMB0HQDWWhs6MgGA6D4FQmCOZAZbkg+IqzvfAPodCKbIqz
PzHaxFk1sjS4NS8IloNPJkFQDP0OP5AfBH1xENQh34Z+MfZb0T8PvBJ+Czq9
+MtxlsAfgC6D/ym07oXg4+B8/JXifwjcib/TUDH4YXQG8TUAfYv/76BHsO0E
j6WCoAZqA58A/4WsAfud4OPgP8D14G34/x5/P+OrEbyWWGugDdiOcLYefh1U
w908Tcw89NvRfxBZhP5B+PcUD3/7OBuFbwl9F+OcVaE/iM4hZDdwtjSyjXQX
Zxy7ibO7M85hiljl+KgmVj/3FyF7F39HMr6jCfDboe9iELoV+8fAd8LXYB8i
fwv8CTiGDuFvEzq38T1V+LsEvB6d1cg2EuNGcES8LvgO6E10e6Et5P581m/T
Bd6edXx9y1DOd61vyo/8JnoLxVMtLAEvyromPoAvR2chsv2cnSLea+TXRj4n
yWc7/KLEucgmhX0FNhNpv+Gl2P6ATuFMPZTCj8R+m2t5k47YNara1Jvsh78F
nYvRHdWb6/uhFHwt8mHkR6FP8b0k5btYF9mX7mRDaB+yVc5r8H8muBLbpdC/
sWtWtTqLnBNwAf4vgJ/mbES1Hvqt9f7XwBchn4f8BWL0hX4j3dUA9CL2L0PP
4bse/R9D94C+tYiz5tA1JV/LOJuP7m+cHST3BeC/wVeAn8J3ITE6idWRONYe
cA/8Tux3of8+eAf8o9Dj4OvT5rvQ2ZvnsxL81XK2W28BtSFrhXqQ9eVZNi92
btK5CtyeOJZ8FCCr4ezDPM8Q9ebtoWtdPXouumV833zwYnTuA9+rs7R7+nV0
v0FennaNvIS/UvDcjO+oC3/T6E9SO9PIv0C/DNyE7S7kQ7HvTHf1EfjryDWn
WlOMZnALtDXjnt6Ifn3s3vkv5dxfie1L37BD95f423ejfz/8A4nfXjm+E7on
1YuHoT2he1a9Mgztw19d6LdSTfXAN0aOpZ58hlhX5vwW6tnPwf34v5l8ryOH
CmTPxva1Ap1KbDeHrt1+qBDd5Tm/rWrsGPIvI88m1cRZ2I6h35tyT98k34l7
vRL5Mtknviv1xCi6c2PXomzuwdeToWej7uwX1Q74roxn6iS4O/Qs10ydBd4c
eTdUZL0rVsfuHe0Mzd6V4Kuz1l8If1Hsb5md9bfPzvltdQevhp4x6hftIL31
sdC1qTeP1cvYHwV3g1fFzkGxFUOzf23su1S+mpWTM/NfM3MK3yE+z8nzjP0M
3Tmh70Y+nwj9zbLVjNa3N8SeJboD9VarvjHtHtOsuCPyrtHMKIE/HHo2aJ9q
lr0Re7Zqpp2Bfm3sXfRryrlMRq4l5TSW80xR/2smtmNfnfhb61KePUXoF2c8
g+q0uxLvKu2wAznXoGpPO+pI6B2vXLSjP0b3ROJdoxlfiKwAKsrYp2bpgthv
o5mqXTweeXZpJ6s3S2b8qUfHkU8k3jWauZdHnuGaZ+p59a6+Qbmrh6sS72zt
au2gZnBL4lmmmbMi538K/Uvojv/B1+nIvagc/wf6BxwL
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8816610462585823, 0.886691348759338, 0.8607056459428633], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl0mMFmUQhnvm7//v/rthEBGNogdjFNCDgg5ByTAEGXBDFEcWPWlcYmLc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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlU9sVVUQxs+77z3uefdB+WMwURMTFkKBBYKBBGgtiS2gWAyltKWuNAgx
MajEnbBCoG0i0IQ/CRsgorgwxoRqW4wVLP8DVEERErBAaVEjyAZYAf6+fC4m
me/MzD0zc76ZO+nt9xvWJiGEtUgBmVUOYSAN4X4+hPeKIfxdCqEb3JkLYRGO
x9GTLIRh7LeROfg/C04I3oNcQG9GWvG/AJ4bQ9gB3oLezfcuoq8gplM6Zw3g
ZUgL/neRDP83sH/BXUPgh+i9yDpwibur8A34TCN2KlJPfqc460evJZ/rigW/
hf9no0JYgu955Y+9OXHux8AjeddwCPwmPl9iP6hvgAvgF9FnIBPxbQMfIPYG
+SzEnoJnYZuJ1HB/H2e96HP43nL0Cdi3U9/LnH1KPovAjcTvQ5ahH8zcq358
5oM78NmLrQ7JRdeo2qYX/O3DnP2W+I6j5POIOwe56wYygdgcPrfQp/G9JvUX
WUmu9/Rm6DE695eIHyZ+HjEf4bsf/Ae2VzLX+g93nAafQQbwr0Z+QO9DjqLP
RrYSOw6pJP4I8iOxk1Uz8YeRZ9CvcMdX+L7L95bgW4+043uTs+fL7rl6Pbfo
XrZQT2PePVVuI8RXpM5xNL7n0A/k/KbjsT8uufap2PuxPQHfzLsHS7GXou/6
PHGum6J7r5zFBXFc3BYnxMWJ0VwVJ2uxP40MgHcTM4itLvNb3wGvT30mfTn3
bQBfB99NXEOXuEU+C8Hbcq7lQdncVU3iVnPJseLYCvDXmd/iVNHcbo/OXRyv
IWYn+BvwZOyXU3Nc3FaPxf2T2K8lnoFPsDdyVlPwTP3JXd9ytj3nnL5D/6vk
WdZZD3g3/h0Fz/govvUxZw3kNwjehL665NkUp37HXp2Zm3XgMeRSUXZu4vgQ
/i9kfvsu7GfBY7FPKfoNF0dzSNzRWQ+4FZ9K7vtV+wW8KvUsXQXXR+8c7ZpW
8Gb0NSVzWztGu2c238sXvIMu4v9B6l1wK/HumcdZW8E7SFz5CftQ3pzZif1Q
6reSTzW+uzhrL7gnyu1fpC/3f47Rd+jbw8gU7Y/Us/EU/r3RNakWzeyJ6JpU
i96oS7OaujfaOR3RO1G7UDtPXNLMalbFqY3RO1S7Uzvi9bI5Km5qpn7B9+fM
u1Kc1W44Io7kvSP0lppxzbbedCn2D1O/nWZ8Afid1LOuGR+TeUdpN+kfkM+8
Y7RbtDOfy8xZcVU91+zfS127dsCT1D1Sby6pJ9E7UbtQnAyZZ1izqzdoR99S
9u7rLZrrbWXr4vyriueb+9GbEu/ix6m/rZ2st6ri7Pui30y+C1LvesWoF69F
x6on/wHK4Ox5
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlsFvVVUQxs9t6bu377W0r7XJq4b4XiGRRGPRqE1ME02s1rbURA0RDdKE
uHKh7NW9iX8C7a4gG01EScCFlFdR2UBBl7SUBdoUEmmb0FYi+H2ZX+Nics6d
O2fuzDffzLmNY5++80lLSmlJ0ip5UrIlqUtGspRGSykNpFjflDyn/b/tKV3M
UzqRhd1YKc6NFynNoR8vhX5Q+g+1HpF8l0I/IXlW+4PY2aYLmzP4G8dmWT6/
kM+3snhvX/Z/U/rPpZ/Ufkq6o5LvnYf0n+Xhu5lCP5/i7FfE8LfefyB5QTbV
ihTllA4LhH69H5JcleqRcpyXzbRsOiSz0s9J3yLbS9LPSPcNetv/ru/+UQRm
M8TkePz+JGcfL8U3jLV1pyTHWuKbpyUfa39OPs4XEdudtpTutkXuPufzZ7V/
Vd9/N49cntLzoKRX8iAFlnX0T0tuaf9aOXAxJg917ssi6nhJ6y+SYelXiM25
ON+/2A8Rl/eHZPtEOZ5t6zO1UtiuYL/zvECOzs+5v62zneV4dk3uU5dT4GMs
rduU/CB9j+rSKvv3W6IGXo2n309h001NzZ19snlG8lgW2IwVgY9tqtTdtt3s
V4jT8ZpDS1lgdzILmznsj+D/PfFhVxF2udY3FNtyFrXxeiDFGdteTGE7Ug77
w+1xxnaup+tq/AvpRsvh4yetr8juQha199qbojZXsujB32Qz2R7P54XPZiU4
MQVuR8HbOTiW+3r/Zx6cuaJ1ooh3rp/xdr1etA/5Pd4WvOjLI7bL+DWXf86D
99438+iNafrRveiedd97Lpwg1lX5a2hd1LrUFjn16PlGW+T1fCVicjw+4/47
wznjc4CZ5PrcTOHDvnbhYxE/W8ys7hTnVsHWvhyjOTPBPDH/vy0Hj42Bsfd8
Mf6n6f2z1HISPrxejlnjZ/f3ozx6/A59adudmDw/Xbdhauc6jYDH1+XoAddn
W88b9Kkxvgyfh7H12YZ5JrmWgqfuyQV6s5N9Pz1fp++9dzzOuURd9mSxb+L3
nxR1yPFjrq5L+jwLsc/R9zBXlpkn3lt3nXeO7V6KnvMdUsvCv+tu3r1cCTyv
5lFv19qzc7IILj1sj/nr2rt33cNZCj6+VAlOup6j3DvmQRfxdBKncXAcu4nL
uHWhn0ff5FyDmD0Xnc9eyVqK794Dg3XwMa+2wXYfc8U2/cyMJXw6pgXwWCaW
/eSyBi99rkq9NsCnFdyNm3G6TZ/2YVNFtvCxycx0j28QWxVfxnyAmjbI3XnX
yX2QfG/Buz56cS/6HurdwdzIOXsNe9e1Aaf2YJuzb8K7/uz/WGr430Bf56x5
2QSPFuL3Xb/D3zXeOd9fi5h37qEqc9v88d1e4i5zjq7xdfjQQWx1uNFkv5tc
fM/Mctd0oXPNfixi/l5gDk3TO93M/jk4sB9++j/InByBQzs9UeL7PjtLz3rG
umZN+nKM/xrPLN9pM+DygFq6f1eZf34+nse/hb9V41415zxveuCR75VJZpHv
m4PMLv/jnONfYh28jbtj9zcG4GArnK/BPe8XmdmeGV38lzm3If4TzNWP8viH
GKbve+FhVo772/nZzw3m9jZ8dhz/ARgzN38=
         "],
         VertexColors->None], 
        PolygonBox[{{2123, 2999, 1553, 421}, {3054, 2124, 180, 1737}, {1858, 
         3001, 1562, 222}, {2628, 2627, 332, 478}, {2573, 1999, 421, 610}, {
         3016, 2122, 411, 1629}, {2125, 3054, 1737, 413}, {2010, 3041, 1702, 
         429}, {2992, 2056, 334, 1516}, {2021, 3043, 1704, 437}, {1813, 2992, 
         1516, 49}, {2630, 2629, 333, 480}, {1987, 2561, 601, 412}, {1917, 
         2392, 480, 334}, {2989, 2031, 308, 1502}, {3041, 2727, 610, 1702}, {
         3063, 3062, 437, 1562}, {3010, 2053, 46, 1611}, {2121, 3016, 1629, 
         177}, {2587, 2011, 429, 618}, {2047, 3009, 1608, 324}, {1985, 2558, 
         600, 411}, {2367, 1892, 316, 447}, {1808, 2989, 1502, 4}, {2381, 
         1904, 324, 462}, {2054, 3010, 1611, 332}, {2999, 1856, 177, 1553}, {
         1916, 2391, 478, 333}, {2563, 1988, 413, 601}, {2560, 1986, 412, 
         600}, {2233, 2234, 447, 308}, {3009, 2046, 49, 1608}, {2870, 2010, 
         429, 1392}, {3043, 2734, 618, 1704}, {2246, 2247, 462, 316}, {2011, 
         2869, 1392, 429}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1808, 2989, 2031, 1882, 2232, 2233, 2234, 2750, 2367, 1892, 
         2245, 2246, 2247, 2760, 2381, 1904, 2259, 2260, 2047, 3009, 2046, 
         2184, 1813, 2992, 2056, 2631, 2272, 1917, 2392, 2055, 2630, 2629, 
         2271, 1916, 2391, 2052, 2628, 2627, 2270, 1915, 2054, 3010, 2053}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1858, 3001, 3063, 3062, 2022, 2874, 2021, 3043, 2734, 2133, 
         2587, 2011, 2869, 2586, 2870, 2010, 3041, 2727, 2129, 2573, 1999, 
         2866, 1998, 2123, 2999, 1856, 1875, 2121, 3016, 2122, 1984, 2557, 
         1985, 2558, 2833, 2560, 1986, 2559, 1987, 2561, 2834, 2563, 1988, 
         2562, 1989, 2125, 3054, 2124}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2066, 2643, 2067, 2644, 1924, 2280, 2641, 2642, 2065, 2406, 
         1925, 2282, 2645, 2646, 2068, 2407, 1926, 2283, 2647, 2770, 3011, 
         2069, 2901, 2771, 2186, 3057, 1927, 2895, 2058, 2768, 2769, 1814, 
         1860, 2892, 2893, 2891, 2057, 2894, 1918, 2185, 2048, 2620, 2049, 
         2621, 2263, 2261, 1905, 2382, 2761, 2250, 2249, 2248, 1893, 2368, 
         2752, 2238, 2237, 2235, 1883, 2599, 2032, 2598, 2751}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2108, 2710, 2109, 2711, 1976, 2313, 1975, 2538, 2823, 2537, 
         1974, 2535, 1973, 2536, 2822, 2534, 1972, 2311, 1971, 2709, 2106, 
         2708, 2105, 2179, 2178, 2954, 2107, 2951, 2953, 2952, 2197, 1855, 
         2830, 2829, 2119, 2957, 2180, 2181, 2832, 2958, 2120, 3053, 2831, 
         1996, 2330, 1997, 2572, 2128, 2726, 3040, 2008, 2868, 2009, 2585, 
         2132, 2597, 2019, 2354, 2020, 2740, 2139, 2739, 2846}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2080, 2413, 1931, 2281, 1932, 2655, 2656, 2654, 2079, 2414, 
         1933, 2290, 2657, 3012, 3047, 3046, 2081, 2913, 2914, 2659, 2658, 
         1934, 2284, 1935, 2415, 2785, 2417, 1936, 2416, 2419, 2418, 1824, 
         2190, 2905, 2906, 2904, 2908, 2907, 2175, 2902, 2903, 2772, 2773, 
         1819, 2187, 2632, 2393, 2394, 2861, 2860, 1919, 3039, 2622, 2050, 
         2383, 1907, 2262, 1906, 2762, 2990, 2763, 2887, 2886, 2764, 2254, 
         2253, 2251, 1894, 2369, 2754, 2600, 2602, 2601, 1885, 2236, 1884, 
         2357, 2753}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2101, 3050, 3051, 3014, 2698, 2312, 1963, 2814, 2998, 2815, 
         2935, 2934, 2816, 2525, 1962, 2302, 1961, 3059, 2524, 2813, 2932, 
         2933, 2812, 2997, 2811, 2697, 2310, 1960, 2523, 2100, 2696, 2695, 
         2309, 2522, 2521, 2694, 1871, 1848, 2810, 2809, 2931, 2930, 1970, 
         2949, 2950, 2946, 2948, 2947, 1873, 1851, 2555, 2556, 2316, 2317, 
         2318, 2828, 2571, 1995, 2329, 2331, 2724, 2725, 2723, 2127, 2583, 
         2006, 2343, 2007, 2584, 2131, 2731, 2733, 2732, 2018, 2353, 2355, 
         2356, 2845}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1809, 2755, 2756, 2850, 2849, 1886, 2358, 2033, 2370, 1895, 
         2252, 1896, 2371, 2042, 2613, 3037, 1908, 2856, 2857, 2385, 3055, 
         2384, 2889, 2623, 2624, 2395, 2397, 2396, 2633, 2188, 1820, 2225, 
         2224, 2070, 2176, 1863, 2775, 2774, 2909, 2071, 3044, 2848, 1877, 
         2916, 2083, 2915, 2082, 1864, 2177, 2084, 2660, 2662, 2661, 2191, 
         1828, 2440, 2441, 2437, 2439, 2438, 1827, 2435, 2436, 2433, 1946, 
         2434, 2789, 2432, 1945, 2291, 1944, 2431, 2788, 2430, 1943, 2427, 
         2429, 2428, 2669}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1857, 1876, 2352, 2351, 2017, 2873, 2594, 2844, 2345, 2344, 
         2342, 2005, 2867, 2580, 2838, 2328, 2327, 2326, 2568, 2567, 1854, 
         1874, 2315, 2314, 2552, 2551, 1850, 1872, 2943, 2944, 2705, 2104, 
         2196, 2195, 2928, 2098, 2927, 2099, 2929, 2965, 2963, 2964, 2926, 
         2097, 2806, 2807, 2808, 2193, 2194, 2091, 2231, 2792, 1843, 1867, 
         2679, 2496, 2497, 2299, 2680, 3033, 1868, 2681, 2503, 2504, 2300, 
         2682, 2683, 2092, 2510, 1953, 2301, 2684, 2685, 2093, 2516, 1954, 
         2303, 2686, 3003, 1869, 2847}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1810, 2757, 2758, 2359, 2363, 2362, 2885, 2604, 2605, 2372, 
         2375, 2374, 2888, 2614, 2615, 2386, 2389, 2388, 2890, 2625, 2626, 
         2398, 2402, 2401, 2896, 2634, 2635, 2408, 2410, 2409, 2648, 2171, 
         3024, 2172, 2140, 2142, 3018, 2141, 2182, 2023, 3004, 2024, 1878, 
         2878, 2879, 2875, 2877, 2876, 2966, 2967, 2229, 2156, 2213, 2212, 
         1880, 2028, 3006, 2027, 1840, 2149, 3021, 2150, 2148, 2152, 3022, 
         2151, 1841, 3030, 3031, 3029, 2488, 2487, 2490, 2489, 1842, 2492, 
         2493, 2491, 2495, 2494, 1844, 2499, 2500, 2498, 2502, 2501, 1845, 
         2506, 2507, 2505, 2509, 2508, 1846, 2512, 2513, 2511, 2515, 2514, 
         1847}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2672, 2458, 2459, 2457, 2461, 2460, 1832, 2465, 2466, 2464, 
         2468, 2467, 1834, 2471, 2472, 2470, 2474, 2473, 1835, 2477, 2478, 
         2476, 2480, 2479, 1836, 2484, 2485, 2483, 2486, 3026, 3028, 3027, 
         1837, 2144, 3019, 2145, 2143, 2147, 3020, 2146, 1838, 2025, 3005, 
         2026, 1879, 2883, 2884, 2880, 2882, 2881, 1839, 2230, 2163, 2215, 
         2214, 1881, 2030, 3007, 2029, 2183, 2173, 3025, 2174, 2153, 2155, 
         3023, 2154, 2741, 2692, 2693, 2531, 2533, 2532, 2945, 2706, 2707, 
         2550, 2554, 2553, 2956, 2716, 2717, 2566, 2570, 2569, 2959, 2721, 
         2722, 2579, 2582, 2581, 2962, 2729, 2730, 2593, 2596, 2595, 2738}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1831, 2455, 2456, 2453, 1950, 2454, 2791, 2452, 1949, 2293, 
         1948, 2451, 2790, 2450, 1947, 2447, 2449, 2448, 1830, 2445, 2446, 
         2442, 2444, 2443, 1829, 2208, 1826, 2228, 2227, 2161, 2207, 2206, 
         2918, 2085, 2917, 2086, 2919, 2074, 2975, 2160, 2974, 2159, 2202, 
         2203, 2072, 2226, 2776, 1821, 2189, 1815, 1861, 2274, 2273, 2400, 
         2399, 1811, 1859, 2265, 2264, 1909, 2858, 2387, 2765, 2258, 2257, 
         2255, 1897, 2852, 2373, 2759, 2241, 2240, 2239, 2361, 2360, 2603}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1833, 2462, 2463, 2294, 2670, 2671, 2089, 2469, 1951, 2295, 
         2673, 2674, 2090, 2475, 1952, 2297, 2675, 3002, 1865, 2676, 2481, 
         2482, 2298, 2677, 3032, 1866, 2678, 2192, 2978, 2979, 2744, 2162, 
         2210, 2209, 2802, 2801, 2800, 2164, 2980, 2095, 2986, 2165, 2803, 
         2804, 2805, 2216, 2217, 2169, 2747, 2749, 2748, 2222, 2942, 2703, 
         2704, 2547, 2549, 2548, 2955, 2714, 2715, 2865, 2864, 1994, 2565, 
         2126, 2577, 2003, 2339, 2004, 2578, 2130, 2728, 3042, 2016, 2871, 
         2872, 2592, 3056, 2591, 2737}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2034, 2364, 1887, 2242, 2244, 2607, 2608, 2606, 2035, 2376, 
         1898, 2256, 1899, 2377, 2043, 2616, 2618, 2617, 1910, 2266, 2268, 
         2269, 2766, 2403, 1920, 2275, 2276, 1862, 1816, 2201, 1822, 2778, 
         2777, 2973, 2972, 2073, 2976, 2977, 2779, 2780, 1823, 2205, 1825, 
         2421, 2422, 2420, 1937, 2423, 2786, 2424, 1938, 2286, 1939, 2664, 
         2665, 2663, 2087, 2425, 1940, 2292, 2666, 3013, 3049, 3048, 2088, 
         2920, 2921, 2668, 2667, 1941, 2289, 1942, 2426, 2787}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2138, 2590, 2015, 2349, 2014, 2841, 3000, 2842, 2961, 2960, 
         2843, 2341, 2340, 2338, 2002, 2576, 2837, 2718, 2720, 2719, 1993, 
         2323, 1992, 2564, 2118, 2546, 1983, 2862, 2863, 2702, 2701, 2941, 
         2218, 2937, 2938, 2936, 2940, 2939, 2096, 2984, 2985, 2981, 2983, 
         2982, 2211, 2691, 1870, 3034, 2690, 2308, 1959, 2520, 2094, 2689, 
         2688, 2306, 1958, 2797, 2996, 2798, 2925, 2924, 2799, 2519, 1957, 
         2296, 1956, 3058, 2518, 2795, 2922, 2923, 2794, 2995, 2793, 2687, 
         2304, 1955, 2517, 2796}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2036, 2609, 2037, 2610, 1888, 2243, 1889, 2365, 2038, 2611, 
         3035, 1900, 2853, 1901, 2378, 2044, 2390, 1911, 2267, 1912, 2743, 
         2157, 2742, 2767, 2198, 2051, 2900, 2059, 2897, 2899, 2898, 2200, 
         2969, 2970, 2968, 2158, 2971, 2061, 2204, 2782, 2910, 2075, 3045, 
         2781, 1928, 2285, 2649, 2650, 2076, 2411, 1929, 2287, 2651, 2652, 
         2077, 2412, 1930, 2288, 2653, 2783, 2912, 2078, 2911, 2784}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2136, 2735, 2137, 2736, 2350, 2348, 2013, 2589, 2840, 2337, 
         2336, 2335, 2001, 2575, 2836, 2325, 2324, 2322, 1991, 2713, 2117, 
         2712, 2116, 2223, 2113, 2988, 2170, 2826, 2827, 1853, 2220, 1849, 
         2821, 2820, 2168, 2987, 2103, 2219, 2166, 2745, 2167, 2746, 1969, 
         2307, 1968, 2530, 2819, 2529, 1967, 2527, 1966, 2528, 2817, 2526, 
         1965, 2305, 1964, 2700, 2102, 2699, 2818}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1818, 2994, 2064, 2640, 2279, 1923, 2405, 2063, 2639, 2638, 
         2278, 1922, 2404, 2062, 2637, 2636, 2277, 1921, 2060, 2993, 1817, 
         2199, 1812, 2991, 3061, 3060, 1914, 2859, 1913, 3038, 2619, 2045, 
         2380, 1903, 2854, 2379, 2855, 1902, 3036, 2612, 2041, 2366, 1891, 
         2851, 1890, 2040, 3008, 2039}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1852, 2110, 1977, 2539, 1978, 2540, 2824, 2542, 1979, 2541, 
         1980, 2543, 2825, 2545, 1981, 2544, 1982, 2112, 3052, 2111, 2221, 
         2114, 3015, 2115, 1990, 2319, 2320, 2321, 2835, 2574, 2000, 2332, 
         2333, 2334, 2839, 2588, 2012, 2346, 2347, 2135, 3017, 2134}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->769542259]
}, Open  ]],

Cell[TextData[{
 "A contour plot gives you essentially a \[OpenCurlyDoubleQuote]topographic \
map\[CloseCurlyDoubleQuote] of a function. The contours join points on the \
surface that have the same height. The default is to have contours \
corresponding to a sequence of equally spaced ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " values. Contour plots produced by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are by default shaded, in such a way that regions with higher ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " values are lighter. "
}], "Text",
 CellID->18896],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "what colors to use for shading; ",
     Cell[BoxData[
      ButtonBox["Hue",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
     " uses a sequence of hues"
    }], "TableText"]},
   {
    ButtonBox["Contours",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Contours"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the total number of contours, or the list of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " values for contours"
    }], "TableText"]},
   {
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[TextData[{
     "the range of values to be included; you can specify ",
     Cell[BoxData["{"], "InlineFormula"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "}",
     StyleBox[", ", "TR"],
     Cell[BoxData[
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
     ", or a list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["xrange", "TI"], ",", " ", 
        StyleBox["yrange", "TI"], ",", " ", 
        StyleBox["zrange", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["ContourShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContourShading"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "how to shade the regions; ",
     Cell[BoxData[
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]], "InlineFormula"],
     " leaves the regions blank, or a list of colors can be provided"
    }], "TableText"]},
   {
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of initial sample points in each direction", "TableText"]},
   {
    ButtonBox["MaxRecursion",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxRecursion"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of recursive subdivision steps to do", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], 
     Scaled[0.3], {
      Scaled[0.45]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->4667],

Cell[TextData[{
 "Some options for ",
 StyleBox["ContourPlot", "MR"],
 "."
}], "Caption",
 CellID->7285],

Cell["This shows the plot with no shading.", "MathCaption",
 CellID->12550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ContourShading", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->306891563],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyVnXm819P2/4+4hnANkUsh5F7iGuJKHPZBpVGEdCtEchVxVJKEQipDkSEy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   "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1808, 2989, 2031, 1882, 2232, 2233, 2234, 2750, 2367, 1892, 
         2245, 2246, 2247, 2760, 2381, 1904, 2259, 2260, 2047, 3009, 2046, 
         2184, 1813, 2992, 2056, 2631, 2272, 1917, 2392, 2055, 2630, 2629, 
         2271, 1916, 2391, 2052, 2628, 2627, 2270, 1915, 2054, 3010, 2053}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1858, 3001, 3063, 3062, 2022, 2874, 2021, 3043, 2734, 2133, 
         2587, 2011, 2869, 2586, 2870, 2010, 3041, 2727, 2129, 2573, 1999, 
         2866, 1998, 2123, 2999, 1856, 1875, 2121, 3016, 2122, 1984, 2557, 
         1985, 2558, 2833, 2560, 1986, 2559, 1987, 2561, 2834, 2563, 1988, 
         2562, 1989, 2125, 3054, 2124}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2066, 2643, 2067, 2644, 1924, 2280, 2641, 2642, 2065, 2406, 
         1925, 2282, 2645, 2646, 2068, 2407, 1926, 2283, 2647, 2770, 3011, 
         2069, 2901, 2771, 2186, 3057, 1927, 2895, 2058, 2768, 2769, 1814, 
         1860, 2892, 2893, 2891, 2057, 2894, 1918, 2185, 2048, 2620, 2049, 
         2621, 2263, 2261, 1905, 2382, 2761, 2250, 2249, 2248, 1893, 2368, 
         2752, 2238, 2237, 2235, 1883, 2599, 2032, 2598, 2751}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2108, 2710, 2109, 2711, 1976, 2313, 1975, 2538, 2823, 2537, 
         1974, 2535, 1973, 2536, 2822, 2534, 1972, 2311, 1971, 2709, 2106, 
         2708, 2105, 2179, 2178, 2954, 2107, 2951, 2953, 2952, 2197, 1855, 
         2830, 2829, 2119, 2957, 2180, 2181, 2832, 2958, 2120, 3053, 2831, 
         1996, 2330, 1997, 2572, 2128, 2726, 3040, 2008, 2868, 2009, 2585, 
         2132, 2597, 2019, 2354, 2020, 2740, 2139, 2739, 2846}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2080, 2413, 1931, 2281, 1932, 2655, 2656, 2654, 2079, 2414, 
         1933, 2290, 2657, 3012, 3047, 3046, 2081, 2913, 2914, 2659, 2658, 
         1934, 2284, 1935, 2415, 2785, 2417, 1936, 2416, 2419, 2418, 1824, 
         2190, 2905, 2906, 2904, 2908, 2907, 2175, 2902, 2903, 2772, 2773, 
         1819, 2187, 2632, 2393, 2394, 2861, 2860, 1919, 3039, 2622, 2050, 
         2383, 1907, 2262, 1906, 2762, 2990, 2763, 2887, 2886, 2764, 2254, 
         2253, 2251, 1894, 2369, 2754, 2600, 2602, 2601, 1885, 2236, 1884, 
         2357, 2753}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2101, 3050, 3051, 3014, 2698, 2312, 1963, 2814, 2998, 2815, 
         2935, 2934, 2816, 2525, 1962, 2302, 1961, 3059, 2524, 2813, 2932, 
         2933, 2812, 2997, 2811, 2697, 2310, 1960, 2523, 2100, 2696, 2695, 
         2309, 2522, 2521, 2694, 1871, 1848, 2810, 2809, 2931, 2930, 1970, 
         2949, 2950, 2946, 2948, 2947, 1873, 1851, 2555, 2556, 2316, 2317, 
         2318, 2828, 2571, 1995, 2329, 2331, 2724, 2725, 2723, 2127, 2583, 
         2006, 2343, 2007, 2584, 2131, 2731, 2733, 2732, 2018, 2353, 2355, 
         2356, 2845}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1809, 2755, 2756, 2850, 2849, 1886, 2358, 2033, 2370, 1895, 
         2252, 1896, 2371, 2042, 2613, 3037, 1908, 2856, 2857, 2385, 3055, 
         2384, 2889, 2623, 2624, 2395, 2397, 2396, 2633, 2188, 1820, 2225, 
         2224, 2070, 2176, 1863, 2775, 2774, 2909, 2071, 3044, 2848, 1877, 
         2916, 2083, 2915, 2082, 1864, 2177, 2084, 2660, 2662, 2661, 2191, 
         1828, 2440, 2441, 2437, 2439, 2438, 1827, 2435, 2436, 2433, 1946, 
         2434, 2789, 2432, 1945, 2291, 1944, 2431, 2788, 2430, 1943, 2427, 
         2429, 2428, 2669}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1857, 1876, 2352, 2351, 2017, 2873, 2594, 2844, 2345, 2344, 
         2342, 2005, 2867, 2580, 2838, 2328, 2327, 2326, 2568, 2567, 1854, 
         1874, 2315, 2314, 2552, 2551, 1850, 1872, 2943, 2944, 2705, 2104, 
         2196, 2195, 2928, 2098, 2927, 2099, 2929, 2965, 2963, 2964, 2926, 
         2097, 2806, 2807, 2808, 2193, 2194, 2091, 2231, 2792, 1843, 1867, 
         2679, 2496, 2497, 2299, 2680, 3033, 1868, 2681, 2503, 2504, 2300, 
         2682, 2683, 2092, 2510, 1953, 2301, 2684, 2685, 2093, 2516, 1954, 
         2303, 2686, 3003, 1869, 2847}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1810, 2757, 2758, 2359, 2363, 2362, 2885, 2604, 2605, 2372, 
         2375, 2374, 2888, 2614, 2615, 2386, 2389, 2388, 2890, 2625, 2626, 
         2398, 2402, 2401, 2896, 2634, 2635, 2408, 2410, 2409, 2648, 2171, 
         3024, 2172, 2140, 2142, 3018, 2141, 2182, 2023, 3004, 2024, 1878, 
         2878, 2879, 2875, 2877, 2876, 2966, 2967, 2229, 2156, 2213, 2212, 
         1880, 2028, 3006, 2027, 1840, 2149, 3021, 2150, 2148, 2152, 3022, 
         2151, 1841, 3030, 3031, 3029, 2488, 2487, 2490, 2489, 1842, 2492, 
         2493, 2491, 2495, 2494, 1844, 2499, 2500, 2498, 2502, 2501, 1845, 
         2506, 2507, 2505, 2509, 2508, 1846, 2512, 2513, 2511, 2515, 2514, 
         1847}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2672, 2458, 2459, 2457, 2461, 2460, 1832, 2465, 2466, 2464, 
         2468, 2467, 1834, 2471, 2472, 2470, 2474, 2473, 1835, 2477, 2478, 
         2476, 2480, 2479, 1836, 2484, 2485, 2483, 2486, 3026, 3028, 3027, 
         1837, 2144, 3019, 2145, 2143, 2147, 3020, 2146, 1838, 2025, 3005, 
         2026, 1879, 2883, 2884, 2880, 2882, 2881, 1839, 2230, 2163, 2215, 
         2214, 1881, 2030, 3007, 2029, 2183, 2173, 3025, 2174, 2153, 2155, 
         3023, 2154, 2741, 2692, 2693, 2531, 2533, 2532, 2945, 2706, 2707, 
         2550, 2554, 2553, 2956, 2716, 2717, 2566, 2570, 2569, 2959, 2721, 
         2722, 2579, 2582, 2581, 2962, 2729, 2730, 2593, 2596, 2595, 2738}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1831, 2455, 2456, 2453, 1950, 2454, 2791, 2452, 1949, 2293, 
         1948, 2451, 2790, 2450, 1947, 2447, 2449, 2448, 1830, 2445, 2446, 
         2442, 2444, 2443, 1829, 2208, 1826, 2228, 2227, 2161, 2207, 2206, 
         2918, 2085, 2917, 2086, 2919, 2074, 2975, 2160, 2974, 2159, 2202, 
         2203, 2072, 2226, 2776, 1821, 2189, 1815, 1861, 2274, 2273, 2400, 
         2399, 1811, 1859, 2265, 2264, 1909, 2858, 2387, 2765, 2258, 2257, 
         2255, 1897, 2852, 2373, 2759, 2241, 2240, 2239, 2361, 2360, 2603}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1833, 2462, 2463, 2294, 2670, 2671, 2089, 2469, 1951, 2295, 
         2673, 2674, 2090, 2475, 1952, 2297, 2675, 3002, 1865, 2676, 2481, 
         2482, 2298, 2677, 3032, 1866, 2678, 2192, 2978, 2979, 2744, 2162, 
         2210, 2209, 2802, 2801, 2800, 2164, 2980, 2095, 2986, 2165, 2803, 
         2804, 2805, 2216, 2217, 2169, 2747, 2749, 2748, 2222, 2942, 2703, 
         2704, 2547, 2549, 2548, 2955, 2714, 2715, 2865, 2864, 1994, 2565, 
         2126, 2577, 2003, 2339, 2004, 2578, 2130, 2728, 3042, 2016, 2871, 
         2872, 2592, 3056, 2591, 2737}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2034, 2364, 1887, 2242, 2244, 2607, 2608, 2606, 2035, 2376, 
         1898, 2256, 1899, 2377, 2043, 2616, 2618, 2617, 1910, 2266, 2268, 
         2269, 2766, 2403, 1920, 2275, 2276, 1862, 1816, 2201, 1822, 2778, 
         2777, 2973, 2972, 2073, 2976, 2977, 2779, 2780, 1823, 2205, 1825, 
         2421, 2422, 2420, 1937, 2423, 2786, 2424, 1938, 2286, 1939, 2664, 
         2665, 2663, 2087, 2425, 1940, 2292, 2666, 3013, 3049, 3048, 2088, 
         2920, 2921, 2668, 2667, 1941, 2289, 1942, 2426, 2787}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2138, 2590, 2015, 2349, 2014, 2841, 3000, 2842, 2961, 2960, 
         2843, 2341, 2340, 2338, 2002, 2576, 2837, 2718, 2720, 2719, 1993, 
         2323, 1992, 2564, 2118, 2546, 1983, 2862, 2863, 2702, 2701, 2941, 
         2218, 2937, 2938, 2936, 2940, 2939, 2096, 2984, 2985, 2981, 2983, 
         2982, 2211, 2691, 1870, 3034, 2690, 2308, 1959, 2520, 2094, 2689, 
         2688, 2306, 1958, 2797, 2996, 2798, 2925, 2924, 2799, 2519, 1957, 
         2296, 1956, 3058, 2518, 2795, 2922, 2923, 2794, 2995, 2793, 2687, 
         2304, 1955, 2517, 2796}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2036, 2609, 2037, 2610, 1888, 2243, 1889, 2365, 2038, 2611, 
         3035, 1900, 2853, 1901, 2378, 2044, 2390, 1911, 2267, 1912, 2743, 
         2157, 2742, 2767, 2198, 2051, 2900, 2059, 2897, 2899, 2898, 2200, 
         2969, 2970, 2968, 2158, 2971, 2061, 2204, 2782, 2910, 2075, 3045, 
         2781, 1928, 2285, 2649, 2650, 2076, 2411, 1929, 2287, 2651, 2652, 
         2077, 2412, 1930, 2288, 2653, 2783, 2912, 2078, 2911, 2784}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2136, 2735, 2137, 2736, 2350, 2348, 2013, 2589, 2840, 2337, 
         2336, 2335, 2001, 2575, 2836, 2325, 2324, 2322, 1991, 2713, 2117, 
         2712, 2116, 2223, 2113, 2988, 2170, 2826, 2827, 1853, 2220, 1849, 
         2821, 2820, 2168, 2987, 2103, 2219, 2166, 2745, 2167, 2746, 1969, 
         2307, 1968, 2530, 2819, 2529, 1967, 2527, 1966, 2528, 2817, 2526, 
         1965, 2305, 1964, 2700, 2102, 2699, 2818}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1818, 2994, 2064, 2640, 2279, 1923, 2405, 2063, 2639, 2638, 
         2278, 1922, 2404, 2062, 2637, 2636, 2277, 1921, 2060, 2993, 1817, 
         2199, 1812, 2991, 3061, 3060, 1914, 2859, 1913, 3038, 2619, 2045, 
         2380, 1903, 2854, 2379, 2855, 1902, 3036, 2612, 2041, 2366, 1891, 
         2851, 1890, 2040, 3008, 2039}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1852, 2110, 1977, 2539, 1978, 2540, 2824, 2542, 1979, 2541, 
         1980, 2543, 2825, 2545, 1981, 2544, 1982, 2112, 3052, 2111, 2221, 
         2114, 3015, 2115, 1990, 2319, 2320, 2321, 2835, 2574, 2000, 2332, 
         2333, 2334, 2839, 2588, 2012, 2346, 2347, 2135, 3017, 2134}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]=",
 CellID->233567927]
}, Open  ]],

Cell["\<\
This cycles the colors used for contour regions between light red and light \
purple.\
\>", "MathCaption",
 CellID->640505349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ContourShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"LightRed", ",", "LightPurple"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[59]:=",
 CellID->173812373],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyVnXm819P2/4+4hnANkUsh5F7iGuJKHPZBpVGEdCtEchVxVJKEQipDkSEy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   "], {{
     {RGBColor[1, 0.85, 0.85], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlk1sVGUUhu+tzMydO9CfaGi07RAx1tChXbmREjSWkpjiT0xoKd3Uoltd
607dsIYmphBYFlmIK6n/q067MjGBCot2ZbQQoJV0BjQZW98352ni4uSe+93z
ne+c97znfPf5mY/e/bAtSZLfJU9JHpaT5MdSklxIk6Sl938lNcmw3keLSdIj
/bBkWzIoaWLTK6my3ud32RckN6QfQF+SvijJpNf1PCLZsW9JRb5zyXwSe2zz
jZ63/E36Cn4q7O1JY69j+1KyR+9X9dySj4ZkL2urxVj3cw3dcW8WIo8x5ftS
JUkm9X5K9g8LEdcofo5LvsqS5HXJNfKy3wXpE3o+SCN+79uQvJIERt5nTJxz
LptlPb9F917jUQafF3T+TCkwbtd7Q7JPsj8N3XgaC+NzAx/2ZZ+D0l+UdEgf
0rNfclP6H4r301LkZD9NavSn1j/T+rjW1qV/Xoo8Bth7MA1sm9R5OFd9ZbOS
RhyPqfO0YnlP8pv062noy5zRAoOMHF2v28VYr1HrNeq9gi/7OaPnlOSK9nSn
cVY7edpmifOfEINtvcd18fkz+DFHDsC3vwpR66PS1wtRJ9foWeX0RRb6kPbd
1fpYGjY1uOl95sruXudQI5c7koEk6j8OB+zD67bd2cXPMYhjP+u8WdndT6Mm
9j8p27rkdDH6pgo3W5xh/+bgFjw0LlNtUfsqPWUu1cHBfn7VOb06bx6eujds
4zpk8M3Yr4L/kuw7yuHbeDxTCkwa4uQnpcCkS9+frsTZl4uBl9efgyd9zIAW
9b+o73OSEX3vlM938uCY/dUqsfcD+ezIAj9jdhvc3td6exY4+cz2PM6tar1b
72fbIu5VeuFeIXB3zHeoo3GzbW8e9sbCz2X6dJ0et+096u5aLMKlV7Po+Wv0
8T7yOluKXnWfnijGjLB+X7F9r2/n07DfYk8D/hqfR4Xg4lF4Xucs9+4TeO3v
tjNWm9ibP8cUy3f476bfbe++6kxjpnomVOHDSBZ1vcLMPs7cbpCHYzP2b+eB
v3EYgm/T9KR756dScNe8PQP/zL1z0t9oi1lqzIzdLPxaZFY5lpweNC8XmNNz
zIEBONNkJqzqrIFyzJJx+sQ1Mse26SXfSWNt4SdTHTbKEYd7f5r5U+HMFWb4
Ce6Cx9ShnZ4aZf0gc884luXzUTnO2CzHu3VzbQ+9M/+/WT5Jzzkec30ODJ1H
jVxm4ZZt7GuWnnTcF7izzM3r+HV/fEzfuSaeuwPMzHPcX/Y9kcUe+/H6eWZt
gXnrmX2yHPv/kX5M+i/cn7fgjvPuIvcp+sR5XQVrx2nemd/2/3IevuzHZ1Y4
1/3utR5mjTGxH/fxm3nU8odS/FvYr/vXHJmHDxfhZyexOz7fXXuzmJWeH76r
Joi1C5757Ar/DG/lcbeZO2vE5jw2mPmnmNHj8Mq88z1n7u2gm2Oucy+1LqAv
0Du+R3vp0wn8HaIfd/vyEHex8RgGE9dghDoa8yFysP0g/f+16t6sxDzq5z6+
SZz7uXu36Yc+eNtJLQvcd3X0Kj3QxN55nczjn8A4+C56LQsu+r/jb/49fA90
che4Jpeo6yVq5Bx8t/Rxv/RX4v/J/04PytGT5qN5exnunuZuMh82mWeHmb3r
zO0WPOihFkeYCTP8Y5jndeaMZ+Z/1GpKIA==
         "],
         VertexColors->None], 
        PolygonBox[{{1902, 3036, 1691, 323}, {2060, 2993, 1518, 341}, {2545, 
         1981, 404, 587}, {1922, 2404, 491, 342}, {1980, 2543, 587, 403}, {
         2993, 1817, 57, 1518}, {1923, 2405, 492, 343}, {3052, 2111, 169, 
         1732}, {1913, 3038, 1693, 331}, {1852, 2110, 402, 166}, {2639, 2638, 
         342, 492}, {2542, 1979, 403, 585}, {3038, 2619, 469, 1693}, {3036, 
         2612, 461, 1691}, {2040, 3008, 1606, 315}, {2588, 2012, 430, 611}, {
         3061, 3060, 331, 1513}, {3008, 2039, 12, 1606}, {1903, 2854, 1369, 
         323}, {2320, 2321, 603, 414}, {1818, 2994, 1521, 60}, {2855, 1902, 
         323, 1369}, {2994, 2064, 343, 1521}, {2135, 3017, 1634, 430}, {2380, 
         1903, 323, 469}, {2114, 3015, 1627, 169}, {2574, 2000, 422, 603}, {
         1978, 2540, 585, 402}, {2333, 2334, 611, 422}, {3017, 2134, 214, 
         1634}, {2637, 2636, 341, 491}, {1812, 2991, 1513, 57}, {3015, 2115, 
         414, 1627}, {2366, 1891, 315, 461}, {2112, 3052, 1732, 404}},
         VertexColors->None]}]}, 
     {RGBColor[0.94, 0.88, 0.94], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1V11oVnUcPnvPed9zzntcaSyY5uZ20YckQWVNnbOaRGstUyvDcqVmV35d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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtsVVUQhtfZ+2z3PnsTWkKJEGjTxkSJTUhQLhZCIYAvtaLWC6KUS4En
oL4JNDGCSMItxvAgRU1M9MEHWioXa1qQJwUMcldfFOQiilFEYms0gYTvz8/D
5Mysf2bW2jP/zGnoeK2tMwohdCJlZHwWwpIihN1JCFc42J6GsKYSwt1SCB1I
GSxBxoK/S+Bc/HuRY+gLkD1g3dgH0U8lxmYjrZF9Gsn1KFIfh9CAbCP/auw7
5F6O7MZ3HGe/ox+InKuNnO8kznkpD+FDzvrRr/K+v4jNwGvBz5NvAviD2JOx
y+DD5JrMWS16HfIBWCfxWyLnqCV+AjKW2HFINXoVUo0+CrlM7FJ9E/l+Ib6L
2B7sE8TuQgrsF7D3o9/gzbeJrWDX4f898X3g85EjiWNmgS/nTTPwPYl0oQ+p
pvyOQPq472X8v8H/Y+7rQZ/FeQP215Fz3yLHhdh3DOD/Oj6H8D2IPA/+XOG3
qGbPgFeBzwBrQh4CW0G+qcS/CP40+EjwJ8CmIwNgzdgt3HUGn3XYL3Hfd+Rr
QQax/8A+DXYWeZb4avxvgs0k/hHyPwU+V/3FXpf5jXrb58iizN+ob/sEqUW/
qO8mfmXk3tVV3Av1cA3Yj6r/A+QsuVdnOfs3ds9eIX4RsqxkDulbV+GzNPY3
i2s/peaCOPcfegdSj/1tybXbi3wVuYZnyNWP9KKfROaAHcX/h9gcbkrdE/VC
M9Cq2eDsbfR5+FzF/gx7O7mbInPzz4prJY42o/8P/mbiHoibQ9hvJObowswz
otlYHZmLx8BvxObkMvTHcnNZHBI364i5VjZHNbuaEc2GZli9XUmOJbF7XAV2
jhyfEruY/PvRB3P3Rm9ejP5q7lnUzOvueZlnW2/YA3acs4/AdhLzBfb61NzY
V3avHs/NbfWsG/v9wrtAM/cWvr+Sbyjym7ZiX8y9a9TDzdi/gQ9H7uEm7OvY
/2C3Y9erNhVzRd8wSfXOzSVxaC93rc+8m9TTPuKvVNyLbeC92Jewp2NvLZmr
DxfunTi7AbwRu533TiRngZ4XnnXNYAv+a1NzUTOh2e7m/h1lz7i4pRnTbIlj
NfiPqbjWqllN6h2n3bYZeS8z58Q17RBxb23mWoqD4t7fmr/YHFTtFuSeZdXw
CPhN8HOxd4Jq1Zp7llUzzapmWrOsmd0BNg2fTeAbkRGZa6zaaufuBO9JXRv5
qBZd93eTaqK7DqfetbpTb/sy9a7TGzULM3PXTjMxmvhRFe/SxsTcn5J7N2gG
hsH7CtdCO1C1fDIzt1TTqPCb9daaxNzQztGuEUcuk3tf6t6qpz+Dtef+r9JM
jMz9Bt2tnXEPO3jkBg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 0.85, 0.85], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1eMVVUUhs/ce889957zoBFRAaWqwwNBwUSFaALGBjoio9EBuwbLMKhB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW9oV2UUx5/t3p/3d+8liqaUqZtWWi/WrA1KJV/4oqXGlCwkS8mKpW7T
wuY2V9TyVYnLzJSWq4xMDbWMAqMXWVbUIoSKVObmSgvclpWD/hrS58t3Lw73
fJ9znvOc59xzvs+UBx9ZtKY0hLARiZE9Cd80hGIUwgfIZ8UQjiC9OJ1Efs5D
6M9CqMf23pgQRsC72NNREsIweHrmPfKdSMCxxLpcgn8Z0outBf869CF8zoO3
gVvAF0p91v3gmyKf+SL6evZn6A2c0c15ryB9xP4bfAr7Ddivxn8Ma++AB8Af
g48gb4ADeAz6+8hZ9g4iC8k1J2YX+svI14UQbsd1Kvpq9szB9x7WDnGf1eS0
Ad+FrD0FHkQuctZa5By2JeC56P+oRuC2xL663y3gfchm9FnIDuJfAh4i96PE
7yu6JvIdRqqwH2b/CfbXY59QdM1V6wvsKeMuPdiHI9dUdx8AJ7Fr0JT4Dsq9
grVe9AWsbeJu24hRRbwTqf/tOtULPAep0/2QWvSY+wxh78S+L/cdlHtvwf/y
C+INjp7/G7b78J+P77/4/Ap+AftjkevRi60cXBv8zzZkzkm5qMd09n7wyYJz
OAPuwH8ptvOqB+dVjv7fa5AD2EpG/+dhZBbxZiDfUZtpxP+d/cvAdbH7aTf+
pfgn+B5CdnPWHuRYwTUpx/de9uyKXcPXse3M3VsDsXuzEZ9lsXt0J/qrwsTe
ylon+nPIcWzdxNuauAa6e3PkXnybtU8i92QLeB2yGN9HwdsTz4BybQVH2A6y
9mnknCdia2TtYfR5nPc4uT2BHCD/Svacy3xH3a2EtV/A36fu9QC+Fn0qUo/v
Xu7UmrhH1W8LItdyP2sfRa7pFvTm1LmtRTYmrqnyWwGehN6UWr+DfKo478bM
s95D/CXYD2b+V03s+ZxcGzLPrmauSfOVO9frsb9J/OOpdXFILfinov+9euY0
e1tT53KWM86A21PXajB27afnnhX9g7Ho41JzTSVry1XLUf6qZm059nLwRc7q
wv48eAtSU3CN5rG3UfNf4p66EtsU1iawt7pg7pqZudfEYf+BF6eu5XWsrcC2
Sj0Vm7NWZu4J9YLWIuL9mJqbxhFvJrYCa1eg7+C+reT2oTg0MmeUYDuVutfL
8Bmfm/PEdcr5JfCaorlEHPZMYk5S/4mjxTXdRXOHOOfpzByg2W9GGvV/kGml
5rRV6Ctzc6N6XrV7gJg1o3z8B3p15lp+RbwG8NzU/141O536jrqbejhGbyua
O3THCvz7Ms+WZmB+6hqqduLch8BHsffE5oBJmf+Bal9gLSfWneBO8GYkAt+d
W+/j/B9S10y10szdhb4oN7drz7uJZ0yzpRpfRvxvE8+GZvpWbCPg8bHfoNng
P8FPFlyD7UWfqbP0JnSx/7aiuVOcKK7qT5yrOOvZxBwpbtQMH0v9ZuqtVM3b
sWXgyQVzoN4qvTF6WzSPb2Hbm3vWxVnKpSYztysncVtH5n+pO+X4zk7cS4qp
t+K1zFylN+PLxG+IuFscP5Ka88X1enPa2b8+N5eJYy7NPFOapb/Uw5k5SVyk
N28g80xplsS5m8A3Y59Rak5pSz3Dml29CUszc4i4Q29GBfZvEse+KvK/7y/6
LVQPTE7tI5tm8H/mqBrz
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.94, 0.88, 0.94], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG1sltUZx+8+vZ/nuV/2YbOiG7OaTSrRpcUty4YLYR+Wos5kIZtL3EuC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllsVVUUhndPb3vuOdcHNdEwCAhaER8KJkapIfpgakQTY9AHjSYQiNAy
WqBAESLQBFFbZlBooWWSQSMFClaEMCiBmBgGB1qBSKgRHBCsrYIG8fv9H1ay
/r2mvddee63dd+SkYROjEMIqKAPdk4TwdRzC3/kh3AV1z4XQAt1ZGEJTXgh9
kVWiU4HsIga/pCGMRb6hIISb4Ivg5cjfRv47eBr8VKgszzaD0b0bnSyyCmx2
gX8Cv4H8BngveCgxZmkvxCwGD4Tmob8CnXfx9R70Dr7K0SnDthx6EXk58i/h
T2VDaOdQR1kbDx4nQvaKdHJeE7+eeI/Cl0BDkRexVodtN6gUfjc++rCXNeBP
4M+zNhl+PbQPvAO8Cfk18E3wHvbUia8u6DB4YeSzXiVme6HPvBpcB/2K7ofs
vxPbseCXkd1A/wHwB5xvFfJRrPUHV4ErwS+BuxFvFWvN6J4EH8X2ELgNfBjc
Bl5DvOOcbT5rrfBPYzObWMsKvZc+6LQF7+lH+KX4X4D/qxmffSd0PHIOLiNv
xiagO5cc9YBfAn2O/zrk/fDdjP4J9F9F7efUd6q7rED+B/Kn8P8Y/nuCByH7
grXLuj90/sK2ApuRGeewFb4X8tLgPWxCfzN0Gt1a8C7pQ9szjnkf/BjVKHwh
tIRYi6HR2M8nxhJ8TQcnkWuwRrWTeK/VyFcmrlnVag14PL6ugCPibYRKkA+W
Pfqt+KhH3p2YH0fO8ST41VnXypvQEBSHE7OEWMeglfAzWbslcg3WgRcl3pty
Pib1HetuVcMzkC2NXcva82jiFWV9tr3Q1pxzoly0Er8hdg6VuxX4WwPuyrqW
9AbPwp+DzuS5xicRbwB4BLGGQ+vwdYa1Beh/hb9L4PtV//At3PmyxDWi2ngL
fzORz4CGoP8ROstj17DiqUZH6PzQw+TrCmvfpa5J1eI5fJQmrlnV6hD058Fn
WJvH3qax9nziN6y3+wzy4tQ1pNrpkfFb2wjene8z/wM/OPXbrS5wr1KNqjbV
s84jfyTnXlPP2p/YT0x99n+xP4Y8A34OvjHPZ5sFbS/wGUexnznovJDnHP6G
7oSca2OKeoh6H9SU8Rt7HX4QMQ5F9rEY3BN6qMBvZhiyLan3ckT3h+y1rGtH
NTw08Zl0lsc542zk25B/hqyJtQJsnwUvz/gN6e7Opu5NusPbU8eQb/Vw6d7G
2vV829wKfwc+i5Ffy3et1Me+W91hbeqYiqWe+23iHq/erpxPSd2j1ZsDeAXy
tbHfjnrycfyVx77bC5FrqSznXquaWoT9YtWEahUXA+EHpb5bvRnlqgifvfKd
s0ZkDanvZik6HcgOxJ4FurMucGfiXiqf7cT7AeqIfGfqXboz3ZV6mGp/U+K3
ojewA34nlJfvmTMu5x6m3qWZtlX9F2rJuKfXorswce9Qj+lQ74BqIs8E5XZt
6r0qx0+w1zbsL0V+E/2wPRU795qvrcgqY9e6dNYib0hcm1XoH9F8zPktakac
QH9c7NpQfkvhL2T91tQztddPib8n4z2rdqpyfquqocmpZ4xmi3quemlD1r1F
PbURf9ezvlvNoM3gVvYzIPIbrUw9UzRLlLMNyL9B3j/yDJ+q94n8YOScqFc2
5txb1DNbUs9QzU69Gc2y3rF7g2aaZq3+GPpbaOb2Rv/72H+PCepRsf8oyp1q
+n29P2z2R54RJ7OuQeVGf4C52M9JPbt0hoPIDmTdyzUzNYsfzHkWaSbfm/iO
5F81WK33Frs3TYf2g/elrl3leBu2lVnPep1Zs+N04r+AZoj2Jh//2yJ/MvYM
1+xWjapXbMm5l6tnjI19x9q/ZuZ/2vNjeA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 0.85, 0.85], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mGuUl1UVxt+Z/+193/+nNJVuq0xrra5CENAFhkuaWau1FLKSEhhwiPtl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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsllUQhr+2f/m/8/1XooiaGKMCLqzeAIoou4heGEAwgkBZypawF8oq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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.94, 0.88, 0.94], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2Q1lUVx3+7z/Ps89zfE2lNQc04IaCOxosoI6BAIFIa1gwuZDqjyPuu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmeMlVUQhr97717ud74rMUYFTUyUooFEpLkQQToRAU0UwUCUvsCyS1NQ
ysLSQRMiSlVhTVj6oggrRUGaFBUQ6cREftgiKog/DJ3o8+blxyQzZ8qZM+ed
OafOoNE9RqWjKNoCFUALkiiano+iz7JRNIeFZSGKPoRK0L2TiaIW8P1yUdQy
FUUHodbIraDa6J9A3xZdjhiX4esS4704iq4h5+FnYDOa2M1YW4e8FqqL7inW
XocfRiJDkYugLPzL7D9D+xNzFHvdzdomfDdDx+D/Ze0UvqehqTWITfwnsd2P
z3r2v4H/VmxHQB/Dn8TnArG3I9eBv87an9jvwr8N/iniDUdXDi1CfxQqgi+G
JsMfgWYSux4+F/Gdyh7D4DsG16Jdynuthnanvef36E5B1diWoy/E/jDyJ8g3
0VfCr4BKVXvWFsSumWqlHLuRb3doMLrOrI0h14Xo341cwwTfPFQT/VLivwVf
nz0uqXasXcX3CpRkfQfL4ecRYzf8fGwehn8e+zHw3Vmrg1wX2lvgO65Ed1ox
086/Nnv3Rb8E2xehfsiHkYuo3xvY1Mb2Aag/fCX2HdB1hCZi+xo5r8K+NzGn
pV2jFeQzH/0+9IvZswG+DYOxUIX/LPRboQ3oJkCdse2U910p5gpiHdOdYD+F
td+Rv0TfinwGsd9U+BdYq0Bfjf0i1Q+6jG41clfp8e9KreYgt0u8Jr4R+x1E
PpQY26QetSDWcew3I99C3xO5A9QC+0fVH9i2hLrBPxb5bAH5n4zP2AXfZ4J1
rVnrBF+cM3ZOQAuwvx/72+gOYd8LfU+oMHLMHjn3mHpLdz6WpLbFxnZ1ge/m
LP4/FPiOusK/in9vbAtZW594D8WuQG4L3w56Ezli/+axe1S9uT5rrFzH/3zG
mHmIveepf9PuwceJ1yjxWTQDeqF/JG9s/Iy8H909rB1IGVOaLb8S71DGM2YJ
8tK88xc+pqJ7H/uR2NdkrRX8VdZ+xP5B7GsR715oVNY1Ui8sgtqn3ROzsX07
GPujU8bChZzPJkysjV0z1WoPPtPhn0U/IPLMEVa0p/YSZrrDN895VixLu7fm
47Mh7R5LyKUGVJr1HXcRtmPPph7EXEkuq4J7ewTyFGwnJ8aqeqoh+TWAuqSM
wSvYLkw8e4uJ2YR4Q4hXhu2StHu5aWzsqqfrIFclvsuxyNeCZ4JmgWo2Bdu5
0Mq0Z1qMba3g3tSM/hR+k2Ys/KjIs20O8vSMZ9x6+CpoCfJI9FvhtwTbfsRa
G3J/Ou+7E4aGxp6ZmpXKWb1+EdqRcs/vxHcPtAbfMtZuYrsPee0duQz5OPHG
cVcvEfMo/GDWxuM7nLWTyNuC99bML+M8k1TTlGfAEfQDYr8Fw2p4NvWNPQs0
o4bBNyWfqgLP9K+ERZ0x4xi30H+DvOGO3AfbNfEdrKRdy0us7Uy5prr7isSz
VBion/hOdBd3sbadWDuglcSbhM958ilM3OvLNaNin1FnGxO5lxvnXE/1xLf4
fgdtzBgzwn5l4lmpHhiXc0zFEoamYzsr+G3Sm1mXeIOlzxrj5xJjVNjUjHgF
2/aJZ11/bJaiKw/uvRH4v4duWt6zUz02IfGd6a5K8BmfuEfUG8XIE5Gfy1lX
CjXTPCbeavK5hnwi+E3UW6IZeiT4jDqb3sQDwXei2usN3xWMGe2nGJ8H11S1
rMx4FmnGabZpJhXlPYM0eyrI+YvgHLS37qADth2hPhnP1HPYn8k71kxqeB+6
5sgjs37Dvg4+k84iTJQgDw/Gpt7kdcJucG+rRzQbhiT+u2hGCMuTY7+NwvTA
2BgVNoXpQfgODH7bldNG/Q2Ce009qb/RT+RfnfIfaXfwH0d/G/WQsHw279yF
6ZHqBeWMrl+B775e7FoIA3/njGlhWRj+DdtfoKKsZ/KN4Bmk2aOZvxy+Ivjv
pz9Kaew/kv5G5Wm/zSWxeb3RfYMxJSzpzZmiuwvGknKqxr5e4t5YAx0NflP1
lgrj+ov9kXMv6E/2V84zULNPM0R3cybnv4Hu6GDwn0p/KfXwB5q/wX9FvSGN
4ZsEv82q4d5gzAqrmjlzg98MvRWaefobLM777dMf4SS6lsS8XXDnD4fvf7Hx
qz+Tajc78d9ENfwfZ4Z+IQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 0.85, 0.85], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2QllUZx+/n9X7u+yanHATLEt2FBpqcBRYY8YPl4qjYiwjhjgiYJFCO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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhjf3nttzzzlKjMFClAgUgkUhIAWCmjiAQR7USqtUoKIC4hBp
mVRkaAuUQYkTKTLE1CgalVkRjMEYBwKG6UEZRJxIEA08GCEGhAJ+f34e1s1e
+19r7bPXXutft9u4+qq6XAihFYmQrVkIl9IQGlBKSkLYzfoe9poKIZSxV5GE
MACZjNPmdiFUxSFk6FfkQ9iAf1kxhOHsrQKPkOfwbSPGbHzXEuM39NvRf8S3
lfgZ693Yr0avxr4L/nXEe4Z4lfh8C74d6Y2OWejMz8fY7MV2KHoRLE59dgds
5uK7CpsG1nOQ/8CmceYazu6Pzxqwi/hHYF8gO8BexmYR59fwPXfh/w36l5w9
GPwP1k3szWZ9kr2F2M9DhhBrKzFPEetxbKrA2ti7AdtDnHEJ++uRGmz3g58i
/lLsB4H/A16KfR/woejn0OeC3Zp37l/AZ13Bb9CZdS9suoANZG8u5/VAaiLn
uJvOx2YV2FBkE3opcnfkHI0Gexg5zfkt4O/q28ALxNuM9CX2Ub0h9j3Qv0L/
Gsmxnk9O27CdyTc9C55n7y/WFbGxH4h/MPadddeLeef2I/a25Z3jC+iz8amL
rC9Fvwl5Gn09/j3xPYB92+V8Bb71l8RvczXf+yBYv8TfdgR4C/h54i3gPnne
6w7WdyI14APA+xB7f+K71etNVJvICux/ZW8Y/nuw3xG5ppX7gejdI7/BBdbT
M9fqVcgb6IOJuQC8GTnNegU+s/J+7+3Y/ol8WuIa6Ah+DH0T+r+cOY71eGJU
R36jxtg9oNofAT4D7DB6S4lzvo31fdgs4i492Xsndg6Vu43IWe5yBnk7uOf2
gD0Vu3Z+53tK8e8Efg16P85brNpGmjmrAvw2bM8nzsW14L2wH4E+HH10wXdt
QTbkfOeF+Fbi8xb6i5Hv1hWZnvMdu7EeG7uWq/CvQ78Z/77g05BGYh8jxonI
OZuP3py4N8dyh73Y7i76248iE7F9AnkU7CF8dmL7XeLaaw7uzXKkQ+QeVS9M
SG2rnqjVe6qHue8gZDLf0x+bfjnfaSr6J9hszJkTyhPXoGpPPTYBvHvR3KU7
HiL2wdRvuRJ9Crav4z8RPYf+fOaaVa2qZzukfgPlXjVdwP4n5PO830C1ME53
bOeaqASbRrxh7cyJY/BtVI0RexkxpoJ3BT+ObX3evfNZ0b2nHtqQmaPFzcex
74h9aWIuVA0sV62iz2A9E1nEemHi3DflzU0HdMfIHLUydo2rtsV5xzNzjLhF
Nd6b9b7EtTgJn+nYl2euHfXQHHElMib4zEdY1ybmavXoa9jXJ86dcvBKbA7V
eeL8xWAvJf421cB6vm1d6lnTSvxJYEvwGY8ecubSIezdkjeniutqM+dOnHeC
9cnM3D4I+xuJ1St1baiG+oD1ztyLI3Um2GPI/ZHPENc3I1sK5vwrOat94lkl
TlFvDEbaF9wjDal7WL0rjh0Ru+fUa6059/q9sWtZPa/ZVpa5dzTj3kN/H3kz
8kxULYzMPDtUE2fAzqbmTvWYemdi7FmlHtKsFUeKGzVzNQuaiq5dzYTDiXta
vayaVG82JK4N9ehw9FGJczEgcu29iv+anGtwsuo1cS2qBy6m/s+g/wqaoWNT
z3DNbuVQ3PI3+Pcl5ph5iWeqZqlmdDW2a1O/7U7u2Cn1ntaaofMz51C50xus
Fh+BL4+cozmpOV9crxlzLvXM16zXm/ycmNPF5ZpJHxLrSGIu1Ay5Dn0J/h/k
3AOzUte4alszb1fqHlNvqUfFHQsyz35xiL6lY+rZp29SLOVQuVPMstQzXLNb
M7YlM0eKG3exV4H9lMu6OOrJ2Jyut1RNN+q/V+bZI87X7NpXNFdqhultRmWe
7XojxVqWObZiKvcPJJ6NeoP/AaiCQ1U=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.94, 0.88, 0.94], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMVdUVx8/lnjvnnnMY6COghqZKFCion9BYlIdYFBKHmVG4UAqxMFKL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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtsX3MYx8//0p7/OaeXLGxTJSEys5kXaDNBZ3XZlqDtlm7L1pmuYSas
tdYlISyx9a4IEfbKxCUorxTLLowObbcuSNqaa9zatbNQSxATfL759sWTPN/f
cz2/33M55zc0rWpMB0HQDWWhs6MgGA6D4FQmCOZAZbkg+IqzvfAPodCKbIqz
PzHaxFk1sjS4NS8IloNPJkFQDP0OP5AfBH1xENQh34Z+MfZb0T8PvBJ+Czq9
+MtxlsAfgC6D/ym07oXg4+B8/JXifwjcib/TUDH4YXQG8TUAfYv/76BHsO0E
j6WCoAZqA58A/4WsAfud4OPgP8D14G34/x5/P+OrEbyWWGugDdiOcLYefh1U
w908Tcw89NvRfxBZhP5B+PcUD3/7OBuFbwl9F+OcVaE/iM4hZDdwtjSyjXQX
Zxy7ibO7M85hiljl+KgmVj/3FyF7F39HMr6jCfDboe9iELoV+8fAd8LXYB8i
fwv8CTiGDuFvEzq38T1V+LsEvB6d1cg2EuNGcES8LvgO6E10e6Et5P581m/T
Bd6edXx9y1DOd61vyo/8JnoLxVMtLAEvyromPoAvR2chsv2cnSLea+TXRj4n
yWc7/KLEucgmhX0FNhNpv+Gl2P6ATuFMPZTCj8R+m2t5k47YNara1Jvsh78F
nYvRHdWb6/uhFHwt8mHkR6FP8b0k5btYF9mX7mRDaB+yVc5r8H8muBLbpdC/
sWtWtTqLnBNwAf4vgJ/mbES1Hvqt9f7XwBchn4f8BWL0hX4j3dUA9CL2L0PP
4bse/R9D94C+tYiz5tA1JV/LOJuP7m+cHST3BeC/wVeAn8J3ITE6idWRONYe
cA/8Tux3of8+eAf8o9Dj4OvT5rvQ2ZvnsxL81XK2W28BtSFrhXqQ9eVZNi92
btK5CtyeOJZ8FCCr4ezDPM8Q9ebtoWtdPXouumV833zwYnTuA9+rs7R7+nV0
v0FennaNvIS/UvDcjO+oC3/T6E9SO9PIv0C/DNyE7S7kQ7HvTHf1EfjryDWn
WlOMZnALtDXjnt6Ifn3s3vkv5dxfie1L37BD95f423ejfz/8A4nfXjm+E7on
1YuHoT2he1a9Mgztw19d6LdSTfXAN0aOpZ58hlhX5vwW6tnPwf34v5l8ryOH
CmTPxva1Ap1KbDeHrt1+qBDd5Tm/rWrsGPIvI88m1cRZ2I6h35tyT98k34l7
vRL5Mtknviv1xCi6c2PXomzuwdeToWej7uwX1Q74roxn6iS4O/Qs10ydBd4c
eTdUZL0rVsfuHe0Mzd6V4Kuz1l8If1Hsb5md9bfPzvltdQevhp4x6hftIL31
sdC1qTeP1cvYHwV3g1fFzkGxFUOzf23su1S+mpWTM/NfM3MK3yE+z8nzjP0M
3Tmh70Y+nwj9zbLVjNa3N8SeJboD9VarvjHtHtOsuCPyrtHMKIE/HHo2aJ9q
lr0Re7Zqpp2Bfm3sXfRryrlMRq4l5TSW80xR/2smtmNfnfhb61KePUXoF2c8
g+q0uxLvKu2wAznXoGpPO+pI6B2vXLSjP0b3ROJdoxlfiKwAKsrYp2bpgthv
o5mqXTweeXZpJ6s3S2b8qUfHkU8k3jWauZdHnuGaZ+p59a6+Qbmrh6sS72zt
au2gZnBL4lmmmbMi538K/Uvojv/B1+nIvagc/wf6BxwL
         "],
         VertexColors->None]}]}, 
     {RGBColor[1, 0.85, 0.85], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl0mMFmUQhnvm7//v/rthEBGNogdjFNCDgg5ByTAEGXBDFEcWPWlcYmLc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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlU9sVVUQxs+77z3uefdB+WMwURMTFkKBBYKBBGgtiS2gWAyltKWuNAgx
MajEnbBCoG0i0IQ/CRsgorgwxoRqW4wVLP8DVEERErBAaVEjyAZYAf6+fC4m
me/MzD0zc76ZO+nt9xvWJiGEtUgBmVUOYSAN4X4+hPeKIfxdCqEb3JkLYRGO
x9GTLIRh7LeROfg/C04I3oNcQG9GWvG/AJ4bQ9gB3oLezfcuoq8gplM6Zw3g
ZUgL/neRDP83sH/BXUPgh+i9yDpwibur8A34TCN2KlJPfqc460evJZ/rigW/
hf9no0JYgu955Y+9OXHux8AjeddwCPwmPl9iP6hvgAvgF9FnIBPxbQMfIPYG
+SzEnoJnYZuJ1HB/H2e96HP43nL0Cdi3U9/LnH1KPovAjcTvQ5ahH8zcq358
5oM78NmLrQ7JRdeo2qYX/O3DnP2W+I6j5POIOwe56wYygdgcPrfQp/G9JvUX
WUmu9/Rm6DE695eIHyZ+HjEf4bsf/Ae2VzLX+g93nAafQQbwr0Z+QO9DjqLP
RrYSOw6pJP4I8iOxk1Uz8YeRZ9CvcMdX+L7L95bgW4+043uTs+fL7rl6Pbfo
XrZQT2PePVVuI8RXpM5xNL7n0A/k/KbjsT8uufap2PuxPQHfzLsHS7GXou/6
PHGum6J7r5zFBXFc3BYnxMWJ0VwVJ2uxP40MgHcTM4itLvNb3wGvT30mfTn3
bQBfB99NXEOXuEU+C8Hbcq7lQdncVU3iVnPJseLYCvDXmd/iVNHcbo/OXRyv
IWYn+BvwZOyXU3Nc3FaPxf2T2K8lnoFPsDdyVlPwTP3JXd9ytj3nnL5D/6vk
WdZZD3g3/h0Fz/govvUxZw3kNwjehL665NkUp37HXp2Zm3XgMeRSUXZu4vgQ
/i9kfvsu7GfBY7FPKfoNF0dzSNzRWQ+4FZ9K7vtV+wW8KvUsXQXXR+8c7ZpW
8Gb0NSVzWztGu2c238sXvIMu4v9B6l1wK/HumcdZW8E7SFz5CftQ3pzZif1Q
6reSTzW+uzhrL7gnyu1fpC/3f47Rd+jbw8gU7Y/Us/EU/r3RNakWzeyJ6JpU
i96oS7OaujfaOR3RO1G7UDtPXNLMalbFqY3RO1S7Uzvi9bI5Km5qpn7B9+fM
u1Kc1W44Io7kvSP0lppxzbbedCn2D1O/nWZ8Afid1LOuGR+TeUdpN+kfkM+8
Y7RbtDOfy8xZcVU91+zfS127dsCT1D1Sby6pJ9E7UbtQnAyZZ1izqzdoR99S
9u7rLZrrbWXr4vyriueb+9GbEu/ix6m/rZ2st6ri7Pui30y+C1LvesWoF69F
x6on/wHK4Ox5
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.94, 0.88, 0.94], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlsFvVVUQxs9t6bu377W0r7XJq4b4XiGRRGPRqE1ME02s1rbURA0RDdKE
uHKh7NW9iX8C7a4gG01EScCFlFdR2UBBl7SUBdoUEmmb0FYi+H2ZX+Nics6d
O2fuzDffzLmNY5++80lLSmlJ0ip5UrIlqUtGspRGSykNpFjflDyn/b/tKV3M
UzqRhd1YKc6NFynNoR8vhX5Q+g+1HpF8l0I/IXlW+4PY2aYLmzP4G8dmWT6/
kM+3snhvX/Z/U/rPpZ/Ufkq6o5LvnYf0n+Xhu5lCP5/i7FfE8LfefyB5QTbV
ihTllA4LhH69H5JcleqRcpyXzbRsOiSz0s9J3yLbS9LPSPcNetv/ru/+UQRm
M8TkePz+JGcfL8U3jLV1pyTHWuKbpyUfa39OPs4XEdudtpTutkXuPufzZ7V/
Vd9/N49cntLzoKRX8iAFlnX0T0tuaf9aOXAxJg917ssi6nhJ6y+SYelXiM25
ON+/2A8Rl/eHZPtEOZ5t6zO1UtiuYL/zvECOzs+5v62zneV4dk3uU5dT4GMs
rduU/CB9j+rSKvv3W6IGXo2n309h001NzZ19snlG8lgW2IwVgY9tqtTdtt3s
V4jT8ZpDS1lgdzILmznsj+D/PfFhVxF2udY3FNtyFrXxeiDFGdteTGE7Ug77
w+1xxnaup+tq/AvpRsvh4yetr8juQha199qbojZXsujB32Qz2R7P54XPZiU4
MQVuR8HbOTiW+3r/Zx6cuaJ1ooh3rp/xdr1etA/5Pd4WvOjLI7bL+DWXf86D
99438+iNafrRveiedd97Lpwg1lX5a2hd1LrUFjn16PlGW+T1fCVicjw+4/47
wznjc4CZ5PrcTOHDvnbhYxE/W8ys7hTnVsHWvhyjOTPBPDH/vy0Hj42Bsfd8
Mf6n6f2z1HISPrxejlnjZ/f3ozx6/A59adudmDw/Xbdhauc6jYDH1+XoAddn
W88b9Kkxvgyfh7H12YZ5JrmWgqfuyQV6s5N9Pz1fp++9dzzOuURd9mSxb+L3
nxR1yPFjrq5L+jwLsc/R9zBXlpkn3lt3nXeO7V6KnvMdUsvCv+tu3r1cCTyv
5lFv19qzc7IILj1sj/nr2rt33cNZCj6+VAlOup6j3DvmQRfxdBKncXAcu4nL
uHWhn0ff5FyDmD0Xnc9eyVqK794Dg3XwMa+2wXYfc8U2/cyMJXw6pgXwWCaW
/eSyBi99rkq9NsCnFdyNm3G6TZ/2YVNFtvCxycx0j28QWxVfxnyAmjbI3XnX
yX2QfG/Buz56cS/6HurdwdzIOXsNe9e1Aaf2YJuzb8K7/uz/WGr430Bf56x5
2QSPFuL3Xb/D3zXeOd9fi5h37qEqc9v88d1e4i5zjq7xdfjQQWx1uNFkv5tc
fM/Mctd0oXPNfixi/l5gDk3TO93M/jk4sB9++j/InByBQzs9UeL7PjtLz3rG
umZN+nKM/xrPLN9pM+DygFq6f1eZf34+nse/hb9V41415zxveuCR75VJZpHv
m4PMLv/jnONfYh28jbtj9zcG4GArnK/BPe8XmdmeGV38lzm3If4TzNWP8viH
GKbve+FhVo772/nZzw3m9jZ8dhz/ARgzN38=
         "],
         VertexColors->None], 
        PolygonBox[{{2123, 2999, 1553, 421}, {3054, 2124, 180, 1737}, {1858, 
         3001, 1562, 222}, {2628, 2627, 332, 478}, {2573, 1999, 421, 610}, {
         3016, 2122, 411, 1629}, {2125, 3054, 1737, 413}, {2010, 3041, 1702, 
         429}, {2992, 2056, 334, 1516}, {2021, 3043, 1704, 437}, {1813, 2992, 
         1516, 49}, {2630, 2629, 333, 480}, {1987, 2561, 601, 412}, {1917, 
         2392, 480, 334}, {2989, 2031, 308, 1502}, {3041, 2727, 610, 1702}, {
         3063, 3062, 437, 1562}, {3010, 2053, 46, 1611}, {2121, 3016, 1629, 
         177}, {2587, 2011, 429, 618}, {2047, 3009, 1608, 324}, {1985, 2558, 
         600, 411}, {2367, 1892, 316, 447}, {1808, 2989, 1502, 4}, {2381, 
         1904, 324, 462}, {2054, 3010, 1611, 332}, {2999, 1856, 177, 1553}, {
         1916, 2391, 478, 333}, {2563, 1988, 413, 601}, {2560, 1986, 412, 
         600}, {2233, 2234, 447, 308}, {3009, 2046, 49, 1608}, {2870, 2010, 
         429, 1392}, {3043, 2734, 618, 1704}, {2246, 2247, 462, 316}, {2011, 
         2869, 1392, 429}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1808, 2989, 2031, 1882, 2232, 2233, 2234, 2750, 2367, 1892, 
         2245, 2246, 2247, 2760, 2381, 1904, 2259, 2260, 2047, 3009, 2046, 
         2184, 1813, 2992, 2056, 2631, 2272, 1917, 2392, 2055, 2630, 2629, 
         2271, 1916, 2391, 2052, 2628, 2627, 2270, 1915, 2054, 3010, 2053}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1858, 3001, 3063, 3062, 2022, 2874, 2021, 3043, 2734, 2133, 
         2587, 2011, 2869, 2586, 2870, 2010, 3041, 2727, 2129, 2573, 1999, 
         2866, 1998, 2123, 2999, 1856, 1875, 2121, 3016, 2122, 1984, 2557, 
         1985, 2558, 2833, 2560, 1986, 2559, 1987, 2561, 2834, 2563, 1988, 
         2562, 1989, 2125, 3054, 2124}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2066, 2643, 2067, 2644, 1924, 2280, 2641, 2642, 2065, 2406, 
         1925, 2282, 2645, 2646, 2068, 2407, 1926, 2283, 2647, 2770, 3011, 
         2069, 2901, 2771, 2186, 3057, 1927, 2895, 2058, 2768, 2769, 1814, 
         1860, 2892, 2893, 2891, 2057, 2894, 1918, 2185, 2048, 2620, 2049, 
         2621, 2263, 2261, 1905, 2382, 2761, 2250, 2249, 2248, 1893, 2368, 
         2752, 2238, 2237, 2235, 1883, 2599, 2032, 2598, 2751}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2108, 2710, 2109, 2711, 1976, 2313, 1975, 2538, 2823, 2537, 
         1974, 2535, 1973, 2536, 2822, 2534, 1972, 2311, 1971, 2709, 2106, 
         2708, 2105, 2179, 2178, 2954, 2107, 2951, 2953, 2952, 2197, 1855, 
         2830, 2829, 2119, 2957, 2180, 2181, 2832, 2958, 2120, 3053, 2831, 
         1996, 2330, 1997, 2572, 2128, 2726, 3040, 2008, 2868, 2009, 2585, 
         2132, 2597, 2019, 2354, 2020, 2740, 2139, 2739, 2846}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2080, 2413, 1931, 2281, 1932, 2655, 2656, 2654, 2079, 2414, 
         1933, 2290, 2657, 3012, 3047, 3046, 2081, 2913, 2914, 2659, 2658, 
         1934, 2284, 1935, 2415, 2785, 2417, 1936, 2416, 2419, 2418, 1824, 
         2190, 2905, 2906, 2904, 2908, 2907, 2175, 2902, 2903, 2772, 2773, 
         1819, 2187, 2632, 2393, 2394, 2861, 2860, 1919, 3039, 2622, 2050, 
         2383, 1907, 2262, 1906, 2762, 2990, 2763, 2887, 2886, 2764, 2254, 
         2253, 2251, 1894, 2369, 2754, 2600, 2602, 2601, 1885, 2236, 1884, 
         2357, 2753}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2101, 3050, 3051, 3014, 2698, 2312, 1963, 2814, 2998, 2815, 
         2935, 2934, 2816, 2525, 1962, 2302, 1961, 3059, 2524, 2813, 2932, 
         2933, 2812, 2997, 2811, 2697, 2310, 1960, 2523, 2100, 2696, 2695, 
         2309, 2522, 2521, 2694, 1871, 1848, 2810, 2809, 2931, 2930, 1970, 
         2949, 2950, 2946, 2948, 2947, 1873, 1851, 2555, 2556, 2316, 2317, 
         2318, 2828, 2571, 1995, 2329, 2331, 2724, 2725, 2723, 2127, 2583, 
         2006, 2343, 2007, 2584, 2131, 2731, 2733, 2732, 2018, 2353, 2355, 
         2356, 2845}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1809, 2755, 2756, 2850, 2849, 1886, 2358, 2033, 2370, 1895, 
         2252, 1896, 2371, 2042, 2613, 3037, 1908, 2856, 2857, 2385, 3055, 
         2384, 2889, 2623, 2624, 2395, 2397, 2396, 2633, 2188, 1820, 2225, 
         2224, 2070, 2176, 1863, 2775, 2774, 2909, 2071, 3044, 2848, 1877, 
         2916, 2083, 2915, 2082, 1864, 2177, 2084, 2660, 2662, 2661, 2191, 
         1828, 2440, 2441, 2437, 2439, 2438, 1827, 2435, 2436, 2433, 1946, 
         2434, 2789, 2432, 1945, 2291, 1944, 2431, 2788, 2430, 1943, 2427, 
         2429, 2428, 2669}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1857, 1876, 2352, 2351, 2017, 2873, 2594, 2844, 2345, 2344, 
         2342, 2005, 2867, 2580, 2838, 2328, 2327, 2326, 2568, 2567, 1854, 
         1874, 2315, 2314, 2552, 2551, 1850, 1872, 2943, 2944, 2705, 2104, 
         2196, 2195, 2928, 2098, 2927, 2099, 2929, 2965, 2963, 2964, 2926, 
         2097, 2806, 2807, 2808, 2193, 2194, 2091, 2231, 2792, 1843, 1867, 
         2679, 2496, 2497, 2299, 2680, 3033, 1868, 2681, 2503, 2504, 2300, 
         2682, 2683, 2092, 2510, 1953, 2301, 2684, 2685, 2093, 2516, 1954, 
         2303, 2686, 3003, 1869, 2847}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1810, 2757, 2758, 2359, 2363, 2362, 2885, 2604, 2605, 2372, 
         2375, 2374, 2888, 2614, 2615, 2386, 2389, 2388, 2890, 2625, 2626, 
         2398, 2402, 2401, 2896, 2634, 2635, 2408, 2410, 2409, 2648, 2171, 
         3024, 2172, 2140, 2142, 3018, 2141, 2182, 2023, 3004, 2024, 1878, 
         2878, 2879, 2875, 2877, 2876, 2966, 2967, 2229, 2156, 2213, 2212, 
         1880, 2028, 3006, 2027, 1840, 2149, 3021, 2150, 2148, 2152, 3022, 
         2151, 1841, 3030, 3031, 3029, 2488, 2487, 2490, 2489, 1842, 2492, 
         2493, 2491, 2495, 2494, 1844, 2499, 2500, 2498, 2502, 2501, 1845, 
         2506, 2507, 2505, 2509, 2508, 1846, 2512, 2513, 2511, 2515, 2514, 
         1847}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2672, 2458, 2459, 2457, 2461, 2460, 1832, 2465, 2466, 2464, 
         2468, 2467, 1834, 2471, 2472, 2470, 2474, 2473, 1835, 2477, 2478, 
         2476, 2480, 2479, 1836, 2484, 2485, 2483, 2486, 3026, 3028, 3027, 
         1837, 2144, 3019, 2145, 2143, 2147, 3020, 2146, 1838, 2025, 3005, 
         2026, 1879, 2883, 2884, 2880, 2882, 2881, 1839, 2230, 2163, 2215, 
         2214, 1881, 2030, 3007, 2029, 2183, 2173, 3025, 2174, 2153, 2155, 
         3023, 2154, 2741, 2692, 2693, 2531, 2533, 2532, 2945, 2706, 2707, 
         2550, 2554, 2553, 2956, 2716, 2717, 2566, 2570, 2569, 2959, 2721, 
         2722, 2579, 2582, 2581, 2962, 2729, 2730, 2593, 2596, 2595, 2738}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1831, 2455, 2456, 2453, 1950, 2454, 2791, 2452, 1949, 2293, 
         1948, 2451, 2790, 2450, 1947, 2447, 2449, 2448, 1830, 2445, 2446, 
         2442, 2444, 2443, 1829, 2208, 1826, 2228, 2227, 2161, 2207, 2206, 
         2918, 2085, 2917, 2086, 2919, 2074, 2975, 2160, 2974, 2159, 2202, 
         2203, 2072, 2226, 2776, 1821, 2189, 1815, 1861, 2274, 2273, 2400, 
         2399, 1811, 1859, 2265, 2264, 1909, 2858, 2387, 2765, 2258, 2257, 
         2255, 1897, 2852, 2373, 2759, 2241, 2240, 2239, 2361, 2360, 2603}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1833, 2462, 2463, 2294, 2670, 2671, 2089, 2469, 1951, 2295, 
         2673, 2674, 2090, 2475, 1952, 2297, 2675, 3002, 1865, 2676, 2481, 
         2482, 2298, 2677, 3032, 1866, 2678, 2192, 2978, 2979, 2744, 2162, 
         2210, 2209, 2802, 2801, 2800, 2164, 2980, 2095, 2986, 2165, 2803, 
         2804, 2805, 2216, 2217, 2169, 2747, 2749, 2748, 2222, 2942, 2703, 
         2704, 2547, 2549, 2548, 2955, 2714, 2715, 2865, 2864, 1994, 2565, 
         2126, 2577, 2003, 2339, 2004, 2578, 2130, 2728, 3042, 2016, 2871, 
         2872, 2592, 3056, 2591, 2737}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2034, 2364, 1887, 2242, 2244, 2607, 2608, 2606, 2035, 2376, 
         1898, 2256, 1899, 2377, 2043, 2616, 2618, 2617, 1910, 2266, 2268, 
         2269, 2766, 2403, 1920, 2275, 2276, 1862, 1816, 2201, 1822, 2778, 
         2777, 2973, 2972, 2073, 2976, 2977, 2779, 2780, 1823, 2205, 1825, 
         2421, 2422, 2420, 1937, 2423, 2786, 2424, 1938, 2286, 1939, 2664, 
         2665, 2663, 2087, 2425, 1940, 2292, 2666, 3013, 3049, 3048, 2088, 
         2920, 2921, 2668, 2667, 1941, 2289, 1942, 2426, 2787}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2138, 2590, 2015, 2349, 2014, 2841, 3000, 2842, 2961, 2960, 
         2843, 2341, 2340, 2338, 2002, 2576, 2837, 2718, 2720, 2719, 1993, 
         2323, 1992, 2564, 2118, 2546, 1983, 2862, 2863, 2702, 2701, 2941, 
         2218, 2937, 2938, 2936, 2940, 2939, 2096, 2984, 2985, 2981, 2983, 
         2982, 2211, 2691, 1870, 3034, 2690, 2308, 1959, 2520, 2094, 2689, 
         2688, 2306, 1958, 2797, 2996, 2798, 2925, 2924, 2799, 2519, 1957, 
         2296, 1956, 3058, 2518, 2795, 2922, 2923, 2794, 2995, 2793, 2687, 
         2304, 1955, 2517, 2796}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2036, 2609, 2037, 2610, 1888, 2243, 1889, 2365, 2038, 2611, 
         3035, 1900, 2853, 1901, 2378, 2044, 2390, 1911, 2267, 1912, 2743, 
         2157, 2742, 2767, 2198, 2051, 2900, 2059, 2897, 2899, 2898, 2200, 
         2969, 2970, 2968, 2158, 2971, 2061, 2204, 2782, 2910, 2075, 3045, 
         2781, 1928, 2285, 2649, 2650, 2076, 2411, 1929, 2287, 2651, 2652, 
         2077, 2412, 1930, 2288, 2653, 2783, 2912, 2078, 2911, 2784}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2136, 2735, 2137, 2736, 2350, 2348, 2013, 2589, 2840, 2337, 
         2336, 2335, 2001, 2575, 2836, 2325, 2324, 2322, 1991, 2713, 2117, 
         2712, 2116, 2223, 2113, 2988, 2170, 2826, 2827, 1853, 2220, 1849, 
         2821, 2820, 2168, 2987, 2103, 2219, 2166, 2745, 2167, 2746, 1969, 
         2307, 1968, 2530, 2819, 2529, 1967, 2527, 1966, 2528, 2817, 2526, 
         1965, 2305, 1964, 2700, 2102, 2699, 2818}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1818, 2994, 2064, 2640, 2279, 1923, 2405, 2063, 2639, 2638, 
         2278, 1922, 2404, 2062, 2637, 2636, 2277, 1921, 2060, 2993, 1817, 
         2199, 1812, 2991, 3061, 3060, 1914, 2859, 1913, 3038, 2619, 2045, 
         2380, 1903, 2854, 2379, 2855, 1902, 3036, 2612, 2041, 2366, 1891, 
         2851, 1890, 2040, 3008, 2039}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1852, 2110, 1977, 2539, 1978, 2540, 2824, 2542, 1979, 2541, 
         1980, 2543, 2825, 2545, 1981, 2544, 1982, 2112, 3052, 2111, 2221, 
         2114, 3015, 2115, 1990, 2319, 2320, 2321, 2835, 2574, 2000, 2332, 
         2333, 2334, 2839, 2588, 2012, 2346, 2347, 2135, 3017, 2134}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[59]=",
 CellID->471585990]
}, Open  ]],

Cell[TextData[{
 "Both ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " use an adaptive algorithm that subdivides parts of the plot region to \
obtain more sample points for a smoother representation of the function you \
are plotting. Because the number of sample points is always finite, however, \
it is possible that features of your function will sometimes be missed. When \
necessary, you can increase the number of sample points by increasing the \
values of the ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " options."
}], "Text",
 CellID->2695],

Cell[TextData[{
 "One point to notice is that whereas a curve generated by ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " may be inaccurate if your function varies too quickly in a particular \
region, the shape of contours generated by ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " can be inaccurate if your function varies too slowly. A rapidly varying \
function gives a regular pattern of contours, but a function that is almost \
flat can give irregular contours. You can typically overcome this by \
increasing the value of ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->419097597],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->304020836],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->209930736],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->532474771],

Cell[TextData[ButtonBox["M205: Visualization and Dynamic Interactivity",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://www.wolfram.com/services/education/minicourses/m205.html"], 
   None}]], "TutorialRelatedLinks",
 CellID->2573598]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Density and Contour Plots - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/InsettingObjectsInGraphics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 55.9685490}", "context" -> "", 
    "keywords" -> {
     "ColorData", "ColorFunction", "ContourPlot", "contour plots", "contours",
       "ContourShading", "DensityPlot", "height function", "MaxRecursion", 
      "mesh", "PlotPoints", "PlotRange", "plot range", "plots", 
      "topographic map"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Density and contour plots. This gives a density plot of sin(x) sin(y). \
Lighter regions show higher values of the function. Some options for \
DensityPlot.", "synonyms" -> {"2.10.7"}, "title" -> 
    "Density and Contour Plots", "type" -> "Tutorial", "uri" -> 
    "tutorial/DensityAndContourPlots"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.9.5"->{
  Cell[1975, 61, 88, 2, 70, "Title",
   CellTags->{"S1.9.5", "5.1"},
   CellID->14270]},
 "5.1"->{
  Cell[1975, 61, 88, 2, 70, "Title",
   CellTags->{"S1.9.5", "5.1"},
   CellID->14270]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.9.5", 363945, 6694},
 {"5.1", 364044, 6698}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1350, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1975, 61, 88, 2, 70, "Title",
 CellTags->{"S1.9.5", "5.1"},
 CellID->14270],
Cell[2066, 65, 2264, 73, 70, "DefinitionBox",
 CellID->29170],
Cell[4333, 140, 60, 1, 70, "Caption",
 CellID->235],
Cell[4396, 143, 294, 9, 70, "MathCaption",
 CellID->21624],
Cell[CellGroupData[{
Cell[4715, 156, 385, 13, 28, "Input",
 CellID->28019],
Cell[5103, 171, 34468, 578, 204, 8381, 146, "CachedBoxData", "BoxData", \
"Output",
 CellID->17903691]
}, Open  ]],
Cell[39586, 752, 1654, 49, 70, "DefinitionBox3Col",
 CellID->26302],
Cell[41243, 803, 105, 5, 70, "Caption",
 CellID->17371],
Cell[41351, 810, 73, 1, 70, "MathCaption",
 CellID->26576],
Cell[CellGroupData[{
Cell[41449, 815, 433, 14, 28, "Input",
 CellID->373779795],
Cell[41885, 831, 37078, 612, 204, "Output",
 Evaluatable->False,
 CellID->213971876]
}, Open  ]],
Cell[78978, 1446, 1454, 41, 70, "Text",
 CellID->8850],
Cell[80435, 1489, 98, 1, 70, "MathCaption",
 CellID->50967099],
Cell[CellGroupData[{
Cell[80558, 1494, 443, 14, 70, "Input",
 CellID->408299914],
Cell[81004, 1510, 58915, 1126, 204, 14182, 388, "CachedBoxData", "BoxData", \
"Output",
 CellID->99961535]
}, Open  ]],
Cell[139934, 2639, 580, 18, 70, "Text",
 CellID->14636363],
Cell[140517, 2659, 248, 8, 70, "MathCaption",
 CellID->77155740],
Cell[CellGroupData[{
Cell[140790, 2671, 122, 3, 70, "Input",
 CellID->268503839],
Cell[140915, 2676, 1764, 32, 173, "Output",
 CellID->4038161]
}, Open  ]],
Cell[142694, 2711, 305, 10, 70, "MathCaption",
 CellID->30833],
Cell[CellGroupData[{
Cell[143024, 2725, 496, 16, 70, "Input",
 CellID->19711],
Cell[143523, 2743, 31744, 534, 204, 8284, 145, "CachedBoxData", "BoxData", \
"Output",
 CellID->71436831]
}, Open  ]],
Cell[175282, 3280, 85, 1, 70, "MathCaption",
 CellID->168591347],
Cell[CellGroupData[{
Cell[175392, 3285, 389, 13, 70, "Input",
 CellID->298956532],
Cell[175784, 3300, 74520, 1273, 70, "Output",
 CellID->769542259]
}, Open  ]],
Cell[250319, 4576, 612, 15, 70, "Text",
 CellID->18896],
Cell[250934, 4593, 3663, 114, 70, "DefinitionBox3Col",
 CellID->4667],
Cell[254600, 4709, 104, 5, 70, "Caption",
 CellID->7285],
Cell[254707, 4716, 75, 1, 70, "MathCaption",
 CellID->12550],
Cell[CellGroupData[{
Cell[254807, 4721, 445, 14, 70, "Input",
 CellID->306891563],
Cell[255255, 4737, 28266, 494, 70, "Output",
 CellID->233567927]
}, Open  ]],
Cell[283536, 5234, 136, 4, 70, "MathCaption",
 CellID->640505349],
Cell[CellGroupData[{
Cell[283697, 5242, 510, 16, 70, "Input",
 CellID->173812373],
Cell[284210, 5260, 74144, 1273, 70, "Output",
 CellID->471585990]
}, Open  ]],
Cell[358369, 6536, 989, 28, 70, "Text",
 CellID->2695],
Cell[359361, 6566, 984, 27, 70, "Text",
 CellID->419097597],
Cell[CellGroupData[{
Cell[360370, 6597, 72, 1, 70, "RelatedTutorialsSection",
 CellID->304020836],
Cell[360445, 6600, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]],
Cell[CellGroupData[{
Cell[360683, 6610, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->209930736],
Cell[360784, 6613, 414, 13, 70, "TutorialRelatedLinks",
 CellID->532474771],
Cell[361201, 6628, 242, 5, 70, "TutorialRelatedLinks",
 CellID->2573598]
}, Open  ]]
}, Open  ]],
Cell[361470, 6637, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

