(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14349,        535]
NotebookOptionsPosition[      9935,        395]
NotebookOutlinePosition[     12529,        464]
CellTagsIndexPosition[     12438,        458]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Calculus" :> 
         Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Derivatives of Unknown Functions", "Title",
 CellTags->{"S3.5.3", "3.1"},
 CellID->22830],

Cell["Differentiating a known function gives an explicit result. ", \
"MathCaption",
 CellID->24901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], "^", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->28442],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", "x", "]"}]}], "x"]], "Output",
 ImageSize->{61, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->5177]
}, Open  ]],

Cell[TextData[{
 "Differentiating an unknown function ",
 Cell[BoxData["f"], "InlineFormula"],
 " gives a result in terms of ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "^", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->25770],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"f", "[", "x", "]"}], " ", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}]}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->702]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applies the chain rule for differentiation, and leaves the result in terms \
of ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"f", "[", 
     RowBox[{"x", "^", "2"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->1381],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   SuperscriptBox["x", "2"], "]"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", 
    SuperscriptBox["x", "2"], "]"}]}]}]], "Output",
 ImageSize->{113, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->16590]
}, Open  ]],

Cell[TextData[{
 "Differentiating again gives a result in terms of ",
 Cell[BoxData["f"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"f", "'"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"f", "''"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->2237],

Cell[BoxData[
 RowBox[{
  RowBox[{"6", " ", "x", " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]",
     MultilineFunction->None], "[", 
    SuperscriptBox["x", "2"], "]"}]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{
    SuperscriptBox["f", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", 
    SuperscriptBox["x", "2"], "]"}]}]}]], "Output",
 ImageSize->{140, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->8023]
}, Open  ]],

Cell["\<\
When a function has more than one argument, superscripts are used to indicate \
how many times each argument is being differentiated. \
\>", "MathCaption",
 CellID->32179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->16595],

Cell[BoxData[
 RowBox[{"2", " ", "x", " ", 
  RowBox[{
   SuperscriptBox["g", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"1", ",", "0"}], ")"}],
     Derivative],
    MultilineFunction->None], "[", 
   RowBox[{
    SuperscriptBox["x", "2"], ",", 
    SuperscriptBox["y", "2"]}], "]"}]}]], "Output",
 ImageSize->{107, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->20169]
}, Open  ]],

Cell[TextData[{
 "This represents ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[PartialD]", 
     RowBox[{"\[PartialD]", "x"}]], 
    FractionBox["\[PartialD]", 
     RowBox[{"\[PartialD]", "x"}]], 
    FractionBox["\[PartialD]", 
     RowBox[{"\[PartialD]", "y"}]], "g", 
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that the order in which derivatives are taken with respect to \
different variables is irrelevant. "
}], "MathCaption",
 CellID->2327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "x", ",", "y"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->12042],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["g", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"2", ",", "1"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->31310]
}, Open  ]],

Cell[TextData[{
 "You can find the value of the derivative when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 " by replacing ",
 Cell[BoxData["x"], "InlineFormula"],
 " with ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", "0"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->11058],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["g", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"2", ",", "1"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"0", ",", "y"}], "]"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->7926]
}, Open  ]],

Cell[BoxData[
 FormBox[GridBox[{
    {Cell[TextData[{
      StyleBox["f", "TI"],
      StyleBox["'[", "MR"],
      StyleBox["x", "TI"],
      StyleBox["]", "MR"],
      " "
     }]], Cell["first derivative of a function of one variable "]},
    {Cell[TextData[{
      Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["f", "TI"], 
         RowBox[{
          StyleBox["(", "MR"], Cell[BoxData[
           StyleBox["n", "TI"]], "InlineFormula"], 
          StyleBox[")", "MR"]}]], TraditionalForm]], "InlineFormula"],
      StyleBox["[", "MR"],
      StyleBox["x", "TI"],
      StyleBox["]", "MR"],
      " "
     }]], Cell[TextData[{
      StyleBox["n", "TI"],
      Cell[BoxData[
       FormBox[
        SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
      " derivative of a function of one variable "
     }]]},
    {Cell[TextData[{
      Cell[BoxData[
       FormBox[
        SuperscriptBox[
         StyleBox["f", "TI"], 
         RowBox[{
          StyleBox["(", "MR"], Cell[BoxData[
           SubscriptBox[
            StyleBox["n", "TI"], "1"]], "InlineFormula"], 
          StyleBox[",", "MR"], Cell[BoxData[
           SubscriptBox[
            StyleBox["n", "TI"], "2"]], "InlineFormula"], 
          StyleBox[",", "MR"], Cell[BoxData[
           RowBox[{
            StyleBox["\[Ellipsis]", "TR"], " "}]], "InlineFormula"], 
          StyleBox[")", "MR"]}]], TraditionalForm]], "InlineFormula"],
      StyleBox["[", "MR"],
      StyleBox["x", "TI"],
      StyleBox["]", "MR"],
      " "
     }]], Cell[TextData[{
      "derivative of a function of several variables, ",
      Cell[BoxData[
       FormBox[
        SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
      " times with respect to variable ",
      StyleBox["i", "TI"],
      " "
     }]]}
   },
   GridBoxAlignment->{
    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
     "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], 
  TraditionalForm]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9487],

Cell["Output forms for derivatives of unknown functions. ", "Caption",
 CellID->1670],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->44741214],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Derivatives of Unknown Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TotalDerivatives"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfDerivatives"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 59.5467656}", "context" -> "", 
    "keywords" -> {
     "chain rule", "derivatives", "output forms", "prime character"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Differentiating a known function gives an explicit result. \
Differentiating an unknown function f gives a result in terms of f'. \
Mathematica applies the chain rule for differentiation, and leaves the result \
in terms of f'. ", "synonyms" -> {"3.5.3"}, "title" -> 
    "Derivatives of Unknown Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/DerivativesOfUnknownFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.3"->{
  Cell[1215, 42, 95, 2, 70, "Title",
   CellTags->{"S3.5.3", "3.1"},
   CellID->22830]},
 "3.1"->{
  Cell[1215, 42, 95, 2, 70, "Title",
   CellTags->{"S3.5.3", "3.1"},
   CellID->22830]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.3", 12227, 447},
 {"3.1", 12326, 451}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 590, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1215, 42, 95, 2, 70, "Title",
 CellTags->{"S3.5.3", "3.1"},
 CellID->22830],
Cell[1313, 46, 100, 2, 70, "MathCaption",
 CellID->24901],
Cell[CellGroupData[{
Cell[1438, 52, 173, 6, 28, "Input",
 CellID->28442],
Cell[1614, 60, 228, 8, 51, "Output",
 CellID->5177]
}, Open  ]],
Cell[1857, 71, 224, 8, 70, "MathCaption",
 CellID->13877],
Cell[CellGroupData[{
Cell[2106, 83, 171, 6, 28, "Input",
 CellID->25770],
Cell[2280, 91, 302, 10, 36, "Output",
 CellID->702]
}, Open  ]],
Cell[2597, 104, 247, 9, 70, "MathCaption",
 CellID->14364],
Cell[CellGroupData[{
Cell[2869, 117, 196, 7, 28, "Input",
 CellID->1381],
Cell[3068, 126, 407, 14, 39, "Output",
 CellID->16590]
}, Open  ]],
Cell[3490, 143, 277, 11, 70, "MathCaption",
 CellID->8823],
Cell[CellGroupData[{
Cell[3792, 158, 116, 4, 28, "Input",
 CellID->2237],
Cell[3911, 164, 512, 17, 39, "Output",
 CellID->8023]
}, Open  ]],
Cell[4438, 184, 181, 4, 70, "MathCaption",
 CellID->32179],
Cell[CellGroupData[{
Cell[4644, 192, 223, 8, 70, "Input",
 CellID->16595],
Cell[4870, 202, 429, 16, 39, "Output",
 CellID->20169]
}, Open  ]],
Cell[5314, 221, 579, 19, 70, "MathCaption",
 CellID->2327],
Cell[CellGroupData[{
Cell[5918, 244, 194, 7, 70, "Input",
 CellID->12042],
Cell[6115, 253, 336, 13, 36, "Output",
 CellID->31310]
}, Open  ]],
Cell[6466, 269, 301, 11, 70, "MathCaption",
 CellID->28182],
Cell[CellGroupData[{
Cell[6792, 284, 114, 4, 70, "Input",
 CellID->11058],
Cell[6909, 290, 335, 13, 36, "Output",
 CellID->7926]
}, Open  ]],
Cell[7259, 306, 2289, 70, 70, "DefinitionBox",
 CellID->9487],
Cell[9551, 378, 85, 1, 70, "Caption",
 CellID->1670],
Cell[CellGroupData[{
Cell[9661, 383, 71, 1, 70, "RelatedTutorialsSection",
 CellID->44741214],
Cell[9735, 386, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[9908, 393, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

