(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39102,       1333]
NotebookOptionsPosition[     33464,       1149]
NotebookOutlinePosition[     35278,       1193]
CellTagsIndexPosition[     35235,       1190]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"CentralMoment" :> 
         Documentation`HelpLookup["paclet:ref/CentralMoment"], "Commonest" :> 
         Documentation`HelpLookup["paclet:ref/Commonest"], "Correlation" :> 
         Documentation`HelpLookup["paclet:ref/Correlation"], "Covariance" :> 
         Documentation`HelpLookup["paclet:ref/Covariance"], "GeometricMean" :> 
         Documentation`HelpLookup["paclet:ref/GeometricMean"], "HarmonicMean" :> 
         Documentation`HelpLookup["paclet:ref/HarmonicMean"], 
         "InterquartileRange" :> 
         Documentation`HelpLookup["paclet:ref/InterquartileRange"], 
         "Kurtosis" :> Documentation`HelpLookup["paclet:ref/Kurtosis"], 
         "Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], 
         "MeanDeviation" :> 
         Documentation`HelpLookup["paclet:ref/MeanDeviation"], "Median" :> 
         Documentation`HelpLookup["paclet:ref/Median"], "MedianDeviation" :> 
         Documentation`HelpLookup["paclet:ref/MedianDeviation"], "Quantile" :> 
         Documentation`HelpLookup["paclet:ref/Quantile"], "QuartileDeviation" :> 
         Documentation`HelpLookup["paclet:ref/QuartileDeviation"], 
         "Quartiles" :> Documentation`HelpLookup["paclet:ref/Quartiles"], 
         "QuartileSkewness" :> 
         Documentation`HelpLookup["paclet:ref/QuartileSkewness"], 
         "RootMeanSquare" :> 
         Documentation`HelpLookup["paclet:ref/RootMeanSquare"], "Skewness" :> 
         Documentation`HelpLookup["paclet:ref/Skewness"], "StandardDeviation" :> 
         Documentation`HelpLookup["paclet:ref/StandardDeviation"], 
         "TrimmedMean" :> Documentation`HelpLookup["paclet:ref/TrimmedMean"], 
         "Variance" :> Documentation`HelpLookup["paclet:ref/Variance"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"CentralMoment\"\>", 
      2->"\<\"Commonest\"\>", 3->"\<\"Correlation\"\>", 
      4->"\<\"Covariance\"\>", 5->"\<\"GeometricMean\"\>", 
      6->"\<\"HarmonicMean\"\>", 7->"\<\"InterquartileRange\"\>", 
      8->"\<\"Kurtosis\"\>", 9->"\<\"Mean\"\>", 10->"\<\"MeanDeviation\"\>", 
      11->"\<\"Median\"\>", 12->"\<\"MedianDeviation\"\>", 
      13->"\<\"Quantile\"\>", 14->"\<\"QuartileDeviation\"\>", 
      15->"\<\"Quartiles\"\>", 16->"\<\"QuartileSkewness\"\>", 
      17->"\<\"RootMeanSquare\"\>", 18->"\<\"Skewness\"\>", 
      19->"\<\"StandardDeviation\"\>", 20->"\<\"TrimmedMean\"\>", 
      21->"\<\"Variance\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Descriptive Statistics", "Title",
 CellID->7135],

Cell[TextData[{
 "Descriptive statistics refers to properties of distributions, such as \
location, dispersion, and shape. The functions described here compute \
descriptive statistics of lists of data. You can calculate some of the \
standard descriptive statistics for various known distributions by using the \
functions described in \"",
 ButtonBox["Continuous Distributions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ContinuousDistributions"],
 " and \"",
 ButtonBox["Discrete Distributions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DiscreteDistributions"],
 "."
}], "Text",
 CellID->31545],

Cell[TextData[{
 "The statistics are calculated assuming that each value of data ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 " has probability equal to ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "n"], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is the number of elements in the data. "
}], "Text",
 CellID->12822],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Mean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mean"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "average value ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox["1", "n"], 
        RowBox[{
         UnderscriptBox["\[Sum]", "i",
          LimitsPositioning->True], 
         SubscriptBox["x", "i"]}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Median",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Median"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "median (central value)", "TableText"]},
   {
    RowBox[{
     ButtonBox["Commonest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Commonest"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "list of the elements with highest frequency", "TableText"]},
   {
    RowBox[{
     ButtonBox["GeometricMean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GeometricMean"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "geometric mean ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          UnderscriptBox["\[Product]", "i",
           LimitsPositioning->True], 
          SubscriptBox["x", "i"]}], ")"}], 
        FractionBox["1", "n"]], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HarmonicMean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HarmonicMean"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "harmonic mean ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", "/", 
        RowBox[{
         UnderscriptBox["\[Sum]", "i",
          LimitsPositioning->True], 
         FractionBox["1", 
          SubscriptBox["x", "i"]]}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RootMeanSquare",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootMeanSquare"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "root mean square ",
     Cell[BoxData[
      FormBox[
       SqrtBox[
        RowBox[{
         FractionBox["1", "n"], 
         UnderscriptBox["\[Sum]", "i",
          LimitsPositioning->True], 
         SubsuperscriptBox["x", "i", "2"]}]], TraditionalForm]], 
      "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TrimmedMean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrimmedMean"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      StyleBox["f", "TI"]}], "]"}], Cell[TextData[{
     "mean of remaining entries, when a fraction ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " is removed from each end of the sorted list of data "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["TrimmedMean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TrimmedMean"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]}], "]"}], Cell[TextData[{
     "mean of remaining entries, when fractions ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["f", "1"], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["f", "2"], TraditionalForm]], "InlineMath"],
     " are dropped from each end of the sorted data "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Quantile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quantile"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " quantile"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Quartiles",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quartiles"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       FractionBox["1", "4"], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     ", ",
     Cell[BoxData[
      FormBox[
       FractionBox["1", "2"], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     ", ",
     Cell[BoxData[
      FormBox[
       FractionBox["3", "4"], TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " quantiles"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->867791],

Cell["Location statistics. ", "Caption",
 CellID->1503],

Cell[TextData[{
 "Location statistics describe where the data are located. The most common \
functions include measures of central tendency like the mean, median, and \
mode. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " gives the location before which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"100", "q"}], ")"}], TraditionalForm]], "InlineMath"],
 " percent of the data lie. In other words, ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " gives a value ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " such that the probability that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "i"], "<", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is less than or equal to ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " and the probability that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["x", "i"], "\[LessEqual]", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is greater than or equal to ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->19196],

Cell["Here is a data set. ", "MathCaption",
 CellID->14897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"{", 
   RowBox[{
   "6.5", ",", "3.8", ",", "6.6", ",", "5.7", ",", "6.0", ",", "6.4", ",", 
    "5.3"}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->19338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.5`", ",", "3.8`", ",", "6.6`", ",", "5.7`", ",", "6.`", ",", "6.4`", ",",
    "5.3`"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->551814487]
}, Open  ]],

Cell["This finds the mean and median of the data. ", "MathCaption",
 CellID->6853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "[", "data", "]"}], ",", " ", 
   RowBox[{"Median", "[", "data", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11093],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.757142857142857`", ",", "6.`"}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->152974932]
}, Open  ]],

Cell[TextData[{
 "This is the mean when the smallest entry in the list is excluded. ",
 Cell[BoxData[
  ButtonBox["TrimmedMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrimmedMean"]], "InlineFormula"],
 " allows you to describe the data with removed outliers. "
}], "MathCaption",
 CellID->12675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrimmedMean", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "7"], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3467],

Cell[BoxData["6.083333333333333`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->273354839]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "unbiased estimate of variance, ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox["1", 
         RowBox[{"n", "-", "1"}]], 
        RowBox[{
         UnderscriptBox["\[Sum]", "i",
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["x", "i"], "-", 
            OverscriptBox["x", "_"]}], ")"}], "2"]}]}], TraditionalForm]], 
      "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["StandardDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardDeviation"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "unbiased estimate of standard deviation ", "TableText"]},
   {
    RowBox[{
     ButtonBox["MeanDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MeanDeviation"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "mean absolute deviation, ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         FractionBox["1", "n"], 
         UnderscriptBox["\[Sum]", "i",
          LimitsPositioning->True]}], "\[VerticalSeparator]", 
        RowBox[{
         SubscriptBox["x", "i"], "-", 
         OverscriptBox["x", "_"]}], "\[VerticalSeparator]"}], 
       TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MedianDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MedianDeviation"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[TextData[{
     "median absolute deviation, median of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[VerticalSeparator]", 
        RowBox[{
         SubscriptBox["x", "i"], "-", 
         StyleBox["median",
          FontSlant->"Italic"]}], "\[VerticalSeparator]"}], TraditionalForm]],
       "InlineMath"],
     " values "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["QuartileDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/QuartileDeviation"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "difference between the first and third quartiles", "TableText"]},
   {
    RowBox[{
     ButtonBox["InterquartileRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InterquartileRange"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "half the quartile deviation", "TableText"]}
  }]], "DefinitionBox",
 CellID->5115481],

Cell["Dispersion statistics. ", "Caption",
 CellID->21020],

Cell["\<\
Dispersion statistics summarize the scatter or spread of the data. Most of \
these functions describe deviation from a particular location. For instance, \
variance is a measure of deviation from the mean, and standard deviation is \
just the square root of the variance. \
\>", "Text",
 CellID->10165],

Cell[TextData[{
 "This gives an unbiased estimate for the variance of the data with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "-", "1"}], TraditionalForm]], "InlineMath"],
 " as the divisor. "
}], "MathCaption",
 CellID->573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "data", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31043],

Cell[BoxData["0.9628571428571431`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->158356093]
}, Open  ]],

Cell["This compares three types of deviation. ", "MathCaption",
 CellID->22427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"StandardDeviation", "[", "data", "]"}], ",", 
   RowBox[{"MeanDeviation", "[", "data", "]"}], ",", 
   RowBox[{"MedianDeviation", "[", "data", "]"}]}], "}"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->12054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9812528434899657`", ",", "0.7061224489795919`", ",", "0.5`"}], 
  "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->480801228]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Covariance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Covariance"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[TextData[{
     "covariance coefficient between lists ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Covariance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Covariance"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "covariance matrix for the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Covariance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Covariance"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[TextData[{
     "covariance matrix for the matrices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Correlation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Correlation"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[TextData[{
     "correlation coefficient between lists ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Correlation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Correlation"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "correlation matrix for the matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Correlation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Correlation"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[TextData[{
     "correlation matrix for the matrices ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->105644373],

Cell["Covariance and correlation statistics.", "Caption",
 CellID->294491716],

Cell[TextData[{
 "Covariance is the multivariate extension of variance. For two vectors of \
equal length, the covariance is a number. For a single matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], ",", 
   StyleBox["j", "TI"]}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element of the covariance matrix is the covariance between the ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " columns of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". For two matrices ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], ",", 
   StyleBox["j", "TI"]}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element of the covariance matrix is the covariance between the ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " column of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " column of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 "."
}], "Text",
 CellID->20957192],

Cell["\<\
While covariance measures dispersion, correlation measures association. The \
correlation between two vectors is equivalent to the covariance between the \
vectors divided by the standard deviations of the vectors. Likewise, the \
elements of a correlation matrix are equivalent to the elements of the \
corresponding covariance matrix scaled by the appropriate column standard \
deviations.\
\>", "Text",
 CellID->552399377],

Cell[TextData[{
 "This gives the covariance between ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " and a random vector."
}], "MathCaption",
 CellID->364927107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Covariance", "[", 
  RowBox[{"data", ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Length", "[", "data", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->45259537],

Cell[BoxData[
 RowBox[{"-", "0.1339577112433097`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->102209794]
}, Open  ]],

Cell["Here is a random matrix.", "MathCaption",
 CellID->460760616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->457378746],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6.649185593003968`", ",", "1.278732447743205`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.1935613595941152`", ",", "8.525639615567226`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.364609926256819`", ",", "6.619785488739192`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.31896801640043`", ",", "8.550702102332812`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.06194699467539`", ",", "4.395582842872344`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.760636792919522`", ",", "3.3079166851558406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.85391538400904`", ",", "3.116343802350099`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.009439261873963`", ",", "5.021288315991789`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5951563774701429`", ",", "5.1499785029988825`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.862024212475875`", ",", "7.89575646016136`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.25356502581751705`", ",", "7.2777591446345635`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"3.3696479611418795`", ",", "5.5813646648785165`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.15740575707745`", ",", "1.9118360098362563`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.8350304149579273`", ",", "8.777923072850992`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.688639382999492`", ",", "6.367780540548096`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.168831538357713`", ",", "4.785222438866905`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.2200298799061833`", ",", "3.784092404357382`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.077133751378378`", ",", "5.460521267714058`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.6271885917581108`", ",", "2.77774807153667`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.3286840842878185`", ",", "7.166978965357336`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{559, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->104425935]
}, Open  ]],

Cell[TextData[{
 "This is the correlation matrix for the matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->45838559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Correlation", "[", "m", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->173314715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.0000000000000002`", ",", 
     RowBox[{"-", "0.1894179586885405`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.1894179586885405`"}], ",", "0.9999999999999998`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->1934190]
}, Open  ]],

Cell["This is the covariance matrix.", "MathCaption",
 CellID->743574628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Covariance", "[", "m", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->422413199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9.050711768736711`", ",", 
     RowBox[{"-", "1.2826915249782158`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2826915249782158`"}], ",", "5.066632587071127`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->592659558]
}, Open  ]],

Cell["\<\
Scaling the covariance matrix terms by the appropriate standard deviations \
gives the correlation matrix.\
\>", "MathCaption",
 CellID->118388862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sd", "=", 
     RowBox[{"StandardDeviation", "[", "m", "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"%", "/", "sd"}], "]"}], "/", "sd"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->42387343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.18941795868854056`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.18941795868854056`"}], ",", "1.`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->741127649]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CentralMoment",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CentralMoment"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      StyleBox["r", "TI"]}], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " central moment ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox["1", "n"], 
        RowBox[{
         UnderscriptBox["\[Sum]", "i",
          LimitsPositioning->True], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SubscriptBox["x", "i"], "-", 
            OverscriptBox["x", "_"]}], ")"}], "r"]}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Skewness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Skewness"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "coefficient of skewness ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Kurtosis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Kurtosis"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "kurtosis coefficient", "TableText"]},
   {
    RowBox[{
     ButtonBox["QuartileSkewness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/QuartileSkewness"], "[", 
     StyleBox["data", "TI"], "]"}], Cell[
    "quartile skewness coefficient", "TableText"]}
  }]], "DefinitionBox",
 CellID->36392028],

Cell["Shape statistics. ", "Caption",
 CellID->21123],

Cell["\<\
You can get some information about the shape of a distribution using shape \
statistics. Skewness describes the amount of asymmetry. Kurtosis measures the \
concentration of data around the peak and in the tails versus the \
concentration in the flanks. \
\>", "Text",
 CellID->9427],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Skewness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skewness"]], "InlineFormula"],
 " is calculated by dividing the third central moment by the cube of the \
population standard deviation. ",
 Cell[BoxData[
  ButtonBox["Kurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Kurtosis"]], "InlineFormula"],
 " is calculated by dividing the fourth central moment by the square of the \
population variance of the data, equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CentralMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CentralMoment"], "[", 
   RowBox[{
    StyleBox["data", "TI"], ",", "2"}], "]"}]], "InlineFormula"],
 ". (The population variance is the second central moment, and the population \
standard deviation is its square root.)"
}], "Text",
 CellID->9195],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QuartileSkewness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuartileSkewness"]], "InlineFormula"],
 " is calculated from the quartiles of data. It is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["q", "1"], "-", 
      RowBox[{"2", 
       SubscriptBox["q", "2"]}], "+", 
      SubscriptBox["q", "3"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["q", "3"], "-", 
      SubscriptBox["q", "1"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["q", "1"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["q", "2"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["q", "3"], TraditionalForm]], "InlineMath"],
 " are the first, second and third quartiles respectively."
}], "Text",
 CellID->124461204],

Cell["Here is the second central moment of the data. ", "MathCaption",
 CellID->1386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{"data", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->3371],

Cell[BoxData["0.8253061224489796`"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->95396259]
}, Open  ]],

Cell["\<\
A negative value for skewness indicates that the distribution underlying the \
data has a long left\[Hyphen]sided tail. \
\>", "MathCaption",
 CellID->31169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", "data", "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->5764],

Cell[BoxData[
 RowBox[{"-", "1.2010831332504142`"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->157049034]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->222795007],

Cell[TextData[{
 ButtonBox["M215: Applied Statistical Analysis with ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->449100321]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Descriptive Statistics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 33, 59.8436482}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Descriptive statistics refers to properties of distributions, such as \
location, dispersion, and shape. The functions described here compute \
descriptive statistics of lists of data. You can calculate some of the \
standard descriptive statistics for various known distributions by using the \
functions described in \"Continuous Distributions\" and \"Discrete \
Distributions\". The statistics are calculated assuming that each value of \
data x_i has probability equal to FractionBox[1, n], where n is the number of \
elements in the data. Location statistics. ", "synonyms" -> {}, "title" -> 
    "Descriptive Statistics", "type" -> "Tutorial", "uri" -> 
    "tutorial/DescriptiveStatistics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2812, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3437, 75, 54, 1, 70, "Title",
 CellID->7135],
Cell[3494, 78, 622, 15, 70, "Text",
 CellID->31545],
Cell[4119, 95, 436, 14, 70, "Text",
 CellID->12822],
Cell[4558, 111, 4877, 165, 70, "DefinitionBox",
 CellID->867791],
Cell[9438, 278, 55, 1, 70, "Caption",
 CellID->1503],
Cell[9496, 281, 1382, 47, 70, "Text",
 CellID->19196],
Cell[10881, 330, 59, 1, 70, "MathCaption",
 CellID->14897],
Cell[CellGroupData[{
Cell[10965, 335, 211, 7, 28, "Input",
 CellID->19338],
Cell[11179, 344, 331, 11, 36, "Output",
 CellID->551814487]
}, Open  ]],
Cell[11525, 358, 82, 1, 70, "MathCaption",
 CellID->6853],
Cell[CellGroupData[{
Cell[11632, 363, 188, 6, 70, "Input",
 CellID->11093],
Cell[11823, 371, 272, 9, 36, "Output",
 CellID->152974932]
}, Open  ]],
Cell[12110, 383, 306, 8, 70, "MathCaption",
 CellID->12675],
Cell[CellGroupData[{
Cell[12441, 395, 201, 7, 70, "Input",
 CellID->3467],
Cell[12645, 404, 225, 7, 36, "Output",
 CellID->273354839]
}, Open  ]],
Cell[12885, 414, 2574, 83, 70, "DefinitionBox",
 CellID->5115481],
Cell[15462, 499, 58, 1, 70, "Caption",
 CellID->21020],
Cell[15523, 502, 312, 6, 70, "Text",
 CellID->10165],
Cell[15838, 510, 228, 7, 70, "MathCaption",
 CellID->573],
Cell[CellGroupData[{
Cell[16091, 521, 103, 3, 70, "Input",
 CellID->31043],
Cell[16197, 526, 226, 7, 36, "Output",
 CellID->158356093]
}, Open  ]],
Cell[16438, 536, 79, 1, 70, "MathCaption",
 CellID->22427],
Cell[CellGroupData[{
Cell[16542, 541, 259, 7, 70, "Input",
 CellID->12054],
Cell[16804, 550, 306, 10, 36, "Output",
 CellID->480801228]
}, Open  ]],
Cell[17125, 563, 3218, 114, 70, "DefinitionBox",
 CellID->105644373],
Cell[20346, 679, 77, 1, 70, "Caption",
 CellID->294491716],
Cell[20426, 682, 1896, 70, 70, "Text",
 CellID->20957192],
Cell[22325, 754, 435, 8, 70, "Text",
 CellID->552399377],
Cell[22763, 764, 178, 6, 70, "MathCaption",
 CellID->364927107],
Cell[CellGroupData[{
Cell[22966, 774, 233, 7, 70, "Input",
 CellID->45259537],
Cell[23202, 783, 193, 6, 36, "Output",
 CellID->102209794]
}, Open  ]],
Cell[23410, 792, 67, 1, 70, "MathCaption",
 CellID->460760616],
Cell[CellGroupData[{
Cell[23502, 797, 206, 7, 70, "Input",
 CellID->457378746],
Cell[23711, 806, 2059, 49, 105, "Output",
 CellID->104425935]
}, Open  ]],
Cell[25785, 858, 166, 6, 70, "MathCaption",
 CellID->45838559],
Cell[CellGroupData[{
Cell[25976, 868, 107, 3, 70, "Input",
 CellID->173314715],
Cell[26086, 873, 419, 14, 36, "Output",
 CellID->1934190]
}, Open  ]],
Cell[26520, 890, 73, 1, 70, "MathCaption",
 CellID->743574628],
Cell[CellGroupData[{
Cell[26618, 895, 106, 3, 70, "Input",
 CellID->422413199],
Cell[26727, 900, 419, 14, 36, "Output",
 CellID->592659558]
}, Open  ]],
Cell[27161, 917, 157, 4, 70, "MathCaption",
 CellID->118388862],
Cell[CellGroupData[{
Cell[27343, 925, 377, 12, 70, "Input",
 CellID->42387343],
Cell[27723, 939, 390, 14, 36, "Output",
 CellID->741127649]
}, Open  ]],
Cell[28128, 956, 1528, 51, 70, "DefinitionBox",
 CellID->36392028],
Cell[29659, 1009, 53, 1, 70, "Caption",
 CellID->21123],
Cell[29715, 1012, 293, 6, 70, "Text",
 CellID->9427],
Cell[30011, 1020, 846, 23, 70, "Text",
 CellID->9195],
Cell[30860, 1045, 954, 33, 70, "Text",
 CellID->124461204],
Cell[31817, 1080, 85, 1, 70, "MathCaption",
 CellID->1386],
Cell[CellGroupData[{
Cell[31927, 1085, 130, 4, 70, "Input",
 CellID->3371],
Cell[32060, 1091, 225, 7, 36, "Output",
 CellID->95396259]
}, Open  ]],
Cell[32300, 1101, 167, 4, 70, "MathCaption",
 CellID->31169],
Cell[CellGroupData[{
Cell[32492, 1109, 103, 3, 70, "Input",
 CellID->5764],
Cell[32598, 1114, 244, 8, 36, "Output",
 CellID->157049034]
}, Open  ]],
Cell[CellGroupData[{
Cell[32879, 1127, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->222795007],
Cell[32980, 1130, 430, 13, 70, "TutorialRelatedLinks",
 CellID->449100321]
}, Open  ]]
}, Open  ]],
Cell[33437, 1147, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

