(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23985,        825]
NotebookOptionsPosition[     18034,        644]
NotebookOutlinePosition[     21273,        722]
CellTagsIndexPosition[     21181,        716]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Aspects of Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Global Aspects of Mathematica Sessions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialog" :> Documentation`HelpLookup["paclet:ref/Dialog"], 
          "DialogProlog" :> 
          Documentation`HelpLookup["paclet:ref/DialogProlog"], 
          "DialogSymbols" :> 
          Documentation`HelpLookup["paclet:ref/DialogSymbols"], "Return" :> 
          Documentation`HelpLookup["paclet:ref/Return"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Dialog\"\>", 2->"\<\"DialogProlog\"\>", 
       3->"\<\"DialogSymbols\"\>", 4->"\<\"Return\"\>"}, "\<\"functions\"\>", 
       
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dialogs", "Title",
 CellTags->{"S2.14.2", "2.1"},
 CellID->32528],

Cell[TextData[{
 "Within a standard interactive session, you can create \
\[OpenCurlyDoubleQuote]subsessions\[CloseCurlyDoubleQuote] or ",
 StyleBox["dialogs",
  FontSlant->"Italic"],
 " using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " command ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 ". Dialogs are often useful if you want to interact with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " while it is in the middle of doing a calculation. As mentioned in \"",
 ButtonBox["Tracing Evaluation\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TracingEvaluation"],
 ", ",
 Cell[BoxData[
  ButtonBox["TraceDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceDialog"]], "InlineFormula"],
 " for example automatically calls ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " at specified points in the evaluation of a particular expression. In \
addition, if you interrupt ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " during a computation, you can typically \[OpenCurlyDoubleQuote]inspect\
\[CloseCurlyDoubleQuote] its state using a dialog. "
}], "Text",
 CellID->5651],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Dialog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dialog"], "[", "]"}], Cell[TextData[{
     "initiate a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " dialog"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Dialog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dialog"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "initiate a dialog with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as the current value of ",
     Cell[BoxData["%"], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Return",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Return"], "[", "]"}], Cell[TextData[{
     "return from a dialog, taking the current value of ",
     Cell[BoxData["%"], "InlineFormula"],
     " as the return value"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Return",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Return"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "return from a dialog, taking ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as the return value"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2258],

Cell["Initiating and returning from dialogs. ", "Caption",
 CellID->7213],

Cell["This initiates a dialog. ", "MathCaption",
 CellID->9860],

Cell[BoxData[
 RowBox[{"Dialog", "[", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->25783],

Cell[TextData[{
 "You can do computations in a dialog just as you would in any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "MathCaption",
 CellID->21286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "^", "41"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->2742],

Cell[BoxData["2199023255552"], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->8610]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " to exit from a dialog. "
}], "MathCaption",
 CellID->4472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Return", "[", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->7128],

Cell[BoxData["2199023255552"], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->18434]
}, Open  ]],

Cell[TextData[{
 "When you exit a dialog, you can return a value for the dialog using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ". If you do not want to return a value, and you have set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$IgnoreEOF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$IgnoreEOF"], "=", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", then you can also exit a dialog simply by giving an end\[Hyphen]of\
\[Hyphen]file character, at least on systems with text\[Hyphen]based \
interfaces. "
}], "Text",
 CellID->5841],

Cell[TextData[{
 "To evaluate this expression, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " initiates a dialog. "
}], "MathCaption",
 CellID->20718],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   RowBox[{"Dialog", "[", "]"}], "^", "2"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->3503],

Cell[TextData[{
 "The value ",
 Cell[BoxData[
  RowBox[{"a", "+", "b"}]], "InlineFormula"],
 " returned from the dialog is now inserted in the original expression. "
}], "MathCaption",
 CellID->14867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->24865],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->10938]
}, Open  ]],

Cell[TextData[{
 "In starting a dialog, you will often find it useful to have some \
\[OpenCurlyDoubleQuote]initial expression\[CloseCurlyDoubleQuote]. If you use \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dialog"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will start a dialog, using ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as the initial expression, accessible for example as the value of ",
 Cell[BoxData["%"], "InlineFormula"],
 ". "
}], "Text",
 CellID->1881],

Cell[TextData[{
 "This first starts a dialog with initial expression ",
 Cell[BoxData[
  RowBox[{"a", "^", "2"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Dialog", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "^", "2"}], ",", 
     RowBox[{"b", "+", "c"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->22750],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->28614]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["%"], "InlineFormula"],
 " is the initial expression in the dialog. "
}], "MathCaption",
 CellID->18598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "^", "2"}], "+", "1"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->28458],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["a", "4"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->2661]
}, Open  ]],

Cell[TextData[{
 "This returns a value from the first dialog, and starts the second dialog, \
with initial expression ",
 Cell[BoxData[
  RowBox[{"b", "+", "c"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Return", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->32756],

Cell[BoxData[
 RowBox[{"b", "+", "c"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->20807]
}, Open  ]],

Cell["\<\
This returns a value from the second dialog. The final result is the original \
expression, with values from the two dialogs inserted. \
\>", "MathCaption",
 CellID->20278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Return", "[", "444", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->19489],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["a", "4"]}], ",", "444"}], "}"}]], "Output",
 ImageSize->{83, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->19435]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " effectively works by running a subsidiary version of the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " main loop. Each dialog you start effectively \
\[OpenCurlyDoubleQuote]inherits\[CloseCurlyDoubleQuote] various values from \
the overall main loop. Some of the values are, however, local to the dialog, \
so their original values are restored when you exit the dialog."
}], "Text",
 CellID->6365],

Cell[TextData[{
 "Thus, for example, dialogs inherit the current line number ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 " when they start. This means that the lines in a dialog have numbers that \
follow the sequence used in the main loop. Nevertheless, the value of ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 " is local to the dialog. As a result, when you exit the dialog, the value \
of ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 " reverts to what it was in the main loop. "
}], "Text",
 CellID->32075],

Cell[TextData[{
 "If you start a dialog on line ",
 Cell[BoxData["10"], "InlineFormula"],
 " of your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, then the first line of the dialog will be labeled ",
 StyleBox["In[11]", "MB"],
 ". Successive lines of the dialog will be labeled ",
 StyleBox["In[12]", "MB"],
 ", ",
 StyleBox["In[13]", "MB"],
 " and so on. Then, when you exit the dialog, the next line in your main loop \
will be labeled ",
 StyleBox["In[11]", "MB"],
 ". At this point, you can still refer to results generated within the dialog \
as ",
 StyleBox["Out[11]", "MB"],
 ", ",
 StyleBox["Out[12]", "MB"],
 " and so on. These results will be overwritten, however, when you reach \
lines ",
 StyleBox["In[12]", "MB"],
 ", ",
 StyleBox["In[13]", "MB"],
 ", and so on in the main loop. "
}], "Text",
 CellID->7586],

Cell[TextData[{
 "In a standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, you can tell whether you are in a dialog by seeing whether your \
input and output lines are indented. If you call a dialog from within a \
dialog, you will get two levels of indentation. In general, the indentation \
you get inside ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " nested dialogs is determined by the output form of the object ",
 Cell[BoxData[
  RowBox[{"DialogIndent", "[", 
   StyleBox["d", "TI"], "]"}]], "InlineFormula"],
 ". By defining the format for this object, you can specify how dialogs \
should be indicated in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->1386],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DialogSymbols",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DialogSymbols"], ":>", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell["\<\
symbols whose values should be treated as local to the dialog\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["DialogSymbols",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DialogSymbols"], ":>", "{", 
     StyleBox["x", "TI"], "=", 
     SubscriptBox[
      StyleBox["x", "TI"], "0"], ",", 
     StyleBox["y", "TI"], "=", 
     SubscriptBox[
      StyleBox["y", "TI"], "0"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], "\[SpanFromLeft]"},
   {"", Cell["symbols with initial values", "TableText"]},
   {
    RowBox[{
     ButtonBox["DialogProlog",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DialogProlog"], ":>", 
     StyleBox["expr", "TI"]}], Cell[
    "an expression to evaluate before starting the dialog", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7833],

Cell[TextData[{
 "Options for ",
 StyleBox["Dialog", "MR"],
 ". "
}], "Caption",
 CellID->8360],

Cell[TextData[{
 "Whatever setting you give for ",
 Cell[BoxData[
  ButtonBox["DialogSymbols",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogSymbols"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " will always treat the values of ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["$Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Epilog"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " as local. Note that if you give a value for ",
 Cell[BoxData[
  ButtonBox["$Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Epilog"]], "InlineFormula"],
 ", it will automatically be evaluated when you exit the dialog. "
}], "Text",
 CellID->13330],

Cell[TextData[{
 "When you call ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 ", its first step is to localize the values of variables. Then it evaluates \
any expression you have set for the option ",
 Cell[BoxData[
  ButtonBox["DialogProlog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogProlog"]], "InlineFormula"],
 ". If you have given an explicit argument to the ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " function, this is then evaluated next. Finally, the actual dialog is \
started. "
}], "Text",
 CellID->26048],

Cell[TextData[{
 "When you exit the dialog, you can explicitly specify the return value using \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ". If you do not do this, the return value will be taken to be the last \
value generated in the dialog. "
}], "Text",
 CellID->8928],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->389314861],

Cell[TextData[{
 ButtonBox["Global Aspects of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]
}], "RelatedTutorials",
 CellID->1006056654]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dialogs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Global Aspects of Mathematica Sessions", "OverviewNavText"],
         BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/GlobalAspectsOfMathematicaSessionsOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheMainLoop"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MemoryManagement"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 0.2811594}", "context" -> "", 
    "keywords" -> {
     "break loops", "dialog", "DialogIndent", "DialogProlog", "dialogs", 
      "DialogSymbols", "ending subsession", "exiting dialog", "inspector", 
      "interactive input", "interrupts", "local variables", "main loop", 
      "return from subsession", "subsessions", "terminating dialogs", 
      "Epilog", "IgnoreEOF", "line numbers", "MessageList", 
      "what if investigations"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Within a standard interactive session, you can create 'subsessions' or \
dialogs using the Mathematica command Dialog. Dialogs are often useful if you \
want to interact with Mathematica while it is in the middle of doing a \
calculation. As mentioned in \"Tracing Evaluation\", TraceDialog for example \
automatically calls Dialog at specified points in the evaluation of a \
particular expression. In addition, if you interrupt Mathematica during a \
computation, you can typically 'inspect' its state using a dialog. Initiating \
and returning from dialogs. This initiates a dialog. ", 
    "synonyms" -> {"2.14.2"}, "title" -> "Dialogs", "type" -> "Tutorial", 
    "uri" -> "tutorial/Dialogs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.14.2"->{
  Cell[2195, 65, 71, 2, 70, "Title",
   CellTags->{"S2.14.2", "2.1"},
   CellID->32528]},
 "2.1"->{
  Cell[2195, 65, 71, 2, 70, "Title",
   CellTags->{"S2.14.2", "2.1"},
   CellID->32528]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.14.2", 20968, 705},
 {"2.1", 21068, 709}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1570, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2195, 65, 71, 2, 70, "Title",
 CellTags->{"S2.14.2", "2.1"},
 CellID->32528],
Cell[2269, 69, 1262, 37, 70, "Text",
 CellID->5651],
Cell[3534, 108, 1588, 51, 70, "DefinitionBox",
 CellID->2258],
Cell[5125, 161, 73, 1, 70, "Caption",
 CellID->7213],
Cell[5201, 164, 63, 1, 70, "MathCaption",
 CellID->9860],
Cell[5267, 167, 94, 3, 70, "Input",
 CellID->25783],
Cell[5364, 172, 179, 6, 70, "MathCaption",
 CellID->21286],
Cell[CellGroupData[{
Cell[5568, 182, 89, 3, 28, "Input",
 CellID->2742],
Cell[5660, 187, 167, 5, 36, "Output",
 CellID->8610]
}, Open  ]],
Cell[5842, 195, 209, 8, 70, "MathCaption",
 CellID->4472],
Cell[CellGroupData[{
Cell[6076, 207, 93, 3, 70, "Input",
 CellID->7128],
Cell[6172, 212, 168, 5, 36, "Output",
 CellID->18434]
}, Open  ]],
Cell[6355, 220, 730, 21, 70, "Text",
 CellID->5841],
Cell[7088, 243, 158, 6, 70, "MathCaption",
 CellID->20718],
Cell[7249, 251, 140, 5, 70, "Input",
 CellID->3503],
Cell[7392, 258, 200, 6, 70, "MathCaption",
 CellID->14867],
Cell[CellGroupData[{
Cell[7617, 268, 122, 4, 70, "Input",
 CellID->24865],
Cell[7742, 274, 250, 9, 36, "Output",
 CellID->10938]
}, Open  ]],
Cell[8007, 286, 633, 20, 70, "Text",
 CellID->1881],
Cell[8643, 308, 172, 6, 70, "MathCaption",
 CellID->9257],
Cell[CellGroupData[{
Cell[8840, 318, 225, 8, 70, "Input",
 CellID->22750],
Cell[9068, 328, 178, 6, 36, "Output",
 CellID->28614]
}, Open  ]],
Cell[9261, 337, 134, 4, 70, "MathCaption",
 CellID->18598],
Cell[CellGroupData[{
Cell[9420, 345, 112, 4, 70, "Input",
 CellID->28458],
Cell[9535, 351, 200, 7, 36, "Output",
 CellID->2661]
}, Open  ]],
Cell[9750, 361, 222, 7, 70, "MathCaption",
 CellID->26063],
Cell[CellGroupData[{
Cell[9997, 372, 99, 3, 70, "Input",
 CellID->32756],
Cell[10099, 377, 177, 6, 36, "Output",
 CellID->20807]
}, Open  ]],
Cell[10291, 386, 182, 4, 70, "MathCaption",
 CellID->20278],
Cell[CellGroupData[{
Cell[10498, 394, 101, 3, 70, "Input",
 CellID->19489],
Cell[10602, 399, 252, 9, 39, "Output",
 CellID->19435]
}, Open  ]],
Cell[10869, 411, 550, 13, 70, "Text",
 CellID->6365],
Cell[11422, 426, 727, 20, 70, "Text",
 CellID->32075],
Cell[12152, 448, 840, 27, 70, "Text",
 CellID->7586],
Cell[12995, 477, 748, 20, 70, "Text",
 CellID->1386],
Cell[13746, 499, 1499, 42, 70, "DefinitionBox",
 CellID->7833],
Cell[15248, 543, 95, 5, 70, "Caption",
 CellID->8360],
Cell[15346, 550, 975, 33, 70, "Text",
 CellID->13330],
Cell[16324, 585, 682, 20, 70, "Text",
 CellID->26048],
Cell[17009, 607, 402, 12, 70, "Text",
 CellID->8928],
Cell[CellGroupData[{
Cell[17436, 623, 72, 1, 70, "RelatedTutorialsSection",
 CellID->389314861],
Cell[17511, 626, 469, 12, 70, "RelatedTutorials",
 CellID->1006056654]
}, Open  ]]
}, Open  ]],
Cell[18007, 642, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

