(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53411,       1049]
NotebookOptionsPosition[     48958,        929]
NotebookOutlinePosition[     52265,       1007]
CellTagsIndexPosition[     52174,       1001]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Using the Mathematica System" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/UsingTheMathematicaSystemOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Using the Mathematica System\"\>"}, "\<\"related tutorials\"\>",
       
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Differences between Computer Systems", "Title",
 CellTags->{"S1.3.2", "2.1"},
 CellID->29492],

Cell[TextData[{
 "There are many detailed differences between different kinds of computer \
systems. But one of the important features of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that it allows you to work and create material without being concerned \
about such differences."
}], "Text",
 CellID->12433],

Cell[TextData[{
 "In order to fit in as well as possible with particular computer systems, \
the user interface for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on different systems is inevitably at least slightly different. But the \
crucial point is that beyond superficial differences, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is set up to work in exactly the same way on every kind of computer \
system."
}], "Text",
 CellID->23840],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] The language used by the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] The structure of ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebooks"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] The ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " communication protocol"
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6766],

Cell[TextData[{
 "Elements of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that are exactly the same on all computer systems. "
}], "Caption",
 CellID->1735],

Cell[TextData[{
 "The commands that you give to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, for example, are absolutely identical on every computer system. \
This means that when you write a program using these commands, you can \
immediately take the program and run it on any computer that supports ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->19810],

Cell[TextData[{
 "The structure of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks is also the same on all computer systems. And as a result, if \
you create a notebook on one computer system, you can immediately take it and \
use it on any other system.",
 " "
}], "Text",
 CellID->11599],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] The visual appearance of windows, fonts, etc.\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Mechanisms for importing and exporting material from \
notebooks\
\>", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Keyboard shortcuts for menu commands\
\>", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11837],

Cell["\<\
Elements that can differ from one computer system to another. \
\>", "Caption",
 CellID->21892],

Cell[TextData[{
 "Although the underlying structure of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks is always the same, there are often superficial differences in \
the way notebooks look on different computer systems, and in some of the \
mechanisms provided for interacting with them. "
}], "Text",
 CellID->31982],

Cell["\<\
The goal in each case is to make notebooks work in a way that is as familiar \
as possible to people who are used to a particular type of computer system. \
\>", "Text",
 CellID->7328],

Cell["\<\
And in addition, by adapting the details of notebooks to each specific \
computer system, it becomes easier to exchange material between notebooks and \
other programs running on that computer system.\
\>", "Text",
 CellID->29352],

Cell[TextData[{
 "The same ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook on three different computer systems. The underlying structure is \
exactly the same, but some details of the presentation are different."
}], "MathCaption",
 CellID->11369],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzsvQd4VlXyPz77ppCAUta67rprF2yrrCKi7rN2wYKo2HFBLHQUsaDIoxRR
eu/wpYXQaxI6DzWUFCCBACGEhCQkEBIgobf3P5+5Z+573vASqgr7/93nvfc9
99xTZ+bMzGlzXmnQutEnzRu0btywwS0vtGrweaPGDb+85fmWrdgr6E9EnluJ
/lT7FoLbS6QPL/+cx+14wLuER5Tjcfjw4YZ4lHN8p+PPAw8Kor2H99Levc7t
xbOhOJ0PCIK7jBNxmvwFiZfG81Bubq6Xtm1Lb4iHvCI2kjQphDqxp8pfsBOb
PyOgxEhJSfFQYmKil2JjY/+Lh7zKBw7PYSQs4nDcECe1KfJXxi2LSU3icAq0
YMECLlt0dJSXpkyZ/F885JWj4BOCIKibuClrsJ16mFtWO2UkMmVKBA0dOsxL
ffv2a4AHh+V38cd3O3lTbr+Uw90y26lGRERIWt26daOOHTsyPr777rv/4sER
4IEPCICAdjZaA788yrpQRhBUGqVDdCSFRJu2akJNmzbxUsOGH9XDg+Pwu/jj
O8IhPOIhvpvV3r0mp8nyV84PTow6KRzggQJLTpwq0n/33Xe5VnXqvF4PD44I
D3xAAAREBEREAkjIAiBT1Vnz1NqhBkgWmdSsU4vzrFmzVj08OCI88EHy5YBa
zbPmWdYvTwCfqUqiah1RHU7eS08//fRreJSnzp2HcJ6//DKEOnUaRC1adHLr
6oB2siQUIM+pprUhCqIiCS+Sa3jxaXboMFBcuXlo9XsKihviwWmKB39AAMDn
nNMMlkLl5hVSux8HUrNmnbzUvPnPb+IhdejM9y9yl5XnVfyls4RFHMQ9S3Z+
uYVIjD2FxciJVqxIpKysXGpGGRk5nFtGRjatjE2Uu4o8g2nVyrW0bPlaat++
D/XpPSaMevcexZypV6+R1LXbMNqQkkrz5y+k3n1GUc9eI1tRr94jOVaPnv/H
jW0yrV+3juLjN1flxyb6C21I3kzZWTspa0cO3ztp29Y0Onr0IB08eIhSN6fS
/v0FdPz4Cdqauo1279opRV6zep1UHHA+h+oGgi6itvqyG/XrO7SZ5B8kJTh2
7DhXP4fukbdg2pGZTeMiZ1BW9i5K2bQjjDZt3sFV3bwli13bqHuPYbR8+Rra
sHE7rVq9qRWtXrOJY61clUJb0zJpVtQCZFmVTp3yclXXJm6gTIZnRnoWJ59H
MTNH0YI547iqx2nJwlk0dWIfKio6QAlxsRQ5+heubg6tXnWJqtqd8TOomeQd
RNvSdnBVj0lpPOJ3tbgPHjhChw8do9yduzlMJgMmV94PHTzqIIf9duXtEb8D
xcgNcYMl7v59Byh92w7cHiraf5A/4hUBcFcwQZHEhImzqJijr4jd6KE1cVs4
6Oo1myl5QxYlJG7jN/iFUnzCVios3EcdOvWjDRu2UEZmPsXFb23FgdI4pdVr
tlDxgcMUOX6GA+Xjx0+xtw3lzIwcDyWvT6Rr4KRNKRspMX4lpW3NoNTUrZQY
t4LpKk3I+vcA8rWcazq9+GIteuqpp2l85EQqLCjiAifRo49Wp8ceq0EpG7cI
7CZNmkwPP/wI1ar1MhXs2edCcvOmrdSieUvKy80HUjz04Yf/5ayAHw3iALqs
D9CM09iVmxhyqQLXTVvyqF+/EdxEV1Pi2m0e+VBGYHo6sFPF/wZ+br0KznJw
hcBVwq9iCaSMHz/TQcqxY6dKkL5D/rnctnayGwSTxVBlIjt0mNJSM6T+aDAr
V/5eWAFpt/vhR/rXvx7m70wbW7bRf/7zH4qJnkNRs6Lp2Wefo+nTZ9Krr9Sm
2THzaMzoCJZ/Lwn2kEJyUgpVvrsyebnU9T+s76FePXtzVuyUyiBIqMkeWeVk
58kdhGdQKejasDGHxo6dQv968J/06su1wV3OhK6cnEJKSk7nNpTB8iB5w/Zy
cMKVWY4DZATDxTniO3+Vu2yAcOJygoVIlHXrtzODOsKtTBBKVZk7H+eEbIw6
dbiG2cUuil02lxnbcMFoYvwqZmp9hYf/XozsRtqZs4smjJ9IL7/0qjCq5KSN
dO+994m7uOgQ3X//AzRq5Bj5fuzoSWlT99xzL+3bW0y78wroYPERJt+J9GG9
/9L337Wlnj16CUINOhWTwOCihUuYQGI467lzFrDfvLkLadrU6YJMTwnEHjhw
lGJXbWYxspMixk2jBx+4j558/HGKil5Ca9dt9zC7S2OYJ65NdxGbzLIxP7+I
k0pNzXmAUrfmBLMLsorf8Sr3fXhWlA/BIpkOHXLRVRq2dnAbXJ+4hjE2W3w2
bdzAYmgGS90tIuJ/P2xFjI2U9gTxg7YEbOzfd5Db1366/777BVv29ypVqkhG
EWPH0ddffUMbN2yiN9+sK9z1k48/EaZoWKJiC021U8fO9Kc//YnfcF0tTBei
QJmSYGrCTDrEpLtxUzYNHDiKqnLTe612HVq6LIFS03ajBW3M5Pa3cVOWH5r2
7CnmtHIpLW0nPUBp23Ih6dB7gwe/yn0fnlfhA/xzGdsIA8QdPnxU5Bj4XlU6
cuTYGXAGfrkjM1daGtyQagcPHuMYR383KXaDqAczZ8wSSXauOIM0i46eTfU+
qEetvviSfvyxPXXv1oPatm0nBQCjhAgr4+abySrGERo6ZATniyuI+e9rrBQV
iFrilCVcwo1npB07fpJ2ZO2hsWPGc9O6n2pz2Lg1SZS3qwiaSEYep5y5YzcV
7t0vSEtK2sxN8gjt3FnAdyEzzdzcAlbadxbcQDtzC4LxyhHxCS7cZf2DVBTP
YMrO2UNHjh4TPfH4iVNV6eChoyXQ51BhRUFd0rpEmjd7LKPswPkyxQvF2PWs
5WynSpUq0Ttvv+tgJDlFeOKu3D3CyB544J8i1YDRPfl7KS4ukZ544kn6sd1P
9BNjChi/917mkdxNAFZjGJOMhXBTOyAOn3r16kvVqj1KBfn7KDdnty3bjJZG
edxFOXToOC2Yv5geuO9eYYEJ8eu5igc8zOz2MZoKuK3utdB0iOGJnk0ed6iu
ol27CsuxElp4A6O2MJgfGGHBJ/4gd1n/IFchSJB8CZHQwPhRg6+jR09weysW
VfZMCIP+ODtqNOsmW8+XL144woAUCLGPP/5YNGu8Q8bcdNNf6eab/07LlsbS
3sIi7n/1pxtuuFGEGsAMIdaoUWO64447mLFskyb0Yb0PadbMKCCsnKWGOHoY
hIaFpUgHSwdYhYPUh3vp0uXSot54/Q3unhz0yIdQEfA+LG2S992797USJAYz
vPeK7IkYN4MZ6vGqtG//oRJALmP0VTCxrB27pDC/PRNziDJEmEj+7kJXb0bu
HoH11Yz2HPEH2cMHUFUJAQak7wiDNJDWNRbjGmfAGEQnT500Q0nTp03lENud
AUN4O2N5CsL1DMJjx06yUCluxZ7FHKuQ8YsOacS46cxTjlWlvfsOlgBhuOm8
obf624PuHstv+IiJzMKOMN04Fd3GoGj3Yy9K5NJ9pZU/eZJGjZ5CxSyLq1LB
3gMyoJAlaQHE4bSDXVczcedeqtJ/yaXv2XPARyLYHVQDOUBKGeMHLQHtH9/u
tmQONBEQQdaObFq+arWoAmvWrGM8oYtfhpbxE66lS1fTaNbK17O+tCI2gZav
iGMoxK6MRzd29Vru/SfIWxnzhN+KlXHyHxsbT8uWrZb/uLj1FMY6/Vp0eDmf
2Ng4uT3yDJHwy02euPFeBq7w3ymza8QVTCu4gjGzl9HK1eupcN/BqpTPgGbR
mJ0jfbj4+CTG5Pp1KYzJdWs3UnxcMjVv0fliMflFq640fPhYGYO/CY8QVrJ2
ceh8fhYWFjCz2c9UhWcw9zB2sYoWT2MjptGMWYvL0PSZC6k8OxdRROR0efv8
818viG2HuCXC+Fsmk60zvs/f3jBFzt+dTWOYIqBPcJ+pDOv4WZw7NMXi4oOs
d/aj1q27/5a5T54SzbwZIyopOqKC0ZO4+K3y5viVZxpJYU5yhLp2HSIt5fxK
NNmeJ+AvZylZuF/JtE/LXR1uMUlc0mR2p5PToS3PhLxJOi6/S9H+clrRMO6U
lLyDO3kNqOFHn5ixqDQp3AUWjS5N2VKkLJ992oTuv7cKPcB3k8bNacPGbMHp
H1K2ydHS6Vi7LoM+/bgR3XP3XfTDDx2oTZt2dE/lu6hxo6a0ISVbYHqIOza/
Z9kmTZaJOvrll+50/z1V6POWrSh75z7Kyi6k5s1asN89LB/68fs+6WZ1+V3K
Fiplmzgpik6cOMV4PU79+g5kPZdV3hzuPVSSXn7/foMYrCcpKytfxP5FFS30
TEWTUtUyYYYO9VLlyr4bvuznwYvH8B+UHOMXjrJSLEI9iBnuQS42q4Nco5O0
DzoS33D/NsW+y6gUSAkTTkghyPhhpgh+MmGL59/NB1QpJcWpllbH9pswYZbh
VMeOn2DpderUKerSZfBvVvxwmRfD9B9SxfQffFF0nYnErNpZqhAsfoqViIhp
jgZ2tSDm558H0JfnLmrOsfR3G9jptGCZMmYWmy+PKagzje71IeFvZ6xBmF8N
xk+awVrKGlEI01hNS0vLCKatrKlVoFR+prNmFhOziIYMixSV4LfASyi1atXK
TVFrd8MNN2jlKlSocK6V+6tf5TJZs12xch33t7eyeEmlDRu2cvg02rRpm0wg
bZY7nXXSDFq3bjPFJWy4EN3pHGtp48jC4QWg8Cq/WhbsO0RFrOMXc2fzAAuG
w4eP01Huy4DZnTrpZcr0Bplo8Qmbz6eC59e6kBAS1Nlo+MLPnRmHX+mtq6xf
xfILi6Xbgo4X+q8YKMDoDksOj/RuK8j8BiaeMHKHGc1Lj727TWF1OYOvsP5+
4cZPeIhBY0Pjh3l5pmeTkfbY0oUK8O8JEHf4lQSkaoZF4dPTTz8tiw/gA5YV
5KxYcWqDFRHIyq2NB7mpKEFwrb/CSZNy3hwWrOsqwLNlkY0PHVjhYaMI9dHo
gfwCZRNsWovthxvwQZb4FxVDZPJeyZfTDDaRtWS4ZVmQVBOBQv2yBpjhK6uG
HIVGsYAkVEA9+OCDklSQXy0nWzUKZYKo7Ac8uFmwjbjyaOhqd9WL1gWpovGg
schaIvbDIhEIbl2No7IZ63puvfUWxY4HxQozQNAG6COkcBE8uBTG0mjNIh5V
DBTGqBnCaRporOynydvsO9hUxfYDUHChCqgKstFkUF38A21OdjcKlDQ8stXi
K7ARR8kAhCrpcLHR/JAO3IiLauBScsJ3t80Ey6uuL+La2pxICcr20xyHXUmU
dYfFcnFBnwiTZ5CgQvWLYBMOLF0pUBVXAENZPW5QmupTfpLbK6sUXUrhtMtY
zBFZaRHAxYLNN1QUxdMk8P1MyUODVYW7jCoSTgnt5J01hw5gQCDAtCYBwuBk
tHIAq34GA4XEDnIaEFqFkwqW5Qm0yXiEC1qUjnGDxrTiQpN1arkARPoouc39
9JtdQ6U8ZXdIQynxiqK6amekJoeHo4HafsCJKsJKiUhWeZwqGMAtsvRRbJgA
zQauMg4gkvMPtrJFcUA9mtzpfMtZMauEpVSIpJRF2vQiVWnVxIlaTtgUKM8u
CWoPCaUsDOgEfFWco6SoIZJk7q0AsSlG/RAVFAG0lMarUMMrmmoUJnalkGpJ
SsKlTDnIJK0iRi9QDIcpYwLZOoiDtjICr5IEpFqWMhHA2b6ATq6gJmtHD7Fq
4a+rOIIPfoCNEhEIC/4hhthspoJi6OpXQ1nOjHSwiHqA3LA0jxQxxI/+VBtV
dgIWhVLhDkQsNvFdkQT0qPms8l8BAb7MOSgccAFOPlYb7q5A1yiq4+ICqFGg
cpZQsjGOb+BeZkm6JqlJlEwS/7h8nKiCRMUlbdxoRdqhADwAH8AGxSzpp5IE
xceF4oBjodaqwOnaci0LiE6ohhP0WOShZfQNl1T2I0ikqcvCufyavBZdgxkE
XFE6eHUDRptwgCJQilIOsAzQon4qRIw+YarlAyVK5cs9yFVdUEqNizC4kG64
RYk6lIBbWzRaMuIDdYoy9fOpU8GuzMTNeVaysvdnqg7ns7sbdrE1C1vxu6L6
5VUMPNB6cUEqMO7+YYEO1I23v5qgyAScHVGYnNNN0HffvRyqO8kgzd55U3Lw
/x6Lq6vs+YdFa6pW/M2iU1WC0hzpgoF5B8PYEXR5VNneFlRalZUF3RJA2v/N
wruqkFtLVnnv3j+6ymch6kAIliIrlqOjvW5Ngi73WoCV+tXi76Yhaosz/5dt
RaqUaEdCcG5FPFJ+JyVlmZdtVaTYNd36+GbmZEouOECx4XN5FPv1P6x058KU
/+AifmBwqkXE/bI8S2esf3Cx3zOsoMRG01ekrGWEjesO0cuy5CF+Gze1qC9D
RnkkdohocpdZ2d+16LnkplOdv3gZOqFH9N7gy6w5avH9d3f69stCz35JVN4y
fnryZYoFeCsGAH2ZHjDFfkV0gBAZGrjMi6+T9zrChyK/KrpoYPqpZRpQyTUi
h72B5efvWaurxXv69Gk0btw4GjJkKPXu3Ye6dOlC7du3l2Rat25NLVu2pGbN
mlLjxo3o008/oSr0yScfG4Xn9dffoNdeq8MKKZ6nQeBxS6UAzmXcEX4VzrHz
9XtCwxmlRbBNmzYRlthmYE9mZibt2LFD73spKwv7L9PStjGwetP48eNp8uRJ
wTRt2lSOM3XqFHHhDpFnsJ8fuz0mKMA+Y8Z0+RwkfmHyDn+84b8UcOKSLvDl
Cs5g8Y6MjKStW9M4p+KHaN8+LGlPTU2lnj170u7du+nEiRN/NmXHuhuskPa6
DSNc3uGPN6yS7tZtBBUUFlGnTkNp8eJVstIozNFOIUOdOWDVAXQaRudHPNb4
IUqL0geZ1qniwbkTrTkXRzrbFhc0DwfI7NLRdpWLPuiHu/YQ7IEP/Ou8j68Q
YfItUFgzliVoDbpsMQ0WglYRANPZ2dmc0/FyppwHDhygn376iR5++GF6/vnn
3dmI9PTt9M4779Bbb71Fo0aNUhAi4bp169Lbb78trXHXrl2nCYlwB8G4nHlc
pIkL/8AJGLRZlaGDzooGM2dsTw/rpfO77kBoWXe8FHJXp2N1bkQHKt1p2Zsk
f3jh1vUSukJNohkrCTpwAX+ERXkhYgwBu+F1gYCGN3Y3LnPaGDt2rDBQ9nlI
GrTDQLt37y5clgkiCO07nHM/StdKRGxEROpMN/LeqNFntHTpUoE35M/mzZuF
YOrX/y/t2bNHgAQJhbAlqMMZjKzoN7jplW6sM2Km08ba7iCptC1qO+V4yivs
tQMYXEMQpQ57bYIuAoKGAHjpAI4uJaEb/Obs1K3/mjOoQMeCQBUonV1qFAH/
ZgWKZCNzKfDVVTGXJ0lAMDCneIgKCgoYsFu2bKEePXpII9+/f7/wiSDwkyDj
PHjwoLhwe+Tp0AraHcQlaAXZYdN5YWGhfAOtREXNooULF1K9evXED4k/8cQT
IlJKoRUgUNf/KFYAdV2JgXfUFgjW+QrEYbpSWsErgKLIckwROfBXxOkCEUUw
AKmzrDKtcWZa0SSU1FBqpRUdnhchZuaAlaYwDq7mc64AWhk9erQ/rYS6tALv
/Px8QTd/8SCMRAoWGXStcBsIFWQFdQJ85/HHH6e8vDzJ4aOPGkiTYoEjvERq
x1lUq1ZN9MBS6APQR+u0+bdZsOUuCtD5VeXzZmRXhY2Slk5WICjTgM5YAU/2
dJQqfYgmq82QXLDf+jaRZGBRZV3o2mJKl86AwIyfR6iunFRJyRiEoRnjawlx
Q5e5vAEy/eRNqCtvQDioOLRP1iQ8cIQJCV0r0gfKx4QJE4RHgN889dRTor8g
8QYN6kvtlyxZItoI/Hbu3CnND6p7QFpxJuHs0XvAXjFs+ysadUSf3239VKc8
UUGfJhviolSTAb4UNWofy3nDs7w72qRpqS6r4g/F04k09XM1mvDTtFMEVZHo
zrpe3uQBfuKnqoaJqgry2Lhxo6gVOTk5gnagl/+DxOMv8goX/lFZpAJG+uij
j3Kqo5irOAAAWwB7Qufuww8/pISEBEpOTqb3339fJBUadtu2baWjF1CXNfPQ
qk/olDpX8GoDVtUDHCJwKqdrKAAT5vk6XQqwKLp0thbvftMVIZctusaMGSN2
hpjHPyQt9Q7R/oAu1AKoA8qAC6SEf4gF+OFd3fDHP5Lq1auXtOCoqCgOs138
gR+Mb0CbQJ8DeEZnf+LEifTee+/Jt6SkJOEgAVu6w84VLwpgrqCiTDs6IpIt
P5d/43nHZYsHNBvoZsJVoWuFCExBy8AHmgtg5kHr8IjTGarQRiOWGOUr81o0
O8hj9OZycrIlNtzQ6vANGWpECPeioiLhxwgTYGJC4PQSHh6ZNjz7rO8fo/Ii
CKudD0k9HbbTtWtX6cEAGpBA0Erh5n+PeIS6n3BbwYLw4oQJcqPhdvzKumHV
X5MvBXjnNn/8ewLPGZfDQBv0saq0YcMGI9nQ1AYMGMh0OHDgIA8NGjQ4CC7+
yk5x4b+kH25PiRhl/GIEHIIuOZCL6dDSJqd/fxBBmODtdUNzl+N0xpVWUghr
vL1mOPzlOXNrr/fVadE68gxyhzZRkzqXdS2CLLjrSMYbovo4KsyVgQvdkAFc
oBYIyiLydekGODtvoR1e/uhwK8LeCAI5z1HfMANe6PRcYRhhb1CT2U3zhukp
ofNyJVXEaSBPfxdBZR6sRVfLM5jK3FqdbqjZhKo37Qb3s+Id5FYMd+1zqFwt
AyvoUJBw5v7jlszoSAm8a/aNlXrjNu6ycHjohqff5UK3ioi1w4TLS5AbHPc1
Afz+7qQBrwsFWIio6gCarlk70/qo3xNqIS7UqrcaJtQBdzmq/B3Wit/asJ8Q
Cer9rPGr3LTfubaF20wW3YwFcLzB7UgdZ0EF3s3qbPBCv8V959K/2b1nPxUU
FlMhAwymEmAS9eAhVothywy7Z07QkaMnBFgJiee1I7o08qIbHpRBEO4IMnkJ
s6vzrlrufp1hVfN8GaDCCqmC6dhDNgorFBQXhMPZYRV6GqwGDBxH4yKjPRQx
DpiMGDeLX6Pk9lDk+GgqT+MnxtDI0ZNoxfIV1KLF+drx0YXWJUGlC7G35cKW
xDYZ4YYbLtxheHrEK9h4pmsAxzukpLf8e8QV7JcWu0v1DvFLQd2/U+bhATPH
f4oxCH8OQv820xR0EFlt1sMX5GO2f8j7rbfeIjRx6xnJ5K+nkQlsj8C0XN6u
QlhfFIOaMH8KI7Ww1APLw2hdJa3NgCbOq02dTihoRIAGZHBtWhALvc5ZjzX5
3CET5BrLR0PROYvT9wSHuKXFm67WkRA3XEngyhVAefgZi8eCl+A6P8Dpwl61
VIArxAKSPeDvzgZdgUAKUtCwGy7cwS7gnjl/wD0kn52FGbh0s5OOxJslTQKc
a688eJUtFTb3WFSjTctj+enuqn+cS6sNdkWfWeDgeAS5Xo4MdMCt6xt0zkon
MMzs15UK7trnT4C2jmWG/x1RK3uufYfR6BQyt24FojZ0cEZdSIILM9EM8CsV
iLe7NOtzhZw/YG83NdfFPmjROgFiz7uoUQhAEJCTln+Fgu6uAOzxhgB+QS5g
saYtMdafl54fnHUyA5xSxUxwADjrrJQa0nFq4/hhglHDXWP87CVQRReAil15
hTBAbaEiA8cv/F6ouNWF5wIHwokpLtD/cjpdS6hECXUBtH6ngY92MMBObzRQ
V7EPP9y6nxvJ6HFOiq/TDPh4zNicPa0li+uuQIy8eCbd4beRimqHT9uFbNY0
OMGyEp1Qt5dr6IpD26iG2slxZKx/20Cb0aLp/DH+91/e2MFQhWInF0OP3D5q
mwUPSCJ6QZRgwtZqzVIpd6QP8hJgwc0xz4IMtQymwgAA1I4F9BM1LROKpwev
at4Al039ZvmOymu1i6Hm8AxW7H3suDDhrKKZBYxtEULXYey7HHHmGzXBLUNJ
WN20YEEdoWuH4+gIyT0WanRXOvmGNO0O3M2lo6uyBR8AG2/XnQEhRttR3qdN
BM1GV3/aQ2W6Pg4XCmobWdAVXZclKpzmg7FfMLcHm/ajytWru+alaqPwHknR
f4DzbsNykD5ApfvFFXTKggCrc2xERkmXt+st+ldpLQtpncZhI8pmaP58Ndg9
+A+XuyAyyOWHdnTbLET+5YuoCjW/Ex4nI42MKNTOMdDEDUeWkVSSpIJkw5eu
KnnIalagTh8XDHcBgbvkumbwGfjdaig90C6KOy30aSvQIQDlUyhlRVMLNbim
XQvtGqNBmt0WDpJdi7KXK0bK+iSPM3VCDz7tWGBzTARG6L/udDTzYOINN9j3
n03jAjgQCt8eMtb+bC5Y2aDLtqCkst72AxhvNeR/BnUOlxwkaWkgGhVv2kNB
5ZV3VTQUAEyqOod/FNuefZVDMfmt4HJEWEU/Rc5FmJjRi3CtLuIfyalVYzV7
xU3oz2YqVo/kRNCHTHvTtmZrGKB/IMdng8andTgrbX36g5L6dYGRd4eFPJWC
CnhlcQ6b9akItgUouLn2SgO21LwsG9efS8UV8GTbDNNNuWoZxtjjpJRtKRUo
UbqOuXtz3SCc+0OSjj/aaliqm6Lk+sDo0PEVVbNx6eZOjxTTmbAHnHHZttYU
9rebpNVmnrGee1k2nTOjA8DT3bi6XhnJ6P4GRQe0b/5WwXSQgBTlgWdAx2MG
xmrtTenV6Z7gCnWliBo8gw7CJVXVDAXTKUYUDMgPLQ2jwW7ZzW5jhwsHmROR
HW97zEGVHm2f0CO0fV6WmLy2VEwKpkz3PdFsaZRdZ6djUhApa1TPGaOq6qn1
QKQaJk9nUlSxqdo2wqi00XXvanxeqUF1QbQiRoZtkx7ZiN3YwBh/xOKFikZJ
8zo3jcsIb2GlMkTZvIF0wtx1waejbQH8K5ihGWaNriXIs6BLx3dAGOFmFMHe
fhBkoUv9tdC2H27gBXVDboxyxTRAobrGGRroncYb+SMVlIpTKGu8BTpmr+Ot
ZnpTEQkk+q+4/MMV+UCIdGyaIYFwF2s6i6uSTfkQsFlBmmKwZKcaS6m81GFX
dk8JhGL2qboaCi7II0BTzakhHbQT9AaE8ZaipPiMzaqIxsXwUHUHmYF3iv4K
v2tNcmrsyKzAvoxRhajBPismPpvcDg593S24cF9t/NzWyFT8kM86uvjbiCpp
r1d7wj6rw0E+puWyzDB3UY3mDbrR2X9O01N629INxoAIx7DWCITIknggx2nF
9jqlPxBDIadhCL3i102nSrd3IuRjhjZtC4C4jVFRBYwqaKBPFkc6jYMesT9r
C7z2+Iymo+gf7p4Cvc8ItF3OkZc+oG3/rYbfbLLmqK8FWGp6r4Gz2txETqqR
/cMQHUjG5ipnXO7mMSwYoDjsJz1KoaHfFxw6grwXJkFZ/QkSxSbINfCAt9td
v0RXS7rN+KHhYi4AsLvPElnaQ+Bi3Gy8UUokCzJ1La+Xtqb9DwRSWEAgIfiC
2CiKTky8WxyAls5KRbFS7PhBTOk8yP0G6fZmeD0OBAzN72yIKwcawlKYtrfF
YvG2t7I4mEIS94oL9x3GL3ZBusuV7rOgoasVbr+ca346w61e/Tt6g/pWjy0x
RKyWR5EUsgBX5d7RHZdz7U4X+NWpoyARX2szz9prBrqwHM3XxH0nC+DbZV3F
05m/qeJrpiZq9MxurDo5edmT53nV7o3/V5P/V5M/pCZnsu12Th3UK6GWeogB
1BtkLiM78LuQ5U9XRI0fNUF1BljYJZ7X/K/W2JjOckadEEJHnbSjhM6EGarz
mGFUeIMmnH6G0wg0mj28oSbU8G7bfkSp8R3/2K8dpTtl4Kk2Lo2RE2cQ0wxw
IBSjRYI7vXBnKYY9OixdGLyF/U+jjCr6TUOooRcdRdIjo5Acur1QyuFGL8VM
qGuBNKquXjHD7bbFM1RH149JZcyCCB0amqInw13nTmPpmlWdPdYeu67V0blL
JIsCyVIN0yPVbBY4g53/P0FnIDsx+Dfns7jf1NKXffCKZStGu2QoGLDuO6Hn
zPbJkLXp1qK0TvBKblIlp6jtEf2SdsiAdzWU6u4mKHcBuMvLgwUIxl3aTkpN
1VGnS7hc9lLjDhBAo7AXpqjtJ+lUHHa4HsLpXgw0R4ag4k6HWxWosbGxAXGn
ySM86ot/s9Jbcaf40Dao0YF2ZaVqF0ypSC3kAbcXh7vfeqnzeeHuSUd2ce2u
PTsW1eqbzYfMQKq9cM092Qb0Dvi5Zv1C/TilIp+DO5/LuYPAOhsKzKDygDyK
jZRBF450lKIj82vcdHVxirJWqGVIBJJT/XRlLxLV6WttnpLxBbPU329Z4Tmg
9hrLTxuHTnjp2k28XVMa4kMCmoZ0d1tba8qCA/jp1JVC2DSoSqVEVzrzqnZZ
9opHRDnDdpT+FBpK7FD78A2cTVe14lJOB2Q5px0mutlr29EL+gwXSa0D62m8
QJa2Vl3To8fXOUnd6K7XMUeoua0a9KHnHcNPZ9FwoUg6mqdGHJGnSjhVgJhb
hpdCXra9WbX3x0moUSh7FkPteGkJDVC0mQIdOr2q0beZraX/Q6R0lfhdJVW1
G6VKMCUZ/YaSiGUpZ24OXv6nwIX4DcyiwIiiy//sNfS2gmOfeeeabLzO5Si2
GC4pR9VmK2CiMkOz0LD2/1Wlcadgd9ICb1JRhrPi396VoTtmEF7H+sIsPw0n
z7+YD5fV8ogLoJOKQidok7qJRelD27BC2tCJ276NRFfdSxEEfRhBfYULdxGr
9AGWgwrp/DeyL41AVIHWhZVqYhiAKEkgJWkReZ2BQCSTsxjuurKwWc7tCwLk
NvZ0FTjkpq7Vd9ZwlpVS6RCAglc1LFAHQOp2eMv4rUdH8sCennnoLJP/q595
Re3lqqDQ7Zb6r0vkxUIEFw/FR1g98kB3tWmeuNSSaq4YDjgP7PrbtLuysBvi
d7KZgl+ZtH1YofYgHaP9Zf3QoQxe14zpUl9rxaC9lla1D3svlEbVvpWOmBgO
K+FRfCUqEBATozPkVNYV5To0hdLoCniFG7+XhtczmZPznQtyOaJW58kOe33q
9q0B0F3OtDRdv6y8TLcNANaBFCDddmUbla1cChTPOpfwh0HqgQCQ+kcASF3U
TMkfVrs7AtTOdFXZ684A9axjKEK3DwXahCLp1LlsK63VQo8OfMxn+N/xg3AH
gd/2P4NmXVCmrNAc76yLOiCe4SX7zJo2CcQIrsx669S/Td6y7A4odjppqmQi
BVl6/D9T+TuNTFQlC6mCF7vbwgwvN5solWXbsAoL4Hf1/xyAIPlVWUcqOqJT
AkD/e5RhV9w+elhVdTPnVM4VCOUD0EPQpQbLHzbV42zmD5eehp71o91ypI53
gMjedKIdQdyBoBP8PwMdh5eG+NUOe/qxc0FpAO+JZoAizEATrUmHXwDNRMRJ
8R1dkCuG3RimwSZ/u1shzY8z4GKeLyRtC5iqmLsWMC9HAFczrRI6s9o7ww1V
RPcOgncDiEyKznEfZd1dOlIJ1l6MxUMX3qDaCwZfafYwL0cYqj6rc29g4c4u
3SC/9fvG7gkydOhUqXrBgigX+KBk9rc3YujYo/ZPNU3gDFGdb1akcwC3Kmd6
HBFwzdGkoGc+ROByhj4+yyDeXliN5KecGBDig3mIH8zRSQfFKlB1gxNuQ71u
zvimY/igdAzycWEDUfcdRl2Bn44JyNk4ZkQVdXbwtsA9DRSFw/fbSkcVNALr
ZLorEFW3uTLdObexjHuykYMZ324+H2audndKg1RzDRg1rG7o1JlzlNNnDS4Q
akJFDmiz0sE0r5niNTupdLyN9ZQzLHVVJdXeXx1k5mpsqwWSMCejBbJHD8VP
7VnYa+F9NhB0eNkqp5uEx/qmwyBmeoicaaOQ00a+nL3JTso2D/cIbQe5aUB+
akcN1K4X41+NPyopWp9MFJ9lKFxqQ05rjYqWLL6Kag2XeYWStYkAF+4Khsp1
34zOOekGYd9EUrCrBrtEc/gMal0Zd3wSWrRCzp/Ir3IxoBDFO4qh+8DsxQhM
MKVReaihF11z5UOGQ7v+e6IcP/8pNN8AthYJNcfls4oQ7I67myLZ9KFk7E/6
/vZiHLJ2Jv50zUJJutIxdlwGAmKSyWjWSvlwq2BE8gA0rmADXCV9JW2zI9Id
8MVlNo85B7I5AMQnTcqunTbsK5P6q5uaKNdT1PpYeLC7SAWsiXMsa1JEm1AU
WZzaHUAxMtScfxlqIV1lhqrvSBwZAnu6AoYLdGPpzBs8Ty/lw3bfSqkXF8La
ZjGVyrUXostr3HU3rITYEwlKF3o+6xloQKPY3+zjAB0G7tKtj2MjTW0WJn2L
s4e64WwrVSwxNYq9dFD9tLo+vxC/1UD+WA7xO9qyNC6vrfjKovPHTU0Qw4aW
M+/nGMHRtSmOFPRBpSSX1j01ukYF7SLEZK8TzLpD2EDukpCy74BiiwxRwjIO
SclKXFxXu3JKEadF0RVJuFSenY1ofTvLnYlyHePyI2jyN8pVGt1yWcqapoli
KRRtJcjXHEL8dC7U25421OJduXRZ2dQEIxbaYvGPVN1hU7+ZFn672oBPFwMC
C/YUJoi0mqE4BZ0BrTI8lFwHqs6wQO58iVM1AJtfsmxVjROfQT56+fB4o0sD
dlSbHpTkNAtbVAcKp50D8+5xyVvVDARCvez1IjaNlrCAV9Jkul4ot1OHii7d
ah3s5qBtVSFul9Uslr+yyFZtodoLk28xUdSmt9dfL9COMHAI8Jqh0RAz1KLH
HufKIQu+zBVUyljdmX5/K5ml0bCqwKeN5nB4UCT8DWXZq/D0clePOAc7qTLs
rgsLcssGNT3MZKY7iHAFu/RHPpN6jh+ucHd8oSRJarcSGQQ7KTkFUYLCJcvC
HG/bXDrXTL1t0c7eYVc2vakMU0Pe9ijBXabGtqLjRTcdgYJdWOLiQiidAZog
BLUjZAS+Mjt3M5gXZrRK5ZVqdtORi45aAQiogqj407Eo0xdR++P26nGVcdrj
0WkmH9BC/RZEqb7NrFk1WHjbK2twofrGyJMWRvd349al7PaQAoI7epJTSt3O
gzuQ5XSL0zoJ6GEmmoCelO0ERqVDpRD2CiHE4TLu+J8kU12mjvat7V3HmJS/
IKyuL9fVZoYdnWErg3or28QlRkWdhEHZuBzB62DHnjSoaKFSSb5cSVQiEUTS
kmlpkSjfGtRecnpBVnP/cBSioqWhsLKFam2ytiVbbbJXBYCqLtZVKYN0z7Bg
7DqLUrR9qTU0Mex66y26xPEaq0Taigz+fMtVZA0+N61yhrvo9iBNB0UvNgmd
1/LgP1iDDhINWlVVd4L5LCuwqlgg0xnsv5rsTFtzmFErxwqhdLnZMzgwsuxV
mwDeea7J/cNpXhe4nonm7bahNK+0rDniDjN5n77/JdxPF8GtQw0ouaKvNPDq
HC3WwmIBpVlE6dglulnmHNVY3OW1szDQurkqAYB8r/FTFQ/JqZRF69Q5yrJG
cbZZuK5Zt6Uxbh3yhFv7MGcHcqgA1zoKUnwZwo49rL+Kl9/hhgVFTMUM4Nw9
lJ2TzwDeSZs3Z9PadWm0avVmWr4ihQ4ePEJdu/2e648VoDpAgFRvPAOgVAHT
Ep0NUG8YNgooDBs+kY4fOy4+J0+e4qKeOHFSynKcSesYHThwhP327z9M5WlP
fiF17NSfWrc+LyhcOBC06drN7yZLNOlgUHAAAe45KwCCqbgon7ZsSaPRY6bQ
ypXxHlq2bDVdS0uXrhLX8uVr5F6xYg2tWpVIYzjYihWx1KLFL79P/bWl6XSY
j9P7i/DS1m1rXYv259O69VtowMCxTPrRZShy/CyqQOMnRNGQoeNp0ZJ4atHy
vOp1Nuq+lRLB1QJVrHIAxKr4g0jTyZcwU3jbEBC7dYevbZA/7BxgAIIfPWYy
FRYWUcqmrDK0eUs2w4CdlL+nkDr9fN60XSoMcMAERZwJuapOQ7EpqU7j0kGC
Mqa1grgV6coBzmAm+rRKT54STUVFh2lFbEoZWhO3hSsduzIFR5P+ztsqtKur
iDenrDmqok98OLtkfLDQ4bKz1zfEr76oZELiNo4RF59KlcQN18pVm5i7/TGV
D3JPQIO/g1f//cC21W6dGzx7zUPdmu/ff4gS126nufNiKSk50yMY/zOtT8pk
r5WsPWRR7KqUCwXAhde/uqmDbiLDxYRww3lU7cjRUzRy1CR68onHuSVP8tCm
zblctREjxtO/n3iCedoMrnn6b1u1Jw2h2ToRbryXD1BtHS3HwAqUUO0B4b2c
qTvCa+NmlJ8dJDc5IJkcTceOQVWaTjWqV6dH/lWV6zWbJrJu83DVB+mJGjUk
TFJyFh06fEGK4rnBRM0QBVoSqgc2yFq1UuBjD9krg9PZBDVUf25NwQHOpMlR
XOljtHXbblqyZA0D6FF69pln6JmnnhbALF+eQBmZBbRhYyZOs6YuvxVwbgoA
nGsD+AXqAOrYLi6Viu5kSmA4QitSO7z4x/td5wiziZOiWAE8xd920+7dRRQX
t14I68nHazAeN7CiXETZ2Xtox458Jrzjvx3MRJyb2UE5Y8q12FNWElRYLDA2
PpV/YimeWG/alqJT6brhDf+6V05NuTtLaMq57de1c40NcoedM+XQR8d3uH0D
gr7NFvguJvsd3o1qYyFNbKyjnKrdKIg8fHPWATsqC6LKdzNE7zXaPMw8RutK
4XNfy/qGKYLdvYGug34kDmlftGgJK7Yr6OjRk+QR3wry/cSJExeCyXMUhY5m
dqPbaUZldZpX5wq0r6cLdWztVkfr4A8FQedOdSAK9H0r5g0A4Qp+G8ztLSG6
YgYUggtyV5e/6EkSuv4P6/V0XYdSmoZBevDTo3BQDGftGn+RBaDGNDECq4li
QFGWcCbG+oZizhexwX6IZZblYUwe42TQZQMOnTc8y0tnrkuXwb9h66RrBE6q
m+GGW9fFA4U6drjX2E/Td4gC2+yTc4K5k6U9HbrXTDu501ZXnbaJRbPXxWy4
lAQY2k60Cu6WaXmzJqvsd5RIu5CaHDRRPUhJ42v2TqfTYTKnKQPnhdkgwez4
8TMt/a+8bDH89VdG4W/R33ZQ+Gd3CEstxtsmx1FRHVBwDE6nuOhB5rpMVjR4
f+zhX+fb3dnPq6Td64wmzFXb8+D6r3PQbrTr/bBn52Bjw0wEidterg4IifUT
059SzN6qp3aUjrxz3gf6usHygeLdNGHSLMZwNjPdY2VYGcWyTLTK5A1bqN+A
MVyVrpzGb8Nn/+ye/o1Gpmq2YhQmsdVeBBihMkAAEbgRnsXfmaeq+LSn9yBt
lSB8i2+vcvttZpW6uJ2Vdk4HHYSFeMju8GGzaeAv7uwgUKKmR7T94gJbUE1Q
ZxTtnX24ADe8KyvWrEFdyC4Qqy15AO333/eiQpaGbdr0ppiYJV7uQRVXcR4r
Vqzjlh8bu57rvozGjptBP/7Yj/r2wdl3vXuPZnD34idczv8Y+qFdXxo+agq3
8s4ypvgbtFrnqAtd7qTCiZmxx3AO2c9vxrEBRGGGhgTwrgxSCV/KYU7y9Phs
84W6WxMQQK1G8L9qqtGWtRtHlfqLy9M1P7Q94eWH97rcFQhyrAImSnns8vri
JQqC8B3kiTIjTKJ1JHNpDfWnn/rztz2Mk3HUvsMIat9+OFNqx07/54Xzb3jc
Q737TMQMdr/JNHDgVCbTmcx8Bw2eziAcOmwmDRgwlYYPn0k5Obvp506DLz0a
7VWTStDs59uO6uNJWmXbbIiG05V1eDvzXvayLmjaMYnu3VtE69dvppSNabSR
79iVCRQXn8Qaf5JHHGEUH5/seJlb3/GfmprxZ4mHUdc02rJlu7x58QzFoxL3
EbL5a1ZWNu3IzKL09ExGDp4h/CXL8ecQ+M/k7863UMrgZxb773C/53AvLctD
mdsy+JGeEQQXVaSMjB2UlZ3jBOYb0Y8cOcp4HXDJuyHMvzyyEcR3uorT0BxY
21seFCcQWdrMAm2YDA/gF3ZG3AW7uGvbtjftLzrASt9xKHvJG5Jo0qQJ3OOf
wHWZMGE8JzJ+fCSNixxPkfyPe8KECfIlMnIcrV69MhhRMc6Px/FjoXAxBJAe
XPp/lGG5dUuGBKRg32cnSJA4gvxieUyZ7FQkepCbIyPfLyETMsgtTQmXnfHx
Y75kgksW11eVNXBVMlDLz99Dg0bNopbf9qPP2/T38GNAEFwMppb8HDVhDvN5
54TpjIws6t5/IjX/uq8b1iNhwyV+q+8H0oyYZQyYIxI+aWsWDWvchsZXfYoi
a9Tkqo5/vKZHnME0/uFnaPibn9DyhE10CiSEGOVEW/jhh75/wAxdHaNKKR19
911P5ms7uUReOsF9hePHT9K4cZE0atQobr4bKTtzO+Xm76NVyyfR6sgGlJOV
wX7bKD0+inLZvTN3F8vKaEmV+xqvmixPcVInuTuCuwaelTj1k3fDVReuiqwT
nTBVmzRzGTX9sj/XsGfvGA/16B0TBBezgu49o6jxF31p7uIER9kcOp1afj2E
fuk6i+P+/OsMZmadfplB3XpEsdydTZ27TKPGrfpQcsp2qdCQz9rQ5H89T9Ev
vBtCUc+9Q5Uo+vl3aFq1mjTgtYa0K28Pl/mkjHQUFxcJLH7boV8H+lX9oA8F
8fDhozK5eODQEZo7bx430UjKZqxkJa2m5FG9KX5ea8qNJCqY8wXljX2PMqf+
QHsOe2l33k6KiY5miHplFP/oseN0GA02NZM2rk+jvQXOeoj83QWUtHYzbUnJ
4DiFtCu3gA5z+IL8/bSPtdjiooO0m/2OHjnG2N0lPcmcHbvpCJfr6NHjlLdz
D6exl9YnsqRI3sZxiplSTlQ1Xc0DBw7LWCuKUAPPSqjN3XDVhasig/eQEV29
Bk6kvoPmcld/aTCNGLmAUTh6zCJmVEuZSS2nrr1n0IhxzgKQ7zoOo4lT4ig7
u4AhuM9DO3fupVu4MRfR0mVbaMzYJdwLXkltO0bQ/CVr6OiBQzSh6r9pYe0P
adUrb9Dql1+nhHfrUcJ7H1Lc62/Je1zdd2lxnXoUWeVRylm3gQ4ePsYFBDL2
nSv6Lxb7/7Kw34u2pe2QEZgClsP5Bfuo/4BBXLEI2rx1O2VlFtCamuUpYVQo
LYshyuhNNLcB0cwu71L60na0eRWGH2LowMFjrLcWASMMkEn03HMvUJOmLSg+
LpliV8TRSy+/xnrB8/Tii6/SD993oq6/9uFKxVGjz5pTxradVO+DBpS9Yw+9
/349SlqXSu1+ak+jhk0QLtXmu7bUuWMPeviR6vTUU89Rw48/pbjVyWLNoYjR
/hDzzYNczz17ikV3Rn+mBp6VuErFd8NVF66KlL9nL6vJhw8fERKImLCMFi5c
zwR0gut/kPbtOyiTzOvXpzP1L6Fp01fR8DELaNjYWdJGf+g8guISM1hPSacO
7Ucwm+geybTQvx+Dtc4nrKJNYTa0lrr3nUox81dRIYNy6n9q0uqXXqNds6Lp
aN4uWvfefyn+pTqUN30GnSjcSwlvf0AJ73xA06s/TVvj11PBvgO0p3A/7ebG
AtT8DrQQ4kcLmzZvp3RufR5+5tF9NHlaNI3o14XWDX6Vcpc+TEXLw6kom2j2
fKIvuMP2w+dEebOJMhe9RTnZW2jGzCjK3llA6Rm5lLMzn+89tGv3PvrqmzY0
bvwkBlRdWjA3lnJ3FdLrb7xFjT5tLvQQE7OA3qjzDm3elEHPPvsibduaR51/
7Ua7me/X/6ghDRowio6f8NKH9T+iFs1aU90332eOcYwixk+k999twA3yAO3M
K3iIM9/D1dyZu48rkCv3SjwrUmpaDj0slpW79o6kqTNXy5qVEcMnUe1XW9IH
77dh+nyf6n3YklatTqcFC5MpYuIS6jd0KlPNfvq+03DakJJDixclUI8eE2nu
/HVc19WcXhE1bfIlDRg4mZYv30J9Bs2gyTMWU0ZaNk39d01Kfq0uJU+cSMcY
0odS0ygvItLp5qSxrvthA9rwQX2a+dgztHbRStrKcE9N20mZO3Jd5OsW4UuO
fD3q115jdG0A5pDMqvSGTczKGTHJKenUs9cA6tThV4qZ0pU2TOHGNZP7DKuJ
JgznDvE9RAt/5XcWoamLerLQPkDTps2gLVtzJP6mLTsoZXMmfdOmHY0cNZ4b
5mF64cWXaeG8lVzxbHrzzXepWZMv6JdOPZkgFlG99z+iTSk76JlnnqdkbpTZ
Owspb1cR1WMiGDNyIuvYXnqfAdiy+Vf0Uf3P6OABL40cHUnvvv0h6+EFtDl1
BzOHTZwjZjp3SRlwr8Szoojof1Baei517jmWlizdSDOjllLt2vWpQYOWVL9+
c3rnnc+4XzaaMZ9NievS+fsq4Rw7snczRQzj3sAeWrQwgQYPmUXxa9No2YqN
VFR8nJo1+4qlSQylbMqhoaNm07jJ87ki22gas4O8po2p/2OP0NCO7Q3erqH4
5cvom2pVKe3Tjyjjs48p+vFnaPWcZbSBAZbM3Aa061JEqyauzXmdS7g0msFj
xk/HLfB23WnaQi9am5TK0NhKa1m643/EyEgaMmQIpabvok2TP6EdHYl2f0XU
+z6iF8uyzGjIJNGZqKj/32nT4hE0ddpMStqQIfFTt+aytjWQPvqkEQ0fHEGz
ps+np1hOzGcegQV8tZh5Nm3yOb315nv0deu29HiNf1OfnoPpo4af0caUTFqX
lMbNew+9+da71OSzFjRy6HjG3CfUpVtfev75l2jU8An0Rctv6Id2nRiKeVVp
3XrpKG7O4uy3yl0Dz0qUuD7tbrjqwlWREtZuYXaRwtTSqftoQWxqKrO0nGJW
BfbzXSTutLR82rAhk7ZszqGYufHUvd94rlKWqA07d+6juXNW09y5awSImNjD
/2effUFTpy7g7mU+jRo3l0ZFzqa1rNTMePolyvm8Ge1v+hlF9+4JXV3CL1u0
kNKaN6adzZtQ3hfNae5/XqSlMxdSQtI2JrpUaVVtDHGAVaC7p7MCJYjjYm1U
O+fHq6Ee+OjwufY7dasJ3GZFhaNHOZb2dUc/ouGT2vfxWS0Ik+jqpzMbmJRB
vWrWrKXjQWZ7sXubII4hg3KSgt0ZRnPBwJ3a6Mf4D74jGWcK80GXwBMYG7Fr
UmhV3Eb+38B6/WCaGT2bkucPplVdH6Lkr8tTZnei1A5Ev/6bKIrvAx3uoew1
I6g4cxlNnjKd1iSkcvxNtJLTWZe0nX7q0JXerPsB9R80hvsKA2nJsnW0Om4z
E2p/5lmT6e336lO9Bp9S/YaNqUHDRrRydQqtid/C8TcxVW7n3sgweuvdD+n1
uu/TtBkLaNLUOXR35Xvog3oN6es27Slp4w4PAj9EqzhGkCyrWLl6k9w18KxE
K+NS7oarLlwVacWqDQzzBFa22ncdJWsLM9PzQyl9227ute3gNjWbCbpL73Hc
VtOpTYehlMsEvWTJWmrWtBv93On/qGOHEdStayQ98giz8AWrWUMvolERc2no
mChatSqZZj33Cu1p1YwOL1vq9FLXrKEBP7VzULK3kAp+bEN7231LC194ieZN
mUux8Zu5UBul3bdp08sdh3VkX4Sgzh3CY1QFXzA1q/ljey5f5wF1UFCpW0jD
ULhOHKFJuZv0Q13LydDU9GwfTlYniXW0EiXQVdIIDtLT433c0y+vOc3crQZH
dD3UG2oB2gZAYhkocpsg/lEqh7KdAXVQ9hqmyCXL19PSFUn8n8RUNYi6dutK
K+eNo/yMjRTf/z4qSiDaM5Zo+bdEwxt4aM2P/+HOXBYVHz5BkyZPpeVMWYi/
lOMvWbaeedA2Wr8hi6l9C1P9Vv6WLHnEJaYxQW7mb0yZ65IxorY2KdP9jOwX
cyPghuJBGAwlr8+Q9vHxJ01oW8Y+ps10BP0cYSvRkhVJd8NVF66KknUw63Cb
RC9P3ZLDCvdBD+3eVYTHfoY7O8W1f99hWWrVqfsYbtqpQstHD52iCRNmUbVH
Xgyi556tS3+nxx9/mZKSttKxw6do+qwV1H/YNFq2dC3FPFOTTnb6htJioigu
Lp5+qfsSzWrdkIb9+iulbU6l4i4d6Fj3n2j5izUphruNS1du4Iqt58qmu2Ss
FiDVsrk1En2xVOxsY7X3ZOs0lLNRRWxZybvMtHBcFEKPEkK8kla81cq77zyB
shIv0FE2oF9l1u5gfcXTDHHru06XqIF40K/Opmmj4zgVjO6B2oJsVzJXmM96
1sLFibSANfCevYcwOMfI+ETR3lzaHPMEFeYtpsKFH9PG3pVow8YkSl0+inLi
o+lA8QGaOGkqLV6aJPGvowX8DBb3vIXxNHveKlq4JPEReD8J30pw3Q1XXbgq
8iOBwy+PTaKfe46hEWPmUPH+I6EG+IV7DlLfwdNZ8k9gzruRvus0VNTEY0dO
khPmb5S1o5A6dh1Lw5gxLlqSSBHvfERHO35L0V81pPYfv0qnsueQN38RRQ1t
Q+0a1CLvtCF0+NfvaAp3iGaxprBw6TopalzCFpeiwBBtarKk/MXzRV3qDfTZ
6x+ARnsSTjecgQp0ncHTMPnhyxnRQfkgUmMMQJec2PPnNk0ZUW1WMfiYos07
baLSOTu1LCU7TTg7PXrGTh9FcphiBZe6lrNyF8Uoi4lZTdF8d/q5N3fm+8t4
/+HCNDpxMpdOcowT+Vto76IWMsKlbWb8hMkUMzuB462hWVGrOR0s24YriKKi
17B/nLw9gueTCFaJ81lzN1x14apIs2at4oSio1fTRO5wftl2AHXrM5FGjY9h
ohvJnYhwfkbTLz3G0dc/DqYpU5dTDCc8asw8+rxNP+5wTuGws03Ym2l4RBS1
6zyS2v38fzRjxiqKiomngaPm0PC3GtDmRvVp04+tKfabRrT8689oXfuWtKnD
VxT/ST2awgp2L853Zkwil2g1zZy5inWFVJfeAFib1nQezbcx9GwE9098lrVK
N5+R9BxzBfbJFUCyEoyuikAGOo8LTmKOeVfNUE1hKc8zBiSdVML9ZrpAUvis
q7qRO2RskCE7zQGtDbXX88RQc5QMcXUlCb6h5Jh5Rol0ClmNNJQ3abZs2ZmW
LU9mLMbR+MilNGnicurceRBNmjSeEhLiWEavptWr42nNmlWsAcZT7JIoio9f
w3cciy/mAnGrWHRNoSmTV5GXpkxacRMelSSdIJo6OZYiIxfToCFRDM0BA2cy
3AYMnEWDh0YzsS6R7xM55NQpsTQ2YgENHBzlBCtDAwbNoqHDY7ggyzjxFZLg
5Kkruas9h1EQ0X1cEEV0i2RhwE6KYHocM2QmTZy6iiZzwAnjl3FN14ig/fZb
oRmPICvYRy4Oewq5BNSiRtJ1q6ayBoU54K8LE+0dvPZGIA0bHiCc7jq0xWp5
Qz9padmMu9WUnp7Hau96mjZ1BUWOW0CjR82isWOiaczoaI45ZnQUl2/M2Lk0
ml2jR5mb3eMj5/O9mHE3PnLRTXj8mSZOWMxxJjF+Jk1cKneoPEPED1/1xnvY
mb6xbxkWdss4xESkw99nzoilFczgdu3aR7NmrpAdctIYAEpn25k249CLlBvO
/nld+CLb6jkN+7QdBWWo5adNLyxAuJsNmjEBOHLkdMrcsVu2CKWl5dH6ddtp
2bKNTApLl27w8iP5r3g8QvGsg4bL3qldu5zptPSMPBo3LoaKig448/um0h5U
osw51fp2owdhLQcu3aKqG0Vty2Is7nQfr21Y9e8BAPemqSAmXyIiZnMLjaGE
uA2UnJRG69dnSl28zBXS7sTjYe5+JXMZly9PoSWL1zEVLqWePUfRkMGT6eAB
sxL33GpylbAqXLo3WnewqC1U7TzjOoMp5rqmTe3ZU0jTps2n5s070Scf/0gt
W3TlUrds0eUuPB5hjvcrE0ezZp2oceP2MkGfn19Y/jxKGyqrhXR1kFVaNVuo
JobMIpFAhX3b+O3aVYAlb3J78bwLjxfOqTS2GXtFq66GgFiBgiNr6gPkL6FX
nlM2elREtFnjhFqdMUmHhG5w9xpquUCNa+Nj6doXptJ3Y7dTr7m59EtMLtXq
nUFvD99LLaO81GGVl/qkeandnHT6plVLgawezCfrjY2w/eCcin2rBR2dAy4j
i2ZCXcsaesM3d29uoE3F51Sr656fSm1Gcy989k7qOGsnPd89k2oPLqDGM07S
97Fe6pbqpW+iLl2tgkUF0EuGoZgUndM5gl3jF8IRFkRpiqiVDtzjxjI3Jtzr
LrjSjMrvudJdudLtZ3Kle2RSnSH7qNGMU9R2mZe6buJKz7oUlb7NFNHeYW/v
xF8Qa1s9DPFrlipXL7iaSrE95+RS56idVKtXBr01jCk2+pRDsYzbttGXopq6
SVvXfIO7O5u9yrkr/lQFcM0VGwkAt/aFbNs0yhsqXkz1vx+3nfosyKMus/Oo
dp8d9MHo/dR6tpc6x3lpQCY33Hnp9PVFV/+OEtVHVR1tqIJb/QVu9c32ZcOI
0XlT6tBBAFxoBpUuqurjM6jfol3Uc14evTkgm+qP3U/fzPNS93VeGsJV7zT/
UlT9zgBVNxaqGdGuIYptKdqmXRyrvHRsV+EKcRcF6wXgXRQQ2k3aQQMW7qJe
83bT2wNz6ONxxfT9fC/1Wu+lUble+nUhA+GLiwXCXQGA4HGBYK9s1DJqgrqS
UxS9vQ5rF9M3RC6fONuJBfLlFYV0inM8F+7gc2CD7aZm0cBFu6n3gt303tCd
1HjSQfppiZf6bfTS2F3M/5dcCgDpxlgldMeO1OnV0w2ituUY9YMAV10q5Exg
eNl8hhEG2AbQ27GCcQ6NZnIWDVqym/ouzKcPR+ZRs8kHqMNS5hUM1sg9Xuqx
/FKAQ/dK2/Siu4UVHKga84xwk5K1gt7ljHv1HNLAW8zVkpnUE8/bLRpRAHjO
AShtJ++gwUt3MyPNp3cH76RPI4uo3SKWH0wjY5jOui2+FECpEgAo1wegEd2r
hUuHOhviQCBcoa5ZMyUVA5UqViy1b3jYWKpXIQ2bHecFlwmZNHDhbuaw+VSX
OexHzFy+Y+bSM8lLI3K89MuiSwEXtZhg743SPh6GSLTHFGY2XNtDKSXNyvpq
5piHU3VfVQ5DVQCYjAw4E4xBfoNJyr/1uCnfXHmQe2S0A2vnqf0gY5JMDZTi
sq1VG2NeuqoSrV01BohIHYcC/LR2anZSc0IOkB64ZdjE4QWopI6NI6pvl4Mz
pIIC4uaCh5oo8EYUTRFRnDpeJSWAn24+0RFSuKX+pnWaU6kUXPZelrQLJDiI
9D4Lcllv3UV1+mfThyzSv5rDtVrLIn3HpRLpJe2UyAF6xg+ogCbjMHAB8gJ1
imuBs67GXtoeiPBsu666/N20VCE8hz7KlDSC73ekuMcqk2pSmq9uTMTlMWnZ
h6LiVoMFPiv15U6zCoRLaceuCxDtMJNgv+X7HD/Y6DK6UtweJrUtmKmMU+t+
dvFsPVivklYAAfEQUzW7HeuGDO1HaVp2G79gAozMpN7z8+hX7v++0i+L3md1
+ssYL/28xkv9M7zUft6l6E0E4njXG+KxJYESg0JEZpIdKaBAt44sLkFbJU8u
cEqkfS5kqQM7HE7JSskDcNSNUoojnSHRUql+qxumjAR3ojlmWnWk1DaLpOqv
olQp2Q7nWgINd3fYGynoutU6k0t1SgYAlhbVKOrkOyHCTkJ3fWlWWjJly7h0
OELhbRObjtldCLFhWOK7Mdx1xWBLdC7V5K5r3eF7qcWsU9Seu66907z0wyUZ
bAmkdjg7nsq7xGY3YYSTfUxeZ0xCt5JbGthZqMzHWR2IOeFso98aDjXxF7tX
uasa7L22igkbO8aUsc10lVHZBpJNMDVDq95mkCbIsEU1210aleHyHUoU5BKw
r/D+5KVsO8gqoU1a2l0yDeCSUtaodOo2Zyd1mLmTnuueSa8OKqBG050Br65b
vPTVrHT69qIpSw+N9Q2KxDrt7Qyn0dk2YpQzBOronJWJBTKAzbgX5cZBcTl3
7temB125o5lrg7dpSPUwZQ6ncbYQP26mMlMJyTZGXRohQSarUmnv/lc/5dO+
FhTsigFDrGeiK21QhpdfMrqSMcXtMqYIunqhRya9PmQfNZl5in5YzsJps5e+
vSQDqdqZDjzaoJ2ZM1KMvcfUbvZQaQxKlOoUyc4ZEe459WX8qETFJNxo/w46
wvxQZNYz2OF0yMdeIuH16pl6uJyFXSgWLtUE9V0KwuVSQtZ0kI17PpHKbSU1
55wJlCzEb0pJNY0gixh8jFdA4J7LpgDRDIGGbRdAMPZ8ws9RuTI6i/mEz6NP
UcfV3HQg4mIuBcHcZT7bBCMiy2E+px36piXV3pAeWqaN9NZbbzH2p8+TzAA2
td1hkdnpJuMquPbQbcliY8rmT/ZJRjbGVN7Z29s1nHVqVpjfmUQljx9xl+GE
uMwLF/L2mYj3N+xltyqgxLQQ+xQuJT5ckLXKwwBOLS7nnm7SO98Rm+8it1Of
hbnUbXYevdZ3B9Ubs59ac0fxlzgvDcz0UsffZOwXI/phFjy0ydp+Kq8C0c+N
DjUSufPaqndgoMBjDspRPgKs69iwLUp02NRGpAc0r6aG7QTUMJBqYfb02m6D
RgDfMkCqw4h2W8eNMrr9pAmZMuzcc94uqjswh+qPLaJv53mpx3pO6pJ11PVY
U7ddJ/qmGKRR20bRVXDbyFAWXjoytO+vjB6Xwsvu++pEjW3aUpFxWie45Ac3
0cLSoV6S6hXqEL8/TgbU88xgfzZ9EllMbRd4qVeSl0bneqnLJRns11FU5UTQ
mgIZNjxXQFvj1qGnjVujusKo8HK9vp5W8x+m+Ebx3x+WS00mH6T2S5xh64jd
rHwsLbXm51Nxh62pJSBOzFk3G+zupzGcMJA2e8bqvyMfrvFvQ5OzaLAZiq83
Io+aTTpA7Zd6qb8OxS9Lp68uGpt/dyVgkIVX3SZRVp5BrsEZn1QM9jtHhqXT
NedTNxlR57r1nr+b3hmUw5RaRD8s9I2od5UR9RaXrG5/MWXWwuHipnt+ZTY8
rcfcfJlPxGh3m/nOfOLwHC91Xgh8XGyZhchkFiSQNYVAS9hOL3ACF7jGBPpu
3HbqPS+XuszeRa/2zaL3Ru2nL83cb79tzmKNr79ofpEFvtswYT2/WBd9g7Hd
cc7FfSSSdcF06jEnlzqxLvhizwx6c2ghNZ9xkn7iTmkP7jx8MyOdWrdseomK
KyPYxvyZ2uE5p+Imxq+ga+8fS62HbKUuMTnUdloOPdl5G9Xsl08fTTxOrZmM
f2AINx+P4ja5oOI+WEstDWsfGkXVmXJueOdU0gQu6Y1VhlPt1gnUcVoWNYvI
pAfabqHHfs2mOiNYz5rBXVemh/f6rKU2X31+kYANtJzvdOAlrKKHnxpMZR+J
ohpfJ9J9366nW1om0cMd0unFvqwrjDpE70ccpZe/HEk/d/jxty4S2FdS0lpq
3Lw/Bd/JSkS1aPLUWULXf7aG7v0mmZ74eSuTYha90CmeXv3wCxoxbNjvUaT1
69cxB46kZ17vRcEPTyJ6fiGFv7+c/tYsjqp8u4GqfrWcnvrwR/qy9ZfuKNJv
XKS1a9fCzgpNmDCRXm/wC938wmAKfXkmVXxrJlV5fyg9/14r+vrrb2j5sqV0
8ODB36pI7xoxum7dOqn5nj35tHDhAurTpy916NBBekmdf/6ZIsdxn3TbNjp6
9CgMll2c3D9raQCc+Ph4qXhxcTFlZGTQ5s2baceOHbRr1y4qKiqSUsAGAWwa
XrLSwLV48eLAsDlw4IDkeuTIEcrLy6OsrCyG1x7xRylQmuPHj1+K0oS4pZk/
f75UOz19O8H8TMZbAo1g2rlzJyUkJMh96NAhj2R9NRUUFEgAXdaNwuILEHcp
aMhXsqioWTRixP/R8OEjzBBhEA0bNlxc+PfgSzCcYfATl/hJsHDHHCq7glw/
r8OJkcA1NGTIUCnkrFkzacOGDZScnExr1qxh6lxIixYtkjEH1B3fUJGkpKRL
UsFQt4LLly8XN3CcnZ3tEYSXEWzAhRtuQBvYSUvbxjlgND1I/DRcuDyD3LAI
4ZHQQRIPfghR1kpfw+FGSITLzMxkCuAwVawEtSDB8gyT1gGUXxQNVnLVvNtc
F/mOkHbIQD9UKEEWK1asoH379gl9OoC4SoquVUpNTZXWBByChGbMmE5z5syh
lStXik0hrm6YBHa2Z6Lgq1evpnnz5tHMmTOEHNBvjIuLE5bAYTR4aupWoQLg
LSYmRlKG9aGlS5eyBFgv3xmQ0or+KnGCuGQZUjrc4fIMli9aYv53KhFGOTk5
UrHfGrTuwFnJwzFLQnrVqlXCHZ0dt4WFhQxpNH8UFBCOiIykHzp2ok+bNaP6
n31GLb/6inr3HyCgBCyYVkIlwlWUn58vNLZkyWIaMHAYC8K21KBBU/r44+b0
7bc/0fARozm7lUJyHFajgQui+lGzZlH3Lr2oZdMv6eP6jal54y/o105dadrU
qdI+EY5j/A2FvBblvQ0uSeVaf79w+N0M13Vwwa/gRv5aQDjgoVBc+/bhvxB7
GApCEUBcDBiAAMDQfxTSI29h8l6KHD037KkdBkTUDUjXlsAKCBMZoc4eoaMK
Aja4APVlLNC7s3R975136MOnn6SvXn6O2tWpSU2f/w+9/cJz1PLrr2kyK6Wg
ZIfTI+bV4kZho6Nn0Tfftae333iRGn3yCLVt+xijqDo1bFCN3nnrNerQyTnT
Do0jxMRFQwKvHDN6DDX5rBm9+M4T9GYLjvPjk/T2F9Wp5ns16OOPPqahg4dL
Y9u6NY0aIK7TtEKENsBawGSYFUrj9si3CvIOaaP/u3fvlmxRabgRB/HxDUBR
XoZvCiDQH8gW3xAG6dvhVAIiR00DYZBnOHzbSdBQac9gmBs3bhD1CsKc9ZlQ
AUmoqDbwQiV1vxzH9pj2j2xQTEj0i5MlasQFly7UvaYEpaCNqnwJkqo4lALM
Dx85ij59800a/lwN2vZtEzo2qjd5pwyjgt4dKLb+6/Tlf2rQ921/oIXMRVEJ
RyIgjfICHHDTnzt3oeYfPE7zx1alvKx6nGcb1lO+pqyMd2jKwAeo0fvPU5++
A4UyhM85RUBSIFQw5+Ytm3PX4X76Jf4FmnPgC0rydqQlh7+hvpteozc63E+f
NGlIkydPpk2bNkm8+kgjTGBYWbS0jz5qQPfeey89+eSTNGjQYAEXCGnatKl0
33330RNPPEE//fQTvfXWW4I3SPU33niTGdESiY8W9vnnn0uLAid59tlnXalf
o0YN0VOhkzVp0ph69uwpdvqgr7300suS1pYtW6hu3br0Dre26tWrU9WqVSVv
JiopZjupdIjkvXLlKho4cDA1avQZvfpqbWYaL7zwAn+rXfs1at68mSg60EAc
EY94YUKcrH1dHFsxBiRld5JYWBUXopSVBc46D2n6qj6rrY6xA1g7dYKXkTpj
rEmtETkGVFN8QkTt2DPdqTkShEeS+FfD3DpeFWSKoeH0X3erIx3dGZyrtpjD
ZOAepcVqZF2RDFRibQNH07OItCWA4hmLwQLK8oL4ZEbwr0wYw6v9k463bUHe
yGHkjZlI3vlTyTszgryDutGWujXph1ov0jQW9kxUGh3tad6iZdSx5Tu0dvA9
5N35KXlP/MI59ecbw8s/kzf7Q1rQ9U7q/F1LWrUmwVn5iugVhNRAyxGjx1Gt
L6tRx8Rnaf7JH2idty9t8Q6jjd6BtMLbifpkvEwvff8ADWKSAcME02gkaVQR
koQiBD/0bh599FFBA7oIIMfvv//eNWx83XXXiYxCh6datWqivgAorVu3pnr1
6rmYdjqy60WqoWsGBQrpvf76G9S+fXsJB6aP5gYhBH6KIYLu3bsLRIGiKlWq
CK+FithRyhoqKgTKj+b5FasIsATK6ZSRTCsJN4FeNmbMGCnSyJEjhVsCTEgA
OIS7lH7YOfJMZ3z7r+4IPlLWNU86c6czbiAmSGB7D7yukxI7+jVr+exZmzkf
NV+DeGqaQxfBSJHq1HJt1+DS1QtqQV7zdc+hdawpYA5SP2txURRMnyE5PdoW
2dsm/2UbJl6cBQk68RFWQkqAtaIDB9UzSPhNBUHtAkZ/e9YXkl6oTkc6tSFv
X6bw0QO4oQwh7/DedKr7j1TY/L8U8c87qHenn2kLczhH5IIAKog7LT2Dxgwd
QTNa3EUn5z5J3tSPyJv/JXkP/Uin+Pbmt2K/BnR0VlUa3fRhmjFtutjlDTJp
gJOnbEihZj+0oNpD/k79Nr1FUwpb0vwT7biJdKbF3vY049CXNCz9v/TuxNuo
3tf1KCEuQUR4OEoA46v5/3RdZeG6Hq5wCXO98PO5c+cKwF58saYQOHD12GOP
SecTDWDq1Cn0z3/+U3g45Ab4PHRcEPkXX3xBH3zwgTRINJ477ridNbBljlZY
UaoBwL72Wh0RQyBkiJf7779fkgIekRV6HSB26B9/+9vfaNy4cYhXBhD4q1t8
qdLtWpF8gdKdcDHNw4RxdHQ0tWnznbRcVIwLH2YICVYMUS/0W8Ac0MuFgoMC
AlP4dtFjC/aJDAEMg4vbPpEBJFjyRAZtiMgC+0s0S3u1xbYUxyREtG7tP78T
GVxxVkly17kezbmkbX/4665xiCcIOQ3rrDM5vT8VWqKrDzUBDAy1YsJz9mBX
ED43h6nv58p3UfKr/6a8FvXpyI9f0olenegkt7eTXdtR0TeNKavhGzSxyj+o
Z+PGtJFZqaMeO2nAvTk1ncb17kJLmt5EJ6Ifo1Oxr9DJjfXpVEZLvpvTqZT/
kndFLToZVY2i6t9M0yLHMZS2m+ljp71vXLeRarZ6hd4ceSd1WvMcDUx9jybm
NacZe1vTlIIvaEh6Pfol8UX6aMp99HjzxyluZZzoKI0kjSpStYEDB4kIgFaG
1mCqS48//rhoNxgkAqn/61//EhUQqjJEF5oCqA/8/7333hOQQSbcfvtt0ruG
SFL1XptTmzZtJBzG8qDpIS2gCVrb7NmzJS9QNtIYP368lKUMUvhBkgoVAIwe
PZoGDBgoESGjOILs5fEgG2dXT0XhQigtRoh69+5NEydOFAGOZAB9hLroUUL7
KAxQlR6cALdOk4PAVRKIJTNzcK8KLnwHZbJkKHkUhhqpkvaRm+6KJfsojAWB
j8LQRSsiT3zNRpd/aqvTKNrikCxaIrQ55ziiw+56E4RRsx92E8E/6CBIsFde
1Bvg9/trrqEV/65GG+o8S5mfvUe7v25Ce9o0o7wvPqGt9V6j5JpP0LDrr6EB
rFnvOXAg2EQvKDpAcwb1pvmvl6d9Y++mo9MfpOOLatGx2Lp0PPZNOrH4BTo2
7V7+di9FvVieVsyOpqLiYif3CsLf9+7aS/9p+jQ91fM2ahZThdqteIp6ra9L
/Te+T703vk0dVj9HLWZXodoj7qF7GtxL2RnZUqP6SCNMxIJzYmqtWi9xV7qt
uEEsOm6Kjgs0IviDbz/yyCNC7iD/m266SToe0K7ef/99Fi53SBh0EtDMADJm
7B7JpoLwePRtAF0ohxjafeihh2REDDQM/8aNGwnPh7Z18803i5hAMcogjR+k
4kHSxKBVYojUI8NAQSK10PHBHQykeMRZUT4gCAgXTQltD3hDUqgkyqb0cZGt
4yrOJFFaBAhKF3mpGoZWAqKDtAFdM916zC5tfFa1yD2hoow7+a+dZV2A4ztg
q5yrrOFfVxdC88IpJNpnQjxn25FD0tpqzHoDY8kG7etq+QZE2PtJdGIeRUQc
DYMYiO90Z64/rangHQiEhg0aAd42sQLT6NZbafqD99Gih+6glS/WoPVvvURJ
775Ca+s8TyuefJDm3Xcbtf/LTdSHtfF9Bw8GS2Q0l2KaN2wERTx2PW395Tba
2f86yh9dmfZPepj2T/4XFY65k/L6X0OpnSvT0IdupLhFi6lw7z6NXryvmGo3
fI0qf3kHvTT0Jvpo4i3UKuZh+mruY9R6TjX6bNrtVHvUjVS1fRV67I3HKD8v
HzHDUfw/w3UtXJXgqgRXBbik++CRHG4U7QnKGDrPUMjatWsn5AV/dKInT54k
cIEogDIHBg28vvLKq9LJf+aZZ6RBQLv67LNPRTRAgUOHjtPwCCDLC+Wij46m
5zS72yUr7cj8+9//lm8YK0AbAsqY0oMQIARFvdqtEmyPF1+nVSqSyt0g5t7D
uJXncxOdJ30tqGNoTmgUUMj5P1hYwJ9tL+GFGMtGdwzdOCiZinyoj5eonYU6
ZxVZGhwo02044fJZ1R3dBKzbCuSIlW0p7rpI/a63TDuYLrtuLRfjSaYbo/bm
kI67oPq0M5VD3XR1sMKEkREO5hRaHLtomi3e0Z6RlTndRXetlmxigK4oBWCg
IbSNO6uNmJo63/8ARdV4lJbWfh5L9d5/g6OuePc1mvdUDRrNHPxj5s6jhg3n
5rE3WKJeTbuZqS+LmUPdHvknrfj0X7S5VzXKHP047Rj7H8rkO2N4DUrp9ijN
e/uf1PU/T1LyWhz648QFttp9347ufrkyPd2jOjUcV42+mvE038/T1zOeoc/G
P0rP936MKr95DzVt3ET0niYmLri9Mzac6g6Z4gt0Ph1OhV6Fd/g748rOFjr0
eBAHAgkaD97xHXGcel0lGhBcCKffQZcgZ+hiECQ6pMrxfjaQRAYQHeCTkDOI
ostQ5Tgrgzt2K1tFxN69+9C3337rjvp7xDdMuzsu61UbyRdA/WGlHhJonXsJ
lq+t4HQLAqqM+frcTj9cd7TddAaKA0OT+VYIz/LSrA+hn8S87TXuNUY2b0Hb
pk2jXUuWUt7SJZTDTWd1n370xVNPUVNWnXMYKMzAnLGvqyWRQobNkC9aUZ8n
HqFNw7pQYdJ82r91Oe1PXUYFCTG0tsf31JnFxRSGbTGz0hATF3wQ/eGnn32a
6jR9g0YtG00r05fSmsxltJrvCXET6YNv6tEjjz0iA97IS873eRTOW+Aq61RF
DBCjJk7SUidz490jrmD3mxmYcbyD/KKEm2RQNkAMmr8uTS6Hb/9A3tUQpzK7
DhsAgzygOX399dfUo0cPHHHhgbgIdqwSQnBUZLEQQV26dJGeBTQacFVERr3w
jzyVw2pnUC3Tnu9Y7BT7TFE9kNbegKQkI7u3DP+yDWWp1lOSjNBRMe0GpBQk
pXdwCTLq0rUr1X7uORo/eAjt5GSKdudTEif15aef0HtvwgL2ele1CJG4V9FJ
TiqTW3enjz6inm++Q5v/v/auLsSy7Cofz/2/t38y3e00ODEyBEKTwNBEHPsl
D3Ym47SMZto/6GhokjIEplWcASU2GkZpCKMtCAZBnTdp5mX6yS6jcJ/v40WY
eA2BasiItsmMFBjGhuShsr9vrW+fdc49t+pWddVQLRbcW+fun7XXXmvttdde
e+91/umfi/cffLf4n3f+vZintdCfvvBi8Ze//wfFfyfz4wc//GHPmwQIYPGN
f/xG8cLPXym+cvMPi39J4L/37ntpQvtW8bXXv1Z85tOfKd688yZNV5T/Auqa
e5MeD663IIMJ/wmSv0rgw/TbePLNb77N6RwrTzgY/yb1iy9Kgk6xd7gjCVko
goUgxMaugAPUiI2hfbFWQYdjwP31ePvJFk/AU25rKg0eHrSONQCkEp0sqVAn
VGWwRd5NnzcTpl9Ks+6n0tL5mSTkV5N989XXXiv+NQkb1LFtDYyL99IzZqW/
Toz9nV/79eKlZBf96rPPFq/8xm8Wfw8mJz2bYFpx7n5y7+aV33slMeWF4hMf
/0Rx+eeS0fzyy1wvIH8DZc2P22ECKATbkvu4rxFSJynsbXYAGbb9aQsHpEGZ
d71F5ACAvEvNeM4gxj7PTzgpMfOAnHhOrOyZqQhjcEBM5NtCF2QhYWVCizPh
/H76nZZ7xPbdVO4994N9P5X53/fft2IjVkFVdAzcAUiAxm80hnwaCh9nhRNs
C0/6QMwwEDBfyU8coll//kCdR8uQTky7P8Drt1PiddcSkC00Bl1QnL/YDMO4
XoNPtQjz2Za0DzcEnJomkQv2go6p7GD2/zy+bCe0xxzQ5u/uviW0iutr4fXL
ng150mmp7zsXE6dL8Ig+aArgDgbVi7Z7Y3IL1oGN+JSUjQ45prXqF9fCgn3n
11Prl3+xQb7z5xXXYZR49KD4q0tJMOb3kylrcaNx+UuGjN2Zw1bvhKau8qeb
bxXnr7zM9tAujqJicsIQAy7/sD569M0YdiczfpXZ/v/4Pb74VYeBiM2FYyuI
FaKfatE1D44t3l/IeL/Tgndzi+D44K1AYPZiDNsf+WTuy3/5yuvChTeIsz47
O9rtf3RBh59C/bl49VH7Yzf8urU4JAlK1aV+C3vecZixG4FVB+VU7NnhcQqW
g0LuVRNQWHpW/UAfDqEfUeLEoQs37x2wH7XAPNN7PMqB1qZlFaq7Cipm4Xum
urTKNwfM6mGd8vuD+f52gLT4qeKkyukeNlC2tFMkZlx1xWtTWPnDWBV8+Jd9
C9Fudg6CH6uKEAlqbBIJGzsK/ykU8btbAbFNJgGx+4+n8xs+eARG8dUcRzWi
FaDwF75+s54UragmFP7t6GXk0WVdMiI5xx+v8UmRTj0WZdx/1aVSoCd52d6u
wvLZDdBJ3m3WR3KBvQTxoh4dZpx3APBLxz0kJ3D0eH1dio4BxRNLdGs77ntr
pYnftZAmvXzmRH9gXfPmee6Q9ikUEkN/WUXsVFF45CoVmpIax+Vbj5No6M5u
Fg2xPFJPka3iGBUDjAinuDhSXmSK2KzYe2K3b8Aamk8xqxliRHeyhaPyYygA
lY2nDPAn92B81j6VlKMkzk/A1QJHCA62ALTPpetyUVrJ++3tQlEtqFkUGDxr
Tsq0AY4IPVZKZIWkDLKk4D/GlUgD0sUQqHyD087DfJZLtoU2SBQYV2xTxICa
pIx2lRR5nBW4QUfNoiDG8DBSMC1SEvklldV1sPFd7sDSTodZXgzbVVd/vdqL
qSQkPs1Aa3bz/OT4vP1BmiRHLin9zC5NtR4dWGEco2qh85EhOGxcSecqEIvd
zqn46bq/VUoUiVlmRpMtRyEl4NqO72Ygo58VoBRjLbxVrxZXqSEbaWC1aY+3
naqRbC4PWW4OeQX96AuLlTLiN5UqedAOfg5n0atFFsIfhEEnn1uYw2dF6/GN
J2th5JahWyC+LyCcFL5EUxuedd1U54RkF7QFUq3JRjcXhWnBM3NBbmLQX82y
0ZCuK7Qu2ZKlBJYp/ga1GQkKKVgjxQdgjhyeWCxZqmK9VKdsPqDUc6Kot5if
85H8E+R8fE2NAgPH+E06BpbajUZnEDBxSkoDZG6zTxNCsk9jbJQoF34CbJV9
Wr0IqpOZWS2ybKtXp8XqMT77tTh9MlOD9mwOHFDzsTJTMUS1cOz4t47zWQmj
kcaH6AdaxFB6+KtCyJ7J/IdM2Ep6ivsRzAW9FQsMU4fOvaINqQyWmc00PcfJ
H+iBOGnZ4fMAAExqaDclZNuDRskOiJMD6ml3srqNWDc4hGqcGYHqdDbLa3XA
0LoeI0ftTb0NwZ8a7vrdtFVV7FiJyzlntZZ3oI1ESBOsDRujjyyEnZ3oB6l4
03croDnFqowPwxPCKqjdMOAHGfKyK1OCWmFVXbfxDyfyYQuMb3taNYKraKH7
nPGPjiUnWxCXloMLhi8pTuI4zDPclFO/f3ot1cdeVGl+9r3tAPnABwk4oTEL
IcfvUw4GGKjFNJ6z+fbwP5bo+/D40TffVlwSUb2PrIX24Z5y3exOz+NdALZF
L20j+39aI7Pp/UC+apAdI/Kd3KW3fPqZrFLwTs23iHnXewF//rHoBVF4Hl8d
Ilmp6auv3uYzUH26mB8PNV2hS1S2iQ7+S/PZa/Aszd4zd2zQVqTHZX12LNC7
YkKQF03HAqmrjyEq8wqVxaFvQh2IKlNQxW8gwsA5dFQGK1HB0snCwY7zm1nv
3n1jt+b33fpwqXXR3APz9fkwTN/TQ214dw7oFmqJFLMYh5SLDwYF3awDLUqm
TvhbdyU2N+8crhA8uSsbwHzsbzMoQ1powHIDKvZq9l1R2QOTy8WdPcVRmFjg
VntFrXbcK4Lc20s0dyVKFYJuLaKgOV3NwhAFUkhH2l2+tfBwR0l/FSY8AZsM
NGkNvQ9HCH7AiHRyGAKMGEsbrYPIYaitupyg6ZOZSQr8a//vPLLvqiYneAvV
Q6IClLDgQJNXrvyCXT0fESu0sHarg+VWL5mrYgvLGbTxWTbUz8eZb92a+Vt5
+F75EYGbV+r85WsHFICLl3npnmGyr3KwdXLgeAuunp7sVSEWAX7dpuodxDHL
ywk4kOX+Dzwz1+meGRDMWkTrLcEE+qXfp4FlAf2F/3ZFp0pbrEgb+Zu4Y930
sWMkvVpRZZ9ZCbpbS0vPZ1uKjvFdIumJltxOBLRln/R8vqXoMy1p3Qy82TH/
lOapXqCLuZ91GJ+z21VIGkaa5EKQR382Co04ZcySWFLh71/8xUmIPyT8I5iI
aRr1OSWbR0Fvo7rmaSi56SdkrucaX/b3V8UadnqmquTGlwEfsVmojEPCXuYl
MCD97IyOMCHJsBAyB97U69jbgGdeBnn0TS5YZszKJ+zlwKlqVX2W08gDuFIr
8GZdml9V2QbqTK2VjEnKf/Bg4ew0TARevZgvanVGgUHobGVf93MaiyPPHKyW
PcjQBDn7glOa3bCyLTyWW+pBBV7EqIE/Ra8ZvHCYNESrJkbzZfDDLElOOJXh
L+NTJ59RtxgmyO7XCus5AcysnbeyVgQURJ33ElEVwsfczMO2FioR2Lo/isSd
zysCOrLGH1QY1DrRzoBBrQkxYOr1qEwag/Ozzhxjxv38bjnDw4kxqppMFp5j
TmD40zjqHXR4ntt1eGY5SL3FLMewSxmdBeck+H+x6wS0+NpqJPS5sQhskYUU
7kRtLURzdAaeaUidICiCgIEYs5OcRj1/4Ypet7WhmxI2Ix+loBbmSxTHdOz7
Euw/0nhTxK9rKnQInPuxE4uFY3iORTHHw0gSJ/VqRBQHPdRBvRkw0kmviEQe
X85mdEGHkNXaifOEgH18taDIS6CFTFr81kgFHdFx0Qnp6FBLE75m67IO8vje
R9wbQ2UbkwCBj9DgEQRk9PNWIUiG2s5Q9QuNABHxmyG0RM1OjihUKQHjr5gB
KxmUXtmC7T5KOXWy5rHx/6HsK9GJGS0Y0ZTe26JoLmgMrAN7wdrMnnGmqwjh
u1c5hCJwSmCuuszlboE9vg6UGEcZi2KMfLAFbHDN1D3a4QsMMk/CTKoNfa1o
eQAMqNuWATqjnfQ4+k2OzubqYD1AgJToIDcaXEHxXJnvW7OZ1DzgAB3Ugw6o
YJ5iPhcHnp4XC+k33ooBxwfwAvu0o0sZsf1QNYNfPUezbt0YO3EQReVik0Bb
sbXII5c31LH3sIAQFsoBT7rKi7Ei8W52TUNbk5pIJhJteXw6SKj2YtE2cAKp
AEcbd4oF1k6+M/ZK14SLzuEosJf6hjrqq6RhEdSs96VkZ4a25zozigO0Toa6
gPXCBBopLGxt4kPuqdopBOwuY2SEFtkgsJbTwBnbbQz0J4hHPM6APx2fAwl1
ckUCr+dIhpKlxrlBkRkaETlCBgolDc+XXJLAQR0dACWlpNEM+qT1tjirAIj4
Q9ksdZkuZp+tMewPMuo9+gE6h00FTdzAlPNhtmI9uJuNevRdUUWQKutIIibx
4x5FGhbYBADdteGLZzbpdJf9gDTkoUyC0WlZrXRkHKTiim5HzH3itw1iIDU2
mqceQlYAlscGgq7z3tngGzIZxTb9cAN+g9s+UAyqHV4ApPj+2lTM5GUkTwaR
U3i+SA9TQssds4Hy4xQcqRXVs3edT9k0WtERHcHXUPZwfrXwZJV6MaJhdkId
vm468U/HPaS2wAPgjzZoCPtMqzZUH/Ctjm0bb9E6tYkUdcZhBmAfkgxsuQWL
iUTqDDAx0CN89AF9kyEuemTrJPQj4Wpo2KYrNLOGNMglUuG5SSr85okms99F
TRUDKM31LzV6AxALt03AEWoGHw0YYBjSEjFARw9AFR3mXbilf2Tr5SfZHCdq
fwlg1uU+1cIWmfmCV+4pTenojg4WuoKTsFIpdV3RSouhq+yi6xNasK5DdB1E
bSqOK5g/z2SoD4aukzuOcsCOFkl8+SHakslgNn1FdvZz7gMsTBM/kWdsvbtP
mwhoDQyUcYM/UAgiq5kTLYtSuoMDZSFBwG/0kK6h5Q72fUSCGGCQjAzNVOaS
RUMTSjpQFWiFPENzGKmA6035qDtXmwHRBYy+SDigDjg6y4m6sqNkfOjINoeI
DXSzRWxmA8VsKV6n69klqZB6h0ThN9S+puXYkAJdgcuEnjrRHPJAPH3ikEc/
ZNLrYCRDNnu6FDbo5c3Yxa1BVqjIQmuoonHySy7jYpvYA1KjZ1GjiGxa1LHX
03v5SLWF4+rU7MXyKIf/JEsMwERfidamKm/OEJva5PqRdDgpOo1xb2oQfTHc
72XxRSXQRwagbEZzxN/P7JFtCsSGLTO6PGS6wVay5lg+qWqsb9v6vTHWm0P9
w3luVxCVaVB8qEjrNf3WkNeY1EyndR0oj2dZkWC2ThaGTo2dt5rMuYZLH60b
AJ52OK/NoMQk77oIrJrUdZplmp3Lo0KBeGlNbm9niwdU43nYG/buOc0DWkaD
1kDfdWbJSr0cMAMivHqYN4VAfinAoHMl0Vw7W7Eh2Fd6VaoplAe1Dsl/AVlH
Xb3bCnU0wGRSIw1qBVaMJFvqOhG4JKXNlaQoZZrjtLb7xdyx1L5MbVt8223N
eGdKbzCT1zEOdORJ5UEQswV7RGP8TJ7AGCc2UUBuW7m5Nv3eprwT4ArypM7c
TcjODxtcpb1Gv655OXUsULY7uACSovdNSsnZXclMepS/SBYYeHELr0wGFuPs
KRUcueZgictDVRvaxYkl5wWozoBw7mXV9op7Ym1ny0alnLnZdS1/vGsqK9tt
dmvi05F471W1Z8a9xbncuSg0zq7ipnO8AXnQMt3keNs7D7Pk0XNc9SkvfOTy
tfWFIS9pdm+zPCBoQsPaNNW4YjsD1D3InieUBZsddMc3USNkOUvyDsk4Mybu
08RO5SUVBuL5LA7Z3RL6BETY2sKCAEYDTcH9RN64qaLnFxt6y1anwNcmj2l+
zlR0Ty3Som9UrW3ZyuzADrl1xvap7CjFn25zERN3YvJONuZ1vwTlXseJLyOj
sQkSCgw6KxeHJkGIFgN/RdDOtcq1Pc3LSFnhmM0AE/U3HZ24Pkce1IX2t2RL
823DI02RKZPnz32Zgv9yPqoT3H4cBzNaWE186SynOv4gUjYaxfhhS82+m0lN
v1ScUTUByTho2z0dBPtUa4lUVsOqlfRb5giWP7RuXJkfnEbTYnnFa9rAfREW
d0LesFSt31I6IXPNlxwCLC+fe/G1Plli0fBwJXzmEs72fPuv2pjSqKu2cFPK
ae/QzKXY7aiyOibcDT6taXQaVdvEEtxuVr9exfRhc297VvputpWyLIl8tu1W
4zT1MaDGyyi8s9xTzV8GaO77uTNQpim3sdJEY3BekSw+o0xvlZyWTv/oBixb
CnddemMXdU8nUmPZJRCRnRV5ZycgWGY1Mc0why3lotAK3/DcbA5VpVIOWSOv
Xr/X0063pFXM/EhAWLnncu6vZFmoHbOoqk9agL/ekraKBntGUFl1GIgzncRm
ltlggbC7bhre1+BG+Vnfy89C+d/28qEs8n+qBfSkpfrrLWlWbuTqrMHu9Lyy
q8Pc1VfvzOyMGecMw8zGiSsGtDSvJXfEKWCSB92syx8dH495Kp8vwrU0podh
kJuohiOTS5/VZnl8N+v1c7r4bmVmS2BbOrQ6eRqQWFW6Uyvd2Qf0WvJgqWeB
0N7L3nKZ+bzYmzr769CK5GFL4z4u5wsTdSR0m1woBcLEtcIxkGq3jnWrdgJA
bydIUVaAofn1Sdve6W5oKuQ3KR6puw5pZ3XxPgS+7k+sa8n/lxrv1JK767XT
IUMqkcmVTrVWMvNmlg+qQmVeunF7jzOxKM3PlZeLC5d4LnYHD9f5a8i5hYdu
Qrndj75qAsPMdPrKzeLCxi1q+RFTu0wHpIsbt5G+g+Sf9TyUwxPwTs+sUjK1
U1x69Q3m4TOsMvr5mHtjKllhOGzctgkIHeGscuPrCRwa7PFymTpL8qUmd5D3
LAv07fZZykQhFEDTlzZuDgxhZmOWAvyQHXKHOR947O8ssbDG7wsJ634iLeCC
kHhiK469yvwZc86wzNPXbpEh+OA5prX9R83qmeklH060FF0NJjXz54TVI4Yi
HzAEfXvIK00aWAwMQTdFJMgT4PdYbZIBIG0PYq6yJtqomRAYsO1+jZBgI7JT
axMi2TEk/XO5Je1Zfp9h58Fz3jNJH4AFUSAR+A3ksbTEbzQj6dGzp5d8OGEC
iaqocuM2+x+r4z8v+CRapGZOtWB2k991PkjOWbJDCoxrIhV5gYKgBg3VjVsG
fWIsw5BO2O+LJaNdWcKWU/WeIcvfzSHqvEm6Y7m7lCqI7O3nVrLpo2QT+gl8
7kznOWw8OoINsOnWg+LuwiLtoFP4D/YBA6WB9nRXJ+xUJv5HuzFt29tSHQ23
Xsa434Lxb+VcG9CjikcNZnJsbJiMdJBrA2y4N0MvHhVDn974OlsHqXoGlKBW
MbSTO9trIcUfeRqgARZaMQx+khBFWDFWaU3Goa7yAQPw0LrywZhYn/EdL5rH
CYPPJjhnXAPHL+cetAnnh4LKW8VC49pJ5pNiVHtWfw9OFkfMSmhlPPdsvt+V
lcOW7v8xv88xH13R8Q+4JzV7iAl6FhMAu42JqSslC5/MPATqzeq0AJyHPFbr
PPxdotQ1lEBNTjy3n2Ryf4lRPoF1nEfxwh0grKE+H51He05pfTObspLbfaQ5
QtIebWL7FX5/jGma4IAJN0SvfbHYwnGMQGgxAl5ODcDLfqoP+XCPRj7LMEEa
YEljAia05rbvH8Y6wi/9/+kWlAe5f8/YE8hdL3JuH4MRtZEmTPdiNMp1CMEM
iAMxendLcEDwo6wX2rgsVMXUiyYg+tXO6NIneBnLuAVIDtyx+8IPw/ym55K5
Z1kO3MYvPaOOJAyIYp8IdTDHIj+rVlxmTOsZzJGo0zYbPrOK1Y2059flLY3b
sjmzruCqyRBSJvx9BFwtg44QB6OhjLmqjdOlW3JZmVGRWeafILnLUdOvWenh
ecCHbtZivk5QLWlb8ctHYD/Ly8XMhFstjKnSsrFz62O7Gm9PrMHAflxAbCyz
Dd3rObu0oJDtsDa7lm+ROrtGvh6DUDA5rMDSZNnnQ8fmzRv2+Vt+d5kmeUrP
fxEgsZ8JGiElnFP2gNm91uwBYY1ZAh0Fblhrr7PQbO9ZIvCIid28wHBZ+05I
xpO7aCd44Ph/LhSQWdAAp8ky4ddpB1fyYcRkTdqxN9iJ5hnOFhf5w3p3UPwE
O9WxMXPFbMbv4LsE5U56LiRFuZ8Oaao1bqYliljaMKdFJBU6PGHkOCrAkFbA
hhuwdOcIXDFJPtPzDpIvuQNEPg53pqTvHssHhwl/jz1PjiDk643o95ZRoJMi
67FuprSzmjbUc8zrZWtLDg7UVz2ZTKibOrsZWjrNgqYuNTZ28P28Z8TL1Sc9
Db8BAh9Hu3q7ykdXJBQ/9iNBP8eJ\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{545, 335},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->31244],

Cell[TextData[{
 "One consequence of the modular nature of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system is that its parts can be run on different computers. Thus, for \
example, it is not uncommon to run the front end for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on one computer, while running the kernel on a quite separate computer."
}], "Text",
 CellID->21794],

Cell[TextData[{
 "Communications between the kernel and the front end are handled by ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->6608],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->410012375],

Cell[TextData[{
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"]
}], "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Differences between Computer Systems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Using the Mathematica System", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/UsingTheMathematicaSystemOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheStructureOfMathematica"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/UsingATextBasedInterface"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 0.7967976}", "context" -> "", 
    "keywords" -> {
     "client-server computing", "compatibility", "computer systems", 
      "dependence", "exporting", "importing", "invariance", 
      "keyboard shortcuts", "machine independence", "networked computing", 
      "notebooks", "portability", "server", 
      "support on different computer systems", "transportability"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "There are many detailed differences between different kinds of computer \
systems. But one of the important features of Mathematica is that it allows \
you to work and create material without being concerned about such \
differences. In order to fit in as well as possible with particular computer \
systems, the user interface for Mathematica on different systems is \
inevitably at least slightly different. But the crucial point is that beyond \
superficial differences, Mathematica is set up to work in exactly the same \
way on every kind of computer system. Elements of Mathematica that are \
exactly the same on all computer systems. ", "synonyms" -> {"1.3.2"}, "title" -> 
    "Differences between Computer Systems", "type" -> "Tutorial", "uri" -> 
    "tutorial/DifferencesBetweenComputerSystems"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.3.2"->{
  Cell[1289, 44, 99, 2, 70, "Title",
   CellTags->{"S1.3.2", "2.1"},
   CellID->29492]},
 "2.1"->{
  Cell[1289, 44, 99, 2, 70, "Title",
   CellTags->{"S1.3.2", "2.1"},
   CellID->29492]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.3.2", 51963, 990},
 {"2.1", 52062, 994}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 664, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1289, 44, 99, 2, 70, "Title",
 CellTags->{"S1.3.2", "2.1"},
 CellID->29492],
Cell[1391, 48, 321, 8, 70, "Text",
 CellID->12433],
Cell[1715, 58, 460, 12, 70, "Text",
 CellID->23840],
Cell[2178, 72, 848, 27, 70, "FramedBox",
 CellID->6766],
Cell[3029, 101, 167, 6, 70, "Caption",
 CellID->1735],
Cell[3199, 109, 408, 11, 70, "Text",
 CellID->19810],
Cell[3610, 122, 306, 9, 70, "Text",
 CellID->11599],
Cell[3919, 133, 668, 19, 70, "FramedBox",
 CellID->11837],
Cell[4590, 154, 105, 3, 70, "Caption",
 CellID->21892],
Cell[4698, 159, 336, 8, 70, "Text",
 CellID->31982],
Cell[5037, 169, 194, 4, 70, "Text",
 CellID->7328],
Cell[5234, 175, 240, 5, 70, "Text",
 CellID->29352],
Cell[5477, 182, 263, 7, 70, "MathCaption",
 CellID->11369],
Cell[5743, 191, 42061, 693, 70, "Picture",
 Evaluatable->False,
 CellID->31244],
Cell[47807, 886, 398, 10, 70, "Text",
 CellID->21794],
Cell[48208, 898, 165, 6, 70, "Text",
 CellID->6608],
Cell[CellGroupData[{
Cell[48398, 908, 72, 1, 70, "RelatedTutorialsSection",
 CellID->410012375],
Cell[48473, 911, 431, 12, 70, "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],
Cell[48931, 927, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

