(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     82976,       2953]
NotebookOptionsPosition[     69451,       2505]
NotebookOutlinePosition[     73646,       2598]
CellTagsIndexPosition[     73551,       2592]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DSolve" :> Documentation`HelpLookup["paclet:ref/DSolve"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"DSolve\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Differential Equations", "Title",
 CellTags->{"S3.5.11", "11.1"},
 CellID->9252],

Cell[TextData[{
 "You can use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to find symbolic solutions to ordinary and partial differential equations. \
"
}], "Text",
 CellID->11647],

Cell[TextData[{
 "Solving a differential equation consists essentially in finding the form of \
an unknown function. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", unknown functions are represented by expressions like ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ". The derivatives of such functions are represented by ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "''"}], "[", "x", "]"}]], "InlineFormula"],
 " and so on. "
}], "Text",
 CellID->17432],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " returns as its result a list of rules for functions. There is a question \
of how these functions are represented. If you ask ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to solve for ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " will indeed return a rule for ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ". In some cases, this rule may be all you need. But this rule, on its own, \
does not give values for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}]], "InlineFormula"],
 " or even ",
 Cell[BoxData[
  RowBox[{"y", "[", "0", "]"}]], "InlineFormula"],
 ". In many cases, therefore, it is better to ask ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to solve not for ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ", but instead for ",
 Cell[BoxData["y"], "InlineFormula"],
 " itself. In this case, what ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " will return is a rule which gives ",
 Cell[BoxData["y"], "InlineFormula"],
 " as a pure function, in the sense discussed in \"",
 ButtonBox["Pure Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PureFunctions"],
 ". "
}], "Text",
 CellID->9535],

Cell[TextData[{
 "If you ask ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to solve for ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ", it will give a rule specifically for ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "==", "1"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->3264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->3497]
}, Open  ]],

Cell[TextData[{
 "The rule applies only to ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 " itself, and not, for example, to objects like ",
 Cell[BoxData[
  RowBox[{"y", "[", "0", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "+", 
   RowBox[{"2", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
   RowBox[{"y", "[", "0", "]"}]}], "/.", "%"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->27649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]], " ", 
    RowBox[{"C", "[", "1", "]"}]}], "+", 
   RowBox[{"y", "[", "0", "]"}], "+", 
   RowBox[{"2", " ", 
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->22015]
}, Open  ]],

Cell[TextData[{
 "If you ask ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to solve for ",
 Cell[BoxData["y"], "InlineFormula"],
 ", it gives a rule for the object ",
 Cell[BoxData["y"], "InlineFormula"],
 " on its own as a pure function. "
}], "MathCaption",
 CellID->26841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "==", "1"}], ",", "y", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"1", "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", "x"}]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->16100]
}, Open  ]],

Cell[TextData[{
 "Now the rule applies to all occurrences of ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "+", 
   RowBox[{"2", 
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
   RowBox[{"y", "[", "0", "]"}]}], "/.", "%"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->30648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", "+", 
   RowBox[{"C", "[", "1", "]"}], "-", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]], " ", 
    RowBox[{"C", "[", "1", "]"}]}]}], "}"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->9523]
}, Open  ]],

Cell[TextData[{
 "Substituting the solution into the original equation yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
    RowBox[{"y", "[", "x", "]"}]}], "==", "1"}], "/.", "%%"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->24474],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->28633]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     StyleBox["eqn", "TI"], ",", 
     StyleBox["y", "TI"], "[", 
     StyleBox["x", "TI"], "]", ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "solve a differential equation for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["y", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     StyleBox["eqn", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "solve a differential equation for the function ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29891],

Cell["\<\
Getting solutions to differential equations in different forms. \
\>", "Caption",
 CellID->27200],

Cell[TextData[{
 "In standard mathematical notation, one typically represents solutions to \
differential equations by explicitly introducing \[OpenCurlyDoubleQuote]dummy \
variables\[CloseCurlyDoubleQuote] to represent the arguments of the functions \
that appear. If all you need is a symbolic form for the solution, then \
introducing such dummy variables may be convenient. However, if you actually \
intend to use the solution in a variety of other computations, then you will \
usually find it better to get the solution in pure\[Hyphen]function form, \
without dummy variables. Notice that this form, while easy to represent in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", has no direct analog in standard mathematical notation. "
}], "Text",
 CellID->19854],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["eqn", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["x", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["solve a list of differential equations", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->9990],

Cell["Solving simultaneous differential equations. ", "Caption",
 CellID->25697],

Cell["This solves two simultaneous differential equations. ", "MathCaption",
 CellID->4919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "==", 
      RowBox[{"-", 
       RowBox[{
        RowBox[{"z", "'"}], "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"z", "[", "x", "]"}], "==", 
      RowBox[{"-", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->17780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "x"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "x"}]]}], ")"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "-", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "x"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "x"}]]}], ")"}], " ", 
         RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "x"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "x"}]]}], ")"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "x"}]], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "x"}]]}], ")"}], " ", 
         RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{423, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->22578]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns two distinct solutions for ",
 Cell[BoxData["y"], "InlineFormula"],
 " in this case. "
}], "MathCaption",
 CellID->12931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], " ", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}]}], "==", "1"}], ",", "y", ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->32544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox["2"]}], " ", 
        SqrtBox[
         RowBox[{"x", "+", 
          RowBox[{"C", "[", "1", "]"}]}]]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         RowBox[{"x", "+", 
          RowBox[{"C", "[", "1", "]"}]}]]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{498, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->3340]
}, Open  ]],

Cell[TextData[{
 "You can add constraints and boundary conditions for differential equations \
by explicitly giving additional equations such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "[", "0", "]"}], "==", "0"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13487],

Cell[TextData[{
 "This asks for a solution which satisfies the condition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "[", "0", "]"}], "==", "1"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"a", " ", 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->22525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", " ", "x"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->8483]
}, Open  ]],

Cell[TextData[{
 "If you ask ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to solve a set of differential equations and you do not give any \
constraints or boundary conditions, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will try to find a ",
 StyleBox["general solution",
  FontSlant->"Italic"],
 " to your equations. This general solution will involve various undetermined \
constants. One new constant is introduced for each order of derivative in \
each equation you give. "
}], "Text",
 CellID->5538],

Cell[TextData[{
 "The default is that these constants are named ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ", where the index ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " starts at ",
 Cell[BoxData["1"], "InlineFormula"],
 " for each invocation of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". You can override this choice, by explicitly giving a setting for the \
option ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 ". Any function you give is applied to each successive index value ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " to get the constants to use for each invocation of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7492],

Cell["\<\
The general solution to this fourth\[Hyphen]order equation involves four \
undetermined constants. \
\>", "MathCaption",
 CellID->6193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''''"}], "[", "x", "]"}], "==", 
    RowBox[{"y", "[", "x", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->28252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "3", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "4", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->25011]
}, Open  ]],

Cell["\<\
Each independent initial or boundary condition you give reduces the number of \
undetermined constants by one. \
\>", "MathCaption",
 CellID->1560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''''"}], "[", "x", "]"}], "==", 
      RowBox[{"y", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->15834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "x"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"C", "[", "3", "]"}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]], " ", 
        RowBox[{"C", "[", "3", "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "x"}]], " ", 
        RowBox[{"C", "[", "4", "]"}]}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"C", "[", "3", "]"}], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"C", "[", "4", "]"}], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"C", "[", "4", "]"}], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{579, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->1840]
}, Open  ]],

Cell["\<\
You should realize that finding exact formulas for the solutions to \
differential equations is a difficult matter. In fact, there are only fairly \
few kinds of equations for which such formulas can be found, at least in \
terms of standard mathematical functions. \
\>", "Text",
 CellID->31497],

Cell["\<\
The most widely investigated differential equations are linear ones, in which \
the functions you are solving for, as well as their derivatives, appear only \
linearly. \
\>", "Text",
 CellID->2785],

Cell["\<\
This is a homogeneous first\[Hyphen]order linear differential equation, and \
its solution is quite simple. \
\>", "MathCaption",
 CellID->18529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->31540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       SuperscriptBox["x", "2"], "2"]], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{128, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->18805]
}, Open  ]],

Cell["\<\
Making the equation inhomogeneous leads to a significantly more complicated \
solution. \
\>", "MathCaption",
 CellID->28791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "1"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->13392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        SuperscriptBox["x", "2"], "2"]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        SuperscriptBox["x", "2"], "2"]], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      RowBox[{"Erf", "[", 
       FractionBox["x", 
        SqrtBox["2"]], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{263, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->13210]
}, Open  ]],

Cell["\<\
If you have only a single linear differential equation, and it involves only \
a first derivative of the function you are solving for, then it turns out \
that the solution can always be found just by doing integrals. \
\>", "Text",
 CellID->13549],

Cell[TextData[{
 "But as soon as you have more than one differential equation, or more than a \
first\[Hyphen]order derivative, this is no longer true. However, some simple \
second\[Hyphen]order linear differential equations can nevertheless be solved \
using various special functions from \"",
 ButtonBox["Special Functions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SpecialFunctions"],
 ". Indeed, historically many of these special functions were first \
introduced specifically in order to represent the solutions to such \
equations."
}], "Text",
 CellID->21578],

Cell["\<\
This is Airy\[CloseCurlyQuote]s equation, which is solved in terms of Airy \
functions.\
\>", "MathCaption",
 CellID->26979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->30971],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"AiryAi", "[", "x", "]"}], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"AiryBi", "[", "x", "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->9277]
}, Open  ]],

Cell["This equation comes out in terms of Bessel functions. ", "MathCaption",
 CellID->73],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->20193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"BesselI", "[", 
       RowBox[{"0", ",", 
        RowBox[{"2", " ", 
         SqrtBox[
          SuperscriptBox["\[ExponentialE]", "x"]]}]}], "]"}], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"BesselK", "[", 
       RowBox[{"0", ",", 
        RowBox[{"2", " ", 
         SqrtBox[
          SuperscriptBox["\[ExponentialE]", "x"]]}]}], "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{406, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->1620]
}, Open  ]],

Cell["This requires Mathieu functions. ", "MathCaption",
 CellID->21497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", "y", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->13826],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"MathieuC", "[", 
         RowBox[{"0", ",", 
          RowBox[{"-", "2"}], ",", 
          FractionBox["x", "2"]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"MathieuS", "[", 
         RowBox[{"0", ",", 
          RowBox[{"-", "2"}], ",", 
          FractionBox["x", "2"]}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{483, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->31276]
}, Open  ]],

Cell["And this Legendre functions. ", "MathCaption",
 CellID->19790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"Cot", "[", "x", "]"}], "^", "2"}], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->6582],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], 
       RowBox[{"1", "/", "4"}]], " ", 
      RowBox[{"LegendreP", "[", 
       RowBox[{
        FractionBox["1", "2"], ",", 
        FractionBox[
         SqrtBox["5"], "2"], ",", 
        RowBox[{"Cos", "[", "x", "]"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox[
          RowBox[{"Cos", "[", "x", "]"}], "2"]}], ")"}], 
       RowBox[{"1", "/", "4"}]], " ", 
      RowBox[{"LegendreQ", "[", 
       RowBox[{
        FractionBox["1", "2"], ",", 
        FractionBox[
         SqrtBox["5"], "2"], ",", 
        RowBox[{"Cos", "[", "x", "]"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{391, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->13578]
}, Open  ]],

Cell["\<\
Occasionally second\[Hyphen]order linear equations can be solved using only \
elementary functions. \
\>", "MathCaption",
 CellID->11159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->20418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SqrtBox["x"], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], "+", 
     RowBox[{
      SqrtBox["x"], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"Log", "[", "x", "]"}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{441, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->26489]
}, Open  ]],

Cell[TextData[{
 "Beyond second order, the kinds of functions needed to solve even fairly \
simple linear differential equations become extremely complicated. At third \
order, the generalized Meijer G function ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " can sometimes be used, but at fourth order and beyond absolutely no \
standard mathematical functions are typically adequate, except in very \
special cases. "
}], "Text",
 CellID->159],

Cell["\<\
Here is a third\[Hyphen]order linear differential equation which can be \
solved in terms of generalized hypergeometric functions. \
\>", "MathCaption",
 CellID->3449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'''"}], "[", "x", "]"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->12924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"HypergeometricPFQ", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          FractionBox["1", "2"], ",", 
          FractionBox["3", "4"]}], "}"}], ",", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["x", "4"], "64"]}]}], "]"}]}], "+", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]], 
      RowBox[{"x", " ", 
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"HypergeometricPFQ", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["3", "4"], ",", 
           FractionBox["5", "4"]}], "}"}], ",", 
         RowBox[{"-", 
          FractionBox[
           SuperscriptBox["x", "4"], "64"]}]}], "]"}]}]}], "+", 
     RowBox[{
      FractionBox["1", "8"], " ", 
      SuperscriptBox["x", "2"], " ", 
      RowBox[{"C", "[", "3", "]"}], " ", 
      RowBox[{"HypergeometricPFQ", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          FractionBox["5", "4"], ",", 
          FractionBox["3", "2"]}], "}"}], ",", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["x", "4"], "64"]}]}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{367, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->9072]
}, Open  ]],

Cell["This requires more general Meijer G functions. ", "MathCaption",
 CellID->10380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'''"}], "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->27008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"HypergeometricPFQ", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", "x"]}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"MeijerG", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", "0", "}"}]}], "}"}], ",", 
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", "x"]}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "3", "]"}], " ", 
      RowBox[{"MeijerG", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", "}"}]}], "}"}], ",", 
        SuperscriptBox["\[ExponentialE]", "x"]}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{583, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->27967]
}, Open  ]],

Cell[TextData[{
 "For nonlinear differential equations, only rather special cases can usually \
ever be solved in terms of standard mathematical functions. Nevertheless, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " includes fairly general procedures which allow it to handle almost all \
nonlinear differential equations whose solutions are found in standard \
reference books. "
}], "Text",
 CellID->10208],

Cell[TextData[{
 "First\[Hyphen]order nonlinear differential equations in which ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " does not appear on its own are fairly easy to solve. "
}], "MathCaption",
 CellID->6477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->18503],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", "x"}], "-", 
      RowBox[{"C", "[", "1", "]"}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{136, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->15370]
}, Open  ]],

Cell["\<\
This Riccati equation already gives a significantly more complicated \
solution.\
\>", "MathCaption",
 CellID->32607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "==", "x"}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->14196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SqrtBox["x"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"BesselJ", "[", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["2", "3"]}], ",", 
            FractionBox[
             RowBox[{"2", " ", 
              SuperscriptBox["x", 
               RowBox[{"3", "/", "2"}]]}], "3"]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"BesselJ", "[", 
           RowBox[{
            FractionBox["2", "3"], ",", 
            FractionBox[
             RowBox[{"2", " ", 
              SuperscriptBox["x", 
               RowBox[{"3", "/", "2"}]]}], "3"]}], "]"}], " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BesselJ", "[", 
        RowBox[{
         FractionBox["1", "3"], ",", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox["x", 
            RowBox[{"3", "/", "2"}]]}], "3"]}], "]"}], "+", 
       RowBox[{
        RowBox[{"BesselJ", "[", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "3"]}], ",", 
          FractionBox[
           RowBox[{"2", " ", 
            SuperscriptBox["x", 
             RowBox[{"3", "/", "2"}]]}], "3"]}], "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{434, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->12074]
}, Open  ]],

Cell["\<\
This Bernoulli equation, however, has a fairly simple solution.\
\>", "MathCaption",
 CellID->13722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "-", 
     RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->12611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", "x"], 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", "x"]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", "x"}], "-", 
       RowBox[{"C", "[", "1", "]"}]}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{184, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->19019]
}, Open  ]],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " order Bernoulli equation typically has ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "-", "1"}], TraditionalForm]], "InlineMath"],
 " distinct solutions. "
}], "MathCaption",
 CellID->28761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "3"}]}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->11056],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       SqrtBox["2"], 
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "x"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "x"}]], " ", 
          RowBox[{"C", "[", "1", "]"}]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
     FractionBox[
      SqrtBox["2"], 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"2", " ", "x"}]], " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->12890]
}, Open  ]],

Cell["This Abel equation can be solved, but only implicitly.", "MathCaption",
 CellID->31163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "3"}]}], "+", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->16683],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"tdep\"\>"}], ":", 
  " ", "\<\"The equations appear to involve the variables to be solved for in \
an essentially non-algebraic way.\"\>"}]], "Message", "MSG",
 CellID->13716],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", 
         RowBox[{"ArcTanh", "[", 
          FractionBox[
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{"2", " ", "x", " ", 
             RowBox[{"y", "[", "x", "]"}]}]}], 
           SqrtBox["5"]], "]"}]}], 
        SqrtBox["5"]], "+", 
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"x", " ", 
           RowBox[{"y", "[", "x", "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"x", " ", 
              RowBox[{"y", "[", "x", "]"}]}]}], ")"}]}]}], 
         RowBox[{
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox[
           RowBox[{"y", "[", "x", "]"}], "2"]}]], "]"}]}], ")"}]}], 
    "\[Equal]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "-", 
     RowBox[{"Log", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{550, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->19932]
}, Open  ]],

Cell[TextData[{
 "In practical applications, it is quite often convenient to set up \
differential equations that involve piecewise functions. You can use ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " to find symbolic solutions to such equations. "
}], "Text",
 CellID->25452],

Cell["This equation involves a piecewise forcing function. ", "MathCaption",
 CellID->2741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
     RowBox[{"y", "[", "x", "]"}]}], "==", 
    RowBox[{"UnitStep", "[", "x", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->4954],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWDtvFDEQ9u3jLk8iKC45KaATBUVCGahRilCliUL6U5QoKRAoRII/AA2/
N7XxeO1b+/Pszi66hWSlO3v8GM98M+Oxfbq4v7n6vLi/vVzMP94tvt7cXn6b
n3y5M035SCn1YH4v95Spa1OzvwetTVn9/zb/hWm8ttQv+s9pjP1UBvQZ0C/s
rJ/QmgM9Nn+lIXdcuWdK6s4dTWWmXEVVX+bkQl7P7ZDCzShd+UOQYA3oZwFN
q+0L85HOnIRhW8nMCWW0/QmnAui+mpQOw5BPZ43KJe1mSTohjdJnnXT8LvRL
1qLq7K/1Q7Q4Cf6PXoj+LqNT5qXnbZe0Pg5NKfIpmm17UberCAO/frYU3H6u
xfeQbLmPp5Vr5vcdH7WbrnwL9OueCEwdX6/FVoIEWn86iH4SvQn0gdA/F/hN
nL6vAr0nqsoB/0i7GmUdexKO3gDa762kM+dxTbvJpIHPliDtm1haU0H0u6GE
noSjooyEs6P1cQRaP7QHheq2XsUehPhhbtthpCB9Lhg929YZVfzcqYObUcLK
TTl+zKy0rtKsvA3juHmS5bhszyES0p86rEuHRUKkQkXyIYgsxspN2Eg+RFWM
xL44SR6UM9EoYdbNm7rkFzlC5EhEhFBDtB/mo1Ujiuu1yUfV857rt+z/0f6e
L+H0X56MacsBdKOhweilffHyJx6M+AFxaIkxpGcxJqrpTNl3554mfCXchtM/
PK3t63ovKlR9f8R75MyVbd4+nNTv3eq+lKSgfiIPdezT/r491kOelN8ltj5K
WiTr2/7E6w4TPmzOeCR3HV4Hf1/YCGzyNCReC8pVSdz3vaarX6y3osu9CaQv
Ml1er1LeBzqOOcx3vIfyr1mcBP4OmvL40IMzvufRmYfIY12/wGH28y+DavQH
rJysNA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{245, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->75229215]
}, Open  ]],

Cell["Here the solution is explicitly broken into three cases. ", \
"MathCaption",
 CellID->2862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{"Clip", "[", "x", "]"}], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->10396],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWDtvE0EQXt96YztReKQJBKQYCkQVuSIo6UACCYkCUUAipbAikFMgIuOa
/ASXLq38AvdpXLr0T/FP2Ozr7uZmx7dLzpELTvLNfbszs/Palz93B70fv7qD
i/Nu+2O/e9m7OP/T/vC7r5p4jTF2o36HT5j6lurL/G6kVLSu3omCwtExwsJw
cf3mWso8Rgri60B/8p9q0Vx1EM0tR/sIb6xktBDeQvgy0B/SV8GqeoZdBBJH
MfcmwjqSQsEvivK0PpFNgtAT50sS4CrMCiyd+0Rw4NjCqKk3+2rUw6iwO3iB
R8X9NauXW0JJQMwIP7hcXrEtZHHmF+ALVTrGFL9e0LQntaicoXojorrMp1DO
eBpKPhqNptPpbDZjnyr6G5fBmHUnXE3hqsWzD2fXH2c8HrOmp3df2tmaOMoB
1pF/WDFqFVaqwkrEszClD/d4ylarHWnXe6tZxSKTqgOpF1HZgnWt8eP1xahk
TmC8Z3DmOWtU8jmrjcor4+q8h/v2c+StyUmh8tvFFvVsFGtM2qp7JPPKSZh/
LlvNCeENsvc1iG0e9eN7G0vcm/beGrXiXGEtPyV1pn6PuAZkq54/esBtR0+X
ckG7thGmpZoBqZMVSkELmfMH4rtZ+AzhY1KLnTvz+fzKPCzRL41dv0D9DdM/
HA7BqMLfC4j1qql+B7kN3g5gVCwWCzOAeSngtOH+pumfTCauvyXzXcTfkWAN
Fm3sGPLOWGpV688OitzyfS4/5eTcB0CnOvhYIz2d5Gmh9PzRKep1tjZc/Fse
/y7SiPdIkIuSqtp03u46uuNo55+kz6K4jQ8C+pAyfI+Sf4AwLZXuujge30ju
vSiupyib9Mhxuui1bm2tAs5TqlJfSipr6c1ed7wlx0hPfK+kf280050YK05T
OjNxfQBpoe4j9lZS5lXpzQjfB6z2K7L1r7PsyCD77xKr3QL+qxJY\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{186, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->352539531]
}, Open  ]],

Cell[TextData[{
 "Beyond ordinary differential equations, one can consider ",
 StyleBox["differential-algebraic equations",
  FontSlant->"Italic"],
 " that involve a mixture of differential and algebraic equations."
}], "Text",
 CellID->20615],

Cell["\<\
This solves a differential\[Hyphen]algebraic equation. \
\>", "MathCaption",
 CellID->10904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
       RowBox[{"3", 
        RowBox[{
         RowBox[{"z", "'"}], "[", "x", "]"}]}]}], "==", 
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"y", "[", "x", "]"}]}], "+", 
       RowBox[{"1", "/", "x"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "+", 
       RowBox[{"z", "[", "x", "]"}]}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], ",", 
     RowBox[{"z", "[", "x", "]"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->2599],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["3", "2"], "+", 
      RowBox[{
       FractionBox["1", "18"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "2"}], " ", "x"}]]}], " ", 
          RowBox[{"C", "[", "1", "]"}]}], "-", 
         RowBox[{"9", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "x"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "x"}]]}], "+", 
            RowBox[{"ExpIntegralEi", "[", 
             RowBox[{"2", " ", "x"}], "]"}]}], ")"}]}]}], ")"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "x", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], "+", 
      RowBox[{
       FractionBox["1", "18"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "x"}]], " ", 
          RowBox[{"C", "[", "1", "]"}]}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "x"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "x"}]]}], "+", 
            RowBox[{"ExpIntegralEi", "[", 
             RowBox[{"2", " ", "x"}], "]"}]}], ")"}]}]}], ")"}]}]}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{427, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->20136]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     RowBox[{
      StyleBox["eqn", "TI"], ",", 
      RowBox[{
       StyleBox["y", "TI"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "solve a partial differential equation for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["y", "TI"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DSolve",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DSolve"], "[", 
     StyleBox["eqn", "TI"], ",", 
     StyleBox["y", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "solve a partial differential equation for the function ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4680],

Cell["Solving partial differential equations. ", "Caption",
 CellID->9198],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is set up to handle not only ",
 StyleBox["ordinary differential equations",
  FontSlant->"Italic"],
 " in which just a single independent variable appears, but also ",
 StyleBox["partial differential equations",
  FontSlant->"Italic"],
 " in which two or more independent variables appear. "
}], "Text",
 CellID->27032],

Cell["\<\
This finds the general solution to a simple partial differential equation \
with two independent variables. \
\>", "MathCaption",
 CellID->14387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}], "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}], "==", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x1", " ", "x2"}], ")"}]}]}], ",", 
   RowBox[{"y", "[", 
    RowBox[{"x1", ",", "x2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->32584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"x1", ",", "x2"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"x1", "-", "x2"}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Log", "[", "x1", "]"}]}], "+", 
       RowBox[{"Log", "[", "x2", "]"}], "+", 
       RowBox[{"x1", " ", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "[", 
         RowBox[{
          RowBox[{"-", "x1"}], "+", "x2"}], "]"}]}], "-", 
       RowBox[{"x2", " ", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "[", 
         RowBox[{
          RowBox[{"-", "x1"}], "+", "x2"}], "]"}]}]}], ")"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{529, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->7240]
}, Open  ]],

Cell["Here is the result represented as a pure function. ", "MathCaption",
 CellID->3517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}], "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}], "==", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"x1", " ", "x2"}], ")"}]}]}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[29]:= ",
 CellID->17006],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"x1", "-", "x2"}]], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Log", "[", "x1", "]"}]}], "+", 
         RowBox[{"Log", "[", "x2", "]"}], "+", 
         RowBox[{"x1", " ", 
          RowBox[{
           RowBox[{"C", "[", "1", "]"}], "[", 
           RowBox[{
            RowBox[{"-", "x1"}], "+", "x2"}], "]"}]}], "-", 
         RowBox[{"x2", " ", 
          RowBox[{
           RowBox[{"C", "[", "1", "]"}], "[", 
           RowBox[{
            RowBox[{"-", "x1"}], "+", "x2"}], "]"}]}]}], ")"}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{473, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]= ",
 CellID->8670]
}, Open  ]],

Cell[TextData[{
 "The basic mathematics of partial differential equations is considerably \
more complicated than that of ordinary differential equations. One feature is \
that whereas the general solution to an ordinary differential equation \
involves only arbitrary ",
 StyleBox["constants",
  FontSlant->"Italic"],
 ", the general solution to a partial differential equation, if it can be \
found at all, must involve arbitrary ",
 StyleBox["functions",
  FontSlant->"Italic"],
 ". Indeed, with ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " independent variables, arbitrary functions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "-", "1"}], TraditionalForm]], "InlineMath"],
 " arguments appear. ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " by default names these functions ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->241],

Cell["Here is a simple PDE involving three independent variables. ", \
"MathCaption",
 CellID->18882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "x1"}], "]"}], "+", 
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "x2"}], "]"}], "+", 
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "x3"}], "]"}]}], ")"}], "&"}], "[", 
   RowBox[{"y", "[", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "]"}], "]"}], "==", "0"}]], "Input",\

 CellLabel->"In[30]:= ",
 CellID->25249],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["y", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "]"}], "+", 
   RowBox[{
    SuperscriptBox["y", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "]"}], "+", 
   RowBox[{
    SuperscriptBox["y", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "]"}]}], "\[Equal]", 
  "0"}]], "Output",
 ImageSize->{416, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]= ",
 CellID->3523]
}, Open  ]],

Cell["\<\
The solution involves an arbitrary function of two variables. \
\>", "MathCaption",
 CellID->31758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"y", "[", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[31]:= ",
 CellID->12105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"x1", ",", "x2", ",", "x3"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x1"}], "+", "x2"}], ",", 
      RowBox[{
       RowBox[{"-", "x1"}], "+", "x3"}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]= ",
 CellID->29621]
}, Open  ]],

Cell["\<\
Here is the one\[Hyphen]dimensional wave equation. \
\>", "MathCaption",
 CellID->17095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"c", "^", "2"}], " ", 
       RowBox[{"D", "[", 
        RowBox[{"#", ",", "x", ",", "x"}], "]"}]}], "-", 
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "t", ",", "t"}], "]"}]}], ")"}], "&"}], "[", 
   RowBox[{"y", "[", 
    RowBox[{"x", ",", "t"}], "]"}], "]"}], "==", "0"}]], "Input",
 CellLabel->"In[32]:= ",
 CellID->7296],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox["y", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "2"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "t"}], "]"}]}], "+", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{
     SuperscriptBox["y", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"2", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "t"}], "]"}]}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{208, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]= ",
 CellID->9916]
}, Open  ]],

Cell["\<\
The solution to this second\[Hyphen]order equation involves two arbitrary \
functions. \
\>", "MathCaption",
 CellID->15678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"y", "[", 
    RowBox[{"x", ",", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "t"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[33]:= ",
 CellID->10178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"x", ",", "t"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], "[", 
      RowBox[{"t", "-", 
       FractionBox[
        RowBox[{
         SqrtBox[
          SuperscriptBox["c", "2"]], " ", "x"}], 
        SuperscriptBox["c", "2"]]}], "]"}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], "[", 
      RowBox[{"t", "+", 
       FractionBox[
        RowBox[{
         SqrtBox[
          SuperscriptBox["c", "2"]], " ", "x"}], 
        SuperscriptBox["c", "2"]]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{322, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]= ",
 CellID->13579]
}, Open  ]],

Cell["\<\
For an ordinary differential equation, it is guaranteed that a general \
solution must exist, with the property that adding initial or boundary \
conditions simply corresponds to forcing specific choices for arbitrary \
constants in the solution. But for partial differential equations this is no \
longer true. Indeed, it is only for linear partial differential and a few \
other special types that such general solutions exist.\
\>", "Text",
 CellID->25058],

Cell["\<\
Other partial differential equations can be solved only when specific initial \
or boundary values are given, and in the vast majority of cases no solutions \
can be found as exact formulas in terms of standard mathematical functions. \
\>", "Text",
 CellID->27577],

Cell[TextData[{
 "Since ",
 Cell[BoxData["y"], "InlineFormula"],
 " and its derivatives appear only linearly here, a general solution exists. \
"
}], "MathCaption",
 CellID->12750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x1", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}]}], "+", 
     RowBox[{"x2", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}]}], "==", 
    RowBox[{"Exp", "[", 
     RowBox[{"x1", " ", "x2"}], "]"}]}], ",", 
   RowBox[{"y", "[", 
    RowBox[{"x1", ",", "x2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[34]:= ",
 CellID->14007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"x1", ",", "x2"}], "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ExpIntegralEi", "[", 
        RowBox[{"x1", " ", "x2"}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "[", 
         FractionBox["x2", "x1"], "]"}]}]}], ")"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{356, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]= ",
 CellID->23729]
}, Open  ]],

Cell["\<\
This weakly nonlinear PDE turns out to have a general solution. \
\>", "MathCaption",
 CellID->24081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}], "+", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}], "==", 
    RowBox[{"Exp", "[", 
     RowBox[{"y", "[", 
      RowBox[{"x1", ",", "x2"}], "]"}], "]"}]}], ",", 
   RowBox[{"y", "[", 
    RowBox[{"x1", ",", "x2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[35]:= ",
 CellID->2995],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"x1", ",", "x2"}], "]"}], "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "x1"}], "-", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         RowBox[{"-", "x1"}], "+", "x2"}], "]"}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]= ",
 CellID->2678]
}, Open  ]],

Cell["Here is a nonlinear PDE which has no general solution. ", "MathCaption",
 CellID->24676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}], " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}], "==", "a"}], 
   ",", 
   RowBox[{"y", "[", 
    RowBox[{"x1", ",", "x2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[36]:= ",
 CellID->27753],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a complete integral.\"\>"}]], "Message", "MSG",
 CellID->20899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"x1", ",", "x2"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "+", 
     FractionBox[
      RowBox[{"a", " ", "x1"}], 
      RowBox[{"C", "[", "2", "]"}]], "+", 
     RowBox[{"x2", " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{239, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]= ",
 CellID->11784]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->233673891],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Differential Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingIntegralsInSymbolicForm"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 1.8749502}", "context" -> "", 
    "keywords" -> {
     "Abel equations", "Airy's differential equation", "Bernoulli equations", 
      "boundary conditions", "C", "closed-form solutions", 
      "constants of integration", "DAE", "derivative", 
      "differential-algebraic equations", "differential equations", "DSolve", 
      "dummy variables", "equations", "general solutions", 
      "GeneratedParameters", "Hamilton-Jacobi equations", 
      "homogeneous differential equations", 
      "inhomogeneous differential equations", "linear differential equations",
       "MeijerG", "multivariate differential equations", 
      "nonlinear differential equations", "ODE", 
      "ordinary differential equations", "partial differential equations", 
      "PDE", "piecewise differential equations", "pure functions", 
      "quasilinear PDE", "Riccati equations", 
      "solving differential equations", "undetermined coefficients", 
      "wave equation"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "You can use the Mathematica function DSolve to find symbolic solutions \
to ordinary and partial differential equations. Solving a differential \
equation consists essentially in finding the form of an unknown function. In \
Mathematica, unknown functions are represented by expressions like y[x]. The \
derivatives of such functions are represented by y'[x], y''[x] and so on. The \
Mathematica function DSolve returns as its result a list of rules for \
functions. There is a question of how these functions are represented. If you \
ask DSolve to solve for y[x], then DSolve will indeed return a rule for y[x]. \
In some cases, this rule may be all you need. But this rule, on its own, does \
not give values for y'[x] or even y[0]. In many cases, therefore, it is \
better to ask DSolve to solve not for y[x], but instead for y itself. In this \
case, what DSolve will return is a rule which gives y as a pure function, in \
the sense discussed in \"Pure Functions\". ", "synonyms" -> {"3.5.11"}, 
    "title" -> "Differential Equations", "type" -> "Tutorial", "uri" -> 
    "tutorial/DifferentialEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.11"->{
  Cell[1754, 57, 86, 2, 70, "Title",
   CellTags->{"S3.5.11", "11.1"},
   CellID->9252]},
 "11.1"->{
  Cell[1754, 57, 86, 2, 70, "Title",
   CellTags->{"S3.5.11", "11.1"},
   CellID->9252]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.11", 73337, 2581},
 {"11.1", 73438, 2585}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1129, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1754, 57, 86, 2, 70, "Title",
 CellTags->{"S3.5.11", "11.1"},
 CellID->9252],
Cell[1843, 61, 325, 12, 70, "Text",
 CellID->11647],
Cell[2171, 75, 580, 18, 70, "Text",
 CellID->17432],
Cell[2754, 95, 1767, 57, 70, "Text",
 CellID->9535],
Cell[4524, 154, 381, 14, 70, "MathCaption",
 CellID->7208],
Cell[CellGroupData[{
Cell[4930, 172, 294, 10, 28, "Input",
 CellID->3264],
Cell[5227, 184, 408, 14, 36, "Output",
 CellID->3497]
}, Open  ]],
Cell[5650, 201, 364, 13, 70, "MathCaption",
 CellID->23243],
Cell[CellGroupData[{
Cell[6039, 218, 251, 9, 28, "Input",
 CellID->27649],
Cell[6293, 229, 484, 16, 36, "Output",
 CellID->22015]
}, Open  ]],
Cell[6792, 248, 350, 12, 70, "MathCaption",
 CellID->26841],
Cell[CellGroupData[{
Cell[7167, 264, 267, 10, 70, "Input",
 CellID->189],
Cell[7437, 276, 479, 16, 36, "Output",
 CellID->16100]
}, Open  ]],
Cell[7931, 295, 142, 5, 70, "MathCaption",
 CellID->19812],
Cell[CellGroupData[{
Cell[8098, 304, 251, 9, 70, "Input",
 CellID->30648],
Cell[8352, 315, 354, 12, 36, "Output",
 CellID->9523]
}, Open  ]],
Cell[8721, 330, 232, 8, 70, "MathCaption",
 CellID->19851],
Cell[CellGroupData[{
Cell[8978, 342, 220, 8, 70, "Input",
 CellID->24474],
Cell[9201, 352, 180, 6, 36, "Output",
 CellID->28633]
}, Open  ]],
Cell[9396, 361, 1160, 36, 70, "DefinitionBox",
 CellID->29891],
Cell[10559, 399, 107, 3, 70, "Caption",
 CellID->27200],
Cell[10669, 404, 776, 13, 70, "Text",
 CellID->19854],
Cell[11448, 419, 1260, 38, 70, "DefinitionBox",
 CellID->9990],
Cell[12711, 459, 80, 1, 70, "Caption",
 CellID->25697],
Cell[12794, 462, 91, 1, 70, "MathCaption",
 CellID->4919],
Cell[CellGroupData[{
Cell[12910, 467, 506, 18, 70, "Input",
 CellID->17780],
Cell[13419, 487, 1908, 58, 81, "Output",
 CellID->22578]
}, Open  ]],
Cell[15342, 548, 197, 7, 70, "MathCaption",
 CellID->12931],
Cell[CellGroupData[{
Cell[15564, 559, 270, 10, 70, "Input",
 CellID->32544],
Cell[15837, 571, 784, 29, 43, "Output",
 CellID->3340]
}, Open  ]],
Cell[16636, 603, 272, 8, 70, "Text",
 CellID->13487],
Cell[16911, 613, 205, 7, 70, "MathCaption",
 CellID->899],
Cell[CellGroupData[{
Cell[17141, 624, 411, 14, 70, "Input",
 CellID->22525],
Cell[17555, 640, 325, 11, 36, "Output",
 CellID->8483]
}, Open  ]],
Cell[17895, 654, 531, 15, 70, "Text",
 CellID->5538],
Cell[18429, 671, 1059, 34, 70, "Text",
 CellID->7492],
Cell[19491, 707, 145, 4, 70, "MathCaption",
 CellID->6193],
Cell[CellGroupData[{
Cell[19661, 715, 270, 9, 70, "Input",
 CellID->28252],
Cell[19934, 726, 713, 23, 36, "Output",
 CellID->25011]
}, Open  ]],
Cell[20662, 752, 157, 4, 70, "MathCaption",
 CellID->1560],
Cell[CellGroupData[{
Cell[20844, 760, 453, 15, 70, "Input",
 CellID->15834],
Cell[21300, 777, 1215, 36, 39, "Output",
 CellID->1840]
}, Open  ]],
Cell[22530, 816, 306, 6, 70, "Text",
 CellID->31497],
Cell[22839, 824, 208, 5, 70, "Text",
 CellID->2785],
Cell[23050, 831, 155, 4, 70, "MathCaption",
 CellID->18529],
Cell[CellGroupData[{
Cell[23230, 839, 323, 11, 70, "Input",
 CellID->31540],
Cell[23556, 852, 413, 14, 51, "Output",
 CellID->18805]
}, Open  ]],
Cell[23984, 869, 135, 4, 70, "MathCaption",
 CellID->28791],
Cell[CellGroupData[{
Cell[24144, 877, 323, 11, 70, "Input",
 CellID->13392],
Cell[24470, 890, 701, 24, 61, "Output",
 CellID->13210]
}, Open  ]],
Cell[25186, 917, 258, 5, 70, "Text",
 CellID->13549],
Cell[25447, 924, 582, 12, 70, "Text",
 CellID->21578],
Cell[26032, 938, 134, 4, 70, "MathCaption",
 CellID->26979],
Cell[CellGroupData[{
Cell[26191, 946, 324, 11, 70, "Input",
 CellID->30971],
Cell[26518, 959, 476, 16, 36, "Output",
 CellID->9277]
}, Open  ]],
Cell[27009, 978, 90, 1, 70, "MathCaption",
 CellID->73],
Cell[CellGroupData[{
Cell[27124, 983, 358, 12, 70, "Input",
 CellID->20193],
Cell[27485, 997, 732, 24, 47, "Output",
 CellID->1620]
}, Open  ]],
Cell[28232, 1024, 72, 1, 70, "MathCaption",
 CellID->21497],
Cell[CellGroupData[{
Cell[28329, 1029, 332, 12, 70, "Input",
 CellID->13826],
Cell[28664, 1043, 748, 25, 49, "Output",
 CellID->31276]
}, Open  ]],
Cell[29427, 1071, 68, 1, 70, "MathCaption",
 CellID->19790],
Cell[CellGroupData[{
Cell[29520, 1076, 385, 13, 70, "Input",
 CellID->6582],
Cell[29908, 1091, 1213, 41, 91, "Output",
 CellID->13578]
}, Open  ]],
Cell[31136, 1135, 147, 4, 70, "MathCaption",
 CellID->11159],
Cell[CellGroupData[{
Cell[31308, 1143, 352, 12, 70, "Input",
 CellID->20418],
Cell[31663, 1157, 763, 27, 51, "Output",
 CellID->26489]
}, Open  ]],
Cell[32441, 1187, 519, 12, 70, "Text",
 CellID->159],
Cell[32963, 1201, 177, 4, 70, "MathCaption",
 CellID->3449],
Cell[CellGroupData[{
Cell[33165, 1209, 325, 11, 70, "Input",
 CellID->12924],
Cell[33493, 1222, 1597, 53, 124, "Output",
 CellID->9072]
}, Open  ]],
Cell[35105, 1278, 86, 1, 70, "MathCaption",
 CellID->10380],
Cell[CellGroupData[{
Cell[35216, 1283, 359, 12, 70, "Input",
 CellID->27008],
Cell[35578, 1297, 1510, 49, 71, "Output",
 CellID->27967]
}, Open  ]],
Cell[37103, 1349, 483, 11, 70, "Text",
 CellID->10208],
Cell[37589, 1362, 238, 6, 70, "MathCaption",
 CellID->6477],
Cell[CellGroupData[{
Cell[37852, 1372, 323, 11, 70, "Input",
 CellID->18503],
Cell[38178, 1385, 365, 13, 53, "Output",
 CellID->15370]
}, Open  ]],
Cell[38558, 1401, 127, 4, 70, "MathCaption",
 CellID->32607],
Cell[CellGroupData[{
Cell[38710, 1409, 369, 13, 70, "Input",
 CellID->14196],
Cell[39082, 1424, 1609, 52, 87, "Output",
 CellID->12074]
}, Open  ]],
Cell[40706, 1479, 110, 3, 70, "MathCaption",
 CellID->13722],
Cell[CellGroupData[{
Cell[40841, 1486, 392, 13, 70, "Input",
 CellID->12611],
Cell[41236, 1501, 557, 18, 54, "Output",
 CellID->19019]
}, Open  ]],
Cell[41808, 1522, 362, 13, 70, "MathCaption",
 CellID->28761],
Cell[CellGroupData[{
Cell[42195, 1539, 392, 13, 70, "Input",
 CellID->11056],
Cell[42590, 1554, 950, 32, 67, "Output",
 CellID->12890]
}, Open  ]],
Cell[43555, 1589, 93, 1, 70, "MathCaption",
 CellID->31163],
Cell[CellGroupData[{
Cell[43673, 1594, 419, 14, 70, "Input",
 CellID->16683],
Cell[44095, 1610, 229, 5, 70, "Message",
 CellID->13716],
Cell[44327, 1617, 1268, 42, 84, "Output",
 CellID->19932]
}, Open  ]],
Cell[45610, 1662, 351, 9, 70, "Text",
 CellID->25452],
Cell[45964, 1673, 91, 1, 70, "MathCaption",
 CellID->2741],
Cell[CellGroupData[{
Cell[46080, 1678, 332, 11, 28, "Input",
 CellID->4954],
Cell[46415, 1691, 1136, 23, 50, "Output",
 Evaluatable->False,
 CellID->75229215]
}, Open  ]],
Cell[47566, 1717, 97, 2, 70, "MathCaption",
 CellID->2862],
Cell[CellGroupData[{
Cell[47688, 1723, 358, 12, 28, "Input",
 CellID->10396],
Cell[48049, 1737, 1181, 23, 76, "Output",
 Evaluatable->False,
 CellID->352539531]
}, Open  ]],
Cell[49245, 1763, 243, 6, 70, "Text",
 CellID->20615],
Cell[49491, 1771, 102, 3, 70, "MathCaption",
 CellID->10904],
Cell[CellGroupData[{
Cell[49618, 1778, 722, 25, 70, "Input",
 CellID->2599],
Cell[50343, 1805, 1894, 59, 81, "Output",
 CellID->20136]
}, Open  ]],
Cell[52252, 1867, 2228, 70, 70, "DefinitionBox",
 CellID->4680],
Cell[54483, 1939, 74, 1, 70, "Caption",
 CellID->9198],
Cell[54560, 1942, 454, 13, 70, "Text",
 CellID->27032],
Cell[55017, 1957, 155, 4, 70, "MathCaption",
 CellID->14387],
Cell[CellGroupData[{
Cell[55197, 1965, 616, 21, 70, "Input",
 CellID->32584],
Cell[55816, 1988, 846, 29, 51, "Output",
 CellID->7240]
}, Open  ]],
Cell[56677, 2020, 89, 1, 70, "MathCaption",
 CellID->3517],
Cell[CellGroupData[{
Cell[56791, 2025, 560, 19, 70, "Input",
 CellID->17006],
Cell[57354, 2046, 945, 31, 73, "Output",
 CellID->8670]
}, Open  ]],
Cell[58314, 2080, 1071, 32, 70, "Text",
 CellID->241],
Cell[59388, 2114, 101, 2, 70, "MathCaption",
 CellID->18882],
Cell[CellGroupData[{
Cell[59514, 2120, 451, 16, 70, "Input",
 CellID->25249],
Cell[59968, 2138, 881, 32, 36, "Output",
 CellID->3523]
}, Open  ]],
Cell[60864, 2173, 109, 3, 70, "MathCaption",
 CellID->31758],
Cell[CellGroupData[{
Cell[60998, 2180, 262, 8, 70, "Input",
 CellID->12105],
Cell[61263, 2190, 492, 17, 36, "Output",
 CellID->29621]
}, Open  ]],
Cell[61770, 2210, 98, 3, 70, "MathCaption",
 CellID->17095],
Cell[CellGroupData[{
Cell[61893, 2217, 439, 15, 70, "Input",
 CellID->7296],
Cell[62335, 2234, 687, 26, 36, "Output",
 CellID->9916]
}, Open  ]],
Cell[63037, 2263, 134, 4, 70, "MathCaption",
 CellID->15678],
Cell[CellGroupData[{
Cell[63196, 2271, 236, 8, 70, "Input",
 CellID->10178],
Cell[63435, 2281, 765, 27, 62, "Output",
 CellID->13579]
}, Open  ]],
Cell[64215, 2311, 469, 8, 70, "Text",
 CellID->25058],
Cell[64687, 2321, 275, 5, 70, "Text",
 CellID->27577],
Cell[64965, 2328, 180, 6, 70, "MathCaption",
 CellID->12750],
Cell[CellGroupData[{
Cell[65170, 2338, 658, 22, 70, "Input",
 CellID->14007],
Cell[65831, 2362, 598, 21, 51, "Output",
 CellID->23729]
}, Open  ]],
Cell[66444, 2386, 111, 3, 70, "MathCaption",
 CellID->24081],
Cell[CellGroupData[{
Cell[66580, 2393, 627, 21, 70, "Input",
 CellID->2995],
Cell[67210, 2416, 519, 19, 36, "Output",
 CellID->2678]
}, Open  ]],
Cell[67744, 2438, 94, 1, 70, "MathCaption",
 CellID->24676],
Cell[CellGroupData[{
Cell[67863, 2443, 540, 19, 70, "Input",
 CellID->27753],
Cell[68406, 2464, 231, 5, 70, "Message",
 CellID->20899],
Cell[68640, 2471, 499, 17, 53, "Output",
 CellID->11784]
}, Open  ]],
Cell[CellGroupData[{
Cell[69176, 2493, 72, 1, 70, "RelatedTutorialsSection",
 CellID->233673891],
Cell[69251, 2496, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[69424, 2503, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

