(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22216,        832]
NotebookOptionsPosition[     17415,        676]
NotebookOutlinePosition[     19850,        741]
CellTagsIndexPosition[     19759,        735]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> 
          Documentation`HelpLookup["paclet:tutorial/CalculusOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Calculus\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"D" :> Documentation`HelpLookup["paclet:ref/D"], "NonConstants" :> 
          Documentation`HelpLookup["paclet:ref/NonConstants"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"D\"\>", 
       2->"\<\"NonConstants\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Differentiation", "Title",
 CellTags->{"S3.5.1", "1.1"},
 CellID->15469],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "partial derivative ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox["\[PartialD]", 
         RowBox[{"\[PartialD]", "x"}]], "f"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "multiple derivative ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox["\[PartialD]", 
         RowBox[{"\[PartialD]", "x"}]], 
        FractionBox["\[PartialD]", 
         RowBox[{"\[PartialD]", "y"}]], "\[Ellipsis]", "f"}], 
       TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " derivative ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox[
         SuperscriptBox["\[PartialD]", "n"], 
         RowBox[{"\[PartialD]", 
          SuperscriptBox["x", "n"]}]], "f"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      RowBox[{
       ButtonBox["NonConstants",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NonConstants"], "->", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["v", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox["\[PartialD]", 
         RowBox[{"\[PartialD]", "x"}]], "f"}], TraditionalForm]], 
      "InlineMath"],
     " with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " taken to depend on ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22912],

Cell["Partial differentiation operations. ", "Caption",
 CellID->8146],

Cell[TextData[{
 "This gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[PartialD]", 
     RowBox[{"\[PartialD]", "x"}]], 
    SuperscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->9091],

Cell[BoxData[
 RowBox[{"n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->9815]
}, Open  ]],

Cell["This gives the third derivative. ", "MathCaption",
 CellID->26949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->26857],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", "n", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "n"}]]}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->20640]
}, Open  ]],

Cell["\<\
You can differentiate with respect to any expression that does not involve \
explicit mathematical operations.\
\>", "MathCaption",
 CellID->26052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"x", "[", "2", "]"}], "^", "2"}]}], ",", 
   RowBox[{"x", "[", "1", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->236],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"x", "[", "1", "]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->8551]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " does ",
 StyleBox["partial differentiation",
  FontSlant->"Italic"],
 ". It assumes here that ",
 Cell[BoxData["y"], "InlineFormula"],
 " is independent of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31226],

Cell[BoxData[
 RowBox[{"2", " ", "x"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->28162]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData["y"], "InlineFormula"],
 " does in fact depend on ",
 Cell[BoxData["x"], "InlineFormula"],
 ", you can use the explicit functional form ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ". \"",
 ButtonBox["The Representation of Derivatives\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TheRepresentationOfDerivatives"],
 " describes how objects like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"y", "'"}], "[", "x", "]"}]], "InlineFormula"],
 " work. "
}], "MathCaption",
 CellID->16955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->23183],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"y", "[", "x", "]"}], " ", 
   RowBox[{
    SuperscriptBox["y", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->8394]
}, Open  ]],

Cell[TextData[{
 "Instead of giving an explicit function ",
 Cell[BoxData[
  RowBox[{"y", "[", "x", "]"}]], "InlineFormula"],
 ", you can tell ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " that ",
 Cell[BoxData["y"], "InlineFormula"],
 " ",
 StyleBox["implicitly",
  FontSlant->"Italic"],
 " depends on ",
 Cell[BoxData["x"], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{"y", ",", "x", ",", 
    RowBox[{
     ButtonBox["NonConstants",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NonConstants"], "->", 
     RowBox[{"{", "y", "}"}]}]}], "]"}]], "InlineFormula"],
 " then represents ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", "y"}], 
    RowBox[{"\[PartialD]", "x"}]], TraditionalForm]], "InlineMath"],
 ", with ",
 Cell[BoxData["y"], "InlineFormula"],
 " implicitly depending on ",
 Cell[BoxData["x"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->30180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "x", ",", 
   RowBox[{"NonConstants", "->", 
    RowBox[{"{", "y", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->16097],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"2", " ", "y", " ", 
   RowBox[{"D", "[", 
    RowBox[{"y", ",", "x", ",", 
     RowBox[{"NonConstants", "\[Rule]", 
      RowBox[{"{", "y", "}"}]}]}], "]"}]}]}]], "Output",
 ImageSize->{232, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->3065]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     StyleBox["f", "TI"], ",", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "}", "]"}], Cell[TextData[{
     "the gradient of a scalar function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"\[PartialD]", "f"}], "/", 
           RowBox[{"\[PartialD]", 
            SubscriptBox["x", "1"]}]}], ",", 
          RowBox[{
           RowBox[{"\[PartialD]", "f"}], "/", 
           RowBox[{"\[PartialD]", 
            SubscriptBox["x", "2"]}]}], ",", "\[Ellipsis]"}], " ", ")"}]}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "2"}], "}"}]}], "]"}], 
    Cell[TextData[{
     "the Hessian matrix for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     "-order Taylor series coefficient"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}], Cell[
    TextData[{
     "the Jacobian for a vector function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27065],

Cell["Vector derivatives. ", "Caption",
 CellID->2513],

Cell[TextData[{
 "This gives the gradient of the function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->9261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->12578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{"2", " ", "y"}]}], "}"}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->21078]
}, Open  ]],

Cell["This gives the Hessian. ", "MathCaption",
 CellID->16878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->14140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->4611]
}, Open  ]],

Cell["This gives the Jacobian for a vector function. ", "MathCaption",
 CellID->31947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", " ", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->2445],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "x"}], ",", 
     RowBox[{"2", " ", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->170]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->377029955],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CalculusOverview"]], "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Differentiation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Calculus", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/CalculusOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TotalDerivatives"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 2.6405948}", "context" -> "", 
    "keywords" -> {
     "calculus", "D", "dependent variables", "derivatives", 
      "derivative tensor", "differentiation", "divergence", "extrema", 
      "gradients", "Hessian", "Jacobian", "multivariate derivative", 
      "NonConstants", "partial derivatives", "stationary points", 
      "tensor derivative", "variation", "vector derivative"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Partial differentiation operations. This gives FractionBox[\\[PartialD], \
RowBox[{\\[PartialD], x}]]x^n. This gives the third derivative. ", 
    "synonyms" -> {"3.5.1"}, "title" -> "Differentiation", "type" -> 
    "Tutorial", "uri" -> "tutorial/Differentiation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.5.1"->{
  Cell[1847, 58, 78, 2, 70, "Title",
   CellTags->{"S3.5.1", "1.1"},
   CellID->15469]},
 "1.1"->{
  Cell[1847, 58, 78, 2, 70, "Title",
   CellTags->{"S3.5.1", "1.1"},
   CellID->15469]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.5.1", 19548, 724},
 {"1.1", 19647, 728}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1222, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1847, 58, 78, 2, 70, "Title",
 CellTags->{"S3.5.1", "1.1"},
 CellID->15469],
Cell[1928, 62, 3337, 115, 70, "DefinitionBox",
 CellID->22912],
Cell[5268, 179, 70, 1, 70, "Caption",
 CellID->8146],
Cell[5341, 182, 245, 10, 70, "MathCaption",
 CellID->30693],
Cell[CellGroupData[{
Cell[5611, 196, 140, 5, 28, "Input",
 CellID->9091],
Cell[5754, 203, 244, 9, 36, "Output",
 CellID->9815]
}, Open  ]],
Cell[6013, 215, 72, 1, 70, "MathCaption",
 CellID->26949],
Cell[CellGroupData[{
Cell[6110, 220, 190, 7, 28, "Input",
 CellID->26857],
Cell[6303, 229, 400, 15, 36, "Output",
 CellID->20640]
}, Open  ]],
Cell[6718, 247, 157, 4, 70, "MathCaption",
 CellID->26052],
Cell[CellGroupData[{
Cell[6900, 255, 280, 10, 28, "Input",
 CellID->236],
Cell[7183, 267, 204, 7, 36, "Output",
 CellID->8551]
}, Open  ]],
Cell[7402, 277, 360, 14, 70, "MathCaption",
 CellID->9487],
Cell[CellGroupData[{
Cell[7787, 295, 191, 7, 70, "Input",
 CellID->31226],
Cell[7981, 304, 177, 6, 36, "Output",
 CellID->28162]
}, Open  ]],
Cell[8173, 313, 551, 18, 70, "MathCaption",
 CellID->16955],
Cell[CellGroupData[{
Cell[8749, 335, 222, 8, 70, "Input",
 CellID->23183],
Cell[8974, 345, 354, 12, 36, "Output",
 CellID->8394]
}, Open  ]],
Cell[9343, 360, 1061, 40, 70, "MathCaption",
 CellID->30180],
Cell[CellGroupData[{
Cell[10429, 404, 262, 9, 70, "Input",
 CellID->16097],
Cell[10694, 415, 367, 12, 36, "Output",
 CellID->3065]
}, Open  ]],
Cell[11076, 430, 3664, 122, 70, "DefinitionBox",
 CellID->27065],
Cell[14743, 554, 54, 1, 70, "Caption",
 CellID->2513],
Cell[14800, 557, 240, 9, 70, "MathCaption",
 CellID->9261],
Cell[CellGroupData[{
Cell[15065, 570, 266, 10, 70, "Input",
 CellID->12578],
Cell[15334, 582, 248, 9, 36, "Output",
 CellID->21078]
}, Open  ]],
Cell[15597, 594, 63, 1, 70, "MathCaption",
 CellID->16878],
Cell[CellGroupData[{
Cell[15685, 599, 293, 11, 70, "Input",
 CellID->14140],
Cell[15981, 612, 298, 11, 36, "Output",
 CellID->4611]
}, Open  ]],
Cell[16294, 626, 86, 1, 70, "MathCaption",
 CellID->31947],
Cell[CellGroupData[{
Cell[16405, 631, 346, 13, 70, "Input",
 CellID->2445],
Cell[16754, 646, 349, 13, 36, "Output",
 CellID->170]
}, Open  ]],
Cell[CellGroupData[{
Cell[17140, 664, 72, 1, 70, "RelatedTutorialsSection",
 CellID->377029955],
Cell[17215, 667, 146, 3, 70, "RelatedTutorials",
 CellID->808424779]
}, Open  ]]
}, Open  ]],
Cell[17388, 674, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

