(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29757,       1066]
NotebookOptionsPosition[     22343,        828]
NotebookOutlinePosition[     25436,        903]
CellTagsIndexPosition[     25345,        897]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/NumbersOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numbers\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BaseForm" :> Documentation`HelpLookup["paclet:ref/BaseForm"], 
          "FromDigits" :> Documentation`HelpLookup["paclet:ref/FromDigits"], 
          "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "IntegerExponent" :> 
          Documentation`HelpLookup["paclet:ref/IntegerExponent"], 
          "IntegerLength" :> 
          Documentation`HelpLookup["paclet:ref/IntegerLength"], 
          "IntegerString" :> 
          Documentation`HelpLookup["paclet:ref/IntegerString"], 
          "MantissaExponent" :> 
          Documentation`HelpLookup["paclet:ref/MantissaExponent"], 
          "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BaseForm\"\>", 
       2->"\<\"FromDigits\"\>", 3->"\<\"IntegerDigits\"\>", 
       4->"\<\"IntegerExponent\"\>", 5->"\<\"IntegerLength\"\>", 
       6->"\<\"IntegerString\"\>", 7->"\<\"MantissaExponent\"\>", 
       8->"\<\"RealDigits\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Digits in Numbers", "Title",
 CellTags->{"S3.1.3", "3.1"},
 CellID->22276],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["IntegerDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerDigits"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "a list of the decimal digits in the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerDigits"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "the digits of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerDigits"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["len", "TI"], "]"}], Cell[TextData[{
     "the list of digits padded on the left with zeros to give total length ",
     
     Cell[BoxData[
      StyleBox["len", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerLength",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerLength"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the number of decimal digits in ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerLength",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerLength"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[TextData[{
     "the number of base b digits in ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerExponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerExponent"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "the number of zeros at the end of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RealDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RealDigits"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "a list of the decimal digits in the approximate real number ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     ", together with the number of digits to the left of the decimal point"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RealDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RealDigits"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "the digits of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RealDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RealDigits"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["len", "TI"], "]"}], Cell[TextData[{
     "the first ",
     Cell[BoxData[
      StyleBox["len", "TI"]], "InlineFormula"],
     " digits of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RealDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RealDigits"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["len", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the first ",
     Cell[BoxData[
      StyleBox["len", "TI"]], "InlineFormula"],
     " digits starting with the coefficient of ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["b", "n"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FromDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromDigits"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[
    "construct a number from its decimal digit sequence", "TableText"]},
   {
    RowBox[{
     ButtonBox["FromDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromDigits"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "construct a number from its digit sequence in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FromDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromDigits"], "[", 
     StyleBox[
      RowBox[{"\"\<\>", "string", "\"\<\>"}], "TI"], "]"}], Cell[
    "construct an integer from a string of digits", "TableText"]},
   {
    RowBox[{
     ButtonBox["FromDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromDigits"], "[", 
     RowBox[{
      StyleBox["\"\<string\>\"", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[TextData[{
     "construct an integer from a string of digits in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerString"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "a string of the decimal digits in the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerString"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[TextData[{
     "a string of the digits of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, True, False, False, False, True,
      False, False, False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->25759],

Cell["Converting between numbers and lists or strings of digits. ", "Caption",
 CellID->30189],

Cell["Here is the list of base 16 digits for an integer. ", "MathCaption",
 CellID->30422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"1234135634", ",", "16"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "9", ",", "8", ",", "15", ",", "6", ",", "10", ",", "5", ",", 
   "2"}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198611384]
}, Open  ]],

Cell["\<\
This gives a list of digits, together with the number of digits that appear \
to the left of the decimal point. \
\>", "MathCaption",
 CellID->3455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", "123.4567890123456", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9", ",", "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", 
     ",", "6"}], "}"}], ",", "3"}], "}"}]], "Output",
 ImageSize->{330, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222712106]
}, Open  ]],

Cell["\<\
Here is the binary digit sequence for 56, padded with zeros so that it is of \
total length 8. \
\>", "MathCaption",
 CellID->4860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"56", ",", "2", ",", "8"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->506165383]
}, Open  ]],

Cell["\<\
This reconstructs the original number from its binary digit sequence. \
\>", "MathCaption",
 CellID->31348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12503],

Cell[BoxData["56"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->539334781]
}, Open  ]],

Cell["Here is 56 as a binary string. ", "MathCaption",
 CellID->47642351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerString", "[", 
  RowBox[{"56", ",", " ", "2"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->428691496],

Cell[BoxData["\<\"111000\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->485389076]
}, Open  ]],

Cell["This reconstructs the original number again. ", "MathCaption",
 CellID->29298195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->29457548],

Cell[BoxData["56"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->176207551]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["b", "TI"], "^", "^", 
     StyleBox["nnnn", "TI"]}], Cell[TextData[{
     "a number in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BaseForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BaseForm"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "print with ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerString"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], Cell[TextData[{
     "a string representing ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22431],

Cell["Numbers in other bases. ", "Caption",
 CellID->29082],

Cell[TextData[{
 "When the base is larger than ",
 Cell[BoxData["10"], "InlineFormula"],
 ", extra digits are represented by letters ",
 Cell[BoxData["a"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["z"], "InlineFormula"],
 ". "
}], "Text",
 CellID->12455],

Cell[TextData[{
 "The number ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["100101", "2"], TraditionalForm]], "InlineMath"],
 " in base 2 is ",
 Cell[BoxData[
  FormBox["37", TraditionalForm]], "InlineMath"],
 " in base 10. "
}], "MathCaption",
 CellID->14197],

Cell[CellGroupData[{

Cell[BoxData["2^^100101"], "Input",
 CellLabel->"In[7]:=",
 CellID->22106],

Cell[BoxData["37"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->8261988]
}, Open  ]],

Cell[TextData[{
 "This prints ",
 Cell[BoxData[
  FormBox["37", TraditionalForm]], "InlineMath"],
 " in base 2. "
}], "MathCaption",
 CellID->15821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"37", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->17296],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"100101\"\>", "\<\"2\"\>"],
   37,
   Editable->False],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//BaseForm=",
 CellID->269550113]
}, Open  ]],

Cell["This gives the base 2 representation as a string.", "MathCaption",
 CellID->183431862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerString", "[", 
  RowBox[{"37", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->26812085],

Cell[BoxData["\<\"100101\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->145557900]
}, Open  ]],

Cell["Here is a number in base 16. ", "MathCaption",
 CellID->26021],

Cell[CellGroupData[{

Cell[BoxData["16^^ffffaa00"], "Input",
 CellLabel->"In[10]:=",
 CellID->24455],

Cell[BoxData["4294945280"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->207777944]
}, Open  ]],

Cell["\<\
You can do computations with numbers in base 16. Here the result is given in \
base 10. \
\>", "MathCaption",
 CellID->27124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"16^^fffaa2", "+", "16^^ff", "-", "1"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->18318],

Cell[BoxData["16776096"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->667682298]
}, Open  ]],

Cell["This gives the result in base 16. ", "MathCaption",
 CellID->11376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"%", ",", "16"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1774],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"fffba0\"\>", "\<\"16\"\>"],
   16776096,
   Editable->False],
  BaseForm[#, 16]& ]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]//BaseForm=",
 CellID->531486010]
}, Open  ]],

Cell["\<\
You can give approximate real numbers, as well as integers, in other bases. \
\>", "MathCaption",
 CellID->24998],

Cell[CellGroupData[{

Cell[BoxData["2^^101.100101"], "Input",
 CellLabel->"In[13]:=",
 CellID->12074],

Cell[BoxData["5.578125`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->796023117]
}, Open  ]],

Cell[TextData[{
 "Here are the first few digits of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " in octal. "
}], "MathCaption",
 CellID->6922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", "30"}], "]"}], ",", "8"}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->10635],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"1.324047463177167462204262766115467\"\>", "8"],
   1.41421356237309504880168872421`30.,
   AutoDelete->True],
  BaseForm[#, 8]& ]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]//BaseForm=",
 CellID->39534977]
}, Open  ]],

Cell["This gives an explicit list of the first 15 octal digits. ", \
"MathCaption",
 CellID->28888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], ",", "8", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->8153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "4", ",", "0", ",", "4", ",", "7", ",", "4",
      ",", "6", ",", "3", ",", "1", ",", "7", ",", "7", ",", "1", ",", "6"}], 
    "}"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->33358918]
}, Open  ]],

Cell[TextData[{
 "This gives 15 octal digits starting with the coefficient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["8", 
    RowBox[{"-", "10"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->4747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], ",", "8", ",", "15", ",", 
   RowBox[{"-", "10"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->28680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "7", ",", "7", ",", "1", ",", "6", ",", "7", ",", "4", ",", "6",
      ",", "2", ",", "2", ",", "0", ",", "4", ",", "2", ",", "6", ",", "2"}], 
    "}"}], ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Output",
 ImageSize->{320, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->64231848]
}, Open  ]],

Cell[TextData[{
 ButtonBox["\"Output Formats for Numbers\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/OutputFormatsForNumbers"],
 " describes how to print numbers in various formats. If you want to create \
your own formats, you will often need to use ",
 Cell[BoxData[
  ButtonBox["MantissaExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MantissaExponent"]], "InlineFormula"],
 " to separate the pieces of real numbers. "
}], "Text",
 CellID->25678],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MantissaExponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MantissaExponent"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "give a list containing the mantissa and exponent of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MantissaExponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MantissaExponent"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "give the mantissa and exponent in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->6450],

Cell["Separating the mantissa and exponent of numbers.", "Caption",
 CellID->14801],

Cell["\<\
This gives a list in which the mantissa and exponent of the number are \
separated. \
\>", "MathCaption",
 CellID->24961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MantissaExponent", "[", 
  RowBox[{"3.45", " ", 
   RowBox[{"10", "^", "125"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->14199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.345`", ",", "126"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->16901700]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->682371406],

Cell[TextData[ButtonBox["Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumbersOverview"]], "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Digits in Numbers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numbers", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/NumbersOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericQuantities"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NumericalPrecision"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 7.5313450}", "context" -> "", 
    "keywords" -> {
     "^^", "BaseForm", "bases", "binary digits", "binary numbers", "caret", 
      "conversion", "decimal digits", "decode", "digits", "encode", "explode",
       "exponent", "exponents", "floating-point decomposition", "FromDigits", 
      "hexadecimal digits", "hexadecimal numbers", "implode", "index", 
      "IntegerDigits", "IntegerExponent", "IntegerLength", "integers", 
      "MantissaExponent", "number base", "numbers", "octal digits", 
      "octal numbers", "padding", "radix", "radix conversion", "RealDigits", 
      "reconstruction", "ruler function", "ternary digits", "ternary numbers",
       "unpack", "wedge", "zeros"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Converting between numbers and lists or strings of digits. Here is the \
list of base 16 digits for an integer. This gives a list of digits, together \
with the number of digits that appear to the left of the decimal point. ", 
    "synonyms" -> {"3.1.3"}, "title" -> "Digits in Numbers", "type" -> 
    "Tutorial", "uri" -> "tutorial/DigitsInNumbers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.1.3"->{
  Cell[2627, 73, 80, 2, 70, "Title",
   CellTags->{"S3.1.3", "3.1"},
   CellID->22276]},
 "3.1"->{
  Cell[2627, 73, 80, 2, 70, "Title",
   CellTags->{"S3.1.3", "3.1"},
   CellID->22276]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.1.3", 25134, 886},
 {"3.1", 25233, 890}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2002, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2627, 73, 80, 2, 70, "Title",
 CellTags->{"S3.1.3", "3.1"},
 CellID->22276],
Cell[2710, 77, 6494, 204, 70, "DefinitionBox",
 CellID->25759],
Cell[9207, 283, 94, 1, 70, "Caption",
 CellID->30189],
Cell[9304, 286, 90, 1, 70, "MathCaption",
 CellID->30422],
Cell[CellGroupData[{
Cell[9419, 291, 138, 4, 28, "Input",
 CellID->27666],
Cell[9560, 297, 273, 9, 36, "Output",
 CellID->198611384]
}, Open  ]],
Cell[9848, 309, 158, 4, 70, "MathCaption",
 CellID->3455],
Cell[CellGroupData[{
Cell[10031, 317, 117, 3, 28, "Input",
 CellID->2028],
Cell[10151, 322, 410, 12, 36, "Output",
 CellID->222712106]
}, Open  ]],
Cell[10576, 337, 141, 4, 70, "MathCaption",
 CellID->4860],
Cell[CellGroupData[{
Cell[10742, 345, 139, 4, 28, "Input",
 CellID->29253],
Cell[10884, 351, 270, 9, 36, "Output",
 CellID->506165383]
}, Open  ]],
Cell[11169, 363, 117, 3, 70, "MathCaption",
 CellID->31348],
Cell[CellGroupData[{
Cell[11311, 370, 125, 4, 70, "Input",
 CellID->12503],
Cell[11439, 376, 159, 5, 36, "Output",
 CellID->539334781]
}, Open  ]],
Cell[11613, 384, 73, 1, 70, "MathCaption",
 CellID->47642351],
Cell[CellGroupData[{
Cell[11711, 389, 138, 4, 70, "Input",
 CellID->428691496],
Cell[11852, 395, 171, 5, 36, "Output",
 CellID->485389076]
}, Open  ]],
Cell[12038, 403, 87, 1, 70, "MathCaption",
 CellID->29298195],
Cell[CellGroupData[{
Cell[12150, 408, 128, 4, 70, "Input",
 CellID->29457548],
Cell[12281, 414, 159, 5, 36, "Output",
 CellID->176207551]
}, Open  ]],
Cell[12455, 422, 1402, 46, 70, "DefinitionBox",
 CellID->22431],
Cell[13860, 470, 59, 1, 70, "Caption",
 CellID->29082],
Cell[13922, 473, 257, 9, 70, "Text",
 CellID->12455],
Cell[14182, 484, 259, 10, 70, "MathCaption",
 CellID->14197],
Cell[CellGroupData[{
Cell[14466, 498, 74, 2, 70, "Input",
 CellID->22106],
Cell[14543, 502, 157, 5, 36, "Output",
 CellID->8261988]
}, Open  ]],
Cell[14715, 510, 148, 6, 70, "MathCaption",
 CellID->15821],
Cell[CellGroupData[{
Cell[14888, 520, 124, 4, 70, "Input",
 CellID->17296],
Cell[15015, 526, 291, 11, 50, "Output",
 CellID->269550113]
}, Open  ]],
Cell[15321, 540, 92, 1, 70, "MathCaption",
 CellID->183431862],
Cell[CellGroupData[{
Cell[15438, 545, 132, 4, 70, "Input",
 CellID->26812085],
Cell[15573, 551, 171, 5, 36, "Output",
 CellID->145557900]
}, Open  ]],
Cell[15759, 559, 68, 1, 70, "MathCaption",
 CellID->26021],
Cell[CellGroupData[{
Cell[15852, 564, 78, 2, 70, "Input",
 CellID->24455],
Cell[15933, 568, 168, 5, 36, "Output",
 CellID->207777944]
}, Open  ]],
Cell[16116, 576, 135, 4, 70, "MathCaption",
 CellID->27124],
Cell[CellGroupData[{
Cell[16276, 584, 113, 3, 70, "Input",
 CellID->18318],
Cell[16392, 589, 166, 5, 36, "Output",
 CellID->667682298]
}, Open  ]],
Cell[16573, 597, 73, 1, 70, "MathCaption",
 CellID->11376],
Cell[CellGroupData[{
Cell[16671, 602, 124, 4, 70, "Input",
 CellID->1774],
Cell[16798, 608, 300, 11, 50, "Output",
 CellID->531486010]
}, Open  ]],
Cell[17113, 622, 123, 3, 70, "MathCaption",
 CellID->24998],
Cell[CellGroupData[{
Cell[17261, 629, 79, 2, 70, "Input",
 CellID->12074],
Cell[17343, 633, 167, 5, 36, "Output",
 CellID->796023117]
}, Open  ]],
Cell[17525, 641, 179, 7, 70, "MathCaption",
 CellID->6922],
Cell[CellGroupData[{
Cell[17729, 652, 216, 8, 70, "Input",
 CellID->10635],
Cell[17948, 662, 347, 11, 50, "Output",
 CellID->39534977]
}, Open  ]],
Cell[18310, 676, 99, 2, 70, "MathCaption",
 CellID->28888],
Cell[CellGroupData[{
Cell[18434, 682, 168, 5, 70, "Input",
 CellID->8153],
Cell[18605, 689, 399, 12, 36, "Output",
 CellID->33358918]
}, Open  ]],
Cell[19019, 704, 230, 8, 70, "MathCaption",
 CellID->4747],
Cell[CellGroupData[{
Cell[19274, 716, 199, 6, 70, "Input",
 CellID->28680],
Cell[19476, 724, 418, 13, 36, "Output",
 CellID->64231848]
}, Open  ]],
Cell[19909, 740, 473, 12, 70, "Text",
 CellID->25678],
Cell[20385, 754, 1029, 30, 70, "DefinitionBox",
 CellID->6450],
Cell[21417, 786, 83, 1, 70, "Caption",
 CellID->14801],
Cell[21503, 789, 131, 4, 70, "MathCaption",
 CellID->24961],
Cell[CellGroupData[{
Cell[21659, 797, 162, 5, 70, "Input",
 CellID->14199],
Cell[21824, 804, 210, 7, 36, "Output",
 CellID->16901700]
}, Open  ]],
Cell[CellGroupData[{
Cell[22071, 816, 72, 1, 70, "RelatedTutorialsSection",
 CellID->682371406],
Cell[22146, 819, 143, 3, 70, "RelatedTutorials",
 CellID->54483688]
}, Open  ]]
}, Open  ]],
Cell[22316, 826, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

