(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    327901,      10435]
NotebookOptionsPosition[    290560,       9131]
NotebookOutlinePosition[    298653,       9398]
CellTagsIndexPosition[    297257,       9350]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Diophantine Polynomial Systems", "Title",
 CellID->827847405],

Cell[CellGroupData[{

Cell["Introduction", "Section",
 CellTags->{"t:3", "c:3"},
 CellID->21194150],

Cell[TextData[{
 "A ",
 StyleBox["Diophantine polynomial system",
  FontSlant->"Italic"],
 " is an expression constructed with polynomial equations and inequalities"
}], "Text",
 CellID->188227223],

Cell[BoxData[
 FormBox[
  RowBox[{" ", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[Equal]", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[NotEqual]", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[GreaterEqual]", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", " ", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], ">", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[LessEqual]", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "<", " ", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}], ","}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->141921810],

Cell["combined using logical connectives and quantifiers", "Text",
 CellID->252289036],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[And]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", " ", 
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[Or]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", " ", 
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "1"], "\[Implies]", 
    SubscriptBox["\[CapitalPhi]", "2"]}], ",", 
   RowBox[{"\[Not]", "\[CapitalPhi]"}], ",", 
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], "\[CapitalPhi]"}], ",", " ", 
   RowBox[{"and", " ", 
    RowBox[{
     SubscriptBox["\[Exists]", "x"], "\[CapitalPhi]"}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellID->751756458],

Cell["where the variables represent integer quantities.", "Text",
 CellID->83213009],

Cell[TextData[{
 "An occurrence of a variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " inside ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ForAll]", "x"], 
    RowBox[{"\[CapitalPhi]", "  ", "or", "  ", 
     RowBox[{
      SubscriptBox["\[Exists]", "x"], "\[CapitalPhi]"}]}]}], 
   TraditionalForm]], "InlineMath"],
 " is called a ",
 StyleBox["bound occurrence",
  FontSlant->"Italic"],
 "; any other occurrence of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is called a ",
 StyleBox["free occurrence.",
  FontSlant->"Italic"],
 " A variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is called a ",
 StyleBox["free variable",
  FontSlant->"Italic"],
 " of a polynomial system if the system contains a free occurrence of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". A Diophantine polynomial system is ",
 StyleBox["quantifier-free",
  FontSlant->"Italic"],
 " if it contains no quantifiers. A ",
 StyleBox["decision problem",
  FontSlant->"Italic"],
 " is a system with all variables existentially quantified, that is, a system \
of the form"
}], "Text",
 CellID->91342862],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["\[Exists]", 
     SubscriptBox["x", "1"]], 
    RowBox[{
     SubscriptBox["\[Exists]", 
      SubscriptBox["x", "2"]], 
     RowBox[{"\[Ellipsis]", 
      RowBox[{
       SubscriptBox["\[Exists]", 
        SubscriptBox["x", "n"]], 
       RowBox[{"\[CapitalPhi]", "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}]}]}]}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(1)"}]]}, {None, None}},
 CellTags->"Diophantine1",
 CellID->106442024],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " are all variables in ",
 Cell[BoxData[
  FormBox["\[CapitalPhi]", TraditionalForm]], "InlineMath"],
 ". The decision problem (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"1"],
 ") is equivalent to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", depending on whether the quantifier-free system of polynomial equations \
and inequalities ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " has integer solutions."
}], "Text",
 CellID->554193710],

Cell["An example of a Diophantine polynomial system is", "Text",
 CellID->33004248],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[ForAll]", 
      RowBox[{"n", ",", " ", 
       RowBox[{"n", "\[GreaterEqual]", "2"}]}]], 
     RowBox[{
      SubscriptBox["\[Exists]", 
       RowBox[{"p", ",", " ", 
        RowBox[{"p", ">", "1"}]}]], 
      RowBox[{
       SubscriptBox["\[Exists]", 
        RowBox[{"q", ",", " ", 
         RowBox[{"q", ">", "1"}]}]], 
       RowBox[{
        SubscriptBox["\[ForAll]", 
         RowBox[{"a", ",", " ", 
          RowBox[{"a", ">", "1"}]}]], 
        RowBox[{
         SubscriptBox["\[ForAll]", 
          RowBox[{"b", ",", " ", 
           RowBox[{"b", ">", "1"}]}]], " ", 
         RowBox[{
          RowBox[{"a", " ", "b"}], "\[NotEqual]", "p"}]}]}]}]}]}], "\[And]", 
    RowBox[{
     RowBox[{"a", " ", "b"}], "\[NotEqual]", "q"}], "\[And]", 
    RowBox[{"p", "+", "q"}]}], "=", 
   RowBox[{"2", 
    RowBox[{"n", "."}]}]}], TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(2)"}]]}, {None, None}},
 CellTags->"Diophantine2",
 CellID->298139489],

Cell[TextData[{
 "Goldbach's conjecture [",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"1"],
 "], formulated in 1742 and still unproven, asserts that system (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"2"],
 ") is equivalent to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". This suggests that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may not be able to solve arbitrary Diophantine polynomial systems. In \
fact, Matiyasevich's solution of Hilbert's tenth problem [",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"2"],
 "] shows that no algorithm can be constructed that would solve arbitrary \
Diophantine polynomial systems, not even quantifier-free systems or decision \
problems. Nevertheless, ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "functions ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " are able to solve several reasonably large classes of Diophantine systems. \
This tutorial describes these classes of systems and methods used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to solve them. The methods are presented in the order in which they are \
used. The tutorial also covers options affecting the methods used and how \
they operate."
}], "Text",
 CellID->340212020]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linear Systems", "Section",
 CellID->551921972],

Cell[CellGroupData[{

Cell["Systems of Linear Equations", "Subsection",
 CellTags->"LinearEqns",
 CellID->22538780],

Cell[TextData[{
 "Conjunctions of linear Diophantine equations are solvable for an arbitrary \
number of variables. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a method based on the computation Hermite normal form of matrices, \
available in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directly as ",
 Cell[BoxData[
  ButtonBox["HermiteDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteDecomposition"]], "InlineFormula"],
 ". The result may contain new unrestricted integer parameters. If the \
equations are independent, the number of parameters is equal to the \
difference between the number of variables and the number of equations."
}], "Text",
 CellID->17656720],

Cell["\<\
This system has four variables and two independent equations, hence the \
result is expressed in terms of two integer parameters.\
\>", "MathCaption",
 CellID->383261712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"3", "a"}], "+", 
      RowBox[{"4", "b"}], "+", 
      RowBox[{"18", "c"}], "+", 
      RowBox[{"24", "d"}]}], "\[Equal]", "30"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"27", "a"}], "+", 
      RowBox[{"16", "b"}], "+", 
      RowBox[{"28", "c"}], "+", 
      RowBox[{"24", "d"}]}], "\[Equal]", "30"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229190442],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{"a", "\[Equal]", 
   RowBox[{"2", "+", 
    RowBox[{"8", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}], "&&", 
  RowBox[{"b", "\[Equal]", 
   RowBox[{"6", "-", 
    RowBox[{"6", " ", 
     RowBox[{"C", "[", "1", "]"}]}], "+", 
    RowBox[{"15", " ", 
     RowBox[{"C", "[", "2", "]"}]}]}]}], "&&", 
  RowBox[{"c", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "12"}], "-", 
    RowBox[{"12", " ", 
     RowBox[{"C", "[", "1", "]"}]}], "-", 
    RowBox[{"18", " ", 
     RowBox[{"C", "[", "2", "]"}]}]}]}], "&&", 
  RowBox[{"d", "\[Equal]", 
   RowBox[{"9", "+", 
    RowBox[{"9", " ", 
     RowBox[{"C", "[", "1", "]"}]}], "+", 
    RowBox[{"11", " ", 
     RowBox[{"C", "[", "2", "]"}]}]}]}]}]], "Output",
 ImageSize->{490, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314031709]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frobenius Equations", "Subsection",
 CellTags->"Frobenius",
 CellID->33996244],

Cell[TextData[{
 "A ",
 StyleBox["Frobenius equation",
  FontSlant->"Italic"],
 " is an equation of the form"
}], "Text",
 CellID->4484172],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], 
      SubscriptBox["x", "1"]}], "+", "\[Ellipsis]", "+", 
     RowBox[{
      SubscriptBox["a", "n"], 
      SubscriptBox["x", "n"]}]}], "\[Equal]", " ", "m"}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellID->120031077],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", " ", 
    SubscriptBox["a", "n"]}], TraditionalForm]], "InlineMath"],
 " are positive integers, ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is an integer, and the coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", " ", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " of solutions are required to be non\[Hyphen]negative integers."
}], "Text",
 CellID->536223126],

Cell[TextData[{
 "For finding solution instances of Frobenius equations ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a fast algorithm based on the computation of the critical tree in the \
Frobenius graph [",
 ButtonBox["11",
  BaseStyle->"Hyperlink",
  ButtonData->"11"],
 "]. The algorithm applies when the smallest of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", " ", 
    SubscriptBox["a", "n"]}], TraditionalForm]], "InlineMath"],
 " does not exceed the value of the ",
 Cell[BoxData["MaxFrobeniusGraph"], "InlineFormula"],
 " system option (the default is 1,000,000). Otherwise the more general ",
 ButtonBox["methods for solving bounded linear systems",
  BaseStyle->"Hyperlink",
  ButtonData->"BoundedLinearSystems"],
 " are used. Functions ",
 Cell[BoxData[
  ButtonBox["FrobeniusSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FrobeniusNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrobeniusNumber"]], "InlineFormula"],
 " provide specialized functionality for solving Frobenius equations and \
computing Frobenius numbers."
}], "Text",
 CellID->31411680],

Cell["This finds a solution of a Frobenius equation.", "MathCaption",
 CellID->733961252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"123456", " ", "x"}], "+", 
      RowBox[{"234567", " ", "y"}], "+", 
      RowBox[{"345678", " ", "z"}], "+", 
      RowBox[{"456789", " ", "u"}], "+", 
      RowBox[{"567890", " ", "v"}], "+", 
      RowBox[{"678901", " ", "w"}], "+", 
      RowBox[{"789012", " ", "r"}], "+", 
      RowBox[{"890123", " ", "s"}], "+", 
      RowBox[{"901234", " ", "t"}]}], "\[Equal]", "123456789"}], "&&", 
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"u", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"v", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"w", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"r", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"s", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"t", "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
    "x", ",", "y", ",", "z", ",", "u", ",", "v", ",", "w", ",", "r", ",", "s",
      ",", "t"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->340562248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "5"}], ",", 
    RowBox[{"y", "\[Rule]", "8"}], ",", 
    RowBox[{"z", "\[Rule]", "12"}], ",", 
    RowBox[{"u", "\[Rule]", "17"}], ",", 
    RowBox[{"v", "\[Rule]", "24"}], ",", 
    RowBox[{"w", "\[Rule]", "29"}], ",", 
    RowBox[{"r", "\[Rule]", "29"}], ",", 
    RowBox[{"s", "\[Rule]", "29"}], ",", 
    RowBox[{"t", "\[Rule]", "30"}]}], "}"}], "}"}]], "Output",
 ImageSize->{441, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->391581807]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bounded Systems of Linear Equations and Inequalities", "Subsection",
 CellTags->"BoundedLinearSystems",
 CellID->3382796],

Cell[TextData[{
 "If a real solution set of a system of linear equations and inequalities is \
a bounded polyhedron, the system has finitely many integer solutions. To find \
the solutions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the following procedure."
}], "Text",
 CellID->65402303],

Cell[TextData[{
 "You may assume the system has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["M", "eq"], ".", "x"}], "\[Equal]", 
     SubscriptBox["b", "eq"]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["M", "ineq"], ".", "x"}], "\[GreaterEqual]", 
     SubscriptBox["b", "ineq"]}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "eq"], TraditionalForm]], "InlineMath"],
 " is a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " integer matrix, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "eq"], TraditionalForm]], "InlineMath"],
 " is a length ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " integer vector, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "ineq"], TraditionalForm]], "InlineMath"],
 " is an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"l", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " integer matrix, and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "ineq"], TraditionalForm]], "InlineMath"],
 " is a length ",
 Cell[BoxData[
  FormBox["l", TraditionalForm]], "InlineMath"],
 " integer vector. First, ",
 ButtonBox["the method for solving systems of linear equations",
  BaseStyle->"Hyperlink",
  ButtonData->"LinearEqns"],
 " is used to find an integer vector ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["M", "eq"], ".", "s"}], "\[Equal]", 
    SubscriptBox["b", "eq"]}], TraditionalForm]], "InlineMath"],
 " and a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[Cross]", "n"}], TraditionalForm]], "InlineMath"],
 " integer matrix ",
 StyleBox["N ",
  FontSlant->"Italic"],
 "whose rows generate the nullspace of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["M", "eq"], ".", "x"}], "\[Equal]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". The integer solution set of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["M", "eq"], ".", "x"}], "\[Equal]", 
    SubscriptBox["b", "eq"]}], TraditionalForm]], "InlineMath"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"s", "+", 
     RowBox[{"i", ".", 
      RowBox[{"N", ":", 
       RowBox[{"i", "\[Element]", 
        SuperscriptBox["\[DoubleStruckCapitalZ]", "p"]}]}]}]}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ". Put ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["M", "mult"], "=", 
    RowBox[{
     SubscriptBox["M", "ineq"], ".", 
     SuperscriptBox["N", "T"]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "mult"], "=", 
    RowBox[{
     SubscriptBox["b", "ineq"], "-", 
     RowBox[{
      SubscriptBox["M", "ineq"], ".", "s"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". The integer solution set of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["M", "eq"], ".", "x"}], "\[Equal]", 
     SubscriptBox["b", "eq"]}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["M", "ineq"], ".", "x"}], "\[GreaterEqual]", 
     SubscriptBox["b", "ineq"]}]}], TraditionalForm]], "InlineMath"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"s", "+", 
     RowBox[{"i", ".", 
      RowBox[{"N", ":", 
       RowBox[{"i", "\[Element]", "\[ScriptCapitalI]"}]}]}]}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalI]", TraditionalForm]], "InlineMath"],
 " is the integer solution set of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["M", "mult"], ".", "i"}], "\[GreaterEqual]", 
    SubscriptBox["b", "mult"]}], TraditionalForm]], "InlineMath"],
 ". To improve efficiency of finding the set ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalI]", TraditionalForm]], "InlineMath"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " simplifies ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["M", "mult"], "T"], TraditionalForm]], "InlineMath"],
 " using ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 ", obtaining ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    SubscriptBox["M", "red"], "T"], TraditionalForm]], "InlineMath"],
 ". Note that if the columns of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "mult"], TraditionalForm]], "InlineMath"],
 " are linearly dependent, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["M", "mult"], ".", "i"}], "\[GreaterEqual]", 
    SubscriptBox["b", "mult"]}], TraditionalForm]], "InlineMath"],
 " has no solutions (otherwise it would have infinitely many solutions, which \
contradicts the assumptions). Hence you may assume that ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "mult"], TraditionalForm]], "InlineMath"],
 " has linearly independent columns and so ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["M", "red"], TraditionalForm]], "InlineMath"],
 " has ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " columns. Put ",
 Cell[BoxData[
  FormBox[
   RowBox[{"R", "=", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["M", "mult"], "T"], ".", 
        SubscriptBox["M", "mult"]}], ")"}], 
      RowBox[{"-", "1"}]], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        SubscriptBox["M", "mult"], "T"], 
       SubscriptBox["M", "red"]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Lattice reduction techniques are also used to find a small vector ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["b", "red"], TraditionalForm]], "InlineMath"],
 " in the lattice ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "mult"], "+", 
    RowBox[{
     SubscriptBox["M", "red"], ".", "v"}]}], TraditionalForm]], 
  "InlineMath"],
 ". Let ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "0"], TraditionalForm]], "InlineMath"],
 " be such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["b", "red"], "=", 
    RowBox[{
     SubscriptBox["b", "mult"], "+", 
     RowBox[{
      SubscriptBox["M", "red"], ".", 
      SubscriptBox["v", "0"]}]}]}], TraditionalForm]], "InlineMath"],
 ". The set ",
 Cell[BoxData[
  FormBox["\[ScriptCapitalI]", TraditionalForm]], "InlineMath"],
 " can be computed from the set ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalI]", "red"], TraditionalForm]], 
  "InlineMath"],
 " of all ",
 Cell[BoxData[
  FormBox[
   RowBox[{"i", "\[Element]", 
    SuperscriptBox["\[DoubleStruckCapitalZ]", "p"]}], TraditionalForm]], 
  "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["M", "red"], ".", "i"}], "\[GreaterEqual]", 
    SubscriptBox["b", "red"]}], TraditionalForm]], "InlineMath"],
 " using the formula ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[ScriptCapitalI]", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"R", ".", 
       RowBox[{"(", 
        RowBox[{"i", "-", 
         SubscriptBox["v", "0"]}], ")"}]}], ":", 
      RowBox[{"i", "\[Element]", 
       SubscriptBox["\[ScriptCapitalI]", "red"]}]}], "}"}]}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->621221680],

Cell[TextData[{
 "To find the set ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalI]", "red"], TraditionalForm]], 
  "InlineMath"],
 " a simple recursive algorithm can be used. The algorithm finds the bounds \
on the first variable using ",
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 " and, for each integer value ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "1"], TraditionalForm]], "InlineMath"],
 " between the bounds, calls itself recursively with the first variable set \
to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "1"], TraditionalForm]], "InlineMath"],
 ". This algorithm is used when the system option ",
 Cell[BoxData["BranchLinearDiophantine"], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". With the default setting ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " a hybrid algorithm combining the recursive algorithm and a \
branch-and-bound type algorithm is used. At each level of the recursion, the \
recursion is continued for the \"middle\" values of the first variable \
(defined as a projection of the set of points contained in the real solution \
set together with a unit cube) while the remaining parts of the real solution \
set are searched for integer solutions using the branch-and-bound type \
algorithm. ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " finds the single element of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[ScriptCapitalI]", "red"], TraditionalForm]], 
  "InlineMath"],
 " it needs using a branch-and-bound type algorithm."
}], "Text",
 CellTags->"PolyhedronIntegerPoints",
 CellID->551184031],

Cell[TextData[{
 "There are two system options, ",
 Cell[BoxData["BranchLinearDiophantine"], "InlineFormula"],
 " and ",
 Cell[BoxData["LatticeReduceDiophantine"], "InlineFormula"],
 ", that allow you to control the exact algorithm used. In some cases \
changing the values of these options may greatly improve the performance of \
",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"PolyhedronIntegerPoints",
 CellID->93685138],

Cell["This finds all integer points in a triangle.", "MathCaption",
 CellID->108988687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"7", " ", "x"}], "+", "y"}], "\[GreaterEqual]", "3"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", "x"}], "-", 
      RowBox[{"33", " ", "y"}], "+", "333"}], "\[GreaterEqual]", "0"}], "&&", 
    
    RowBox[{"x", "<", "y"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->567505768],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{480, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->632118532]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " enumerates the solutions explicitly only if the number of integer \
solutions of the system does not exceed the maximum of the ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " power of the value of the system option ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is the dimension of the solution lattice of the equations, and the second \
element of the value of the system option ",
 Cell[BoxData["ExhaustiveSearchMaxPoints"], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"BoundedSolutionLimits",
 CellID->126309748],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " does not give explicit solutions because their number would exceed the \
default limit of 10000."
}], "MathCaption",
 CellID->552720389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{"x", "+", "y"}], "\[LessEqual]", "200"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->514161096],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "|", "y"}], ")"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "199"}], "&&", 
      RowBox[{"0", "\[LessEqual]", "y", "\[LessEqual]", 
       RowBox[{"200", "-", "x"}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "200"}], "&&", 
      RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{457, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->74068940]
}, Open  ]],

Cell[TextData[{
 "This increases the value of the system option ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 " to 1000."
}], "MathCaption",
 CellID->22773890],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DiscreteSolutionBound\>\"", "\[Rule]", "1000"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->240373159],

Cell[TextData[{
 "Since there are two variables and no equations, the limit on the number of \
solutions is now ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["1000", "2"], TraditionalForm]], "InlineMath"],
 ", and ",
 StyleBox["Reduce", "MR"],
 " can enumerate the solutions explicitly."
}], "MathCaption",
 CellID->176248344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "\[LessEqual]", "200"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
  "Length"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->244043109],

Cell[BoxData["20301"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->117830275]
}, Open  ]],

Cell[TextData[{
 "This resets ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->413780436],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DiscreteSolutionBound\>\"", "\[Rule]", "10"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->60790276]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arbitrary Systems of Linear Equations and Inequalities", "Subsection",
 CellID->138579073],

Cell[TextData[{
 "Quantifier-free systems of linear Diophantine equations and inequalities \
are solvable for an arbitrary number of variables. The system is written in \
the ",
 StyleBox["disjunctive normal form",
  FontSlant->"Italic"],
 ", that is, as a disjunction of conjunctions, and each conjunction is solved \
separately. If a conjunction contains only equations, ",
 ButtonBox["the method for solving systems of linear equations",
  BaseStyle->"Hyperlink",
  ButtonData->"LinearEqns"],
 " is used. If the difference between the number of variables and the number \
of equations is at most one, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " solves the equations using ",
 ButtonBox["the method for solving systems of linear equations",
  BaseStyle->"Hyperlink",
  ButtonData->"LinearEqns"],
 ", and if the solution contains at most one free parameter (which is true in \
the generic case), back substitutes the solution into the inequalities to \
determine inequality restrictions for the parameter. For all other \
quantifier-free systems of linear Diophantine equations and inequalities ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the algorithm described in [",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"3"],
 "], with some linear-programming-based improvements for handling bounded \
variables. The result may contain new non\[Hyphen]negative integer \
parameters, and the number of new parameters may be larger than the number of \
variables."
}], "Text",
 CellID->389866364],

Cell["\<\
This system has three variables; however, to express the solution set, you \
need eight non\[Hyphen]negative integer parameters.\
\>", "MathCaption",
 CellID->109401115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "+", 
      RowBox[{"2", "b"}], "-", 
      RowBox[{"3", "c"}]}], "\[Equal]", "4"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"3", "a"}], "-", 
      RowBox[{"2", "b"}], "+", "c"}], "\[GreaterEqual]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->5857738],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{485, 339},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->7604364]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Univariate Systems", "Section",
 CellID->101156547],

Cell[CellGroupData[{

Cell["Univariate Equations", "Subsection",
 CellTags->"UnivariateEqns",
 CellID->940041165],

Cell[TextData[{
 "To find integer solutions of univariate equations ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a variant of the algorithm given in [",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"4"],
 "] with improvements described in [",
 ButtonBox["5",
  BaseStyle->"Hyperlink",
  ButtonData->"5"],
 "]. The algorithm can find integer solutions of polynomials of much higher \
degrees than can be handled by real root isolation algorithms and with much \
larger free terms than can be handled by integer factorization algorithms."
}], "Text",
 CellID->273031667],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " finds integer solutions of a sparse polynomial of degree 100,000."
}], "MathCaption",
 CellID->71750999],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{
    SuperscriptBox["x", "100000"], "+", 
    RowBox[{"1234", " ", 
     SuperscriptBox["x", "77777"]}], "-", 
    RowBox[{"2121", " ", 
     SuperscriptBox["x", "12345"]}], "+", 
    RowBox[{"7890", " ", 
     SuperscriptBox["x", "999"]}], "-", 
    SuperscriptBox["x", "11"]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"freeterm", "=", 
   RowBox[{"poly", "/.", "\[InvisibleSpace]", 
    RowBox[{"x", "\[Rule]", "1234567"}]}]}], ";"}], "\n", 
 RowBox[{"Timing", "[", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"poly", "-", "freeterm"}], "\[Equal]", "0"}], ",", "x", ",", 
    "Integers"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[9]:=",
 CellID->3848862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.6979999999999995`", ",", 
   RowBox[{"x", "\[Equal]", "1234567"}]}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->944685127]
}, Open  ]],

Cell["\<\
The free term of this polynomial has 609,152 digits and cannot be easily \
factored.\
\>", "MathCaption",
 CellID->81969822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "freeterm", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->62823905],

Cell[BoxData["2.926904998127342567255744665591`15.954589770191005*^609151"], \
"Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->417246639]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FactorInteger", "[", "freeterm", "]"}], "//", "Timing"}], ",", 
   "1000"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->646475880],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->548978267]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems of Univariate Equations and Inequalities", "Subsection",
 CellID->125613587],

Cell[TextData[{
 "Systems of univariate Diophantine equations and inequalities are written in \
the disjunctive normal form, and each conjunction is solved separately. If a \
conjunction contains an equation, ",
 ButtonBox["the method for solving univariate equations",
  BaseStyle->"Hyperlink",
  ButtonData->"UnivariateEqns"],
 " is used, and the solutions satisfying the remaining equations and \
inequalities are selected."
}], "Text",
 CellID->16645855],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " finds integer solutions of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "4"], "-", 
     RowBox[{"25", " ", 
      SuperscriptBox["x", "2"]}]}], "\[LongEqual]", 
    RowBox[{"-", "144"}]}], TraditionalForm]], "InlineMath"],
 " and selects the ones that satisfy the inequality ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "100001"], "-", 
     RowBox[{"27", "x"}], "+", "5"}], "\[GreaterEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->190054578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "4"], "-", 
      RowBox[{"25", 
       SuperscriptBox["x", "2"]}]}], "\[Equal]", 
     RowBox[{"-", "144"}]}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "100001"], "-", 
      RowBox[{"27", " ", "x"}], "+", "5"}], "\[GreaterEqual]", "0"}]}], ",", 
   "x", ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->457671103],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "3"}], "||", 
  RowBox[{"x", "\[Equal]", "4"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->190059551]
}, Open  ]],

Cell[TextData[{
 "Conjunctions containing only inequalities are solved over the reals. \
Integer solutions in the resulting real intervals are given explicitly if \
their number in the given interval does not exceed the value of the system \
option ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 ". The default value of the option is 10. For intervals containing more \
integer solutions, the solutions are represented implicitly."
}], "Text",
 CellID->512069660]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bivariate Systems", "Section",
 CellID->13440227],

Cell[CellGroupData[{

Cell["Quadratic Equations", "Subsection",
 CellID->192854485],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can solve arbitrary quadratic Diophantine equations in two variables. The \
general form of such an equation is"
}], "Text",
 CellID->12207510],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{"x", ",", "y"}], ")"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"b", " ", "x", " ", "y"}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"d", " ", "x"}], "+", 
     RowBox[{"e", " ", "y"}], "+", "f"}], "\[Equal]", "0."}]}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(1)"}]]}, {None, None}},
 CellTags->"Quadratic",
 CellID->250440120],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalPhi]", "1"], "(", 
      RowBox[{"x", ",", "y"}], ")"}], 
     RowBox[{
      SubscriptBox["\[CapitalPhi]", "2"], "(", 
      RowBox[{"x", ",", "y"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", where",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     SubscriptBox["\[CapitalPhi]", "1"], "(", 
     RowBox[{"x", ",", "y"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "2"], "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " are linear polynomials, the equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalPhi]", "1"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[Or]", 
      RowBox[{
       SubscriptBox["\[CapitalPhi]", "2"], "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], "=", "0"}]}], TraditionalForm]], 
  "InlineMath"],
 ", and methods for solving linear Diophantine equations are used. For \
irreducible polynomials ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 ", the algorithms used and the form of the result depend on the determinant \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", "=", 
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     RowBox[{"4", " ", "a", " ", "c"}]}]}], TraditionalForm]], "InlineMath"],
 " of the quadratic form. The algorithms may use integer factorization and \
hence the correctness of the results depends on the correctness of the \
probabilistic primality test used by",
 " ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 "."
}], "Text",
 CellID->30546744],

Cell[CellGroupData[{

Cell["Hyperbolic type equations with square determinants", "Subsubsection",
 CellID->169792321],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", ">", "0"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SqrtBox["\[CapitalDelta]"], TraditionalForm]], "InlineMath"],
 " is an integer, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalDelta]", " ", 
      RowBox[{"\[CapitalPhi]", "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], "-", "g"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[CapitalPhi]", "1"], "(", 
      RowBox[{"x", ",", "y"}], ")"}], 
     RowBox[{
      SubscriptBox["\[CapitalPhi]", "2"], "(", 
      RowBox[{"x", ",", "y"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", where",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     SubscriptBox["\[CapitalPhi]", "1"], "(", 
     RowBox[{"x", ",", "y"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[CapitalPhi]", "2"], "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " are linear polynomials and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "=", 
    RowBox[{
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["e", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["b", "2"], "f"}], "-", 
     RowBox[{"b", " ", "d", " ", "e"}], "-", 
     RowBox[{"4", " ", "a", " ", "c", " ", "f"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". In this case, the equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") is equivalent to the disjunction of linear systems ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalPhi]", "1"], "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[Delta]", " ", "\[And]", 
      RowBox[{
       SubscriptBox["\[CapitalPhi]", "2"], "(", 
       RowBox[{"x", ",", "y"}], ")"}]}], "=", 
     RowBox[{
      RowBox[{"-", "g"}], "/", "\[Delta]"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", for all divisors ",
 Cell[BoxData[
  FormBox["\[Delta]", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ". Each of the linear systems has one solution over the rationals, hence the \
equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") has a finite number of integer solutions."
}], "Text",
 CellID->702370375],

Cell[TextData[{
 "Here is a binary quadratic equation with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", "=", "9"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->223521695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"12", " ", "x"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"7", " ", "y"}], "+", 
     RowBox[{"5", " ", "x", " ", "y"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["y", "2"]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->215084580],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "3"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "9"}]}]}], ")"}]}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->175018541]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperbolic type equations with nonsquare determinants", "Subsubsection",
 CellID->268472846],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", ">", "0"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SqrtBox["\[CapitalDelta]"], TraditionalForm]], "InlineMath"],
 " is not an integer, then the equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") is a Pell-type equation. Methods for solving such equations have been \
developed since the 18",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " century and can be constructed based on [",
 ButtonBox["6",
  BaseStyle->"Hyperlink",
  ButtonData->"6"],
 "] and [",
 ButtonBox["7",
  BaseStyle->"Hyperlink",
  ButtonData->"7"],
 "] (though these books do not contain a complete description of the \
algorithm). The solution set is empty or infinite, parametrized by an integer \
parameter appearing in the exponent."
}], "Text",
 CellID->337818019],

Cell[TextData[{
 "A Pell equation is an equation of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"D", " ", 
      SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["D", TraditionalForm]], "InlineMath"],
 " is not a square. Solutions to Pell equations with small coefficients can \
be quite complicated."
}], "MathCaption",
 CellID->167354501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"61", " ", 
      SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->901623847],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1766319049", "-", 
            RowBox[{"226153980", " ", 
             SqrtBox["61"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "+", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "-", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "+", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["61"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1766319049", "-", 
            RowBox[{"226153980", " ", 
             SqrtBox["61"]}]}], ")"}], 
          RowBox[{"C", "[", "1", "]"}]]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "+", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1766319049", "-", 
          RowBox[{"226153980", " ", 
           SqrtBox["61"]}]}], ")"}], 
        RowBox[{"C", "[", "1", "]"}]], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1766319049", "+", 
          RowBox[{"226153980", " ", 
           SqrtBox["61"]}]}], ")"}], 
        RowBox[{"C", "[", "1", "]"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["61"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "-", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "+", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "-", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "+", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], 
       RowBox[{"2", " ", 
        SqrtBox["61"]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "-", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1766319049", "+", 
           RowBox[{"226153980", " ", 
            SqrtBox["61"]}]}], ")"}], 
         RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1766319049", "-", 
          RowBox[{"226153980", " ", 
           SqrtBox["61"]}]}], ")"}], 
        RowBox[{"C", "[", "1", "]"}]], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1766319049", "+", 
          RowBox[{"226153980", " ", 
           SqrtBox["61"]}]}], ")"}], 
        RowBox[{"C", "[", "1", "]"}]]}], 
      RowBox[{"2", " ", 
       SqrtBox["61"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{564, 518},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->15330225]
}, Open  ]],

Cell[TextData[{
 "Here is the solution of a Pell-type equation with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", "=", "5"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->812676277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"7", "+", 
      RowBox[{"5", " ", "x"}], "+", 
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"7", " ", "y"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      SuperscriptBox["y", "2"]}], "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]}]], "Input",
 CellLabel->"In[17]:=",
 CellID->277407805],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{565, 1747},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->277820084]
}, Open  ]],

Cell["\<\
Even though the solutions are expressed using nonrational numbers, they are \
in fact integers, as they should be.\
\>", "MathCaption",
 CellID->24913506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"sol", "/.", 
   RowBox[{
    RowBox[{"C", "[", "1", "]"}], "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->600329995],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "143556140002351233"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "375834853819893935"}], "||", 
      RowBox[{"x", "\[Equal]", "54833566187159759"}]}], ")"}]}], ")"}], "||", 
  
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "375834853819893937"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "983948421457330581"}]}], "||", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "143556140002351235"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "54833566187159761"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "143556140002351235"}]}], "||", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "20944558559128053"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "2576010410552097799"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "983948421457330581"}]}], "||", 
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "6744082810198962821"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "6744082810198962819"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "2576010410552097797"}], "||", 
      RowBox[{"x", "\[Equal]", "17656238020044790655"}]}], ")"}]}], ")"}], "||",
   
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "983948421457330579"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "375834853819893935"}], "||", 
      RowBox[{"x", "\[Equal]", "2576010410552097797"}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{571, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->189514895]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can solve systems consisting of a Pell-type equation and inequalities \
giving simple bounds on variables."
}], "MathCaption",
 CellID->78290278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "22"}], " ", "&&", 
    RowBox[{"0", "\[LessEqual]", "y", "\[LessEqual]", "1000000"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->237564403],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "856487"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "494493"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "472765"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "272951"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "229495"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "132499"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "126677"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "73137"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "61493"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "35503"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "33943"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "19597"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "16477"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "9513"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9095"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "5251"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4415"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "2549"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "2437"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "1407"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1183"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "683"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "653"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "377"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "317"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "183"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "175"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "101"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "85"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "49"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "47"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "27"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "23"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "13"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "13"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "7"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "7"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "5"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "7"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "13"}], "&&", 
    RowBox[{"y", "\[Equal]", "7"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "23"}], "&&", 
    RowBox[{"y", "\[Equal]", "13"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "47"}], "&&", 
    RowBox[{"y", "\[Equal]", "27"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "85"}], "&&", 
    RowBox[{"y", "\[Equal]", "49"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "175"}], "&&", 
    RowBox[{"y", "\[Equal]", "101"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "317"}], "&&", 
    RowBox[{"y", "\[Equal]", "183"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "653"}], "&&", 
    RowBox[{"y", "\[Equal]", "377"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1183"}], "&&", 
    RowBox[{"y", "\[Equal]", "683"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2437"}], "&&", 
    RowBox[{"y", "\[Equal]", "1407"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4415"}], "&&", 
    RowBox[{"y", "\[Equal]", "2549"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "9095"}], "&&", 
    RowBox[{"y", "\[Equal]", "5251"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "16477"}], "&&", 
    RowBox[{"y", "\[Equal]", "9513"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "33943"}], "&&", 
    RowBox[{"y", "\[Equal]", "19597"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "61493"}], "&&", 
    RowBox[{"y", "\[Equal]", "35503"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "126677"}], "&&", 
    RowBox[{"y", "\[Equal]", "73137"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "229495"}], "&&", 
    RowBox[{"y", "\[Equal]", "132499"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "472765"}], "&&", 
    RowBox[{"y", "\[Equal]", "272951"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "856487"}], "&&", 
    RowBox[{"y", "\[Equal]", "494493"}]}], ")"}]}]], "Output",
 ImageSize->{560, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->468009843]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parabolic type equations", "Subsubsection",
 CellID->277000449],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "=", 
    RowBox[{
     RowBox[{
      StyleBox["sign",
       FontSlant->"Italic"], "(", "a", ")"}], 
     RowBox[{
      StyleBox["gcd",
       FontSlant->"Italic"], "(", 
      RowBox[{"a", ",", "c"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "1"], "=", 
    SqrtBox[
     RowBox[{"a", "/", "g"}]]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["c", "1"], "=", 
    RowBox[{
     RowBox[{
      StyleBox["sign",
       FontSlant->"Italic"], "(", 
      RowBox[{"b", "/", "g"}], ")"}], 
     SqrtBox[
      RowBox[{"c", "/", "g"}]]}]}], TraditionalForm]], "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["b", "2"], "=", 
    RowBox[{"4", 
     RowBox[{
      SuperscriptBox["g", "2"], "(", 
      RowBox[{"a", "/", "g"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"c", "/", "g"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["a", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "1"], TraditionalForm]], "InlineMath"],
 " are nonzero integers, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", 
    RowBox[{"2", "g", " ", 
     SubscriptBox["a", "1"], 
     SubscriptBox["c", "1"]}]}], TraditionalForm]], "InlineMath"],
 ". Then"
}], "Text",
 CellID->15585768],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{"x", ",", "y"}], ")"}], "=", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"g", "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], "x"}], "+", 
       RowBox[{
        SubscriptBox["c", "1"], "y"}]}], ")"}], "2"], "+", 
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}], "+", 
    RowBox[{"f", "."}]}]}], TraditionalForm]], "DisplayMath",
 CellID->443509506],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["c", "1"], "d"}], "-", 
     RowBox[{
      SubscriptBox["a", "1"], "e"}]}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], " ", "x"}], "+", 
     RowBox[{
      SubscriptBox["c", "1"], " ", "y"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Then the equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") is equivalent to"
}], "Text",
 CellID->121755007],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["a", "1"], 
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{"x", ",", "y"}], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], 
      SuperscriptBox[
       RowBox[{"g", "(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], "x"}], "+", 
         RowBox[{
          SubscriptBox["c", "1"], "y"}]}], ")"}], "2"]}], "+", 
     RowBox[{"d", "(", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], " ", "x"}], "+", 
       RowBox[{
        SubscriptBox["c", "1"], " ", "y"}]}], ")"}], "-", 
     RowBox[{"m", " ", "y"}], "+", 
     RowBox[{
      SubscriptBox["a", "1"], "f"}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["a", "1"], "g", " ", 
       SuperscriptBox["t", "2"]}], "+", 
      RowBox[{"d", " ", "t"}], "-", 
      RowBox[{"m", " ", "y"}], "+", 
      RowBox[{
       SubscriptBox["a", "1"], "f"}]}], "\[Equal]", "0."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(2)"}]]}, {None, None}},
 CellTags->"Parabolic1",
 CellID->141071864],

Cell[TextData[{
 "Suppose ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", "0"}], TraditionalForm]], "InlineMath"],
 ". If the equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") had integer solutions, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], "g", " ", 
      SuperscriptBox["t", "2"]}], "+", 
     RowBox[{"d", " ", "t"}], "+", 
     RowBox[{
      SubscriptBox["a", "1"], "f"}]}], "=", "0"}], TraditionalForm]], 
  "InlineMath"],
 " would have integer solutions in ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ", and so ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " would be a product of two linear polynomials. Since here ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " is irreducible, the equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") has no integer solutions. "
}], "Text",
 CellID->202057420],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[NotEqual]", "0"}], TraditionalForm]], "InlineMath"],
 ", then the equation (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic1"],
 ") implies"
}], "Text",
 CellID->435636865],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["a", "1"], "g", " ", 
     SuperscriptBox["t", "2"]}], "+", 
    RowBox[{"d", " ", "t"}], "+", 
    RowBox[{
     SubscriptBox["a", "1"], "f"}]}], "\[Congruent]", 
   RowBox[{"0", "  ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["mod",
        FontSlant->"Italic"], 
       StyleBox[" ",
        FontSlant->"Italic"], "|", "m", "|"}], ")"}], "."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(3)"}]]}, {None, None}},
 CellTags->"Parabolic2",
 CellID->328505180],

Cell[TextData[{
 "If the modular equation (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic2"],
 ") has no solutions in ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ", the equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") has no integer solutions. (If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"|", "m", "|"}], "=", "1"}], TraditionalForm]], "InlineMath"],
 ", the modular equation (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic2"],
 ") has one solution, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", "0"}], TraditionalForm]], "InlineMath"],
 ".) Otherwise ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{"u", "+", 
     RowBox[{"k", " ", "m"}]}]}], TraditionalForm]], "InlineMath"],
 ", for some solution ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"0", "\[LessEqual]", "u", "<"}], "|", "m", "|"}], 
   TraditionalForm]], "InlineMath"],
 " of the modular equation (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic2"],
 "). Replacing ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "\[Rule]", 
    RowBox[{"u", "+", 
     RowBox[{"k", " ", "m"}]}]}], TraditionalForm]], "InlineMath"],
 " in the equation (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic1"],
 ") and solving the resulting linear equation for ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " gives"
}], "Text",
 CellID->14815555],

Cell[BoxData[
 FormBox[
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "1"], "g", " ", "m", " ", 
     SuperscriptBox["k", "2"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "+", 
       RowBox[{"2", 
        SubscriptBox["a", "1"], "g", " ", "u"}]}], ")"}], "k"}], "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "1"], "g", " ", 
        SuperscriptBox["u", "2"]}], "+", 
       RowBox[{"d", " ", "u"}], "+", 
       RowBox[{
        SubscriptBox["a", "1"], "f"}]}], ")"}], "/", 
     RowBox[{"m", "."}]}]}]}], TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(4)"}]]}, {None, None}},
 CellTags->"Parabolic3",
 CellID->238897076],

Cell[TextData[{
 "Note that since ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " satisfies the modular equation (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic2"],
 "), the division in the last term of (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic3"],
 ") gives an integer result. Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], " ", "x"}], "+", 
     RowBox[{
      SubscriptBox["c", "1"], " ", "y"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{"u", "+", 
     RowBox[{"k", " ", "m"}]}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"u", "+", 
       RowBox[{"k", " ", "m"}], "-", 
       RowBox[{
        SubscriptBox["c", "1"], "y"}]}], ")"}], "/", 
     SubscriptBox["a", "1"]}]}], TraditionalForm]], "InlineMath"],
 ". Taking the equation (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic3"],
 ") and the fact that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["c", "1"], "d"}], "-", 
     RowBox[{
      SubscriptBox["a", "1"], "e"}]}]}], TraditionalForm]], "InlineMath"],
 " into account gives"
}], "Text",
 CellID->894213245],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["c", "1"]}], "g", " ", "m", " ", 
     SuperscriptBox["k", "2"]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"e", "+", 
       RowBox[{"2", 
        SubscriptBox["c", "1"], "g", " ", "u"}]}], ")"}], "k"}], "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SubscriptBox["c", "1"], "g", " ", 
        SuperscriptBox["u", "2"]}], "+", 
       RowBox[{"e", " ", "u"}], "+", 
       RowBox[{
        SubscriptBox["c", "1"], "f"}]}], ")"}], "/", 
     RowBox[{"m", "."}]}]}]}], TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(5)"}]]}, {None, None}},
 CellTags->"Parabolic4",
 CellID->69774393],

Cell[TextData[{
 "Therefore, the full solution of the equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") of parabolic type consists of one-parameter solution families given by \
equations (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic3"],
 ") and (",
 ButtonBox["5",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic4"],
 ") for each solution ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " of the modular equation (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"Parabolic2"],
 "), for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["c", "1"], "g", " ", 
       SuperscriptBox["u", "2"]}], "+", 
      RowBox[{"e", " ", "u"}], "+", 
      RowBox[{
       SubscriptBox["c", "1"], "f"}]}], ")"}], "/", "m"}], TraditionalForm]], 
  "InlineMath"],
 " is an integer."
}], "Text",
 CellID->346478772],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " finds integer solutions of a quadratic equation of the parabolic type."
}], "MathCaption",
 CellID->262817330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "-", 
     RowBox[{"2", " ", "x", " ", "y"}], "+", 
     SuperscriptBox["y", "2"], "+", 
     RowBox[{"5", " ", "x"}], "-", 
     RowBox[{"7", " ", "y"}]}], "\[Equal]", "22"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->764095279],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "11"}], "+", 
      RowBox[{"7", " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"C", "[", "1", "]"}], "2"]}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "11"}], "+", 
      RowBox[{"5", " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"C", "[", "1", "]"}], "2"]}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
    RowBox[{"x", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "7"}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"C", "[", "1", "]"}], "2"]}]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      RowBox[{"7", " ", 
       RowBox[{"C", "[", "1", "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"C", "[", "1", "]"}], "2"]}]}]}]}], ")"}]}]], "Output",
 ImageSize->{477, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->156628762]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptic type equations", "Subsubsection",
 CellID->262833632],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalDelta]", "<", "0"}], TraditionalForm]], "InlineMath"],
 ", the solutions of equation (",
 ButtonBox["1",
  BaseStyle->"Hyperlink",
  ButtonData->"Quadratic"],
 ") are integer points on an ellipse. Since an ellipse is a bounded set, the \
number of solutions must be finite. An obvious algorithm for finding integer \
points would be to compute the solutions for ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " for each of the finite number of possible integer values of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". This, however, would be prohibitively slow for larger ellipses. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a faster algorithm described in [",
 ButtonBox["8",
  BaseStyle->"Hyperlink",
  ButtonData->"8"],
 "]."
}], "Text",
 CellID->30996886],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " finds positive integer solutions of a quadratic equation of the elliptic \
type. There are more than ",
 Cell[BoxData[
  FormBox[
   RowBox[{"8", "\[Times]", 
    SuperscriptBox["10", "18"]}], TraditionalForm]], "InlineMath"],
 " possible positive integer values of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", so the obvious algorithm would not be practical for this ellipse."
}], "MathCaption",
 CellID->486256267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"23", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"17", 
       SuperscriptBox["y", "2"]}]}], "\[Equal]", 
     "1693339429465935072912802926367922572800"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->417391655],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1234567890987654321"}], "&&", 
    RowBox[{"y", "\[Equal]", "9876543210123456789"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2394388915976549628"}], "&&", 
    RowBox[{"y", "\[Equal]", "9583927013507483052"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3587688774846621081"}], "&&", 
    RowBox[{"y", "\[Equal]", "9066079904941225629"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4628858032573225308"}], "&&", 
    RowBox[{"y", "\[Equal]", "8403549375095756172"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4730542803202013073"}], "&&", 
    RowBox[{"y", "\[Equal]", "8326586121887736693"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6448688263945408950"}], "&&", 
    RowBox[{"y", "\[Equal]", "6583719143723572530"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6563464511756847993"}], "&&", 
    RowBox[{"y", "\[Equal]", "6428433631978684413"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "7787179624084878150"}], "&&", 
    RowBox[{"y", "\[Equal]", "4191136305399154530"}]}], ")"}]}]], "Output",
 ImageSize->{401, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->315430140]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Thue Equations", "Subsection",
 CellID->55469500],

Cell[TextData[{
 "A",
 StyleBox[" Thue ",
  FontSlant->"Italic"],
 "equation is a Diophantine equation of the form"
}], "Text",
 CellID->159783309],

Cell["\[CapitalPhi](x, y) = m,", "DisplayMath",
 CellID->157187725],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " is an irreducible homogenous form of degree \[GreaterEqual] 3. "
}], "Text",
 CellID->119621423],

Cell[TextData[{
 "The number of solutions of Thue equations is always finite. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can in principle solve arbitrary Thue equations, though the time necessary \
to find the solutions lengthens very fast with degree and coefficient size. \
The hardest part of the algorithm is computing a bound on the size of \
solutions. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses an algorithm based on the Baker\[Dash]Wustholz theorem to find the \
bound [",
 ButtonBox["9",
  BaseStyle->"Hyperlink",
  ButtonData->"9"],
 "]. If the input contains inequalities that provide a reasonable size bound \
on solutions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can compute the solutions much faster."
}], "Text",
 CellID->15680138],

Cell["This finds integer solutions of a cubic Thue equation.", "MathCaption",
 CellID->313292578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"4", " ", "x", " ", 
       SuperscriptBox["y", "2"]}], "+", 
      SuperscriptBox["y", "3"]}], "==", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->323337918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6209999999999491`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "2"}]}], "&&", 
      RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "0"}], "&&", 
      RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "1"}], "&&", 
      RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "1"}], "&&", 
      RowBox[{"y", "\[Equal]", "4"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "2"}], "&&", 
      RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "508"}], "&&", 
      RowBox[{"y", "\[Equal]", "273"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{495, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->45360015]
}, Open  ]],

Cell[TextData[{
 "If we give ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " a bound on the size of solutions, it can solve the equation much faster."
}], "MathCaption",
 CellID->775838566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "3"], "-", 
       RowBox[{"4", " ", "x", " ", 
        SuperscriptBox["y", "2"]}], "+", 
       SuperscriptBox["y", "3"]}], "==", "1"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"10", "^", "10"}]}], "<", "x", "<", 
      RowBox[{"10", "^", "10"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->14199522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04999999999998095`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "2"}]}], "&&", 
      RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "0"}], "&&", 
      RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "1"}], "&&", 
      RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "1"}], "&&", 
      RowBox[{"y", "\[Equal]", "4"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "2"}], "&&", 
      RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "508"}], "&&", 
      RowBox[{"y", "\[Equal]", "273"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->809093723]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " finds the only solution of a degree 15 Thue equation with at most a \
100-digit ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinate. Without the bound on the solution size, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " did not finish in 1000 seconds."
}], "MathCaption",
 CellID->206191399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "15"], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"x", " "}], "12"], 
        SuperscriptBox["y", "3"]}], "+", 
       RowBox[{"7", 
        SuperscriptBox["x", "7"], 
        SuperscriptBox["y", "8"]}], "-", 
       RowBox[{"2", 
        SuperscriptBox["y", "15"]}]}], "\[Equal]", 
      "23058325506004605670097246320963935108919550"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"10", "^", "100"}]}], "<", "x", "<", 
      RowBox[{"10", "^", "100"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->332355893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12.35999999999995`", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "777"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "121"}]}]}]}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->37695497]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Nonlinear Systems", "Section",
 CellID->479923181],

Cell[CellGroupData[{

Cell["Systems Solvable with the Modular Sieve Method", "Subsection",
 CellTags->"Sieve",
 CellID->276178224],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a variant of the modular sieve method (see e.g. [",
 ButtonBox["9",
  BaseStyle->"Hyperlink",
  ButtonData->"9"],
 "]). The method may prove that a system has no solutions in integers modulo \
an integer ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", and therefore, it has no integer solutions. Otherwise, it may find a \
solution with small integer coordinates or prove that the system has no \
integer solutions with all coordinates between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "b"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ". The number of candidate solution points that the sieve method is allowed \
to test is controlled by the system option ",
 Cell[BoxData["SieveMaxPoints"], "InlineFormula"],
 ". "
}], "Text",
 CellID->53385984],

Cell["This equation has no solutions modulo 2.", "MathCaption",
 CellID->287347954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["x", "3"], " ", 
      SuperscriptBox["y", "9"]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["x", "5"], " ", 
      SuperscriptBox["y", "5"], " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["x", "8"], " ", 
      SuperscriptBox["y", "2"], " ", 
      SuperscriptBox["z", "5"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["x", "7"], " ", 
      SuperscriptBox["y", "6"], " ", 
      SuperscriptBox["z", "7"]}]}], "\[Equal]", "7"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->490125107],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->374506010]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " finds a small solution using the modular sieve."
}], "MathCaption",
 CellID->326409774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"9", " ", 
      SuperscriptBox["x", "6"], " ", 
      SuperscriptBox["y", "8"], " ", "z"}], "-", 
     RowBox[{"81", " ", 
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox["y", "9"], " ", "z"}], "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["x", "9"], " ", 
      SuperscriptBox["y", "5"], " ", 
      SuperscriptBox["z", "5"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "6"], " ", 
      SuperscriptBox["y", "2"], " ", 
      SuperscriptBox["z", "9"]}]}], "\[Equal]", "1080"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->153182627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "2"}], ",", 
    RowBox[{"z", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->369341712]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems with More Than one Equation", "Subsection",
 CellTags->"ManyEqn",
 CellID->11174366],

Cell[TextData[{
 "If a Diophantine polynomial system contains more than one equation, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " in an attempt to reduce the problem to a sequence of simpler problems."
}], "Text",
 CellID->457704621],

Cell[CellGroupData[{

Cell["\<\
Systems solvable by recursion over finitely many partial solutions\
\>", "Subsubsection",
 CellID->718104328],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to solve an element of the Gr\[ODoubleDot]bner basis that depends \
on the minimal number of the initial variables. If the number of solutions is \
finite, then for each solution ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " substitutes the computed values and attempts to solve the obtained system \
for the remaining variables."
}], "Text",
 CellID->193959803],

Cell[TextData[{
 "Here the first equation has four integer solutions for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". For each of the solutions, the second equation becomes a univariate \
equation in ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ". The four univariate equations have a total of two integer solutions. "
}], "MathCaption",
 CellID->717643889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "4"], "-", 
      RowBox[{"x", " ", "y"}], "+", 
      SuperscriptBox["y", "2"]}], "\[Equal]", "7"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "4"], "-", 
      RowBox[{"x", " ", "z"}], "+", 
      SuperscriptBox["y", "2"], "+", "y"}], "\[Equal]", "2400"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->41402925],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "3"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "7"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "7"}]}]}], ")"}]}]], "Output",
 ImageSize->{355, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->347203758]
}, Open  ]],

Cell[TextData[{
 "Here the first equation is a Thue equation with one solution. After \
replacing ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " with the values computed from the first equation, the second equation \
becomes a Pell equation."
}], "MathCaption",
 CellID->189250134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["y", "3"]}]}], "\[Equal]", "11"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["z", "2"], "-", 
      RowBox[{"x", " ", "y", " ", 
       SuperscriptBox["w", "2"]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"z", ">", "0"}], "&&", 
    RowBox[{"w", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->188911562],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "3"}], "&&", 
  RowBox[{"y", "\[Equal]", "2"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "-", 
         RowBox[{"2", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"2", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
  RowBox[{"w", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "-", 
         RowBox[{"2", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "+", 
         RowBox[{"2", " ", 
          SqrtBox["6"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]]}]}]}]], "Output",
 ImageSize->{496, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->31607602]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Systems with linear-triangular Gr\[ODoubleDot]bner bases\
\>", "Subsubsection",
 CellID->166093770],

Cell["\<\
This heuristic applies to systems with Gr\[ODoubleDot]bner bases of the form\
\>", "Text",
 CellID->36505167],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["c", "1"], 
       SubscriptBox["x", "1"]}], "-", 
      RowBox[{
       SubscriptBox["f", "1"], "(", "Y", ")"}]}], ",", "\[Ellipsis]", ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["c", "k"], 
       SubscriptBox["x", "k"]}], "-", 
      RowBox[{
       SubscriptBox["f", "k"], "(", "Y", ")"}]}], ",", 
     RowBox[{"g", "(", "Y", ")"}]}], "}"}], "."}], 
  TraditionalForm]], "DisplayMath",
 CellID->185106411],

Cell[TextData[{
 "In this case, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " solves the system of congruences"
}], "Text",
 CellID->121479120],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["f", "1"], "(", "Y", ")"}], "\[Congruent]", 
    RowBox[{"0", " ", "mod", " ", 
     SubscriptBox["c", "1"]}]}], "\[And]", "\[Ellipsis]", "\[And]", 
   RowBox[{
    RowBox[{
     SubscriptBox["f", "k"], "(", "Y", ")"}], "\[Congruent]", 
    RowBox[{"0", " ", "mod", " ", 
     RowBox[{
      SubscriptBox["c", "k"], "."}]}]}]}], TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(1)"}]]}, {None, None}},
 CellTags->"Congruences",
 CellID->86771084],

Cell[TextData[{
 "The solutions are represented using new integer parameters. These are \
substituted into the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "Y", ")"}], "\[Equal]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " and the inequalities present in the original system, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to solve the so-obtained systems for the new parameters."
}], "Text",
 CellID->9976895],

Cell["\<\
This system reduces to solving a congruence and a Pell equation.\
\>", "MathCaption",
 CellID->217316773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"7", " ", 
       SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{"2", " ", "z"}], "\[Equal]", 
     RowBox[{
      SuperscriptBox["x", "3"], "-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"t", "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["z", "2"]}], "+", "y"}], "\[Equal]", "7"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->733855660],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"1", "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"127", "-", 
             RowBox[{"48", " ", 
              SqrtBox["7"]}]}], ")"}], 
           RowBox[{"C", "[", "1", "]"}]], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"127", "+", 
             RowBox[{"48", " ", 
              SqrtBox["7"]}]}], ")"}], 
           RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], ")"}]}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"127", "-", 
         RowBox[{"48", " ", 
          SqrtBox["7"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"127", "+", 
         RowBox[{"48", " ", 
          SqrtBox["7"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], 
     RowBox[{"2", " ", 
      SqrtBox["7"]}]]}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"127", "-", 
                  RowBox[{"48", " ", 
                   SqrtBox["7"]}]}], ")"}], 
                RowBox[{"C", "[", "1", "]"}]], "+", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"127", "+", 
                  RowBox[{"48", " ", 
                   SqrtBox["7"]}]}], ")"}], 
                RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], ")"}]}]}], ")"}], 
       "3"]}], ")"}]}]}], "&&", 
  RowBox[{"t", "\[Equal]", 
   RowBox[{"8", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "6"], "-", "y"}]}]}]], "Output",
 ImageSize->{571, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->73236175]
}, Open  ]],

Cell["\<\
This system reduces to solving a system of two congruences and a quadratic \
Diophantine equation of the parabolic type for each family of congruence \
solutions.
\
\>", "MathCaption",
 CellID->309531394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", " ", "z"}], "\[Equal]", 
     RowBox[{
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"2", " ", "x", " ", "y"}]}]}], "&&", 
    RowBox[{
     RowBox[{"2", " ", "t"}], "\[Equal]", 
     RowBox[{
      SuperscriptBox["x", "3"], "+", 
      RowBox[{"96", " ", 
       SuperscriptBox["z", "2"]}], "-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"2", " ", "y"}]}], ")"}], "2"], "-", 
      RowBox[{"3", " ", "x"}]}], "\[Equal]", "18"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->515352053],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{547, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->70239532]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sums of Squares", "Subsection",
 CellID->76762835],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can solve equations of the form"
}], "Text",
 CellID->842843879],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     SubscriptBox["x", "1"], "2"], "+", 
    SuperscriptBox[
     SubscriptBox["x", "2"], "2"], "+", "\[Ellipsis]", "+", 
    SuperscriptBox[
     SubscriptBox["x", "n"], "2"]}], "\[Equal]", "m"}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(2)"}]]}, {None, None}},
 CellTags->"SumOfSquares",
 CellID->624380415],

Cell[TextData[{
 "using the algorithm described in [",
 ButtonBox["10",
  BaseStyle->"Hyperlink",
  ButtonData->"10"],
 "]. For multivariate quadratic equations, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to find an affine transformation that puts the equation in the \
form (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"SumOfSquares"],
 "). A heuristic method based on ",
 Cell[BoxData[
  ButtonBox["CholeskyDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CholeskyDecomposition"]], "InlineFormula"],
 " is used for this purpose. However, the method may fail for some equations \
that can be represented in the form (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"SumOfSquares"],
 ")."
}], "Text",
 CellID->291279106],

Cell["This solves a sum-of-squares equation in three variables.", \
"MathCaption",
 CellID->29323096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"2", " ", "y"}], "+", 
        RowBox[{"3", " ", "z"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "y"}], "+", 
        RowBox[{"5", " ", "z"}]}], ")"}], "2"], "+", 
     SuperscriptBox["z", "2"]}], "\[Equal]", "14"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->650809474],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "19"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "15"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "5"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "9"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "15"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "3"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "19"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "3"}]}]}], ")"}]}]], "Output",
 ImageSize->{545, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->34429944]
}, Open  ]],

Cell[TextData[{
 "To find a single solution of (",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"SumOfSquares"],
 ") ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " uses an algorithm based on [",
 ButtonBox["12",
  BaseStyle->"Hyperlink",
  ButtonData->"12"],
 "]."
}], "Text",
 CellID->34597627],

Cell[TextData[{
 "This finds a decomposition of a 10000-digit integer into a sum of seven \
squares. ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " is applied to make the printed result smaller."
}], "MathCaption",
 CellID->250147251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "10", "]"}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      SuperscriptBox["10", "10000"]}], "}"}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"s7", "=", 
     RowBox[{"FindInstance", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"], "+", 
         SuperscriptBox["z", "2"], "+", 
         SuperscriptBox["t", "2"], "+", 
         SuperscriptBox["u", "2"], "+", 
         SuperscriptBox["v", "2"], "+", 
         SuperscriptBox["w", "2"]}], "\[Equal]", "a"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}], 
        "}"}], ",", "Integers"}], "]"}]}], "]"}], "//", "Timing"}]}]], "Input",\

 CellLabel->"In[32]:=",
 CellID->43278149],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.529`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
      "x", "\[Rule]", 
       "4.6547839938898788816842670956`15.954589770191005*^4999"}], ",", 
      RowBox[{
      "y", "\[Rule]", 
       "2.728258415849877128464318987675909`15.954589770191005*^2499"}], ",", 
      
      RowBox[{
      "z", "\[Rule]", 
       "3.4568501258045976622062274`15.954589770191005*^1249"}], ",", 
      RowBox[{
      "t", "\[Rule]", 
       "4.532687928125587117462140661`15.954589770191005*^624"}], ",", 
      RowBox[{
      "u", "\[Rule]", 
       "3.52338701671742811007674602`15.954589770191005*^624"}], ",", 
      RowBox[{
      "v", "\[Rule]", 
       "3.170130382788626476923049729`15.954589770191005*^624"}], ",", 
      RowBox[{
      "w", "\[Rule]", 
       "1.713114815166737470835346264`15.954589770191005*^624"}]}], "}"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{423, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->138292553]
}, Open  ]],

Cell["This proves that the decomposition found is correct.", "MathCaption",
 CellID->210849536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"y", "^", "2"}], "+", 
   RowBox[{"z", "^", "2"}], "+", 
   RowBox[{"t", "^", "2"}], "+", 
   RowBox[{"u", "^", "2"}], "+", 
   RowBox[{"v", "^", "2"}], "+", 
   RowBox[{"w", "^", "2"}], "-", "a"}], "/.", "s7"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->414400811],

Cell[BoxData[
 RowBox[{"{", "0", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->655187225]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pythagorean Equation", "Subsection",
 CellID->336018421],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows the solution to the Pythagorean equation"
}], "Text",
 CellID->466314649],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "\[Equal]", 
   RowBox[{
    SuperscriptBox["z", "2"], "."}]}], TraditionalForm]], "DisplayMath",
 CellTags->"PythagoreanTriples",
 CellID->54624850],

Cell["This gives the general solution of the Pythagorean equation.", \
"MathCaption",
 CellID->732534261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "==", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->616941761],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}], "|", 
     RowBox[{"C", "[", "3", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{
   RowBox[{"C", "[", "3", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"C", "[", "2", "]"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"C", "[", "3", "]"}], "2"]}], ")"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"2", " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"C", "[", "3", "]"}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"C", "[", "2", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"C", "[", "3", "]"}], "2"]}], ")"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"C", "[", "3", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"C", "[", "2", "]"}], "2"], "-", 
          SuperscriptBox[
           RowBox[{"C", "[", "3", "]"}], "2"]}], ")"}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"C", "[", "2", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"C", "[", "3", "]"}], "2"]}], ")"}]}]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{510, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->162106900]
}, Open  ]],

Cell[TextData[{
 "For quadratic equations in three variables, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to find a transformation of the form"
}], "Text",
 CellID->16586492],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["x", "1"], "=", 
    RowBox[{"x", "+", 
     RowBox[{"a", " ", "y"}], "+", 
     RowBox[{"b", " ", "z"}], "+", "c"}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["y", "1"], "=", 
    RowBox[{"y", "+", 
     RowBox[{"d", " ", "z"}], "+", "e"}]}], ",", "\n", 
   RowBox[{
    SubscriptBox["z", "1"], "=", 
    RowBox[{"z", "+", "f"}]}], ","}], TraditionalForm]], "DisplayMath",
 CellTags->"PythagoreanTriples",
 CellID->42507905],

Cell["transforming the equation to the Pythagorean equation.", "Text",
 CellID->340810444],

Cell["\<\
This equation can be transformed to the Pythagorean equation.\
\>", "MathCaption",
 CellID->1351366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "x"}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"2", " ", "y"}], "+", 
     RowBox[{"4", " ", "x", " ", "y"}], "+", 
     SuperscriptBox["y", "2"], "+", 
     RowBox[{"28", " ", "x", " ", "z"}], "+", 
     RowBox[{"6", " ", "y", " ", "z"}], "+", 
     RowBox[{"72", " ", 
      SuperscriptBox["z", "2"]}]}], "\[Equal]", "8"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->98402069],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXUuTFEUQHmZ2FwSFXVgQEdgVF8IIQHwgD19wEgI0fP+ADUThYIjIAQ31
4N2LByP8E17VmxrhUQ/q3cdPUO/lVHXXTM83WZ2VXdU93T09ETuzWV2PzOys
R+dXWf3S5p0b19/dvHPz2ub6pdubt27cvPbB+gvv3R4mDbb0ev0zvV7vs/29
4f9q+J/5s59zw79e7039PRil984A/QrQCwz9dmD5jwxXbzBcvSas9a3A8h82
iKtDw6/+kNyR/m6H69vh+hrQO4RcXK24vUTq1yH1MNBY61bmOtKHmOsoJcf1
lZrzd9do9fLwWydug6uDNB25XErTFyG9P/xaHJLYCpYfCMvf69m+q16pVnT9
2kZNhUmy4Q3TBim/qw79tV1PifVc0t+L2TmmR9hMn8y1BLkWyVwcH5we6bax
lF8u1LEfx351S/Vv2l4Y06lxTqTQ/FnLSKq0nyUyL2qzu0dl9RHsDbafYz/F
fIV0nVPfgNIf6MCHL0qeYHtPtTj6nrhv41TkbT8hY6fbOHZK3qcKdcrVR44H
FeqW49e1vpocnbFVlKLTOmXRrrWtzt0nbLtqLVJrsxAtWrlirIFla499acuo
6U6jCR0ywlIr+zJ1yPXF1cDyUt1tzdwD+6uVeD/ku2/O9RT+RLaTTK3T6l7n
0uSuEurEPs7JeZKs3Y+zTocJPTlP3+OodXn4u5C22s/82hEBe0qfyD8AOpuf
qj8vv5Q+lda30nA5/Hzi6Jc9DjTOyVKfeez62ywVh/UczNC6Xx8HWtoqYkGx
60+woq8ZXX3FXP/c1KLSzzmC+oXRG4dxrQH9MNAvA520+jPTKocWIUKArb4K
9NkZtrqhkrHqaTWJDS0zNPYTKfa1zuTnpMP6pNgX5k+0cQxSzwONWM/OwOsP
Ah0bS+Pqw5ketY78ce3FxtKQP9Mnpu7SHpU8iVBPoTadWhW5MJxY+V0Yz7LK
x/qop3cJP6EYFvUEJ5GPs6pdabuhfIaW3xso19ga+z0XnoNl/NC2OPhOTMwl
Zl30E4/fsxbmWoiiqTKf87A3xdSkT08rquk66XC1RJ0lvfhoJlWX2kdIS80x
HO3VR3PKc1hVqEffzpGoFR++XHNhsNUE6GOHioPdcT0ru7bIpuPcHYrg1BXb
pOxF13tCjXrT1B4I+ewYGxkquzyntT3C+jg/3qzxRXJuK7HXrZQsT+z6QrEH
eq7aMKrGeW4vUzeFvpbZFzgMsCjmt6JojHMhJ71Km+DklvYZlx64vrKbqbfq
vsLphesrvnpI+oj2fk3PN9gG6gh5qnp+qHp+qRumzY1hofMHp5+q+0TZ2DXd
N56HVBpv7nwQzcfnl0uok5OrLT6HMvF5TE/65XMqmeFW1DjmIw+n3kZcH2Ro
7vpuNVu8n8Lh8/JzKKXVGyVPnfB+lMMP/0Ms5wTBdZ52OHyQQ76x/iZzzeHK
iJefAJrjeo3hmsPjsf4xNv4Io89bjD6eHdWkPxTmfgBKPAM0YuYoqxSj/920
+gDTKqLXaBdStPy3GrV6RMXFspHLsrH5RCqM7kCbrxorrju2/utYa2NPaapx
G+looxqbgojOO7LtG7X6vaJ6jBn1J7zmNKZstFDrtXOZeF2HHleFHvvEtv6o
KEvW+bTNc/6ctqFf9N3hIks6LHWstdG3I6b0B5Vnb1oDjvGyQr1WjQr5jYgd
thgmLz3STc/ZPjhGTD1Whau41nYd7lbYjpzrfsQp2oZDFBux5g2twohLegQ6
QOqyTmvYKj3pHa4TS5O0vwJ9V9r66uxbz8MErCabhHH4+S2lXnHOrxnqxW8y
15w/XOrLX2O4DsUeEn/6XUaXHzO6+cPUotIPhRNchBKfAn0WaMQNuPHmHWF5
Mxv3Lgi5Qg8/x9V1YfnVBnGlUyUxgNj/DsP1UByDk/rFktvjnmhMT5zaTYOr
wtgxgzgerTH5y8ZZuLt0tWb8kT7gqbv6hKJj1CyyULeYwl1KhrxI+Zn1uZhS
q/NFYhZUu84PjWf9RZ+i2r1vkH5GLIY+xdFUU0/xlPZoHzRqiWyZRlHpvN09
ij+aPAmp1ByFY14e7WUpOeXLjqm0c0oYGlj1mX2zwk4lM8Ho24EOYtvzduJs
nP56Wliq6VGZfnM6hzdVbVNcfbHPfi2yAs+77lppT87S837ibpwe/RTTauy9
ALOKDXU9Bdv883Iubuy+aq7P9UnDcfoh+vqlK9WmxaMWm1nbdoKwtDci7q/r
10ps+0nLne+qvr6r+T5PWSrno50OxTr09yXpRNd+jrJjZrn9JHU7W1p6su9j
DZXDD6u9AKkcDi/dkcJpF3H60PqL7S5ohlQXhVJJ9+FwUuH+k9D6k/0p+t+D
cEV6bvb6qCb9ofbm3IYSGIOLdwh1ycXsfmdaeR9SMfoV5cRWuGjZbytsZUMl
45Ee/0L2lOBuBOQudI8M987WRJpjkHoK6KrfgTrrPSvcTp9vSK25zpWuek+A
NCoXpW373hD/uxv7nOY6rd1jxtyiRrtdD2VplrbVo5lUXYvrNOK24pgU6rNI
jFQ+/tN50hMlh27HvKkl2qm8dcPcYr/hDU+FlKJZddNP1W8BTcawDdMUjodc
zFzd8KOi0bOoI7t3ft6RST/b8Tu9FXfKNx3/CB2H2oYH+dmK32mmdVpflull
RxvpMJ9YmqStL3tmZ5385VR5TTYFt+Bo2jcofXsj5zsMfRtkk7hEn7H0nZGc
Tzn0HZSJz/kLRtZPmOs/mVpU+qF857jSQT6+ZOTk4lT/M61wflyuFS7C898a
taJji+scV5pIweU6CfS8xXX+49ZS7jk2XbSkm49ZRQH6Rkf+6b7nuK4qfG5l
t+eq85z75IpxWuXfysee7WmC6HXv4tLa7EuPeUrlX0piZ/SpldI3MoZaX2j5
LsoqhpZCTxf0G+GmZ2zcWy5tV2otXQQQLXdV8SoBduRc7aMNddErRaSumxde
ekql3whEn1rZPQt0vniqTk6uxDfB+aEOqC5GoMje+ji+xNBd4XXiItRHHLqX
PPEh63+xR6M8apRTfyh/9yRFrSOyvlRcP+2E62jzeB0l0TuTNXka8umLVwxH
WAJ7B1oEzmec3xU1yOXH3vI4Q2N5/XXZSIY1Sb2EsfclS72MFD963LHxqkkB
+7GZbW2DNDf+Wm7tqGfXFz4nuUm4t1xaqX3b0YUfIu+f35zG0cV2Hvu1Xcyj
WEwubucPXavR6VZITa8tkSW4Vf+ALOXjLYypHbyrOb5whiv9Y96tRttfTpuF
LC/nOvfMTlobM35J5uIAC+NWP2IroxAfX2+hz7iepxc7cvH4CseJLnNE1cG2
pE8yZdgWtePc36YWQcvj3HaGoyzPzkQSuy/yRD/yGU1xx90J/VWP8YfzpUlt
xOVLKzLuWL+Yr48Ddecub1EDepzidF5UB/ljTHNsxmcsLXNcsWtkM65MeVLt
OtP+a0eJQW/89J7NYz0KA0f57Pp5UdF3ViqR30oGW9XpiQXQdsvZRVtXzSg3
vvkJx5bzEdum3yKjf82JrbgaVbzXjLJ0lxeKijKSeK307njN/CWm3J6U1oXM
yZYjcXhvyCTV2/I/IjJmpg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{566, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->255748878]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations with Reducible Nonconstant Parts", "Subsection",
 CellID->195660507],

Cell[TextData[{
 "If the sum of nonconstant terms in an equation factors, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the formula"
}], "Text",
 CellID->33520346],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"f", " ", "g"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"c", "\[DoubleLongLeftRightArrow]"}], 
     SubscriptBox["\[Or]", 
      RowBox[{"d", "|", "c"}]], "f"}], "=", 
    RowBox[{
     RowBox[{"d", "\[And]", "g"}], "=", 
     RowBox[{"c", "/", "d"}]}]}]}], TraditionalForm]], "DisplayMath",
 CellID->2785354],

Cell[TextData[{
 "to reduce the equation to a disjunction of pairs of equations with lower \
degrees. Note that this reduction depends on the ability to find all divisors \
of ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]], "InlineMath"],
 ", hence the correctness of the results depends on the correctness of the \
probabilistic primality test used by ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 "."
}], "Text",
 CellID->42757427],

Cell["\<\
This cubic equation reduces to 12 pairs of quadratic and linear equations.\
\>", "MathCaption",
 CellID->1659640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"2", " ", "y"}], "+", 
        RowBox[{"3", " ", "z"}]}], ")"}], " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"2", " ", "y"}], "+", 
        RowBox[{"3", " ", "z"}]}], ")"}], " ", "y", " ", "z"}]}], "\[Equal]", 
    "18"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->645836790],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "71"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "112"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "45"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "55"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "82"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "37"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "53"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "80"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "35"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "11"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}], "&&", 
    RowBox[{"z", "\[Equal]", "15"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "12"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "7"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}], "&&", 
    RowBox[{"z", "\[Equal]", "9"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "9"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "10"}], "&&", 
    RowBox[{"z", "\[Equal]", "9"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "3"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "6"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}], "&&", 
    RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "6"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "7"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "6"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "6"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "5"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "13"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "10"}]}], "&&", 
    RowBox[{"z", "\[Equal]", 
     RowBox[{"-", "17"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "34"}], "&&", 
    RowBox[{"y", "\[Equal]", "50"}], "&&", 
    RowBox[{"z", "\[Equal]", "23"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "38"}], "&&", 
    RowBox[{"y", "\[Equal]", "58"}], "&&", 
    RowBox[{"z", "\[Equal]", "25"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "83"}], "&&", 
    RowBox[{"y", "\[Equal]", "130"}], "&&", 
    RowBox[{"z", "\[Equal]", "53"}]}], ")"}]}]], "Output",
 ImageSize->{573, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->92666063]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equations with a Linear Variable", "Subsection",
 CellTags->"LinVarEqn",
 CellID->567820882],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to solve Diophantine systems of the form"
}], "Text",
 CellID->78817744],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}], "y"}], "+", 
      RowBox[{"g", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"]}], ")"}]}], "\[Equal]", "0"}], "\[And]", 
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellID->828446993],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"], ",", "y"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a conjunction of inequalities or ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", by reducing them to"
}], "Text",
 CellID->333706022],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", 
    RowBox[{
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}], "\[Equal]", "0"}], "\[And]", 
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"], ",", "y"}], ")"}]}], "\[Or]", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"g", "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}]}], "/", 
      RowBox[{"f", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"]}], ")"}]}]}], "\[And]", 
    RowBox[{
     RowBox[{"\[CapitalPhi]", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"], ",", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"g", "(", 
          RowBox[{
           SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
           SubscriptBox["x", "n"]}], ")"}]}], "/", 
        RowBox[{"f", "(", 
         RowBox[{
          SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
          SubscriptBox["x", "n"]}], ")"}]}]}], ")"}], "."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(3)"}]]}, {None, None}},
 CellTags->"LinVar",
 CellID->570075151],

Cell[TextData[{
 "The first part of the system (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") is solved using the method for solving ",
 ButtonBox["systems with more than one equation",
  BaseStyle->"Hyperlink",
  ButtonData->"ManyEqn"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " recognizes three cases when the second part of the system (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") is solvable. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Congruent]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ", the solution is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "\[Equal]", 
    RowBox[{"-", 
     RowBox[{"g", "(", 
      RowBox[{
       SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["x", "n"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 " and by the restrictions on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " obtained by solving the inequalities ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"], ",", 
     RowBox[{"-", 
      RowBox[{"g", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"]}], ")"}]}]}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ". Nonlinear systems of inequalities are solved using",
 " ",
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Congruent]", "m"}], 
   TraditionalForm]], "InlineMath"],
 " for an integer constant ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[GreaterEqual]", "2"}], TraditionalForm]], "InlineMath"],
 ", the solution of the second part of the system (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "\[Equal]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"g", "(", 
       RowBox[{
        SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["x", "n"]}], ")"}]}], "/", "m"}]}], TraditionalForm]], 
  "InlineMath"],
 " and by the restrictions on ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " obtained by solving the congruence ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Congruent]", 
    RowBox[{"0", " ", "mod", " ", "m"}]}], TraditionalForm]], "InlineMath"],
 " and then solving the inequalities ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"g", "(", 
        RowBox[{
         SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["x", "n"]}], ")"}]}], "/", "m"}]}], ")"}], 
   TraditionalForm]], "InlineMath"],
 " for each solution of the congruence. If ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is nonconstant, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can solve the second part of the system (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") if ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " factors all equations at the preprocessing stage, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    SubscriptBox["x", "1"], ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", 
    SubscriptBox["x", "1"], ")"}], TraditionalForm]], "InlineMath"],
 " can be assumed to be relatively prime. Then"
}], "Text",
 CellID->67122203],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"d", " ", 
    RowBox[{"g", "(", 
     SubscriptBox["x", "1"], ")"}]}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{"q", "(", 
      SubscriptBox["x", "1"], ")"}], 
     RowBox[{"f", "(", 
      SubscriptBox["x", "1"], ")"}]}], "+", 
    RowBox[{"r", "(", 
     SubscriptBox["x", "1"], ")"}]}]}], TraditionalForm]], "DisplayMath",
 CellID->556337108],

Cell[TextData[{
 "for an integer ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " and polynomials ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "(", 
    SubscriptBox["x", "1"], ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "(", 
    SubscriptBox["x", "1"], ")"}], TraditionalForm]], "InlineMath"],
 " with integer coefficients and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"deg", "(", "r", ")"}], "<", 
    RowBox[{"deg", "(", "f", ")"}]}], TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     RowBox[{"g", "(", 
      SubscriptBox["x", "1"], ")"}]}], "/", 
    RowBox[{"f", "(", 
     SubscriptBox["x", "1"], ")"}]}], TraditionalForm]], "InlineMath"],
 " is an integer, then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "(", 
     SubscriptBox["x", "1"], ")"}], "/", 
    RowBox[{"f", "(", 
     SubscriptBox["x", "1"], ")"}]}], TraditionalForm]], "InlineMath"],
 " is an integer, and so ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"r", "(", 
     SubscriptBox["x", "1"], ")"}], "\[Equal]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"|", 
    RowBox[{"r", "(", 
     SubscriptBox["x", "1"], ")"}], "|", 
    RowBox[{"\[GreaterEqual]", " ", 
     RowBox[{"|", 
      RowBox[{"f", "(", 
       SubscriptBox["x", "1"], ")"}], "|"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". Since ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"deg", "(", "r", ")"}], "<", 
    RowBox[{"deg", "(", "f", ")"}]}], TraditionalForm]], "InlineMath"],
 ", the last condition is satisfied only by a finite number of integers ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "1"], TraditionalForm]], "InlineMath"],
 ". Hence the solutions of the second part of the system (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") can be selected from a finite number of solution candidates. "
}], "Text",
 CellID->73112932],

Cell[TextData[{
 "Additionally, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the following heuristic to detect cases when the system (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") has no solutions. If there is an integer ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[GreaterEqual]", "2"}], TraditionalForm]], "InlineMath"],
 ", such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is always divisible by ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "(", 
    RowBox[{
     SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["x", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is never divisible by ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", then the system (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") has no solutions. Candidates for ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " are found by computing the ",
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " of the values of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " at several points."
}], "Text",
 CellID->569792802],

Cell[TextData[{
 "The last two methods use exhaustive search over finite sets of points. The \
allowed number of search points is controlled by the system option ",
 Cell[BoxData["SieveMaxPoints"], "InlineFormula"],
 ". "
}], "Text",
 CellID->26716957],

Cell[TextData[{
 "This reduces to (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Congruent]", "1"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->97526973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"7", " ", "x", " ", "y"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["y", "4"]}], "-", "z"}], "\[Equal]", "3"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"2", " ", "x"}], "-", "y"}], ">", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->413022944],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}], "|", 
     RowBox[{"C", "[", "3", "]"}], "|", 
     RowBox[{"C", "[", "4", "]"}], "|", 
     RowBox[{"C", "[", "5", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "2", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "3", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "4", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "5", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"1", "+", 
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "2", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "4", "]"}]}], "-", 
        RowBox[{"C", "[", "5", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "2", "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "4", "]"}]}], "-", 
        RowBox[{"C", "[", "5", "]"}]}]}]}], ")"}]}], ")"}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["x", "3"], "-", 
    RowBox[{"7", " ", "x", " ", "y"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "4"]}]}]}]}]], "Output",
 ImageSize->{570, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->410867118]
}, Open  ]],

Cell[TextData[{
 "This reduces to (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ") with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{
      SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["x", "n"]}], ")"}], "\[Congruent]", "3"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->214562981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"], " ", "y"}], "+", 
     RowBox[{"9", " ", "x", " ", 
      SuperscriptBox["y", "4"]}], "-", 
     RowBox[{"3", " ", "z"}]}], "\[Equal]", "8"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->25052500],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "2", "]"}]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", "+", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"3", " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], ")"}]}], ")"}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      SuperscriptBox["x", "3"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"9", " ", "x", " ", 
       SuperscriptBox["y", "4"]}]}], ")"}]}]}]}]], "Output",
 ImageSize->{436, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->262938559]
}, Open  ]],

Cell[TextData[{
 "This reduces to the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Equal]", "1"}], TraditionalForm]], "InlineMath"],
 " case of system (",
 ButtonBox["3",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVar"],
 ")."
}], "MathCaption",
 CellID->473173069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "5"], "+", 
     RowBox[{"7", " ", "x"}], "-", "271", "+", 
     RowBox[{"y", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "3"], "+", 
        RowBox[{"21", " ", 
         SuperscriptBox["x", "2"]}], "-", "17"}], ")"}]}]}], "\[Equal]", 
    "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->72008462],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "93"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}]}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->221635579]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " detects that the equation has no solutions, because ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"9", " ", 
     SuperscriptBox["x", "6"], " ", 
     SuperscriptBox["y", "3"], " ", 
     SuperscriptBox["z", "4"]}], "-", 
    RowBox[{"9", " ", 
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "3"], " ", 
     SuperscriptBox["z", "8"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "8"], " ", 
     SuperscriptBox["z", "9"]}], "-", "10"}], TraditionalForm]], 
  "InlineMath"],
 " is always divisible by 5, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"7", "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "4"], " ", "y", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["x", "8"], " ", 
     SuperscriptBox["y", "2"], " ", 
     SuperscriptBox["z", "4"]}], "-", 
    RowBox[{"9", " ", 
     SuperscriptBox["z", "8"]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "6"], " ", "y", " ", 
     SuperscriptBox["z", "8"]}]}], TraditionalForm]], "InlineMath"],
 " is never divisible by 5."
}], "MathCaption",
 CellID->1674974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"9", " ", 
         SuperscriptBox["x", "6"], " ", 
         SuperscriptBox["y", "3"], " ", 
         SuperscriptBox["z", "4"]}], "-", 
        RowBox[{"9", " ", 
         SuperscriptBox["x", "2"], " ", 
         SuperscriptBox["y", "3"], " ", 
         SuperscriptBox["z", "8"]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["y", "8"], " ", 
         SuperscriptBox["z", "9"]}], "-", "10"}], ")"}], " ", "t"}], "+", "7",
      "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["x", "4"], " ", "y", " ", 
      SuperscriptBox["z", "4"]}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["x", "8"], " ", 
      SuperscriptBox["y", "2"], " ", 
      SuperscriptBox["z", "4"]}], "-", 
     RowBox[{"9", " ", 
      SuperscriptBox["z", "8"]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["x", "6"], " ", "y", " ", 
      SuperscriptBox["z", "8"]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->3045174],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->617141957]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems with Empty or Bounded Real Solution Sets", "Subsection",
 CellID->114666200],

Cell[TextData[{
 "If a Diophantine polynomial system is not solved by any other methods, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " solves the system over the reals using the ",
 ButtonBox["Cylindrical Algebraic Decomposition",
  BaseStyle->"Hyperlink",
  ButtonData->{"RealReduceTutorial.nb", "CAD"}],
 " (CAD) algorithm. If the system has no real solutions, then clearly it has \
no integer solutions. If the real solution set is bounded, then the number of \
integer solutions is finite. In principle, all the integer solutions can be \
found in this case from a cylindrical decomposition. Namely, for each \
cylinder, you enumerate all possible integer values of the first coordinate, \
then for each value of the first coordinate, you enumerate all possible \
integer values of the second coordinate, and so on. However, for large \
bounded solution sets this method could lead to a huge number of points to \
try. Therefore, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a bound on the number of explicitly enumerated integer solutions in a \
real interval. By default this bound is equal to 10. It can be changed using \
the system option ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 ". For systems for which the real solution set is unbounded or bounded but \
large, the solution is represented implicitly by returning the CAD and a \
condition that all variables are integers. Note that for multivariate systems \
such an implicit representation may not even be enough to tell whether \
integer solutions exist. This should be expected, given Matiyasevich's \
solution of Hilbert's tenth problem [",
 ButtonBox["2",
  BaseStyle->"Hyperlink",
  ButtonData->"2"],
 "]."
}], "Text",
 CellID->402968579],

Cell[TextData[{
 "Here the real solution set is bounded, but ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " gives some cylinders in an implicit form. This is because some of the \
intervals bounding ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " contain more than 10 integers."
}], "MathCaption",
 CellID->52119230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "5"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "3"}], "-", 
      RowBox[{"x", " ", "y", " ", "z"}]}], "\[Equal]", "8"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "30"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->81669180],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"y", "|", "z"}], ")"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "2"}]}], "&&", 
      RowBox[{
       RowBox[{"-", "5"}], "\[LessEqual]", "y", "\[LessEqual]", "5"}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "40"}], "+", 
           SuperscriptBox["y", "2"], "+", 
           RowBox[{"2", " ", "y", " ", "#1"}], "+", 
           SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], ")"}], "||",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"-", "1"}]}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", "3"}]}], "&&", 
          RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", "3"}], "&&", 
          RowBox[{"z", "\[Equal]", "0"}]}], ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"-", "5"}], "\[LessEqual]", "y", "\[LessEqual]", "5"}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], "+", 
           SuperscriptBox["y", "2"], "+", 
           SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], ")"}], "||",
     
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "1"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", "5"}]}], "&&", 
          RowBox[{"z", "\[Equal]", 
           RowBox[{"-", "2"}]}]}], ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"-", "2"}]}], "&&", 
          RowBox[{"z", "\[Equal]", "1"}]}], ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", "1"}], "&&", 
          RowBox[{"z", "\[Equal]", "2"}]}], ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", "3"}], "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"z", "\[Equal]", 
             RowBox[{"-", "2"}]}], "||", 
            RowBox[{"z", "\[Equal]", "1"}]}], ")"}]}], ")"}]}], ")"}]}], 
     ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{"-", "5"}], "\[LessEqual]", "y", "\[LessEqual]", "5"}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"24", "+", 
           SuperscriptBox["y", "2"], "-", 
           RowBox[{"2", " ", "y", " ", "#1"}], "+", 
           SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], ")"}]}],
    ")"}]}]], "Output",
 ImageSize->{545, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->57676624]
}, Open  ]],

Cell[TextData[{
 "Increasing the value of the system option ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find all integer solutions explicitly."
}], "MathCaption",
 CellID->600418672],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DiscreteSolutionBound\>\"", "\[Rule]", "11"}], "}"}]}], 
   "]"}], ";"}], "\n", 
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "5"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "3"}], "-", 
      RowBox[{"x", " ", "y", " ", "z"}]}], "\[Equal]", "8"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "30"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]}], "Input",
 CellLabel->"In[42]:=",
 CellID->131720673],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{438, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->458118626]
}, Open  ]],

Cell[TextData[{
 "This resets ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->29221804],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DiscreteSolutionBound\>\"", "\[Rule]", "10"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->347996735],

Cell[TextData[{
 "Here ",
 ButtonBox["the modular sieve method",
  BaseStyle->"Hyperlink",
  ButtonData->"Sieve"],
 " shows that there are no solutions in ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "15"}], ",", "15"}], "]"}], "3"], TraditionalForm]], 
  "InlineMath"],
 ". After adding inequalities to eliminate this cube, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " then recognizes that this equation has no solutions anywhere."
}], "MathCaption",
 CellID->951443395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"9", " ", 
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"7", " ", 
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox["z", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["y", "2"], " ", 
      SuperscriptBox["z", "2"]}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "+", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->64337138],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->518725314]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Equations of the Form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"g", "(", 
       RowBox[{"x", ",", "y", ",", 
        SubscriptBox["z", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["z", "n"]}], ")"}]}], "+", "y"}], "\[Equal]", "c"}], 
   TraditionalForm]], "InlineMath"]
}], "Subsection",
 CellID->25443394],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to solve Diophantine systems of the form"
}], "Text",
 CellID->144361231],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"g", "(", 
        RowBox[{"x", ",", "y", ",", 
         SubscriptBox["z", "1"], ",", "\[Ellipsis]", ",", 
         SubscriptBox["z", "n"]}], ")"}]}], "+", "y"}], "\[Equal]", "c"}], 
    "\[And]", 
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{"x", ",", "y", ",", 
      SubscriptBox["z", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["z", "n"]}], ")"}]}], ","}], 
  TraditionalForm]], "DisplayMath",
 CellID->665977278],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[CapitalPhi]", "(", 
    RowBox[{"x", ",", "y", ",", 
     SubscriptBox["z", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["z", "n"]}], ")"}], TraditionalForm]], "InlineMath"],
 " is a conjunction of inequalities or ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", by transforming them to"
}], "Text",
 CellID->62396675],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "\[And]", 
    RowBox[{"y", "\[Equal]", "c"}], "\[And]", 
    RowBox[{"\[CapitalPhi]", "(", 
     RowBox[{"0", ",", "c", ",", 
      SubscriptBox["z", "1"], ",", "\[Ellipsis]", ",", 
      SubscriptBox["z", "n"]}], ")"}]}], "\[Or]", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"c", "+", 
      RowBox[{"t", " ", "x"}]}]}], "\[And]", 
    RowBox[{
     RowBox[{
      RowBox[{"g", "(", 
       RowBox[{"x", ",", 
        RowBox[{"c", "+", 
         RowBox[{"t", " ", "x"}]}], ",", 
        SubscriptBox["z", "1"], ",", "\[Ellipsis]", ",", 
        SubscriptBox["z", "n"]}], ")"}], "+", "t"}], "\[Equal]", "0"}], 
    "\[And]", 
    RowBox[{
     RowBox[{"\[CapitalPhi]", "(", 
      RowBox[{"x", ",", 
       RowBox[{"c", "+", 
        RowBox[{"t", " ", "x"}]}], ",", 
       SubscriptBox["z", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["z", "n"]}], ")"}], "."}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellFrameLabels->{{None, 
    Cell[
     TextData[{"(4)"}]]}, {None, None}},
 CellTags->"DivisibilityHeuristic",
 CellID->553913193],

Cell[TextData[{
 "The resulting system (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"DivisibilityHeuristic"],
 ") may, or may not, be easier to solve. Systems exist for which this \
transformation could be applied recursively arbitrarily many times; \
therefore, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses a recursion bound to ensure the heuristic terminates. "
}], "Text",
 CellID->378839699],

Cell[TextData[{
 "This transforms to a system (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"DivisibilityHeuristic"],
 ") with no real solutions."
}], "MathCaption",
 CellID->132044299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}], "+", "y", "+", 
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"x", " ", "z"}]}], "\[Equal]", "0"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"z", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[46]:=",
 CellID->130101853],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]=",
 CellID->438672421]
}, Open  ]],

Cell[TextData[{
 "Here the system (",
 ButtonBox["4",
  BaseStyle->"Hyperlink",
  ButtonData->"DivisibilityHeuristic"],
 ") obtained after three recursive transformations has a reducible \
nonconstant part."
}], "MathCaption",
 CellID->70005998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"2", " ", "x", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     RowBox[{"20", " ", "x", " ", "y"}], "+", "y"}], "\[Equal]", "5"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->22152510],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "7"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "12"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "5"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "7"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "2"}]}]}], ")"}]}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->183823068]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Systems Solvable by Exhaustive Search", "Subsection",
 CellTags->"ExhaustiveSearch",
 CellID->53756076],

Cell[TextData[{
 "For systems containing explicit lower and upper bounds on all variables, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses exhaustive search to find solutions. The bounds of the search are \
specified by the value of the system option ",
 Cell[BoxData["ExhaustiveSearchMaxPoints"], "InlineFormula"],
 ". The option value should be a pair of integers (the default is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1000", ",", "10000"}], "}"}], TraditionalForm]], "InlineMath"],
 "). If the number of integer points within the bounds does not exceed the \
first integer, the exhaustive search is used instead of any solution methods \
other than univariate polynomial solving. Otherwise, if the number of integer \
points within the bounds does not exceed the second integer, the exhaustive \
search is performed after all other methods fail."
}], "Text",
 CellID->1002419],

Cell["\<\
This transcendental Diophantine equation with bounded variable values is \
solved by exhaustive search.\
\>", "MathCaption",
 CellID->19998089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", "x", " ", "y"}], "2"], "]"}], "2"], "\[Equal]", 
     
     RowBox[{"Gamma", "[", 
      RowBox[{
       RowBox[{"21", " ", "x"}], "-", 
       RowBox[{"37", " ", "y"}]}], "]"}]}], "&&", 
    RowBox[{"0", "<", "x", "<", "100"}], "&&", 
    RowBox[{"1", "\[LessEqual]", "y", "\[LessEqual]", "100"}]}], ",", "x", 
   ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->118182320],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "13"}], "&&", 
    RowBox[{"x", "\[Equal]", "23"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", "55"}], "&&", 
    RowBox[{"x", "\[Equal]", "97"}]}], ")"}]}]], "Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->322514149]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options", "Section",
 CellID->623839255],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions for solving Diophantine polynomial systems have a number of \
options that control the way they operate. This tutorial gives a summary of \
these options."
}], "Text",
 CellID->56121441],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["GeneratedParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GeneratedParameters"], "C", Cell["\<\
specifies how the new parameters generated to represent solutions should be \
named\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->386408775],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " options affecting the behavior for Diophantine polynomial systems."
}], "Caption",
 CellID->250020308],

Cell[CellGroupData[{

Cell["GeneratedParameters", "Subsection",
 CellID->515843223],

Cell[TextData[{
 "To represent infinite solutions of some Diophantine systems, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " needs to introduce new integer parameters. The names of the new parameters \
are specified by the option ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", the new parameters are named ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 "."
}], "Text",
 CellID->455961191],

Cell[TextData[{
 "By default, the new parameters generated by ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " are named ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "1", "]"}], ",", 
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", "2", "]"}], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->619300757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{"x", ">", 
     RowBox[{"y", "+", "1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->558321853],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}], "|", 
     RowBox[{"C", "[", "3", "]"}], "|", 
     RowBox[{"C", "[", "4", "]"}], "|", 
     RowBox[{"C", "[", "5", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "2", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "3", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "4", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "5", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"1", "+", 
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"C", "[", "1", "]"}], "-", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}], "-", 
        RowBox[{"C", "[", "5", "]"}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{"2", "-", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "1", "]"}]}], "-", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "4", "]"}]}], "+", 
        RowBox[{"C", "[", "5", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", "+", 
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "-", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}], "-", 
        RowBox[{"C", "[", "5", "]"}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "-", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "4", "]"}]}], "+", 
        RowBox[{"C", "[", "5", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"C", "[", "1", "]"}], "-", 
        RowBox[{"C", "[", "3", "]"}], "-", 
        RowBox[{"C", "[", "4", "]"}], "-", 
        RowBox[{"C", "[", "5", "]"}]}]}], "&&", 
      RowBox[{"z", "\[Equal]", 
       RowBox[{"4", "-", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "1", "]"}]}], "-", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "4", "]"}]}], "+", 
        RowBox[{"C", "[", "5", "]"}]}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{498, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->579927017]
}, Open  ]],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " allows users to customize the parameter names."
}], "MathCaption",
 CellID->3757467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", "y", "+", "z"}], "\[Equal]", "2"}], "&&", 
    RowBox[{"x", ">", 
     RowBox[{"y", "+", "1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"k", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->855882666],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{507, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->328493184]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReduceOptions Group of System Options", "Subsection",
 CellID->226945663],

Cell[TextData[{
 "Here are the system options from the ",
 Cell[BoxData["ReduceOptions"], "InlineFormula"],
 " group that may affect the behavior of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " for Diophantine polynomial systems. The options can be set with"
}], "Text",
 CellID->178502180],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetSystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSystemOptions"], "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"option\", \"TI\"]\)\!\(\*
StyleBox[\" \", \"TI\"]\)\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "->", 
      StyleBox["value", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 StyleBox[".", "Text"]
}], "Program",
 CellID->41981489],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {"\"\<BranchLinearDiophantine\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether ",
     Cell[BoxData[
      ButtonBox["Reduce",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
     " should use a branch-and-bound type algorithm to compute solutions of \
bounded systems of linear Diophantine inequalities"
    }], "TableText"]},
   {"\"\<DiscreteSolutionBound\>\"", "10", Cell["\<\
the bound on the number of explicitly enumerated integer solutions in a real \
interval\
\>", "TableText"]},
   {"\"\<ExhaustiveSearchMaxPoints\>\"", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "10000"}], "}"}], Cell["\<\
the maximal number of integer points within variable bounds for which the \
exhaustive search is used before and after all other solution methods\
\>", "TableText"]},
   {"\"\<LatticeReduceDiophantine\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether ",
     Cell[BoxData[
      ButtonBox["LatticeReduce",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
     " should be used to preprocess bounded systems of linear Diophantine \
inequalities"
    }], "TableText"]},
   {"\"\<MaxFrobeniusGraph\>\"", "1000000", Cell[TextData[{
     "the maximal size of the smallest coefficient in a Frobenius equation \
for which ",
     Cell[BoxData[
      ButtonBox["FindInstance",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
     " computes the critical tree in the Frobenius graph"
    }], "TableText"]},
   {"\"\<SieveMaxPoints\>\"", "10000", Cell["\<\
the maximal number of points at which the modular sieve method evaluates the \
system\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellID->97607950],

Cell[TextData[{
 Cell[BoxData["ReduceOptions"], "InlineFormula"],
 " group options affecting the behavior of ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " for Diophantine polynomial systems."
}], "Caption",
 CellID->244061410],

Cell[CellGroupData[{

Cell["BranchLinearDiophantine", "Subsubsection",
 CellTags->"BranchLinearDiophantine",
 CellID->210244652],

Cell[TextData[{
 "The value of the system option ",
 Cell[BoxData["BranchLinearDiophantine"], "InlineFormula"],
 " specifies which variant of the algorithm should be used in ",
 ButtonBox["the final stage of solving bounded linear systems",
  BaseStyle->"Hyperlink",
  ButtonData->"PolyhedronIntegerPoints"],
 ". Neither variant seems to be clearly better. For some examples the hybrid \
method combining a branch-and-bound type algorithm and a simple recursive \
enumeration is faster; for other examples the simple recursive enumeration \
alone is faster. The hybrid method seems to be more robust for badly \
conditioned problems, hence it is the default method."
}], "Text",
 CellID->272817929],

Cell["\<\
This finds integer points in a long, narrow four-dimensional simplex using \
the default hybrid method.\
\>", "MathCaption",
 CellID->76836355],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "10000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "x"}], "+", 
        RowBox[{"a", " ", "y"}], "+", 
        RowBox[{"a", " ", "z"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], " ", "t"}]}], "\[LessEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "x"}], "+", 
        RowBox[{"a", " ", "y"}], "+", 
        RowBox[{"a", " ", "t"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], " ", "z"}]}], "\[LessEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "x"}], "+", 
        RowBox[{"a", " ", "z"}], "+", 
        RowBox[{"a", " ", "t"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], " ", "y"}]}], "\[LessEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "y"}], "+", 
        RowBox[{"a", " ", "z"}], "+", 
        RowBox[{"a", " ", "t"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], " ", "x"}]}], "\[LessEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{
       RowBox[{"x", "+", "y", "+", "z", "+", "t"}], "\[GreaterEqual]", "1"}], 
      "&&", 
      RowBox[{"x", "<", "y"}], "&&", 
      RowBox[{"z", "<", "t"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Integers"}], 
    "]"}], "//", "Length"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[51]:=",
 CellID->184206951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6710000000000019`", ",", "3336"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->365383897]
}, Open  ]],

Cell[TextData[{
 "This sets the value of the system option ",
 Cell[BoxData["BranchLinearDiophantine"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->158103086],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<BranchLinearDiophantine\>\"", "\[Rule]", "False"}], "}"}]}],
    "]"}], ";"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->156762942],

Cell["\<\
Here the simple recursive enumeration method is used, and for this badly \
conditioned problem it is several times slower. \
\>", "MathCaption",
 CellID->46009676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "x"}], "+", 
        RowBox[{"a", " ", "y"}], "+", 
        RowBox[{"a", " ", "z"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], " ", "t"}]}], "\[LessEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "x"}], "+", 
        RowBox[{"a", " ", "y"}], "+", 
        RowBox[{"a", " ", "t"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], " ", "z"}]}], "\[LessEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "x"}], "+", 
        RowBox[{"a", " ", "z"}], "+", 
        RowBox[{"a", " ", "t"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], " ", "y"}]}], "\[LessEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"a", " ", "y"}], "+", 
        RowBox[{"a", " ", "z"}], "+", 
        RowBox[{"a", " ", "t"}], "-", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{"a", "-", "1"}], ")"}], " ", "x"}]}], "\[LessEqual]", 
       RowBox[{"3", " ", "a"}]}], "&&", 
      RowBox[{
       RowBox[{"x", "+", "y", "+", "z", "+", "t"}], "\[GreaterEqual]", "1"}], 
      "&&", 
      RowBox[{"x", "<", "y"}], "&&", 
      RowBox[{"z", "<", "t"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", "Integers"}], 
    "]"}], "//", "Length"}], "//", "Timing"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->813755251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.4470000000000045`", ",", "3336"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->62385160]
}, Open  ]],

Cell[TextData[{
 "This resets the value of the system option ",
 Cell[BoxData["BranchLinearDiophantine"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->280144831],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<BranchLinearDiophantine\>\"", "\[Rule]", "True"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[55]:=",
 CellID->275242839],

Cell[TextData[{
 "Here are solutions of a system of two randomly generated equations ",
 Cell[BoxData[
  FormBox[
   StyleBox["eqns",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " and three randomly generated inequalities ",
 Cell[BoxData[
  FormBox[
   StyleBox["ineqs",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " in seven variables inside a simplex bounded by ",
 Cell[BoxData[
  FormBox[
   StyleBox["bds",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->8676016],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"x", "/@", 
    RowBox[{"Range", "[", "7", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"And", "@@", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"A", ".", "X"}], "\[Equal]", "a"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ineqs", "=", 
   RowBox[{"And", "@@", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"B", ".", "X"}], "\[GreaterEqual]", "b"}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bds", "=", 
   RowBox[{
    RowBox[{"And", "@@", 
     RowBox[{"Thread", "[", 
      RowBox[{"X", "\[GreaterEqual]", "0"}], "]"}]}], "&&", 
    RowBox[{
     RowBox[{"Total", "[", "X", "]"}], "\[LessEqual]", "100"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"eqns", "&&", "ineqs", "&&", "bds"}], ",", "X", ",", "Integers"}],
    "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[56]:=",
 CellID->26032968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.319999999999994`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Equal]", "9"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Equal]", "8"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Equal]", "14"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Equal]", "20"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Equal]", "22"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Equal]", "13"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Equal]", "12"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Equal]", "15"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Equal]", "12"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Equal]", "11"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Equal]", "22"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Equal]", "18"}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{563, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[64]=",
 CellID->236059578]
}, Open  ]],

Cell["\<\
For this system the nondefault simple recursion method is faster.\
\>", "MathCaption",
 CellID->153486163],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<BranchLinearDiophantine\>\"", "\[Rule]", "False"}], "}"}]}],
    "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"eqns", "&&", "ineqs", "&&", "bds"}], ",", "X", ",", "Integers"}],
    "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[65]:=",
 CellID->347114198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.6429999999999958`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Equal]", "9"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Equal]", "8"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Equal]", "14"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Equal]", "20"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Equal]", "22"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Equal]", "13"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Equal]", "12"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Equal]", "15"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Equal]", "12"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Equal]", "11"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Equal]", "22"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Equal]", "18"}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{563, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[66]=",
 CellID->606836779]
}, Open  ]],

Cell[TextData[{
 "Here is a random system very similar to the previous one, except that it \
contains one more variable and the right-hand side of the last of ",
 Cell[BoxData[
  FormBox[
   StyleBox["bds",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 " is changed from ",
 Cell[BoxData["100"], "InlineFormula"],
 " to ",
 Cell[BoxData["200."], "InlineFormula"],
 " However, for this system the default method is faster."
}], "MathCaption",
 CellID->935352015],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<BranchLinearDiophantine\>\"", "\[Rule]", "True"}], "}"}]}], 
   "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "8", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "8", "}"}]}], "]"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"x", "/@", 
    RowBox[{"Range", "[", "8", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"And", "@@", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"A", ".", "X"}], "\[Equal]", "a"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ineqs", "=", 
   RowBox[{"And", "@@", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"B", ".", "X"}], "\[GreaterEqual]", "b"}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bds", "=", 
   RowBox[{
    RowBox[{"And", "@@", 
     RowBox[{"Thread", "[", 
      RowBox[{"X", "\[GreaterEqual]", "0"}], "]"}]}], "&&", 
    RowBox[{
     RowBox[{"Total", "[", "X", "]"}], "\[LessEqual]", "200"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"eqns", "&&", "ineqs", "&&", "bds"}], ",", "X", ",", "Integers"}],
    "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[67]:=",
 CellID->54773922],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16.093`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Equal]", "6"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Equal]", "27"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Equal]", "35"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Equal]", "6"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "8", "]"}], "\[Equal]", "38"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Equal]", "10"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Equal]", "48"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Equal]", "54"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "8", "]"}], "\[Equal]", "55"}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{531, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[76]=",
 CellID->369465]
}, Open  ]],

Cell["The nondefault method is slower for this system.", "MathCaption",
 CellID->415724669],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<BranchLinearDiophantine\>\"", "\[Rule]", "False"}], "}"}]}],
    "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{"eqns", "&&", "ineqs", "&&", "bds"}], ",", "X", ",", "Integers"}],
    "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[77]:=",
 CellID->168220324],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"47.788999999999994`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Equal]", "6"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Equal]", "27"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Equal]", "35"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Equal]", "6"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Equal]", "0"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "8", "]"}], "\[Equal]", "38"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Equal]", "10"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Equal]", "48"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Equal]", "54"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Equal]", "1"}], "&&", 
      RowBox[{
       RowBox[{"x", "[", "8", "]"}], "\[Equal]", "55"}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{531, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[78]=",
 CellID->137349453]
}, Open  ]],

Cell[TextData[{
 "This resets the value of the system option ",
 Cell[BoxData["BranchLinearDiophantine"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->161232824],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<BranchLinearDiophantine\>\"", "\[Rule]", "True"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[79]:=",
 CellID->1530487]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiscreteSolutionBound", "Subsubsection",
 CellTags->"DiscreteSolutionBound",
 CellID->251741464],

Cell[TextData[{
 "The value of the system option ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 " specifies whether integer solutions in a real interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[LessEqual]", "x", "\[LessEqual]", "b"}], TraditionalForm]],
   "InlineMath"],
 " should be enumerated explicitly or represented implicitly as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", 
    RowBox[{"a", "\[LessEqual]", "x", "\[LessEqual]", "b"}]}], 
   TraditionalForm]], "InlineMath"],
 ". With ",
 Cell[BoxData[
  RowBox[{"DiscreteSolutionBound", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ", the integer solutions in the given real interval are enumerated \
explicitly if their number does not exceed ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". The default value of the option is 10. "
}], "Text",
 CellID->116102929],

Cell[TextData[{
 "There are 10 integers in the real interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "x", "<", "10"}], TraditionalForm]], 
  "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " writes them out explicitly. "
}], "MathCaption",
 CellID->532458365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", 
    SuperscriptBox["x", "3"], "<", "1000"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[80]:=",
 CellID->2562060],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "0"}], "||", 
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", "2"}], "||", 
  RowBox[{"x", "\[Equal]", "3"}], "||", 
  RowBox[{"x", "\[Equal]", "4"}], "||", 
  RowBox[{"x", "\[Equal]", "5"}], "||", 
  RowBox[{"x", "\[Equal]", "6"}], "||", 
  RowBox[{"x", "\[Equal]", "7"}], "||", 
  RowBox[{"x", "\[Equal]", "8"}], "||", 
  RowBox[{"x", "\[Equal]", "9"}]}]], "Output",
 ImageSize->{491, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[80]=",
 CellID->33859634]
}, Open  ]],

Cell[TextData[{
 "There are 11 integers in the real interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "x", "<", 
    SuperscriptBox["1001", 
     RowBox[{"1", "/", "3"}]]}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " represents them implicitly."
}], "MathCaption",
 CellID->410099897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", 
    SuperscriptBox["x", "3"], "<", "1001"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[81]:=",
 CellID->107995296],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Element]", "Integers"}], "&&", 
  RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", "10"}]}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[81]=",
 CellID->401396736]
}, Open  ]],

Cell[TextData[{
 "This increases the ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 " to 11."
}], "MathCaption",
 CellID->38584246],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DiscreteSolutionBound\>\"", "\[Rule]", "11"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[82]:=",
 CellID->256742475],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " represents the solutions explicitly."
}], "MathCaption",
 CellID->126391429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"0", "\[LessEqual]", 
    SuperscriptBox["x", "3"], "<", "1001"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[83]:=",
 CellID->179537443],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "0"}], "||", 
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", "2"}], "||", 
  RowBox[{"x", "\[Equal]", "3"}], "||", 
  RowBox[{"x", "\[Equal]", "4"}], "||", 
  RowBox[{"x", "\[Equal]", "5"}], "||", 
  RowBox[{"x", "\[Equal]", "6"}], "||", 
  RowBox[{"x", "\[Equal]", "7"}], "||", 
  RowBox[{"x", "\[Equal]", "8"}], "||", 
  RowBox[{"x", "\[Equal]", "9"}], "||", 
  RowBox[{"x", "\[Equal]", "10"}]}]], "Output",
 ImageSize->{549, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[83]=",
 CellID->212508641]
}, Open  ]],

Cell[TextData[{
 "This resets ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->137416699],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<DiscreteSolutionBound\>\"", "\[Rule]", "10"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[84]:=",
 CellID->215389923],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["DiscreteSolutionBound"], "InlineFormula"],
 " also affects ",
 ButtonBox["the solving of bounded linear systems",
  BaseStyle->"Hyperlink",
  ButtonData->"BoundedSolutionLimits"],
 "."
}], "Text",
 CellID->318020393]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExhaustiveSearchMaxPoints", "Subsubsection",
 CellTags->"ExhaustiveSearchMaxPoints",
 CellID->522087212],

Cell[TextData[{
 "The system option ",
 Cell[BoxData["ExhaustiveSearchMaxPoints"], "InlineFormula"],
 " specifies the maximal number of search points used by ",
 ButtonBox["the exhaustive search method",
  BaseStyle->"Hyperlink",
  ButtonData->"ExhaustiveSearch"],
 ". The option value should be a pair of integers (the default is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1000", ",", "10000"}], "}"}], TraditionalForm]], "InlineMath"],
 "). If the number of integer points within the bounds does not exceed the \
first integer, the exhaustive search is used instead of any solution methods \
other than univariate polynomial solving. Otherwise, if the number of integer \
points within the bounds does not exceed the second integer, the exhaustive \
search is performed after all other methods fail."
}], "Text",
 CellID->265392510],

Cell[TextData[{
 "With the default setting of ",
 Cell[BoxData["ExhaustiveSearchMaxPoints"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " is unable to solve this equation."
}], "MathCaption",
 CellID->323752078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
     RowBox[{"Gamma", "[", 
      RowBox[{"x", "+", "y"}], "]"}]}], "&&", 
    RowBox[{"1", "\[LessEqual]", "x", "\[LessEqual]", "200"}], "&&", 
    RowBox[{"1", "\[LessEqual]", "y", "\[LessEqual]", "200"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[85]:=",
 CellID->697229188],

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "::", "\<\"nsmet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"This system cannot be solved with \
the methods available to Reduce.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/Reduce\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[85]:=",
 CellID->112068535],

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
     RowBox[{"Gamma", "[", 
      RowBox[{"x", "+", "y"}], "]"}]}], "&&", 
    RowBox[{"1", "\[LessEqual]", "x", "\[LessEqual]", "200"}], "&&", 
    RowBox[{"1", "\[LessEqual]", "y", "\[LessEqual]", "200"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Output",
 ImageSize->{531, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[85]=",
 CellID->111353086]
}, Open  ]],

Cell[TextData[{
 "This increases the value of the second element of ",
 Cell[BoxData["ExhaustiveSearchMaxPoints"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox["100000", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->34036973],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ExhaustiveSearchMaxPoints\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "100000"}], "}"}]}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[86]:=",
 CellID->31570790],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can solve the equation."
}], "MathCaption",
 CellID->594974318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", 
     RowBox[{"Gamma", "[", 
      RowBox[{"x", "+", "y"}], "]"}]}], "&&", 
    RowBox[{"1", "\[LessEqual]", "x", "\[LessEqual]", "200"}], "&&", 
    RowBox[{"1", "\[LessEqual]", "y", "\[LessEqual]", "200"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[87]:=",
 CellID->14719304],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[87]=",
 CellID->351851860]
}, Open  ]],

Cell[TextData[{
 "With the default setting of ",
 Cell[BoxData["ExhaustiveSearchMaxPoints"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " solves this equation using the method for solving Pell equations."
}], "MathCaption",
 CellID->127505266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ExhaustiveSearchMaxPoints\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "10000"}], "}"}]}], "}"}]}], "]"}], ";", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{"1", "\[LessEqual]", "x", "\[LessEqual]", "1000"}], "&&", 
      RowBox[{"1", "\[LessEqual]", "y", "\[LessEqual]", "1000"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
   "Timing"}]}]], "Input",
 CellLabel->"In[88]:=",
 CellID->121435139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.05999999999999997`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "3"}], "&&", 
      RowBox[{"y", "\[Equal]", "2"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "17"}], "&&", 
      RowBox[{"y", "\[Equal]", "12"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "99"}], "&&", 
      RowBox[{"y", "\[Equal]", "70"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "577"}], "&&", 
      RowBox[{"y", "\[Equal]", "408"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{555, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[88]=",
 CellID->350192174]
}, Open  ]],

Cell[TextData[{
 "Increasing the first element of ",
 Cell[BoxData["ExhaustiveSearchMaxPoints"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "6"], TraditionalForm]], "InlineMath"],
 " makes ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " use the exhaustive search first. In this example the search is much slower \
than the Pell equation solver."
}], "MathCaption",
 CellID->312691978],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ExhaustiveSearchMaxPoints\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox["10", "6"], ",", 
        SuperscriptBox["10", "6"]}], "}"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{"1", "\[LessEqual]", "x", "\[LessEqual]", "1000"}], "&&", 
     RowBox[{"1", "\[LessEqual]", "y", "\[LessEqual]", "1000"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[89]:=",
 CellID->125977054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.538000000000006`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "3"}], "&&", 
      RowBox[{"y", "\[Equal]", "2"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "17"}], "&&", 
      RowBox[{"y", "\[Equal]", "12"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "99"}], "&&", 
      RowBox[{"y", "\[Equal]", "70"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "577"}], "&&", 
      RowBox[{"y", "\[Equal]", "408"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{562, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[90]=",
 CellID->93364369]
}, Open  ]],

Cell["\<\
For this equation the Pell equation solver is slower than the exhaustive \
search.\
\>", "MathCaption",
 CellID->32904670],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ExhaustiveSearchMaxPoints\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "10000"}], "}"}]}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       RowBox[{"21", " ", 
        SuperscriptBox["y", "2"]}]}], "\[Equal]", "2004"}], "&&", 
     RowBox[{"1", "\[LessEqual]", "x", "\[LessEqual]", "100"}], "&&", 
     RowBox[{"1", "\[LessEqual]", "y", "\[LessEqual]", "100"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[91]:=",
 CellID->47013539],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3809999999999972`", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "45"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}]}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[92]=",
 CellID->222723506]
}, Open  ]],

Cell["The exhaustive search is faster here.", "MathCaption",
 CellID->1134239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ExhaustiveSearchMaxPoints\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"10000", ",", "10000"}], "}"}]}], "}"}]}], "]"}], ";", 
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        RowBox[{"21", " ", 
         SuperscriptBox["y", "2"]}]}], "\[Equal]", "2004"}], "&&", 
      RowBox[{"1", "\[LessEqual]", "x", "\[LessEqual]", "100"}], "&&", 
      RowBox[{"1", "\[LessEqual]", "y", "\[LessEqual]", "100"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
   "Timing"}]}]], "Input",
 CellLabel->"In[93]:=",
 CellID->362688604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.12000000000000816`", ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "45"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}]}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[93]=",
 CellID->160177472]
}, Open  ]],

Cell[TextData[{
 "This resets ",
 Cell[BoxData["ExhaustiveSearchMaxPoints"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->466500556],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ExhaustiveSearchMaxPoints\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1000", ",", "10000"}], "}"}]}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[94]:=",
 CellID->507660]
}, Open  ]],

Cell[CellGroupData[{

Cell["LatticeReduceDiophantine", "Subsubsection",
 CellTags->"LatticeReduceDiophantine",
 CellID->224006136],

Cell[TextData[{
 "The value of the system option ",
 Cell[BoxData["LatticeReduceDiophantine"], "InlineFormula"],
 " specifies whether ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " should be used to preprocess ",
 ButtonBox["systems of bounded linear inequalities",
  BaseStyle->"Hyperlink",
  ButtonData->"BoundedLinearSystems"],
 ". The use of ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " is important for systems of inequalities describing polyhedra whose \
projections on some nonaxial lines are much smaller than their projections on \
the axes. However, there are systems for which ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 ", instead of simplifying the problem, makes it significantly harder."
}], "Text",
 CellID->8910548],

Cell[TextData[{
 "This finds the only two integer points in a triangle whose projections on \
both axes have sizes greater than ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " but whose projection on the line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"5000", "y"}]}], "\[Equal]", "0"}], TraditionalForm]], 
  "InlineMath"],
 " has size one."
}], "MathCaption",
 CellID->31049335],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   SuperscriptBox["10", "4"]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "x"}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "1"}], ")"}], " ", "y"}]}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "1"}], ")"}], " ", "x"}], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "2"}], ")"}], " ", "y"}]}], "&&", 
     RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", 
      RowBox[{"a", "+", "1"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
  "Timing"}]}], "Input",
 CellLabel->"In[95]:=",
 CellID->364437364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "0"}], "&&", 
      RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "10001"}], "&&", 
      RowBox[{"y", "\[Equal]", "10000"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[96]=",
 CellID->458440706]
}, Open  ]],

Cell[TextData[{
 "This sets the value of the system option ",
 Cell[BoxData["LatticeReduceDiophantine"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->46907727],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<LatticeReduceDiophantine\>\"", "\[Rule]", "False"}], 
     "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[97]:=",
 CellID->212854556],

Cell[TextData[{
 "The nondefault method is much slower for this system, and the speed \
difference grows with ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->24002584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", "x"}], "\[LessEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "1"}], ")"}], " ", "y"}]}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "1"}], ")"}], " ", "x"}], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "2"}], ")"}], " ", "y"}]}], "&&", 
     RowBox[{"0", "\[LessEqual]", "x", "\[LessEqual]", 
      RowBox[{"a", "+", "1"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[98]:=",
 CellID->371731154],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.875000000000005`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "0"}], "&&", 
      RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", "10001"}], "&&", 
      RowBox[{"y", "\[Equal]", "10000"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[98]=",
 CellID->69339472]
}, Open  ]],

Cell[TextData[{
 "Here is a system that contains a set of simple inequalities ",
 Cell[BoxData[
  FormBox[
   StyleBox["bds",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 StyleBox[",",
  FontSlant->"Italic"],
 " which bound solutions to a reasonably small size polyhedron, combined with \
a set of relatively complicated inequalities ",
 Cell[BoxData[
  FormBox[
   StyleBox["ineqs",
    FontSlant->"Italic"], TraditionalForm]], "InlineMath"],
 ". For such systems, using ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " tends to increase the timing."
}], "MathCaption",
 CellID->273907597],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<LatticeReduceDiophantine\>\"", "\[Rule]", "True"}], "}"}]}],
    "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1000"}], ",", "1000"}], "}"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"x", "/@", 
    RowBox[{"Range", "[", "5", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ineqs", "=", 
   RowBox[{"And", "@@", 
    RowBox[{"Thread", "[", 
     RowBox[{
      RowBox[{"B", ".", "X"}], "\[GreaterEqual]", "b"}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"bds", "=", 
   RowBox[{
    RowBox[{"And", "@@", 
     RowBox[{"Thread", "[", 
      RowBox[{"X", "\[GreaterEqual]", "0"}], "]"}]}], "&&", 
    RowBox[{
     RowBox[{"Total", "[", "X", "]"}], "\[LessEqual]", "10"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"ineqs", "&&", "bds"}], ",", "X", ",", "Integers"}], "]"}], "//",
    "Length"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[99]:=",
 CellID->294619746],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.7730000000000055`", ",", "35"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[105]=",
 CellID->328925421]
}, Open  ]],

Cell["The nondefault method is faster for this system.", "MathCaption",
 CellID->39496738],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<LatticeReduceDiophantine\>\"", "\[Rule]", "False"}], 
     "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Reduce", "[", 
    RowBox[{
     RowBox[{"ineqs", "&&", "bds"}], ",", "X", ",", "Integers"}], "]"}], "//",
    "Length"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[106]:=",
 CellID->497078689],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0900000000000023`", ",", "35"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[107]=",
 CellID->9661441]
}, Open  ]],

Cell[TextData[{
 "This resets ",
 Cell[BoxData["LatticeReduceDiophantine"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->473910087],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<LatticeReduceDiophantine\>\"", "\[Rule]", "True"}], "}"}]}],
    "]"}], ";"}]], "Input",
 CellLabel->"In[108]:=",
 CellID->673711290]
}, Open  ]],

Cell[CellGroupData[{

Cell["MaxFrobeniusGraph", "Subsubsection",
 CellTags->"MaxFrobeniusGraph",
 CellID->219054329],

Cell[TextData[{
 "The system option ",
 Cell[BoxData["MaxFrobeniusGraph"], "InlineFormula"],
 " specifies the maximal size of the smallest coefficient in a ",
 ButtonBox["Frobenius equation",
  BaseStyle->"Hyperlink",
  ButtonData->"Frobenius"],
 " for which ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " uses an algorithm based on the computation of the critical tree in the \
Frobenius graph [",
 ButtonBox["11",
  BaseStyle->"Hyperlink",
  ButtonData->"11"],
 "]. Otherwise, the more general ",
 ButtonBox["methods for solving bounded linear systems",
  BaseStyle->"Hyperlink",
  ButtonData->"BoundedLinearSystems"],
 " are used. Unlike the general method for solving bounded linear systems, \
the method based on the computation of the Frobenius graph depends very \
little on the number of variables, hence it is the faster choice for \
equations with many variables. On the other hand, the method requires storing \
a graph of the size of the smallest coefficient, so for large coefficients it \
may run out of memory."
}], "Text",
 CellID->61907656],

Cell[TextData[{
 "To find a solution of a Frobenius equation with the smallest coefficient \
larger than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "6"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " by default uses the general method for solving bounded linear systems. For \
this example the method is relatively slow but uses little memory. The kernel \
has been restarted to show the memory usage by the current example."
}], "MathCaption",
 CellID->144101505],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "1", "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"5", " ", 
         SuperscriptBox["10", "6"]}], ",", 
        SuperscriptBox["10", "7"]}], "}"}], "]"}], ",", 
     RowBox[{"{", "25", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"x", "/@", 
    RowBox[{"Range", "[", "25", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"A", ".", "X"}], "\[Equal]", "123456789"}], "&&", 
     RowBox[{"And", "@@", 
      RowBox[{"Thread", "[", 
       RowBox[{"X", "\[GreaterEqual]", "0"}], "]"}]}]}], ",", "X", ",", 
    "Integers"}], "]"}], "//", "Timing"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->445335518],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"42.952`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "8", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "9", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "10", "]"}], "\[Rule]", "7"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "11", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "12", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "13", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "14", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "15", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "16", "]"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "17", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "18", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "19", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "20", "]"}], "\[Rule]", "3"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "21", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "22", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "23", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "24", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "25", "]"}], "\[Rule]", "0"}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{485, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->127955357]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaxMemoryUsed", "[", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->436879321],

Cell[BoxData["10288400"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->459289209]
}, Open  ]],

Cell[TextData[{
 "This increases the value of ",
 Cell[BoxData["MaxFrobeniusGraph"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "7"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->179878890],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MaxFrobeniusGraph\>\"", "\[Rule]", 
      SuperscriptBox["10", "7"]}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->43113712],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " uses the method based on the computation of the Frobenius graph. It finds \
the solution faster, but it uses more memory."
}], "MathCaption",
 CellID->391323379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"A", ".", "X"}], "\[Equal]", "123456789"}], "&&", 
     RowBox[{"And", "@@", 
      RowBox[{"Thread", "[", 
       RowBox[{"X", "\[GreaterEqual]", "0"}], "]"}]}]}], ",", "X", ",", 
    "Integers"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->191183626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.213`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Rule]", "14"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "8", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "9", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "10", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "11", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "12", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "13", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "14", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "15", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "16", "]"}], "\[Rule]", "2"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "17", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "18", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "19", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "20", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "21", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "22", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "23", "]"}], "\[Rule]", "1"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "24", "]"}], "\[Rule]", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "25", "]"}], "\[Rule]", "0"}]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{485, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->217515046]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaxMemoryUsed", "[", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->656541300],

Cell[BoxData["77722760"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->137154084]
}, Open  ]],

Cell[TextData[{
 "This resets ",
 Cell[BoxData["MaxFrobeniusGraph"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->9695292],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<MaxFrobeniusGraph\>\"", "\[Rule]", 
      SuperscriptBox["10", "6"]}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->166922865]
}, Open  ]],

Cell[CellGroupData[{

Cell["SieveMaxPoints", "Subsubsection",
 CellTags->"SieveMaxPoints",
 CellID->307047228],

Cell[TextData[{
 "The system option ",
 Cell[BoxData["SieveMaxPoints"], "InlineFormula"],
 " specifies the maximal number of search points used by ",
 ButtonBox["the modular sieve method",
  BaseStyle->"Hyperlink",
  ButtonData->"Sieve"],
 " and by searches used in ",
 ButtonBox["solving equations with a linear variable",
  BaseStyle->"Hyperlink",
  ButtonData->"LinVarEqn"],
 ". The default value of the option is 10,000."
}], "Text",
 CellID->13883425],

Cell[TextData[{
 "With the default setting of ",
 Cell[BoxData["SieveMaxPoints"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " is unable to find a solution for this equation."
}], "MathCaption",
 CellID->96205051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox["y", "3"]}], "-", 
     RowBox[{"17", " ", 
      SuperscriptBox["z", "4"]}]}], "\[Equal]", "401"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->75200279],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindInstance", "::", "\<\"nsmet\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The methods available to \
FindInstance are insufficient to find the requested instances or prove they \
do not exist.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/FindInstance\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[10]:=",
 CellID->457294284],

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox["y", "3"]}], "-", 
     RowBox[{"17", " ", 
      SuperscriptBox["z", "4"]}]}], "\[Equal]", "401"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]], "Output",
 ImageSize->{373, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->638088738]
}, Open  ]],

Cell[TextData[{
 "Increasing the number of ",
 Cell[BoxData["SieveMaxPoints"], "InlineFormula"],
 " to one million allows ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find a solution."
}], "MathCaption",
 CellID->833982335],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SieveMaxPoints\>\"", "\[Rule]", "1000000"}], "}"}]}], "]"}],
   ";"}], "\n", 
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox["y", "3"]}], "-", 
     RowBox[{"17", " ", 
      SuperscriptBox["z", "4"]}]}], "\[Equal]", "401"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Integers"}], 
  "]"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->56274466],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "29"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "2"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"-", "2"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->12914805]
}, Open  ]],

Cell[TextData[{
 "This resets ",
 Cell[BoxData["SieveMaxPoints"], "InlineFormula"],
 " to the default value."
}], "MathCaption",
 CellID->350883274],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetSystemOptions", "[", 
   RowBox[{"\"\<ReduceOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SieveMaxPoints\>\"", "\[Rule]", "10000"}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->9058871]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["References", "Section",
 CellMargins->{{27, 27}, {20, 18}},
 CellTags->{"t:29", "c:29"},
 CellID->73689979],

Cell[TextData[{
 "[1] C. Goldbach, Letter to L. Euler, June 7, 1742. ",
 ButtonBox["http://www.mathstat.dal.ca/~joerg/pic/g-letter.jpg",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.mathstat.dal.ca/~joerg/pic/g-letter.jpg"], None}],
 "."
}], "DisplayMath",
 CellTags->"1",
 CellID->449015277],

Cell[TextData[{
 "[2] Yu. V. Matiyasevich, \[OpenCurlyDoubleQuote]The Diophantineness of \
Enumerable Sets,\[CloseCurlyDoubleQuote] (Russian) ",
 StyleBox["Dokl. Akad. Nauk SSSR,",
  FontSlant->"Italic"],
 " ",
 StyleBox["191",
  FontWeight->"Bold"],
 ", 1970 pp. 279-282. English translation: ",
 StyleBox["Soviet Math. Dokl.,",
  FontSlant->"Italic"],
 " ",
 StyleBox["11",
  FontWeight->"Bold"],
 ", 1970 pp. 354\[Dash]358."
}], "DisplayMath",
 CellTags->"2",
 CellID->5262274],

Cell[TextData[{
 "[3] E. Contejean and H. Devie, \[OpenCurlyDoubleQuote]An Efficient \
Incremental Algorithm for Solving Systems of Linear Diophantine Equations,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["Information and Computation,",
  FontSlant->"Italic"],
 " ",
 StyleBox["113",
  FontWeight->"Bold"],
 ", 1994 pp. 143\[Dash]172."
}], "DisplayMath",
 CellTags->"3",
 CellID->36916775],

Cell[TextData[{
 "[4] F. Cucker, P. Koiran, and S. Smale, \[OpenCurlyDoubleQuote]A Polynomial \
Time Algorithm for Diophantine Equations in One Variable,\
\[CloseCurlyDoubleQuote] ",
 StyleBox["Journal of Symbolic Computation,",
  FontSlant->"Italic"],
 " ",
 StyleBox["27",
  FontWeight->"Bold"],
 "(1), 1999 pp. 21\[Dash]30."
}], "DisplayMath",
 CellTags->"4",
 CellID->434003486],

Cell[TextData[{
 "[5] A. Strzebonski, \[OpenCurlyDoubleQuote]An Improved Algorithm for \
Diophantine Equations in One Variable,\[CloseCurlyDoubleQuote] Paper \
presented at the ACA 2002 Session on Symbolic-Numerical Methods in \
Computational Science, Volos, Greece. Notebook with the conference talk \
available at ",
 ButtonBox["members.wolfram.com/adams",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://members.wolfram.com/adams"], None}],
 "."
}], "DisplayMath",
 CellTags->"5",
 CellID->321539263],

Cell[TextData[{
 "[6] L. E. Dickson,",
 " ",
 StyleBox["History of the Theory of Numbers",
  FontSlant->"Italic"],
 ", New York: Chelsea, 1952."
}], "DisplayMath",
 CellTags->"6",
 CellID->442253592],

Cell[TextData[{
 "[7] T. Nagell, ",
 StyleBox["Introduction to Number Theory,",
  FontSlant->"Italic"],
 " New York: Wiley, 1951."
}], "DisplayMath",
 CellTags->"7",
 CellID->157765207],

Cell[TextData[{
 "[8] K. Hardy, J. B. Muskat and K. S. Williams, \[OpenCurlyDoubleQuote]A \
Deterministic Algorithm for Solving ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "=", 
    RowBox[{
     RowBox[{"f", " ", 
      SuperscriptBox["u", "2"]}], "+", 
     RowBox[{"g", " ", 
      SuperscriptBox["v", "2"]}]}]}], TraditionalForm]], "InlineMath"],
 " in Coprime Integers ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 ",\[CloseCurlyDoubleQuote] ",
 StyleBox["Mathematics of Computation,",
  FontSlant->"Italic"],
 " ",
 StyleBox["55",
  FontWeight->"Bold"],
 ", 1990 pp. 327",
 "\[Dash]",
 "343. "
}], "DisplayMath",
 CellTags->"8",
 CellID->906771487],

Cell[TextData[{
 "[9] N. Smart, ",
 StyleBox["The Algorithmic Resolution of Diophantine Equations",
  FontSlant->"Italic"],
 ", London Mathematical Society Student Text, ",
 StyleBox["41",
  FontWeight->"Bold"],
 ", Cambridge University Press, 1998. "
}], "DisplayMath",
 CellTags->"9",
 CellID->745879058],

Cell[TextData[{
 "[10] D. M. Bressoud and S. Wagon, ",
 StyleBox["A Course in Computational Number Theory",
  FontSlant->"Italic"],
 ", San Francisco: Key College Publishing, 2000."
}], "DisplayMath",
 CellTags->"10",
 CellID->441990865],

Cell[TextData[{
 "[11] D. E. Beihoffer, J. Hendry, A. Nijenhuis, and S. Wagon, \
\[OpenCurlyDoubleQuote]Faster Algorithms for Frobenius Numbers,\
\[CloseCurlyDoubleQuote] to appear in ",
 StyleBox["The Electronic Journal of Combinatorics",
  FontSlant->"Italic"],
 "."
}], "DisplayMath",
 CellTags->"11",
 CellID->99664469],

Cell[TextData[{
 "[12] M. O. Rabin and J. O. Shallit, \[OpenCurlyDoubleQuote]Randomized \
Algorithms in Number Theory,\[CloseCurlyDoubleQuote]",
 StyleBox[" Communications on Pure and Applied Mathematics",
  FontSlant->"Italic"],
 ", ",
 StyleBox["39",
  FontWeight->"Bold"],
 ", 1986 pp. 239\[Dash]256."
}], "DisplayMath",
 CellTags->"12",
 CellID->594065443]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Diophantine Polynomial Systems - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 9.8126534}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "A Diophantine polynomial system is an expression constructed with \
polynomial equations and inequalities combined using logical connectives and \
quantifiers where the variables represent integer quantities.", 
    "synonyms" -> {}, "title" -> "Diophantine Polynomial Systems", "type" -> 
    "Tutorial", "uri" -> "tutorial/DiophantineReduce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "t:3"->{
  Cell[820, 34, 77, 2, 70, "Section",
   CellTags->{"t:3", "c:3"},
   CellID->21194150]},
 "c:3"->{
  Cell[820, 34, 77, 2, 70, "Section",
   CellTags->{"t:3", "c:3"},
   CellID->21194150]},
 "Diophantine1"->{
  Cell[5175, 176, 630, 22, 70, "DisplayMath",
   CellTags->"Diophantine1",
   CellID->106442024]},
 "Diophantine2"->{
  Cell[6887, 239, 1073, 35, 70, "DisplayMath",
   CellTags->"Diophantine2",
   CellID->298139489]},
 "LinearEqns"->{
  Cell[9746, 336, 93, 2, 70, "Subsection",
   CellTags->"LinearEqns",
   CellID->22538780]},
 "Frobenius"->{
  Cell[12429, 431, 84, 2, 70, "Subsection",
   CellTags->"Frobenius",
   CellID->33996244]},
 "BoundedLinearSystems"->{
  Cell[16718, 572, 127, 2, 70, "Subsection",
   CellTags->"BoundedLinearSystems",
   CellID->3382796]},
 "PolyhedronIntegerPoints"->{
  Cell[24575, 849, 1922, 52, 70, "Text",
   CellTags->"PolyhedronIntegerPoints",
   CellID->551184031],
  Cell[26500, 903, 523, 15, 70, "Text",
   CellTags->"PolyhedronIntegerPoints",
   CellID->93685138]},
 "BoundedSolutionLimits"->{
  Cell[32425, 1029, 784, 21, 70, "Text",
   CellTags->"BoundedSolutionLimits",
   CellID->126309748]},
 "UnivariateEqns"->{
  Cell[46266, 1378, 91, 2, 70, "Subsection",
   CellTags->"UnivariateEqns",
   CellID->940041165]},
 "Quadratic"->{
  Cell[52092, 1596, 568, 19, 70, "DisplayMath",
   CellTags->"Quadratic",
   CellID->250440120]},
 "Parabolic1"->{
  Cell[110287, 3046, 1150, 41, 70, "DisplayMath",
   CellTags->"Parabolic1",
   CellID->141071864]},
 "Parabolic2"->{
  Cell[112842, 3144, 611, 23, 70, "DisplayMath",
   CellTags->"Parabolic2",
   CellID->328505180]},
 "Parabolic3"->{
  Cell[114957, 3227, 763, 26, 70, "DisplayMath",
   CellTags->"Parabolic3",
   CellID->238897076]},
 "Parabolic4"->{
  Cell[117128, 3311, 784, 27, 70, "DisplayMath",
   CellTags->"Parabolic4",
   CellID->69774393]},
 "Sieve"->{
  Cell[131286, 3817, 108, 2, 70, "Subsection",
   CellTags->"Sieve",
   CellID->276178224]},
 "ManyEqn"->{
  Cell[134793, 3942, 98, 2, 70, "Subsection",
   CellTags->"ManyEqn",
   CellID->11174366]},
 "Congruences"->{
  Cell[140889, 4169, 563, 18, 70, "DisplayMath",
   CellTags->"Congruences",
   CellID->86771084]},
 "SumOfSquares"->{
  Cell[151627, 4465, 426, 15, 70, "DisplayMath",
   CellTags->"SumOfSquares",
   CellID->624380415]},
 "PythagoreanTriples"->{
  Cell[158939, 4735, 264, 9, 70, "DisplayMath",
   CellTags->"PythagoreanTriples",
   CellID->54624850],
  Cell[162058, 4845, 490, 16, 70, "DisplayMath",
   CellTags->"PythagoreanTriples",
   CellID->42507905]},
 "LinVarEqn"->{
  Cell[172664, 5158, 98, 2, 70, "Subsection",
   CellTags->"LinVarEqn",
   CellID->567820882]},
 "LinVar"->{
  Cell[174009, 5209, 1635, 50, 70, "DisplayMath",
   CellTags->"LinVar",
   CellID->570075151]},
 "DivisibilityHeuristic"->{
  Cell[206676, 6295, 1141, 35, 70, "DisplayMath",
   CellTags->"DivisibilityHeuristic",
   CellID->553913193]},
 "ExhaustiveSearch"->{
  Cell[210453, 6436, 109, 2, 70, "Subsection",
   CellTags->"ExhaustiveSearch",
   CellID->53756076]},
 "BranchLinearDiophantine"->{
  Cell[226801, 6928, 106, 2, 70, "Subsubsection",
   CellTags->"BranchLinearDiophantine",
   CellID->210244652]},
 "DiscreteSolutionBound"->{
  Cell[246200, 7569, 102, 2, 70, "Subsubsection",
   CellTags->"DiscreteSolutionBound",
   CellID->251741464]},
 "ExhaustiveSearchMaxPoints"->{
  Cell[251638, 7772, 110, 2, 70, "Subsubsection",
   CellTags->"ExhaustiveSearchMaxPoints",
   CellID->522087212]},
 "LatticeReduceDiophantine"->{
  Cell[263443, 8174, 108, 2, 70, "Subsubsection",
   CellTags->"LatticeReduceDiophantine",
   CellID->224006136]},
 "MaxFrobeniusGraph"->{
  Cell[272207, 8490, 94, 2, 70, "Subsubsection",
   CellTags->"MaxFrobeniusGraph",
   CellID->219054329]},
 "SieveMaxPoints"->{
  Cell[281730, 8800, 88, 2, 70, "Subsubsection",
   CellTags->"SieveMaxPoints",
   CellID->307047228]},
 "t:29"->{
  Cell[285927, 8955, 113, 3, 70, "Section",
   CellTags->{"t:29", "c:29"},
   CellID->73689979]},
 "c:29"->{
  Cell[285927, 8955, 113, 3, 70, "Section",
   CellTags->{"t:29", "c:29"},
   CellID->73689979]},
 "1"->{
  Cell[286043, 8960, 309, 9, 70, "DisplayMath",
   CellTags->"1",
   CellID->449015277]},
 "2"->{
  Cell[286355, 8971, 480, 17, 70, "DisplayMath",
   CellTags->"2",
   CellID->5262274]},
 "3"->{
  Cell[286838, 8990, 385, 12, 70, "DisplayMath",
   CellTags->"3",
   CellID->36916775]},
 "4"->{
  Cell[287226, 9004, 382, 12, 70, "DisplayMath",
   CellTags->"4",
   CellID->434003486]},
 "5"->{
  Cell[287611, 9018, 513, 13, 70, "DisplayMath",
   CellTags->"5",
   CellID->321539263]},
 "6"->{
  Cell[288127, 9033, 199, 8, 70, "DisplayMath",
   CellTags->"6",
   CellID->442253592]},
 "7"->{
  Cell[288329, 9043, 185, 7, 70, "DisplayMath",
   CellTags->"7",
   CellID->157765207]},
 "8"->{
  Cell[288517, 9052, 751, 28, 70, "DisplayMath",
   CellTags->"8",
   CellID->906771487]},
 "9"->{
  Cell[289271, 9082, 306, 10, 70, "DisplayMath",
   CellTags->"9",
   CellID->745879058]},
 "10"->{
  Cell[289580, 9094, 237, 7, 70, "DisplayMath",
   CellTags->"10",
   CellID->441990865]},
 "11"->{
  Cell[289820, 9103, 323, 9, 70, "DisplayMath",
   CellTags->"11",
   CellID->99664469]},
 "12"->{
  Cell[290146, 9114, 360, 11, 70, "DisplayMath",
   CellTags->"12",
   CellID->594065443]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"t:3", 291973, 9165},
 {"c:3", 292073, 9169},
 {"Diophantine1", 292182, 9173},
 {"Diophantine2", 292300, 9177},
 {"LinearEqns", 292417, 9181},
 {"Frobenius", 292526, 9185},
 {"BoundedLinearSystems", 292646, 9189},
 {"PolyhedronIntegerPoints", 292780, 9193},
 {"BoundedSolutionLimits", 293015, 9200},
 {"UnivariateEqns", 293139, 9204},
 {"Quadratic", 293255, 9208},
 {"Parabolic1", 293370, 9212},
 {"Parabolic2", 293488, 9216},
 {"Parabolic3", 293605, 9220},
 {"Parabolic4", 293722, 9224},
 {"Sieve", 293833, 9228},
 {"ManyEqn", 293940, 9232},
 {"Congruences", 294051, 9236},
 {"SumOfSquares", 294170, 9240},
 {"PythagoreanTriples", 294297, 9244},
 {"LinVarEqn", 294525, 9251},
 {"LinVar", 294634, 9255},
 {"DivisibilityHeuristic", 294759, 9259},
 {"ExhaustiveSearch", 294894, 9263},
 {"BranchLinearDiophantine", 295027, 9267},
 {"DiscreteSolutionBound", 295169, 9271},
 {"ExhaustiveSearchMaxPoints", 295313, 9275},
 {"LatticeReduceDiophantine", 295460, 9279},
 {"MaxFrobeniusGraph", 295599, 9283},
 {"SieveMaxPoints", 295727, 9287},
 {"t:29", 295842, 9291},
 {"c:29", 295951, 9295},
 {"1", 296057, 9299},
 {"2", 296155, 9303},
 {"3", 296252, 9307},
 {"4", 296350, 9311},
 {"5", 296449, 9315},
 {"6", 296548, 9319},
 {"7", 296646, 9323},
 {"8", 296744, 9327},
 {"9", 296843, 9331},
 {"10", 296943, 9335},
 {"11", 297043, 9339},
 {"12", 297142, 9343}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 67, 1, 70, "Title",
 CellID->827847405],
Cell[CellGroupData[{
Cell[820, 34, 77, 2, 70, "Section",
 CellTags->{"t:3", "c:3"},
 CellID->21194150],
Cell[900, 38, 197, 6, 70, "Text",
 CellID->188227223],
Cell[1100, 46, 2028, 59, 70, "DisplayMath",
 CellID->141921810],
Cell[3131, 107, 86, 1, 70, "Text",
 CellID->252289036],
Cell[3220, 110, 663, 19, 70, "DisplayMath",
 CellID->751756458],
Cell[3886, 131, 84, 1, 70, "Text",
 CellID->83213009],
Cell[3973, 134, 1199, 40, 70, "Text",
 CellID->91342862],
Cell[5175, 176, 630, 22, 70, "DisplayMath",
 CellTags->"Diophantine1",
 CellID->106442024],
Cell[5808, 200, 990, 34, 70, "Text",
 CellID->554193710],
Cell[6801, 236, 83, 1, 70, "Text",
 CellID->33004248],
Cell[6887, 239, 1073, 35, 70, "DisplayMath",
 CellTags->"Diophantine2",
 CellID->298139489],
Cell[7963, 276, 1668, 50, 70, "Text",
 CellID->340212020]
}, Open  ]],
Cell[CellGroupData[{
Cell[9668, 331, 53, 1, 70, "Section",
 CellID->551921972],
Cell[CellGroupData[{
Cell[9746, 336, 93, 2, 70, "Subsection",
 CellTags->"LinearEqns",
 CellID->22538780],
Cell[9842, 340, 717, 18, 70, "Text",
 CellID->17656720],
Cell[10562, 360, 180, 4, 70, "MathCaption",
 CellID->383261712],
Cell[CellGroupData[{
Cell[10767, 368, 579, 20, 70, "Input",
 CellID->229190442],
Cell[11349, 390, 1031, 35, 54, "Output",
 CellID->314031709]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12429, 431, 84, 2, 70, "Subsection",
 CellTags->"Frobenius",
 CellID->33996244],
Cell[12516, 435, 139, 6, 70, "Text",
 CellID->4484172],
Cell[12658, 443, 329, 12, 70, "DisplayMath",
 CellID->120031077],
Cell[12990, 457, 581, 18, 70, "Text",
 CellID->536223126],
Cell[13574, 477, 1225, 34, 70, "Text",
 CellID->31411680],
Cell[14802, 513, 89, 1, 70, "MathCaption",
 CellID->733961252],
Cell[CellGroupData[{
Cell[14916, 518, 1166, 29, 70, "Input",
 CellID->340562248],
Cell[16085, 549, 584, 17, 36, "Output",
 CellID->391581807]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16718, 572, 127, 2, 70, "Subsection",
 CellTags->"BoundedLinearSystems",
 CellID->3382796],
Cell[16848, 576, 306, 8, 70, "Text",
 CellID->65402303],
Cell[17157, 586, 7415, 261, 70, "Text",
 CellID->621221680],
Cell[24575, 849, 1922, 52, 70, "Text",
 CellTags->"PolyhedronIntegerPoints",
 CellID->551184031],
Cell[26500, 903, 523, 15, 70, "Text",
 CellTags->"PolyhedronIntegerPoints",
 CellID->93685138],
Cell[27026, 920, 87, 1, 70, "MathCaption",
 CellID->108988687],
Cell[CellGroupData[{
Cell[27138, 925, 481, 16, 28, "Input",
 CellID->567505768],
Cell[27622, 943, 4788, 83, 258, "Output",
 Evaluatable->False,
 CellID->632118532]
}, Open  ]],
Cell[32425, 1029, 784, 21, 70, "Text",
 CellTags->"BoundedSolutionLimits",
 CellID->126309748],
Cell[33212, 1052, 280, 9, 70, "MathCaption",
 CellID->552720389],
Cell[CellGroupData[{
Cell[33517, 1065, 369, 11, 70, "Input",
 CellID->514161096],
Cell[33889, 1078, 641, 20, 36, "Output",
 CellID->74068940]
}, Open  ]],
Cell[34545, 1101, 175, 5, 70, "MathCaption",
 CellID->22773890],
Cell[34723, 1108, 272, 8, 70, "Input",
 CellID->240373159],
Cell[34998, 1118, 327, 10, 70, "MathCaption",
 CellID->176248344],
Cell[CellGroupData[{
Cell[35350, 1132, 409, 13, 70, "Input",
 CellID->244043109],
Cell[35762, 1147, 162, 5, 36, "Output",
 CellID->117830275]
}, Open  ]],
Cell[35939, 1155, 155, 5, 70, "MathCaption",
 CellID->413780436],
Cell[36097, 1162, 269, 8, 70, "Input",
 CellID->60790276]
}, Open  ]],
Cell[CellGroupData[{
Cell[36403, 1175, 96, 1, 70, "Subsection",
 CellID->138579073],
Cell[36502, 1178, 1528, 34, 70, "Text",
 CellID->389866364],
Cell[38033, 1214, 179, 4, 70, "MathCaption",
 CellID->109401115],
Cell[CellGroupData[{
Cell[38237, 1222, 458, 16, 28, "Input",
 CellID->5857738],
Cell[38698, 1240, 7425, 126, 360, "Output",
 Evaluatable->False,
 CellID->7604364]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46184, 1373, 57, 1, 70, "Section",
 CellID->101156547],
Cell[CellGroupData[{
Cell[46266, 1378, 91, 2, 70, "Subsection",
 CellTags->"UnivariateEqns",
 CellID->940041165],
Cell[46360, 1382, 594, 16, 70, "Text",
 CellID->273031667],
Cell[46957, 1400, 248, 8, 70, "MathCaption",
 CellID->71750999],
Cell[CellGroupData[{
Cell[47230, 1412, 734, 23, 70, "Input",
 CellID->3848862],
Cell[47967, 1437, 260, 8, 36, "Output",
 CellID->944685127]
}, Open  ]],
Cell[48242, 1448, 134, 4, 70, "MathCaption",
 CellID->81969822],
Cell[CellGroupData[{
Cell[48401, 1456, 104, 3, 70, "Input",
 CellID->62823905],
Cell[48508, 1461, 220, 6, 36, "Output",
 CellID->417246639]
}, Open  ]],
Cell[CellGroupData[{
Cell[48765, 1472, 221, 7, 70, "Input",
 CellID->646475880],
Cell[48989, 1481, 166, 5, 36, "Output",
 CellID->548978267]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49204, 1492, 90, 1, 70, "Subsection",
 CellID->125613587],
Cell[49297, 1495, 458, 10, 70, "Text",
 CellID->16645855],
Cell[49758, 1507, 695, 25, 70, "MathCaption",
 CellID->190054578],
Cell[CellGroupData[{
Cell[50478, 1536, 469, 16, 70, "Input",
 CellID->457671103],
Cell[50950, 1554, 242, 8, 36, "Output",
 CellID->190059551]
}, Open  ]],
Cell[51207, 1565, 478, 9, 70, "Text",
 CellID->512069660]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51734, 1580, 55, 1, 70, "Section",
 CellID->13440227],
Cell[CellGroupData[{
Cell[51814, 1585, 61, 1, 70, "Subsection",
 CellID->192854485],
Cell[51878, 1588, 211, 6, 70, "Text",
 CellID->12207510],
Cell[52092, 1596, 568, 19, 70, "DisplayMath",
 CellTags->"Quadratic",
 CellID->250440120],
Cell[52663, 1617, 2072, 68, 70, "Text",
 CellID->30546744],
Cell[CellGroupData[{
Cell[54760, 1689, 95, 1, 70, "Subsubsection",
 CellID->169792321],
Cell[54858, 1692, 2438, 83, 70, "Text",
 CellID->702370375],
Cell[57299, 1777, 207, 7, 70, "MathCaption",
 CellID->223521695],
Cell[CellGroupData[{
Cell[57531, 1788, 485, 15, 70, "Input",
 CellID->215084580],
Cell[58019, 1805, 614, 22, 36, "Output",
 CellID->175018541]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58682, 1833, 98, 1, 70, "Subsubsection",
 CellID->268472846],
Cell[58783, 1836, 927, 30, 70, "Text",
 CellID->337818019],
Cell[59713, 1868, 484, 16, 70, "MathCaption",
 CellID->167354501],
Cell[CellGroupData[{
Cell[60222, 1888, 330, 11, 70, "Input",
 CellID->901623847],
Cell[60555, 1901, 5371, 170, 539, "Output",
 CellID->15330225]
}, Open  ]],
Cell[65941, 2074, 216, 7, 70, "MathCaption",
 CellID->812676277],
Cell[CellGroupData[{
Cell[66182, 2085, 465, 14, 30, "Input",
 CellID->277407805],
Cell[66650, 2101, 32020, 529, 1768, "Output",
 Evaluatable->False,
 CellID->277820084]
}, Open  ]],
Cell[98685, 2633, 164, 4, 70, "MathCaption",
 CellID->24913506],
Cell[CellGroupData[{
Cell[98874, 2641, 191, 6, 70, "Input",
 CellID->600329995],
Cell[99068, 2649, 1949, 60, 173, "Output",
 CellID->189514895]
}, Open  ]],
Cell[101032, 2712, 279, 8, 70, "MathCaption",
 CellID->78290278],
Cell[CellGroupData[{
Cell[101336, 2724, 421, 13, 70, "Input",
 CellID->237564403],
Cell[101760, 2739, 5710, 186, 241, "Output",
 CellID->468009843]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107519, 2931, 69, 1, 70, "Subsubsection",
 CellID->277000449],
Cell[107591, 2934, 1606, 64, 70, "Text",
 CellID->15585768],
Cell[109200, 3000, 470, 16, 70, "DisplayMath",
 CellID->443509506],
Cell[109673, 3018, 611, 26, 70, "Text",
 CellID->121755007],
Cell[110287, 3046, 1150, 41, 70, "DisplayMath",
 CellTags->"Parabolic1",
 CellID->141071864],
Cell[111440, 3089, 1133, 40, 70, "Text",
 CellID->202057420],
Cell[112576, 3131, 263, 11, 70, "Text",
 CellID->435636865],
Cell[112842, 3144, 611, 23, 70, "DisplayMath",
 CellTags->"Parabolic2",
 CellID->328505180],
Cell[113456, 3169, 1498, 56, 70, "Text",
 CellID->14815555],
Cell[114957, 3227, 763, 26, 70, "DisplayMath",
 CellTags->"Parabolic3",
 CellID->238897076],
Cell[115723, 3255, 1402, 54, 70, "Text",
 CellID->894213245],
Cell[117128, 3311, 784, 27, 70, "DisplayMath",
 CellTags->"Parabolic4",
 CellID->69774393],
Cell[117915, 3340, 957, 36, 70, "Text",
 CellID->346478772],
Cell[118875, 3378, 254, 8, 70, "MathCaption",
 CellID->262817330],
Cell[CellGroupData[{
Cell[119154, 3390, 421, 13, 70, "Input",
 CellID->764095279],
Cell[119578, 3405, 1407, 46, 58, "Output",
 CellID->156628762]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[121034, 3457, 68, 1, 70, "Subsubsection",
 CellID->262833632],
Cell[121105, 3460, 892, 26, 70, "Text",
 CellID->30996886],
Cell[122000, 3488, 586, 17, 70, "MathCaption",
 CellID->486256267],
Cell[CellGroupData[{
Cell[122611, 3509, 485, 16, 70, "Input",
 CellID->417391655],
Cell[123099, 3527, 1434, 38, 156, "Output",
 CellID->315430140]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[124594, 3572, 55, 1, 70, "Subsection",
 CellID->55469500],
Cell[124652, 3575, 147, 6, 70, "Text",
 CellID->159783309],
Cell[124802, 3583, 67, 1, 70, "DisplayMath",
 CellID->157187725],
Cell[124872, 3586, 256, 8, 70, "Text",
 CellID->119621423],
Cell[125131, 3596, 790, 21, 70, "Text",
 CellID->15680138],
Cell[125924, 3619, 97, 1, 70, "MathCaption",
 CellID->313292578],
Cell[CellGroupData[{
Cell[126046, 3624, 411, 14, 70, "Input",
 CellID->323337918],
Cell[126460, 3640, 1038, 33, 54, "Output",
 CellID->45360015]
}, Open  ]],
Cell[127513, 3676, 262, 8, 70, "MathCaption",
 CellID->775838566],
Cell[CellGroupData[{
Cell[127800, 3688, 569, 19, 70, "Input",
 CellID->14199522],
Cell[128372, 3709, 1040, 33, 54, "Output",
 CellID->809093723]
}, Open  ]],
Cell[129427, 3745, 538, 17, 70, "MathCaption",
 CellID->206191399],
Cell[CellGroupData[{
Cell[129990, 3766, 803, 26, 70, "Input",
 CellID->332355893],
Cell[130796, 3794, 335, 11, 36, "Output",
 CellID->37695497]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[131192, 3812, 69, 1, 70, "Section",
 CellID->479923181],
Cell[CellGroupData[{
Cell[131286, 3817, 108, 2, 70, "Subsection",
 CellTags->"Sieve",
 CellID->276178224],
Cell[131397, 3821, 912, 25, 70, "Text",
 CellID->53385984],
Cell[132312, 3848, 83, 1, 70, "MathCaption",
 CellID->287347954],
Cell[CellGroupData[{
Cell[132420, 3853, 785, 25, 70, "Input",
 CellID->490125107],
Cell[133208, 3880, 163, 5, 36, "Output",
 CellID->374506010]
}, Open  ]],
Cell[133386, 3888, 243, 8, 70, "MathCaption",
 CellID->326409774],
Cell[CellGroupData[{
Cell[133654, 3900, 755, 23, 70, "Input",
 CellID->153182627],
Cell[134412, 3925, 332, 11, 36, "Output",
 CellID->369341712]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[134793, 3942, 98, 2, 70, "Subsection",
 CellTags->"ManyEqn",
 CellID->11174366],
Cell[134894, 3946, 384, 11, 70, "Text",
 CellID->457704621],
Cell[CellGroupData[{
Cell[135303, 3961, 119, 3, 70, "Subsubsection",
 CellID->718104328],
Cell[135425, 3966, 448, 11, 70, "Text",
 CellID->193959803],
Cell[135876, 3979, 480, 13, 70, "MathCaption",
 CellID->717643889],
Cell[CellGroupData[{
Cell[136381, 3996, 544, 18, 70, "Input",
 CellID->41402925],
Cell[136928, 4016, 598, 21, 36, "Output",
 CellID->347203758]
}, Open  ]],
Cell[137541, 4040, 378, 11, 70, "MathCaption",
 CellID->189250134],
Cell[CellGroupData[{
Cell[137944, 4055, 607, 20, 70, "Input",
 CellID->188911562],
Cell[138554, 4077, 1360, 47, 82, "Output",
 CellID->31607602]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[139963, 4130, 109, 3, 70, "Subsubsection",
 CellID->166093770],
Cell[140075, 4135, 119, 3, 70, "Text",
 CellID->36505167],
Cell[140197, 4140, 534, 19, 70, "DisplayMath",
 CellID->185106411],
Cell[140734, 4161, 152, 6, 70, "Text",
 CellID->121479120],
Cell[140889, 4169, 563, 18, 70, "DisplayMath",
 CellTags->"Congruences",
 CellID->86771084],
Cell[141455, 4189, 462, 13, 70, "Text",
 CellID->9976895],
Cell[141920, 4204, 115, 3, 70, "MathCaption",
 CellID->217316773],
Cell[CellGroupData[{
Cell[142060, 4211, 701, 23, 70, "Input",
 CellID->733855660],
Cell[142764, 4236, 2596, 85, 128, "Output",
 CellID->73236175]
}, Open  ]],
Cell[145375, 4324, 214, 6, 70, "MathCaption",
 CellID->309531394],
Cell[CellGroupData[{
Cell[145614, 4334, 780, 26, 30, "Input",
 CellID->515352053],
Cell[146397, 4362, 4975, 86, 233, "Output",
 Evaluatable->False,
 CellID->70239532]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[151433, 4455, 56, 1, 70, "Subsection",
 CellID->76762835],
Cell[151492, 4458, 132, 5, 70, "Text",
 CellID->842843879],
Cell[151627, 4465, 426, 15, 70, "DisplayMath",
 CellTags->"SumOfSquares",
 CellID->624380415],
Cell[152056, 4482, 783, 25, 70, "Text",
 CellID->291279106],
Cell[152842, 4509, 101, 2, 70, "MathCaption",
 CellID->29323096],
Cell[CellGroupData[{
Cell[152968, 4515, 589, 20, 70, "Input",
 CellID->650809474],
Cell[153560, 4537, 1744, 58, 71, "Output",
 CellID->34429944]
}, Open  ]],
Cell[155319, 4598, 392, 16, 70, "Text",
 CellID->34597627],
Cell[155714, 4616, 298, 9, 70, "MathCaption",
 CellID->250147251],
Cell[CellGroupData[{
Cell[156037, 4629, 916, 28, 70, "Input",
 CellID->43278149],
Cell[156956, 4659, 1054, 33, 92, "Output",
 CellID->138292553]
}, Open  ]],
Cell[158025, 4695, 95, 1, 70, "MathCaption",
 CellID->210849536],
Cell[CellGroupData[{
Cell[158145, 4700, 346, 11, 70, "Input",
 CellID->414400811],
Cell[158494, 4713, 181, 6, 36, "Output",
 CellID->655187225]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[158724, 4725, 62, 1, 70, "Subsection",
 CellID->336018421],
Cell[158789, 4728, 147, 5, 70, "Text",
 CellID->466314649],
Cell[158939, 4735, 264, 9, 70, "DisplayMath",
 CellTags->"PythagoreanTriples",
 CellID->54624850],
Cell[159206, 4746, 105, 2, 70, "MathCaption",
 CellID->732534261],
Cell[CellGroupData[{
Cell[159336, 4752, 335, 12, 70, "Input",
 CellID->616941761],
Cell[159674, 4766, 2172, 68, 75, "Output",
 CellID->162106900]
}, Open  ]],
Cell[161861, 4837, 194, 6, 70, "Text",
 CellID->16586492],
Cell[162058, 4845, 490, 16, 70, "DisplayMath",
 CellTags->"PythagoreanTriples",
 CellID->42507905],
Cell[162551, 4863, 90, 1, 70, "Text",
 CellID->340810444],
Cell[162644, 4866, 110, 3, 70, "MathCaption",
 CellID->1351366],
Cell[CellGroupData[{
Cell[162779, 4873, 639, 20, 30, "Input",
 CellID->98402069],
Cell[163421, 4895, 3837, 67, 151, "Output",
 Evaluatable->False,
 CellID->255748878]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[167307, 4968, 84, 1, 70, "Subsection",
 CellID->195660507],
Cell[167394, 4971, 177, 6, 70, "Text",
 CellID->33520346],
Cell[167574, 4979, 360, 12, 70, "DisplayMath",
 CellID->2785354],
Cell[167937, 4993, 510, 14, 70, "Text",
 CellID->42757427],
Cell[168450, 5009, 123, 3, 70, "MathCaption",
 CellID->1659640],
Cell[CellGroupData[{
Cell[168598, 5016, 603, 21, 70, "Input",
 CellID->645836790],
Cell[169204, 5039, 3411, 113, 122, "Output",
 CellID->92666063]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[172664, 5158, 98, 2, 70, "Subsection",
 CellTags->"LinVarEqn",
 CellID->567820882],
Cell[172765, 5162, 149, 5, 70, "Text",
 CellID->78817744],
Cell[172917, 5169, 637, 20, 70, "DisplayMath",
 CellID->828446993],
Cell[173557, 5191, 449, 16, 70, "Text",
 CellID->333706022],
Cell[174009, 5209, 1635, 50, 70, "DisplayMath",
 CellTags->"LinVar",
 CellID->570075151],
Cell[175647, 5261, 4489, 149, 70, "Text",
 CellID->67122203],
Cell[180139, 5412, 396, 14, 70, "DisplayMath",
 CellID->556337108],
Cell[180538, 5428, 2025, 71, 70, "Text",
 CellID->73112932],
Cell[182566, 5501, 1436, 49, 70, "Text",
 CellID->569792802],
Cell[184005, 5552, 252, 6, 70, "Text",
 CellID->26716957],
Cell[184260, 5560, 390, 16, 70, "MathCaption",
 CellID->97526973],
Cell[CellGroupData[{
Cell[184675, 5580, 507, 17, 70, "Input",
 CellID->413022944],
Cell[185185, 5599, 2250, 67, 88, "Output",
 CellID->410867118]
}, Open  ]],
Cell[187450, 5669, 391, 16, 70, "MathCaption",
 CellID->214562981],
Cell[CellGroupData[{
Cell[187866, 5689, 461, 15, 70, "Input",
 CellID->25052500],
Cell[188330, 5706, 1303, 44, 84, "Output",
 CellID->262938559]
}, Open  ]],
Cell[189648, 5753, 269, 11, 70, "MathCaption",
 CellID->473173069],
Cell[CellGroupData[{
Cell[189942, 5768, 510, 17, 70, "Input",
 CellID->72008462],
Cell[190455, 5787, 429, 15, 36, "Output",
 CellID->221635579]
}, Open  ]],
Cell[190899, 5805, 1247, 40, 70, "MathCaption",
 CellID->1674974],
Cell[CellGroupData[{
Cell[192171, 5849, 1190, 36, 70, "Input",
 CellID->3045174],
Cell[193364, 5887, 163, 5, 36, "Output",
 CellID->617141957]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[193576, 5898, 90, 1, 70, "Subsection",
 CellID->114666200],
Cell[193669, 5901, 1750, 34, 70, "Text",
 CellID->402968579],
Cell[195422, 5937, 412, 12, 70, "MathCaption",
 CellID->52119230],
Cell[CellGroupData[{
Cell[195859, 5953, 542, 18, 70, "Input",
 CellID->81669180],
Cell[196404, 5973, 3177, 99, 111, "Output",
 CellID->57676624]
}, Open  ]],
Cell[199596, 6075, 333, 10, 70, "MathCaption",
 CellID->600418672],
Cell[CellGroupData[{
Cell[199954, 6089, 756, 24, 47, "Input",
 CellID->131720673],
Cell[200713, 6115, 2522, 45, 105, "Output",
 Evaluatable->False,
 CellID->458118626]
}, Open  ]],
Cell[203250, 6163, 154, 5, 70, "MathCaption",
 CellID->29221804],
Cell[203407, 6170, 271, 8, 70, "Input",
 CellID->347996735],
Cell[203681, 6180, 601, 20, 70, "MathCaption",
 CellID->951443395],
Cell[CellGroupData[{
Cell[204307, 6204, 608, 20, 70, "Input",
 CellID->64337138],
Cell[204918, 6226, 163, 5, 36, "Output",
 CellID->518725314]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[205130, 6237, 384, 13, 70, "Subsection",
 CellID->25443394],
Cell[205517, 6252, 150, 5, 70, "Text",
 CellID->144361231],
Cell[205670, 6259, 541, 17, 70, "DisplayMath",
 CellID->665977278],
Cell[206214, 6278, 459, 15, 70, "Text",
 CellID->62396675],
Cell[206676, 6295, 1141, 35, 70, "DisplayMath",
 CellTags->"DivisibilityHeuristic",
 CellID->553913193],
Cell[207820, 6332, 425, 12, 70, "Text",
 CellID->378839699],
Cell[208248, 6346, 199, 7, 70, "MathCaption",
 CellID->132044299],
Cell[CellGroupData[{
Cell[208472, 6357, 510, 17, 70, "Input",
 CellID->130101853],
Cell[208985, 6376, 163, 5, 36, "Output",
 CellID->438672421]
}, Open  ]],
Cell[209163, 6384, 245, 8, 70, "MathCaption",
 CellID->70005998],
Cell[CellGroupData[{
Cell[209433, 6396, 395, 12, 70, "Input",
 CellID->22152510],
Cell[209831, 6410, 573, 20, 36, "Output",
 CellID->183823068]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[210453, 6436, 109, 2, 70, "Subsection",
 CellTags->"ExhaustiveSearch",
 CellID->53756076],
Cell[210565, 6440, 911, 18, 70, "Text",
 CellID->1002419],
Cell[211479, 6460, 153, 4, 70, "MathCaption",
 CellID->19998089],
Cell[CellGroupData[{
Cell[211657, 6468, 567, 18, 70, "Input",
 CellID->118182320],
Cell[212227, 6488, 411, 14, 36, "Output",
 CellID->322514149]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[212699, 6509, 46, 1, 70, "Section",
 CellID->623839255],
Cell[212748, 6512, 273, 8, 70, "Text",
 CellID->56121441],
Cell[213024, 6522, 573, 15, 70, "DefinitionBox3Col",
 CellID->386408775],
Cell[213600, 6539, 236, 7, 70, "Caption",
 CellID->250020308],
Cell[CellGroupData[{
Cell[213861, 6550, 61, 1, 70, "Subsection",
 CellID->515843223],
Cell[213925, 6553, 880, 27, 70, "Text",
 CellID->455961191],
Cell[214808, 6582, 544, 20, 70, "MathCaption",
 CellID->619300757],
Cell[CellGroupData[{
Cell[215377, 6606, 349, 12, 70, "Input",
 CellID->558321853],
Cell[215729, 6620, 3368, 96, 122, "Output",
 CellID->579927017]
}, Open  ]],
Cell[219112, 6719, 260, 8, 70, "MathCaption",
 CellID->3757467],
Cell[CellGroupData[{
Cell[219397, 6731, 518, 16, 47, "Input",
 CellID->855882666],
Cell[219918, 6749, 2892, 51, 88, "Output",
 Evaluatable->False,
 CellID->328493184]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[222859, 6806, 79, 1, 70, "Subsection",
 CellID->226945663],
Cell[222941, 6809, 628, 20, 70, "Text",
 CellID->178502180],
Cell[223572, 6831, 473, 15, 70, "Program",
 CellID->41981489],
Cell[224048, 6848, 2162, 55, 70, "DefinitionBox3Col",
 CellID->97607950],
Cell[226213, 6905, 563, 19, 70, "Caption",
 CellID->244061410],
Cell[CellGroupData[{
Cell[226801, 6928, 106, 2, 70, "Subsubsection",
 CellTags->"BranchLinearDiophantine",
 CellID->210244652],
Cell[226910, 6932, 698, 13, 70, "Text",
 CellID->272817929],
Cell[227611, 6947, 153, 4, 70, "MathCaption",
 CellID->76836355],
Cell[CellGroupData[{
Cell[227789, 6955, 1775, 53, 70, "Input",
 CellID->184206951],
Cell[229567, 7010, 225, 7, 36, "Output",
 CellID->365383897]
}, Open  ]],
Cell[229807, 7020, 287, 10, 70, "MathCaption",
 CellID->158103086],
Cell[230097, 7032, 276, 8, 70, "Input",
 CellID->156762942],
Cell[230376, 7042, 173, 4, 70, "MathCaption",
 CellID->46009676],
Cell[CellGroupData[{
Cell[230574, 7050, 1718, 51, 70, "Input",
 CellID->813755251],
Cell[232295, 7103, 224, 7, 36, "Output",
 CellID->62385160]
}, Open  ]],
Cell[232534, 7113, 188, 5, 70, "MathCaption",
 CellID->280144831],
Cell[232725, 7120, 275, 8, 70, "Input",
 CellID->275242839],
Cell[233003, 7130, 548, 18, 70, "MathCaption",
 CellID->8676016],
Cell[CellGroupData[{
Cell[233576, 7152, 2127, 72, 70, "Input",
 CellID->26032968],
Cell[235706, 7226, 1412, 41, 71, "Output",
 CellID->236059578]
}, Open  ]],
Cell[237133, 7270, 116, 3, 70, "MathCaption",
 CellID->153486163],
Cell[CellGroupData[{
Cell[237274, 7277, 441, 13, 70, "Input",
 CellID->347114198],
Cell[237718, 7292, 1413, 41, 71, "Output",
 CellID->606836779]
}, Open  ]],
Cell[239146, 7336, 476, 13, 70, "MathCaption",
 CellID->935352015],
Cell[CellGroupData[{
Cell[239647, 7353, 2342, 78, 70, "Input",
 CellID->54773922],
Cell[241992, 7433, 1551, 45, 88, "Output",
 CellID->369465]
}, Open  ]],
Cell[243558, 7481, 91, 1, 70, "MathCaption",
 CellID->415724669],
Cell[CellGroupData[{
Cell[243674, 7486, 441, 13, 70, "Input",
 CellID->168220324],
Cell[244118, 7501, 1566, 45, 88, "Output",
 CellID->137349453]
}, Open  ]],
Cell[245699, 7549, 188, 5, 70, "MathCaption",
 CellID->161232824],
Cell[245890, 7556, 273, 8, 70, "Input",
 CellID->1530487]
}, Open  ]],
Cell[CellGroupData[{
Cell[246200, 7569, 102, 2, 70, "Subsubsection",
 CellTags->"DiscreteSolutionBound",
 CellID->251741464],
Cell[246305, 7573, 946, 25, 70, "Text",
 CellID->116102929],
Cell[247254, 7600, 370, 13, 70, "MathCaption",
 CellID->532458365],
Cell[CellGroupData[{
Cell[247649, 7617, 208, 7, 70, "Input",
 CellID->2562060],
Cell[247860, 7626, 570, 16, 36, "Output",
 CellID->33859634]
}, Open  ]],
Cell[248445, 7645, 420, 14, 70, "MathCaption",
 CellID->410099897],
Cell[CellGroupData[{
Cell[248890, 7663, 210, 7, 70, "Input",
 CellID->107995296],
Cell[249103, 7672, 278, 8, 36, "Output",
 CellID->401396736]
}, Open  ]],
Cell[249396, 7683, 146, 5, 70, "MathCaption",
 CellID->38584246],
Cell[249545, 7690, 271, 8, 70, "Input",
 CellID->256742475],
Cell[249819, 7700, 219, 8, 70, "MathCaption",
 CellID->126391429],
Cell[CellGroupData[{
Cell[250063, 7712, 210, 7, 70, "Input",
 CellID->179537443],
Cell[250276, 7721, 613, 17, 36, "Output",
 CellID->212508641]
}, Open  ]],
Cell[250904, 7741, 155, 5, 70, "MathCaption",
 CellID->137416699],
Cell[251062, 7748, 271, 8, 70, "Input",
 CellID->215389923],
Cell[251336, 7758, 265, 9, 70, "Text",
 CellID->318020393]
}, Open  ]],
Cell[CellGroupData[{
Cell[251638, 7772, 110, 2, 70, "Subsubsection",
 CellTags->"ExhaustiveSearchMaxPoints",
 CellID->522087212],
Cell[251751, 7776, 850, 18, 70, "Text",
 CellID->265392510],
Cell[252604, 7796, 309, 10, 70, "MathCaption",
 CellID->323752078],
Cell[CellGroupData[{
Cell[252938, 7810, 505, 14, 70, "Input",
 CellID->697229188],
Cell[253446, 7826, 445, 9, 70, "Message",
 CellID->112068535],
Cell[253894, 7837, 594, 17, 36, "Output",
 CellID->111353086]
}, Open  ]],
Cell[254503, 7857, 253, 8, 70, "MathCaption",
 CellID->34036973],
Cell[254759, 7867, 335, 10, 70, "Input",
 CellID->31570790],
Cell[255097, 7879, 206, 8, 70, "MathCaption",
 CellID->594974318],
Cell[CellGroupData[{
Cell[255328, 7891, 504, 14, 70, "Input",
 CellID->14719304],
Cell[255835, 7907, 407, 14, 36, "Output",
 CellID->351851860]
}, Open  ]],
Cell[256257, 7924, 341, 10, 70, "MathCaption",
 CellID->127505266],
Cell[CellGroupData[{
Cell[256623, 7938, 813, 23, 70, "Input",
 CellID->121435139],
Cell[257439, 7963, 759, 24, 36, "Output",
 CellID->350192174]
}, Open  ]],
Cell[258213, 7990, 491, 15, 70, "MathCaption",
 CellID->312691978],
Cell[CellGroupData[{
Cell[258729, 8009, 862, 25, 70, "Input",
 CellID->125977054],
Cell[259594, 8036, 756, 24, 36, "Output",
 CellID->93364369]
}, Open  ]],
Cell[260365, 8063, 132, 4, 70, "MathCaption",
 CellID->32904670],
Cell[CellGroupData[{
Cell[260522, 8071, 808, 23, 70, "Input",
 CellID->47013539],
Cell[261333, 8096, 313, 10, 36, "Output",
 CellID->222723506]
}, Open  ]],
Cell[261661, 8109, 78, 1, 70, "MathCaption",
 CellID->1134239],
Cell[CellGroupData[{
Cell[261764, 8114, 816, 23, 70, "Input",
 CellID->362688604],
Cell[262583, 8139, 314, 10, 36, "Output",
 CellID->160177472]
}, Open  ]],
Cell[262912, 8152, 159, 5, 70, "MathCaption",
 CellID->466500556],
Cell[263074, 8159, 332, 10, 70, "Input",
 CellID->507660]
}, Open  ]],
Cell[CellGroupData[{
Cell[263443, 8174, 108, 2, 70, "Subsubsection",
 CellTags->"LatticeReduceDiophantine",
 CellID->224006136],
Cell[263554, 8178, 999, 26, 70, "Text",
 CellID->8910548],
Cell[264556, 8206, 436, 14, 70, "MathCaption",
 CellID->31049335],
Cell[CellGroupData[{
Cell[265017, 8224, 784, 26, 70, "Input",
 CellID->364437364],
Cell[265804, 8252, 480, 16, 36, "Output",
 CellID->458440706]
}, Open  ]],
Cell[266299, 8271, 287, 10, 70, "MathCaption",
 CellID->46907727],
Cell[266589, 8283, 279, 8, 70, "Input",
 CellID->212854556],
Cell[266871, 8293, 219, 7, 70, "MathCaption",
 CellID->24002584],
Cell[CellGroupData[{
Cell[267115, 8304, 705, 23, 70, "Input",
 CellID->371731154],
Cell[267823, 8329, 494, 16, 36, "Output",
 CellID->69339472]
}, Open  ]],
Cell[268332, 8348, 692, 21, 70, "MathCaption",
 CellID->273907597],
Cell[CellGroupData[{
Cell[269049, 8373, 1623, 54, 70, "Input",
 CellID->294619746],
Cell[270675, 8429, 224, 7, 36, "Output",
 CellID->328925421]
}, Open  ]],
Cell[270914, 8439, 90, 1, 70, "MathCaption",
 CellID->39496738],
Cell[CellGroupData[{
Cell[271029, 8444, 463, 14, 70, "Input",
 CellID->497078689],
Cell[271495, 8460, 222, 7, 36, "Output",
 CellID->9661441]
}, Open  ]],
Cell[271732, 8470, 158, 5, 70, "MathCaption",
 CellID->473910087],
Cell[271893, 8477, 277, 8, 70, "Input",
 CellID->673711290]
}, Open  ]],
Cell[CellGroupData[{
Cell[272207, 8490, 94, 2, 70, "Subsubsection",
 CellTags->"MaxFrobeniusGraph",
 CellID->219054329],
Cell[272304, 8494, 1143, 28, 70, "Text",
 CellID->61907656],
Cell[273450, 8524, 599, 15, 70, "MathCaption",
 CellID->144101505],
Cell[CellGroupData[{
Cell[274074, 8543, 889, 29, 70, "Input",
 CellID->445335518],
Cell[274966, 8574, 2184, 61, 88, "Output",
 CellID->127955357]
}, Open  ]],
Cell[CellGroupData[{
Cell[277187, 8640, 104, 3, 70, "Input",
 CellID->436879321],
Cell[277294, 8645, 165, 5, 36, "Output",
 CellID->459289209]
}, Open  ]],
Cell[277474, 8653, 245, 9, 70, "MathCaption",
 CellID->179878890],
Cell[277722, 8664, 289, 8, 70, "Input",
 CellID->43113712],
Cell[278014, 8674, 316, 9, 70, "MathCaption",
 CellID->391323379],
Cell[CellGroupData[{
Cell[278355, 8687, 385, 12, 70, "Input",
 CellID->191183626],
Cell[278743, 8701, 2184, 61, 88, "Output",
 CellID->217515046]
}, Open  ]],
Cell[CellGroupData[{
Cell[280964, 8767, 104, 3, 70, "Input",
 CellID->656541300],
Cell[281071, 8772, 165, 5, 36, "Output",
 CellID->137154084]
}, Open  ]],
Cell[281251, 8780, 149, 5, 70, "MathCaption",
 CellID->9695292],
Cell[281403, 8787, 290, 8, 70, "Input",
 CellID->166922865]
}, Open  ]],
Cell[CellGroupData[{
Cell[281730, 8800, 88, 2, 70, "Subsubsection",
 CellTags->"SieveMaxPoints",
 CellID->307047228],
Cell[281821, 8804, 456, 13, 70, "Text",
 CellID->13883425],
Cell[282280, 8819, 323, 10, 70, "MathCaption",
 CellID->96205051],
Cell[CellGroupData[{
Cell[282628, 8833, 415, 14, 70, "Input",
 CellID->75200279],
Cell[283046, 8849, 505, 9, 70, "Message",
 CellID->457294284],
Cell[283554, 8860, 505, 17, 39, "Output",
 CellID->638088738]
}, Open  ]],
Cell[284074, 8880, 314, 10, 70, "MathCaption",
 CellID->833982335],
Cell[CellGroupData[{
Cell[284413, 8894, 625, 20, 70, "Input",
 CellID->56274466],
Cell[285041, 8916, 395, 14, 36, "Output",
 CellID->12914805]
}, Open  ]],
Cell[285451, 8933, 148, 5, 70, "MathCaption",
 CellID->350883274],
Cell[285602, 8940, 264, 8, 70, "Input",
 CellID->9058871]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[285927, 8955, 113, 3, 70, "Section",
 CellTags->{"t:29", "c:29"},
 CellID->73689979],
Cell[286043, 8960, 309, 9, 70, "DisplayMath",
 CellTags->"1",
 CellID->449015277],
Cell[286355, 8971, 480, 17, 70, "DisplayMath",
 CellTags->"2",
 CellID->5262274],
Cell[286838, 8990, 385, 12, 70, "DisplayMath",
 CellTags->"3",
 CellID->36916775],
Cell[287226, 9004, 382, 12, 70, "DisplayMath",
 CellTags->"4",
 CellID->434003486],
Cell[287611, 9018, 513, 13, 70, "DisplayMath",
 CellTags->"5",
 CellID->321539263],
Cell[288127, 9033, 199, 8, 70, "DisplayMath",
 CellTags->"6",
 CellID->442253592],
Cell[288329, 9043, 185, 7, 70, "DisplayMath",
 CellTags->"7",
 CellID->157765207],
Cell[288517, 9052, 751, 28, 70, "DisplayMath",
 CellTags->"8",
 CellID->906771487],
Cell[289271, 9082, 306, 10, 70, "DisplayMath",
 CellTags->"9",
 CellID->745879058],
Cell[289580, 9094, 237, 7, 70, "DisplayMath",
 CellTags->"10",
 CellID->441990865],
Cell[289820, 9103, 323, 9, 70, "DisplayMath",
 CellTags->"11",
 CellID->99664469],
Cell[290146, 9114, 360, 11, 70, "DisplayMath",
 CellTags->"12",
 CellID->594065443]
}, Open  ]]
}, Open  ]],
Cell[290533, 9129, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

