(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36691,       1205]
NotebookOptionsPosition[     31956,       1055]
NotebookOutlinePosition[     34148,       1111]
CellTagsIndexPosition[     34078,       1106]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"BernoulliDistribution" :> 
         Documentation`HelpLookup["paclet:ref/BernoulliDistribution"], 
         "BetaBinomialDistribution" :> 
         Documentation`HelpLookup["paclet:ref/BetaBinomialDistribution"], 
         "BetaDistribution" :> 
         Documentation`HelpLookup["paclet:ref/BetaDistribution"], 
         "BetaNegativeBinomialDistribution" :> 
         Documentation`HelpLookup[
          "paclet:ref/BetaNegativeBinomialDistribution"], 
         "BinomialDistribution" :> 
         Documentation`HelpLookup["paclet:ref/BinomialDistribution"], "CDF" :> 
         Documentation`HelpLookup["paclet:ref/CDF"], "CharacteristicFunction" :> 
         Documentation`HelpLookup["paclet:ref/CharacteristicFunction"], 
         "DiscreteUniformDistribution" :> 
         Documentation`HelpLookup["paclet:ref/DiscreteUniformDistribution"], 
         "ExpectedValue" :> 
         Documentation`HelpLookup["paclet:ref/ExpectedValue"], 
         "GeometricDistribution" :> 
         Documentation`HelpLookup["paclet:ref/GeometricDistribution"], 
         "HypergeometricDistribution" :> 
         Documentation`HelpLookup["paclet:ref/HypergeometricDistribution"], 
         "InverseCDF" :> Documentation`HelpLookup["paclet:ref/InverseCDF"], 
         "Kurtosis" :> Documentation`HelpLookup["paclet:ref/Kurtosis"], 
         "LogSeriesDistribution" :> 
         Documentation`HelpLookup["paclet:ref/LogSeriesDistribution"], "Mean" :> 
         Documentation`HelpLookup["paclet:ref/Mean"], 
         "NegativeBinomialDistribution" :> 
         Documentation`HelpLookup["paclet:ref/NegativeBinomialDistribution"], 
         "PDF" :> Documentation`HelpLookup["paclet:ref/PDF"], 
         "PoissonDistribution" :> 
         Documentation`HelpLookup["paclet:ref/PoissonDistribution"], 
         "Quantile" :> Documentation`HelpLookup["paclet:ref/Quantile"], 
         "RandomInteger" :> 
         Documentation`HelpLookup["paclet:ref/RandomInteger"], "Skewness" :> 
         Documentation`HelpLookup["paclet:ref/Skewness"], "StandardDeviation" :> 
         Documentation`HelpLookup["paclet:ref/StandardDeviation"], "Variance" :> 
         Documentation`HelpLookup["paclet:ref/Variance"], "ZipfDistribution" :> 
         Documentation`HelpLookup["paclet:ref/ZipfDistribution"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"BernoulliDistribution\"\>", 
      2->"\<\"BetaBinomialDistribution\"\>", 3->"\<\"BetaDistribution\"\>", 
      4->"\<\"BetaNegativeBinomialDistribution\"\>", 
      5->"\<\"BinomialDistribution\"\>", 6->"\<\"CDF\"\>", 
      7->"\<\"CharacteristicFunction\"\>", 
      8->"\<\"DiscreteUniformDistribution\"\>", 9->"\<\"ExpectedValue\"\>", 
      10->"\<\"GeometricDistribution\"\>", 
      11->"\<\"HypergeometricDistribution\"\>", 12->"\<\"InverseCDF\"\>", 
      13->"\<\"Kurtosis\"\>", 14->"\<\"LogSeriesDistribution\"\>", 
      15->"\<\"Mean\"\>", 16->"\<\"NegativeBinomialDistribution\"\>", 
      17->"\<\"PDF\"\>", 18->"\<\"PoissonDistribution\"\>", 
      19->"\<\"Quantile\"\>", 20->"\<\"RandomInteger\"\>", 
      21->"\<\"Skewness\"\>", 22->"\<\"StandardDeviation\"\>", 
      23->"\<\"Variance\"\>", 
      24->"\<\"ZipfDistribution\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Discrete Distributions", "Title",
 CellID->15659],

Cell[TextData[{
 "The functions described here are among the most commonly used discrete \
statistical distributions. You can compute their densities, means, variances, \
and other related properties. The distributions themselves are represented in \
the symbolic form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["param", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["param", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". Functions such as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", which give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. \"",
 ButtonBox["Continuous Distributions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ContinuousDistributions"],
 " describes many continuous statistical distributions."
}], "Text",
 CellID->4255],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["BernoulliDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BernoulliDistribution"], 
      StyleBox["[", "MR"], 
      StyleBox["p", "TI"], 
      StyleBox["]", "MR"]}], " "}], Cell[TextData[{
     "Bernoulli distribution with mean ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BetaBinomialDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BetaBinomialDistribution"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["\[Beta]", "TR",
       FontSlant->"Italic"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "binomial distribution where the success probability is a ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["BetaDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BetaDistribution"], "[", 
       RowBox[{
        StyleBox["\[Alpha]", "TR"], ",", 
        StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
     " random variable"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BetaNegativeBinomialDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BetaNegativeBinomialDistribution"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["\[Alpha]", "TR"], ",", 
      StyleBox["\[Beta]", "TR"], ",", 
      StyleBox["n", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "negative binomial distribution where the success probability is a ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["BetaDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BetaDistribution"], "[", 
       RowBox[{
        StyleBox["\[Alpha]", "TR"], ",", 
        StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
     " random variable "
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["BinomialDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/BinomialDistribution"], 
      StyleBox["[", "MR"], 
      RowBox[{
       StyleBox["n", "TI"], 
       StyleBox[",", "MR"], 
       StyleBox[" ", "MR"], 
       StyleBox["p", "TI"]}], 
      StyleBox["]", "MR"]}], " "}], Cell[TextData[{
     "binomial distribution for the number of successes that occur in ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " trials, where the probability of success in a trial is ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["DiscreteUniformDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DiscreteUniformDistribution"], 
      StyleBox["[", "MR"], 
      StyleBox[
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TI"]]}], "}"}], "MR"], 
      StyleBox["]", "MR"]}], " "}], Cell[TextData[{
     "discrete uniform distribution over the integers from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["GeometricDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GeometricDistribution"], 
      StyleBox["[", "MR"], 
      StyleBox["p", "TI"], 
      StyleBox["]", "MR"]}], " "}], Cell[TextData[{
     "geometric distribution for the number of trials before the first \
success, where the probability of success in a trial is ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HypergeometricDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HypergeometricDistribution"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["succ", "TI"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["tot", "TI"]]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "hypergeometric distribution for the number of successes out of a sample \
of size ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     ", from a population of size ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["tot", "TI"]]], "InlineFormula"],
     " containing ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["succ", "TI"]]], "InlineFormula"],
     " successes "
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["LogSeriesDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LogSeriesDistribution"], 
      StyleBox["[", "MR"], 
      StyleBox["\[Theta]", "TR"], 
      StyleBox["]", "MR"]}], " "}], Cell[TextData[{
     "logarithmic series distribution with parameter ",
     Cell[BoxData[
      FormBox["\[Theta]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["NegativeBinomialDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NegativeBinomialDistribution"], 
      StyleBox["[", "MR"], 
      RowBox[{
       StyleBox["n", "TI"], 
       StyleBox[",", "MR"], 
       StyleBox[" ", "MR"], 
       StyleBox["p", "TI"]}], 
      StyleBox["]", "MR"]}], " "}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "negative binomial distribution with parameters ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["PoissonDistribution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PoissonDistribution"], 
      StyleBox["[", "MR"], 
      StyleBox["\[Mu]", "TR"], 
      StyleBox["]", "MR"]}], " "}], Cell[TextData[{
     "Poisson distribution with mean ",
     Cell[BoxData[
      FormBox["\[Mu]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ZipfDistribution",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ZipfDistribution"], 
     StyleBox["[", "MR"], 
     StyleBox["\[Rho]", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "Zipf distribution with parameter ",
     Cell[BoxData[
      FormBox["\[Rho]", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->22582755],

Cell["Discrete statistical distributions.", "Caption",
 CellID->17804],

Cell["\<\
Most of the common discrete statistical distributions can be understood by \
considering a sequence of trials, each with two possible outcomes, for \
example, success and failure. \
\>", "Text",
 CellID->11852],

Cell[TextData[{
 "The ",
 StyleBox["Bernoulli distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BernoulliDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BernoulliDistribution"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 " is the probability distribution for a single trial in which success, \
corresponding to value 1, occurs with probability ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ", and failure, corresponding to value 0, occurs with probability ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "-", "p"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->10883],

Cell[TextData[{
 "The ",
 StyleBox["binomial distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinomialDistribution"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " is the distribution of the number of successes that occur in ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " independent trials, where the probability of success in each trial is ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->28645],

Cell[TextData[{
 "The ",
 StyleBox["negative binomial distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NegativeBinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NegativeBinomialDistribution"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " for positive integer ",
 StyleBox["n", "TI"],
 " is the distribution of the number of failures that occur in a sequence of \
trials before ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " successes have occurred, where the probability of success in each trial is \
",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ". The distribution is defined for any positive ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", though the interpretation of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " as the number of successes and ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " as the success probability no longer holds if ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is not an integer. "
}], "Text",
 CellID->6492],

Cell[TextData[{
 "The ",
 StyleBox["beta binomial distribution ", "TB"],
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaBinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaBinomialDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 StyleBox[" ", "TB"],
 "is a mixture of binomial and beta distributions. A ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaBinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaBinomialDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " random variable follows a ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinomialDistribution"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " distribution, where the success probability ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is itself a random variable following the beta distribution ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
 ".",
 StyleBox[" ", "TB"],
 "The ",
 StyleBox["beta negative binomial distribution ", "TB"],
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaNegativeBinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaNegativeBinomialDistribution"], "[", 
   RowBox[{
    StyleBox["\[Alpha]", "TR"], ",", 
    StyleBox["\[Beta]", "TR"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is a similar mixture of the beta and negative binomial distributions. "
}], "Text",
 CellID->10971],

Cell[TextData[{
 "The ",
 StyleBox["geometric distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricDistribution"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 " is the distribution of the total number of trials before the first success \
occurs, where the probability of success in each trial is ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->20420],

Cell[TextData[{
 "The ",
 StyleBox["hypergeometric distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HypergeometricDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricDistribution"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["succ", "TI"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["tot", "TI"]]}], "]"}]], "InlineFormula"],
 " is used in place of the binomial distribution for experiments in which the \
",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " trials correspond to sampling without replacement from a population of \
size ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["tot", "TI"]]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["succ", "TI"]]], "InlineFormula"],
 " potential successes. "
}], "Text",
 CellID->27964],

Cell[TextData[{
 "The ",
 StyleBox["discrete uniform distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DiscreteUniformDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiscreteUniformDistribution"], "[", 
   StyleBox[
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], "MR"], "]"}]], "InlineFormula"],
 " represents an experiment with multiple equally probable outcomes \
represented by integers ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " through ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16234],

Cell[TextData[{
 "The ",
 StyleBox["Poisson distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PoissonDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PoissonDistribution"], "[", 
   StyleBox["\[Mu]", "TR"], "]"}]], "InlineFormula"],
 " describes the number of events that occur in a given time period where ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineMath"],
 " is the average number of events per period."
}], "Text",
 CellID->31886],

Cell[TextData[{
 "The terms in the series expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", 
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Theta]"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " about ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", "0"}], TraditionalForm]], "InlineMath"],
 " are proportional to the probabilities of a discrete random variable \
following the ",
 StyleBox["logarithmic series distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogSeriesDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogSeriesDistribution"], "[", 
   StyleBox["\[Theta]", "TR"], "]"}]], "InlineFormula"],
 ". The distribution of the number of items of a product purchased by a buyer \
in a specified interval is sometimes modeled by this distribution. "
}], "Text",
 CellID->30993],

Cell[TextData[{
 "The ",
 StyleBox["Zipf distribution", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ZipfDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZipfDistribution"], "[", 
   StyleBox["\[Rho]", "TR"], "]"}]], "InlineFormula"],
 ", sometimes referred to as the zeta distribution, was first used in \
linguistics and its use has been extended to model rare events. "
}], "Text",
 CellID->20425],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PDF"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["x", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "probability mass function at ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CDF"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["x", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "cumulative distribution function at ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseCDF",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InverseCDF"], "[", 
     RowBox[{
      StyleBox["dist", "TI"], ",", 
      StyleBox["q", "TI"]}], "]"}], Cell[TextData[{
     "the largest integer ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " such that ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["CDF",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CDF"], "[", 
       RowBox[{
        StyleBox["dist", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     " is at most ",
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Quantile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quantile"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["q", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     Cell[BoxData[
      FormBox["q", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " quantile "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mean",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mean"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["mean", "TableText"]},
   {
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["variance", "TableText"]},
   {
    RowBox[{
     ButtonBox["StandardDeviation",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardDeviation"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["standard deviation ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Skewness",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Skewness"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["coefficient of skewness ", "TableText"]},
   {
    RowBox[{
     ButtonBox["Kurtosis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Kurtosis"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell["coefficient of kurtosis ", "TableText"]},
   {
    RowBox[{
     ButtonBox["CharacteristicFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CharacteristicFunction"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["t", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "characteristic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Phi]", "(", "t", ")"}], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpectedValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpectedValue"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["dist", "TI"]}], "]"}], Cell[TextData[{
     "expected value of the pure function ",
     Cell[BoxData[
      FormBox["f", TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpectedValue",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpectedValue"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}], ",", 
      StyleBox["dist", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "expected value of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"f", "[", "x", "]"}], TraditionalForm]], "InlineMath"],
     " for ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], 
     StyleBox["[", "MR"], 
     StyleBox["dist", "TI"], 
     StyleBox["]", "MR"]}], Cell[
    "pseudorandom number with specified distribution ", "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomInteger"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["dist", "TI"], 
      StyleBox[",", "MR"], 
      StyleBox["dims", "TI"]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "pseudorandom array with dimensionality ",
     Cell[BoxData[
      StyleBox["dims", "TI"]], "InlineFormula"],
     ", and elements from the specified distribution "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->294100013],

Cell["Functions of statistical distributions.", "Caption",
 CellID->11121],

Cell[TextData[{
 "Distributions are represented in symbolic form. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PDF"], 
   StyleBox["[", "MR"], 
   RowBox[{
    StyleBox["dist", "TI"], 
    StyleBox[",", "MR"], 
    StyleBox["x", "TI"]}], 
   StyleBox["]", "MR"]}]], "InlineFormula"],
 " evaluates the mass function at ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is a numerical value, and otherwise leaves the function in symbolic form \
whenever possible. Similarly, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"], "[", 
   RowBox[{
    StyleBox["dist", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives the cumulative distribution and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], 
   StyleBox["[", "MR"], 
   StyleBox["dist", "TI"], 
   StyleBox["]", "MR"]}]], "InlineFormula"],
 " gives the mean of the specified distribution. For a more complete \
description of the various functions of a statistical distribution, see the \
description of their continuous analogues in \"",
 ButtonBox["Continuous Distributions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ContinuousDistributions"],
 "."
}], "Text",
 CellID->11278],

Cell[TextData[{
 "Here is a symbolic representation of the binomial distribution for ",
 Cell[BoxData[
  FormBox["34", TraditionalForm]], "InlineMath"],
 " trials, each having probability ",
 Cell[BoxData[
  FormBox["0.3", TraditionalForm]], "InlineMath"],
 " of success. "
}], "MathCaption",
 CellID->4735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bdist", "=", 
  RowBox[{"BinomialDistribution", "[", 
   RowBox[{"34", ",", "0.3"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4559],

Cell[BoxData[
 RowBox[{"BinomialDistribution", "[", 
  RowBox[{"34", ",", "0.3`"}], "]"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->129491745]
}, Open  ]],

Cell["This is the mean of the distribution. ", "MathCaption",
 CellID->1789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "bdist", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25995],

Cell[BoxData["10.2`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->277726214]
}, Open  ]],

Cell["\<\
You can get the expression for the mean by using symbolic variables as \
arguments. \
\>", "MathCaption",
 CellID->18209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BinomialDistribution", "[", 
   RowBox[{"n", ",", "p"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27106],

Cell[BoxData[
 RowBox[{"n", " ", "p"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->466203586]
}, Open  ]],

Cell["Here is the 50% quantile, which is equal to the median. ", "MathCaption",
 CellID->8883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{"bdist", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31331],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->458315186]
}, Open  ]],

Cell[TextData[{
 "This gives the expected value of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "3"], TraditionalForm]], "InlineMath"],
 " with respect to the binomial distribution. "
}], "MathCaption",
 CellID->22060403],

Cell[CellGroupData[{

Cell["ExpectedValue[x^3, bdist, x]", "Input",
 CellTags->"S6.1.1",
 CellLabel->"In[3]:=",
 CellID->186209826],

Cell[BoxData["1282.547999999998`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S6.1.1",
 CellLabel->"Out[3]=",
 CellID->39352515]
}, Open  ]],

Cell["\<\
The elements of this matrix are pseudorandom numbers from the binomial \
distribution. \
\>", "MathCaption",
 CellID->21615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"bdist", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->6828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "7", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "10", ",", "11"}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->432653376]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->5367788],

Cell[TextData[{
 ButtonBox["M215: Applied Statistical Analysis with ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m215.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->368496230]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Discrete Distributions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 11.9064570}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The functions described here are among the most commonly used discrete \
statistical distributions. You can compute their densities, means, variances, \
and other related properties. The distributions themselves are represented in \
the symbolic form name[param_1,param_2,...]. Functions such as Mean, which \
give properties of statistical distributions, take the symbolic \
representation of the distribution as an argument. \"Continuous Distributions\
\" describes many continuous statistical distributions. Discrete statistical \
distributions. Most of the common discrete statistical distributions can be \
understood by considering a sequence of trials, each with two possible \
outcomes, for example, success and failure. ", "synonyms" -> {}, "title" -> 
    "Discrete Distributions", "type" -> "Tutorial", "uri" -> 
    "tutorial/DiscreteDistributions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S6.1.1"->{
  Cell[30346, 987, 109, 3, 70, "Input",
   CellTags->"S6.1.1",
   CellID->186209826],
  Cell[30458, 992, 195, 6, 36, "Output",
   CellTags->"S6.1.1",
   CellID->39352515]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S6.1.1", 33882, 1096}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3593, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4218, 91, 55, 1, 70, "Title",
 CellID->15659],
Cell[4276, 94, 1041, 28, 70, "Text",
 CellID->4255],
Cell[5320, 124, 6748, 212, 70, "DefinitionBox",
 CellID->22582755],
Cell[12071, 338, 70, 1, 70, "Caption",
 CellID->17804],
Cell[12144, 341, 220, 5, 70, "Text",
 CellID->11852],
Cell[12367, 348, 652, 20, 70, "Text",
 CellID->10883],
Cell[13022, 370, 617, 20, 70, "Text",
 CellID->28645],
Cell[13642, 392, 1177, 36, 70, "Text",
 CellID->6492],
Cell[14822, 430, 1936, 59, 70, "Text",
 CellID->10971],
Cell[16761, 491, 508, 16, 70, "Text",
 CellID->20420],
Cell[17272, 509, 961, 34, 70, "Text",
 CellID->27964],
Cell[18236, 545, 840, 31, 70, "Text",
 CellID->16234],
Cell[19079, 578, 488, 15, 70, "Text",
 CellID->31886],
Cell[19570, 595, 838, 25, 70, "Text",
 CellID->30993],
Cell[20411, 622, 425, 13, 70, "Text",
 CellID->20425],
Cell[20839, 637, 5664, 195, 70, "DefinitionBox",
 CellID->294100013],
Cell[26506, 834, 74, 1, 70, "Caption",
 CellID->11121],
Cell[26583, 837, 1433, 46, 70, "Text",
 CellID->11278],
Cell[28019, 885, 307, 9, 70, "MathCaption",
 CellID->4735],
Cell[CellGroupData[{
Cell[28351, 898, 165, 5, 70, "Input",
 CellID->4559],
Cell[28519, 905, 232, 7, 36, "Output",
 CellID->129491745]
}, Open  ]],
Cell[28766, 915, 76, 1, 70, "MathCaption",
 CellID->1789],
Cell[CellGroupData[{
Cell[28867, 920, 100, 3, 70, "Input",
 CellID->25995],
Cell[28970, 925, 162, 5, 36, "Output",
 CellID->277726214]
}, Open  ]],
Cell[29147, 933, 131, 4, 70, "MathCaption",
 CellID->18209],
Cell[CellGroupData[{
Cell[29303, 941, 167, 5, 70, "Input",
 CellID->27106],
Cell[29473, 948, 180, 6, 36, "Output",
 CellID->466203586]
}, Open  ]],
Cell[29668, 957, 94, 1, 70, "MathCaption",
 CellID->8883],
Cell[CellGroupData[{
Cell[29787, 962, 129, 4, 70, "Input",
 CellID->31331],
Cell[29919, 968, 159, 5, 36, "Output",
 CellID->458315186]
}, Open  ]],
Cell[30093, 976, 228, 7, 70, "MathCaption",
 CellID->22060403],
Cell[CellGroupData[{
Cell[30346, 987, 109, 3, 70, "Input",
 CellTags->"S6.1.1",
 CellID->186209826],
Cell[30458, 992, 195, 6, 36, "Output",
 CellTags->"S6.1.1",
 CellID->39352515]
}, Open  ]],
Cell[30668, 1001, 134, 4, 70, "MathCaption",
 CellID->21615],
Cell[CellGroupData[{
Cell[30827, 1009, 180, 6, 70, "Input",
 CellID->6828],
Cell[31010, 1017, 326, 11, 36, "Output",
 CellID->432653376]
}, Open  ]],
Cell[CellGroupData[{
Cell[31373, 1033, 96, 1, 70, "TutorialRelatedLinksSection",
 CellID->5367788],
Cell[31472, 1036, 430, 13, 70, "TutorialRelatedLinks",
 CellID->368496230]
}, Open  ]]
}, Open  ]],
Cell[31929, 1053, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

