(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     76786,       1655]
NotebookOptionsPosition[     71397,       1503]
NotebookOutlinePosition[     74734,       1583]
CellTagsIndexPosition[     74638,       1577]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Structure of Graphics and Sound\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphicsComplex" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsComplex"], "Line" :> 
          Documentation`HelpLookup["paclet:ref/Line"], "Point" :> 
          Documentation`HelpLookup["paclet:ref/Point"], "Polygon" :> 
          Documentation`HelpLookup["paclet:ref/Polygon"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphicsComplex\"\>", 2->"\<\"Line\"\>", 
       3->"\<\"Point\"\>", 4->"\<\"Polygon\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Efficient Representation of Many Primitives", "Title",
 CellTags->{"S2.10.15", "15.1"},
 CellID->24353],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Point",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Point"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["pt", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "a multipoint consisting of points at ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Line",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Line"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["line", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["line", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "a multiline consisting of lines ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["line", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["line", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Polygon",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Polygon"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "a multipolygon consisting of polygons ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4706875],

Cell["Primitives which can take multiple elements. ", "Caption",
 CellID->82696337],

Cell[TextData[{
 "Some primitives have multi-element forms that can be processed and rendered \
more quickly by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end than the equivalent individual primitives. For large numbers of \
primitives, using the multi-element forms can also significantly reduce the \
sizes of notebook files. Notebooks that use multi-element forms can be less \
than half the size of those that do not, and render up to ten times faster."
}], "Text",
 CellID->486791108],

Cell["Here is multipoint random distribution.", "MathCaption",
 CellID->1974459928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{"0", ",", "1"}], "]"}], ",", "2"}], "]"}], ",", 
     RowBox[{"{", "10000", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1730805049],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->389331813]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GraphicsComplex",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsComplex"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["pt", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["pt", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["data", "TI"]}], "]"}], Cell[TextData[{
     "a graphics complex in which coordinates given as integers ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in graphics primitives in ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " are taken to be ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pt", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->581485719],

Cell["Primitive for sharing coordinate data among primitives.", "Caption",
 CellID->1979885383],

Cell[TextData[{
 "When many primitives share the same coordinate data, as in meshes and \
graphs, further efficiency can be gained by using ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " to factor out the coordinate data. The output of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'",
 StyleBox["s",
  FontSlant->"Italic"],
 " surface- and graph-plotting functions typically use this representation."
}], "Text",
 CellID->674521816],

Cell["\<\
Here is a structure of points and lines that share coordinates.\
\>", "MathCaption",
 CellID->1569706955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5"}], "}"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "4"}], "}"}]}], "}"}], "]"}], ",", "Red", ",", 
      RowBox[{"PointSize", "[", ".05", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "]"}]}],
      "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[85]:=",
 CellID->228189290],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{0, 0}, {0, 1}, {1, 1}, {1, 0}, {0.5, 0.5}}, {
    LineBox[{{1, 2, 3}, {5, 4}}], 
    {RGBColor[1, 0, 0], PointSize[0.05], 
     PointBox[{1, 2, 3, 4, 5}]}}]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[85]=",
 CellID->1722038839]
}, Open  ]],

Cell[TextData[{
 "In addition to being efficient, ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " is useful interactively. Primitives that share coordinates stay connected \
when one of them is dragged."
}], "Text",
 CellID->741273690],

Cell[TextData[{
 "Because the output of ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ", the graph stays connected when any part of it is dragged."
}], "MathCaption",
 CellID->1034271583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        SuperscriptBox["i", "2"], "-", "199"}], ",", "10"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "22"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[111]:=",
 CellID->415090778],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.3604482126594895`, 3.2352896503184003`}, {
    1.0399109783377696`, 1.8746642428371403`}, {1.8080402802022109`, 
    1.618378145695964}, {3.7108387467490602`, -0.028565531727442917`}, {
    3.552587579504385, 0.8804721035498483}, {3.6440191889315807`, 
    1.8671763069684406`}, {3.007670842963741, 1.5551062298430287`}, {
    2.4676424693131658`, 1.8060511491602211`}, {1.5436265116580616`, 
    0.7924539281519156}, {0.6703764531611367, 2.7147364936854963`}, {
    1.6830756623440124`, 4.158834261768926}, {0.35189274299013085`, 
    2.0751349819684903`}, {1.829349139582307, 0.21288597564509312`}, {
    4.166473963918594, 0.57479300524558}, {3.4193456414199384`, 
    2.3183816155574615`}, {2.450826822519227, 2.165935022720443}, {
    3.0468496402199707`, 2.6579565889291987`}, {4.373382907471111, 
    1.3020025103686503`}, {2.3248148104912287`, 0.12026739003101847`}, {
    0.27137255141068284`, 1.3651783169649283`}, {0.8096081913188317, 
    3.7785065270004083`}, {0.4385278018787402, 0.6704977503186965}, {
    2.820280481425103, 0.21288597551162478`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {3, 8}, {4, 5}, {6, 7}, {7, 5}, {8, 7}, {9, 
       3}, {10, 2}, {11, 1}, {12, 2}, {13, 3}, {14, 5}, {15, 7}, {16, 8}, {17,
        7}, {18, 5}, {19, 3}, {20, 2}, {21, 1}, {22, 2}, {23, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2321097094255977`, 3.40668284068305}, {
     0.8256694903819679, 2.1317540283841123`}, {1.3938400701543272`, 
     1.3327228284215675`}, {3.439466195338378, 0.}, {3.2812150280937025`, 
     0.9090376352772913}, {3.3726466375208983`, 1.8957418386958838`}, {
     2.7362982915530587`, 1.5836717615704718`}, {2.053442259265283, 
     1.5203958318858246`}, {1.129426301610178, 0.5067986108775187}, {
     0.39900390175045386`, 2.7433020254129397`}, {1.4117031109333298`, 
     4.18739979349637}, {0.08052019157944801, 2.1037005136959337`}, {
     1.5579765881716243`, 0.24145150737253607`}, {3.8951014125079113`, 
     0.603358536973023}, {3.147973090009256, 2.346947147284905}, {
     2.1794542711085447`, 2.1945005544478864`}, {2.7754770888092883`, 
     2.686522120656642}, {4.102010356060429, 1.3305680420960935`}, {
     2.0534422590805463`, 0.1488329217584614}, {0., 1.3937438486923714`}, {
     0.5382356399081489, 3.8070720587278517`}, {0.16715525046805735`, 
     0.6990632820461395}, {2.5489079300144204`, 0.24145150723906772`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{184, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[111]=",
 CellID->6816083]
}, Open  ]],

Cell[TextData[{
 "Any primitive may be used within a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " can be used in both 2D and 3D graphics. Within ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ", coordinate positions in primitives are replaced by indices into the \
coordinate data in the ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1175550562],

Cell[TextData[{
 "This ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " combines several types of primitives."
}], "MathCaption",
 CellID->1666309898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"GraphicsComplex", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "i", ",", "i"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"4", ",", "1.5"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"\[Integral]", 
           RowBox[{
            RowBox[{"f", "[", "x", "]"}], 
            RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "36"}], "]"}], ",", 
        "4"}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Point", "[", 
       RowBox[{"Range", "[", "5", "]"}], "]"}]}], "\[IndentingNewLine]", 
     "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[132]:=",
 CellID->336215159],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 
   5}}, {SphereBox[4, 1.5], Text3DBox[
     FormBox[
      StyleBox[
       RowBox[{"\[Integral]", 
        RowBox[{
         RowBox[{"f", "(", "x", ")"}], 
         RowBox[{"\[DifferentialD]", "x"}]}]}],
       StripOnInput->False,
       FontSize->36], TraditionalForm], 4], 
    Point3DBox[{1, 2, 3, 4, 5}]}]]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[132]=",
 CellID->1414835530,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 " is especially useful for representing meshes of polygons. By using ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ", numerical errors that could cause gaps between adjacent polygons are \
avoided."
}], "Text",
 CellID->563911091],

Cell[TextData[{
 "The output of ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->86533571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], " ", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[133]:=",
 CellID->403599901],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytvQd4m9eVJowhqWa5xXYcp03K7s7uvztJZidTNrvZnew/uzv5ZweOS1zi
ONU9LnFsx3biJrc4LpJly7J6l6hKiZQoSpRYJPYGkiBIkEQjAKIRBMACgARJ
vM/uOefeD4QgOpPd59cDgR++cr97z7nnnPc9536A+WfPPPzA4z975pH7fvbl
f3jqZ08+/Mh9T3/5f/zyKdpV/Ccmk6mS/r9/k4m2/xdtyf9KAHQg7/0Rei+h
Q0X0t4j+/r3s/QW/L6OP8km/yzmmYvWZN6/W1/yFHH+U30sWj15+/lWXnfEN
+fNY3nlL3ef/7+t4zKbl+fuX7u8qeuOPpmW5s/SdvpGTEo+/WP+9Qv9V7Tzw
wAMm9a+w3a/J1c/r1ouNuxTrxnMSfVa3tyxPG9SqPu0v5e/T+upVMlZ1VJ3w
7+XPLUbrJYutm0yf0y1f+QlX3VrQ4+KCzzfoVpeSmIzc0EhuLP9ci5/SLS5b
qsVluR7qdv+4Nq+5RB+X7jd6yZtL60daX5w9uq1rdD9vLGij8N5/vtjGsvw2
uPeG3RTe94Yl+sXnfT2nySKtyCKtcb748wVXlRS0+u/k6p98wj0/W3B1ofz/
rVx9r77XV/6Ze6mz/wMWZ0eR7uFS9/7SEjLkw6rH37pU/ktc/2l9/p8VtLO8
4Lx/80e2dx0WLTJ//7/4Z9o3+v3VP/I+1+aPM6/dFUu0m//5K39k+1fp9r++
RL+LDVfwf9Huan39XxS0u7LgvMLrVPs8K/K9pdHaNwtaUxZfaDOiA9N39bWG
r+T3wuuvuGwc6tr/ru/3N7k2LpV8SYEPVlf9S33VFz7hzspz7+3jfezxryoY
u2rlXxfsvVFf+df677J9fZeM4cqC87+6ZCs3LNGnv9QtrpAW99mgw1Bhv5Zu
0fDChTPk6/pORXulVRktv5fI2/4+7DdulN/zRSn+K3290b4x7hJqr0jaUA2q
VxG1Zio5IE0e6If2mPn9+XKu1UI8wh//SmtzudH66lzrqqvUtFJXaT9KB7CU
fNQd/qxgrv61/lwicqAN+rvXSpv0VrzPqvap20jsMy0rlVEcHMAhdZ8rkedJ
JdoaPRat5dq1SrtFul1paxW1Sj2nFg/241A/t3vYjiP2XEzJ7/+fSvtfL2jf
mKlyG5bOHv5vVfZGf/nVq+7M2uYRsewO9MldbXzXwwN8Y7rr0UEcG1pSdure
12pZGVgjf5Ya416WJ8c9LDN+K6Fe7FavXuWPqU9Fe3vJtPdbuYWCvhy149gg
yobkLoV9+aLc9JrLfMKNeZKRaGr0ZI/qSTHdXnDxrh4U7+4ht0Sd2NcL1QN9
e9FB2aDWdXG5wxjfat3qlz7h7oblFnrKb+heFRm9IQOmF+nKBtlXskf0t7uP
xaNw3c5e7OzhF3dhZzeKdnWTKezpwV7p8AGjw2rGHx/EiSGUD6PCgVMuGBK7
BOfwh898Qs8NCzZ8H3uAIumi6u1eNl1+W7bHBtVZ+reLZxR11LR8Rw+2d+sX
HdhuQdEOC11CHd/dDdVrGdcqJV3qL3X2pAOVTpx244xnccatMF0aI7TH+aSe
53uHojxbYAfBXmJZwSiKWOasCxK2sAXq/45ebJcBbCM5b6V+L9vaxW1s6wK9
dnSpBkxX5uSuBnFiEBXDOOXAaRfOuFE9Au0JDDxXGBuW6v+V+GQ7EpdcnPNy
4vjZixbt79fziQZ0BWmExkK62Cl9296LbT08EhrIli4Ub+5Ukr96WycPZZcF
e7qxrwcHjeBGwzg5jEoHqlw468a5kSUtbimUtugNriiYPzyrlxm9px6z65ee
H1A9L6YRmFbv68feflD/d/Vx50kNdGhrD7ZYsLkLmzqVqExXf9yOTe3Y3I6t
HdjeiZ1dPIQDvUb/7Tg5hNMOnHVpSdb7cXF0cUZdhjrUXDI8WH6fc96fNqX/
y/aLmA5IdOGoJViHo4t40AHQa/8A1Eh2GyNRw1D+49qNnfioHRva8GErNrTy
sY9asbEVm9r0kGg8e7tR2ituZ0Bz05oR1PlwwY+GQG4kS/kWpYfP5Mmfz1qe
N5Z9OrgX8VBKVJBkd0uaoABWfNCubI7+HrDrseyRsahZ//lNFmzswkcd2NCO
D1rxfgveb8b6Zm7mw2ZsaMbGFmxuw/YO7O7iiaUQA2nl1DCrpMaDei8u+tEU
QGtIbm4w6kvZ603y4dN5WmHtcyzhOCxapMilX3p4ppJSGY+KxEUUOIsPk+Mu
OTQoEWWQhyR3uo6GtMuGHVZsFZf6USc+bMf6VqxrwdomvNeI9xqwtpEPrW/E
B008KJMCk6Jp0gtNsjNOHs5FH5pG0RpERxhdY0vGSjXDrtdaMey5pGCGLd+r
opHCAH2LGIBdjGAAisam4qMUj68/OqwldWgINK79duwbwO5+PSLSER36oB3v
t2JtM95twjsN+P0FvH1Bz1gex5Vb2rCzE3stWkUVg6hyoMaNi140j6ItiM7w
kravRnMdLkXYvGkgSIVwVGBg4FFMb0Uc38Vv7jXUdgnikGHmEEdR2bA6+6oy
B45JyD08DDXYfXbs6sd2Kzb34CPxzGtblW+QcV31+zq8U491F7GhCZtbsaMD
+4wxnh7GeZceoI7nvVHYYjnUVpSbeddd6pvp+j/P9wwlOb3xjBQwsUcsfTdH
wd1qrMX0V+YL4y2BFWrIarxHBCwyspBWy53kvU84cUICdpmTh01jpgHvHeDJ
uk1jgevebuLeqH+vnMMr1Xj1HF/yZg1+X4t1F7ChEZtbsKsDB8T8Tg2i2qmk
ubwjiJ4IbOOwxzCcyCGDyzyIod1clksf/bNLZEB2RzFHRVgDaTKmUta8qxeE
q3YJbCmmP6aVLIkeDbBIEkrzJAZ1/olhELiqcDJkKTrlJoM45cFJNzd+wo1j
TpaG0tlOG7aKfzQV8ds1b17E6/VYU4OXqvHbKrxQhRer+LLXqvG783ivHh82
YGsr9nSqa8TGat1o8qGT5BGGLYqBcTgS8EzmZsLSMrk8Bi7K5qsw+KVyswI1
OEbv1c5zry2Hf7WEKEpL3CLAtGwHYaXlhJB2CWba26Nxneh8RZmdER1tnRRE
RyCpikBSURWBjOLTI6gUsKFGdh2J6cCgniKbevBBh0yOBqypxQvn8HwVnq3E
Myfx7Ene/+JprDmDN89BY5oubSnnnWgcQUcAvSSeMQzF4J6AdzIfo9x4yUwp
KZDGlwz/sGyvQfkUpTQxBmOsq5C3FYJuFejidrYxUiTIuL0LOy0sDenZFSQK
wihH+qFEcVIcYJWARYJaRdVePTfO+gyWLnNjVekQ9tixrQ8fWbC2jY+tqWM5
PFelAJ/pqpcq8WY11tbhowbsaENpN4vg7DDq3Wj1oyeEgTE4Yoa/CEwbuKxw
lly/5CwplMvntQUtZ2ms2CfxShEABkb9HG8VzlmVj+SUeAjJbe1WmiYsV7RF
Y7mrdlr0lNnfuyik8kEtJAKjZz0M5NQIVteOLvoP9oleVIygzI2Dw9g9gK1W
ff/PPnMaT1bgsTL84gh+cRiPH+HGnj2BF0/hjbNYW4tNTdjdgSNiiTVONHth
CbKw6DRPAr5JhKcRTS1pUUpWKwxvgsWskUT5ApkZeEZCZm4isfsp3q9tiyS3
X+MxxsNFLMZV7I4NEKaAMIlPwUk1xqsUkNzSjm1iJTksebgPxwZAWJhQy2mn
uoVElxUXAqinVxB1Qb7irB8nvRp9fHpTL9a1403BDc9U4Yly/OIYHjyE+w/g
gf2884kjeKYML1TgzbNYV4fNTcgZXKNH62e5YxwjcQQnEZ1GLJVvcZI7Vpm4
y3N4l+xZVSBBg4sukYvZr3MxKzSklX+0QVCWgW0x/TWtUEAwJ88dIk816k9t
FNERoqXXR/TKg7NKpAxnrThsA8GmCoFiSpbFBMsbA2gmGFjUHKbmmiNoDONi
WEviK5U+nPDgoAO7BvBxD95rw6sX8NxZPFGBh4/i/oP4yV78aBd+upvbfOQA
fnVEy/b9OmxvwaFuLdsWL3qDcEThjSM0iTGSaxJT6UWsdgkzLjb2XpIpNObn
H86eFi0heyMTXJiXKc7Tg8r6qLMIih9UeaQSRuMlpXlQXGbtii3dDPGYSXTg
Q/FphMFNRYzCV35ggPBNcmCXgHBD4quqCYFLrCDRNwfRGkZ7BB1jaB/TMr++
Wey3NogqP467UTqMnQP40IK3mvFiLR966Ch+egD37MLd23HXVtyzTXbuU5Dc
tOqYlYVOs9kSwGCEJR6cQGQKiaQSVKEnKGTGV/zRc3x1gZyNrNuyHD6T/Bqj
6n1GHCXwxeLtZ35wyI7DKq9WRCyhiElC8UHhCIa+TdfmSALJm0iCgtTrhO28
KyRhXSPeF4bwUXNOylccsuJYP0/1HEOgQ20GQ1D4wzIOSwyd43yIZE4CPzOK
Ci/Pdu1/f3ECPyvFvXtw13bc9jFu24i7t/DZD+7BLw/hxXK8XY2PL+KAoJp6
Jzp86A/BM45gAuNTfGY6hdm8Wf4Hqg5/UOoF87tQ7iuRl4ndu5hnVLLfp/OM
pqty3FkTmwFO7RHiPzKIo4Jt6J15jcpPKE3sE0PY0XeJCta14j1iNeJmidXk
GM2Nm4RP77Ew8D3Sh3I7GPALo1EKIEZDG9Zx9MVgi6Mvgd44LHE5Oo4GrZs/
pUm/rR9r2/FKPR+67zDu3oVbN+HmD3DzOnzvfd75g024byeePIiXK/DuOWxr
xhFxN41udI/CMcZaoNOmkkgmWQsLM4tz1nRJNTvHsf6oWX9VgfSX4fJstYEy
OckqKIu1slqBblMusTnA0PuIkVc9PqyjJxEu0xXEPY4MM+A+OMTkUulgSw8+
tuDDDuWFrn2jVuOI39Xi7TqG2esbJNfRxtT/YC+O96NyCOecuDCCZr9Gg8S3
+mOwxzGYgJ1EVDQwQaDINqH9bEMY54Oo9OOgE1tteK8dL9TwoR/uw+1bcesG
3PwezG/h5nd4510b8fMdrIM1J/FBLfa0obyP+9Tp03NuRXQSE1NIJTGfRpZe
M4to5LI8kNLBClxawSq0lIJquvY5y/PytpxcJg7ERFAIYF78MHLMOTJIO5Uq
VH5bzf1i4kD0hwlhUTmxwWVECYkPHnUY2lAs4/02KCqokO5VLxtc8PXzePM8
3q7F+xe5nW1tTPIPW1E+gKphw893CHwh5kNMcCgB5yRc9JqCS/CtXZB+TwJt
MdSF2S+VOrDFhrdatJ+/zvwGzK+xKujD3Rtw3w48fQhvVOKjehzs0hDcFoB7
DJEEJqcwk8RCCkUL6cU1CZdpQPbmsohGFT7HNU1CofYye1BcU8S127ror5fl
8uQqVW6SPPkKEns+71RC12j4uJEoP+lCpZDNSg+YeHpQ4cFxl5b2yu19i6iZ
yNRrdXj5vFjob07THV44jZer8NpZvHUea8Vp7GjX2lxFBtAwgvYAusX75Jim
d8qYpe5peJJwJflw3yRao7hgYKAVm/vwZjOerORj39sI87swv66grenKMuH3
HV4MhhCIYWIS6WnMJTEnqBHi+pfOrl2Vk3Th3JZ5SsIu2bfIWo1MueT7c23k
8v3FuXy/qYiIm9CqHRbksv37dLZ/9dEBlElpghPlTk6UE4s9I3iE3qsMhlJM
gi9zLc7s1cRJiL0RtH6rCcTeXhQWSyc+XYFnyvHcSWNOKvZ2oh9nDPbWLSlG
Zq8JzV6DSQRTCKUQTMOfwkhK9e3zDRGc8uKQC5v6sOYiflHBJ5vXwvwqzL+F
+ddZ8294z81v4fvr8eBO/PYY1p3DvjZUSva/PwBfFLEEa2B2Wvt2UkNxNmXw
xdUF0r7qktlu5MyNma7A+fI8LeRm+XKa+ooZsqCFGRZt4+zBVgu2dukXHSIG
nV+pUCl+ZoZDXGshWlOlmKEX531qjqw+51+c5SrpclA4JGlgQxfebdWc+epf
luGp43i2XJNB2rWxkTNOh3tQMYDqYTR40BmALaJx1+gUIkkmg9E0ImmWfSit
tf2F4WlGQi3jOBfEYZE/hd0Hj4n834T5haz5yQXz4/Pmp7Is/zdw14d4dDde
OYENtThi0a7GGUZoHEmBPQtJFLHYi0kBSM7nPEuhF79s/htrJ5blV1pYAbrK
ovKXKrt/ealC0cutQi+LNhncfGunFCksbAuExIkIHREiRUpQ3JJrRZ68vOyK
2gBqAjgfwBk/T8njwsyVL7nh981YU49nz+DJk8wtadeDpXjkIB4/jKfL8JsK
vCaG8XETJ7sIilcNsiG0+WENqd5f45tAaArRJOJpJNKIzyAhQXF8FmHZcKcw
MAWCpJUGr73+Z4cXrd78WMb8UIY3ngPFgHs34Jf78OYp7GjESatWhk84xNw0
T3+G/UhmMT0nE0zPdqlk5z4ZsbYElzKlfQV1l/25uovEBWamnFPMVVzyFSLz
9Brioxvb8LFQoVzFaJdFKl5WHBVNcLnIuchKVzQE0CjBsTEkdDSE+pDB8I/I
iVusWN/JPP+F8/jVKTx2HA+JhH66Fw/ux6MH8eQRPH9C62JTE/Z34YQN5x16
xl9jH4NHQCcx0fEkEilMzyAp0p+aZX1MzCKe4Y+eaX3NyroIjnrwcR97v5/v
FeN4dsH8yIzyrObnccsbuH8jfluK9WdR2q41Qe/RGGYmWRPTTLamF3i6T80s
YRPin5ZYWVOAQbWuclV9nY+RrELx4tILyZhwAmEVkdhSeZmkREbayhXHVGwt
UUx2QxsXlIo+aFHh7aMWfNzKpaRtHdhtwf4eHOpb1NI1RGPrfYuFpLaIgPgx
tMhGYwR1IVQH2ICOuAwGQoj+tYt4rhqPnsB9h5ha0d57tuPHO3HfHjxWimfL
8Opp3asrzw+j1QtbGG4haeEpTshMpJCUuDo7i9QsimZITdcmM5gQdQVn4Jjm
LtQEUTaCTTY8dx4/lvSE+fFZ833T5nsS5h8nVxrD8EeQ4Mwi62Y5VGZxKoPJ
NMXyJTR0xaKGlljZmmPSup5UtEStLG/VyqW1MiLDUibj6y9lwH1calHQ3yRF
pfXCgNc2cYFsnZAwRX83ty0yYGVWiv7We9EoBbJ2ob+WqPJEK4n7to8z2CFl
kber9OG4B/uHcDUfvWJdLXa04lgvqgfR7EFPAMNj8IvVxKd1bSgzg/lZeWUw
m0FSdJCa4/dAEr407NOCpMQXfNp855j59jHzj5Lmh+bNz2bveRuP7MAbFdjd
jOp+bS/j42wspAlMc7TBZIY1LsrIeasrF7WwiGC1Fi6p9Ws9lMjioX3WfCZg
Kskv8CnUo6jwEVbCkSEda1Rtb29ebY/UsKGTm1Is+J1GFL19UeFkwUrbO7Cn
SxNg2lnlYAJ8wcs1SpWB0P7EKkWvvjh64hx+uygCE+yMqPt+Yb9E/XfaOOfz
xEn8pBR3bgfBT9r5vfX4/kb8cAse3INfHxX112FPO1OvWgdaR9AXwMg4wsLo
ppNIpZAR+lu0MAvT1ZlZ3k8Ky2QwIwqLzzL1oI2OGE76sNWOF8/i/k0qEtxg
NofYeh7O3PIcHlyLl/Ziwxkc7dT6ioxjKoH5KWU581pfiQnEo0vYz6o/aD/L
DY3qNVKyTEr5gtWkvYKirMpd0LFjQyjT8bmIK5Xsu3LEeQ+pTYjzxi4pxCwz
LGT1u/V4vwEbm8F0uROlPSiTSVjtRP0ImvyGnnrGuFw3EBeybDL1J0CEmeiy
HP0iodZzAabLhyQwvduO357HI8dx9x7cthmkKvM7zJVveR93f4z7d+FpiVMf
X0RpF07aUO+Axc/JCtoZM1JG84zMmCmvyIquICZGepvLYH7OWPMWmYV9ArWj
qBrFdoO5Xmm+I2Qy/hFMuP1FPPAhXjiEzXWoMlaYqHFhKoupBUzOscLiCb7P
eGgJna38gzrLrem8ipg20TxmegLGWGFWlOYVGYlh51ZxLS93gOg1vU7Qu4tr
rsoGVe1sz4DBxN9vMwKpsq5XzmHNObwmzO+tGqyVYuuWVtagSnhoxERszxJG
XxQDxK7jcEwwwaYDil0PTjHE6p1Ae4xNjjzfIYe2Nz3fFK/+3u/w/bW4ZyOz
62ek/LK5AUe7cd4Yx/W+cYxLw7Mpzm8sGCkOzPDG/AzbndJiNsORn+DFcAze
lCGH3UN4uVo7JvM/eszfcSjtmh/O3rUm++CW7JvlKG0zuDKJIJnAHDlIUh5p
LpHUmosGEBnhUwy2Wbh6+k8uwXuFWcWc5eW4+07mkszdl+8WIq+4u1KnYkm6
HKqqxUzcS3K8vdytUSTpcYctL0NC+16rxyvn8cJZEG3/7Wm8eJpbeeMc3qnF
Bw2syT3G+q6V9R5mkJYQrGPoj7IauQQ6pWbKCo9wdncSjiQrs2McjWP6ymVr
O/CbajxwCLdtYsIu4dC0qn4YHR4MBhGOc0KEdhFPn09prkhGdy1pEOks0gvZ
GWYt2Zk5zLLWUrMcjGzRha5olrDoPgfeqM8++MGMmrPm/2jXFidxbrUvzENO
J5AlRU2QllIs6VgcY4aWCm2sMMeltGU8WZHLSjLHt6BgNZ9SjrLpwzYQxefV
fMIwaZdazVfEHL+4aiQ/AiqcQOr5uBvrO/C2pM9fOo/nz+DXp6CYvRrP3k4c
taJSCkdNXnQFYY3AHoUzjhFVry8iUm/6Em0QqQykeXoTrXdIOoUsjBzkCbn1
2k48e45z6rd9yLkrnvLPZG9+EcQpb1uH+7ZLVD2P/e04ZUWjE8Tp/eOITzCn
1/WfFE/W1AJS89kUE5psagbp2SLMzInwE9NzU5n5yMx8W3junH9BshI3mP+6
j2/1g+StTy/8fG32t6XZXQ2ot2vHMjaG+QnSk+DyeAqEQMZGEfEiNGy61GKM
J7gWny3JPYvEfL+YmOa2rkXktlqxfgLNRHOO21ExpBcn0rHqEWb9+rwa/yX1
YKL9R504MISd/djUg/fbDfz0xDHm/KylSvzuHN6vx5YWpjZlfagSYySa2Rtm
zbgEpnEB2OD80qtIWueAvWkOYt0JtMZRFdD9uO6ls4YjepmnO1P+X+PmV3Dr
Wjywgw99WMN8v2YQPT4ovp+aQk4v/4aoPkFAFiMh9GQKKXpP8sc0s52ZmZng
RNo7wSfUB+aPe7LrLdlHNs3ynb7Zye/fDZrvTd/+/Nz9H2ffrsBxgRiDIpvZ
BBYEznDdMBrFWAhhH38c7dc6Wio2Fed0VciyFL/Y0gG1CNMktXvODNig0jOk
qConL79czArUBVArr/OyApB4TZnbiDbEa95o0MIjMvrwYTxYiodK8ZhE+99W
4PUzXBLd2oIDFpQLzGga4QKdjgJERgOTGEtyuXkizQRU+ThCZtFZjM2CeI0n
xeWSC0EjMv6mFvftw23v6DZuoGhv/tWC+SXcsZbbf7UcWy6ivAcXhtDpxkjY
yAiQIDgrA8kJsJfDVKoIU9Omf4HpSUzFeQ9tJBlyZ9KsP1csZY3M2uKo9PK8
eGYzhxzzX7aKzkK33pd+9NXZN3fO7apZOC8QIxbVZV8ksjwiIsBkZOERUZh9
Kf+Xy/PnLEtyc0xEcgmETW2LywRUQZu0pczK0FEJ17ODaArxq6iJhnxTQxgX
QlozFSM44uTFKJutnMt8/SKelxn/8FHcV4qf7GFa/9AB3vPccbxeBWJAW5tx
sBun9AqpldYQHOO6iB2VIjYxxaTSVhGFdlMx4d9EBuOZHMqf5MriYQGHL9Th
x/txy++z5ifnRIfLzS9mfyDaevMU9rQwQpOrvjoWQ2oSWaUtUpVOGsxichqT
E5hMYGJc9iQwOYapKKb441wynkxOpWdm+iIccepGsWsILxzmbfNfNPG7OWp+
dOYn7yy8dAiH2/S6HhJcNrHAeajxBMYi3GzQCf8AvD2mvKxoXiV+absSjfFa
u/WyHPXDZqgEwpZ2rbGDuk5g1MFrJYFAe5qDaJM6ePsY2ow6+BVNY7IQwWQi
dHbMBSJEW/q4JPjqRTxTpSy45J5t+MlOPueZo2rPZ06LW+8ahT2CkZiUvicR
m8a0uEDC0LMCxuaE+0wL/ZmaYwtzTKKHWFiC4bSu75gfFtH9cEr53+V1g7D5
4QnybCbGk9Us+AZMz2FyBhPTmIgjEZWJH0UihESQ1MMfJxhYz09HJyditJFI
zjb5U22h7CFnViOIr13UspWIdYU3wBY0H1/IkgcYn0YkLGrxwG8jteQiD2P5
JZGDkcfLX9fDn682cJ5aXasK54toYNVRG69a4lWoHlyQZbV0iCirRWulqJtI
63Kiqu3jzFZpT3WAa1Mqx/zqBTwlcO6He3DnVtzyEe7YpLX5uV8dxppTeF9y
CmW9OC9G2xeEK4pRmnaTLD3aM5NGhjCzEB7WV0a/ExBLz7FlhWcwrBFgySEJ
pQ8dy5rfyqhIav5BwvzI3C2/xU8/4EMba1HejQt29LoRiiA1wWsGp5VfwZSh
tEQccZn2sQDGfYiNIuYXHY4i7lP+eX4qGhgbjyaS3jiHr5OeeRnxteb/7Lr1
3onHX06+vXu2tIGd42gQszFWXmacDGqa2wmPIuCGjzRnlbW5rAtZfYPcg8bq
0edlBs7LxbHLq8/GkyEKvW2Wevs+C3MfYq+nhnDOJbkGP+catAca50p7fxy2
BKxxrrf3JNAZV0dvZONyY/cgPuhiy/rlKW7w9q0wf4Cb13Kl/faPeM8vpcS7
3ijx1gq2tIfhi+nVFCrPsGDwHeSIK3tCVuNn5uaQUjm6WQxN8+qtI6K/pypw
99uz5h+zZZhvj5kfnCHSyt7yKHY0oLoP3R6MjrGWOIuqeo3JBck0EP3hyxAd
RdSH6AjpTz66Me5G1ImYmz5m497sZCg7zWfOz8x0BdJVnlm1ktf8//rND6bu
f3v+7WOolPRaJLQQDs7p8DU2jnAIoy74BvijuwPOFsOa6JTCVXLF/2daFD77
Rg3eqsU7dVwq3igQPFcqPuNArdvAiF3iCvvHMRjH8ASG6DXJljAoALxvwuCj
tWGUe9lZbuzhVOuTSp8bccs63PwWbpGq/b1b8Nh+vFKBD+uwvwOn+tFo3GdZ
KIH4FKEBKD6r8hDiX1TlvogNcyUZaDaTVaY5OQvXBK/n6JvECvED5gfn7lgj
Ua0ChzvY/vqN9QCfm2fuKnOD6SuFUKU/PyIeRNyIOETuLoTtiAzJ9iCrcNw5
E2X8MBEbu+BgY63xzxx1KKu/zvw/Qz/4VfLJTdhRgyZZrxINLRgqpFgdZPvz
M5qHi1TYhmH2tuw9V/5faFD56au1BuUI08sXz+CVs3jVWPC8QfKye7twRK/G
XsFsdhRdwmbpM7FZJ2vNY/BZxxSnrsky+kSl9WFej6Sx3lOV+JGUHHS+/gcb
8bhocEOdfj5lIATvOGKTmJ5ChohXEfPaT5ukCM0vnZTIZmdYbdnZeSK2ZJup
THZCFFnnW2gew1Gpvz+8VcpL3x5UOvvs3a/xGR9Uo0LYZv8IYuOYmUB2CpC+
Ii6ObnwMY37WYki0GBpEyI5gH8KD8tGGUJ+uqSPqGPW7MBGgD4nEeLt/8qw7
qfPdt989/tQrU+tLZ08I1JuIaJ62MDaBcBiBEYw6xRq74GzF0MWlVvz9QT3m
rf65UmtxOYwa/fOn8NJpXkfw+xpdMz/Wx9S3xgWivp1B9EY4F0EHPBPwTSmb
GCWBLwukuJxN1NedwrBRNVpVE0KZB3uG8G47njrD+I9F+yrMz+ua+RWbLhoZ
JZPJEUEojqkpzJABJhWHSQvjzRLpVTMvm84gnRHGuyIreYnQ5HwiszA0MV/t
nTvjN+aM+W9s5pvHZJPfvnSuDwNeZrdTcaTipLksJgT+k71HI4j4EPYgKDYX
tGPUioCVt/0WVuGohbcD8h5hzuXzuSaj/rqhoIkfGplU97j20Xezm05rC4kE
M/FQmnUSHkNQ/PKIFZ5eONiHwl77f6q3S+xvpdZcjs2tVoyYtvZ1gXR2ehC1
LrT4ZP14FE5j/fhXgwSnUhijVxrhXCXcZPLKO3HilnGcDeKgCx/1cm7uYVXr
+41UwZ/l7e+v5/r36xXY2oDyXk5U8OVRxs9pQTELKciyg2VILiA5p3pMjJhX
JKRZm5IQmpnJzMykZmbskbT07EuVI/Mm45/5r/rMt8RueYIvXnMUh9vRaIfN
g0EPYX0mw1p5ZPFEhsdGSXkm4cPwW+HvwWgvf/R1wd8Fb7vMUvjaxVPNjPYg
bAt62Sr7Pd7JmL/WGTV/vfmO746o6uhRQRXe0YXpSAbRFKsnOCr6s7H+hpuV
/tBfbWjich0a359hVJYLcWqJ1p88gXkd7X/0EH51DM+Xc9H2vVrugMpsnBmS
pQyj6BdH4JEkvFrXXhRn28gvoEdmEJrVT9q0jeupsnMQrzVygVj2X23+Rcb8
BNvSne/j8b1cOd/VjNN9aBXfF5CrMtOQNQxJfviTeLKsYWAOMSX5jGSSmJfe
SE4iNZWenqKPqZmUNZz0Tc3bYihz8yVPvscGaL4tcdvT7FLXncZJCy72w+ll
E8zIWAjV8nuUnGcYIbdocQC+HnjF2kba4e2ER2zG0wJPM0aadawmhSLQRVtu
lz0yOqwRgPkbPXfdFXn+9cktxzM1koqfiWYRndEBcdQNrx3uHjiYv2OA1Hge
faf50hVLanKpJ085dl5vRL4HD+DxQ3j6GF6pxDvntebKbahx6Mg2FOVqe0AS
ODGj2q4r8cRpJ2YZQxC2j2VYe7R3KAnSHkFTMsK1nXikHLd9lDU/Naezu0SZ
n9qDd6twoB1njXVkxeMCEJkzSzX3m5jWax5IaZicxBQnNDAh9GxyHJNEmmOY
Zt48kYhl0tPTqVRXgONYa5jw08JbZ1jV5rv4qse2Y2stavvg8PKltCcZBRLz
RCy5tbGQOEcH/P3EzjDCySy4W+Fpg6uRt50X4W6Ci1EHXBc0hp12tWK0w+Ow
ZsO9LXYX3+xbw7c/MPPsByiVZYOJCNl1Kh0WAxwdgW+I1MZNDDUptRX9QZ0Z
rO5Gg/Pdu4OL7E8cwgvluQr7kFFhjzENC0s8m5SM+MwMU+UZsiZG7yUpgy2T
npS8CaaQp6zw5djyvRPad8nnL14UiheIYiKBBWHLUtXNZTKSfCAxjoRiyGOI
jzJnnhCqOxEkyD4/NTYeY33Fp1JNvqnhWLbWn1Wt3/RiKY60awN3ezEXRzZO
+kjzxREOSggqztWjleFqhrMRzgb+6KiHSzacF4rgqNGr89ysn6SnHaPtClf+
9J8GH34+9V4pqgX3RALS93Ccpe0dhtuqlWG/ANs53u45uYRGVMY4l/HSad7P
GXHr6ufK8Lsz3P5BC04PoEGWLw9F4CPkOsGpCzqUFlpczNj7c5lZXbadNWix
Wvpgn9CwkWjxe514+AA7IPOtYfPP0uZn8KO1eKYUH9VwRrBZ2FtknAnxpXx4
lilVgiiA6CQuqiBKHBeBxrzMhxH3itUvTIYDkXA2PR2Ks6F0hwUz/mfXzfdP
KaR/uhuthCNGkYln52Nz2dgMohMiQD8CLsWHxSBa4GiEQ4xjqBbDdfQu2+cx
yAEGg2cxeEbNubGBBngkVaKefHn1nckD5+e7BDtlx7OZUCIzGmTRe2xaN4ON
Od3AcoIvWr6kfq7SXk2+5+nzdBpR3zs24r5dXGJ/U9YRHe7GGTsaXLD44Iwi
ZCwvN3GeVHivUN8FVe2Tai2ZDr3PLdZsM0zY6uVRg11D2nK+c/PTePg9vF6K
HRdQZYVFvn2B+a5KeasirdJNPI6Y6IYYU9QrGxL3xz0YcxCqlm1nNubKJnxZ
yTqRkofDE7Vu9mPm/8Zh/BcbsaMWF/ow4sN4aCHoy2Rjs2I30vKok+guqUfs
owXDDRi6IGqoYfUMnOXtgSqtG/sZDFSqeAt7lSkPspn/zqHqwgnCgf7JbCim
A5DTgqEWDDahz9BLd/kn66XwW8Q+a0Sd772N73+AH2/l1edvCOY80o2zdl7/
oHhEdEKvPGdtSFnWIEGsqzlRVK4yOz+nKyPhWTjF/xEV2mA8YbX8lqfx8w/w
0lHsa0HtAOx6Lf0qoxK7IBFsmtQjKglizEv9j7hVVSI8TLwWoX7FaGn/gGl5
NiIphdgIEqM9bv9Cclxa/FPzP7HSXt6HY23oHET7wHzIT7YjEGFMcr5kO35B
6e4OuNpZP4N1oopzsJ8XRZ2D7RTsoqj+StgqeKOvPJdj/5T5a3UP3mV/7JWF
7ZXZTsmXTgZn2fmPBljQrh4Mt8EukavvnFaQrDhbUkPXFuz9nMQbsyQAfvAx
flmK1yuNldhdPl4pPUpOn1DTtK69Qlen+G/JglRgs2l2tUVZ4jjFRFSRyc4R
S1Uack5icIoXlxGpevNUSrOdhzdk36qQZSlq3c54DCmKO5OK57ByRNxxVSlH
2InQkEZRARuCMtsDvUR1qB/BXtNXRG+26YCdzMnEYNgXkTBvvosTFu+ewMmO
bM9QNh4SOh1NYozCZ0jZj0mxU1GOWMt5gsroP8PbttPoOwVbpRqxtVyxGusJ
9B4z9HMD3+Zvux96ILh2y1SFrH9IRoAxLqLB52FJOzoN/VSj5xQsbEBoP2y6
/ClgpaNPLaEjyWlfcaIXNXZ0jcAzhmiC1+9mkot6kRXUV1xeb5XAwz5jYXZO
SXF0Ej1jBuAeyipu+5mT3bBIkm8yhrx6uERp0hDXw70IicAC/Rjtkw15J9pJ
6vB3KjnR32UYZagb9NgwNugZcSq9f+GJ9dhTp+8b8M6GvUlOJocjCIh3VIzT
2YYhQxO2s7CJo7KeJE3IRgV6ykgF4o3KjHm+TPyl5+Gn05vLFtptxgrGlD8G
v5iJowuDwoSs1eiVFjvLSAdoKzUZmrxMD9flR5nP8B1ewC1r8YgsUNzRhFNC
Q4bIRKK8hmpGgr9ewJ4CZwHyS6zTxD7S1HJyWs2iVDKbTmVn1KqEEv/kQmsw
2x3lFZiy58u3v7Dw2A5srkW1FTYpyE/FMcdUUpbaxVNSWg0iMqp14u+Dvxe+
bt72djCbpPcR4Q0jrfC2wSu0hGjIqAXBHlW3IQyg1FHejs6BbK99NhGY5fXO
4SjRSMXB4LFq/jFYL0oR2+irRG8F6UWEWg7LEdG95fBlTyuWmP+CQcBLazMn
WjTbmwmmEBjDiFNHGXsDWVe1urLrBNtGzv9dppXCb4SUGPMF1s6vs7e+jV+I
drg8Z0OLE1YvgpIAmpsGEUStnWSObKQ4ezo1RXwDk5LclKoqpuNIJpSvymTm
/JNzDaNzBmO7c+qhF2fW7F3Y34w6Gxx+wd9xRQ4XFiuoESHhgUHWi7cbI136
KV0miC6u7zE7dBNCkm3acF+cd/O8n2ZQKyX2f+Lc6foTqLZkB53ZdGQB0fSk
T+LKqFBPzs+IYuz1TAyVYnpPkqR6ytV3QXUfR9cREethdB4U4RvY1vzt/qef
CurnB+ci2bnReMbjgauPZUvQre8864QvLVfeCi37ltCKqmF9egmtKF9z25t4
XNaKMP8zLLOYfPvsVI7/qcylQTQmuDKnSqbkiSYimAgxAZwUgDs1hiTH7Zgs
yvYnZut9sijhnqmfvDG35lC2rAOdxlNbn0sT0UhkpVo6gei4XoZA3M8nOvF0
iOjFLPK4Br3Ldh0ctUQ4eNtVR+pRKyyfXoeDDWjvJ2ScHR6anhyVJAMzPslZ
Ozu1Pux16JOo3lOB7hOwlIl9kDJKtDra95s0/7jB/LXym78bev611LFGNu50
GAlvfN4XgofbZKn21aD3rGEeotCW/WjaY7r8O0eUPgq/i/WzRgxZUW/URaNj
i0xP1y0Et06zBuJRXWaLhxDzE6dAPKA8ZcJPU2gyqLxGOD6VnUkHErNSS7ia
zEDKoBkug44JeQ+NIDDM8h4Rbkf8gbido0GzOMKoRLcHz8k4hs4pBCYUAkM8
3HlHnbK6t/bidAcaezNDDjHccByBUfgcmjsMtzKvI6nnRG45LtI6Su12HlYy
7yR3zzNYcmDX3/IfWp550r1+d6ZJlsxNjqazAZ5YC44eFptNYFp3JQu845gI
/IAS+CdI/DNL+SVeZUWU7o41eHwH3+VYF2r70eNGiKbxhCF84XMy3dOLfG58
lMlc1Kvrm1wlG0HUhXF22Ii5kPDppyyQZrpw9wOTL65P7zyfrbVyxopdXmx+
ITaLcclfhoMI+TE6tEjliC44Gri6ojJ+QzWyHoD+MmEYErgvhIE3+k/SBmlF
zZObNp/SQRyx7JQ/Me0Nwu/GyIBWBdG4ARGf9YyoQoJ15xF0HOKNtgNoL83X
BG3c+Q/2V9+IHK7j2Z8MLiAkfXbZMdiqQ0RPFTpPoFO02lr6BzVxU37cXmn+
4dQdr+CX4oIqutFBgDyCmK6ErhS+Nk+UTea6EILxEBGCIox5yDgjElnHXEQG
uMg15lB3jdhNf4bokMn455O5fvOTmWe24XAr2uwsbtHAXHZcZTkiCPqICsBv
Nyk24GwVtiauRlEBzdbOoP80qcB0KSFA3wlhaDceb4VlAB5nxmGPzwXjGJXp
4ZIM8nAL+pXgq9BtCL6DXM1BEdt+tLLUc8+s3HtnaO3mdINFr55PjYThcWHY
gv4GlmnvWXQKVm09KCLf+4kS/9xSc5/Xj97xcvZxCcine9EpmXcCe7MTOR7G
i2J1JUkRMYRdCBsFqfAg4UuEZFoFrVyTovegjDRsU2u5zN/x3v/rqdcP4mQn
uiSHtRBjNpKNTiJCEMbPDFlVE92diyDfXkMjGTin61uM8U+LmE8ylBFwScd7
y0yfMwmWMX+TI8W6A9lznWiwpH3ONFclAhKQ3H0E8EVZIvneKsH4Mk8NfEli
R8teLXm1SnPGn4DXv+CwYYBhKYuuSzTdeggtS2JSJenCb7ZmSQt6X9Ht4lUT
BFwyE4pGZXgpq0J5GruH3UbJaIBLRqPEoPplpKPdBKP9jNgJvMPfwfhDZtv1
T7yS3FixUNMDj0DQhfHMAoHDSEzqtJLM8NCxbqnT5ujTWUYi+s4E3IU/sWy7
j2ng3luG7iPGbLrC/Pfc0L7z2RbSsRezIclv+EfhGYDToiNTfz16T9NLXMmx
RdG27EPzHnUKtXWt+evHH7h7aMO2eI3UI2eD6XlfJOOUUffVs9wsQiPajigx
Ly3lLyw1n6833xK7Yw17KEJ+FwfgDsAbQCiUtyBVcSUWtt8oDnCJhzlRj+lK
/jzSzmRphMB4m3xsYWA+IgjE2wJ/u+jy8wG/EvYMVBlVF+T6FBLHsEDGgRqm
R1IMYMwn3Ei2CYwfNSmM0X0UXYcMTymS/PRrGzKnWmGTLFxgOKZwOJw9GGpT
s5incK8gSYHiaDt4iZwlN3qN+a9an3gksq+S05aZYGbSE5tzy3Tob0DvOe2z
24/9wbn8Re2nxXtcab45+sM17IaPtuNCPywORMKY1UWXecbV4zG9ti0wJEWX
XhqV16KeKvK0sWglgU973Y00nxWw9jTAdQGueo0I7/9x4LWtmRNt6JBUSjY2
x99vExao4nfCO7BY8xy8ICKuhlVETIGsRyZvdxlP5C41f0m6BdUWms/f5DsT
EaX3zt501JNGcCIz4oW7H8Mdhl0YPFTxHQXomveiaXdOxrTx2I8633pvqk7m
8pRvesHLIGxhoA3WGnRXsUA7jmsZM9f6E9rDslXyLfwu+ZuUnG+N//g1lnNF
F3qcjAJpOxVTQHlWgHJM51qCqkjSy+RFybWVIqarEU5JZwzXCVgWt0c4jaHy
Z2Q/Y4efPZF87xAxFzhdKt87mx2TrM6om5Ayl7Scgr4Jsw3UkpTVLEZ3OYFl
vc6WAZsiL52H0H7ApLk+Z1yefJnRf5cNMR/G3RORQS9FRFGa0CGiLj1LCNek
19Sxa3vuSdfeirk+/TTZyhmnJzvUjb4L6DkrYj2BloNLSvXLS0mVkdMdslzn
rBTx+gkxBAkLZ7PxOcbC0ZhJc2ld6CCZSsGQCx1NhMNEbvUYJjx8wcDDg9Wm
VQSGTQqI2au+/y3rg2uwsxpNVowY33/1aYSiGPVyicMjuRjOBhIUvqhlyglB
zT7QJTg2J9LWvSYtU5UffW/77DkKkEPo6R5PuMbg9SmJYuCisRKE8HDncXQc
zRdpbhWw6co334zXSgpsxj+ddgVA4a1fbKnrFAus9fCSEi38BQWR6Je/dxej
Mfp3iubpMGJhzMUXFmIZxNKISj03LAybpOmTgbvaWJSEqYYvSL8lAz4oyEph
WpUEHzjNsKr/lOKhb7ybKGtB50BOmuEEgiH4nPD0m3JolgTap6R5imdol0iT
cFUO0HaUamkuV5Him5zx2F+9cL4t029LJX088xMDAxjuwkCj5haMaI+jU9oy
4JXKoF9l/topNfZh8VIzI2NwDS/YZcZYTtPkVA52CVl+VftUxT7MP2ZmsK8R
LQMIBRAcnZf6geQmI2MIB3T+U62YYwE2EyEwUtTnWYYqEUqg1FZJ77xN6LSv
AraT+lskhgXWIZpBKAa/FyMCcIfbuW4wIJpQac9uCU7CAgiPKunngJHiwbyy
4OXfJytbsrb+hZkgO6mkww1nH+zNsNXnCU0ccdshJbRrDLT5g++0rV0XqJEF
ERlfIusZmRsUemihq/j2suz8Mpn9y4L5J0zuG3f8lDMQx9rQNpC12OdjQXnG
KEq8NqYXqY0KTnV3MbJ0NGNIimKEfwaqBQKJA+pj+EPvertXcGFPGWNLk+nR
X8W2VWYbeuFUMgxPISDFO8GUbMkD9UqAnNE5pdhxx1G0H8rhytx6Kh7/lsOZ
9l4GKMPWscxIEO7h2QFeTQKrWIGAeWqplWIWmpgJSJiRqEAfHr7TufPwzLAs
yUu5Jf0y0I6eGnSeVKK7XHL/qkByNxpt3fUIL7Go7ES/Q1LuscxkYFqDmYCX
YoDikfBYLpFcLt3bd5oTvSrjS3im57jK9cJyhIAjLIfN3+5/8fX4sWZ09fMS
YGntU/D7yGqlZNXGPosHfhY9p9Et4mfUeKgQNYrsVpu/2azsra4t5bGTFuJT
Q665IWEaFGl7NJotYdhIAF1k9yljrK++NHZevu845Z0Sx9O9YG1AV6WSLwmn
+DK5Ff46C8tN8PZXRkYwMDw75kvzEwuSg+VmCJaMKOeuVvPUSbZvEfyhpxy9
BvjrIhkZwpKUHxOYWyZ+t3nuDBmlkRv7FAIRDfyGZY4MXGRp9Z7Jl5ZpEZaI
tIQ5cj3v/c3JmrYFp3123Dnh6XHDJYsG++ooemrLJuzXKsgz983HK3ceTFsk
1wKPPzPkyNpa0F1t0ixgWU4aSmgaI/5r7c9uMqS9rQbnLAu9g3OTwTleVhSJ
EwQXHzbIYnJ1ajZpyMgQkCThlFwIwHUKKCCvTTISZJFb8bStfKGhOyej4AR8
frjJcSuKd4Fxm1VyI5ZyMcUcutijoJuSkWC3ByKHahbau+fa2mOj/WLXw73o
byR8TNhN7k/YTWQkq3NWmb/WYDL+ZX3RWYcP9k701iuBIv97tPRsMpn+n4KZ
9GmF8b7FjPdoCyx2Tp5GfemwR6r5AR/nzEb64bJoOQ3ULWYqexVW0Jkzhl+d
MgXaSxkutO035a3te/YFTpdbbPp7UhCMY0QyU4IXFpPH3adETEbKUiEGwbe8
juHZl5JnWhbaOqcjw9xc0EKuvp1MTmagTGgRkMiHvwbi52b7xn2ZIfkqhowr
CDHRkk+Qzb9dQjbS28+fonsMZrv7VWpmEkGVv7LnluyYFDLV2cSTi0GfxJKL
+5zFOqASWboWeM/fN/3uo5mzZGZDGPdLncYnBjzUruI+ekUoFhFKh7TIaUUW
ylWGF99Vlmnq5KqRuzcQ7RvGUA9sgg+7xB0KiFJVkBW3/Pvq3//OfV5WomcI
JDg4jl9S+V20pMJfVspJY/XpDu7pbDSLsWTcHcKoD14hzOxJm1kaCt1JID95
CQAih6plcUAFcrUa9KF7B7eXz1+0wONYUNiSzcjRw3G8XxwzxXEWArfDEekg
R6S9ylflvpnStNLam+5uDycGR2hk8S6FJCsJ/hTlJEAb99/Ss2N/Us0JuCRD
t1x7DTXyP9efbjRGfEWbDSEfBu2TMU8cwTB8MnOd3Qz3hluM0Z4V2KK8oQTd
XBqtLX+0bOvP/Hr8eGO2u29h0i+LD/0RSV6269H2noXlpEItl4029yTWpl2p
s42ztu5E0hWaGJCUVd/FHHTRGX3aeOU5/3n9HNCKS8ZZ+NtWNxhWdrQJF7uJ
66SnR9MISZJzZBCuXmKjjNJ0yvCsYIxVJtNlCZaWvTpa5lZeX3uxK6scFcVK
eNxwWGmCy1DPsWJVLqvtMJEoNdIcR1h14kLWYkmNO8btbSL1/tZM1zmFMRTy
Yu+yc39yWJ5OXJkXO/VvDOaN8Hqj1c9UEusZwmwE4x7hBj4PgyhZvcIfFRDt
rdLq7CorSCBp3y0o9Nr77mAzohH6HBmtTLfAZFu9+O7TsEhwbz+qqPe1RlRc
t36ipiXT3Sk9cA7B3jXfe0EhgZuw+LuFJcaTCJf9alhuPKtru8iH8FSa8sYx
GoRnmKenTtHUk7L0E4vMcHUlW+zQCNWCa6759VPRisZsrzWTGBFXNyJPdVII
sp7XIai9jIxQZxAE0bD+j9Rk65qErHs8nlYrbM0qUEtezFiBr38XsaD3Kis7
aJ+dDc4iEBu3O+ASCD7YIv0+p8OCpUJNMu0Bm/dphLHKmAFrPyaEMT/Qb/gP
J5mTBdZaQhjie05w1xf7rVb++Aam/dZRf+cgBjpU4LxJy1t9l8lfanu5wUAT
J5rQ24+EPztkjUwRYTWSCBzCbLXUV817O44ZpDevrxLpr77vtv6D5xaau+aD
DqkE+hMYtrKMe2SgneXSUVbOdYbH2nV8rqUt1dwYCfW6MMghTLwx91N9y91f
FUhWruS8x1miI90z9r6JWR9Psplhmw4t/TLBaWp2S5DIsUqjs7nvNbyyspHz
UuNuIYEkVXsHrOIAOiu4pxJecphtWdXFufbW+Fi/T8eWT+l+ylyR3/7K76fs
vf7mv2M0WNM+7xqaQ5iTudNDDjh6xfsrQzzDTkIXcw4ykWuWKJrzhRfaMvZ+
Sam6XXCKL+w+SwGQ9M7nif6YDW3fn2xsSfqsYeX4r9K9U79A8DdL9Y455tGL
2c5ebn2wJ5Tx+Am9YqhTu2qr8l+q7nGIXZh0TfXsoTv7y+qzHV3p6LDyooLq
rHUSlcpzPWNi/Oyj7lP181bxBSL9EoOVm/5Wz8KclK+oaZ529U9gdHzB40kN
CO0gLK19zSmd9Ww2GNuVhpReWxOtbpobtE5FnFK/YqTQxIJSEcP4LUjj6Ysv
yt2/VSAV8V7X0ml17fOeodnpkcmhLvecQwCA7YLyFIbDk/xRM+Plqw2ft+vY
bHP7jFNBKQcBZTt669B5SnsLHrX63bj/WHDfa4xRHKhBm2XO0pXwWEWcDttM
X4vQLrZ0ipek82JFJnLXMRY8dVFq5W4pUzuH0ceo7bP6nsLpTf9pqXtyRDzZ
uNDQlhwdZC2Gewez5FpsDYsWS95F7OBThsW2tM+5rLGYSyxcOHXOYtUvaX5b
69T4FhDTlTWtrBOfbczb7YKjHwNt8z2yVLbzJAP/1iO59u/6ds2x2mxLe8bf
L5FjsCff0tSvpv6XgpEYa8ZNq1s7Zxubx4O2UTKBtK0731TQxj5L/8bCC894
zl6ctVtUJvIaPSfUr8b+3RKti24qLi60d0xHh6PJYa+/06ZnO6egZIZdb8z2
HQdTTS1Jv1W+zmi17rn8CqXpOwVtq9mrElg1zRmnbbKnNZA3e6s1FlDrfFhX
dfKgzUrd6t9Kq/9Vyzu/NdFTurNVyucOe6idPFs9uk4b2ir8DhduTWaI+oXn
wt/bXP2A8Us9J6QHGc+Yt8s13t0r8ZA5oOAVbkXkZ/pvBa1IdfuKxc/cvXmn
Nd7d7Ju02THQqUfJLajfmP7vBS2suLQF+revCrWNSVtHOD3kVKHDeDr1H6SF
/6HlIleuyr+SLaZ+ztoZnxzkvK5YMN/5H+XYdwvuvOTKRI7LdY1pV89Ynk+7
Wa7//wrOX2rtFot/hb7qNrnqH5e6S+F3pdPHO+Xs/ymzrTBPYDyhfY+c80/6
U4m+8keyl/vIF/5MyeFP/jekEa93\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[133]=",
 CellID->355221960]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->419777204],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Efficient Representation of Many Primitives - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LabelingThreeDimensionalGraphics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FormatsForTextInGraphics"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 34, 57.9388854}", "context" -> "", 
    "keywords" -> {
     "bold fonts", "characters", "courier fonts", "faces", "FontFamily", 
      "fonts", "FontSize", "FontWeight", "FormatType", "graphics", 
      "Helvetica fonts", "italic fonts", "labels", "oblique fonts", 
      "PlotLabel", "plot label", "plots", "Roman fonts", "size", "StyleForm", 
      "styles", "text", "TextStyle", "times fonts", "typeface", 
      "typewriter font", "courier", "FormatType", "TextStyle"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Primitives which can take multiple elements. Some primitives have \
multi-element forms that can be processed and rendered more quickly by the \
Mathematica front end than the equivalent individual primitives. For large \
numbers of primitives, using the multi-element forms can also significantly \
reduce the sizes of notebook files. Notebooks that use multi-element forms \
can be less than half the size of those that do not, and render up to ten \
times faster. Here is multipoint random distribution.", "synonyms" -> {}, 
    "title" -> "Efficient Representation of Many Primitives", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/EfficientRepresentationOfManyPrimitives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.15"->{
  Cell[2148, 63, 109, 2, 70, "Title",
   CellTags->{"S2.10.15", "15.1"},
   CellID->24353]},
 "15.1"->{
  Cell[2148, 63, 109, 2, 70, "Title",
   CellTags->{"S2.10.15", "15.1"},
   CellID->24353]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.15", 74418, 1566},
 {"15.1", 74522, 1570}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1523, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2148, 63, 109, 2, 70, "Title",
 CellTags->{"S2.10.15", "15.1"},
 CellID->24353],
Cell[2260, 67, 2789, 95, 70, "DefinitionBox",
 CellID->4706875],
Cell[5052, 164, 83, 1, 70, "Caption",
 CellID->82696337],
Cell[5138, 167, 511, 10, 70, "Text",
 CellID->486791108],
Cell[5652, 179, 83, 1, 70, "MathCaption",
 CellID->1974459928],
Cell[CellGroupData[{
Cell[5760, 184, 371, 11, 28, "Input",
 CellID->1730805049],
Cell[6134, 197, 9883, 166, 203, "Output",
 Evaluatable->False,
 CellID->389331813]
}, Open  ]],
Cell[16032, 366, 1278, 39, 70, "DefinitionBox",
 CellID->581485719],
Cell[17313, 407, 95, 1, 70, "Caption",
 CellID->1979885383],
Cell[17411, 410, 533, 15, 70, "Text",
 CellID->674521816],
Cell[17947, 427, 115, 3, 70, "MathCaption",
 CellID->1569706955],
Cell[CellGroupData[{
Cell[18087, 434, 1002, 31, 70, "Input",
 CellID->228189290],
Cell[19092, 467, 354, 10, 201, "Output",
 CellID->1722038839]
}, Open  ]],
Cell[19461, 480, 326, 9, 70, "Text",
 CellID->741273690],
Cell[19790, 491, 410, 13, 70, "MathCaption",
 CellID->1034271583],
Cell[CellGroupData[{
Cell[20225, 508, 377, 12, 70, "Input",
 CellID->415090778],
Cell[20605, 522, 5109, 141, 70, "Output",
 CellID->6816083]
}, Open  ]],
Cell[25729, 666, 789, 24, 70, "Text",
 CellID->1175550562],
Cell[26521, 692, 240, 8, 70, "MathCaption",
 CellID->1666309898],
Cell[CellGroupData[{
Cell[26786, 704, 953, 27, 70, "Input",
 CellID->336215159],
Cell[27742, 733, 19651, 331, 216, 430, 12, "CachedBoxData", "BoxData", \
"Output",
 CellID->1414835530]
}, Open  ]],
Cell[47408, 1067, 471, 13, 70, "Text",
 CellID->563911091],
Cell[47882, 1082, 336, 13, 70, "MathCaption",
 CellID->86533571],
Cell[CellGroupData[{
Cell[48243, 1099, 337, 11, 28, "Input",
 CellID->403599901],
Cell[48583, 1112, 22447, 372, 164, "Output",
 Evaluatable->False,
 CellID->355221960]
}, Open  ]],
Cell[CellGroupData[{
Cell[71067, 1489, 72, 1, 70, "RelatedTutorialsSection",
 CellID->419777204],
Cell[71142, 1492, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717]
}, Open  ]]
}, Open  ]],
Cell[71370, 1501, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

