(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24221,        753]
NotebookOptionsPosition[     19020,        600]
NotebookOutlinePosition[     22291,        679]
CellTagsIndexPosition[     22200,        673]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcCos" :> Documentation`HelpLookup["paclet:ref/ArcCos"], 
          "ArcCosh" :> Documentation`HelpLookup["paclet:ref/ArcCosh"], 
          "ArcCot" :> Documentation`HelpLookup["paclet:ref/ArcCot"], 
          "ArcCoth" :> Documentation`HelpLookup["paclet:ref/ArcCoth"], 
          "ArcCsc" :> Documentation`HelpLookup["paclet:ref/ArcCsc"], 
          "ArcCsch" :> Documentation`HelpLookup["paclet:ref/ArcCsch"], 
          "ArcSec" :> Documentation`HelpLookup["paclet:ref/ArcSec"], 
          "ArcSech" :> Documentation`HelpLookup["paclet:ref/ArcSech"], 
          "ArcSin" :> Documentation`HelpLookup["paclet:ref/ArcSin"], 
          "ArcSinh" :> Documentation`HelpLookup["paclet:ref/ArcSinh"], 
          "ArcTan" :> Documentation`HelpLookup["paclet:ref/ArcTan"], 
          "ArcTanh" :> Documentation`HelpLookup["paclet:ref/ArcTanh"], "Cos" :> 
          Documentation`HelpLookup["paclet:ref/Cos"], "Cosh" :> 
          Documentation`HelpLookup["paclet:ref/Cosh"], "Cot" :> 
          Documentation`HelpLookup["paclet:ref/Cot"], "Coth" :> 
          Documentation`HelpLookup["paclet:ref/Coth"], "Csc" :> 
          Documentation`HelpLookup["paclet:ref/Csc"], "Csch" :> 
          Documentation`HelpLookup["paclet:ref/Csch"], "Exp" :> 
          Documentation`HelpLookup["paclet:ref/Exp"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"], "Sec" :> 
          Documentation`HelpLookup["paclet:ref/Sec"], "Sech" :> 
          Documentation`HelpLookup["paclet:ref/Sech"], "Sin" :> 
          Documentation`HelpLookup["paclet:ref/Sin"], "Sinc" :> 
          Documentation`HelpLookup["paclet:ref/Sinc"], "Sinh" :> 
          Documentation`HelpLookup["paclet:ref/Sinh"], "Tan" :> 
          Documentation`HelpLookup["paclet:ref/Tan"], "Tanh" :> 
          Documentation`HelpLookup["paclet:ref/Tanh"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ArcCos\"\>", 2->"\<\"ArcCosh\"\>", 
       3->"\<\"ArcCot\"\>", 4->"\<\"ArcCoth\"\>", 5->"\<\"ArcCsc\"\>", 
       6->"\<\"ArcCsch\"\>", 7->"\<\"ArcSec\"\>", 8->"\<\"ArcSech\"\>", 
       9->"\<\"ArcSin\"\>", 10->"\<\"ArcSinh\"\>", 11->"\<\"ArcTan\"\>", 
       12->"\<\"ArcTanh\"\>", 13->"\<\"Cos\"\>", 14->"\<\"Cosh\"\>", 
       15->"\<\"Cot\"\>", 16->"\<\"Coth\"\>", 17->"\<\"Csc\"\>", 
       18->"\<\"Csch\"\>", 19->"\<\"Exp\"\>", 20->"\<\"Log\"\>", 
       21->"\<\"Sec\"\>", 22->"\<\"Sech\"\>", 23->"\<\"Sin\"\>", 
       24->"\<\"Sinc\"\>", 25->"\<\"Sinh\"\>", 26->"\<\"Tan\"\>", 
       27->"\<\"Tanh\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Elementary Transcendental Functions", "Title",
 CellTags->{"S3.2.7", "7.1"},
 CellID->10797],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Exp",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exp"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "exponential function ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["e", "z"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "logarithm ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["log", "e"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     StyleBox["b", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "logarithm ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["log", "b"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     " to base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Cos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cos"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Tan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tan"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Csc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Csc"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Sec",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sec"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Cot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cot"], "[", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "trigonometric functions (with arguments in radians)", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcSin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSin"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcCos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCos"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcTan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTan"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcCsc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCsc"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcSec",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSec"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcCot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCot"], "[", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[
    "inverse trigonometric functions (giving results in radians)", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcTan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTan"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], "]"}], Cell[TextData[{
     "the argument of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "+", 
        RowBox[{"i", "\[InvisibleSpace]", "y"}]}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Sinh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sinh"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Cosh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cosh"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Tanh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tanh"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Csch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Csch"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Sech",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sech"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["Coth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Coth"], "[", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["hyperbolic functions", "TableText"]},
   {
    RowBox[{
     ButtonBox["ArcSinh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSinh"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcCosh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCosh"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcTanh",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcTanh"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcCsch",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCsch"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcSech",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcSech"], "[", 
     StyleBox["z", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["ArcCoth",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ArcCoth"], "[", 
     StyleBox["z", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["inverse hyperbolic functions", "TableText"]},
   {
    RowBox[{
     ButtonBox["Sinc",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sinc"], "[", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "sinc function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"sin", "(", "z", ")"}], "/", "z"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->31202],

Cell["Elementary transcendental functions.", "Caption",
 CellID->10508],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives exact results for logarithms whenever it can. Here is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "2"], "1024"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->5340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"2", ",", "1024"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->12076],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->9058]
}, Open  ]],

Cell["\<\
You can find the numerical values of mathematical functions to any precision. \
\
\>", "MathCaption",
 CellID->31493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Log", "[", "2", "]"}], ",", "40"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->7740],

Cell[BoxData["0.6931471805599453094172321214581765680755001343599489645599`40.\
"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->8546]
}, Open  ]],

Cell["This gives a complex number result. ", "MathCaption",
 CellID->20474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"-", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->24773],

Cell[BoxData[
 RowBox[{"0.6931471805599453`", "\[InvisibleSpace]", "+", 
  RowBox[{"3.141592653589793`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->19097]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can evaluate logarithms with complex arguments. "
}], "MathCaption",
 CellID->8880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"2", "+", 
    RowBox[{"8", " ", "I"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->23335],

Cell[BoxData[
 RowBox[{"2.1097538525880535`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.3258176636680326`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->11072]
}, Open  ]],

Cell["\<\
The arguments of trigonometric functions are always given in radians.\
\>", "MathCaption",
 CellID->23400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Pi", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->707],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->22955]
}, Open  ]],

Cell[TextData[{
 "You can convert from degrees by explicitly multiplying by the constant ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"30", " ", "Degree"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->4141],

Cell[BoxData["0.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->23588]
}, Open  ]],

Cell["\<\
Here is a plot of the hyperbolic tangent function. It has a characteristic \
\[OpenCurlyDoubleQuote]sigmoidal\[CloseCurlyDoubleQuote] form. \
\>", "MathCaption",
 CellID->12481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->17168],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WDtM3EAQXfD5OPIlUqRcFZ0iCCgfCZFEQqny5f85yIcjFQhFOoooiCCF
jpKSkpKSkgaJMiUlJSUlJSWl82Zm7V2v14a7KJbOZ8+8ebO7Mzu73unljeb3
H8sbqyvLtdH15bXm6sqv2sjPdYiCDqXUIX6/qwrPEZ74dxhF+LfvE7gHUHXS
Gz1EfKlOPC4xYtLRBHQrmXelSg6iwWKRHh8f/+FLPaFbcHp6qlF3cSt5rK/L
z7jg/Pz8DV/qKd2CgYEBJVeZbqVqtSr6sbGxzq2tLRWgGTAi48q1PJNggV9f
sx7G0qOjoyNmDMFe5avRaBwcHKhymz16R/cy+Pf39+v1OghBf3FxEbTJ95Hu
IfhAg3FB0+LIUgvpP/TajcYji0Y0m02OVBY1ztLd3d2lJU6U25pzMckrFezt
7WntLS8H5RaNoV87xVKMLgabHm8UoM7OztDFy8vLHNQ0S3d2dtbW1uixuwAF
llqthv4zyvRpxuFw86dhoQyHHzXrcHUVoJACyAXqmx9VZymSD3nDKRTJnLa1
GEIMZKzNcsyxFG703PBnhqA2Nze3t7evQhmPftS847GUarVokX1IsFibx2E8
+VETOor2PKLiQDKOlEa7NdDK89RskxHE5NBU7vwUu/eR1I7OHHvMDcve9DzP
HzK80F/WLtT9VgFSEeat9DG0JJjCaKzfazy2XbGvUCZ8QqS+8f/nuA9oSn47
vrDXpLWRPftYFyZZnmIXXTKbPLqTk5PBwUG/DhnQ09MjeWB0X6N09TERYk0J
ruBQTCyLEsosUiMrR5oj2W15r477INNLr8n/kJb3MarfGannzAYXtNTw9dJB
PGK7hzr/3NnH9rrykPUrr7XXK63mw8PD+VZ9OmLSIxlXQr/Q8r4EZdsKGuHR
+T3k6HvZ6nGKm9YlQcfcguII0aqkdwGLlhQ5oG1sKdVVpegu0sXYO+AmMxOp
rkciPWQfbtVxq7S7Alz13qp9gpcM/+/+rrLnuS3xsKRJVGWucdyyGZSMM/IM
2eaOvkw6Syr1Lak5MtdSMaS8slh0TatUKmjEQkYubrNycZyVyw5nwWmPqXNW
e8Kkr7Lo+XV6Ynt1WHWx9vp12I1ii2vpAm4J9g4YbxJ+MVblxAoXxgejlKeV
2p+nld7naWUUjNZ8Z5j16FM6XnYGBeL7KpTZQwmqaLV3a6Ew4JsEe0fDkF0N
vRnu7sitvcz8P/GYfrfCEyR9NrvuPPt4Z+COh9ibnCmyt+3cCijvkln0OJeK
TLxX8FnR18C8N9qCTtZxzRnnlbTI5FXdyyEos38tQslal48qOx5nc1HUJ8NB
ymRHp6uE31aibHYgMwUos+vwoypORKYLUIbLoChe8mUlFZIep7wc3U6c/Cjh
Mpk+WYBCPoKLNkd+1M1Iz2I0DVj59syg5BsTQ4kySevPeKpvd1iLIgoOMKkx
LwejSugbUKg7oBmJ4szOO0Vx5wp/TYdoJ6oWyo7QqA/M0/pZyz1OMowN2LCm
IW4gRHzetsl3n1MKGQA+2eqhjXJ8ouT8BFNHn+h084mOJBSZPWvBJwkexHGT
wxTNj9mpT3S6+URH9oV09fOKhl7KIZLeZ7R7PtWuXVzF4jMULrQqe7KmOv4C
KNpVqQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->360122860]
}, Open  ]],

Cell[TextData[{
 "There are a number of additional trigonometric and hyperbolic functions \
that are sometimes used. The ",
 StyleBox["versine",
  FontWeight->"Bold"],
 " function is defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"vers", "(", "z", ")"}], "=", 
    RowBox[{"1", "-", 
     RowBox[{"cos", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". The ",
 StyleBox["haversine",
  FontWeight->"Bold"],
 " is simply ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"hav", "(", "z", ")"}], "=", 
    RowBox[{
     FractionBox["1", "2"], 
     RowBox[{"vers", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". The complex exponential ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{"i", "\[InvisibleSpace]", "x"}]], TraditionalForm]], 
  "InlineMath"],
 " is sometimes written as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cis", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ". The ",
 StyleBox["Gudermannian function",
  FontWeight->"Bold"],
 " is defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"gd", "(", "z", ")"}], "=", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{
       SuperscriptBox["tan", 
        RowBox[{"-", "1"}]], "(", 
       SuperscriptBox["e", "z"], ")"}]}], "-", 
     FractionBox["\[Pi]", "2"]}]}], TraditionalForm]], "InlineMath"],
 ". The ",
 StyleBox["inverse Gudermannian",
  FontWeight->"Bold"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["gd", 
      RowBox[{"-", "1"}]], "(", "z", ")"}], "=", 
    RowBox[{"log", "[", 
     RowBox[{
      RowBox[{"sec", "(", "z", ")"}], "+", 
      RowBox[{"tan", "(", "z", ")"}]}], "]"}]}], TraditionalForm]], 
  "InlineMath"],
 ". The Gudermannian satisfies such relations as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sinh", "(", "z", ")"}], "=", 
    RowBox[{"tan", "[", 
     RowBox[{"gd", "(", "x", ")"}], "]"}]}], TraditionalForm]], 
  "InlineMath"],
 ". The ",
 StyleBox["sinc function",
  FontWeight->"Bold"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sinc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sinc"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is the Fourier transform of a square signal."
}], "Text",
 CellID->19396],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->296740257],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Elementary Transcendental Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CombinatorialFunctions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FunctionsThatDoNotHaveUniqueValues"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 0.8295844}", "context" -> "", 
    "keywords" -> {
     "ArcCos", "ArcCosh", "ArcCot", "ArcCoth", "ArcCsc", "ArcCsch", "ArcSec", 
      "ArcSech", "ArcSin", "ArcSinh", "ArcTan", "ArcTanh", 
      "arc trigonometric functions", "circular functions", 
      "complex exponentials", "Cos", "Cosh", "Cot", "Coth", "Csc", "Csch", 
      "Degree", "elementary functions", "Exp", "exponential function", 
      "functions", "Gudermannian function", "haversine", 
      "hyperbolic functions", "inverse hyperbolic functions", 
      "inverse trigonometric functions", "log", "logarithms", "radians", 
      "sampling function", "Sec", "Sech", "Sin", "Sinc", "Sinh", 
      "square wave", "Tan", "Tanh", "transcendental functions", 
      "trigonometric functions", "versine"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Elementary transcendental functions. Mathematica gives exact results for \
logarithms whenever it can. Here is log_21024. You can find the numerical \
values of mathematical functions to any precision. ", "synonyms" -> {"3.2.7"},
     "title" -> "Elementary Transcendental Functions", "type" -> "Tutorial", 
    "uri" -> "tutorial/ElementaryTranscendentalFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.7"->{
  Cell[4157, 92, 98, 2, 70, "Title",
   CellTags->{"S3.2.7", "7.1"},
   CellID->10797]},
 "7.1"->{
  Cell[4157, 92, 98, 2, 70, "Title",
   CellTags->{"S3.2.7", "7.1"},
   CellID->10797]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.7", 21989, 662},
 {"7.1", 22088, 666}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3532, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4157, 92, 98, 2, 70, "Title",
 CellTags->{"S3.2.7", "7.1"},
 CellID->10797],
Cell[4258, 96, 6432, 194, 70, "DefinitionBox",
 CellID->31202],
Cell[10693, 292, 71, 1, 70, "Caption",
 CellID->10508],
Cell[10767, 295, 282, 10, 70, "MathCaption",
 CellID->5340],
Cell[CellGroupData[{
Cell[11074, 309, 122, 4, 28, "Input",
 CellID->12076],
Cell[11199, 315, 155, 5, 36, "Output",
 CellID->9058]
}, Open  ]],
Cell[11369, 323, 127, 4, 70, "MathCaption",
 CellID->31493],
Cell[CellGroupData[{
Cell[11521, 331, 148, 5, 28, "Input",
 CellID->7740],
Cell[11672, 338, 220, 6, 36, "Output",
 CellID->8546]
}, Open  ]],
Cell[11907, 347, 75, 1, 70, "MathCaption",
 CellID->20474],
Cell[CellGroupData[{
Cell[12007, 352, 143, 5, 28, "Input",
 CellID->24773],
Cell[12153, 359, 269, 7, 36, "Output",
 CellID->19097]
}, Open  ]],
Cell[12437, 369, 151, 5, 70, "MathCaption",
 CellID->8880],
Cell[CellGroupData[{
Cell[12613, 378, 173, 6, 70, "Input",
 CellID->23335],
Cell[12789, 386, 270, 7, 36, "Output",
 CellID->11072]
}, Open  ]],
Cell[13074, 396, 116, 3, 70, "MathCaption",
 CellID->23400],
Cell[CellGroupData[{
Cell[13215, 403, 118, 4, 70, "Input",
 CellID->707],
Cell[13336, 409, 155, 5, 36, "Output",
 CellID->22955]
}, Open  ]],
Cell[13506, 417, 247, 8, 70, "MathCaption",
 CellID->20666],
Cell[CellGroupData[{
Cell[13778, 429, 153, 5, 70, "Input",
 CellID->4141],
Cell[13934, 436, 158, 5, 36, "Output",
 CellID->23588]
}, Open  ]],
Cell[14107, 444, 187, 4, 70, "MathCaption",
 CellID->12481],
Cell[CellGroupData[{
Cell[14319, 452, 232, 8, 28, "Input",
 CellID->17168],
Cell[14554, 462, 1869, 35, 140, "Output",
 Evaluatable->False,
 CellID->360122860]
}, Open  ]],
Cell[16438, 500, 2253, 83, 70, "Text",
 CellID->19396],
Cell[CellGroupData[{
Cell[18716, 587, 72, 1, 70, "RelatedTutorialsSection",
 CellID->296740257],
Cell[18791, 590, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[18993, 598, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

