(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34665,        983]
NotebookOptionsPosition[     30584,        855]
NotebookOutlinePosition[     33028,        921]
CellTagsIndexPosition[     32936,        915]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Input and Output in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Alpha]" :> 
          Documentation`HelpLookup["paclet:ref/character/Alpha"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\\[Alpha]\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Entering Greek Letters", "Title",
 CellTags->{"S1.10.1", "1.1"},
 CellID->14875],

Cell[BoxData[GridBox[{
   {
    RowBox[{Cell["click on ", "TableText"], "\[Alpha]"}], Cell[
    "use a button in a palette", "TableText"]},
   {Cell[BoxData[
     ButtonBox["\\[Alpha]",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/character/Alpha"]], "InlineCharacterName"], 
    Cell["use a full name", "TableText"]},
   {
    RowBox[{
     StyleBox["Esc", "KeyEvent"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["a", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     RowBox[{
      StyleBox["Esc", "KeyEvent"], Cell[" or ", "TableText"], 
      StyleBox["Esc", "KeyEvent"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["alpha", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[TextData[{
     "use a standard alias (shown below as ",
     StyleBox["\[AliasIndicator]a\[AliasIndicator]", "InlineCode"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["\\", "InlineCode"], 
      StyleBox["alpha", "InlineCode"]}], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell[TextData[{
     "use a ",
     Cell[BoxData[
      StyleBox[
       RowBox[{"T", 
        AdjustmentBox["E",
         BoxBaselineShift->0.5,
         BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
       SingleLetterItalics->False]], "InlineFormula"],
     " alias"
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      StyleBox["Esc", "KeyEvent"], 
      StyleBox["\[ThinSpace]", "InlineCode"], 
      StyleBox["&", "InlineCode"]}], 
     StyleBox["agr", "InlineCode"], 
     StyleBox["\[ThinSpace]", "InlineCode"], 
     StyleBox["Esc", "KeyEvent"]}], Cell["use an SGML alias", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5907],

Cell["Ways to enter Greek letters in a notebook. ", "Caption",
 CellID->21184],

Cell["Here is a palette for entering common Greek letters.", "MathCaption",
 CellID->28074],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXV1S2zAQFrbjJKUzHdoLcAYO0T71jR4gQ3/ggdKh3KQv9G70ClwhjeQf
2fKuvNJKQQnKjF0jWdKnzyt7/+x+3jxcf7vdPNxcbc4/3W9+Xd9c/T7/eHe/
KypPhBD3u+3PuZDH291htyvFdrsVFxcXartTe9GWPj8/q21a+vj4V9zKfRGw
qpD7H/LPauYkVfVVTmBX29WMay0NdxVPT//E5eUXtb1T+6ZMNpD/ngUqkz8J
gDShM9WkVM27DvllVV/WgslYMpajxrKQLcrm5jA6MsZQ562x2qU8qmVthdUu
ZO0Cqy2F7rr7Fc3Of251O5r8yaPmr2lZgc3XOK8pW47Kuptj126NtiuDnKdZ
PBxOCNJRydoaqF2B2Pqu/EhYttBN0FYRdTi/brENz+/F285VDQzVHQ/mDeGD
LuoKHSw6X+iCZ7MzaVoA84cEGOKpAoY1OKJpJEsYGyTUXnyiCyhlUszlizGS
yu12BXC52wotoH53nFXfyxKbfZSHq5p3qWv90FPZywpVxnIIWN6rcm2JNv2F
KXO6PV4NFlZXW0ZtKLI9n7FwHmLGYwB6mGd8Fg0RtXRUmbZ5C+yRXve9uKsS
YdSBumV2yPNAwYNAQ/rdwL6f11Kp15Zj38ZS/rz5gi0EiqG0D7piW50J0+Zl
wA3kaGwQcXxc5kVwWVMMQzwqUc0lX40uuK8Q8fmZt4xhcuBJQyYc1UiOJ0XG
s2cgE+0PtUsRGueojUpRxHvSG1Qk5lUHhXdpnSHqIVC1C93W7zJz0ENlbn6B
NDAfs4KesaSPxTsSn30FKV7OjIWHhapIsg0athX3UjOaV6FjeCPWPWcoJrQt
JaI7sTpCB7UhTRTSYmcCzJB0OZmkHk1M7vcf6Xdbbd6hRw9ucHXwyFnybp4Z
c20eOufG1QlCNavMfqd47caxOycTSjmCpIRBLX73qLdqq1BTvQCoP117Var+
iONLoeoJfMM240sZX0padsaSkw2yH+C1SFzGAmOBgtBr4rh2mxZ19xujrRjo
8f6I6B000L3Np3LRQZ08K6hyCEmB9hDhVr/ZQoTwWcDJBmhmKhof0gE8SKA5
/hE86Kh7eSGvjZ0NwlLxew8gnTx7alSUyofVNZc2Ff4ZGQdBhF+UnbPCzFQx
b4LmQ/1hMl9ciIGeARWxrZMPS8lAvEy80DGJl9L+FBuVlog0UL02/ThjgbF8
aPvrDFa5nQUoazHQDfFkXAkiewQyloBY4iR5xYiLp4RUaQ4jq3VOqTslnrcP
9PYMA7bJqk5D35Aw4j3oi5UB40J1jwqyODjzdXUlQO+Yd7NBc0GsWfVxPVoc
bjiavsMb3RHCo25OjP3bQfZVZt4nD4YN+2vYxoygmZ8ad5Vw1i00GsU9N3/N
yV/xmPSP3GLeomBCvuaCDK6doe0lGPzs51Nl32gx4j86DWUzedu4qA+gwjiA
WuDaAiOVvxzyHEofDZMxl7qWnLFkLMm7BnKWwSuRuIyFjoWaeWAPayaH1FDI
9hFR0FY0Vd81LYdGe0LgOr1niho/Yd7WxJTyITa7OgtRhAajZlwxdPdC7Igo
/C0JGyJOyjo1GZvtsBKQsRcu0YkqC2yunFx6Tt+aGGSDh+PFLjmQC+jJ4jTE
Xx0I56YILS014T6Df3Vy8qkA+5cLCit9+vk30NSaUZCTDR445p9hXJOvBD3p
RLueMc7pq0nVLjRT4VQA128z8BMOwmG3Z634ph4cp1KasaSFJYU0g++tJd4V
Gia62Sb4f2uAVMntp9yftFUn/wHG1wf5\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{114, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->8719],

Cell["\<\
You can use Greek letters just like the ordinary letters that you type on \
your keyboard. \
\>", "MathCaption",
 CellID->26790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Alpha]", "+", "\[Beta]"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->20476],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Alpha]", "3"], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["\[Alpha]", "2"], " ", "\[Beta]"}], "+", 
  RowBox[{"3", " ", "\[Alpha]", " ", 
   SuperscriptBox["\[Beta]", "2"]}], "+", 
  SuperscriptBox["\[Beta]", "3"]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->30041]
}, Open  ]],

Cell["\<\
There are several ways to enter Greek letters. This input uses full names. \
\>", "MathCaption",
 CellID->3351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"\[Alpha]", "+", "\[Beta]"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->8329],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Alpha]", "3"], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["\[Alpha]", "2"], " ", "\[Beta]"}], "+", 
  RowBox[{"3", " ", "\[Alpha]", " ", 
   SuperscriptBox["\[Beta]", "2"]}], "+", 
  SuperscriptBox["\[Beta]", "3"]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->16290]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData[GridBox[{
       {"", Cell["full name", "TableHeader"], Cell[
        "aliases", "TableHeader"]},
       {"\[Alpha]", Cell[BoxData[
         ButtonBox["\\[Alpha]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Alpha"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]a\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]alpha\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Beta]", Cell[BoxData[
         ButtonBox["\\[Beta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Beta"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]b\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]beta\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Gamma]", Cell[BoxData[
         ButtonBox["\\[Gamma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Gamma"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]g\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]gamma\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Delta]", Cell[BoxData[
         ButtonBox["\\[Delta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Delta"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]d\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]delta\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Epsilon]", Cell[BoxData[
         ButtonBox["\\[Epsilon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Epsilon"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]e\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]epsilon\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Zeta]", Cell[BoxData[
         ButtonBox["\\[Zeta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Zeta"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]z\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]zeta\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Eta]", Cell[BoxData[
         ButtonBox["\\[Eta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Eta"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]h\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]et\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]eta\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Theta]", Cell[BoxData[
         ButtonBox["\\[Theta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Theta"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]q\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]th\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]theta\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Kappa]", Cell[BoxData[
         ButtonBox["\\[Kappa]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Kappa"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]k\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]kappa\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Lambda]", Cell[BoxData[
         ButtonBox["\\[Lambda]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Lambda"]], "InlineCharacterName"],
         Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]l\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]lambda\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Mu]", Cell[BoxData[
         ButtonBox["\\[Mu]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Mu"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]m\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]mu\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Nu]", Cell[BoxData[
         ButtonBox["\\[Nu]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Nu"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]n\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]nu\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Xi]", Cell[BoxData[
         ButtonBox["\\[Xi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Xi"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]x\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]xi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Pi]", Cell[BoxData[
         ButtonBox["\\[Pi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Pi"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]p\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]pi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Rho]", Cell[BoxData[
         ButtonBox["\\[Rho]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Rho"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]r\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]rho\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Sigma]", Cell[BoxData[
         ButtonBox["\\[Sigma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Sigma"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]s\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]sigma\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Tau]", Cell[BoxData[
         ButtonBox["\\[Tau]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Tau"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]t\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]tau\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Phi]", Cell[BoxData[
         ButtonBox["\\[Phi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Phi"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]f\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]ph\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]phi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CurlyPhi]", Cell[BoxData[
         ButtonBox["\\[CurlyPhi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CurlyPhi"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]j\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]cph\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]cphi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Chi]", Cell[BoxData[
         ButtonBox["\\[Chi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Chi"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]c\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]ch\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]chi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Psi]", Cell[BoxData[
         ButtonBox["\\[Psi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Psi"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]y\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]ps\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]psi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[Omega]", Cell[BoxData[
         ButtonBox["\\[Omega]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Omega"]], "InlineCharacterName"], 
        Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]o\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]w\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]omega\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"], Cell[
    TextData[Cell[BoxData[GridBox[{
       {"", Cell["full name", "TableHeader"], Cell[
        "aliases", "TableHeader"]},
       {"\[CapitalGamma]", Cell[BoxData[
         ButtonBox["\\[CapitalGamma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalGamma"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]G\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Gamma\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalDelta]", Cell[BoxData[
         ButtonBox["\\[CapitalDelta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalDelta"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]D\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Delta\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalTheta]", Cell[BoxData[
         ButtonBox["\\[CapitalTheta]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalTheta"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Q\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Th\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Theta\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalLambda]", Cell[BoxData[
         ButtonBox["\\[CapitalLambda]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalLambda"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]L\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Lambda\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalPi]", Cell[BoxData[
         ButtonBox["\\[CapitalPi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalPi"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]P\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Pi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalSigma]", Cell[BoxData[
         ButtonBox["\\[CapitalSigma]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalSigma"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]S\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Sigma\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalUpsilon]", Cell[BoxData[
         ButtonBox["\\[CapitalUpsilon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalUpsilon"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]U\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Upsilon\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalPhi]", Cell[BoxData[
         ButtonBox["\\[CapitalPhi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalPhi"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]F\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Ph\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Phi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalChi]", Cell[BoxData[
         ButtonBox["\\[CapitalChi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalChi"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]C\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Ch\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Chi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalPsi]", Cell[BoxData[
         ButtonBox["\\[CapitalPsi]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalPsi"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Y\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Ps\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Psi\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]},
       {"\[CapitalOmega]", Cell[BoxData[
         ButtonBox["\\[CapitalOmega]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CapitalOmega"]], 
         "InlineCharacterName"], Cell[TextData[{
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]O\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]W\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"],
         ", ",
         StyleBox["Esc", "KeyEvent"],
         StyleBox["\[ThinSpace]Omega\[ThinSpace]", "InlineCode"],
         StyleBox["Esc", "KeyEvent"]
        }], "TableText"]}
      },
      GridBoxAlignment->{
       "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]]]], "TableText"]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->22974],

Cell["\<\
Commonly used Greek letters. TeX aliases are not listed explicitly.\
\>", "Caption",
 CellID->23072],

Cell[TextData[{
 "Note that in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " the letter ",
 Cell[BoxData["\[Pi]"], "InlineMath"],
 " stands for ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ". None of the other Greek letters have special meanings. "
}], "Text",
 CellID->3591],

Cell[TextData[{
 Cell[BoxData["\[Pi]"], "InlineMath"],
 " stands for ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "\[Pi]", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->15787],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->31490]
}, Open  ]],

Cell["\<\
You can use Greek letters either on their own or with other letters. \
\>", "MathCaption",
 CellID->3239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"R\[Alpha]\[Beta]", "+", "\[CapitalXi]"}], ")"}], "^", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->14893],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["R\[Alpha]\[Beta]", "4"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["R\[Alpha]\[Beta]", "3"], " ", "\[CapitalXi]"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["R\[Alpha]\[Beta]", "2"], " ", 
   SuperscriptBox["\[CapitalXi]", "2"]}], "+", 
  RowBox[{"4", " ", "R\[Alpha]\[Beta]", " ", 
   SuperscriptBox["\[CapitalXi]", "3"]}], "+", 
  SuperscriptBox["\[CapitalXi]", "4"]}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->3053]
}, Open  ]],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData["\[Pi]"], "InlineMath"],
 Cell[BoxData["\[Alpha]"], "InlineMath"],
 " is not related to the symbol ",
 Cell[BoxData["\[Pi]"], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->17063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"\[Pi]\[Alpha]", "^", "4"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->10681],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[Pi]\[Alpha]"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "\[Pi]\[Alpha]"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["\[Pi]\[Alpha]", "2"]}], ")"}]}]], "Output",
 ImageSize->{167, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->25903]
}, Open  ]],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Entering Greek Letters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EnteringTwoDimensionalInput"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 7.0016174}", "context" -> "", 
    "keywords" -> {
     "buttons", "escape key", "Greek letters", "HTML names for characters", 
      "letters", "palettes", "pi", "SGML names for characters", 
      "special characters", "TeX names for characters"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Ways to enter Greek letters in a notebook. Here is a palette for \
entering common Greek letters. You can use Greek letters just like the \
ordinary letters that you type on your keyboard. ", "synonyms" -> {"1.10.1"}, 
    "title" -> "Entering Greek Letters", "type" -> "Tutorial", "uri" -> 
    "tutorial/EnteringGreekLetters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.1"->{
  Cell[1853, 60, 86, 2, 70, "Title",
   CellTags->{"S1.10.1", "1.1"},
   CellID->14875]},
 "1.1"->{
  Cell[1853, 60, 86, 2, 70, "Title",
   CellTags->{"S1.10.1", "1.1"},
   CellID->14875]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.1", 32723, 904},
 {"1.1", 32823, 908}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1228, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1853, 60, 86, 2, 70, "Title",
 CellTags->{"S1.10.1", "1.1"},
 CellID->14875],
Cell[1942, 64, 2185, 63, 70, "DefinitionBox",
 CellID->5907],
Cell[4130, 129, 78, 1, 70, "Caption",
 CellID->21184],
Cell[4211, 132, 91, 1, 70, "MathCaption",
 CellID->28074],
Cell[4305, 135, 1987, 36, 70, "Picture",
 Evaluatable->False,
 CellID->8719],
Cell[6295, 173, 138, 4, 70, "MathCaption",
 CellID->26790],
Cell[CellGroupData[{
Cell[6458, 181, 184, 6, 28, "Input",
 CellID->20476],
Cell[6645, 189, 401, 12, 36, "Output",
 CellID->30041]
}, Open  ]],
Cell[7061, 204, 121, 3, 70, "MathCaption",
 CellID->3351],
Cell[CellGroupData[{
Cell[7207, 211, 183, 6, 28, "Input",
 CellID->8329],
Cell[7393, 219, 401, 12, 36, "Output",
 CellID->16290]
}, Open  ]],
Cell[7809, 234, 19790, 494, 70, "DoubleBox",
 CellID->22974],
Cell[27602, 730, 110, 3, 70, "Caption",
 CellID->23072],
Cell[27715, 735, 350, 13, 70, "Text",
 CellID->3591],
Cell[28068, 750, 219, 9, 70, "MathCaption",
 CellID->12189],
Cell[CellGroupData[{
Cell[28312, 763, 98, 3, 70, "Input",
 CellID->15787],
Cell[28413, 768, 172, 5, 36, "Output",
 CellID->31490]
}, Open  ]],
Cell[28600, 776, 115, 3, 70, "MathCaption",
 CellID->3239],
Cell[CellGroupData[{
Cell[28740, 783, 200, 7, 70, "Input",
 CellID->14893],
Cell[28943, 792, 558, 15, 36, "Output",
 CellID->3053]
}, Open  ]],
Cell[29516, 810, 227, 8, 70, "MathCaption",
 CellID->17063],
Cell[CellGroupData[{
Cell[29768, 822, 158, 5, 70, "Input",
 CellID->10681],
Cell[29929, 829, 411, 14, 39, "Output",
 CellID->25903]
}, Open  ]],
Cell[30355, 846, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]],
Cell[30557, 853, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

