(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    141851,       3422]
NotebookOptionsPosition[     38899,       1192]
NotebookOutlinePosition[    131004,       3124]
CellTagsIndexPosition[    128191,       3050]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Entering Greek Letters" :> 
         Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
         "Entering Two-Dimensional Input" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/EnteringTwoDimensionalInput"], 
         "Special Characters" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]}, \
#, 2]& , Evaluator -> Automatic], {1->"\<\"Entering Greek Letters\"\>", 
      2->"\<\"Entering Two-Dimensional Input\"\>", 
      3->"\<\"Special Characters\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Entering Input in Notebooks", "Title",
 CellID->509267359],

Cell[CellGroupData[{

Cell[TextData[{
 "First Steps with ",
 StyleBox["Mathematica...",
  FontSlant->"Italic"]
}], "Section",
 PageBreakAbove->True,
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 " and then press ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 " (hold down the ",
 StyleBox["Shift", "KeyEvent"],
 " key and press ",
 StyleBox["Enter", "KeyEvent"],
 ") to tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to evaluate your input."
}], "Text",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmF1OwzAMx92k7QZCAsTrgF6DCwAvHKKakLaHCbTtOH3l6zC9A1wBHvYw
oMROZ3UhTBp0XSVcqf8ktvuzk1Ztlat0OrgepdNhP00uxuntYNifJOc3Y2PS
AUCgAOAyAewXplsKHRoFgJpPtAfWYC3FIvgHV57n8F5kWab8fmzmFKUxinF/
jVQYOcOuWu8aJ/KNNKQ446Vz9WxcCtpeSaPFuEoCQQlKUIISlKBaiXpBjYqD
brFXH/SMVDMKR0+lzWRi266kXC9lDzXGYceTPGKv2lJpipOrlUU6cVso95iT
E5+YMdui5gs64eQ7nuQd9obNl3a6vFZO8i57dfOlJZz8iHstefj3PTZfaY/W
W+8bmB7vEIeH3PPdngdnXUwLG/4Q3JOG1VvRwOfnrsRXs25gws+occ3zaeef
g6AEJShB/TOUOX+7bzizQd95ze2czkmXF8a/5fuBav9X7HqVW8UQfAFkiUdd
\
\>"], "Picture",
 ImageSize->{258, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell["Labels are added automatically.", "Text",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell["Output is placed below the input.", "Text",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWstO3DAU9dhJZoB2hhFQVe2i8zXtquuuRwgJFoiK8iW0IM2ePn6ASn1K
XXQ5G7qo+BCEkEDB9/qRxHMzRSWOZyDW2HGOb+49x44ztpKXw73Nje3h3tb6
cPBid/h6c2v9zeD5zq6ERIuxVswYezVgUE9lVRep/KUJFIBk9QgOaNJSBZ5x
iwoXVQgbj8dsNBqxKyh5iRHUwPASS4EXmHQb86hgLvMFnPB/XRa7l6HpOaKR
i09qSsjLZTqb4r1x07jx7OaZmkI4Y03+07huXFvXTwjXgsBO6g13DGXM1npX
3Nb69VL4oltkZItFBNarnha4hywILDAtqrcC0EI36BnJcHunqHCWrtBEDKZx
fblMH+vl3UWwW3Cd79qSo9EjNAtHTiZySVM34SF/mEOJEyP2ACrJHRyxtkPT
ZEifQkhdvKlUrmZYmm/imbC83IcazouU6T1U0DjxrSomVcUZ3fygcVeese86
0yvAIGVPvo4KYvsfstv/Gu8pQWb2cM9dftO/2GXiaXXk0ILjDFD9XLxTDLUZ
YHY85f72SI9akyKVxHO/UIF/NeGacE24uxTuKRHud73hvkIZe36cUYF/EuE8
LikeAciz1WpxSRGCjOOaO30UgJZaqrSnLvuFdkGt9eURF48YoK15mliKoWl9
O6vKJpb1CCO6oG4hpqPxqSodu/nR27ecO+rRIFNiscO50ZGN25Jlv0CMVtu2
HoTQFhW0mH0ZvUGlJpwzXI64jm19F0Jc0bUgMGoDumpJr4SdPwR9xTfK800N
vEzM+x6B7VtHHv9yH6suskRTlVbUrJCpb2v7DgvPm6oSZj+c6aCZ1E/ku/Ze
816zhM03qCT2wVDlS4KSiNT+u6IXMfc44uk8eKfW6X/vs+vZetPduKnKzS0/
hSE+wEE7OKvuM5//Nod8qTFjDmcTXzdlCxNW+CqKta4Bvs38Eg==\
\>"], "Picture",
 ImageSize->{261, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell[TextData[{
 "Your first calculation will take longer than subsequent calculations \
because the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel has to start up."
}], "Text",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is made of two parts: a kernel and a front end. The kernel is the part \
that does calculations. The front end is the part that handles notebooks and \
interaction with the user."
}], "TextNote",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell[CellGroupData[{

Cell["Tips", "Subsubsection",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],

Cell[TextData[{
 "On the Macintosh, ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 StyleBox[" ", "KeyboardChars"],
 "is equivalent to ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 "."
}], "Notes",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
 CellID->1008559715],

Cell[TextData[{
 "On extended keyboards, you can use the ",
 StyleBox["Enter", "KeyEvent"],
 " key at the lower right corner of the numeric keypad to evaluate your \
input. Pressing the ",
 StyleBox["Enter", "KeyEvent"],
 " key in the main keypad by itself gives you a new line in the same cell. \
See ",
 ButtonBox["Working with Cells and Notebooks",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/WorkingWithCellsAndNotebooks"],
 " for a discussion of cells."
}], "Notes",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
 CellID->774704234]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Your First ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Calculations"
}], "Section",
 PageBreakAbove->True,
 CellTags->{
  "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
   "Executing calculations", "Entering input", "Conventions: Mathematica", 
   "Input cell", "Output cell", "Capital letters", 
   "Built-in functions: conventions for", "Arguments to functions", 
   "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
   "Brackets: conventions for", "Syntax: Mathematica", "Grammar: Mathematica",
    "Notation: Mathematica", "First calculations", "Tour of Mathematica", 
   "Notebooks", "Help Browser examples", "Examples to try", "firstcalc", 
   "i:2", "gs:0.4"},
 CellID->233105605],

Cell[CellGroupData[{

Cell[TextData[{
 "You can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just like a calculator. Type your input, press ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 ", and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns the answer. "
}], "TextEmphasisNote",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->193950997],

Cell[TextData[{
 "Type the input ",
 StyleBox["9.7^200", "MB"],
 " and press ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 "."
}], "Text",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->1924232],

Cell["Here is the result.", "Text",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->304815992],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs2O0zAQdmMn/aOlXVZaDhz6CEi8A5y4cm+rlXYPaNGyggPa88I79IkQ
KuI5WCRuHENmHDuxO/YmVZM0kGo7nh1PxjPf2BPHzevlzcX52+XN5Xq5eHW9
fHdxuX6/eHl1nYh4j7HeGWPszYIBHydsSuLkL34KhDEODYpPgfSkVIqZ+vj6
t9tt0r/ZbE6ABLQStDGozlGfg6q2fhD1ADQxsAmQoNyFlib2DpEVqAQq8PVH
aJuSYSR0gGyohTlzrLPX2evs/Tf27oGGbDZISpTiHh/O/G+kHKxK95OvIGST
ww35TNbbxLrQ3LeG3Cgw5Nf6XZsBRetcIxSkA6sh01YKeF4kPUFHeOqnnpxx
qpv1cs2hLNCc0L2CsKLcyct27X6sHzu5NsaG+Tw4VBtYLkFruylhTujQ8lV9
4ePrCzx9boRp/ZDQF0RGkk9U0vSHNqVMGNeo9UJ6aiIwdi2MEgmiFhe6FWnc
EYj+v5yBkLyGWlD4H4U7JSu7WIRHn8pT2L7sjIpmJyBuCfa6gHbuzMVOWReu
ohN6kAoI/bYXKXq6SxQiuxiplloNU090D99FTKTKomcvCFdyqbGcRe94MpXt
nobZchAa+fwq2TcLzn1Vbr/kKV4Y0NTSj0j9ON1TWQcsVLpWcqUmYakJURHA
L7TnY82FVjQubKi5Oi2AZtFZaMrO6599ty7XnMGs9XSsOG+3nnlJoUfJVpaL
0Fbs9ieNHicWiuIdMSzTnFuluRakCTQD7SfeA1fpkNRNpWIXfwKNasDiT2e+
M9+Zb5n57Nix4vLQwAHkGVDrAPJHQ24UGPJ7/a7JR8OB9/k/VoePwu7CR6Vs
V5g9ZiOHvXgP59IGS7dFyH1pKtjhQ8HmYjW3EwqIRzrEiRlsdtMvxX1uCor+
3uc+p9r5DIyZ5sJ2B86J3KsjR5SOgAvNCZBFL449evO3BeLcQl5uZn/nTMOK
JkNirjl+7EiY5qmzM+pIZ0aEMPUGPWhPTSAg8R2sUFiMCFlW+IsWB4q70+NW
vFl5rt3Fk4/IdLyvewXB3RFTpmJ3f9EVq+JR760SkRu5vofaSn4sR3+P+F2B
zl5nr7PX2avCHsqB7PmaI77yOZGau5abeAMU0VG7mzxsnndanwCRmz95ffpW
LOv9BZU87Nw=\
\>"], "Picture",
 ImageSize->{279, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->405220212],

Cell[TextData[{
 "Here is an example from algebra. The first bracket after the function name \
",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " is a special color until the closing bracket is typed."
}], "Text",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->92108902],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMtuHEUUbfdjZuzY4/HYM3bAgIPCIsoWWFgyiA2s2AF7y4oUCyFQYhll
FeUz/FFmFfLcsWQFH4CarlvVtx5zulPteKZrrG65qyunbt1X3Xp2Z74/Pnv4
4Jfjs9OT44PvHh3/9vD05PHBt78+KqBkJYpWplEUPTiIRD4vsirJi798VyRR
lIgHwdsiWZGohKPyqiu/vLwsyi8uLoYiienfichy7dk64pkLytG8yEkPsnNd
JP5qIUoqHVA2JSJBIm4y2JuVNKNI+5TNGDTYRR2/jp/Bb0xpQn20vP+dL/sU
YH93IpdEZGaxz+UVPRe5LJps/hdzbnMxol9Jq4VE1xMWtrEYdT5SornDFvdT
gH0Zltr7QMVnAPsiLLU/BCqqCCwuUoKkJZzbBthtgO0BbBNI+zx8h6QA6wEs
c1Qsb3ZlA/rthvTjhvSjm90ULiauoSfdjicdaiJEt3VzXE0YadMHpbdqS7dq
S0fvLr0ZLuyitVVXE52EUlZCXesN6dGYW0ePXFtHvwTT5b5SwFSxNGiXc1Pu
3LS2iLk0w4ZTWWrTZ8AZgS2m0NI1BtgewCaOiuXNTnDop559YIcdmICmYjjo
tfXRAv01xV5CLA/D8tIhd7e9K/kGd+IPHPplcgYyM6npCi6BXV2ex/bcSksc
IWCk0tu5inhA27qjsMwM7ECjUydgdYQIJSY3OkEBocXdpwC7BbBTgB20b6jp
9wSIRuvNuwBbBdjPAPtk8SbT5pG4J9ySsRbJrtDtLJlyAdppkr2k3lBWs0Y/
NFegPWz9sZrvURvC1oC0jxfve7ndGlnszdCreOYOFitdzebKxXagyKDOhjDk
/7rTMLQSRDya0WFZTXVrenLYlB75r7XoGV41egztOGpQX/aNFnQ0grag7xMl
Lj9xDTx18T0e8qVDZx/LFwWJ0gQNLZUDiB6YUcNlXPr+A0IV58qXCVc8avUo
DaWp13ybWk3WVpMaixjGu06/pJ0+g5GQKYraxcL1RUDdcazvQs83EpIaWfM+
um5KH8gSUy/vZZdJudGtUYLhXMUFCokBm3sblK4qc0yspL8vclQ0sXkk2nc2
t31Zo9CmN18Hoc9aEsNVub7Q2wi0s0Mnp5XTqIPdk20SzZ4jinvXk0trW2cv
P/4ONJ6w3XscK59xfLYQA7Gte6n/E8/2njgY22NYIZ7hWHYO+m/ZYWdhfap5
VxGYFrTTZOhrtHPWc7e2Z91RqqEZNRBT/hBpLyDfvunUWLQaM70WafJ6vprQ
NBgLif2WhDsis8W3BlLjr07kjRH5UqTZAsZaJPwtEDnn1Zs6pqetQDm0lHII
/kbkaBVwyLmfWtLTXmyIC72b+VrqXlxfca4FjeW2q197Hme8W8nY+ybBhgzH
SO2V6JV6wu1AdfROKuVSXSO2624ALiPG0vb9tfqu80vtN+csQxlUZFfZjIxz
+pV9UosZitokiLhnCyJvDkENlNsCXAKN0soXBh4+7nvS9UBOy3BaNLM5B+/A
8iMadASvIzblLphdnw91mKWgblBBmFo+s08sWWqspE7sV570HLIX6/s4wio9
m9iluqNv2XTkiHFI/rTZuzNl1TA6skMxtY12ZheN6TnFmXGQ2wcA22Z+YbrO
WCOV8ZmX8KjKHspNOacDFIWbzu1w4Glf/MhKzHlhqr5+z0vW4qbPXfrALDJG
f5DRB0HhjEBU+gMIxhbMeuGMO0qVFjT5Uw9rkYm35JjnsvUmc/o/lkjkP0vD
PpedoePX8ev4LRk/wkVyxZ/AoF8HWZeUs5zb+HUQ8k750tZ0W83Pn4xFIhd/
sr76AZVo5X+40htM\
\>"], "Picture",
 ImageSize->{278, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->305670387]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tips", "Subsubsection",
 CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
 CellID->221939370],

Cell[TextData[{
 "To use your most recent input or output in another evaluation, press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["L", "KeyEvent"],
 " or ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["L", "KeyEvent"],
 "."
}], "Notes",
 CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
 CellID->870817259],

Cell[TextData[{
 "Use the ",
 StyleBox["Syntax Coloring", "DialogElementName"],
 " dialog box to interpret and edit the meanings of colored syntax. To open \
the dialog box, choose ",
 StyleBox[ButtonBox["Edit",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EditMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 " and click the ",
 StyleBox["Syntax Coloring", "DialogElementName"],
 " tab."
}], "Notes",
 CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
 CellID->724617708]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Some ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " conventions"
}], "Section",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->651392543],

Cell[TextData[{
 "Built-in functions are capitalized. Arguments to functions are wrapped with \
square brackets.\n",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", "x", "]"}]], "InlineFormula"]
}], "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->713080572],

Cell[TextData[{
 "Each of these represents multiplication:\n",
 Cell[BoxData[
  RowBox[{"a", "*", "b"}]], "InlineFormula"],
 "    ",
 Cell[BoxData[
  RowBox[{"a", " ", "b"}]], "InlineFormula"],
 "    ",
 Cell[BoxData[
  RowBox[{"a", 
   RowBox[{"(", 
    RowBox[{"b", "+", "1"}], ")"}]}]], "InlineFormula"],
 "\n",
 Cell[BoxData[
  RowBox[{"2", "x"}]], "InlineFormula"],
 " means ",
 Cell[BoxData[
  RowBox[{"2", "*", "x"}]], "InlineFormula"],
 "."
}], "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->195371028],

Cell[TextData[{
 "These are standard arithmetic operations:\n",
 Cell[BoxData[
  RowBox[{"2", "+", "3"}]], "InlineFormula"],
 "    ",
 Cell[BoxData[
  RowBox[{"2", "-", "3"}]], "InlineFormula"],
 "    ",
 Cell[BoxData[
  RowBox[{"2", "/", "3"}]], "InlineFormula"],
 "    ",
 Cell[BoxData[
  RowBox[{"2", "^", "3"}]], "InlineFormula"]
}], "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->37976782],

Cell[TextData[{
 "Uppercase and lowercase letters are recognized as different characters. \
Lists are wrapped with curly brackets.\n",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "B"}], "}"}]], "InlineFormula"]
}], "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->162752057],

Cell[TextData[{
 "Built-in symbols are capitalized. Commas are used to separate arguments. A \
semicolon suppresses output, but the command is still evaluated.\n",
 Cell[BoxData[
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", " ", "50"}], "]"}], ";"}]], "InlineFormula"]
}], "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->643380487],

Cell[TextData[{
 "Variables are usually lowercase. Entire words can be used.\n",
 Cell[BoxData[
  RowBox[{"x", "=", "5"}]], "InlineFormula"],
 "    ",
 Cell[BoxData[
  RowBox[{"xvalue", "=", "3"}]], "InlineFormula"]
}], "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->171604328],

Cell[CellGroupData[{

Cell["Tips", "Subsubsection",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->76532856],

Cell[TextData[{
 "After your first evaluation, built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions will turn black when typed as input. Other names will appear \
blue. For more information about syntax coloring, choose the ",
 StyleBox["Syntax Coloring", "DialogElementName"],
 " tab in ",
 StyleBox[ButtonBox["Edit",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EditMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 "."
}], "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->270056219],

Cell[TextData[{
 "For information about a function, type ",
 Cell[BoxData[
  ButtonBox["?",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 ", the function name, and press ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 "."
}], "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->1201926622],

Cell[TextData[{
 "You can use Greek letters or other mathematical symbols as variables. See \
\"",
 ButtonBox["Entering Notation",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/EnteringInputInNotebooks#310290317"],
 "\" for more information."
}], "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->790848335],

Cell[TextData[{
 "To abort a calculation, press ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 " on Windows, ",
 StyleBox["Command", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 " on Macintosh, or ",
 StyleBox["Mod1", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[".", "KeyEvent"],
 " on Unix. On Unix, to find out which keys represent ",
 StyleBox["Mod1", "KeyEvent"],
 " and ",
 StyleBox["Mod2", "KeyEvent"],
 ", choose ",
 StyleBox[ButtonBox["Help",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/HelpMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Environment Information", "MenuName"],
 ". Typically the ",
 StyleBox["Alt", "KeyEvent"],
 " key represents ",
 StyleBox["Mod1", "KeyEvent"],
 "."
}], "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->1011675062],

Cell[TextData[{
 "To complete a given command name, press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " on Windows, ",
 StyleBox["Command", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " on Macintosh, or ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " on Unix."
}], "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->1594733735],

Cell[TextData[{
 "To see a template, press ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " on Windows, ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Command", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " on Macintosh, or ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " on Unix."
}], "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->2093969585]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Entering Notation", "Section",
 PageBreakAbove->True,
 CellTags->{
  "Entering mathematical notation with keyboard", 
   "Mathematical notation: entering with keyboard", 
   "Formulas: entering with keyboard", 
   "Two-dimensional notation: entering with keyboard", 
   "Powers: entering with keyboard", "Fractions: entering with keyboard", 
   "Fractions: getting out of", "Square roots: entering with keyboard", 
   "Subscripts: entering keyboard", 
   "Two-dimensional structure: move cursor from", 
   "Cursor: moving from two-dimensional structure", "Control-Space", 
   "Matrices: entering", "Create Table/Matrix/Palette", 
   "Columns: adding to matrix", "Rows: adding to matrix", 
   "Special characters: entering with keyboard", 
   "Entering Greek letters with keyboard", "Full names of characters", 
   "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
   "Complete Characters Palette", "Palette: Complete Characters", 
   "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
   "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
 CellID->310290317],

Cell["\<\
Mathematical symbols and two-dimensional notation can be entered from the \
keyboard as well as through palettes.\
\>", "TextNote",
 CellTags->{"notation", "gs:0.7"},
 CellID->269559308]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mathematical  formulas", "Section",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->66728874],

Cell["You can use keystrokes for two-dimensional input.", "Text",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->23984578],

Cell[BoxData[GridBox[{
   {Cell["Formula", "TableHeader"], Cell["Keystrokes", "TableHeader"], Cell[
    "Result", "TableHeader"]},
   {Cell["power", "TableText"], Cell[TextData[{
     "x ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " 3"
    }], "TableText"], 
    SuperscriptBox["x", "3"]},
   {Cell["fraction", "TableText"], Cell[TextData[{
     "x ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["/", "KeyEvent"],
     " 3"
    }], "TableText"], 
    FractionBox["x", "3"]},
   {Cell["square root", "TableText"], Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["2", "KeyEvent"],
     " x"
    }], "TableText"], 
    SqrtBox["x"]},
   {Cell["subscript", "TableText"], Cell[TextData[{
     "x ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " 3"
    }], "TableText"], 
    SubscriptBox["x", "3"]},
   {Cell["move cursor out of formula by one level", "TableText"], Cell[
    TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], " "}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{GridBoxDividers->{"Rows" -> {False, True, {False}}}},
 CellID->320096479],

Cell[TextData[{
 "You can use ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " as an alternative to ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 "; on some non-U.S. keyboards, you may have to use ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 "."
}], "Text",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->545236557],

Cell["Practice entering a formula by going through these steps.", "Text",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->102694231],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["x", "MR"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"]
}], "ItemizedText",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->15336287],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw/ARiNwUGEPs/kAkl
fjL8/w9kMYOoryARRogARIQBBnBInT17luEzw8yZM5mwy4PoT2BVzCBVcOMo
VckEUvkOxGQiTQ+ayldgkgUsD5IFYfy+QTcFJPYSTLLC+UgmMYwaNWrUqFGj
Ro0aNeKNug4iWRlE+f/yUs/Q22CSGWQqmAXC3KPGQ8RUQSQbiLeBthapgUgW
EG8jbS1SB5FgPZuGiUV0CzpEYkBr24ItX0lby3WgxsP4EHWYYssgwU7dMgJi
ORucDwNQ9nI0r4No+tkO9jEwDpADnhbeJxz2i6FWIruEVuEBDo4lEBZ1fTs4
675Ro0aNGjVq1KgRZhQIkDnG9A6iCNM8+o2yfQKTqAGDfXjwC4iA1KkM0BFF
BkYAXEYOVA==\
\>"], "ItemizedPicture",
 ImageSize->{249, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->573402458]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["2", "MR"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"]
}], "ItemizedText",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->254279257],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw/ARiNwUGEPs/kAkl
fjL8/w9kMYOoryARRogARIQBBnBInT17luEzw8yZM5mwy4PoT2BVzCBVcOMo
VckEUvkOxGQiTQ+ayldgkgUsD5IFYfy+QTcFJPYSTLLC+UgmMYwaNWrUqFGj
Ro0aNTSNug4iWRlE+f/yUs9QEzDJDOeD8BKoGNAmuBj3qJWkWakKItlAPE76
W64GIllAPC76W64OIsF6uEeY5QMa7AOa4HQgZRNcLV0t14XHOSv9LdeDW86C
xfLFEFnqltn6cCuxBfYiNP+CaCpargO3HK1fhs0tC8EkC0rYUzcswHHPjCv4
F0AtQrafBmFyDZL1qOuzwdkIGTVq1KhRo0aNGgpGgQCZw2rvIIowzaPfwOIn
MIkaMNhHRL+ACCaIEHQQlYERAP1ZgiQ=\
\>"], "ItemizedPicture",
 ImageSize->{249, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->12424241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["+", "MR"],
 " ",
 StyleBox["1", "MR"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"]
}], "ItemizedText",
 PageBreakAbove->False,
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->233296968],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw/ARiNwUGEPs/kAkl
fjL8/w9kMYOoryARRogARIQBBnBInT17luEzw8yZM5mwy4PoT2BVzCBVcOMo
VckEUvkOxGQiTQ+ayldgkgUsD5IFYfy+QTcFJPYSTLLC+UgmMYwaNWrUqFFD
yqgbIJKVQZT/Lw/1DHUDkRwgXh+YzwwyH8wCYS4qWwQUg/FBmAWLWA99ncEA
1sWAobd31Bkj3hkDmUTpkSXvjBqP23g1EMkG4vFhSQLzaWu5OohkAfH46W+5
BohkgvscbCYbiMVNhzSJsFxghAU7IsFtoK1FuvBYXUVbi/TgcbmGthbpwy1a
TVuLDOAWicBjawIdYgusB63rKwaXmESHaARnBXF6WelBf4smQlg0aF2zYEsl
IJqKFrnD46gfzGdBCTDqegoRZn1QQ5HtooHnrkPyGnV9MTj7eKNGjRo1MowC
ATKHOd9BFGGaR7+B3k/Q4hw5YLCPUH8BEUwQIeigNgMjAA9CGlY=\
\>"], "ItemizedPicture",
 PageBreakAbove->False,
 ImageSize->{249, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->295143837]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " ",
 StyleBox["x", "MR"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"]
}], "ItemizedText",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->216776244],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw/ARiNwUGEPs/kAkl
fjL8/w9kMYOoryARRogARIQBBnBInT17luEzw8yZM5mwy4PoT2BVzCBVcOMo
VckEUvkOxGQiTQ+ayldgkgUsD5IFYfy+QTcFJPYSTLLC+UgmMYwaNWrU8DLq
BohkZRDl/8tDPUN9wCQznA/CAljEqqBiQNvhYlzDzhnekJINCNhBLDYQi3Ug
ncEBYrGAWGz0d4YXmGRBsRLmJkQgjbrJDbubmLG4hHUg49MdRDLjchrLQKZ4
DyxWYnMkH/2d5jfqDCRn+GOxkndkO4MXV46iseXx9LfyDm2NV4MXQdhS9nza
Wq4OIsFFMz/9LdcAkUxwn4PNBNcQMiBWLb0sx9bkGs7BjkhwG2hrkS48VlfR
1iI9eFyuoa1F+nCLVtPWIgO4RbLw2GqnQ2yB9SApBgF5uEQnHaIRnBUU6GVl
IP0t6oCwqNuj9YcXKOipBERT0aIAeBy1gfksKAFGXU8hwqwVaiiyXTTw3HVI
XqOuLwbnuMqoUaNGUdsoECBzjPsdRBGmefQb5f8ELTiRAwb79MQXEMEEEYLO
aDAwAgC36Awd\
\>"], "ItemizedPicture",
 ImageSize->{249, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->960790530]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["+", "MR"],
 " ",
 StyleBox["a", "MR"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " ",
 StyleBox["1", "MR"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"]
}], "ItemizedText",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->80127512],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1OwkAQXtotEkQxMR6NHIyaGMGrZxIw/h/8PahpiAkcjAZ5AF+Dh+Ks
B19ADxxQDxwMdqZlKLglQZfdGrrJTqc70/m+nR12G7pv18o3t3atUrIzxap9
X66UHjKFu6ozZMYYY22nFzIM9I6jeqLNOh1HM+HyCSMxd8AdYd0WYGo0Guyd
1et1Q2yHawu9TPCicH/1NMCzCaox2jMDnm8oOdrBCn34bAajwNgrSovufZFY
FCoKFYJQzyAttpD+SskL+oLShKioQU/KC7/nhe/eQ18ByWFkSmC9UE9o1d2E
nJZQT2iXwDEbcdCSAhpxsprhoJugZZwW0LDIzyCN6yS+g5L3QXaZGJR0hPp/
3FNBBWNRwZiauBfE3M2gmhmpombVz6dIyRRNgdOvdJ4mk1ZPclsAKaKbU0/t
IKLho3EogMxONo0ZuFtWD/44EZD48oUblGjvzKsnhC9fgfukBkJrIHunC8bE
s3QLNK6T0Fw4MhS6JesV9bF68A2qEtGZMmbwLNXGkXrwHIGLzo8xg28S+Dqt
/qKm1cdnfM7QeoYlTWWBiFmdNK7DC37uWuX+mXIJkgdBng3MF64Swa9ozUXg
pyh5X7LlTn54vk88ID/+GJLw5O4FcmcWzr8Do1BRKNmhoP3ye0rTdfoZT90X
pZa37/gTI/4U9gHCcIe8r2cs9g2FywtO\
\>"], "ItemizedPicture",
 ImageSize->{249, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->291792303],

Cell["\<\
Any part of a two-dimensional formula can be selected and edited.\
\>", "Text",
 PageBreakAbove->False,
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->509924950]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tables and Matrices", "Section",
 PageBreakAbove->True,
 CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
 CellID->762462733],

Cell[TextData[{
 "Tables and matrices can be entered using the command ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Table/Matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TableMatrix"], "MenuName"],
 ". In the dialog box, specify the number of rows and columns. Press ",
 StyleBox["Tab", "KeyEvent"],
 " to fill in successive entries."
}], "Text",
 CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
 CellID->6671827],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1OwkAQHvoDGJUfgYOeOIk3vXnwriceoiEmcDAaRD3wJDwURz34EHog
hmgi2Nltp9Buk4ZstwW3yU6/zk7nm9l2p79dZ9S/vXNGg57Tvhk6D/1B77F9
fT90VWYBABZu67YB8dKFnljAcukiE1c/qClwBdeAv8R0TadT+ILJZGIwaCKk
faLmuJ6nYMnYZwiTxyGy/GTSYv3Yi40ll9gL6j6YtGl7xRNoV9rVpq7eUNrQ
qv425Dl9Z9JErwxhq2+N+zM+593lktBLupQdIrIRFRFVBKhIds9KA3J7/R6+
R1R3INnO0qlKT/WUiIoZpWpTBE861XRSjS0eJfUBXWlKTakpNSXAMaIyohP1
5GVEFqJDj9K3wWYJdPsosyqbe4QqodCAeYKIvxxflHYqmeAKGz6RtjUZIxTz
jhyoEs34cDK5nPGsQJkUblZ1MpirF+rJ/8d1UFNqyu2iFD1VVhGx8lrOqFgy
VCNkEKoIdMoqekdAWSfUWh9TtW+3goCOCDXzEVBjfaxMwSEzJL+iDl7yWnQq
NwUjFH/rgmuJAZ1T5klP6jHbz1o7UHIHKbgJqNMg1QiNPaJV/hQG5pUXHbmZ
5fNjjHalXYG/bPjdeMaNov7UfTmfe5VydWDEfwB8o+BPjOD9NACFP8H0rWA=
\
\>"], "Picture",
 ImageSize->{254, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
 CellID->14649221],

Cell["Tables can also be entered directly from the keyboard.", "Text",
 CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
 CellID->587569907],

Cell[BoxData[GridBox[{
   {Cell["Action", "TableHeader"], Cell["Keystrokes", "TableHeader"]},
   {Cell["add a column", "TableText"], Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox[",", "KeyEvent"]
    }], "TableText"]},
   {Cell["add a row", "TableText"], Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Enter", "KeyEvent"]
    }], "TableText"]},
   {Cell["move out of table", "TableText"], Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxDividers->{"Rows" -> {False, True, {False}}}},
 CellID->108121815],

Cell[CellGroupData[{

Cell["Tips", "Subsubsection",
 CellID->10248373],

Cell["Type parentheses around a table to display it as a matrix.", "Notes",
 CellID->1395786496],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " to preserve or create matrix structure in evaluations."
}], "Notes",
 CellID->2019762091]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special characters", "Section",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->172450535],

Cell[TextData[{
 "Every special character in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a full name, such as ",
 Cell[BoxData[
  ButtonBox["\\[Alpha]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Alpha"]], "InlineCharacterName"],
 ". Common characters also have short aliases using the ",
 StyleBox["Esc", "KeyEvent"],
 " key."
}], "Text",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->472436714],

Cell[BoxData[GridBox[{
   {Cell["Character", "TableHeader"], Cell["Full name", "TableHeader"], Cell[
    "Alias", "TableHeader"]},
   {Cell[TextData[Cell[BoxData[
     FormBox["\[Alpha]", TraditionalForm]], "InlineMath"]], "TableText"], 
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "Alpha", "]"}]}], Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["a", "InlineCode"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"]},
   {Cell[TextData[Cell[BoxData[
     FormBox["\[Beta]", TraditionalForm]], "InlineMath"]], "TableText"], 
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "Beta", "]"}]}], Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["b", "InlineCode"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"]},
   {Cell[TextData[Cell[BoxData[
     FormBox["\[Pi]", TraditionalForm]], "InlineMath"]], "TableText"], 
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "Pi", "]"}]}], Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]pi\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"]},
   {Cell[TextData[Cell[BoxData[
     FormBox["\[Integral]", TraditionalForm]], "InlineMath"]], "TableText"], 
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "Integral", "]"}]}], Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
     " (differential operator)"
    }], "TableText"], 
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "DifferentialD", "]"}]}], Cell[TextData[{
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"]
    }], "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{GridBoxDividers->{"Rows" -> {False, True, {False}}}},
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->77122898],

Cell["\<\
Practice entering special characters in either of these ways:\
\>", "Text",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->939358241],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\[Backslash][Alpha]", "MR"]], "ItemizedText",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->18110453],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwsjAwMJgrMIDY/4FM
KPEfiP6zgggGBmYQBRZmhBAQHjOUhgB88mfPnmX4xzBz5kwm7PIg+i9YFTNI
FdxMSlUygVT+BDGZSNODpvIrmGQBy4NkQRi/b9BNAYl9AZOscD6SSQyjRo0a
NWrUqFGDyaibkCpAlP+vGPUM1QOTzHA+CK+BigFtgouJjFpJmpXqIBJiIytc
MUwSBNbR1n41EAnWA60okQAT/YMD4RwmVNaIdAY4cbCBuaiK19LWXg2cnqZD
isSWCVdDHET7Mm0Vmt9ANI2tXAkmWVCCk/YeXQE1HtlWGnj4BiQFU9c/g7Pe
HTVq1CgGGCCz6/kToojYTi8tOt9/oYUFcsDgGTqAVBAMyOMODIwA7amQ4w==
\
\>"], "ItemizedPicture",
 ImageSize->{260, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->747403082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]b", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"]
}], "ItemizedText",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->473253524],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwsjAwMJgrMIDY/4FM
KAEGrCCCgYEZwgMKM0IICIcZJgrVgVv+7NmzDP/+z5w5kwm7PIj6C1bFDFIF
N5NSlUwglT9BTCbS9KCp/AomWcDqgLJgjN836KaAxL6ASVYYH9kkhlGjRo0a
NWrUKIqNugkiWf+L8v8Vo56hlmCSGW4UiLcQKga0CS4mQj0rDUEkWA/bCLNc
HUSCbUSrYVkhUQtkMdHfVWrwIIHWg1BXwQOJCe4wJjS3g6hF9HIdwgWjrsKT
vtjgbmEZoASlgRoQaJazIAKHFW4UTAFIdDFtXWdMyP5FEAXULWdNQCQzrjCZ
j+ZlIM1A40J+HjQykEKZDlXLXKjxyLbSwMM3QCQblf0zOFsFo0aNGkVto0Cl
IJkd458QRcR2yWkxNAAuWdACBs/ABqQ8hoQXdFSEgREAjc0kiA==\
\>"], "ItemizedPicture",
 ImageSize->{260, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->514130813],

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 " appears on the screen as \[AliasDelimiter] and disappears when the \
substitution occurs."
}], "Text",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->477960995]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tips", "Subsubsection",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->152554343],

Cell[TextData[{
 StyleBox[ButtonBox["Palettes",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PalettesMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Special Characters", "MenuName"],
 " lists all special characters. The name of each character is displayed when \
the cursor is over the character."
}], "Notes",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->867455308],

Cell[TextData[{
 "In some cases, the special character is replaced automatically without \
pressing the ",
 StyleBox["Esc", "KeyEvent"],
 " key. For example, ",
 Cell[BoxData[">="], "InlineFormula"],
 " is converted to ",
 Cell[BoxData["\[GreaterEqual]"], "InlineFormula"],
 ". "
}], "Notes",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->54882073],

Cell[TextData[{
 "You can also use ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.30000000000000004`, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " names as aliases for special characters, such as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]\\infty", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->1132516348],

Cell[TextData[{
 StyleBox["Unix:",
  FontWeight->"Bold"],
 " If the main ",
 StyleBox["Ctrl", "KeyEvent"],
 " key is remapped, the keyboard commands discussed above will not work."
}], "Notes",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->1054697475]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "RelatedTutorials",
 CellID->806871991],

Cell[TextData[ButtonBox["Entering Two-Dimensional Input",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalInput"]], "RelatedTutorials",
 CellID->1646679440],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"RelatedTutorials",
 CellID->683818123]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Entering Input in Notebooks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 7.9703922}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "Type 2+2 and then press Shift+Enter (hold down the Shift key and press \
Enter) to tell Mathematica to evaluate your input. Labels are added \
automatically. Output is placed below the input.", "synonyms" -> {}, "title" -> 
    "Entering Input in Notebooks", "type" -> "Tutorial", "uri" -> 
    "tutorial/EnteringInputInNotebooks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "starting"->{
  Cell[1701, 54, 178, 6, 70, "Section",
   PageBreakAbove->True,
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[1882, 62, 469, 17, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[2354, 81, 689, 14, 70, "Picture",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3046, 97, 99, 1, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3148, 100, 101, 1, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3252, 103, 1168, 21, 70, "Picture",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[4423, 126, 244, 7, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[4670, 135, 315, 7, 70, "TextNote",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[5010, 146, 81, 1, 70, "Subsubsection",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[5094, 149, 387, 13, 70, "Notes",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
   CellID->1008559715],
  Cell[5484, 164, 551, 14, 70, "Notes",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
   CellID->774704234]},
 "i:63"->{
  Cell[1701, 54, 178, 6, 70, "Section",
   PageBreakAbove->True,
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[1882, 62, 469, 17, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[2354, 81, 689, 14, 70, "Picture",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3046, 97, 99, 1, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3148, 100, 101, 1, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3252, 103, 1168, 21, 70, "Picture",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[4423, 126, 244, 7, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[4670, 135, 315, 7, 70, "TextNote",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[5010, 146, 81, 1, 70, "Subsubsection",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[5094, 149, 387, 13, 70, "Notes",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
   CellID->1008559715],
  Cell[5484, 164, 551, 14, 70, "Notes",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
   CellID->774704234]},
 "b:2.3"->{
  Cell[1701, 54, 178, 6, 70, "Section",
   PageBreakAbove->True,
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[1882, 62, 469, 17, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[2354, 81, 689, 14, 70, "Picture",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3046, 97, 99, 1, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3148, 100, 101, 1, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3252, 103, 1168, 21, 70, "Picture",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[4423, 126, 244, 7, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[4670, 135, 315, 7, 70, "TextNote",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[5010, 146, 81, 1, 70, "Subsubsection",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[5094, 149, 387, 13, 70, "Notes",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
   CellID->1008559715],
  Cell[5484, 164, 551, 14, 70, "Notes",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
   CellID->774704234]},
 "gs:0.3"->{
  Cell[1701, 54, 178, 6, 70, "Section",
   PageBreakAbove->True,
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[1882, 62, 469, 17, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[2354, 81, 689, 14, 70, "Picture",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3046, 97, 99, 1, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3148, 100, 101, 1, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[3252, 103, 1168, 21, 70, "Picture",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[4423, 126, 244, 7, 70, "Text",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[4670, 135, 315, 7, 70, "TextNote",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[5010, 146, 81, 1, 70, "Subsubsection",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
  Cell[5094, 149, 387, 13, 70, "Notes",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
   CellID->1008559715],
  Cell[5484, 164, 551, 14, 70, "Notes",
   CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
   CellID->774704234]},
 "Calculations"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Input: executing"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "SHIFT-RETURN"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Terminating input"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Executing calculations"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Entering input"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Conventions: Mathematica"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Input cell"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Output cell"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Capital letters"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Built-in functions: conventions for"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Arguments to functions"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Upper-case letters"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Lower-case letters"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Curly brackets"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Braces"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Brackets: conventions for"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Syntax: Mathematica"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Grammar: Mathematica"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Notation: Mathematica"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "First calculations"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Tour of Mathematica"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Notebooks"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Help Browser examples"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "Examples to try"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "firstcalc"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605],
  Cell[6875, 205, 400, 14, 70, "TextEmphasisNote",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->193950997],
  Cell[7278, 221, 251, 10, 70, "Text",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->1924232],
  Cell[7532, 233, 91, 2, 70, "Text",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->304815992],
  Cell[7626, 237, 1376, 26, 70, "Picture",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->405220212],
  Cell[9005, 265, 338, 10, 70, "Text",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->92108902],
  Cell[9346, 277, 2052, 37, 70, "Picture",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->305670387],
  Cell[11435, 319, 102, 2, 70, "Subsubsection",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->221939370],
  Cell[11540, 323, 448, 14, 70, "Notes",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->870817259],
  Cell[11991, 339, 630, 17, 70, "Notes",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->724617708],
  Cell[12670, 362, 178, 7, 70, "Section",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->651392543],
  Cell[12851, 371, 345, 10, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->713080572],
  Cell[13199, 383, 538, 21, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->195371028],
  Cell[13740, 406, 422, 15, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->37976782],
  Cell[14165, 423, 318, 8, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->162752057],
  Cell[14486, 433, 369, 9, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->643380487],
  Cell[14858, 444, 305, 9, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->171604328],
  Cell[15188, 457, 101, 2, 70, "Subsubsection",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->76532856],
  Cell[15292, 461, 683, 18, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->270056219],
  Cell[15978, 481, 403, 13, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1201926622],
  Cell[16384, 496, 334, 9, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->790848335],
  Cell[16721, 507, 931, 30, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1011675062],
  Cell[17655, 539, 492, 16, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1594733735],
  Cell[18150, 557, 684, 22, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->2093969585]},
 "i:2"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605]},
 "gs:0.4"->{
  Cell[6084, 184, 766, 17, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
     "Executing calculations", "Entering input", "Conventions: Mathematica", 
     "Input cell", "Output cell", "Capital letters", 
     "Built-in functions: conventions for", "Arguments to functions", 
     "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
     "Brackets: conventions for", "Syntax: Mathematica", 
     "Grammar: Mathematica", "Notation: Mathematica", "First calculations", 
     "Tour of Mathematica", "Notebooks", "Help Browser examples", 
     "Examples to try", "firstcalc", "i:2", "gs:0.4"},
   CellID->233105605],
  Cell[6875, 205, 400, 14, 70, "TextEmphasisNote",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->193950997],
  Cell[7278, 221, 251, 10, 70, "Text",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->1924232],
  Cell[7532, 233, 91, 2, 70, "Text",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->304815992],
  Cell[7626, 237, 1376, 26, 70, "Picture",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->405220212],
  Cell[9005, 265, 338, 10, 70, "Text",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->92108902],
  Cell[9346, 277, 2052, 37, 70, "Picture",
   CellTags->{"firstcalc", "gs:0.4"},
   CellID->305670387],
  Cell[11435, 319, 102, 2, 70, "Subsubsection",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->221939370],
  Cell[11540, 323, 448, 14, 70, "Notes",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->870817259],
  Cell[11991, 339, 630, 17, 70, "Notes",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->724617708],
  Cell[12670, 362, 178, 7, 70, "Section",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->651392543],
  Cell[12851, 371, 345, 10, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->713080572],
  Cell[13199, 383, 538, 21, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->195371028],
  Cell[13740, 406, 422, 15, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->37976782],
  Cell[14165, 423, 318, 8, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->162752057],
  Cell[14486, 433, 369, 9, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->643380487],
  Cell[14858, 444, 305, 9, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->171604328],
  Cell[15188, 457, 101, 2, 70, "Subsubsection",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->76532856],
  Cell[15292, 461, 683, 18, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->270056219],
  Cell[15978, 481, 403, 13, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1201926622],
  Cell[16384, 496, 334, 9, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->790848335],
  Cell[16721, 507, 931, 30, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1011675062],
  Cell[17655, 539, 492, 16, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1594733735],
  Cell[18150, 557, 684, 22, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->2093969585]},
 "b:3.0"->{
  Cell[11435, 319, 102, 2, 70, "Subsubsection",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->221939370],
  Cell[11540, 323, 448, 14, 70, "Notes",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->870817259],
  Cell[11991, 339, 630, 17, 70, "Notes",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->724617708],
  Cell[12670, 362, 178, 7, 70, "Section",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->651392543],
  Cell[12851, 371, 345, 10, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->713080572],
  Cell[13199, 383, 538, 21, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->195371028],
  Cell[13740, 406, 422, 15, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->37976782],
  Cell[14165, 423, 318, 8, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->162752057],
  Cell[14486, 433, 369, 9, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->643380487],
  Cell[14858, 444, 305, 9, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->171604328],
  Cell[15188, 457, 101, 2, 70, "Subsubsection",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->76532856],
  Cell[15292, 461, 683, 18, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->270056219],
  Cell[15978, 481, 403, 13, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1201926622],
  Cell[16384, 496, 334, 9, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->790848335],
  Cell[16721, 507, 931, 30, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1011675062],
  Cell[17655, 539, 492, 16, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1594733735],
  Cell[18150, 557, 684, 22, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->2093969585]},
 "i:12"->{
  Cell[11435, 319, 102, 2, 70, "Subsubsection",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->221939370],
  Cell[11540, 323, 448, 14, 70, "Notes",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->870817259],
  Cell[11991, 339, 630, 17, 70, "Notes",
   CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
   CellID->724617708],
  Cell[12670, 362, 178, 7, 70, "Section",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->651392543],
  Cell[12851, 371, 345, 10, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->713080572],
  Cell[13199, 383, 538, 21, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->195371028],
  Cell[13740, 406, 422, 15, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->37976782],
  Cell[14165, 423, 318, 8, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->162752057],
  Cell[14486, 433, 369, 9, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->643380487],
  Cell[14858, 444, 305, 9, 70, "FramedBox",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->171604328],
  Cell[15188, 457, 101, 2, 70, "Subsubsection",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->76532856],
  Cell[15292, 461, 683, 18, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->270056219],
  Cell[15978, 481, 403, 13, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1201926622],
  Cell[16384, 496, 334, 9, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->790848335],
  Cell[16721, 507, 931, 30, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1011675062],
  Cell[17655, 539, 492, 16, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->1594733735],
  Cell[18150, 557, 684, 22, 70, "Notes",
   CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
   CellID->2093969585]},
 "Entering mathematical notation with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Mathematical notation: entering with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Formulas: entering with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Two-dimensional notation: entering with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Powers: entering with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Fractions: entering with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Fractions: getting out of"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Square roots: entering with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Subscripts: entering keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Two-dimensional structure: move cursor from"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Cursor: moving from two-dimensional structure"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Control-Space"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Matrices: entering"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Create Table/Matrix/Palette"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Columns: adding to matrix"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Rows: adding to matrix"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Special characters: entering with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Entering Greek letters with keyboard"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Full names of characters"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Aliases: for characters"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "TeX aliases"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Aliases: based on TeX"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Complete Characters Palette"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Palette: Complete Characters"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Keyboard shortcuts for characters"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Mathematical symbols: entering"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "Escape key: on-screen representation"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "notation"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317],
  Cell[20009, 607, 196, 5, 70, "TextNote",
   CellTags->{"notation", "gs:0.7"},
   CellID->269559308],
  Cell[20242, 617, 112, 2, 70, "Section",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->66728874],
  Cell[20357, 621, 136, 2, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->23984578],
  Cell[21883, 669, 491, 16, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->545236557],
  Cell[22377, 687, 145, 2, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->102694231],
  Cell[22547, 693, 229, 8, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->15336287],
  Cell[22779, 703, 668, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->573402458],
  Cell[23484, 722, 234, 8, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->254279257],
  Cell[23721, 732, 687, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->12424241],
  Cell[24445, 751, 282, 11, 70, "ItemizedText",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->233296968],
  Cell[24730, 764, 793, 16, 70, "ItemizedPicture",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->295143837],
  Cell[25560, 785, 336, 12, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->216776244],
  Cell[25899, 799, 851, 17, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->960790530],
  Cell[26787, 821, 497, 20, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->80127512],
  Cell[27287, 843, 932, 18, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->291792303],
  Cell[28222, 863, 185, 5, 70, "Text",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->509924950],
  Cell[28456, 874, 133, 3, 70, "Section",
   PageBreakAbove->True,
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->762462733],
  Cell[28592, 879, 578, 14, 70, "Text",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->6671827],
  Cell[29173, 895, 891, 18, 70, "Picture",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->14649221],
  Cell[30067, 915, 142, 2, 70, "Text",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->587569907],
  Cell[31445, 962, 109, 2, 70, "Section",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->172450535],
  Cell[31557, 966, 442, 14, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->472436714],
  Cell[32002, 982, 2177, 53, 70, "DefinitionBox3Col",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->77122898],
  Cell[34182, 1037, 157, 4, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->939358241],
  Cell[34364, 1045, 140, 2, 70, "ItemizedText",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->18110453],
  Cell[34507, 1049, 656, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->747403082],
  Cell[35200, 1068, 249, 7, 70, "ItemizedText",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->473253524],
  Cell[35452, 1077, 708, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->514130813],
  Cell[36163, 1093, 223, 6, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->477960995],
  Cell[36423, 1104, 101, 2, 70, "Subsubsection",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->152554343],
  Cell[36527, 1108, 430, 10, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->867455308],
  Cell[36960, 1120, 363, 11, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->54882073],
  Cell[37326, 1133, 582, 18, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->1132516348],
  Cell[37911, 1153, 266, 8, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->1054697475]},
 "i:44"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317]},
 "gs:0.7"->{
  Cell[18883, 585, 1123, 20, 70, "Section",
   PageBreakAbove->True,
   CellTags->{
    "Entering mathematical notation with keyboard", 
     "Mathematical notation: entering with keyboard", 
     "Formulas: entering with keyboard", 
     "Two-dimensional notation: entering with keyboard", 
     "Powers: entering with keyboard", "Fractions: entering with keyboard", 
     "Fractions: getting out of", "Square roots: entering with keyboard", 
     "Subscripts: entering keyboard", 
     "Two-dimensional structure: move cursor from", 
     "Cursor: moving from two-dimensional structure", "Control-Space", 
     "Matrices: entering", "Create Table/Matrix/Palette", 
     "Columns: adding to matrix", "Rows: adding to matrix", 
     "Special characters: entering with keyboard", 
     "Entering Greek letters with keyboard", "Full names of characters", 
     "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
     "Complete Characters Palette", "Palette: Complete Characters", 
     "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
     "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
   CellID->310290317],
  Cell[20009, 607, 196, 5, 70, "TextNote",
   CellTags->{"notation", "gs:0.7"},
   CellID->269559308],
  Cell[20242, 617, 112, 2, 70, "Section",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->66728874],
  Cell[20357, 621, 136, 2, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->23984578],
  Cell[21883, 669, 491, 16, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->545236557],
  Cell[22377, 687, 145, 2, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->102694231],
  Cell[22547, 693, 229, 8, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->15336287],
  Cell[22779, 703, 668, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->573402458],
  Cell[23484, 722, 234, 8, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->254279257],
  Cell[23721, 732, 687, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->12424241],
  Cell[24445, 751, 282, 11, 70, "ItemizedText",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->233296968],
  Cell[24730, 764, 793, 16, 70, "ItemizedPicture",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->295143837],
  Cell[25560, 785, 336, 12, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->216776244],
  Cell[25899, 799, 851, 17, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->960790530],
  Cell[26787, 821, 497, 20, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->80127512],
  Cell[27287, 843, 932, 18, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->291792303],
  Cell[28222, 863, 185, 5, 70, "Text",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->509924950],
  Cell[28456, 874, 133, 3, 70, "Section",
   PageBreakAbove->True,
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->762462733],
  Cell[28592, 879, 578, 14, 70, "Text",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->6671827],
  Cell[29173, 895, 891, 18, 70, "Picture",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->14649221],
  Cell[30067, 915, 142, 2, 70, "Text",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->587569907],
  Cell[31445, 962, 109, 2, 70, "Section",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->172450535],
  Cell[31557, 966, 442, 14, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->472436714],
  Cell[32002, 982, 2177, 53, 70, "DefinitionBox3Col",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->77122898],
  Cell[34182, 1037, 157, 4, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->939358241],
  Cell[34364, 1045, 140, 2, 70, "ItemizedText",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->18110453],
  Cell[34507, 1049, 656, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->747403082],
  Cell[35200, 1068, 249, 7, 70, "ItemizedText",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->473253524],
  Cell[35452, 1077, 708, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->514130813],
  Cell[36163, 1093, 223, 6, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->477960995],
  Cell[36423, 1104, 101, 2, 70, "Subsubsection",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->152554343],
  Cell[36527, 1108, 430, 10, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->867455308],
  Cell[36960, 1120, 363, 11, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->54882073],
  Cell[37326, 1133, 582, 18, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->1132516348],
  Cell[37911, 1153, 266, 8, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->1054697475]},
 "i:45"->{
  Cell[20242, 617, 112, 2, 70, "Section",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->66728874],
  Cell[20357, 621, 136, 2, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->23984578],
  Cell[21883, 669, 491, 16, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->545236557],
  Cell[22377, 687, 145, 2, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->102694231],
  Cell[22547, 693, 229, 8, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->15336287],
  Cell[22779, 703, 668, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->573402458],
  Cell[23484, 722, 234, 8, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->254279257],
  Cell[23721, 732, 687, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->12424241],
  Cell[24445, 751, 282, 11, 70, "ItemizedText",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->233296968],
  Cell[24730, 764, 793, 16, 70, "ItemizedPicture",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->295143837],
  Cell[25560, 785, 336, 12, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->216776244],
  Cell[25899, 799, 851, 17, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->960790530],
  Cell[26787, 821, 497, 20, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->80127512],
  Cell[27287, 843, 932, 18, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->291792303],
  Cell[28222, 863, 185, 5, 70, "Text",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->509924950]},
 "b:6.0"->{
  Cell[20242, 617, 112, 2, 70, "Section",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->66728874],
  Cell[20357, 621, 136, 2, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->23984578],
  Cell[21883, 669, 491, 16, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->545236557],
  Cell[22377, 687, 145, 2, 70, "Text",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->102694231],
  Cell[22547, 693, 229, 8, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->15336287],
  Cell[22779, 703, 668, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->573402458],
  Cell[23484, 722, 234, 8, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->254279257],
  Cell[23721, 732, 687, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->12424241],
  Cell[24445, 751, 282, 11, 70, "ItemizedText",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->233296968],
  Cell[24730, 764, 793, 16, 70, "ItemizedPicture",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->295143837],
  Cell[25560, 785, 336, 12, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->216776244],
  Cell[25899, 799, 851, 17, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->960790530],
  Cell[26787, 821, 497, 20, 70, "ItemizedText",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->80127512],
  Cell[27287, 843, 932, 18, 70, "ItemizedPicture",
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->291792303],
  Cell[28222, 863, 185, 5, 70, "Text",
   PageBreakAbove->False,
   CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
   CellID->509924950]},
 "i:46"->{
  Cell[28456, 874, 133, 3, 70, "Section",
   PageBreakAbove->True,
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->762462733],
  Cell[28592, 879, 578, 14, 70, "Text",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->6671827],
  Cell[29173, 895, 891, 18, 70, "Picture",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->14649221],
  Cell[30067, 915, 142, 2, 70, "Text",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->587569907]},
 "b:6.1"->{
  Cell[28456, 874, 133, 3, 70, "Section",
   PageBreakAbove->True,
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->762462733],
  Cell[28592, 879, 578, 14, 70, "Text",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->6671827],
  Cell[29173, 895, 891, 18, 70, "Picture",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->14649221],
  Cell[30067, 915, 142, 2, 70, "Text",
   CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
   CellID->587569907]},
 "i:47"->{
  Cell[31445, 962, 109, 2, 70, "Section",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->172450535],
  Cell[31557, 966, 442, 14, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->472436714],
  Cell[32002, 982, 2177, 53, 70, "DefinitionBox3Col",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->77122898],
  Cell[34182, 1037, 157, 4, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->939358241],
  Cell[34364, 1045, 140, 2, 70, "ItemizedText",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->18110453],
  Cell[34507, 1049, 656, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->747403082],
  Cell[35200, 1068, 249, 7, 70, "ItemizedText",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->473253524],
  Cell[35452, 1077, 708, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->514130813],
  Cell[36163, 1093, 223, 6, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->477960995],
  Cell[36423, 1104, 101, 2, 70, "Subsubsection",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->152554343],
  Cell[36527, 1108, 430, 10, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->867455308],
  Cell[36960, 1120, 363, 11, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->54882073],
  Cell[37326, 1133, 582, 18, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->1132516348],
  Cell[37911, 1153, 266, 8, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->1054697475]},
 "b:6.2"->{
  Cell[31445, 962, 109, 2, 70, "Section",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->172450535],
  Cell[31557, 966, 442, 14, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->472436714],
  Cell[32002, 982, 2177, 53, 70, "DefinitionBox3Col",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->77122898],
  Cell[34182, 1037, 157, 4, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->939358241],
  Cell[34364, 1045, 140, 2, 70, "ItemizedText",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->18110453],
  Cell[34507, 1049, 656, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->747403082],
  Cell[35200, 1068, 249, 7, 70, "ItemizedText",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->473253524],
  Cell[35452, 1077, 708, 14, 70, "ItemizedPicture",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->514130813],
  Cell[36163, 1093, 223, 6, 70, "Text",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->477960995],
  Cell[36423, 1104, 101, 2, 70, "Subsubsection",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->152554343],
  Cell[36527, 1108, 430, 10, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->867455308],
  Cell[36960, 1120, 363, 11, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->54882073],
  Cell[37326, 1133, 582, 18, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->1132516348],
  Cell[37911, 1153, 266, 8, 70, "Notes",
   CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
   CellID->1054697475]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"starting", 40285, 1225},
 {"i:63", 41414, 1251},
 {"b:2.3", 42544, 1277},
 {"gs:0.3", 43675, 1303},
 {"Calculations", 44812, 1329},
 {"Input: executing", 45557, 1343},
 {"SHIFT-RETURN", 46298, 1357},
 {"Terminating input", 47044, 1371},
 {"Executing calculations", 47795, 1385},
 {"Entering input", 48538, 1399},
 {"Conventions: Mathematica", 49291, 1413},
 {"Input cell", 50030, 1427},
 {"Output cell", 50770, 1441},
 {"Capital letters", 51514, 1455},
 {"Built-in functions: conventions for", 52278, 1469},
 {"Arguments to functions", 53029, 1483},
 {"Upper-case letters", 53776, 1497},
 {"Lower-case letters", 54523, 1511},
 {"Curly brackets", 55266, 1525},
 {"Braces", 56001, 1539},
 {"Brackets: conventions for", 56755, 1553},
 {"Syntax: Mathematica", 57503, 1567},
 {"Grammar: Mathematica", 58252, 1581},
 {"Notation: Mathematica", 59002, 1595},
 {"First calculations", 59749, 1609},
 {"Tour of Mathematica", 60497, 1623},
 {"Notebooks", 61235, 1637},
 {"Help Browser examples", 61985, 1651},
 {"Examples to try", 62729, 1665},
 {"firstcalc", 63467, 1679},
 {"i:2", 66874, 1762},
 {"gs:0.4", 67609, 1776},
 {"b:3.0", 71018, 1859},
 {"i:12", 73090, 1911},
 {"Entering mathematical notation with keyboard", 75202, 1963},
 {"Mathematical notation: entering with keyboard", 76427, 1985},
 {"Formulas: entering with keyboard", 77639, 2007},
 {"Two-dimensional notation: entering with keyboard", 78867, 2029},
 {"Powers: entering with keyboard", 80077, 2051},
 {"Fractions: entering with keyboard", 81290, 2073},
 {"Fractions: getting out of", 82495, 2095},
 {"Square roots: entering with keyboard", 83711, 2117},
 {"Subscripts: entering keyboard", 84920, 2139},
 {"Two-dimensional structure: move cursor from", 86143, 2161},
 {"Cursor: moving from two-dimensional structure", 87368, 2183},
 {"Control-Space", 88561, 2205},
 {"Matrices: entering", 89759, 2227},
 {"Create Table/Matrix/Palette", 90966, 2249},
 {"Columns: adding to matrix", 92171, 2271},
 {"Rows: adding to matrix", 93373, 2293},
 {"Special characters: entering with keyboard", 94595, 2315},
 {"Entering Greek letters with keyboard", 95811, 2337},
 {"Full names of characters", 97015, 2359},
 {"Aliases: for characters", 98218, 2381},
 {"TeX aliases", 99409, 2403},
 {"Aliases: based on TeX", 100610, 2425},
 {"Complete Characters Palette", 101817, 2447},
 {"Palette: Complete Characters", 103025, 2469},
 {"Keyboard shortcuts for characters", 104238, 2491},
 {"Mathematical symbols: entering", 105448, 2513},
 {"Escape key: on-screen representation", 106664, 2535},
 {"notation", 107852, 2557},
 {"i:44", 113262, 2685},
 {"gs:0.7", 114448, 2707},
 {"i:45", 119858, 2835},
 {"b:6.0", 121791, 2884},
 {"i:46", 123723, 2933},
 {"b:6.1", 124230, 2947},
 {"i:47", 124736, 2961},
 {"b:6.2", 126458, 3004}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 987, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1612, 49, 64, 1, 70, "Title",
 CellID->509267359],
Cell[CellGroupData[{
Cell[1701, 54, 178, 6, 70, "Section",
 PageBreakAbove->True,
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[1882, 62, 469, 17, 70, "Text",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[2354, 81, 689, 14, 70, "Picture",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[3046, 97, 99, 1, 70, "Text",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[3148, 100, 101, 1, 70, "Text",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[3252, 103, 1168, 21, 70, "Picture",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[4423, 126, 244, 7, 70, "Text",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[4670, 135, 315, 7, 70, "TextNote",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[CellGroupData[{
Cell[5010, 146, 81, 1, 70, "Subsubsection",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"}],
Cell[5094, 149, 387, 13, 70, "Notes",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
 CellID->1008559715],
Cell[5484, 164, 551, 14, 70, "Notes",
 CellTags->{"starting", "i:63", "b:2.3", "gs:0.3"},
 CellID->774704234]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6084, 184, 766, 17, 70, "Section",
 PageBreakAbove->True,
 CellTags->{
  "Calculations", "Input: executing", "SHIFT-RETURN", "Terminating input", 
   "Executing calculations", "Entering input", "Conventions: Mathematica", 
   "Input cell", "Output cell", "Capital letters", 
   "Built-in functions: conventions for", "Arguments to functions", 
   "Upper-case letters", "Lower-case letters", "Curly brackets", "Braces", 
   "Brackets: conventions for", "Syntax: Mathematica", "Grammar: Mathematica",
    "Notation: Mathematica", "First calculations", "Tour of Mathematica", 
   "Notebooks", "Help Browser examples", "Examples to try", "firstcalc", 
   "i:2", "gs:0.4"},
 CellID->233105605],
Cell[CellGroupData[{
Cell[6875, 205, 400, 14, 70, "TextEmphasisNote",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->193950997],
Cell[7278, 221, 251, 10, 70, "Text",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->1924232],
Cell[7532, 233, 91, 2, 70, "Text",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->304815992],
Cell[7626, 237, 1376, 26, 70, "Picture",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->405220212],
Cell[9005, 265, 338, 10, 70, "Text",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->92108902],
Cell[9346, 277, 2052, 37, 70, "Picture",
 CellTags->{"firstcalc", "gs:0.4"},
 CellID->305670387]
}, Open  ]],
Cell[CellGroupData[{
Cell[11435, 319, 102, 2, 70, "Subsubsection",
 CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
 CellID->221939370],
Cell[11540, 323, 448, 14, 70, "Notes",
 CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
 CellID->870817259],
Cell[11991, 339, 630, 17, 70, "Notes",
 CellTags->{"gs:0.4", "firstcalc", "b:3.0", "i:12"},
 CellID->724617708]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12670, 362, 178, 7, 70, "Section",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->651392543],
Cell[12851, 371, 345, 10, 70, "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->713080572],
Cell[13199, 383, 538, 21, 70, "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->195371028],
Cell[13740, 406, 422, 15, 70, "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->37976782],
Cell[14165, 423, 318, 8, 70, "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->162752057],
Cell[14486, 433, 369, 9, 70, "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->643380487],
Cell[14858, 444, 305, 9, 70, "FramedBox",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->171604328],
Cell[CellGroupData[{
Cell[15188, 457, 101, 2, 70, "Subsubsection",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->76532856],
Cell[15292, 461, 683, 18, 70, "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->270056219],
Cell[15978, 481, 403, 13, 70, "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->1201926622],
Cell[16384, 496, 334, 9, 70, "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->790848335],
Cell[16721, 507, 931, 30, 70, "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->1011675062],
Cell[17655, 539, 492, 16, 70, "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->1594733735],
Cell[18150, 557, 684, 22, 70, "Notes",
 CellTags->{"firstcalc", "i:12", "b:3.0", "gs:0.4"},
 CellID->2093969585]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18883, 585, 1123, 20, 70, "Section",
 PageBreakAbove->True,
 CellTags->{
  "Entering mathematical notation with keyboard", 
   "Mathematical notation: entering with keyboard", 
   "Formulas: entering with keyboard", 
   "Two-dimensional notation: entering with keyboard", 
   "Powers: entering with keyboard", "Fractions: entering with keyboard", 
   "Fractions: getting out of", "Square roots: entering with keyboard", 
   "Subscripts: entering keyboard", 
   "Two-dimensional structure: move cursor from", 
   "Cursor: moving from two-dimensional structure", "Control-Space", 
   "Matrices: entering", "Create Table/Matrix/Palette", 
   "Columns: adding to matrix", "Rows: adding to matrix", 
   "Special characters: entering with keyboard", 
   "Entering Greek letters with keyboard", "Full names of characters", 
   "Aliases: for characters", "TeX aliases", "Aliases: based on TeX", 
   "Complete Characters Palette", "Palette: Complete Characters", 
   "Keyboard shortcuts for characters", "Mathematical symbols: entering", 
   "Escape key: on-screen representation", "notation", "i:44", "gs:0.7"},
 CellID->310290317],
Cell[20009, 607, 196, 5, 70, "TextNote",
 CellTags->{"notation", "gs:0.7"},
 CellID->269559308]
}, Open  ]],
Cell[CellGroupData[{
Cell[20242, 617, 112, 2, 70, "Section",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->66728874],
Cell[20357, 621, 136, 2, 70, "Text",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->23984578],
Cell[20496, 625, 1384, 42, 70, "DefinitionBox3Col",
 CellID->320096479],
Cell[21883, 669, 491, 16, 70, "Text",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->545236557],
Cell[22377, 687, 145, 2, 70, "Text",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->102694231],
Cell[CellGroupData[{
Cell[22547, 693, 229, 8, 70, "ItemizedText",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->15336287],
Cell[22779, 703, 668, 14, 70, "ItemizedPicture",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->573402458]
}, Open  ]],
Cell[CellGroupData[{
Cell[23484, 722, 234, 8, 70, "ItemizedText",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->254279257],
Cell[23721, 732, 687, 14, 70, "ItemizedPicture",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->12424241]
}, Open  ]],
Cell[CellGroupData[{
Cell[24445, 751, 282, 11, 70, "ItemizedText",
 PageBreakAbove->False,
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->233296968],
Cell[24730, 764, 793, 16, 70, "ItemizedPicture",
 PageBreakAbove->False,
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->295143837]
}, Open  ]],
Cell[CellGroupData[{
Cell[25560, 785, 336, 12, 70, "ItemizedText",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->216776244],
Cell[25899, 799, 851, 17, 70, "ItemizedPicture",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->960790530]
}, Open  ]],
Cell[CellGroupData[{
Cell[26787, 821, 497, 20, 70, "ItemizedText",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->80127512],
Cell[27287, 843, 932, 18, 70, "ItemizedPicture",
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->291792303],
Cell[28222, 863, 185, 5, 70, "Text",
 PageBreakAbove->False,
 CellTags->{"notation", "i:45", "b:6.0", "gs:0.7"},
 CellID->509924950]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28456, 874, 133, 3, 70, "Section",
 PageBreakAbove->True,
 CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
 CellID->762462733],
Cell[28592, 879, 578, 14, 70, "Text",
 CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
 CellID->6671827],
Cell[29173, 895, 891, 18, 70, "Picture",
 CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
 CellID->14649221],
Cell[30067, 915, 142, 2, 70, "Text",
 CellTags->{"notation", "i:46", "b:6.1", "gs:0.7"},
 CellID->587569907],
Cell[30212, 919, 773, 19, 70, "DefinitionBox",
 CellID->108121815],
Cell[CellGroupData[{
Cell[31010, 942, 48, 1, 70, "Subsubsection",
 CellID->10248373],
Cell[31061, 945, 96, 1, 70, "Notes",
 CellID->1395786496],
Cell[31160, 948, 236, 8, 70, "Notes",
 CellID->2019762091]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31445, 962, 109, 2, 70, "Section",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->172450535],
Cell[31557, 966, 442, 14, 70, "Text",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->472436714],
Cell[32002, 982, 2177, 53, 70, "DefinitionBox3Col",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->77122898],
Cell[34182, 1037, 157, 4, 70, "Text",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->939358241],
Cell[CellGroupData[{
Cell[34364, 1045, 140, 2, 70, "ItemizedText",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->18110453],
Cell[34507, 1049, 656, 14, 70, "ItemizedPicture",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->747403082]
}, Open  ]],
Cell[CellGroupData[{
Cell[35200, 1068, 249, 7, 70, "ItemizedText",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->473253524],
Cell[35452, 1077, 708, 14, 70, "ItemizedPicture",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->514130813],
Cell[36163, 1093, 223, 6, 70, "Text",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->477960995]
}, Open  ]],
Cell[CellGroupData[{
Cell[36423, 1104, 101, 2, 70, "Subsubsection",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->152554343],
Cell[36527, 1108, 430, 10, 70, "Notes",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->867455308],
Cell[36960, 1120, 363, 11, 70, "Notes",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->54882073],
Cell[37326, 1133, 582, 18, 70, "Notes",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->1132516348],
Cell[37911, 1153, 266, 8, 70, "Notes",
 CellTags->{"notation", "i:47", "b:6.2", "gs:0.7"},
 CellID->1054697475]
}, Open  ]],
Cell[CellGroupData[{
Cell[38214, 1166, 72, 1, 70, "RelatedTutorialsSection",
 CellID->415694126],
Cell[38289, 1169, 164, 3, 70, "RelatedTutorials",
 CellID->806871991],
Cell[38456, 1174, 183, 4, 70, "RelatedTutorials",
 CellID->1646679440],
Cell[38642, 1180, 191, 5, 70, "RelatedTutorials",
 CellID->683818123]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[38872, 1190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

