(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37977,       1417]
NotebookOptionsPosition[     28889,       1128]
NotebookOutlinePosition[     32416,       1209]
CellTagsIndexPosition[     32322,       1203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Entering Two\[Hyphen]Dimensional Input", "Title",
 CellTags->{"S1.10.2", "2.1"},
 CellID->24828],

Cell[TextData[{
 "When ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reads the text ",
 Cell[BoxData[
  RowBox[{"x", "^", "y"}]], "InlineFormula"],
 ", it interprets it as ",
 Cell[BoxData["x"], "InlineFormula"],
 " raised to the power\[NonBreakingSpace]",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "^", "y"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->24399],

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->8978]
}, Open  ]],

Cell[TextData[{
 "In a notebook, you can also give the two\[Hyphen]dimensional input ",
 Cell[BoxData[
  SuperscriptBox["x", "y"]], "InlineFormula"],
 " directly. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " again interprets this as a power. "
}], "MathCaption",
 CellID->11891],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Input",
 CellLabel->"In[2]:= ",
 CellID->1023],

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->26943]
}, Open  ]],

Cell[TextData[{
 "One way to enter a two\[Hyphen]dimensional form such as ",
 Cell[BoxData[
  SuperscriptBox["x", "y"]], "InlineFormula"],
 " into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook is to paste this form into the notebook by clicking the \
appropriate button in the palette."
}], "Text",
 CellID->2048252716],

Cell["\<\
Here is a palette for entering some common two\[Hyphen]dimensional notations. \
\
\>", "MathCaption",
 CellID->14243],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1y0zAQViw7cfNjyjRt+BmGcABOcMhDwIkDM+UBMh1m2gMD03Tgwk8f
o7xbeYW8QvDK9tqxPxnLlqlT8IxjeSXt9620Wq3cvllenL7/sLw4O1nOX58v
P52enazmrz6ehyLZE0JchvfbuaDyJizGP5diswlLP8RisehFZSHFer0mgbq/
Zqq+iaurn46RQJLgC2mUsEoJVsQlfCc8wg7lwtE3fyCOj985JH3JpedUqq7i
vri+/hW+UyeqovsFkD3LyBLVJYb8RbU+yVwatyftALgkk2pmPFVNFz2Tcku4
MpZl4dSbAyoet8OhT7K+zsgxD31MNrkcnWxsRmnIACMdOaX2KahVo7RXMm2q
u3Dz8joUi1rM+Up2Mzc3v2jOo/HVG2doRerjEtsj2RGcUsuG3M7lUnlfl/si
uyXPlLut1DEzUDJKwS0T3eYmZpR6W0pT9sWV6oABToK3xwpnzQ11uOTfvGUp
yNEts2zACg/rWpYugZxzdsA8CxPn8RIzt8dFWwxz1qpKF1Le3kgWXkFdc9IJ
3y81IqUeoPml59A4HqK9f1rD2xSvu3/mX9wJJlTwqIT2OGWfn/O/TO/Iiywk
JQ4aDd0IPQRa0uTFAiXlE2lyptQ+Au26m0ZbULuKPaDi0cOw+T932BmxJ6Ew
YQuguMBvD1qbg7dbvoTUJtE/OyGo3Ri0m+08/D5vIgNOBALQbgTaGR6ubhje
5y15DwDcwcuyX8pKc+jt2xyhzhLTBDKUWLulZDUfIMoVGRpQHgfHnLaYsx9U
7GuV8ARAIfgZ6OtX7Htok/BBRXJBV4ioviq9txBkpwD0SAcq+vmVkDwtJOgd
YzImZRMdPvqkOqEfvzn8buUo/08lXRvOqmqn7MhBc4B7rAx9spjifdQWblFz
eyRwkreVMkexCX9cQcQmaSfwB5m2+AGocnIH7RBBMX5XQdGgDhoQseoPGo9s
xA+rNKQY4IWJiGnjWON1HXAAM8K1FT87uZ18VvUub5HxnW1X4/8sCoLvBNDL
CETvN4YlJW8=\
\>"], "Picture",
 Evaluatable->False,
 ImageSize->{128, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->7349],

Cell["\<\
There are also several ways to enter two\[Hyphen]dimensional forms directly \
from the keyboard. \
\>", "Text",
 CellID->2702],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "use control keys that exist on most keyboards", "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["6", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "use control keys that should exist on all keyboards", "TableText"]}
  }]], "DefinitionBox",
 CellID->8707],

Cell["Ways to enter a superscript directly from the keyboard.", "Caption",
 CellID->20502],

Cell[TextData[{
 "You type ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " by holding down the ",
 StyleBox["Control", "KeyEvent"],
 " key, then hitting the ",
 StyleBox["^", "KeyEvent"],
 " key. As soon as you do this, your cursor will jump to a superscript \
position. You can then type anything you want and it will appear in that \
position."
}], "Text",
 CellID->25141],

Cell[TextData[{
 "When you have finished, press ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " to move back down from the superscript position. You type ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " by holding down the ",
 StyleBox["Control", "KeyEvent"],
 " key, then pressing the ",
 StyleBox["Space", "KeyEvent"],
 " bar. "
}], "Text",
 CellID->10687],

Cell[TextData[{
 "This sequence of keystrokes enters ",
 Cell[BoxData[
  SuperscriptBox["x", "y"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8346],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " y"
}], "Input",
 CellLabel->"In[3]:= ",
 CellID->15891],

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->24637]
}, Open  ]],

Cell[TextData[{
 "Here the whole expression ",
 Cell[BoxData[
  RowBox[{"y", "+", "z"}]], "InlineFormula"],
 " is in the superscript. "
}], "MathCaption",
 CellID->18413],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " y + z"
}], "Input",
 CellLabel->"In[4]:= ",
 CellID->11400],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"y", "+", "z"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22816]
}, Open  ]],

Cell[TextData[{
 "Pressing ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " takes you down from the superscript. "
}], "MathCaption",
 CellID->31690],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " y ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " + z"
}], "Input",
 CellLabel->"In[5]:= ",
 CellID->13162],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "y"], "+", "z"}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->8935]
}, Open  ]],

Cell[TextData[{
 "You can remember the fact that ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " gives you a superscript by thinking of ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " as just a more immediate form of ",
 StyleBox["^", "KeyEvent"],
 ". When you type ",
 Cell[BoxData[
  RowBox[{"x", "^", "y"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will leave this one\[Hyphen]dimensional form unchanged until you \
explicitly process it. But if you type ",
 Cell[BoxData["x"], "InlineFormula"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " ",
 Cell[BoxData[
  RowBox[{" ", "y"}]], "InlineFormula"],
 " then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will immediately give you a superscript. "
}], "Text",
 CellID->29126],

Cell[TextData[{
 "On a standard English\[Hyphen]language keyboard, the character ",
 StyleBox["^", "KeyEvent"],
 " appears as the shifted version of ",
 StyleBox["6", "KeyEvent"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " therefore accepts ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " as an alternative to ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 ". Note that if you are using something other than a standard English\
\[Hyphen]language keyboard, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will almost always accept ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["6", "KeyEvent"],
 " but may not accept ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 ". "
}], "Text",
 CellID->19410],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "use control keys that exist on most keyboards", "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["-", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "use control keys that should exist on all keyboards", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18588],

Cell["Ways to enter a subscript directly from the keyboard. ", "Caption",
 CellID->7811],

Cell[TextData[{
 "Subscripts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " work very much like superscripts. However, whereas ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically interprets ",
 Cell[BoxData[
  SuperscriptBox["x", "y"]], "InlineFormula"],
 " as ",
 Cell[BoxData["x"], "InlineFormula"],
 " raised to the power ",
 Cell[BoxData["y"], "InlineFormula"],
 ", it has no similar interpretation for ",
 Cell[BoxData[
  SubscriptBox["x", "y"]], "InlineFormula"],
 ". Instead, it just treats ",
 Cell[BoxData[
  SubscriptBox["x", "y"]], "InlineFormula"],
 " as a purely symbolic object. "
}], "Text",
 CellID->28245],

Cell[TextData[{
 "This enters ",
 Cell[BoxData["y"], "InlineFormula"],
 " as a subscript. "
}], "MathCaption",
 CellID->9467],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " y"
}], "Input",
 CellLabel->"In[8]:= ",
 CellID->32425],

Cell[BoxData[
 SubscriptBox["x", "y"]], "Output",
 ImageSize->{17, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->26867]
}, Open  ]],

Cell[TextData[{
 "Here is the usual one\[Hyphen]dimensional ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input that gives the same output expression. "
}], "MathCaption",
 CellID->513872058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subscript", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64552670],

Cell[BoxData[
 SubscriptBox["x", "y"]], "Output",
 ImageSize->{17, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25494828]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], " "}]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["/ ", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell["use control keys", "TableText"]}
  }]], "DefinitionBox",
 CellID->21547],

Cell["\<\
How to enter a built\[Hyphen]up fraction directly from the keyboard. \
\>", "Caption",
 CellID->30502],

Cell[TextData[{
 "This enters the built\[Hyphen]up fraction ",
 Cell[BoxData[
  FormBox[
   FractionBox["x", "y"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->29617],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 " y"
}], "Input",
 CellLabel->"In[10]:= ",
 CellID->9099],

Cell[BoxData[
 FractionBox["x", "y"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->25023]
}, Open  ]],

Cell[TextData[{
 "Here the whole ",
 Cell[BoxData[
  RowBox[{"y", "+", "z"}]], "InlineFormula"],
 " goes into the denominator. "
}], "MathCaption",
 CellID->17226],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 " y + z"
}], "Input",
 CellLabel->"In[11]:= ",
 CellID->31203],

Cell[BoxData[
 FractionBox["x", 
  RowBox[{"y", "+", "z"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->30048]
}, Open  ]],

Cell[TextData[{
 "But pressing Control\[Hyphen]Space takes you out of the denominator, so the \
",
 Cell[BoxData[
  RowBox[{"+", "z"}]], "InlineFormula"],
 " does not appear in the denominator. "
}], "MathCaption",
 CellID->21051],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["/", "KeyEvent"],
 " y ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " + z"
}], "Input",
 CellLabel->"In[12]:= ",
 CellID->1570],

Cell[BoxData[
 RowBox[{
  FractionBox["x", "y"], "+", "z"}]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->8636]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically interprets a built\[Hyphen]up fraction as a division. "
}], "MathCaption",
 CellID->9458],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox["8888", "2222"]], "Input",
 CellLabel->"In[13]:= ",
 CellID->25967],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->8456]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["@", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "use control keys that exist on most keyboards", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["2", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "use control keys that should exist on all keyboards", "TableText"]}
  }]], "DefinitionBox",
 CellID->26819],

Cell["Ways to enter a square root directly from the keyboard. ", "Caption",
 CellID->7975],

Cell["This enters a square root. ", "MathCaption",
 CellID->10556],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 " x + y"
}], "Input",
 CellLabel->"In[15]:= ",
 CellID->7531],

Cell[BoxData[
 SqrtBox[
  RowBox[{"x", "+", "y"}]]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->31495]
}, Open  ]],

Cell["\<\
Control\[Hyphen]Space takes you out of the square root. \
\>", "MathCaption",
 CellID->8044],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 " x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " + y"
}], "Input",
 CellLabel->"In[16]:= ",
 CellID->30591],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], "+", "y"}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->26803]
}, Open  ]],

Cell[TextData[{
 "Here is the usual one\[Hyphen]dimensional ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input that gives the same output expression. "
}], "MathCaption",
 CellID->12319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", "x", "]"}], "+", "y"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->6272],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], "+", "y"}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->25791]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["6", "KeyEvent"]
    }], "TableText"], Cell["go to the superscript position", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["-", "KeyEvent"]
    }], "TableText"], Cell["go to the subscript position", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["@", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["2", "KeyEvent"]
    }], "TableText"], Cell["go into a square root", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["%", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["5", "KeyEvent"]
    }], "TableText"], Cell["\<\
go from subscript to superscript or vice versa, or to the exponent position \
in a root\
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["/", "KeyEvent"]
    }], "TableText"], Cell[
    "go to the denominator for a fraction", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell["return from a special position", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {True}, False}, 
   "RowsIndexed" -> {}}},
 CellID->29383],

Cell["\<\
Special input forms based on control characters. The second forms given \
should work on any keyboard. \
\>", "Caption",
 CellID->10133],

Cell[TextData[{
 "This puts both a subscript and a superscript on ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1775],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " y ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " z"
}], "Input",
 CellLabel->"In[19]:= ",
 CellID->24642],

Cell[BoxData[
 SubsuperscriptBox["x", "z", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->23569]
}, Open  ]],

Cell["Here is another way to enter the same expression. ", "MathCaption",
 CellID->18300],

Cell[CellGroupData[{

Cell[TextData[{
 "x ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " z ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " y"
}], "Input",
 CellLabel->"In[20]:= ",
 CellID->17954],

Cell[BoxData[
 SubsuperscriptBox["x", "z", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->12078]
}, Open  ]],

Cell["\<\
The same procedure can be used to enter a definite integral. \
\>", "MathCaption",
 CellID->163521821],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " 0 ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " 1 ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " f[x] ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["dd", "MR"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 StyleBox[" ", "MR"],
 "x"
}], "Input",
 CellLabel->"In[3]:=",
 CellID->100551510],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{68, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->320976922]
}, Open  ]],

Cell[TextData[{
 "In addition to subscripts and superscripts, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also supports the notion of underscripts and \
overscripts\[LongDash]elements that go directly underneath or above. Among \
other things, you can use underscripts and overscripts to enter the limits of \
sums and products. "
}], "Text",
 CellID->10722],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Plus", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"],
     "  or  ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["=", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "create an underscript ",
     Cell[BoxData[
      UnderscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"],
     "  or  ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["7", "KeyEvent"],
     " ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "create an overscript ",
     Cell[BoxData[
      OverscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "RowsIndexed" -> {}}},
 CellID->24271],

Cell["Creating underscripts and overscripts.", "Caption",
 CellID->19611],

Cell["Here is a way to enter a summation. ", "MathCaption",
 CellID->277275055],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sum\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Plus", "KeyEvent"],
 " x=0 ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " n ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 StyleBox[" ", "MR"],
 "f[x]"
}], "Input",
 CellLabel->"In[3]:=",
 CellID->200391212],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"x", "=", "0"}], "n"], 
  RowBox[{"f", "[", "x", "]"}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{50, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->220749919]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->60593332],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->450366216],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->396026059],

Cell[TextData[{
 ButtonBox["M195: Authoring in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m195.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m195.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->459743650]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Entering Two-Dimensional Input - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/EnteringGreekLetters"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EditingAndEvaluatingTwoDimensionalExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 9.4860560}", "context" -> "", 
    "keywords" -> {
     "above overscript", "activating textual input", "atop overscript", 
      "backslash sequences", "below underscript", "builtup fractions", 
      "control characters", "control keys", "division", "downward motion", 
      "exponents", "exporting", "fractions", "hot keys", "function keys", 
      "input", "international keys", "key shortcuts", "key sequences", 
      "keyboard shortcuts", "keyboard", "make 2D menu item", "motion keys", 
      "moving around", "on top overscript", "Overscript", "palette", "Powers",
       "radicals", "rational functions", "roots", "screen entry", 
      "square roots", "stack overscript", "subscripts", "superscripts", 
      "Twodimensional forms", "Twodimensional input", 
      "underneath underscript", "Underscript", "upward motion"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When Mathematica reads the text x^y, it interprets it as x raised to the \
power y. In a notebook, you can also give the two-dimensional input x^y \
directly. Mathematica again interprets this as a power. One way to enter a \
two-dimensional form such as x^y into a Mathematica notebook is to paste this \
form into the notebook by clicking the appropriate button in the palette.", 
    "synonyms" -> {"1.10.2"}, "title" -> "Entering Two-Dimensional Input", 
    "type" -> "Tutorial", "uri" -> "tutorial/EnteringTwoDimensionalInput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.2"->{
  Cell[1286, 44, 102, 2, 70, "Title",
   CellTags->{"S1.10.2", "2.1"},
   CellID->24828]},
 "2.1"->{
  Cell[1286, 44, 102, 2, 70, "Title",
   CellTags->{"S1.10.2", "2.1"},
   CellID->24828]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.2", 32107, 1192},
 {"2.1", 32208, 1196}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 102, 2, 70, "Title",
 CellTags->{"S1.10.2", "2.1"},
 CellID->24828],
Cell[1391, 48, 344, 13, 70, "MathCaption",
 CellID->12581],
Cell[CellGroupData[{
Cell[1760, 65, 89, 3, 28, "Input",
 CellID->24399],
Cell[1852, 70, 177, 6, 36, "Output",
 CellID->8978]
}, Open  ]],
Cell[2044, 79, 288, 9, 70, "MathCaption",
 CellID->11891],
Cell[CellGroupData[{
Cell[2357, 92, 89, 3, 28, "Input",
 CellID->1023],
Cell[2449, 97, 178, 6, 36, "Output",
 CellID->26943]
}, Open  ]],
Cell[2642, 106, 339, 10, 70, "Text",
 CellID->2048252716],
Cell[2984, 118, 127, 4, 70, "MathCaption",
 CellID->14243],
Cell[3114, 124, 1234, 24, 70, "Picture",
 Evaluatable->False,
 CellID->7349],
Cell[4351, 150, 136, 4, 70, "Text",
 CellID->2702],
Cell[4490, 156, 1056, 34, 70, "DefinitionBox",
 CellID->8707],
Cell[5549, 192, 90, 1, 70, "Caption",
 CellID->20502],
Cell[5642, 195, 428, 13, 70, "Text",
 CellID->25141],
Cell[6073, 210, 473, 15, 70, "Text",
 CellID->10687],
Cell[6549, 227, 157, 6, 70, "MathCaption",
 CellID->8346],
Cell[CellGroupData[{
Cell[6731, 237, 177, 8, 70, "Input",
 CellID->15891],
Cell[6911, 247, 178, 6, 36, "Output",
 CellID->24637]
}, Open  ]],
Cell[7104, 256, 170, 6, 70, "MathCaption",
 CellID->18413],
Cell[CellGroupData[{
Cell[7299, 266, 181, 8, 70, "Input",
 CellID->11400],
Cell[7483, 276, 201, 7, 36, "Output",
 CellID->22816]
}, Open  ]],
Cell[7699, 286, 206, 7, 70, "MathCaption",
 CellID->31690],
Cell[CellGroupData[{
Cell[7930, 297, 287, 12, 70, "Input",
 CellID->13162],
Cell[8220, 311, 200, 7, 36, "Output",
 CellID->8935]
}, Open  ]],
Cell[8435, 321, 941, 32, 70, "Text",
 CellID->29126],
Cell[9379, 355, 913, 30, 70, "Text",
 CellID->19410],
Cell[10295, 387, 1487, 44, 70, "DefinitionBox",
 CellID->18588],
Cell[11785, 433, 88, 1, 70, "Caption",
 CellID->7811],
Cell[11876, 436, 650, 22, 70, "Text",
 CellID->28245],
Cell[12529, 460, 125, 5, 70, "MathCaption",
 CellID->9467],
Cell[CellGroupData[{
Cell[12679, 469, 177, 8, 70, "Input",
 CellID->32425],
Cell[12859, 479, 176, 6, 38, "Output",
 CellID->26867]
}, Open  ]],
Cell[13050, 488, 200, 6, 70, "MathCaption",
 CellID->513872058],
Cell[CellGroupData[{
Cell[13275, 498, 127, 4, 70, "Input",
 CellID->64552670],
Cell[13405, 504, 178, 6, 38, "Output",
 CellID->25494828]
}, Open  ]],
Cell[13598, 513, 546, 18, 70, "DefinitionBox",
 CellID->21547],
Cell[14147, 533, 112, 3, 70, "Caption",
 CellID->30502],
Cell[14262, 538, 189, 7, 70, "MathCaption",
 CellID->29617],
Cell[CellGroupData[{
Cell[14476, 549, 177, 8, 70, "Input",
 CellID->9099],
Cell[14656, 559, 176, 6, 51, "Output",
 CellID->25023]
}, Open  ]],
Cell[14847, 568, 163, 6, 70, "MathCaption",
 CellID->17226],
Cell[CellGroupData[{
Cell[15035, 578, 182, 8, 70, "Input",
 CellID->31203],
Cell[15220, 588, 199, 7, 51, "Output",
 CellID->30048]
}, Open  ]],
Cell[15434, 598, 230, 7, 70, "MathCaption",
 CellID->21051],
Cell[CellGroupData[{
Cell[15689, 609, 287, 12, 70, "Input",
 CellID->1570],
Cell[15979, 623, 198, 7, 51, "Output",
 CellID->8636]
}, Open  ]],
Cell[16192, 633, 171, 5, 70, "MathCaption",
 CellID->9458],
Cell[CellGroupData[{
Cell[16388, 642, 94, 3, 70, "Input",
 CellID->25967],
Cell[16485, 647, 155, 5, 36, "Output",
 CellID->8456]
}, Open  ]],
Cell[16655, 655, 907, 28, 70, "DefinitionBox",
 CellID->26819],
Cell[17565, 685, 90, 1, 70, "Caption",
 CellID->7975],
Cell[17658, 688, 66, 1, 70, "MathCaption",
 CellID->10556],
Cell[CellGroupData[{
Cell[17749, 693, 174, 7, 70, "Input",
 CellID->7531],
Cell[17926, 702, 190, 7, 38, "Output",
 CellID->31495]
}, Open  ]],
Cell[18131, 712, 102, 3, 70, "MathCaption",
 CellID->8044],
Cell[CellGroupData[{
Cell[18258, 719, 281, 11, 70, "Input",
 CellID->30591],
Cell[18542, 732, 190, 7, 38, "Output",
 CellID->26803]
}, Open  ]],
Cell[18747, 742, 196, 6, 70, "MathCaption",
 CellID->12319],
Cell[CellGroupData[{
Cell[18968, 752, 120, 4, 70, "Input",
 CellID->6272],
Cell[19091, 758, 190, 7, 38, "Output",
 CellID->25791]
}, Open  ]],
Cell[19296, 768, 2014, 57, 70, "DefinitionBox",
 CellID->29383],
Cell[21313, 827, 146, 4, 70, "Caption",
 CellID->10133],
Cell[21462, 833, 146, 5, 70, "MathCaption",
 CellID->1775],
Cell[CellGroupData[{
Cell[21633, 842, 282, 12, 70, "Input",
 CellID->24642],
Cell[21918, 856, 187, 6, 36, "Output",
 CellID->23569]
}, Open  ]],
Cell[22120, 865, 89, 1, 70, "MathCaption",
 CellID->18300],
Cell[CellGroupData[{
Cell[22234, 870, 282, 12, 70, "Input",
 CellID->17954],
Cell[22519, 884, 187, 6, 36, "Output",
 CellID->12078]
}, Open  ]],
Cell[22721, 893, 112, 3, 70, "MathCaption",
 CellID->163521821],
Cell[CellGroupData[{
Cell[22858, 900, 704, 26, 70, "Input",
 CellID->100551510],
Cell[23565, 928, 348, 12, 51, "Output",
 CellID->320976922]
}, Open  ]],
Cell[23928, 943, 369, 9, 70, "Text",
 CellID->10722],
Cell[24300, 954, 2236, 77, 70, "DefinitionBox",
 CellID->24271],
Cell[26539, 1033, 73, 1, 70, "Caption",
 CellID->19611],
Cell[26615, 1036, 79, 1, 70, "MathCaption",
 CellID->277275055],
Cell[CellGroupData[{
Cell[26719, 1041, 536, 20, 70, "Input",
 CellID->200391212],
Cell[27258, 1063, 315, 11, 58, "Output",
 CellID->220749919]
}, Open  ]],
Cell[CellGroupData[{
Cell[27610, 1079, 71, 1, 70, "RelatedTutorialsSection",
 CellID->60593332],
Cell[27684, 1082, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]],
Cell[CellGroupData[{
Cell[27908, 1091, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->450366216],
Cell[28009, 1094, 414, 13, 70, "TutorialRelatedLinks",
 CellID->396026059],
Cell[28426, 1109, 409, 13, 70, "TutorialRelatedLinks",
 CellID->459743650]
}, Open  ]]
}, Open  ]],
Cell[28862, 1126, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

