(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20055,        803]
NotebookOptionsPosition[     13693,        602]
NotebookOutlinePosition[     16836,        678]
CellTagsIndexPosition[     16745,        672]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Symbolic Mathematics" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SymbolicMathematicsOverview"]}, #, 2]& , Evaluator -> 
       Automatic], {
      1->"\<\"Symbolic Mathematics\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Equations", "Title",
 CellTags->{"S1.5.5", "5.1"},
 CellID->5158],

Cell[TextData[{
 ButtonBox["\"Defining Variables\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DefiningVariables"],
 " discussed ",
 StyleBox["assignments",
  FontSlant->"Italic"],
 " such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " which ",
 StyleBox["set",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " equal to ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". Here we discuss ",
 StyleBox["equations",
  FontSlant->"Italic"],
 ", which ",
 StyleBox["test",
  FontSlant->"Italic"],
 " equality. The equation ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "==", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " ",
 StyleBox["tests",
  FontSlant->"Italic"],
 " whether ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->17589],

Cell[TextData[{
 "This ",
 Cell[BoxData[
  StyleBox["tests", "TI"]], "InlineFormula"],
 " whether ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 " and ",
 Cell[BoxData["4"], "InlineFormula"],
 " are equal. The result is the symbol ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "+", "2"}], "==", "4"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->27809],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->17889]
}, Open  ]],

Cell[TextData[{
 "It is very important that you do not confuse ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "==", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". While ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " is an ",
 StyleBox["imperative",
  FontSlant->"Italic"],
 " statement that actually causes an assignment to be done, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "==", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " merely ",
 StyleBox["tests",
  FontSlant->"Italic"],
 " whether ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " are equal, and causes no explicit action. If you have used the C \
programming language, you will recognize that the notation for assignment and \
testing in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the same as in C."
}], "Text",
 CellID->11447],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     "assigns ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to have value ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "==", 
     StyleBox["y", "TI"]}], Cell[TextData[{
     "tests whether ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " are equal"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->40],

Cell["Assignments and tests. ", "Caption",
 CellID->3818],

Cell[TextData[{
 "This ",
 StyleBox["assigns",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData["x"], "InlineFormula"],
 " to have value ",
 Cell[BoxData["4"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", "4"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17975],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->26]
}, Open  ]],

Cell[TextData[{
 "If you ask for ",
 Cell[BoxData["x"], "InlineFormula"],
 ", you now get ",
 Cell[BoxData["4"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25089],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[3]:= ",
 CellID->2503],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->30066]
}, Open  ]],

Cell[TextData[{
 "This ",
 StyleBox["tests",
  FontSlant->"Italic"],
 " whether ",
 Cell[BoxData["x"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData["4"], "InlineFormula"],
 ". In this case, it is. "
}], "MathCaption",
 CellID->26412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "==", "4"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->6840],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->12570]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["x"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData["4"], "InlineFormula"],
 ", not ",
 Cell[BoxData["6"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "==", "6"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->25395],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->28641]
}, Open  ]],

Cell[TextData[{
 "This removes the value assigned to ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29986],

Cell[BoxData[
 RowBox[{"x", "=."}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->17651],

Cell[TextData[{
 "The tests we have used so far involve only numbers, and always give a \
definite answer, either ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". You can also do tests on symbolic expressions. "
}], "Text",
 CellID->21109],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot get a definite result for this test unless you give ",
 Cell[BoxData["x"], "InlineFormula"],
 " a specific numerical value. "
}], "MathCaption",
 CellID->8187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "==", "5"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->20083],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "5"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->21085]
}, Open  ]],

Cell[TextData[{
 "If you replace ",
 Cell[BoxData["x"], "InlineFormula"],
 " by the specific numerical value ",
 Cell[BoxData["4"], "InlineFormula"],
 ", the test gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", "4"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->31250],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->18686]
}, Open  ]],

Cell[TextData[{
 "Even when you do tests on symbolic expressions, there are some cases where \
you can get definite results. An important one is when you test the equality \
of two expressions that are ",
 StyleBox["identical",
  FontSlant->"Italic"],
 ". Whatever the numerical values of the variables in these expressions may \
be, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " knows that the expressions must always be equal. "
}], "Text",
 CellID->4755],

Cell[TextData[{
 "The two expressions are ",
 StyleBox["identical",
  FontSlant->"Italic"],
 ", so the result is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", whatever the value of ",
 Cell[BoxData["x"], "InlineFormula"],
 " may be. "
}], "MathCaption",
 CellID->11381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"x", "^", "2"}]}], "==", 
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->28128],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->25502]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not try to tell whether these expressions are equal. In this case, \
using ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " would make them have the same form. "
}], "MathCaption",
 CellID->24277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   RowBox[{"x", "^", "2"}]}], "==", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->30862],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], "\[Equal]", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->26424]
}, Open  ]],

Cell[TextData[{
 "Expressions like ",
 Cell[BoxData[
  RowBox[{"x", "==", "4"}]], "InlineFormula"],
 " represent ",
 StyleBox["equations",
  FontSlant->"Italic"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". There are many functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for manipulating and solving equations. "
}], "Text",
 CellID->3565],

Cell[TextData[{
 "This is an ",
 StyleBox["equation",
  FontSlant->"Italic"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". \"",
 ButtonBox["Solving Equations\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SolvingEquations"],
 " will discuss how to solve it for ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"2", " ", "x"}], "-", "7"}], "==", "0"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->832],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "7"}], "+", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->30885]
}, Open  ]],

Cell["You can assign a name to the equation. ", "MathCaption",
 CellID->14428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqn", "=", "%"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->6646],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "7"}], "+", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->20889]
}, Open  ]],

Cell[TextData[{
 "If you ask for ",
 Cell[BoxData["eqn"], "InlineFormula"],
 ", you now get the equation. "
}], "MathCaption",
 CellID->6478],

Cell[CellGroupData[{

Cell[BoxData["eqn"], "Input",
 CellLabel->"In[13]:= ",
 CellID->10883],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "7"}], "+", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->24925]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->724140082],

Cell[TextData[ButtonBox["Symbolic Mathematics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematicsOverview"]], "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Symbolic Mathematics", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> "paclet:tutorial/SymbolicMathematicsOverview"]],
       "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SumsAndProducts"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/RelationalAndLogicalOperators"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 12.9705202}", "context" -> "", 
    "keywords" -> {
     "==", "=", "assignments", "biconditional", "Boolean tests", 
      "Delta function", "equal", "equality testing", "equations", "false", 
      "identical expressions", "Kronecker delta", "relations", 
      "same expressions", "testing equality", "tests", "true"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"Defining Variables\" discussed assignments such as x=y which set x \
equal to y. Here we discuss equations, which test equality. The equation x==y \
tests whether x is equal to y. This tests whether 2+2 and 4 are equal. The \
result is the symbol True. It is very important that you do not confuse x=y \
with x==y. While x=y is an imperative statement that actually causes an \
assignment to be done, x==y merely tests whether x and y are equal, and \
causes no explicit action. If you have used the C programming language, you \
will recognize that the notation for assignment and testing in Mathematica is \
the same as in C.", "synonyms" -> {"1.5.5"}, "title" -> "Equations", "type" -> 
    "Tutorial", "uri" -> "tutorial/Equations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.5.5"->{
  Cell[1260, 43, 71, 2, 70, "Title",
   CellTags->{"S1.5.5", "5.1"},
   CellID->5158]},
 "5.1"->{
  Cell[1260, 43, 71, 2, 70, "Title",
   CellTags->{"S1.5.5", "5.1"},
   CellID->5158]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.5.5", 16536, 661},
 {"5.1", 16634, 665}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 635, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1260, 43, 71, 2, 70, "Title",
 CellTags->{"S1.5.5", "5.1"},
 CellID->5158],
Cell[1334, 47, 977, 43, 70, "Text",
 CellID->17589],
Cell[2314, 92, 402, 16, 70, "MathCaption",
 CellID->9858],
Cell[CellGroupData[{
Cell[2741, 112, 113, 4, 28, "Input",
 CellID->27809],
Cell[2857, 118, 158, 5, 36, "Output",
 CellID->17889]
}, Open  ]],
Cell[3030, 126, 1078, 40, 70, "Text",
 CellID->11447],
Cell[4111, 168, 922, 32, 70, "DefinitionBox",
 CellID->40],
Cell[5036, 202, 57, 1, 70, "Caption",
 CellID->3818],
Cell[5096, 205, 212, 10, 70, "MathCaption",
 CellID->9364],
Cell[CellGroupData[{
Cell[5333, 219, 89, 3, 28, "Input",
 CellID->17975],
Cell[5425, 224, 152, 5, 36, "Output",
 CellID->26]
}, Open  ]],
Cell[5592, 232, 171, 7, 70, "MathCaption",
 CellID->25089],
Cell[CellGroupData[{
Cell[5788, 243, 66, 2, 70, "Input",
 CellID->2503],
Cell[5857, 247, 155, 5, 36, "Output",
 CellID->30066]
}, Open  ]],
Cell[6027, 255, 238, 10, 70, "MathCaption",
 CellID->26412],
Cell[CellGroupData[{
Cell[6290, 269, 89, 3, 70, "Input",
 CellID->6840],
Cell[6382, 274, 158, 5, 36, "Output",
 CellID->12570]
}, Open  ]],
Cell[6555, 282, 199, 8, 70, "MathCaption",
 CellID->14676],
Cell[CellGroupData[{
Cell[6779, 294, 90, 3, 70, "Input",
 CellID->25395],
Cell[6872, 299, 159, 5, 36, "Output",
 CellID->28641]
}, Open  ]],
Cell[7046, 307, 134, 5, 70, "MathCaption",
 CellID->29986],
Cell[7183, 314, 85, 3, 70, "Input",
 CellID->17651],
Cell[7271, 319, 430, 14, 70, "Text",
 CellID->21109],
Cell[7704, 335, 234, 7, 70, "MathCaption",
 CellID->8187],
Cell[CellGroupData[{
Cell[7963, 346, 90, 3, 70, "Input",
 CellID->20083],
Cell[8056, 351, 184, 6, 36, "Output",
 CellID->21085]
}, Open  ]],
Cell[8255, 360, 325, 12, 70, "MathCaption",
 CellID->23390],
Cell[CellGroupData[{
Cell[8605, 376, 114, 4, 70, "Input",
 CellID->31250],
Cell[8722, 382, 159, 5, 36, "Output",
 CellID->18686]
}, Open  ]],
Cell[8896, 390, 466, 12, 70, "Text",
 CellID->4755],
Cell[9365, 404, 341, 13, 70, "MathCaption",
 CellID->11381],
Cell[CellGroupData[{
Cell[9731, 421, 232, 9, 70, "Input",
 CellID->28128],
Cell[9966, 432, 158, 5, 36, "Output",
 CellID->25502]
}, Open  ]],
Cell[10139, 440, 341, 11, 70, "MathCaption",
 CellID->24277],
Cell[CellGroupData[{
Cell[10505, 455, 234, 9, 70, "Input",
 CellID->30862],
Cell[10742, 466, 330, 12, 36, "Output",
 CellID->26424]
}, Open  ]],
Cell[11087, 481, 376, 15, 70, "Text",
 CellID->3565],
Cell[11466, 498, 367, 15, 70, "MathCaption",
 CellID->3872],
Cell[CellGroupData[{
Cell[11858, 517, 170, 6, 70, "Input",
 CellID->832],
Cell[12031, 525, 286, 10, 36, "Output",
 CellID->30885]
}, Open  ]],
Cell[12332, 538, 78, 1, 70, "MathCaption",
 CellID->14428],
Cell[CellGroupData[{
Cell[12435, 543, 91, 3, 70, "Input",
 CellID->6646],
Cell[12529, 548, 286, 10, 36, "Output",
 CellID->20889]
}, Open  ]],
Cell[12830, 561, 141, 5, 70, "MathCaption",
 CellID->6478],
Cell[CellGroupData[{
Cell[12996, 570, 70, 2, 70, "Input",
 CellID->10883],
Cell[13069, 574, 286, 10, 36, "Output",
 CellID->24925]
}, Open  ]],
Cell[CellGroupData[{
Cell[13392, 589, 72, 1, 70, "RelatedTutorialsSection",
 CellID->724140082],
Cell[13467, 592, 172, 4, 70, "RelatedTutorials",
 CellID->391267452]
}, Open  ]]
}, Open  ]],
Cell[13666, 600, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

