(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     78729,       2820]
NotebookOptionsPosition[     66302,       2403]
NotebookOutlinePosition[     69672,       2484]
CellTagsIndexPosition[     69579,       2478]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Equations and Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"], 
          "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Manipulating Equations and Inequalities\"\>", 
       2->"\<\"Complex Polynomial Systems\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Booleans" :> Documentation`HelpLookup["paclet:ref/Booleans"], 
          "Complexes" :> Documentation`HelpLookup["paclet:ref/Complexes"], 
          "False" :> Documentation`HelpLookup["paclet:ref/False"], 
          "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Integers" :> 
          Documentation`HelpLookup["paclet:ref/Integers"], "Modulus" :> 
          Documentation`HelpLookup["paclet:ref/Modulus"], "Reals" :> 
          Documentation`HelpLookup["paclet:ref/Reals"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "Root" :> 
          Documentation`HelpLookup["paclet:ref/Root"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Booleans\"\>", 2->"\<\"Complexes\"\>", 
       3->"\<\"False\"\>", 4->"\<\"FindInstance\"\>", 5->"\<\"Integers\"\>", 
       6->"\<\"Modulus\"\>", 7->"\<\"Reals\"\>", 8->"\<\"Reduce\"\>", 
       9->"\<\"Root\"\>", 10->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Equations and Inequalities over Domains", "Title",
 CellTags->{"S3.4.9", "9.1"},
 CellID->18990],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally assumes that variables which appear in equations can stand for \
arbitrary complex numbers. But when you use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ", you can explicitly tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that the variables stand for objects in more restricted domains. "
}], "Text",
 CellID->30338],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Reduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reduce"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["dom", "TI"], "]"}], Cell[TextData[{
     "reduce ",
     Cell[BoxData[
      StyleBox["eqns", "TI"]], "InlineFormula"],
     " over the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Complexes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complexes"], Cell[TextData[{
     "complex numbers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"], Cell[TextData[{
     "real numbers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalR]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"], Cell[TextData[{
     "integers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalZ]", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21641],

Cell["Solving over domains. ", "Caption",
 CellID->23258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " by default assumes that ",
 Cell[BoxData["x"], "InlineFormula"],
 " can be complex, and gives all five complex solutions. "
}], "MathCaption",
 CellID->19047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "6"}], "-", 
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", "4"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2352],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}]}]], "Output",
 ImageSize->{401, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2023783629]
}, Open  ]],

Cell[TextData[{
 "But here it assumes that ",
 Cell[BoxData["x"], "InlineFormula"],
 " is real, and gives only the real solutions. "
}], "MathCaption",
 CellID->479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "6"}], "-", 
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", "4"}], "==", "0"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25302],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}]}]], "Output",
 ImageSize->{236, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1451991367]
}, Open  ]],

Cell[TextData[{
 "And here it assumes that ",
 Cell[BoxData["x"], "InlineFormula"],
 " is an integer, and gives only the integer solutions. "
}], "MathCaption",
 CellID->10002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "6"}], "-", 
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", "4"}], "==", "0"}], ",", "x", ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15568],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2020395890]
}, Open  ]],

Cell[TextData[{
 "A single polynomial equation in one variable will always have a finite set \
of discrete solutions. And in such a case one can think of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"], "[", 
   RowBox[{
    StyleBox["eqns", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
 " as just filtering the solutions by selecting the ones that happen to lie \
in the domain ",
 Cell[BoxData[
  StyleBox["dom", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16895],

Cell["\<\
But as soon as there are more variables, things can become more complicated, \
with solutions to equations corresponding to parametric curves or surfaces in \
which the values of some variables can depend on the values of others. Often \
this dependence can be described by some collection of equations or \
inequalities, but the form of these can change significantly when one goes \
from one domain to another. \
\>", "Text",
 CellID->6135],

Cell["\<\
This gives solutions over the complex numbers as simple formulas. \
\>", "MathCaption",
 CellID->18008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12361],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}]}], "||", 
  RowBox[{"y", "\[Equal]", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{182, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1211171062]
}, Open  ]],

Cell["\<\
To represent solutions over the reals requires introducing an inequality. \
\>", "MathCaption",
 CellID->22194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->23699],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}]}], "||", 
    RowBox[{"y", "\[Equal]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{272, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2050326738]
}, Open  ]],

Cell["\<\
Over the integers, the solution can be represented as equations for discrete \
points. \
\>", "MathCaption",
 CellID->20178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->4042],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1416891126]
}, Open  ]],

Cell[TextData[{
 "If your input involves only equations, then ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " will by default assume that all variables are complex. But if your input \
involves inequalities, then ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " will assume that any algebraic variables appearing in them are real, since \
inequalities can only compare real quantities. "
}], "Text",
 CellID->23941],

Cell["\<\
Since the variables appear in an inequality, they are assumed to be real. \
\>", "MathCaption",
 CellID->1847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", "y", "+", "z"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->7469],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", "x"}], "2"], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}]]}]}], "<", "y", "<", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", "x"}], "2"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}], "-", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}]]}]}]}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{"1", "-", "x", "-", "y"}]}]}]], "Output",
 ImageSize->{506, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1725406370]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Complexes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complexes"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["polynomial", "TI"], "!=", "0"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], "==", 
       RowBox[{
        ButtonBox["Root",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Root"], "[", 
        StyleBox["\[Ellipsis]", "TR"], "]"}]}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{
        ButtonBox["Root",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Root"], "[", 
        StyleBox["\[Ellipsis]", "TR"], "]"}], "<", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], "<", 
       RowBox[{
        ButtonBox["Root",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Root"], "[", 
        StyleBox["\[Ellipsis]", "TR"], "]"}]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], "==", 
       RowBox[{
        ButtonBox["Root",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Root"], "[", 
        StyleBox["\[Ellipsis]", "TR"], "]"}]}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"], Cell[
    "arbitrarily complicated", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->4380],

Cell["\<\
Schematic building blocks for solutions to polynomial equations and \
inequalities. \
\>", "Caption",
 CellID->31913],

Cell["\<\
For systems of polynomials over real and complex domains, the solutions \
always consist of a finite number of components, within which the values of \
variables are given by algebraic numbers or functions. \
\>", "Text",
 CellID->14964],

Cell[TextData[{
 "Here the components are distinguished by equations and inequations on ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"y", "^", "3"}]}], "+", "y"}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->20061],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[NotEqual]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", "#1", "+", 
           RowBox[{"x", " ", 
            SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", "#1", "+", 
           RowBox[{"x", " ", 
            SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", "#1", "+", 
           RowBox[{"x", " ", 
            SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}]}]}], 
     ")"}]}], ")"}]}]], "Output",
 ImageSize->{429, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->685129192]
}, Open  ]],

Cell[TextData[{
 "And here the components are distinguished by inequalities on ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"y", "^", "3"}]}], "+", "y"}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->27504],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", 
      FractionBox["4", "27"]}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", "#1", "+", 
         RowBox[{"x", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], ")"}], 
  "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["4", "27"]}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "3"}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       FractionBox["3", "2"]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["4", "27"]}], "<", "x", "<", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", "#1", "+", 
           RowBox[{"x", " ", 
            SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", "#1", "+", 
           RowBox[{"x", " ", 
            SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", "#1", "+", 
           RowBox[{"x", " ", 
            SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}]}]}], 
     ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "+", "#1", "+", 
         RowBox[{"x", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{506, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1347525525]
}, Open  ]],

Cell[TextData[{
 "While in principle ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can always find the complete solution to any collection of polynomial \
equations and inequalities with real or complex variables, the results are \
often very complicated, with the number of components typically growing \
exponentially as the number of variables increases. "
}], "Text",
 CellID->32703],

Cell["\<\
With 3 variables, the solution here already involves 8 components. \
\>", "MathCaption",
 CellID->28102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", 
    RowBox[{"y", "^", "2"}], "==", 
    RowBox[{"z", "^", "2"}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->11069],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmktvEzEQx928Gh4HEC2vUhLgBkiEIqCA4AgnuHHkEFVI7QGBSr8XH9Fs
du1u8t9xPONHdqErNdtxdsczf4/X65/yeX52/P3H/OzkaD79dDr/dXxy9Hv6
8edp0dTfUqq3r5Q6uK2K/3XxX/lnj0nxV5uVdXXx2T+/Sh0UH4PC/Artl8Ae
eL5/kciPjecLtD8to78CrS/Bxt7Hnt7x+1eJ/WF8mNWTMqvL0NorPoaFecOc
h8W5V5xVv7xc2WuwbQR+9sz9I+b9ts2ebf+Y5bZHBfwe8+HGg/lI78d8rB6p
8wkdH2k+feb4PHZWlRouPx+UiX1xUeXEHuSsHdS2CWulZWyi2iY9XgOPQ4bH
5jW0b9+sDBnfplIjVt+cvKxStEfUPqVSOAp5lNpUTYVoPyJbmNF651gf7JuU
F6PX+eeKinXr8tNiYe/o+mnTyJrp0z6pbiWuA1/ekhgx7xhfNt9dh3a5844Z
71gNOeNMVzFexZvPLG0ZMw+fUbhqol+b65j0lnptoHr39+rLoakNT/M4bVKv
Bu3WTYjm7rUl7Pnfa8RKzmLPiDVX1H1hbs2VkHwyxa78a3vg1GYz093oTO9v
PNOwMZVm2nxz8Y2pu0aHjv57ql4z6dl7j1Br+a6BXt2jYC+p9l7oF+Ogo98R
Ro/zLlf0PO190dszV/uqPpCp7IH9GuxnYOM7kJSRYH8zT/+p+8N8sH/sr2I2
yNHuGM0PzXmm64pavk7Kw6zf5+A/ld8Z+Mf7Ku6mzTHJZqGeb3Uanmj9IHnz
+cGqsXzzm9BPuXo05th7sGM5I/rDbKVvwchBMWufvypr18pzV/9fHHDT+XA5
IGfvQuUTy2mtvlwuivmEjo+76riMKoRSXkyaF6NU92heyExpjxBfp6IVK5Wn
pug5iO9QlmWSu7kLwAm7lj+XF0rnSU4u7OLhUuaactzp6udxMSn3vEjMMF6b
LjBD6explzXjKsOZG/nqZs273UouUlL671LIdjKVU8igd6sMZBn1YlHbpGO6
flfsI6vdJpp5opcSzdAdbxhNxpwpiptSe5olPQQ7Nz/19efjp1IWhbz2MHF+
larIH6c6D3dFvy7uKuWTlue+iYy3UkObY5LNwqev5bRSvoo6vNNh3PhPGRW2
IleVclCs5Q9gS7lvFSVWeCoO2Ra3cz2Vpb9fRT9SPVJxVfcotcchu8yMYuha
eqVCPHKViv01El1Zm6BLXaQtPtqU4heTLh1itU1B2+hqaJc2dYsahBGVXNqE
+M33y8Y1q1QGztD+7tvPGbCHsEypXaEs01iisv4tMWynvum9ruudEP3yosc9
ZG7OQO8mcOeceieLUT3y+I/dqVdZ4kye6jQ7Uez9AfgL3TlXUWtzTISW2voL
UuMqNw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{541, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->546573045]
}, Open  ]],

Cell[TextData[{
 "As soon as one introduces functions like ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ", even equations in single real or complex variables can have solutions \
with an infinite number of components. ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " labels these components by introducing additional parameters. By default, \
the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " parameter in a given solution will be named ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". In general you can specify that it should be named ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " by giving the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->3529],

Cell[TextData[{
 "The components here are labeled by the integer parameter ",
 Cell[BoxData[
  SubscriptBox["c", "1"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "==", "2"}], ",", "x", ",", 
   RowBox[{"GeneratedParameters", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"c", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->32074],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["c", "1"], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"Log", "[", "2", "]"}], "+", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     SubscriptBox["c", "1"]}]}]}]}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1115243965]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can handle equations not only over real and complex variables, but also \
over integers. Solving such ",
 StyleBox["Diophantine equations",
  FontSlant->"Italic"],
 " can often be a very difficult problem. "
}], "Text",
 CellID->3730],

Cell["\<\
Describing the solution to this equation over the reals is straightforward. \
\>", "MathCaption",
 CellID->2244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", "y"}], "==", "8"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->10844],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", "0"}], "||", 
    RowBox[{"x", ">", "0"}]}], ")"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   FractionBox["8", "x"]}]}]], "Output",
 ImageSize->{149, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->460215127]
}, Open  ]],

Cell["The solution over the integers involves the divisors of 8. ", \
"MathCaption",
 CellID->14118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", "y"}], "==", "8"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->24065],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "8"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "1"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "2"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "4"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", "8"}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "8"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "8"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{524, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->68070088]
}, Open  ]],

Cell["\<\
Solving an equation like this effectively requires factoring a large number. \
\
\>", "MathCaption",
 CellID->19552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "y"}], "==", "7777777"}], ",", 
     RowBox[{"x", ">", "y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->28773],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4649"}], "&&", 
    RowBox[{"y", "\[Equal]", "1673"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "32543"}], "&&", 
    RowBox[{"y", "\[Equal]", "239"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1111111"}], "&&", 
    RowBox[{"y", "\[Equal]", "7"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "7777777"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}]}]], "Output",
 ImageSize->{318, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1906651502]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can solve any system of linear equations or inequalities over the \
integers. With ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " linear equations in ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " variables, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "-", "m"}], TraditionalForm]], "InlineMath"],
 " parameters typically need to be introduced. But with inequalities, a much \
larger number of parameters may be needed. "
}], "Text",
 CellID->29731],

Cell["\<\
Three parameters are needed here, even though there are only two variables. \
\>", "MathCaption",
 CellID->6747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"3", "x"}], "-", 
       RowBox[{"2", "y"}]}], ">", "1"}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->7511],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "|", 
     RowBox[{"C", "[", "2", "]"}], "|", 
     RowBox[{"C", "[", "3", "]"}]}], ")"}], "\[Element]", "Integers"}], "&&", 
  
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "2", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "3", "]"}], "\[GreaterEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"C", "[", "3", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"2", "+", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"2", "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        RowBox[{"C", "[", "2", "]"}], "+", 
        RowBox[{"C", "[", "3", "]"}]}]}], "&&", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"1", "+", 
        RowBox[{"3", " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{423, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1483131429]
}, Open  ]],

Cell[TextData[{
 "With two variables, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can solve any quadratic equation over the integers. The result can be a \
Fibonacci\[Hyphen]like sequence, represented in terms of powers of quadratic \
irrationals. "
}], "Text",
 CellID->14398],

Cell["Here is the solution to a Pell equation. ", "MathCaption",
 CellID->10498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "==", 
      RowBox[{
       RowBox[{"13", " ", 
        RowBox[{"y", "^", "2"}]}], "+", "1"}]}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->7103],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"649", "-", 
         RowBox[{"180", " ", 
          SqrtBox["13"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"649", "+", 
         RowBox[{"180", " ", 
          SqrtBox["13"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"649", "-", 
         RowBox[{"180", " ", 
          SqrtBox["13"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"649", "+", 
         RowBox[{"180", " ", 
          SqrtBox["13"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], 
     RowBox[{"2", " ", 
      SqrtBox["13"]}]]}]}]}]], "Output",
 ImageSize->{518, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->1726270014]
}, Open  ]],

Cell[TextData[{
 "The actual values for specific ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 " as integers, as they should be. "
}], "MathCaption",
 CellID->25679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", "/.", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "->", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "4"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->28053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[Equal]", "649"}], "&&", 
    RowBox[{"y", "\[Equal]", "180"}]}], ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "842401"}], "&&", 
    RowBox[{"y", "\[Equal]", "233640"}]}], ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1093435849"}], "&&", 
    RowBox[{"y", "\[Equal]", "303264540"}]}], ",", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1419278889601"}], "&&", 
    RowBox[{"y", "\[Equal]", "393637139280"}]}]}], "}"}]], "Output",
 ImageSize->{498, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->119085245]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can handle many specific classes of equations over the integers. "
}], "Text",
 CellID->14522],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " finds the solution to a Thue equation. "
}], "MathCaption",
 CellID->31088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"4", " ", "x", " ", 
      RowBox[{"y", "^", "2"}]}], "+", 
     RowBox[{"y", "^", "3"}]}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->1563],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "2"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "4"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "508"}], "&&", 
    RowBox[{"y", "\[Equal]", "273"}]}], ")"}]}]], "Output",
 ImageSize->{366, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->1419303045]
}, Open  ]],

Cell[TextData[{
 "Changing the right\[Hyphen]hand side to ",
 Cell[BoxData["3"], "InlineFormula"],
 ", the equation now has no solution. "
}], "MathCaption",
 CellID->9850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"4", " ", "x", " ", 
      RowBox[{"y", "^", "2"}]}], "+", 
     RowBox[{"y", "^", "3"}]}], "==", "3"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->17022],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->1320899194]
}, Open  ]],

Cell["\<\
Equations over the integers sometimes have seemingly quite random collections \
of solutions. And even small changes in equations can often lead them to have \
no solutions at all. \
\>", "Text",
 CellID->21911],

Cell[TextData[{
 "For polynomial equations over real and complex numbers, there is a definite \
",
 StyleBox["decision procedure",
  FontSlant->"Italic"],
 " for determining whether or not any solution exists. But for polynomial \
equations over the integers, the unsolvability of Hilbert\[CloseCurlyQuote]s \
Tenth Problem demonstrates that there can never be any such general \
procedure. "
}], "Text",
 CellID->9492],

Cell[TextData[{
 "For specific classes of equations, however, procedures can be found, and \
indeed many are implemented in ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". But handling different classes of equations can often seem to require \
whole different branches of number theory, and quite different kinds of \
computations. And in fact it is known that there are ",
 StyleBox["universal",
  FontSlant->"Italic"],
 " integer polynomial equations, for which filling in some variables can make \
solutions for other variables correspond to the output of absolutely any \
possible program. This then means that for such equations there can never in \
general be any closed\[Hyphen]form solution built from fixed elements like \
algebraic functions. "
}], "Text",
 CellID->5651],

Cell[TextData[{
 "If one includes functions like ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ", then even for equations involving real and complex numbers the same \
issues can arise. "
}], "Text",
 CellID->28580],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " here effectively has to solve an equation over the integers. "
}], "MathCaption",
 CellID->15477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"Pi", " ", "x"}], "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"Pi", " ", "y"}], "]"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "-", "25"}], ")"}], "^", "2"}]}], "==", 
    "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->27616],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "5"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "4"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "3"}]}], "||", 
      RowBox[{"y", "\[Equal]", "3"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "3"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "4"}]}], "||", 
      RowBox[{"y", "\[Equal]", "4"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "5"}]}], "||", 
      RowBox[{"y", "\[Equal]", "5"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "4"}]}], "||", 
      RowBox[{"y", "\[Equal]", "4"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "4"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "3"}]}], "||", 
      RowBox[{"y", "\[Equal]", "3"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "5"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{482, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->57358318]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Reduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reduce"], "[", 
     StyleBox["eqns", "TI"], ",", 
     StyleBox["vars", "TI"], ",", 
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "find solutions modulo ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->19178],

Cell[TextData[{
 "Handling equations involving integers modulo ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "Caption",
 CellID->5220],

Cell[TextData[{
 "Since there are only ever a finite number of possible solutions for integer \
equations modulo ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can systematically find them. "
}], "Text",
 CellID->14615],

Cell["This finds all solutions modulo 4. ", "MathCaption",
 CellID->22348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "==", 
    RowBox[{
     RowBox[{"y", "^", "4"}], "+", 
     RowBox[{"x", " ", "y"}], "+", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Modulus", "->", "4"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->26798],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "1"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "2"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"y", "\[Equal]", "2"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "3"}], "&&", 
    RowBox[{"y", "\[Equal]", "3"}]}], ")"}]}]], "Output",
 ImageSize->{347, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->1064168973]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " can also handle equations that involve several different moduli. "
}], "Text",
 CellID->31635],

Cell["Here is an equation involving two different moduli. ", "MathCaption",
 CellID->16857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], "+", "1"}], ",", "5"}], "]"}], "==", 
     RowBox[{"Mod", "[", 
      RowBox[{"x", ",", "7"}], "]"}]}], "&&", 
    RowBox[{"0", "<", "x", "<", "50"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->2883],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "4"}], "||", 
  RowBox[{"x", "\[Equal]", "7"}], "||", 
  RowBox[{"x", "\[Equal]", "15"}], "||", 
  RowBox[{"x", "\[Equal]", "23"}], "||", 
  RowBox[{"x", "\[Equal]", "31"}], "||", 
  RowBox[{"x", "\[Equal]", "39"}], "||", 
  RowBox[{"x", "\[Equal]", "42"}]}]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->98330559]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Reduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reduce"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["dom", "TI"], "]"}], Cell[
    "specify a default domain for all variables", "TableText"]},
   {
    RowBox[{
     ButtonBox["Reduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reduce"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], "\[Element]", 
         SubscriptBox[
          StyleBox["dom", "TI"], 
          StyleBox["1", "TR"]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["vars", "TI"]}], "]"}], Cell[
    "explicitly specify individual domains for variables", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18902],

Cell["Different ways to specify domains for variables. ", "Caption",
 CellID->28262],

Cell[TextData[{
 "This assumes that ",
 Cell[BoxData["x"], "InlineFormula"],
 " is an integer, but ",
 Cell[BoxData["y"], "InlineFormula"],
 " is a real. "
}], "MathCaption",
 CellID->19420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "^", "2"}]}]}], "==", "1"}], ",", 
     RowBox[{"x", " ", "\[Element]", " ", "Integers"}], ",", 
     RowBox[{"y", " ", "\[Element]", " ", "Reals"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->19770],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["2"]]}]}], "||", 
      RowBox[{"y", "\[Equal]", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{453, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->1686131321]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " normally treats complex variables as single objects. But in dealing with \
functions that are not analytic or have branch cuts, it sometimes has to \
break them into pairs of real variables ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->9273],

Cell["The result involves separate real and imaginary parts. ", "MathCaption",
 CellID->25841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "z", "]"}], "==", "1"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->12686],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "\[LessEqual]", 
   RowBox[{"Re", "[", "z", "]"}], "\[LessEqual]", "1"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Im", "[", "z", "]"}], "\[Equal]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"Re", "[", "z", "]"}], "2"]}]]}]}], "||", 
    RowBox[{
     RowBox[{"Im", "[", "z", "]"}], "\[Equal]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Re", "[", "z", "]"}], "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{412, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->1625617911]
}, Open  ]],

Cell["\<\
Here again there is a separate condition on the imaginary part. \
\>", "MathCaption",
 CellID->3917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "z", "]"}], "==", "a"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->31717],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[Pi]"}], "<", 
   RowBox[{"Im", "[", "a", "]"}], "\[LessEqual]", "\[Pi]"}], "&&", 
  RowBox[{"z", "\[Equal]", 
   SuperscriptBox["\[ExponentialE]", "a"]}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->724175496]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " by default assumes that variables that appear algebraically in \
inequalities are real. But you can override this by explicitly specifying ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 " as the default domain. It is often useful in such cases to be able to \
specify that certain variables are still real. "
}], "Text",
 CellID->13698],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " by default assumes that ",
 Cell[BoxData["x"], "InlineFormula"],
 " is a real. "
}], "MathCaption",
 CellID->11267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "<", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->11749],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "<", "x", "<", "1"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->1360054325]
}, Open  ]],

Cell[TextData[{
 "This forces ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to consider the case where ",
 Cell[BoxData["x"], "InlineFormula"],
 " can be complex. "
}], "MathCaption",
 CellID->10389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "<", "1"}], ",", "x", ",", "Complexes"}], 
  "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->6932],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", 
     RowBox[{"Re", "[", "x", "]"}], "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "x", "]"}], "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{
   RowBox[{"Re", "[", "x", "]"}], "\[Equal]", "0"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", 
     RowBox[{"Re", "[", "x", "]"}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"Im", "[", "x", "]"}], "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->986696672]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData["x"], "InlineFormula"],
 " does not appear algebraically, ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " immediately assumes that it can be complex. "
}], "MathCaption",
 CellID->16081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], "<", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->2003],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", 
   RowBox[{"Re", "[", "x", "]"}], "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox[
       RowBox[{"Re", "[", "x", "]"}], "2"]}]]}], "<", 
   RowBox[{"Im", "[", "x", "]"}], "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      RowBox[{"Re", "[", "x", "]"}], "2"]}]]}]}]], "Output",
 ImageSize->{337, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->799643201]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData["x"], "InlineFormula"],
 " is a real, but ",
 Cell[BoxData["y"], "InlineFormula"],
 " can be complex. "
}], "MathCaption",
 CellID->13028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", "y", "]"}], "<", 
      RowBox[{"Abs", "[", "x", "]"}]}], ",", 
     RowBox[{"x", " ", "\[Element]", " ", "Reals"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->18631],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       SuperscriptBox["x", "2"]]}], "<", 
     RowBox[{"Re", "[", "y", "]"}], "<", 
     SqrtBox[
      SuperscriptBox["x", "2"]]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox[
         RowBox[{"Re", "[", "y", "]"}], "2"]}]]}], "<", 
     RowBox[{"Im", "[", "y", "]"}], "<", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox[
        RowBox[{"Re", "[", "y", "]"}], "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       SuperscriptBox["x", "2"]]}], "<", 
     RowBox[{"Re", "[", "y", "]"}], "<", 
     SqrtBox[
      SuperscriptBox["x", "2"]]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox[
         RowBox[{"Re", "[", "y", "]"}], "2"]}]]}], "<", 
     RowBox[{"Im", "[", "y", "]"}], "<", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["x", "2"], "-", 
       SuperscriptBox[
        RowBox[{"Re", "[", "y", "]"}], "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{476, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->925071607]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FindInstance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindInstance"], "[", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["dom", "TI"], "]"}], Cell[TextData[{
     "try to find an instance of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " in ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     " satisfying ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FindInstance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FindInstance"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["vars", "TI"], ",", 
     StyleBox["dom", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "try to find ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " instances"
    }], "TableText"]},
   {
    ButtonBox["Complexes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Complexes"], Cell[TextData[{
     "the domain of complex numbers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Reals",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reals"], Cell[TextData[{
     "the domain of real numbers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalR]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"], Cell[TextData[{
     "the domain of integers ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalZ]", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    ButtonBox["Booleans",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Booleans"], Cell[TextData[{
     "the domain of Booleans (",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ") ",
     Cell[BoxData[
      FormBox["\[DoubleStruckCapitalB]", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23152],

Cell["Finding particular solutions in domains. ", "Caption",
 CellID->18630],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " always returns a complete representation of the solution to a system of \
equations or inequalities. Sometimes, however, you may just want to find \
particular sample solutions. You can do this using ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19172],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " then this means that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has effectively proved that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " cannot be satisfied for any values of variables in the specified domain. \
When ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be satisfied, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " will normally pick quite arbitrarily among values that do this, as \
discussed for inequalities in \"",
 ButtonBox["Inequalities: Manipulating Equations and Inequalities\"",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/Inequalities-ManipulatingEquationsAndInequalities"],
 ". "
}], "Text",
 CellID->19864],

Cell[TextData[{
 "Particularly for integer equations, ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " can often find particular solutions to equations even when ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " cannot find a complete solution. In such cases it usually returns one of \
the smallest solutions to the equations. "
}], "Text",
 CellID->6407],

Cell["This finds the smallest integer point on an elliptic curve. ", \
"MathCaption",
 CellID->12295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "==", 
      RowBox[{
       RowBox[{"y", "^", "3"}], "+", "12"}]}], ",", 
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"y", ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->25428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "47"}], ",", 
    RowBox[{"y", "\[Rule]", "13"}]}], "}"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->1784797411]
}, Open  ]],

Cell[TextData[{
 "One feature of ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " is that it also works with Boolean expressions whose variables can have \
values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". You can use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to determine whether a particular expression is ",
 StyleBox["satisfiable",
  FontSlant->"Italic"],
 ", so that there is some choice of truth values for its variables that makes \
the expression ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "."
}], "Text",
 CellID->18490],

Cell[TextData[{
 "This expression cannot be satisfied for any choice of ",
 Cell[BoxData["p"], "InlineFormula"],
 " and ",
 Cell[BoxData["q"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->26610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"p", "&&", 
    RowBox[{"!", 
     RowBox[{"(", 
      RowBox[{"p", "||", 
       RowBox[{"!", "q"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}], ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->26177],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->1781238257]
}, Open  ]],

Cell["But this can. ", "MathCaption",
 CellID->25236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{"p", "&&", 
    RowBox[{"!", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"!", "p"}], "||", 
       RowBox[{"!", "q"}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "q"}], "}"}], ",", "Booleans"}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->6459],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "\[Rule]", "True"}], ",", 
    RowBox[{"q", "\[Rule]", "True"}]}], "}"}], "}"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->2137579291]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->169175361],

Cell[TextData[ButtonBox["Manipulating Equations and Inequalities",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], \
"RelatedTutorials",
 CellID->6804882],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "RelatedTutorials",\

 CellID->65437048]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Equations and Inequalities over Domains - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "Manipulating Equations and Inequalities", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingEquationsAndInequalitiesOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/Inequalities-ManipulatingEquationsAndInequalities"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfSolutionSets"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 10.8923420}", "context" -> "", 
    "keywords" -> {
     "Boolean satisfiability", "chinese remainder theorem", 
      "Closedform solutions", "complexes", "complex variables", 
      "Diophantine equations", "domains", "elliptic curve equations", 
      "equations", "number fields", "FindInstance", "FrobeniusSolve", 
      "GeneratedParameters", "Hilberts Tenth Problem", "integer equations", 
      "integers", "linear equations", "modular equations", "number theory", 
      "Pell equations", "Reals", "reduce", "rings", "Satisfiability", 
      "SAT problem", "sets of numbers", "Thue equations", "undecidability"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica normally assumes that variables which appear in equations \
can stand for arbitrary complex numbers. But when you use Reduce, you can \
explicitly tell Mathematica that the variables stand for objects in more \
restricted domains. Solving over domains. Reduce by default assumes that x \
can be complex, and gives all five complex solutions. ", 
    "synonyms" -> {"3.4.9"}, "title" -> 
    "Equations and Inequalities over Domains", "type" -> "Tutorial", "uri" -> 
    "tutorial/EquationsAndInequalitiesOverDomains"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.4.9"->{
  Cell[2910, 74, 102, 2, 70, "Title",
   CellTags->{"S3.4.9", "9.1"},
   CellID->18990]},
 "9.1"->{
  Cell[2910, 74, 102, 2, 70, "Title",
   CellTags->{"S3.4.9", "9.1"},
   CellID->18990]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.4.9", 69366, 2467},
 {"9.1", 69466, 2471}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2285, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2910, 74, 102, 2, 70, "Title",
 CellTags->{"S3.4.9", "9.1"},
 CellID->18990],
Cell[3015, 78, 481, 14, 70, "Text",
 CellID->30338],
Cell[3499, 94, 1541, 48, 70, "DefinitionBox",
 CellID->21641],
Cell[5043, 144, 57, 1, 70, "Caption",
 CellID->23258],
Cell[5103, 147, 292, 9, 70, "MathCaption",
 CellID->19047],
Cell[CellGroupData[{
Cell[5420, 160, 293, 11, 28, "Input",
 CellID->2352],
Cell[5716, 173, 592, 21, 38, "Output",
 CellID->2023783629]
}, Open  ]],
Cell[6323, 197, 165, 5, 70, "MathCaption",
 CellID->479],
Cell[CellGroupData[{
Cell[6513, 206, 309, 11, 28, "Input",
 CellID->25302],
Cell[6825, 219, 390, 14, 38, "Output",
 CellID->1451991367]
}, Open  ]],
Cell[7230, 236, 176, 5, 70, "MathCaption",
 CellID->10002],
Cell[CellGroupData[{
Cell[7431, 245, 312, 11, 70, "Input",
 CellID->15568],
Cell[7746, 258, 261, 9, 36, "Output",
 CellID->2020395890]
}, Open  ]],
Cell[8022, 270, 595, 18, 70, "Text",
 CellID->16895],
Cell[8620, 290, 452, 8, 70, "Text",
 CellID->6135],
Cell[9075, 300, 113, 3, 70, "MathCaption",
 CellID->18008],
Cell[CellGroupData[{
Cell[9213, 307, 272, 10, 70, "Input",
 CellID->12361],
Cell[9488, 319, 395, 15, 45, "Output",
 CellID->1211171062]
}, Open  ]],
Cell[9898, 337, 121, 3, 70, "MathCaption",
 CellID->22194],
Cell[CellGroupData[{
Cell[10044, 344, 286, 10, 70, "Input",
 CellID->23699],
Cell[10333, 356, 535, 19, 52, "Output",
 CellID->2050326738]
}, Open  ]],
Cell[10883, 378, 134, 4, 70, "MathCaption",
 CellID->20178],
Cell[CellGroupData[{
Cell[11042, 386, 288, 10, 70, "Input",
 CellID->4042],
Cell[11333, 398, 695, 24, 36, "Output",
 CellID->1416891126]
}, Open  ]],
Cell[12043, 425, 560, 15, 70, "Text",
 CellID->23941],
Cell[12606, 442, 120, 3, 70, "MathCaption",
 CellID->1847],
Cell[CellGroupData[{
Cell[12751, 449, 439, 15, 70, "Input",
 CellID->7469],
Cell[13193, 466, 886, 32, 52, "Output",
 CellID->1725406370]
}, Open  ]],
Cell[14094, 501, 1978, 64, 70, "DefinitionBox",
 CellID->4380],
Cell[16075, 567, 127, 4, 70, "Caption",
 CellID->31913],
Cell[16205, 573, 247, 5, 70, "Text",
 CellID->14964],
Cell[16455, 580, 169, 5, 70, "MathCaption",
 CellID->25710],
Cell[CellGroupData[{
Cell[16649, 589, 291, 10, 70, "Input",
 CellID->20061],
Cell[16943, 601, 1226, 40, 58, "Output",
 CellID->685129192]
}, Open  ]],
Cell[18184, 644, 160, 5, 70, "MathCaption",
 CellID->20073],
Cell[CellGroupData[{
Cell[18369, 653, 287, 10, 70, "Input",
 CellID->27504],
Cell[18659, 665, 2182, 75, 108, "Output",
 CellID->1347525525]
}, Open  ]],
Cell[20856, 743, 462, 11, 70, "Text",
 CellID->32703],
Cell[21321, 756, 114, 3, 70, "MathCaption",
 CellID->28102],
Cell[CellGroupData[{
Cell[21460, 763, 303, 10, 28, "Input",
 CellID->11069],
Cell[21766, 775, 1624, 31, 71, "Output",
 Evaluatable->False,
 CellID->546573045]
}, Open  ]],
Cell[23405, 809, 1379, 45, 70, "Text",
 CellID->3529],
Cell[24787, 856, 178, 6, 70, "MathCaption",
 CellID->31552],
Cell[CellGroupData[{
Cell[24990, 866, 346, 11, 70, "Input",
 CellID->32074],
Cell[25339, 879, 418, 13, 36, "Output",
 CellID->1115243965]
}, Open  ]],
Cell[25772, 895, 368, 11, 70, "Text",
 CellID->3730],
Cell[26143, 908, 122, 3, 70, "MathCaption",
 CellID->2244],
Cell[CellGroupData[{
Cell[26290, 915, 235, 8, 70, "Input",
 CellID->10844],
Cell[26528, 925, 333, 12, 51, "Output",
 CellID->460215127]
}, Open  ]],
Cell[26876, 940, 100, 2, 70, "MathCaption",
 CellID->14118],
Cell[CellGroupData[{
Cell[27001, 946, 238, 8, 70, "Input",
 CellID->24065],
Cell[27242, 956, 1312, 46, 54, "Output",
 CellID->68070088]
}, Open  ]],
Cell[28569, 1005, 126, 4, 70, "MathCaption",
 CellID->19552],
Cell[CellGroupData[{
Cell[28720, 1013, 333, 11, 70, "Input",
 CellID->28773],
Cell[29056, 1026, 678, 22, 54, "Output",
 CellID->1906651502]
}, Open  ]],
Cell[29749, 1051, 630, 19, 70, "Text",
 CellID->29731],
Cell[30382, 1072, 122, 3, 70, "MathCaption",
 CellID->6747],
Cell[CellGroupData[{
Cell[30529, 1079, 397, 14, 70, "Input",
 CellID->7511],
Cell[30929, 1095, 1529, 47, 71, "Output",
 CellID->1483131429]
}, Open  ]],
Cell[32473, 1145, 354, 10, 70, "Text",
 CellID->14398],
Cell[32830, 1157, 80, 1, 70, "MathCaption",
 CellID->10498],
Cell[CellGroupData[{
Cell[32935, 1162, 437, 15, 70, "Input",
 CellID->7103],
Cell[33375, 1179, 1301, 45, 96, "Output",
 CellID->1726270014]
}, Open  ]],
Cell[34691, 1227, 259, 9, 70, "MathCaption",
 CellID->25679],
Cell[CellGroupData[{
Cell[34975, 1240, 327, 11, 70, "Input",
 CellID->28053],
Cell[35305, 1253, 635, 19, 54, "Output",
 CellID->119085245]
}, Open  ]],
Cell[35955, 1275, 228, 7, 70, "Text",
 CellID->14522],
Cell[36186, 1284, 219, 8, 70, "MathCaption",
 CellID->31088],
Cell[CellGroupData[{
Cell[36430, 1296, 362, 12, 70, "Input",
 CellID->1563],
Cell[36795, 1310, 925, 31, 54, "Output",
 CellID->1419303045]
}, Open  ]],
Cell[37735, 1344, 172, 5, 70, "MathCaption",
 CellID->9850],
Cell[CellGroupData[{
Cell[37932, 1353, 363, 12, 70, "Input",
 CellID->17022],
Cell[38298, 1367, 164, 5, 36, "Output",
 CellID->1320899194]
}, Open  ]],
Cell[38477, 1375, 221, 5, 70, "Text",
 CellID->21911],
Cell[38701, 1382, 419, 10, 70, "Text",
 CellID->9492],
Cell[39123, 1394, 855, 18, 70, "Text",
 CellID->5651],
Cell[39981, 1414, 282, 9, 70, "Text",
 CellID->28580],
Cell[40266, 1425, 231, 7, 70, "MathCaption",
 CellID->15477],
Cell[CellGroupData[{
Cell[40522, 1436, 578, 20, 70, "Input",
 CellID->27616],
Cell[41103, 1458, 1639, 57, 71, "Output",
 CellID->57358318]
}, Open  ]],
Cell[42757, 1518, 797, 24, 70, "DefinitionBox",
 CellID->19178],
Cell[43557, 1544, 165, 6, 70, "Caption",
 CellID->5220],
Cell[43725, 1552, 364, 12, 70, "Text",
 CellID->14615],
Cell[44092, 1566, 74, 1, 70, "MathCaption",
 CellID->22348],
Cell[CellGroupData[{
Cell[44191, 1571, 349, 12, 70, "Input",
 CellID->26798],
Cell[44543, 1585, 900, 30, 54, "Output",
 CellID->1064168973]
}, Open  ]],
Cell[45458, 1618, 228, 7, 70, "Text",
 CellID->31635],
Cell[45689, 1627, 91, 1, 70, "MathCaption",
 CellID->16857],
Cell[CellGroupData[{
Cell[45805, 1632, 380, 13, 70, "Input",
 CellID->2883],
Cell[46188, 1647, 452, 13, 36, "Output",
 CellID->98330559]
}, Open  ]],
Cell[46655, 1663, 1316, 40, 70, "DefinitionBox",
 CellID->18902],
Cell[47974, 1705, 84, 1, 70, "Caption",
 CellID->28262],
Cell[48061, 1708, 190, 7, 70, "MathCaption",
 CellID->19420],
Cell[CellGroupData[{
Cell[48276, 1719, 465, 15, 70, "Input",
 CellID->19770],
Cell[48744, 1736, 753, 27, 59, "Output",
 CellID->1686131321]
}, Open  ]],
Cell[49512, 1766, 684, 23, 70, "Text",
 CellID->9273],
Cell[50199, 1791, 94, 1, 70, "MathCaption",
 CellID->25841],
Cell[CellGroupData[{
Cell[50318, 1796, 179, 6, 70, "Input",
 CellID->12686],
Cell[50500, 1804, 701, 24, 52, "Output",
 CellID->1625617911]
}, Open  ]],
Cell[51216, 1831, 110, 3, 70, "MathCaption",
 CellID->3917],
Cell[CellGroupData[{
Cell[51351, 1838, 228, 8, 70, "Input",
 CellID->31717],
Cell[51582, 1848, 353, 11, 36, "Output",
 CellID->724175496]
}, Open  ]],
Cell[51950, 1862, 548, 14, 70, "Text",
 CellID->13698],
Cell[52501, 1878, 249, 9, 70, "MathCaption",
 CellID->11267],
Cell[CellGroupData[{
Cell[52775, 1891, 171, 6, 70, "Input",
 CellID->11749],
Cell[52949, 1899, 210, 7, 36, "Output",
 CellID->1360054325]
}, Open  ]],
Cell[53174, 1909, 274, 10, 70, "MathCaption",
 CellID->10389],
Cell[CellGroupData[{
Cell[53473, 1923, 191, 7, 70, "Input",
 CellID->6932],
Cell[53667, 1932, 633, 21, 36, "Output",
 CellID->986696672]
}, Open  ]],
Cell[54315, 1956, 300, 10, 70, "MathCaption",
 CellID->16081],
Cell[CellGroupData[{
Cell[54640, 1970, 177, 6, 70, "Input",
 CellID->2003],
Cell[54820, 1978, 547, 20, 45, "Output",
 CellID->799643201]
}, Open  ]],
Cell[55382, 2001, 178, 7, 70, "MathCaption",
 CellID->13028],
Cell[CellGroupData[{
Cell[55585, 2012, 363, 12, 70, "Input",
 CellID->18631],
Cell[55951, 2026, 1429, 52, 84, "Output",
 CellID->925071607]
}, Open  ]],
Cell[57395, 2081, 2832, 89, 70, "DefinitionBox",
 CellID->23152],
Cell[60230, 2172, 76, 1, 70, "Caption",
 CellID->18630],
Cell[60309, 2175, 497, 14, 70, "Text",
 CellID->19172],
Cell[60809, 2191, 1143, 37, 70, "Text",
 CellID->19864],
Cell[61955, 2230, 511, 14, 70, "Text",
 CellID->6407],
Cell[62469, 2246, 101, 2, 70, "MathCaption",
 CellID->12295],
Cell[CellGroupData[{
Cell[62595, 2252, 415, 14, 70, "Input",
 CellID->25428],
Cell[63013, 2268, 294, 10, 36, "Output",
 CellID->1784797411]
}, Open  ]],
Cell[63322, 2281, 973, 33, 70, "Text",
 CellID->18490],
Cell[64298, 2316, 201, 7, 70, "MathCaption",
 CellID->26610],
Cell[CellGroupData[{
Cell[64524, 2327, 316, 11, 70, "Input",
 CellID->26177],
Cell[64843, 2340, 177, 6, 36, "Output",
 CellID->1781238257]
}, Open  ]],
Cell[65035, 2349, 53, 1, 70, "MathCaption",
 CellID->25236],
Cell[CellGroupData[{
Cell[65113, 2354, 338, 12, 70, "Input",
 CellID->6459],
Cell[65454, 2368, 298, 10, 36, "Output",
 CellID->2137579291]
}, Open  ]],
Cell[CellGroupData[{
Cell[65789, 2383, 72, 1, 70, "RelatedTutorialsSection",
 CellID->169175361],
Cell[65864, 2386, 208, 5, 70, "RelatedTutorials",
 CellID->6804882],
Cell[66075, 2393, 173, 4, 70, "RelatedTutorials",
 CellID->65437048]
}, Open  ]]
}, Open  ]],
Cell[66275, 2401, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

