(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38752,       1351]
NotebookOptionsPosition[     30708,       1091]
NotebookOutlinePosition[     34925,       1209]
CellTagsIndexPosition[     34587,       1193]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AddTo" :> Documentation`HelpLookup["paclet:ref/AddTo"], "And" :> 
         Documentation`HelpLookup["paclet:ref/And"], "Block" :> 
         Documentation`HelpLookup["paclet:ref/Block"], "CompoundExpression" :> 
         Documentation`HelpLookup["paclet:ref/CompoundExpression"], "Do" :> 
         Documentation`HelpLookup["paclet:ref/Do"], "Evaluate" :> 
         Documentation`HelpLookup["paclet:ref/Evaluate"], "Function" :> 
         Documentation`HelpLookup["paclet:ref/Function"], "Hold" :> 
         Documentation`HelpLookup["paclet:ref/Hold"], "HoldAll" :> 
         Documentation`HelpLookup["paclet:ref/HoldAll"], "HoldComplete" :> 
         Documentation`HelpLookup["paclet:ref/HoldComplete"], "HoldFirst" :> 
         Documentation`HelpLookup["paclet:ref/HoldFirst"], "HoldForm" :> 
         Documentation`HelpLookup["paclet:ref/HoldForm"], "HoldPattern" :> 
         Documentation`HelpLookup["paclet:ref/HoldPattern"], "HoldRest" :> 
         Documentation`HelpLookup["paclet:ref/HoldRest"], "If" :> 
         Documentation`HelpLookup["paclet:ref/If"], "Module" :> 
         Documentation`HelpLookup["paclet:ref/Module"], "Or" :> 
         Documentation`HelpLookup["paclet:ref/Or"], "Plot" :> 
         Documentation`HelpLookup["paclet:ref/Plot"], "Set" :> 
         Documentation`HelpLookup["paclet:ref/Set"], "Sum" :> 
         Documentation`HelpLookup["paclet:ref/Sum"], "Trace" :> 
         Documentation`HelpLookup["paclet:ref/Trace"], "Unevaluated" :> 
         Documentation`HelpLookup["paclet:ref/Unevaluated"], "Which" :> 
         Documentation`HelpLookup["paclet:ref/Which"], "$IterationLimit" :> 
         Documentation`HelpLookup["paclet:ref/$IterationLimit"], 
         "$RecursionLimit" :> 
         Documentation`HelpLookup["paclet:ref/$RecursionLimit"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"AddTo\"\>", 2->"\<\"And\"\>", 
      3->"\<\"Block\"\>", 4->"\<\"CompoundExpression\"\>", 5->"\<\"Do\"\>", 
      6->"\<\"Evaluate\"\>", 7->"\<\"Function\"\>", 8->"\<\"Hold\"\>", 
      9->"\<\"HoldAll\"\>", 10->"\<\"HoldComplete\"\>", 
      11->"\<\"HoldFirst\"\>", 12->"\<\"HoldForm\"\>", 
      13->"\<\"HoldPattern\"\>", 14->"\<\"HoldRest\"\>", 15->"\<\"If\"\>", 
      16->"\<\"Module\"\>", 17->"\<\"Or\"\>", 18->"\<\"Plot\"\>", 
      19->"\<\"Set\"\>", 20->"\<\"Sum\"\>", 21->"\<\"Trace\"\>", 
      22->"\<\"Unevaluated\"\>", 23->"\<\"Which\"\>", 
      24->"\<\"$IterationLimit\"\>", 
      25->"\<\"$RecursionLimit\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Evaluation", "Title",
 CellID->2050626245],

Cell[CellGroupData[{

Cell["The Standard Evaluation Sequence", "Section",
 CellTags->{"SA.4.1", "1.1"},
 CellID->19212],

Cell[TextData[{
 "The following is the sequence of steps that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows in evaluating an expression like ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], 
     StyleBox["\[Ellipsis]", "TR"]}]}], "]"}]], "InlineFormula"],
 ". Every time the expression changes, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively starts the evaluation sequence over again."
}], "Text",
 CellID->26114],

Cell[TextData[{
 "If the expression is a raw object (e.g., ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", etc.), leave it unchanged. "
}], "Notes",
 CellID->30129],

Cell[TextData[{
 "Evaluate the head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " of the expression. "
}], "Notes",
 CellID->166648925],

Cell[TextData[{
 "Evaluate each element ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " of the expression in turn. If ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " is a symbol with attributes ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ", then skip evaluation of certain elements. "
}], "Notes",
 CellID->72445495],

Cell[TextData[{
 "Unless ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ", strip the outermost of any ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " wrappers that appear in the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->113427891],

Cell[TextData[{
 "Unless ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["SequenceHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceHold"]], "InlineFormula"],
 ", flatten out all ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects that appear among the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->58084889],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ", then flatten out all nested expressions with head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->161564239],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ", then thread through any ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " that are lists."
}], "Notes",
 CellID->67916168],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ", then sort the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " into order."
}], "Notes",
 CellID->330707854],

Cell[TextData[{
 "Unless ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ", use any applicable transformation rules associated with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " that you have defined for objects of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->318603780],

Cell[TextData[{
 "Use any built\[Hyphen]in transformation rules associated with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " for objects of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->453904039],

Cell[TextData[{
 "Use any applicable transformation rules that you have defined for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " or for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["h", "TI"], "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->271141904],

Cell[TextData[{
 "Use any built\[Hyphen]in transformation rules for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " or for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["h", "TI"], "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->515773118]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nonstandard Argument Evaluation", "Section",
 CellTags->{"SA.4.2", "2.1"},
 CellID->14361],

Cell[TextData[{
 "There are a number of built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions that evaluate their arguments in special ways. The control \
structure ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " is an example. The symbol ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". As a result, the arguments of ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " are not evaluated as part of the standard evaluation process. Instead, the \
internal code for ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " evaluates the arguments in a special way. In the case of ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 ", the code evaluates the arguments repeatedly, so as to implement a loop. "
}], "Text",
 CellID->7485],

Cell[BoxData[GridBox[{
   {Cell["Control structures", "TableText"], Cell[TextData[{
     "arguments evaluated in a sequence determined by control flow (e.g., ",
     Cell[BoxData[
      ButtonBox["CompoundExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CompoundExpression"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["Conditionals", "TableText"], Cell[TextData[{
     "arguments evaluated only when they correspond to branches that are \
taken (e.g., ",
     Cell[BoxData[
      ButtonBox["If",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/If"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Which",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Which"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["Logical operations", "TableText"], Cell[TextData[{
     "arguments evaluated only when they are needed in determining the \
logical result (e.g., ",
     Cell[BoxData[
      ButtonBox["And",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/And"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Or",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Or"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["Iteration functions", "TableText"], Cell[TextData[{
     "first argument evaluated for each step in the iteration (e.g., ",
     Cell[BoxData[
      ButtonBox["Do",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Do"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Sum",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Plot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["Tracing functions", "TableText"], Cell[TextData[{
     "form never evaluated (e.g., ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["Assignments", "TableText"], Cell[TextData[{
     "first argument only partially evaluated (e.g., ",
     Cell[BoxData[
      ButtonBox["Set",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Set"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["AddTo",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AddTo"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["Pure functions", "TableText"], Cell[TextData[{
     "function body not evaluated (e.g., ",
     Cell[BoxData[
      ButtonBox["Function",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Function"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["Scoping constructs", "TableText"], Cell[TextData[{
     "variable specifications not evaluated (e.g., ",
     Cell[BoxData[
      ButtonBox["Module",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Module"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Block",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Block"]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["Holding functions", "TableText"], Cell[TextData[{
     "argument maintained in unevaluated form (e.g., ",
     Cell[BoxData[
      ButtonBox["Hold",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["HoldPattern",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13095],

Cell["\<\
Built\[Hyphen]in functions that evaluate their arguments in special ways. \
\>", "Caption",
 CellID->23007],

Cell[CellGroupData[{

Cell["Logical Operations", "Subsection",
 CellID->17156],

Cell[TextData[{
 "In an expression of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "&&", 
    SubscriptBox["e", "2"], "&&", 
    SubscriptBox["e", "3"]}], TraditionalForm]], "InlineMath"],
 " the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are evaluated in order. As soon as any ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " is found to be ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", evaluation is stopped, and the result ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " is returned. This means that you can use the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " to represent different \[OpenCurlyDoubleQuote]branches\
\[CloseCurlyDoubleQuote] in a program, with a particular branch being \
evaluated only if certain conditions are met."
}], "Text",
 CellID->27544],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " function works much like ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 "; it returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " as soon as it finds any argument that is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Xor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Xor"]], "InlineFormula"],
 ", on the other hand, always evaluates ",
 StyleBox["all",
  FontSlant->"Italic"],
 " its arguments. "
}], "Text",
 CellID->4605]
}, Open  ]],

Cell[CellGroupData[{

Cell["Iteration Functions", "Subsection",
 CellID->6624],

Cell[TextData[{
 "An iteration function such as",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " is evaluated as follows:"
}], "Text",
 CellID->16056],

Cell[TextData[{
 "The limits ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " are evaluated. "
}], "Notes",
 CellID->20892],

Cell[TextData[{
 "The value of the iteration variable ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " is made local, effectively using ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->335091084],

Cell[TextData[{
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " are used to determine the sequence of values to be assigned to the \
iteration variable\[NonBreakingSpace]",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->72460775],

Cell[TextData[{
 "The iteration variable is successively set to each value, and ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is evaluated in each case."
}], "Notes",
 CellID->178892021],

Cell[TextData[{
 "The local values assigned to ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " are cleared."
}], "Notes",
 CellID->161395672],

Cell["\<\
If there are several iteration variables, the same procedure is followed for \
each variable in turn, for every value of all the preceding variables. \
\>", "Text",
 CellID->12250],

Cell[TextData[{
 "Unless otherwise specified, ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is not evaluated until a specific value has been assigned to ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ", and is then evaluated for each value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " chosen. You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Evaluate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Evaluate"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " to make ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " be evaluated immediately, rather than only after a specific value has been \
assigned to ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16085]
}, Open  ]],

Cell[CellGroupData[{

Cell["Assignments", "Subsection",
 CellID->2420],

Cell["\<\
The left\[Hyphen]hand sides of assignments are only partially evaluated. \
\>", "Text",
 CellID->9431],

Cell["\<\
If the left\[Hyphen]hand side is a symbol, no evaluation is performed.\
\>", "Notes",
 CellID->31516],

Cell["\<\
If the left\[Hyphen]hand side is a function without hold attributes, the \
arguments of the function are evaluated, but the function itself is not \
evaluated.\
\>", "Notes",
 CellID->49880818],

Cell[TextData[{
 "The right\[Hyphen]hand side is evaluated for immediate (",
 Cell[BoxData["="], "InlineFormula"],
 "), but not for delayed (",
 Cell[BoxData[":="], "InlineFormula"],
 "), assignments. "
}], "Text",
 CellID->28786],

Cell[TextData[{
 "Any subexpression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HoldPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldPattern"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " that appears on the left\[Hyphen]hand side of an assignment is not \
evaluated. When the subexpression is used for pattern matching, it matches as \
though it were ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " without the ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5034]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Overriding Nonstandard Argument Evaluation", "Section",
 CellTags->{"SA.4.3", "3.1"},
 CellID->2800],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     RowBox[{
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{
       ButtonBox["Evaluate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Evaluate"], "[", 
       StyleBox["expr", "TI"], "]"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "evaluates the argument ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", whether or not ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " has a ",
     Cell[BoxData[
      ButtonBox["HoldFirst",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["HoldRest",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
     ", or ",
     Cell[BoxData[
      ButtonBox["HoldAll",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
     " attribute specifying that it should be held"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->18087],

Cell["Overriding holding of arguments. ", "Caption",
 CellID->31060],

Cell[TextData[{
 "By using ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 ", you can get any argument of a function evaluated immediately, even if the \
argument would usually be evaluated later under the control of the \
function.",
 " ",
 "An exception to this is when the function has the ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " attribute; in this case, the contents of the function are not modified by \
the evaluator."
}], "Text",
 CellID->1926]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preventing Evaluation", "Section",
 CellTags->{"SA.4.4", "4.1"},
 CellID->17124],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides various functions which act as \[OpenCurlyDoubleQuote]wrappers\
\[CloseCurlyDoubleQuote] to prevent the expressions they contain from being \
evaluated. "
}], "Text",
 CellID->23941],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "treated as ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hold",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hold"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " in all cases"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HoldComplete",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldComplete"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "treated as ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["HoldComplete",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HoldComplete"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " with upvalues disabled"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HoldForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "treated as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " for printing"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HoldPattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldPattern"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "treated as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in rules, definitions and patterns"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Unevaluated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unevaluated"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "treated as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " when arguments are passed to a function"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32745],

Cell["Wrappers that prevent expressions from being evaluated. ", "Caption",
 CellID->31762]
}, Open  ]],

Cell[CellGroupData[{

Cell["Global Control of Evaluation", "Section",
 CellTags->{"SA.4.5", "5.1"},
 CellID->23953],

Cell["\<\
In the evaluation procedure described so far, two basic kinds of steps are \
involved: \
\>", "Text",
 CellID->19485],

Cell["\<\
Iteration: evaluate a particular expression until it no longer changes.\
\>", "Notes",
 CellID->20741],

Cell["\<\
Recursion: evaluate subsidiary expressions needed to find the value of a \
particular expression.\
\>", "Notes",
 CellID->208211446],

Cell["\<\
Iteration leads to evaluation chains in which successive expressions are \
obtained by the application of various transformation rules. \
\>", "Text",
 CellID->10199],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " shows evaluation chains as lists, and shows subsidiary evaluations \
corresponding to recursion in sublists. "
}], "Text",
 CellID->11567],

Cell[TextData[{
 "The expressions associated with the sequence of subsidiary evaluations \
which lead to an expression currently being evaluated are given in the list \
returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"], "[", "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->4208],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$RecursionLimit",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$RecursionLimit"], Cell[
    "maximum recursion depth", "TableText"]},
   {
    ButtonBox["$IterationLimit",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$IterationLimit"], Cell[
    "maximum number of iterations", "TableText"]}
  }]], "DefinitionBox",
 CellID->6844],

Cell["Global variables controlling the evaluation of expressions.", "Caption",
 CellID->30169]
}, Open  ]],

Cell[CellGroupData[{

Cell["Aborts", "Section",
 CellTags->{"SA.4.6", "6.1"},
 CellID->19169],

Cell[TextData[{
 "You can ask ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to abort at any point in a computation, either by calling the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"], "[", "]"}]], "InlineFormula"],
 ", or by typing appropriate interrupt keys. "
}], "Text",
 CellID->15724],

Cell[TextData[{
 "When asked to abort, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will terminate the computation as quickly as possible. If the answer \
obtained would be incorrect or incomplete, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 " instead of giving that answer. "
}], "Text",
 CellID->11478],

Cell[TextData[{
 "Aborts can be caught using ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 ", and can be postponed using ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->29358]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Evaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 15.1737016}", "context" -> "", 
    "keywords" -> {
     "abort", "aborted", "AbortProtect", "and", "arguments", "assignments", 
      "Boolean expressions", "branch", "CheckAbort", "eval", "Evaluate", 
      "evaluation", "expressions", "hold", "HoldAll", "HoldAllComplete", 
      "HoldComplete", "HoldForm", "HoldPattern", "HoldRest", 
      "interrupt calculation", "iteration functions", "IterationLimit", 
      "iterators", "logical operations", "or", "order of evaluation", 
      "lazy evaluation", "RecursionLimit", "releasing held arguments", 
      "SequenceHold", "special evaluation", "stack", "terminate computation", 
      "trace", "transformation rules", "unevaluated", "xor"}, "index" -> True,
     "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The following is the sequence of steps that Mathematica follows in \
evaluating an expression like h[e_1,e_2...]. Every time the expression \
changes, Mathematica effectively starts the evaluation sequence over again. \
There are a number of built-in Mathematica functions that evaluate their \
arguments in special ways. The control structure While is an example. The \
symbol While has the attribute HoldAll. As a result, the arguments of While \
are not evaluated as part of the standard evaluation process. Instead, the \
internal code for While evaluates the arguments in a special way. In the case \
of While, the code evaluates the arguments repeatedly, so as to implement a \
loop. Built-in functions that evaluate their arguments in special ways. ", 
    "synonyms" -> {"A.4.1", "A.4.2", "A.4.3", "A.4.4", "A.4.5", "A.4.6"}, 
    "title" -> "Evaluation", "type" -> "Tutorial", "uri" -> 
    "tutorial/Evaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.4.1"->{
  Cell[3578, 80, 97, 2, 70, "Section",
   CellTags->{"SA.4.1", "1.1"},
   CellID->19212]},
 "1.1"->{
  Cell[3578, 80, 97, 2, 70, "Section",
   CellTags->{"SA.4.1", "1.1"},
   CellID->19212]},
 "SA.4.2"->{
  Cell[10651, 367, 96, 2, 70, "Section",
   CellTags->{"SA.4.2", "2.1"},
   CellID->14361]},
 "2.1"->{
  Cell[10651, 367, 96, 2, 70, "Section",
   CellTags->{"SA.4.2", "2.1"},
   CellID->14361]},
 "SA.4.3"->{
  Cell[22514, 795, 106, 2, 70, "Section",
   CellTags->{"SA.4.3", "3.1"},
   CellID->2800]},
 "3.1"->{
  Cell[22514, 795, 106, 2, 70, "Section",
   CellTags->{"SA.4.3", "3.1"},
   CellID->2800]},
 "SA.4.4"->{
  Cell[24862, 873, 86, 2, 70, "Section",
   CellTags->{"SA.4.4", "4.1"},
   CellID->17124]},
 "4.1"->{
  Cell[24862, 873, 86, 2, 70, "Section",
   CellTags->{"SA.4.4", "4.1"},
   CellID->17124]},
 "SA.4.5"->{
  Cell[27557, 967, 93, 2, 70, "Section",
   CellTags->{"SA.4.5", "5.1"},
   CellID->23953]},
 "5.1"->{
  Cell[27557, 967, 93, 2, 70, "Section",
   CellTags->{"SA.4.5", "5.1"},
   CellID->23953]},
 "SA.4.6"->{
  Cell[29376, 1037, 71, 2, 70, "Section",
   CellTags->{"SA.4.6", "6.1"},
   CellID->19169]},
 "6.1"->{
  Cell[29376, 1037, 71, 2, 70, "Section",
   CellTags->{"SA.4.6", "6.1"},
   CellID->19169]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.4.1", 33325, 1142},
 {"1.1", 33426, 1146},
 {"SA.4.2", 33530, 1150},
 {"2.1", 33633, 1154},
 {"SA.4.3", 33739, 1158},
 {"3.1", 33842, 1162},
 {"SA.4.4", 33948, 1166},
 {"4.1", 34051, 1170},
 {"SA.4.5", 34157, 1174},
 {"5.1", 34260, 1178},
 {"SA.4.6", 34366, 1182},
 {"6.1", 34470, 1186}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2880, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3505, 75, 48, 1, 70, "Title",
 CellID->2050626245],
Cell[CellGroupData[{
Cell[3578, 80, 97, 2, 70, "Section",
 CellTags->{"SA.4.1", "1.1"},
 CellID->19212],
Cell[3678, 84, 639, 22, 70, "Text",
 CellID->26114],
Cell[4320, 108, 362, 13, 70, "Notes",
 CellID->30129],
Cell[4685, 123, 152, 6, 70, "Notes",
 CellID->166648925],
Cell[4840, 131, 862, 31, 70, "Notes",
 CellID->72445495],
Cell[5705, 164, 568, 21, 70, "Notes",
 CellID->113427891],
Cell[6276, 187, 546, 21, 70, "Notes",
 CellID->58084889],
Cell[6825, 210, 363, 14, 70, "Notes",
 CellID->161564239],
Cell[7191, 226, 402, 16, 70, "Notes",
 CellID->67916168],
Cell[7596, 244, 391, 16, 70, "Notes",
 CellID->330707854],
Cell[7990, 262, 773, 27, 70, "Notes",
 CellID->318603780],
Cell[8766, 291, 533, 19, 70, "Notes",
 CellID->453904039],
Cell[9302, 312, 724, 26, 70, "Notes",
 CellID->271141904],
Cell[10029, 340, 585, 22, 70, "Notes",
 CellID->515773118]
}, Open  ]],
Cell[CellGroupData[{
Cell[10651, 367, 96, 2, 70, "Section",
 CellTags->{"SA.4.2", "2.1"},
 CellID->14361],
Cell[10750, 371, 1239, 38, 70, "Text",
 CellID->7485],
Cell[11992, 411, 3964, 120, 70, "DefinitionBox",
 CellID->13095],
Cell[15959, 533, 117, 3, 70, "Caption",
 CellID->23007],
Cell[CellGroupData[{
Cell[16101, 540, 56, 1, 70, "Subsection",
 CellID->17156],
Cell[16160, 543, 1086, 34, 70, "Text",
 CellID->27544],
Cell[17249, 579, 805, 31, 70, "Text",
 CellID->4605]
}, Open  ]],
Cell[CellGroupData[{
Cell[18091, 615, 56, 1, 70, "Subsection",
 CellID->6624],
Cell[18150, 618, 531, 21, 70, "Text",
 CellID->16056],
Cell[18684, 641, 291, 13, 70, "Notes",
 CellID->20892],
Cell[18978, 656, 311, 11, 70, "Notes",
 CellID->335091084],
Cell[19292, 669, 435, 16, 70, "Notes",
 CellID->72460775],
Cell[19730, 687, 203, 6, 70, "Notes",
 CellID->178892021],
Cell[19936, 695, 156, 6, 70, "Notes",
 CellID->161395672],
Cell[20095, 703, 190, 4, 70, "Text",
 CellID->12250],
Cell[20288, 709, 786, 26, 70, "Text",
 CellID->16085]
}, Open  ]],
Cell[CellGroupData[{
Cell[21111, 740, 48, 1, 70, "Subsection",
 CellID->2420],
Cell[21162, 743, 112, 3, 70, "Text",
 CellID->9431],
Cell[21277, 748, 111, 3, 70, "Notes",
 CellID->31516],
Cell[21391, 753, 203, 5, 70, "Notes",
 CellID->49880818],
Cell[21597, 760, 230, 7, 70, "Text",
 CellID->28786],
Cell[21830, 769, 635, 20, 70, "Text",
 CellID->5034]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22514, 795, 106, 2, 70, "Section",
 CellTags->{"SA.4.3", "3.1"},
 CellID->2800],
Cell[22623, 799, 1509, 46, 70, "DefinitionBox",
 CellID->18087],
Cell[24135, 847, 68, 1, 70, "Caption",
 CellID->31060],
Cell[24206, 850, 619, 18, 70, "Text",
 CellID->1926]
}, Open  ]],
Cell[CellGroupData[{
Cell[24862, 873, 86, 2, 70, "Section",
 CellTags->{"SA.4.4", "4.1"},
 CellID->17124],
Cell[24951, 877, 259, 7, 70, "Text",
 CellID->23941],
Cell[25213, 886, 2213, 73, 70, "DefinitionBox",
 CellID->32745],
Cell[27429, 961, 91, 1, 70, "Caption",
 CellID->31762]
}, Open  ]],
Cell[CellGroupData[{
Cell[27557, 967, 93, 2, 70, "Section",
 CellTags->{"SA.4.5", "5.1"},
 CellID->23953],
Cell[27653, 971, 127, 4, 70, "Text",
 CellID->19485],
Cell[27783, 977, 112, 3, 70, "Notes",
 CellID->20741],
Cell[27898, 982, 142, 4, 70, "Notes",
 CellID->208211446],
Cell[28043, 988, 176, 4, 70, "Text",
 CellID->10199],
Cell[28222, 994, 270, 8, 70, "Text",
 CellID->11567],
Cell[28495, 1004, 355, 11, 70, "Text",
 CellID->4208],
Cell[28853, 1017, 389, 12, 70, "DefinitionBox",
 CellID->6844],
Cell[29245, 1031, 94, 1, 70, "Caption",
 CellID->30169]
}, Open  ]],
Cell[CellGroupData[{
Cell[29376, 1037, 71, 2, 70, "Section",
 CellTags->{"SA.4.6", "6.1"},
 CellID->19169],
Cell[29450, 1041, 372, 12, 70, "Text",
 CellID->15724],
Cell[29825, 1055, 461, 15, 70, "Text",
 CellID->11478],
Cell[30289, 1072, 365, 13, 70, "Text",
 CellID->29358]
}, Open  ]]
}, Open  ]],
Cell[30681, 1089, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

