(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19992,        720]
NotebookOptionsPosition[     14700,        561]
NotebookOutlinePosition[     17818,        637]
CellTagsIndexPosition[     17727,        631]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluate" :> Documentation`HelpLookup["paclet:ref/Evaluate"], 
          "Table" :> Documentation`HelpLookup["paclet:ref/Table"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluate\"\>", 
       2->"\<\"Table\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Evaluation in Iteration Functions", "Title",
 CellTags->{"S2.6.7", "7.1"},
 CellID->16334],

Cell[TextData[{
 "The built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " iteration functions such as ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " evaluate their arguments in a slightly special way. "
}], "Text",
 CellID->21001],

Cell[TextData[{
 "When evaluating an expression like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ", the first step, as discussed in\[NonBreakingSpace]",
 ButtonBox["Blocks and Local Values",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/BlocksAndLocalValues"],
 ", is to make the value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " local. Next, the limit ",
 Cell[BoxData[
  StyleBox[
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["max", "TI"]], "TI"]], "InlineFormula"],
 " in the iterator specification is evaluated. The expression ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is maintained in an unevaluated form, but is repeatedly evaluated as a \
succession of values are assigned to ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ". When this is finished, the global value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " is restored. "
}], "Text",
 CellID->2737],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"], "[", "]"}]], "InlineFormula"],
 " is evaluated four separate times here, so four different pseudorandom \
numbers are generated."
}], "MathCaption",
 CellID->9310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", "]"}], ",", 
   RowBox[{"{", "4", "}"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->5974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.3009493947057875`", ",", "0.4501792985021398`", ",", 
   "0.8312375767649851`", ",", "0.16137861276243792`"}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->251781792]
}, Open  ]],

Cell[TextData[{
 "This evaluates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"], "[", "]"}]], "InlineFormula"],
 " before feeding it to ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". The result is a list of four identical numbers. "
}], "MathCaption",
 CellID->20356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
   RowBox[{"{", "4", "}"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->1071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6530982114884822`", ",", "0.6530982114884822`", ",", 
   "0.6530982114884822`", ",", "0.6530982114884822`"}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->325330899]
}, Open  ]],

Cell[TextData[{
 "In most cases, it is convenient for the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " in an expression like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " to be maintained in an unevaluated form until specific values have been \
assigned to ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 ". This is true in particular if a complete symbolic form for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " valid for any ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " cannot be found. "
}], "Text",
 CellID->10935],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["fac"], "InlineFormula"],
 " to give the factorial when it has an integer argument, and to give ",
 Cell[BoxData["NaN"], "InlineFormula"],
 " (standing for \[OpenCurlyDoubleQuote]Not a Number\[CloseCurlyDoubleQuote]) \
otherwise. "
}], "MathCaption",
 CellID->32145],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fac", "[", "n_Integer", "]"}], ":=", 
   RowBox[{"n", "!"}]}], ";", 
  RowBox[{
   RowBox[{"fac", "[", "x_", "]"}], ":=", "NaN"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->17282],

Cell[TextData[{
 "In this form, ",
 Cell[BoxData[
  RowBox[{"fac", "[", "i", "]"}]], "InlineFormula"],
 " is not evaluated until an explicit integer value has been assigned to ",
 Cell[BoxData["i"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"fac", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->18718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "6", ",", "24", ",", "120"}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->13573]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " forces ",
 Cell[BoxData[
  RowBox[{"fac", "[", "i", "]"}]], "InlineFormula"],
 " to be evaluated with ",
 Cell[BoxData["i"], "InlineFormula"],
 " left as a symbolic object. "
}], "MathCaption",
 CellID->4712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"fac", "[", "i", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->13037],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NaN", ",", "NaN", ",", "NaN", ",", "NaN", ",", "NaN"}], 
  "}"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->4998]
}, Open  ]],

Cell[TextData[{
 "In cases where a complete symbolic form for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " with arbitrary ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " in expressions such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " ",
 StyleBox["can",
  FontSlant->"Italic"],
 " be found, it is often more efficient to compute this form first, and then \
feed it to ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". You can do this using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Evaluate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Evaluate"], "[", 
     StyleBox["f", "TI"], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox[
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["max", "TI"]], "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->9905],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " in this case is evaluated separately for each value of ",
 Cell[BoxData["i"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"i", "^", "k"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->1717],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "30", ",", "120", ",", "340", ",", "780", ",", "1554", ",", 
   "2800", ",", "4680"}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->8692]
}, Open  ]],

Cell[TextData[{
 "It is however possible to get a symbolic formula for the sum, valid for any \
value of ",
 Cell[BoxData["i"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"i", "^", "k"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->28047],

Cell[BoxData[
 RowBox[{"i", "+", 
  SuperscriptBox["i", "2"], "+", 
  SuperscriptBox["i", "3"], "+", 
  SuperscriptBox["i", "4"]}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->10946]
}, Open  ]],

Cell[TextData[{
 "By inserting ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 ", you tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " first to evaluate the sum symbolically, then to iterate over ",
 Cell[BoxData["i"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"i", "^", "k"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->30231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "30", ",", "120", ",", "340", ",", "780", ",", "1554", ",", 
   "2800", ",", "4680"}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->24115]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox[
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TI"]], "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "keep ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " unevaluated until specific values are assigned to ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Evaluate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Evaluate"], "[", 
       StyleBox["f", "TI"], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox[
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TI"]], "TI"]}], "}"}]}], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " first with ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " left symbolic"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->839],

Cell["Evaluation in iteration functions.", "Caption",
 CellID->25858],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->54198888],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Evaluation in Iteration Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EvaluationInPatternsRulesAndDefinitions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Conditionals"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 13.9705458}", "context" -> "", 
    "keywords" -> {
     "efficiency", "Evaluate", "evaluation", "iteration functions", 
      "iterators", "plot", "Plot3D", "Sum", "Table"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The built-in Mathematica iteration functions such as Table and Sum \
evaluate their arguments in a slightly special way. When evaluating an \
expression like Table[f,{i,i_max}], the first step, as discussed in Blocks \
and Local Values, is to make the value of i local. Next, the limit i_max in \
the iterator specification is evaluated. The expression f is maintained in an \
unevaluated form, but is repeatedly evaluated as a succession of values are \
assigned to i. When this is finished, the global value of i is restored. The \
function RandomReal[] is evaluated four separate times here, so four \
different pseudorandom numbers are generated.", "synonyms" -> {"2.6.7"}, 
    "title" -> "Evaluation in Iteration Functions", "type" -> "Tutorial", 
    "uri" -> "tutorial/EvaluationInIterationFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.7"->{
  Cell[1907, 59, 96, 2, 70, "Title",
   CellTags->{"S2.6.7", "7.1"},
   CellID->16334]},
 "7.1"->{
  Cell[1907, 59, 96, 2, 70, "Title",
   CellTags->{"S2.6.7", "7.1"},
   CellID->16334]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.7", 17516, 620},
 {"7.1", 17615, 624}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1282, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1907, 59, 96, 2, 70, "Title",
 CellTags->{"S2.6.7", "7.1"},
 CellID->16334],
Cell[2006, 63, 441, 16, 70, "Text",
 CellID->21001],
Cell[2450, 81, 1253, 40, 70, "Text",
 CellID->2737],
Cell[3706, 123, 315, 10, 70, "MathCaption",
 CellID->9310],
Cell[CellGroupData[{
Cell[4046, 137, 177, 6, 28, "Input",
 CellID->5974],
Cell[4226, 145, 305, 9, 36, "Output",
 CellID->251781792]
}, Open  ]],
Cell[4546, 157, 413, 14, 70, "MathCaption",
 CellID->20356],
Cell[CellGroupData[{
Cell[4984, 175, 214, 7, 28, "Input",
 CellID->1071],
Cell[5201, 184, 304, 9, 36, "Output",
 CellID->325330899]
}, Open  ]],
Cell[5520, 196, 925, 31, 70, "Text",
 CellID->10935],
Cell[6448, 229, 314, 8, 70, "MathCaption",
 CellID->32145],
Cell[6765, 239, 229, 8, 70, "Input",
 CellID->17282],
Cell[6997, 249, 256, 8, 70, "MathCaption",
 CellID->1825],
Cell[CellGroupData[{
Cell[7278, 261, 201, 7, 70, "Input",
 CellID->18718],
Cell[7482, 270, 234, 7, 36, "Output",
 CellID->13573]
}, Open  ]],
Cell[7731, 280, 357, 13, 70, "MathCaption",
 CellID->4712],
Cell[CellGroupData[{
Cell[8113, 297, 238, 8, 70, "Input",
 CellID->13037],
Cell[8354, 307, 243, 8, 36, "Output",
 CellID->4998]
}, Open  ]],
Cell[8612, 318, 1394, 52, 70, "Text",
 CellID->9905],
Cell[10009, 372, 272, 10, 70, "MathCaption",
 CellID->7162],
Cell[CellGroupData[{
Cell[10306, 386, 304, 11, 70, "Input",
 CellID->1717],
Cell[10613, 399, 283, 9, 36, "Output",
 CellID->8692]
}, Open  ]],
Cell[10911, 411, 186, 6, 70, "MathCaption",
 CellID->19539],
Cell[CellGroupData[{
Cell[11122, 421, 192, 7, 70, "Input",
 CellID->28047],
Cell[11317, 430, 269, 9, 36, "Output",
 CellID->10946]
}, Open  ]],
Cell[11601, 442, 363, 13, 70, "MathCaption",
 CellID->19103],
Cell[CellGroupData[{
Cell[11989, 459, 346, 12, 70, "Input",
 CellID->30231],
Cell[12338, 473, 284, 9, 36, "Output",
 CellID->24115]
}, Open  ]],
Cell[12637, 485, 1658, 56, 70, "DefinitionBox",
 CellID->839],
Cell[14298, 543, 69, 1, 70, "Caption",
 CellID->25858],
Cell[CellGroupData[{
Cell[14392, 548, 71, 1, 70, "RelatedTutorialsSection",
 CellID->54198888],
Cell[14466, 551, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[14673, 559, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

