(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30705,       1108]
NotebookOptionsPosition[     22948,        858]
NotebookOutlinePosition[     26334,        943]
CellTagsIndexPosition[     26202,        936]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationOfExpressionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation of Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluate" :> Documentation`HelpLookup["paclet:ref/Evaluate"], 
          "HoldPattern" :> 
          Documentation`HelpLookup["paclet:ref/HoldPattern"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluate\"\>", 
       2->"\<\"HoldPattern\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Evaluation in Patterns, Rules and Definitions", "Title",
 CellTags->{"S2.6.6", "6.1"},
 CellID->2645],

Cell[TextData[{
 "There are a number of important interactions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " between evaluation and pattern matching. The first observation is that \
pattern matching is usually done on expressions that have already been at \
least partly evaluated. As a result, it is usually appropriate that the \
patterns to which these expressions are matched should themselves be \
evaluated. "
}], "Text",
 CellID->3394],

Cell["\<\
The fact that the pattern is evaluated means that it matches the expression \
given. \
\>", "MathCaption",
 CellID->17199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"k", "^", "2"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", "^", 
     RowBox[{"(", 
      RowBox[{"1", "+", "1"}], ")"}]}], "]"}], "->", 
   RowBox[{"p", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19645],

Cell[BoxData[
 RowBox[{"p", "[", "k", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1583187485]
}, Open  ]],

Cell[TextData[{
 "The right\[Hyphen]hand side of the ",
 Cell[BoxData["/;"], "InlineFormula"],
 " condition is not evaluated until it is used during pattern matching. "
}], "MathCaption",
 CellID->675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"list_", "/;", 
     RowBox[{
      RowBox[{"Length", "[", "list", "]"}], ">", "1"}]}], "]"}], "->", 
   RowBox[{"list", "^", "2"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["a", "2"], ",", 
   SuperscriptBox["b", "2"]}], "}"}]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->488026086]
}, Open  ]],

Cell[TextData[{
 "There are some cases, however, where you may want to keep all or part of a \
pattern unevaluated. You can do this by wrapping the parts you do not want to \
evaluate with ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 ". In general, whenever ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HoldPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldPattern"], "[", 
   StyleBox["patt", "TI"], "]"}]], "InlineFormula"],
 " appears within a pattern, this form is taken to be equivalent to ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 " for the purpose of pattern matching, but the expression ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 " is maintained unevaluated. "
}], "Text",
 CellID->13773],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["HoldPattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldPattern"], "[", 
     StyleBox["patt", "TI"], "]"}], Cell[TextData[{
     "equivalent to ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " for pattern matching, with ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     " kept unevaluated"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2480],

Cell["Preventing evaluation in patterns. ", "Caption",
 CellID->11238],

Cell[TextData[{
 "One application for ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " is in specifying patterns which can apply to unevaluated expressions, or \
expressions held in an unevaluated form. "
}], "Text",
 CellID->26897],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " keeps the ",
 Cell[BoxData[
  RowBox[{"1", "+", "1"}]], "InlineFormula"],
 " from being evaluated, and allows it to match the ",
 Cell[BoxData[
  RowBox[{"1", "+", "1"}]], "InlineFormula"],
 " on the left\[Hyphen]hand side of the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator. "
}], "MathCaption",
 CellID->3542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"u", "[", 
    RowBox[{"1", "+", "1"}], "]"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"1", "+", "1"}], "]"}], "->", "x"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29608],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"u", "[", "x", "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->616228303]
}, Open  ]],

Cell[TextData[{
 "Notice that while functions like ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " prevent evaluation of expressions, they do not affect the manipulation of \
parts of those expressions with ",
 Cell[BoxData["/."], "InlineFormula"],
 " and other operators. "
}], "Text",
 CellID->23277],

Cell[TextData[{
 "This defines values for ",
 Cell[BoxData["r"], "InlineFormula"],
 " whenever its argument is not an atomic object. "
}], "MathCaption",
 CellID->6125],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "/;", 
   RowBox[{"!", 
    RowBox[{"AtomQ", "[", "x", "]"}]}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20134],

Cell[TextData[{
 "According to the definition, expressions like ",
 Cell[BoxData[
  RowBox[{"r", "[", "3", "]"}]], "InlineFormula"],
 " are left unchanged. "
}], "MathCaption",
 CellID->1401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "[", "3", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->9078],

Cell[BoxData[
 RowBox[{"r", "[", "3", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->535390904]
}, Open  ]],

Cell[TextData[{
 "However, the pattern ",
 Cell[BoxData[
  RowBox[{"r", "[", "x_", "]"}]], "InlineFormula"],
 " is transformed according to the definition for ",
 Cell[BoxData["r"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "[", "x_", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->20736],

Cell[BoxData[
 SuperscriptBox["x_", "2"]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->2055898757]
}, Open  ]],

Cell[TextData[{
 "You need to wrap ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " around ",
 Cell[BoxData[
  RowBox[{"r", "[", "x_", "]"}]], "InlineFormula"],
 " to prevent it from being evaluated. "
}], "MathCaption",
 CellID->17939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"r", "[", "3", "]"}], ",", 
    RowBox[{"r", "[", "5", "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"r", "[", "x_", "]"}], "]"}], "->", "x"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->21138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "5"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1362870249]
}, Open  ]],

Cell[TextData[{
 "As illustrated above, the left\[Hyphen]hand sides of transformation rules \
such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " are usually evaluated immediately, since the rules are usually applied to \
expressions which have already been evaluated. The right\[Hyphen]hand side of \
",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "->", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " is also evaluated immediately. With the delayed rule ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":>", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ", however, the expression ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " is not evaluated. "
}], "Text",
 CellID->31426],

Cell[TextData[{
 "The right\[Hyphen]hand side is evaluated immediately in ",
 Cell[BoxData["->"], "InlineFormula"],
 " but not ",
 Cell[BoxData[":>"], "InlineFormula"],
 " rules. "
}], "MathCaption",
 CellID->10663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "->", 
     RowBox[{"1", "+", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ":>", 
     RowBox[{"1", "+", "1"}]}], "}"}]}], "}"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1677],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[RuleDelayed]", 
     RowBox[{"1", "+", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->907652550]
}, Open  ]],

Cell[TextData[{
 "Here are the results of applying the rules. The right\[Hyphen]hand side of \
the ",
 Cell[BoxData[":>"], "InlineFormula"],
 " rule gets inserted inside the ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " without evaluation. "
}], "MathCaption",
 CellID->6724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"Hold", "[", "x", "]"}]}], "}"}], "/.", "%"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->25981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"Hold", "[", "2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"Hold", "[", 
      RowBox[{"1", "+", "1"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->323231145]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "evaluate both ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":>", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " but not ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7961],

Cell["Evaluation in transformation rules. ", "Caption",
 CellID->28862],

Cell[TextData[{
 "While the left\[Hyphen]hand sides of transformation rules are usually \
evaluated, the left\[Hyphen]hand sides of definitions are usually not. The \
reason for the difference is as follows. Transformation rules are typically \
applied using ",
 Cell[BoxData["/."], "InlineFormula"],
 " to expressions that have already been evaluated. Definitions, however, are \
used during the evaluation of expressions, and are applied to expressions \
that have not yet been completely evaluated. To work on such expressions, the \
left\[Hyphen]hand sides of definitions must be maintained in a form that is \
at least partially unevaluated. "
}], "Text",
 CellID->16002],

Cell[TextData[{
 "Definitions for symbols are the simplest case. As discussed in \"",
 ButtonBox["Non\[Hyphen]Standard Evaluation\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NonStandardEvaluation"],
 ", a symbol on the left\[Hyphen]hand side of a definition such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " is not evaluated. If ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " had previously been assigned a value ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", then if the left\[Hyphen]hand side of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " were evaluated, it would turn into the quite unrelated definition ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18448],

Cell["\<\
Here is a definition. The symbol on the left\[Hyphen]hand side is not \
evaluated. \
\>", "MathCaption",
 CellID->25095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"w", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->684],

Cell[BoxData[
 RowBox[{"w", "[", "3", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1015956685]
}, Open  ]],

Cell["This redefines the symbol. ", "MathCaption",
 CellID->15137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "=", 
  RowBox[{"w", "[", "4", "]"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->9507],

Cell[BoxData[
 RowBox[{"w", "[", "4", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->1820050379]
}, Open  ]],

Cell[TextData[{
 "If you evaluate the left\[Hyphen]hand side, then you define not the symbol \
",
 Cell[BoxData["k"], "InlineFormula"],
 ", but the ",
 StyleBox["value",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{"w", "[", "4", "]"}]], "InlineFormula"],
 " of the symbol ",
 Cell[BoxData["k"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Evaluate", "[", "k", "]"}], "=", 
  RowBox[{"w", "[", "5", "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->2944],

Cell[BoxData[
 RowBox[{"w", "[", "5", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->541596848]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  RowBox[{"w", "[", "4", "]"}]], "InlineFormula"],
 " has value ",
 Cell[BoxData[
  RowBox[{"w", "[", "5", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"w", "[", "4", "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->7058],

Cell[BoxData[
 RowBox[{"w", "[", "5", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1323281265]
}, Open  ]],

Cell[TextData[{
 "Although individual symbols that appear on the left\[Hyphen]hand sides of \
definitions are not evaluated, more complicated expressions are partially \
evaluated. In an expression such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 " on the left\[Hyphen]hand side of a definition, the ",
 Cell[BoxData[
  StyleBox["args", "TI"]], "InlineFormula"],
 " are evaluated. "
}], "Text",
 CellID->17668],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"1", "+", "1"}]], "InlineFormula"],
 " is evaluated, so that a value is defined for ",
 Cell[BoxData[
  RowBox[{"g", "[", "2", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "=", "5"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->119],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->678618978]
}, Open  ]],

Cell[TextData[{
 "This shows the value defined for ",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "g"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->8891],

Cell[CellGroupData[{

Cell["Global`g", "Print", "PrintUsage",
 CellTags->"Info3371383925-8205668",
 CellID->703423921],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"g", "[", "2", "]"}], "=", "5"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["g"],
  Editable->False]], "Print",
 CellTags->"Info3371383925-8205668",
 CellID->431809769]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "You can see why the arguments of a function that appears on the left\
\[Hyphen]hand side of a definition must be evaluated by considering how the \
definition is used during the evaluation of an expression. As discussed in \
\"",
 ButtonBox["Principles of Evaluation\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PrinciplesOfEvaluation"],
 ", when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates a function, it first evaluates each of the arguments, then tries \
to find definitions for the function. As a result, by the time ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " applies any definition you have given for a function, the arguments of the \
function must already have been evaluated. An exception to this occurs when \
the function in question has attributes which specify that it should hold \
some of its arguments unevaluated. "
}], "Text",
 CellID->6915],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["symbol", "TI"], "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     StyleBox["symbol", "TI"],
     " is not evaluated; ",
     StyleBox["value", "TI"],
     " is evaluated"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["symbol", "TI"], ":=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     "neither ",
     Cell[BoxData[
      StyleBox["symbol", "TI"]], "InlineFormula"],
     " nor ",
     Cell[BoxData[
      StyleBox["value", "TI"]], "InlineFormula"],
     " is evaluated"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]", "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     StyleBox["args", "TI"],
     " are evaluated; left\[Hyphen]hand side as a whole is not"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     ButtonBox["HoldPattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HoldPattern"], "[", 
     StyleBox["arg", "TI"], "]", "]", "=", 
     StyleBox["value", "TI"]}], Cell[TextData[{
     StyleBox["f", "TI"],
     "[",
     StyleBox["arg", "TI"],
     "]",
     " is assigned, without evaluating ",
     StyleBox["arg", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Evaluate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Evaluate"], "[", 
     StyleBox["lhs", "TI"], "]", "=", 
     StyleBox["value", "TI"]}], Cell["\<\
left\[Hyphen]hand side is evaluated completely\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8072],

Cell["Evaluation in definitions. ", "Caption",
 CellID->17929],

Cell[TextData[{
 "While in most cases it is appropriate for the arguments of a function that \
appears on the left\[Hyphen]hand side of a definition to be evaluated, there \
are some situations in which you do not want this to happen. In such cases, \
you can wrap ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " around the parts that you do not want to be evaluated. "
}], "Text",
 CellID->841],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->841578724],

Cell[TextData[ButtonBox["Evaluation of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationOfExpressionsOverview"]], "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Evaluation in Patterns, Rules and Definitions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Evaluation of Expressions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/EvaluationOfExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NonStandardEvaluation"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/EvaluationInIterationFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 14.4236824}", "context" -> "", 
    "keywords" -> {
     ":=", "=", ":>", "->", "arguments", "assignments", "definitions", 
      "evaluation", "HoldPattern", "patterns", "RuleDelayed", "rules", 
      "unevaluated expressions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "There are a number of important interactions in Mathematica between \
evaluation and pattern matching. The first observation is that pattern \
matching is usually done on expressions that have already been at least \
partly evaluated. As a result, it is usually appropriate that the patterns to \
which these expressions are matched should themselves be evaluated. The fact \
that the pattern is evaluated means that it matches the expression given. The \
right-hand side of the /; condition is not evaluated until it is used during \
pattern matching. ", "synonyms" -> {"2.6.6"}, "title" -> 
    "Evaluation in Patterns, Rules and Definitions", "type" -> "Tutorial", 
    "uri" -> "tutorial/EvaluationInPatternsRulesAndDefinitions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.6.6"->{
  Cell[1936, 60, 107, 2, 70, "Title",
   CellTags->{"S2.6.6", "6.1"},
   CellID->2645]},
 "6.1"->{
  Cell[1936, 60, 107, 2, 70, "Title",
   CellTags->{"S2.6.6", "6.1"},
   CellID->2645]},
 "Info3371383925-8205668"->{
  Cell[18413, 710, 96, 2, 70, "Print",
   CellTags->"Info3371383925-8205668",
   CellID->703423921],
  Cell[18512, 714, 744, 22, 70, "Print",
   CellTags->"Info3371383925-8205668",
   CellID->431809769]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.6.6", 25757, 918},
 {"6.1", 25856, 922},
 {"Info3371383925-8205668", 25974, 926}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1311, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1936, 60, 107, 2, 70, "Title",
 CellTags->{"S2.6.6", "6.1"},
 CellID->2645],
Cell[2046, 64, 454, 10, 70, "Text",
 CellID->3394],
Cell[2503, 76, 132, 4, 70, "MathCaption",
 CellID->17199],
Cell[CellGroupData[{
Cell[2660, 84, 302, 11, 28, "Input",
 CellID->19645],
Cell[2965, 97, 186, 6, 36, "Output",
 CellID->1583187485]
}, Open  ]],
Cell[3166, 106, 201, 5, 70, "MathCaption",
 CellID->675],
Cell[CellGroupData[{
Cell[3392, 115, 342, 12, 28, "Input",
 CellID->21862],
Cell[3737, 129, 253, 9, 39, "Output",
 CellID->488026086]
}, Open  ]],
Cell[4005, 141, 836, 23, 70, "Text",
 CellID->13773],
Cell[4844, 166, 759, 23, 70, "DefinitionBox",
 CellID->2480],
Cell[5606, 191, 70, 1, 70, "Caption",
 CellID->11238],
Cell[5679, 194, 314, 9, 70, "Text",
 CellID->26897],
Cell[5996, 205, 464, 15, 70, "MathCaption",
 CellID->3542],
Cell[CellGroupData[{
Cell[6485, 224, 262, 9, 70, "Input",
 CellID->29608],
Cell[6750, 235, 216, 7, 36, "Output",
 CellID->616228303]
}, Open  ]],
Cell[6981, 245, 371, 11, 70, "Text",
 CellID->23277],
Cell[7355, 258, 168, 5, 70, "MathCaption",
 CellID->6125],
Cell[7526, 265, 219, 8, 70, "Input",
 CellID->20134],
Cell[7748, 275, 191, 6, 70, "MathCaption",
 CellID->1401],
Cell[CellGroupData[{
Cell[7964, 285, 92, 3, 70, "Input",
 CellID->9078],
Cell[8059, 290, 185, 6, 36, "Output",
 CellID->535390904]
}, Open  ]],
Cell[8259, 299, 240, 8, 70, "MathCaption",
 CellID->20169],
Cell[CellGroupData[{
Cell[8524, 311, 94, 3, 70, "Input",
 CellID->20736],
Cell[8621, 316, 183, 6, 36, "Output",
 CellID->2055898757]
}, Open  ]],
Cell[8819, 325, 318, 11, 70, "MathCaption",
 CellID->17939],
Cell[CellGroupData[{
Cell[9162, 340, 290, 10, 70, "Input",
 CellID->21138],
Cell[9455, 352, 204, 7, 36, "Output",
 CellID->1362870249]
}, Open  ]],
Cell[9674, 362, 784, 24, 70, "Text",
 CellID->31426],
Cell[10461, 388, 215, 7, 70, "MathCaption",
 CellID->10663],
Cell[CellGroupData[{
Cell[10701, 399, 262, 10, 70, "Input",
 CellID->1677],
Cell[10966, 411, 347, 12, 36, "Output",
 CellID->907652550]
}, Open  ]],
Cell[11328, 426, 346, 11, 70, "MathCaption",
 CellID->6724],
Cell[CellGroupData[{
Cell[11699, 441, 194, 7, 70, "Input",
 CellID->25981],
Cell[11896, 450, 397, 14, 36, "Output",
 CellID->323231145]
}, Open  ]],
Cell[12308, 467, 917, 31, 70, "DefinitionBox",
 CellID->7961],
Cell[13228, 500, 71, 1, 70, "Caption",
 CellID->28862],
Cell[13302, 503, 676, 12, 70, "Text",
 CellID->16002],
Cell[13981, 517, 930, 28, 70, "Text",
 CellID->18448],
Cell[14914, 547, 130, 4, 70, "MathCaption",
 CellID->25095],
Cell[CellGroupData[{
Cell[15069, 555, 115, 4, 70, "Input",
 CellID->684],
Cell[15187, 561, 187, 6, 36, "Output",
 CellID->1015956685]
}, Open  ]],
Cell[15389, 570, 66, 1, 70, "MathCaption",
 CellID->15137],
Cell[CellGroupData[{
Cell[15480, 575, 116, 4, 70, "Input",
 CellID->9507],
Cell[15599, 581, 187, 6, 36, "Output",
 CellID->1820050379]
}, Open  ]],
Cell[15801, 590, 364, 14, 70, "MathCaption",
 CellID->21284],
Cell[CellGroupData[{
Cell[16190, 608, 151, 5, 70, "Input",
 CellID->2944],
Cell[16344, 615, 186, 6, 36, "Output",
 CellID->541596848]
}, Open  ]],
Cell[16545, 624, 211, 9, 70, "MathCaption",
 CellID->821],
Cell[CellGroupData[{
Cell[16781, 637, 93, 3, 70, "Input",
 CellID->7058],
Cell[16877, 642, 187, 6, 36, "Output",
 CellID->1323281265]
}, Open  ]],
Cell[17079, 651, 482, 13, 70, "Text",
 CellID->17668],
Cell[17564, 666, 243, 9, 70, "MathCaption",
 CellID->10677],
Cell[CellGroupData[{
Cell[17832, 679, 139, 5, 70, "Input",
 CellID->119],
Cell[17974, 686, 159, 5, 36, "Output",
 CellID->678618978]
}, Open  ]],
Cell[18148, 694, 132, 5, 70, "MathCaption",
 CellID->23041],
Cell[CellGroupData[{
Cell[18305, 703, 83, 3, 70, "Input",
 CellID->8891],
Cell[CellGroupData[{
Cell[18413, 710, 96, 2, 70, "Print",
 CellTags->"Info3371383925-8205668",
 CellID->703423921],
Cell[18512, 714, 744, 22, 70, "Print",
 CellTags->"Info3371383925-8205668",
 CellID->431809769]
}, Open  ]]
}, Open  ]],
Cell[19283, 740, 920, 20, 70, "Text",
 CellID->6915],
Cell[20206, 762, 1862, 63, 70, "DefinitionBox",
 CellID->8072],
Cell[22071, 827, 62, 1, 70, "Caption",
 CellID->17929],
Cell[22136, 830, 478, 11, 70, "Text",
 CellID->841],
Cell[CellGroupData[{
Cell[22639, 845, 72, 1, 70, "RelatedTutorialsSection",
 CellID->841578724],
Cell[22714, 848, 180, 4, 70, "RelatedTutorials",
 CellID->14411223]
}, Open  ]]
}, Open  ]],
Cell[22921, 856, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

