(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19889,        723]
NotebookOptionsPosition[     14313,        550]
NotebookOutlinePosition[     17190,        620]
CellTagsIndexPosition[     17099,        614]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/ExpressionsOverview"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Expressions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FullForm" :> Documentation`HelpLookup["paclet:ref/FullForm"], 
          "Head" :> Documentation`HelpLookup["paclet:ref/Head"], "List" :> 
          Documentation`HelpLookup["paclet:ref/List"], "Plus" :> 
          Documentation`HelpLookup["paclet:ref/Plus"], "Power" :> 
          Documentation`HelpLookup["paclet:ref/Power"], "Rule" :> 
          Documentation`HelpLookup["paclet:ref/Rule"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "Times" :> 
          Documentation`HelpLookup["paclet:ref/Times"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FullForm\"\>", 2->"\<\"Head\"\>", 
       3->"\<\"List\"\>", 4->"\<\"Plus\"\>", 5->"\<\"Power\"\>", 
       6->"\<\"Rule\"\>", 7->"\<\"Set\"\>", 
       8->"\<\"Times\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Everything Is an Expression", "Title",
 CellTags->{"S2.1.1", "1.1"},
 CellID->4715],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " handles many different kinds of things: mathematical formulas, lists and \
graphics, to name a few. Although they often look very different, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represents all of these things in one uniform way. They are all ",
 StyleBox["expressions",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->17615],

Cell[TextData[{
 "A prototypical example of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression is ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}]], "InlineFormula"],
 ". You might use ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}]], "InlineFormula"],
 " to represent a mathematical function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", 
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". The function is named ",
 Cell[BoxData["f"], "InlineFormula"],
 ", and it has two arguments, ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "Text",
 CellID->12536],

Cell[TextData[{
 "You do not always have to write expressions in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ". For example, ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 " is also an expression. When you type in ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " converts it to the standard form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"], "[", 
   RowBox[{"x", ",", "y"}], "]"}]], "InlineFormula"],
 ". Then, when it prints it out again, it gives it as ",
 Cell[BoxData[
  RowBox[{"x", "+", "y"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14957],

Cell[TextData[{
 "The same is true of other \[OpenCurlyDoubleQuote]operators\
\[CloseCurlyDoubleQuote], such as ",
 Cell[BoxData["^"], "InlineFormula"],
 " (",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ") and ",
 Cell[BoxData["/"], "InlineFormula"],
 " (",
 Cell[BoxData[
  ButtonBox["Divide",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Divide"]], "InlineFormula"],
 "). "
}], "Text",
 CellID->27759],

Cell[TextData[{
 "In fact, everything you type into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is treated as an expression. "
}], "Text",
 CellID->700],

Cell[BoxData[GridBox[{
   {
    RowBox[{"x", "+", "y", "+", "z"}], 
    RowBox[{
     ButtonBox["Plus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plus"], "[", "x", ",", "y", ",", "z", "]"}]},
   {
    RowBox[{"x", "y", "z"}], 
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", "x", ",", "y", ",", "z", "]"}]},
   {
    RowBox[{"x", "^", "n"}], 
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", "x", ",", "n", "]"}]},
   {
    RowBox[{"{", "a", ",", "b", ",", "c", "}"}], 
    RowBox[{
     ButtonBox["List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/List"], "[", "a", ",", "b", ",", "c", "]"}]},
   {
    RowBox[{"a", "->", "b"}], 
    RowBox[{
     ButtonBox["Rule",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rule"], "[", "a", ",", "b", "]"}]},
   {
    RowBox[{"a", "=", "b"}], 
    RowBox[{
     ButtonBox["Set",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Set"], "[", "a", ",", "b", "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13452],

Cell[TextData[{
 "Some examples of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Caption",
 CellID->5093],

Cell[TextData[{
 "You can see the full form of any expression by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullForm"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->24241],

Cell["Here is an expression. ", "MathCaption",
 CellID->11829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", "y", "+", "z"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->12448],

Cell[BoxData[
 RowBox[{"x", "+", "y", "+", "z"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->5227]
}, Open  ]],

Cell["This is the full form of the expression. ", "MathCaption",
 CellID->11798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->16224],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm= ",
 CellID->10324]
}, Open  ]],

Cell["Here is another expression. ", "MathCaption",
 CellID->12274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"x", "^", "2"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"y", "+", "z"}], ")"}], "^", "2"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->18133],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"y", "+", "z"}], ")"}], "2"]}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->22885]
}, Open  ]],

Cell["Its full form has several nested pieces. ", "MathCaption",
 CellID->15038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->12170],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "2"}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"Plus", "[", 
        RowBox[{"y", ",", "z"}], "]"}], ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm= ",
 CellID->6862]
}, Open  ]],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " in an expression ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is known as the ",
 StyleBox["head",
  FontSlant->"Italic"],
 " of the expression. You can extract it using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Head",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Head"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ". Particularly when you write programs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you will often want to test the head of an expression to find out what \
kind of thing the expression is. "
}], "Text",
 CellID->32629],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " gives the \[OpenCurlyDoubleQuote]function name\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->5084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->11909],

Cell[BoxData["f"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->14878]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " gives the name of the \[OpenCurlyDoubleQuote]operator\
\[CloseCurlyDoubleQuote]. "
}], "MathCaption",
 CellID->6923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->27085],

Cell[BoxData["Plus"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->29400]
}, Open  ]],

Cell["Everything has a head. ", "MathCaption",
 CellID->23024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->14193],

Cell[BoxData["List"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->23105]
}, Open  ]],

Cell["Numbers also have heads. ", "MathCaption",
 CellID->9412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "23432", "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->15765],

Cell[BoxData["Integer"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->5767]
}, Open  ]],

Cell["\<\
You can distinguish different kinds of numbers by their heads. \
\>", "MathCaption",
 CellID->15407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "345.6", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->10677],

Cell[BoxData["Real"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->13784]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Head",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Head"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "give the head of an expression: the ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], "]"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FullForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "display an expression in the full form used by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->704],

Cell["Functions for manipulating expressions. ", "Caption",
 CellID->14790],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsOverview"]], "RelatedTutorials",
 CellID->323659647],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->482724422]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Everything Is an Expression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Expressions", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/ExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheMeaningOfExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 16.9393718}", "context" -> "", 
    "keywords" -> {
     "arguments", "expressions", "FullForm", "function name", "functions", 
      "Head", "heads", "input of operators", "internal form", "operators", 
      "symbolic expressions"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica handles many different kinds of things: mathematical \
formulas, lists and graphics, to name a few. Although they often look very \
different, Mathematica represents all of these things in one uniform way. \
They are all expressions. A prototypical example of a Mathematica expression \
is f[x,y]. You might use f[x,y] to represent a mathematical function f(x,y). \
The function is named f, and it has two arguments, x and y. You do not always \
have to write expressions in the form f[x,y,...]. For example, x+y is also an \
expression. When you type in x+y, Mathematica converts it to the standard \
form Plus[x,y]. Then, when it prints it out again, it gives it as x+y. ", 
    "synonyms" -> {"2.1.1"}, "title" -> "Everything Is an Expression", "type" -> 
    "Tutorial", "uri" -> "tutorial/EverythingIsAnExpression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.1.1"->{
  Cell[2382, 66, 89, 2, 70, "Title",
   CellTags->{"S2.1.1", "1.1"},
   CellID->4715]},
 "1.1"->{
  Cell[2382, 66, 89, 2, 70, "Title",
   CellTags->{"S2.1.1", "1.1"},
   CellID->4715]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.1.1", 16890, 603},
 {"1.1", 16988, 607}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1757, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2382, 66, 89, 2, 70, "Title",
 CellTags->{"S2.1.1", "1.1"},
 CellID->4715],
Cell[2474, 70, 413, 12, 70, "Text",
 CellID->17615],
Cell[2890, 84, 715, 26, 70, "Text",
 CellID->12536],
Cell[3608, 112, 870, 30, 70, "Text",
 CellID->14957],
Cell[4481, 144, 478, 18, 70, "Text",
 CellID->27759],
Cell[4962, 164, 163, 6, 70, "Text",
 CellID->700],
Cell[5128, 172, 1416, 46, 70, "DefinitionBox",
 CellID->13452],
Cell[6547, 220, 134, 6, 70, "Caption",
 CellID->5093],
Cell[6684, 228, 279, 10, 70, "Text",
 CellID->24241],
Cell[6966, 240, 62, 1, 70, "MathCaption",
 CellID->11829],
Cell[CellGroupData[{
Cell[7053, 245, 99, 3, 70, "Input",
 CellID->12448],
Cell[7155, 250, 186, 6, 36, "Output",
 CellID->5227]
}, Open  ]],
Cell[7356, 259, 80, 1, 70, "MathCaption",
 CellID->11798],
Cell[CellGroupData[{
Cell[7461, 264, 101, 3, 70, "Input",
 CellID->16224],
Cell[7565, 269, 353, 13, 50, "Output",
 CellID->10324]
}, Open  ]],
Cell[7933, 285, 67, 1, 70, "MathCaption",
 CellID->12274],
Cell[CellGroupData[{
Cell[8025, 290, 194, 7, 70, "Input",
 CellID->18133],
Cell[8222, 299, 284, 10, 36, "Output",
 CellID->22885]
}, Open  ]],
Cell[8521, 312, 80, 1, 70, "MathCaption",
 CellID->15038],
Cell[CellGroupData[{
Cell[8626, 317, 101, 3, 70, "Input",
 CellID->12170],
Cell[8730, 322, 542, 19, 50, "Output",
 CellID->6862]
}, Open  ]],
Cell[9287, 344, 819, 28, 70, "Text",
 CellID->32629],
Cell[10109, 374, 281, 9, 70, "MathCaption",
 CellID->5084],
Cell[CellGroupData[{
Cell[10415, 387, 149, 5, 70, "Input",
 CellID->11909],
Cell[10567, 394, 155, 5, 36, "Output",
 CellID->14878]
}, Open  ]],
Cell[10737, 402, 256, 9, 70, "MathCaption",
 CellID->6923],
Cell[CellGroupData[{
Cell[11018, 415, 130, 4, 70, "Input",
 CellID->27085],
Cell[11151, 421, 158, 5, 36, "Output",
 CellID->29400]
}, Open  ]],
Cell[11324, 429, 62, 1, 70, "MathCaption",
 CellID->23024],
Cell[CellGroupData[{
Cell[11411, 434, 154, 5, 70, "Input",
 CellID->14193],
Cell[11568, 441, 158, 5, 36, "Output",
 CellID->23105]
}, Open  ]],
Cell[11741, 449, 63, 1, 70, "MathCaption",
 CellID->9412],
Cell[CellGroupData[{
Cell[11829, 454, 101, 3, 70, "Input",
 CellID->15765],
Cell[11933, 459, 160, 5, 36, "Output",
 CellID->5767]
}, Open  ]],
Cell[12108, 467, 110, 3, 70, "MathCaption",
 CellID->15407],
Cell[CellGroupData[{
Cell[12243, 474, 101, 3, 70, "Input",
 CellID->10677],
Cell[12347, 479, 158, 5, 36, "Output",
 CellID->13784]
}, Open  ]],
Cell[12520, 487, 1101, 35, 70, "DefinitionBox",
 CellID->704],
Cell[13624, 524, 75, 1, 70, "Caption",
 CellID->14790],
Cell[13702, 527, 152, 3, 70, "RelatedTutorials",
 CellID->323659647],
Cell[13857, 532, 414, 13, 70, "TutorialRelatedLinks",
 CellID->482724422]
}, Open  ]],
Cell[14286, 548, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

