(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14528,        531]
NotebookOptionsPosition[      9143,        366]
NotebookOutlinePosition[     12168,        440]
CellTagsIndexPosition[     12077,        434]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalCalculationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"N" :> Documentation`HelpLookup["paclet:ref/N"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"N\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exact and Approximate Results", "Title",
 CellTags->{"S1.1.2", "2.1"},
 CellID->9834],

Cell[TextData[{
 "A standard electronic calculator does all your calculations to a particular \
accuracy, say ten decimal digits. With ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", however, you can often get ",
 StyleBox["exact",
  FontSlant->"Italic"],
 " results."
}], "Text",
 CellID->10891],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " gives an ",
 StyleBox["exact",
  FontSlant->"Italic"],
 " result for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", "100"], TraditionalForm]], "InlineMath"],
 ", even though it has 31 decimal digits. "
}], "MathCaption",
 CellID->621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "^", "100"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->18085],

Cell[BoxData["1267650600228229401496703205376"], "Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->27734]
}, Open  ]],

Cell[TextData[{
 "You can tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to give you an approximate numerical result, just as a calculator would, \
by ending your input with ",
 Cell[BoxData[
  RowBox[{"//", 
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"]}]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " stands for \[OpenCurlyDoubleQuote]numerical\[CloseCurlyDoubleQuote]. It \
must be a capital letter. \"",
 ButtonBox["Special Ways to Input Expressions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SpecialWaysToInputExpressions"],
 " will explain what the ",
 Cell[BoxData["//"], "InlineFormula"],
 " means. "
}], "Text",
 CellID->25190],

Cell["This gives an approximate numerical result. ", "MathCaption",
 CellID->20542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "^", "100"}], "//", "N"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->17998],

Cell[BoxData["1.2676506002282294`*^30"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->22086]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can give results in terms of rational numbers."
}], "MathCaption",
 CellID->32018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "3"}], "+", 
  RowBox[{"2", "/", "7"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->15621],

Cell[BoxData[
 FractionBox["13", "21"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->30424]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"//", 
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"]}]], "InlineFormula"],
 " always gives the approximate numerical result. "
}], "MathCaption",
 CellID->22597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "/", "3"}], "+", 
   RowBox[{"2", "/", "7"}]}], "//", "N"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21376],

Cell[BoxData["0.6190476190476191`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->24254]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "//", 
     ButtonBox["N",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/N"]}], Cell[TextData[{
     "give an approximate numerical value for ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->29669],

Cell["Getting numerical approximations. ", "Caption",
 CellID->18108],

Cell[TextData[{
 "When you type in an integer like ",
 Cell[BoxData["7"], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that it is exact. If you type in a number like ",
 Cell[BoxData["4.5"], "InlineFormula"],
 ", with an explicit decimal point, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that it is accurate only to a fixed number of decimal places. "
}], "Text",
 CellID->12927],

Cell["\<\
This is taken to be an exact rational number, and reduced to its lowest \
terms. \
\>", "MathCaption",
 CellID->12493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"452", "/", "62"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->26068],

Cell[BoxData[
 FractionBox["226", "31"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->6366]
}, Open  ]],

Cell[TextData[{
 "Whenever you give a number with an explicit decimal point, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " produces an approximate numerical result. "
}], "MathCaption",
 CellID->9102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"452.3", "/", "62"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->2438],

Cell[BoxData["7.29516129032258`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->12600]
}, Open  ]],

Cell[TextData[{
 "Here again, the presence of the decimal point makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " give you an approximate numerical result. "
}], "MathCaption",
 CellID->10819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"452.", "/", "62"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->14318],

Cell[BoxData["7.290322580645161`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->2290]
}, Open  ]],

Cell["\<\
When any number in an arithmetic expression is given with an explicit decimal \
point, you get an approximate numerical result for the whole expression. \
\>", "MathCaption",
 CellID->14984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "+", 
  RowBox[{"452", "/", "62"}]}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->16339],

Cell[BoxData["8.29032258064516`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->2556]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->7374792],

Cell[TextData[ButtonBox["Numerical Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalCalculationsOverview"]], "RelatedTutorials",
 CellID->21356267]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->376628284],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->159939056]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exact and Approximate Results - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Arithmetic"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/SomeMathematicalFunctions"]}],
       "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 17.6112640}", "context" -> "", 
    "keywords" -> {
     "@", "approximations", "decimal points", "exact computation", 
      "function application", "integers", "N", "numbers", 
      "numerical evaluation", "rational numbers", "real", "real numbers"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "A standard electronic calculator does all your calculations to a \
particular accuracy, say ten decimal digits. With Mathematica, however, you \
can often get exact results. Mathematica gives an exact result for 2^100, \
even though it has 31 decimal digits. You can tell Mathematica to give you an \
approximate numerical result, just as a calculator would, by ending your \
input with //N. The N stands for 'numerical'. It must be a capital letter. \
\"Special Ways to Input Expressions\" will explain what the // means. ", 
    "synonyms" -> {"1.1.2"}, "title" -> "Exact and Approximate Results", 
    "type" -> "Tutorial", "uri" -> "tutorial/ExactAndApproximateResults"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.1.2"->{
  Cell[1782, 57, 91, 2, 70, "Title",
   CellTags->{"S1.1.2", "2.1"},
   CellID->9834]},
 "2.1"->{
  Cell[1782, 57, 91, 2, 70, "Title",
   CellTags->{"S1.1.2", "2.1"},
   CellID->9834]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.1.2", 11868, 423},
 {"2.1", 11966, 427}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1157, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1782, 57, 91, 2, 70, "Title",
 CellTags->{"S1.1.2", "2.1"},
 CellID->9834],
Cell[1876, 61, 304, 10, 70, "Text",
 CellID->10891],
Cell[2183, 73, 307, 12, 70, "MathCaption",
 CellID->621],
Cell[CellGroupData[{
Cell[2515, 89, 91, 3, 28, "Input",
 CellID->18085],
Cell[2609, 94, 186, 5, 36, "Output",
 CellID->27734]
}, Open  ]],
Cell[2810, 102, 782, 25, 70, "Text",
 CellID->25190],
Cell[3595, 129, 83, 1, 70, "MathCaption",
 CellID->20542],
Cell[CellGroupData[{
Cell[3703, 134, 115, 4, 28, "Input",
 CellID->17998],
Cell[3821, 140, 177, 5, 36, "Output",
 CellID->22086]
}, Open  ]],
Cell[4013, 148, 150, 5, 70, "MathCaption",
 CellID->32018],
Cell[CellGroupData[{
Cell[4188, 157, 135, 5, 28, "Input",
 CellID->15621],
Cell[4326, 164, 177, 6, 51, "Output",
 CellID->30424]
}, Open  ]],
Cell[4518, 173, 229, 8, 70, "MathCaption",
 CellID->22597],
Cell[CellGroupData[{
Cell[4772, 185, 161, 6, 70, "Input",
 CellID->21376],
Cell[4936, 193, 173, 5, 36, "Output",
 CellID->24254]
}, Open  ]],
Cell[5124, 201, 631, 19, 70, "DefinitionBox",
 CellID->29669],
Cell[5758, 222, 69, 1, 70, "Caption",
 CellID->18108],
Cell[5830, 225, 439, 13, 70, "Text",
 CellID->12927],
Cell[6272, 240, 128, 4, 70, "MathCaption",
 CellID->12493],
Cell[CellGroupData[{
Cell[6425, 248, 92, 3, 70, "Input",
 CellID->26068],
Cell[6520, 253, 177, 6, 51, "Output",
 CellID->6366]
}, Open  ]],
Cell[6712, 262, 209, 6, 70, "MathCaption",
 CellID->9102],
Cell[CellGroupData[{
Cell[6946, 272, 93, 3, 70, "Input",
 CellID->2438],
Cell[7042, 277, 171, 5, 36, "Output",
 CellID->12600]
}, Open  ]],
Cell[7228, 285, 203, 6, 70, "MathCaption",
 CellID->10819],
Cell[CellGroupData[{
Cell[7456, 295, 93, 3, 70, "Input",
 CellID->14318],
Cell[7552, 300, 171, 5, 36, "Output",
 CellID->2290]
}, Open  ]],
Cell[7738, 308, 200, 4, 70, "MathCaption",
 CellID->14984],
Cell[CellGroupData[{
Cell[7963, 316, 116, 4, 70, "Input",
 CellID->16339],
Cell[8082, 322, 170, 5, 36, "Output",
 CellID->2556]
}, Open  ]],
Cell[CellGroupData[{
Cell[8289, 332, 70, 1, 70, "RelatedTutorialsSection",
 CellID->7374792],
Cell[8362, 335, 175, 4, 70, "RelatedTutorials",
 CellID->21356267]
}, Open  ]],
Cell[CellGroupData[{
Cell[8574, 344, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->376628284],
Cell[8675, 347, 414, 13, 70, "TutorialRelatedLinks",
 CellID->159939056]
}, Open  ]]
}, Open  ]],
Cell[9116, 364, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

