(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21159,        694]
NotebookOptionsPosition[     16150,        542]
NotebookOutlinePosition[     18958,        613]
CellTagsIndexPosition[     18866,        607]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"], 
          "Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Files and External Operations\"\>", 
       2->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "ImportString" :> 
          Documentation`HelpLookup["paclet:ref/ImportString"], "MathMLForm" :> 
          Documentation`HelpLookup["paclet:ref/MathMLForm"], "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Export\"\>", 2->"\<\"Import\"\>", 
       3->"\<\"ImportString\"\>", 4->"\<\"MathMLForm\"\>", 
       5->"\<\"StandardForm\"\>", 
       6->"\<\"ToExpression\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Exchanging Material with the Web", "Title",
 CellTags->{"S1.11.7", "7.1"},
 CellID->25808],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", 
     StyleBox[
      RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).html\>\"", ",", 
       StyleBox["nb", "TI"]}],
      ShowStringCharacters->True], "]"}], Cell[TextData[{
     "save the notebook ",
     Cell[BoxData[
      StyleBox["nb", "TI"]], "InlineFormula"],
     " in HTML form"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->4632],

Cell["Converting notebooks to HTML. ", "Caption",
 CellID->21478],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " has many options applying to HTML export that allow you to specify how \
notebooks should be converted for web browsers with different capabilities."
}], "Text",
 CellID->26814],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MathMLForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathMLForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "print ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in MathML form"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MathMLForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathMLForm"], "[", 
     ButtonBox["StandardForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StandardForm"], "[", 
     StyleBox["expr", "TI"], "]", "]"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      ButtonBox["StandardForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
     " rather than traditional mathematical notation"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToExpression"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
     ButtonBox["MathMLForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MathMLForm"], "]"}], Cell[TextData[{
     "interpret a string of MathML as ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->13787],

Cell["Converting to and from MathML. ", "Caption",
 CellID->7239],

Cell["Here is an expression printed in MathML form. ", "MathCaption",
 CellID->28074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "/", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->25020],

Cell["\<\
<math>
<mfrac>
  <msup>
    <mi>x</mi>
    <mn>2</mn>
  </msup>
  <mi>z</mi>
</mfrac>
</math>\
\>", "Output",
 ImageSize->{98, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->10827]
}, Open  ]],

Cell[TextData[{
 "If you paste MathML into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically try to convert it to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. You can copy an expression from a notebook as MathML using the ",
 StyleBox["Copy As", "SR"],
 " menu in the notebook front end."
}], "Text",
 CellID->2554],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "export in XML format", "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", "]"}], Cell[
    "import from XML", "TableText"]},
   {
    RowBox[{
     ButtonBox["ImportString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImportString"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<XML\>\"", "]"}], Cell[
    "import data from a string of XML", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1988],

Cell["XML importing and exporting. ", "Caption",
 CellID->7441],

Cell[TextData[{
 "Somewhat like ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, XML is a general format for representing data. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically converts certain types of expressions to and from specific \
types of XML. MathML is one example. Another example is SVG for graphics."
}], "Text",
 CellID->16798],

Cell[TextData[{
 "If you ask ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to import a generic piece of XML, it will produce a ",
 StyleBox["SymbolicXML",
  FontSlant->"Italic"],
 " expression. Each XML element of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"<", 
    RowBox[{
     StyleBox["elem", "TI"], " ", 
     StyleBox["attr", "TI"]}]}], "=", 
   RowBox[{
    RowBox[{"'", 
     RowBox[{
      StyleBox["val", "TI"], "'"}]}], ">", 
    StyleBox["data", "TI"], "<", 
    RowBox[{"/", 
     StyleBox["elem", "TI"]}], ">"}]}]], "InlineFormula"],
 " is translated to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " SymbolicXML expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLElement"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"elem\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"attr\", \"TI\"]\)\>\"", "->", "\"\<\!\(\*
StyleBox[\"val\", \"TI\"]\)\>\""}], "}"}], ",", 
    RowBox[{"{", 
     StyleBox["data", "TI"], "}"}]}], "]"}]], "InlineFormula"],
 ". Once you have imported a piece of XML as SymbolicXML, you can use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s powerful symbolic programming capabilities to \
manipulate the expression you get. You can then use ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " to export the result in XML form."
}], "Text",
 CellID->13642],

Cell[TextData[{
 "This generates a SymbolicXML expression, with an ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " representing the ",
 Cell[BoxData["a"], "InlineFormula"],
 " element in the XML string. "
}], "MathCaption",
 CellID->19002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<<a aa='va'>s</a>\>\"", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->16321],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"a\"\>", ",", 
     RowBox[{"{", 
      RowBox[{"\<\"aa\"\>", "\[Rule]", "\<\"va\"\>"}], "}"}], ",", 
     RowBox[{"{", "\<\"s\"\>", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->30104]
}, Open  ]],

Cell["There are now two nested levels in the SymbolicXML. ", "MathCaption",
 CellID->13946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<<a><b bb='1'>ss</b><b bb='2'>ss</b></a>\>\"", ",", "\"\<XML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->7056],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"a\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"b\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"bb\"\>", "\[Rule]", "\<\"1\"\>"}], "}"}], ",", 
         RowBox[{"{", "\<\"ss\"\>", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"b\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"bb\"\>", "\[Rule]", "\<\"2\"\>"}], "}"}], ",", 
         RowBox[{"{", "\<\"ss\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{581, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->18509]
}, Open  ]],

Cell["This does a simple transformation on the SymbolicXML. ", "MathCaption",
 CellID->29833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"\"\<ss\>\"", "->", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<c\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "\"\<xx\>\"", "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->17708],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"a\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"b\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"bb\"\>", "\[Rule]", "\<\"1\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"c\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"xx\"\>", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"b\"\>", ",", 
         RowBox[{"{", 
          RowBox[{"\<\"bb\"\>", "\[Rule]", "\<\"2\"\>"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"c\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"xx\"\>", "}"}]}], "]"}], "}"}]}], "]"}]}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{480, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->19761]
}, Open  ]],

Cell["This shows the result as an XML string. ", "MathCaption",
 CellID->6533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"%", ",", "\"\<XML\>\""}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->20686],

Cell[BoxData["\<\"<a>\\n <b bb='1'>\\n  <c>xx</c>\\n </b>\\n <b bb='2'>\\n  \
<c>xx</c>\\n </b>\\n</a>\"\>"], "Output",
 ImageSize->{81, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->14804]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", 
     RowBox[{"\"\<http://\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "import a file from any accessible URL", "TableText"]},
   {
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", 
     RowBox[{"\"\<ftp://\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "import a file from an FTP server", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->26385],

Cell["Importing data from web sources.", "Caption",
 CellID->10142],

Cell["This imports a picture from a website.", "MathCaption",
 CellID->145586917],

Cell[BoxData[
 RowBox[{"Import", "[", 
  "\"\<http://reference.wolfram.com/mathematica/ExampleData/ocelot.jpg\>\"", 
  "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->72786628],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->222944362],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "RelatedTutorials",
 CellID->417450494]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exchanging Material with the Web - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/GeneratingAndImportingTeX"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/GeneratingCAndFortranExpressions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 20.2675820}", "context" -> "", 
    "keywords" -> {
     "copying", "ExpressionML", "ftp", "HTML output", "HTMLSave", "http", 
      "markup", "MathMLForm", "NotebookML", "notebooks", "OpenMath", 
      "SymbolicXML", "URLs", "web", "web import", "world wide web", "www", 
      "XML"}, "index" -> True, "label" -> "Mathematica Tutorial", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Converting notebooks to HTML. Export has many options applying to HTML \
export that allow you to specify how notebooks should be converted for web \
browsers with different capabilities. Converting to and from MathML. ", 
    "synonyms" -> {"1.11.7"}, "title" -> "Exchanging Material with the Web", 
    "type" -> "Tutorial", "uri" -> "tutorial/ExchangingMaterialWithTheWeb"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.7"->{
  Cell[2561, 70, 96, 2, 70, "Title",
   CellTags->{"S1.11.7", "7.1"},
   CellID->25808]},
 "7.1"->{
  Cell[2561, 70, 96, 2, 70, "Title",
   CellTags->{"S1.11.7", "7.1"},
   CellID->25808]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.7", 18653, 596},
 {"7.1", 18753, 600}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1936, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2561, 70, 96, 2, 70, "Title",
 CellTags->{"S1.11.7", "7.1"},
 CellID->25808],
Cell[2660, 74, 942, 28, 70, "DefinitionBox",
 CellID->4632],
Cell[3605, 104, 65, 1, 70, "Caption",
 CellID->21478],
Cell[3673, 107, 311, 8, 70, "Text",
 CellID->26814],
Cell[3987, 117, 1793, 55, 70, "DefinitionBox",
 CellID->13787],
Cell[5783, 174, 65, 1, 70, "Caption",
 CellID->7239],
Cell[5851, 177, 85, 1, 70, "MathCaption",
 CellID->28074],
Cell[CellGroupData[{
Cell[5961, 182, 150, 5, 28, "Input",
 CellID->25020],
Cell[6114, 189, 258, 15, 178, "Output",
 CellID->10827]
}, Open  ]],
Cell[6387, 207, 423, 14, 70, "Text",
 CellID->2554],
Cell[6813, 223, 1087, 31, 70, "DefinitionBox",
 CellID->1988],
Cell[7903, 256, 63, 1, 70, "Caption",
 CellID->7441],
Cell[7969, 259, 379, 10, 70, "Text",
 CellID->16798],
Cell[8351, 271, 1521, 49, 70, "Text",
 CellID->13642],
Cell[9875, 322, 320, 10, 70, "MathCaption",
 CellID->19002],
Cell[CellGroupData[{
Cell[10220, 336, 161, 4, 70, "Input",
 CellID->16321],
Cell[10384, 342, 497, 15, 36, "Output",
 CellID->30104]
}, Open  ]],
Cell[10896, 360, 91, 1, 70, "MathCaption",
 CellID->13946],
Cell[CellGroupData[{
Cell[11012, 365, 189, 6, 70, "Input",
 CellID->7056],
Cell[11204, 373, 884, 25, 54, "Output",
 CellID->18509]
}, Open  ]],
Cell[12103, 401, 93, 1, 70, "MathCaption",
 CellID->29833],
Cell[CellGroupData[{
Cell[12221, 406, 260, 8, 70, "Input",
 CellID->17708],
Cell[12484, 416, 1203, 34, 71, "Output",
 CellID->19761]
}, Open  ]],
Cell[13702, 453, 78, 1, 70, "MathCaption",
 CellID->6533],
Cell[CellGroupData[{
Cell[13805, 458, 138, 4, 70, "Input",
 CellID->20686],
Cell[13946, 464, 247, 6, 156, "Output",
 CellID->14804]
}, Open  ]],
Cell[14208, 473, 957, 28, 70, "DefinitionBox",
 CellID->26385],
Cell[15168, 503, 67, 1, 70, "Caption",
 CellID->10142],
Cell[15238, 506, 81, 1, 70, "MathCaption",
 CellID->145586917],
Cell[15322, 509, 178, 5, 70, "Input",
 CellID->72786628],
Cell[CellGroupData[{
Cell[15525, 518, 72, 1, 70, "RelatedTutorialsSection",
 CellID->222944362],
Cell[15600, 521, 187, 4, 70, "RelatedTutorials",
 CellID->16088632],
Cell[15790, 527, 306, 9, 70, "RelatedTutorials",
 CellID->417450494]
}, Open  ]]
}, Open  ]],
Cell[16123, 540, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

