(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10258,        297]
NotebookOptionsPosition[      6374,        199]
NotebookOutlinePosition[      9639,        274]
CellTagsIndexPosition[      9547,        268]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Input and Output in Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/InputAndOutputInNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Input and Output in Notebooks\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Exposition in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Notebooks"
}], "Title",
 CellTags->{"S1.10.15", "15.1"},
 CellID->29744],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks provide the basic technology that you need to be able to create \
a very wide range of sophisticated interactive documents. But to get the best \
out of this technology you need to develop an appropriate style of \
exposition."
}], "Text",
 CellID->8388],

Cell[TextData[{
 "Many people at first tend to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks either as simple worksheets containing a sequence of input and \
output lines, or as on\[Hyphen]screen versions of traditional books and other \
printed material. But the most effective and productive uses of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebooks tend to lie at neither one of these extremes, and instead \
typically involve a fine\[Hyphen]grained mixing of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input and output with explanatory text. In most cases the single most \
important factor in obtaining such fine\[Hyphen]grained mixing is uniform use \
of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. "
}], "Text",
 CellID->26610],

Cell[TextData[{
 "One might think that there would tend to be four kinds of material in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook: plain text, mathematical formulas, computer code, and \
interactive interfaces. But one of the key ideas of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is to provide a single language that offers the best of both traditional \
mathematical formulas and computer code. "
}], "Text",
 CellID->18718],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions have the same kind of compactness and elegance as traditional \
mathematical formulas. But unlike such formulas, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions are set up in a completely consistent and uniform way. As a \
result, if you use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, then regardless of your subject matter, you never have to go \
back and reexplain your basic notation: it is always just the notation of the \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language. In addition, if you set up your explanations in terms of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions, then a reader of your notebook can immediately take what you \
have given, and actually execute it as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Text",
 CellID->26919],

Cell[TextData[{
 "If one has spent many years working with traditional mathematical notation, \
then it takes a little time to get used to seeing mathematical facts \
presented as ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. Indeed, at first one often has a tendency to try to use ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " whenever possible, perhaps with hidden tags to indicate its \
interpretation. But quite soon one tends to evolve to a mixture of ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". And in the end it becomes clear that ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " alone is for most purposes the most effective form of presentation. "
}], "Text",
 CellID->18259],

Cell[TextData[{
 "In traditional mathematical exposition, there are many tricks for replacing \
chunks of text by fragments of formulas. In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " many of these same tricks can be used. But the fact that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions can represent not only mathematical objects but also \
procedures, algorithms, graphics, and interfaces increases greatly the extent \
to which chunks of text can be replaced by shorter and more precise material. \
"
}], "Text",
 CellID->5927],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->261372592],

Cell[TextData[ButtonBox["Input and Output in Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Exposition in Mathematica Notebooks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Input and Output in Notebooks", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/InputAndOutputInNotebooksOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/AutomaticNumbering"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 21.6894934}", "context" -> "", 
    "keywords" -> {"exposition", "notation"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica notebooks provide the basic technology that you need to be \
able to create a very wide range of sophisticated interactive documents. But \
to get the best out of this technology you need to develop an appropriate \
style of exposition. Many people at first tend to use Mathematica notebooks \
either as simple worksheets containing a sequence of input and output lines, \
or as on-screen versions of traditional books and other printed material. But \
the most effective and productive uses of Mathematica notebooks tend to lie \
at neither one of these extremes, and instead typically involve a \
fine-grained mixing of Mathematica input and output with explanatory text. In \
most cases the single most important factor in obtaining such fine-grained \
mixing is uniform use of the Mathematica language. One might think that there \
would tend to be four kinds of material in a Mathematica notebook: plain \
text, mathematical formulas, computer code, and interactive interfaces. But \
one of the key ideas of Mathematica is to provide a single language that \
offers the best of both traditional mathematical formulas and computer code. \
", "synonyms" -> {"1.10.15"}, "title" -> 
    "Exposition in Mathematica Notebooks", "type" -> "Tutorial", "uri" -> 
    "tutorial/ExpositionInMathematicaNotebooks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.10.15"->{
  Cell[1286, 44, 159, 7, 70, "Title",
   CellTags->{"S1.10.15", "15.1"},
   CellID->29744]},
 "15.1"->{
  Cell[1286, 44, 159, 7, 70, "Title",
   CellTags->{"S1.10.15", "15.1"},
   CellID->29744]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.10.15", 9327, 257},
 {"15.1", 9431, 261}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 661, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1286, 44, 159, 7, 70, "Title",
 CellTags->{"S1.10.15", "15.1"},
 CellID->29744],
Cell[1448, 53, 332, 8, 70, "Text",
 CellID->8388],
Cell[1783, 63, 809, 20, 70, "Text",
 CellID->26610],
Cell[2595, 85, 463, 11, 70, "Text",
 CellID->18718],
Cell[3061, 98, 1077, 31, 70, "Text",
 CellID->26919],
Cell[4141, 131, 1249, 34, 70, "Text",
 CellID->18259],
Cell[5393, 167, 640, 15, 70, "Text",
 CellID->5927],
Cell[CellGroupData[{
Cell[6058, 186, 72, 1, 70, "RelatedTutorialsSection",
 CellID->261372592],
Cell[6133, 189, 187, 4, 70, "RelatedTutorials",
 CellID->133182837]
}, Open  ]]
}, Open  ]],
Cell[6347, 197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

