(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35779,       1077]
NotebookOptionsPosition[     31565,        951]
NotebookOutlinePosition[     34327,       1022]
CellTagsIndexPosition[     34234,       1016]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Expressions" :> 
         Documentation`HelpLookup["paclet:tutorial/ExpressionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Expressions\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Expressions as Trees", "Title",
 CellTags->{"S2.1.6", "6.1"},
 CellID->14609],

Cell["Here is an expression in full form. ", "MathCaption",
 CellID->28119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->21479],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "3"}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"Plus", "[", 
        RowBox[{"1", ",", "x"}], "]"}], ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]//FullForm=",
 CellID->1034635553]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 " prints out expressions to show their \[OpenCurlyDoubleQuote]tree\
\[CloseCurlyDoubleQuote] structure."
}], "MathCaption",
 CellID->6300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->21396],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.2510864843424487`, 2.5021729686848975`}, {
    0.41702882811414954`, 1.6681153124565984`}, {0., 0.8340576562282993}, {
    0.8340576562282991, 0.8340576562282993}, {2.0851441405707476`, 
    1.6681153124565984`}, {1.6681153124565982`, 0.8340576562282993}, {
    1.2510864843424487`, 0.}, {2.0851441405707476`, 0.}, {2.5021729686848975`,
     0.8340576562282993}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 4}, {5, 6}, {5, 9}, {6, 7}, {6, 
       8}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["x", "3"], "+", 
           SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", "+", "x"}], ")"}], "2"]}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^3 + (1 + $CellContext`x)^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["x", "3"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["3",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SuperscriptBox[
          RowBox[{"(", 
            RowBox[{"1", "+", "x"}], ")"}], "2"], HoldForm]],
       Annotation[#, 
        HoldForm[(1 + $CellContext`x)^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         RowBox[{"1", "+", "x"}], HoldForm]],
       Annotation[#, 
        HoldForm[1 + $CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2510864843424487`, 2.5021729686848975`}, {
     0.41702882811414954`, 1.6681153124565984`}, {0., 0.8340576562282993}, {
     0.8340576562282991, 0.8340576562282993}, {2.0851441405707476`, 
     1.6681153124565984`}, {1.6681153124565982`, 0.8340576562282993}, {
     1.2510864843424487`, 0.}, {2.0851441405707476`, 0.}, {
     2.5021729686848975`, 0.8340576562282993}}]& ],
  AspectRatio->NCache[2 5^Rational[-1, 2], 0.8944271909999159],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]//TreeForm=",
 CellID->277611857]
}, Open  ]],

Cell[TextData[{
 "You can think of any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression as a tree. In the expression above, the top node in the tree \
consists of a ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ". From this node come two \[OpenCurlyDoubleQuote]branches\
\[CloseCurlyDoubleQuote], ",
 Cell[BoxData[
  RowBox[{"x", "^", "3"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "2"}]], "InlineFormula"],
 ". From the ",
 Cell[BoxData[
  RowBox[{"x", "^", "3"}]], "InlineFormula"],
 " node, there are then two branches, ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["3"], "InlineFormula"],
 ", which can be viewed as \[OpenCurlyDoubleQuote]leaves\
\[CloseCurlyDoubleQuote] of the tree. "
}], "Text",
 CellID->11458],

Cell["This matrix is a simple tree with just two levels. ", "MathCaption",
 CellID->20830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->24593],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.2247448713915892`, 1.6329931618554523`}, {
    0.4082482904638631, 0.8164965809277261}, {0., 0.}, {0.8164965809277261, 
    0.}, {2.041241452319315, 0.8164965809277261}, {1.6329931618554523`, 0.}, {
    2.4494897427831783`, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 4}, {5, 6}, {5, 7}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"a", ",", "b"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"c", ",", "d"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`a, $CellContext`b}, {$CellContext`c, \
$CellContext`d}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`a, $CellContext`b}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["a",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["a", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`a], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["b",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["b", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`b], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         RowBox[{"{", 
           RowBox[{"c", ",", "d"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`c, $CellContext`d}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["c",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["c", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`c], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["d",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["d", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`d], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2247448713915892`, 1.6329931618554523`}, {
     0.4082482904638631, 0.8164965809277261}, {0., 0.}, {0.8164965809277261, 
     0.}, {2.041241452319315, 0.8164965809277261}, {1.6329931618554523`, 
     0.}, {2.4494897427831783`, 0.}}]& ],
  AspectRatio->NCache[Rational[1, 2] 3^Rational[1, 2], 0.8660254037844386],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]//TreeForm=",
 CellID->353951077]
}, Open  ]],

Cell["Here is a more complicated expression. ", "MathCaption",
 CellID->29849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "b"}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"d", "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "3"}], " ", 
     RowBox[{"y", "^", "4"}]}], "}"}]}], "}"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->14854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "b"}], ",", 
     RowBox[{"c", " ", 
      SuperscriptBox["d", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "3"], " ", 
     SuperscriptBox["y", "4"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->174160877]
}, Open  ]],

Cell["\<\
The tree for this expression has several levels. The representation of the \
tree here was too long to fit on a single line, so it had to be broken onto \
two lines. \
\>", "MathCaption",
 CellID->26160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->12294],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.6663955872130627`, 2.8441552930272667`}, {
    1.066558234885225, 2.13311646977045}, {0.35551941162840833`, 
    1.4220776465136333`}, {0., 0.7110388232568168}, {0.7110388232568167, 
    0.7110388232568168}, {1.7775970581420417`, 1.4220776465136333`}, {
    1.4220776465136333`, 0.7110388232568168}, {2.13311646977045, 
    0.7110388232568168}, {1.7775970581420417`, 0.}, {2.4886358813988583`, 
    0.}, {4.2662329395409, 2.13311646977045}, {4.2662329395409, 
    1.4220776465136333`}, {3.5551941162840834`, 0.7110388232568168}, {
    3.199674704655675, 0.}, {3.910713527912492, 0.}, {4.9772717627977165`, 
    0.7110388232568168}, {4.621752351169309, 0.}, {5.332791174426125, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 11}, {2, 3}, {2, 6}, {3, 4}, {3, 5}, {6, 7}, {6, 
       8}, {8, 9}, {8, 10}, {11, 12}, {12, 13}, {12, 16}, {13, 14}, {13, 
       15}, {16, 17}, {16, 18}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"a", " ", "b"}], ",", 
                 RowBox[{"c", " ", 
                   SuperscriptBox["d", "2"]}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 SuperscriptBox["x", "3"], " ", 
                 SuperscriptBox["y", "4"]}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`a $CellContext`b, $CellContext`c \
$CellContext`d^2}, {$CellContext`x^3 $CellContext`y^4}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"a", " ", "b"}], ",", 
             RowBox[{"c", " ", 
               SuperscriptBox["d", "2"]}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`a $CellContext`b, $CellContext`c \
$CellContext`d^2}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"a", " ", "b"}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`a $CellContext`b], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["a",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["a", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`a], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["b",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["b", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`b], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         RowBox[{"c", " ", 
           SuperscriptBox["d", "2"]}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`c $CellContext`d^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["c",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["c", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`c], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         SuperscriptBox["d", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`d^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["d",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["d", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`d], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             SuperscriptBox["x", "3"], " ", 
             SuperscriptBox["y", "4"]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x^3 $CellContext`y^4}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox[
         RowBox[{
           SuperscriptBox["x", "3"], " ", 
           SuperscriptBox["y", "4"]}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^3 $CellContext`y^4], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox[
         SuperscriptBox["x", "3"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 14],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["3",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 15],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 16],
        TagBox[
         SuperscriptBox["y", "4"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`y^4], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["y",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 17],
        TagBox["y", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`y], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["4",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 18],
        TagBox["4", HoldForm]],
       Annotation[#, 
        HoldForm[4], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.6663955872130627`, 2.8441552930272667`}, {
     1.066558234885225, 2.13311646977045}, {0.35551941162840833`, 
     1.4220776465136333`}, {0., 0.7110388232568168}, {0.7110388232568167, 
     0.7110388232568168}, {1.7775970581420417`, 1.4220776465136333`}, {
     1.4220776465136333`, 0.7110388232568168}, {2.13311646977045, 
     0.7110388232568168}, {1.7775970581420417`, 0.}, {2.4886358813988583`, 
     0.}, {4.2662329395409, 2.13311646977045}, {4.2662329395409, 
     1.4220776465136333`}, {3.5551941162840834`, 0.7110388232568168}, {
     3.199674704655675, 0.}, {3.910713527912492, 0.}, {4.9772717627977165`, 
     0.7110388232568168}, {4.621752351169309, 0.}, {5.332791174426125, 
     0.}}]& ],
  AspectRatio->NCache[Rational[1, 3] 5^Rational[1, 2], 0.7453559924999299],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]//TreeForm=",
 CellID->152981589]
}, Open  ]],

Cell["\<\
The indices that label each part of an expression have a simple \
interpretation in terms of trees. Descending from the top node of the tree, \
each index specifies which branch to take in order to reach the part you \
want. \
\>", "Text",
 CellID->26333],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->444198793],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsOverview"]], "RelatedTutorials",
 CellID->323659647]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Expressions as Trees - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Expressions", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/ExpressionsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingExpressionsLikeLists"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/LevelsInExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 22.0488776}", "context" -> "", 
    "keywords" -> {
     "branches", "expressions", "leaf", "leaves", "nodes", "parse trees", 
      "TreeForm", "trees"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Here is an expression in full form. TreeForm prints out expressions to \
show their 'tree' structure. You can think of any Mathematica expression as a \
tree. In the expression above, the top node in the tree consists of a Plus. \
From this node come two 'branches', x^3 and (1+x)^2. From the x^3 node, there \
are then two branches, x and 3, which can be viewed as 'leaves' of the tree. \
", "synonyms" -> {"2.1.6"}, "title" -> "Expressions as Trees", "type" -> 
    "Tutorial", "uri" -> "tutorial/ExpressionsAsTrees"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.1.6"->{
  Cell[1224, 42, 83, 2, 70, "Title",
   CellTags->{"S2.1.6", "6.1"},
   CellID->14609]},
 "6.1"->{
  Cell[1224, 42, 83, 2, 70, "Title",
   CellTags->{"S2.1.6", "6.1"},
   CellID->14609]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.1.6", 34023, 1005},
 {"6.1", 34122, 1009}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 599, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1224, 42, 83, 2, 70, "Title",
 CellTags->{"S2.1.6", "6.1"},
 CellID->14609],
Cell[1310, 46, 75, 1, 70, "MathCaption",
 CellID->28119],
Cell[CellGroupData[{
Cell[1410, 51, 223, 8, 28, "Input",
 CellID->21479],
Cell[1636, 61, 538, 19, 50, "Output",
 CellID->1034635553]
}, Open  ]],
Cell[2189, 83, 274, 8, 70, "MathCaption",
 CellID->6300],
Cell[CellGroupData[{
Cell[2488, 95, 223, 8, 28, "Input",
 CellID->21396],
Cell[2714, 105, 6771, 190, 199, "Output",
 CellID->277611857]
}, Open  ]],
Cell[9500, 298, 896, 29, 70, "Text",
 CellID->11458],
Cell[10399, 329, 90, 1, 70, "MathCaption",
 CellID->20830],
Cell[CellGroupData[{
Cell[10514, 334, 250, 9, 70, "Input",
 CellID->24593],
Cell[10767, 345, 5436, 152, 70, "Output",
 CellID->353951077]
}, Open  ]],
Cell[16218, 500, 78, 1, 70, "MathCaption",
 CellID->29849],
Cell[CellGroupData[{
Cell[16321, 505, 341, 13, 70, "Input",
 CellID->14854],
Cell[16665, 520, 437, 16, 39, "Output",
 CellID->174160877]
}, Open  ]],
Cell[17117, 539, 213, 5, 70, "MathCaption",
 CellID->26160],
Cell[CellGroupData[{
Cell[17355, 548, 101, 3, 70, "Input",
 CellID->12294],
Cell[17459, 553, 13520, 373, 70, "Output",
 CellID->152981589]
}, Open  ]],
Cell[30994, 929, 265, 6, 70, "Text",
 CellID->26333],
Cell[CellGroupData[{
Cell[31284, 939, 72, 1, 70, "RelatedTutorialsSection",
 CellID->444198793],
Cell[31359, 942, 152, 3, 70, "RelatedTutorials",
 CellID->323659647]
}, Open  ]]
}, Open  ]],
Cell[31538, 949, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

