(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14552,        522]
NotebookOptionsPosition[     10455,        396]
NotebookOutlinePosition[     13093,        468]
CellTagsIndexPosition[     12955,        460]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"InputStream" :> 
         Documentation`HelpLookup["paclet:ref/InputStream"], "OutputStream" :> 
         Documentation`HelpLookup["paclet:ref/OutputStream"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"InputStream\"\>", 
      2->"\<\"OutputStream\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Files and Streams", "Title",
 CellID->223855164],

Cell[CellGroupData[{

Cell["File Names", "Section",
 CellTags->{"SA.6.1", "1.1"},
 CellID->5831],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "m"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " language source file"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "nb"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebook file"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "ma"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebook file from before Version 3"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "mx"}], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression dump"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "exe"}], Cell[TextData[{
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " executable program"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "tm"}], Cell[TextData[{
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " template file"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "ml"}], Cell[TextData[{
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " stream file"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21295],

Cell["Conventions for file names. ", "Caption",
 CellID->3537],

Cell[TextData[{
 "Most files used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are completely system independent. .mx and ",
 ".exe",
 " files are however system dependent. For these files, there is a convention \
that bundles of versions for different computer systems have names with forms \
such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["name", "TI"], "/", 
    ButtonBox["$SystemID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemID"]}], "/", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15623],

Cell[TextData[{
 "In general, when you refer to a file, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tries to resolve its name as follows: "
}], "Text",
 CellID->17922],

Cell[TextData[{
 "If the name starts with ",
 Cell[BoxData["!"], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " treats the remainder of the name as an external command, and uses a pipe \
to this command. "
}], "Notes",
 CellID->2927],

Cell[TextData[{
 "If the name contains metacharacters used by your operating system, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " passes the name directly to the operating system for interpretation. "
}], "Notes",
 CellID->492366257],

Cell["\<\
Unless the file is to be used for input, no further processing on the name is \
done.\
\>", "Notes",
 CellID->105664922],

Cell[TextData[{
 "Unless the name given is an absolute file name under your operating system, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will search each of the directories specified in the list ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->94140363],

Cell[TextData[{
 "If what is found is a directory rather than a file, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will look for a file ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["name", "TI"], "/", 
    ButtonBox["$SystemID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemID"]}], "/", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32983968],

Cell[TextData[{
 "For names of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["name", "TI"], "`"}]]], "InlineFormula"],
 " the following further translations are done in ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " and related functions: "
}], "Text",
 CellID->28029],

Cell[TextData[{
 "A file ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", "mx"}]], "InlineFormula"],
 " is used if it exists."
}], "Notes",
 CellID->30211],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", "mx"}]], "InlineFormula"],
 " is a directory, then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["name", "TI"], ".", "mx"}], "/", 
    ButtonBox["$SystemID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemID"]}], "/", 
   RowBox[{
    StyleBox["name", "TI"], ".", "mx"}]}]], "InlineFormula"],
 " is used if it exists."
}], "Notes",
 CellID->5163861],

Cell[TextData[{
 "A file ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", "m"}]], "InlineFormula"],
 " is used if it exists."
}], "Notes",
 CellID->223042172],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is a directory, then the file ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], "/", 
   RowBox[{"init", ".", "m"}]}]], "InlineFormula"],
 " is used if it exists."
}], "Notes",
 CellID->16211],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["name", "TI"], "`"}]]], "InlineFormula"],
 " is taken to refer to a file or directory named ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", "exe"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->11754]
}, Open  ]],

Cell[CellGroupData[{

Cell["Streams", "Section",
 CellTags->{"SA.6.2", "2.1"},
 CellID->71],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InputStream",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InputStream"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
     StyleBox["n", "TI"], "]"}], Cell[
    "input from a file or pipe", "TableText"]},
   {
    RowBox[{
     ButtonBox["OutputStream",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OutputStream"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
     StyleBox["n", "TI"], "]"}], Cell[
    "output to a file or pipe", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->658],

Cell["Types of streams. ", "Caption",
 CellID->14122],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "encoding to use for special characters", "TableText"]},
   {
    ButtonBox["BinaryFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BinaryFormat"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to treat the file as being in binary format", "TableText"]},
   {
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["InputForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputForm"], Cell[
    "default format for expressions", "TableText"]},
   {
    ButtonBox["PageWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PageWidth"], "78", Cell[
    "number of characters per line", "TableText"]},
   {
    ButtonBox["TotalWidth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TotalWidth"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "maximum number of characters in a single expression", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26859],

Cell["Options for output streams. ", "Caption",
 CellID->7997],

Cell[TextData[{
 "You can test options for streams using ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 ", and reset them using ",
 Cell[BoxData[
  ButtonBox["SetOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetOptions"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->10999]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Files and Streams - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 29.6740728}", "context" -> "", 
    "keywords" -> {
     "binary files", "BinaryFormat", "dump files", "extensions", 
      "file extensions", "file names", "files", "format", "FormatType", 
      "globbing", "InputStream", ".ma files", ".ma extension", 
      "MathLink files", "Metacharacters", ".m files", ".m extension", 
      ".ml files", ".mx files", ".nb files", ".nb extension", "newlines", 
      "OutputStream", "output stream", "PageWidth", "page width", 
      "return characters", "text files", "TotalWidth", "types", 
      "Unix streams"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Conventions for file names. Most files used by Mathematica are \
completely system independent. .mx and .exe files are however system \
dependent. For these files, there is a convention that bundles of versions \
for different computer systems have names with forms such as \
name/$SystemID/name. In general, when you refer to a file, Mathematica tries \
to resolve its name as follows: ", "synonyms" -> {"A.6.1", "A.6.2"}, "title" -> 
    "Files and Streams", "type" -> "Tutorial", "uri" -> 
    "tutorial/FilesAndStreams"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.6.1"->{
  Cell[1381, 48, 74, 2, 70, "Section",
   CellTags->{"SA.6.1", "1.1"},
   CellID->5831]},
 "1.1"->{
  Cell[1381, 48, 74, 2, 70, "Section",
   CellTags->{"SA.6.1", "1.1"},
   CellID->5831]},
 "SA.6.2"->{
  Cell[7277, 289, 69, 2, 70, "Section",
   CellTags->{"SA.6.2", "2.1"},
   CellID->71]},
 "2.1"->{
  Cell[7277, 289, 69, 2, 70, "Section",
   CellTags->{"SA.6.2", "2.1"},
   CellID->71]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.6.1", 12541, 441},
 {"1.1", 12641, 445},
 {"SA.6.2", 12744, 449},
 {"2.1", 12843, 453}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 677, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1302, 43, 54, 1, 70, "Title",
 CellID->223855164],
Cell[CellGroupData[{
Cell[1381, 48, 74, 2, 70, "Section",
 CellTags->{"SA.6.1", "1.1"},
 CellID->5831],
Cell[1458, 52, 1659, 59, 70, "DefinitionBox",
 CellID->21295],
Cell[3120, 113, 62, 1, 70, "Caption",
 CellID->3537],
Cell[3185, 116, 572, 19, 70, "Text",
 CellID->15623],
Cell[3760, 137, 178, 6, 70, "Text",
 CellID->17922],
Cell[3941, 145, 263, 9, 70, "Notes",
 CellID->2927],
Cell[4207, 156, 248, 6, 70, "Notes",
 CellID->492366257],
Cell[4458, 164, 130, 4, 70, "Notes",
 CellID->105664922],
Cell[4591, 170, 361, 12, 70, "Notes",
 CellID->94140363],
Cell[4955, 184, 411, 15, 70, "Notes",
 CellID->32983968],
Cell[5369, 201, 354, 13, 70, "Text",
 CellID->28029],
Cell[5726, 216, 167, 7, 70, "Notes",
 CellID->30211],
Cell[5896, 225, 466, 18, 70, "Notes",
 CellID->5163861],
Cell[6365, 245, 170, 7, 70, "Notes",
 CellID->223042172],
Cell[6538, 254, 285, 11, 70, "Notes",
 CellID->16211],
Cell[6826, 267, 414, 17, 70, "Text",
 CellID->11754]
}, Open  ]],
Cell[CellGroupData[{
Cell[7277, 289, 69, 2, 70, "Section",
 CellTags->{"SA.6.2", "2.1"},
 CellID->71],
Cell[7349, 293, 860, 25, 70, "DefinitionBox",
 CellID->658],
Cell[8212, 320, 53, 1, 70, "Caption",
 CellID->14122],
Cell[8268, 323, 1704, 49, 70, "DefinitionBox3Col",
 CellID->26859],
Cell[9975, 374, 62, 1, 70, "Caption",
 CellID->7997],
Cell[10040, 377, 361, 13, 70, "Text",
 CellID->10999]
}, Open  ]]
}, Open  ]],
Cell[10428, 394, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

