(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11379,        362]
NotebookOptionsPosition[      7514,        257]
NotebookOutlinePosition[     10520,        331]
CellTagsIndexPosition[     10428,        325]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndStreamsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DumpSave" :> Documentation`HelpLookup["paclet:ref/DumpSave"], 
          "$Path" :> Documentation`HelpLookup["paclet:ref/$Path"], 
          "$SystemID" :> Documentation`HelpLookup["paclet:ref/$SystemID"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"DumpSave\"\>", 
       2->"\<\"$Path\"\>", 3->"\<\"$SystemID\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Files for Packages", "Title",
 CellTags->{"S2.12.5", "5.1"},
 CellID->26880],

Cell[TextData[{
 "When you create or use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages, you will often want to refer to files in a \
system\[Hyphen]independent way. You can use contexts to do this. "
}], "Text",
 CellID->12253],

Cell[TextData[{
 "The basic idea is that on every computer system there is a convention about \
how files corresponding to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " contexts should be named. Then, when you refer to a file using a context, \
the particular version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you are using converts the context name to the file name appropriate for \
the computer system you are on. "
}], "Text",
 CellID->3293],

Cell[BoxData[GridBox[{
   {
    RowBox[{"<<", 
     StyleBox["context", "TI"], 
     StyleBox["`", "MR"]}], Cell[
    "read in the file corresponding to the specified context", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21321],

Cell["Using contexts to specify files. ", "Caption",
 CellID->20785],

Cell[TextData[{
 "This reads in one of the standard packages that come with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->26528],

Cell[BoxData[
 RowBox[{"<<", "VectorAnalysis`"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->10443],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "mx"}], Cell[TextData[{
     "file in ",
     Cell[BoxData[
      ButtonBox["DumpSave",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
     " format"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "mx", "/", 
     ButtonBox["$SystemID",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/$SystemID"], "/", 
     StyleBox["name", "TI"], ".", "mx"}], Cell[TextData[{
     "file in ",
     Cell[BoxData[
      ButtonBox["DumpSave",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
     " format for your computer system"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], ".", "m"}], Cell[TextData[{
     "file in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " source format"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["name", "TI"], "/", "init", ".", "m"}], Cell[
    "initialization file for a particular directory", "TableText"]},
   {
    RowBox[{
     StyleBox["dir", "TI"], "/", 
     StyleBox["\[Ellipsis]", "TR"], "  "}], Cell[TextData[{
     "files in other directories specified by ",
     Cell[BoxData[
      ButtonBox["$Path",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Path"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31000],

Cell[TextData[{
 "The typical sequence of files looked for by ",
 StyleBox["<<", "MR"],
 StyleBox["name", "TI"],
 StyleBox["`", "MR"],
 ". "
}], "Caption",
 CellID->10555],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is set up so that ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox[
    RowBox[{
     StyleBox["name", "TI"], "`"}]]}]], "InlineFormula"],
 " will automatically try to load the appropriate version of a file. It will \
first try to load a ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", "mx"}]], "InlineFormula"],
 " file that is optimized for your particular computer system. If it finds no \
such file, then it will try to load a ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", "m"}]], "InlineFormula"],
 " file containing ordinary system\[Hyphen]independent ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Text",
 CellID->24671],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is a directory, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will try to load the initialization file ",
 Cell[BoxData[
  RowBox[{"init", ".", "m"}]], "InlineFormula"],
 " in that directory. The purpose of the ",
 Cell[BoxData[
  RowBox[{"init", ".", "m"}]], "InlineFormula"],
 " file is to provide a convenient way to set up ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages that involve many separate files. The idea is to allow you to \
give just the command ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox[
    RowBox[{
     StyleBox["name", "TI"], "`"}]]}]], "InlineFormula"],
 ", but then to load ",
 Cell[BoxData[
  RowBox[{"init", ".", "m"}]], "InlineFormula"],
 " to initialize the whole package, reading in whatever other files are \
necessary."
}], "Text",
 CellID->9270],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->403939829],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreamsOverview"]], "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Files for Packages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and Streams", "OverviewNavText"], BaseStyle -> "Link",
         ButtonData -> "paclet:tutorial/FilesAndStreamsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NamingAndFindingFiles"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingFilesAndDirectories"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 30.5178444}", "context" -> "", 
    "keywords" -> {
     "accent grave", "back quote", "file names", "initialization files", 
      "init.m files", "loading packages", "Master files", "mx files", 
      "packages", "Thirdparty packages", "translation"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you create or use Mathematica packages, you will often want to \
refer to files in a system-independent way. You can use contexts to do this. \
The basic idea is that on every computer system there is a convention about \
how files corresponding to Mathematica contexts should be named. Then, when \
you refer to a file using a context, the particular version of Mathematica \
you are using converts the context name to the file name appropriate for the \
computer system you are on. Using contexts to specify files. ", 
    "synonyms" -> {"2.12.5"}, "title" -> "Files for Packages", "type" -> 
    "Tutorial", "uri" -> "tutorial/FilesForPackages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.12.5"->{
  Cell[1984, 60, 82, 2, 70, "Title",
   CellTags->{"S2.12.5", "5.1"},
   CellID->26880]},
 "5.1"->{
  Cell[1984, 60, 82, 2, 70, "Title",
   CellTags->{"S2.12.5", "5.1"},
   CellID->26880]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.12.5", 10215, 314},
 {"5.1", 10315, 318}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1359, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1984, 60, 82, 2, 70, "Title",
 CellTags->{"S2.12.5", "5.1"},
 CellID->26880],
Cell[2069, 64, 245, 7, 70, "Text",
 CellID->12253],
Cell[2317, 73, 470, 12, 70, "Text",
 CellID->3293],
Cell[2790, 87, 509, 14, 70, "DefinitionBox",
 CellID->21321],
Cell[3302, 103, 68, 1, 70, "Caption",
 CellID->20785],
Cell[3373, 106, 168, 6, 70, "MathCaption",
 CellID->26528],
Cell[3544, 114, 99, 3, 70, "Input",
 CellID->10443],
Cell[3646, 119, 1732, 56, 70, "DefinitionBox",
 CellID->31000],
Cell[5381, 177, 171, 7, 70, "Caption",
 CellID->10555],
Cell[5555, 186, 743, 24, 70, "Text",
 CellID->24671],
Cell[6301, 212, 897, 29, 70, "Text",
 CellID->9270],
Cell[CellGroupData[{
Cell[7223, 245, 72, 1, 70, "RelatedTutorialsSection",
 CellID->403939829],
Cell[7298, 248, 162, 3, 70, "RelatedTutorials",
 CellID->107813958]
}, Open  ]]
}, Open  ]],
Cell[7487, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

