(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25866,        912]
NotebookOptionsPosition[     20110,        728]
NotebookOutlinePosition[     22884,        799]
CellTagsIndexPosition[     22793,        793]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cases" :> Documentation`HelpLookup["paclet:ref/Cases"], 
          "Count" :> Documentation`HelpLookup["paclet:ref/Count"], 
          "DeleteCases" :> Documentation`HelpLookup["paclet:ref/DeleteCases"],
           "Pick" :> Documentation`HelpLookup["paclet:ref/Pick"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cases\"\>", 2->"\<\"Count\"\>", 
       3->"\<\"DeleteCases\"\>", 4->"\<\"Pick\"\>", 5->"\<\"Position\"\>", 
       6->"\<\"ReplaceList\"\>", 7->"\<\"Select\"\>", 
       8->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Finding Expressions That Match a Pattern", "Title",
 CellTags->{"S2.3.2", "2.1"},
 CellID->7301],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Cases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cases"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "give the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Count",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Count"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "give the number of elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Position",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Position"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["form", "TI"], ",", "{", "1", "}", "]"}], Cell[TextData[{
     "give the positions of elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Select",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Select"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["test", "TI"], "]"}], Cell[TextData[{
     "give the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " on which ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Pick",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pick"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["sel", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "give the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " for which the corresponding elements of ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     " match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13293],

Cell["Finding elements that match a pattern. ", "Caption",
 CellID->24099],

Cell[TextData[{
 "This gives the elements of the list which match the pattern ",
 Cell[BoxData[
  RowBox[{"x", "^", "_"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", 
   RowBox[{"x", "^", "_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->19044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["x", "3"]}], "}"}]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->32331]
}, Open  ]],

Cell["\<\
Here is the total number of elements which match the pattern. \
\>", "MathCaption",
 CellID->75],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Count", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", 
   RowBox[{"x", "^", "_"}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->31004],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->19050]
}, Open  ]],

Cell[TextData[{
 "You can apply functions like ",
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " not only to lists, but to expressions of any kind. In addition, you can \
specify the level of parts at which you want to look. "
}], "Text",
 CellID->15026],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Cases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cases"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "find elements of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ", and give a list of the results of applying the transformation rule to \
them"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Cases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cases"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "test parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at levels specified by ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Count",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Count"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "give the total number of parts that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " at levels specified by ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Position",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Position"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "give the positions of parts that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " at levels specified by ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14066],

Cell["Searching for parts of expressions that match a pattern. ", "Caption",
 CellID->11738],

Cell[TextData[{
 "This returns a list of the exponents ",
 Cell[BoxData["n"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "n_"}], "->", "n"}]}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->19623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->13843]
}, Open  ]],

Cell[TextData[{
 "The pattern ",
 Cell[BoxData["_Integer"], "InlineFormula"],
 " matches any integer. This gives a list of integers appearing at any level. \
"
}], "MathCaption",
 CellID->441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", "_Integer", ",", "Infinity"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->3380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->19695]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Cases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cases"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["lev", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "find only the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " parts that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Position",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Position"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["lev", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the positions of the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " parts that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7918],

Cell["Limiting the number of parts to search for. ", "Caption",
 CellID->3659],

Cell[TextData[{
 "This gives the positions of the first two powers of ",
 Cell[BoxData["x"], "InlineFormula"],
 " appearing at any level. "
}], "MathCaption",
 CellID->1363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"4", "+", 
      RowBox[{"x", "^", "a"}]}], ",", 
     RowBox[{"x", "^", "b"}], ",", 
     RowBox[{"6", "+", 
      RowBox[{"x", "^", "5"}]}]}], "}"}], ",", 
   RowBox[{"x", "^", "_"}], ",", "Infinity", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->12628],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->6329]
}, Open  ]],

Cell[TextData[{
 "The positions are specified in exactly the form used by functions such as \
",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 " discussed in \"",
 ButtonBox["Lists\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ListsOverview"],
 ". "
}], "MathCaption",
 CellID->1088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"4", "+", 
      RowBox[{"x", "^", "a"}]}], ",", 
     RowBox[{"x", "^", "b"}], ",", 
     RowBox[{"6", "+", 
      RowBox[{"x", "^", "5"}]}]}], "}"}], ",", "zzz", ",", "%"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->28854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{"4", "+", "zzz"}], ",", "zzz", ",", 
   RowBox[{"6", "+", 
    SuperscriptBox["x", "5"]}]}], "}"}]], "Output",
 ImageSize->{153, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->8613]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DeleteCases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeleteCases"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], "]"}], Cell[TextData[{
     "delete elements of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DeleteCases",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DeleteCases"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["form", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "delete parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " at levels specified by ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24979],

Cell["Deleting parts of expressions that match a pattern. ", "Caption",
 CellID->18569],

Cell[TextData[{
 "This deletes the elements which match ",
 Cell[BoxData[
  RowBox[{"x", "^", "n_"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "x", ",", 
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", 
   RowBox[{"x", "^", "n_"}]}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->7679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "x"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->27577]
}, Open  ]],

Cell["This deletes all integers appearing at any level. ", "MathCaption",
 CellID->27837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "x", ",", 
     RowBox[{"2", "+", "x"}], ",", 
     RowBox[{"3", "+", "x"}]}], "}"}], ",", "_Integer", ",", "Infinity"}], 
  "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->3402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->23115]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ReplaceList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplaceList"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"], "]"}], Cell[TextData[{
     "find all ways that ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " can match ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23292],

Cell["Finding arrangements of an expression that match a pattern. ", "Caption",
 CellID->1723],

Cell["\<\
This finds all ways that the sum can be written in two parts. \
\>", "MathCaption",
 CellID->2872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{
    RowBox[{"x_", "+", "y_"}], "->", 
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->29448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a", ",", 
     RowBox[{"b", "+", "c"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", 
     RowBox[{"a", "+", "c"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", 
     RowBox[{"a", "+", "b"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", "c"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ",", "b"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->30323]
}, Open  ]],

Cell[TextData[{
 "This finds all pairs of identical elements. The pattern ",
 Cell[BoxData["___"], "InlineFormula"],
 " stands for any sequence of elements. "
}], "MathCaption",
 CellID->11153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "b", ",", "b", ",", "c", ",", "c", ",", "a"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"___", ",", "x_", ",", "x_", ",", "___"}], "}"}], "->", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->15948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->24395]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->460795047],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Finding Expressions That Match a Pattern - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/Introduction-Patterns"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/NamingPiecesOfPatterns"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 32.3147654}", "context" -> "", 
    "keywords" -> {
     "cases", "count", "criteria", "DeleteCases", "indices", "lists", 
      "masking", "multiplicity", "number of occurrences", "parts", "patterns",
       "pick", "position", "removing elements that match a pattern", 
      "ReplaceList", "search", "searching", "select", "selecting sublists"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Finding elements that match a pattern. This gives the elements of the \
list which match the pattern x^_. Here is the total number of elements which \
match the pattern. ", "synonyms" -> {"2.3.2"}, "title" -> 
    "Finding Expressions That Match a Pattern", "type" -> "Tutorial", "uri" -> 
    "tutorial/FindingExpressionsThatMatchAPattern"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.2"->{
  Cell[2424, 66, 102, 2, 70, "Title",
   CellTags->{"S2.3.2", "2.1"},
   CellID->7301]},
 "2.1"->{
  Cell[2424, 66, 102, 2, 70, "Title",
   CellTags->{"S2.3.2", "2.1"},
   CellID->7301]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.2", 22582, 782},
 {"2.1", 22681, 786}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1799, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2424, 66, 102, 2, 70, "Title",
 CellTags->{"S2.3.2", "2.1"},
 CellID->7301],
Cell[2529, 70, 2750, 89, 70, "DefinitionBox",
 CellID->13293],
Cell[5282, 161, 74, 1, 70, "Caption",
 CellID->24099],
Cell[5359, 164, 182, 6, 70, "MathCaption",
 CellID->23332],
Cell[CellGroupData[{
Cell[5566, 174, 276, 9, 28, "Input",
 CellID->19044],
Cell[5845, 185, 250, 9, 39, "Output",
 CellID->32331]
}, Open  ]],
Cell[6110, 197, 106, 3, 70, "MathCaption",
 CellID->75],
Cell[CellGroupData[{
Cell[6241, 204, 276, 9, 28, "Input",
 CellID->31004],
Cell[6520, 215, 155, 5, 36, "Output",
 CellID->19050]
}, Open  ]],
Cell[6690, 223, 323, 9, 70, "Text",
 CellID->15026],
Cell[7016, 234, 2318, 72, 70, "DefinitionBox",
 CellID->14066],
Cell[9337, 308, 92, 1, 70, "Caption",
 CellID->11738],
Cell[9432, 311, 136, 5, 70, "MathCaption",
 CellID->19801],
Cell[CellGroupData[{
Cell[9593, 320, 303, 10, 70, "Input",
 CellID->19623],
Cell[9899, 332, 200, 7, 36, "Output",
 CellID->13843]
}, Open  ]],
Cell[10114, 342, 192, 6, 70, "MathCaption",
 CellID->441],
Cell[CellGroupData[{
Cell[10331, 352, 278, 9, 70, "Input",
 CellID->3380],
Cell[10612, 363, 220, 7, 36, "Output",
 CellID->19695]
}, Open  ]],
Cell[10847, 373, 1304, 41, 70, "DefinitionBox",
 CellID->7918],
Cell[12154, 416, 78, 1, 70, "Caption",
 CellID->3659],
Cell[12235, 419, 173, 5, 70, "MathCaption",
 CellID->1363],
Cell[CellGroupData[{
Cell[12433, 428, 376, 12, 70, "Input",
 CellID->12628],
Cell[12812, 442, 272, 10, 36, "Output",
 CellID->6329]
}, Open  ]],
Cell[13099, 455, 500, 18, 70, "MathCaption",
 CellID->1088],
Cell[CellGroupData[{
Cell[13624, 477, 343, 12, 70, "Input",
 CellID->28854],
Cell[13970, 491, 298, 10, 39, "Output",
 CellID->8613]
}, Open  ]],
Cell[14283, 504, 1302, 41, 70, "DefinitionBox",
 CellID->24979],
Cell[15588, 547, 87, 1, 70, "Caption",
 CellID->18569],
Cell[15678, 550, 159, 6, 70, "MathCaption",
 CellID->666],
Cell[CellGroupData[{
Cell[15862, 560, 282, 9, 70, "Input",
 CellID->7679],
Cell[16147, 571, 210, 7, 36, "Output",
 CellID->27577]
}, Open  ]],
Cell[16372, 581, 89, 1, 70, "MathCaption",
 CellID->27837],
Cell[CellGroupData[{
Cell[16486, 586, 284, 9, 70, "Input",
 CellID->3402],
Cell[16773, 597, 210, 7, 36, "Output",
 CellID->23115]
}, Open  ]],
Cell[16998, 607, 790, 24, 70, "DefinitionBox",
 CellID->23292],
Cell[17791, 633, 94, 1, 70, "Caption",
 CellID->1723],
Cell[17888, 636, 108, 3, 70, "MathCaption",
 CellID->2872],
Cell[CellGroupData[{
Cell[18021, 643, 269, 9, 70, "Input",
 CellID->29448],
Cell[18293, 654, 721, 25, 36, "Output",
 CellID->30323]
}, Open  ]],
Cell[19029, 682, 193, 5, 70, "MathCaption",
 CellID->11153],
Cell[CellGroupData[{
Cell[19247, 691, 337, 11, 70, "Input",
 CellID->15948],
Cell[19587, 704, 211, 7, 36, "Output",
 CellID->24395]
}, Open  ]],
Cell[CellGroupData[{
Cell[19835, 716, 72, 1, 70, "RelatedTutorialsSection",
 CellID->460795047],
Cell[19910, 719, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[20083, 726, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

