(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18169,        586]
NotebookOptionsPosition[      9525,        309]
NotebookOutlinePosition[     16104,        510]
CellTagsIndexPosition[     15609,        487]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fonts on Unix and Linux", "Title",
 CellTags->{"i:28", "b:6.5", "net: 1"},
 CellID->158829212],

Cell[TextData[{
 "Dealing with fonts under Unix can sometimes be tricky. The important",
 " ",
 "issues in dealing with fonts in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are presented here for your convenience. "
}], "Text",
 CellTags->"b:6.5",
 CellID->330926434],

Cell[CellGroupData[{

Cell["Font Formats", "Section",
 CellTags->{"i:27", "b:6.5", "net: 2"},
 CellID->856386910],

Cell[TextData[{
 "BDF and Type1 fonts are installed by ",
 StyleBox["MathInstaller", "InlineCode"],
 ".",
 " PCF fonts are included on the CD, but not installed. If your X server \
requires PCF fonts, copy them from the CD and install them according to the \
instructions that follow. If you need fonts in another format, convert them \
using utilities included in your X installation. Your license gives you \
permission to convert the fonts to an appropriate format for your X server."
}], "Text",
 CellTags->{"i:27", "b:6.5"},
 CellID->470949382]
}, Open  ]],

Cell[CellGroupData[{

Cell["Font Installation", "Section",
 CellTags->{"i:26", "b:6.5", "net: 3"},
 CellID->151520728],

Cell[TextData[{
 "All machines that display the front end must have access to the fonts \
included with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". If the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process is running on a remote machine and the front end is displayed on \
the local machine, the X server on the local machine must know where to find \
the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts. To do this, add the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts to the local font path by running a command like the following on",
 " ",
 "the local machine."
}], "Text",
 CellTags->{"i:35", "b:6.5"},
 CellID->475376393],

Cell[TextData[{
 StyleBox["xset fp+", "InlineCode"],
 " ",
 StyleBox["/usr/local/Wolfram/Mathematica/6.0/SystemFiles/Fonts/Type1; xset \
fp rehash", "InlineCode"]
}], "Text",
 CellTags->"b:6.5",
 CellID->42917489],

Cell[TextData[{
 "Be sure to execute ",
 StyleBox["xset fp rehash", "InlineCode"],
 " to make the fonts available to the local X server."
}], "Text",
 CellTags->"b:6.5",
 CellID->1618549],

Cell[TextData[{
 "For optimal onscreen performance, Type1 fonts should appear before BDF or \
PCF fonts in the font path. Hence, ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "/SystemFiles/Fonts/Type1 should appear before ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "/SystemFiles/Fonts/BDF or ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "/SystemFiles/Fonts/PCF",
 ". You can check the order of the font path by executing the command ",
 StyleBox["xset q", "InlineCode"],
 "."
}], "Text",
 CellTags->{"b:6.5", "i:1"},
 CellID->189169655],

Cell[TextData[{
 "Most platforms only require the BDF bitmap fonts, but some platforms, such \
as HP Tru64 Unix\[CloseCurlyQuote]s X server, require PCF instead of BDF. \
Some Windows-based X servers, for example SCO\[CloseCurlyQuote]s XVision, \
require PCF fonts as well. Note that some Windows-based X servers, such as \
Hummingbird\[CloseCurlyQuote]s Exceed, require that you compile fonts into a \
format specific to the X server. For further information, visit ",
 ButtonBox["support.wolfram.com/mathematica/systems/unix/interface",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com/mathematica/systems/unix/interface"], 
    None}],
 "."
}], "Text",
 CellTags->"b:6.5",
 CellID->117535437]
}, Open  ]],

Cell[CellGroupData[{

Cell["Font Servers", "Section",
 CellTags->{"i:29", "b:6.5", "net: 4"},
 CellID->240584515],

Cell[TextData[{
 "You may prefer not to install local copies of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts on all machines. You can instead set up a font server with all the \
necessary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts. The other machines on the network can then find the fonts as needed \
by reading them from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " directory on the font server. Consult your operating system\
\[CloseCurlyQuote]s documentation for further information."
}], "Text",
 CellTags->"b:6.5",
 CellID->445943694]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common Font Errors", "Section",
 CellTags->{"i:31", "b:6.5", "net: 5"},
 CellID->354476824],

Cell[TextData[{
 "On some systems, the font path is limited in length, and it is possible to \
receive ",
 StyleBox["xset: bad font path element", "InlineCode"],
 " errors even if the fonts are available to the server. In this case, try \
reordering the font path and adding the directories for the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts earlier in the path. The directory ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "/SystemFiles/Fonts/Type1 must be listed before ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "/SystemFiles/Fonts/BDF",
 " on the font path for optimal onscreen performance."
}], "Text",
 CellTags->{"i:25", "b:6.5"},
 CellID->183433745]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fonts and Printing", "Section",
 CellTags->{"i:32", "b:6.5", "net: 6"},
 CellID->302216337],

Cell[TextData[{
 "When the X front end prints a notebook, it uses AFM files for the font \
metrics needed for printing. If you want to print using a particular font not \
included with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you will need the AFM files for the font. These files are installed in \
either ",
 StyleBox[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"], "InlineCode"],
 "/Configuration/Fonts/AFM",
 ", ",
 "/usr/lib/AFM",
 ", or ",
 "/usr/lib/afm",
 ". Fonts are normally downloaded to the printer by the front end when \
printing. You may be able to download the fonts and store them on the \
printer. See the documentation and programs that came with your printer for \
more information."
}], "Text",
 CellTags->{"i:24", "b:6.5"},
 CellID->23850191]
}, Open  ]],

Cell[CellGroupData[{

Cell["GhostScript", "Section",
 CellTags->{"i:30", "b:6.5", "net: 7"},
 CellID->219308588],

Cell[TextData[{
 "If you want to view ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics using GhostScript, you need to make GhostScript aware of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fonts. For more information, contact Technical Support by sending email to \
",
 ButtonBox["support@wolfram.com",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["mailto:support@wolfram.com"], None}],
 ", or visit ",
 ButtonBox["support.wolfram.com/mathematica/graphics/export/ghostscript.html",
  
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://support.wolfram.com/mathematica/graphics/export/ghostscript.\
html"], None}],
 "."
}], "Text",
 CellTags->"b:6.5",
 CellID->305738297],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->246585069],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fonts on Unix and Linux - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 35, 37.3773950}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Dealing with fonts under Unix can sometimes be tricky. The important \
issues in dealing with fonts in Mathematica are presented here for your \
convenience. BDF and Type1 fonts are installed by MathInstaller. PCF fonts \
are included on the CD, but not installed. If your X server requires PCF \
fonts, copy them from the CD and install them according to the instructions \
that follow. If you need fonts in another format, convert them using \
utilities included in your X installation. Your license gives you permission \
to convert the fonts to an appropriate format for your X server. All machines \
that display the front end must have access to the fonts included with \
Mathematica. If the Mathematica process is running on a remote machine and \
the front end is displayed on the local machine, the X server on the local \
machine must know where to find the Mathematica fonts. To do this, add the \
Mathematica fonts to the local font path by running a command like the \
following on the local machine.", "synonyms" -> {}, "title" -> 
    "Fonts on Unix and Linux", "type" -> "Tutorial", "uri" -> 
    "tutorial/FontsOnUnixAndLinux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "i:28"->{
  Cell[1565, 48, 100, 2, 70, "Title",
   CellTags->{"i:28", "b:6.5", "net: 1"},
   CellID->158829212]},
 "b:6.5"->{
  Cell[1565, 48, 100, 2, 70, "Title",
   CellTags->{"i:28", "b:6.5", "net: 1"},
   CellID->158829212],
  Cell[1668, 52, 278, 9, 70, "Text",
   CellTags->"b:6.5",
   CellID->330926434],
  Cell[1971, 65, 91, 2, 70, "Section",
   CellTags->{"i:27", "b:6.5", "net: 2"},
   CellID->856386910],
  Cell[2065, 69, 549, 11, 70, "Text",
   CellTags->{"i:27", "b:6.5"},
   CellID->470949382],
  Cell[2651, 85, 96, 2, 70, "Section",
   CellTags->{"i:26", "b:6.5", "net: 3"},
   CellID->151520728],
  Cell[2750, 89, 680, 21, 70, "Text",
   CellTags->{"i:35", "b:6.5"},
   CellID->475376393],
  Cell[3433, 112, 213, 7, 70, "Text",
   CellTags->"b:6.5",
   CellID->42917489],
  Cell[3649, 121, 187, 6, 70, "Text",
   CellTags->"b:6.5",
   CellID->1618549],
  Cell[3839, 129, 816, 20, 70, "Text",
   CellTags->{"b:6.5", "i:1"},
   CellID->189169655],
  Cell[4658, 151, 724, 15, 70, "Text",
   CellTags->"b:6.5",
   CellID->117535437],
  Cell[5419, 171, 91, 2, 70, "Section",
   CellTags->{"i:29", "b:6.5", "net: 4"},
   CellID->240584515],
  Cell[5513, 175, 592, 16, 70, "Text",
   CellTags->"b:6.5",
   CellID->445943694],
  Cell[6142, 196, 97, 2, 70, "Section",
   CellTags->{"i:31", "b:6.5", "net: 5"},
   CellID->354476824],
  Cell[6242, 200, 861, 20, 70, "Text",
   CellTags->{"i:25", "b:6.5"},
   CellID->183433745],
  Cell[7140, 225, 97, 2, 70, "Section",
   CellTags->{"i:32", "b:6.5", "net: 6"},
   CellID->302216337],
  Cell[7240, 229, 840, 22, 70, "Text",
   CellTags->{"i:24", "b:6.5"},
   CellID->23850191],
  Cell[8117, 256, 90, 2, 70, "Section",
   CellTags->{"i:30", "b:6.5", "net: 7"},
   CellID->219308588],
  Cell[8210, 260, 711, 23, 70, "Text",
   CellTags->"b:6.5",
   CellID->305738297]},
 "net: 1"->{
  Cell[1565, 48, 100, 2, 70, "Title",
   CellTags->{"i:28", "b:6.5", "net: 1"},
   CellID->158829212]},
 "i:27"->{
  Cell[1971, 65, 91, 2, 70, "Section",
   CellTags->{"i:27", "b:6.5", "net: 2"},
   CellID->856386910],
  Cell[2065, 69, 549, 11, 70, "Text",
   CellTags->{"i:27", "b:6.5"},
   CellID->470949382]},
 "net: 2"->{
  Cell[1971, 65, 91, 2, 70, "Section",
   CellTags->{"i:27", "b:6.5", "net: 2"},
   CellID->856386910]},
 "i:26"->{
  Cell[2651, 85, 96, 2, 70, "Section",
   CellTags->{"i:26", "b:6.5", "net: 3"},
   CellID->151520728]},
 "net: 3"->{
  Cell[2651, 85, 96, 2, 70, "Section",
   CellTags->{"i:26", "b:6.5", "net: 3"},
   CellID->151520728]},
 "i:35"->{
  Cell[2750, 89, 680, 21, 70, "Text",
   CellTags->{"i:35", "b:6.5"},
   CellID->475376393]},
 "i:1"->{
  Cell[3839, 129, 816, 20, 70, "Text",
   CellTags->{"b:6.5", "i:1"},
   CellID->189169655]},
 "i:29"->{
  Cell[5419, 171, 91, 2, 70, "Section",
   CellTags->{"i:29", "b:6.5", "net: 4"},
   CellID->240584515]},
 "net: 4"->{
  Cell[5419, 171, 91, 2, 70, "Section",
   CellTags->{"i:29", "b:6.5", "net: 4"},
   CellID->240584515]},
 "i:31"->{
  Cell[6142, 196, 97, 2, 70, "Section",
   CellTags->{"i:31", "b:6.5", "net: 5"},
   CellID->354476824]},
 "net: 5"->{
  Cell[6142, 196, 97, 2, 70, "Section",
   CellTags->{"i:31", "b:6.5", "net: 5"},
   CellID->354476824]},
 "i:25"->{
  Cell[6242, 200, 861, 20, 70, "Text",
   CellTags->{"i:25", "b:6.5"},
   CellID->183433745]},
 "i:32"->{
  Cell[7140, 225, 97, 2, 70, "Section",
   CellTags->{"i:32", "b:6.5", "net: 6"},
   CellID->302216337]},
 "net: 6"->{
  Cell[7140, 225, 97, 2, 70, "Section",
   CellTags->{"i:32", "b:6.5", "net: 6"},
   CellID->302216337]},
 "i:24"->{
  Cell[7240, 229, 840, 22, 70, "Text",
   CellTags->{"i:24", "b:6.5"},
   CellID->23850191]},
 "i:30"->{
  Cell[8117, 256, 90, 2, 70, "Section",
   CellTags->{"i:30", "b:6.5", "net: 7"},
   CellID->219308588]},
 "net: 7"->{
  Cell[8117, 256, 90, 2, 70, "Section",
   CellTags->{"i:30", "b:6.5", "net: 7"},
   CellID->219308588]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"i:28", 11733, 354},
 {"b:6.5", 11849, 358},
 {"net: 1", 13557, 413},
 {"i:27", 13672, 417},
 {"net: 2", 13883, 424},
 {"i:26", 13999, 428},
 {"net: 3", 14117, 432},
 {"i:35", 14233, 436},
 {"i:1", 14337, 440},
 {"i:29", 14442, 444},
 {"net: 4", 14561, 448},
 {"i:31", 14678, 452},
 {"net: 5", 14797, 456},
 {"i:25", 14914, 460},
 {"i:32", 15020, 464},
 {"net: 6", 15139, 468},
 {"i:24", 15256, 472},
 {"i:30", 15361, 476},
 {"net: 7", 15480, 480}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 100, 2, 70, "Title",
 CellTags->{"i:28", "b:6.5", "net: 1"},
 CellID->158829212],
Cell[1668, 52, 278, 9, 70, "Text",
 CellTags->"b:6.5",
 CellID->330926434],
Cell[CellGroupData[{
Cell[1971, 65, 91, 2, 70, "Section",
 CellTags->{"i:27", "b:6.5", "net: 2"},
 CellID->856386910],
Cell[2065, 69, 549, 11, 70, "Text",
 CellTags->{"i:27", "b:6.5"},
 CellID->470949382]
}, Open  ]],
Cell[CellGroupData[{
Cell[2651, 85, 96, 2, 70, "Section",
 CellTags->{"i:26", "b:6.5", "net: 3"},
 CellID->151520728],
Cell[2750, 89, 680, 21, 70, "Text",
 CellTags->{"i:35", "b:6.5"},
 CellID->475376393],
Cell[3433, 112, 213, 7, 70, "Text",
 CellTags->"b:6.5",
 CellID->42917489],
Cell[3649, 121, 187, 6, 70, "Text",
 CellTags->"b:6.5",
 CellID->1618549],
Cell[3839, 129, 816, 20, 70, "Text",
 CellTags->{"b:6.5", "i:1"},
 CellID->189169655],
Cell[4658, 151, 724, 15, 70, "Text",
 CellTags->"b:6.5",
 CellID->117535437]
}, Open  ]],
Cell[CellGroupData[{
Cell[5419, 171, 91, 2, 70, "Section",
 CellTags->{"i:29", "b:6.5", "net: 4"},
 CellID->240584515],
Cell[5513, 175, 592, 16, 70, "Text",
 CellTags->"b:6.5",
 CellID->445943694]
}, Open  ]],
Cell[CellGroupData[{
Cell[6142, 196, 97, 2, 70, "Section",
 CellTags->{"i:31", "b:6.5", "net: 5"},
 CellID->354476824],
Cell[6242, 200, 861, 20, 70, "Text",
 CellTags->{"i:25", "b:6.5"},
 CellID->183433745]
}, Open  ]],
Cell[CellGroupData[{
Cell[7140, 225, 97, 2, 70, "Section",
 CellTags->{"i:32", "b:6.5", "net: 6"},
 CellID->302216337],
Cell[7240, 229, 840, 22, 70, "Text",
 CellTags->{"i:24", "b:6.5"},
 CellID->23850191]
}, Open  ]],
Cell[CellGroupData[{
Cell[8117, 256, 90, 2, 70, "Section",
 CellTags->{"i:30", "b:6.5", "net: 7"},
 CellID->219308588],
Cell[8210, 260, 711, 23, 70, "Text",
 CellTags->"b:6.5",
 CellID->305738297],
Cell[CellGroupData[{
Cell[8946, 287, 72, 1, 70, "RelatedTutorialsSection",
 CellID->246585069],
Cell[9021, 290, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[9238, 297, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[9498, 307, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

