(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2660082,      49743]
NotebookOptionsPosition[   2647754,      49370]
NotebookOutlinePosition[   2650679,      49428]
CellTagsIndexPosition[   2650636,      49425]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Editing Techniques" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BasicEditingTechniquesOverview"], 
          "Entering Two-Dimensional Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"], 
          "Entering Two-Dimensional Input" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EnteringTwoDimensionalInput"], 
          "Styles and Fonts in Output" :> 
          Documentation`HelpLookup["paclet:tutorial/StylesAndFontsInOutput"], 
          "Styles and the Inheritance of Option Settings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"], 
          "Notebooks and Documents" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Editing Techniques\"\>", 
       2->"\<\"Entering Two-Dimensional Expressions\"\>", 
       3->"\<\"Entering Two-Dimensional Input\"\>", 
       4->"\<\"Styles and Fonts in Output\"\>", 
       5->"\<\"Styles and the Inheritance of Option Settings\"\>", 
       6->"\<\"Notebooks and Documents\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebook Formatting & Styling in Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], 
          "Notebooks and Documents Overview" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebooksAndDocumentsOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Notebook Formatting & Styling in Mathematica \"\>", 
       2->"\<\"Notebooks and Documents Overview\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Formatted Output", "Title"],

Cell[TextData[{
 "Ever since version 3 of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", there has been rich support for arbitrary mathematical typesetting and \
layout. Underlying all that power was a so called ",
 StyleBox["box language",
  FontSlant->"Italic"],
 ", which allowed notebooks themselves to be ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. This approach turned out to be very powerful, and has formed \
the basis of many unique features in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". However, despite the power of the box language, in practice it was \
awkward enough for users to access directly that few did."
}], "Text"],

Cell[TextData[{
 "Starting in version 6, there is a higher-level interface to this box \
language which takes much of the pain out of using boxes directly, while \
still exposing all the same typesetting and layout power. Functions in this \
new layer are often refered to as ",
 StyleBox["box generators",
  FontSlant->"Italic"],
 ", but there is no need for you to be aware of the box language to use them \
effectively. In this tutorial, we will take a look at box generators that are \
relevant for displaying a wide variety of expressions, and we will show some \
ways in which they can be used to generate beautifully formatted output that \
goes beyond simple mathematical typesetting."
}], "Text"],

Cell[CellGroupData[{

Cell["Styling output", "Section"],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end supports all the usual style mechanisms available in word \
processors, for example including menus for changing font characteristics. \
However, it used to be very difficult to access those styling mechanisms \
automatically in generated output. Output continued to be almost universally \
plain 12 pt. Courier (or Times for those people using ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 "). To address this, the function ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " was created. Whenever you evaluate a ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " expression, its output will be displayed with the given style attributes \
active."
}], "Text"],

Cell[TextData[{
 "You can wrap ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " around any sort of expression. Here",
 " i",
 "s an example that displays prime and composite numbers using different font \
weights and colors via ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", "i", "]"}], ",", " ", 
     RowBox[{"Style", "[", 
      RowBox[{"i", ",", " ", "Bold"}], "]"}], ",", " ", 
     RowBox[{"Style", "[", 
      RowBox[{"i", ",", " ", "Gray"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{507, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->622455389]
}, Open  ]],

Cell[TextData[{
 "There are hundreds of formatting options that you could apply with ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 "\[LongDash]see the documentation for ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " for a more complete listing\[LongDash]but there are a handful that are by \
far the most common, listed here."
}], "Text"],

Cell[BoxData[GridBox[{
   {Cell["Menu", "TableHeader"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", "]"}]], "InlineFormula",
      FontSlant->"Plain"],
     " option"
    }], "TableHeader"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", "]"}]], "InlineFormula",
      FontSlant->"Plain"],
     " directive"
    }], "TableHeader"]},
   {Cell[TextData[{
     StyleBox[ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox[ButtonBox["Size",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/Size"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox["14", "MenuName"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["FontSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontSize"], "->", "14"}], "14"},
   {Cell[TextData[{
     StyleBox[ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox[ButtonBox["Text Color",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/TextColor"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox["Gray", "MenuName"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["FontColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontColor"], "->", 
     ButtonBox["Gray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Gray"]}], 
    ButtonBox["Gray",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gray"]},
   {Cell[TextData[{
     StyleBox[ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox[ButtonBox["Face",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/Face"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox["Bold", "MenuName"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["FontWeight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontWeight"], "->", 
     ButtonBox["Bold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Bold"]}], 
    ButtonBox["Bold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bold"]},
   {Cell[TextData[{
     StyleBox[ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox[ButtonBox["Face",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/Face"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox["Italic", "MenuName"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["FontSlant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontSlant"], "->", 
     ButtonBox["Italic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Italic"]}], 
    ButtonBox["Italic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Italic"]},
   {Cell[TextData[{
     StyleBox[ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox[ButtonBox["Background Color",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/BackgroundColor"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox["Yellow", "MenuName"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["Background",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Background"], "->", 
     ButtonBox["Yellow",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Yellow"]}], " "},
   {Cell[TextData[{
     StyleBox[ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox[ButtonBox["Font",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/Font"], "MenuName"]
    }], "TableText"], 
    RowBox[{
     ButtonBox["FontFamily",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FontFamily"], "->", "\"\<Times\>\""}], " "},
   {Cell[TextData[{
     StyleBox[ButtonBox["Format",
      BaseStyle->"Link",
      ButtonData->"paclet:guide/FormatMenu"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox[ButtonBox["Style",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/menuitem/Style"], "MenuName"],
     StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
     StyleBox["Subsection", "MenuName"]
    }], "TableText"], "\"\<Subsection\>\"", " "}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxDividers->{
   "Columns" -> {{True}}, "ColumnsIndexed" -> {}, "Rows" -> {{True}}, 
    "RowsIndexed" -> {}}]], "Text",
 TextAlignment->Center],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " can be arbitrarily nested, with the innermost one taking precedence if \
there is a conflict. Here we wrap ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " around the entire listing to apply new font to all elements of the list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{498, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->679912930]
}, Open  ]],

Cell[TextData[{
 "Another common thing to want is to have a portion of the output styled like \
text. It can look quite strange to have text appear in a font which is \
intended for use by code. For that purpose, we have a function ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " which ensures that its argument will always be rendered in a text font. \
(Those of you familiar with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics will recognize the ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " function as a graphics primitive, but that use does not conflict with this \
use outside of graphics.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "[", "%%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77919614],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{480, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->519516656]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " can be used to set up a region on the screen where any option is active, \
not just options related to fonts. Later in this tutorial, we will see how ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " can even affect the display characteristics of other formatting \
constructs, like ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Grid layout", "Section"],

Cell[TextData[{
 "Using two dimensional layout structures can be just as useful as applying \
style directives to those structures. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the primary function for such layout is ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " has very flexible layout features, including the ability to arbitrarily \
adjust things like alignment, frame elements, and spanning elements. (Other \
tutorials go into ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "'s features in greater detail, but we will cover the highlights here.)"
}], "Text",
 CellID->1457130555],

Cell[TextData[{
 "Look again at the ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " example which displays prime and composite numbers differently."
}], "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ptable", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"PrimeQ", "[", "i", "]"}], ",", " ", 
       RowBox[{"Style", "[", 
        RowBox[{"i", ",", " ", "Bold"}], "]"}], ",", " ", 
       RowBox[{"Style", "[", 
        RowBox[{"i", ",", " ", "Gray"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[11]:="],

Cell[TextData[{
 "To put this into a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", we first use ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " to turn this 100 element list into a 10\[Times]10 array. Although you can \
give ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " a ragged array (a list whose elements are lists of different lengths), in \
this case we give ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " a regular array, and the resulting display is a nicely formatted layout."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{"ptable", ",", "10"}], "]"}], "]"}]], "Input"],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{219, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->9568570]
}, Open  ]],

Cell[TextData[{
 "Notice that the columns are aligned on center, and there are no frame \
lines. It",
 " i",
 "s an easy matter to change either of these using ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "'s options."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{"ptable", ",", "10"}], "]"}], ",", " ", 
   RowBox[{"Alignment", " ", "\[Rule]", " ", "Right"}], ",", " ", 
   RowBox[{"Frame", " ", "\[Rule]", " ", "True"}], ",", " ", 
   RowBox[{"Background", " ", "\[Rule]", " ", "LightBlue"}]}], "]"}]], "Input"],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{229, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->3195635]
}, Open  ]],

Cell[TextData[{
 "A complete description of all of ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "'s options and their syntax is beyond the scope of this document, but it is \
possible to do some remarkable things with them. See the complete ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " documentation for complete details."
}], "Text"],

Cell[TextData[{
 "There are a few convenience constructs related to ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". One is ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ", which takes a flat list of elements and arranges them vertically. This \
would be slightly awkward to do with ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". Here",
 " i",
 "s a simple example, viewing the options of column in, well, a column."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Options", "[", "Column", "]"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"Alignment", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Baseline"}], "}"}]}]},
    {
     RowBox[{"Background", "\[Rule]", "None"}]},
    {
     RowBox[{"BaselinePosition", "\[Rule]", "Automatic"}]},
    {
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", "}"}]}]},
    {
     RowBox[{"ColumnAlignments", "\[Rule]", "Left"}]},
    {
     RowBox[{"DefaultBaseStyle", "\[Rule]", "\<\"Grid\"\>"}]},
    {
     RowBox[{"DefaultElement", "\[Rule]", "\<\"\[Placeholder]\"\>"}]},
    {
     RowBox[{"Dividers", "\[Rule]", "None"}]},
    {
     RowBox[{"Frame", "\[Rule]", "None"}]},
    {
     RowBox[{"FrameStyle", "\[Rule]", "Automatic"}]},
    {
     RowBox[{"ItemSize", "\[Rule]", "Automatic"}]},
    {
     RowBox[{"ItemStyle", "\[Rule]", "None"}]},
    {
     RowBox[{"Spacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0.8`", ",", "1.`"}], "}"}]}]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{195, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "What about laying out a list of things horizontally? In that case, the main \
question you need to ask is whether you want the resulting display to line \
wrap like a line of math or text would, or whether you want the elements to \
remain on a single line. In the latter case, you would use Grid applied to a \
1\[Times]",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " array."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Range", "[", "15", "]"}], "!"}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:="],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "6", "24", "120", "720", "5040", "40320", "362880", "3628800", 
     "39916800", "479001600", "6227020800", "87178291200", "1307674368000"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{586, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1169204484]
}, Open  ]],

Cell[TextData[{
 "But notice in this example, that the overall grid shrinks so that it fits \
in the avaialble window width. As a result, there are elements of the grid \
which themselves wrap onto multiple lines. This is due to the default ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". If you want to allow the elements of a grid to be as wide as they would \
naturally be, set ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Full",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Full"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "15", "]"}], "!"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->485409224],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "6", "24", "120", "720", "5040", "40320", "362880", "3628800", 
     "39916800", "479001600", "6227020800", "87178291200", "1307674368000"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{All}}, "Rows" -> {{All}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{748, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->2129936462]
}, Open  ]],

Cell[TextData[{
 "Of course, now the whole grid is too wide to fit on one line (unless you \
make this window very wide), and so there are elements in the grid which you \
can",
 "no",
 "t see. That brings us to the other horizontal layout function: ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1553038152],

Cell[TextData[{
 "Given a list of elements, ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " will allow the overall result to word wrap in the natural way, just like a \
line of text or math would. This type of layout will be familiar to those of \
you who might have used the old (and now obsolete) ",
 Cell[BoxData[
  ButtonBox["SequenceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SequenceForm"]], "InlineFormula"],
 " function."
}], "Text",
 CellID->1395975026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Range", "[", "15", "]"}], "!"}], "]"}]], "Input",
 CellID->893418507],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "24", "\[InvisibleSpace]", "120", "\[InvisibleSpace]",
    "720", "\[InvisibleSpace]", "5040", "\[InvisibleSpace]", "40320", 
   "\[InvisibleSpace]", "362880", "\[InvisibleSpace]", "3628800", 
   "\[InvisibleSpace]", "39916800", "\[InvisibleSpace]", "479001600", 
   "\[InvisibleSpace]", "6227020800", "\[InvisibleSpace]", "87178291200", 
   "\[InvisibleSpace]", "1307674368000"}],
  Row[{1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 
    479001600, 6227020800, 87178291200, 1307674368000}]]], "Output",
 ImageSize->{338, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->479187325]
}, Open  ]],

Cell[TextData[{
 "As you can see, ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " does not leave space between elements by default. But if you give a second \
argument, that expression is inserted between elements. Here we use a comma, \
but any expression can be used."
}], "Text",
 CellID->637695025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Range", "[", "15", "]"}], "!"}], ",", " ", "\"\<,\>\""}], 
  "]"}]], "Input",
 CellID->1796886645],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", ",", "2", ",", "6", ",", "24", ",", "120", ",", "720", ",", "5040", 
   ",", "40320", ",", "362880", ",", "3628800", ",", "39916800", ",", 
   "479001600", ",", "6227020800", ",", "87178291200", ",", "1307674368000"}],
  
  Row[{1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 
    479001600, 6227020800, 87178291200, 1307674368000}, ","]]], "Output",
 ImageSize->{423, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->211314754]
}, Open  ]],

Cell[TextData[{
 "If you resize the notebook window, you ",
 "wi",
 "ll see that ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " continues to behave differently than ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", and each are useful in different circumstances."
}], "Text",
 CellID->1776601987]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using output as input", "Section"],

Cell[TextData[{
 "This is a good time to point out that ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", and all other box generators, are persistent in output. If you were to \
take a piece of output that had some formatting created by ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and reuse that as input, the literal ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " expressions would appear in the input expression. Those of you familiar \
with the old uses of ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " and even functions like ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " will find this a change."
}], "Text"],

Cell[TextData[{
 "Consider taking the output of this ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " command, which has lots of embedded styles, and using it in some input \
expression."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Take", "[", 
      RowBox[{"ptable", ",", "16"}], "]"}], ",", "4"}], "]"}], ",", " ", 
   RowBox[{"Alignment", " ", "\[Rule]", " ", "Right"}], ",", " ", 
   RowBox[{"Frame", " ", "\[Rule]", " ", "True"}], ",", " ", 
   RowBox[{"Background", " ", "\[Rule]", " ", "LightBlue"}]}], "]"}]], "Input",\

 CellLabel->"In[17]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV0tuwjAQNYljVNJW4ld1yU26a1fddsEuQpVgUbWiHICTcobeIJ1JZsAM
42BIqYgIzkzw85uPH8lrsZq/fxSrxayYvCyLr/li9j15/lyCK+0YY6ZwPj0a
uC7hqjqnZVnWN+BI4dz8lPAxb/DVuYA3hS8HZgIjunMYs/V6naEN4w3ZKdm5
sJ2KirMTdFVL7Pzou618MJV8Ttg9YScV4NaGD1wfoOi/yhrZORo1LEextmd6
PofjUV+CkaVOuBNYVS3t1oYLyYZ7Qs5EFvZor4QyYT1by0EqbG113+4G94GN
7Ni2jOT95rxwPXCVBCZ1acxpzCi7bDuqgl7lS+lIe2+PeGOcUnGc4dLUB1aK
lSnZ7BTrEFXmXu7p8D7D3HMN1J6K3Ff3Ym68vjUxiOuhnHojXl2a1rTC1uPt
BbHbM8gURv/LQCpu+ucMcC4rkW3Ze1h/3lOsFazQfpTyvt5N16ASureKE8wh
8R9RXMPGeOqdaPa0vq9md0h4gxNyzzm+ZsRQBlAzxh5ecw4tr+p16UMj1zAb
nDMWWIPoOoVxM68b+mQ3R3YNfR3+p8xkHJQ3jEdXRak+fcr2SMmurICuchJx
QIh+7V00H+7f8eb0zpFYvP85M4ht9p5d43A4R/6zh68t/lPg+Yh9pQJx6PzM
N/Li5E5IglEe67X67bN+EzWdX/ENOJ0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{90, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->632501369]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     TagBox[GridBox[{
        {
         StyleBox["1",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]], 
         StyleBox["2",
          StripOnInput->False,
          FontWeight->Bold], 
         StyleBox["3",
          StripOnInput->False,
          FontWeight->Bold], 
         StyleBox["4",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]]},
        {
         StyleBox["5",
          StripOnInput->False,
          FontWeight->Bold], 
         StyleBox["6",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]], 
         StyleBox["7",
          StripOnInput->False,
          FontWeight->Bold], 
         StyleBox["8",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]]},
        {
         StyleBox["9",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]], 
         StyleBox["10",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]], 
         StyleBox["11",
          StripOnInput->False,
          FontWeight->Bold], 
         StyleBox["12",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]]},
        {
         StyleBox["13",
          StripOnInput->False,
          FontWeight->Bold], 
         StyleBox["14",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]], 
         StyleBox["15",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]], 
         StyleBox["16",
          StripOnInput->False,
          FrontFaceColor->GrayLevel[0.5],
          BackFaceColor->GrayLevel[0.5],
          GraphicsColor->GrayLevel[0.5],
          FontColor->GrayLevel[0.5]]}
       },
       ColumnsEqual->False,
       GridBoxAlignment->{"Columns" -> {{Right}}},
       GridBoxBackground->{"Columns" -> {{
            RGBColor[0.87, 0.94, 1]}}},
       GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       RowsEqual->False],
      "Grid"], "+", "5"}], ")"}], "3"], "//", "Expand"}]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[18]:=",
 CellID->797325433],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81u2zAMVv2X1v0Z0jTDbuseYvedttOuO2ynoBjQAhs2dL0vT5pn2Bt0
oiKlAkuZlCXbRZuijUPZ+viJFEVKST+v7q6//1zd3VytLj/drn5f31z9ufz4
61Y3lQdKHfxVSn14o/T7e/3O/MHPWv8p9V6/ftVN7+x1aa/N7q4qtbj5d69/
1Rd4KR3CvXrL3F8w96u9lixaSv3SaLHQV2g+1td6vV7XIOvrkZVLKx8juWFY
Fon4M2aUufFpKwFaocXSPe2067cnpk1D2bYGyS2SCwO4k/Wvfv8IhX6qZqxd
PRGeeFZgrz1Vnt3eb+yVwm7s3EpnLvXxOGyknpyGTX9/8TNmOu8NxS2HL8fi
1u1ZYArNpwjbrCfVTtZvMDu37uOewKoS5LNqcAZcxhufQb8oqzyZmiclkik2
voxZxUZWbj6HidE0NJ9wvVcJM28qQ3xfUitOxU1SZz4VbrK1EbQWNpoLm4Hh
Cs9VngxeKW17zMoXiy/NPrnwn//eba/lJWtp7byHOME7XNgRb5eR7Q+sXG4n
XGwedshdLI8S8bl4z41PWwmvrXgfEq5pYS1yayqZe6Nrf5wHhuTCWX9KLrSn
zhCWfJ/fxSi2BsH9h2HBVRvTsKD9AjOjInYR/ThUSOZiph1UOxcl42oPr/N9
z7c4RjXJsDsnjMUFzwwqf0zFZXxP4VOVcjOdpzAXPGvG9BTHJb+nzJpgy5Mq
W22QYqN+jCT12bSMwvnI1Y1uP+hOs/yZgu9zmb/ticvl8ly4W2uocnsxBbL+
K7RY22aQZ0677YVl99whYknuOTy5Rnq4/kchHl36toPzWgujeifbodOtDTNy
upeIV3bUPNbBMsWt9n3l+ZKUA9odDsbHFudwZhgnarTYE1g7vp86as7zsaPP
43M8CvANFfd49O652Ljvu37kGa2x8aPoWpKtLaPhjBgJabFAf9kpjWwFw0+9
Ej3FMRxnhDAik7fsTIBWyPGg3WWIiohyk7e1uLD57cLmPSfj/Hzq6aHwWgZP
lJcj+ndUkp4MCHOyullY/HPyrqg+zKBHVPUNoCd8OjeUxU4SsCWnZ3vLTGOZ
UMTBOc3Sw5fU/KHZTmFx60kKVniklbOWt3t63WljyUoSjypZN9JRw3YAjCXC
Pg9YvJ9N0jRI7JNXQ9hWtZfF5laOiYiu/pIoiOn//D+n22t5yVpMPOI4sOsA
xIPkxL2rv+SUPKY/PQp86je3q9kFsXrhFY47qcafPMZgcyfPObFlljm3Gvy8
1wj8jJmGcDh/98WRjc7Vb8tNSgWCOcpQuQybB1VmB7dXdNG0MBNmd5+wL2cD
HjF2/PGIcbHvfz/D3zv733yLtUIMdqw9UrD7W2bukDYPK80QVpLogVGZGn1A
fHgk/LlNYc9Z3Hx0magQREzL9Hffs73o0c98wcjqdR+xpNQLYLGuekEFrZRF
S2A07r/1vqlds4GZE23m3NKAnDgNFvEHkh+eXG+7H/wHjke62w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{383, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->597916097]
}, Open  ]],

Cell[TextData[{
 "Notice that the grid is still a grid, it is still blue, and the elements \
are still bold or gray as before. Also notice that having literal ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " in the expression interferes with what would have otherwise been adding a \
scalar to a matrix, and raising the result to a power. This distinction is \
very important, since you almost always want these composite structures to \
resist being interpreted automatically in some way. However, if you ever do \
you want to get rid of these wrappers and get at your data, that",
 " i",
 "s easy enough to do."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "//.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Grid", "[", 
      RowBox[{"a_", ",", "___"}], "]"}], "\[RuleDelayed]", "a"}], ",", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"a_", ",", "___"}], "]"}], "\[RuleDelayed]", "a"}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[19]:=",
 CellID->1289351844],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"216", ",", "343", ",", "512", ",", "729"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000", ",", "1331", ",", "1728", ",", "2197"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2744", ",", "3375", ",", "4096", ",", "4913"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5832", ",", "6859", ",", "8000", ",", "9261"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{349, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->2133597956]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Grid entries", "Section"],

Cell[TextData[{
 "To allow more flexible two-dimensional layout, ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " accepts a few special symbols like ",
 Cell[BoxData[
  ButtonBox["SpanFromLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromLeft"]], "InlineFormula"],
 " as entries. The entry ",
 Cell[BoxData[
  ButtonBox["SpanFromLeft",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromLeft"]], "InlineFormula"],
 " indicates that the grid entry immediately to the left should take up its \
own space and also the space of the spanning character. There are also ",
 Cell[BoxData[
  ButtonBox["SpanFromAbove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromAbove"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SpanFromBoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
 ". See \"",
 ButtonBox["Grids, Rows, and Columns",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 "\" for detailed information."
}], "Text",
 CellID->1402012358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "6", ",", "7", ",", "SpanFromLeft", ",", "SpanFromLeft", ",", "10"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
      "11", ",", "SpanFromAbove", ",", "SpanFromBoth", ",", "SpanFromBoth", 
       ",", "15"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"16", ",", "17", ",", "18", ",", "19", ",", "20"}], "}"}]}], 
    "}"}], ",", " ", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4", "5"},
    {"6", "7", "\[SpanFromLeft]", "\[SpanFromLeft]", "10"},
    {"11", "\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromBoth]", "15"},
    {"16", "17", "18", "19", "20"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{120, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "This approach can be used to create complicated spanning setups. Typing \
something like the following in as an input would take a long time. Luckily \
you can also create them interactively by using ",
 StyleBox[ButtonBox["Make Spanning",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/MakeSpanning"], "MenuName"],
 " and ",
 ButtonBox["Split Spanning",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SplitSpanning"],
 " in the ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Table/Matrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TableMatrix"], "MenuName"],
 " submenu. If you want to see what would be involved in typing this in, \
evaluate the cell which will show how it should be typed in input."
}], "Text"],

Cell[BoxData[
 RowBox[{
  TagBox[GridBox[{
     {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"},
     {"11", "12", "13", "\[SpanFromLeft]", "15", "16", "\[SpanFromLeft]", 
      "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"},
     {"21", "22", "\[SpanFromAbove]", "\[SpanFromBoth]", "25", 
      "\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromBoth]", 
      "\[SpanFromBoth]", "\[SpanFromBoth]"},
     {"31", "32", "33", "34", "35", "\[SpanFromAbove]", "\[SpanFromBoth]", 
      "\[SpanFromBoth]", "\[SpanFromBoth]", "\[SpanFromBoth]"},
     {"41", "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]", 
      "\[SpanFromLeft]", "\[SpanFromAbove]", "\[SpanFromBoth]", 
      "\[SpanFromBoth]", "\[SpanFromBoth]", "\[SpanFromBoth]"},
     {"51", "52", "53", "54", "55", "\[SpanFromAbove]", "\[SpanFromBoth]", 
      "\[SpanFromBoth]", "\[SpanFromBoth]", "\[SpanFromBoth]"},
     {"61", "62", "63", "\[SpanFromLeft]", "\[SpanFromLeft]", 
      "\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromBoth]", 
      "\[SpanFromBoth]", "\[SpanFromBoth]"},
     {"71", "72", "\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromBoth]", 
      "76", "77", "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"},
     {"81", "82", "\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromBoth]", 
      "86", "\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromBoth]", 
      "\[SpanFromBoth]"},
     {"91", "92", "\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromBoth]", 
      "96", "\[SpanFromAbove]", "\[SpanFromBoth]", "\[SpanFromBoth]", 
      "\[SpanFromBoth]"}
    },
    GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
   "Grid"], "//", "InputForm"}]], "Input",
 CellLabel->"In[18]:="],

Cell[TextData[{
 "We have already seen how to apply things like alignment and background to a \
grid as a whole, or to individual columns or rows. What we have not seen \
though is how to override that for an individual element. Say you want your \
whole grid to have the same background, except for a few, special elements. A \
convenient way to do that is to wrap each such element in ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ", and then specify options to ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " which override the corresponding option in ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PrimeQ", "[", "i", "]"}], ",", 
         RowBox[{"Item", "[", 
          RowBox[{"i", ",", " ", 
           RowBox[{"Background", " ", "\[Rule]", " ", "LightYellow"}]}], 
          "]"}], ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}], ",", "10"}], 
    "]"}], ",", " ", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", 
     ItemBox["2",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], 
     ItemBox["3",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "4", 
     ItemBox["5",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "6", 
     ItemBox["7",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "8", "9", "10"},
    {
     ItemBox["11",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "12", 
     ItemBox["13",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "14", "15", "16", 
     ItemBox["17",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "18", 
     ItemBox["19",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "20"},
    {"21", "22", 
     ItemBox["23",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "24", "25", "26", "27", "28", 
     ItemBox["29",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "30"},
    {
     ItemBox["31",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "32", "33", "34", "35", "36", 
     ItemBox["37",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "38", "39", "40"},
    {
     ItemBox["41",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "42", 
     ItemBox["43",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "44", "45", "46", 
     ItemBox["47",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "48", "49", "50"},
    {"51", "52", 
     ItemBox["53",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "54", "55", "56", "57", "58", 
     ItemBox["59",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "60"},
    {
     ItemBox["61",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "62", "63", "64", "65", "66", 
     ItemBox["67",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "68", "69", "70"},
    {
     ItemBox["71",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "72", 
     ItemBox["73",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "74", "75", "76", "77", "78", 
     ItemBox["79",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "80"},
    {"81", "82", 
     ItemBox["83",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "84", "85", "86", "87", "88", 
     ItemBox["89",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "90"},
    {"91", "92", "93", "94", "95", "96", 
     ItemBox["97",
      Background->RGBColor[1, 1, 0.85],
      StripOnInput->False], "98", "99", "100"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[0.87, 0.94, 1]}}}],
  "Grid"]], "Output",
 ImageSize->{223, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "You could override this option with ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " too, but the purpose of ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " is to override it in such a way that knows about the two dimensional \
layout of ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". Notice in the output above that whenever two of the yellow cells are next \
to each other, there is no blue space between them. That would be impossible \
to do with constructs other than ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 "."
}], "Text"],

Cell[TextData[{
 "The same thing goes for all of ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 "'s options, not just ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 ". Consider the ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " option. If you want no frame elements except around certain specified \
elements, you might think that you have to wrap them in their own ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " with the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " setting. (We",
 " wi",
 "ll learn a much easier way to add a frame around an arbitrary expression in \
the next section.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PrimeQ", "[", "i", "]"}], ",", 
        RowBox[{"Grid", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", "i", "}"}], "}"}], ",", 
          RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "i"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}], ",", "10"}], 
   "]"}], "]"}]], "Input"],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{265, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->56110742]
}, Open  ]],

Cell[TextData[{
 "But notice that adjacent framed elements do not share their boundaries. \
Compare that with using ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ", below, which has enough information to not draw more frame elements than \
are necessary. Notice now the frames of 2 and 11 meet at a single point, and \
how the frames of 2 and 3 share a single-pixel line, which in turn is \
perfectly aligned with the left frame of 13 and 23. That is the power of ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PrimeQ", "[", "i", "]"}], ",", 
        RowBox[{"Item", "[", 
         RowBox[{"i", ",", " ", 
          RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", "i"}],
        "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}], ",", "10"}], 
   "]"}], "]"}]], "Input"],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", 
     ItemBox["2",
      Frame->True,
      StripOnInput->False], 
     ItemBox["3",
      Frame->True,
      StripOnInput->False], "4", 
     ItemBox["5",
      Frame->True,
      StripOnInput->False], "6", 
     ItemBox["7",
      Frame->True,
      StripOnInput->False], "8", "9", "10"},
    {
     ItemBox["11",
      Frame->True,
      StripOnInput->False], "12", 
     ItemBox["13",
      Frame->True,
      StripOnInput->False], "14", "15", "16", 
     ItemBox["17",
      Frame->True,
      StripOnInput->False], "18", 
     ItemBox["19",
      Frame->True,
      StripOnInput->False], "20"},
    {"21", "22", 
     ItemBox["23",
      Frame->True,
      StripOnInput->False], "24", "25", "26", "27", "28", 
     ItemBox["29",
      Frame->True,
      StripOnInput->False], "30"},
    {
     ItemBox["31",
      Frame->True,
      StripOnInput->False], "32", "33", "34", "35", "36", 
     ItemBox["37",
      Frame->True,
      StripOnInput->False], "38", "39", "40"},
    {
     ItemBox["41",
      Frame->True,
      StripOnInput->False], "42", 
     ItemBox["43",
      Frame->True,
      StripOnInput->False], "44", "45", "46", 
     ItemBox["47",
      Frame->True,
      StripOnInput->False], "48", "49", "50"},
    {"51", "52", 
     ItemBox["53",
      Frame->True,
      StripOnInput->False], "54", "55", "56", "57", "58", 
     ItemBox["59",
      Frame->True,
      StripOnInput->False], "60"},
    {
     ItemBox["61",
      Frame->True,
      StripOnInput->False], "62", "63", "64", "65", "66", 
     ItemBox["67",
      Frame->True,
      StripOnInput->False], "68", "69", "70"},
    {
     ItemBox["71",
      Frame->True,
      StripOnInput->False], "72", 
     ItemBox["73",
      Frame->True,
      StripOnInput->False], "74", "75", "76", "77", "78", 
     ItemBox["79",
      Frame->True,
      StripOnInput->False], "80"},
    {"81", "82", 
     ItemBox["83",
      Frame->True,
      StripOnInput->False], "84", "85", "86", "87", "88", 
     ItemBox["89",
      Frame->True,
      StripOnInput->False], "90"},
    {"91", "92", "93", "94", "95", "96", 
     ItemBox["97",
      Frame->True,
      StripOnInput->False], "98", "99", "100"}
   }],
  "Grid"]], "Output",
 ImageSize->{237, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frames and labels", "Section"],

Cell[TextData[{
 "Adding a frame or a label to an expression can be done with ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", but conceptually these are much simpler operations than general \
two-dimensional layout, and so there are correspondingly simpler ways to get \
them. For instance, ",
 Cell[BoxData[
  ButtonBox["Framed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Framed"]], "InlineFormula"],
 " is a simple function for drawing a frame around an arbitrary expression. \
This can be useful to draw attention to parts of an expression, for \
instance."
}], "Text",
 CellID->1695183190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", "i", "]"}], ",", 
     RowBox[{"Framed", "[", 
      RowBox[{"i", ",", " ", 
       RowBox[{"Background", " ", "\[Rule]", " ", "LightYellow"}]}], "]"}], 
     ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FrameBox["2",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", 
   FrameBox["3",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "4", ",", 
   FrameBox["5",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "6", ",", 
   FrameBox["7",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "8", ",", "9", ",", "10", ",", 
   FrameBox["11",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "12", ",", 
   FrameBox["13",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "14", ",", "15", ",", "16", ",", 
   FrameBox["17",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "18", ",", 
   FrameBox["19",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "20", ",", "21", ",", "22", ",", 
   FrameBox["23",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "24", ",", "25", ",", "26", ",", "27", ",", 
   "28", ",", 
   FrameBox["29",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "30", ",", 
   FrameBox["31",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "32", ",", "33", ",", "34", ",", "35", ",", 
   "36", ",", 
   FrameBox["37",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "38", ",", "39", ",", "40", ",", 
   FrameBox["41",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "42", ",", 
   FrameBox["43",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "44", ",", "45", ",", "46", ",", 
   FrameBox["47",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "48", ",", "49", ",", "50", ",", "51", ",", 
   "52", ",", 
   FrameBox["53",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "54", ",", "55", ",", "56", ",", "57", ",", 
   "58", ",", 
   FrameBox["59",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "60", ",", 
   FrameBox["61",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "62", ",", "63", ",", "64", ",", "65", ",", 
   "66", ",", 
   FrameBox["67",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "68", ",", "69", ",", "70", ",", 
   FrameBox["71",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "72", ",", 
   FrameBox["73",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "74", ",", "75", ",", "76", ",", "77", ",", 
   "78", ",", 
   FrameBox["79",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "80", ",", "81", ",", "82", ",", 
   FrameBox["83",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "84", ",", "85", ",", "86", ",", "87", ",", 
   "88", ",", 
   FrameBox["89",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "90", ",", "91", ",", "92", ",", "93", ",", 
   "94", ",", "95", ",", "96", ",", 
   FrameBox["97",
    Background->RGBColor[1, 1, 0.85],
    StripOnInput->False], ",", "98", ",", "99", ",", "100"}], "}"}]], "Output",\

 ImageSize->{578, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Labeled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Labeled"]], "InlineFormula"],
 " is another such function, which allows labels to be placed at arbitrary \
locations around a given expression. Here we add a legend to the ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " example from the last section. (",
 Cell[BoxData[
  ButtonBox["Spacer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacer"]], "InlineFormula"],
 " is just a function that is designed to leave empty space.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Labeled", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"Partition", "[", 
      RowBox[{"ptable", ",", "10"}], "]"}], ",", " ", 
     RowBox[{"Alignment", " ", "\[Rule]", " ", "Right"}], ",", " ", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Text", "[", 
    RowBox[{"Row", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[Bullet] Prime\>\"", ",", "Bold"}], "]"}], ",", " ", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\[Bullet] Composite\>\"", ",", "Gray"}], "]"}]}], "}"}],
       ",", 
      RowBox[{"Spacer", "[", "15", "]"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[19]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXc1uGzcQXmtXa1uS7ViSg6KHICiKnppTgSIFCrin9tRD+wZGUCA5FC3S
PMA+Qvsgfage/BzsksuRhsPhz5JcWQoiIFqRy5/5IYcfZ0jn54cPb3/7/eHD
uzcPL396//Dn23dv/nr54x/v+6z6rKqqx/7fv59V/W/R/1L/HoXon3/333XX
db+q1D/yWyaF+lS/eHLv+++mb6jWT/WjGj5z+dXs0rIPM6f/vNA9N/o5009V
qlOf/sdM5tRDjqwt0zWpsatZ72pWM133O9XlDzIl6dLPWj9n+mnSOiPczBT/
wzv583P5Nd/JY+h0KMXnNrtcTS2W5ozkASM47WjF2+63BTh/QdqkdNWxdJ0T
ufD1tc7CvA1afa3HFfCWxqNsYSv2YxH3Mx+jUyPHJ6lhiDZsKzLjtcXdHHOj
aVdjx8+llTOeTzX/5gLNSPxmunFLdStLLRjNGWld587BZSv29gLzxXCMLAlY
G3ia9gm3Z9oa0Ms3hIqapL8k6e/ZVlr9/NqUn+75K7aN+/677euc67qvhGkn
ZaEvSM17VfNx7PdeIbqd//qvswlyQQtSCXLALhzpuX4u9fNcPy8d7400kjf7
vtuvWivdb03yW5b6NjAWrgQ3D2mpZXwpOsfTWgmWWgjTAl8nUUjnK33vWWGt
3Dkr/3OuRZTm6b4N0Lki6bb/eRVTx7liAPczbcTl8yZYg9JB+1wUl6fsoWEs
7TKQT+fBpc7n+86oheS3iuqj1k8qy3xZ1WxZVkdsi5Rzvq2ZtlGO2WeMH74v
sGR8K4BRYHQaqF/npbZr5x6XFuj4u8gohXuUabfMwtaYWrGVGKsbXoJjyh6X
pvL54cuW1JrL3vt2nqelQcBCYJeuhI2duHQr9nYM3jedG6tJgc0RVvO1P0P1
/VhtKgSbnwt0K76RXIy0XvlqvfIBn3VnYmafHjjEaJWr9vuuDdEPL9dp5nX6
zImz14ewKCX4BrRzx9agNkemy2ooxqqF1yKJoHmMU15bcdgqXgPAndKAF6+X
lz5XajokcPy6AN/0Wviwv3/1cllByr2yqozVtf18rnUK7z2cPTjsL+X8doTk
DoOUx43DqfFx+dHMrUDHpZUpVs+pEfFUK/FhtBWFgBmbMQoBdzYSdLW/Ie9P
DfniCI/0bHMewrnmG3xnsjr1xmH50RW57mzvnSs/5AnE9YBuGm9y64HGtWjv
7n0c9EXnsOWpJOk4D2HcTjHkjYxvBctgzZYaMyepVK85OlAadAcRAaUFIwLT
dra/MMPbHpJZtDceKM63YyGZcZ5oS2aHjFgUk6GyvEVk2KIWORlydGKbwY5T
A1dy9kEmr82SYlhLYvp3tWbEndGKuRb79ShVLjcBumBHGTN/Za+emI4hvXWM
PKIiNhMiP2LPlTce1sExSIlp5+PGexzH0+hojsay5Gje7aPDS/0e5jS8V2O5
GzxzUL5BacAJkAacswi0f+p4D/Ab4D3YAXvxbjfS04lsicsTCvJVPh0G37k9
nS7/3KRj/Ul9nNNxTPEAtdhjZ+o4SuOsVbykp/NxTqcBShmPxuP9nOMoLRml
PeTsmU4fsE5sM/XQIBsYOm0Ba5VxxsM6VwBvalQSqIWTGYD8fOVtrnJ5lT3C
iTi6V7jITGOZ7bQW2tFE7AHAf0rba1hZxJVKjU/A6IWdEefzsHvjPC3hUlhe
3PvQnsUlzyG/MhBhGoV8qTI7bvDcwQ4aIxFXGmanK6ZAkY9Ckgj5uNqXlh4j
zZNEkt3xxczjPIETnYVJ3gWedsyc8ghzLN+3mHa+9JnwezTKnCdl7TRKXwVb
oJ6XfCsXJS/Pe/DNGpLLOiN7SDkC8ioXZ4qNVat9B5kFYJGmj1svmd5d/hg3
DnRLYgzioiPwQpjYtDQiYUeLh55Lrj5r1ZrKcxIgiAbLSNNNHczSEOqaAvGV
QnX0lgP1fIdb8J+iV9rTth7SMF+wVw9OstOdmLG/6uz9FHgNl4H2AZOcMtZr
tE1pkUVTDHbqU+3kgvi+Frx9w5EPnF4J84YBfQ9pdGOsG/bqYcRHI27h2x8w
Ork4QVSsJ7zqRfUfT3HINj4TuesijADscWk7+87hQpfDZ5JaMmIkK5c6n9rB
C1Ie+qaWnaPFV+fC0d8mKFt+784hfOz3CWNtDjlgP87Tedo4yvy8pXjask51
NkN6eIljDmaL7ClIoy7epTLUWKjNLgP2y3yDb/eYPRp4aERrtiRTYsRu6WH8
5BxBLCcrUpNGNul7H3LbjSbLYsb0HD4/4y6VizvAF9EwsnTflINavvNFJWTK
rRixfT+VVLmzMvivVsCeFaQP7wHNXaHyDUobt1i0DOZaa7h92t9GmGjvFNHc
McWAnwsT5Xk8dg4/08cb+52OY7omqihQwjrMnjbi/fcjdpXHeuNbthDCmCPk
hGqFPHX5frWDyc86GVfIH0dQyqyzPWNLwdt+2/e2EuYqQFcJsGIYY7jKO9a7
COxW5gRf0slgtGbHnui7FUneYW8JbBnGjgpuTUg+wVcsguIuFXfihS2VHFnK
53gj0jVE560LC3BYY4oby3fCxHKnht0Ao9Hzika64s9DSn4vBXO+kUlzEUGr
nB6HTx11dXnCjwC9TcIrnLXJj66OjUa4Tn+4Tv+oHYYelfkxGdp66K6NuxVM
c6r/icoq9eQM58MQwnX2cpr7RiG9+28SQXQgVZJRf8MrQpI46mBRf2T3OuSa
6kaPZWL7lE7fneHjufPBUclJ8Cn+GsCn+75+jsvf/wA8oXZC3af7viXwY0u0
JG034EKMI9tqj+9ScGRb7c9PuN4Pwx8+GxFzJvL0b/GmUz/drV3uhjZdhUN4
pe3sG+DpskyXEtBYMuoQi0KeCs+lSwvw2yaqVpq0OISJYzbs6LP8dbRE3fFY
bhfl8eiDRo+4k145NyNCEuE07aPXF/nbScyDmjm0mDZeXdLKQWRNxUdN3ZTg
E3ohe54rOw5XxfYdpr48aqJjD3zXsHrTiCm8Pxd71ATlG5SGCCCNmC4D7Z86
agLv163md635gr+Lfkv43Gr+IQ0nNOLwDR1B4HXfMqON3p+9Ycrw42kjfEhi
S9rNuRlK+Vnrnp/rp6Sv1dJJpZfKgcYbc+iFnu+89G29b/3Uw19Ty1mBKdVA
D4xV+4TbICN7rMCprF1tPYL9kYFcemGU0/UX5hG234rKysZ3eEQ5vBUH54GT
MscPN5vXDg0dgjew6cqzD7YMZgGyhWDjDNuoxzI88dqQZvuH/w/hcRDr2f87
4WyO\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{229, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->176119593]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 " is yet another framing construct, which uses the underlying operating \
system's panel frame. This is different from ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 ", as different operating systems might use a drop shadow, rounded corners, \
or fancier graphic design elements for a panel frame."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", "%", "]"}]], "Input",
 CellLabel->"In[20]:="],

Cell[BoxData[
 PanelBox[
  InterpretationBox[GridBox[{
     {
      TagBox[
       TagBox[
        TagBox[GridBox[{
           {
            StyleBox["1",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["2",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["3",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["4",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["5",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["6",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["7",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["8",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["9",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["10",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["11",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["12",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["13",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["14",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["15",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["16",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["17",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["18",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["19",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["20",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["21",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["22",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["23",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["24",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["25",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["26",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["27",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["28",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["29",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["30",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["31",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["32",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["33",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["34",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["35",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["36",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["37",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["38",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["39",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["40",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["41",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["42",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["43",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["44",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["45",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["46",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["47",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["48",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["49",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["50",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["51",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["52",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["53",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["54",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["55",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["56",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["57",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["58",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["59",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["60",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["61",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["62",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["63",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["64",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["65",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["66",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["67",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["68",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["69",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["70",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["71",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["72",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["73",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["74",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["75",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["76",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["77",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["78",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["79",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["80",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["81",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["82",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["83",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["84",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["85",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["86",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["87",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["88",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["89",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["90",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]},
           {
            StyleBox["91",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["92",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["93",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["94",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["95",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["96",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["97",
             StripOnInput->False,
             FontWeight->Bold], 
            StyleBox["98",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["99",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]], 
            StyleBox["100",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0.5],
             BackFaceColor->GrayLevel[0.5],
             GraphicsColor->GrayLevel[0.5],
             FontColor->GrayLevel[0.5]]}
          },
          ColumnsEqual->False,
          GridBoxAlignment->{"Columns" -> {{Right}}},
          GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          RowsEqual->False],
         "Grid"],
        "Labeled",
        Editable->True,
        Selectable->True],
       "SkipImageSizeLevel"]},
     {
      TagBox[
       InterpretationBox[Cell[BoxData[
         InterpretationBox[
          RowBox[{
           StyleBox["\<\"\[Bullet] Prime\"\>",
            StripOnInput->False,
            FontWeight->Bold], 
           InterpretationBox[
            StyleBox[
             GraphicsBox[{},
              BaselinePosition->Baseline,
              ImageSize->{15, 0}],
             CacheGraphics->False],
            Spacer[15]], 
           StyleBox["\<\"\[Bullet] Composite\"\>",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0.5],
            BackFaceColor->GrayLevel[0.5],
            GraphicsColor->GrayLevel[0.5],
            FontColor->GrayLevel[0.5]]}],
          Row[{
            Style["\[Bullet] Prime", Bold], 
            Style["\[Bullet] Composite", 
             GrayLevel[0.5]]}, 
           Spacer[15]]]], "Text", "TR"],
        Text[
         Row[{
           Style["\[Bullet] Prime", Bold], 
           Style["\[Bullet] Composite", 
            GrayLevel[0.5]]}, 
          Spacer[15]]]],
       "Labeled",
       Editable->True,
       Selectable->True]}
    },
    BaselinePosition->{1, 1},
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxItemSize->{
     "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
      "RowsIndexed" -> {}}],
   Labeled[
    Grid[{{
       Style[1, 
        GrayLevel[0.5]], 
       Style[2, Bold], 
       Style[3, Bold], 
       Style[4, 
        GrayLevel[0.5]], 
       Style[5, Bold], 
       Style[6, 
        GrayLevel[0.5]], 
       Style[7, Bold], 
       Style[8, 
        GrayLevel[0.5]], 
       Style[9, 
        GrayLevel[0.5]], 
       Style[10, 
        GrayLevel[0.5]]}, {
       Style[11, Bold], 
       Style[12, 
        GrayLevel[0.5]], 
       Style[13, Bold], 
       Style[14, 
        GrayLevel[0.5]], 
       Style[15, 
        GrayLevel[0.5]], 
       Style[16, 
        GrayLevel[0.5]], 
       Style[17, Bold], 
       Style[18, 
        GrayLevel[0.5]], 
       Style[19, Bold], 
       Style[20, 
        GrayLevel[0.5]]}, {
       Style[21, 
        GrayLevel[0.5]], 
       Style[22, 
        GrayLevel[0.5]], 
       Style[23, Bold], 
       Style[24, 
        GrayLevel[0.5]], 
       Style[25, 
        GrayLevel[0.5]], 
       Style[26, 
        GrayLevel[0.5]], 
       Style[27, 
        GrayLevel[0.5]], 
       Style[28, 
        GrayLevel[0.5]], 
       Style[29, Bold], 
       Style[30, 
        GrayLevel[0.5]]}, {
       Style[31, Bold], 
       Style[32, 
        GrayLevel[0.5]], 
       Style[33, 
        GrayLevel[0.5]], 
       Style[34, 
        GrayLevel[0.5]], 
       Style[35, 
        GrayLevel[0.5]], 
       Style[36, 
        GrayLevel[0.5]], 
       Style[37, Bold], 
       Style[38, 
        GrayLevel[0.5]], 
       Style[39, 
        GrayLevel[0.5]], 
       Style[40, 
        GrayLevel[0.5]]}, {
       Style[41, Bold], 
       Style[42, 
        GrayLevel[0.5]], 
       Style[43, Bold], 
       Style[44, 
        GrayLevel[0.5]], 
       Style[45, 
        GrayLevel[0.5]], 
       Style[46, 
        GrayLevel[0.5]], 
       Style[47, Bold], 
       Style[48, 
        GrayLevel[0.5]], 
       Style[49, 
        GrayLevel[0.5]], 
       Style[50, 
        GrayLevel[0.5]]}, {
       Style[51, 
        GrayLevel[0.5]], 
       Style[52, 
        GrayLevel[0.5]], 
       Style[53, Bold], 
       Style[54, 
        GrayLevel[0.5]], 
       Style[55, 
        GrayLevel[0.5]], 
       Style[56, 
        GrayLevel[0.5]], 
       Style[57, 
        GrayLevel[0.5]], 
       Style[58, 
        GrayLevel[0.5]], 
       Style[59, Bold], 
       Style[60, 
        GrayLevel[0.5]]}, {
       Style[61, Bold], 
       Style[62, 
        GrayLevel[0.5]], 
       Style[63, 
        GrayLevel[0.5]], 
       Style[64, 
        GrayLevel[0.5]], 
       Style[65, 
        GrayLevel[0.5]], 
       Style[66, 
        GrayLevel[0.5]], 
       Style[67, Bold], 
       Style[68, 
        GrayLevel[0.5]], 
       Style[69, 
        GrayLevel[0.5]], 
       Style[70, 
        GrayLevel[0.5]]}, {
       Style[71, Bold], 
       Style[72, 
        GrayLevel[0.5]], 
       Style[73, Bold], 
       Style[74, 
        GrayLevel[0.5]], 
       Style[75, 
        GrayLevel[0.5]], 
       Style[76, 
        GrayLevel[0.5]], 
       Style[77, 
        GrayLevel[0.5]], 
       Style[78, 
        GrayLevel[0.5]], 
       Style[79, Bold], 
       Style[80, 
        GrayLevel[0.5]]}, {
       Style[81, 
        GrayLevel[0.5]], 
       Style[82, 
        GrayLevel[0.5]], 
       Style[83, Bold], 
       Style[84, 
        GrayLevel[0.5]], 
       Style[85, 
        GrayLevel[0.5]], 
       Style[86, 
        GrayLevel[0.5]], 
       Style[87, 
        GrayLevel[0.5]], 
       Style[88, 
        GrayLevel[0.5]], 
       Style[89, Bold], 
       Style[90, 
        GrayLevel[0.5]]}, {
       Style[91, 
        GrayLevel[0.5]], 
       Style[92, 
        GrayLevel[0.5]], 
       Style[93, 
        GrayLevel[0.5]], 
       Style[94, 
        GrayLevel[0.5]], 
       Style[95, 
        GrayLevel[0.5]], 
       Style[96, 
        GrayLevel[0.5]], 
       Style[97, Bold], 
       Style[98, 
        GrayLevel[0.5]], 
       Style[99, 
        GrayLevel[0.5]], 
       Style[100, 
        GrayLevel[0.5]]}}, Alignment -> Right, Frame -> True], 
    Text[
     Row[{
       Style["\[Bullet] Prime", Bold], 
       Style["\[Bullet] Composite", 
        GrayLevel[0.5]]}, 
      Spacer[15]]]],
   Editable->False,
   Selectable->False]]], "Output",
 ImageSize->{242, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->1563182549]
}, Open  ]],

Cell[TextData[{
 "Note that ",
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 " has its own concept of font family and size as well, so the ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 "'s contents change font family and size, and the ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " changes font size. (",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " has its own opinion about font family though, and so it remains in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s text font.) We",
 " wi",
 "ll talk about this in some detail below in the section on the ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " option."
}], "Text"],

Cell[TextData[{
 "Finally, we should point out that ",
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 " itself has an optional second argument to specify one or more labels, \
which are automatically positioned outside the panel, and an optional third \
argument to give details of that position. See the documentation for ",
 Cell[BoxData[
  ButtonBox["Panel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Panel"]], "InlineFormula"],
 " for more detail."
}], "Text",
 CellID->278329581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{"ptable", ",", " ", "\"\<Primes and Composites\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->665884701],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     ItemBox[
      TagBox[
       StyleBox["\<\"Primes and Composites\"\>", "Panel",
        StripOnInput->False,
        Background->None],
       "Labeled",
       Editable->True,
       Selectable->True],
      Alignment->{Left, Inherited}]},
    {
     TagBox[
      TagBox[
       PanelBox[
        RowBox[{"{", 
         RowBox[{
          StyleBox["1",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["2",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["3",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["4",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["5",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["6",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["7",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["8",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["9",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["10",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["11",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["12",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["13",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["14",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["15",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["16",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["17",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["18",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["19",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["20",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["21",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["22",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["23",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["24",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["25",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["26",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["27",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["28",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["29",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["30",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["31",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["32",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["33",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["34",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["35",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["36",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["37",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["38",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["39",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["40",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["41",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["42",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["43",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["44",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["45",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["46",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["47",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["48",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["49",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["50",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["51",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["52",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["53",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["54",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["55",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["56",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["57",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["58",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["59",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["60",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["61",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["62",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["63",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["64",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["65",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["66",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["67",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["68",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["69",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["70",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["71",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["72",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["73",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["74",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["75",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["76",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["77",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["78",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["79",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["80",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["81",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["82",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["83",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["84",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["85",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["86",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["87",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["88",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["89",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["90",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["91",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["92",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["93",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["94",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["95",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["96",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["97",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["98",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["99",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["100",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]]}], "}"}]],
       "Labeled",
       Editable->True,
       Selectable->True],
      "SkipImageSizeLevel"]}
   },
   BaselinePosition->{2, 1},
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Panel[{
     Style[1, 
      GrayLevel[0.5]], 
     Style[2, Bold], 
     Style[3, Bold], 
     Style[4, 
      GrayLevel[0.5]], 
     Style[5, Bold], 
     Style[6, 
      GrayLevel[0.5]], 
     Style[7, Bold], 
     Style[8, 
      GrayLevel[0.5]], 
     Style[9, 
      GrayLevel[0.5]], 
     Style[10, 
      GrayLevel[0.5]], 
     Style[11, Bold], 
     Style[12, 
      GrayLevel[0.5]], 
     Style[13, Bold], 
     Style[14, 
      GrayLevel[0.5]], 
     Style[15, 
      GrayLevel[0.5]], 
     Style[16, 
      GrayLevel[0.5]], 
     Style[17, Bold], 
     Style[18, 
      GrayLevel[0.5]], 
     Style[19, Bold], 
     Style[20, 
      GrayLevel[0.5]], 
     Style[21, 
      GrayLevel[0.5]], 
     Style[22, 
      GrayLevel[0.5]], 
     Style[23, Bold], 
     Style[24, 
      GrayLevel[0.5]], 
     Style[25, 
      GrayLevel[0.5]], 
     Style[26, 
      GrayLevel[0.5]], 
     Style[27, 
      GrayLevel[0.5]], 
     Style[28, 
      GrayLevel[0.5]], 
     Style[29, Bold], 
     Style[30, 
      GrayLevel[0.5]], 
     Style[31, Bold], 
     Style[32, 
      GrayLevel[0.5]], 
     Style[33, 
      GrayLevel[0.5]], 
     Style[34, 
      GrayLevel[0.5]], 
     Style[35, 
      GrayLevel[0.5]], 
     Style[36, 
      GrayLevel[0.5]], 
     Style[37, Bold], 
     Style[38, 
      GrayLevel[0.5]], 
     Style[39, 
      GrayLevel[0.5]], 
     Style[40, 
      GrayLevel[0.5]], 
     Style[41, Bold], 
     Style[42, 
      GrayLevel[0.5]], 
     Style[43, Bold], 
     Style[44, 
      GrayLevel[0.5]], 
     Style[45, 
      GrayLevel[0.5]], 
     Style[46, 
      GrayLevel[0.5]], 
     Style[47, Bold], 
     Style[48, 
      GrayLevel[0.5]], 
     Style[49, 
      GrayLevel[0.5]], 
     Style[50, 
      GrayLevel[0.5]], 
     Style[51, 
      GrayLevel[0.5]], 
     Style[52, 
      GrayLevel[0.5]], 
     Style[53, Bold], 
     Style[54, 
      GrayLevel[0.5]], 
     Style[55, 
      GrayLevel[0.5]], 
     Style[56, 
      GrayLevel[0.5]], 
     Style[57, 
      GrayLevel[0.5]], 
     Style[58, 
      GrayLevel[0.5]], 
     Style[59, Bold], 
     Style[60, 
      GrayLevel[0.5]], 
     Style[61, Bold], 
     Style[62, 
      GrayLevel[0.5]], 
     Style[63, 
      GrayLevel[0.5]], 
     Style[64, 
      GrayLevel[0.5]], 
     Style[65, 
      GrayLevel[0.5]], 
     Style[66, 
      GrayLevel[0.5]], 
     Style[67, Bold], 
     Style[68, 
      GrayLevel[0.5]], 
     Style[69, 
      GrayLevel[0.5]], 
     Style[70, 
      GrayLevel[0.5]], 
     Style[71, Bold], 
     Style[72, 
      GrayLevel[0.5]], 
     Style[73, Bold], 
     Style[74, 
      GrayLevel[0.5]], 
     Style[75, 
      GrayLevel[0.5]], 
     Style[76, 
      GrayLevel[0.5]], 
     Style[77, 
      GrayLevel[0.5]], 
     Style[78, 
      GrayLevel[0.5]], 
     Style[79, Bold], 
     Style[80, 
      GrayLevel[0.5]], 
     Style[81, 
      GrayLevel[0.5]], 
     Style[82, 
      GrayLevel[0.5]], 
     Style[83, Bold], 
     Style[84, 
      GrayLevel[0.5]], 
     Style[85, 
      GrayLevel[0.5]], 
     Style[86, 
      GrayLevel[0.5]], 
     Style[87, 
      GrayLevel[0.5]], 
     Style[88, 
      GrayLevel[0.5]], 
     Style[89, Bold], 
     Style[90, 
      GrayLevel[0.5]], 
     Style[91, 
      GrayLevel[0.5]], 
     Style[92, 
      GrayLevel[0.5]], 
     Style[93, 
      GrayLevel[0.5]], 
     Style[94, 
      GrayLevel[0.5]], 
     Style[95, 
      GrayLevel[0.5]], 
     Style[96, 
      GrayLevel[0.5]], 
     Style[97, Bold], 
     Style[98, 
      GrayLevel[0.5]], 
     Style[99, 
      GrayLevel[0.5]], 
     Style[100, 
      GrayLevel[0.5]]}], {
    Style["Primes and Composites", "Panel", Background -> None]}, {{
    Top, Left}}],
  Editable->False,
  Selectable->False]], "Output",
 ImageSize->{511, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->483458495]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{"ptable", ",", " ", 
   RowBox[{"{", "\"\<Primes and Composites\>\"", "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"Bottom", ",", "Right"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->1160461756],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     TagBox[
      TagBox[
       PanelBox[
        RowBox[{"{", 
         RowBox[{
          StyleBox["1",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["2",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["3",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["4",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["5",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["6",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["7",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["8",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["9",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["10",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["11",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["12",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["13",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["14",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["15",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["16",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["17",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["18",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["19",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["20",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["21",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["22",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["23",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["24",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["25",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["26",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["27",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["28",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["29",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["30",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["31",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["32",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["33",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["34",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["35",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["36",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["37",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["38",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["39",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["40",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["41",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["42",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["43",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["44",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["45",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["46",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["47",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["48",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["49",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["50",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["51",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["52",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["53",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["54",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["55",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["56",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["57",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["58",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["59",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["60",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["61",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["62",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["63",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["64",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["65",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["66",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["67",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["68",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["69",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["70",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["71",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["72",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["73",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["74",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["75",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["76",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["77",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["78",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["79",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["80",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["81",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["82",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["83",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["84",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["85",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["86",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["87",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["88",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["89",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["90",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["91",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["92",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["93",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["94",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["95",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["96",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["97",
           StripOnInput->False,
           FontWeight->Bold], ",", 
          StyleBox["98",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["99",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]], ",", 
          StyleBox["100",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0.5],
           BackFaceColor->GrayLevel[0.5],
           GraphicsColor->GrayLevel[0.5],
           FontColor->GrayLevel[0.5]]}], "}"}]],
       "Labeled",
       Editable->True,
       Selectable->True],
      "SkipImageSizeLevel"]},
    {
     ItemBox[
      TagBox[
       StyleBox["\<\"Primes and Composites\"\>", "Panel",
        StripOnInput->False,
        Background->None],
       "Labeled",
       Editable->True,
       Selectable->True],
      Alignment->{Right, Inherited}]}
   },
   BaselinePosition->{1, 1},
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}}],
  Labeled[
   Panel[{
     Style[1, 
      GrayLevel[0.5]], 
     Style[2, Bold], 
     Style[3, Bold], 
     Style[4, 
      GrayLevel[0.5]], 
     Style[5, Bold], 
     Style[6, 
      GrayLevel[0.5]], 
     Style[7, Bold], 
     Style[8, 
      GrayLevel[0.5]], 
     Style[9, 
      GrayLevel[0.5]], 
     Style[10, 
      GrayLevel[0.5]], 
     Style[11, Bold], 
     Style[12, 
      GrayLevel[0.5]], 
     Style[13, Bold], 
     Style[14, 
      GrayLevel[0.5]], 
     Style[15, 
      GrayLevel[0.5]], 
     Style[16, 
      GrayLevel[0.5]], 
     Style[17, Bold], 
     Style[18, 
      GrayLevel[0.5]], 
     Style[19, Bold], 
     Style[20, 
      GrayLevel[0.5]], 
     Style[21, 
      GrayLevel[0.5]], 
     Style[22, 
      GrayLevel[0.5]], 
     Style[23, Bold], 
     Style[24, 
      GrayLevel[0.5]], 
     Style[25, 
      GrayLevel[0.5]], 
     Style[26, 
      GrayLevel[0.5]], 
     Style[27, 
      GrayLevel[0.5]], 
     Style[28, 
      GrayLevel[0.5]], 
     Style[29, Bold], 
     Style[30, 
      GrayLevel[0.5]], 
     Style[31, Bold], 
     Style[32, 
      GrayLevel[0.5]], 
     Style[33, 
      GrayLevel[0.5]], 
     Style[34, 
      GrayLevel[0.5]], 
     Style[35, 
      GrayLevel[0.5]], 
     Style[36, 
      GrayLevel[0.5]], 
     Style[37, Bold], 
     Style[38, 
      GrayLevel[0.5]], 
     Style[39, 
      GrayLevel[0.5]], 
     Style[40, 
      GrayLevel[0.5]], 
     Style[41, Bold], 
     Style[42, 
      GrayLevel[0.5]], 
     Style[43, Bold], 
     Style[44, 
      GrayLevel[0.5]], 
     Style[45, 
      GrayLevel[0.5]], 
     Style[46, 
      GrayLevel[0.5]], 
     Style[47, Bold], 
     Style[48, 
      GrayLevel[0.5]], 
     Style[49, 
      GrayLevel[0.5]], 
     Style[50, 
      GrayLevel[0.5]], 
     Style[51, 
      GrayLevel[0.5]], 
     Style[52, 
      GrayLevel[0.5]], 
     Style[53, Bold], 
     Style[54, 
      GrayLevel[0.5]], 
     Style[55, 
      GrayLevel[0.5]], 
     Style[56, 
      GrayLevel[0.5]], 
     Style[57, 
      GrayLevel[0.5]], 
     Style[58, 
      GrayLevel[0.5]], 
     Style[59, Bold], 
     Style[60, 
      GrayLevel[0.5]], 
     Style[61, Bold], 
     Style[62, 
      GrayLevel[0.5]], 
     Style[63, 
      GrayLevel[0.5]], 
     Style[64, 
      GrayLevel[0.5]], 
     Style[65, 
      GrayLevel[0.5]], 
     Style[66, 
      GrayLevel[0.5]], 
     Style[67, Bold], 
     Style[68, 
      GrayLevel[0.5]], 
     Style[69, 
      GrayLevel[0.5]], 
     Style[70, 
      GrayLevel[0.5]], 
     Style[71, Bold], 
     Style[72, 
      GrayLevel[0.5]], 
     Style[73, Bold], 
     Style[74, 
      GrayLevel[0.5]], 
     Style[75, 
      GrayLevel[0.5]], 
     Style[76, 
      GrayLevel[0.5]], 
     Style[77, 
      GrayLevel[0.5]], 
     Style[78, 
      GrayLevel[0.5]], 
     Style[79, Bold], 
     Style[80, 
      GrayLevel[0.5]], 
     Style[81, 
      GrayLevel[0.5]], 
     Style[82, 
      GrayLevel[0.5]], 
     Style[83, Bold], 
     Style[84, 
      GrayLevel[0.5]], 
     Style[85, 
      GrayLevel[0.5]], 
     Style[86, 
      GrayLevel[0.5]], 
     Style[87, 
      GrayLevel[0.5]], 
     Style[88, 
      GrayLevel[0.5]], 
     Style[89, Bold], 
     Style[90, 
      GrayLevel[0.5]], 
     Style[91, 
      GrayLevel[0.5]], 
     Style[92, 
      GrayLevel[0.5]], 
     Style[93, 
      GrayLevel[0.5]], 
     Style[94, 
      GrayLevel[0.5]], 
     Style[95, 
      GrayLevel[0.5]], 
     Style[96, 
      GrayLevel[0.5]], 
     Style[97, Bold], 
     Style[98, 
      GrayLevel[0.5]], 
     Style[99, 
      GrayLevel[0.5]], 
     Style[100, 
      GrayLevel[0.5]]}], {
    Style["Primes and Composites", "Panel", Background -> None]}, {{
    Bottom, Right}}],
  Editable->False,
  Selectable->False]], "Output",
 ImageSize->{511, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->1556288864]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other annotations", "Section"],

Cell[TextData[{
 "The annotations mentioned so far have a very definite visual component. \
There are a number of annotations which are effectively invisible, until the \
user needs it. ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for example does not change the display of its first argument, and it",
 " i",
 "s only when you move the mouse pointer over that display is the second \
argument shown, as a tooltip."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{"i", ",", 
     RowBox[{"Divisors", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    TooltipBox["1",
     RowBox[{"{", "1", "}"}]],
    Annotation[#, {1}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["2",
     RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]],
    Annotation[#, {1, 2}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["3",
     RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}]],
    Annotation[#, {1, 3}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["4",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4"}], "}"}]],
    Annotation[#, {1, 2, 4}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["5",
     RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}]],
    Annotation[#, {1, 5}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["6",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "6"}], "}"}]],
    Annotation[#, {1, 2, 3, 6}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["7",
     RowBox[{"{", 
       RowBox[{"1", ",", "7"}], "}"}]],
    Annotation[#, {1, 7}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["8",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "8"}], "}"}]],
    Annotation[#, {1, 2, 4, 8}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["9",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "9"}], "}"}]],
    Annotation[#, {1, 3, 9}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["10",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "5", ",", "10"}], "}"}]],
    Annotation[#, {1, 2, 5, 10}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["11",
     RowBox[{"{", 
       RowBox[{"1", ",", "11"}], "}"}]],
    Annotation[#, {1, 11}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["12",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "12"}], 
       "}"}]],
    Annotation[#, {1, 2, 3, 4, 6, 12}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["13",
     RowBox[{"{", 
       RowBox[{"1", ",", "13"}], "}"}]],
    Annotation[#, {1, 13}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["14",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "7", ",", "14"}], "}"}]],
    Annotation[#, {1, 2, 7, 14}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["15",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "5", ",", "15"}], "}"}]],
    Annotation[#, {1, 3, 5, 15}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["16",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16"}], "}"}]],
    Annotation[#, {1, 2, 4, 8, 16}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["17",
     RowBox[{"{", 
       RowBox[{"1", ",", "17"}], "}"}]],
    Annotation[#, {1, 17}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["18",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "6", ",", "9", ",", "18"}], 
       "}"}]],
    Annotation[#, {1, 2, 3, 6, 9, 18}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["19",
     RowBox[{"{", 
       RowBox[{"1", ",", "19"}], "}"}]],
    Annotation[#, {1, 19}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["20",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "10", ",", "20"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 5, 10, 20}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["21",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "7", ",", "21"}], "}"}]],
    Annotation[#, {1, 3, 7, 21}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["22",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "11", ",", "22"}], "}"}]],
    Annotation[#, {1, 2, 11, 22}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["23",
     RowBox[{"{", 
       RowBox[{"1", ",", "23"}], "}"}]],
    Annotation[#, {1, 23}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["24",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "12", ",",
          "24"}], "}"}]],
    Annotation[#, {1, 2, 3, 4, 6, 8, 12, 24}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["25",
     RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "25"}], "}"}]],
    Annotation[#, {1, 5, 25}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["26",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "13", ",", "26"}], "}"}]],
    Annotation[#, {1, 2, 13, 26}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["27",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "9", ",", "27"}], "}"}]],
    Annotation[#, {1, 3, 9, 27}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["28",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "7", ",", "14", ",", "28"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 7, 14, 28}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["29",
     RowBox[{"{", 
       RowBox[{"1", ",", "29"}], "}"}]],
    Annotation[#, {1, 29}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["30",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "10", ",", "15", 
         ",", "30"}], "}"}]],
    Annotation[#, {1, 2, 3, 5, 6, 10, 15, 30}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["31",
     RowBox[{"{", 
       RowBox[{"1", ",", "31"}], "}"}]],
    Annotation[#, {1, 31}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["32",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 8, 16, 32}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["33",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "11", ",", "33"}], "}"}]],
    Annotation[#, {1, 3, 11, 33}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["34",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "17", ",", "34"}], "}"}]],
    Annotation[#, {1, 2, 17, 34}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["35",
     RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "7", ",", "35"}], "}"}]],
    Annotation[#, {1, 5, 7, 35}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["36",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "9", ",", "12", ",",
          "18", ",", "36"}], "}"}]],
    Annotation[#, {1, 2, 3, 4, 6, 9, 12, 18, 36}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["37",
     RowBox[{"{", 
       RowBox[{"1", ",", "37"}], "}"}]],
    Annotation[#, {1, 37}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["38",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "19", ",", "38"}], "}"}]],
    Annotation[#, {1, 2, 19, 38}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["39",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "13", ",", "39"}], "}"}]],
    Annotation[#, {1, 3, 13, 39}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["40",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "4", ",", "5", ",", "8", ",", "10", ",", "20", 
         ",", "40"}], "}"}]],
    Annotation[#, {1, 2, 4, 5, 8, 10, 20, 40}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["41",
     RowBox[{"{", 
       RowBox[{"1", ",", "41"}], "}"}]],
    Annotation[#, {1, 41}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["42",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "6", ",", "7", ",", "14", ",", "21", 
         ",", "42"}], "}"}]],
    Annotation[#, {1, 2, 3, 6, 7, 14, 21, 42}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["43",
     RowBox[{"{", 
       RowBox[{"1", ",", "43"}], "}"}]],
    Annotation[#, {1, 43}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["44",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "11", ",", "22", ",", "44"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 11, 22, 44}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["45",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "5", ",", "9", ",", "15", ",", "45"}], 
       "}"}]],
    Annotation[#, {1, 3, 5, 9, 15, 45}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["46",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "23", ",", "46"}], "}"}]],
    Annotation[#, {1, 2, 23, 46}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["47",
     RowBox[{"{", 
       RowBox[{"1", ",", "47"}], "}"}]],
    Annotation[#, {1, 47}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["48",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "12", ",",
          "16", ",", "24", ",", "48"}], "}"}]],
    Annotation[#, {1, 2, 3, 4, 6, 8, 12, 16, 24, 48}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["49",
     RowBox[{"{", 
       RowBox[{"1", ",", "7", ",", "49"}], "}"}]],
    Annotation[#, {1, 7, 49}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["50",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "5", ",", "10", ",", "25", ",", "50"}], 
       "}"}]],
    Annotation[#, {1, 2, 5, 10, 25, 50}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["51",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "17", ",", "51"}], "}"}]],
    Annotation[#, {1, 3, 17, 51}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["52",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "13", ",", "26", ",", "52"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 13, 26, 52}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["53",
     RowBox[{"{", 
       RowBox[{"1", ",", "53"}], "}"}]],
    Annotation[#, {1, 53}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["54",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "6", ",", "9", ",", "18", ",", "27", 
         ",", "54"}], "}"}]],
    Annotation[#, {1, 2, 3, 6, 9, 18, 27, 54}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["55",
     RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "11", ",", "55"}], "}"}]],
    Annotation[#, {1, 5, 11, 55}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["56",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "4", ",", "7", ",", "8", ",", "14", ",", "28", 
         ",", "56"}], "}"}]],
    Annotation[#, {1, 2, 4, 7, 8, 14, 28, 56}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["57",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "19", ",", "57"}], "}"}]],
    Annotation[#, {1, 3, 19, 57}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["58",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "29", ",", "58"}], "}"}]],
    Annotation[#, {1, 2, 29, 58}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["59",
     RowBox[{"{", 
       RowBox[{"1", ",", "59"}], "}"}]],
    Annotation[#, {1, 59}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["60",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "10", ",",
          "12", ",", "15", ",", "20", ",", "30", ",", "60"}], "}"}]],
    Annotation[#, {1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30, 60}, "Tooltip"]& ], 
   ",", 
   TagBox[
    TooltipBox["61",
     RowBox[{"{", 
       RowBox[{"1", ",", "61"}], "}"}]],
    Annotation[#, {1, 61}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["62",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "31", ",", "62"}], "}"}]],
    Annotation[#, {1, 2, 31, 62}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["63",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "7", ",", "9", ",", "21", ",", "63"}], 
       "}"}]],
    Annotation[#, {1, 3, 7, 9, 21, 63}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["64",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 8, 16, 32, 64}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["65",
     RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "13", ",", "65"}], "}"}]],
    Annotation[#, {1, 5, 13, 65}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["66",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "6", ",", "11", ",", "22", ",", "33", 
         ",", "66"}], "}"}]],
    Annotation[#, {1, 2, 3, 6, 11, 22, 33, 66}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["67",
     RowBox[{"{", 
       RowBox[{"1", ",", "67"}], "}"}]],
    Annotation[#, {1, 67}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["68",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "17", ",", "34", ",", "68"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 17, 34, 68}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["69",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "23", ",", "69"}], "}"}]],
    Annotation[#, {1, 3, 23, 69}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["70",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "5", ",", "7", ",", "10", ",", "14", ",", "35", 
         ",", "70"}], "}"}]],
    Annotation[#, {1, 2, 5, 7, 10, 14, 35, 70}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["71",
     RowBox[{"{", 
       RowBox[{"1", ",", "71"}], "}"}]],
    Annotation[#, {1, 71}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["72",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "9", ",", 
         "12", ",", "18", ",", "24", ",", "36", ",", "72"}], "}"}]],
    Annotation[#, {1, 2, 3, 4, 6, 8, 9, 12, 18, 24, 36, 72}, "Tooltip"]& ], 
   ",", 
   TagBox[
    TooltipBox["73",
     RowBox[{"{", 
       RowBox[{"1", ",", "73"}], "}"}]],
    Annotation[#, {1, 73}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["74",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "37", ",", "74"}], "}"}]],
    Annotation[#, {1, 2, 37, 74}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["75",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "5", ",", "15", ",", "25", ",", "75"}], 
       "}"}]],
    Annotation[#, {1, 3, 5, 15, 25, 75}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["76",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "19", ",", "38", ",", "76"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 19, 38, 76}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["77",
     RowBox[{"{", 
       RowBox[{"1", ",", "7", ",", "11", ",", "77"}], "}"}]],
    Annotation[#, {1, 7, 11, 77}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["78",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "6", ",", "13", ",", "26", ",", "39", 
         ",", "78"}], "}"}]],
    Annotation[#, {1, 2, 3, 6, 13, 26, 39, 78}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["79",
     RowBox[{"{", 
       RowBox[{"1", ",", "79"}], "}"}]],
    Annotation[#, {1, 79}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["80",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "4", ",", "5", ",", "8", ",", "10", ",", "16", 
         ",", "20", ",", "40", ",", "80"}], "}"}]],
    Annotation[#, {1, 2, 4, 5, 8, 10, 16, 20, 40, 80}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["81",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "9", ",", "27", ",", "81"}], "}"}]],
    Annotation[#, {1, 3, 9, 27, 81}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["82",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "41", ",", "82"}], "}"}]],
    Annotation[#, {1, 2, 41, 82}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["83",
     RowBox[{"{", 
       RowBox[{"1", ",", "83"}], "}"}]],
    Annotation[#, {1, 83}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["84",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "7", ",", "12", ",",
          "14", ",", "21", ",", "28", ",", "42", ",", "84"}], "}"}]],
    Annotation[#, {1, 2, 3, 4, 6, 7, 12, 14, 21, 28, 42, 84}, "Tooltip"]& ], 
   ",", 
   TagBox[
    TooltipBox["85",
     RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "17", ",", "85"}], "}"}]],
    Annotation[#, {1, 5, 17, 85}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["86",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "43", ",", "86"}], "}"}]],
    Annotation[#, {1, 2, 43, 86}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["87",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "29", ",", "87"}], "}"}]],
    Annotation[#, {1, 3, 29, 87}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["88",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "4", ",", "8", ",", "11", ",", "22", ",", "44", 
         ",", "88"}], "}"}]],
    Annotation[#, {1, 2, 4, 8, 11, 22, 44, 88}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["89",
     RowBox[{"{", 
       RowBox[{"1", ",", "89"}], "}"}]],
    Annotation[#, {1, 89}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["90",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "9", ",", "10", ",",
          "15", ",", "18", ",", "30", ",", "45", ",", "90"}], "}"}]],
    Annotation[#, {1, 2, 3, 5, 6, 9, 10, 15, 18, 30, 45, 90}, "Tooltip"]& ], 
   ",", 
   TagBox[
    TooltipBox["91",
     RowBox[{"{", 
       RowBox[{"1", ",", "7", ",", "13", ",", "91"}], "}"}]],
    Annotation[#, {1, 7, 13, 91}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["92",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "4", ",", "23", ",", "46", ",", "92"}], 
       "}"}]],
    Annotation[#, {1, 2, 4, 23, 46, 92}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["93",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "31", ",", "93"}], "}"}]],
    Annotation[#, {1, 3, 31, 93}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["94",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "47", ",", "94"}], "}"}]],
    Annotation[#, {1, 2, 47, 94}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["95",
     RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "19", ",", "95"}], "}"}]],
    Annotation[#, {1, 5, 19, 95}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["96",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "12", ",",
          "16", ",", "24", ",", "32", ",", "48", ",", "96"}], "}"}]],
    Annotation[#, {1, 2, 3, 4, 6, 8, 12, 16, 24, 32, 48, 96}, "Tooltip"]& ], 
   ",", 
   TagBox[
    TooltipBox["97",
     RowBox[{"{", 
       RowBox[{"1", ",", "97"}], "}"}]],
    Annotation[#, {1, 97}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["98",
     RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "7", ",", "14", ",", "49", ",", "98"}], 
       "}"}]],
    Annotation[#, {1, 2, 7, 14, 49, 98}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["99",
     RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "9", ",", "11", ",", "33", ",", "99"}], 
       "}"}]],
    Annotation[#, {1, 3, 9, 11, 33, 99}, "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["100",
     RowBox[{"{", 
       RowBox[{
        "1", ",", "2", ",", "4", ",", "5", ",", "10", ",", "20", ",", "25", 
         ",", "50", ",", "100"}], "}"}]],
    Annotation[#, {1, 2, 4, 5, 10, 20, 25, 50, 100}, "Tooltip"]& ]}], 
  "}"}]], "Output",
 ImageSize->{511, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 " is another such function, but instead of displaying the result in a \
tooltip, it uses the same area of the screen that had been used for the \
display before you moved the mouse pointer over it. If the two displays are \
different sizes, then the effect can be jarring, so it",
 " i",
 "s a good idea to use displays which are closer to the same size, or use ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 "'s ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " option to leave space for the larger of the two displays, regardless of \
which is being displayed."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mouseover", "[", 
    RowBox[{"i", ",", 
     RowBox[{"Framed", "[", 
      RowBox[{
       RowBox[{"Divisors", "[", "i", "]"}], ",", " ", 
       RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PaneSelectorBox[{False->"1", True->
    FrameBox[
     RowBox[{"{", "1", "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"2", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"3", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"4", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"5", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"6", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "6"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"7", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "7"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"8", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "8"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"9", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "9"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"10", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5", ",", "10"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"11", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "11"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"12", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "12"}], "}"}],
     
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"13", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "13"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"14", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "7", ",", "14"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"15", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5", ",", "15"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"16", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"17", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "17"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"18", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "6", ",", "9", ",", "18"}], "}"}],
     
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"19", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "19"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"20", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "5", ",", "10", ",", "20"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"21", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "7", ",", "21"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"22", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "11", ",", "22"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"23", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "23"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"24", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "12", ",", 
       "24"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"25", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "25"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"26", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "13", ",", "26"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"27", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "9", ",", "27"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"28", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "7", ",", "14", ",", "28"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"29", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "29"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"30", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "10", ",", "15", ",", 
       "30"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"31", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "31"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"32", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"33", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "11", ",", "33"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"34", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "17", ",", "34"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"35", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "7", ",", "35"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"36", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "9", ",", "12", ",", 
       "18", ",", "36"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"37", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "37"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"38", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "19", ",", "38"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"39", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "13", ",", "39"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"40", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "5", ",", "8", ",", "10", ",", "20", ",", 
       "40"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"41", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "41"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"42", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "6", ",", "7", ",", "14", ",", "21", ",", 
       "42"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"43", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "43"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"44", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "11", ",", "22", ",", "44"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"45", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5", ",", "9", ",", "15", ",", "45"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"46", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "23", ",", "46"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"47", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "47"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"48", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "12", ",", 
       "16", ",", "24", ",", "48"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"49", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "7", ",", "49"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"50", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5", ",", "10", ",", "25", ",", "50"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"51", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "17", ",", "51"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"52", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "13", ",", "26", ",", "52"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"53", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "53"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"54", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "6", ",", "9", ",", "18", ",", "27", ",", 
       "54"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"55", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "11", ",", "55"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"56", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "7", ",", "8", ",", "14", ",", "28", ",", 
       "56"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"57", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "19", ",", "57"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"58", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "29", ",", "58"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"59", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "59"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"60", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "10", ",", 
       "12", ",", "15", ",", "20", ",", "30", ",", "60"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"61", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "61"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"62", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "31", ",", "62"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"63", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "7", ",", "9", ",", "21", ",", "63"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"64", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32", ",", "64"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"65", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "13", ",", "65"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"66", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "6", ",", "11", ",", "22", ",", "33", ",",
        "66"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"67", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "67"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"68", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "17", ",", "34", ",", "68"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"69", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "23", ",", "69"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"70", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "5", ",", "7", ",", "10", ",", "14", ",", "35", ",",
        "70"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"71", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "71"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"72", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "9", ",", 
       "12", ",", "18", ",", "24", ",", "36", ",", "72"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"73", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "73"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"74", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "37", ",", "74"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"75", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "5", ",", "15", ",", "25", ",", "75"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"76", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "19", ",", "38", ",", "76"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"77", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "7", ",", "11", ",", "77"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"78", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "6", ",", "13", ",", "26", ",", "39", ",",
        "78"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"79", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "79"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"80", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "5", ",", "8", ",", "10", ",", "16", ",", 
       "20", ",", "40", ",", "80"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"81", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "9", ",", "27", ",", "81"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"82", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "41", ",", "82"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"83", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "83"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"84", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "7", ",", "12", ",", 
       "14", ",", "21", ",", "28", ",", "42", ",", "84"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"85", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "17", ",", "85"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"86", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "43", ",", "86"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"87", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "29", ",", "87"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"88", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "8", ",", "11", ",", "22", ",", "44", ",",
        "88"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"89", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "89"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"90", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "5", ",", "6", ",", "9", ",", "10", ",", 
       "15", ",", "18", ",", "30", ",", "45", ",", "90"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"91", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "7", ",", "13", ",", "91"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"92", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4", ",", "23", ",", "46", ",", "92"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"93", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "31", ",", "93"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"94", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "47", ",", "94"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"95", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "19", ",", "95"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"96", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "12", ",", 
       "16", ",", "24", ",", "32", ",", "48", ",", "96"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"97", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "97"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"98", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "7", ",", "14", ",", "49", ",", "98"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"99", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "9", ",", "11", ",", "33", ",", "99"}], 
      "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->"100", True->
    FrameBox[
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "5", ",", "10", ",", "20", ",", "25", ",",
        "50", ",", "100"}], "}"}],
     Background->RGBColor[1, 1, 0.85],
     StripOnInput->False]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic]}], "}"}]], "Output",
 ImageSize->{511, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Also similar to ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " displays the extra information in the notebook's status area, typically in \
the lower-left corner, while ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " will display extra information in a new window when clicked."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"StatusArea", "[", 
    RowBox[{"i", ",", 
     RowBox[{"Divisors", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input"],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXG2P2zYM9tm+ZNe7XHLddS2wDSuG/pbt077tDxyKAe2HYUPXf78BXmSb
PuYxJVKW7CRtAtw5MimKoqi3h4p+e/r84Y8/nz5/fP/09tdPT39/+Pj+n7e/
/PVp/6q6Koqrf4ui+P1Nsf/e7L+1f+7z3/6v+9p9e+3+V0Rtiu8yp3PLX1re
j5B+NVitLOzPNzPz/QRaPrZa3uz/u5fV/nm9f9bAte7pdf+89tBXTM6U/Bod
36Oe3xjlVExfTl+xfFL+FZMv2Umjr43yuZ5T9NPoWO+petYeeau+/lUTbo/O
+1yrFdfD2/ZdUZTiWyep7C2UJw/qXmYvYUoebBHizmcrbIuq534hcqMnlpwb
pEh6x0m9TdIBa3bAFyc1ux3SaoZeQW12I+SP8RJrn0Q970Uu7FFynZ02q/3z
LlHG+O1GfIteIXPFSEQdt+5f/Zwe22sL6RLSD2I5r4ALWwylOqvuLHmidEX6
Q7QE1GEjWcPYItia3zZ+rxXLXcDjzsGHXZu5Rrzvn3JeoqIlfe+3/Xu0wJ2p
lGm50Da2GlH9xZ6ZNILSmhprs2me10JlXzKtkQ77031zuHoiTq6zVEIon9Uv
YnzI1r9svkvzpDyzVCMb+b268kopm2efn6qnXsL4bX4fk8c727hj4+LlhkcR
fV2As93WpJe8Pojxz7l4p80rKeudL7c1luobS/hCastEtJ84r51zb5mrVl96
+8y3fsFVBKbdCEEzNtFrliYMidKEMfrkWdKuvB3QMb2EfiXLX7PnGAd2XxFR
j/92weDT8leDFU8Jk8dn60EXTJ7lxzaU5CBf6bGblQ8xNWu5NB6gvafWw8on
IcY56lN62sXqHz7/beeiC/Z/Uti/DUeuPdw+veOkIuYdp4OvRdNqlscOaTXz
tdn8ftfNmpeIgC5RQuKMNsNVCksjlo8795eQlpBQhpr1VsYdg5grWnf0od0k
KahLeluLs+ElXhAtkbDnae2qebYYY8ruo6fk6YRF58dXnj08FFOhKMRBJGeE
sBOlKsaRE1/UJpRvrP08/iS2kTCHop+VIytIY3BFOQ/G1lqQp+lxIE21wl0T
iudwXMMz4gVW+7eRdN7qg29qfS1gGZyVsPw7Kb/cQ1Su+Ai2GK+PaGettlz+
oOFI78eR3toJgZ2tpkGOueZgaV/qwU2jubj3SXStPTS6rIWNy1ajC+4ey3Xu
cZGuV7i9Io3x7rnzpPEUAZ4NQPSa0C6fPB7XvvakqTxOxzTxk34bRq9ZmvSj
NOkXKr8K1O/gnF1r0gvqfmx554S6O7+phsGm+5BfYS+l/uRbbXH/xLHLml+j
S+dMefqFUU5f/f6TG+vV6NYYwbnHMvJg5u0aOLhWOzhHbecM1HyixEll4yqb
xvTIeuMIBOllsNMpJeTD+S/xje7VMbDyFUmGFetK0O+2f89nnbr3eAt/I/Qa
4pHW/9a8WO7lhHtYAupwwa2nSZwPt86P+WjRmHS/PJpnj3DNuXa7NyN9RA84
4KAR12ON0Un6MU8l5iZEfkxR4mqqVD9WG4fk0nvfuf9T+mWBH/EnqoxT81i5
NMZsIumIQ20hHYokDD7uGQWk8u+l/EGk0M+Vjn2iRu7rOmAxiY7Ieyq2qsVu
NP2SUVXUVeXCNpY9NaWlkSvVa01eLcfiTtp3c+Lu5x8jyGPjzpvd2o32MY74
4EnTHLNj9Jql+anssnjGdX3y+MxZe9JUHqdjmvgxro3RaoxKk36h8qm8ypO+
4M7HlffDYLVTxJnb+2HanRuPY0g3a1DcZFhZCXQtv0bXTgtrctbNc7xGWinO
jRhr8gmpPTZibNXThxhb4wBavOL7hrzva0QW86Gwx0MWl7Ks7TfFX3t7549u
dLMXnobRdmGuVIeGxu7ebGvE0K7aLwXXtqjLXCjyo2DZ0A5zGRRZP3ul6RCD
9qPsn9ss+MsDrV1tvzHNI0Xb6+l7VLL6Mviu6czfkfFdo88tgO92/ifFY49x
7lZqe5d8KdYFbbZpWIxP9GvaGWOZ7r2EEPKdNO2Ex2jtllGqwr/n9pVA+fhe
2zP2GzHrMRI/bnPxpK6xHxZFvrOvem/KcTo29aSwNiaEfgN0atZC7D0e62wG
L0q/xeNUTqAue+52qRPC6bX60tsnHflvht7gu5Nj6h0XGM/z3aHhO2Wr8e9m
1i+EJrvnu9ZqzoDpaKwYuQ6M4KlpHPE1/lNHZ2PTbf1HPdrtZHjcQXs+eN7P
jQK/ZuXL2ICEavrQWR/a6DsF7OMPyQmtCnz5fPdJW1Fonx3WCt0qfy4UnfRL
RdG5Heawo0ZvxxD1DLmOwelUCQVLlSndjhyfi+aKU7zzIY77GHdfaDdU56nZ
eaHu3cyFO0AN58Jzg4To4TpAPl2J+0v5Dg3kmobYaXtTDd+04Iau5rFotA0p
nIY3atjnNHw99tfR7ZpLHa9RV2x1mwel+BmdqrDdShjrX+rpcEgviW7P4238
XGa6PTV6uxJXvQxrSmjjGEGiXRx5BY50G0bXa5PHhyw9bxjLsV+P0FnkqISc
dK7YdKeJUZ7H/2y4SMSIjdbs7rTUPARripZCnBC1wjTG9+QRSsZx5vEibYzQ
6KHznZZ20X57kGcklLnmvz2ju4dW8zK5vXUvkDxOxFiMspf0u5R2C5U1xQfF
35bMpOspIuDdbIkSaO9FiCUho4RH8RUSzX0c8dyyJ0UJMc3xLYnO02tWLtFr
ll4Bf8300eRXhR0h7lawzkQWzLW4+h8crWt8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{507, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->131513308]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PopupWindow", "[", 
    RowBox[{"i", ",", 
     RowBox[{"Divisors", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["1",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["2",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["3",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["4",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["5",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 5}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["6",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 6}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["7",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 7}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["8",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 8}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["9",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 9}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["10",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 5, 10}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["11",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 11}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["12",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 4, 6, 12}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["13",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 13}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["14",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 7, 14}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["15",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 5, 15}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["16",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 8, 16}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["17",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 17}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["18",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 6, 9, 18}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["19",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 19}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["20",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 5, 10, 20}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["21",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 7, 21}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["22",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 11, 22}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["23",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 23}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["24",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 4, 6, 8, 12, 24}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["25",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 5, 25}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["26",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 13, 26}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["27",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 9, 27}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["28",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 7, 14, 28}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["29",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 29}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["30",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 5, 6, 10, 15, 30}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["31",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 31}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["32",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 8, 16, 32}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["33",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 11, 33}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["34",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 17, 34}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["35",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 5, 7, 35}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["36",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 4, 6, 9, 12, 18, 36}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["37",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 37}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["38",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 19, 38}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["39",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 13, 39}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["40",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 5, 8, 10, 20, 40}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["41",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 41}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["42",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 6, 7, 14, 21, 42}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["43",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 43}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["44",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 11, 22, 44}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["45",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 5, 9, 15, 45}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["46",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 23, 46}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["47",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 47}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["48",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 4, 6, 8, 12, 16, 24, 48}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["49",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 7, 49}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["50",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 5, 10, 25, 50}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["51",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 17, 51}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["52",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 13, 26, 52}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["53",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 53}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["54",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 6, 9, 18, 27, 54}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["55",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 5, 11, 55}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["56",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 7, 8, 14, 28, 56}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["57",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 19, 57}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["58",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 29, 58}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["59",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 59}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["60",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30, 
       60}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["61",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 61}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["62",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 31, 62}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["63",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 7, 9, 21, 63}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["64",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 8, 16, 32, 64}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["65",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 5, 13, 65}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["66",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 6, 11, 22, 33, 66}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["67",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 67}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["68",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 17, 34, 68}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["69",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 23, 69}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["70",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 5, 7, 10, 14, 35, 70}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["71",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 71}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["72",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 4, 6, 8, 9, 12, 18, 24, 36, 
       72}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["73",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 73}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["74",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 37, 74}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["75",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 5, 15, 25, 75}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["76",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 19, 38, 76}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["77",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 7, 11, 77}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["78",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 6, 13, 26, 39, 78}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["79",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 79}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["80",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 5, 8, 10, 16, 20, 40, 80}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["81",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 9, 27, 81}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["82",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 41, 82}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["83",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 83}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["84",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 4, 6, 7, 12, 14, 21, 28, 42, 
       84}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["85",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 5, 17, 85}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["86",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 43, 86}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["87",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 29, 87}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["88",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 8, 11, 22, 44, 88}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["89",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 89}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["90",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 5, 6, 9, 10, 15, 18, 30, 45, 
       90}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["91",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 7, 13, 91}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["92",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 23, 46, 92}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["93",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 31, 93}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["94",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 47, 94}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["95",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 5, 19, 95}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["96",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 3, 4, 6, 8, 12, 16, 24, 32, 48, 
       96}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["97",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 97}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["98",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 7, 14, 49, 98}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["99",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 3, 9, 11, 33, 99}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   ButtonBox["100",
    Appearance->None,
    BaseStyle->{},
    ButtonFrame->None,
    ButtonFunction:>CreateDocument[
      Internal`PopupWindowNotebook[{1, 2, 4, 5, 10, 20, 25, 50, 100}]],
    DefaultBaseStyle->{},
    Evaluator->Automatic,
    Method->"Preemptive"]}], "}"}]], "Output",
 ImageSize->{511, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[{
 "Finally, you can specify an arbitrary location for an annotation by using \
the pair ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MouseAnnotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MouseAnnotation"]], "InlineFormula"],
 "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Annotation", "[", 
    RowBox[{"i", ",", 
     RowBox[{"Divisors", "[", "i", "]"}], ",", "\"\<Mouse\>\""}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "100"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Dynamic", "[", 
  RowBox[{"MouseAnnotation", "[", "]"}], "]"}]}], "Input"],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{507, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellID->14881846],

Cell[BoxData[
 DynamicBox[ToBoxes[
   MouseAnnotation[], StandardForm],
  ImageSizeCache->{28., {0., 8.}}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
When using annotations that are triggered merely by moving the mouse pointer \
over a region of the screen, it is important to keep the user in mind. Moving \
the mouse is not something that should trigger a long evaluation or a lot of \
visual clutter. But used sparingly, annotations can be quite helpful to \
users.\
\>", "Text"],

Cell[TextData[{
 "Finally, note that all these annotations work perfectly well in graphics \
too. So you can provide tooltips or mouseovers to aid users in understanding \
a complicated graphic you have created. In fact, even visualization functions \
like ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["DensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
 " support ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ". See the documentation for details."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"LightBlue", ",", 
     RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Tooltip", "[", 
        RowBox[{
         RowBox[{"CountryData", "[", 
          RowBox[{"#", ",", "\"\<SchematicPolygon\>\""}], "]"}], ",", 
         RowBox[{"Panel", "[", 
          RowBox[{
           RowBox[{"CountryData", "[", 
            RowBox[{"#", ",", "\"\<Flag\>\""}], "]"}], ",", "#"}], "]"}]}], 
        "]"}], "&"}], "/@", 
      RowBox[{"CountryData", "[", "]"}]}]}], "}"}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1176634246],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.87, 0.94, 1], EdgeForm[GrayLevel[0.5]], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{61.28333333333333, 35.6}, {64.06666666666666, 36.}, {
      65.78333333333333, 37.56666666666666}, {67.76666666666667, 
      37.21666666666667}, {70.95, 38.46666666666667}, {71.68333333333334, 
      36.68333333333333}, {74.91666666666667, 37.233333333333334`}, {
      74.56666666666666, 37.03333333333333}, {71.63333333333333, 
      36.46666666666667}, {69.9, 34.016666666666666`}, {69.33333333333333, 
      31.933333333333334`}, {66.71666666666667, 31.216666666666665`}, {66.25, 
      29.849999999999998`}, {60.86666666666667, 29.866666666666667`}, {61.85, 
      31.016666666666666`}, {60.583333333333336`, 33.06666666666666}, {
      61.28333333333333, 35.6}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Afghanistan\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt23lQU9caAPAwaq3a1mKBOjpI3z9IQZnK1FYKIzgDQkWgBWegLGoFbWGg
gLUuEDHBKpsaiaAxQMISsl6S3Gz3ZieEsAgB4yMooBZHFrGoPFSs4vIOUqxP
X0GrHf/oyXzJhLuczPzOved8372Xf21JCdsyg0Ag+II3CbzHv7/ZlxeBoH+j
4RVIIJx8owH9oT/0h/7QH/pDf+gP/aE/9If+0B/6Q3/oD/2hP/SH/tAf+v/j
/Tne3ixv70ofH2lysm5yocjD4/iSJVW+vhV+fkobG+j/d/jLbW11UVH/RhAT
hyNlMKxWK3LsmIxGA3+eNZvbm5rqOZx2lUofGytatAj6v0b/8eM8PNwsk7W3
txuNxpaWlqampvLyciKR2NfXRyaTaTQaj8crLCzs7Oy0WCwXOjrEISHYjBnQ
/9X9hXPncpOSGplMAZmsLC09e/asXC7XaDQYhvX09ABwg8EwMDAAumZkZESv
1zfV1vLy89s1mjNyueCTT6D/q/gr58xRkcnNKKqn0eopFNGBA3KRCBeLMSqV
GRtbEhFB9/Y+6ulJ9fFBUlLqZDJzY2Px3r2nysqaeTw0O1tfXKz46CPo/9f8
NWDMT00Vb9wo/OknbUGB9PBhdV6eMC2N7ezMDAxUkUjyqCjcx0e2YYM0JkZO
JiO2tpy9e41Uqqq4WJqVZTx5siYrq6mqSrpgAfR/WX8tgdAlFN69c+fO6OiV
1lb0s8+wI0dESUnCdesEjo68xETcw6MmNVUeEYEnJxtiY9nh4YKwMMTREYCr
iorE69f3KJUXuroePXr02+hozYoV0P+l/PHIyPZTp7qNRtAFwPDhw4eW1laT
Vou7ukrnzJHMmydas4azeTM7Pl64ciUaFaW1seHb2oJeqxWJ2szme/fugb0e
PHhw1Wq9UFtrTE+H/i/lrzl0yMzlag4eFEdHa/PyjCxWN47X7NrVmJg4EfUJ
CeCz4bmoSUy0CAS/mEw6CgVNTlbFx+uysoSZmRro/8L+Qk/PBhbLdPy4cP/+
ei5XmpgozchQL1lya2jo0XSvsXv3DCEhYFKoTkrSIogwL6+ezdYcOMDbsAH6
v4g/yPbrEaS+qkp35Eg1kdgoFstJJOxxVQuO4Q6Z7ObgIIjLLS3Y229fMJlq
Q0L6rVZs8+brVuug2Sx9992JdlTAfPv2E99/zw8IMNJoFqNR+P770H9af/mM
GacUivrycq6nJ3vLFkl+Pic19claQ3j4yODgGSZTl5PT3dDQrlYLf/zRqNcz
IyKGrNYzhYVPtuRHRGjYbD7Ii+bOVVGpjQhS4eEB/af1F/v7aygUJDu7R6EY
7O29f/9+Q1LSk0s9Mje36319NceOWdraNCwWxuXW1dVVCwR8V9drvb0NWVm/
H/wzZ6ILF46Ojvb399/o6QEZKTclRbFnD/Sf1r88NLSvt3cigQGvi2q1dt26
80rlxFrUwYECqgASSSAQGI1GgC+RSKp37WJ5exdSKMWbNk1sZkpIuNbd3Uwm
g+77vZ2LFzWgiJg1C/pP7f9rd3e9QKAhErWFhZKMDP3WrTcuXTrX0TFxCpT6
+4v5fMWBA62trRaLpaCggEOjYQRCtZsbKhBU7dihfOstsJkFRXt6ehB3dwyM
P+npaGamBUFGR0bAlAH9p/aXUyja3Fxxfr4iL69NIqmNi2uvrx8bG8NWr1Y4
OFR6erZWVCj37Dnd2Nje0qJjMLQLF4K92GFhbZWVuJ9fxerVGnv7ocHBW7du
8V1chgcHJfv2Ve7ciWdk1HG5+NKl0H8Kf+3s2ZLsbGVmJkalasrLAbu1sPA8
gnR2do4MD3PT0kTz50uLijgxMbKPP356R7qHh4hK5fn68pYvv9jV1dvbe8lq
lSxdCkYeFZdrOHkSz81twjDZp59C/yn8QeA5OdKdO1lr17Y2N4OyV+/lpV60
6NeBgc5z5yRr1ogdHRkMBkiKpCSS+vF1fu3MmeW+vvzo6LKyMmlKClgiragA
la86OBiUw6PDw1arVUMmy7KyzDiugOP/dP66oiIDnd6GYdevX7caDMLoaLBQ
4eoKMqLx+ffDD0WHD4P5F9m1S5Cfz8/IQI4erUpIEJFI48vXrgXbSFatkv/8
83hTQUHijAzQiTcGB8VE4ikUldjZQf+p/SVpaQoisYbJvHP7torBwHbvxnx9
dc7O2mXLQP3VhiA3+vvv3Lz5TNl7f2xseGDg8unTUnv78f5ycRk/NY4cqUPR
katXlbt3i3fsQEkk3XM/B/2fAQFDBMfLC42PFwUHD1gsSiZT5O7+ZK2UQBi7
e1cbHX3ZaJwohEFcO39e5e7+261blpycP8ax994T7N9/++ZNVXAw+tVXbD8/
+WRpDP2n8AfB/fLL8cv7u3dLfXz0eXnoypV/VGcEAjjam7dv1/n7d4jFV/R6
q0hkJhLBKjDOXORwnmwpe+edhtJSxdatoqCg6pgYXlLS8z8E/f+vv8jVFaQr
yL59+qKiWiq1trQUn7yZKyEQhrq6lD4+iowMoVAI+sJkMqEsFlj1nytXzJP1
LwgDjaYtKNBkZjaVlIDJgrt+PfR/Qf/x4zw8XMNmCxMTZQUFTXS6dnJgkc2a
dXNoyBAZKQsOBokQSFBlMhkKijUC4UZfX8ukf/Xnn5tOnFDT6Zq8vHa1unzr
Vvy5ygv6T+Gvmj0bzcpq4nLl6elaOr2uqKh68mb6L2Kx7vGtFszLq1ehMHzz
jWL2bLD8TG6ucdky8AWbNcvEYKhBHrt3b0tJCZqTw//zW5DQ/89keE5OOjCA
HD0qAEN3bq78f1NHpZ2dat48lr098vi69DP7CjduBIVwM4djZLPZixc/n/ZA
/2n9QaBffKFKSKh2dlYdPCj/4QfNU8+2oYGBfCKx2sGBFxPD2bbt6b2YERGH
0tL4332Hh4VxQ0KmaB/6T+2vtrEB5lVubiCfH78Ftn8/tn07SGy0E7monZ0S
DPULFignpoZVq3CQ7aSm8r/9tpJKNUqlshUr1NM9hQX9p/YBgRMIgm3b5OvX
c7y9BU5ObH//yqAgXWYm7uKCh4YqSCRldjYYo5DYWD2dXp2QUL54MVpUxMjM
RNetm7Zx6D8t0UQA+eqICHloqIbJZCxfXhISct5sVoLsNDdXn5MjIZEkcXHc
r78G50jNpk3SuDjs8aQM/V+XP5htK52dRXFxNSxWY0WFMCDAUFLShuPawECh
gwPf1VVDoQgiIwUBAXJn5xdsE/q/7PPnIJPBFy0SLl0qDgujOziU+fkpPD0l
Tk7YBx/g8+crX7I16P+K/3/xF8Ch/2v0f/WA/tAf+kN/6A/9oT/0h/7QH/pD
f+gP/aE/9If+0B/6Q3/o/zfFfwEEnig2
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt23lQU9caAPAwaq3a1mKBOjpI3z9IQZnK1FYKIzgDQkWgBWegLGoFbWGg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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Afghanistan", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt23lQU9caAPAwaq3a1mKBOjpI3z9IQZnK1FYKIzgDQkWgBWegLGoFbWGg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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "Afghanistan"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{20.016666666666666`, 39.68333333333333}, {
      19.366666666666667`, 41.85}, {20.166666666666668`, 
      42.516666666666666`}, {20.983333333333334`, 40.85}, {
      20.016666666666666`, 39.68333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Albania\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXIvXVFUVv+/3Y755v75v5hNJjCVYRi2MMCSXgI9UTHClpICZkYDaWogl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              "], {{0, 0}, {128, 88}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 88}, PlotRange -> {{0, 128}, {0, 88}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXIvXVFUVv+/3Y755v75v5hNJjCVYRi2MMCSXgI9UTHClpICZkYDaWogl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          "], {{0, 0}, {128, 88}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 88}, PlotRange -> {{0, 128}, {0, 88}}]], {
        Style["Albania", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztXIvXVFUVv+/3Y755v75v5hNJjCVYRi2MMCSXgI9UTHClpICZkYDaWogl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        "], {{0, 0}, {128, 88}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 88}, PlotRange -> {{0, 128}, {0, 88}}], "Albania"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{8.616666666666667, 36.93333333333333}, {0., 
      35.833333333333336`}, {-2.216666666666667, 
      35.083333333333336`}, {-1.1833333333333333`, 
      32.1}, {-3.8166666666666664`, 31.7}, {-3.6333333333333333`, 
      30.966666666666665`}, {-8.666666666666666, 
      28.716666666666665`}, {-8.666666666666666, 
      27.666666666666668`}, {-8.666666666666666, 27.28333333333333}, {-4.8, 
      25.}, {0., 21.833333333333332`}, {4.25, 19.15}, {12., 
      23.516666666666666`}, {9.4, 26.15}, {9.533333333333333, 
      30.233333333333334`}, {7.5, 33.88333333333333}, {8.616666666666667, 
      36.93333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Algeria\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3H1ME2ccB/CnL7TAlMjYwIh2TgZxDhBFjbaKmwniH5oY3ObiEhcbY4xO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              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3H1ME2ccB/CnL7TAlMjYwIh2TgZxDhBFjbaKmwniH5oY3ObiEhcbY4xO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          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Algeria", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3H1ME2ccB/CnL7TAlMjYwIh2TgZxDhBFjbaKmwniH5oY3ObiEhcbY4xO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        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Algeria"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-170.769, -14.2769}, {-170.736, -14.2645}, {-170.7, \
-14.2521}, {-170.671, -14.2521}, {-170.636, -14.2579}, {-170.595, -14.2587}, \
{-170.559, -14.248}, {-170.537, -14.2455}, {-170.527, -14.2505}, {-170.529, \
-14.2653}, {-170.546, -14.2744}, {-170.58, -14.2901}, {-170.613, -14.2991}, \
{-170.65, -14.3098}, {-170.647, -14.3214}, {-170.655, -14.3324}, {-170.679, \
-14.3395}, {-170.704, -14.3502}, {-170.712, -14.3585}, {-170.724, -14.3684}, \
{-170.747, -14.3742}, {-170.766, -14.3733}, {-170.782, -14.3643}, {-170.803, \
-14.3544}, {-170.827, -14.3445}, {-170.854, -14.3445}, {-170.881, -14.3445}, \
{-170.896, -14.3387}, {-170.902, -14.3255}, {-170.9, -14.314}, {-170.887, \
-14.3057}, {-170.869, -14.2983}, {-170.829, -14.2958}, {-170.796, -14.2917}, \
{-170.785, -14.2851}, {-170.769, -14.2769}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"AmericanSamoa\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnAlUU1cax1/bmXHGc9pptVUr44JoUTZZZBOq1SrWKl3saTu1VYs4jDuy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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnAlUU1cax1/bmXHGc9pptVUr44JoUTZZZBOq1SrWKl3saTu1VYs4jDuy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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["AmericanSamoa", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnAlUU1cax1/bmXHGc9pptVUr44JoUTZZZBOq1SrWKl3saTu1VYs4jDuy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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "AmericanSamoa"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{1.75, 42.5}, {1.5, 42.6}, {1.4833333333333334`, 42.6}, {
      1.75, 42.5}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Andorra\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztm3tQVNcdxw8iYAyLFNR93LssS9KknUk66R91prbT6Uw706k1+SOddpxO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              "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztm3tQVNcdxw8iYAyLFNR93LssS9KknUk66R91prbT6Uw706k1+SOddpxO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          "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], {
        Style["Andorra", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztm3tQVNcdxw8iYAyLFNR93LssS9KknUk66R91prbT6Uw706k1+SOddpxO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        "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}], "Andorra"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{13.183333333333334`, -5.866666666666666}, {12.25, -6.1}, {
       13.799999999999999`, -11.8}, {11.766666666666666`, -17.25}, {
       13.85, -17.333333333333332`}, {
       23.483333333333334`, -17.633333333333333`}, {
       22., -16.166666666666668`}, {22., -13.}, {24.016666666666666`, -13.}, {
       23.983333333333334`, -10.866666666666667`}, {
       22.166666666666668`, -10.866666666666667`}, {
       21.78333333333333, -7.283333333333333}, {18., -8.1}, {
       16.983333333333334`, -7.25}, {
       16.516666666666666`, -5.883333333333333}, {
       13.183333333333334`, -5.85}}, {{
       12.033333333333333`, -5.016666666666667}, {12.2, -5.783333333333333}, {
       13.083333333333334`, -4.633333333333333}, {
       12.033333333333333`, -5.016666666666667}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Angola\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmw9MVVUcx7/ASHCWlZDpTEUK/9RaTWOEZbbU/ukqjZqSspEhlAZMgUQL
UEsrEiUzmNMytGWbmdQSJQNmSkZAJkPI0Ckqf62m1EjF0znH+97z+ngP5N/h
3vf77vPe7rvcc/Y733vuOb9z78UvPHp6uAeAEP5J5h+xTSKRSCQSiUQikUgk
EolEIpFIJBKJRCKRSKQOa/gd8PZSHYSraulCtDSi+jDuGa06FNdTcgLOn8Sc
F1FzBHnZqqNxGbm74bmnsX8XFs1HwTea/8sTVYfVi+UzQPeTNdoYPtThYfYa
MhhPTcaxUny/A78XCf+L9qKqBE9O6vqYzaHgQGRvRdNJnbet+u/hgeMl2Pct
pj0ON7dr6+nrLUabf06jOE8MNSHPIH0VmmuwbDG8+vRQW4wl7mHudpvPKQli
592jsOAVnf97tuONaDwUhBeete0sPwDfAbZ6QkNQXQb2p8byJeI79ysE+Cts
nwGU8YHN0ubTqC3XOX8NLfW27V8LtBpGDEPhHpvzdZVIjEVSAh6boLRhBtHI
O3WusgbH/uv/xK+IG/shIgyX+P6zwnmeZGauxptxiAqHu7vqhhlBU6fgSKHF
2AZBQyU2pWP6VEwcrzF5IiLm4P0UfJ2F8yfEkRfO4MOVWJGIs1WWbt+IwhzE
RGJ9KvyGqW6VQbT5I1tnvlSHjWvxSLCYYZ3o1lswawZej8DRItuAw0/Zklhs
zRD+k9qvKY9q5u/cgtEB7Sri74c179icb2nAhjQxa/O5IGYeftqNl1/q5qDN
pfgFeDioXUfyrH5LJi6ftZl/MFd0+JIfsG4VUlNwoUbkpfwCIXWtrFm91fnG
P8QtnawMrF6BubNRvl9MHE0nMGig6ljNJfusnmc4G9PF6Sg7gMCx4ph7x+Dv
Y9oMnvMlpT1dpqBxuqyeU7RXDDilBSLJ4ZmnVTxHulirTSXhoRg6RMwID9yv
LnSDy36o53nmW3HYvB6VP2NCcCtF0lZoGey/1dpqYmtmj8dtCs2coRvq+Vn4
ZB2S4sWY/26yw9s4N/dHfaVudfbfGdzm07OhG1983cpHeKv5xXkyw8nHoX0Y
e18bZeeFaSs46ylIjO2RoM0iPuxYx5yL9aLP857fXIOli+Dp2XZxfmn8VaU5
f7wEcfMx0Lf7gzaRYqJ0s+25E2L+HTPyOmr4OFXr/7QQ7oA+32Azv+kUoiOv
O5kMDtT6/47PuidEUyvtbc3889UYdVdHavD2wmXZ/+squjq4LlVSryTnNc3/
7LCOV3JO//hgV6T6dtnDeicDwc6AlYK5daKSHP0jg0jVjTIWfAhK6FwNX5D/
naAPWN/O1bCb/FfKL9L2k2DjJYNVx2NcIuSMYP15A1g8mKfTIh5g8gGlmAWU
x290QsAqwZ6Q2wFg+WCftlXkQcuwk6Y6eBPQD+yUNDPLshHaVpFlluf4a+T1
orwJRmeT/uUTX6cH86y1+Kr7b0fbcb4IJ0wCq9AnM+857dVz7d4dmqS6CQaF
Z6ErHbyClQ/m31qRIZaZ1wpfx7mrbohBmSZTnSv8KM2sleuyK3teBfPSH899
3maxvUxOvsfBFqpuhTmYLV3d5vgAbv5ai/n1YMFyp7ecvpUHbwJukjeFZjo1
3/r6YorqaE1JhjwL9vv7g2Ve9V4u/56lOlRT4mO3x01eERV2L0U3yFWb8oDN
zTiw7/SeW08Bz/9vVx2eWeEZZixYoV2f3wEWJTcOgQ1VHaQp4ePPTt3/CGgc
BHte3nODTJNGqI7TrPg4WIslqg7MReCz7WH5YGsx2Pqr/P+NVrg9ziCwOss6
d4lcZykPydWIlw8FPFSHQRAEQRAEQRAEQRAEQRAEQRAEQRAEQbg8/wMDVNEi

              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmw9MVVUcx7/ASHCWlZDpTEUK/9RaTWOEZbbU/ukqjZqSspEhlAZMgUQL
UEsrEiUzmNMytGWbmdQSJQNmSkZAJkPI0Ckqf62m1EjF0znH+97z+ngP5N/h
3vf77vPe7rvcc/Y733vuOb9z78UvPHp6uAeAEP5J5h+xTSKRSCQSiUQikUgk
EolEIpFIJBKJRCKRSKQOa/gd8PZSHYSraulCtDSi+jDuGa06FNdTcgLOn8Sc
F1FzBHnZqqNxGbm74bmnsX8XFs1HwTea/8sTVYfVi+UzQPeTNdoYPtThYfYa
MhhPTcaxUny/A78XCf+L9qKqBE9O6vqYzaHgQGRvRdNJnbet+u/hgeMl2Pct
pj0ON7dr6+nrLUabf06jOE8MNSHPIH0VmmuwbDG8+vRQW4wl7mHudpvPKQli
592jsOAVnf97tuONaDwUhBeete0sPwDfAbZ6QkNQXQb2p8byJeI79ysE+Cts
nwGU8YHN0ubTqC3XOX8NLfW27V8LtBpGDEPhHpvzdZVIjEVSAh6boLRhBtHI
O3WusgbH/uv/xK+IG/shIgyX+P6zwnmeZGauxptxiAqHu7vqhhlBU6fgSKHF
2AZBQyU2pWP6VEwcrzF5IiLm4P0UfJ2F8yfEkRfO4MOVWJGIs1WWbt+IwhzE
RGJ9KvyGqW6VQbT5I1tnvlSHjWvxSLCYYZ3o1lswawZej8DRItuAw0/Zklhs
zRD+k9qvKY9q5u/cgtEB7Sri74c179icb2nAhjQxa/O5IGYeftqNl1/q5qDN
pfgFeDioXUfyrH5LJi6ftZl/MFd0+JIfsG4VUlNwoUbkpfwCIXWtrFm91fnG
P8QtnawMrF6BubNRvl9MHE0nMGig6ljNJfusnmc4G9PF6Sg7gMCx4ph7x+Dv
Y9oMnvMlpT1dpqBxuqyeU7RXDDilBSLJ4ZmnVTxHulirTSXhoRg6RMwID9yv
LnSDy36o53nmW3HYvB6VP2NCcCtF0lZoGey/1dpqYmtmj8dtCs2coRvq+Vn4
ZB2S4sWY/26yw9s4N/dHfaVudfbfGdzm07OhG1983cpHeKv5xXkyw8nHoX0Y
e18bZeeFaSs46ylIjO2RoM0iPuxYx5yL9aLP857fXIOli+Dp2XZxfmn8VaU5
f7wEcfMx0Lf7gzaRYqJ0s+25E2L+HTPyOmr4OFXr/7QQ7oA+32Azv+kUoiOv
O5kMDtT6/47PuidEUyvtbc3889UYdVdHavD2wmXZ/+squjq4LlVSryTnNc3/
7LCOV3JO//hgV6T6dtnDeicDwc6AlYK5daKSHP0jg0jVjTIWfAhK6FwNX5D/
naAPWN/O1bCb/FfKL9L2k2DjJYNVx2NcIuSMYP15A1g8mKfTIh5g8gGlmAWU
x290QsAqwZ6Q2wFg+WCftlXkQcuwk6Y6eBPQD+yUNDPLshHaVpFlluf4a+T1
orwJRmeT/uUTX6cH86y1+Kr7b0fbcb4IJ0wCq9AnM+857dVz7d4dmqS6CQaF
Z6ErHbyClQ/m31qRIZaZ1wpfx7mrbohBmSZTnSv8KM2sleuyK3teBfPSH899
3maxvUxOvsfBFqpuhTmYLV3d5vgAbv5ai/n1YMFyp7ecvpUHbwJukjeFZjo1
3/r6YorqaE1JhjwL9vv7g2Ve9V4u/56lOlRT4mO3x01eERV2L0U3yFWb8oDN
zTiw7/SeW08Bz/9vVx2eWeEZZixYoV2f3wEWJTcOgQ1VHaQp4ePPTt3/CGgc
BHte3nODTJNGqI7TrPg4WIslqg7MReCz7WH5YGsx2Pqr/P+NVrg9ziCwOss6
d4lcZykPydWIlw8FPFSHQRAEQRAEQRAEQRAEQRAEQRAEQRAEQbg8/wMDVNEi

          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Angola", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmw9MVVUcx7/ASHCWlZDpTEUK/9RaTWOEZbbU/ukqjZqSspEhlAZMgUQL
UEsrEiUzmNMytGWbmdQSJQNmSkZAJkPI0Ckqf62m1EjF0znH+97z+ngP5N/h
3vf77vPe7rvcc/Y733vuOb9z78UvPHp6uAeAEP5J5h+xTSKRSCQSiUQikUgk
EolEIpFIJBKJRCKRSKQOa/gd8PZSHYSraulCtDSi+jDuGa06FNdTcgLOn8Sc
F1FzBHnZqqNxGbm74bmnsX8XFs1HwTea/8sTVYfVi+UzQPeTNdoYPtThYfYa
MhhPTcaxUny/A78XCf+L9qKqBE9O6vqYzaHgQGRvRdNJnbet+u/hgeMl2Pct
pj0ON7dr6+nrLUabf06jOE8MNSHPIH0VmmuwbDG8+vRQW4wl7mHudpvPKQli
592jsOAVnf97tuONaDwUhBeete0sPwDfAbZ6QkNQXQb2p8byJeI79ysE+Cts
nwGU8YHN0ubTqC3XOX8NLfW27V8LtBpGDEPhHpvzdZVIjEVSAh6boLRhBtHI
O3WusgbH/uv/xK+IG/shIgyX+P6zwnmeZGauxptxiAqHu7vqhhlBU6fgSKHF
2AZBQyU2pWP6VEwcrzF5IiLm4P0UfJ2F8yfEkRfO4MOVWJGIs1WWbt+IwhzE
RGJ9KvyGqW6VQbT5I1tnvlSHjWvxSLCYYZ3o1lswawZej8DRItuAw0/Zklhs
zRD+k9qvKY9q5u/cgtEB7Sri74c179icb2nAhjQxa/O5IGYeftqNl1/q5qDN
pfgFeDioXUfyrH5LJi6ftZl/MFd0+JIfsG4VUlNwoUbkpfwCIXWtrFm91fnG
P8QtnawMrF6BubNRvl9MHE0nMGig6ljNJfusnmc4G9PF6Sg7gMCx4ph7x+Dv
Y9oMnvMlpT1dpqBxuqyeU7RXDDilBSLJ4ZmnVTxHulirTSXhoRg6RMwID9yv
LnSDy36o53nmW3HYvB6VP2NCcCtF0lZoGey/1dpqYmtmj8dtCs2coRvq+Vn4
ZB2S4sWY/26yw9s4N/dHfaVudfbfGdzm07OhG1983cpHeKv5xXkyw8nHoX0Y
e18bZeeFaSs46ylIjO2RoM0iPuxYx5yL9aLP857fXIOli+Dp2XZxfmn8VaU5
f7wEcfMx0Lf7gzaRYqJ0s+25E2L+HTPyOmr4OFXr/7QQ7oA+32Azv+kUoiOv
O5kMDtT6/47PuidEUyvtbc3889UYdVdHavD2wmXZ/+squjq4LlVSryTnNc3/
7LCOV3JO//hgV6T6dtnDeicDwc6AlYK5daKSHP0jg0jVjTIWfAhK6FwNX5D/
naAPWN/O1bCb/FfKL9L2k2DjJYNVx2NcIuSMYP15A1g8mKfTIh5g8gGlmAWU
x290QsAqwZ6Q2wFg+WCftlXkQcuwk6Y6eBPQD+yUNDPLshHaVpFlluf4a+T1
orwJRmeT/uUTX6cH86y1+Kr7b0fbcb4IJ0wCq9AnM+857dVz7d4dmqS6CQaF
Z6ErHbyClQ/m31qRIZaZ1wpfx7mrbohBmSZTnSv8KM2sleuyK3teBfPSH899
3maxvUxOvsfBFqpuhTmYLV3d5vgAbv5ai/n1YMFyp7ecvpUHbwJukjeFZjo1
3/r6YorqaE1JhjwL9vv7g2Ve9V4u/56lOlRT4mO3x01eERV2L0U3yFWb8oDN
zTiw7/SeW08Bz/9vVx2eWeEZZixYoV2f3wEWJTcOgQ1VHaQp4ePPTt3/CGgc
BHte3nODTJNGqI7TrPg4WIslqg7MReCz7WH5YGsx2Pqr/P+NVrg9ziCwOss6
d4lcZykPydWIlw8FPFSHQRAEQRAEQRAEQRAEQRAEQRAEQRAEQbg8/wMDVNEi

        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Angola"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-63.0071, 18.2457}, {-62.9908, 18.2486}, {-62.9774, 
      18.2467}, {-62.9582, 18.2388}, {-62.9537, 18.2269}, {-62.9626, 
      18.2141}, {-62.9789, 18.2101}, {-63.0115, 18.2081}, {-63.0708, 
      18.1726}, {-63.0827, 18.1489}, {-63.1034, 18.137}, {-63.1686, 
      18.137}, {-63.1864, 18.1439}, {-63.1879, 18.1568}, {-63.1672, 
      18.1726}, {-63.0071, 18.2457}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Anguilla\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmwtUE8caxxMQBEHFc8FWpIqPU49S4dZTj7dq0QpHBK+KcG+tFvEBolgp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              "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmwtUE8caxxMQBEHFc8FWpIqPU49S4dZTj7dq0QpHBK+KcG+tFvEBolgp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          "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], {
        Style["Anguilla", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmwtUE8caxxMQBEHFc8FWpIqPU49S4dZTj7dq0QpHBK+KcG+tFvEBolgp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        "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}], "Anguilla"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.6546, 17.0476}, {-61.6433, 17.0365}, {-61.6433, 
       17.0227}, {-61.6526, 17.0116}, {-61.6713, 17.0046}, {-61.7046, 
       17.0019}, {-61.7202, 16.9894}, {-61.7202, 16.9617}, {-61.7275, 
       16.9499}, {-61.7421, 16.9478}, {-61.7556, 16.9533}, {-61.7816, 
       16.963}, {-61.8638, 16.9672}, {-61.8815, 16.9769}, {-61.8835, 
       16.9922}, {-61.8648, 17.0247}, {-61.8607, 17.0747}, {-61.8263, 
       17.0989}, {-61.7982, 17.1065}, {-61.7587, 17.101}, {-61.6546, 
       17.0476}}, {{-61.8163, 17.5651}, {-61.838, 17.5645}, {-61.8641, 
       17.5703}, {-61.8876, 17.5842}, {-61.8937, 17.6103}, {-61.8824, 
       17.6671}, {-61.8754, 17.6741}, {-61.8624, 17.67}, {-61.8363, 
       17.63}, {-61.8215, 17.63}, {-61.8145, 17.6376}, {-61.8145, 
       17.6637}, {-61.8467, 17.7222}, {-61.8432, 17.7321}, {-61.831, 
       17.7355}, {-61.8102, 17.7332}, {-61.7536, 17.6811}, {-61.718, 
       17.6173}, {-61.7145, 17.5593}, {-61.7241, 17.5413}, {-61.7389, 
       17.535}, {-61.758, 17.5355}, {-61.8163, 17.5651}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"AntiguaBarbuda\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnA1UjXccx3/33txKb6LkpYlMw9KIZZOXMPPSrDjS1JzKaTFjeduRwxwv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              "], {{0, 0}, {128, 86}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 86}, PlotRange -> {{0, 128}, {0, 86}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnA1UjXccx3/33txKb6LkpYlMw9KIZZOXMPPSrDjS1JzKaTFjeduRwxwv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          "], {{0, 0}, {128, 86}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 86}, PlotRange -> {{0, 128}, {0, 86}}]], {
        Style["AntiguaBarbuda", "Panel", Background -> None]}, {{Top, Left}}],
       Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnA1UjXccx3/33txKb6LkpYlMw9KIZZOXMPPSrDjS1JzKaTFjeduRwxwv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        "], {{0, 0}, {128, 86}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 86}, PlotRange -> {{0, 128}, {0, 86}}], 
      "AntiguaBarbuda"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-58.199999999999996`, -32.45}, {-58.516666666666666`, \
-34.45}, {-56.666666666666664`, -36.9}, {-58.31666666666666, \
-38.483333333333334`}, {-62.38333333333333, -38.8}, {-62.3, \
-40.81666666666666}, {-65.13333333333333, -40.85}, {-63.583333333333336`, \
-42.61666666666667}, {-64.96666666666667, -42.666666666666664`}, {-65.6, \
-45.016666666666666`}, {-67.58333333333333, -46.}, {-65.73333333333333, \
-47.38333333333333}, {-69.01666666666667, -50.016666666666666`}, \
{-68.43333333333334, -52.38333333333333}, {-71.93333333333334, \
-51.983333333333334`}, {-73.58333333333333, -49.53333333333333}, {-71.1, \
-44.53333333333333}, {-72.13333333333333, -42.28333333333333}, \
{-69.81666666666666, -34.233333333333334`}, {-70.56666666666666, \
-31.316666666666666`}, {-68.31666666666666, -27.05}, {-67.18333333333334, \
-22.816666666666666`}, {-66.23333333333333, -21.78333333333333}, \
{-64.31666666666666, -22.866666666666667`}, {-63.93333333333333, -22.}, \
{-62.63333333333333, -22.233333333333334`}, {-57.75, -25.183333333333334`}, \
{-58.6, -27.316666666666666`}, {-55.583333333333336`, -27.28333333333333}, \
{-54.6, -25.566666666666666`}, {-53.8, -27.133333333333333`}, \
{-57.63333333333333, -30.25}, {-58.199999999999996`, -32.45}}, \
{{-68.61666666666666, -52.65}, {-65.13333333333333, -54.65}, \
{-68.63333333333333, -54.78333333333333}, {-68.63333333333333, \
-54.88333333333333}, {-68.61666666666666, -52.65}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Argentina\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmttrHFUcxw/4qthKqq2u1UZarEVBFKVoIVUh2thSbZoHLxgKTQwaSlFK
QVtvKNIL9UFawRcf8lCVFkH70koTaCQ02bns7OxMkt3NZrO3uc85Z3Y6u9mQ
OMF/QTh0zu/DZ5d52IcvH4ZhZne3HTn29pF7EEI98evL+LV+fFBbQ5MgM6E/
9OdZ6A/9eRb6Q3+ehf7Qn2ehP/TnWegP/XkW+kN/noX+0J9noT/051noD/15
NttcG8cgMwEAuLtotcKVlRV76WoYBtSe8uvX2q2QUsp6Fxc4tQnHXvLKv1jK
QWyMB9UfDPkNv3rFK51rzF9kvS7JrK6uGlURG3+TxS+wvt8uXjC1444+gvMj
gbzJyp8n+uvUEYIgYL00gXSWoyh03cplXPjU1wfc4llHH7aUw3b2kKn0B8pW
nHnKzfU7al+nE4V0gfXepBGf/K4+iIsn7LnjnnaYqk9b0p5G9qipHnXFXV76
YUfaiaWUl+t3xZ0hKbDemzQqheukMGoWLuLZd5xsb0U5Uc0MBplUIG0k+ptL
6fd9YQMRHzH1jwLthao81GrdYT05OTRJlVYuGeXxoPgx0V5r5E5W0/s7GVS4
hvJ/oXYGuTM7DHWUSCkqp5z8abpw0q+MsV6dHOK7TWxNk/yHlj5qygdK8tlI
RGsaItPIv71+0FFQSfnWnHrQEp7D8i5S+np5eZn16uRAsFkvXK6rn9Tl94qT
r+aF0y0JRdJ6+diWvP5u5obVWyN1eaCefiX+pN3IsF6dHDqdDq79TpRn3PRD
ON1Vyw6R20i8gpQ/UOk6mvkV0WlkaJ/Vp55oCHvN7AfU+LPVarFenRxCX6P5
Qat4iSrdRNxszzxpyX3GBKrcRLUJFB9gabsp76XyFip1eYVTfu230LnJenWi
KOtjZH64MfdzU97gCVvq6ZfsuTOB+mJ8/+OpfeX0W1TaSIX7DP2r+HGson4H
1///l/ipyhO309zLjrwbS5upeK8zs6mRedeU93lCyk0/6ojbmvL9vtrrCo+H
zg3We5NGp03aYc2ePUXU3b60Fef2edk9tnLAVXpc8Vma7cbyDiv/DZYei8/8
KIpY700mVuWGv3iezA4Q4QGneMbUjxnKEFWfp3KXVbiAtd473q2QlFnPTDL2
0phrzfrzI1b2kN+YDKo/elK3V73qlc5ZhZ9Yr+OCKCL/ff8fX2eop3kL37cj
0mx6rHcBdx//EPa/QfMs/P+ErdAf+vMs9If+PAv9oT/PQn/oz7PQH/rzLPSH
/jwL/aE/z0J/6M+z0B/68yz0Z+vni2s9CsjMfwFb6wSM
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmttrHFUcxw/4qthKqq2u1UZarEVBFKVoIVUh2thSbZoHLxgKTQwaSlFK
QVtvKNIL9UFawRcf8lCVFkH70koTaCQ02bns7OxMkt3NZrO3uc85Z3Y6u9mQ
OMF/QTh0zu/DZ5d52IcvH4ZhZne3HTn29pF7EEI98evL+LV+fFBbQ5MgM6E/
9OdZ6A/9eRb6Q3+ehf7Qn2ehP/TnWegP/XkW+kN/noX+0J9noT/051noD/15
NttcG8cgMwEAuLtotcKVlRV76WoYBtSe8uvX2q2QUsp6Fxc4tQnHXvLKv1jK
QWyMB9UfDPkNv3rFK51rzF9kvS7JrK6uGlURG3+TxS+wvt8uXjC1444+gvMj
gbzJyp8n+uvUEYIgYL00gXSWoyh03cplXPjU1wfc4llHH7aUw3b2kKn0B8pW
nHnKzfU7al+nE4V0gfXepBGf/K4+iIsn7LnjnnaYqk9b0p5G9qipHnXFXV76
YUfaiaWUl+t3xZ0hKbDemzQqheukMGoWLuLZd5xsb0U5Uc0MBplUIG0k+ptL
6fd9YQMRHzH1jwLthao81GrdYT05OTRJlVYuGeXxoPgx0V5r5E5W0/s7GVS4
hvJ/oXYGuTM7DHWUSCkqp5z8abpw0q+MsV6dHOK7TWxNk/yHlj5qygdK8tlI
RGsaItPIv71+0FFQSfnWnHrQEp7D8i5S+np5eZn16uRAsFkvXK6rn9Tl94qT
r+aF0y0JRdJ6+diWvP5u5obVWyN1eaCefiX+pN3IsF6dHDqdDq79TpRn3PRD
ON1Vyw6R20i8gpQ/UOk6mvkV0WlkaJ/Vp55oCHvN7AfU+LPVarFenRxCX6P5
Qat4iSrdRNxszzxpyX3GBKrcRLUJFB9gabsp76XyFip1eYVTfu230LnJenWi
KOtjZH64MfdzU97gCVvq6ZfsuTOB+mJ8/+OpfeX0W1TaSIX7DP2r+HGson4H
1///l/ipyhO309zLjrwbS5upeK8zs6mRedeU93lCyk0/6ojbmvL9vtrrCo+H
zg3We5NGp03aYc2ePUXU3b60Fef2edk9tnLAVXpc8Vma7cbyDiv/DZYei8/8
KIpY700mVuWGv3iezA4Q4QGneMbUjxnKEFWfp3KXVbiAtd473q2QlFnPTDL2
0phrzfrzI1b2kN+YDKo/elK3V73qlc5ZhZ9Yr+OCKCL/ff8fX2eop3kL37cj
0mx6rHcBdx//EPa/QfMs/P+ErdAf+vMs9If+PAv9oT/PQn/oz7PQH/rzLPSH
/jwL/aE/z0J/6M+z0B/68yz0Z+vni2s9CsjMfwFb6wSM
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Argentina", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmttrHFUcxw/4qthKqq2u1UZarEVBFKVoIVUh2thSbZoHLxgKTQwaSlFK
QVtvKNIL9UFawRcf8lCVFkH70koTaCQ02bns7OxMkt3NZrO3uc85Z3Y6u9mQ
OMF/QTh0zu/DZ5d52IcvH4ZhZne3HTn29pF7EEI98evL+LV+fFBbQ5MgM6E/
9OdZ6A/9eRb6Q3+ehf7Qn2ehP/TnWegP/XkW+kN/noX+0J9noT/051noD/15
NttcG8cgMwEAuLtotcKVlRV76WoYBtSe8uvX2q2QUsp6Fxc4tQnHXvLKv1jK
QWyMB9UfDPkNv3rFK51rzF9kvS7JrK6uGlURG3+TxS+wvt8uXjC1444+gvMj
gbzJyp8n+uvUEYIgYL00gXSWoyh03cplXPjU1wfc4llHH7aUw3b2kKn0B8pW
nHnKzfU7al+nE4V0gfXepBGf/K4+iIsn7LnjnnaYqk9b0p5G9qipHnXFXV76
YUfaiaWUl+t3xZ0hKbDemzQqheukMGoWLuLZd5xsb0U5Uc0MBplUIG0k+ptL
6fd9YQMRHzH1jwLthao81GrdYT05OTRJlVYuGeXxoPgx0V5r5E5W0/s7GVS4
hvJ/oXYGuTM7DHWUSCkqp5z8abpw0q+MsV6dHOK7TWxNk/yHlj5qygdK8tlI
RGsaItPIv71+0FFQSfnWnHrQEp7D8i5S+np5eZn16uRAsFkvXK6rn9Tl94qT
r+aF0y0JRdJ6+diWvP5u5obVWyN1eaCefiX+pN3IsF6dHDqdDq79TpRn3PRD
ON1Vyw6R20i8gpQ/UOk6mvkV0WlkaJ/Vp55oCHvN7AfU+LPVarFenRxCX6P5
Qat4iSrdRNxszzxpyX3GBKrcRLUJFB9gabsp76XyFip1eYVTfu230LnJenWi
KOtjZH64MfdzU97gCVvq6ZfsuTOB+mJ8/+OpfeX0W1TaSIX7DP2r+HGson4H
1///l/ipyhO309zLjrwbS5upeK8zs6mRedeU93lCyk0/6ojbmvL9vtrrCo+H
zg3We5NGp03aYc2ePUXU3b60Fef2edk9tnLAVXpc8Vma7cbyDiv/DZYei8/8
KIpY700mVuWGv3iezA4Q4QGneMbUjxnKEFWfp3KXVbiAtd473q2QlFnPTDL2
0phrzfrzI1b2kN+YDKo/elK3V73qlc5ZhZ9Yr+OCKCL/ff8fX2eop3kL37cj
0mx6rHcBdx//EPa/QfMs/P+ErdAf+vMs9If+PAv9oT/PQn/oz7PQH/rzLPSH
/jwL/aE/z0J/6M+z0B/68yz0Z+vni2s9CsjMfwFb6wSM
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "Argentina"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{43.166666666666664`, 40.583333333333336`}, {
      45.016666666666666`, 41.2}, {46.35, 40.31666666666666}, {
      47.483333333333334`, 39.35}, {46.766666666666666`, 39.06666666666666}, {
      46.166666666666664`, 39.56666666666666}, {44.81666666666666, 
      39.63333333333333}, {43.166666666666664`, 40.583333333333336`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Armenia\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt0kENgDAQRNFNUIICLFQDN641UAuYQQeOsFCKBg4byEveT0bAzLWtdYqI
MtpHz+4HAAAAAAAAAPBW204SRXQAAAAAAAAAfqAsF4nyHwAAAAAAAAAA33cD
zcwcNg==
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt0kENgDAQRNFNUIICLFQDN641UAuYQQeOsFCKBg4byEveT0bAzLWtdYqI
MtpHz+4HAAAAAAAAAPBW204SRXQAAAAAAAAAfqAsF4nyHwAAAAAAAAAA33cD
zcwcNg==
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Armenia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt0kENgDAQRNFNUIICLFQDN641UAuYQQeOsFCKBg4byEveT0bAzLWtdYqI
MtpHz+4HAAAAAAAAAPBW204SRXQAAAAAAAAAfqAsF4nyHwAAAAAAAAAA33cD
zcwcNg==
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Armenia"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-70.0875, 12.5494}, {-70.0824, 12.6139}, {-70.079, 
      12.6407}, {-70.064, 12.6474}, {-70.0423, 12.6395}, {-70.0088, 
      12.6016}, {-69.9017, 12.538}, {-69.8397, 12.4912}, {-69.838, 
      12.4566}, {-69.8565, 12.4332}, {-69.8799, 12.4276}, {-70.0875, 
      12.5494}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Aruba\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2d1LU3EYB/Dh0BvFK70RvChBqJsCCzWN0KAgooYsr0rCyIiCQlovFjUK
NRILetEsnTlflzu6F3dmQ9PSVnPnnO2cnTMLvO3vsF8sbEERUe1h/r7wObDL
7/nux3MeztnSfKGh2WwymY6xy86ur78r+iQAAAAAAAAAAACATSn6uQIIra+b
AACAQ+QLAAAAkOiTTgMh8gUAAABItPieAiHyBQwAAAAAAAAAAAAAAAAAAAAA
OHRcSNYMKOQxuOUKKa3+JHkMbi1NzAhihDwGn/Y6FLWze2lkmjwJn2zehFFZ
Gb9264AzTh6GQ9MzYSknJ1Fe3i7q5GE4tOwUJJOJCfjekofhzcFhVb1yI9V/
xDFBnoc3HQEtUVaW6l87dcbqwgjKKDZzUuUz8eLiniAewRn1wTGx0T8TEubI
I/HgyJjWFUoGxbBy2JLev3SpzROMXBdX61/EyENuMuxRa59dnQ5GloenpIuX
1dLSH5pPo+3YKd+5tzjud81K533JPf0yefgstW8wZgt+mgzJrEzpZnt82/Zf
df5Tcm6uVrdfftA7/3J2MCg3CcYu6jvKItX9csfrtejCivb4+cejFqWg4I/K
3xArLDSsjQmnS4roV0Nr5PeVddihbZ7Uxn3hN6NetbPbqKqSzebfnPy8PKOu
Pnb/yYJLHApET7h1nPx/omZAsXk0j/9deMit2triRUXptatby+K377K/aVKM
nPPo1Zj8/9OhEZWd8PT+w2PeOmw+GcTGy/eZYzYLgffkkbjinFlhj9dU/3pN
basX7x8yqsmtJ62N3/acrof4CpxhbKtRehyp/tksIs/DoTl3iJWv5Oc7Rfow
HOrxS2pJiW5pOCkY5GE4ZBlPJFvOSr2Du5/Rh+FTtH/01dQ8eQxuzQeWHon4
8kLGLhpsCpHH4FYt1n4AAIC/8AWleHqW
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2d1LU3EYB/Dh0BvFK70RvChBqJsCCzWN0KAgooYsr0rCyIiCQlovFjUK
NRILetEsnTlflzu6F3dmQ9PSVnPnnO2cnTMLvO3vsF8sbEERUe1h/r7wObDL
7/nux3MeztnSfKGh2WwymY6xy86ur78r+iQAAAAAAAAAAACATSn6uQIIra+b
AACAQ+QLAAAAkOiTTgMh8gUAAABItPieAiHyBQwAAAAAAAAAAAAAAAAAAAAA
OHRcSNYMKOQxuOUKKa3+JHkMbi1NzAhihDwGn/Y6FLWze2lkmjwJn2zehFFZ
Gb9264AzTh6GQ9MzYSknJ1Fe3i7q5GE4tOwUJJOJCfjekofhzcFhVb1yI9V/
xDFBnoc3HQEtUVaW6l87dcbqwgjKKDZzUuUz8eLiniAewRn1wTGx0T8TEubI
I/HgyJjWFUoGxbBy2JLev3SpzROMXBdX61/EyENuMuxRa59dnQ5GloenpIuX
1dLSH5pPo+3YKd+5tzjud81K533JPf0yefgstW8wZgt+mgzJrEzpZnt82/Zf
df5Tcm6uVrdfftA7/3J2MCg3CcYu6jvKItX9csfrtejCivb4+cejFqWg4I/K
3xArLDSsjQmnS4roV0Nr5PeVddihbZ7Uxn3hN6NetbPbqKqSzebfnPy8PKOu
Pnb/yYJLHApET7h1nPx/omZAsXk0j/9deMit2triRUXptatby+K377K/aVKM
nPPo1Zj8/9OhEZWd8PT+w2PeOmw+GcTGy/eZYzYLgffkkbjinFlhj9dU/3pN
basX7x8yqsmtJ62N3/acrof4CpxhbKtRehyp/tksIs/DoTl3iJWv5Oc7Rfow
HOrxS2pJiW5pOCkY5GE4ZBlPJFvOSr2Du5/Rh+FTtH/01dQ8eQxuzQeWHon4
8kLGLhpsCpHH4FYt1n4AAIC/8AWleHqW
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Aruba", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2d1LU3EYB/Dh0BvFK70RvChBqJsCCzWN0KAgooYsr0rCyIiCQlovFjUK
NRILetEsnTlflzu6F3dmQ9PSVnPnnO2cnTMLvO3vsF8sbEERUe1h/r7wObDL
7/nux3MeztnSfKGh2WwymY6xy86ur78r+iQAAAAAAAAAAACATSn6uQIIra+b
AACAQ+QLAAAAkOiTTgMh8gUAAABItPieAiHyBQwAAAAAAAAAAAAAAAAAAAAA
OHRcSNYMKOQxuOUKKa3+JHkMbi1NzAhihDwGn/Y6FLWze2lkmjwJn2zehFFZ
Gb9264AzTh6GQ9MzYSknJ1Fe3i7q5GE4tOwUJJOJCfjekofhzcFhVb1yI9V/
xDFBnoc3HQEtUVaW6l87dcbqwgjKKDZzUuUz8eLiniAewRn1wTGx0T8TEubI
I/HgyJjWFUoGxbBy2JLev3SpzROMXBdX61/EyENuMuxRa59dnQ5GloenpIuX
1dLSH5pPo+3YKd+5tzjud81K533JPf0yefgstW8wZgt+mgzJrEzpZnt82/Zf
df5Tcm6uVrdfftA7/3J2MCg3CcYu6jvKItX9csfrtejCivb4+cejFqWg4I/K
3xArLDSsjQmnS4roV0Nr5PeVddihbZ7Uxn3hN6NetbPbqKqSzebfnPy8PKOu
Pnb/yYJLHApET7h1nPx/omZAsXk0j/9deMit2triRUXptatby+K377K/aVKM
nPPo1Zj8/9OhEZWd8PT+w2PeOmw+GcTGy/eZYzYLgffkkbjinFlhj9dU/3pN
basX7x8yqsmtJ62N3/acrof4CpxhbKtRehyp/tksIs/DoTl3iJWv5Oc7Rfow
HOrxS2pJiW5pOCkY5GE4ZBlPJFvOSr2Du5/Rh+FTtH/01dQ8eQxuzQeWHon4
8kLGLhpsCpHH4FYt1n4AAIC/8AWleHqW
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Aruba"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{144.63333333333333`, -38.333333333333336`}, {
       143.55, -38.86666666666667}, {140.36666666666667`, -37.95}, {
       139.48333333333332`, -35.916666666666664`}, {
       138.08333333333334`, -34.15}, {136.83333333333334`, -35.3}, {
       137.76666666666665`, -32.516666666666666`}, {
       135.95, -34.983333333333334`}, {
       133.78333333333333`, -32.21666666666667}, {
       131.2, -31.483333333333334`}, {
       125.98333333333333`, -32.31666666666666}, {
       120.01666666666667`, -33.93333333333333}, {117.95, -35.15}, {
       115.11666666666666`, -34.38333333333333}, {
       115.73333333333333`, -31.9}, {113.14999999999999`, -26.15}, {
       114.23333333333333`, -26.133333333333333`}, {
       113.39999999999999`, -24.166666666666668`}, {
       114.03333333333333`, -21.816666666666666`}, {
       116.81666666666666`, -20.5}, {
       121.03333333333333`, -19.53333333333333}, {
       122.93333333333334`, -16.366666666666667`}, {
       123.76666666666667`, -17.883333333333333`}, {
       123.61666666666666`, -16.133333333333333`}, {
       125.25, -15.583333333333334`}, {126.01666666666667`, -13.9}, {
       127.41666666666667`, -13.95}, {127.83333333333333`, -15.6}, {
       128.48333333333332`, -14.766666666666666`}, {
       130.2, -15.383333333333333`}, {129.7, -13.883333333333333`}, {
       131., -12.166666666666666`}, {
       132.68333333333334`, -12.183333333333334`}, {
       131.98333333333332`, -11.2}, {135.71666666666667`, -12.3}, {
       136.98333333333332`, -12.4}, {135.45, -14.983333333333333`}, {
       140.1, -17.716666666666665`}, {
       141.71666666666667`, -15.233333333333333`}, {
       142.13333333333333`, -11.033333333333333`}, {143.1, -12.2}, {
       143.78333333333333`, -14.383333333333333`}, {
       145.36666666666667`, -14.966666666666667`}, {
       146.28333333333333`, -18.883333333333333`}, {
       148.78333333333333`, -20.25}, {149.63333333333333`, -22.55}, {
       150.8, -22.53333333333333}, {152.91666666666666`, -25.3}, {
       153.61666666666667`, -28.78333333333333}, {
       150.21666666666667`, -35.733333333333334`}, {
       149.61666666666667`, -37.71666666666667}, {
       146.36666666666667`, -39.15}, {
       144.63333333333333`, -38.333333333333336`}}, {{
       153.03333333333333`, -25.766666666666666`}, {
       153.26666666666665`, -24.7}, {
       153.03333333333333`, -25.766666666666666`}}, {{
       145.76666666666665`, -43.166666666666664`}, {
       144.7, -40.68333333333333}, {148.35, -40.96666666666667}, {
       147.98333333333332`, -43.18333333333333}, {
       145.76666666666665`, -43.15}}, {{
       130.93333333333334`, -11.933333333333334`}, {
       130.38333333333333`, -11.2}, {131.43333333333334`, -11.3}, {
       130.93333333333334`, -11.933333333333334`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Australia\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXHtMU1ccLkrBPTI3Y7LEZEvUZZlOQhghzMwRnoJDkTH+cn/MwQQqDJ3L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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXHtMU1ccLkrBPTI3Y7LEZEvUZZlOQhghzMwRnoJDkTH+cn/MwQQqDJ3L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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Australia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztXHtMU1ccLkrBPTI3Y7LEZEvUZZlOQhghzMwRnoJDkTH+cn/MwQQqDJ3L
NidmKrosbtPFiWOJJgw3DZsTxgaEwXjLw9piLSvy6GhvBRZ1Smmhtiiwr96u
t94OvH0eHvfmI/md3z33/L7z/U7vPfeeE5an7EhKWSgQCMLxtx9/ZlsgSOPB
gwcPHjx48ODBA3j66fdZxqzA0qW7Vq7MsffDiVPE6XFHcXH74sU7nnxyBwzi
ZLhDKBT19l5ftuwDWyeKcOIUcXrcUV4ur6vrAmAQJ+MQILVCMbBkyU66CANF
OIkT44InnshOTv42M/OsWKyavH/AQBFOnCJOjwsqKjpA++LFvscffxeAgSKc
xIlxxCuvHK6t7Zq0OVCEkzgxjjh2rIam/ccfnQBtw0mcGHckJn5jqz+KxClx
R1bW2Um7A07ixDgCv1m1+p/q6s7BQS0AA0U4iRObim1SUn56+vd79/6CQX72
7EWZTGOvP5w4hQqohsq4ZMb26Lnncp555iMYR49WAzBQhJM4samwceNxirpl
r/lUByrjEuK0H4pXX/0cIE6DCx57LOvIkap798anVx4VUA2ViRPmggUL0gHi
NLgjKOjgpUuqqcTHKVQgTnJu49Ch8qn0xyni9OY2Xnrp0N2796bSH6dQgTjJ
uQqhUCSX99NS6/V3DAYTbcNAkbZRYXZ9hZhFOHDgNygskajT0r7H3LKwsIXW
HAaKcOIUiqhGnOrcw8qVOXl5tcHBzO1l06Y8Wn8YVicqoNr/fiDl4V74+2/X
6e4AMIiTmZ/ACy9AnMa8xRtv5APEacxbPPpoFkCcBg8ePFzH4sU7Nm8+4eub
sWXLKeJk5idUqpt//60tKGgmzmQeIjn5W6NxDG80/f23AwNzifOZV/DxMS8H
vPVWwciIMTr6KP8hixREojNubE1XV9cVFiYRCMzw9VVt3WpUKqVSKj7emfUp
etl69PJlS4M2gHPS2YVskAEl1tdUXUNDV3g490beeec0y5gJoPsyXFPTtW4d
k4WUFGNfX2vrXzExX5HVHwRAg6W8vqmpOzKSbpZ7U42NPfv3/wrAIC47S39L
Fqqqrq5dy2QhNdWoUjU0dIeFfeF9/REUodnKt7R0x8RY2+Qy/hcsSF+6dNeL
L+4rL5fTjcBAEc6ZsLZo30dtZeXV0FC6g1KhUL1tm1Gtrq7ufPnlz7yjPwIh
HIvVSFtbT2ystbXuiAhdfT3IP7Q1TNqPH68dH39gYRpFOHGKuP6C+7/xtrY+
dhYqKjpDQpgspKWZKAojZ/rnvov6o3HrKGWUF4t7NmxglI+MxJ0fhB26N772
2te2baLoRgFDQy0j8/nn9zqd002b8i5fZu/b0ZaVdQYHW7Lg56fOyDBpNMXF
7QEBB9yrPxpEs2zlJZLe+HhG+agoXWMjSNouKHBEaalseNhgMJgAGCi6Uf+8
vFo8Vlas2ENRt/z8nF/dwxQXrxgKxQBLh6HSUkVQkDULlEhk1GiKisQvvPCJ
6/qjETQ1MTFhG3G0vb03IYFRPjoaz1wQAz2QdLRfq1fv27Ll1COPZJ4+3QrA
QBFOd+n/3ns/mseq1gD9XW8NT6U33zzV23udnYWSEkVgoCUL/v5UZqaB0hQW
ttguZjmkPy7E5awtQ6MymTIxkVE+JkZ/4QLIgJLrj8vXX/8GcJfsQqHo4MGy
wUGt7ZYDZAHzq1Wr2CPTUfj6ZqSmFqrV/9iKg1F6+/x5RUAAk4WsLGTh5Mmm
Z5/dzV1/VMYlrJ0SBrlcmZQk8fGh6/esX69vbgYB0AAZtyjmie/hGzceh+bW
XhQUNLtxmzruZtu3nxkYGGJn4dy5P9essWRh0SJNdvaIWoPb4Ntvfze9/qiA
aibT3QeU7+hQJiczysfGYp6JoAjtyu3UO8C7oW1ffv9d4dAdMjz8y4cCM40T
J+qGhkZZWbhVVIRRikk40BMXhxsULew0+o+NPTDmx02mG/n5mEzSjSAL+tZW
BEI4BOXCjaz4S5bszM+vx3zg8OFK/ArwTMnNLcNDinsLkx44ptHf7Qfx8U8D
87czZ5xZ6dbV1bkdN0+etNcfTk/EIq68Fc59kbYXanaBuOwugriAvP6zGsQF
5PWf1SAu4IzVPyTkU5bB6+9N/ZublXFxxwAYnovCzz+nwg8/tN25MwbA8FwU
T7wTzer3r6ee2gnBb97UW5dsYKAIJ065PRyXd3xg166f5PJ+fWurMjmZ/lbQ
HRFxIz9/3GRySP+JiYmhkpKeuDjLV4v1628VFbE+PiMQwnEk5okxuXBh+ocf
/mxLCUU4PfcrmAZRUUebmnr1LS3M8p+PD7Jg6OhgyS4Wq3Jzy6bXHxVQbWxw
UJOdLV20iD7155o1t8+dY2UBQRGaSJeB3buLbcmg6H0OkZFHGht79M3NGKWM
8klJBjl7iRCS0vtVOH5/RmVcYhoYoLKypP7+dAVFQMDt8+dZWQAB0PByx5cv
/1gm0+TklFy5cg2AgSKc3lb+wgXbzQbKxMRRmYyl/KVLKtudQg6tv+BCXG7q
76cyM5ksBAbiBsWK4uUsWNdw9+wpAVhOjyIi4khDQ7d5g010tFW63oSE0Xb2
4iyks/8fAk6sP6IRcxauXaNEIqmfnyULQUFDpaWsiCAGel7LguD+2qj9GquH
gGcZOqhrbOyOimKUj48fkUhYOkgk6qn+e4PT6+9oEM2aNBp1RoY1C53Bwdqy
MvssEP/s73bl6+u7dejYf5vKgJ4NG0bEYnvlp9974OL+EzRuzgJFqdPSpEKh
JQshIdqKChYTEJ4bWTArj7+ICEb52NiRtjZWf6VSisuuD7fsv0IghDOq1ept
26xZuBoaqq2stM8CcQFdBCbhVonMmw1aWuyVT0jgut/GjfsPEdScBZVKlZoq
8fW1ZGHt2uGqKlt6xAV0ERblIyPxzGUp395Obd58wqHW3L7/FgRAw9jXp0pJ
sWaha9264ZqauaE/xj/u/K4r7yH9H8iCUqnaupXJQljYjFp/dA7/AsceTYk=

        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "Australia"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.733333333333333, 47.53333333333333}, {
      13.049999999999999`, 47.5}, {13.833333333333334`, 
      48.766666666666666`}, {17.166666666666668`, 48.016666666666666`}, {
      16.116666666666667`, 46.86666666666667}, {13.716666666666667`, 
      46.53333333333333}, {10.466666666666667`, 46.86666666666667}, {9.6, 
      47.06666666666666}, {9.533333333333333, 47.266666666666666`}, {
      9.733333333333333, 47.53333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Austria\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2rEJAkEARcEDK7EOE2sQbOAaMDTUTg0EzbwSdLUCs4c4j1nYcPnxrufD
bl5N07Qf5zzO+34BAAAAAAAAAAAAAL523Wzu2y2JMf6yLE9FLZ/qV/xv9m+z
f5v92+zfZv82+7fZv83+bfZvs3+b/dvs32b/Nvu32b/N/m32b7N/m/3b7N9m
/zb7t9m/zf5t9m+zf5v928b4t+PxcTqRGOPnH+ABAAAAAAAAAAB+1AvJzH5S

              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2rEJAkEARcEDK7EOE2sQbOAaMDTUTg0EzbwSdLUCs4c4j1nYcPnxrufD
bl5N07Qf5zzO+34BAAAAAAAAAAAAAL523Wzu2y2JMf6yLE9FLZ/qV/xv9m+z
f5v92+zfZv82+7fZv83+bfZvs3+b/dvs32b/Nvu32b/N/m32b7N/m/3b7N9m
/zb7t9m/zf5t9m+zf5v928b4t+PxcTqRGOPnH+ABAAAAAAAAAAB+1AvJzH5S

          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Austria", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2rEJAkEARcEDK7EOE2sQbOAaMDTUTg0EzbwSdLUCs4c4j1nYcPnxrufD
bl5N07Qf5zzO+34BAAAAAAAAAAAAAL523Wzu2y2JMf6yLE9FLZ/qV/xv9m+z
f5v92+zfZv82+7fZv83+bfZvs3+b/dvs32b/Nvu32b/N/m32b7N/m/3b7N9m
/zb7t9m/zf5t9m+zf5v928b4t+PxcTqRGOPnH+ABAAAAAAAAAAB+1AvJzH5S

        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Austria"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{44.81666666666666, 39.63333333333333}, {
       46.166666666666664`, 39.56666666666666}, {46.766666666666666`, 
       39.06666666666666}, {46.166666666666664`, 38.833333333333336`}, {
       44.81666666666666, 39.63333333333333}}, {{47.483333333333334`, 
       39.35}, {46.35, 40.31666666666666}, {45.016666666666666`, 41.2}, {
       47.05, 40.75}, {46.3, 41.81666666666666}, {47.85, 41.21666666666667}, {
       48.583333333333336`, 41.833333333333336`}, {50.4, 
       40.233333333333334`}, {48.88333333333333, 38.45}, {48.13333333333333, 
       39.6}, {47.483333333333334`, 39.35}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Azerbaijan\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2d9LWmEYwHFhf8n+BiPtFwhhUZDB6BfdSD+uutlF14U3XUSIRETWVVRX
dRURBV0XBJpaig5kc5nLrTVmonMtbU8UB5nD2XS8HPc9fJRz8b7wnMdz3uc5
ry9HX78afWEwGCzyccjn4dywbAQAAAAAAAAAAAAAAFVamrZDIY/RqBcnLS3R
ycmE2/1pa+tydTU2MxPs71ce1X+hsVHSns/l7kuOb7FYZGxMfYT1KzgwkAmH
tYTnM5nrvb240xkZHw/b7e9nZ6+2t+XX8ZrNykOtP5Lh/O2tlvyb4+PTnp7S
YX6r9cPKiqehQXnA9cTb3CzLi5b8i4WF8uNDg4NPE5ualAdfB5IbG1ryU4eH
lUwJdHbK98fNTeXB691Zb28hn39M/l06HejqKj/e397+dmrKZ7GEhodlYqC7
22syvXM4TlpblV+LHsVdLu3m/7y7W8kUeUZyicSNxyNTvh4dfU8mr/f3lV+I
Tn05ONDyfz43V8kU6YiKW9NCoaBVBDxX2ufTMhkZGSk/+Mxmu1hczEajv7wd
SOMqz5GsRcovR3fIv1qsP2pRf9X6y/6zrY3+s1Yu19ae+/7l7+jw8P5VI16z
ubik/nH/IdjX9zSR/YcakcXkLpstfgp+uxAFrNaE283+279warM9llStFkg5
lo5ImlIhJ1c7Ow/7zyaT8lDrmOT5Ryp1X3LIAhW26+lfPP2SO/zNxER8fl7K
a3J9/dzpDA0NKY+qSkvTLihkWPYAAAAAAAAAAAAAAIAq/QSzSYc/
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2d9LWmEYwHFhf8n+BiPtFwhhUZDB6BfdSD+uutlF14U3XUSIRETWVVRX
dRURBV0XBJpaig5kc5nLrTVmonMtbU8UB5nD2XS8HPc9fJRz8b7wnMdz3uc5
ry9HX78afWEwGCzyccjn4dywbAQAAAAAAAAAAAAAAFVamrZDIY/RqBcnLS3R
ycmE2/1pa+tydTU2MxPs71ce1X+hsVHSns/l7kuOb7FYZGxMfYT1KzgwkAmH
tYTnM5nrvb240xkZHw/b7e9nZ6+2t+XX8ZrNykOtP5Lh/O2tlvyb4+PTnp7S
YX6r9cPKiqehQXnA9cTb3CzLi5b8i4WF8uNDg4NPE5ualAdfB5IbG1ryU4eH
lUwJdHbK98fNTeXB691Zb28hn39M/l06HejqKj/e397+dmrKZ7GEhodlYqC7
22syvXM4TlpblV+LHsVdLu3m/7y7W8kUeUZyicSNxyNTvh4dfU8mr/f3lV+I
Tn05ONDyfz43V8kU6YiKW9NCoaBVBDxX2ufTMhkZGSk/+Mxmu1hczEajv7wd
SOMqz5GsRcovR3fIv1qsP2pRf9X6y/6zrY3+s1Yu19ae+/7l7+jw8P5VI16z
ubik/nH/IdjX9zSR/YcakcXkLpstfgp+uxAFrNaE283+279warM9llStFkg5
lo5ImlIhJ1c7Ow/7zyaT8lDrmOT5Ryp1X3LIAhW26+lfPP2SO/zNxER8fl7K
a3J9/dzpDA0NKY+qSkvTLihkWPYAAAAAAAAAAAAAAIAq/QSzSYc/
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Azerbaijan", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2d9LWmEYwHFhf8n+BiPtFwhhUZDB6BfdSD+uutlF14U3XUSIRETWVVRX
dRURBV0XBJpaig5kc5nLrTVmonMtbU8UB5nD2XS8HPc9fJRz8b7wnMdz3uc5
ry9HX78afWEwGCzyccjn4dywbAQAAAAAAAAAAAAAAFVamrZDIY/RqBcnLS3R
ycmE2/1pa+tydTU2MxPs71ce1X+hsVHSns/l7kuOb7FYZGxMfYT1KzgwkAmH
tYTnM5nrvb240xkZHw/b7e9nZ6+2t+XX8ZrNykOtP5Lh/O2tlvyb4+PTnp7S
YX6r9cPKiqehQXnA9cTb3CzLi5b8i4WF8uNDg4NPE5ualAdfB5IbG1ryU4eH
lUwJdHbK98fNTeXB691Zb28hn39M/l06HejqKj/e397+dmrKZ7GEhodlYqC7
22syvXM4TlpblV+LHsVdLu3m/7y7W8kUeUZyicSNxyNTvh4dfU8mr/f3lV+I
Tn05ONDyfz43V8kU6YiKW9NCoaBVBDxX2ufTMhkZGSk/+Mxmu1hczEajv7wd
SOMqz5GsRcovR3fIv1qsP2pRf9X6y/6zrY3+s1Yu19ae+/7l7+jw8P5VI16z
ubik/nH/IdjX9zSR/YcakcXkLpstfgp+uxAFrNaE283+279warM9llStFkg5
lo5ImlIhJ1c7Ow/7zyaT8lDrmOT5Ryp1X3LIAhW26+lfPP2SO/zNxER8fl7K
a3J9/dzpDA0NKY+qSkvTLihkWPYAAAAAAAAAAAAAAIAq/QSzSYc/
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "Azerbaijan"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-77.8622, 24.5191}, {-77.8837, 24.5231}, {-77.9142, 
       24.5201}, {-78.0482, 24.4703}, {-78.0681, 24.4551}, {-78.0803, 
       24.3698}, {-78.0529, 24.3149}, {-78.0635, 24.3048}, {-78.0773, 
       24.3038}, {-78.155, 24.3657}, {-78.1764, 24.4043}, {-78.251, 
       24.4825}, {-78.3607, 24.5445}, {-78.443, 24.5678}, {-78.4613, 
       24.5861}, {-78.4567, 24.5953}, {-78.4125, 24.6115}, {-78.3971, 
       24.6302}, {-78.3851, 24.6643}, {-78.3728, 24.6846}, {-78.3534, 
       24.6917}, {-78.3087, 24.6807}, {-78.2952, 24.6836}, {-78.2952, 
       24.6988}, {-78.3135, 24.7415}, {-78.3119, 24.7527}, {-78.2677, 
       24.7923}, {-78.1671, 24.8908}, {-78.1534, 24.9325}, {-78.1809, 
       25.0269}, {-78.2251, 25.1518}, {-78.2281, 25.1671}, {-78.2174, 
       25.1742}, {-78.1809, 25.1691}, {-78.1229, 25.1163}, {-78.0985, 
       25.1112}, {-78.0803, 25.1142}, {-78.0147, 25.1488}, {-77.9888, 
       25.1518}, {-77.9644, 25.1427}, {-77.9324, 25.0624}, {-77.9218, 
       25.0208}, {-77.8974, 24.968}, {-77.8699, 24.9527}, {-77.8607, 
       24.8583}, {-77.7465, 24.7222}, {-77.7007, 24.646}, {-77.7236, 
       24.5181}, {-77.6809, 24.447}, {-77.6794, 24.4165}, {-77.6916, 
       24.3891}, {-77.786, 24.3556}, {-77.8821, 24.2956}, {-77.9339, 
       24.2916}, {-77.975, 24.2987}, {-78.0344, 24.3444}, {-78.0482, 
       24.3708}, {-78.0375, 24.4246}, {-78.0009, 24.4551}, {-77.9201, 
       24.4866}, {-77.8699, 24.5008}, {-77.8622, 24.5191}}, CompressedData["
1:eJxdlAtQVGUUxzckMAvSkEZa8JFYKWDjpuJ3ZOXA7sLKQ4QPKI0NDVaBQZGC
NIbwtcwSiARKECoOiqEFWDEw0vT4zBBcRXeUSQLUSUHISVkFQyGpc3cmdsY7
c++d3/3Od8/j/793zvtpUXo7mUympVO6P2zuyn+i4UI3rhq9e57h/+w1o7Tj
uTaGnwas6zMHcWFwiji5v4WhTDq0Nv5iAQWu5MLcsOZhs4lh5WDN2dBQLqbX
B/+R1cEwkLa/GsEFXbsfX2fosTZx+Q3i6i3KKVdvMUy8oAttIzZUtn91qY+h
Wd1pGV7FRcgLdl7G2wwVW33mzArjImrloR2v3WRYvvml3SKEi5Twob28l6HP
d4cGa4gT7q0NXDHAMKt1PpRQ/ky7isnyewx9XxHvzg7nYjQn5YeMIYbWuNVc
nDZVaZqIHePLw1yjuaCiCsso/tdvF24+GsPF3sx0uZOF4ZkrXnq3WC6MNW+b
FMMM+8dO3L9M683/GIe7Rxj+7HzwrSO0P37++amtowyltJVRXBTnjMGWcYZN
hmxzQyQXybK0nfbPAg6nxn5ST/05XnSL7Hoe0OVBwKUNVF/qtqxj3i6Ary+a
XOtO/XhKCeQ2/myRNAhAilK5U3+uHuf6/D0BndJrC7ppPg47S1UF3jDRryRf
kgIw5vTx6lW03jT0pGMbs/HJeb27K5WAS/1+jPqc4qXHqAK0ykMcNI8mqAWM
Pfx1XSfl8z/b02gIAwz+4PGLfwbbuC75eno++YO6//5UOKDSu6PiNvlnxIEG
GwM4FrepZZzW6zvjP4p4D7DhzoeNrrT/sB8FbgCcLr1IzUVS8d1s/0zA9gt0
EDtaXtauzgYk1fbNIL894reOHTAAms4E1iXT/Kw+yYcJ/3wzqX/PG4WAWH3j
J2fSt4hneJYVAQbsutlaTutpZBtTMaCF7OlL/ZE6F/NKYMI/Vb8tHlxWCvhX
5KmZuSouFpxwMavzAJ8JJ6f7c2HNYwSUylyygovQNkflgVxAa59KLpiGJrMd
cKM6Oc1C3JNEgmcAyt+85ulAbFJIzqL6o2nSwEX5tX3G3BTAliISlnEhlVel
B8zxWLZRTRxN5f+7DvDLKaQExQ+keP1dpgNM2P678mM/Lqw+1Nnyl+rzEnRx
gHtC7tgvJh48R4NaAziNZCmk/eP6kd71kTYuiaMPnvRK1PUETfKz6d3o++iX
ROqvS569XqEBrNh68MjcAOLa0bhNxO8cX9K+PJAL6fPLUAO62cc6+5C+6oLU
/jHy11Uao4b0pSqmLXUHnFkzoF1IfHQuGdoe8On/zX9KwhQy
       "], {{-76.0924, 24.6304}, {-76.0983, 24.6194}, {-76.1055, 
       24.613}, {-76.1233, 24.6115}, {-76.1743, 24.6336}, {-76.2609, 
       24.7222}, {-76.3606, 24.7783}, {-76.3689, 24.7949}, {-76.3581, 
       24.8044}, {-76.3345, 24.8044}, {-76.2597, 24.7696}, {-76.2229, 
       24.7704}, {-76.1494, 24.802}, {-76.1423, 24.8218}, {-76.1636, 
       24.8945}, {-76.1719, 24.8953}, {-76.1802, 24.8906}, {-76.1897, 
       24.8597}, {-76.2028, 24.851}, {-76.2229, 24.8518}, {-76.2324, 
       24.8692}, {-76.2335, 24.9356}, {-76.1885, 25.0203}, {-76.1778, 
       25.1017}, {-76.2063, 25.1578}, {-76.3427, 25.282}, {-76.5172, 
       25.3539}, {-76.5409, 25.3808}, {-76.5433, 25.399}, {-76.5278, 
       25.4085}, {-76.4887, 25.4006}, {-76.4448, 25.3634}, {-76.3617, 
       25.3373}, {-76.325, 25.3365}, {-76.1517, 25.2148}, {-76.1114, 
       25.1871}, {-76.1114, 25.157}, {-76.1422, 25.0788}, {-76.1339, 
       25.0187}, {-76.0699, 24.9135}, {-76.0722, 24.8684}, {-76.1209, 
       24.7743}, {-76.1291, 24.7237}, {-76.0924, 24.6304}}, {{-78.9249, 
       26.6349}, {-78.941, 26.648}, {-78.9428, 26.66}, {-78.9231, 
       26.6659}, {-78.8515, 26.6635}, {-78.7565, 26.6468}, {-78.7171, 
       26.6325}, {-78.71, 26.6194}, {-78.7117, 26.5812}, {-78.6992, 
       26.5716}, {-78.6885, 26.5716}, {-78.6688, 26.5847}, {-78.6616, 
       26.6134}, {-78.6365, 26.6277}, {-78.5774, 26.6397}, {-78.4842, 
       26.6528}, {-78.3445, 26.7185}, {-78.1116, 26.7877}, {-77.9683, 
       26.8032}, {-77.9163, 26.802}, {-77.8841, 26.7805}, {-77.8805, 
       26.728}, {-77.8519, 26.7137}, {-77.8232, 26.7173}, {-77.8035, 
       26.7686}, {-77.7695, 26.7781}, {-77.7552, 26.7758}, {-77.7534, 
       26.7614}, {-77.7767, 26.7364}, {-77.7784, 26.7053}, {-77.7767, 
       26.6767}, {-77.8017, 26.6504}, {-77.8447, 26.6397}, {-78.0328, 
       26.6528}, {-78.1743, 26.6444}, {-78.4251, 26.6003}, {-78.6347, 
       26.5275}, {-78.6992, 26.5191}, {-78.7386, 26.5239}, {-78.9249, 
       26.6349}}, {{-72.9993, 21.234}, {-73.0148, 21.2012}, {-73.1465, 
       21.0521}, {-73.2037, 20.9477}, {-73.2177, 20.9086}, {-73.2414, 
       20.8944}, {-73.2865, 20.8868}, {-73.3357, 20.888}, {-73.4179, 
       20.8829}, {-73.4707, 20.8679}, {-73.5332, 20.8687}, {-73.5771, 
       20.8805}, {-73.6115, 20.8805}, {-73.6471, 20.86}, {-73.6756, 
       20.8592}, {-73.7041, 20.871}, {-73.7147, 20.8837}, {-73.7201, 
       20.9533}, {-73.7746, 21.0086}, {-73.7711, 21.0205}, {-73.7545, 
       21.0276}, {-73.7082, 21.0221}, {-73.694, 21.0268}, {-73.6928, 
       21.0347}, {-73.7213, 21.0703}, {-73.7177, 21.0814}, {-73.697, 
       21.0893}, {-73.6388, 21.0853}, {-73.615, 21.0869}, {-73.5901, 
       21.1043}, {-73.5901, 21.151}, {-73.5736, 21.1628}, {-73.4917, 
       21.1763}, {-73.4603, 21.2047}, {-73.4484, 21.2285}, {-73.4271, 
       21.2356}, {-73.4057, 21.2332}, {-73.3618, 21.2087}, {-73.3037, 
       21.1881}, {-73.2254, 21.1747}, {-73.1738, 21.1794}, {-73.1417, 
       21.1913}, {-73.1109, 21.2174}, {-73.0918, 21.2822}, {-73.0777, 
       21.2965}, {-73.0646, 21.2988}, {-73.0385, 21.2901}, {-73.0041, 
       21.2641}, {-72.9975, 21.249}, {-72.9993, 21.234}}, {{-74.8262, 
       22.8695}, {-74.8321, 22.865}, {-74.8448, 22.8616}, {-74.8575, 
       22.865}, {-74.893, 22.9039}, {-74.9623, 22.9901}, {-75.0503, 
       23.0385}, {-75.1119, 23.0498}, {-75.1719, 23.0723}, {-75.2895, 
       23.1416}, {-75.3022, 23.1529}, {-75.2996, 23.1613}, {-75.2793, 
       23.163}, {-75.2252, 23.1422}, {-75.1661, 23.0949}, {-75.1475, 
       23.0921}, {-75.1323, 23.1011}, {-75.1314, 23.1242}, {-75.1568, 
       23.1726}, {-75.1982, 23.203}, {-75.2134, 23.2171}, {-75.2151, 
       23.2289}, {-75.188, 23.252}, {-75.1686, 23.2847}, {-75.1737, 
       23.3253}, {-75.1838, 23.3625}, {-75.2421, 23.4104}, {-75.254, 
       23.4323}, {-75.2523, 23.4763}, {-75.2692, 23.5382}, {-75.2751, 
       23.5501}, {-75.3258, 23.5579}, {-75.3503, 23.5636}, {-75.3816, 
       23.5777}, {-75.3943, 23.5963}, {-75.396, 23.6154}, {-75.3994, 
       23.6531}, {-75.3748, 23.6644}, {-75.3326, 23.6515}, {-75.2379, 
       23.5782}, {-75.1974, 23.5326}, {-75.1948, 23.4706}, {-75.1568, 
       23.4036}, {-75.1103, 23.3467}, {-75.1154, 23.2306}, {-75.079, 
       23.1157}, {-74.9928, 23.0621}, {-74.9209, 23.0396}, {-74.8533, 
       22.9866}, {-74.8262, 22.8695}}, {{-74.2515, 22.1487}, {-74.2699, 
       22.1441}, {-74.2822, 22.146}, {-74.293, 22.1595}, {-74.2889, 
       22.1758}, {-74.2679, 22.2084}, {-74.1674, 22.2654}, {-74.147, 
       22.2916}, {-74.1131, 22.3088}, {-74.1049, 22.3297}, {-74.1022, 
       22.3559}, {-74.0913, 22.3677}, {-74.0425, 22.3839}, {-74.0289, 
       22.3993}, {-74.0289, 22.422}, {-74.0186, 22.4364}, {-73.9385, 
       22.4898}, {-73.9331, 22.5486}, {-73.9413, 22.5722}, {-73.9562, 
       22.5821}, {-73.9983, 22.5848}, {-74.0906, 22.641}, {-74.1042, 
       22.6581}, {-74.1042, 22.6771}, {-74.0818, 22.6925}, {-74.0614, 
       22.6962}, {-74.0289, 22.6916}, {-74.0044, 22.6916}, {-73.9827, 
       22.7052}, {-73.9474, 22.7188}, {-73.8849, 22.7314}, {-73.8605, 
       22.7278}, {-73.8503, 22.698}, {-73.8897, 22.6247}, {-73.8747, 
       22.5839}, {-73.8231, 22.5287}, {-73.8136, 22.5079}, {-73.8163, 
       22.4916}, {-73.9175, 22.4473}, {-73.9813, 22.3731}, {-73.9922, 
       22.3333}, {-74.0098, 22.3134}, {-74.2515, 22.1487}}, {{-75.5632, 
       23.3873}, {-75.546, 23.386}, {-75.5412, 23.3815}, {-75.5441, 
       23.3726}, {-75.5729, 23.3617}, {-75.6093, 23.3585}, {-75.6688, 
       23.3707}, {-75.7302, 23.4103}, {-75.8002, 23.4135}, {-75.8434, 
       23.4205}, {-75.8731, 23.4359}, {-75.9834, 23.5247}, {-76.0016, 
       23.5311}, {-76.0179, 23.5311}, {-76.0582, 23.5043}, {-76.0736, 
       23.5017}, {-76.086, 23.5094}, {-76.0888, 23.5247}, {-76.0783, 
       23.5516}, {-76.0649, 23.6149}, {-76.0764, 23.6647}, {-76.0707, 
       23.6711}, {-76.0563, 23.6762}, {-76.0026, 23.6596}, {-75.9219, 
       23.5855}, {-75.8644, 23.4832}, {-75.8251, 23.4634}, {-75.7599, 
       23.4551}, {-75.7234, 23.4468}, {-75.6793, 23.4167}, {-75.6102, 
       23.3879}, {-75.5632, 23.3873}}, {{-77.5655, 24.1137}, {-77.4856, 
       23.9787}, {-77.4342, 23.8968}, {-77.4389, 23.8664}, {-77.4579, 
       23.8512}, {-77.4903, 23.8442}, {-77.5055, 23.8353}, {-77.5112, 
       23.8182}, {-77.4884, 23.7282}, {-77.4951, 23.685}, {-77.5217, 
       23.6711}, {-77.5645, 23.6692}, {-77.6093, 23.68}, {-77.6597, 
       23.7168}, {-77.7025, 23.7846}, {-77.7367, 23.9235}, {-77.7567, 
       23.9806}, {-77.7519, 24.0009}, {-77.7072, 24.0281}, {-77.5931, 
       24.1068}, {-77.5798, 24.1169}, {-77.5731, 24.1188}, {-77.5655, 
       24.1137}}, {{-75.3694, 24.2904}, {-75.3107, 24.2248}, {-75.3089, 
       24.177}, {-75.3236, 24.1621}, {-75.3789, 24.1609}, {-75.4238, 
       24.1511}, {-75.46, 24.1316}, {-75.4851, 24.1327}, {-75.543, 
       24.1632}, {-75.5499, 24.1759}, {-75.5387, 24.1885}, {-75.4212, 
       24.2496}, {-75.4168, 24.2622}, {-75.4419, 24.3129}, {-75.5274, 
       24.4234}, {-75.5667, 24.478}, {-75.603, 24.4959}, {-75.6565, 
       24.512}, {-75.6678, 24.5258}, {-75.6686, 24.5471}, {-75.6617, 
       24.5868}, {-75.6708, 24.6029}, {-75.7373, 24.6381}, {-75.7572, 
       24.6622}, {-75.7554, 24.6709}, {-75.7459, 24.6789}, {-75.7174, 
       24.6806}, {-75.6423, 24.6622}, {-75.5688, 24.6283}, {-75.4972, 
       24.5206}, {-75.4415, 24.4619}, {-75.3871, 24.3388}, {-75.3694, 
       24.2904}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Bahamas\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3GlIFGEYB/B3ZmfmXXd1191V17XTTrAQKTIK0w6jpOhDZUSRkBgVld1R
CBFCgRFGB3bS8aEgOiiptMNq6VorLWszsIMO6Ia+CUG1zexMKLW62+7sPHO8
f/4LfvN5frDv6u7MZpYun15qQgiN5R+b+IfwcyAQqG17ceL5S1LlW/fiJe/P
prnZbTvNza2kCndMyzPeHwVD54/F56+Aj2SodvYXYk5gVqzB9x6DD2aQ/u0f
DDVwEHf4OPhsRqjkT1Hon5hmzMJeH/iE+m43/kKcLnbzVvAhdVzJn6ZD+4uv
y7mjuLN14KPqspH4C+E4ZvEy3PgIfGCdVfI3mcL4i6/Lffqy+4+Az6ynSv4M
E4m/dBxNmYYbboNPro9G4S/EZmc2VuKmp+Dza72iP8Ww/+cfDJUzjDt5DnwF
TTcWfyEMY5q/AN9pBl9Eo5X82Wj9xSdCRg921z7wXbRYWfzF0BMn40te8I20
Vcmf42L3F2K1Musq8AM/+F5aqcz+wVBZQ7njp8BX00QlfyynvxCaNs2Zh2/d
B19Q5R3/pD4u/mLIx2rhOuHJad6fNuO4+AdDPlYL64/N4d5/iy3mBHpxRa+G
VyO8b3NJO7fxzUze35LQxfv/siY7C905jwKfSDva/n6kYv58+F+zsAR9a4Nf
XCUV/a0WhfzFuFPRsRr43dVQEH8xhfnouQ9eQA3+idb4vv52Ff7Prsp16Ps7
eAdj+osZ3B9dPwNPAeiflAjpL6akGH1phQcxrD8fZzI6WI1+fYRnUdjflqQK
fzF5ucjvhZcxrD8flkEbylH7a3gfZfztNnX5o+BZdO4ovI8B/fl/Rcrmoq/P
4HEU80+2q8V/eDbyXYRnMaC/w45qqtDPD/Amyvs7kiH9+QNn/mz0+Sm8hgH9
c4YY+k1p0d/piOj6W3ljT0K7tqAf7+ERDOhfUow++eHXB6/o73Iq55+dhW7W
wi+ukor+KYr42xLR9kqjHzgh/RmHLd74dNFUfJlcnRj6+gfGaY+fPNVvAHfg
KPim6uwff0dc6C0WZuVacjd3Ny143BT0d8luT08qwvU3wBdUecXrP+X1pzL7
sXsPga+miUr+rhR56M0JTPkq3NgCvpdWKqM/XTgJ110D30hblfxTUmORF+4L
rjkIvosWG6u/2cwsXUHui4/VPzUaf3p8Ib5wFXwFTTc6f6pXb3LDo5z+aWmR
0mMsfBGHjxw4AP50wTiO3MkSB382zR3mwOnRk92xB3xa/TW8P8cxC5fguw/B
R9VlJX93eugDJy+fq70EPqSO25U/5clgq3eDj6f7Sv7png56ljWVLSJfaQLi
T4/OI1+1B+DvyUDpHnKvOpR/0foN5U0tq1vbSBVulV/wJwHMbz/4efs=
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3GlIFGEYB/B3ZmfmXXd1191V17XTTrAQKTIK0w6jpOhDZUSRkBgVld1R
CBFCgRFGB3bS8aEgOiiptMNq6VorLWszsIMO6Ia+CUG1zexMKLW62+7sPHO8
f/4LfvN5frDv6u7MZpYun15qQgiN5R+b+IfwcyAQqG17ceL5S1LlW/fiJe/P
prnZbTvNza2kCndMyzPeHwVD54/F56+Aj2SodvYXYk5gVqzB9x6DD2aQ/u0f
DDVwEHf4OPhsRqjkT1Hon5hmzMJeH/iE+m43/kKcLnbzVvAhdVzJn6ZD+4uv
y7mjuLN14KPqspH4C+E4ZvEy3PgIfGCdVfI3mcL4i6/Lffqy+4+Az6ynSv4M
E4m/dBxNmYYbboNPro9G4S/EZmc2VuKmp+Dza72iP8Ww/+cfDJUzjDt5DnwF
TTcWfyEMY5q/AN9pBl9Eo5X82Wj9xSdCRg921z7wXbRYWfzF0BMn40te8I20
Vcmf42L3F2K1Musq8AM/+F5aqcz+wVBZQ7njp8BX00QlfyynvxCaNs2Zh2/d
B19Q5R3/pD4u/mLIx2rhOuHJad6fNuO4+AdDPlYL64/N4d5/iy3mBHpxRa+G
VyO8b3NJO7fxzUze35LQxfv/siY7C905jwKfSDva/n6kYv58+F+zsAR9a4Nf
XCUV/a0WhfzFuFPRsRr43dVQEH8xhfnouQ9eQA3+idb4vv52Ff7Prsp16Ps7
eAdj+osZ3B9dPwNPAeiflAjpL6akGH1phQcxrD8fZzI6WI1+fYRnUdjflqQK
fzF5ucjvhZcxrD8flkEbylH7a3gfZfztNnX5o+BZdO4ovI8B/fl/Rcrmoq/P
4HEU80+2q8V/eDbyXYRnMaC/w45qqtDPD/Amyvs7kiH9+QNn/mz0+Sm8hgH9
c4YY+k1p0d/piOj6W3ljT0K7tqAf7+ERDOhfUow++eHXB6/o73Iq55+dhW7W
wi+ukor+KYr42xLR9kqjHzgh/RmHLd74dNFUfJlcnRj6+gfGaY+fPNVvAHfg
KPim6uwff0dc6C0WZuVacjd3Ny143BT0d8luT08qwvU3wBdUecXrP+X1pzL7
sXsPga+miUr+rhR56M0JTPkq3NgCvpdWKqM/XTgJ110D30hblfxTUmORF+4L
rjkIvosWG6u/2cwsXUHui4/VPzUaf3p8Ib5wFXwFTTc6f6pXb3LDo5z+aWmR
0mMsfBGHjxw4AP50wTiO3MkSB382zR3mwOnRk92xB3xa/TW8P8cxC5fguw/B
R9VlJX93eugDJy+fq70EPqSO25U/5clgq3eDj6f7Sv7png56ljWVLSJfaQLi
T4/OI1+1B+DvyUDpHnKvOpR/0foN5U0tq1vbSBVulV/wJwHMbz/4efs=
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Bahamas", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3GlIFGEYB/B3ZmfmXXd1191V17XTTrAQKTIK0w6jpOhDZUSRkBgVld1R
CBFCgRFGB3bS8aEgOiiptMNq6VorLWszsIMO6Ia+CUG1zexMKLW62+7sPHO8
f/4LfvN5frDv6u7MZpYun15qQgiN5R+b+IfwcyAQqG17ceL5S1LlW/fiJe/P
prnZbTvNza2kCndMyzPeHwVD54/F56+Aj2SodvYXYk5gVqzB9x6DD2aQ/u0f
DDVwEHf4OPhsRqjkT1Hon5hmzMJeH/iE+m43/kKcLnbzVvAhdVzJn6ZD+4uv
y7mjuLN14KPqspH4C+E4ZvEy3PgIfGCdVfI3mcL4i6/Lffqy+4+Az6ynSv4M
E4m/dBxNmYYbboNPro9G4S/EZmc2VuKmp+Dza72iP8Ww/+cfDJUzjDt5DnwF
TTcWfyEMY5q/AN9pBl9Eo5X82Wj9xSdCRg921z7wXbRYWfzF0BMn40te8I20
Vcmf42L3F2K1Musq8AM/+F5aqcz+wVBZQ7njp8BX00QlfyynvxCaNs2Zh2/d
B19Q5R3/pD4u/mLIx2rhOuHJad6fNuO4+AdDPlYL64/N4d5/iy3mBHpxRa+G
VyO8b3NJO7fxzUze35LQxfv/siY7C905jwKfSDva/n6kYv58+F+zsAR9a4Nf
XCUV/a0WhfzFuFPRsRr43dVQEH8xhfnouQ9eQA3+idb4vv52Ff7Prsp16Ps7
eAdj+osZ3B9dPwNPAeiflAjpL6akGH1phQcxrD8fZzI6WI1+fYRnUdjflqQK
fzF5ucjvhZcxrD8flkEbylH7a3gfZfztNnX5o+BZdO4ovI8B/fl/Rcrmoq/P
4HEU80+2q8V/eDbyXYRnMaC/w45qqtDPD/Amyvs7kiH9+QNn/mz0+Sm8hgH9
c4YY+k1p0d/piOj6W3ljT0K7tqAf7+ERDOhfUow++eHXB6/o73Iq55+dhW7W
wi+ukor+KYr42xLR9kqjHzgh/RmHLd74dNFUfJlcnRj6+gfGaY+fPNVvAHfg
KPim6uwff0dc6C0WZuVacjd3Ny143BT0d8luT08qwvU3wBdUecXrP+X1pzL7
sXsPga+miUr+rhR56M0JTPkq3NgCvpdWKqM/XTgJ110D30hblfxTUmORF+4L
rjkIvosWG6u/2cwsXUHui4/VPzUaf3p8Ib5wFXwFTTc6f6pXb3LDo5z+aWmR
0mMsfBGHjxw4AP50wTiO3MkSB382zR3mwOnRk92xB3xa/TW8P8cxC5fguw/B
R9VlJX93eugDJy+fq70EPqSO25U/5clgq3eDj6f7Sv7png56ljWVLSJfaQLi
T4/OI1+1B+DvyUDpHnKvOpR/0foN5U0tq1vbSBVulV/wJwHMbz/4efs=
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Bahamas"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{50.402, 25.9856}, {50.4191, 26.1301}, {50.4996, 26.316}, {
      50.529, 26.3294}, {50.5879, 26.3397}, {50.6529, 26.3181}, {50.6607, 
      26.2757}, {50.622, 26.1694}, {50.5863, 25.8968}, {50.5554, 25.8647}, {
      50.5166, 25.8627}, {50.433, 25.9319}, {50.402, 25.9856}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Bahrain\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnXlsVEUcx6t4X+GU+ygSUUBFjIkXeCQaUNHQgDUKEptAqUdKqaJAlApp
NGjjgUqIJYRiVERBEEWEtpS2abVUqoiCjcLbt92ju2+P7vF234VveM3s+o+p
5r35TbO/b75N+u/3M2lnfvN+M5NfVFpQNCAvL2+B+VNh/pDfz/ZBhiVdNzSN
WFUNRTHSaeJUypBl03oyqScSqbafwqte65pym5A3CN0X94X//5ByqjO64V3v
nbOF8weDZ+TZDvGn0vzdseqa7rmPuy4dCR6WQzvNn0qPxxO7vg4uLhGHTARP
zY+Z8acypw+5vjG0fJU7/ybw+OBmz793FGQ5sfMrccRkcAI5xV8PhWPbPu1+
9AmcDljy1zzenk1b/PfPEy4cBh6ZKzuKXf3rTLTqfVyFMuavnPg9sv5Nz82z
wNPxb3vJp9s7cEoF5G9KPS1E39nku3eucMFQ8HT823b+VJoUim/f0T1/sevK
seAxubVz/KmMVCr5zQFp6XJx5HXgeXkzA/6ZgdD1VGsbbpBC8c+WKojRtza6
J9wITiAH+Ssn/4hUVnlm3A0eH9wssaePnwivfd0z7Q7w1PyYBfb2jvDqdV2T
bwUPy6EdYm4YhjnVhl58tWvidPCMPNtm7LouN7aESl92j50GHq1f2F7+ye8O
kU1OrHyB+FvSI9H4JzsDhUWuq8aBB+TcTvCnMtJp8y9CKil3j54CnpRPO8o/
MxDmdPxju7kK8ky9HTwyV2bDP1tK559m5eubOUcYMAQ8PrjZ86dSTwvi0GvA
CeQa/3TH8fArlbgFx5J/7///lyq6Js0Aj8yVncWu66mmllDZavf4G8CT8mlH
sGuaXHdEevYF96jrwQNybnvJp1rbgktKxcH54Ln6i+3lryeTib37g0XPicMm
gUfrF7aXPxX5F9TQHFqxBvc/QfhnK/3zr5F1G8jXrvPg8/JmBvypVEHseW+z
775HcIMUhD+VJoVIF3TBItflo8EJ5CB/Uo79cDS0cq17XK7XBUyxm+VYcyuW
Y4z5k4+SDc3S8yvxKwBL/mQJWtsglZRjRzRL/oaiJA/UkioYSzDm/JVTna6B
48FD9SPby/+s1e28/6BUXIabbyD8MwNxrgULu52h+GcLr4OA5U+l+fyxj7b5
Hy4ULhkBnp0HM+ZPRc6/f7EH10gA5GmP6Jip4PHBzRS7VQXjuoghf1IF1zdK
z5Tj4TuW/MklM4cOS8tWiMOvBc/Is23Hnvy+jhw1zfmJFYR/qqkl8OQSPHAN
xd+SoSjywXrS/4OnYCD4ZwbCMMiNlGvW45lHEP7Z6m07vwvbzmH4U1k3UuIW
BBR/S6Qcq23AuyhZYz/3dUwqLsO6gCV/0he6e1/wqWXioAngkbmys9ij5CAq
uYIp5/usWPLXAsHYlu3+hwqFi4eDB+Tc9pJP7PmWtHfiChOIP9l2qztC9vZz
/mIlEP7ZSh/7JVLxhmf6TPCMPNs5/lR4IyUsfyotKJG283kLcTkEwp8Kj4nB
89+9L7CoGJsVmWKPxeI7dgUee9p1xRjw4JyYBfZwJF7zGb65wJg/qYKra/xz
FggXXQ0ek1vbj93j7fmgGg85gvBXXSL5woXnfIH4W9K8PvLaywMF+NoLCH8q
PRQmM69ZcF02Cjwpn3aUf2YgEonEl3sDC5figh+EP1XvjZTFZXgoEoR/ZiAM
Qz7chPfvsSdPyrGPP8fLHxjzJyePNm/1z56P5RhL/uoZV/TtD32zHsSPkiz5
K7+djFRWeW+5B2uxfzd51d2y9bY7tapmrCj/sPXyO33/nVqW00eP4VMX/8l/
AwRYfwk=
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnXlsVEUcx6t4X+GU+ygSUUBFjIkXeCQaUNHQgDUKEptAqUdKqaJAlApp
NGjjgUqIJYRiVERBEEWEtpS2abVUqoiCjcLbt92ju2+P7vF234VveM3s+o+p
5r35TbO/b75N+u/3M2lnfvN+M5NfVFpQNCAvL2+B+VNh/pDfz/ZBhiVdNzSN
WFUNRTHSaeJUypBl03oyqScSqbafwqte65pym5A3CN0X94X//5ByqjO64V3v
nbOF8weDZ+TZDvGn0vzdseqa7rmPuy4dCR6WQzvNn0qPxxO7vg4uLhGHTARP
zY+Z8acypw+5vjG0fJU7/ybw+OBmz793FGQ5sfMrccRkcAI5xV8PhWPbPu1+
9AmcDljy1zzenk1b/PfPEy4cBh6ZKzuKXf3rTLTqfVyFMuavnPg9sv5Nz82z
wNPxb3vJp9s7cEoF5G9KPS1E39nku3eucMFQ8HT823b+VJoUim/f0T1/sevK
seAxubVz/KmMVCr5zQFp6XJx5HXgeXkzA/6ZgdD1VGsbbpBC8c+WKojRtza6
J9wITiAH+Ssn/4hUVnlm3A0eH9wssaePnwivfd0z7Q7w1PyYBfb2jvDqdV2T
bwUPy6EdYm4YhjnVhl58tWvidPCMPNtm7LouN7aESl92j50GHq1f2F7+ye8O
kU1OrHyB+FvSI9H4JzsDhUWuq8aBB+TcTvCnMtJp8y9CKil3j54CnpRPO8o/
MxDmdPxju7kK8ky9HTwyV2bDP1tK559m5eubOUcYMAQ8PrjZ86dSTwvi0GvA
CeQa/3TH8fArlbgFx5J/7///lyq6Js0Aj8yVncWu66mmllDZavf4G8CT8mlH
sGuaXHdEevYF96jrwQNybnvJp1rbgktKxcH54Ln6i+3lryeTib37g0XPicMm
gUfrF7aXPxX5F9TQHFqxBvc/QfhnK/3zr5F1G8jXrvPg8/JmBvypVEHseW+z
775HcIMUhD+VJoVIF3TBItflo8EJ5CB/Uo79cDS0cq17XK7XBUyxm+VYcyuW
Y4z5k4+SDc3S8yvxKwBL/mQJWtsglZRjRzRL/oaiJA/UkioYSzDm/JVTna6B
48FD9SPby/+s1e28/6BUXIabbyD8MwNxrgULu52h+GcLr4OA5U+l+fyxj7b5
Hy4ULhkBnp0HM+ZPRc6/f7EH10gA5GmP6Jip4PHBzRS7VQXjuoghf1IF1zdK
z5Tj4TuW/MklM4cOS8tWiMOvBc/Is23Hnvy+jhw1zfmJFYR/qqkl8OQSPHAN
xd+SoSjywXrS/4OnYCD4ZwbCMMiNlGvW45lHEP7Z6m07vwvbzmH4U1k3UuIW
BBR/S6Qcq23AuyhZYz/3dUwqLsO6gCV/0he6e1/wqWXioAngkbmys9ij5CAq
uYIp5/usWPLXAsHYlu3+hwqFi4eDB+Tc9pJP7PmWtHfiChOIP9l2qztC9vZz
/mIlEP7ZSh/7JVLxhmf6TPCMPNs5/lR4IyUsfyotKJG283kLcTkEwp8Kj4nB
89+9L7CoGJsVmWKPxeI7dgUee9p1xRjw4JyYBfZwJF7zGb65wJg/qYKra/xz
FggXXQ0ek1vbj93j7fmgGg85gvBXXSL5woXnfIH4W9K8PvLaywMF+NoLCH8q
PRQmM69ZcF02Cjwpn3aUf2YgEonEl3sDC5figh+EP1XvjZTFZXgoEoR/ZiAM
Qz7chPfvsSdPyrGPP8fLHxjzJyePNm/1z56P5RhL/uoZV/TtD32zHsSPkiz5
K7+djFRWeW+5B2uxfzd51d2y9bY7tapmrCj/sPXyO33/nVqW00eP4VMX/8l/
AwRYfwk=
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Bahrain", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnXlsVEUcx6t4X+GU+ygSUUBFjIkXeCQaUNHQgDUKEptAqUdKqaJAlApp
NGjjgUqIJYRiVERBEEWEtpS2abVUqoiCjcLbt92ju2+P7vF234VveM3s+o+p
5r35TbO/b75N+u/3M2lnfvN+M5NfVFpQNCAvL2+B+VNh/pDfz/ZBhiVdNzSN
WFUNRTHSaeJUypBl03oyqScSqbafwqte65pym5A3CN0X94X//5ByqjO64V3v
nbOF8weDZ+TZDvGn0vzdseqa7rmPuy4dCR6WQzvNn0qPxxO7vg4uLhGHTARP
zY+Z8acypw+5vjG0fJU7/ybw+OBmz793FGQ5sfMrccRkcAI5xV8PhWPbPu1+
9AmcDljy1zzenk1b/PfPEy4cBh6ZKzuKXf3rTLTqfVyFMuavnPg9sv5Nz82z
wNPxb3vJp9s7cEoF5G9KPS1E39nku3eucMFQ8HT823b+VJoUim/f0T1/sevK
seAxubVz/KmMVCr5zQFp6XJx5HXgeXkzA/6ZgdD1VGsbbpBC8c+WKojRtza6
J9wITiAH+Ssn/4hUVnlm3A0eH9wssaePnwivfd0z7Q7w1PyYBfb2jvDqdV2T
bwUPy6EdYm4YhjnVhl58tWvidPCMPNtm7LouN7aESl92j50GHq1f2F7+ye8O
kU1OrHyB+FvSI9H4JzsDhUWuq8aBB+TcTvCnMtJp8y9CKil3j54CnpRPO8o/
MxDmdPxju7kK8ky9HTwyV2bDP1tK559m5eubOUcYMAQ8PrjZ86dSTwvi0GvA
CeQa/3TH8fArlbgFx5J/7///lyq6Js0Aj8yVncWu66mmllDZavf4G8CT8mlH
sGuaXHdEevYF96jrwQNybnvJp1rbgktKxcH54Ln6i+3lryeTib37g0XPicMm
gUfrF7aXPxX5F9TQHFqxBvc/QfhnK/3zr5F1G8jXrvPg8/JmBvypVEHseW+z
775HcIMUhD+VJoVIF3TBItflo8EJ5CB/Uo79cDS0cq17XK7XBUyxm+VYcyuW
Y4z5k4+SDc3S8yvxKwBL/mQJWtsglZRjRzRL/oaiJA/UkioYSzDm/JVTna6B
48FD9SPby/+s1e28/6BUXIabbyD8MwNxrgULu52h+GcLr4OA5U+l+fyxj7b5
Hy4ULhkBnp0HM+ZPRc6/f7EH10gA5GmP6Jip4PHBzRS7VQXjuoghf1IF1zdK
z5Tj4TuW/MklM4cOS8tWiMOvBc/Is23Hnvy+jhw1zfmJFYR/qqkl8OQSPHAN
xd+SoSjywXrS/4OnYCD4ZwbCMMiNlGvW45lHEP7Z6m07vwvbzmH4U1k3UuIW
BBR/S6Qcq23AuyhZYz/3dUwqLsO6gCV/0he6e1/wqWXioAngkbmys9ij5CAq
uYIp5/usWPLXAsHYlu3+hwqFi4eDB+Tc9pJP7PmWtHfiChOIP9l2qztC9vZz
/mIlEP7ZSh/7JVLxhmf6TPCMPNs5/lR4IyUsfyotKJG283kLcTkEwp8Kj4nB
89+9L7CoGJsVmWKPxeI7dgUee9p1xRjw4JyYBfZwJF7zGb65wJg/qYKra/xz
FggXXQ0ek1vbj93j7fmgGg85gvBXXSL5woXnfIH4W9K8PvLaywMF+NoLCH8q
PRQmM69ZcF02Cjwpn3aUf2YgEonEl3sDC5figh+EP1XvjZTFZXgoEoR/ZiAM
Qz7chPfvsSdPyrGPP8fLHxjzJyePNm/1z56P5RhL/uoZV/TtD32zHsSPkiz5
K7+djFRWeW+5B2uxfzd51d2y9bY7tapmrCj/sPXyO33/nVqW00eP4VMX/8l/
AwRYfwk=
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Bahrain"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{92.2, 21.15}, {91.48333333333333, 22.916666666666668`}, {
      89.25, 23.95}, {90.61666666666666, 22.366666666666667`}, {
      89.03333333333333, 21.916666666666668`}, {89.01666666666667, 
      25.28333333333333}, {88.41666666666667, 26.633333333333333`}, {89.85, 
      25.28333333333333}, {92.4, 25.03333333333333}, {91.16666666666667, 
      23.633333333333333`}, {91.61666666666666, 22.95}, {92.28333333333333, 
      23.633333333333333`}, {92.6, 21.983333333333334`}, {92.2, 21.15}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Bangladesh\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3VtI01EcwPE5s3JuO+fMLS9pppap5bUUUzM1Mc0LNtKm85ZR9FDUY4F0
pQii20sRFV0IgiiiIoweqoeCIoIioiioh6joSkXZxR46cyCj6Wy48//9/v//
ga/Q0/bvs7P/Oee//TW5Z62zJ9xgMDTzn838x/PvmBVJlk7HsJk77AGK6ogO
kKndJvufHMsTwI9Bz0l/2Ow9k8GPQc9Jf+mv56S/9Ndz0l/66znpD1t0Tzz4
Meg56S/99Rxm/4RmltfAqquYu5SuKmKNlbRoEUtxsig3Az82Tfpz2IpquieD
PraQP4ZAvTCR84lk5VzGXyPww9aAf30lOzSdvh0/Crt/vw3klp325tLpi1X5
QoD7F9ey6zFBs/v3zUj2ZtDEJSp7FWzL4qCeOqOJnZ5KB8Ys79unCOuWbOpY
Cg+L2t/NdmXS3yGV9+3VRMJnanBbnP42l+1MEhUkP9SPMMKXTOC82Pz56vFO
tFh53/i7DPliVUn//Hr2ZoJy+N74MhXzS6CYP18fvoy0Kozv7XgKAXeG9Y9p
sd2nAPJDbcij4NRQ/pY21hcnfMINHF9rOcsxnoVYt3D/A2nA+N6+hltzGtC9
BKL9S2tYaHdYY+nGJHQTgWj/a6G4thDCmipwTQRC/RsqUZx5fOPLAFTLUXH+
/L95j8GD+7e8WBf+rjIGTj1sz6OICc1bQJz/2Snw1CM1fyGWWUCQP2tln8fB
7Hb/p12ZWPxpd6yIh3WWo5t5fXtiwbIQFeR/ZBpqf15+PYopQJD/a8WvcwZb
by6KU5AI/4RmpCsf307guCgqwr+gTgX+V2M169+Ib9vr30OiWf9VRSoY/x8j
NOu/NVsF459nd8H7k66YkD/m7gx1+Kc44ZegIvzX56vA/1cYsbRp07+7RAX+
LyOt4PiC/GsXqGD+vWtDMf+K8Odbe3DeUbuQoFn/eDXsfw+mobj+IMKfx3c3
4MKB6yzRsv/2Wain4H4jiW2BX/zwrF2TRDzs3FrUp6ArcSgGvzh/k5s9j4J3
HqnVhVr3b7ftT4d3HrYBz84XXl60f04D43tMcG3/LuJYeYr25x3G9ykkHxKz
cXzyqIA/f5t/Ccf1LYiTyYgGv2h/3g5MC9HvRpLehGjwK+Bvd9mUv+dopPal
4xr8PEunQ/RTVFexHwgm4psOylpxDX5l/HnrCoDPQs/MZArKW+OV8ecdTQXD
/xBB8vDd+aKwP2lltxW883eofiMpR/NtW0B/0+BdkOcTFcV/P57UVCEd+cr7
e3KzjTlUmX3xUzPJxXraAfMfrLGSvgv+V/0E1S07xTnh/pO5ww7yvDOa2Dkx
5yK+1t2UQ80IvtuA2d8bnxn5QA2VPD+tHUshaar6RViw/t5cZeyRdaz4l+Mp
/rM9Tn9vc+rYtiwa1AfH342kL46uKaSpaK7nq9d/qKQlbGsW5fu1S5PpnWjP
7Yo/wzwfmryeQB5Qz/fGTyXTnTNp2zxG8V1P0ID/8MepkvlUq/5aTfrDJv9W
mvTXc9Jf+us56S/99Zz0l/4ymUwmk+mtvyaaXNs=
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3VtI01EcwPE5s3JuO+fMLS9pppap5bUUUzM1Mc0LNtKm85ZR9FDUY4F0
pQii20sRFV0IgiiiIoweqoeCIoIioiioh6joSkXZxR46cyCj6Wy48//9/v//
ga/Q0/bvs7P/Oee//TW5Z62zJ9xgMDTzn838x/PvmBVJlk7HsJk77AGK6ogO
kKndJvufHMsTwI9Bz0l/2Ow9k8GPQc9Jf+mv56S/9Ndz0l/66znpD1t0Tzz4
Meg56S/99Rxm/4RmltfAqquYu5SuKmKNlbRoEUtxsig3Az82Tfpz2IpquieD
PraQP4ZAvTCR84lk5VzGXyPww9aAf30lOzSdvh0/Crt/vw3klp325tLpi1X5
QoD7F9ey6zFBs/v3zUj2ZtDEJSp7FWzL4qCeOqOJnZ5KB8Ys79unCOuWbOpY
Cg+L2t/NdmXS3yGV9+3VRMJnanBbnP42l+1MEhUkP9SPMMKXTOC82Pz56vFO
tFh53/i7DPliVUn//Hr2ZoJy+N74MhXzS6CYP18fvoy0Kozv7XgKAXeG9Y9p
sd2nAPJDbcij4NRQ/pY21hcnfMINHF9rOcsxnoVYt3D/A2nA+N6+hltzGtC9
BKL9S2tYaHdYY+nGJHQTgWj/a6G4thDCmipwTQRC/RsqUZx5fOPLAFTLUXH+
/L95j8GD+7e8WBf+rjIGTj1sz6OICc1bQJz/2Snw1CM1fyGWWUCQP2tln8fB
7Hb/p12ZWPxpd6yIh3WWo5t5fXtiwbIQFeR/ZBpqf15+PYopQJD/a8WvcwZb
by6KU5AI/4RmpCsf307guCgqwr+gTgX+V2M169+Ib9vr30OiWf9VRSoY/x8j
NOu/NVsF459nd8H7k66YkD/m7gx1+Kc44ZegIvzX56vA/1cYsbRp07+7RAX+
LyOt4PiC/GsXqGD+vWtDMf+K8Odbe3DeUbuQoFn/eDXsfw+mobj+IMKfx3c3
4MKB6yzRsv/2Wain4H4jiW2BX/zwrF2TRDzs3FrUp6ArcSgGvzh/k5s9j4J3
HqnVhVr3b7ftT4d3HrYBz84XXl60f04D43tMcG3/LuJYeYr25x3G9ykkHxKz
cXzyqIA/f5t/Ccf1LYiTyYgGv2h/3g5MC9HvRpLehGjwK+Bvd9mUv+dopPal
4xr8PEunQ/RTVFexHwgm4psOylpxDX5l/HnrCoDPQs/MZArKW+OV8ecdTQXD
/xBB8vDd+aKwP2lltxW883eofiMpR/NtW0B/0+BdkOcTFcV/P57UVCEd+cr7
e3KzjTlUmX3xUzPJxXraAfMfrLGSvgv+V/0E1S07xTnh/pO5ww7yvDOa2Dkx
5yK+1t2UQ80IvtuA2d8bnxn5QA2VPD+tHUshaar6RViw/t5cZeyRdaz4l+Mp
/rM9Tn9vc+rYtiwa1AfH342kL46uKaSpaK7nq9d/qKQlbGsW5fu1S5PpnWjP
7Yo/wzwfmryeQB5Qz/fGTyXTnTNp2zxG8V1P0ID/8MepkvlUq/5aTfrDJv9W
mvTXc9Jf+us56S/99Zz0l/4ymUwmk+mtvyaaXNs=
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Bangladesh", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3VtI01EcwPE5s3JuO+fMLS9pppap5bUUUzM1Mc0LNtKm85ZR9FDUY4F0
pQii20sRFV0IgiiiIoweqoeCIoIioiioh6joSkXZxR46cyCj6Wy48//9/v//
ga/Q0/bvs7P/Oee//TW5Z62zJ9xgMDTzn838x/PvmBVJlk7HsJk77AGK6ogO
kKndJvufHMsTwI9Bz0l/2Ow9k8GPQc9Jf+mv56S/9Ndz0l/66znpD1t0Tzz4
Meg56S/99Rxm/4RmltfAqquYu5SuKmKNlbRoEUtxsig3Az82Tfpz2IpquieD
PraQP4ZAvTCR84lk5VzGXyPww9aAf30lOzSdvh0/Crt/vw3klp325tLpi1X5
QoD7F9ey6zFBs/v3zUj2ZtDEJSp7FWzL4qCeOqOJnZ5KB8Ys79unCOuWbOpY
Cg+L2t/NdmXS3yGV9+3VRMJnanBbnP42l+1MEhUkP9SPMMKXTOC82Pz56vFO
tFh53/i7DPliVUn//Hr2ZoJy+N74MhXzS6CYP18fvoy0Kozv7XgKAXeG9Y9p
sd2nAPJDbcij4NRQ/pY21hcnfMINHF9rOcsxnoVYt3D/A2nA+N6+hltzGtC9
BKL9S2tYaHdYY+nGJHQTgWj/a6G4thDCmipwTQRC/RsqUZx5fOPLAFTLUXH+
/L95j8GD+7e8WBf+rjIGTj1sz6OICc1bQJz/2Snw1CM1fyGWWUCQP2tln8fB
7Hb/p12ZWPxpd6yIh3WWo5t5fXtiwbIQFeR/ZBpqf15+PYopQJD/a8WvcwZb
by6KU5AI/4RmpCsf307guCgqwr+gTgX+V2M169+Ib9vr30OiWf9VRSoY/x8j
NOu/NVsF459nd8H7k66YkD/m7gx1+Kc44ZegIvzX56vA/1cYsbRp07+7RAX+
LyOt4PiC/GsXqGD+vWtDMf+K8Odbe3DeUbuQoFn/eDXsfw+mobj+IMKfx3c3
4MKB6yzRsv/2Wain4H4jiW2BX/zwrF2TRDzs3FrUp6ArcSgGvzh/k5s9j4J3
HqnVhVr3b7ftT4d3HrYBz84XXl60f04D43tMcG3/LuJYeYr25x3G9ykkHxKz
cXzyqIA/f5t/Ccf1LYiTyYgGv2h/3g5MC9HvRpLehGjwK+Bvd9mUv+dopPal
4xr8PEunQ/RTVFexHwgm4psOylpxDX5l/HnrCoDPQs/MZArKW+OV8ecdTQXD
/xBB8vDd+aKwP2lltxW883eofiMpR/NtW0B/0+BdkOcTFcV/P57UVCEd+cr7
e3KzjTlUmX3xUzPJxXraAfMfrLGSvgv+V/0E1S07xTnh/pO5ww7yvDOa2Dkx
5yK+1t2UQ80IvtuA2d8bnxn5QA2VPD+tHUshaar6RViw/t5cZeyRdaz4l+Mp
/rM9Tn9vc+rYtiwa1AfH342kL46uKaSpaK7nq9d/qKQlbGsW5fu1S5PpnWjP
7Yo/wzwfmryeQB5Qz/fGTyXTnTNp2zxG8V1P0ID/8MepkvlUq/5aTfrDJv9W
mvTXc9Jf+us56S/99Zz0l/4ymUwmk+mtvyaaXNs=
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "Bangladesh"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-59.4225, 13.0362}, {-59.483, 13.0184}, {-59.5168, 
      13.0196}, {-59.5577, 13.0315}, {-59.6484, 13.0955}, {-59.6715, 
      13.2555}, {-59.6555, 13.2804}, {-59.6288, 13.2851}, {-59.5879, 
      13.278}, {-59.5684, 13.2555}, {-59.5257, 13.1832}, {-59.4865, 
      13.1559}, {-59.4172, 13.131}, {-59.4047, 13.105}, {-59.3994, 
      13.0706}, {-59.4225, 13.0362}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Barbados\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2ktIVFEYB/DjM7G0h4skCrKICtGsjOyBSkTRAxPNsqAoy8oyM1qEbhwQ
M4o2SS2KHhQUiYuiNKiFWklZmo9aRNamRfQA6f3U7Lvd4z33XmZyHrc5xPl/
fHOZ831nRH4zc+bMvZNQsCenIIwxlkc3F920+4ydkpgHylwDj5nEpH9ArgD8
pSPAX9mEP/ylI8Bf2YQ//KUjwF/ZhD/8pSPAX9mEP/ylI8Bf2YQ//KUjwF/Z
hD/8pSPAX9mEP/ylI8Bf2YT/f+r/6xHLnKPlinTtSEP4B9P/RwfTIzpKO9IQ
/sH0/9LG/YdFaEcawj+Y/h9auX9YqHakIfyD6d/bwsxBQ/gH0//NLYs/DeEf
TP+XjRZ/GsI/mP4vblr8aQj/f+p/pYZv+PVMS7b409Dcpcnwd9a/sph5HzQZ
/s76F6/zwZ8mw99Z/7wlPvjTZPg7658+m9vGx7GKIvvbgYZUpJYeNBn+zvpP
S+C265fzijn0CrX0oMnwd9Z/dCy3rSpx46+f/zy4lw9pMvwd9H97W1BfPurG
v79bq9QfFxV6CPyd8r9wSMA+rXfj39elVcxfys5Xw98x/41ZXDUqklPb/H92
8uLIEbySvwz+zvjT2m5sbFKmiro5jOsvC2fyyphY8UzBPxD/jjrhbGx+bP7f
B/2L1orinXPwd8C/ulSQ1pS79//azou07BtRXgh/B/znpwjSngb3/sb1x9fN
LGSwmDgZ/oH6mxefSeMtLXN8fiDqs6aLeuNp+Afkv2mVwKS13ZP/p/uiXrZV
1LMXwd9//1dN/OcNetjO6pvjo8m/+ayoh4aw59fh76d/RZGQjAi3INv8zb9/
oL1oTLRolW6Avz/+3x6ysXGCMS3ZPsEc7+9ZWksXiFbscHsX/t74n3RZhIn0
L/7v7lpaKzMs3cP74O+bP60n8XEWQ1p/6IPVmFBVYumat/p0PyrS0h0V4/F0
HPzdsuwvYLag17++ySH5bavtXYrCXO3zgibQXjQr097dngd/b/2fNbDIcEEX
Fqo9HcYZnqYz7Noxlppo4aUhFY3dfn83c+3U3jJG0Eaosw7+XvmbX71zk1h7
rRu3vi62K5/P2bHG/ak2+u5m/plKRir8h/a/cUKzmhDPNmez1osePzcH/pwX
nTeDJU3hF188Zdslbb2aOE77s7VH4D+Ef0+Dt5euKLfksNzF3k7ubWFPrsJ/
CH+fsnK3ZVPkR8I/EL3AE/7wh7+yCX/4S0eAv7IJf/hLR4C/sgl/+EtHgL+y
CX/4S0eAv7IJf/hLR4C/sgl/+EtHgL+yCX/4S0eAv7IJ/99u+/jC
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2ktIVFEYB/DjM7G0h4skCrKICtGsjOyBSkTRAxPNsqAoy8oyM1qEbhwQ
M4o2SS2KHhQUiYuiNKiFWklZmo9aRNamRfQA6f3U7Lvd4z33XmZyHrc5xPl/
fHOZ831nRH4zc+bMvZNQsCenIIwxlkc3F920+4ydkpgHylwDj5nEpH9ArgD8
pSPAX9mEP/ylI8Bf2YQ//KUjwF/ZhD/8pSPAX9mEP/ylI8Bf2YQ//KUjwF/Z
hD/8pSPAX9mEP/ylI8Bf2YT/f+r/6xHLnKPlinTtSEP4B9P/RwfTIzpKO9IQ
/sH0/9LG/YdFaEcawj+Y/h9auX9YqHakIfyD6d/bwsxBQ/gH0//NLYs/DeEf
TP+XjRZ/GsI/mP4vblr8aQj/f+p/pYZv+PVMS7b409Dcpcnwd9a/sph5HzQZ
/s76F6/zwZ8mw99Z/7wlPvjTZPg7658+m9vGx7GKIvvbgYZUpJYeNBn+zvpP
S+C265fzijn0CrX0oMnwd9Z/dCy3rSpx46+f/zy4lw9pMvwd9H97W1BfPurG
v79bq9QfFxV6CPyd8r9wSMA+rXfj39elVcxfys5Xw98x/41ZXDUqklPb/H92
8uLIEbySvwz+zvjT2m5sbFKmiro5jOsvC2fyyphY8UzBPxD/jjrhbGx+bP7f
B/2L1orinXPwd8C/ulSQ1pS79//azou07BtRXgh/B/znpwjSngb3/sb1x9fN
LGSwmDgZ/oH6mxefSeMtLXN8fiDqs6aLeuNp+Afkv2mVwKS13ZP/p/uiXrZV
1LMXwd9//1dN/OcNetjO6pvjo8m/+ayoh4aw59fh76d/RZGQjAi3INv8zb9/
oL1oTLRolW6Avz/+3x6ysXGCMS3ZPsEc7+9ZWksXiFbscHsX/t74n3RZhIn0
L/7v7lpaKzMs3cP74O+bP60n8XEWQ1p/6IPVmFBVYumat/p0PyrS0h0V4/F0
HPzdsuwvYLag17++ySH5bavtXYrCXO3zgibQXjQr097dngd/b/2fNbDIcEEX
Fqo9HcYZnqYz7Noxlppo4aUhFY3dfn83c+3U3jJG0Eaosw7+XvmbX71zk1h7
rRu3vi62K5/P2bHG/ak2+u5m/plKRir8h/a/cUKzmhDPNmez1osePzcH/pwX
nTeDJU3hF188Zdslbb2aOE77s7VH4D+Ef0+Dt5euKLfksNzF3k7ubWFPrsJ/
CH+fsnK3ZVPkR8I/EL3AE/7wh7+yCX/4S0eAv7IJf/hLR4C/sgl/+EtHgL+y
CX/4S0eAv7IJf/hLR4C/sgl/+EtHgL+yCX/4S0eAv7IJ/99u+/jC
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Barbados", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2ktIVFEYB/DjM7G0h4skCrKICtGsjOyBSkTRAxPNsqAoy8oyM1qEbhwQ
M4o2SS2KHhQUiYuiNKiFWklZmo9aRNamRfQA6f3U7Lvd4z33XmZyHrc5xPl/
fHOZ831nRH4zc+bMvZNQsCenIIwxlkc3F920+4ydkpgHylwDj5nEpH9ArgD8
pSPAX9mEP/ylI8Bf2YQ//KUjwF/ZhD/8pSPAX9mEP/ylI8Bf2YQ//KUjwF/Z
hD/8pSPAX9mEP/ylI8Bf2YT/f+r/6xHLnKPlinTtSEP4B9P/RwfTIzpKO9IQ
/sH0/9LG/YdFaEcawj+Y/h9auX9YqHakIfyD6d/bwsxBQ/gH0//NLYs/DeEf
TP+XjRZ/GsI/mP4vblr8aQj/f+p/pYZv+PVMS7b409Dcpcnwd9a/sph5HzQZ
/s76F6/zwZ8mw99Z/7wlPvjTZPg7658+m9vGx7GKIvvbgYZUpJYeNBn+zvpP
S+C265fzijn0CrX0oMnwd9Z/dCy3rSpx46+f/zy4lw9pMvwd9H97W1BfPurG
v79bq9QfFxV6CPyd8r9wSMA+rXfj39elVcxfys5Xw98x/41ZXDUqklPb/H92
8uLIEbySvwz+zvjT2m5sbFKmiro5jOsvC2fyyphY8UzBPxD/jjrhbGx+bP7f
B/2L1orinXPwd8C/ulSQ1pS79//azou07BtRXgh/B/znpwjSngb3/sb1x9fN
LGSwmDgZ/oH6mxefSeMtLXN8fiDqs6aLeuNp+Afkv2mVwKS13ZP/p/uiXrZV
1LMXwd9//1dN/OcNetjO6pvjo8m/+ayoh4aw59fh76d/RZGQjAi3INv8zb9/
oL1oTLRolW6Avz/+3x6ysXGCMS3ZPsEc7+9ZWksXiFbscHsX/t74n3RZhIn0
L/7v7lpaKzMs3cP74O+bP60n8XEWQ1p/6IPVmFBVYumat/p0PyrS0h0V4/F0
HPzdsuwvYLag17++ySH5bavtXYrCXO3zgibQXjQr097dngd/b/2fNbDIcEEX
Fqo9HcYZnqYz7Noxlppo4aUhFY3dfn83c+3U3jJG0Eaosw7+XvmbX71zk1h7
rRu3vi62K5/P2bHG/ak2+u5m/plKRir8h/a/cUKzmhDPNmez1osePzcH/pwX
nTeDJU3hF188Zdslbb2aOE77s7VH4D+Ef0+Dt5euKLfksNzF3k7ubWFPrsJ/
CH+fsnK3ZVPkR8I/EL3AE/7wh7+yCX/4S0eAv7IJf/hLR4C/sgl/+EtHgL+y
CX/4S0eAv7IJf/hLR4C/sgl/+EtHgL+yCX/4S0eAv7IJ/99u+/jC
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Barbados"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{23.5, 53.949999999999996`}, {25.316666666666666`, 54.15}, {
      26.333333333333332`, 55.53333333333333}, {28.099999999999998`, 
      56.016666666666666`}, {29.983333333333334`, 55.833333333333336`}, {
      31.716666666666665`, 53.699999999999996`}, {31.633333333333333`, 
      52.06666666666666}, {27.333333333333332`, 51.583333333333336`}, {23.6, 
      51.53333333333333}, {23.5, 53.949999999999996`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Belarus\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnN9Lk1EYxwf9A/0JdSOIiD/SbEGoBXohpGgSpuBQxgKlgkBvFupVCOpg
KkQXmnSR5IUUiDfVdFOX6ZxmNWP+iFZZrPzRqmUh67s9OESCzoUPJ16e8fFw
3jMvDt/33fN83+c97zled7W87ojJZCrAXyv+4v3Y3mfOYvm1uYlO2OVacTho
8FlZWfIfrA8yz/abhMNlfXj4bX8/2ocm02RBQWzf58W1axhcamnZ9vvRiv4c
7ITDP9fXPadPB9vbJ86c+TQ6SuJDc/fJk6s9Pe68vG/Ly9/X1kR/DiB18OZN
X00NzsLbvj6P2fw7EsHgTHn569ZWnJ1Xzc1+i0XiDxNfPB53bu7XxUUojPg/
b7UuXrmy2t09e/FiNBTCIK58b1ERYpToz8HzhoZ5mw06IwXsRqNoZy5c8FVX
r/b2YvDdvXtoX7e1zdXWNt5J0z5b4yH66yUSCCDUkM4INei/uX0bWXi2qmrD
68XgZ5cLZwStxB8OKP/OSf7VxHYi85L/nEz4T2RhZN79/hOnBj+Ny4Pp2mdr
PAJ2O0IQuSA4H/S3ZmY+DA2hAxfkzsmB84E7Qnv1Vqr22RoPXPwUXvyJ+oN/
rwpBg1R/oFbiDwdUeSCFkWSpCkGVB6oCLbW0UBVC9OcA2iK2UDt69Ci1OIQj
QvtxZCTZXnekaJ+t8ZDrXy9wmPNWKzIsXOiPUAj9L5OT34JBdOCCkJ3hfHw1
NVJ/YyLpf8b/5n/Gxf8wk/T/YxkZ4ydOHPD/GBT/zwpVfiby84kFm203GsVg
4MaN5OBKZ6f4Tyao/kPKT507hw7Vf7zFxfHBhga0T0tKpP7DxPOEwuDd4ODL
piZ0pktLfdXV6Pjr65EX6FupfzJBkR8E29uRed25uXSIXIAs/P7+fTpEFrjb
UdnhyBcOF3I+JDKcJ1zoWGYm+ouNjXChU4WF8a+ys+F/MI4bAeFwofoz6Q//
iUNEfs+pU/A88J9jWVkYp1qQ6M+kPz7Up8rb533rfx4dO4ZxmE/Rn1V/WgVE
far/kOa08ofGRX8O9q9wo7Iz1X8OrMXCWXickqJ9toYkeeVT/Y2iECJPMgrh
V4Bx0Z+DVafTYzaTzsi85ELhPEMDA+5EFo4/C66oeNXc/CQ9XftsjcdOOLxg
tQbsdrig2cpKCE71H7SwQwhH+HVMnz+PdCDxnwNc3pFAwJ2Tg7sA+P945cdu
h/PEiYD/9xYV4c6LFoWK/hzQyh/fpUsIMpGlJYT6Fadzuatra2Fhw+ullVf4
LSA1PElL0z5b4yH660Xij14k/+pF/Kd25P5LI1J/0IvU3/4H/akv9Wct+svz
F43I80e9qD9/f5yaqn22xkN9/YnUHzhQX38l8YeDmPL6Q9GfA/X1t1J/4EB9
/bnkXw7U37+Q+MOB+vtHoj8Tiu/fSf2NA7n+9RJTfv9a9OdAff8B8T8cqO+/
If6fg5jy/jMSfzhQ339J9OdAff8xqX+K/saDKj8q+09K/OEgprz/qujPgfr+
w6I/B+r7b4v+HCTV/uf+86I/B38AHa8euw==
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnN9Lk1EYxwf9A/0JdSOIiD/SbEGoBXohpGgSpuBQxgKlgkBvFupVCOpg
KkQXmnSR5IUUiDfVdFOX6ZxmNWP+iFZZrPzRqmUh67s9OESCzoUPJ16e8fFw
3jMvDt/33fN83+c97zled7W87ojJZCrAXyv+4v3Y3mfOYvm1uYlO2OVacTho
8FlZWfIfrA8yz/abhMNlfXj4bX8/2ocm02RBQWzf58W1axhcamnZ9vvRiv4c
7ITDP9fXPadPB9vbJ86c+TQ6SuJDc/fJk6s9Pe68vG/Ly9/X1kR/DiB18OZN
X00NzsLbvj6P2fw7EsHgTHn569ZWnJ1Xzc1+i0XiDxNfPB53bu7XxUUojPg/
b7UuXrmy2t09e/FiNBTCIK58b1ERYpToz8HzhoZ5mw06IwXsRqNoZy5c8FVX
r/b2YvDdvXtoX7e1zdXWNt5J0z5b4yH66yUSCCDUkM4INei/uX0bWXi2qmrD
68XgZ5cLZwStxB8OKP/OSf7VxHYi85L/nEz4T2RhZN79/hOnBj+Ny4Pp2mdr
PAJ2O0IQuSA4H/S3ZmY+DA2hAxfkzsmB84E7Qnv1Vqr22RoPXPwUXvyJ+oN/
rwpBg1R/oFbiDwdUeSCFkWSpCkGVB6oCLbW0UBVC9OcA2iK2UDt69Ci1OIQj
QvtxZCTZXnekaJ+t8ZDrXy9wmPNWKzIsXOiPUAj9L5OT34JBdOCCkJ3hfHw1
NVJ/YyLpf8b/5n/Gxf8wk/T/YxkZ4ydOHPD/GBT/zwpVfiby84kFm203GsVg
4MaN5OBKZ6f4Tyao/kPKT507hw7Vf7zFxfHBhga0T0tKpP7DxPOEwuDd4ODL
piZ0pktLfdXV6Pjr65EX6FupfzJBkR8E29uRed25uXSIXIAs/P7+fTpEFrjb
UdnhyBcOF3I+JDKcJ1zoWGYm+ouNjXChU4WF8a+ys+F/MI4bAeFwofoz6Q//
iUNEfs+pU/A88J9jWVkYp1qQ6M+kPz7Up8rb533rfx4dO4ZxmE/Rn1V/WgVE
far/kOa08ofGRX8O9q9wo7Iz1X8OrMXCWXickqJ9toYkeeVT/Y2iECJPMgrh
V4Bx0Z+DVafTYzaTzsi85ELhPEMDA+5EFo4/C66oeNXc/CQ9XftsjcdOOLxg
tQbsdrig2cpKCE71H7SwQwhH+HVMnz+PdCDxnwNc3pFAwJ2Tg7sA+P945cdu
h/PEiYD/9xYV4c6LFoWK/hzQyh/fpUsIMpGlJYT6Fadzuatra2Fhw+ullVf4
LSA1PElL0z5b4yH660Xij14k/+pF/Kd25P5LI1J/0IvU3/4H/akv9Wct+svz
F43I80e9qD9/f5yaqn22xkN9/YnUHzhQX38l8YeDmPL6Q9GfA/X1t1J/4EB9
/bnkXw7U37+Q+MOB+vtHoj8Tiu/fSf2NA7n+9RJTfv9a9OdAff8B8T8cqO+/
If6fg5jy/jMSfzhQ339J9OdAff8xqX+K/saDKj8q+09K/OEgprz/qujPgfr+
w6I/B+r7b4v+HCTV/uf+86I/B38AHa8euw==
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Belarus", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnN9Lk1EYxwf9A/0JdSOIiD/SbEGoBXohpGgSpuBQxgKlgkBvFupVCOpg
KkQXmnSR5IUUiDfVdFOX6ZxmNWP+iFZZrPzRqmUh67s9OESCzoUPJ16e8fFw
3jMvDt/33fN83+c97zled7W87ojJZCrAXyv+4v3Y3mfOYvm1uYlO2OVacTho
8FlZWfIfrA8yz/abhMNlfXj4bX8/2ocm02RBQWzf58W1axhcamnZ9vvRiv4c
7ITDP9fXPadPB9vbJ86c+TQ6SuJDc/fJk6s9Pe68vG/Ly9/X1kR/DiB18OZN
X00NzsLbvj6P2fw7EsHgTHn569ZWnJ1Xzc1+i0XiDxNfPB53bu7XxUUojPg/
b7UuXrmy2t09e/FiNBTCIK58b1ERYpToz8HzhoZ5mw06IwXsRqNoZy5c8FVX
r/b2YvDdvXtoX7e1zdXWNt5J0z5b4yH66yUSCCDUkM4INei/uX0bWXi2qmrD
68XgZ5cLZwStxB8OKP/OSf7VxHYi85L/nEz4T2RhZN79/hOnBj+Ny4Pp2mdr
PAJ2O0IQuSA4H/S3ZmY+DA2hAxfkzsmB84E7Qnv1Vqr22RoPXPwUXvyJ+oN/
rwpBg1R/oFbiDwdUeSCFkWSpCkGVB6oCLbW0UBVC9OcA2iK2UDt69Ci1OIQj
QvtxZCTZXnekaJ+t8ZDrXy9wmPNWKzIsXOiPUAj9L5OT34JBdOCCkJ3hfHw1
NVJ/YyLpf8b/5n/Gxf8wk/T/YxkZ4ydOHPD/GBT/zwpVfiby84kFm203GsVg
4MaN5OBKZ6f4Tyao/kPKT507hw7Vf7zFxfHBhga0T0tKpP7DxPOEwuDd4ODL
piZ0pktLfdXV6Pjr65EX6FupfzJBkR8E29uRed25uXSIXIAs/P7+fTpEFrjb
UdnhyBcOF3I+JDKcJ1zoWGYm+ouNjXChU4WF8a+ys+F/MI4bAeFwofoz6Q//
iUNEfs+pU/A88J9jWVkYp1qQ6M+kPz7Up8rb533rfx4dO4ZxmE/Rn1V/WgVE
far/kOa08ofGRX8O9q9wo7Iz1X8OrMXCWXickqJ9toYkeeVT/Y2iECJPMgrh
V4Bx0Z+DVafTYzaTzsi85ELhPEMDA+5EFo4/C66oeNXc/CQ9XftsjcdOOLxg
tQbsdrig2cpKCE71H7SwQwhH+HVMnz+PdCDxnwNc3pFAwJ2Tg7sA+P945cdu
h/PEiYD/9xYV4c6LFoWK/hzQyh/fpUsIMpGlJYT6Fadzuatra2Fhw+ullVf4
LSA1PElL0z5b4yH660Xij14k/+pF/Kd25P5LI1J/0IvU3/4H/akv9Wct+svz
F43I80e9qD9/f5yaqn22xkN9/YnUHzhQX38l8YeDmPL6Q9GfA/X1t1J/4EB9
/bnkXw7U37+Q+MOB+vtHoj8Tiu/fSf2NA7n+9RJTfv9a9OdAff8B8T8cqO+/
If6fg5jy/jMSfzhQ339J9OdAff8xqX+K/saDKj8q+09K/OEgprz/qujPgfr+
w6I/B+r7b4v+HCTV/uf+86I/B38AHa8euw==
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Belarus"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{2.55, 51.083333333333336`}, {3.3833333333333333`, 
      51.38333333333333}, {6.016666666666667, 50.766666666666666`}, {
      6.133333333333333, 50.13333333333333}, {5.816666666666666, 
      49.53333333333333}, {2.55, 51.083333333333336`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Belgium\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt0DENgEAQRcFLaBFAiwMMYIKSjhMAFsDA+UMHCS0cGii2mc37ydbT523K
TUpprdvrvj/2yjE+ZxvYvcxXNwTGnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPn/+fXie9ohw=
              "], {{0, 0}, {128, 110}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 110}, PlotRange -> {{0, 128}, {0, 110}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt0DENgEAQRcFLaBFAiwMMYIKSjhMAFsDA+UMHCS0cGii2mc37ydbT523K
TUpprdvrvj/2yjE+ZxvYvcxXNwTGnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPn/+fXie9ohw=
          "], {{0, 0}, {128, 110}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 110}, PlotRange -> {{0, 128}, {0, 110}}]], {
        Style["Belgium", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt0DENgEAQRcFLaBFAiwMMYIKSjhMAFsDA+UMHCS0cGii2mc37ydbT523K
TUpprdvrvj/2yjE+ZxvYvcxXNwTGnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz58+fPnz9//vz5
8+fPnz9//vz58+fPnz9//vz58+fPn/+fXie9ohw=
        "], {{0, 0}, {128, 110}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 110}, PlotRange -> {{0, 128}, {0, 110}}], 
      "Belgium"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-88.28333333333333, 
      18.483333333333334`}, {-88.91666666666667, 15.9}, {-89.13333333333333, 
      17.816666666666666`}, {-88.28333333333333, 18.483333333333334`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Belize\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXQk8Vdv334ZCSQMpXo9SKpSUoUFknofMtwyJzKLwJDOFDCXKECIiU8iQ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              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXQk8Vdv334ZCSQMpXo9SKpSUoUFknofMtwyJzKLwJDOFDCXKECIiU8iQ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          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Belize", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztXQk8Vdv334ZCSQMpXo9SKpSUoUFknofMtwyJzKLwJDOFDCXKECIiU8iQ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        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Belize"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{1.6333333333333333`, 6.216666666666667}, {
      2.7333333333333334`, 6.366666666666666}, {3.5666666666666664`, 11.75}, {
      2.4, 11.883333333333333`}, {0.9666666666666667, 11.}, {
      1.6333333333333333`, 6.216666666666667}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Benin\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt0DEJQgEARdEPFrCCEZwEcXcXLPALWMFFLODsYBFbOBrBCvpN8Yd74D54
81mNp8O4GIbhOO087f/Xtzm7XXfv1bIcf/7l+PMvx59/Of78y/HnX44//3L8
+Zfjz78cf/7l+PMvx59/Of78y/HnX44//3L8+Zfjz78cf/7l+PMvx59/Of78
y/FP+z+2n8u+3Lz+9+fm+xrK8edfjj//cvz5l+PPvxx//uX48y/Hn385/vzL
8edfjj//cvz5l+PPvxx//uX48y/Hn385/vzL8edfjj//cvz5l+PPvxz/efsB
OIMfEA==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt0DEJQgEARdEPFrCCEZwEcXcXLPALWMFFLODsYBFbOBrBCvpN8Yd74D54
81mNp8O4GIbhOO087f/Xtzm7XXfv1bIcf/7l+PMvx59/Of78y/HnX44//3L8
+Zfjz78cf/7l+PMvx59/Of78y/HnX44//3L8+Zfjz78cf/7l+PMvx59/Of78
y/FP+z+2n8u+3Lz+9+fm+xrK8edfjj//cvz5l+PPvxx//uX48y/Hn385/vzL
8edfjj//cvz5l+PPvxx//uX48y/Hn385/vzL8edfjj//cvz5l+PPvxz/efsB
OIMfEA==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Benin", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt0DEJQgEARdEPFrCCEZwEcXcXLPALWMFFLODsYBFbOBrBCvpN8Yd74D54
81mNp8O4GIbhOO087f/Xtzm7XXfv1bIcf/7l+PMvx59/Of78y/HnX44//3L8
+Zfjz78cf/7l+PMvx59/Of78y/HnX44//3L8+Zfjz78cf/7l+PMvx59/Of78
y/FP+z+2n8u+3Lz+9+fm+xrK8edfjj//cvz5l+PPvxx//uX48y/Hn385/vzL
8edfjj//cvz5l+PPvxx//uX48y/Hn385/vzL8edfjj//cvz5l+PPvxz/efsB
OIMfEA==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Benin"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-64.9425, 32.19}, {-64.9635, 32.1956}, {-64.9788, 
       32.2002}, {-64.9873, 32.2086}, {-64.9719, 32.2217}, {-64.9313, 
       32.231}, {-64.9006, 32.23}, {-64.8866, 32.2189}, {-64.8894, 
       32.2002}, {-64.9076, 32.1918}, {-64.9425, 32.19}}, {{-64.7663, 
       32.3316}, {-64.7649, 32.3437}, {-64.7509, 32.3475}, {-64.73, 
       32.3465}, {-64.709, 32.3316}, {-64.6964, 32.3046}, {-64.7006, 
       32.2878}, {-64.7188, 32.2869}, {-64.7356, 32.2934}, {-64.7663, 
       32.3316}}, {{-64.6782, 32.3447}, {-64.6838, 32.3521}, {-64.6782, 
       32.3549}, {-64.653, 32.3558}, {-64.6195, 32.3409}, {-64.6069, 
       32.3242}, {-64.6139, 32.3139}, {-64.6335, 32.3139}, {-64.6629, 
       32.3232}, {-64.6782, 32.3447}}, {{-64.7258, 32.3968}, {-64.7188, 
       32.4052}, {-64.7062, 32.4062}, {-64.688, 32.4024}, {-64.6698, 
       32.3857}, {-64.6726, 32.3717}, {-64.6908, 32.3698}, {-64.7062, 
       32.3726}, {-64.7258, 32.3968}}, {{-64.9677, 32.2664}, {-64.9635, 
       32.2785}, {-64.9523, 32.2813}, {-64.9313, 32.2748}, {-64.9243, 
       32.2599}, {-64.9285, 32.2468}, {-64.9425, 32.244}, {-64.9621, 
       32.2505}, {-64.9677, 32.2664}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Bermuda\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmwk81Okfx38jZJ1zz5hRsiUSW5QVa+WmlKy0WymEkSNH5F9th9RuZVu7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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmwk81Okfx38jZJ1zz5hRsiUSW5QVa+WmlKy0WymEkSNH5F9th9RuZVu7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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Bermuda", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmwk81Okfx38jZJ1zz5hRsiUSW5QVa+WmlKy0WymEkSNH5F9th9RuZVu7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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Bermuda"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{88.91666666666667, 27.316666666666666`}, {90., 
      28.316666666666666`}, {91.65, 27.766666666666666`}, {88.91666666666667, 
      27.316666666666666`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Bhutan\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnQl4E3XexwOIIvqKuuKi7qsPnqvouyoIoqyIrruP7OPxyr5eKEhLuSqt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              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnQl4E3XexwOIIvqKuuKi7qsPnqvouyoIoqyIrruP7OPxyr5eKEhLuSqt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          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Bhutan", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnQl4E3XexwOIIvqKuuKi7qsPnqvouyoIoqyIrruP7OPxyr5eKEhLuSqt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        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Bhutan"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-69.56666666666666, -10.95}, {-68.66666666666667, -12.5}, \
{-69.5, -17.5}, {-67.18333333333334, -22.816666666666666`}, \
{-66.23333333333333, -21.78333333333333}, {-64.31666666666666, \
-22.866666666666667`}, {-63.93333333333333, -22.}, {-62.63333333333333, \
-22.233333333333334`}, {-61.75, -19.65}, {-58.166666666666664`, \
-20.166666666666668`}, {-57.449999999999996`, -18.2}, {-58.333333333333336`, \
-16.28333333333333}, {-60.166666666666664`, -16.266666666666666`}, \
{-60.46666666666667, -13.799999999999999`}, {-64.4, -12.466666666666667`}, \
{-65.31666666666666, -10.916666666666666`}, {-65.43333333333334, \
-9.683333333333334}, {-69.56666666666666, -10.95}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Bolivia\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztxlEJgDAARdEHJjGBXQQLrMAqmMNAqzVng/klwoFz4a6l7mVJcozO0fO5
AAAAAAAAAAAAAN6pbeNDvQcAAAAAAAAAAACAPwkAAAAAAAAAAAAAMOsGWfkr
/w==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztxlEJgDAARdEHJjGBXQQLrMAqmMNAqzVng/klwoFz4a6l7mVJcozO0fO5
AAAAAAAAAAAAAN6pbeNDvQcAAAAAAAAAAACAPwkAAAAAAAAAAAAAMOsGWfkr
/w==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Bolivia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztxlEJgDAARdEHJjGBXQQLrMAqmMNAqzVng/klwoFz4a6l7mVJcozO0fO5
AAAAAAAAAAAAAN6pbeNDvQcAAAAAAAAAAACAPwkAAAAAAAAAAAAAMOsGWfkr
/w==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Bolivia"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{18.633333333333333`, 42.5}, {16.366666666666667`, 
      44.18333333333333}, {16.1, 44.56666666666666}, {15.95, 
      45.166666666666664`}, {18.466666666666665`, 45.05}, {18.8, 
      44.88333333333333}, {18.633333333333333`, 42.5}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"BosniaHerzegovina\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt1r9LAmEcx/FHiiAn/wWhXVAQcQqagnDwTwialf6BAjcHWzUJtxrqqilq
ahJBCmroB4ihkzWVRYMQ2BMHx1HHac9z5/N8v8/3+AjHecLxUvAdXy/k1+cY
Y8v8tc1fP+eM1QxcMml1Om9j12FZT7FYw/PmrY015Q+MaYVCczT6Gv85er33
TObk1807myuvl4vKnxnN8vmLRuPRXrv9YssfHXXtK/X6w9LSgRt/fMXIX3jz
87s+F9PpY44/GHxGIh6ftfHJX2bFYjOXO3fLl0rXqZTlXOn3P2q1ex988pcZ
/5/lv/Bq9S4a3YvH91utZw7uvqFSuV1dPfPBJ3/JdbtD/hXw2hkOR/yEg7vf
TSQOFxbqPvjkL7ly+cYdOdnsqc/Nf/HJX2b/6nxPfPIX3n873xOf/MUm0Pnk
L7xAOp/8hRdI55O/8ALpfPKXmXznk7/M5Duf/IUXSOeTv9iC6nzyF1iAnU/+
Exdq55P/xIXa+eQ/caF2PvlPs/A6n/ynWXidT/4TF2rnk7//wu588vfZDDqf
/J0p6Xzyd6ak88nfmZLOJ3/3Zt/55O/e7Duf/J0p6Xzyt6eq88mfKe18A/21
6nwD/bXqfAP9tep8A/2ZTp1vpr8+nW+gv1adb5q/bp1vlL+GnY/YH0TnI/YH
0fmI/UF0PmJ/BqHzcfvr3/mI/UF0PlZ/KJ2P0h9Q5yPwB935CPxBdz4Cf9Cd
j8CfQe58HP5wOx+BP+jOh+4PvfNB+yPofED+KDsfkD/Kzgfkj7LzAfkzjJ0P
yx9f5yvx/wZZONFm
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt1r9LAmEcx/FHiiAn/wWhXVAQcQqagnDwTwialf6BAjcHWzUJtxrqqilq
ahJBCmroB4ihkzWVRYMQ2BMHx1HHac9z5/N8v8/3+AjHecLxUvAdXy/k1+cY
Y8v8tc1fP+eM1QxcMml1Om9j12FZT7FYw/PmrY015Q+MaYVCczT6Gv85er33
TObk1807myuvl4vKnxnN8vmLRuPRXrv9YssfHXXtK/X6w9LSgRt/fMXIX3jz
87s+F9PpY44/GHxGIh6ftfHJX2bFYjOXO3fLl0rXqZTlXOn3P2q1ex988pcZ
/5/lv/Bq9S4a3YvH91utZw7uvqFSuV1dPfPBJ3/JdbtD/hXw2hkOR/yEg7vf
TSQOFxbqPvjkL7ly+cYdOdnsqc/Nf/HJX2b/6nxPfPIX3n873xOf/MUm0Pnk
L7xAOp/8hRdI55O/8ALpfPKXmXznk7/M5Duf/IUXSOeTv9iC6nzyF1iAnU/+
Exdq55P/xIXa+eQ/caF2PvlPs/A6n/ynWXidT/4TF2rnk7//wu588vfZDDqf
/J0p6Xzyd6ak88nfmZLOJ3/3Zt/55O/e7Duf/J0p6Xzyt6eq88mfKe18A/21
6nwD/bXqfAP9tep8A/2ZTp1vpr8+nW+gv1adb5q/bp1vlL+GnY/YH0TnI/YH
0fmI/UF0PmJ/BqHzcfvr3/mI/UF0PlZ/KJ2P0h9Q5yPwB935CPxBdz4Cf9Cd
j8CfQe58HP5wOx+BP+jOh+4PvfNB+yPofED+KDsfkD/Kzgfkj7LzAfkzjJ0P
yx9f5yvx/wZZONFm
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["BosniaHerzegovina", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt1r9LAmEcx/FHiiAn/wWhXVAQcQqagnDwTwialf6BAjcHWzUJtxrqqilq
ahJBCmroB4ihkzWVRYMQ2BMHx1HHac9z5/N8v8/3+AjHecLxUvAdXy/k1+cY
Y8v8tc1fP+eM1QxcMml1Om9j12FZT7FYw/PmrY015Q+MaYVCczT6Gv85er33
TObk1807myuvl4vKnxnN8vmLRuPRXrv9YssfHXXtK/X6w9LSgRt/fMXIX3jz
87s+F9PpY44/GHxGIh6ftfHJX2bFYjOXO3fLl0rXqZTlXOn3P2q1ex988pcZ
/5/lv/Bq9S4a3YvH91utZw7uvqFSuV1dPfPBJ3/JdbtD/hXw2hkOR/yEg7vf
TSQOFxbqPvjkL7ly+cYdOdnsqc/Nf/HJX2b/6nxPfPIX3n873xOf/MUm0Pnk
L7xAOp/8hRdI55O/8ALpfPKXmXznk7/M5Duf/IUXSOeTv9iC6nzyF1iAnU/+
Exdq55P/xIXa+eQ/caF2PvlPs/A6n/ynWXidT/4TF2rnk7//wu588vfZDDqf
/J0p6Xzyd6ak88nfmZLOJ3/3Zt/55O/e7Duf/J0p6Xzyt6eq88mfKe18A/21
6nwD/bXqfAP9tep8A/2ZTp1vpr8+nW+gv1adb5q/bp1vlL+GnY/YH0TnI/YH
0fmI/UF0PmJ/BqHzcfvr3/mI/UF0PlZ/KJ2P0h9Q5yPwB935CPxBdz4Cf9Cd
j8CfQe58HP5wOx+BP+jOh+4PvfNB+yPofED+KDsfkD/Kzgfkj7LzAfkzjJ0P
yx9f5yvx/wZZONFm
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "BosniaHerzegovina"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{25.266666666666666`, -17.8}, {21., -18.316666666666666`}, {
      20., -22.}, {20., -24.766666666666666`}, {
      20.65, -26.833333333333332`}, {22.8, -25.65}, {
      25.516666666666666`, -25.666666666666668`}, {
      29.383333333333333`, -22.2}, {25.266666666666666`, -17.8}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Botswana\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2lENgDAMQMEmKMHJNJBgYAawgL8ZmBsYCvZF+rF7uSbV0HSv11G3iDjH
3GO+PdoDAAAAAAAAAAAAAABTpZNJkrIqSi0kSZIkSZIk/Vb2/W/1su/fktYt
/QEDAAAAAAAAAAAAAACYegGOnSPv
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2lENgDAMQMEmKMHJNJBgYAawgL8ZmBsYCvZF+rF7uSbV0HSv11G3iDjH
3GO+PdoDAAAAAAAAAAAAAABTpZNJkrIqSi0kSZIkSZIk/Vb2/W/1su/fktYt
/QEDAAAAAAAAAAAAAACYegGOnSPv
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Botswana", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2lENgDAMQMEmKMHJNJBgYAawgL8ZmBsYCvZF+rF7uSbV0HSv11G3iDjH
3GO+PdoDAAAAAAAAAAAAAABTpZNJkrIqSi0kSZIkSZIk/Vb2/W/1su/fktYt
/QEDAAAAAAAAAAAAAACYegGOnSPv
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Botswana"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdU01IVFEUfomJhAsfjYs2oiNGPxvLHB0mfFcc9P3MPN8bdCEihKi4ECUi
XZiLaOPW5bhScCEGbkRCDObSuhYtpFUREa7KyKAQjZp7vm9G8IOZyzn3O+c7
P/e1TswXpmosy3LKP3P+OC5jx9efPhoonTXY9HDW9uoVA9fTnQZPaNf7esSg
SWnL4JEL/8rDqr1WLGM0rV8flLGUxXnWpW2D1X4N3XvQXaY9dxd5n/brRcFt
6F6/sHH2wb/bAv5eH+tPQN/K6ndvDerQx+SAnhZcgz83QN55ScqeGYT+8VEJ
+Sv9nMP+4FL3KvUu7qWvMa9qS/5ZD7yR77z3MY/iaUn6/+nql9sGJw7yezop
aFTSx7jP+xoldYVB1ZZ8mRz67/znSBvrecb/dkT2MM96bOYLOY+EEtqbEHuw
bSX/j4fIb1DIGzGfDXt3iHpXlNT7KuI8fjky1oWY9hn6GYyp99WRsBcx6//i
iP9ZzH01Yi7pAvUTqOt5gfrN3FeB+ZK436jEJxG3FfNd3uS+Y+z7qB3vbiwC
f7wN98MR9nPYDv0bEfd/C/xMqGVdRb7HphBx2Q70cYfzdTvA26/s4z75efIe
QPdvjv4U+vgWMD7Fdxxgfn+68S5bAvAaeth/wO8mzb58zicD//sc4lQvzs8+
eHVKX/6+/wNCFebe
       "], {{-48.4, -0.26666666666666666`}, {-50.38333333333333, \
-1.8333333333333333`}, {-50.583333333333336`, -0.2}, {-48.4, \
-0.26666666666666666`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Brazil\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnHdUU8kexz3n/SXK2p6uvl3XZ1sbiAgoioAgLoriImtbFgWxoKKI0gQX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              "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnHdUU8kexz3n/SXK2p6uvl3XZ1sbiAgoioAgLoriImtbFgWxoKKI0gQX
OyIKooAdCaFjaAYhSJEWQgkQOqGGJEgRQUGwPV3f7OZtTl6Am0ly44Vwz/nA
CZcEZr535jfzK3NnWx03tfrHmDFjzMDXOfD15+s5getxcHBwcHBwcHBwcHBw
cJCZF2gAwLwZoxPDR6vp1VMLq6b+FLUa88aMKhYQ1vlk//iGq/D++VhAL1fh
WtaCHwnrMG/YaMA0dmVV7WSe8oKUMacYR2ti3jw5Romo/5A2522LsPJ8+lvG
+lPnLQzCJwL6WJDVmhomDqW8IMy6SdtjV2DeYLlhechaEv0HGOX5vGsZG5g3
B8wXzBs/0jmatKyVpSiW+HwaGybufqyOeRdGKKvDdZ6W/ksy5QWJKJy1LFgP
8+6MKAxcU5W62OOlF58Ht+mbA09Use7UyEA/Uiu38lu0lBckvnimeqgu5h0c
tswnGFzJWNj7t1clC9pZiscpKpj3dBgCXKfSmn/KTnlBwLKyKkwH8y4PExYF
6d+mzusf2qsSorJwbmiY4Y3bO36/fPDQKYcdRy5YnnB1OG/jecM8gGCcnqzR
2yx6v/SSPf5UitKcUR+72xWvUVc/SaRcYD9fmL3Y8+ZvhhbeSzaGIKNh8sDu
jC05fk13owh/Lbtium7EGsxFwASVYL3Qgn/DDPiUxJVb9l0RKfugN8L3zvZX
TRMQ/vgrzrjz6YvnjrKJAHaDYE8oUvm8TGWzY2clUF4QnZ3+IaEb+jjjEP5R
wagJYq8I1SUXfy9S+X6uwiUvCxh5lYxClDeFinzbtkMXuVXTEf4j2HddzZTz
ILbDU+UOiMUR2G1rJ0fI4b1qe+ThM0+FLu51TjI+GMv/0ZeYp2IcprvLryR3
IfK/LmNO2Ry9CnOhUEcnQjujHGn48WFXzPj5gIc0BmfNzqhXPR0Bj+j8K5ZO
ScuMw8CL5VseJjxeI2LqtYz1z5kvN0HseYEGYIF7hWh++XTWT95kdVVKgw/Y
7ZC4VMAo+RBowEzxXisbEZ8lq4tsCbNu0raRH8TmpWhhlOfZ/P2OztKLL4TK
5lCHK+lqJmH8KytN79XQZ4tsD9j0PqSN1CC2UIoWBnfvIRdcHbOoMzeytHZG
iVQbrMW85RgMeP4UUN0SCn7kmSAehnu822uh3O3GhonmIy2IPVSKFoHkJ5oI
qu5xTOx/23nANVmk/vtdKby3gVXgyl0q72LM0zKwTIfEl4AbAe4j76KNy0n4
5oUXzFIZCUFskSnaoSyPSLNvcjh+0OtA2PUW0cif5Rt/cFME14KCLCX4Rv4V
xF6OucIIwKdohYiKMhgo2v1I+vGLqSIHvJNnemdX+wrTCMjlwN4j3c0nk/fa
3PaMuE2NG5ZBbAlStHx6mhX1zW4OFErfnLQUwrECbDtKhhSf92e3CkylNIqG
uA1uZynaDqcgtjQpWkA0SW/zgdhwMmOgVr+dTAArL7Kehntj4MUHlqe8tonn
rzl4pIHvVvZiTwEewyGIjUqK9vApe2s3SmdXm4rA/oTHnbAC0yODm30+Z29m
8e25SMAWyNU7Y81f+yiwoGj/SmJUdbxoFO0ODMpL9njnFGWMgtjopGi7Gyeq
Ggfy9QFqhz4uGXgjBgWYEV2zR3xhgc8FPxEAG6zi2M97v3z5Qqf7SdOFrPKv
HcRGMUVLjtMW1MT2QiqntWXrEFsdIfxD8nceT+C9Bq5BfGo55Hrxp2Wzp+Q0
Fn349BHoX1ZdI2UvgHd/7qsEsVFP0Z66dEhIGZ1f/xzSLl4ZkFZli3XcUFvT
oZYAH0JJTC05tyXfnXYN6J+QXo8cnYakoGra+igt2YkvixTt3pMuYhkNIYA/
1cDmZuQzId+vaxZNouX50P3J9ZTYWvJlmpdfcCm4zqmcgUp3ZBTEFjdFCw9k
YguYdwBQe+CvzO2fiPS/eBw5n/qk5hmlMfUeI7CglV7yvNLmEoX3K0buAhQ7
BUbpJhJqQWzIFK1kaG2/DSMdsDDvP3T9YvNYsmnyk2XsU1pDcEU4GPms1+zr
hf7hJU+2Hk7gvyGVsgLdfvVxx/pJHcReHKQPmaKVjDfs8Us2BsMJGP0gir5u
N0lc5cGsuRnMCCwNe8bO+vjpo3OGW0Q1iZLFWrX9/9yKyEgDWXSwpm6yaexK
aW6BHUWlXQrfCi39xSItt8bCMVF5U6iTZ04FqwWYGjDg75cSql8yy1pqT3pk
DPyIjPRHpb5CAy5jKxmQ9kcsjPbFnvPLK2hgUhpTgsrDrhf6tb5pu0C9Ep5F
BevvoB9B3f6g7ppZJ6q2QFQsiAt//V23h2QAt4wioLkt8tqDohdd/bdKHvye
fbGqs8Yuzdmd5sVq63TxykX4ILrrbzJDJqEJ1ZC1UZIG2YaCv/8kJZU2sDnq
JlCerxCqW8LsLmUlUxtrO5u8C3wJ5aFgYw/W2eSmtOLnld7BeWom4ch/Aa39
ZxtL8ZiMQ3MWZDVWA1JFk1jw/S/DvTF2l9LEkh2oevB0WnxqQ21Hc3tfh2/R
HRIz7vmbVmDtW3pbI6tiIihVQxkcQVQ2E1Dxv2KLZqqFrJWp+DyUiHpB+bPf
oeEOCMUfRLLBKs75KjU8gVlV//I/nz5HM+OBA/v6/etjqQ5nsi81v+Zcy7+Z
UpcVHFe9cR+sU7zf0VnKXnAaJ+xL+NqpmZ1xKPgF3Y1TXK5l2l7ItHZLt3RK
2WWXBLblRvvjNx94vNc5BWxgvAKKiXHVYMeYyahncJgVL6qA4FRuXiaHCl7E
1SWA5TWgNMgz3+cO42FFQ9t5v3x1k3AfAs3Ve5B9zqBERKyXpgtgi74Uo9Qk
cBDu5s4VN9soRAOrCSjZ3MMhVoQD65HbksfsqgNL53mqR0BZUG5Lvl/RXUZH
GTAvux5bBpQRwZvLX1Seo17u+9jf1tfuXeibXl0cFFNlbv+/7LCSUQhwFk5f
h9Jf2YjYxoSt0BBuef1Es3gNTJQXxCRGs1LMbLsgBQXuQFKvQt/+Pz770G8D
2Y+m2Pd+6PUtukusCMtszr5Bv1XX3QCW1IdlwfuSbMCbP//xuf/9u6KKdjA7
wEyRYMnmY2F3WoI2gyF3P3cuGH6Yi8+DV20CnG4J+tLTPOV179vYWvItRmAa
K+NczuXLNC8guFv2Rf/ie+39HbeK7+dwaUWc6vTiugcxJS5eVGCjVDbDhpqR
kSD/CAabSYxUXq2M2EhaVSJRgDQ19dgJ9yxHzxywSz9zM++if4H77UKwzoLt
zS82T/TMoyEzMuIibv79DVcBDLMFw7hGdz7BwEP8BAFM/YksEKv+pLh66kb0
opoyZV2UVl7lNLFuAXL9lSyAr7/q4Si4ZywaWQ8amhtocDZtcTdbDL8Gof4Q
deDrD6mV3+pFjtQzStoR2plwZefvZVZ/OxDI+tsu9rjTqUvk4IyeU4pyZzNU
pQRa9ecIQNafp5XN0ArXxlw6tNAM00lmQFUKSX/+AgGY8xftLMUTyUsxV0wW
2MJlc8Q6fwQPzPkjcvH3GsOvvBNF1EN144tnwqwFkOfvIBF5/o7b9I114mh5
RsdwO38aOfqeUQP6G1E4C2ZFkOn561H+jCbQd5gjA7J4/gD+jDIeSkQ9Qp4Y
2RxUnr8hH8cbUWRH3IraOllVeQnSx5Wr470oIrsqRz7oVgbKJT/HaFbUTkFd
+V6ugmfmwvmEER9M+AosIKy7niXe2WFk8qumGciyMlwu2fBodTH02fmh6GaP
O5s26h7vgxbzAg3cMxb1cCScCBnl07Uj5CeGhhX6kVo0MbM5L5rHOz5Vxrzl
coSBW9oSyGxOIuO7lVifDJVL1oRrPytHKtRsZSnaJC3DvJ3yDTAsg2ZzSPQf
VL9K+SUOMC9JjO/4yjc3TrAkq2HeqtEG77kHxPzZysTRFToePgznUigcHBwc
HBwcHBwcHBycYcV/ARtv5ls=
          "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], {
        Style["Brazil", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnHdUU8kexz3n/SXK2p6uvl3XZ1sbiAgoioAgLoriImtbFgWxoKKI0gQX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        "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}], "Brazil"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-64.2772, 18.6801}, {-64.32, 18.7077}, {-64.3575, 
       18.7175}, {-64.4016, 18.7193}, {-64.415, 18.7265}, {-64.415, 
       18.7363}, {-64.399, 18.7461}, {-64.3494, 18.7514}, {-64.2839, 
       18.7327}, {-64.2597, 18.7086}, {-64.2517, 18.6899}, {-64.2544, 
       18.6801}, {-64.2638, 18.6765}, {-64.2678, 18.6765}, {-64.2772, 
       18.6801}}, {{-64.3869, 18.3973}, {-64.3949, 18.4205}, {-64.3922, 
       18.4366}, {-64.3387, 18.4696}, {-64.316, 18.4767}, {-64.2397, 
       18.4651}, {-64.2303, 18.4553}, {-64.241, 18.4464}, {-64.3053, 
       18.4313}, {-64.3561, 18.4009}, {-64.3682, 18.3965}, {-64.3869, 
       18.3973}}, {{-64.5569, 18.4259}, {-64.5314, 18.4179}, {-64.5288, 
       18.4045}, {-64.5328, 18.3947}, {-64.5649, 18.3875}, {-64.6439, 
       18.3875}, {-64.6854, 18.3688}, {-64.6933, 18.3688}, {-64.7027, 
       18.3759}, {-64.6947, 18.3929}, {-64.6653, 18.4161}, {-64.6238, 
       18.4268}, {-64.5569, 18.4259}}, {{-64.863, 18.3909}, {-64.8782, 
       18.3924}, {-64.8782, 18.4011}, {-64.8542, 18.4142}, {-64.8085, 
       18.4185}, {-64.7845, 18.4171}, {-64.778, 18.4069}, {-64.7889, 
       18.3996}, {-64.863, 18.3909}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"BritishVirginIslands\"", "Panel", Background -> None, 
            StripOnInput -> False], "Labeled", Editable -> True, Selectable -> 
           True], Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmgdYU9m2x08QkCZFREWkihSviIiIMNhAVCyIDiqIEJLQq/RexEbHRlGw
ICUhEBgcQEEFBCmjtFFEEYZmuXO9o4wijoztrUMySYzv+STgRJ3k+8MXDjt7
r/VbK2vvfc5WxHtuxU9CEGQl/ETCD/oeQRy44oorrrjiiiuuuOKKK6644oqr
f6YEBV1lZQO0tPYuXXpQWTlETMyT4yZ98+LldVq//vC+iJgfiaGNpQ6NxVsb
KSsbyNpUXSkwzz0RHn0wT1t7H8dN/cYkJxcYHk45nx9+NUfpSRXyRz3ij0V/
g9y2IydC0DfPryKlh5HjocJVBbbE7IIVK+I4bvY3oHnzIojE2rry+OtktZ5z
iK81kh+D0o7zpPHf40h7A0rwol3P2sdfmmlaSMpavHg/x134emVllVF7Offn
4kXNOciLOjTPazOQHw+hhO8WIffL0DfpoQz+acEIfDt+JiGJ3uif98/zXcp3
9PUlYjCc9+WrkJCQm5VV2rJlMUAsJrqwkuL0uFoASBbGo9gfXUKCcMiJcIF6
ytrGSzE/1ZAOJEZ4R3lXlmf9VJXaUGzdQpaBMJ1LQn5IoEXkwXnEh6CYczZX
WtoPKpKTU/b06T4cd/OLVR7xh0byQkqKXuaJ2CaK5kApkhKI/FqBkgy0RdrI
opcLCDlnL1y40J5ZmGfkb4HBzUNw6gs8TBIyU8jk+sjIQmJ68E9kTSr83h8R
OzOkIhmhJIrXnk/KOrSmPntmdWkirJc47ukXKE3NqOr8bTdICPEA0ppDS+Cj
/gglDun8QfgKxSYh9qyLS056bt6aACseW5Q8sxZ7mSZlnvDzI2GxGWUFCU2F
i59eQS6nIvfKaLE4HY40nkFuUKb7+eVy3NkvUIqKQZcKXCuOoZToJR3KTn2O
IjknE8jnkCvMQvGTsKzkmbXMd9tpMtnTk5SUVHKJZPGshtFV3zmkKAGpOKm+
YkUMx539MuXlRSrPc3pShaFDqyPrn0qnnDlTE3k8Voqw5P/CLmOnSH8vSNC0
j/GtuHQtPb22+lwgzML03qrIZunpJRx380uWjs7+89lWMI0Crkri+oz0i8ez
CvS9t7AAV7WYGxkwTRmvIITTNPYyOBMxf6mTLHODOS6rjmRnxMdXXCzaO1iN
BrSGvD4t7SJs4jju4xcuHC6jImtNJWk7kXj1ODFHe9ecjFg+UsIkbTtpAawK
Fe/eE/HxSV6HUiKyKLl1dbUXy5IPZx8yCrOCf62xk4SynxXNs4Ag65sQFB19
viw/rJJsSSLWTJrkyHHvvgrJyPgvWLAn6exxE/sZUSECl7P5akh8qbGTLbFC
PLZqAPlseUFfX19XV9e7d++GhoYePnzY0dERl5+2ES96JHpyQx5f2Rn+6AiB
Tbum2ES5e3uTdu7M4Gb+mBSbnCWEXeB/UsJwi7Sui4yO0yx5D+XpNooYLMrf
LTX85s2bg4OD7/56dXd3R+elxBNFNKzlFuJnqjvJT3FQnWmrgNiqhyfHSUp6
cdyjr0hqauH4WB/gbBUzber3Snresst83yvv+MP+9+7de/36NRU+5P/w8LBL
aih2rxiCVVvrK63qrsBYmrpvdHXN5bhTX5Fgr2oajkfpYdXEbOcsc5M2cJam
Zj6df29vLz35e3p64Pf83SaQ7XI2cngvMRM7CXpjMQsNT08ix536irR8edym
MJS/qLWSpYtYZyFyPQdj4SExc5ccFalf8t729vbHjx9D5j99+vS3334rb6jC
2KrrO0snHUBvWQzWYFy9RdStpaHxlB3zufzHyp+a/3YBopvdp2EDpm72lrIO
nmaOFcHQ5t/8X3/9dWBgAMoOJD/MBUm5aXDdM0x4IW6WkbOUClZmodPsNfip
XP5saNmyWCr/eJKIzDZFY99ZRv4yGDyj/h8kJcPkC2kPi5/e0ZdLShhcD0wW
EbCeu9xntkGQPL0x8N+9m8t/DDIwoPFXcZWdZKO22FVGzh5d+dj4SDgEiUNR
ckuLAObPnz9/9OgRlb9uwFZoL22vIIZT3rZ7qq6jNPLXfAH8YWfNcae+IgH/
zeEE5gWPooOCi/eUe2Xo7dCsFAHPPVZQc968eQMlCDYCLW2tgrgF0IzXau4u
V7E7FKQ2k8fcfepMnAKXPxv67rsYswg7Zv4mnlI2WyTMfKQcg8R3Bkm5hRjW
1tbCmgcy/3zOaSI5k9psp4eof4RoUrxwxEHR4ChRMwsh+BYAf9iCsWfJs6qq
O8uXNyEIKl7eXlvbl93dzc39GzYcZaM3M7MUsHm4tZXWIZPgIvwLGrDRLRgD
Jr17//XsypU7K1ey57W+fvSWSHtm/vZHJFeull4WKLcapzqZoCaOW1RZVYn6
MjzcdaEo4XA4tVlyoZCSpbyu2yw9L9lJeEb99/HJY88Sqi9PL1++Y2DAiAIe
/7Knp6HhF2PjJM7yBwPADBbyQ7W1nYaG1G4nir+Uo5Kw5VwFq39dStk3yVpd
FKdVfrECkh/Wn3euVhZkxFKbGQXMgIQ3cJdWcmLcER0/f1oUKipu6+kxokAg
vOztvXKlE1Zrfz9/GBSGZiVfX99pbEzvk+3819OL3hrpQANoo+buKZS4V0AX
N33STrWsw6HiWLTUF5af++OPP2DQ27faW3NTFex0qe23OIhBY4LnFD6LOXT+
vr5k9iz50MffL1y4ratLdbCZj6/P3v5lX9/Fix1Llx78e/jDQDAci1XPGxvv
rl1L761z1apn1dVgPHtewxBb96D8FXGyVg7C+ekCfRd4Th0V2LRDWNdxSfHx
/RouyyOzkyD/X79+DRuB02kHkhP9YGuw0144PUmwu5SHfELAy1NwqY0Ulb+f
H5v8kdHveGNjD2sUyso6dHQYUXBwGOnvLy29sWjRx04fjZM/dA5DsJK/du2u
iQmDvKEhVH4weKy18X/lv8h3tmvyVC0fhRW4afpB8koEeSm8kncE7t9l2bsT
0VsQbW1tHR0dfoeDBy/lzyXoRaUJ6QUp6GOldP0V+LAqM7CK4+dP1aZNx1pb
B1ijUFLSoa1NiwI/f5+T08jAQGFhi4bGnonlDx1Ct6zkm5q6NmxgkDcyelZT
A0aCqeN0Vlf34Pej/Oe4yO2IkVLZPWdL4ExePG09z2s7L/NYaHZGQktLS3t7
O+x/g49FPqukzLVbit8nyoNXN/OfoeChzFz//f3zx2kSCINxMDdPu3XrAQuH
weLiW1pa9Cj0Ozu/HBggka6pqYWPnz90Al29ffuWecThlpYuU1MG+dWrYc4F
w8C8CTlss2TJAfMoRyo9AZyKmZeUX6Sokh1jSzvdRiv/1JHr16+3trbCtyA5
Zf/buhIJaw2YLBTsFNxDxCz9JBFbBv+AgAngTxUPj6OVVUZX139Yo1BUdEtT
kxaFyZP7XV1f9A9kZtbPmcM4bjEm/vBB+Pjr12/eI9/W1m1mxiBvbDx09SoY
AyaBYRPlI/DfFuUE6PhtVGAb9VM25pdipPw070ZbMZ7RXS3GVr3zDhSejl9+
QVdfp9IOlJ9Gl0CKBPn9YYJdRcitAsTbX1jdVmbC+VPFy+tEIGT29f3GDAey
9AmFcktDgxEFNzeIQnp6rZxc4Kfzh8bwkVevXjN3/uLGje6tW5swGGr7u2vW
DNXVgQFgxoQ/WtLR2U/lr2Y/yy1c1NR3hmeI6Pag6esdJOcRZlOzOiv7RHV1
9dDQ0IsXLwoKsqx8tsFFhwCRHZ7TCIHi3/tIbQ+QMrYWh28B8A8MLJhYC6ni
53d2ccl58GCQNQr5+e3z59OiICAw4OHxvG/g2LFKHO7Mx/lDA2g2MvLqPfI3
b3abmzPIr10L60wYFIYGAz6HX4sX798e5Qw8DQJnOSdLLglQWOgyW9p1LvOO
YJH9imvN11+9egX1v+F6o7LnariYkC00beccfa/ZBv5yzPU/KIjCniUrV8b/
v4KVRnJy1eDgMEsUHpNIkKWwCAfdXbcOChQV7Ef4//nnezn/ZmTkUWoqLCap
nUAUhhoaYCAYDgb9FNvY57/XZXSqVVV2k0MsVQzxksguVZZTEOruxhUnD+Wd
PKQfaE47F+Eqi1irLXOYLmkpD3PB+Pm/+wyvj/Cf8Bd7Xmtr76PyR6cAC+Xk
/fw/k5DAsCniFgrM/N0Cdt0vPuu0UXG5sTj1CgartsFe4nYB0krCfGc/Y8ou
JSr/4GA2+T+rqppw/Tc9/UP+cPFzjMWe17DR2LEP5S+1S94jUMR3r8SlLF7/
/eKWNoI6uBl0/qFhdoPlxKjNYo6r+anZbr5bwsNPNDpuSnyCSPA+UVNzQV5r
FeAfElLIniUfgvq6xDZ/i1H+is7ykWfFDILkVS2llwYqsNQfnIPRjxHYSEPE
ZBMt/yOyxHQ3yuh7ztZ3l5FwUqHXHy7/MUlLay+VP7r4j5wmYq9q4SvJ/PyL
NgVvlnU1EV63XkLEknarR99fWmSH8iJ3WV0PGeb5NzSUy38MWrgw6vtQO2TH
XFQWcxFL+K2C7ByVFUgVnYtB1qpo2QFhR2XLGiA6/7CwIi7/T5eyckhJSVMB
pSaPXJ2bdzmbeDEz5/yprNL0M+eOny5KOVl4NIN8+DgxMS0nLuVszLEzB46c
3HfoRFTS8YiE5LC4oyGxR4JjDwXGJPlHJ/odjPc7GIfFnuLy/xrFcYD/cP7/
zPXnl6PPsSf68vdfX44+ZY8P8vYm37hxf6ihodvcnHqvoHPVqkepqW9GRsbE
/+3bt4NFRXfXraPdtViz5jGJxHLzGQaC4T7RMI4D/NwyMkqsre0aqq9nPP7D
YCAKL27eZMF+7VpvVFTJx/lDA2j258OHAx4ezQIC1H+1z5//JD+fJQowKAzN
cfc5KEPDhJqau0N1dZClDPJbt764wfqIEJBSz6t84v1naAwfGXnwoN/NrXny
ZGqDWxoaTygUliiAAWAGx1FwhvzVq8yHDbrNzIbb2ljIX7/ey3xSaEzPX+CD
8PGR+/f7XV0ZUdDUhALFMso/JwqrViVcudKJHrBZvZqOrsvUdLiF9eEsoNu4
kfWMFhvPH6ETNAr37vU7Ozfz89OioKU1WFzMMiIYBuZxHNFnEsxl4OCzmppO
IyMG+Q0bnjc1sXBoaur7kDzb/OlRgG5HBgb6nJzoUejQ1v69pOTDKHxj0y64
U13d+Qwc++tQGeiuicnza9c+JP/xswfjPH8CnaNR6O/vc3Bo5uOjRUFH5/ey
MhZLwOBvIwooefhZtYpBfu3a542NLP42N/d/yqmPCTl/BQPBcC/7+vrs7elR
uK2r+/uFCx9GgeMAxylYhNMRoYcN6us/JG9q+qnnbSbw/CEMikaht7eXQGji
5aVFQU/vaUUFs3kcBzhO0cgbGg6NHrdmfrW09G/enDym3ib8/C0YAGa87Onp
xePpUbhjYPD08uVvgz/kP1T+8ZP/TPzfi0J3d6+tLSMKy5d/A/d//gd7fh3N

              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmgdYU9m2x08QkCZFREWkihSviIiIMNhAVCyIDiqIEJLQq/RexEbHRlGw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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["BritishVirginIslands", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmgdYU9m2x08QkCZFREWkihSviIiIMNhAVCyIDiqIEJLQq/RexEbHRlGw
ICUhEBgcQEEFBCmjtFFEEYZmuXO9o4wijoztrUMySYzv+STgRJ3k+8MXDjt7
r/VbK2vvfc5WxHtuxU9CEGQl/ETCD/oeQRy44oorrrjiiiuuuOKKK6644oqr
f6YEBV1lZQO0tPYuXXpQWTlETMyT4yZ98+LldVq//vC+iJgfiaGNpQ6NxVsb
KSsbyNpUXSkwzz0RHn0wT1t7H8dN/cYkJxcYHk45nx9+NUfpSRXyRz3ij0V/
g9y2IydC0DfPryKlh5HjocJVBbbE7IIVK+I4bvY3oHnzIojE2rry+OtktZ5z
iK81kh+D0o7zpPHf40h7A0rwol3P2sdfmmlaSMpavHg/x134emVllVF7Offn
4kXNOciLOjTPazOQHw+hhO8WIffL0DfpoQz+acEIfDt+JiGJ3uif98/zXcp3
9PUlYjCc9+WrkJCQm5VV2rJlMUAsJrqwkuL0uFoASBbGo9gfXUKCcMiJcIF6
ytrGSzE/1ZAOJEZ4R3lXlmf9VJXaUGzdQpaBMJ1LQn5IoEXkwXnEh6CYczZX
WtoPKpKTU/b06T4cd/OLVR7xh0byQkqKXuaJ2CaK5kApkhKI/FqBkgy0RdrI
opcLCDlnL1y40J5ZmGfkb4HBzUNw6gs8TBIyU8jk+sjIQmJ68E9kTSr83h8R
OzOkIhmhJIrXnk/KOrSmPntmdWkirJc47ukXKE3NqOr8bTdICPEA0ppDS+Cj
/gglDun8QfgKxSYh9qyLS056bt6aACseW5Q8sxZ7mSZlnvDzI2GxGWUFCU2F
i59eQS6nIvfKaLE4HY40nkFuUKb7+eVy3NkvUIqKQZcKXCuOoZToJR3KTn2O
IjknE8jnkCvMQvGTsKzkmbXMd9tpMtnTk5SUVHKJZPGshtFV3zmkKAGpOKm+
YkUMx539MuXlRSrPc3pShaFDqyPrn0qnnDlTE3k8Voqw5P/CLmOnSH8vSNC0
j/GtuHQtPb22+lwgzML03qrIZunpJRx380uWjs7+89lWMI0Crkri+oz0i8ez
CvS9t7AAV7WYGxkwTRmvIITTNPYyOBMxf6mTLHODOS6rjmRnxMdXXCzaO1iN
BrSGvD4t7SJs4jju4xcuHC6jImtNJWk7kXj1ODFHe9ecjFg+UsIkbTtpAawK
Fe/eE/HxSV6HUiKyKLl1dbUXy5IPZx8yCrOCf62xk4SynxXNs4Ag65sQFB19
viw/rJJsSSLWTJrkyHHvvgrJyPgvWLAn6exxE/sZUSECl7P5akh8qbGTLbFC
PLZqAPlseUFfX19XV9e7d++GhoYePnzY0dERl5+2ES96JHpyQx5f2Rn+6AiB
Tbum2ES5e3uTdu7M4Gb+mBSbnCWEXeB/UsJwi7Sui4yO0yx5D+XpNooYLMrf
LTX85s2bg4OD7/56dXd3R+elxBNFNKzlFuJnqjvJT3FQnWmrgNiqhyfHSUp6
cdyjr0hqauH4WB/gbBUzber3Snresst83yvv+MP+9+7de/36NRU+5P/w8LBL
aih2rxiCVVvrK63qrsBYmrpvdHXN5bhTX5Fgr2oajkfpYdXEbOcsc5M2cJam
Zj6df29vLz35e3p64Pf83SaQ7XI2cngvMRM7CXpjMQsNT08ix536irR8edym
MJS/qLWSpYtYZyFyPQdj4SExc5ccFalf8t729vbHjx9D5j99+vS3334rb6jC
2KrrO0snHUBvWQzWYFy9RdStpaHxlB3zufzHyp+a/3YBopvdp2EDpm72lrIO
nmaOFcHQ5t/8X3/9dWBgAMoOJD/MBUm5aXDdM0x4IW6WkbOUClZmodPsNfip
XP5saNmyWCr/eJKIzDZFY99ZRv4yGDyj/h8kJcPkC2kPi5/e0ZdLShhcD0wW
EbCeu9xntkGQPL0x8N+9m8t/DDIwoPFXcZWdZKO22FVGzh5d+dj4SDgEiUNR
ckuLAObPnz9/9OgRlb9uwFZoL22vIIZT3rZ7qq6jNPLXfAH8YWfNcae+IgH/
zeEE5gWPooOCi/eUe2Xo7dCsFAHPPVZQc968eQMlCDYCLW2tgrgF0IzXau4u
V7E7FKQ2k8fcfepMnAKXPxv67rsYswg7Zv4mnlI2WyTMfKQcg8R3Bkm5hRjW
1tbCmgcy/3zOaSI5k9psp4eof4RoUrxwxEHR4ChRMwsh+BYAf9iCsWfJs6qq
O8uXNyEIKl7eXlvbl93dzc39GzYcZaM3M7MUsHm4tZXWIZPgIvwLGrDRLRgD
Jr17//XsypU7K1ey57W+fvSWSHtm/vZHJFeull4WKLcapzqZoCaOW1RZVYn6
MjzcdaEo4XA4tVlyoZCSpbyu2yw9L9lJeEb99/HJY88Sqi9PL1++Y2DAiAIe
/7Knp6HhF2PjJM7yBwPADBbyQ7W1nYaG1G4nir+Uo5Kw5VwFq39dStk3yVpd
FKdVfrECkh/Wn3euVhZkxFKbGQXMgIQ3cJdWcmLcER0/f1oUKipu6+kxokAg
vOztvXKlE1Zrfz9/GBSGZiVfX99pbEzvk+3819OL3hrpQANoo+buKZS4V0AX
N33STrWsw6HiWLTUF5af++OPP2DQ27faW3NTFex0qe23OIhBY4LnFD6LOXT+
vr5k9iz50MffL1y4ratLdbCZj6/P3v5lX9/Fix1Llx78e/jDQDAci1XPGxvv
rl1L761z1apn1dVgPHtewxBb96D8FXGyVg7C+ekCfRd4Th0V2LRDWNdxSfHx
/RouyyOzkyD/X79+DRuB02kHkhP9YGuw0144PUmwu5SHfELAy1NwqY0Ulb+f
H5v8kdHveGNjD2sUyso6dHQYUXBwGOnvLy29sWjRx04fjZM/dA5DsJK/du2u
iQmDvKEhVH4weKy18X/lv8h3tmvyVC0fhRW4afpB8koEeSm8kncE7t9l2bsT
0VsQbW1tHR0dfoeDBy/lzyXoRaUJ6QUp6GOldP0V+LAqM7CK4+dP1aZNx1pb
B1ijUFLSoa1NiwI/f5+T08jAQGFhi4bGnonlDx1Ct6zkm5q6NmxgkDcyelZT
A0aCqeN0Vlf34Pej/Oe4yO2IkVLZPWdL4ExePG09z2s7L/NYaHZGQktLS3t7
O+x/g49FPqukzLVbit8nyoNXN/OfoeChzFz//f3zx2kSCINxMDdPu3XrAQuH
weLiW1pa9Cj0Ozu/HBggka6pqYWPnz90Al29ffuWecThlpYuU1MG+dWrYc4F
w8C8CTlss2TJAfMoRyo9AZyKmZeUX6Sokh1jSzvdRiv/1JHr16+3trbCtyA5
Zf/buhIJaw2YLBTsFNxDxCz9JBFbBv+AgAngTxUPj6OVVUZX139Yo1BUdEtT
kxaFyZP7XV1f9A9kZtbPmcM4bjEm/vBB+Pjr12/eI9/W1m1mxiBvbDx09SoY
AyaBYRPlI/DfFuUE6PhtVGAb9VM25pdipPw070ZbMZ7RXS3GVr3zDhSejl9+
QVdfp9IOlJ9Gl0CKBPn9YYJdRcitAsTbX1jdVmbC+VPFy+tEIGT29f3GDAey
9AmFcktDgxEFNzeIQnp6rZxc4Kfzh8bwkVevXjN3/uLGje6tW5swGGr7u2vW
DNXVgQFgxoQ/WtLR2U/lr2Y/yy1c1NR3hmeI6Pag6esdJOcRZlOzOiv7RHV1
9dDQ0IsXLwoKsqx8tsFFhwCRHZ7TCIHi3/tIbQ+QMrYWh28B8A8MLJhYC6ni
53d2ccl58GCQNQr5+e3z59OiICAw4OHxvG/g2LFKHO7Mx/lDA2g2MvLqPfI3
b3abmzPIr10L60wYFIYGAz6HX4sX798e5Qw8DQJnOSdLLglQWOgyW9p1LvOO
YJH9imvN11+9egX1v+F6o7LnariYkC00beccfa/ZBv5yzPU/KIjCniUrV8b/
v4KVRnJy1eDgMEsUHpNIkKWwCAfdXbcOChQV7Ef4//nnezn/ZmTkUWoqLCap
nUAUhhoaYCAYDgb9FNvY57/XZXSqVVV2k0MsVQzxksguVZZTEOruxhUnD+Wd
PKQfaE47F+Eqi1irLXOYLmkpD3PB+Pm/+wyvj/Cf8Bd7Xmtr76PyR6cAC+Xk
/fw/k5DAsCniFgrM/N0Cdt0vPuu0UXG5sTj1CgartsFe4nYB0krCfGc/Y8ou
JSr/4GA2+T+rqppw/Tc9/UP+cPFzjMWe17DR2LEP5S+1S94jUMR3r8SlLF7/
/eKWNoI6uBl0/qFhdoPlxKjNYo6r+anZbr5bwsNPNDpuSnyCSPA+UVNzQV5r
FeAfElLIniUfgvq6xDZ/i1H+is7ykWfFDILkVS2llwYqsNQfnIPRjxHYSEPE
ZBMt/yOyxHQ3yuh7ztZ3l5FwUqHXHy7/MUlLay+VP7r4j5wmYq9q4SvJ/PyL
NgVvlnU1EV63XkLEknarR99fWmSH8iJ3WV0PGeb5NzSUy38MWrgw6vtQO2TH
XFQWcxFL+K2C7ByVFUgVnYtB1qpo2QFhR2XLGiA6/7CwIi7/T5eyckhJSVMB
pSaPXJ2bdzmbeDEz5/yprNL0M+eOny5KOVl4NIN8+DgxMS0nLuVszLEzB46c
3HfoRFTS8YiE5LC4oyGxR4JjDwXGJPlHJ/odjPc7GIfFnuLy/xrFcYD/cP7/
zPXnl6PPsSf68vdfX44+ZY8P8vYm37hxf6ihodvcnHqvoHPVqkepqW9GRsbE
/+3bt4NFRXfXraPdtViz5jGJxHLzGQaC4T7RMI4D/NwyMkqsre0aqq9nPP7D
YCAKL27eZMF+7VpvVFTJx/lDA2j258OHAx4ezQIC1H+1z5//JD+fJQowKAzN
cfc5KEPDhJqau0N1dZClDPJbt764wfqIEJBSz6t84v1naAwfGXnwoN/NrXny
ZGqDWxoaTygUliiAAWAGx1FwhvzVq8yHDbrNzIbb2ljIX7/ey3xSaEzPX+CD
8PGR+/f7XV0ZUdDUhALFMso/JwqrViVcudKJHrBZvZqOrsvUdLiF9eEsoNu4
kfWMFhvPH6ETNAr37vU7Ozfz89OioKU1WFzMMiIYBuZxHNFnEsxl4OCzmppO
IyMG+Q0bnjc1sXBoaur7kDzb/OlRgG5HBgb6nJzoUejQ1v69pOTDKHxj0y64
U13d+Qwc++tQGeiuicnza9c+JP/xswfjPH8CnaNR6O/vc3Bo5uOjRUFH5/ey
MhZLwOBvIwooefhZtYpBfu3a542NLP42N/d/yqmPCTl/BQPBcC/7+vrs7elR
uK2r+/uFCx9GgeMAxylYhNMRoYcN6us/JG9q+qnnbSbw/CEMikaht7eXQGji
5aVFQU/vaUUFs3kcBzhO0cgbGg6NHrdmfrW09G/enDym3ib8/C0YAGa87Onp
xePpUbhjYPD08uVvgz/kP1T+8ZP/TPzfi0J3d6+tLSMKy5d/A/d//gd7fh3N

        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "BritishVirginIslands"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{114.08333333333333`, 4.583333333333333}, {
       115.01666666666667`, 4.866666666666666}, {115.01666666666667`, 
       4.883333333333333}, {114.08333333333333`, 4.583333333333333}}, {{
       115.14999999999999`, 4.9}, {115.03333333333333`, 4.816666666666666}, {
       115.14999999999999`, 4.9}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Brunei\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnAlUFFe6xyMobijQ3ewNdNPdIJuoYARBEVniuGGMS3RcRmdM9Jwx6ntg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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnAlUFFe6xyMobijQ3ewNdNPdIJuoYARBEVniuGGMS3RcRmdM9Jwx6ntg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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Brunei", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnAlUFFe6xyMobijQ3ewNdNPdIJuoYARBEVniuGGMS3RcRmdM9Jwx6ntg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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Brunei"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{28.583333333333332`, 43.75}, {28.016666666666666`, 
      41.983333333333334`}, {26.349999999999998`, 41.71666666666667}, {
      22.933333333333334`, 41.35}, {22.683333333333334`, 
      44.233333333333334`}, {28.583333333333332`, 43.75}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Bulgaria\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt0DENwmAUhdE/wQAW6gB2FDA2Iew1gAVEIAIXCOjK3KkLKn6Kihdyz5f7
kjefYbqN0661dtnuvt3v772v59My7K1k/Pknjz//5PHnnzz+/JPHn3/y+PNP
Hn/+yePPP3n8+SePP//k8eefPP78k8eff/L4l/tfn4fjo1nJ+PNPHn/+yePP
P3n8+SePP//k8eefPP78k8eff/L4808ef/7J488/efz5J48//+TxL/d/f+Z5
fVnJuiRJkiRJkiRJkiRJkiRJkv6qLzsLNeo=
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt0DENwmAUhdE/wQAW6gB2FDA2Iew1gAVEIAIXCOjK3KkLKn6Kihdyz5f7
kjefYbqN0661dtnuvt3v772v59My7K1k/Pknjz//5PHnnzz+/JPHn3/y+PNP
Hn/+yePPP3n8+SePP//k8eefPP78k8eff/L4l/tfn4fjo1nJ+PNPHn/+yePP
P3n8+SePP//k8eefPP78k8eff/L4808ef/7J488/efz5J48//+TxL/d/f+Z5
fVnJuiRJkiRJkiRJkiRJkiRJkv6qLzsLNeo=
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Bulgaria", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt0DENwmAUhdE/wQAW6gB2FDA2Iew1gAVEIAIXCOjK3KkLKn6Kihdyz5f7
kjefYbqN0661dtnuvt3v772v59My7K1k/Pknjz//5PHnnzz+/JPHn3/y+PNP
Hn/+yePPP3n8+SePP//k8eefPP78k8eff/L4l/tfn4fjo1nJ+PNPHn/+yePP
P3n8+SePP//k8eefPP78k8eff/L4808ef/7J488/efz5J48//+TxL/d/f+Z5
fVnJuiRJkiRJkiRJkiRJkiRJkv6qLzsLNeo=
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Bulgaria"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-2.683333333333333, 
      9.483333333333333}, {-5.516666666666667, 
      10.433333333333334`}, {-3.966666666666667, 13.5}, {0., 15.}, {
      0.23333333333333334`, 15.}, {2.4, 11.9}, {0.9666666666666667, 
      11.}, {-0.16666666666666666`, 
      11.133333333333333`}, {-2.8333333333333335`, 11.}, {-2.683333333333333, 
      9.483333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"BurkinaFaso\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt18lrE3EYxvFHKoIo+B8IXjx7cQEFxSoUBQmK1IMo9CDe9CbopUgvggc3
RHGBVht3i0IPogVx32jqQRtEJ7WJzVCoZjmoaVL9DcYpmaY61uqb/N4HPiml
mcAz3wlJZ0HLro0tDQA2m0ereXi/L24nIiIiIiIiIiIiIiIiIiIiIiIiIiIi
e+zsxqrOqbxwRzdWR+X31zvTP+16P8O/ZPk5dPYinpQfb4El7RgexlgOF2JY
cf73x2+7icQQvuVx7LH8eDtEe72ehglr8k522LIOnH6OYrZ88IbL8svtsP1G
OakxmsWpZ17qwDFburwPHP+wlwPys22ScsfbGv2DaL5efmpph/dRU8hUHHDw
gfxmm5x9UZHX+JrBoUfYdM17qweeKuXQdFF+s02au4KRfzDfyxP/+PSd/GD7
vE1VvwQTtd2VX2uf409CxTdfBLzt+hciV0L1v/dGfqqV9twO/pNTVSyBpkvy
a23SGMWt12E//I3MCPb1yM8OY38EB2rb1Vbkk38Q3xfvwZGt8vt/wcTvA5xa
NTAPuRNTKe8rOnDXy5/IZPpQu/3TazAa/6v4vtxJ71KKn1G99E/MRfbo9JT3
mUuZbpQ/tdrvP7QShVfTHN+XPYzEHPlzrOX+YbiRau/wfjgz5Ldp6J+YjZIb
7P+pTX6Ykv5G/kywf2qR/Co9/d11FfELMflJqvo7s1D6MN7/417pPdr6o+LW
LLlQfo+2/um15fhfHsqPUdjfmYnie6//yG7pJTr7w7tNHsthcL78Ep39zc3y
5zvyM9T2dxq8e2H5GWr71zn2Z3/N2J/9NWN/9teM/dlfM/Znf83Yn/01Y3/2
14z92V8z9md/zdif/TVjf/bXjP3ZXzP2F+9//+dVoP/PxP8ODdVyyg==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt18lrE3EYxvFHKoIo+B8IXjx7cQEFxSoUBQmK1IMo9CDe9CbopUgvggc3
RHGBVht3i0IPogVx32jqQRtEJ7WJzVCoZjmoaVL9DcYpmaY61uqb/N4HPiml
mcAz3wlJZ0HLro0tDQA2m0ereXi/L24nIiIiIiIiIiIiIiIiIiIiIiIiIiIi
e+zsxqrOqbxwRzdWR+X31zvTP+16P8O/ZPk5dPYinpQfb4El7RgexlgOF2JY
cf73x2+7icQQvuVx7LH8eDtEe72ehglr8k522LIOnH6OYrZ88IbL8svtsP1G
OakxmsWpZ17qwDFburwPHP+wlwPys22ScsfbGv2DaL5efmpph/dRU8hUHHDw
gfxmm5x9UZHX+JrBoUfYdM17qweeKuXQdFF+s02au4KRfzDfyxP/+PSd/GD7
vE1VvwQTtd2VX2uf409CxTdfBLzt+hciV0L1v/dGfqqV9twO/pNTVSyBpkvy
a23SGMWt12E//I3MCPb1yM8OY38EB2rb1Vbkk38Q3xfvwZGt8vt/wcTvA5xa
NTAPuRNTKe8rOnDXy5/IZPpQu/3TazAa/6v4vtxJ71KKn1G99E/MRfbo9JT3
mUuZbpQ/tdrvP7QShVfTHN+XPYzEHPlzrOX+YbiRau/wfjgz5Ldp6J+YjZIb
7P+pTX6Ykv5G/kywf2qR/Co9/d11FfELMflJqvo7s1D6MN7/417pPdr6o+LW
LLlQfo+2/um15fhfHsqPUdjfmYnie6//yG7pJTr7w7tNHsthcL78Ep39zc3y
5zvyM9T2dxq8e2H5GWr71zn2Z3/N2J/9NWN/9teM/dlfM/Znf83Yn/01Y3/2
14z92V8z9md/zdif/TVjf/bXjP3ZXzP2F+9//+dVoP/PxP8ODdVyyg==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["BurkinaFaso", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt18lrE3EYxvFHKoIo+B8IXjx7cQEFxSoUBQmK1IMo9CDe9CbopUgvggc3
RHGBVht3i0IPogVx32jqQRtEJ7WJzVCoZjmoaVL9DcYpmaY61uqb/N4HPiml
mcAz3wlJZ0HLro0tDQA2m0ereXi/L24nIiIiIiIiIiIiIiIiIiIiIiIiIiIi
e+zsxqrOqbxwRzdWR+X31zvTP+16P8O/ZPk5dPYinpQfb4El7RgexlgOF2JY
cf73x2+7icQQvuVx7LH8eDtEe72ehglr8k522LIOnH6OYrZ88IbL8svtsP1G
OakxmsWpZ17qwDFburwPHP+wlwPys22ScsfbGv2DaL5efmpph/dRU8hUHHDw
gfxmm5x9UZHX+JrBoUfYdM17qweeKuXQdFF+s02au4KRfzDfyxP/+PSd/GD7
vE1VvwQTtd2VX2uf409CxTdfBLzt+hciV0L1v/dGfqqV9twO/pNTVSyBpkvy
a23SGMWt12E//I3MCPb1yM8OY38EB2rb1Vbkk38Q3xfvwZGt8vt/wcTvA5xa
NTAPuRNTKe8rOnDXy5/IZPpQu/3TazAa/6v4vtxJ71KKn1G99E/MRfbo9JT3
mUuZbpQ/tdrvP7QShVfTHN+XPYzEHPlzrOX+YbiRau/wfjgz5Ldp6J+YjZIb
7P+pTX6Ykv5G/kywf2qR/Co9/d11FfELMflJqvo7s1D6MN7/417pPdr6o+LW
LLlQfo+2/um15fhfHsqPUdjfmYnie6//yG7pJTr7w7tNHsthcL78Ep39zc3y
5zvyM9T2dxq8e2H5GWr71zn2Z3/N2J/9NWN/9teM/dlfM/Znf83Yn/01Y3/2
14z92V8z9md/zdif/TVjf/bXjP3ZXzP2F+9//+dVoP/PxP8ODdVyyg==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "BurkinaFaso"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{29.016666666666666`, -2.75}, {
      29.416666666666668`, -4.45}, {30.566666666666666`, -2.4}, {
      29.016666666666666`, -2.75}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Burundi\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnXlMVFcUxgcIklErCkGrURbToglVo/1DbasxtaSxUmtpK9G01hIJxVis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              "], {{0, 0}, {128, 76}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 76}, PlotRange -> {{0, 128}, {0, 76}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnXlMVFcUxgcIklErCkGrURbToglVo/1DbasxtaSxUmtpK9G01hIJxVis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          "], {{0, 0}, {128, 76}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 76}, PlotRange -> {{0, 128}, {0, 76}}]], {
        Style["Burundi", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnXlMVFcUxgcIklErCkGrURbToglVo/1DbasxtaSxUmtpK9G01hIJxVis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        "], {{0, 0}, {128, 76}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 76}, PlotRange -> {{0, 128}, {0, 76}}], "Burundi"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{104.45, 10.416666666666666`}, {102.91666666666667`, 
      11.633333333333333`}, {102.33333333333333`, 13.549999999999999`}, {
      105.21666666666667`, 14.35}, {107.55, 14.7}, {107.55, 12.35}, {105.85, 
      11.666666666666666`}, {104.45, 10.416666666666666`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Cambodia\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnAtsU9cZx92NwGiBjnasXZnK2MbUSdsQ2rRNRau6tZq2tWUrrJP2aBEQ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              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnAtsU9cZx92NwGiBjnasXZnK2MbUSdsQ2rRNRau6tZq2tWUrrJP2aBEQ
spXSsgFimwjVWioIEF4lgBMwsQOEl9MEm8QxTkopJQ8DQZS26TNUBceJ4/h5
n/a1vf/xdZwo8StO0tskx/olOvfc75zznb+/87p2MnvpqoVLv6xSqZ7Cz//w
Q9IzVWsoFAqFQqFQKBQKhUKhUCgUCoVCoVAoFAqFQqEMEaNqNkVB2lUTKRTK
cOFZvUaoqckEprhYbG7m9HpWo8mwSF/YgweF+nrAZVdco0HTcABuZFgEXVNc
3rQwJSWRzF6CxYLfwffeC1y+nGGRvq/ApUv9EoMrfvkymo67kckLXVNc3rT4
N20KXr8uvvWWUFmZBpMpEtWfVavTGw+A3bNHloUrLc2muFod099kSmuM7qBT
6Jri8mZAjk2V0/3wI2FBSE08/sXGxrTGAxEbGmT9syze2BiP/7TG6A461U5Q
XN6McD78SNrhPIrmH3RHcUkHRefsOZ68f3ieWxmwWtHThAhmcySqP3/qVDKb
FPDHjsniYH7IpvipUzH9zeakZlYruoCOoDuKS5oF9qnTw6KYLKi++PEP59EF
xWXMnklTEDy+3bsDLS0D6Y1/vT6hQWr4EydklYSqqmyK6/W98Z/IwJO/Ac6j
C8rLODTcS3OlTz8dSFx/obY2oUFqsCGP6X/2bDbFa2vj+ic06PrxTxWXbljA
zqFr/kOuJcuYoiLeZOJra7ljx7jjx/07dwrV1ZxW69++nSsvRz65pddzFRVy
uh9cWVkscfQobJi9e2X9Wa2WlIrX0GPWv/iJE5zBEEuXl5NGtVo4ADe4I0fg
Esk3GPxFRe4lyzrnPGAbPbudDHE9uSiATSPPSx99JL7xhmAwyPMwf/x4oKkJ
+SBw8WIkGExIyOHAJjzCcaG2NqmtjT9yJBb/FRXBa9fCDgduwQBmyWqIV04a
LS+X1x0MBPHixcCVK7KBa+EfFRdqhOi495vk1HP9ulBXB/iqKll/VqfDJfIB
s20bf/Ikg6FhsTBbt5KwPHwYIET5sjJy1KqqIpFcWsrs3i3rzx06xMFGr+cr
K7kDB3CLXGJQ6HQYZcyWLaicKSjAXf+uXYGrVwGmLFajiemPIWkyiVgFrl7F
CIWTigs1Uvrfdz/6iC5LH38M4vGPmRyXsW1JS4t8fJZu3RINhuDbb/cFUSon
xLNnBb0+Fv8GA0ZTP4M4gtEo2WziuXPBDz4QMcqiL9K60RiP/2Brq+wAWoeT
igtF9R+TKK9/czPVn+w5W1vJJBzX//TpwLVrMf2RX1ODIxVZoGtrsTkUGxoI
Fy4EmpuJvK2t2LRgumZ7HrRivSA5587hLsFqFd98M9DYiFUV8zwsxfPnEflk
n2+1ykVQCUr1rr9NTXh3xo/+8biV9e97/u1rMPBFdimygO+/3/f8i8t+BomL
t7T0pnvahf7xQ/rY1t9+z30IyNT6k7C8dCkZGAWp9Rfq61MUF86cSa0/DOCk
4kKNEJ7lecMY/73PH4zGYYx/OKm4UCPChMneZ1dwxcVsURGmbn9hoW/9et9L
L/k2bPDl5yOHsH8/e+gQgjAhZAO/ZQtXUgKYwkJm82ZGrWYPHmQ2bUJtsXwc
Hyork9XAHjjA7Nsnt0XaBXAAbmzdSjL37OE0GjgJV5WXa9iZdlfI7UakBd99
N+z3+9atI0fR6IvVauWVsW989g/dpiacsITXXwc4VUmffdb3Li6RKd/lKyqw
+KYeAmgOjcaygkE4E/b55FtwEq4qL9dwY799GrNjJ7t3n4gpIhTC5oScfyWJ
PIqsqJBnAO6111h1cUJw/oUxgedF6Gw0RsLhmIDhMC6RGREE1Axw/k1aj7wE
BALkbYLgkgQ34AxKCRcuwABOwlXF5RoxcohQ0R0g+VKB2YwE1/NJin9zQbKC
3n+ujsjPiqObTC76RALjCJD04cNyvvxMFcbJ6vFv3yG3hUaJD2Yz3ECCVF5X
N4o+Ycxaf95iCXMcZmxMApg3sHVHBArnzxP9d+xMqv/adfHlFeumdPMmeROj
j4zI/HPzpryYygYwTqG/1NbG6nRkmaiuhgNww79xI19dLTQ0jL1nngP196xa
xarVfGkp2SteuRJ2ubAm8gaDe+ky16Kkzx69//5v8MMPyZGqvp7VaMjhC3NR
bPaXyOqp0eAWDGAG42T1uJ76k3ftWqa4mNm/H02TIVNfT55Cv/yye/Hi8RD/
ju99v/3Ou32rV4s4z+LwazJxJ086f/6gfcpX27+S9MMm7wurcHYgnyZHt/3B
d97hdLqQywU4rRaXkehBAAYwg3EKB/Db+YMfYfpC03BAtFo9eXkk8idMHgfx
H2XCZNeTi6BAqLMzeOOGOze3Y+as1EU8/1rjXfcf9/K/oxRbWIhjmryIyFM3
LpGJWzCAGYxT1TbxDtdC0rp04wYcwDkCu+Kunz2ovCyfEzmOufPczywWLRZM
O5h4/QUFzl892p5ze4pSnbO/a/vSJHfucuf8hxDnoVu3er//09CAS2TiFgxg
BuMUVcnf5PHm5aFp/vRpLMGOH84dXV/vGTr2e2Zy2PjV1WG6cC34Q/oit/UU
nD6DfGlz27ZgWxsOBQAJXCITt/oZp8D569+Qp3N1dWxlpX3GNxQX5PPWf/oM
5xMLuLIyz8qVnd/6Tqaxh6njz3/p/u1jUnu7YLGEursBEpLdjkzcgkFmDuSg
UTQNB+BG7xs3PsBgd8x5wLPiOfIgYuPGrvm/yPzIY7ttIuYub34+NjDYtwBs
ZrwvvohMWwZhL4Pm0CiahgOeZ1c4xuKn7WnpmPXtUFeX669PD67U1+7tmvcT
9/MvcEeP4sQKkHCvfB6ZuDWoqty5eVh/4YbiUijDHXdKn3zS/dgTgy44eapz
7jzm1VdDNhtAApfIHGw9zl8+KnV02O/6uvJSKASZsadk8wU/BK3/lVewegIk
sozhSVNcfxvc6BtrpNxzpsA+dTrmHPL0xmxGwp71E8tsHRj35LiffkZ+5ta9
4Pfjauv+RQDbFf+uXfL5y7c+X3F/xiH2aXczxSWsVmefOgY/LhkVdP/ucffi
JYq7MRQU/wPwoXBGNatGdb/ibgwFxf8BAoVCoVAoFAqFQqFQKBQKhUKhUCgU
CoVCoVAoY4D/A4uG0t4=
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Cambodia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnAtsU9cZx92NwGiBjnasXZnK2MbUSdsQ2rRNRau6tZq2tWUrrJP2aBEQ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        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Cambodia"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.816666666666666, 2.35}, {9.75, 4.133333333333333}, {8.6, 
      4.816666666666666}, {9.8, 6.8}, {11.883333333333333`, 
      7.083333333333333}, {14.65, 11.566666666666666`}, {14.066666666666666`, 
      13.083333333333334`}, {15.683333333333334`, 9.983333333333333}, {13.95, 
      9.633333333333333}, {15.5, 7.533333333333333}, {14.416666666666666`, 
      6.05}, {16.2, 2.216666666666667}, {13.299999999999999`, 
      2.1666666666666665`}, {11.333333333333334`, 2.1666666666666665`}, {
      9.816666666666666, 2.35}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Cameroon\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3D1oE2Ecx/HnkkvuLiKIINIWtfFlFLVVJ9H60jiIg4I4uEhnoW4uDg7q
6KCrLr6Ciy46OTo4OIl1FJJckmpjXvtim9b6XCppTZpcLgl5CPnC7yAcl+P+
n7v73/MkIeGJycsTfiHEFbnckYvzWpwPK8zJ0cGoCCnM3Cv/alGoyp80/vjj
jz/++OOPP/74d9H/l2L/U/jjjz/++OOvxP8l/vjjjz/+CjKGP/74448//n3o
n8Eff/zxxx9/BTk9MoA//vjj36f+L/DHH3/88ce/7/zPePGfuRS0d5sum/ms
zI1A1LTw77h/atRYSYqZq8F6G9hD5sI739xrf89c/9le8o9qVmlKk4c9+9gf
21p9hf+8GFyOOUWlr9U9Qfi35S9C+bv62pGXvmqp48bayljIKj7UK3d0fFuz
zQd/r/6po8bGg8/eCqRGjKXPWmXl/Bufpx3i74mr0oLqJX3dQ/PB37O/bEH3
9Lrl5ER8h4fmg38L/qljRr1yFt57az74e/Y31h+1tSl905IH3SYI+G/IWS/+
iQPm4sdGzX+1PP7JTAbkLAz/zvrLUf3KdLN1zb/1xXc2dQrwdyWSU63ZJ56V
lr+LHxHD3f85/g2ftqPG0heXnlO3uoLI39ejwUY3Av6N/e1B095jJobNRNhM
7C1nn5nYb8p2tLGQ3x98ctob327J8afsPPaAaQ+Z9i7nvbEt+LfVfzZPwFqO
rhfiPHNb2o9i/1zP+otQ8dE6nbw78O+y//TYv4nY4iet5Z30vX8bv3/zW3KQ
I6vI3dbxV+AvQoUHzlw4ebjF5oN/m/7TJ4zSlBbVvH3mhn+n/J1ve2+2OPLB
vwP+MnrrFz/+HfBvL/jjj3/f+p87gj/++Kvzf6bUP48//vjjjz/++OOPf1cz
jj/++OOPP/74448//vh3zb+g2D+Cf5/7P8Uff/zxxx9//PHHH3/8nWiR6vg2
iz8yXBW9JoHx6gTLuXBI9f+/1fhLk0bJN0zOLdn/kxF/Aa0K8jo=
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3D1oE2Ecx/HnkkvuLiKIINIWtfFlFLVVJ9H60jiIg4I4uEhnoW4uDg7q
6KCrLr6Ciy46OTo4OIl1FJJckmpjXvtim9b6XCppTZpcLgl5CPnC7yAcl+P+
n7v73/MkIeGJycsTfiHEFbnckYvzWpwPK8zJ0cGoCCnM3Cv/alGoyp80/vjj
jz/++OOPP/74d9H/l2L/U/jjjz/++OOvxP8l/vjjjz/+CjKGP/74448//n3o
n8Eff/zxxx9/BTk9MoA//vjj36f+L/DHH3/88ce/7/zPePGfuRS0d5sum/ms
zI1A1LTw77h/atRYSYqZq8F6G9hD5sI739xrf89c/9le8o9qVmlKk4c9+9gf
21p9hf+8GFyOOUWlr9U9Qfi35S9C+bv62pGXvmqp48bayljIKj7UK3d0fFuz
zQd/r/6po8bGg8/eCqRGjKXPWmXl/Bufpx3i74mr0oLqJX3dQ/PB37O/bEH3
9Lrl5ER8h4fmg38L/qljRr1yFt57az74e/Y31h+1tSl905IH3SYI+G/IWS/+
iQPm4sdGzX+1PP7JTAbkLAz/zvrLUf3KdLN1zb/1xXc2dQrwdyWSU63ZJ56V
lr+LHxHD3f85/g2ftqPG0heXnlO3uoLI39ejwUY3Av6N/e1B095jJobNRNhM
7C1nn5nYb8p2tLGQ3x98ctob327J8afsPPaAaQ+Z9i7nvbEt+LfVfzZPwFqO
rhfiPHNb2o9i/1zP+otQ8dE6nbw78O+y//TYv4nY4iet5Z30vX8bv3/zW3KQ
I6vI3dbxV+AvQoUHzlw4ebjF5oN/m/7TJ4zSlBbVvH3mhn+n/J1ve2+2OPLB
vwP+MnrrFz/+HfBvL/jjj3/f+p87gj/++Kvzf6bUP48//vjjjz/++OOPf1cz
jj/++OOPP/74448//vh3zb+g2D+Cf5/7P8Uff/zxxx9//PHHH3/8nWiR6vg2
iz8yXBW9JoHx6gTLuXBI9f+/1fhLk0bJN0zOLdn/kxF/Aa0K8jo=
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Cameroon", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3D1oE2Ecx/HnkkvuLiKIINIWtfFlFLVVJ9H60jiIg4I4uEhnoW4uDg7q
6KCrLr6Ciy46OTo4OIl1FJJckmpjXvtim9b6XCppTZpcLgl5CPnC7yAcl+P+
n7v73/MkIeGJycsTfiHEFbnckYvzWpwPK8zJ0cGoCCnM3Cv/alGoyp80/vjj
jz/++OOPP/74d9H/l2L/U/jjjz/++OOvxP8l/vjjjz/+CjKGP/74448//n3o
n8Eff/zxxx9/BTk9MoA//vjj36f+L/DHH3/88ce/7/zPePGfuRS0d5sum/ms
zI1A1LTw77h/atRYSYqZq8F6G9hD5sI739xrf89c/9le8o9qVmlKk4c9+9gf
21p9hf+8GFyOOUWlr9U9Qfi35S9C+bv62pGXvmqp48bayljIKj7UK3d0fFuz
zQd/r/6po8bGg8/eCqRGjKXPWmXl/Bufpx3i74mr0oLqJX3dQ/PB37O/bEH3
9Lrl5ER8h4fmg38L/qljRr1yFt57az74e/Y31h+1tSl905IH3SYI+G/IWS/+
iQPm4sdGzX+1PP7JTAbkLAz/zvrLUf3KdLN1zb/1xXc2dQrwdyWSU63ZJ56V
lr+LHxHD3f85/g2ftqPG0heXnlO3uoLI39ejwUY3Av6N/e1B095jJobNRNhM
7C1nn5nYb8p2tLGQ3x98ctob327J8afsPPaAaQ+Z9i7nvbEt+LfVfzZPwFqO
rhfiPHNb2o9i/1zP+otQ8dE6nbw78O+y//TYv4nY4iet5Z30vX8bv3/zW3KQ
I6vI3dbxV+AvQoUHzlw4ebjF5oN/m/7TJ4zSlBbVvH3mhn+n/J1ve2+2OPLB
vwP+MnrrFz/+HfBvL/jjj3/f+p87gj/++Kvzf6bUP48//vjjjz/++OOPf1cz
jj/++OOPP/74448//vh3zb+g2D+Cf5/7P8Uff/zxxx9//PHHH3/8nWiR6vg2
iz8yXBW9JoHx6gTLuXBI9f+/1fhLk0bJN0zOLdn/kxF/Aa0K8jo=
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Cameroon"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxVVGtIFFEUXqRAtAR/REQZpBQ9QIKSJAumcJ+zM3vvzs6u7qo7RQYWFRRm
UEFEhdGDQioUggqLHiJB0A+LGHr4yyIQiX5shNCDCsNM6Fe0c79vRzqwDGfv
ud/5znfOuSt2Hkh2lgUCgZ7iz/v+nCracIcb8OxERKv1bHv7/37ZnK++gazv
vx4rWrzF923POtPwAxGt17Ny221WFtYe3C/aQMpVuCeD2kB/0e6l3N2ehYLA
G0q5PZ69a0b8iOUq3O6gpmBeWq6KOz/nK7xbQW2DZzNJ90OhaFtDmsJNJ5kv
BP4fpe8r3FcS+e+ENKWHKd2nTzwLg8+YAJ9rIU3h7hPMR7z1wlU8K8Kautck
wG+IeMMJF98Qzs8J1NNAvHbBfEGcHzV9fBU3a7rVnk2X+CeQ7xvx1gnUWwij
3sfC11/9v5C+xn61lfhHoNe4xLkTBt/9EnyrItRXov5NEeTbK8Gnmvg1wlV9
Xh3V8L/pqr4uiQLvjY76lsYwT5M69YwBf54B/jU66m0o1R/D/fq5c+gaR/0x
XVM4GZPzp2v9Km8C+XJx4gnUU28i36kSX4PzLIlnEI/zMRlHvgWcj5AB/s8l
7pebfrzS8ZCJfPM5fwUT/ThjAX9tAvkHLfAxDcSvtBB/PY59iVjAG9eh5zR9
i/pMWKwvivgj3JfFMfSzL4X4Ph37k7WBf7ykbxp89jBfY4b847yf4f4Y8B9l
OD8m4u+mUX9vAnoczIBPpUC//tq+D71s1is4v2nsxzGB/X/P9yEloPePlMs9
wXwZNviO8L6TAh9XoB6b8bqEvrts6NEjwf+Fjfi3xN+SJh8JvEv0qyT02pyh
PsQbZP2BJOqpbWH9kv3PcJ4k+BbofxW4/zuDfb8tsD+VLcg3JTAfh1ugf530
31OF+4V6XmxFfd+px4Us/CbGL8tRb4n578r6fFB3FvN7lXqdzrEeifyjbcg/
w3zP2rjvEvGL8rifpp51eez3WYl6cnn2j/kCDuuV6G+r49/HO+iAXyPxGxy8
J5cZf9PB/LXz/JODfGsk5u/GDvhdzFf0Ff4qE/hTzPfZQLxGPrM68Lcx3zTf
l+WMH42h/xUO3wueD+d9X+H9yQNvIop5+EX/ShT93ki/Owp+Dzu4fxHtH1QD
YUA=
       "], {{-131.66666666666666`, 54.11666666666667}, {-132.7, 
       53.25}, {-133.06666666666666`, 
       54.166666666666664`}, {-131.66666666666666`, 
       54.11666666666667}}, {{-127.46666666666667`, 50.7}, {-123.55, 
       48.3}, {-127.48333333333333`, 50.7}}, {{-119.73333333333333`, 
       74.03333333333333}, {-115.31666666666666`, 73.48333333333333}, {-122.8,
        71.08333333333333}, {-126., 71.96666666666667}, {-124.78333333333333`,
        74.33333333333333}, {-119.75, 74.03333333333333}}, {{-114.6, 
       72.6}, {-108.6, 72.51666666666667}, {-107.85, 
       71.6}, {-108.08333333333333`, 73.35}, {-105.2, 
       72.38333333333333}, {-100.96666666666667`, 
       70.15}, {-102.89999999999999`, 68.8}, {-106.58333333333333`, 
       69.5}, {-113.31666666666666`, 
       68.46666666666667}, {-117.43333333333334`, 70.}, {-111.48333333333333`,
        70.33333333333333}, {-117.56666666666666`, 
       70.6}, {-115.06666666666666`, 71.53333333333333}, {-119.1, 
       71.68333333333334}, {-117.35, 72.91666666666667}, {-114.6, 
       72.6}}, {{-83.01666666666667, 64.91666666666667}, {-80.96666666666667, 
       63.449999999999996`}, {-85.23333333333333, 
       63.11666666666667}, {-87.18333333333334, 
       63.583333333333336`}, {-85.61666666666666, 
       65.91666666666667}, {-83.01666666666667, 
       64.91666666666667}}, {{-104.48333333333333`, 
       73.53333333333333}, {-105.28333333333333`, 
       72.85}, {-107.03333333333333`, 
       73.48333333333333}, {-104.48333333333333`, 
       73.53333333333333}}, {{-97.86666666666666, 
       69.88333333333333}, {-95.53333333333333, 
       68.66666666666667}, {-99.43333333333334, 
       68.88333333333333}, {-97.86666666666666, 
       69.88333333333333}}, {{-55.61666666666667, 51.61666666666667}, {-56.85,
        49.55}, {-55.38333333333333, 
       49.03333333333333}, {-53.483333333333334`, 
       49.28333333333333}, {-53.666666666666664`, 
       47.516666666666666`}, {-52.833333333333336`, 
       48.1}, {-53.083333333333336`, 46.65}, {-54.25, 
       47.9}, {-55.38333333333333, 46.86666666666667}, {-55.766666666666666`, 
       47.95}, {-59.3, 47.61666666666667}, {-59.4, 
       47.916666666666664`}, {-57.833333333333336`, 
       49.833333333333336`}, {-55.61666666666667, 
       51.6}}, {{-60.31666666666666, 46.85}, {-61.15, 45.7}, {-59.8, 
       45.93333333333333}, {-61.516666666666666`, 
       45.93333333333333}, {-60.31666666666666, 46.85}}, {{-67.23333333333333,
        68.28333333333333}, {-61.266666666666666`, 
       66.63333333333333}, {-63.55, 64.88333333333333}, {-64.35, 
       66.35}, {-68.53333333333333, 66.3}, {-67.38333333333333, 
       65.53333333333333}, {-64.63333333333333, 62.9}, {-69., 
       63.75}, {-66.06666666666666, 61.86666666666667}, {-71.4, 
       63.05}, {-75.2, 64.45}, {-78., 64.41666666666667}, {-77.43333333333334,
        65.46666666666667}, {-75.38333333333333, 
       64.71666666666667}, {-73.48333333333333, 65.45}, {-71.25, 
       65.95}, {-69.21666666666667, 66.56666666666666}, {-72.98333333333333, 
       66.75}, {-76.65, 68.7}, {-79.01666666666667, 
       70.68333333333334}, {-80.95, 69.71666666666667}, {-87.91666666666667, 
       70.23333333333333}, {-89.56666666666666, 
       71.08333333333333}, {-90.01666666666667, 71.88333333333333}, {-86.15, 
       73.86666666666666}, {-86.8, 70.98333333333333}, {-85.68333333333334, 
       72.9}, {-81.96666666666667, 73.73333333333333}, {-80.96666666666667, 
       71.88333333333333}, {-77.06666666666666, 72.75}, {-75.08333333333333, 
       71.18333333333334}, {-73.38333333333333, 
       70.98333333333333}, {-71.91666666666667, 
       71.56666666666666}, {-72.61666666666666, 
       70.63333333333333}, {-71.53333333333333, 
       70.01666666666667}, {-69.86666666666666, 70.88333333333333}, {-69., 
       70.}, {-70.03333333333333, 69.53333333333333}, {-66.76666666666667, 
       69.33333333333333}, {-69.4, 68.86666666666666}, {-67.23333333333333, 
       68.28333333333333}}, {{-95.08333333333333, 74.01666666666667}, {-90.2, 
       73.9}, {-94.06666666666666, 71.98333333333333}, {-95.08333333333333, 
       74.01666666666667}}, {{-118.64999999999999`, 
       77.36666666666666}, {-115.89999999999999`, 
       76.68333333333334}, {-120.33333333333333`, 
       75.8}, {-123.03333333333333`, 
       76.08333333333333}, {-118.64999999999999`, 
       77.36666666666666}}, {{-103.7, 79.35}, {-99.18333333333334, 
       77.83333333333333}, {-104.81666666666666`, 78.35}, {-103.7, 
       79.35}}, {{-100.38333333333333`, 
       76.63333333333333}, {-97.61666666666666, 
       75.11666666666666}, {-102.78333333333333`, 
       75.55}, {-101.86666666666666`, 76.45}, {-100.38333333333333`, 
       76.63333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Canada\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztm39sU1UUx5f4n7oYJBHFGCQhGhIIssxN3cSJCoRsgrqhQIYyTRQwgyjO
H4mBADHKQqIhkmB0amIwI05IJMIWkrVru7Vrt9HRja3dgO5HWbu2K23X36/P
Ux+ptVsf77W9PV3e/eYsaV/vu9+TT+/uPff1veV1+1+vu6egoKAC/g7DX+x1
+71PEQ12gYs0H8qfX+gAKf8FHdj8MhU6QMp/QQc5MhOnm1XL1mtLarwGIzkX
dIB5y9/S1MJZuPsGybmgA8xb/lNnLnAWs8Yb5FzQAeYtf+sfrZxFYGKKnAs6
wLzlP/1XO2cRdrnJuaADzFv+jjYVZxENhcm5oAPMW/4zHVroX/ZAMTkLlvJP
rdtqPfSveOR5chYs5Z9aUHZC/50rNpCzYCn/1PIOjkD/mjVbyFmwlH9q+UbH
oX/ts2+Rs2AlyT8aYSw//wnljc9kZoKhVM2g7If+e1/ezdMVlKYwTdla2hyt
yjQyYSXJHzT65Xfc6bL7i7qe3NS38b2hPYdvHv/RevaSW2cIOVzQJjTthAb6
V/ey/35l/puTTpnG0tQC5w7UNujKdyiWrounYW2+SPkLV8TrUzxcztOtYklZ
d3F17MXSderVVVCF8jRWPlbBBIKUvyjBmM9WDv1v1KedBjpALP7dT9dkKwfD
9o8pf1HyjYzxTymiIpMaFR1g7vnDxhZm7OymAYtylGEo/7vKdv6yfHEpiUyu
bjsQ8cxS/jwaP/kbFJzkktGW1PjHblH+cwWTg6mhMQf5qJatd3VdofwTxfgC
UKLkLCX5opKpMxcof04h+0zPi7tyn5jAFRkdIFH+UGfC7hUrNyErMjpAcvxJ
1Jli464rMjpAQvzJ1Zlig39FRk+PBH/SdabY4FmR0XMjwd9nMsNXoCvfgZ4e
hPLRF24cPZXqJi709Ejw5xRyuvLhv2Di1O88SaKnR44/SP5gCXqG9r/l0uTP
/YCIHjATSpO/o1WJnh7EcP0xafIf+eyEwE76q/d3PrFJuKl+y94rlR8IbKx7
brsU+UejApEOf3gUml8/8r1wU6dMwwSCAn/BlBUWhd1eqfF3qXqFnA4jORqO
QPuB2gbhptyUDlS1z7wppL2jTSU1/sYDX8XbwAiEvUBPRW3SudrSbRHPnZGp
WbNVuOng7i+4s4JWu3pVZeJHUO33bXy3a+XmxIPXD52UFP9ohFE9/lJ3cbXx
o69t5y6HZ25zxxNXhM4VG+IPVjC+gKidAnxZcS/f6Dh4xT9yKXu44yGHy35J
YfrkODTufaVOUvwZfzA07Zx7PDLrVy2Psep4qMzTPxw/7u4ZEOd739rEKd2j
H1IsKYPj+qo98+YTsNgkxZ9HsUtDhUVJtwtafjkn1nemQ5vYA7yFvZ5bZxCb
DzrAHPOHqWbuvYKmg9+I9R379tekTtJ7TBUdYI75z6s07oUbePvTrFijA8wH
/ol30goM9eqqrFijA0Tnn+ZlIliCs/FcJDpAdP72ix3pWTvbNZR/5gTMjT+l
Z20+0UT5Z04AVlKuK/3WfVDDDO07ksrLsPOgraUtfs0B3lL+mRPQrH0NIr4j
CExa5Yvm+dVGvrg0eGs61iIahQpWvaqya+XmzN3RAeLyjzLM5A9nuUtwcQ3X
H5trZGpo/N+JofDE6WbYaGeYADpAXP7zym+2JD0d8N/gz7bQAeYhf9C19w8l
uiQN/iwKHWB+8o89IFN454ooucHPUv6pNfjO5+2EBz9L+aeW99oobHKJDn6W
8ucVVPhEBz9L+fPKc9VIdPCzlD+20AFS/gs6sPllKnSAlD/R+Ad2z0DI
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztm39sU1UUx5f4n7oYJBHFGCQhGhIIssxN3cSJCoRsgrqhQIYyTRQwgyjO
H4mBADHKQqIhkmB0amIwI05IJMIWkrVru7Vrt9HRja3dgO5HWbu2K23X36/P
Ux+ptVsf77W9PV3e/eYsaV/vu9+TT+/uPff1veV1+1+vu6egoKAC/g7DX+x1
+71PEQ12gYs0H8qfX+gAKf8FHdj8MhU6QMp/QQc5MhOnm1XL1mtLarwGIzkX
dIB5y9/S1MJZuPsGybmgA8xb/lNnLnAWs8Yb5FzQAeYtf+sfrZxFYGKKnAs6
wLzlP/1XO2cRdrnJuaADzFv+jjYVZxENhcm5oAPMW/4zHVroX/ZAMTkLlvJP
rdtqPfSveOR5chYs5Z9aUHZC/50rNpCzYCn/1PIOjkD/mjVbyFmwlH9q+UbH
oX/ts2+Rs2AlyT8aYSw//wnljc9kZoKhVM2g7If+e1/ezdMVlKYwTdla2hyt
yjQyYSXJHzT65Xfc6bL7i7qe3NS38b2hPYdvHv/RevaSW2cIOVzQJjTthAb6
V/ey/35l/puTTpnG0tQC5w7UNujKdyiWrounYW2+SPkLV8TrUzxcztOtYklZ
d3F17MXSderVVVCF8jRWPlbBBIKUvyjBmM9WDv1v1KedBjpALP7dT9dkKwfD
9o8pf1HyjYzxTymiIpMaFR1g7vnDxhZm7OymAYtylGEo/7vKdv6yfHEpiUyu
bjsQ8cxS/jwaP/kbFJzkktGW1PjHblH+cwWTg6mhMQf5qJatd3VdofwTxfgC
UKLkLCX5opKpMxcof04h+0zPi7tyn5jAFRkdIFH+UGfC7hUrNyErMjpAcvxJ
1Jli464rMjpAQvzJ1Zlig39FRk+PBH/SdabY4FmR0XMjwd9nMsNXoCvfgZ4e
hPLRF24cPZXqJi709Ejw5xRyuvLhv2Di1O88SaKnR44/SP5gCXqG9r/l0uTP
/YCIHjATSpO/o1WJnh7EcP0xafIf+eyEwE76q/d3PrFJuKl+y94rlR8IbKx7
brsU+UejApEOf3gUml8/8r1wU6dMwwSCAn/BlBUWhd1eqfF3qXqFnA4jORqO
QPuB2gbhptyUDlS1z7wppL2jTSU1/sYDX8XbwAiEvUBPRW3SudrSbRHPnZGp
WbNVuOng7i+4s4JWu3pVZeJHUO33bXy3a+XmxIPXD52UFP9ohFE9/lJ3cbXx
o69t5y6HZ25zxxNXhM4VG+IPVjC+gKidAnxZcS/f6Dh4xT9yKXu44yGHy35J
YfrkODTufaVOUvwZfzA07Zx7PDLrVy2Psep4qMzTPxw/7u4ZEOd739rEKd2j
H1IsKYPj+qo98+YTsNgkxZ9HsUtDhUVJtwtafjkn1nemQ5vYA7yFvZ5bZxCb
DzrAHPOHqWbuvYKmg9+I9R379tekTtJ7TBUdYI75z6s07oUbePvTrFijA8wH
/ol30goM9eqqrFijA0Tnn+ZlIliCs/FcJDpAdP72ix3pWTvbNZR/5gTMjT+l
Z20+0UT5Z04AVlKuK/3WfVDDDO07ksrLsPOgraUtfs0B3lL+mRPQrH0NIr4j
CExa5Yvm+dVGvrg0eGs61iIahQpWvaqya+XmzN3RAeLyjzLM5A9nuUtwcQ3X
H5trZGpo/N+JofDE6WbYaGeYADpAXP7zym+2JD0d8N/gz7bQAeYhf9C19w8l
uiQN/iwKHWB+8o89IFN454ooucHPUv6pNfjO5+2EBz9L+aeW99oobHKJDn6W
8ucVVPhEBz9L+fPKc9VIdPCzlD+20AFS/gs6sPllKnSAlD/R+Ad2z0DI
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Canada", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztm39sU1UUx5f4n7oYJBHFGCQhGhIIssxN3cSJCoRsgrqhQIYyTRQwgyjO
H4mBADHKQqIhkmB0amIwI05IJMIWkrVru7Vrt9HRja3dgO5HWbu2K23X36/P
Ux+ptVsf77W9PV3e/eYsaV/vu9+TT+/uPff1veV1+1+vu6egoKAC/g7DX+x1
+71PEQ12gYs0H8qfX+gAKf8FHdj8MhU6QMp/QQc5MhOnm1XL1mtLarwGIzkX
dIB5y9/S1MJZuPsGybmgA8xb/lNnLnAWs8Yb5FzQAeYtf+sfrZxFYGKKnAs6
wLzlP/1XO2cRdrnJuaADzFv+jjYVZxENhcm5oAPMW/4zHVroX/ZAMTkLlvJP
rdtqPfSveOR5chYs5Z9aUHZC/50rNpCzYCn/1PIOjkD/mjVbyFmwlH9q+UbH
oX/ts2+Rs2AlyT8aYSw//wnljc9kZoKhVM2g7If+e1/ezdMVlKYwTdla2hyt
yjQyYSXJHzT65Xfc6bL7i7qe3NS38b2hPYdvHv/RevaSW2cIOVzQJjTthAb6
V/ey/35l/puTTpnG0tQC5w7UNujKdyiWrounYW2+SPkLV8TrUzxcztOtYklZ
d3F17MXSderVVVCF8jRWPlbBBIKUvyjBmM9WDv1v1KedBjpALP7dT9dkKwfD
9o8pf1HyjYzxTymiIpMaFR1g7vnDxhZm7OymAYtylGEo/7vKdv6yfHEpiUyu
bjsQ8cxS/jwaP/kbFJzkktGW1PjHblH+cwWTg6mhMQf5qJatd3VdofwTxfgC
UKLkLCX5opKpMxcof04h+0zPi7tyn5jAFRkdIFH+UGfC7hUrNyErMjpAcvxJ
1Jli464rMjpAQvzJ1Zlig39FRk+PBH/SdabY4FmR0XMjwd9nMsNXoCvfgZ4e
hPLRF24cPZXqJi709Ejw5xRyuvLhv2Di1O88SaKnR44/SP5gCXqG9r/l0uTP
/YCIHjATSpO/o1WJnh7EcP0xafIf+eyEwE76q/d3PrFJuKl+y94rlR8IbKx7
brsU+UejApEOf3gUml8/8r1wU6dMwwSCAn/BlBUWhd1eqfF3qXqFnA4jORqO
QPuB2gbhptyUDlS1z7wppL2jTSU1/sYDX8XbwAiEvUBPRW3SudrSbRHPnZGp
WbNVuOng7i+4s4JWu3pVZeJHUO33bXy3a+XmxIPXD52UFP9ohFE9/lJ3cbXx
o69t5y6HZ25zxxNXhM4VG+IPVjC+gKidAnxZcS/f6Dh4xT9yKXu44yGHy35J
YfrkODTufaVOUvwZfzA07Zx7PDLrVy2Psep4qMzTPxw/7u4ZEOd739rEKd2j
H1IsKYPj+qo98+YTsNgkxZ9HsUtDhUVJtwtafjkn1nemQ5vYA7yFvZ5bZxCb
DzrAHPOHqWbuvYKmg9+I9R379tekTtJ7TBUdYI75z6s07oUbePvTrFijA8wH
/ol30goM9eqqrFijA0Tnn+ZlIliCs/FcJDpAdP72ix3pWTvbNZR/5gTMjT+l
Z20+0UT5Z04AVlKuK/3WfVDDDO07ksrLsPOgraUtfs0B3lL+mRPQrH0NIr4j
CExa5Yvm+dVGvrg0eGs61iIahQpWvaqya+XmzN3RAeLyjzLM5A9nuUtwcQ3X
H5trZGpo/N+JofDE6WbYaGeYADpAXP7zym+2JD0d8N/gz7bQAeYhf9C19w8l
uiQN/iwKHWB+8o89IFN454ooucHPUv6pNfjO5+2EBz9L+aeW99oobHKJDn6W
8ucVVPhEBz9L+fPKc9VIdPCzlD+20AFS/gs6sPllKnSAlD/R+Ad2z0DI
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Canada"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-23.3104, 14.884}, {-23.3063, 14.8635}, {-23.3289, 
       14.8374}, {-23.3906, 14.8059}, {-23.4831, 14.7949}, {-23.5469, 
       14.8018}, {-23.6333, 14.8593}, {-23.6847, 14.958}, {-23.6888, 
       15.0978}, {-23.7238, 15.1869}, {-23.7238, 15.2485}, {-23.6991, 
       15.2691}, {-23.6559, 15.2718}, {-23.6168, 15.2677}, {-23.5695, 
       15.217}, {-23.5243, 15.0841}, {-23.4379, 14.9731}, {-23.3104, 
       14.884}}, {{-22.6501, 15.8626}, {-22.6751, 15.8574}, {-22.7078, 
       15.8574}, {-22.7904, 15.8647}, {-22.8542, 15.8595}, {-22.8854, 
       15.8688}, {-22.9477, 15.9218}, {-22.9477, 15.9342}, {-22.9212, 
       15.9508}, {-22.9212, 15.9799}, {-22.954, 16.0142}, {-22.9618, 
       16.0266}, {-22.9524, 16.037}, {-22.9181, 16.0495}, {-22.8916, 
       16.0765}, {-22.8792, 16.1367}, {-22.8527, 16.1429}, {-22.8278, 
       16.1429}, {-22.7888, 16.1294}, {-22.767, 16.1294}, {-22.6657, 
       16.1346}, {-22.6283, 16.1336}, {-22.6003, 16.1253}, {-22.5878, 
       16.0962}, {-22.58, 16.0463}, {-22.5582, 16.0339}, {-22.5551, 
       16.0225}, {-22.6439, 15.9249}, {-22.6501, 15.8626}}, {{-25.0189, 
       16.9946}, {-25.0568, 16.9741}, {-25.1508, 16.9296}, {-25.2376, 
       16.8465}, {-25.2954, 16.8393}, {-25.3442, 16.8393}, {-25.3695, 
       16.8525}, {-25.3533, 16.938}, {-25.3623, 16.9513}, {-25.4473, 
       16.9729}, {-25.4563, 16.9826}, {-25.4527, 16.9898}, {-25.3948, 
       17.0271}, {-25.3605, 17.0633}, {-25.2864, 17.1042}, {-25.2539, 
       17.1379}, {-25.2177, 17.1488}, {-25.2087, 17.15}, {-25.1761, 
       17.1428}, {-25.1364, 17.1367}, {-25.1075, 17.1391}, {-25.084, 
       17.1331}, {-25.0225, 17.0452}, {-25.0189, 16.9946}}, {{-24.082, 
       16.5612}, {-24.0508, 16.5404}, {-24.0477, 16.5145}, {-24.0477, 
       16.502}, {-24.0695, 16.4885}, {-24.1397, 16.4896}, {-24.2472, 
       16.5041}, {-24.3002, 16.4999}, {-24.3204, 16.4885}, {-24.3282, 
       16.3909}, {-24.3298, 16.3868}, {-24.3547, 16.3868}, {-24.3936, 
       16.4065}, {-24.5105, 16.5186}, {-24.5339, 16.5529}, {-24.5308, 
       16.5716}, {-24.4575, 16.6121}, {-24.4264, 16.6183}, {-24.3952, 
       16.6173}, {-24.3391, 16.5913}, {-24.1584, 16.5809}, {-24.082, 
       16.5612}}, {{-24.4255, 14.7199}, {-24.4839, 14.7413}, {-24.5148, 
       14.7421}, {-24.5411, 14.7405}, {-24.5768, 14.7413}, {-24.665, 
       14.8175}, {-24.6757, 14.8675}, {-24.6304, 14.9612}, {-24.5935, 
       14.9755}, {-24.5339, 14.9723}, {-24.4982, 14.9739}, {-24.4529, 
       14.9842}, {-24.4326, 14.9842}, {-24.4112, 14.9771}, {-24.3719, 
       14.9215}, {-24.3409, 14.8508}, {-24.3421, 14.7865}, {-24.3624, 
       14.7365}, {-24.3838, 14.7238}, {-24.3969, 14.723}, {-24.4255, 
       14.7199}}, {{-22.8234, 16.6614}, {-22.7989, 16.592}, {-22.8041, 
       16.5825}, {-22.8221, 16.58}, {-22.853, 16.58}, {-22.871, 
       16.5791}, {-22.9057, 16.5671}, {-22.9122, 16.5671}, {-22.9224, 
       16.574}, {-22.9315, 16.6083}, {-22.9315, 16.7034}, {-22.9379, 
       16.724}, {-22.9765, 16.76}, {-22.9765, 16.7755}, {-22.9559, 
       16.8286}, {-22.9508, 16.8972}, {-22.934, 16.9126}, {-22.8826, 
       16.9221}, {-22.8105, 16.9204}, {-22.7873, 16.9032}, {-22.7899, 
       16.8003}, {-22.8118, 16.7943}, {-22.8427, 16.7772}, {-22.8504, 
       16.766}, {-22.8491, 16.736}, {-22.8311, 16.7223}, {-22.8028, 
       16.7137}, {-22.7989, 16.7034}, {-22.8105, 16.6837}, {-22.8234, 
       16.6614}}, {{-23.1232, 15.2252}, {-23.0985, 15.2033}, {-23.0985, 
       15.1841}, {-23.1273, 15.1225}, {-23.1088, 15.0581}, {-23.1397, 
       15.0128}, {-23.1685, 14.9991}, {-23.2075, 15.0142}, {-23.2117, 
       15.0375}, {-23.2651, 15.0731}, {-23.2692, 15.0868}, {-23.2487, 
       15.1266}, {-23.2878, 15.2157}, {-23.2878, 15.239}, {-23.2754, 
       15.2499}, {-23.226, 15.2513}, {-23.1232, 15.2252}}, {{-24.9245, 
       16.8574}, {-24.9153, 16.8507}, {-24.9098, 16.8434}, {-24.9098, 
       16.8276}, {-24.8768, 16.7977}, {-24.8768, 16.7916}, {-24.8796, 
       16.7867}, {-24.9052, 16.7781}, {-24.9107, 16.7726}, {-24.9107, 
       16.7488}, {-24.919, 16.7293}, {-24.9419, 16.7189}, {-25.0581, 
       16.7189}, {-25.0746, 16.7226}, {-25.081, 16.7354}, {-25.1662, 
       16.7818}, {-25.1689, 16.8123}, {-25.1497, 16.8459}, {-25.1287, 
       16.8526}, {-25.0005, 16.8574}, {-24.9245, 16.8574}}, {{-24.8053, 
       14.7958}, {-24.8028, 14.7875}, {-24.8011, 14.778}, {-24.7885, 
       14.7724}, {-24.76, 14.769}, {-24.7391, 14.7595}, {-24.7299, 
       14.7389}, {-24.7475, 14.7193}, {-24.8112, 14.7037}, {-24.8514, 
       14.7025}, {-24.8875, 14.712}, {-24.9135, 14.7366}, {-24.9101, 
       14.7556}, {-24.8464, 14.8104}, {-24.8279, 14.8126}, {-24.8129, 
       14.8109}, {-24.8053, 14.7958}}, {{-24.7944, 16.5895}, {-24.7865, 
       16.5721}, {-24.7931, 16.5598}, {-24.8206, 16.5537}, {-24.8559, 
       16.5572}, {-24.8847, 16.5799}, {-24.8873, 16.5982}, {-24.8755, 
       16.6139}, {-24.8559, 16.6174}, {-24.8258, 16.6148}, {-24.7944, 
       16.5895}}, {{-24.7041, 16.5415}, {-24.6308, 16.5415}, {-24.6046, 
       16.5345}, {-24.602, 16.525}, {-24.6164, 16.5162}, {-24.6596, 
       16.5005}, {-24.691, 16.5014}, {-24.7067, 16.5084}, {-24.7185, 
       16.5258}, {-24.7159, 16.5363}, {-24.7041, 16.5415}}, {{-24.8363, 
       14.9115}, {-24.8573, 14.9266}, {-24.8531, 14.9372}, {-24.8179, 
       14.9528}, {-24.7802, 14.9545}, {-24.7559, 14.95}, {-24.7559, 
       14.9299}, {-24.7944, 14.9104}, {-24.8363, 14.9115}}, {{-24.8959, 
       14.9132}, {-24.8883, 14.9048}, {-24.895, 14.8947}, {-24.9151, 
       14.8841}, {-24.942, 14.883}, {-24.9629, 14.8886}, {-24.9671, 
       14.9009}, {-24.9503, 14.9137}, {-24.9327, 14.9165}, {-24.8959, 
       14.9132}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"CapeVerde\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnHtQVFUcx5npnwXZhUIC4tWCwBAIFW8QkJaHimsCrpggz0hBCORhxUxF
MFlOkqONVsgUWqMm4x9ZIw02Gcg7YnlMhlBAQjzUJDBsQOD0u97ttrMszQB7
9u7lnt98Yc7dPef3u3zuued1z0Wckh2d8oienp4Uforgh0qHRZ0UmOcRsSXC
n/Dnswh/wp/P0h3+L8ZvsXXeR6ef3xrj4ZvE+inxin9CrHTk28c2Rew8/Ir/
RJ1QZJXD+inxir+ZfeZMiwFqE4AuHndh/XxWH//Q0F1MemPI7jVPHFD+drs0
5l69kOZf95nYzmWvSnEn97R1ri/9e5ir7I270ib/s6Vux9/wFlrlFGaG1J62
Yz6Hmn/m8NM0eUbjtSLoEZSLrxVnDVabSCN3WDlmVJ9yeG1/COv0uMVfFhUF
YG9dNYbf+XtDF2YwFWdNNxtcOOq6mIdLJ5znfxTc+d4IPDi6pbFOj1v8gTlT
vY+97qNvkbswz5VyB+iI1RY3X7e/psKOLg6XCW4E1ulxhb/Jk1lfHHVVaWGu
fmJv7ZSukjM9aRM0Rws9+AfuGagyVS4ON8Khgg1qLyKHpB3+0HWGhe0CFeUE
AbqTRV70obtXskpOlU6ZUfDGOLoIdM3gIU62jT6EvoB1hrrPnxH0oX83rXF5
NnXZHuAGkVdasc6No/xBJXmBKylu6ZiRp67v5qi0z9/QcqUT25V70B3pzvyX
n2rvGqqp79W4Ohs/7Woso9OtDV/daHoHR5RVIITJZv9EciPUH4+G30JyIbpX
gyvQYD6630El5qbQQBp6MIYrEOesL1YxVu+yBTq4otwuR+3GaPQIuu6BbgTj
isI5m/wOddoo+MtF6NYJXIFmRlCbviIQXAVi87NUm9NmoDLbRX270dykhmNB
KwdtDhPiujv6q1nDIThtPRLUYYbmp7E4n/kd9SehnnD0sxcFv9OaSvduRhOX
sYTjot0uo+onbntwB8kN0dgH2ANhsOGMhD4/Z0wakDgNJ9vi889o6vNHf9vs
oIVAGhdW/lrTkMye9XPgM3/uivAn/Pks7fDvD3Ri/S/VTeEaVw29iu6epxL0
FIleosFhgzmKAT9MB36VUWNRYmATVdScqHcr6rJDP7liDARXGQIBeZjo9UZi
DMQtm5ui1j/pZYHBXIyBoMIz6z9jxzAG4pDNjFArD8yyjFyIa3I6PYC6/f8L
1L4W3b2AJRCHbGYU9cdRSzHdvhSTjsepNEjjS6DTN1HfTtX1H9D4RQ0H4qjN
3UftpmgoH3sgLq//tMpv4nu4NtoikzdWauEp3h8/PNfYcI31h4nLkLekFN/D
ZW//RIG5NvanPQzE/sP05Zw5Tv5EusPf0zfRfJ1iY6eRdXZgUPxSPRxMlwgV
L8XkFuwLXR27gLTG38MncaDK1D9wz1PPpLZXWkZvi16qh/K3PVrO2fgEJFR9
5HTllAPr6LjFH9R/2XS62WCiTjTVYGhs8/JSi2+XxjBD/ezUMNbRcYs/tDm1
p8U0vZ5L5mo3mf+PDCwOvJkdzPD/uNgTHLJOjyv8g4Ljur+0UN4OMVRtAvVZ
OU9xblBEeKzg4Rb0I4V+fhsSmK/cPJObztqqbKgAh+CWdYC6zx+qrkTyAr1d
/5evzSbrhOHhsfShch2O3CKbaxUcKgi4dkYMV0ftwFUauQPIZ6ZEsM6NQ/yV
9e7BgHOl69V+BWMb6Broul1W4qE2j8g6G/IsfDWSu9Iyf5goyaKiFn4ON0Jp
oe9sq/5irROjwlXx2iNb/AXqdu9DXwwVvqbCDoaXAB9qOKRBKu+f0lrsBSWO
Sqfmv3BpxmtFHxZ7sX4m/OQPOv/+euiIWT8N3vKHEY6QH/95Qzf5802EP+HP
ZxH+hD+fRfgT/nwW4U/481mEP+HPZxH+hD+fRfgT/nwW4U/481mEP+HPZxH+
hD+fRfgT/nwW4c+uyirqS977hogt/QPccWs0
              "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnHtQVFUcx5npnwXZhUIC4tWCwBAIFW8QkJaHimsCrpggz0hBCORhxUxF
MFlOkqONVsgUWqMm4x9ZIw02Gcg7YnlMhlBAQjzUJDBsQOD0u97ttrMszQB7
9u7lnt98Yc7dPef3u3zuued1z0Wckh2d8oienp4Uforgh0qHRZ0UmOcRsSXC
n/Dnswh/wp/P0h3+L8ZvsXXeR6ef3xrj4ZvE+inxin9CrHTk28c2Rew8/Ir/
RJ1QZJXD+inxir+ZfeZMiwFqE4AuHndh/XxWH//Q0F1MemPI7jVPHFD+drs0
5l69kOZf95nYzmWvSnEn97R1ri/9e5ir7I270ib/s6Vux9/wFlrlFGaG1J62
Yz6Hmn/m8NM0eUbjtSLoEZSLrxVnDVabSCN3WDlmVJ9yeG1/COv0uMVfFhUF
YG9dNYbf+XtDF2YwFWdNNxtcOOq6mIdLJ5znfxTc+d4IPDi6pbFOj1v8gTlT
vY+97qNvkbswz5VyB+iI1RY3X7e/psKOLg6XCW4E1ulxhb/Jk1lfHHVVaWGu
fmJv7ZSukjM9aRM0Rws9+AfuGagyVS4ON8Khgg1qLyKHpB3+0HWGhe0CFeUE
AbqTRV70obtXskpOlU6ZUfDGOLoIdM3gIU62jT6EvoB1hrrPnxH0oX83rXF5
NnXZHuAGkVdasc6No/xBJXmBKylu6ZiRp67v5qi0z9/QcqUT25V70B3pzvyX
n2rvGqqp79W4Ohs/7Woso9OtDV/daHoHR5RVIITJZv9EciPUH4+G30JyIbpX
gyvQYD6630El5qbQQBp6MIYrEOesL1YxVu+yBTq4otwuR+3GaPQIuu6BbgTj
isI5m/wOddoo+MtF6NYJXIFmRlCbviIQXAVi87NUm9NmoDLbRX270dykhmNB
KwdtDhPiujv6q1nDIThtPRLUYYbmp7E4n/kd9SehnnD0sxcFv9OaSvduRhOX
sYTjot0uo+onbntwB8kN0dgH2ANhsOGMhD4/Z0wakDgNJ9vi889o6vNHf9vs
oIVAGhdW/lrTkMye9XPgM3/uivAn/Pks7fDvD3Ri/S/VTeEaVw29iu6epxL0
FIleosFhgzmKAT9MB36VUWNRYmATVdScqHcr6rJDP7liDARXGQIBeZjo9UZi
DMQtm5ui1j/pZYHBXIyBoMIz6z9jxzAG4pDNjFArD8yyjFyIa3I6PYC6/f8L
1L4W3b2AJRCHbGYU9cdRSzHdvhSTjsepNEjjS6DTN1HfTtX1H9D4RQ0H4qjN
3UftpmgoH3sgLq//tMpv4nu4NtoikzdWauEp3h8/PNfYcI31h4nLkLekFN/D
ZW//RIG5NvanPQzE/sP05Zw5Tv5EusPf0zfRfJ1iY6eRdXZgUPxSPRxMlwgV
L8XkFuwLXR27gLTG38MncaDK1D9wz1PPpLZXWkZvi16qh/K3PVrO2fgEJFR9
5HTllAPr6LjFH9R/2XS62WCiTjTVYGhs8/JSi2+XxjBD/ezUMNbRcYs/tDm1
p8U0vZ5L5mo3mf+PDCwOvJkdzPD/uNgTHLJOjyv8g4Ljur+0UN4OMVRtAvVZ
OU9xblBEeKzg4Rb0I4V+fhsSmK/cPJObztqqbKgAh+CWdYC6zx+qrkTyAr1d
/5evzSbrhOHhsfShch2O3CKbaxUcKgi4dkYMV0ftwFUauQPIZ6ZEsM6NQ/yV
9e7BgHOl69V+BWMb6Broul1W4qE2j8g6G/IsfDWSu9Iyf5goyaKiFn4ON0Jp
oe9sq/5irROjwlXx2iNb/AXqdu9DXwwVvqbCDoaXAB9qOKRBKu+f0lrsBSWO
Sqfmv3BpxmtFHxZ7sX4m/OQPOv/+euiIWT8N3vKHEY6QH/95Qzf5802EP+HP
ZxH+hD+fRfgT/nwW4U/481mEP+HPZxH+hD+fRfgT/nwW4U/481mEP+HPZxH+
hD+fRfgT/nwW4c+uyirqS977hogt/QPccWs0
          "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], {
        Style["CapeVerde", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnHtQVFUcx5npnwXZhUIC4tWCwBAIFW8QkJaHimsCrpggz0hBCORhxUxF
MFlOkqONVsgUWqMm4x9ZIw02Gcg7YnlMhlBAQjzUJDBsQOD0u97ttrMszQB7
9u7lnt98Yc7dPef3u3zuued1z0Wckh2d8oienp4Uforgh0qHRZ0UmOcRsSXC
n/Dnswh/wp/P0h3+L8ZvsXXeR6ef3xrj4ZvE+inxin9CrHTk28c2Rew8/Ir/
RJ1QZJXD+inxir+ZfeZMiwFqE4AuHndh/XxWH//Q0F1MemPI7jVPHFD+drs0
5l69kOZf95nYzmWvSnEn97R1ri/9e5ir7I270ib/s6Vux9/wFlrlFGaG1J62
Yz6Hmn/m8NM0eUbjtSLoEZSLrxVnDVabSCN3WDlmVJ9yeG1/COv0uMVfFhUF
YG9dNYbf+XtDF2YwFWdNNxtcOOq6mIdLJ5znfxTc+d4IPDi6pbFOj1v8gTlT
vY+97qNvkbswz5VyB+iI1RY3X7e/psKOLg6XCW4E1ulxhb/Jk1lfHHVVaWGu
fmJv7ZSukjM9aRM0Rws9+AfuGagyVS4ON8Khgg1qLyKHpB3+0HWGhe0CFeUE
AbqTRV70obtXskpOlU6ZUfDGOLoIdM3gIU62jT6EvoB1hrrPnxH0oX83rXF5
NnXZHuAGkVdasc6No/xBJXmBKylu6ZiRp67v5qi0z9/QcqUT25V70B3pzvyX
n2rvGqqp79W4Ohs/7Woso9OtDV/daHoHR5RVIITJZv9EciPUH4+G30JyIbpX
gyvQYD6630El5qbQQBp6MIYrEOesL1YxVu+yBTq4otwuR+3GaPQIuu6BbgTj
isI5m/wOddoo+MtF6NYJXIFmRlCbviIQXAVi87NUm9NmoDLbRX270dykhmNB
KwdtDhPiujv6q1nDIThtPRLUYYbmp7E4n/kd9SehnnD0sxcFv9OaSvduRhOX
sYTjot0uo+onbntwB8kN0dgH2ANhsOGMhD4/Z0wakDgNJ9vi889o6vNHf9vs
oIVAGhdW/lrTkMye9XPgM3/uivAn/Pks7fDvD3Ri/S/VTeEaVw29iu6epxL0
FIleosFhgzmKAT9MB36VUWNRYmATVdScqHcr6rJDP7liDARXGQIBeZjo9UZi
DMQtm5ui1j/pZYHBXIyBoMIz6z9jxzAG4pDNjFArD8yyjFyIa3I6PYC6/f8L
1L4W3b2AJRCHbGYU9cdRSzHdvhSTjsepNEjjS6DTN1HfTtX1H9D4RQ0H4qjN
3UftpmgoH3sgLq//tMpv4nu4NtoikzdWauEp3h8/PNfYcI31h4nLkLekFN/D
ZW//RIG5NvanPQzE/sP05Zw5Tv5EusPf0zfRfJ1iY6eRdXZgUPxSPRxMlwgV
L8XkFuwLXR27gLTG38MncaDK1D9wz1PPpLZXWkZvi16qh/K3PVrO2fgEJFR9
5HTllAPr6LjFH9R/2XS62WCiTjTVYGhs8/JSi2+XxjBD/ezUMNbRcYs/tDm1
p8U0vZ5L5mo3mf+PDCwOvJkdzPD/uNgTHLJOjyv8g4Ljur+0UN4OMVRtAvVZ
OU9xblBEeKzg4Rb0I4V+fhsSmK/cPJObztqqbKgAh+CWdYC6zx+qrkTyAr1d
/5evzSbrhOHhsfShch2O3CKbaxUcKgi4dkYMV0ftwFUauQPIZ6ZEsM6NQ/yV
9e7BgHOl69V+BWMb6Broul1W4qE2j8g6G/IsfDWSu9Iyf5goyaKiFn4ON0Jp
oe9sq/5irROjwlXx2iNb/AXqdu9DXwwVvqbCDoaXAB9qOKRBKu+f0lrsBSWO
Sqfmv3BpxmtFHxZ7sX4m/OQPOv/+euiIWT8N3vKHEY6QH/95Qzf5802EP+HP
ZxH+hD+fRfgT/nwW4U/481mEP+HPZxH+hD+fRfgT/nwW4U/481mEP+HPZxH+
hD+fRfgT/nwW4c+uyirqS977hogt/QPccWs0
        "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}], 
      "CapeVerde"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-81.4212, 19.355}, {-81.4223, 19.3621}, {-81.42, 
       19.3691}, {-81.4106, 19.3738}, {-81.3976, 19.3715}, {-81.3812, 
       19.3589}, {-81.3659, 19.3033}, {-81.3435, 19.2876}, {-81.3224, 
       19.2813}, {-81.3, 19.2852}, {-81.2811, 19.3001}, {-81.2717, 
       19.3331}, {-81.2565, 19.3495}, {-81.1012, 19.3495}, {-81.0541, 
       19.3284}, {-81.0447, 19.3135}, {-81.0577, 19.2915}, {-81.113, 
       19.279}, {-81.1706, 19.2735}, {-81.22, 19.2414}, {-81.2377, 
       19.2398}, {-81.2741, 19.2468}, {-81.3141, 19.2476}, {-81.3706, 
       19.2398}, {-81.3953, 19.2453}, {-81.4082, 19.257}, {-81.4212, 
       19.355}}, {{-79.8588, 19.6607}, {-79.8782, 19.6607}, {-79.8943, 
       19.6652}, {-79.8983, 19.6723}, {-79.8903, 19.6866}, {-79.8181, 
       19.7267}, {-79.7873, 19.7329}, {-79.7619, 19.7311}, {-79.7519, 
       19.7178}, {-79.7639, 19.6999}, {-79.7946, 19.6803}, {-79.8588, 
       19.6607}}, {{-80.0902, 19.659}, {-80.022, 19.6848}, {-79.9966, 
       19.6866}, {-79.9818, 19.6794}, {-79.9845, 19.667}, {-80.0394, 
       19.6411}, {-80.0915, 19.6269}, {-80.1048, 19.6304}, {-80.1089, 
       19.6393}, {-80.1076, 19.6465}, {-80.0902, 19.659}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"CaymanIslands\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXAlczUv7P23CRZa6V/adm+sSQi5JFJW11Hvz9rdFFP/ssqfUTRKikLqW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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXAlczUv7P23CRZa6V/adm+sSQi5JFJW11Hvz9rdFFP/ssqfUTRKikLqW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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["CaymanIslands", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztXAlczUv7P23CRZa6V/adm+sSQi5JFJW11Hvz9rdFFP/ssqfUTRKikLqW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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "CaymanIslands"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{15.5, 7.533333333333333}, {18.583333333333332`, 
      8.033333333333333}, {22.766666666666666`, 10.95}, {22.883333333333333`, 
      10.916666666666666`}, {23.516666666666666`, 8.716666666666667}, {27.45, 
      5.016666666666667}, {22.333333333333332`, 4.133333333333333}, {19.2, 
      4.966666666666667}, {18.633333333333333`, 3.4833333333333334`}, {
      16.583333333333332`, 3.4833333333333334`}, {16.2, 2.216666666666667}, {
      14.416666666666666`, 6.05}, {15.5, 7.533333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"CentralAfricanRepublic\"", "Panel", Background -> None, 
            StripOnInput -> False], "Labeled", Editable -> True, Selectable -> 
           True], Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3EFIU3EcwPG30sZQO8QO7RJIQgcPixAMAxFkBgljGEmeIrtEHkaxix0i
D3YZSgdFCBFPSaCMUZeGMCKCIIQdOgiJ4KEJDT1UjK1wr78Mhth8FG9vv7f9
vz++A/fkz9v/wyZ7Hl7neHRk/LRhGLfU46l6HP5smu4uYpiGjSLSr7/Rwx9/
ncMff53DH3+dwx9/ncMff53DH3+dwx9/ncMff53DH3+dwx9/Jxt4HXRz76+e
teOvlotvwTrjheHmEpdtvf/VcvEtNHT4469z+OOvc/jjr3P4469z+OOvc/jj
r3P4469z+OOvc/jjr3NN75/+mnZz365fs+OvlotvwTrT5ROJ2PE/XM7YGfxl
B3/ZwV928Jcd/GUHf9nBX3bwlx38ZQd/2cFfdvCXHfxlB3/ZwV928Jcd/GUH
f9lpdv/9fVdXvGHLXy0X34J1dt5cdShh2PJXy8W30NDhf7SOju+xWNzjKVX9
rd+fi0af4+9oGxtX1tcHA4HsseOhUCqbDUxOPsPf0aamnpimkcv5w+Fk+YjX
W5idfVgqedTx7u7P+DtaT8+nyr2D5ucfqKeZTLD8dGvrYs1Ph/+x1B//3d3z
VW/lNDPzCP86tLh4r6p/f/87/OvQ9PTjv/EPDk51dX3B39Ha2n4uL9856VZy
e3vnhobe4u9QwWBmc/OS9d381Kegtl9B8S83MTFXKHj/8Z6Ka2sj6koN/1rV
2/sxHo+pb5tLS3dXVm4nk+FUKlQsnqmA7+xcSKcHjrawcN/ny+PvXIlEpOI/
PPzGqbPgf0JjYy/L+OpauKXlN/51rr39Rz7vK18FO3cW/C1aXb2p/Pv6PuAv
0ujoq+3tTkdPgb9F6nKs5v9wxv+/am39hX8T1/T+fwB1SzO3
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3EFIU3EcwPG30sZQO8QO7RJIQgcPixAMAxFkBgljGEmeIrtEHkaxix0i
D3YZSgdFCBFPSaCMUZeGMCKCIIQdOgiJ4KEJDT1UjK1wr78Mhth8FG9vv7f9
vz++A/fkz9v/wyZ7Hl7neHRk/LRhGLfU46l6HP5smu4uYpiGjSLSr7/Rwx9/
ncMff53DH3+dwx9/ncMff53DH3+dwx9/ncMff53DH3+dwx9/Jxt4HXRz76+e
teOvlotvwTrjheHmEpdtvf/VcvEtNHT4469z+OOvc/jjr3P4469z+OOvc/jj
r3P4469z+OOvc/jjr3NN75/+mnZz365fs+OvlotvwTrT5ROJ2PE/XM7YGfxl
B3/ZwV928Jcd/GUHf9nBX3bwlx38ZQd/2cFfdvCXHfxlB3/ZwV928Jcd/GUH
f9lpdv/9fVdXvGHLXy0X34J1dt5cdShh2PJXy8W30NDhf7SOju+xWNzjKVX9
rd+fi0af4+9oGxtX1tcHA4HsseOhUCqbDUxOPsPf0aamnpimkcv5w+Fk+YjX
W5idfVgqedTx7u7P+DtaT8+nyr2D5ucfqKeZTLD8dGvrYs1Ph/+x1B//3d3z
VW/lNDPzCP86tLh4r6p/f/87/OvQ9PTjv/EPDk51dX3B39Ha2n4uL9856VZy
e3vnhobe4u9QwWBmc/OS9d381Kegtl9B8S83MTFXKHj/8Z6Ka2sj6koN/1rV
2/sxHo+pb5tLS3dXVm4nk+FUKlQsnqmA7+xcSKcHjrawcN/ny+PvXIlEpOI/
PPzGqbPgf0JjYy/L+OpauKXlN/51rr39Rz7vK18FO3cW/C1aXb2p/Pv6PuAv
0ujoq+3tTkdPgb9F6nKs5v9wxv+/am39hX8T1/T+fwB1SzO3
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["CentralAfricanRepublic", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3EFIU3EcwPG30sZQO8QO7RJIQgcPixAMAxFkBgljGEmeIrtEHkaxix0i
D3YZSgdFCBFPSaCMUZeGMCKCIIQdOgiJ4KEJDT1UjK1wr78Mhth8FG9vv7f9
vz++A/fkz9v/wyZ7Hl7neHRk/LRhGLfU46l6HP5smu4uYpiGjSLSr7/Rwx9/
ncMff53DH3+dwx9/ncMff53DH3+dwx9/ncMff53DH3+dwx9/Jxt4HXRz76+e
teOvlotvwTrjheHmEpdtvf/VcvEtNHT4469z+OOvc/jjr3P4469z+OOvc/jj
r3P4469z+OOvc/jjr3NN75/+mnZz365fs+OvlotvwTrT5ROJ2PE/XM7YGfxl
B3/ZwV928Jcd/GUHf9nBX3bwlx38ZQd/2cFfdvCXHfxlB3/ZwV928Jcd/GUH
f9lpdv/9fVdXvGHLXy0X34J1dt5cdShh2PJXy8W30NDhf7SOju+xWNzjKVX9
rd+fi0af4+9oGxtX1tcHA4HsseOhUCqbDUxOPsPf0aamnpimkcv5w+Fk+YjX
W5idfVgqedTx7u7P+DtaT8+nyr2D5ucfqKeZTLD8dGvrYs1Ph/+x1B//3d3z
VW/lNDPzCP86tLh4r6p/f/87/OvQ9PTjv/EPDk51dX3B39Ha2n4uL9856VZy
e3vnhobe4u9QwWBmc/OS9d381Kegtl9B8S83MTFXKHj/8Z6Ka2sj6koN/1rV
2/sxHo+pb5tLS3dXVm4nk+FUKlQsnqmA7+xcSKcHjrawcN/ny+PvXIlEpOI/
PPzGqbPgf0JjYy/L+OpauKXlN/51rr39Rz7vK18FO3cW/C1aXb2p/Pv6PuAv
0ujoq+3tTkdPgb9F6nKs5v9wxv+/am39hX8T1/T+fwB1SzO3
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "CentralAfricanRepublic"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{24., 19.5}, {16., 23.5}, {15., 23.}, {16., 20.35}, {
      15.483333333333333`, 16.9}, {13.633333333333333`, 
      13.716666666666667`}, {14.066666666666666`, 13.083333333333334`}, {
      15.683333333333334`, 9.983333333333333}, {13.95, 9.633333333333333}, {
      15.5, 7.533333333333333}, {18.583333333333332`, 8.033333333333333}, {
      22.766666666666666`, 10.95}, {21.833333333333332`, 12.8}, {
      22.933333333333334`, 15.549999999999999`}, {24., 15.7}, {24., 19.5}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Chad\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt0LEJgEAURMEFKzGxIMFfwCWCiS3Y+XliEZcMvIWNZ2333pYkx9gz9v3k
nFjV1XtmVltPJsafP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/P9eFSYn/w==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt0LEJgEAURMEFKzGxIMFfwCWCiS3Y+XliEZcMvIWNZ2333pYkx9gz9v3k
nFjV1XtmVltPJsafP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/P9eFSYn/w==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Chad", "Panel", Background -> None]}, {{Top, Left}}], Editable -> 
      False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt0LEJgEAURMEFKzGxIMFfwCWCiS3Y+XliEZcMvIWNZ2333pYkx9gz9v3k
nFjV1XtmVltPJsafP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz58+fP3/+/Pnz
58+fP3/+/Pnz58+fP3/+/P9eFSYn/w==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Chad"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-70.4, -18.35}, {-71.45, -32.65}, {-73.68333333333334, \
-37.333333333333336`}, {-72.3, -41.38333333333333}, {-72.6, -44.5}, \
{-73.73333333333333, -46.53333333333333}, {-74.16666666666667, -45.8}, \
{-75.7, -46.63333333333333}, {-74.51666666666667, -46.8}, \
{-73.21666666666667, -48.}, {-74.65, -48.016666666666666`}, {-74.7, -50.2}, \
{-73.55, -52.05}, {-72.46666666666667, -51.78333333333333}, {-73.45, -53.}, \
{-71.46666666666667, -52.63333333333333}, {-73.21666666666667, \
-53.233333333333334`}, {-71.11666666666666, -52.85}, {-72.13333333333333, \
-53.38333333333333}, {-68.43333333333334, -52.38333333333333}, \
{-71.93333333333334, -51.983333333333334`}, {-73.58333333333333, \
-49.53333333333333}, {-71.1, -44.53333333333333}, {-72.13333333333333, \
-42.28333333333333}, {-69.81666666666666, -34.233333333333334`}, \
{-70.56666666666666, -31.316666666666666`}, {-68.31666666666666, -27.05}, \
{-67.18333333333334, -22.816666666666666`}, {-69.5, -17.5}, {-70.4, -18.35}}, \
{{-67.05, -55.1}, {-68.36666666666666, -54.949999999999996`}, {-67.05, \
-55.1}}, {{-68.4, -54.96666666666667}, {-68.08333333333333, \
-55.71666666666667}, {-70.03333333333333, -55.166666666666664`}, \
{-68.38333333333333, -54.96666666666667}}, {{-68.63333333333333, \
-54.88333333333333}, {-72.01666666666667, -54.516666666666666`}, {-69., \
-54.46666666666667}, {-70.41666666666667, -52.766666666666666`}, \
{-68.61666666666666, -52.65}, {-68.63333333333333, -54.88333333333333}}, \
{{-73.9, -43.38333333333333}, {-73.5, -41.85}, {-73.9, -43.38333333333333}}}],
     
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Chile\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2N1LU2EAx/FFf0l3/TtpTsdaqHQRCS3L0Uhx0QsKQRTeRDHMXjA3twaB
uMzAXAkpa71QWpQuxbXKVs3F5k7Qk8M1bDs7zzkXz4XfH5/BOGeci69j5+Ce
dndD+26bzdYkXqfF6+/7tb27AAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQbvbw
EYXmPcdyA76dzL5vRKELfbHfO3v0Vzv6qx391Y7+akd/taO/2tFf7eivdvRX
O+OtXC2jQ4PP6n6s/9wU/Y1P6uv6IpGae7rS5rpb9WzbgfCTWHIi+o7+xifV
/7o/rmnap9RPb9f9bad83ZPpdFac7TvL919iUv3dHWPa5vL5Df/VudLBlsZA
KPCquFEUx9fX8057kP7GJ9VfWFn+rm3t8fSSp3N8Yf7LvyOxpNTV6C/b/17k
jVZ7ly/O0F9qsv3P9D6sFb9QKLY6w/SXmmx/R1Mwm81X7Z+Ir8pejf6yxU6e
iGYyv6r2FzeCQ60R+ktNKte1K7PiyUfn9/9zOtvjnaC/8RkM5XKEpqcWdcpX
3gUG/XH6G5yRSsePjiWTGSPxyxMPogcdIfrXXd1EA5dmcrmCVPzSlj9mxB+O
/vrT7+NsHu09Nenr3q7//KPK1B/er/3/GcHbFaW//qTuv5XeLnwt9799I2Hu
IvQ33X/41vNyf3dHnd8Z+tea6f7it70Uf2nxm+mL0N90OvvW/+KCd17S3/Ss
9I+EX4v+ns5x+puelf493gep1R9WrkB/K/WaG0ZuDpl88qF/aVbqCY79Afpb
mcX+FtGf/mpHf7Wjv9rRX+3or3b0Vzv6qx391Y7+avcHJc1rww==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2N1LU2EAx/FFf0l3/TtpTsdaqHQRCS3L0Uhx0QsKQRTeRDHMXjA3twaB
uMzAXAkpa71QWpQuxbXKVs3F5k7Qk8M1bDs7zzkXz4XfH5/BOGeci69j5+Ce
dndD+26bzdYkXqfF6+/7tb27AAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQbvbw
EYXmPcdyA76dzL5vRKELfbHfO3v0Vzv6qx391Y7+akd/taO/2tFf7eivdvRX
O+OtXC2jQ4PP6n6s/9wU/Y1P6uv6IpGae7rS5rpb9WzbgfCTWHIi+o7+xifV
/7o/rmnap9RPb9f9bad83ZPpdFac7TvL919iUv3dHWPa5vL5Df/VudLBlsZA
KPCquFEUx9fX8057kP7GJ9VfWFn+rm3t8fSSp3N8Yf7LvyOxpNTV6C/b/17k
jVZ7ly/O0F9qsv3P9D6sFb9QKLY6w/SXmmx/R1Mwm81X7Z+Ir8pejf6yxU6e
iGYyv6r2FzeCQ60R+ktNKte1K7PiyUfn9/9zOtvjnaC/8RkM5XKEpqcWdcpX
3gUG/XH6G5yRSsePjiWTGSPxyxMPogcdIfrXXd1EA5dmcrmCVPzSlj9mxB+O
/vrT7+NsHu09Nenr3q7//KPK1B/er/3/GcHbFaW//qTuv5XeLnwt9799I2Hu
IvQ33X/41vNyf3dHnd8Z+tea6f7it70Uf2nxm+mL0N90OvvW/+KCd17S3/Ss
9I+EX4v+ns5x+puelf493gep1R9WrkB/K/WaG0ZuDpl88qF/aVbqCY79Afpb
mcX+FtGf/mpHf7Wjv9rRX+3or3b0Vzv6qx391Y7+avcHJc1rww==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Chile", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2N1LU2EAx/FFf0l3/TtpTsdaqHQRCS3L0Uhx0QsKQRTeRDHMXjA3twaB
uMzAXAkpa71QWpQuxbXKVs3F5k7Qk8M1bDs7zzkXz4XfH5/BOGeci69j5+Ce
dndD+26bzdYkXqfF6+/7tb27AAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQbvbw
EYXmPcdyA76dzL5vRKELfbHfO3v0Vzv6qx391Y7+akd/taO/2tFf7eivdvRX
O+OtXC2jQ4PP6n6s/9wU/Y1P6uv6IpGae7rS5rpb9WzbgfCTWHIi+o7+xifV
/7o/rmnap9RPb9f9bad83ZPpdFac7TvL919iUv3dHWPa5vL5Df/VudLBlsZA
KPCquFEUx9fX8057kP7GJ9VfWFn+rm3t8fSSp3N8Yf7LvyOxpNTV6C/b/17k
jVZ7ly/O0F9qsv3P9D6sFb9QKLY6w/SXmmx/R1Mwm81X7Z+Ir8pejf6yxU6e
iGYyv6r2FzeCQ60R+ktNKte1K7PiyUfn9/9zOtvjnaC/8RkM5XKEpqcWdcpX
3gUG/XH6G5yRSsePjiWTGSPxyxMPogcdIfrXXd1EA5dmcrmCVPzSlj9mxB+O
/vrT7+NsHu09Nenr3q7//KPK1B/er/3/GcHbFaW//qTuv5XeLnwt9799I2Hu
IvQ33X/41vNyf3dHnd8Z+tea6f7it70Uf2nxm+mL0N90OvvW/+KCd17S3/Ss
9I+EX4v+ns5x+puelf493gep1R9WrkB/K/WaG0ZuDpl88qF/aVbqCY79Afpb
mcX+FtGf/mpHf7Wjv9rRX+3or3b0Vzv6qx391Y7+avcHJc1rww==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Chile"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxNVEtoE1EUDQWVgpuuVFxZxJW6aSejTVpfkvm1gtDMx0lm3mRMsUIFBSvG
+gERkQoiKCjU4koX4mclIhIXIuJKXQgiLipS8LuouBCRojgv5xg8EC533r3n
nnvve9nQPFjd25PL5cazn7IthTUN8eJ5htWGeNTOsDOBjSpiVuFoInIdGKIT
30rEu4UMJ+n/lPB/V0S/wiEpDIWNFfC0JfjvlGkTMaBwr4z4VxJ1ZktiTmGG
9ds7wP+J+ZtFVw/qjiC+l3wDI+RJwLs4DJ71jNcLYlLhmYTdNMR+qf+ajrxL
MfQbefDXYnFV2XU66kzE4ttShq151PscIf6MBt4rEc4PaOL2rQzHItQpDOL8
SAQ9DwbR1wmeH9eQ96eO7+c1xK2KUHdaE30Ke+qsr7PfGngn89A5WkPcRQ3+
w5D6t6G/Zoj8JR193w1hF7Yj7lyIuP4ieIOQ8ysKX2EF/dYw4r8E6P9pAffk
VID640X0P/TPLyC+N2C9Ar6XvO7+OudzLucvwPfexbkr2I+LeS0L3luP8yoh
77CLvMf0b1S5nzLzq9x3mXqr6HOlAT19Hn2T94z1py3yeZyvhTk98aBn3obd
77MPG/N67VOfA/+HD3vZoZ4Adsbm+wiw15sWvr/dzX1Y+L6W+5Jm1+/0kZrY
664652vwfvD+uCbfaURek+86pj4L9/2XhD6f/cxLxlH/hxj9f7fBt0Viz18d
1H8pobdnlJbvsTkGezoBz/0xzHdfA/M+y/NF+h9Zz0/5nhzEN1Lqt+G/STkf
B3qvM/6CBZ4khb4pi3NIwatxv//9//0FBz4vIw==
       "], {{109.56666666666666`, 19.983333333333334`}, {110.95, 
       19.966666666666665`}, {110.53333333333333`, 18.78333333333333}, {
       108.68333333333334`, 18.5}, {109.58333333333333`, 
       19.983333333333334`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"China\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztndtLFHEUx0/aPeh/6G/wsnnJyi5WthhBBb4EUg+lJBUhvoRCZSAl1Ev0
YFFYFkFFj/VU0IWiKxIUlGW9JNE9sNJv0xlmGUt3h9lxz0znwGeXYXaYPeez
zO93fmdn2QVNreubiolog/PocB5/tlEzH2XFk1CUjdJp2SghIxDV8+Rj0Iz5
l6VqrnwMmjH/5l8z5t/8a8b8m3/NmH9ZKufIx6AZ82/+NWP+zb9mzL/510zF
bPkYNGP+zb9mzL/514z5N/+aMf/C/mfJx6AZ82/+NWP+zb9mzL/514z5l2Xh
TJn3XSSdeEwopP80IcUb6whnpBOPCYX0X00YJJwgfDT/Ev4ddhPADBAapHOP
A4X07ww+Nzz/XwjXCWuk0xenkP67CKcJ+wmjhF3SiccEkfrnPGGTdOIxQcR/
JaFKOvGYkJohH4NmzL/514z5N/+aiZv/JsIyNzDCHulgFPpfy0vjvYQhQpt0
MAr9Owxzg2JUxxqhfLp8DBnqCPe8BpHDCwXL5Fj5byRsI3Sw/JOEVkKLdEiq
/Gd4SaiRjkGz/83SAcTNf2fgE67SZK9g/q8QbhJW5jrMGbo/eQW8EaH/nTwn
vuc5ccIDagnX+Jjb0hkli4D+KwnfWO8YoZ9QMf7V7YR3XtG4TzqjZFFWHPTI
q77K/DlhI+90Pog+/lDc/T9t8Jky/+0+/w4/CN2Et+N33pFOJ3EE9+8U5CPj
bf/LgUhjc+aUZmk/8fFf4rt7ZEJ+EVZEGttBwkVpP7Hy35nV/92IQkoRThHO
cQv0A6GXcJywVFqUuP9ywqWs/p9FN/k28BTvnnZ48qL3PyCg/zThca7B310g
RDVid3vnPCutaGr9F+U+pp2/E8kpH17fvpcvljwDu8X3y7XxhSBuScp/NeFy
YPN+7hNW5xFVKRc/7nYdYYm0JRH/jdwHDiHfxZk6d0hnF38m87+FL/xBwivC
a2aIeeN9P+hnhNtun3mYcvjKzYrv/HzMeQvpHONMkPH/L2q5z+D3f0g6i+QS
wn8J9xky8scI9dJZJJdw/rt8/p9Ip5Bowvmv4zrT9d8jnUKiCf1faQ+8wScd
XTAKZ+rQ/g+z/4HoIunx1fx6CO0/zf6P5h3AEb7PcyvXVNG2TxNBPv/V+DSK
35DW80rNnUr6CMulhSTIf1RtyQu+JXM/YbG0k6T4j4QWXj4/Yv8RTuVJQdx/
M5c9KcJDlb+IF/efYRkvK8TDMAzDMIyp5zfU6KJJ
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztndtLFHEUx0/aPeh/6G/wsnnJyi5WthhBBb4EUg+lJBUhvoRCZSAl1Ev0
YFFYFkFFj/VU0IWiKxIUlGW9JNE9sNJv0xlmGUt3h9lxz0znwGeXYXaYPeez
zO93fmdn2QVNreubiolog/PocB5/tlEzH2XFk1CUjdJp2SghIxDV8+Rj0Iz5
l6VqrnwMmjH/5l8z5t/8a8b8m3/NmH9ZKufIx6AZ82/+NWP+zb9mzL/510zF
bPkYNGP+zb9mzL/514z5N/+aMf/C/mfJx6AZ82/+NWP+zb9mzL/514z5l2Xh
TJn3XSSdeEwopP80IcUb6whnpBOPCYX0X00YJJwgfDT/Ev4ddhPADBAapHOP
A4X07ww+Nzz/XwjXCWuk0xenkP67CKcJ+wmjhF3SiccEkfrnPGGTdOIxQcR/
JaFKOvGYkJohH4NmzL/514z5N/+aiZv/JsIyNzDCHulgFPpfy0vjvYQhQpt0
MAr9Owxzg2JUxxqhfLp8DBnqCPe8BpHDCwXL5Fj5byRsI3Sw/JOEVkKLdEiq
/Gd4SaiRjkGz/83SAcTNf2fgE67SZK9g/q8QbhJW5jrMGbo/eQW8EaH/nTwn
vuc5ccIDagnX+Jjb0hkli4D+KwnfWO8YoZ9QMf7V7YR3XtG4TzqjZFFWHPTI
q77K/DlhI+90Pog+/lDc/T9t8Jky/+0+/w4/CN2Et+N33pFOJ3EE9+8U5CPj
bf/LgUhjc+aUZmk/8fFf4rt7ZEJ+EVZEGttBwkVpP7Hy35nV/92IQkoRThHO
cQv0A6GXcJywVFqUuP9ywqWs/p9FN/k28BTvnnZ48qL3PyCg/zThca7B310g
RDVid3vnPCutaGr9F+U+pp2/E8kpH17fvpcvljwDu8X3y7XxhSBuScp/NeFy
YPN+7hNW5xFVKRc/7nYdYYm0JRH/jdwHDiHfxZk6d0hnF38m87+FL/xBwivC
a2aIeeN9P+hnhNtun3mYcvjKzYrv/HzMeQvpHONMkPH/L2q5z+D3f0g6i+QS
wn8J9xky8scI9dJZJJdw/rt8/p9Ip5Bowvmv4zrT9d8jnUKiCf1faQ+8wScd
XTAKZ+rQ/g+z/4HoIunx1fx6CO0/zf6P5h3AEb7PcyvXVNG2TxNBPv/V+DSK
35DW80rNnUr6CMulhSTIf1RtyQu+JXM/YbG0k6T4j4QWXj4/Yv8RTuVJQdx/
M5c9KcJDlb+IF/efYRkvK8TDMAzDMIyp5zfU6KJJ
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["China", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztndtLFHEUx0/aPeh/6G/wsnnJyi5WthhBBb4EUg+lJBUhvoRCZSAl1Ev0
YFFYFkFFj/VU0IWiKxIUlGW9JNE9sNJv0xlmGUt3h9lxz0znwGeXYXaYPeez
zO93fmdn2QVNreubiolog/PocB5/tlEzH2XFk1CUjdJp2SghIxDV8+Rj0Iz5
l6VqrnwMmjH/5l8z5t/8a8b8m3/NmH9ZKufIx6AZ82/+NWP+zb9mzL/510zF
bPkYNGP+zb9mzL/514z5N/+aMf/C/mfJx6AZ82/+NWP+zb9mzL/514z5l2Xh
TJn3XSSdeEwopP80IcUb6whnpBOPCYX0X00YJJwgfDT/Ev4ddhPADBAapHOP
A4X07ww+Nzz/XwjXCWuk0xenkP67CKcJ+wmjhF3SiccEkfrnPGGTdOIxQcR/
JaFKOvGYkJohH4NmzL/514z5N/+aiZv/JsIyNzDCHulgFPpfy0vjvYQhQpt0
MAr9Owxzg2JUxxqhfLp8DBnqCPe8BpHDCwXL5Fj5byRsI3Sw/JOEVkKLdEiq
/Gd4SaiRjkGz/83SAcTNf2fgE67SZK9g/q8QbhJW5jrMGbo/eQW8EaH/nTwn
vuc5ccIDagnX+Jjb0hkli4D+KwnfWO8YoZ9QMf7V7YR3XtG4TzqjZFFWHPTI
q77K/DlhI+90Pog+/lDc/T9t8Jky/+0+/w4/CN2Et+N33pFOJ3EE9+8U5CPj
bf/LgUhjc+aUZmk/8fFf4rt7ZEJ+EVZEGttBwkVpP7Hy35nV/92IQkoRThHO
cQv0A6GXcJywVFqUuP9ywqWs/p9FN/k28BTvnnZ48qL3PyCg/zThca7B310g
RDVid3vnPCutaGr9F+U+pp2/E8kpH17fvpcvljwDu8X3y7XxhSBuScp/NeFy
YPN+7hNW5xFVKRc/7nYdYYm0JRH/jdwHDiHfxZk6d0hnF38m87+FL/xBwivC
a2aIeeN9P+hnhNtun3mYcvjKzYrv/HzMeQvpHONMkPH/L2q5z+D3f0g6i+QS
wn8J9xky8scI9dJZJJdw/rt8/p9Ip5Bowvmv4zrT9d8jnUKiCf1faQ+8wScd
XTAKZ+rQ/g+z/4HoIunx1fx6CO0/zf6P5h3AEb7PcyvXVNG2TxNBPv/V+DSK
35DW80rNnUr6CMulhSTIf1RtyQu+JXM/YbG0k6T4j4QWXj4/Yv8RTuVJQdx/
M5c9KcJDlb+IF/efYRkvK8TDMAzDMIyp5zfU6KJJ
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "China"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{105.682, -10.3815}, {105.659, -10.3823}, {
      105.638, -10.3773}, {105.62, -10.3699}, {105.619, -10.3637}, {
      105.633, -10.355}, {105.667, -10.3517}, {105.681, -10.3563}, {
      105.689, -10.3662}, {105.691, -10.3769}, {105.682, -10.3815}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"ChristmasIsland\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztm3lQE1ccx2lta+35R+0xivWgVsXqqCOVze4mGypWndZ7vNB61KOtFo/x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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztm3lQE1ccx2lta+35R+0xivWgVsXqqCOVze4mGypWndZ7vNB61KOtFo/x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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["ChristmasIsland", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztm3lQE1ccx2lta+35R+0xivWgVsXqqCOVze4mGypWndZ7vNB61KOtFo/x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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "ChristmasIsland"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{95.312, -12.2373}, {95.3064, -12.2485}, {
      95.2891, -12.2493}, {95.2729, -12.2419}, {95.2723, -12.2311}, {
      95.2872, -12.2225}, {95.2959, -12.2221}, {95.3094, -12.2291}, {
      95.312, -12.2373}}, {{96.8046, -11.7525}, {96.8062, -11.7608}, {
      96.7955, -11.7672}, {96.7821, -11.7633}, {96.7729, -11.7536}, {
      96.7767, -11.7447}, {96.7891, -11.7422}, {96.8003, -11.745}, {
      96.8046, -11.7525}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"CocosKeelingIslands\"", "Panel", Background -> None, 
            StripOnInput -> False], "Labeled", Editable -> True, Selectable -> 
           True], Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnGlsFVUUgE8F16CIVuMWFeNGRKNGDCoSlR9EIxiIohgTFRWMaHBBQzVq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              "], {{0, 0}, {120, 60}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {120, 60}, PlotRange -> {{0, 120}, {0, 60}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnGlsFVUUgE8F16CIVuMWFeNGRKNGDCoSlR9EIxiIohgTFRWMaHBBQzVq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          "], {{0, 0}, {120, 60}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {120, 60}, PlotRange -> {{0, 120}, {0, 60}}]], {
        Style["CocosKeelingIslands", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnGlsFVUUgE8F16CIVuMWFeNGRKNGDCoSlR9EIxiIohgTFRWMaHBBQzVq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        "], {{0, 0}, {120, 60}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {120, 60}, PlotRange -> {{0, 120}, {0, 60}}], 
      "CocosKeelingIslands"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-71.31666666666666, 11.85}, {-74.86666666666666, 
      11.133333333333333`}, {-76.75, 7.916666666666667}, {-77.36666666666666, 
      8.666666666666666}, {-77.88333333333333, 
      7.233333333333333}, {-77.03333333333333, 
      3.9166666666666665`}, {-78.81666666666666, 
      1.4333333333333333`}, {-75.28333333333333, -0.1}, {-72.93333333333334, \
-2.433333333333333}, {-70.1, -2.6333333333333333`}, {-70.71666666666667, \
-3.783333333333333}, {-69.95, -4.216666666666667}, {-70.05, 
      0.5833333333333334}, {-69.11666666666666, 0.65}, {-69.85, 
      1.7166666666666666`}, {-66.86666666666666, 
      1.2166666666666666`}, {-67.85, 2.783333333333333}, {-67.45, 6.2}, {-72.,
       7.016666666666667}, {-73.38333333333333, 
      9.183333333333334}, {-71.31666666666666, 11.85}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Colombia\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt0E0uQ2EYhuHTH1OHpBhbAooNIDGV2EAXoGUBeoqZnwVaQXdRNREzyZHT
b/BcyfUm7/DJfTiZ3kwGVVXdrq9Z3/f/We0AAAAAAAAAAP90vn3321ndxmk9
bWFcz9o5aeW4vt+ko/rhT+PdaTX6oJThwWvxDcn0L2uw/1Z8QzL99U+mv/7J
9Nc/WX9Pf/1z6a9/Mv31T9YbvRffkEx//ZPpX7x/M79uHq86sph36Km57M5z
l14WFz9Wy63VsqIc/fVPpr/+yfTXP9mw9IBw+uufTH/9k+mvfzL9yxqUHhBO
f/2T6a9/Mv31T9YvPSCc/von01//ZPrrn0z/snqlB4TTX/9k+uufTH/9k+kP
AJv2BUbs4so=
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt0E0uQ2EYhuHTH1OHpBhbAooNIDGV2EAXoGUBeoqZnwVaQXdRNREzyZHT
b/BcyfUm7/DJfTiZ3kwGVVXdrq9Z3/f/We0AAAAAAAAAAP90vn3321ndxmk9
bWFcz9o5aeW4vt+ko/rhT+PdaTX6oJThwWvxDcn0L2uw/1Z8QzL99U+mv/7J
9Nc/WX9Pf/1z6a9/Mv31T9YbvRffkEx//ZPpX7x/M79uHq86sph36Km57M5z
l14WFz9Wy63VsqIc/fVPpr/+yfTXP9mw9IBw+uufTH/9k+mvfzL9yxqUHhBO
f/2T6a9/Mv31T9YvPSCc/von01//ZPrrn0z/snqlB4TTX/9k+uufTH/9k+kP
AJv2BUbs4so=
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Colombia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt0E0uQ2EYhuHTH1OHpBhbAooNIDGV2EAXoGUBeoqZnwVaQXdRNREzyZHT
b/BcyfUm7/DJfTiZ3kwGVVXdrq9Z3/f/We0AAAAAAAAAAP90vn3321ndxmk9
bWFcz9o5aeW4vt+ko/rhT+PdaTX6oJThwWvxDcn0L2uw/1Z8QzL99U+mv/7J
9Nc/WX9Pf/1z6a9/Mv31T9YbvRffkEx//ZPpX7x/M79uHq86sph36Km57M5z
l14WFz9Wy63VsqIc/fVPpr/+yfTXP9mw9IBw+uufTH/9k+mvfzL9yxqUHhBO
f/2T6a9/Mv31T9YvPSCc/von01//ZPrrn0z/snqlB4TTX/9k+uufTH/9k+kP
AJv2BUbs4so=
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Colombia"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{43.1657, -11.492}, {43.1641, -11.4544}, {
       43.15, -11.4126}, {43.1312, -11.3666}, {43.1328, -11.3457}, {
       43.1532, -11.3237}, {43.1767, -11.3164}, {43.2033, -11.3175}, {
       43.2519, -11.3279}, {43.2849, -11.3237}, {43.299, -11.3279}, {
       43.3209, -11.3436}, {43.3257, -11.3708}, {43.3257, -11.3885}, {
       43.3476, -11.4147}, {43.3492, -11.4377}, {43.346, -11.4764}, {
       43.3539, -11.4983}, {43.3711, -11.5297}, {43.3664, -11.6123}, {
       43.3507, -11.6499}, {43.3476, -11.7001}, {43.3625, -11.7362}, {
       43.3782, -11.7592}, {43.4362, -11.8261}, {43.4566, -11.8648}, {
       43.4566, -11.8846}, {43.4441, -11.8961}, {43.397, -11.8993}, {
       43.3484, -11.9014}, {43.3296, -11.8972}, {43.3155, -11.8815}, {
       43.2903, -11.8522}, {43.2715, -11.848}, {43.2339, -11.8501}, {
       43.2135, -11.8533}, {43.1979, -11.8491}, {43.1273, -11.7843}, {
       43.121, -11.754}, {43.1367, -11.7027}, {43.1696, -11.639}, {
       43.1728, -11.5971}, {43.1602, -11.5229}, {43.1657, -11.492}}, {{
       44.2542, -12.2694}, {44.1961, -12.2422}, {44.1899, -12.2296}, {
       44.1961, -12.2181}, {44.2149, -12.2181}, {44.2589, -12.2223}, {
       44.3043, -12.2056}, {44.331, -12.1784}, {44.3326, -12.1314}, {
       44.3514, -12.1219}, {44.378, -12.1219}, {44.4078, -12.1314}, {
       44.4502, -12.1774}, {44.4815, -12.2296}, {44.527, -12.2714}, {
       44.527, -12.2903}, {44.5098, -12.3321}, {44.4894, -12.3519}, {
       44.4643, -12.3582}, {44.4251, -12.354}, {44.3937, -12.3363}, {
       44.3765, -12.3154}, {44.2867, -12.2759}, {44.2542, -12.2694}}, {{
       43.7139, -12.3614}, {43.6637, -12.3174}, {43.6355, -12.2871}, {
       43.6386, -12.2652}, {43.6606, -12.2495}, {43.6794, -12.2453}, {
       43.7154, -12.2516}, {43.844, -12.307}, {43.8895, -12.3446}, {
       43.9115, -12.3854}, {43.9115, -12.4021}, {43.8911, -12.4053}, {
       43.8331, -12.3938}, {43.728, -12.3676}, {43.7139, -12.3614}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Comoros\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmmlQU1cUx5lR237v9rkFFWVxKkWJWhBaBBfEkaoFZBFEQS1qEYtjW0FZ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              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmmlQU1cUx5lR237v9rkFFWVxKkWJWhBaBBfEkaoFZBFEQS1qEYtjW0FZ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          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Comoros", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmmlQU1cUx5lR237v9rkFFWVxKkWJWhBaBBfEkaoFZBFEQS1qEYtjW0FZ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        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Comoros"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-165.643, -10.8159}, {-165.627, -10.8167}, {-165.617, \
-10.8237}, {-165.614, -10.8344}, {-165.62, -10.8555}, {-165.639, -10.8749}, \
{-165.66, -10.8797}, {-165.676, -10.8727}, {-165.679, -10.8603}, {-165.678, \
-10.8468}, {-165.664, -10.8264}, {-165.643, -10.8159}}, {{-165.628, \
-10.9215}, {-165.614, -10.9272}, {-165.612, -10.9331}, {-165.622, -10.9492}, \
{-165.643, -10.9676}, {-165.66, -10.9703}, {-165.677, -10.9692}, {-165.688, \
-10.9638}, {-165.693, -10.9573}, {-165.69, -10.9525}, {-165.678, -10.9471}, \
{-165.669, -10.9352}, {-165.651, -10.9228}, {-165.628, -10.9215}}, \
{{-165.731, -10.944}, {-165.734, -10.9448}, {-165.737, -10.9454}, {-165.74, \
-10.9457}, {-165.744, -10.9458}, {-165.747, -10.9457}, {-165.75, -10.9454}, \
{-165.753, -10.9448}, {-165.756, -10.944}, {-165.759, -10.9431}, {-165.762, \
-10.9419}, {-165.765, -10.9405}, {-165.767, -10.9389}, {-165.769, -10.9373}, \
{-165.771, -10.9354}, {-165.772, -10.9335}, {-165.773, -10.9314}, {-165.774, \
-10.9293}, {-165.775, -10.9272}, {-165.775, -10.925}, {-165.775, -10.9228}, \
{-165.774, -10.9207}, {-165.773, -10.9186}, {-165.772, -10.9165}, {-165.771, \
-10.9146}, {-165.769, -10.9127}, {-165.767, -10.9111}, {-165.765, -10.9095}, \
{-165.762, -10.9081}, {-165.759, -10.9069}, {-165.756, -10.906}, {-165.753, \
-10.9052}, {-165.75, -10.9046}, {-165.747, -10.9043}, {-165.744, -10.9042}, \
{-165.74, -10.9043}, {-165.737, -10.9046}, {-165.734, -10.9052}, {-165.731, \
-10.906}, {-165.728, -10.9069}, {-165.725, -10.9081}, {-165.723, -10.9095}, \
{-165.72, -10.9111}, {-165.718, -10.9127}, {-165.717, -10.9146}, {-165.715, \
-10.9165}, {-165.714, -10.9186}, {-165.713, -10.9207}, {-165.713, -10.9228}, \
{-165.712, -10.925}, {-165.713, -10.9272}, {-165.713, -10.9293}, {-165.714, \
-10.9314}, {-165.715, -10.9335}, {-165.717, -10.9354}, {-165.718, -10.9373}, \
{-165.72, -10.9389}, {-165.723, -10.9405}, {-165.725, -10.9419}, {-165.728, \
-10.9431}, {-165.731, -10.944}}, {{-165.387, -11.6488}, {-165.39, -11.6495}, \
{-165.393, -11.65}, {-165.395, -11.6503}, {-165.398, -11.6504}, {-165.401, \
-11.6503}, {-165.404, -11.65}, {-165.407, -11.6495}, {-165.41, -11.6488}, \
{-165.413, -11.6479}, {-165.415, -11.6468}, {-165.417, -11.6456}, {-165.419, \
-11.6442}, {-165.421, -11.6426}, {-165.423, -11.641}, {-165.424, -11.6392}, \
{-165.425, -11.6374}, {-165.426, -11.6355}, {-165.426, -11.6336}, {-165.427, \
-11.6316}, {-165.426, -11.6296}, {-165.426, -11.6277}, {-165.425, -11.6258}, \
{-165.424, -11.624}, {-165.423, -11.6222}, {-165.421, -11.6206}, {-165.419, \
-11.619}, {-165.417, -11.6176}, {-165.415, -11.6164}, {-165.413, -11.6153}, \
{-165.41, -11.6144}, {-165.407, -11.6137}, {-165.404, -11.6132}, {-165.401, \
-11.6129}, {-165.398, -11.6128}, {-165.395, -11.6129}, {-165.393, -11.6132}, \
{-165.39, -11.6137}, {-165.387, -11.6144}, {-165.384, -11.6153}, {-165.382, \
-11.6164}, {-165.38, -11.6176}, {-165.377, -11.619}, {-165.376, -11.6206}, \
{-165.374, -11.6222}, {-165.373, -11.624}, {-165.372, -11.6258}, {-165.371, \
-11.6277}, {-165.37, -11.6296}, {-165.37, -11.6316}, {-165.37, -11.6336}, \
{-165.371, -11.6355}, {-165.372, -11.6374}, {-165.373, -11.6392}, {-165.374, \
-11.641}, {-165.376, -11.6426}, {-165.377, -11.6442}, {-165.38, -11.6456}, \
{-165.382, -11.6468}, {-165.384, -11.6479}, {-165.387, -11.6488}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"CookIslands\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXAlQFEcXXhUBgyYm5jKHljGm4oFHEIlVhHB4RkUkaExpLIOKyKXwe+BR
KhqPCOofgyIQYxQlKAISEQTCL4ccIpfgorsge4gGUVRYREBx/w8Ge4dZXRbY
nSHK1MfW7ExPv9ff6+l+r/stg+yX29r34PF45vjbjL/Gcx7PoQtd6EIXutCF
LnSBW8yff0h1gX793GfO3M+5ni8l9PWdqqoeffjhahVlwsNz1q+P4FzVlxLD
h2+Sy+XHj18cONDzu+8CVq4M1dFxxHWch4Vlr1p1auPGSBTYvTuOc1VfMvTq
5Wxqumv//vPyZ8fTp0/t7A5Sd2GF5GQhuZWRUfLVV7t69FjKudr/dixdGoTP
YcM2Xbokkrc8GINM//6rZLJH9AK3b1fivWBU+N57/+G8UZ0Z33yzz8Pj5Guv
ueD855/PoVeTW9On/yoQlBF6Z8/2pz84Zcov5FZFRfXq1afef38lrtvYHLC2
9qXKWFntOXPmMudt7Mzo2XOZVFpRXl4FosCkv38S/W5w8EVcjIjIvXtXJhSW
oTB1HaNTScmdsrLKkJBMFEhLKyaPDBjg2dDQEBvLX7s2/PHjJ7Ap523s5HB1
/ZP0ZPDZu7cruZWSUrR9ezRODAxcVqw4QTq2ubnPjBm+1Fy8Z098bq6UXiHI
JxW26r6+4sCkeeLEJfowfueOzNMznLICTKNODfv2JZCveDXi4wtJbZgjHByC
OG9m50T37kuDgtLp5MMWbm4hxsbbyFCjDnR1mwu//bZHevp1eoUIH0SiO1u3
RnV5RwyA4aFDN86Z4z969JZ33vGA94JZoIN12tr6LV58dNasA3v3xoP8Q4cu
kFvdujlQ41UXAD09p3XrWviTa9aExcQUaKr+t95aUVNT9/33geQK5mUXl2DO
G95JAD8fAwX9Sp8+rghvNSgiICAZrxX5Cn8VM0vfvss5bztXABuGhl4ffLAK
zgy8R/RPxpjcpjG/Vbz7bovIy939BDUiLVjw+4YNp7/91o9zQliGvr7T338X
0idHDDje3rFLlhzVXpQ6YcIejGygHbMwkYuwjmGdVwSIcxMTBXQTlJbemzuX
uWigQcCygYEpiMjo/u1HH6laUH25YWKyg1CRkHCVHm1pD3CxEAtTQnHy6afr
OeeBK2AooNbK8BkVlc+OULhDEAf/FvFFbW394cOpnPPACTDqFhXdnjfvN7ji
fn6JGIfZkTt27DbM+EOGbOA1xWjLl4ew8951Ngwc6EktdVLw9AxnJywdOdKL
Wh19lUGPhjgH3kFExJyrwSbCwrIXLjzMuRrA66+7YQL6+OM1nGvCJqKjC+7f
fzhs2KY5c/yDgtLNzX3YlK6n5/TDD4fMzLz791+1c2cMpuNJk/7LOSesYdy4
7Zh5ied58GCStiUqY/Zsf3ogcPJkFqIzvAuck6NVzJ9/qKCglB5zIRTt1cuZ
E2UcHILkLQ+x+C6swDlL2oOu7jIMOHFx/KdPn1JNrq9/YmjoxYkycISIGhUV
1YsWHSF7By89cnOlVH+TN+3YcuJ+UPvF//zzAJ9XrtxULlB1/vw1M7MsHq8R
OjqihQtri4uzsyXTpv3aDnE2Ngcg6GFubnOFNOAibqFAO6qFMlCJ8SJXJSVd
MzdXzX9sLL9796XUUvwXX/zEMvmffbbhwoWimTP3Qwdf3//BGVAuQ7WlMiHh
mqmpwgr29rUlJenp1ydO3Mst/1CAscGHQ5aSIrC0pKpV8WxkZF6/fu4sc05H
nz6KmBdvn79/koGBC6MMvV2VcXFXx49XWGHRolqRKClJACeKff4hFKKZzKel
CSZOJHWq7v+dLQKFCZR3HJTb+ODcuasmJlQDs3v2FC9ZUisWx8cXfvnlDnb4
hyB6RgF1VGdkCCdPJrUJLCyqEhOhvPrNZ38F3sRkB5x/8hVuz3NXgfCOZ2SU
MK0QHV1obKywgoNDnURy9my+6lG0g/yjcohgMp+ZKZw6VcG8pSVGfijc6ti4
fXs0yWFzdf2TSuxhE4MGrb17VzZ3bgB8Hh+fuPz8UhWFZ8zwpRyGFlaIiio0
Mmq2gq6u2NGxTioND895kTvXbv5RIaplMp+VVTRtmoJ5K6uq5GQoCVXVaf7X
X3vLm6IeKqvW1paDHUCqY5eVNa5+t5oahwHKzu4gn3+TwcP9yEj+mDHECpJl
y2qlUnhWn3++seP8oxJURZxk6niYk1Nkba1gfsIEzLlQDOqp70aipFRaQepU
ndWvJRw5kkYUWLHihDqPwFmaN+83evDebIWICP6oUc1W0NOTODvXSKSof/Bg
xeZOm/jHg3j8yZMGupSHeXnFNjYK5idOlMGHa1rDh2JtajvmX6FQkU8LK7Pp
DunpOdHJx9HQ0MDIgVEBHR1HBGtU8EIO9NJ7YWF8Q0OFFVxcYIXAwBT42Orz
j8J4hOzQUUdNfn6xrW1Wt25UeeGkSbLUVCgANdqRyDRkyIaSkjvylgfioOnT
2xPXtBU9eizduTMGoRWAKQCiJZIK6quj4zH168HE4eR0/ObN+0wrhIZeGTGi
2Qr6+lI3t2qxFCHGjz/+oZp/FECxurrHLZgvKCi2s1MwP3ky/EwIhej2ResY
eRYs+B2yrK19T59ulOvtHUvloujrO7HAPx2rV5+CArNmPX/iMzf3aRXwNDCF
IXxjWKEiJAS9FE44IJwyBQMURawK/uvrW/T5hrq6cj8/OJNUJbCCLD0dgiAO
QtXRrdXmw6eCoNGjt7BGOCO5BcMgWvSiBUC5Fg4V/Gv8UIeQiIhcMnfg1WD8
sELjOHYsg54Ix2va/HpR4arz5zWOO4GByvzjojZkqUMIPfKaOvWX2Fi+VvkX
CMoCApLVLKxM1L8L6rQRbg9GfuockXVlZU1bXSn1gZkXYyxcHUxzkZF5qanF
VBbEq8w/5tyYmILq6trLl29Qo9ZPP52dOXP/0KEb4SVqhPbevV3d3U+cOpV9
69YDMjZCYquLNpwTyAL/xASMuSM0NEuDe+IjR3qhQnog6eYW0upTnBPIDv+8
poiAMINeSt8EHDt2W0eYpy+00jccETh28U/g5XVG/iwRkc9vsRV16ZKo3Smy
eBDdnnx1cQlG/Xv3xmMKrq2tx3TfxT+vaVosLLyFUAgDPj6fPGmg58WVlt6L
i+PDNR040BNBn5FRKztliClMTXfBpUe1SUkCmI/c2ro1CuRT5/37r2o1B+xV
8D95TS4QPSxydg4mMyO8U3hE8qY0CXnTj39JsXXrIojv+skn66gfywN9+y5H
Yfg51CoZPa0UdmnTRrOGw6Gmo7PFX8+FgYGLh8fJ9PTr9BQdsEr/xdD69REY
r6ytfRcvPiqTPbK3/4PcGjduO30VJTdXumVLlLHxtrbu8qsT4wNQNT+/VJae
XmxnR60VCCwsyv38Gurq2sQ/3IP7ERHCKVOaVy0mTaoICWEsPkMQxKmpWLv5
B958cwWG65wcxc6+UFhGXyAyNPSiK0aCCF7TKjH0JLcePaoPDr5oZbVH41kW
qDMlpUiWlqbY/uvWDVaoKWC6c5mZIvQB1fyjAIrV37oldXPL1tenbl0ZMeJe
aCjDChAK0Zpti+pBALMAPnfsiCHXBwzwBLHU3YqKarqfA9+SqIpXQxu/s7O0
3J2cLJSlpqKXKpi3ta3JZ24RglIqX0XN9WcUxiN1N29KXFyy9fSoAnxDw3th
YQwrQAGowQL/fn6J6LpmZt6BgSlUxDp3bgBjybG8vIraesM0nZUl9vQMR8m8
POlzE0s0wPyFC/Rkg2Ibm4d5eQzmMfXTM4XatP+CB/F4XWmpxNlZYYVRozBA
MaRo2wqpqcWMhe7hwzdt2vTX5s1/+fjEUTps23YWX3Fx8OD1b7yh6O2DBq29
fr1cU5pYWOyGQ9WYYDNhAqGuyNr6YQ5zcxbUKe9ltGP/EZU0WuHGDcmyZdm6
us1WGDPmfmQkQyIUg3ra4J+epaAMjPOM3w4zMH78zo7rgLkMDaxKThZYWSmY
nzatOiuLwQNevRftIrV7/x0Voto6qVTs6EisUGhk9CAqStkKLGeSr1wZqs5K
QkeYT0wUVKFhz5LKAOHUqdWZmcrMq8496GD+CSpvtIJEInZwyO7Zs9kKxsYP
oqMZmkBh1qwAt0d7qVyNzOPPwkLB/OTJ1RkZjPZmZ0vUyfrQSP4VBEFcrVgs
XrKEWOGqicmDc+eUrcCOCbQHOOGEosZkg7Q0ZebJvyFih38KENpoBZFItGhR
lo5OsxXGj6+Mi6OrxzmBHUQz85aWmHMZzCMwaes/GtV4/i0UgBq1JSUie3ti
hWumppUJCS8H/+j/GPk7zryW+G9hheJi0cKFCiuYmam//tNp8X8n7wQk
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXAlQFEcXXhUBgyYm5jKHljGm4oFHEIlVhHB4RkUkaExpLIOKyKXwe+BR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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["CookIslands", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztXAlQFEcXXhUBgyYm5jKHljGm4oFHEIlVhHB4RkUkaExpLIOKyKXwe+BR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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "CookIslands"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-83.65, 10.916666666666666`}, {-82.56666666666666, 
      9.566666666666666}, {-82.9, 8.033333333333333}, {-85.66666666666667, 
      9.9}, {-85.68333333333334, 11.066666666666666`}, {-83.65, 
      10.916666666666666`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"CostaRica\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3E0JgEAQgNEBk9jEDIIFLGCFDeV9c+zVsx38ieBBBpb38QYmxDDjus3r
EBHLM+WZd4/YAQAAAAC6VEoj0SVJkiRJkiRJnXZME4laBAAAAAAAAAAAAMAn
2fenkiRJkiRJkvRXtZ4kSn/ACwAAAAAduwEkpp5R
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3E0JgEAQgNEBk9jEDIIFLGCFDeV9c+zVsx38ieBBBpb38QYmxDDjus3r
EBHLM+WZd4/YAQAAAAC6VEoj0SVJkiRJkiRJnXZME4laBAAAAAAAAAAAAMAn
2fenkiRJkiRJkvRXtZ4kSn/ACwAAAAAduwEkpp5R
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["CostaRica", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3E0JgEAQgNEBk9jEDIIFLGCFDeV9c+zVsx38ieBBBpb38QYmxDDjus3r
EBHLM+WZd4/YAQAAAAC6VEoj0SVJkiRJkiRJnXZME4laBAAAAAAAAAAAAMAn
2fenkiRJkiRJkvRXtZ4kSn/ACwAAAAAduwEkpp5R
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "CostaRica"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{18.65, 42.36666666666667}, {14.566666666666666`, 45.3}, {
      13.983333333333333`, 45.5}, {15.716666666666667`, 45.8}, {
      16.53333333333333, 46.6}, {17.866666666666667`, 45.766666666666666`}, {
      18.85, 45.916666666666664`}, {18.8, 44.88333333333333}, {
      18.466666666666665`, 45.05}, {15.95, 45.166666666666664`}, {16.1, 
      44.56666666666666}, {16.366666666666667`, 44.18333333333333}, {
      18.633333333333333`, 42.5}, {18.65, 42.36666666666667}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Croatia\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmgtUk2UYx2dmlsYhtzERQQbGxQDhTEINpEBRkPtAbkMibsIEtRQCZMHk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              "], {{0, 0}, {128, 66}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 66}, PlotRange -> {{0, 128}, {0, 66}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmgtUk2UYx2dmlsYhtzERQQbGxQDhTEINpEBRkPtAbkMibsIEtRQCZMHk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          "], {{0, 0}, {128, 66}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 66}, PlotRange -> {{0, 128}, {0, 66}}]], {
        Style["Croatia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmgtUk2UYx2dmlsYhtzERQQbGxQDhTEINpEBRkPtAbkMibsIEtRQCZMHk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        "], {{0, 0}, {128, 66}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 66}, PlotRange -> {{0, 128}, {0, 66}}], "Croatia"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-84.91666666666667, 
      21.916666666666668`}, {-81.13333333333333, 23.216666666666665`}, {-77.3,
       21.75}, {-74.13333333333333, 20.183333333333334`}, {-77.46666666666667,
       20.15}, {-81.88333333333333, 22.683333333333334`}, {-84.91666666666667,
       21.916666666666668`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Cuba\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJy92NtSgzAQBmBaY8W2kCLWs9aEd/BBfITeO77/nYEU2Rzgav/NDDPcffOT
07Lm/Pt9XhdF8eWeH/e8X3diY7Xe3AhixtxKhesxIxVuwKTCXTCZcCMmEm7C
BMIRDB8uwNDhQgwcLsaMKi1sXMWYMdudIIYLl8Ng4fIYKNwMhgk3iyHCzWOA
cEsYe7hFjDscwQ7JSx/u+ZNvvExYXSr/7eogHONpSc5GbXeH4cPp8FPyXQX0
IG6t3dfWtsnMcYWjWO2n8S5dJ0zhKKY9dp9iTOEIpk4e8+sEkW3Cpi3V6sTi
mbURUzXdfdG0ca3HEdvu++Gc4/Ci+WN1cQ3izsIGtBJTrLE2Xh2vTyu28RFg
yh5Divfcj079MlwazDdahDV0R7Pf1Qv3GX8VMosh6qs5DFI55jFQTZzFUNV+
BsP9x6QY7icmwTaPjNVUPB5CDPtXXVEM3S+gGLwTMmECPZ5/TKJ7dcFk+nIe
E+o49phYL9VhYo3UrnqTaxF31R8qzPC3
              "], {{0, 0}, {109, 54}}, ColorFunctionScaling -> False, 
              ColorFunction -> (Apply[RGBColor, 
                Part[CompressedData["
1:eJzt091KFGEcx/EhugCDUsxUvIMQT+ygn7egQWVaguCxokG3UfhK+XYFkRp6
InjggRCUu6667k7uzr67rrtaUPaiov/fPPNf2CE69GQ/MMzBd9h95vk/09I/
2DVww7Ksjqvr5tXVQDaGyMETysGiE2yHRAo1FMDONmn/dSpyvrvXn9IBmug9
7tIn7cEA4Q7tYIRS2leWRRa3aQx1tKE9skeYmxVf0Exx7c+piJ8/RAavqLy+
pUWRxD1axSMKaX9Gh2YfQnj3VkS199ExLs5FEQ+ppP2rLQpw4oRhSmp39zuM
HrLRSuXeS0f4/k0kzD6ktXdTHlOTYkPX6fVoROQxPyc29f+8bkfFIfbCZOYU
0+6uq2Dew8bCB+Foj8dECWd/RQEz0+KoYj4HZi5rePNaBLS/oBL+/BZ5XY/X
t4IigdCWSJpzktF+ixLmXISxuCAS2htp38wpjseU9c3XnXsKtZT1nY82Spt9
zvner5OCqKeIdm/dXg/vkvb75Oj6K8+v+9056KKk7/zG9kVRv7t2ymv/uCRS
mBgXGTyg8v66c/d+z7LGRsW69v/dZ2fEZ0xOiF28pHTFc/9S7dVe7dfZLwEk
BPKm
                 "], #]]& )], ImageSize -> {109, 54}, 
             PlotRange -> {{0, 109}, {0, 54}}, Background -> None]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJy92NtSgzAQBmBaY8W2kCLWs9aEd/BBfITeO77/nYEU2Rzgav/NDDPcffOT
07Lm/Pt9XhdF8eWeH/e8X3diY7Xe3AhixtxKhesxIxVuwKTCXTCZcCMmEm7C
BMIRDB8uwNDhQgwcLsaMKi1sXMWYMdudIIYLl8Ng4fIYKNwMhgk3iyHCzWOA
cEsYe7hFjDscwQ7JSx/u+ZNvvExYXSr/7eogHONpSc5GbXeH4cPp8FPyXQX0
IG6t3dfWtsnMcYWjWO2n8S5dJ0zhKKY9dp9iTOEIpk4e8+sEkW3Cpi3V6sTi
mbURUzXdfdG0ca3HEdvu++Gc4/Ci+WN1cQ3izsIGtBJTrLE2Xh2vTyu28RFg
yh5Divfcj079MlwazDdahDV0R7Pf1Qv3GX8VMosh6qs5DFI55jFQTZzFUNV+
BsP9x6QY7icmwTaPjNVUPB5CDPtXXVEM3S+gGLwTMmECPZ5/TKJ7dcFk+nIe
E+o49phYL9VhYo3UrnqTaxF31R8qzPC3
          "], {{0, 0}, {109, 54}}, ColorFunctionScaling -> False, 
          ColorFunction -> (Apply[RGBColor, 
            Part[CompressedData["
1:eJzt091KFGEcx/EhugCDUsxUvIMQT+ygn7egQWVaguCxokG3UfhK+XYFkRp6
InjggRCUu6667k7uzr67rrtaUPaiov/fPPNf2CE69GQ/MMzBd9h95vk/09I/
2DVww7Ksjqvr5tXVQDaGyMETysGiE2yHRAo1FMDONmn/dSpyvrvXn9IBmug9
7tIn7cEA4Q7tYIRS2leWRRa3aQx1tKE9skeYmxVf0Exx7c+piJ8/RAavqLy+
pUWRxD1axSMKaX9Gh2YfQnj3VkS199ExLs5FEQ+ppP2rLQpw4oRhSmp39zuM
HrLRSuXeS0f4/k0kzD6ktXdTHlOTYkPX6fVoROQxPyc29f+8bkfFIfbCZOYU
0+6uq2Dew8bCB+Foj8dECWd/RQEz0+KoYj4HZi5rePNaBLS/oBL+/BZ5XY/X
t4IigdCWSJpzktF+ixLmXISxuCAS2htp38wpjseU9c3XnXsKtZT1nY82Spt9
zvner5OCqKeIdm/dXg/vkvb75Oj6K8+v+9056KKk7/zG9kVRv7t2ymv/uCRS
mBgXGTyg8v66c/d+z7LGRsW69v/dZ2fEZ0xOiF28pHTFc/9S7dVe7dfZLwEk
BPKm
             "], #]]& )], ImageSize -> {109, 54}, 
         PlotRange -> {{0, 109}, {0, 54}}, Background -> None]], {
        Style["Cuba", "Panel", Background -> None]}, {{Top, Left}}], Editable -> 
      False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJy92NtSgzAQBmBaY8W2kCLWs9aEd/BBfITeO77/nYEU2Rzgav/NDDPcffOT
07Lm/Pt9XhdF8eWeH/e8X3diY7Xe3AhixtxKhesxIxVuwKTCXTCZcCMmEm7C
BMIRDB8uwNDhQgwcLsaMKi1sXMWYMdudIIYLl8Ng4fIYKNwMhgk3iyHCzWOA
cEsYe7hFjDscwQ7JSx/u+ZNvvExYXSr/7eogHONpSc5GbXeH4cPp8FPyXQX0
IG6t3dfWtsnMcYWjWO2n8S5dJ0zhKKY9dp9iTOEIpk4e8+sEkW3Cpi3V6sTi
mbURUzXdfdG0ca3HEdvu++Gc4/Ci+WN1cQ3izsIGtBJTrLE2Xh2vTyu28RFg
yh5Divfcj079MlwazDdahDV0R7Pf1Qv3GX8VMosh6qs5DFI55jFQTZzFUNV+
BsP9x6QY7icmwTaPjNVUPB5CDPtXXVEM3S+gGLwTMmECPZ5/TKJ7dcFk+nIe
E+o49phYL9VhYo3UrnqTaxF31R8qzPC3
        "], {{0, 0}, {109, 54}}, ColorFunctionScaling -> False, 
        ColorFunction -> (Apply[RGBColor, 
          Part[CompressedData["
1:eJzt091KFGEcx/EhugCDUsxUvIMQT+ygn7egQWVaguCxokG3UfhK+XYFkRp6
InjggRCUu6667k7uzr67rrtaUPaiov/fPPNf2CE69GQ/MMzBd9h95vk/09I/
2DVww7Ksjqvr5tXVQDaGyMETysGiE2yHRAo1FMDONmn/dSpyvrvXn9IBmug9
7tIn7cEA4Q7tYIRS2leWRRa3aQx1tKE9skeYmxVf0Exx7c+piJ8/RAavqLy+
pUWRxD1axSMKaX9Gh2YfQnj3VkS199ExLs5FEQ+ppP2rLQpw4oRhSmp39zuM
HrLRSuXeS0f4/k0kzD6ktXdTHlOTYkPX6fVoROQxPyc29f+8bkfFIfbCZOYU
0+6uq2Dew8bCB+Foj8dECWd/RQEz0+KoYj4HZi5rePNaBLS/oBL+/BZ5XY/X
t4IigdCWSJpzktF+ixLmXISxuCAS2htp38wpjseU9c3XnXsKtZT1nY82Spt9
zvner5OCqKeIdm/dXg/vkvb75Oj6K8+v+9056KKk7/zG9kVRv7t2ymv/uCRS
mBgXGTyg8v66c/d+z7LGRsW69v/dZ2fEZ0xOiF28pHTFc/9S7dVe7dfZLwEk
BPKm
           "], #]]& )], ImageSize -> {109, 54}, 
       PlotRange -> {{0, 109}, {0, 54}}, Background -> None], "Cuba"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{34.583333333333336`, 35.666666666666664`}, {
      33.03333333333333, 34.56666666666666}, {32.266666666666666`, 
      35.06666666666666}, {34.583333333333336`, 35.666666666666664`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Cyprus\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt1klugzAUBuB4wANgzBAIkKEF7tCDdNllLtD77+rQtEoa7DjFqKrkJyGB
QZ/sX34W3fH99QhXq9WLut7U1Q1LlZe97GV3Mhr4QrIgzRKyKCRFZFcQt3LI
qcypSmO3LaUI3clRQ5uQku2g9IoX5QO0WW6KsiorgtTtFiEZ7QrhRg5RjkRZ
5ecHgginlQs5lEQiHn0/R5xSWtjuP+OckSD51UAuiHUcJjmS/GkY2rq+GAtL
2ziM8rgTkn5zNRhNf/yQrApjEPd9AADAGK8tzfsyBGl/VSxzI8Ogv6mDCzmL
b2EVOayTrE1myZsJWEU+LoTNkfEkfC6bvLVyaoD3FrBWhqYp28BaeW2S4RzZ
GLPN1jDIQWuIOrg/bX0a2WersCz5Ha3dGwk8tTfAw+U2CRj76p+Y3cnE5q/g
1DNpsj8fSK06njZjv8S1aeI2Muhj8NPA40IYmCmneGIUYqCiieuJV9byWr/o
w57pTu2//mP0spe97OX/LT93S9UH+0SEYw==
              "], {{0, 0}, {90, 54}}, ColorFunctionScaling -> False, 
              ColorFunction -> (Apply[RGBColor, 
                Part[CompressedData["
1:eJzt08tqU1EYxfEgPoGCeBcfQSdOistnkIriFQodtw6Los/QYm9WW1/Ceul9
1llpk6Y0GlPbJmlybqUVdGCrXStnfxuOCM6c5AfhEP7hnL33+XK5q+dm97Fc
Lnfj6HP86PPrkGI8kAijI7SDnOxio0IJ3kxQAvd716/KJkrr1ECnbFt/Lgkm
xilGh4TWH0qM6SkK8G2ftqy37ruOkWGqp+upWB8eoiLWilTDBSlbfyYxzkuI
1QL59Q0NUhX3JMA1qVuf+khNjL+mCK/GKLD+VELbx8FP8vu7KDHOSYATsmm9
VzZwRhrIr5Dvc7MUY2aaQrybpJr107KIwRe0nZ5/wfp1ifFEAuzvkb//I0ls
/e4cXL8tdTu/D+/Jz8dAPy2gkKet9Puy9ezctN5PZP2SLOGWVNPnrVl351L+
TCHOStO6m6v7EmLyLVWtV76Qfy9ujlxvzX0Zd2QHj+Wr9ZYEhwcU4a7457t9
j72kJoqr5J9/UvI4JbV0/aXM/hPMzlCEPmlYn5+jxNbh5in7ft193Ly77v5P
2avrP75T/Y9rdn4/laiJK+LP59+uf9Pu7d7u/7P/BqG4Bmc=
                 "], #]]& )], ImageSize -> {90, 54}, 
             PlotRange -> {{0, 90}, {0, 54}}, Background -> None]], "Labeled",
            Editable -> True, Selectable -> True], "SkipImageSizeLevel"]}}, 
       RowAlignments -> Center, ColumnAlignments -> Center, 
       BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt1klugzAUBuB4wANgzBAIkKEF7tCDdNllLtD77+rQtEoa7DjFqKrkJyGB
QZ/sX34W3fH99QhXq9WLut7U1Q1LlZe97GV3Mhr4QrIgzRKyKCRFZFcQt3LI
qcypSmO3LaUI3clRQ5uQku2g9IoX5QO0WW6KsiorgtTtFiEZ7QrhRg5RjkRZ
5ecHgginlQs5lEQiHn0/R5xSWtjuP+OckSD51UAuiHUcJjmS/GkY2rq+GAtL
2ziM8rgTkn5zNRhNf/yQrApjEPd9AADAGK8tzfsyBGl/VSxzI8Ogv6mDCzmL
b2EVOayTrE1myZsJWEU+LoTNkfEkfC6bvLVyaoD3FrBWhqYp28BaeW2S4RzZ
GLPN1jDIQWuIOrg/bX0a2WersCz5Ha3dGwk8tTfAw+U2CRj76p+Y3cnE5q/g
1DNpsj8fSK06njZjv8S1aeI2Muhj8NPA40IYmCmneGIUYqCiieuJV9byWr/o
w57pTu2//mP0spe97OX/LT93S9UH+0SEYw==
          "], {{0, 0}, {90, 54}}, ColorFunctionScaling -> False, 
          ColorFunction -> (Apply[RGBColor, 
            Part[CompressedData["
1:eJzt08tqU1EYxfEgPoGCeBcfQSdOistnkIriFQodtw6Los/QYm9WW1/Ceul9
1llpk6Y0GlPbJmlybqUVdGCrXStnfxuOCM6c5AfhEP7hnL33+XK5q+dm97Fc
Lnfj6HP86PPrkGI8kAijI7SDnOxio0IJ3kxQAvd716/KJkrr1ECnbFt/Lgkm
xilGh4TWH0qM6SkK8G2ftqy37ruOkWGqp+upWB8eoiLWilTDBSlbfyYxzkuI
1QL59Q0NUhX3JMA1qVuf+khNjL+mCK/GKLD+VELbx8FP8vu7KDHOSYATsmm9
VzZwRhrIr5Dvc7MUY2aaQrybpJr107KIwRe0nZ5/wfp1ifFEAuzvkb//I0ls
/e4cXL8tdTu/D+/Jz8dAPy2gkKet9Puy9ezctN5PZP2SLOGWVNPnrVl351L+
TCHOStO6m6v7EmLyLVWtV76Qfy9ujlxvzX0Zd2QHj+Wr9ZYEhwcU4a7457t9
j72kJoqr5J9/UvI4JbV0/aXM/hPMzlCEPmlYn5+jxNbh5in7ft193Ly77v5P
2avrP75T/Y9rdn4/laiJK+LP59+uf9Pu7d7u/7P/BqG4Bmc=
             "], #]]& )], ImageSize -> {90, 54}, 
         PlotRange -> {{0, 90}, {0, 54}}, Background -> None]], {
        Style["Cyprus", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt1klugzAUBuB4wANgzBAIkKEF7tCDdNllLtD77+rQtEoa7DjFqKrkJyGB
QZ/sX34W3fH99QhXq9WLut7U1Q1LlZe97GV3Mhr4QrIgzRKyKCRFZFcQt3LI
qcypSmO3LaUI3clRQ5uQku2g9IoX5QO0WW6KsiorgtTtFiEZ7QrhRg5RjkRZ
5ecHgginlQs5lEQiHn0/R5xSWtjuP+OckSD51UAuiHUcJjmS/GkY2rq+GAtL
2ziM8rgTkn5zNRhNf/yQrApjEPd9AADAGK8tzfsyBGl/VSxzI8Ogv6mDCzmL
b2EVOayTrE1myZsJWEU+LoTNkfEkfC6bvLVyaoD3FrBWhqYp28BaeW2S4RzZ
GLPN1jDIQWuIOrg/bX0a2WersCz5Ha3dGwk8tTfAw+U2CRj76p+Y3cnE5q/g
1DNpsj8fSK06njZjv8S1aeI2Muhj8NPA40IYmCmneGIUYqCiieuJV9byWr/o
w57pTu2//mP0spe97OX/LT93S9UH+0SEYw==
        "], {{0, 0}, {90, 54}}, ColorFunctionScaling -> False, 
        ColorFunction -> (Apply[RGBColor, 
          Part[CompressedData["
1:eJzt08tqU1EYxfEgPoGCeBcfQSdOistnkIriFQodtw6Los/QYm9WW1/Ceul9
1llpk6Y0GlPbJmlybqUVdGCrXStnfxuOCM6c5AfhEP7hnL33+XK5q+dm97Fc
Lnfj6HP86PPrkGI8kAijI7SDnOxio0IJ3kxQAvd716/KJkrr1ECnbFt/Lgkm
xilGh4TWH0qM6SkK8G2ftqy37ruOkWGqp+upWB8eoiLWilTDBSlbfyYxzkuI
1QL59Q0NUhX3JMA1qVuf+khNjL+mCK/GKLD+VELbx8FP8vu7KDHOSYATsmm9
VzZwRhrIr5Dvc7MUY2aaQrybpJr107KIwRe0nZ5/wfp1ifFEAuzvkb//I0ls
/e4cXL8tdTu/D+/Jz8dAPy2gkKet9Puy9ezctN5PZP2SLOGWVNPnrVl351L+
TCHOStO6m6v7EmLyLVWtV76Qfy9ujlxvzX0Zd2QHj+Wr9ZYEhwcU4a7457t9
j72kJoqr5J9/UvI4JbV0/aXM/hPMzlCEPmlYn5+jxNbh5in7ft193Ly77v5P
2avrP75T/Y9rdn4/laiJK+LP59+uf9Pu7d7u/7P/BqG4Bmc=
           "], #]]& )], ImageSize -> {90, 54}, 
       PlotRange -> {{0, 90}, {0, 54}}, Background -> None], "Cyprus"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{16.516666666666666`, 48.166666666666664`}, {
      17.766666666666666`, 49.416666666666664`}, {19.116666666666667`, 
      49.88333333333333}, {14.833333333333334`, 50.86666666666667}, {12.1, 
      50.31666666666666}, {13.833333333333334`, 48.766666666666666`}, {
      16.516666666666666`, 48.166666666666664`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"CzechRepublic\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztlsduU0EUho/txA4I0iPRQnmVQHpv1LBIsqKIAAtIsohIewVIsdOb4Tno
ZU9bpJcFLZvE5cJY1wwhAtu58b1nZu759VvyxtKZT/8n+UxLW12LCwAa2ecB
+0S+t7oLP7s8ay7XP+p0xqrDEasA1ER62HE9H5qfQD76JfYs4w/QBnDrKhR8
glT0e+zW3/wjPQHNj0kEPP4kgvU9tJs/iYDPn0QQgH9UBD+cRD9S4cbmr4vQ
BAUfwY1+qpJNgD+JgM+fRDCpB+FawvwjPU4ioPLXRbgCZ0kEPP5REeZIBDz+
JIIA/EkEfP66CJdJBEM9AIn//4wvwiyJgMefRBCAf6THoIVEQOTPRfhAIqDx
JxHw+ZMIcZtmOv+oCDNwCv2xAtYa/iSCAPxJBHz+ugiX4ByJgMc/0qMkAip/
vSSCB24g8tdFmLaxCOj8uQjvbSmCIPxtK4I4/PVetJkIovHXRZiC0+hkrGma
ePxtJYKA++c9Aq3KiyAyf70XoFBhEcTnr7YIUvBXWASJ+OsiTKolglz89Z5X
SAQ33ETnaWcR3C58mIbrb+ra7O+Ptq/PYHt7jbSnx2C7u/+0q8vjuYuO0UDT
0+8NDj7VNO2nzNG2tmTkX1T0cH7+Cza8JEQ6/mz2Q0PSz55HLv7KzJ5H2952
uyXgz2Y/PPxMmdnzSMG/uPjRwoJSs+cRnH9Gxn2v97l6s+cRmX9JibKz5xGT
P5u9z6fy7HkE5F9aOrC4+BUbjEVh/FNT76Az3zl7bCSWRgsEBOFvq9nziMA/
M7N9ZOQFNgmcoPMvKxtYWrLd7HkQ+bPZj47adPY8jH9KCgL/8vJBO8+ex3r+
WVntY2Mvsd8tSizmX1FBs/8rWjBoDX82+/Fxmv3uWMOfzX55+Rv2W0WM2fxp
9rHD+Ltct02CX1k5RLOPHZP4Z2d3TEy8wn6cBDGDf1XV8MoKzT6haKFQEvmz
2U9OvsZ+k0xJIv/qapr9npMU/mz2U1M0eyNh/J3OffFns19d/Y79DlmzH/45
OR3T02+wXyB3DPOvqfHS7PcfA/xp9kmMFg7viX9trXdt7Qf21eokcf5s9jMz
NPskh/F3OOLDr6vz0ezNSFz+ubmds7Nvsc9UNrH50+zNzv/4s9nPzdHsTc8/
+dfX+9bXafZWRNO0nfzz8jr9/nfYR9kojD+H39AwQrO3ODp/mj1WGP/GxtGN
jc09/cTEhMMmNhQyscGgkQYCvwAsSL/b
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztlsduU0EUho/txA4I0iPRQnmVQHpv1LBIsqKIAAtIsohIewVIsdOb4Tno
ZU9bpJcFLZvE5cJY1wwhAtu58b1nZu759VvyxtKZT/8n+UxLW12LCwAa2ecB
+0S+t7oLP7s8ay7XP+p0xqrDEasA1ER62HE9H5qfQD76JfYs4w/QBnDrKhR8
glT0e+zW3/wjPQHNj0kEPP4kgvU9tJs/iYDPn0QQgH9UBD+cRD9S4cbmr4vQ
BAUfwY1+qpJNgD+JgM+fRDCpB+FawvwjPU4ioPLXRbgCZ0kEPP5REeZIBDz+
JIIA/EkEfP66CJdJBEM9AIn//4wvwiyJgMefRBCAf6THoIVEQOTPRfhAIqDx
JxHw+ZMIcZtmOv+oCDNwCv2xAtYa/iSCAPxJBHz+ugiX4ByJgMc/0qMkAip/
vSSCB24g8tdFmLaxCOj8uQjvbSmCIPxtK4I4/PVetJkIovHXRZiC0+hkrGma
ePxtJYKA++c9Aq3KiyAyf70XoFBhEcTnr7YIUvBXWASJ+OsiTKolglz89Z5X
SAQ33ETnaWcR3C58mIbrb+ra7O+Ptq/PYHt7jbSnx2C7u/+0q8vjuYuO0UDT
0+8NDj7VNO2nzNG2tmTkX1T0cH7+Cza8JEQ6/mz2Q0PSz55HLv7KzJ5H2952
uyXgz2Y/PPxMmdnzSMG/uPjRwoJSs+cRnH9Gxn2v97l6s+cRmX9JibKz5xGT
P5u9z6fy7HkE5F9aOrC4+BUbjEVh/FNT76Az3zl7bCSWRgsEBOFvq9nziMA/
M7N9ZOQFNgmcoPMvKxtYWrLd7HkQ+bPZj47adPY8jH9KCgL/8vJBO8+ex3r+
WVntY2Mvsd8tSizmX1FBs/8rWjBoDX82+/Fxmv3uWMOfzX55+Rv2W0WM2fxp
9rHD+Ltct02CX1k5RLOPHZP4Z2d3TEy8wn6cBDGDf1XV8MoKzT6haKFQEvmz
2U9OvsZ+k0xJIv/qapr9npMU/mz2U1M0eyNh/J3OffFns19d/Y79DlmzH/45
OR3T02+wXyB3DPOvqfHS7PcfA/xp9kmMFg7viX9trXdt7Qf21eokcf5s9jMz
NPskh/F3OOLDr6vz0ezNSFz+ubmds7Nvsc9UNrH50+zNzv/4s9nPzdHsTc8/
+dfX+9bXafZWRNO0nfzz8jr9/nfYR9kojD+H39AwQrO3ODp/mj1WGP/GxtGN
jc09/cTEhMMmNhQyscGgkQYCvwAsSL/b
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["CzechRepublic", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztlsduU0EUho/txA4I0iPRQnmVQHpv1LBIsqKIAAtIsohIewVIsdOb4Tno
ZU9bpJcFLZvE5cJY1wwhAtu58b1nZu759VvyxtKZT/8n+UxLW12LCwAa2ecB
+0S+t7oLP7s8ay7XP+p0xqrDEasA1ER62HE9H5qfQD76JfYs4w/QBnDrKhR8
glT0e+zW3/wjPQHNj0kEPP4kgvU9tJs/iYDPn0QQgH9UBD+cRD9S4cbmr4vQ
BAUfwY1+qpJNgD+JgM+fRDCpB+FawvwjPU4ioPLXRbgCZ0kEPP5REeZIBDz+
JIIA/EkEfP66CJdJBEM9AIn//4wvwiyJgMefRBCAf6THoIVEQOTPRfhAIqDx
JxHw+ZMIcZtmOv+oCDNwCv2xAtYa/iSCAPxJBHz+ugiX4ByJgMc/0qMkAip/
vSSCB24g8tdFmLaxCOj8uQjvbSmCIPxtK4I4/PVetJkIovHXRZiC0+hkrGma
ePxtJYKA++c9Aq3KiyAyf70XoFBhEcTnr7YIUvBXWASJ+OsiTKolglz89Z5X
SAQ33ETnaWcR3C58mIbrb+ra7O+Ptq/PYHt7jbSnx2C7u/+0q8vjuYuO0UDT
0+8NDj7VNO2nzNG2tmTkX1T0cH7+Cza8JEQ6/mz2Q0PSz55HLv7KzJ5H2952
uyXgz2Y/PPxMmdnzSMG/uPjRwoJSs+cRnH9Gxn2v97l6s+cRmX9JibKz5xGT
P5u9z6fy7HkE5F9aOrC4+BUbjEVh/FNT76Az3zl7bCSWRgsEBOFvq9nziMA/
M7N9ZOQFNgmcoPMvKxtYWrLd7HkQ+bPZj47adPY8jH9KCgL/8vJBO8+ex3r+
WVntY2Mvsd8tSizmX1FBs/8rWjBoDX82+/Fxmv3uWMOfzX55+Rv2W0WM2fxp
9rHD+Ltct02CX1k5RLOPHZP4Z2d3TEy8wn6cBDGDf1XV8MoKzT6haKFQEvmz
2U9OvsZ+k0xJIv/qapr9npMU/mz2U1M0eyNh/J3OffFns19d/Y79DlmzH/45
OR3T02+wXyB3DPOvqfHS7PcfA/xp9kmMFg7viX9trXdt7Qf21eokcf5s9jMz
NPskh/F3OOLDr6vz0ezNSFz+ubmds7Nvsc9UNrH50+zNzv/4s9nPzdHsTc8/
+dfX+9bXafZWRNO0nfzz8jr9/nfYR9kojD+H39AwQrO3ODp/mj1WGP/GxtGN
jc09/cTEhMMmNhQyscGgkQYCvwAsSL/b
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "CzechRepublic"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{13.183333333333334`, -5.866666666666666}, {
      12.2, -5.783333333333333}, {13.1, -4.633333333333333}, {
      15.9, -3.9166666666666665`}, {18.633333333333333`, 
      3.4833333333333334`}, {19.2, 4.966666666666667}, {22.333333333333332`, 
      4.133333333333333}, {27.45, 5.016666666666667}, {30.866666666666667`, 
      3.4833333333333334`}, {31.3, 2.1166666666666667`}, {
      29.599999999999998`, -1.3833333333333333`}, {
      29.03333333333333, -2.7333333333333334`}, {
      29.416666666666668`, -4.45}, {
      30.766666666666666`, -8.183333333333334}, {
      28.366666666666667`, -9.266666666666666}, {
      28.366666666666667`, -11.55}, {29.8, -12.15}, {29.8, -13.45}, {
      27.2, -11.566666666666666`}, {
      23.983333333333334`, -10.866666666666667`}, {
      22.166666666666668`, -10.866666666666667`}, {
      21.78333333333333, -7.283333333333333}, {18., -8.1}, {
      16.983333333333334`, -7.25}, {
      16.516666666666666`, -5.883333333333333}, {
      13.183333333333334`, -5.866666666666666}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"DemocraticRepublicCongo\"", "Panel", Background -> None, 
            StripOnInput -> False], "Labeled", Editable -> True, Selectable -> 
           True], Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnAtMFFcUhgGRAkKIGgWt1ljRpIq2VkFFtiALUvGBUBErIIhUoYJoUSxQ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              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnAtMFFcUhgGRAkKIGgWt1ljRpIq2VkFFtiALUvGBUBErIIhUoYJoUSxQ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          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["DemocraticRepublicCongo", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnAtMFFcUhgGRAkKIGgWt1ljRpIq2VkFFtiALUvGBUBErIIhUoYJoUSxQ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        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "DemocraticRepublicCongo"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{8.666666666666666, 54.9}, {8.133333333333333, 
      56.583333333333336`}, {9.95, 57.05}, {8.25, 56.81666666666666}, {10.55, 
      57.733333333333334`}, {9.45, 54.81666666666666}, {8.666666666666666, 
      54.916666666666664`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Denmark\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2M1pQkEARtEHKcOVKSkdaAO6cW8DQroJNpAU5e+zg0cgDOSejzswy+Es
Z73dfWzfpmnazOc4n9f9snof1e30+Vi26/4w8J3/Nf78y/HnX44//3L8+Zfj
z78cf/7l+PMvx59/Of78y/HnX44//3L8+Zfjz78cf/7l+PMvx59/Of78y/Hn
X44//3L8+Q9vRhjV/ftnof/t6zzwnX/aQgEzMzMzMzMzMzP7xfx/js3/fzb+
/Mvx51+OP/9y/PmX48+/HH/+5fjzL8effzn+/Mvx51+OP/9y/PmX48+/HH/+
5fjzL8effzn+/Mvx51+OP/9y/PkP7wliPHsd
              "], {{0, 0}, {128, 97}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 97}, PlotRange -> {{0, 128}, {0, 97}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2M1pQkEARtEHKcOVKSkdaAO6cW8DQroJNpAU5e+zg0cgDOSejzswy+Es
Z73dfWzfpmnazOc4n9f9snof1e30+Vi26/4w8J3/Nf78y/HnX44//3L8+Zfj
z78cf/7l+PMvx59/Of78y/HnX44//3L8+Zfjz78cf/7l+PMvx59/Of78y/Hn
X44//3L8+Q9vRhjV/ftnof/t6zzwnX/aQgEzMzMzMzMzMzP7xfx/js3/fzb+
/Mvx51+OP/9y/PmX48+/HH/+5fjzL8effzn+/Mvx51+OP/9y/PmX48+/HH/+
5fjzL8effzn+/Mvx51+OP/9y/PkP7wliPHsd
          "], {{0, 0}, {128, 97}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 97}, PlotRange -> {{0, 128}, {0, 97}}]], {
        Style["Denmark", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2M1pQkEARtEHKcOVKSkdaAO6cW8DQroJNpAU5e+zg0cgDOSejzswy+Es
Z73dfWzfpmnazOc4n9f9snof1e30+Vi26/4w8J3/Nf78y/HnX44//3L8+Zfj
z78cf/7l+PMvx59/Of78y/HnX44//3L8+Zfjz78cf/7l+PMvx59/Of78y/Hn
X44//3L8+Q9vRhjV/ftnof/t6zzwnX/aQgEzMzMzMzMzMzP7xfx/js3/fzb+
/Mvx51+OP/9y/PmX48+/HH/+5fjzL8effzn+/Mvx51+OP/9y/PmX48+/HH/+
5fjzL8effzn+/Mvx51+OP/9y/PkP7wliPHsd
        "], {{0, 0}, {128, 97}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 97}, PlotRange -> {{0, 128}, {0, 97}}], "Denmark"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{43.28333333333333, 11.516666666666666`}, {
      42.516666666666666`, 11.533333333333333`}, {43.11666666666667, 
      12.716666666666667`}, {41.766666666666666`, 11.516666666666666`}, {
      42.95, 11.}, {43.28333333333333, 11.516666666666666`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Djibouti\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt11loVFccx/HRMYuaGpe0tg8+qIniglqUlhRLpaVipSUS0aCgDz74oKi4
UlEwJNBiQ6SFiKZaxaVCSgumD31wieKGy8xkTJzEmEyMMTEmMYHMPuPMnP6H
U0w6TSWT3Du/e+858I0MZ17u+eR3hUzftCN/k9lkMq2hn0L6iX3e2rJllMVk
koFi0ej1vmsza2bAn0TMyJ/yhj3bn22TLwLKn3fTdSOnNhv+SEI10J/yhb27
WneOtoyCP5ggxfnz7rhuz66dBX82ERrUn/KHfXtb95gto+FPaOz+z593z313
7qM58Ic0cG/3pwJh//7n38oXAeXPe+C+P//RPPjTGq8h+lPBcOBg24ExFjP8
mY3U0P15No91oWMB/LENU6L+VCgSLGw/lGIZA394AzQMf95Dj/1DxyL48+u9
YftTryOh4vaiVGsK/Bb6bST+vFpvzZK6xfCL6LSR+1PhyOvvX3yXZk2FX0d3
KeLPq/M6Pq77CH4jfaWgP38Rfug4nG5Ng99LLynrz3vsq/+kPhd+NV2khj8V
iYSPdJSOtabDL6jxVPLnNfqefFq/FH5HLaeqP0Vvwk8vfxxvGwe/qTZT25/n
9Dcte/wZ/LIaLDn+/EU42lmWYRsPv7KmSpo/76m/+YuGz+G31k5J9ucd7zz2
ji0DfnctBPGnngValjd8Cb8+PJQ/72TXiUzbBDiCsP7U80DrV09WwB2E9eed
7j41sToTriGsP9UeaPum8Ws4iLD+vHPdZydXT4KzCOtPdQRfrGrMg8sI68+7
8OrXKdWT4T7C+lOdwZerm/LhRNrydzqH/+2w+q2n4l17FhxKK/6VlSw/n/X2
xp/TCZ3Ttyq8CN2hrgLnWriVJvz9fpaRwaZNY7du9R/SZzqhc/pWBX/eHz2/
T7W/BxcD+1MFBcxkYmYzKy5moVDsX/pMJ3SuGj7vVah7vXMdHA3sX1ER0+Zl
ZfV/pnOV/XmVvRc/sL8Pp4P5u90sPb2fnUcndJ4Uf6o31LOxeQNcD+PvcrGc
nHh/OqHzZPnzSmr/Wvxnoa5L+NYWC8vOjsd/8yuw2ZIj7/VHT1dFN5czvZfA
rSMRVlrKUlIGx+elprKyMrXxa1qie88ZAT8B/64utnLl2+QHNugfCHL2I/F3
OFhV1b/at68fvKgo/tuGBjl7Jf3/W1vbP/hpaayvT421D5z9KWPNXgF/Kjc3
5p+Xpyr+w6cGnL0y/iUlMf/z51WS9xh39sr4O53q/ecTm/1Zg+OP1J8qTPwv
iCHM/perxpdXxj8YVBbfLsbsFfOXszeEv2iz146/mLPXiL+ws4f7e3xCzx7r
T7PfI/bsUf40+5Ny9iD/6mY5e4y/nD3QX84e5R+b/RUpj/GXs0f5y9kD/Wn2
u+XsEf5uX/SEnD3I3+aUs8f4y9kD/eXsUf40+58vS3mMv5Vmf0biA/zl7IH+
cvYofzl7oL+cPcpfzh7oL2eP8qfZl8vZg/wtTdFdcvYIfzl7oL+cPcrf5Y2W
X5LymOTssf0NI0dcZw==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt11loVFccx/HRMYuaGpe0tg8+qIniglqUlhRLpaVipSUS0aCgDz74oKi4
UlEwJNBiQ6SFiKZaxaVCSgumD31wieKGy8xkTJzEmEyMMTEmMYHMPuPMnP6H
U0w6TSWT3Du/e+858I0MZ17u+eR3hUzftCN/k9lkMq2hn0L6iX3e2rJllMVk
koFi0ej1vmsza2bAn0TMyJ/yhj3bn22TLwLKn3fTdSOnNhv+SEI10J/yhb27
WneOtoyCP5ggxfnz7rhuz66dBX82ERrUn/KHfXtb95gto+FPaOz+z593z313
7qM58Ic0cG/3pwJh//7n38oXAeXPe+C+P//RPPjTGq8h+lPBcOBg24ExFjP8
mY3U0P15No91oWMB/LENU6L+VCgSLGw/lGIZA394AzQMf95Dj/1DxyL48+u9
YftTryOh4vaiVGsK/Bb6bST+vFpvzZK6xfCL6LSR+1PhyOvvX3yXZk2FX0d3
KeLPq/M6Pq77CH4jfaWgP38Rfug4nG5Ng99LLynrz3vsq/+kPhd+NV2khj8V
iYSPdJSOtabDL6jxVPLnNfqefFq/FH5HLaeqP0Vvwk8vfxxvGwe/qTZT25/n
9Dcte/wZ/LIaLDn+/EU42lmWYRsPv7KmSpo/76m/+YuGz+G31k5J9ucd7zz2
ji0DfnctBPGnngValjd8Cb8+PJQ/72TXiUzbBDiCsP7U80DrV09WwB2E9eed
7j41sToTriGsP9UeaPum8Ws4iLD+vHPdZydXT4KzCOtPdQRfrGrMg8sI68+7
8OrXKdWT4T7C+lOdwZerm/LhRNrydzqH/+2w+q2n4l17FhxKK/6VlSw/n/X2
xp/TCZ3Ttyq8CN2hrgLnWriVJvz9fpaRwaZNY7du9R/SZzqhc/pWBX/eHz2/
T7W/BxcD+1MFBcxkYmYzKy5moVDsX/pMJ3SuGj7vVah7vXMdHA3sX1ER0+Zl
ZfV/pnOV/XmVvRc/sL8Pp4P5u90sPb2fnUcndJ4Uf6o31LOxeQNcD+PvcrGc
nHh/OqHzZPnzSmr/Wvxnoa5L+NYWC8vOjsd/8yuw2ZIj7/VHT1dFN5czvZfA
rSMRVlrKUlIGx+elprKyMrXxa1qie88ZAT8B/64utnLl2+QHNugfCHL2I/F3
OFhV1b/at68fvKgo/tuGBjl7Jf3/W1vbP/hpaayvT421D5z9KWPNXgF/Kjc3
5p+Xpyr+w6cGnL0y/iUlMf/z51WS9xh39sr4O53q/ecTm/1Zg+OP1J8qTPwv
iCHM/perxpdXxj8YVBbfLsbsFfOXszeEv2iz146/mLPXiL+ws4f7e3xCzx7r
T7PfI/bsUf40+5Ny9iD/6mY5e4y/nD3QX84e5R+b/RUpj/GXs0f5y9kD/Wn2
u+XsEf5uX/SEnD3I3+aUs8f4y9kD/eXsUf40+58vS3mMv5Vmf0biA/zl7IH+
cvYofzl7oL+cPcpfzh7oL2eP8qfZl8vZg/wtTdFdcvYIfzl7oL+cPcrf5Y2W
X5LymOTssf0NI0dcZw==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Djibouti", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt11loVFccx/HRMYuaGpe0tg8+qIniglqUlhRLpaVipSUS0aCgDz74oKi4
UlEwJNBiQ6SFiKZaxaVCSgumD31wieKGy8xkTJzEmEyMMTEmMYHMPuPMnP6H
U0w6TSWT3Du/e+858I0MZ17u+eR3hUzftCN/k9lkMq2hn0L6iX3e2rJllMVk
koFi0ej1vmsza2bAn0TMyJ/yhj3bn22TLwLKn3fTdSOnNhv+SEI10J/yhb27
WneOtoyCP5ggxfnz7rhuz66dBX82ERrUn/KHfXtb95gto+FPaOz+z593z313
7qM58Ic0cG/3pwJh//7n38oXAeXPe+C+P//RPPjTGq8h+lPBcOBg24ExFjP8
mY3U0P15No91oWMB/LENU6L+VCgSLGw/lGIZA394AzQMf95Dj/1DxyL48+u9
YftTryOh4vaiVGsK/Bb6bST+vFpvzZK6xfCL6LSR+1PhyOvvX3yXZk2FX0d3
KeLPq/M6Pq77CH4jfaWgP38Rfug4nG5Ng99LLynrz3vsq/+kPhd+NV2khj8V
iYSPdJSOtabDL6jxVPLnNfqefFq/FH5HLaeqP0Vvwk8vfxxvGwe/qTZT25/n
9Dcte/wZ/LIaLDn+/EU42lmWYRsPv7KmSpo/76m/+YuGz+G31k5J9ucd7zz2
ji0DfnctBPGnngValjd8Cb8+PJQ/72TXiUzbBDiCsP7U80DrV09WwB2E9eed
7j41sToTriGsP9UeaPum8Ws4iLD+vHPdZydXT4KzCOtPdQRfrGrMg8sI68+7
8OrXKdWT4T7C+lOdwZerm/LhRNrydzqH/+2w+q2n4l17FhxKK/6VlSw/n/X2
xp/TCZ3Ttyq8CN2hrgLnWriVJvz9fpaRwaZNY7du9R/SZzqhc/pWBX/eHz2/
T7W/BxcD+1MFBcxkYmYzKy5moVDsX/pMJ3SuGj7vVah7vXMdHA3sX1ER0+Zl
ZfV/pnOV/XmVvRc/sL8Pp4P5u90sPb2fnUcndJ4Uf6o31LOxeQNcD+PvcrGc
nHh/OqHzZPnzSmr/Wvxnoa5L+NYWC8vOjsd/8yuw2ZIj7/VHT1dFN5czvZfA
rSMRVlrKUlIGx+elprKyMrXxa1qie88ZAT8B/64utnLl2+QHNugfCHL2I/F3
OFhV1b/at68fvKgo/tuGBjl7Jf3/W1vbP/hpaayvT421D5z9KWPNXgF/Kjc3
5p+Xpyr+w6cGnL0y/iUlMf/z51WS9xh39sr4O53q/ecTm/1Zg+OP1J8qTPwv
iCHM/perxpdXxj8YVBbfLsbsFfOXszeEv2iz146/mLPXiL+ws4f7e3xCzx7r
T7PfI/bsUf40+5Ny9iD/6mY5e4y/nD3QX84e5R+b/RUpj/GXs0f5y9kD/Wn2
u+XsEf5uX/SEnD3I3+aUs8f4y9kD/eXsUf40+58vS3mMv5Vmf0biA/zl7IH+
cvYofzl7oL+cPcpfzh7oL2eP8qfZl8vZg/wtTdFdcvYIfzl7oL+cPcrf5Y2W
X5LymOTssf0NI0dcZw==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Djibouti"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.3308, 15.249}, {-61.3582, 15.2384}, {-61.3834, 
      15.2374}, {-61.3999, 15.2432}, {-61.415, 15.2643}, {-61.4107, 
      15.3166}, {-61.4323, 15.4078}, {-61.5079, 15.5047}, {-61.5093, 
      15.5219}, {-61.5014, 15.5373}, {-61.4661, 15.5517}, {-61.4532, 
      15.568}, {-61.4438, 15.6184}, {-61.433, 15.627}, {-61.4129, 
      15.628}, {-61.3733, 15.6059}, {-61.2473, 15.5575}, {-61.2142, 
      15.5239}, {-61.2099, 15.4653}, {-61.2344, 15.4178}, {-61.2452, 
      15.3449}, {-61.2581, 15.3099}, {-61.3308, 15.249}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Dominica\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmwtwE9UagP/dZPNOtiIKIyhWkzRp0tKHEVqL9KFAH4CgFCsPKZZar2Bf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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmwtwE9UagP/dZPNOtiIKIyhWkzRp0tKHEVqL9KFAH4CgFCsPKZZar2Bf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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Dominica", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmwtwE9UagP/dZPNOtiIKIyhWkzRp0tKHEVqL9KFAH4CgFCsPKZZar2Bf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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Dominica"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-71.76666666666667, 19.7}, {-68.31666666666666, 
      18.6}, {-71.78333333333333, 18.05}, {-71.76666666666667, 19.7}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"DominicanRepublic\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2XtMEwccB3CS/bX/3JIl8y/jHn9sf5i4xx+auJHpnDNkASdubMgm+NrU
oM7B3owMUJmgFOZ4dKXDCaS1lj4AiyAU1oG8C6VAK6VvSlva0tLn9XBHsvjP
thgSyB2X7zffu7SX++N3n16v6d3WzOwDmU8kJCR8RC0/UsvKa/3u17QvPcvw
+ttbHq4y4/qFhO1chnfTrjr4wx/+DC/84Q9/+MMf/vCHP/zhD3/4wx/+8Ic/
/OEPf/jDH/7whz/84Q9/2nnhz/DCH/7wp50X/gwv/OEPf/jDH/7whz/84Q//
NfEnQ8HVHhpdiemno5OaR28DUR9BxnwhVygW+GdTPB57oIsvuOiZj9UhPQt+
Ub2XU+y5nE+YjdQWz2CfQ9yoE3Aj2pUPJTzS7y0tdJ47ER66vxwn6J6XhQnH
lihY68eJlrRX57L32y6ka3JOjOcddnx5yJK8w5K+3XHlh+Cj7wKy1qlT5RfI
0tQW5eSwvP3XzwzVhd7KUh+v3C7gapqr2kf5vSbFfXOHxjFA96QsjMaqEg6U
9Opbbg9yFCpOhzCv50/eQ5JU690cUY9I1Scba/pa8WF+2/GKe3mh6Ib5Udso
sXp034jeK5JniHtKpk6+b9i6afbFZ3y2+Vs1soQdFVTfOiPO6ziWenPbHV2D
P+Sje162xRWwlt09TV2CdOLrK/gvb3b//JNC0L7YKpUfOXPk8LWn3+FKJvgZ
gp2iierRORXd87IqRDya3fCGcvpW70yzS9po2fO69dODvRpH2W/dY22qRYfL
8NxTW5JrJ53DZcpvOaqvpJN8ukdmW9SW7q4pQanipDtgJ7xeq8kRuNsq59/U
1Vb5Z/SEzWIyGHtmWyUafnF3ttreSy6TdI/Mqlg8+mplbo5w35DWdLakM7Og
zX314syY2mU2eUYGnkys1FX9Eg4t3dbUUCf/zMIE3fOyLcopUZUy93JLVj6/
bGeWILv0ns/YGfJOB53jRGhxcxJP+m7SvNXQoC4Xqivn/Va652VbokS4uCWr
abiiol6Ze03WILzBq+c79bWeoT9ssvLy+u7BjDTfvMPk1Y/ZBlzBObrnZVvG
Z9yyv4bdAdt1wcj5ouq0HO4LyRy70+OuqzGf3W++kGr84E0yEqb25Mm0wTDu
P6xxuoZtzx+8QcTJ45c6E0+JU3PqqbU/GF3qUNjTkmznU6h1QCIcmnJuSfmd
JJfpnpeF4Uonvqvqk3Qb/m8Hucq475y0cwgX/3VJKEJsS2/Ye6wwI7csM1/I
k4y5feEpk/dKbXNT653+/g5uo6i1C/+81jfTJi91hl9tHN17tOCVQ5d2ZRS9
/Tlf+8Bid2/Iez5ub9izGGF4I7H4vyeftftHdC6PP/Kfx0XGYmHtOMMbMegT
j8ppfwz32NZKpld7XhHOedofmz62hpTd8Ic//Ble+MMf/vCHP/zhD3/4wx/+
8Ic//OEPf/jDH/7whz/84Q9/+MMf/rTzwp/hhT/84U87L/wZXvjDH/7whz/8
4Q9/+MMf/vCHP/zhD//17kXe6Gr9o1az8ZMDDK/9+y/+Bn0LWPI=
              "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2XtMEwccB3CS/bX/3JIl8y/jHn9sf5i4xx+auJHpnDNkASdubMgm+NrU
oM7B3owMUJmgFOZ4dKXDCaS1lj4AiyAU1oG8C6VAK6VvSlva0tLn9XBHsvjP
thgSyB2X7zffu7SX++N3n16v6d3WzOwDmU8kJCR8RC0/UsvKa/3u17QvPcvw
+ttbHq4y4/qFhO1chnfTrjr4wx/+DC/84Q9/+MMf/vCHP/zhD3/4wx/+8Ic/
/OEPf/jDH/7whz/84Q9/2nnhz/DCH/7wp50X/gwv/OEPf/jDH/7whz/84Q//
NfEnQ8HVHhpdiemno5OaR28DUR9BxnwhVygW+GdTPB57oIsvuOiZj9UhPQt+
Ub2XU+y5nE+YjdQWz2CfQ9yoE3Aj2pUPJTzS7y0tdJ47ER66vxwn6J6XhQnH
lihY68eJlrRX57L32y6ka3JOjOcddnx5yJK8w5K+3XHlh+Cj7wKy1qlT5RfI
0tQW5eSwvP3XzwzVhd7KUh+v3C7gapqr2kf5vSbFfXOHxjFA96QsjMaqEg6U
9Opbbg9yFCpOhzCv50/eQ5JU690cUY9I1Scba/pa8WF+2/GKe3mh6Ib5Udso
sXp034jeK5JniHtKpk6+b9i6afbFZ3y2+Vs1soQdFVTfOiPO6ziWenPbHV2D
P+Sje162xRWwlt09TV2CdOLrK/gvb3b//JNC0L7YKpUfOXPk8LWn3+FKJvgZ
gp2iierRORXd87IqRDya3fCGcvpW70yzS9po2fO69dODvRpH2W/dY22qRYfL
8NxTW5JrJ53DZcpvOaqvpJN8ukdmW9SW7q4pQanipDtgJ7xeq8kRuNsq59/U
1Vb5Z/SEzWIyGHtmWyUafnF3ttreSy6TdI/Mqlg8+mplbo5w35DWdLakM7Og
zX314syY2mU2eUYGnkys1FX9Eg4t3dbUUCf/zMIE3fOyLcopUZUy93JLVj6/
bGeWILv0ns/YGfJOB53jRGhxcxJP+m7SvNXQoC4Xqivn/Va652VbokS4uCWr
abiiol6Ze03WILzBq+c79bWeoT9ssvLy+u7BjDTfvMPk1Y/ZBlzBObrnZVvG
Z9yyv4bdAdt1wcj5ouq0HO4LyRy70+OuqzGf3W++kGr84E0yEqb25Mm0wTDu
P6xxuoZtzx+8QcTJ45c6E0+JU3PqqbU/GF3qUNjTkmznU6h1QCIcmnJuSfmd
JJfpnpeF4Uonvqvqk3Qb/m8Hucq475y0cwgX/3VJKEJsS2/Ye6wwI7csM1/I
k4y5feEpk/dKbXNT653+/g5uo6i1C/+81jfTJi91hl9tHN17tOCVQ5d2ZRS9
/Tlf+8Bid2/Iez5ub9izGGF4I7H4vyeftftHdC6PP/Kfx0XGYmHtOMMbMegT
j8ppfwz32NZKpld7XhHOedofmz62hpTd8Ic//Ble+MMf/vCHP/zhD3/4wx/+
8Ic//OEPf/jDH/7whz/84Q9/+MMf/rTzwp/hhT/84U87L/wZXvjDH/7whz/8
4Q9/+MMf/vCHP/zhD//17kXe6Gr9o1az8ZMDDK/9+y/+Bn0LWPI=
          "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], {
        Style["DominicanRepublic", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2XtMEwccB3CS/bX/3JIl8y/jHn9sf5i4xx+auJHpnDNkASdubMgm+NrU
oM7B3owMUJmgFOZ4dKXDCaS1lj4AiyAU1oG8C6VAK6VvSlva0tLn9XBHsvjP
thgSyB2X7zffu7SX++N3n16v6d3WzOwDmU8kJCR8RC0/UsvKa/3u17QvPcvw
+ttbHq4y4/qFhO1chnfTrjr4wx/+DC/84Q9/+MMf/vCHP/zhD3/4wx/+8Ic/
/OEPf/jDH/7whz/84Q9/2nnhz/DCH/7wp50X/gwv/OEPf/jDH/7whz/84Q//
NfEnQ8HVHhpdiemno5OaR28DUR9BxnwhVygW+GdTPB57oIsvuOiZj9UhPQt+
Ub2XU+y5nE+YjdQWz2CfQ9yoE3Aj2pUPJTzS7y0tdJ47ER66vxwn6J6XhQnH
lihY68eJlrRX57L32y6ka3JOjOcddnx5yJK8w5K+3XHlh+Cj7wKy1qlT5RfI
0tQW5eSwvP3XzwzVhd7KUh+v3C7gapqr2kf5vSbFfXOHxjFA96QsjMaqEg6U
9Opbbg9yFCpOhzCv50/eQ5JU690cUY9I1Scba/pa8WF+2/GKe3mh6Ib5Udso
sXp034jeK5JniHtKpk6+b9i6afbFZ3y2+Vs1soQdFVTfOiPO6ziWenPbHV2D
P+Sje162xRWwlt09TV2CdOLrK/gvb3b//JNC0L7YKpUfOXPk8LWn3+FKJvgZ
gp2iierRORXd87IqRDya3fCGcvpW70yzS9po2fO69dODvRpH2W/dY22qRYfL
8NxTW5JrJ53DZcpvOaqvpJN8ukdmW9SW7q4pQanipDtgJ7xeq8kRuNsq59/U
1Vb5Z/SEzWIyGHtmWyUafnF3ttreSy6TdI/Mqlg8+mplbo5w35DWdLakM7Og
zX314syY2mU2eUYGnkys1FX9Eg4t3dbUUCf/zMIE3fOyLcopUZUy93JLVj6/
bGeWILv0ns/YGfJOB53jRGhxcxJP+m7SvNXQoC4Xqivn/Va652VbokS4uCWr
abiiol6Ze03WILzBq+c79bWeoT9ssvLy+u7BjDTfvMPk1Y/ZBlzBObrnZVvG
Z9yyv4bdAdt1wcj5ouq0HO4LyRy70+OuqzGf3W++kGr84E0yEqb25Mm0wTDu
P6xxuoZtzx+8QcTJ45c6E0+JU3PqqbU/GF3qUNjTkmznU6h1QCIcmnJuSfmd
JJfpnpeF4Uonvqvqk3Qb/m8Hucq475y0cwgX/3VJKEJsS2/Ye6wwI7csM1/I
k4y5feEpk/dKbXNT653+/g5uo6i1C/+81jfTJi91hl9tHN17tOCVQ5d2ZRS9
/Tlf+8Bid2/Iez5ub9izGGF4I7H4vyeftftHdC6PP/Kfx0XGYmHtOMMbMegT
j8ppfwz32NZKpld7XhHOedofmz62hpTd8Ic//Ble+MMf/vCHP/zhD3/4wx/+
8Ic//OEPf/jDH/7whz/84Q9/+MMf/rTzwp/hhT/84U87L/wZXvjDH/7whz/8
4Q9/+MMf/vCHP/zhD//17kXe6Gr9o1az8ZMDDK/9+y/+Bn0LWPI=
        "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}], 
      "DominicanRepublic"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxdVAlMVVcQxV814ILQUsGK+u6DWHBroOICLgPUqlAVJaJVw5RF+oMoFpTa
IuJOkVpEgliWIlFRiLEfkEUoMCAKQtTIIiDF1mqrKMSCIgJCO+//X016k5eX
mzv3zpkz54zwDV6zWWVgYODFn/J38C5aPsYRobPZsPJplqDuuhW+JoBQ5T43
2nmvoJPb3j1ALggWX0xJLfIVJDQh6rglCH29E8yNZwvaGW8x3OtThFdZCUZl
1oLq+fr65Qh5q6r8Rn4gyG2ManrUSoTYh91T6sYJajq9feGoYASfIFHt3CdR
eU36kvxwhAUBp+yHOiVqn2pneGE3wp+jnoWYPpNIed44AqHXyWxE/wuJZuak
Pju3ByE3r3SZekCirC4GvBch3Ozi0vv9Ep1wjQl6dIDPw7s1Hk8lClDWYYRu
51sBjY8kMrxgucE/5u2+ltM/P8r4PR+cTX4o0VDDrvapcQi+bta3a5slep3J
CY4jNE8r/2P7HYlu9XJgPEJ66eaViY0SGSjrJEJ8cP5lO8b/sbKS39anzf8T
goPtiDZvlaCrEhOYjtB2w3NSyDuCOlYXTj50GmFDz+W7RwYl+vvcNfe5mQhd
L9w+P/xf/iyErZbZ49PqJIrr3L3Y4SJCbavpytE3JVLoHZ+NcGXaveoFFRKZ
t9zs9cxF2HdrnNXBAom4u6rpBQgZyZWSJkePrxjhzJyvQspyJVLCH5Qg2Iwb
nZdxWaL854MNu8oR0HtvxI4iSdffa5z/0UBmV46+/lqEtLBXW3LyJWqzHrkv
oR7hoP+w9wqvSmTV2rcnsAHBcGHy2rRafTyfD4wo9mll/LEVPTabqhAiHu/v
P2Ek6AzLoekKQmINFzRRkJKmjvEkD3UsPTJP0EubTbEVeaxH0y1dth5CVy/z
Y5HQYKT21esrA+H2umMBMwIFhaqZoTSE31YdTdx2XJD2n6TnL0eQtg7uZ9cs
867UakHr51+qDvsBIcfPyuTnVkFruB1PoxH8IlsWftMsyJbT93yHkGB855/5
vwpKYRpDeH9J5epV8ESQIienKNbDl7lPQnvEG30qz6y2kEmrK9azVmeTZIoM
/GVH/C6EU9Ga++3vy8TuqknfiTD4cufvKaayDl8I61PxId/X+m0r68tx2IqD
M2VqZHnaqRGaPitt+WuOTMy+a4w/gsuixy0XHGWdvny4Xq+Ii/kuMpkoBXoh
aOal9DUGyW/8uGjx9yaTU/Xx7Nex0eEzIgplesHtb2c/r9uYXdZRKhO76lsz
3ntkRThOzpVJgW/xCevDttakKkkmZXyoXBFKHDRr9x+SdXwuQtDyEqnPz/t7
KqMjU0JlSvqRlzNC1NYY+4n+sk7P/L5zUrbacaNMEz9iRTGeefaxr8s9ZN38
cUP4kMeCJden9a87QnGnS2jqSJk4W2kan5890BNpXK+fX8sQln5t4uTJ/VXo
62S8s2dZGl6vE6SdEzzPhh+7W3l9rL4fPO9W3DkfpbaWidXIE4rjTecsKJFl
XTzPx/ry/sVRE2QKVho2X++XPkHn2a7RvA8b3N+muSHo//P0X6t2h5M=
       "], {{124.385, -9.12053}, {124.43, -9.17586}, {124.443, -9.23217}, {
       124.42, -9.30899}, {124.384, -9.35613}, {124.368, -9.36639}, {
       124.317, -9.37349}, {124.28, -9.3703}, {124.224, -9.35665}, {
       124.176, -9.32972}, {124.127, -9.28356}, {124.081, -9.23204}, {
       124.173, -9.18393}, {124.257, -9.1399}, {124.385, -9.12053}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"EastTimor\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnG1IE3Ecx8/bjdN5c0PwAfdmkk7cbD2M9cI39kooGk1Ho3eF5MgifSFC
jYpl7J0wBH0hRLTZZkb4zhetvUiF3sRetMoeEBV8J+FWvTARWX/94yFrt3tY
3h+235cbyHkc8vmw75338GvuG+rt01AUdR59Auiz//NVJ5O0699TBliILEhB
u5l+d1e3fLqG+B9Thgt1EF0l9eQe+yPEgQUi/HGuXWDSr6vBAin+KNZm+kNY
9+ctBxaI8Mdd9NTPIgVggQh/nOsX97sILJDij2JrplMRHVYAFtTnj1JdRT27
z/IKwILK/HH6LjGZwy4CC+rzRzl5gv44rTuqACyoyR+Fq6IiD9gcBWBBNf44
N1y5XQQW1OSPYm+hPz3P7SKwoBp/6qCLph/m6SKwoA5/HN9l5mc8TxeBBXX4
o5xqoT9H83cRWFCBP4peR0UDlQUUgIVj5Y9z060t0EVg4bj5o5yx0MuxQl0E
Fo6VP0pNNTXzSKSLwIJc/gzDyLJwq1f7641IF4EFifyNRuPg4KAs/ihn2+gv
M+JdBBZESba2tm5tbdXW1spVYOCo2ceSuqicLYhi7OzszGazExMTcvnj3PZI
7aLytCAK0O12I/67u7s2m02ZAkcb/VVyF5WbBVF6/f392YPE4/G8G3AcZzCI
7Ad10Us5XVQ+FkT5+/3+7GFcLhdeaTKZvF7v+Ph4MplcWFhgWVZ0Pyh3rmh/
J2R0UTlYEIUWCoV4/qurq9FodH19/eiauro6KfBxnO30txfyuqi0LQiBamho
6OnpGRsb29jYyAokk8lYrVbp8HGMHPUqKLuLStUCj6WioqKjo8Pn84XD4ZWV
FSHmfNARubu7Wy58PkNeJV1UehZ4IBqNxuPxLC0tiZLHGRgYUAwf55yV/j6r
pItKycK/WBwORyQS2dnZKQA/kUgUCR/4C/HHaWxsHB0d3dzczMsf2TGbzcXA
h/4pzB8HHQ6EvgLoO6KMPBx/pfMfHh4W4r+3t2e32+XCh/NPWfwDgQAPfHFx
EZ1tTk5Obm9v4zXz8/Oy4MP/X3L5o/N/jDqVShmNRryyvr4+GAym02m0vqur
Swp5uP6gjP/U1BSCvLa21tTUlPMrvV4/MjIyNzcnCh+uvynmH4vF0CmQxWIR
2oBlWa1WW2APcP25SP5Op7PwNkKB+y/F8zeZTMrgw/3H/8JfWeD+Oyn+8PwJ
Qf7w/BVB/vD8ISn+8PwtQf7w/DlB/vD+BSn+8P4RQf7w/h1B/vD+KSn+8P41
Qf4wf4Agf5i/QYo/zJ8hyB/mLxHkD/PHSPGH+XsE+cP8SYL8Yf4qKf4wf5gg
f5i/TXCB+fNkl79Saqgq
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnG1IE3Ecx8/bjdN5c0PwAfdmkk7cbD2M9cI39kooGk1Ho3eF5MgifSFC
jYpl7J0wBH0hRLTZZkb4zhetvUiF3sRetMoeEBV8J+FWvTARWX/94yFrt3tY
3h+235cbyHkc8vmw75338GvuG+rt01AUdR59Auiz//NVJ5O0699TBliILEhB
u5l+d1e3fLqG+B9Thgt1EF0l9eQe+yPEgQUi/HGuXWDSr6vBAin+KNZm+kNY
9+ctBxaI8Mdd9NTPIgVggQh/nOsX97sILJDij2JrplMRHVYAFtTnj1JdRT27
z/IKwILK/HH6LjGZwy4CC+rzRzl5gv44rTuqACyoyR+Fq6IiD9gcBWBBNf44
N1y5XQQW1OSPYm+hPz3P7SKwoBp/6qCLph/m6SKwoA5/HN9l5mc8TxeBBXX4
o5xqoT9H83cRWFCBP4peR0UDlQUUgIVj5Y9z060t0EVg4bj5o5yx0MuxQl0E
Fo6VP0pNNTXzSKSLwIJc/gzDyLJwq1f7641IF4EFifyNRuPg4KAs/ihn2+gv
M+JdBBZESba2tm5tbdXW1spVYOCo2ceSuqicLYhi7OzszGazExMTcvnj3PZI
7aLytCAK0O12I/67u7s2m02ZAkcb/VVyF5WbBVF6/f392YPE4/G8G3AcZzCI
7Ad10Us5XVQ+FkT5+/3+7GFcLhdeaTKZvF7v+Ph4MplcWFhgWVZ0Pyh3rmh/
J2R0UTlYEIUWCoV4/qurq9FodH19/eiauro6KfBxnO30txfyuqi0LQiBamho
6OnpGRsb29jYyAokk8lYrVbp8HGMHPUqKLuLStUCj6WioqKjo8Pn84XD4ZWV
FSHmfNARubu7Wy58PkNeJV1UehZ4IBqNxuPxLC0tiZLHGRgYUAwf55yV/j6r
pItKycK/WBwORyQS2dnZKQA/kUgUCR/4C/HHaWxsHB0d3dzczMsf2TGbzcXA
h/4pzB8HHQ6EvgLoO6KMPBx/pfMfHh4W4r+3t2e32+XCh/NPWfwDgQAPfHFx
EZ1tTk5Obm9v4zXz8/Oy4MP/X3L5o/N/jDqVShmNRryyvr4+GAym02m0vqur
Swp5uP6gjP/U1BSCvLa21tTUlPMrvV4/MjIyNzcnCh+uvynmH4vF0CmQxWIR
2oBlWa1WW2APcP25SP5Op7PwNkKB+y/F8zeZTMrgw/3H/8JfWeD+Oyn+8PwJ
Qf7w/BVB/vD8ISn+8PwtQf7w/DlB/vD+BSn+8P4RQf7w/h1B/vD+KSn+8P41
Qf4wf4Agf5i/QYo/zJ8hyB/mLxHkD/PHSPGH+XsE+cP8SYL8Yf4qKf4wf5gg
f5i/TXCB+fNkl79Saqgq
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["EastTimor", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnG1IE3Ecx8/bjdN5c0PwAfdmkk7cbD2M9cI39kooGk1Ho3eF5MgifSFC
jYpl7J0wBH0hRLTZZkb4zhetvUiF3sRetMoeEBV8J+FWvTARWX/94yFrt3tY
3h+235cbyHkc8vmw75338GvuG+rt01AUdR59Auiz//NVJ5O0699TBliILEhB
u5l+d1e3fLqG+B9Thgt1EF0l9eQe+yPEgQUi/HGuXWDSr6vBAin+KNZm+kNY
9+ctBxaI8Mdd9NTPIgVggQh/nOsX97sILJDij2JrplMRHVYAFtTnj1JdRT27
z/IKwILK/HH6LjGZwy4CC+rzRzl5gv44rTuqACyoyR+Fq6IiD9gcBWBBNf44
N1y5XQQW1OSPYm+hPz3P7SKwoBp/6qCLph/m6SKwoA5/HN9l5mc8TxeBBXX4
o5xqoT9H83cRWFCBP4peR0UDlQUUgIVj5Y9z060t0EVg4bj5o5yx0MuxQl0E
Fo6VP0pNNTXzSKSLwIJc/gzDyLJwq1f7641IF4EFifyNRuPg4KAs/ihn2+gv
M+JdBBZESba2tm5tbdXW1spVYOCo2ceSuqicLYhi7OzszGazExMTcvnj3PZI
7aLytCAK0O12I/67u7s2m02ZAkcb/VVyF5WbBVF6/f392YPE4/G8G3AcZzCI
7Ad10Us5XVQ+FkT5+/3+7GFcLhdeaTKZvF7v+Ph4MplcWFhgWVZ0Pyh3rmh/
J2R0UTlYEIUWCoV4/qurq9FodH19/eiauro6KfBxnO30txfyuqi0LQiBamho
6OnpGRsb29jYyAokk8lYrVbp8HGMHPUqKLuLStUCj6WioqKjo8Pn84XD4ZWV
FSHmfNARubu7Wy58PkNeJV1UehZ4IBqNxuPxLC0tiZLHGRgYUAwf55yV/j6r
pItKycK/WBwORyQS2dnZKQA/kUgUCR/4C/HHaWxsHB0d3dzczMsf2TGbzcXA
h/4pzB8HHQ6EvgLoO6KMPBx/pfMfHh4W4r+3t2e32+XCh/NPWfwDgQAPfHFx
EZ1tTk5Obm9v4zXz8/Oy4MP/X3L5o/N/jDqVShmNRryyvr4+GAym02m0vqur
Swp5uP6gjP/U1BSCvLa21tTUlPMrvV4/MjIyNzcnCh+uvynmH4vF0CmQxWIR
2oBlWa1WW2APcP25SP5Op7PwNkKB+y/F8zeZTMrgw/3H/8JfWeD+Oyn+8PwJ
Qf7w/BVB/vD8ISn+8PwtQf7w/DlB/vD+BSn+8P4RQf7w/h1B/vD+KSn+8P41
Qf4wf4Agf5i/QYo/zJ8hyB/mLxHkD/PHSPGH+XsE+cP8SYL8Yf4qKf4wf5gg
f5i/TXCB+fNkl79Saqgq
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "EastTimor"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-80.33333333333333, -3.3666666666666667`}, \
{-79.76666666666667, -2.0166666666666666`}, {-80.91666666666667, \
-2.3166666666666664`}, {-80.91666666666667, -1.0333333333333332`}, \
{-78.81666666666666, 
      1.4333333333333333`}, {-75.28333333333333, -0.1}, {-79.03333333333333, \
-5.}, {-80.48333333333333, -4.433333333333334}, {-80.33333333333333, \
-3.3666666666666667`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Ecuador\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztlntQzWkYx7/nnKTYdDmVy9ncUqE5Y5AhUznsujTrllCitIXNVCKT2tJK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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztlntQzWkYx7/nnKTYdDmVy9ncUqE5Y5AhUznsujTrllCitIXNVCKT2tJK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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Ecuador", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztlntQzWkYx7/nnKTYdDmVy9ncUqE5Y5AhUznsujTrllCitIXNVCKT2tJK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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Ecuador"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{35.61666666666667, 23.133333333333333`}, {
      32.333333333333336`, 29.599999999999998`}, {34.25, 
      27.733333333333334`}, {34.96666666666667, 29.55}, {34.9, 
      29.483333333333334`}, {34.266666666666666`, 31.216666666666665`}, {
      34.21666666666667, 31.333333333333332`}, {25.15, 31.65}, {25., 22.}, {
      33.93333333333333, 21.75}, {35.61666666666667, 23.133333333333333`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Egypt\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmluME2UUgJcY37y9QPQJ9tEQUeKD8YqgMT4oUQgmohhuglyXiIIoIBqF
jWKCYGCBgKyAqBgRTYTCroWVXbsXlt3S+2Xa6XQ691s7M22nFzxtE0JwiS+6
k6nny9fdv+k/yZkzM+f8/3ZbF7fNWXxbS0vLPHhtg1dtjCAIgiAIgiAIgiAI
giAIgiAIgiAIgiAIgiAIgiAIgjiLDxFbueYcSkU2rw4YklsXz92kIf1uqp5S
IWN3jM1GITuqC2d08awuugrZkUpJrVatMeZVy5VStpDzwrT6fFelpI17sM1G
lv3xVre0ZRJlS7rlkdWKmj70X4X1/8AyYrrU1RgXjXDtV7Wi0ccM1ZPjfhIT
OxVyr5rp1AWXxv5giK765ahaebJxCDwpGnPCruCbgyzzfa3+iC6R+MyQunTp
vEjsEGIfmYrHELoM8WxRD0mJL9T0AZ07lVf7NbpTyxyFYgXtIMf9XLYEu8/A
2VhmAnpupZwz5Z6iEWL8yyRyd5b9jo9sSF+ZG++ZQvROYwIrZGqvlNwlk3vg
chiyGx4T6BHQLOwO3/FYZvzGt2LiczG+XYhu5SLvkYMzwt13Rt0TmcBKJX1I
pb9W6SM3Ti5bcrmkjm+8zQY5MDMnuK6/5SKb1PQRObWPDa4lB56OXpxM9E1X
Uns1+oiS6lCojuszTbmX6J0Ki1U7om4eUoOz2MAqObW/Wi3BW5Fo1zLHdeE3
MfYJfJT482Fq+AVDugA1X4h/rLEnG0fJVAfrfyvoainkAraG73io4dlscE16
dA49Or9oJlX6G0gy3OcZ72sk5N/zGD36iphoV+nOHHscqo2p9FNXXk4OPM4G
VkD+rXzK7jNwNrT3VTawOtn3YMQ9iQtv5GNbZHK3kj7IRzelhp5NDT6T8S9V
04dV5ijrX6JQ+7jIRujIUfe9bHB10DWhYsl2n4GzYXxL4f4Pd9+V6HuIC69L
eh7J+BZBCYKCn7m6EIoMW2++CrWfC78LNzz0hdTQczDggmuhO1crRbvPwNlw
oTY2uBLySQ7N4sLrY3+0CtHNfOR9KEG1tst8K5NfKdQBeASE6AcwDdZC1JWX
6heiLdbTanf4jgdSzdQ7KTX8IhdaH+66Q07uynKnMt4F16plmFDI+aDmwHZY
IHbU0u5fRnvnNx6EZP8TdofveMT4p1DhIZ/pkXlw/8NAoQ/GeqZAOWpMgA1a
7bb3L+Oj22BAX13A+BbV688aWBrZG3wTIJNf0t43aon1vs5H3q4lNrIBft6U
f3guRGJHuPsecuApNrC8XohWQO+2N/gmQKEOUpdnh87dnvEthkZcawSXn/97
/kE+vKG28rlwH+wX6k/EUtDe4JsAjTmR6JsecU9k/MsZ35twIZL9T46Zf0h7
qn5p6pdpAjwvXGidvcE3ATn+l6h7Urz3ATa4CjZW8Z5Wom/amPmnry5Mj8xt
rHzC3XeTgzP46GZ7g28CdKm7VnMGZsJdTfROTXoeFePbYFGa8S6ELZgQ2wJN
mfEtgcU/H3qHCbXVGkRoLXHp/tjFySLRbnf4jscQz7OhNUJ8u0zt05hjlklI
iXbYcOlCt0p3yqkOjTmppA/DzldK7CwVeV04q2Y6RWI7LFZlco/d4TufarmQ
8xayIw2LerBaNg3ZbUgXoDQVsl5TGyzoAVO5VP/mK3V9ZuObYrujb07Klgjb
rhz/a6lA57PDuuj652OQf5W8NjTmGBkf8trlMcfI+KALZ6D4NMaY//GkVGBy
/CmdPy1EtsLuzFT68H/expNSIW2qHlgUNf7+2Qy0tKAoiqIoiqIoiqIoiqIo
iqIoiqIoiqIoiqIoiqIoiqIO8i9mnmG0
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmluME2UUgJcY37y9QPQJ9tEQUeKD8YqgMT4oUQgmohhuglyXiIIoIBqF
jWKCYGCBgKyAqBgRTYTCroWVXbsXlt3S+2Xa6XQ691s7M22nFzxtE0JwiS+6
k6nny9fdv+k/yZkzM+f8/3ZbF7fNWXxbS0vLPHhtg1dtjCAIgiAIgiAIgiAI
giAIgiAIgiAIgiAIgiAIgiAIgjiLDxFbueYcSkU2rw4YklsXz92kIf1uqp5S
IWN3jM1GITuqC2d08awuugrZkUpJrVatMeZVy5VStpDzwrT6fFelpI17sM1G
lv3xVre0ZRJlS7rlkdWKmj70X4X1/8AyYrrU1RgXjXDtV7Wi0ccM1ZPjfhIT
OxVyr5rp1AWXxv5giK765ahaebJxCDwpGnPCruCbgyzzfa3+iC6R+MyQunTp
vEjsEGIfmYrHELoM8WxRD0mJL9T0AZ07lVf7NbpTyxyFYgXtIMf9XLYEu8/A
2VhmAnpupZwz5Z6iEWL8yyRyd5b9jo9sSF+ZG++ZQvROYwIrZGqvlNwlk3vg
chiyGx4T6BHQLOwO3/FYZvzGt2LiczG+XYhu5SLvkYMzwt13Rt0TmcBKJX1I
pb9W6SM3Ti5bcrmkjm+8zQY5MDMnuK6/5SKb1PQRObWPDa4lB56OXpxM9E1X
Uns1+oiS6lCojuszTbmX6J0Ki1U7om4eUoOz2MAqObW/Wi3BW5Fo1zLHdeE3
MfYJfJT482Fq+AVDugA1X4h/rLEnG0fJVAfrfyvoainkAraG73io4dlscE16
dA49Or9oJlX6G0gy3OcZ72sk5N/zGD36iphoV+nOHHscqo2p9FNXXk4OPM4G
VkD+rXzK7jNwNrT3VTawOtn3YMQ9iQtv5GNbZHK3kj7IRzelhp5NDT6T8S9V
04dV5ijrX6JQ+7jIRujIUfe9bHB10DWhYsl2n4GzYXxL4f4Pd9+V6HuIC69L
eh7J+BZBCYKCn7m6EIoMW2++CrWfC78LNzz0hdTQczDggmuhO1crRbvPwNlw
oTY2uBLySQ7N4sLrY3+0CtHNfOR9KEG1tst8K5NfKdQBeASE6AcwDdZC1JWX
6heiLdbTanf4jgdSzdQ7KTX8IhdaH+66Q07uynKnMt4F16plmFDI+aDmwHZY
IHbU0u5fRnvnNx6EZP8TdofveMT4p1DhIZ/pkXlw/8NAoQ/GeqZAOWpMgA1a
7bb3L+Oj22BAX13A+BbV688aWBrZG3wTIJNf0t43aon1vs5H3q4lNrIBft6U
f3guRGJHuPsecuApNrC8XohWQO+2N/gmQKEOUpdnh87dnvEthkZcawSXn/97
/kE+vKG28rlwH+wX6k/EUtDe4JsAjTmR6JsecU9k/MsZ35twIZL9T46Zf0h7
qn5p6pdpAjwvXGidvcE3ATn+l6h7Urz3ATa4CjZW8Z5Wom/amPmnry5Mj8xt
rHzC3XeTgzP46GZ7g28CdKm7VnMGZsJdTfROTXoeFePbYFGa8S6ELZgQ2wJN
mfEtgcU/H3qHCbXVGkRoLXHp/tjFySLRbnf4jscQz7OhNUJ8u0zt05hjlklI
iXbYcOlCt0p3yqkOjTmppA/DzldK7CwVeV04q2Y6RWI7LFZlco/d4TufarmQ
8xayIw2LerBaNg3ZbUgXoDQVsl5TGyzoAVO5VP/mK3V9ZuObYrujb07Klgjb
rhz/a6lA57PDuuj652OQf5W8NjTmGBkf8trlMcfI+KALZ6D4NMaY//GkVGBy
/CmdPy1EtsLuzFT68H/expNSIW2qHlgUNf7+2Qy0tKAoiqIoiqIoiqIoiqIo
iqIoiqIoiqIoiqIoiqIoiqIO8i9mnmG0
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Egypt", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmluME2UUgJcY37y9QPQJ9tEQUeKD8YqgMT4oUQgmohhuglyXiIIoIBqF
jWKCYGCBgKyAqBgRTYTCroWVXbsXlt3S+2Xa6XQ691s7M22nFzxtE0JwiS+6
k6nny9fdv+k/yZkzM+f8/3ZbF7fNWXxbS0vLPHhtg1dtjCAIgiAIgiAIgiAI
giAIgiAIgiAIgiAIgiAIgiAIgjiLDxFbueYcSkU2rw4YklsXz92kIf1uqp5S
IWN3jM1GITuqC2d08awuugrZkUpJrVatMeZVy5VStpDzwrT6fFelpI17sM1G
lv3xVre0ZRJlS7rlkdWKmj70X4X1/8AyYrrU1RgXjXDtV7Wi0ccM1ZPjfhIT
OxVyr5rp1AWXxv5giK765ahaebJxCDwpGnPCruCbgyzzfa3+iC6R+MyQunTp
vEjsEGIfmYrHELoM8WxRD0mJL9T0AZ07lVf7NbpTyxyFYgXtIMf9XLYEu8/A
2VhmAnpupZwz5Z6iEWL8yyRyd5b9jo9sSF+ZG++ZQvROYwIrZGqvlNwlk3vg
chiyGx4T6BHQLOwO3/FYZvzGt2LiczG+XYhu5SLvkYMzwt13Rt0TmcBKJX1I
pb9W6SM3Ti5bcrmkjm+8zQY5MDMnuK6/5SKb1PQRObWPDa4lB56OXpxM9E1X
Uns1+oiS6lCojuszTbmX6J0Ki1U7om4eUoOz2MAqObW/Wi3BW5Fo1zLHdeE3
MfYJfJT482Fq+AVDugA1X4h/rLEnG0fJVAfrfyvoainkAraG73io4dlscE16
dA49Or9oJlX6G0gy3OcZ72sk5N/zGD36iphoV+nOHHscqo2p9FNXXk4OPM4G
VkD+rXzK7jNwNrT3VTawOtn3YMQ9iQtv5GNbZHK3kj7IRzelhp5NDT6T8S9V
04dV5ijrX6JQ+7jIRujIUfe9bHB10DWhYsl2n4GzYXxL4f4Pd9+V6HuIC69L
eh7J+BZBCYKCn7m6EIoMW2++CrWfC78LNzz0hdTQczDggmuhO1crRbvPwNlw
oTY2uBLySQ7N4sLrY3+0CtHNfOR9KEG1tst8K5NfKdQBeASE6AcwDdZC1JWX
6heiLdbTanf4jgdSzdQ7KTX8IhdaH+66Q07uynKnMt4F16plmFDI+aDmwHZY
IHbU0u5fRnvnNx6EZP8TdofveMT4p1DhIZ/pkXlw/8NAoQ/GeqZAOWpMgA1a
7bb3L+Oj22BAX13A+BbV688aWBrZG3wTIJNf0t43aon1vs5H3q4lNrIBft6U
f3guRGJHuPsecuApNrC8XohWQO+2N/gmQKEOUpdnh87dnvEthkZcawSXn/97
/kE+vKG28rlwH+wX6k/EUtDe4JsAjTmR6JsecU9k/MsZ35twIZL9T46Zf0h7
qn5p6pdpAjwvXGidvcE3ATn+l6h7Urz3ATa4CjZW8Z5Wom/amPmnry5Mj8xt
rHzC3XeTgzP46GZ7g28CdKm7VnMGZsJdTfROTXoeFePbYFGa8S6ELZgQ2wJN
mfEtgcU/H3qHCbXVGkRoLXHp/tjFySLRbnf4jscQz7OhNUJ8u0zt05hjlklI
iXbYcOlCt0p3yqkOjTmppA/DzldK7CwVeV04q2Y6RWI7LFZlco/d4TufarmQ
8xayIw2LerBaNg3ZbUgXoDQVsl5TGyzoAVO5VP/mK3V9ZuObYrujb07Klgjb
rhz/a6lA57PDuuj652OQf5W8NjTmGBkf8trlMcfI+KALZ6D4NMaY//GkVGBy
/CmdPy1EtsLuzFT68H/expNSIW2qHlgUNf7+2Qy0tKAoiqIoiqIoiqIoiqIo
iqIoiqIoiqIoiqIoiqIoiqIO8i9mnmG0
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Egypt"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-87.83333333333333, 13.433333333333334`}, {-90.1, 
      13.75}, {-89.35, 14.433333333333334`}, {-87.83333333333333, 
      13.433333333333334`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"ElSalvador\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2ntMU1ccB/Buy4iTZJM91DExsmRhbmPo1G3qzKjKlEfrRFaJrwFVFMro
KG9B2oIFBBSGYAEFLJWCbSnYlnfLS9pGodICjkdVpBOYFEWooCjqDmniH879
ocm8Kf6++TT53dNzknPubW/vba6tD9Xd5y0cDkdALwZ6zdTbEu4CAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAHgJebX3AYaemE86NKpLStHTzbGxsdE742Pjd++M
GU0tDx8+VCtLJyYmMJrgrM3khLE4j1HCiTr1R8CjR49MjaKalpCEwrj08qrG
ziczO/+BID9CwE1Kiz/Qoii7NzGK6ZRnT4YHdTmpFLEwi3eSNjkxbmqcnJzc
uD/x+x2cZVuOOu7LnZ6eRl8H1I6OTkVpVtbRgFOpvneNY5hOfDbk/v37cmm2
rJSlvVCCNtG5xTfR991t7y7c/JnT7ypmpkxYeWFjoGK+6wpLd0tKMmVqagp1
a1WIZNJM2bk0dFywXoF552wevaTwyMVmsW5Ad4hzCE/BWztaz/eavzZoHS2x
3NQnlt3wPcXJhmwz74d5dnvs6Bz6tYFrzbLT8cGrW5oKsJ2/WWd4sDeFsVPA
YaKamc1cTFo8x2XO9tDtHiyPpiaepjaqOneD/LRTu5xe11joesjVM8LTgmjx
tffXfDEfDRFxGXERHndGR7Beh1lmevrh5UvVHHYkuqpBm9RIvw9XWy0jL1N3
qVvUdQ1c5+7mwyJBjkBQoJEx5JxNXe2Ktp62z70+t/rBkhyy6/Hjx/q+TllF
fgk3FuulmGVuDl0vzQ9Q1RehOvCPwLmuc23dbEuqZ34FmtV92aKu4uortHjR
YXYdT9rOFv4padChIyWuEy8iLLJ0s6SmU1HPi028bm01xisxz8gqzlSK0ozj
o2ivMpm0jwkfu4W66a+1OfvvdqKtcg23dQ6Z7/Sb1Xckyy+dFqza47Mhhu8Y
zikuoHlEetg4f5KUdOjplSrkJdJYnV/KZZhqN3+3T1csUGvV7d2D3nSqIzkj
gIcjs3HuMTiXINymwDfW7Xr7W3f+uohSXplM06lZbP/BL0G/oIHG8dvHmJ6l
vARMl2KW0bZWySUZqND16z4ifmRNtEZ1cPrldG79jzG5TuEr8NTl3/gGrTyw
/4tA6ZdhvV+FaJOzgncnXDOMjC50W2iz1aZ/qB8NqeTH6S43YrwYc47+hh6/
2YG0m9DV0/dz7LBcdSX1VOgH5yW4vj6L83UL5HxU4J482SMJNozccmfqBVWt
rqT1G4hrBoYG0HDp2SMlhSlYL8L8Ii6Mrik7ZqqXeiy12mzFlba4x90cGDIE
xZ4h871wSiUxhXDc7503zzcuUQj9aT7omodyrJuVp7JytrLfYW8aq5Rz6ssz
sFuHuaZCmIwOganGB+IXbbL2pRftpMTt9guOS2QlpqctWRlptzLNfnnq4tUp
jls8KisEpL2/7/ILIwXl2zrZEMIJprF8TnxuZjR26zDXnD4Rejic+ODBA1SX
FVPXr7PYQFpbXNGxld5/tU/v6b13G2EV/7s3JS4Wgfj3f93nUyaWUI51Hc7V
LiMsdXCYUyPwQmNvG/6qFDBU9TysV2N+uTWsN+38e/cmBq4rlnvbv+f8nne0
0Cs0Oz7h4NTUlOHvnl17iQTXH9POHkTdsk9m+oUwtoTVz3Oet3LfipEhzeit
AYUs90TygcaqXKxXY5apleYLuYmmmpHBiKTTHBzx+8O8n3agsny2l4V1dHaZ
Nv0j9zmsx0dEhbEL2WgT/RywYvxPZ4aY7qAhLxpxcaJEeLy7oxnV9VU5wVTP
bf7En1zWrvFe01A3c1cbeqQiKTUFfRckUqEdyY5EXE+OJqckRWWm+qF3Wxrz
8zMCO9Vw//uSMRrH2y819Pf13NBf0SgzJifvokZ0Ugqg72/TtqG6vEYZxJz5
h1PVqorPijeNQh/7Xi3/QnNZTipFdCYOw/nPmjTVFo7dMfy7XafriQnf8twh
aoXoue2QF02rqjyNRRbz4oxG4zNvoY96s4z9TKNGWSQsiGFF7XxVE5z9Qecc
RgixODfyorL2tkH/X91GDDcaKjI6NKqrPWp0aF7lDF+HaNVyufRECTdWUsSq
FmcN9rcPDQ2Njd4c1F9G7xblMQvYtIwjvld7NfAIxP8Uw9/XezoVCdGeNeKc
nOQdNecyBScPnDo6c6ppqMyuPXd8eLAX6zm+FtGqivt7ldXnTna3yy8oqrCe
zssH8wfAXnOYPwAJAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGbqH/EksY8=
              "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2ntMU1ccB/Buy4iTZJM91DExsmRhbmPo1G3qzKjKlEfrRFaJrwFVFMro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          "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], {
        Style["ElSalvador", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2ntMU1ccB/Buy4iTZJM91DExsmRhbmPo1G3qzKjKlEfrRFaJrwFVFMro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        "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}], 
      "ElSalvador"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.8, 1.}, {9.816666666666666, 2.35}, {11.333333333333334`, 
      2.1666666666666665`}, {11.35, 1.}, {9.8, 1.}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"EquatorialGuinea\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztml9MU3cYho9ZXLLdsN2Y3chiYlhclizbvNh2YWbGFKgb2RLnNk3M2MUw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              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztml9MU3cYho9ZXLLdsN2Y3chiYlhclizbvNh2YWbGFKgb2RLnNk3M2MUw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          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["EquatorialGuinea", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztml9MU3cYho9ZXLLdsN2Y3chiYlhclizbvNh2YWbGFKgb2RLnNk3M2MUw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        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "EquatorialGuinea"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{36.46666666666667, 14.366666666666667`}, {37., 
      17.066666666666666`}, {38.61666666666667, 18.03333333333333}, {
      39.71666666666667, 15.083333333333334`}, {43.11666666666667, 
      12.716666666666667`}, {42.666666666666664`, 12.316666666666666`}, {
      38.833333333333336`, 14.633333333333333`}, {36.46666666666667, 
      14.366666666666667`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Eritrea\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmvlTk0cYx/Fup07v6WEv206L4IEF0ZqCoCIqUioeKIgHVEShqAi0RRHl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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmvlTk0cYx/Fup07v6WEv206L4IEF0ZqCoCIqUioeKIgHVEShqAi0RRHl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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Eritrea", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmvlTk0cYx/Fup07v6WEv206L4IEF0ZqCoCIqUioeKIgHVEShqAi0RRHl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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Eritrea"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{28.03333333333333, 59.483333333333334`}, {
      27.599999999999998`, 57.81666666666666}, {24.1, 57.86666666666667}, {
      23.466666666666665`, 59.21666666666667}, {28.03333333333333, 
      59.483333333333334`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Estonia\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztxrEJgEAQRNEFK7EeMzPTCwWxBbEcKzCwt/Ps4LJFeI8/MGPZ5zJExNJ2
tH2/AgAAAAAAAAAAAADdLlIFAAAAAAAAAAAAANBvOpXZ9kiSJEmSJEmSJEmS
JEmSJOlPrbcSewF2cI8Z
              "], {{0, 0}, {128, 89}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 89}, PlotRange -> {{0, 128}, {0, 89}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztxrEJgEAQRNEFK7EeMzPTCwWxBbEcKzCwt/Ps4LJFeI8/MGPZ5zJExNJ2
tH2/AgAAAAAAAAAAAADdLlIFAAAAAAAAAAAAANBvOpXZ9kiSJEmSJEmSJEmS
JEmSJOlPrbcSewF2cI8Z
          "], {{0, 0}, {128, 89}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 89}, PlotRange -> {{0, 128}, {0, 89}}]], {
        Style["Estonia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztxrEJgEAQRNEFK7EeMzPTCwWxBbEcKzCwt/Ps4LJFeI8/MGPZ5zJExNJ2
tH2/AgAAAAAAAAAAAADdLlIFAAAAAAAAAAAAANBvOpXZ9kiSJEmSJEmSJEmS
JEmSJOlPrbcSewF2cI8Z
        "], {{0, 0}, {128, 89}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 89}, PlotRange -> {{0, 128}, {0, 89}}], "Estonia"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{36.46666666666667, 14.366666666666667`}, {
      38.833333333333336`, 14.633333333333333`}, {42.666666666666664`, 
      12.316666666666666`}, {41.766666666666666`, 11.516666666666666`}, {
      42.95, 11.}, {44.016666666666666`, 9.}, {47.983333333333334`, 8.}, {
      44.95, 4.9}, {41.9, 3.9833333333333334`}, {39.516666666666666`, 
      3.433333333333333}, {35.93333333333333, 4.616666666666666}, {
      32.983333333333334`, 7.933333333333334}, {34.28333333333333, 10.55}, {
      36.15, 12.7}, {36.46666666666667, 14.366666666666667`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Ethiopia\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmntMU1cYwHnMTZEpy9ymDkPKszjZxmMzBOYQx0PCKiMwESMyhquspS3j
VR6FQsvKo1CB8RgKotgWKK+tlCqU0tLWxGj2SMRlWZYZ3bKYzRn3NtG5j9yk
1rYsbPvj9LYn+TU59/Qccs7vnnu+71xKyWOn53m6ubnFwYcPn+XyLcpmDAaD
wWAwGAwGg8FgMBgMBoPBYDAYjGtyI8B3PCqpOLHoIE2QkNmZnNGeQ6srT2Cr
I+JuUrYgH54T80UIFVR70+fdGOftsilfXZbIvh7oh3yozkd9PN2LrrUSTpcI
NhfPWFU+na86FZ2GfMBOA+wqua/X2l3wFz7eE8mT2vvKxN9zFPnIV8/9y1n3
z1MckxxxE2EVlro7w2Tp2TCV9HLNkGUNNPAvmyTKNT0lyAe/WhzVf8sJhtnt
7rrjc+OpT3BmzTWaidTo2kHz5ZZiFTRIFvaYaxTy/cinQF7/F5XxnkyjWeYj
TMNPuh3vHqvzLZ0mamYUabH8k0SZJur8QRsGDdaxdOYu61na7zThyCdCUv+7
6gasNvYz0oNnx/YpR9Mru8s9mMasZrFf6UcgvHswH9pPK954tmTaNkYjnwgZ
/Z8do9kG1jeb2u4YAhnt/LumgMWpZJD/fNXw0kzsLd1zvJ4S9di+CJtwDE/N
1dko5NMhnf+3Wxts/W/gzIP/jEbJq3X932oibutC/zQEEcte3M+4OveSueWj
hYsQCALKl2Ox4EMO8umQy/9fJgqR2Lf1F0yOZEIKZA6758Zpp6WHHmfP57W+
D+ah8ag8Cy6/nt0p6S/wZmkzmyQyWfb1uYiBocPUCgV0Ca1QIJ8Rufx/M/tg
JYNDbhcXUk3IbZ4pVkP8hSD71bmd0AZSzaJOHjwRUAm9XuEPHGkTwg3KbhF7
sRbMf8GDYbxr9Ec+KRL5X5hMsd18IL1cW6jrGKBDg2HZgY0cDVEfXi0V9BVB
Jchf6dXE9/MvIp8UifzLpNm2DoMrxi8pd/+qp8Jqz5c8FB0+V+26rI79wxA8
Is/y4czZ9l1SxyKfFIn8QyZjJfAdieC3xZBPVXGwHbHaayDswp5PfAVBFrpA
ahRWNXJFHQNROIY/iNf//+GT6bgHZyi2Nq7+RHpjO2z1ScIeKMPiJ4TDhg+X
EHD5vcUpwm4ovybog7AL2WlNb4knw4D3///Gbf32NcxFUBfJk36pjrbbRi7L
1kyk2tafHDr8VqvoZ32ofmrvtlLl8sbFHUM+I3L5Byxf49hS3sUFw48V6iHz
h2Q1UdD7D4253Vzk0yGd//7TuXZl+pZOszt4EIuhDew5hR21kI6uYRqOHquH
E4HdLpeU8cinQzr/d4xBlLIpK5PuDBOcAog30kszsV2DR3STe0+dOQSX2ytH
f9SGvVAlt+qSIOhFPhcy+geG5QesZELmMzWaQZQb+thwLrtn9KeJOoma3FYR
nMs2cB76B+VFx1/8juofyGputTwIX5uLhCMwcRlaoYCM6JdFKhzKzG0g+I4P
Z5Jp53ds/78bgsOrZeYFDzmn5dpWjaXBgcuyxou18N4H1UQ5paH7nsmx006H
9w/c1O1YKRcSHWftt3hALMlvE8K9Qz74VZIz4BsqXuuwUFvWPVWd5860/uVJ
EHfCm2X9owhPlnIrPwX5mP8VDu6fILBxqw+3yqNQs1Ke78lSbaqihzT7IB+q
U/onoLZ4b6uPebKyYGM5b32JxLtUDDcFtPsJo+AxQT48p/fvlGD/2L8rg/1j
/64M9o/9uzLYP/bvymD/2L8rg/1j/64M9o/9uzLYP/bvymD/iP0PBiMfgytz
5cZnF67pMaj4GzTxmt4=
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmntMU1cYwHnMTZEpy9ymDkPKszjZxmMzBOYQx0PCKiMwESMyhquspS3j
VR6FQsvKo1CB8RgKotgWKK+tlCqU0tLWxGj2SMRlWZYZ3bKYzRn3NtG5j9yk
1rYsbPvj9LYn+TU59/Qccs7vnnu+71xKyWOn53m6ubnFwYcPn+XyLcpmDAaD
wWAwGAwGg8FgMBgMBoPBYDAYjGtyI8B3PCqpOLHoIE2QkNmZnNGeQ6srT2Cr
I+JuUrYgH54T80UIFVR70+fdGOftsilfXZbIvh7oh3yozkd9PN2LrrUSTpcI
NhfPWFU+na86FZ2GfMBOA+wqua/X2l3wFz7eE8mT2vvKxN9zFPnIV8/9y1n3
z1MckxxxE2EVlro7w2Tp2TCV9HLNkGUNNPAvmyTKNT0lyAe/WhzVf8sJhtnt
7rrjc+OpT3BmzTWaidTo2kHz5ZZiFTRIFvaYaxTy/cinQF7/F5XxnkyjWeYj
TMNPuh3vHqvzLZ0mamYUabH8k0SZJur8QRsGDdaxdOYu61na7zThyCdCUv+7
6gasNvYz0oNnx/YpR9Mru8s9mMasZrFf6UcgvHswH9pPK954tmTaNkYjnwgZ
/Z8do9kG1jeb2u4YAhnt/LumgMWpZJD/fNXw0kzsLd1zvJ4S9di+CJtwDE/N
1dko5NMhnf+3Wxts/W/gzIP/jEbJq3X932oibutC/zQEEcte3M+4OveSueWj
hYsQCALKl2Ox4EMO8umQy/9fJgqR2Lf1F0yOZEIKZA6758Zpp6WHHmfP57W+
D+ah8ag8Cy6/nt0p6S/wZmkzmyQyWfb1uYiBocPUCgV0Ca1QIJ8Rufx/M/tg
JYNDbhcXUk3IbZ4pVkP8hSD71bmd0AZSzaJOHjwRUAm9XuEPHGkTwg3KbhF7
sRbMf8GDYbxr9Ec+KRL5X5hMsd18IL1cW6jrGKBDg2HZgY0cDVEfXi0V9BVB
Jchf6dXE9/MvIp8UifzLpNm2DoMrxi8pd/+qp8Jqz5c8FB0+V+26rI79wxA8
Is/y4czZ9l1SxyKfFIn8QyZjJfAdieC3xZBPVXGwHbHaayDswp5PfAVBFrpA
ahRWNXJFHQNROIY/iNf//+GT6bgHZyi2Nq7+RHpjO2z1ScIeKMPiJ4TDhg+X
EHD5vcUpwm4ovybog7AL2WlNb4knw4D3///Gbf32NcxFUBfJk36pjrbbRi7L
1kyk2tafHDr8VqvoZ32ofmrvtlLl8sbFHUM+I3L5Byxf49hS3sUFw48V6iHz
h2Q1UdD7D4253Vzk0yGd//7TuXZl+pZOszt4EIuhDew5hR21kI6uYRqOHquH
E4HdLpeU8cinQzr/d4xBlLIpK5PuDBOcAog30kszsV2DR3STe0+dOQSX2ytH
f9SGvVAlt+qSIOhFPhcy+geG5QesZELmMzWaQZQb+thwLrtn9KeJOoma3FYR
nMs2cB76B+VFx1/8juofyGputTwIX5uLhCMwcRlaoYCM6JdFKhzKzG0g+I4P
Z5Jp53ds/78bgsOrZeYFDzmn5dpWjaXBgcuyxou18N4H1UQ5paH7nsmx006H
9w/c1O1YKRcSHWftt3hALMlvE8K9Qz74VZIz4BsqXuuwUFvWPVWd5860/uVJ
EHfCm2X9owhPlnIrPwX5mP8VDu6fILBxqw+3yqNQs1Ke78lSbaqihzT7IB+q
U/onoLZ4b6uPebKyYGM5b32JxLtUDDcFtPsJo+AxQT48p/fvlGD/2L8rg/1j
/64M9o/9uzLYP/bvymD/2L8rg/1j/64M9o/9uzLYP/bvymD/iP0PBiMfgytz
5cZnF67pMaj4GzTxmt4=
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Ethiopia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmntMU1cYwHnMTZEpy9ymDkPKszjZxmMzBOYQx0PCKiMwESMyhquspS3j
VR6FQsvKo1CB8RgKotgWKK+tlCqU0tLWxGj2SMRlWZYZ3bKYzRn3NtG5j9yk
1rYsbPvj9LYn+TU59/Qccs7vnnu+71xKyWOn53m6ubnFwYcPn+XyLcpmDAaD
wWAwGAwGg8FgMBgMBoPBYDAYjGtyI8B3PCqpOLHoIE2QkNmZnNGeQ6srT2Cr
I+JuUrYgH54T80UIFVR70+fdGOftsilfXZbIvh7oh3yozkd9PN2LrrUSTpcI
NhfPWFU+na86FZ2GfMBOA+wqua/X2l3wFz7eE8mT2vvKxN9zFPnIV8/9y1n3
z1MckxxxE2EVlro7w2Tp2TCV9HLNkGUNNPAvmyTKNT0lyAe/WhzVf8sJhtnt
7rrjc+OpT3BmzTWaidTo2kHz5ZZiFTRIFvaYaxTy/cinQF7/F5XxnkyjWeYj
TMNPuh3vHqvzLZ0mamYUabH8k0SZJur8QRsGDdaxdOYu61na7zThyCdCUv+7
6gasNvYz0oNnx/YpR9Mru8s9mMasZrFf6UcgvHswH9pPK954tmTaNkYjnwgZ
/Z8do9kG1jeb2u4YAhnt/LumgMWpZJD/fNXw0kzsLd1zvJ4S9di+CJtwDE/N
1dko5NMhnf+3Wxts/W/gzIP/jEbJq3X932oibutC/zQEEcte3M+4OveSueWj
hYsQCALKl2Ox4EMO8umQy/9fJgqR2Lf1F0yOZEIKZA6758Zpp6WHHmfP57W+
D+ah8ag8Cy6/nt0p6S/wZmkzmyQyWfb1uYiBocPUCgV0Ca1QIJ8Rufx/M/tg
JYNDbhcXUk3IbZ4pVkP8hSD71bmd0AZSzaJOHjwRUAm9XuEPHGkTwg3KbhF7
sRbMf8GDYbxr9Ec+KRL5X5hMsd18IL1cW6jrGKBDg2HZgY0cDVEfXi0V9BVB
Jchf6dXE9/MvIp8UifzLpNm2DoMrxi8pd/+qp8Jqz5c8FB0+V+26rI79wxA8
Is/y4czZ9l1SxyKfFIn8QyZjJfAdieC3xZBPVXGwHbHaayDswp5PfAVBFrpA
ahRWNXJFHQNROIY/iNf//+GT6bgHZyi2Nq7+RHpjO2z1ScIeKMPiJ4TDhg+X
EHD5vcUpwm4ovybog7AL2WlNb4knw4D3///Gbf32NcxFUBfJk36pjrbbRi7L
1kyk2tafHDr8VqvoZ32ofmrvtlLl8sbFHUM+I3L5Byxf49hS3sUFw48V6iHz
h2Q1UdD7D4253Vzk0yGd//7TuXZl+pZOszt4EIuhDew5hR21kI6uYRqOHquH
E4HdLpeU8cinQzr/d4xBlLIpK5PuDBOcAog30kszsV2DR3STe0+dOQSX2ytH
f9SGvVAlt+qSIOhFPhcy+geG5QesZELmMzWaQZQb+thwLrtn9KeJOoma3FYR
nMs2cB76B+VFx1/8juofyGputTwIX5uLhCMwcRlaoYCM6JdFKhzKzG0g+I4P
Z5Jp53ds/78bgsOrZeYFDzmn5dpWjaXBgcuyxou18N4H1UQ5paH7nsmx006H
9w/c1O1YKRcSHWftt3hALMlvE8K9Qz74VZIz4BsqXuuwUFvWPVWd5860/uVJ
EHfCm2X9owhPlnIrPwX5mP8VDu6fILBxqw+3yqNQs1Ke78lSbaqihzT7IB+q
U/onoLZ4b6uPebKyYGM5b32JxLtUDDcFtPsJo+AxQT48p/fvlGD/2L8rg/1j
/64M9o/9uzLYP/bvymD/2L8rg/1j/64M9o/9uzLYP/bvymD/iP0PBiMfgytz
5cZnF67pMaj4GzTxmt4=
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Ethiopia"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.03333333333333, -52.016666666666666`}, \
{-59.21666666666667, -51.4}, {-61.03333333333333, -52.016666666666666`}}, \
{{-59.71666666666667, -52.11666666666667}, {-57.733333333333334`, \
-51.699999999999996`}, {-59.71666666666667, -52.11666666666667}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"FalklandIslands\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmgdUU2nax8OIwq5umfOd2dmdnXGKZ3fUT8exreK4jjRBkCrqWEaQEnqQ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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmgdUU2nax8OIwq5umfOd2dmdnXGKZ3fUT8exreK4jjRBkCrqWEaQEnqQ
ooB0LKhUaQEh9BJAagggIZBCKCEJ0qQEIYmAggoiRaqzTzYMJez6SXHzZTb3
/OHk5L7leX7/N+99773vl4Y2uoZrEAjEYfjzhD/+ZwQCKZFEEkkkkUQSSSSR
RBJJJJFEEkkkkUS/VKmoBMXFkfz9cw8d8p39UlbWYvNmd3X1EBQKGxBQHBdH
CAvLCgrKv3EDb2AQu22b55o1prOFv/3WOzCQgMGU7tlzXeTpiJe2bvWIiowo
TIokY/wzAjxdL4dbW6cmJuBL83MIaXHJQTeSb7n4ofRDLU8F6Kt5HP8+8LxK
NPJYNFIj2vJEiJu7vx+eQGAWYhMyfV19TE6WEmpEnpF4KTm5xMfN2VppV1t2
FMHHBuNmjYtHF8YEp/i6375oHGhrSA52DbE8HWqqh1Te66Qhh0NpuKruMJf7
6qrCJme5Txy/+8L3nDIh0KXslq2PlYHVD5pHjgSJPClxEcwbWCy2/F4cUv7b
tGAfal56cnhg1C2vQBf7u16X465eyg9wS/FEhTsY37Y6H2BxOtxIPQ+lFai3
/5b6jkt//9JR7s8m//uhydfrr+z6/dWzR308XFjZ8R62ziLPS1yERpcVFxf3
0InhztbVZGJSZFiE3w1CSjQ25GZGzN1ETMod/2Tf2wVx8RXpxS30usd5uRW+
1yIifXzvBXglWGqjj/7FZd/HJ79a775dNnC3DNrbiUfKASM2bXIReWpiodjY
Qh6P94ROxEUHMSsoob4+RYkRUWY6/kba69aZgy5fzozNrc+t63vz5ic4evpH
m9t6zcyS1q41d3fPiLjuFoXUCpf/xPivsph9sjGok9zSrCTUCR2dEJGnJhZS
UPDPzMzOTYrpetT6euBZXkZahJ0B7sy3wTq7YS1USGzBMZ9MTP0T/byD0zuM
L2yMisrr57J7H5SHujugz36fdEA2Uv7jUOszQV63wTiRpyYuiokpYrPZr0eG
MaFB6YlYX321/HO77rkYR+Y0fuxSscOP5VvW1dXR3l1f9biW2sdpu9/Svyew
dqMjmc3rBct6a6lRQX4UUtUVtT3x+2X9jn2zZYubyJMSI3344UUcjpiamvqU
RakKd484d5gRaB+URkLYUUFbrGP9rPWr3bRr3LVAdFfNWJTuj1bOUvaUtfaU
h9y+l50P72el0XHY2ggPy71/1layF3lGYqedO6/6+fnBTFIfc70oyC3rPk0A
/xuLiDwH7WoXDbyNEsDPslQotjsCH2hO6tesLqy3vb/GjlzfxiHi87oqCmvR
bilBt2RkLESejjgKgylg3s8hxwaRquo+sOfD/51VXo6dOhb5fbmzRoT+oWzH
U5HWx/EOmvdtVaiOahQntTtWp6XsydK2FCqjoaeakO7rcuECRuSJiKk2bnQK
Cc5saev5xJkP/zNvemJYUL61PMFJC33VRcXU08TI9NMTVxUdoq5bGrD8kKGn
/0a+dFTPwgMK/8GWUFvb4uSAkZISfSLiKy8v3MTkdFFLf2xp0+P2ZpyjHs1Z
A3vzUguzopqQH+2E9PW5ya5jFCbezb/jgnPSybE+grE+ftAhRvVylG/qg/Pn
Y0SegvhqzRrTDl7/xNhrSnIoLhWTedWcHuoQZqaDT0CPjY40VlOibU5lon17
OO0NlaRoJ8M4R4PMi8eyLmqkWavlXjk7PTVV39QjGf/L1unTURNTUw2ErEw3
g8rs+F5OS2dzfTDqTHxIACz42+tZISYa+LjQwf7njVXUCIcLgc7WeVfNc5xP
F1zWTXc4MTU1CcVsbdNEnoiYKim1xsbEKBcTQkoIHhkafPJq/JSFvbuh3IGz
ZidiGsj4jCjLw4VJ4aMT027XPFwM5DRNTH5lVxKOZ/U0s+pzojs6OXYZrcEh
RJEnIo7asME6Lq9RxhK3+byP/h38j8FF650qzlwwdNQ95KSvqmvmhDT7AW2+
O9ZT8RzK5qSB8aXzKvamOgqnDOHi+3c/2gVM9a+d+EtW/+iK3/4WJfJ0xE5b
t3qcCagAgGtsSjYgU6Vsyf9jGN2MU0wLVSOlHNlgnVuKVUu5fsA5APWVTTQJ
q3IvQiMhSHWToR9U2YDECm4WQOpX7kvevyxDysqBdimNAoYA/zfGSbJWuIJI
+dHK76aZh7bYRWfbfN0UuqPxzo6v7TCMbOVByoGXlAOnvaM2WGavsSHO8je4
U3niRKTI0xE7GRjEwtWz8ckIMp39K0fa710qnePLaJmYBFt1ZrIJJcWlIFiZ
5rl1iHQgKuVmro9Zut33jEilqnQ7CvPh5psMIH8wpI7WOQiNODtnLSOAV2Vl
LYcOMRAIvqSlOw0MxtrbmUyuuvpynqNqa4dDJCO1tTMNzhN8CaegwDKahWAg
JKFHka/I5JbDh1fI39k1d7bBFyOTA6P8xUxJzK0c18P05PMPSnI6WNQcD7Xi
MCNytBUlK6Y8UrMGa1uMdh3sezI5/ebh05HZ6gEBhGUEIKg7SCS2HDw454Kh
4VhHR2XlI/h5ipY/BABhCJEfolJbFRQEza6Qv6MnXqjxp411jZdsaDqKpKSg
ZlpRLQ5dHqxIjzncSM3rIBPLLM9lBqDIGaE/LTruBC9nCTS/hcHi4mY5uTkX
jIzGOjvJ5Nb5ewP+Y/yhU+hamHxFRauy8mybKx//tm64T73oIdSe2S5Gx8dc
En0Vj3/zmdH+EHw8OymmVPlv9eXER6xKUuE9W7XtG09uM0W7DL2eG/nPhieM
09g29hnLCGBxji+Lipr37RMkyFy7lmNiMsbhEAgP9+/3+c/wh46gO6Gohquq
2lRUZltrlZd/RSJB8Cvkb++RL7iAqt5tTGT0JtIa96LUEaqfIhQ/QWh8jtD+
QsnjXEwxFluO+zHITlp3E0LnS4TSnxDHNn58bpdrUkBubXsAueuPHtXQgvXF
9OXFAL/xqqoOYRcKCh7u3TvnAhI5zuXi8fW7dl17f/yhcehCmDyd3nb06Bx5
BQWY+SHgpc6N/1IOP/OfkZ4eQv0zhNpf12nJyWjtQWh+zgcukNpGhOpn/A/a
X/CtObYRcexzhNY+hFWOoK6VzTL5C6ShEVpbyxN2IT//4e7dMy6sW8cxMxvn
8bKyWNu3e60uf2gQmhUmz2Cw1dXnyCsqvqJQIEgIdeXkBbrshV/AX1MboauP
sMLdTC31Tb3/wY/XET+gEDqnESfPI078gDiF/NTCV93JEXHO809GVlIn9RHH
dREmmJ/5r/QRhJQUUk8voqmpW4jDQG5u086dsy5wzc3HeDwslr55s/vK+UMj
0NSbNwvetI6wWGxNzTnySkpwzYXAILzVfdLl5L2Qvy3/5ZfMJUo6vgSO726R
F5y1o66/TE3NJ0rZU60wZUKnLFHYVQnpgw9Mz56NZrN7hV3Izm7asWPGBRkZ
rqXlKJcXH18xf8fFkvhDRag+NTW9gPyDB+3a2nPklZWHysshGAgJAltF8gJd
uVYohPEvXpTonNKSn4/YHCKBwP8Qn0v0Ti71S5s5lVlA/OjKgooW1qvDXyBp
aTMjo3gO5/l8ODBK+zMzm7Zvn3PBygpciIqibtzo9O78oTBUmZycmt/4aH19
u64uQ0pKUL7tyJEhGg0CgDAgmFUnL5DL9SIh+CQypa6urrKykkwml/ybg0aj
VVVVGd8lza9rbpm66uGtW2duYZHc3T0g7EJGRuO2bTMuyMryUKhhDi80tPTC
hbi384cCUGx8fHIB+YaGdj29OfIqKrDOhE6h6/e9ncPtxgL+gBTwcrncly9f
9vT0sFgsQD04ONjW1lZaWkqlUuEsWMPj8R49euSZVLpy/ocP+/2fgpVGWFjZ
wMCIkAsvsFgYpbAIB7WpqsIEJQD7Fv4TEwvG/PT4eB8aDYtJQSPgwlBlJXQE
3UGn7xLbCvl73Cyez9A/nT+9EIlEJpPZ3Nzc29v75MkTyBS86Orqevz4MYPB
ADv4ub94EZBOnF/XzCJlGQH89B6Ot/Bf9WOF/L1uLeCPzSdyOBwY7YB9enr6
zcJjcnLy9evXgs/wIbuwRMqOMlvX1Dx5GQG8KitbdT2LilrMH758H32tkL/3
7QX884qI5eXlnZ2dMOCBNnCemJiA/7NeTE1NjY+PC76vrq6Wtp/jjzRLWkYA
i0GJl1bI/5pfySzA3znBBE/t6+sbHR19+vTpAMyDIyNgB0w1YAfM+c+ePWOz
2Y2NjfAbganpXknlfO+QphL+S9aNAD7/c7G1eeSajCISzPwdHR3d3d3Dw8Ot
ra0AHy4HdDq9oaEBTsGah0QiwaUB/lfRaxT8FtwdmCATJfyXqpuB/DVMYW0n
TPgwyIH82NhYU1NTTU0NhUKNzCq9klB2Hi2sk6Gkj65Q5sPnr51MJPyXrFtB
/DXMH9wq8CxOZGQErCqfP3/e0tJSWErd4i188/t2GRnHS/gvVb7Bc48REmmP
YOaHKyyT3fORa8WS4P+Tf4KE/1LlH7rgMY5SCOO7wJqlkhfI0HA54/+/fP0Z
GLa0SeYtglv7ZQTwPu6JxOj+S1X1jqdn3qroXd5PLda73OOD7OzS6+u7hior
2/X0BM8KWuXl+9Do6fHxJfGHO5eB7Ow2VdWZpxZHjrzAYoUePkNH0N07BrZC
/v//pagYQKWyhyoq5l7/SUmBC6MNDULY6fROb+/8t/OHAlBsAm5nUCimrKzg
VOO2bf0ZGUIuQKfQtcjTF6EUFPwplLYhGg1G6Rx5Xd3ReuFXhIBUsF/lHZ8/
Q2GoMt7dzbWyYsrICAo0bd/en5kp5AIEAGGIHIVoyJeXz99s0K6tPfLggRD5
mprO+TuFlvT+BSpC9fGuLq6l5ZwLO3bABCXUy3+PC/Ly/mRyK3+DjZLSLDq2
puYIS/jlLKA7dkx4j9Yy3j9CI3wXHj/mmpsz162bcWHnzoHcXKEeITAIT+SI
3pPgWgYJvqJQWhUV58irqw8zGEIcGAzOYvLL5j/rAjQ7zuNxzMxmXXi4e/fL
/PzFLvzCLruQDonU+goS+3lTGajt6NFhOn0x+bfvPVjh/hNonO8Cl8tBIplr
1864sHfvy4ICoUgg4F+GC3zy8CcvP0deRWW4qkooXyaT+y67PlZl/xV0BN2N
cTgcE5NZF5r37XtZVLTYBZEDXKFgET6LiL/ZoKJiMXlNzXfdb7OK+w+hU74L
nZ2dRkYMaekZF+TkBouL54cncoAr1Ax5BQW45gqRZ7G4WlphS2pt1fffQgAQ
xlhHR6eh4awLLQcPDhKJvwz+MP5h5l85+ffEf4EL7e2dBgZzLhw6tPLnPyLX
PwDqVS1B
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["FalklandIslands", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmgdUU2nax8OIwq5umfOd2dmdnXGKZ3fUT8exreK4jjRBkCrqWEaQEnqQ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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "FalklandIslands"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-7.23855, 62.3179}, {-7.20545, 62.3359}, {-7.17975, 
       62.3343}, {-7.1105, 62.293}, {-7.03695, 62.2456}, {-6.98545, 
       62.235}, {-6.95355, 62.208}, {-6.95235, 62.177}, {-6.9401, 
       62.1647}, {-6.88125, 62.1484}, {-6.86225, 62.1251}, {-6.861, 
       62.0932}, {-6.8365, 62.076}, {-6.7985, 62.0589}, {-6.7519, 
       62.009}, {-6.747, 61.9542}, {-6.77215, 61.9448}, {-6.83345, 
       61.9456}, {-6.86775, 61.9612}, {-6.9033, 62.0102}, {-6.9609, 
       62.0601}, {-7.0541, 62.1295}, {-7.1908, 62.188}, {-7.25575, 
       62.2264}, {-7.26555, 62.2485}, {-7.257, 62.3}, {-7.23855, 
       62.3179}}, {{-6.95935, 61.7034}, {-6.9182, 61.7034}, {-6.90445, 
       61.6963}, {-6.9075, 61.6759}, {-6.9159, 61.6632}, {-6.9113, 
       61.65}, {-6.8366, 61.6449}, {-6.78475, 61.6307}, {-6.771, 
       61.6205}, {-6.77405, 61.6022}, {-6.80915, 61.5799}, {-6.80915, 
       61.5666}, {-6.77405, 61.5483}, {-6.77255, 61.5372}, {-6.80915, 
       61.5138}, {-6.81675, 61.5036}, {-6.80455, 61.4945}, {-6.7893, 
       61.4955}, {-6.7588, 61.5036}, {-6.7405, 61.5046}, {-6.73285, 
       61.4985}, {-6.7344, 61.4619}, {-6.7298, 61.4324}, {-6.697, 
       61.4156}, {-6.69245, 61.3994}, {-6.70615, 61.3923}, {-6.75345, 
       61.3943}, {-6.7824, 61.4156}, {-6.8297, 61.4339}, {-6.8617, 
       61.4421}, {-6.8861, 61.4634}, {-6.89375, 61.4929}, {-6.94255, 
       61.5377}, {-6.9456, 61.5631}, {-6.95935, 61.5783}, {-7.02035, 
       61.5987}, {-7.03405, 61.6119}, {-7.0356, 61.6373}, {-6.9967, 
       61.6805}, {-6.95935, 61.7034}}, {{-7.0577, 62.3922}, {-7.0135, 
       62.3973}, {-6.97385, 62.3861}, {-6.8442, 62.3129}, {-6.8274, 
       62.3007}, {-6.8259, 62.2875}, {-6.8335, 62.2682}, {-6.81825, 
       62.258}, {-6.77405, 62.259}, {-6.75115, 62.2509}, {-6.73285, 
       62.2366}, {-6.742, 62.2255}, {-6.7603, 62.2133}, {-6.76185, 
       62.2051}, {-6.73135, 62.1858}, {-6.7039, 62.1655}, {-6.7039, 
       62.1472}, {-6.71915, 62.0973}, {-6.7481, 62.0984}, {-6.7786, 
       62.1258}, {-6.7969, 62.1685}, {-6.8152, 62.1807}, {-6.8335, 
       62.1797}, {-6.8564, 62.1634}, {-6.8747, 62.1634}, {-6.8869, 
       62.1777}, {-6.893, 62.2061}, {-6.91895, 62.2316}, {-6.9723, 
       62.26}, {-7.04245, 62.2875}, {-7.076, 62.3129}, {-7.09735, 
       62.3403}, {-7.0882, 62.3658}, {-7.0577, 62.3922}}, {{-7.4611, 
       62.2007}, {-7.39305, 62.1995}, {-7.28765, 62.1888}, {-7.2006, 
       62.1504}, {-7.12825, 62.1096}, {-7.12395, 62.0887}, {-7.12765, 
       62.0642}, {-7.1742, 62.0487}, {-7.3017, 62.0536}, {-7.3348, 
       62.0683}, {-7.3569, 62.092}, {-7.3471, 62.1034}, {-7.33235, 
       62.1181}, {-7.3348, 62.132}, {-7.38755, 62.1484}, {-7.4574, 
       62.1672}, {-7.47885, 62.1823}, {-7.47885, 62.1953}, {-7.4611, 
       62.2007}}, {{-6.97955, 61.9505}, {-6.89775, 61.948}, {-6.75885, 
       61.9125}, {-6.70935, 61.8833}, {-6.70175, 61.8643}, {-6.70175, 
       61.8275}, {-6.7246, 61.8123}, {-6.75695, 61.8097}, {-6.7874, 
       61.8237}, {-6.8159, 61.8516}, {-6.83115, 61.8567}, {-6.8597, 
       61.8567}, {-6.8825, 61.8503}, {-6.92625, 61.8313}, {-6.9548, 
       61.8313}, {-6.97575, 61.8402}, {-6.98335, 61.8579}, {-6.98525, 
       61.896}, {-6.99665, 61.9188}, {-6.99665, 61.9391}, {-6.97955, 
       61.9505}}, {{-6.62915, 62.3576}, {-6.61085, 62.3576}, {-6.59105, 
       62.3383}, {-6.5712, 62.3088}, {-6.54985, 62.2946}, {-6.5331, 
       62.2885}, {-6.5148, 62.2539}, {-6.51175, 62.2326}, {-6.5163, 
       62.2214}, {-6.5346, 62.2183}, {-6.5529, 62.2336}, {-6.5651, 
       62.2468}, {-6.5773, 62.2499}, {-6.59105, 62.2448}, {-6.59865, 
       62.2244}, {-6.6139, 62.2143}, {-6.6322, 62.2163}, {-6.65205, 
       62.2488}, {-6.6368, 62.2895}, {-6.6261, 62.3149}, {-6.6307, 
       62.3526}, {-6.62915, 62.3576}}, {{-6.60095, 62.4192}, {-6.5781, 
       62.4161}, {-6.55215, 62.3876}, {-6.53385, 62.3744}, {-6.50945, 
       62.3622}, {-6.4835, 62.3602}, {-6.47435, 62.351}, {-6.482, 
       62.3338}, {-6.5018, 62.3277}, {-6.5415, 62.3297}, {-6.5781, 
       62.349}, {-6.6147, 62.3785}, {-6.6162, 62.3978}, {-6.60705, 
       62.412}, {-6.60095, 62.4192}}, {{-6.73215, 62.0532}, {-6.68025, 
       62.0562}, {-6.6513, 62.044}, {-6.6406, 62.0023}, {-6.6467, 
       61.9749}, {-6.6711, 61.9606}, {-6.7001, 61.9677}, {-6.73215, 
       61.9952}, {-6.7367, 62.041}, {-6.73215, 62.0532}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"FaroeIslands\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3bFKQlEAh/ELhpubL9B2wdAlrKlB3yBoEwLXhugJjFodgoaGQBDcHOwN
6gGKNqOlqa2HuN01aziRec7l+z74j8I997ddDrg9PD0c1rIsG5Q7L7dVrkio
59ePItu/+bJG96p4yfOg5bsX336/eHiLfSwLTH92+rPTn53+7PRnpz87/dnp
z05/dvqz05+d/uz0Z6c/O/3Z6c9Of3b6s9Ofnf7s9GenPzv92enPTn92+rPT
n53+7PRnpz87/dnpz05/dvpvvvun92R2e7dcu//l5DH6uVLe6vtKbX/1d9We
/uzpz57+/7uTznHSO+sMgv1H7aPoz1u1hb5b55xzzjnnnHPOOVfNTXf6SW/W
6gWfZd46iP68VVvs789+/3f6O/2d/k7/zS72/UPvf8ZdSnn/m53+7PRnpz87
/dnpz05/dvqz05+d/uz0Z6c/O/3Z6c9Of3b6s9Ofnf7s9GenPzv92enPTn92
+rPTn53+7PRnpz87/dnpz05/dvqz05+d/ux+8q/vXQf/l0mzO9b/l30C/rVd
yg==
              "], {{0, 0}, {128, 92}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 92}, PlotRange -> {{0, 128}, {0, 92}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3bFKQlEAh/ELhpubL9B2wdAlrKlB3yBoEwLXhugJjFodgoaGQBDcHOwN
6gGKNqOlqa2HuN01aziRec7l+z74j8I997ddDrg9PD0c1rIsG5Q7L7dVrkio
59ePItu/+bJG96p4yfOg5bsX336/eHiLfSwLTH92+rPTn53+7PRnpz87/dnp
z05/dvqz05+d/uz0Z6c/O/3Z6c9Of3b6s9Ofnf7s9GenPzv92enPTn92+rPT
n53+7PRnpz87/dnpz05/dvpvvvun92R2e7dcu//l5DH6uVLe6vtKbX/1d9We
/uzpz57+/7uTznHSO+sMgv1H7aPoz1u1hb5b55xzzjnnnHPOOVfNTXf6SW/W
6gWfZd46iP68VVvs789+/3f6O/2d/k7/zS72/UPvf8ZdSnn/m53+7PRnpz87
/dnpz05/dvqz05+d/uz0Z6c/O/3Z6c9Of3b6s9Ofnf7s9GenPzv92enPTn92
+rPTn53+7PRnpz87/dnpz05/dvqz05+d/ux+8q/vXQf/l0mzO9b/l30C/rVd
yg==
          "], {{0, 0}, {128, 92}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 92}, PlotRange -> {{0, 128}, {0, 92}}]], {
        Style["FaroeIslands", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3bFKQlEAh/ELhpubL9B2wdAlrKlB3yBoEwLXhugJjFodgoaGQBDcHOwN
6gGKNqOlqa2HuN01aziRec7l+z74j8I997ddDrg9PD0c1rIsG5Q7L7dVrkio
59ePItu/+bJG96p4yfOg5bsX336/eHiLfSwLTH92+rPTn53+7PRnpz87/dnp
z05/dvqz05+d/uz0Z6c/O/3Z6c9Of3b6s9Ofnf7s9GenPzv92enPTn92+rPT
n53+7PRnpz87/dnpz05/dvpvvvun92R2e7dcu//l5DH6uVLe6vtKbX/1d9We
/uzpz57+/7uTznHSO+sMgv1H7aPoz1u1hb5b55xzzjnnnHPOOVfNTXf6SW/W
6gWfZd46iP68VVvs789+/3f6O/2d/k7/zS72/UPvf8ZdSnn/m53+7PRnpz87
/dnpz05/dvqz05+d/uz0Z6c/O/3Z6c9Of3b6s9Ofnf7s9GenPzv92enPTn92
+rPTn53+7PRnpz87/dnpz05/dvqz05+d/ux+8q/vXQf/l0mzO9b/l30C/rVd
yg==
        "], {{0, 0}, {128, 92}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 92}, PlotRange -> {{0, 128}, {0, 92}}], 
      "FaroeIslands"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{177.83333333333334`, -17.366666666666667`}, {
      178.7, -18.}, {178., -18.266666666666666`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Fiji\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztm3tQU1cex38qoDPr7tY/dq2Oj3a0U3cFQRl8VIs8BKQgMizOjmtXEdQF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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztm3tQU1cex38qoDPr7tY/dq2Oj3a0U3cFQRl8VIs8BKQgMizOjmtXEdQF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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Fiji", "Panel", Background -> None]}, {{Top, Left}}], Editable -> 
      False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztm3tQU1cex38qoDPr7tY/dq2Oj3a0U3cFQRl8VIs8BKQgMizOjmtXEdQF
Q93d2u5st451fcxaxh3aLRVXR/HRoVEERHkJYh5AAjHhaRIeGfIQpCCP8DSR
R/aX3mwSbroIyaV3wXvnSwZzzz3nez7fyzknN8c3o/8YET0HAHzw5wT+GH//
Q5aBESNGjBgxYsSIESNGjBgxYsSIESNGjBgxYsTo1dSJi3Xi38XlHv2SdbOf
djOvlGKzDN9UGZrWeDQAGHU68e8P6Xf1iugkx6DRGvBQe5j4dycmjowaChWG
uLv025vZOl9u0A0ZiMOaP/FOY4fhozz6Tc5UZcoMo6NGzkql0pp/y7mEPEEe
EUHnoOE0l36rM0+cJiPevLTrtbW1t2/f1ul0Zv6az//h8YFH0p0kIgL9sCGh
mH7DM0m3ao1g29ra2tu+Ky8v5/F4pPFnaGjI+/fr/sxaV1p8D0/16Ax/vU+/
7Zmh4w8MOL0q6moVCgWyRdTHjh1raWmx5v/8+XNWzDIf37nRuxeVluRisepW
+p3PDD1qNt78N1KSGxsbi4uLZTJZdXV1amoqaf797JPgfbsXBPrPZx1YOTIy
gu+c5dNvfroLF/Y456pb1b/dvwuxI1W88+VyOU7BJP49PdoPYj127150Ny+N
mAhk7fT7n+56oDDgzey+3d0z1FOv1xusDtv1Z3Ozqr2z/cSFE5ezLuM/Mbi/
FdLfhemr+Ax9RwFnkMPpuJ+PrySpVq4k+LezWLZnCRWmS2jvxfQVOzHP9ITB
bv38tdiMYdo7Mk1VuTfeUf4AiUnltHdkmkqx/E3H+RfFn6G9I9NRZy9JHYeP
kr3jO6l2ezmcOm9vMYBRTk7KqCidQiGRaENCRADZk1V4+CNcCQxUVpoqtBK+
iaewgB3Vohm0ZBh79PJ4dT4+VPFPKjNVKyjKwlepuIiT+62mST7O+gePe+zk
UeIh0X+P9v7JtUscPUVFdVu2WFKIjtY1NQmFXQEBZfTyRwNog0S+r7i43s+P
qJYq/ufLTZWzL57CV+H96xXi0oyrn7d+1/qD/J91PhseHk67fAZ/wQja2tqI
Ys8G7OFvSqGgQL5pkyWFmBidUsnjdXh7C358/tgoNk0mLxDUBwSY66Tw/if4
61/oV767JCEpISTq3fD9YeuDf33qy1MiiYjEH4GnpKesCF6xYPP8paFLj35x
VNuntY+/bR+1+fnyDRuIDkqcnVUHD+pUqsLCZxs3lvw4/LEhbI7kqr+srCEo
yFxbva9vL5eL5inkn1OUE3og9Gfr5q/2X71k85K3vd9evGlxwPsB6bnpJP6D
g4M3sm64Rbo5uzktfm8x6xRLXi+3jz/xN15WRv4b1+bmyry8LCkcOqRXq3Ny
2tat408df6wcmyCTF4kagoMt5P38cORHw8TYSCH/h4KHIYdCWMdZO/btOHfx
3Prg9a4hruevnk/NTLUdf7q13YnXEtNL0i/cuqBp1pjd2sGf0I4dospK8hyn
zc6WeXqaUnBxUcXG6jWajIxWNzcetfyxQqyWTF4sbgwJsZD39+/l89EkWjVf
SBX/tIRMStY/imVv2McfNWtWdmSkWCrtJXHozsqSrl1rTkEdF6fTaNjsllWr
OI7zx0qwKtIqYqCiojEszEJ+2zacc9EY2kOT1pf///C/4wHfbnCIP6HZs7P3
7KlobOwnp5CZKXV3N6Uwd66axRpUP7l27cmKFQ/t448X4uXDw2PJV1UpwsMt
5AMC+kpK0AxaQmO2bqnlLwPgLoJ6MEr6Q5BrAZLfgQcH4O5eKA0cc0r0BjxK
AO7mhQ7yJ+TklBMTU61SDVjDwbu0Kz1d6uZmSSE+HlO4dEm9bNmDifPHwnjJ
0NCIdeWDNTWKiAi8v4nyDYGBfaWlaABtoJn/5ZNC/mULgL0TOGvgyi648Ru4
8jGwPwFpCtScBsk+EKyHGidjQJe9oHIBYDd4B0zkMSkhQLkT5B+HumXLKeFP
yMUl5/Dh2paW5+QU0tIeu7qaUpg3T3PkSL+qOSlJuX9/1fj8sQAW0+vHkq+t
VXw/spjIBwXhOhMbxabRwPgOKeR/JSr43p+i5AAX8N4uBTYbRCJobASDwaSn
dVBzFgRbQe4MXBfI+hTu/RJyloPsGtTXw9OnIDk86fHHx0fwUuFK4+uvld3d
elIKnWw23qW4CEc1bN+OA5RePzw+/xcvxpAf0evbk5NxMUlUgin0CYXYEDaH
jU7EG4X8cw5H53x8GPmnxUBqCnA5kJoARQEg2gXSb6CrwxKEWgqCM5CVAdf+
BXIhNBSAdA7gmqBq8vPvVBzj8Kf8oJA/b6nzrf1z2O8D3xcqPoWuTuAusAzv
VQtBHA3y29DeagkC1d8NRRH2r396ORzK9ezSJVv++OZUtEUhf+vJNG8PPEiH
y0HGiZg0Bdf8FIT+UPkRPE6Ex1/BPQ/gboTMXXbytwU1vTRF/K/+Cq6/BfxZ
gMNR5WzjO/jhX+wCJa8DdzUUrYTyOZbCkl9A/jHgv87wp4y/tYQ/gYt7ofrf
cOcgCLxBsBDKX4PCVcBeDjffgptrIMUHCncYV0cM/6ngTyz7xzlb7YRLcWb8
cUj/TJELWJ+NI8nWkEqvrShRZMw4xTh/SWT4TyPRDvAV58+sP+nVVBzT8fMX
XZrIZ3zUhx9Ka2p6+oRCRWQk8ayg3te3PTl5ZOwmvZfyHx0d7c7MbNi+3fTU
IjCwk80mPXzGhrC5CRqjHaCDeum3gf7+wuLizj6BwPL136xZmMJgbS0Ju0jU
ffJk/fj8sQAWe/H0qebIEcm8ecSpx66uXWlppBSwUWz6pfZoBzh1/P38hHx+
Z19pKd6lFvIREYM1Nbbkif0qE3z+jIXxEn1Lizo+XjJ3LlFA6ubWlZ5OSgEN
oI1Xjb+JfEmJ9WYDRXj4QFUVifyjR93WO4Um9f0LXoiX65ub1SyWJQV3dxyg
SK2MkwLtAKnl7+sr5PE6jBtstm0zo2sMCxuoqLAlHxpK3qNlx/ePWIkxhSdP
1HFxEhcXUwpr13ZnkRcHaAztzVT+OJdhB3v5/Hp/fwv5kJB+sZjEQSzW2pK3
m785BaxWr9GoYmPNKcg8PbXZ2bYpoNWZxB+7w+V29PJ45k1lqIbg4H6RyJa8
9d4DCvkTwsqNKajVqkOHJM7OphS8vLS5uSQnaJhIgXaADspInsvFxaSFfFBQ
f1kZqb8SyUvIU8LfnAI2p1OpVAcPmlOQb9igzc+3TYF2gA4KF+FmRMbNBgKB
LfmwsInuxaVw/yE2akxBqVTGxIidnEwpbNrUU1BgbY92gA7KRN7PD+dcEvmK
Cu3OnZPbLkv5/ls0gDZ0TU3K6GhzCnVbtvQUFc0M/nj/937//4sdJD9F/Mek
oFAoo6IsKXh7z4DnP/8B8DuKWQ==
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Fiji"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{24.166666666666668`, 65.81666666666666}, {25.45, 64.95}, {
      21.1, 62.766666666666666`}, {21.416666666666668`, 
      60.583333333333336`}, {22.883333333333333`, 59.8}, {27.866666666666667`,
       60.56666666666666}, {31.583333333333332`, 62.916666666666664`}, {
      29.016666666666666`, 69.03333333333333}, {28.966666666666665`, 69.05}, {
      27.9, 70.08333333333333}, {25.75, 68.98333333333333}, {20.6, 69.05}, {
      24.166666666666668`, 65.81666666666666}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Finland\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2rFJxHAchuGAC7jC7WJj6whpLQQLsXQAB7nCHcQpFBEFS62vsdGzs7jK
wP+F8Dx8gZThbX/ZzBdn89E0Taf752b//L5/j3K5/Zjm539vc/U67FNXSf+W
/i39W/q39G/p39K/pX9L/5b+Lf1b+rf0b+nf0r+lf0v/lv4t/Vv6t/Rv6d/S
v6V/S/+D7h93Y3Zy+76k//H5y9vn1/q2pImZmZmZmZmZmZmZmZmZ2d8NO3Re
3y26v6/1/jvs0P/wtFvSf63/Pwyjf0v/lv4t/Vv6t/Rv6d/Sv6V/S/+W/i39
W/q39G/p39K/pX9L/5b+Lf1b+rf0b+nf0r+l/0E/aGFZdQ==
              "], {{0, 0}, {128, 73}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 73}, PlotRange -> {{0, 128}, {0, 73}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2rFJxHAchuGAC7jC7WJj6whpLQQLsXQAB7nCHcQpFBEFS62vsdGzs7jK
wP+F8Dx8gZThbX/ZzBdn89E0Taf752b//L5/j3K5/Zjm539vc/U67FNXSf+W
/i39W/q39G/p39K/pX9L/5b+Lf1b+rf0b+nf0r+lf0v/lv4t/Vv6t/Rv6d/S
v6V/S/+D7h93Y3Zy+76k//H5y9vn1/q2pImZmZmZmZmZmZmZmZmZ2d8NO3Re
3y26v6/1/jvs0P/wtFvSf63/Pwyjf0v/lv4t/Vv6t/Rv6d/Sv6V/S/+W/i39
W/q39G/p39K/pX9L/5b+Lf1b+rf0b+nf0r+l/0E/aGFZdQ==
          "], {{0, 0}, {128, 73}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 73}, PlotRange -> {{0, 128}, {0, 73}}]], {
        Style["Finland", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2rFJxHAchuGAC7jC7WJj6whpLQQLsXQAB7nCHcQpFBEFS62vsdGzs7jK
wP+F8Dx8gZThbX/ZzBdn89E0Taf752b//L5/j3K5/Zjm539vc/U67FNXSf+W
/i39W/q39G/p39K/pX9L/5b+Lf1b+rf0b+nf0r+lf0v/lv4t/Vv6t/Rv6d/S
v6V/S/+D7h93Y3Zy+76k//H5y9vn1/q2pImZmZmZmZmZmZmZmZmZ2d8NO3Re
3y26v6/1/jvs0P/wtFvSf63/Pwyjf0v/lv4t/Vv6t/Rv6d/Sv6V/S/+W/i39
W/q39G/p39K/pX9L/5b+Lf1b+rf0b+nf0r+l/0E/aGFZdQ==
        "], {{0, 0}, {128, 73}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 73}, PlotRange -> {{0, 128}, {0, 73}}], "Finland"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{7.533333333333333, 43.78333333333333}, {7.433333333333334, 
      43.75}, {7.3999999999999995`, 43.733333333333334`}, {
      3.8833333333333333`, 43.55}, {3.216666666666667, 42.43333333333333}, {
      1.75, 42.5}, {1.5, 42.6}, {-1.7666666666666666`, 
      43.4}, {-1.1166666666666667`, 46.31666666666666}, {-4.783333333333333, 
      48.516666666666666`}, {-1.35, 48.63333333333333}, {-1.9333333333333333`,
       49.733333333333334`}, {0., 49.333333333333336`}, {2.55, 
      51.083333333333336`}, {5.816666666666666, 49.53333333333333}, {
      6.366666666666666, 49.46666666666667}, {8.233333333333333, 
      48.96666666666667}, {7.583333333333333, 47.583333333333336`}, {
      5.966666666666667, 46.21666666666667}, {7.033333333333333, 
      45.93333333333333}, {7.533333333333333, 43.78333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"France\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2ktOAkEQgOGeB3AOjzQDg6AudC7gFTwFj0uywZCwAoyJi9aMq+le8FX+
Smr9reuhf2/7KoTQ3fbjtl93eD1l7GV/vmSdY9McQsgYf/78+fPnz58//5Q9
8+fPnz9//vz58+fPn38y/7blz58/f/78+fNP2dOOP3/+/Pnz58+fP3/+/Pnz
58+fP3/+Y7Xe8r9r/8/5nD9//vz58+fPnz9//vz58+fPn/94rfjz58+fP3/+
/Pnz588/mf9iwZ8/f/78+fPnn7LHDX/+/Pnz58+fP3/+/Pnz58+fP3/+/Mdq
yf/O/buOP3/+/Pnz58+fP3/+/LP4F2//VA5W9UPVv8r///PjXxR/VJZxVRVX
13GTSdx0GjebfXcFZ3d3Ww==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2ktOAkEQgOGeB3AOjzQDg6AudC7gFTwFj0uywZCwAoyJi9aMq+le8FX+
Smr9reuhf2/7KoTQ3fbjtl93eD1l7GV/vmSdY9McQsgYf/78+fPnz58//5Q9
8+fPnz9//vz58+fPn38y/7blz58/f/78+fNP2dOOP3/+/Pnz58+fP3/+/Pnz
58+fP3/+Y7Xe8r9r/8/5nD9//vz58+fPnz9//vz58+fPn/94rfjz58+fP3/+
/Pnz588/mf9iwZ8/f/78+fPnn7LHDX/+/Pnz58+fP3/+/Pnz58+fP3/+/Mdq
yf/O/buOP3/+/Pnz58+fP3/+/LP4F2//VA5W9UPVv8r///PjXxR/VJZxVRVX
13GTSdx0GjebfXcFZ3d3Ww==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["France", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2ktOAkEQgOGeB3AOjzQDg6AudC7gFTwFj0uywZCwAoyJi9aMq+le8FX+
Smr9reuhf2/7KoTQ3fbjtl93eD1l7GV/vmSdY9McQsgYf/78+fPnz58//5Q9
8+fPnz9//vz58+fPn38y/7blz58/f/78+fNP2dOOP3/+/Pnz58+fP3/+/Pnz
58+fP3/+Y7Xe8r9r/8/5nD9//vz58+fPnz9//vz58+fPn/94rfjz58+fP3/+
/Pnz588/mf9iwZ8/f/78+fPnn7LHDX/+/Pnz58+fP3/+/Pnz58+fP3/+/Mdq
yf/O/buOP3/+/Pnz58+fP3/+/LP4F2//VA5W9UPVv8r///PjXxR/VJZxVRVX
13GTSdx0GjebfXcFZ3d3Ww==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "France"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-54.166666666666664`, 5.35}, {-52.93333333333333, 
      5.45}, {-51.68333333333333, 4.033333333333333}, {-52.733333333333334`, 
      2.3333333333333335`}, {-54.61666666666667, 
      2.3333333333333335`}, {-54.166666666666664`, 5.35}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"FrenchGuiana\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2ktOAkEQgOGeB3AOjzQDg6AudC7gFTwFj0uywZCwAoyJi9aMq+le8FX+
Smr9reuhf2/7KoTQ3fbjtl93eD1l7GV/vmSdY9McQsgYf/78+fPnz58//5Q9
8+fPnz9//vz58+fPn38y/7blz58/f/78+fNP2dOOP3/+/Pnz58+fP3/+/Pnz
58+fP3/+Y7Xe8r9r/8/5nD9//vz58+fPnz9//vz58+fPn/94rfjz58+fP3/+
/Pnz588/mf9iwZ8/f/78+fPnn7LHDX/+/Pnz58+fP3/+/Pnz58+fP3/+/Mdq
yf/O/buOP3/+/Pnz58+fP3/+/LP4F2//VA5W9UPVv8r///PjXxR/VJZxVRVX
13GTSdx0GjebfXcFZ3d3Ww==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2ktOAkEQgOGeB3AOjzQDg6AudC7gFTwFj0uywZCwAoyJi9aMq+le8FX+
Smr9reuhf2/7KoTQ3fbjtl93eD1l7GV/vmSdY9McQsgYf/78+fPnz58//5Q9
8+fPnz9//vz58+fPn38y/7blz58/f/78+fNP2dOOP3/+/Pnz58+fP3/+/Pnz
58+fP3/+Y7Xe8r9r/8/5nD9//vz58+fPnz9//vz58+fPn/94rfjz58+fP3/+
/Pnz588/mf9iwZ8/f/78+fPnn7LHDX/+/Pnz58+fP3/+/Pnz58+fP3/+/Mdq
yf/O/buOP3/+/Pnz58+fP3/+/LP4F2//VA5W9UPVv8r///PjXxR/VJZxVRVX
13GTSdx0GjebfXcFZ3d3Ww==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["FrenchGuiana", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2ktOAkEQgOGeB3AOjzQDg6AudC7gFTwFj0uywZCwAoyJi9aMq+le8FX+
Smr9reuhf2/7KoTQ3fbjtl93eD1l7GV/vmSdY9McQsgYf/78+fPnz58//5Q9
8+fPnz9//vz58+fPn38y/7blz58/f/78+fNP2dOOP3/+/Pnz58+fP3/+/Pnz
58+fP3/+Y7Xe8r9r/8/5nD9//vz58+fPnz9//vz58+fPn/94rfjz58+fP3/+
/Pnz588/mf9iwZ8/f/78+fPnn7LHDX/+/Pnz58+fP3/+/Pnz58+fP3/+/Mdq
yf/O/buOP3/+/Pnz58+fP3/+/LP4F2//VA5W9UPVv8r///PjXxR/VJZxVRVX
13GTSdx0GjebfXcFZ3d3Ww==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "FrenchGuiana"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-149.301, -17.6312}, {-149.283, -17.6553}, {-149.249, \
-17.7303}, {-149.23, -17.7551}, {-149.2, -17.7704}, {-149.166, -17.7777}, \
{-149.134, -17.7806}, {-149.107, -17.7864}, {-149.095, -17.7973}, {-149.086, \
-17.8214}, {-149.103, -17.8447}, {-149.148, -17.8571}, {-149.185, -17.8607}, \
{-149.209, -17.8556}, {-149.233, -17.8388}, {-149.263, -17.7915}, {-149.281, \
-17.7755}, {-149.312, -17.7726}, {-149.331, -17.7799}, {-149.36, -17.8039}, \
{-149.428, -17.8236}, {-149.484, -17.825}, {-149.537, -17.8097}, {-149.601, \
-17.785}, {-149.625, -17.7514}, {-149.626, -17.6903}, {-149.61, -17.6145}, \
{-149.588, -17.5927}, {-149.496, -17.573}, {-149.415, -17.5708}, {-149.337, \
-17.5992}, {-149.301, -17.6312}}, {{-149.739, -17.4215}, {-149.717, \
-17.4258}, {-149.705, -17.4316}, {-149.7, -17.4412}, {-149.705, -17.4501}, \
{-149.719, -17.4551}, {-149.733, -17.4621}, {-149.742, -17.4694}, {-149.743, \
-17.4848}, {-149.751, -17.4956}, {-149.767, -17.5002}, {-149.781, -17.5103}, \
{-149.795, -17.5253}, {-149.817, -17.5292}, {-149.843, -17.518}, {-149.883, \
-17.4898}, {-149.908, -17.4613}, {-149.901, -17.4432}, {-149.864, -17.4331}, \
{-149.828, -17.4274}, {-149.739, -17.4215}}, {{-148.124, -17.9257}, \
{-148.107, -17.9286}, {-148.097, -17.9351}, {-148.098, -17.946}, {-148.109, \
-17.9596}, {-148.121, -17.9754}, {-148.127, -17.995}, {-148.137, -18.0048}, \
{-148.149, -18.0025}, {-148.175, -17.9863}, {-148.214, -17.9543}, {-148.214, \
-17.9464}, {-148.206, -17.9385}, {-148.186, -17.9294}, {-148.158, -17.9253}, \
{-148.124, -17.9257}}, {{-150.752, -17.7129}, {-150.758, -17.7115}, \
{-150.763, -17.7097}, {-150.768, -17.7077}, {-150.773, -17.7055}, {-150.778, \
-17.7031}, {-150.783, -17.7005}, {-150.787, -17.6978}, {-150.791, -17.6949}, \
{-150.795, -17.692}, {-150.798, -17.689}, {-150.801, -17.6859}, {-150.803, \
-17.6829}, {-150.805, -17.6799}, {-150.806, -17.677}, {-150.806, -17.6743}, \
{-150.806, -17.6716}, {-150.805, -17.6691}, {-150.804, -17.6669}, {-150.803, \
-17.6648}, {-150.8, -17.663}, {-150.797, -17.6614}, {-150.794, -17.6601}, \
{-150.791, -17.6592}, {-150.786, -17.6585}, {-150.782, -17.6581}, {-150.777, \
-17.6581}, {-150.772, -17.6583}, {-150.767, -17.6589}, {-150.762, -17.6598}, \
{-150.756, -17.661}, {-150.751, -17.6625}, {-150.746, -17.6642}, {-150.74, \
-17.6662}, {-150.735, -17.6684}, {-150.73, -17.6708}, {-150.725, -17.6734}, \
{-150.721, -17.6762}, {-150.717, -17.679}, {-150.713, -17.682}, {-150.71, \
-17.685}, {-150.708, -17.688}, {-150.706, -17.691}, {-150.704, -17.694}, \
{-150.703, -17.6969}, {-150.702, -17.6997}, {-150.702, -17.7023}, {-150.703, \
-17.7048}, {-150.704, -17.7071}, {-150.706, -17.7091}, {-150.708, -17.711}, \
{-150.711, -17.7125}, {-150.714, -17.7138}, {-150.718, -17.7148}, {-150.722, \
-17.7154}, {-150.726, -17.7158}, {-150.731, -17.7159}, {-150.736, -17.7156}, \
{-150.741, -17.715}, {-150.747, -17.7141}, {-150.752, -17.7129}}, {{-149.535, \
-17.0938}, {-149.54, -17.0914}, {-149.545, -17.0887}, {-149.55, -17.0859}, \
{-149.555, -17.0828}, {-149.559, -17.0797}, {-149.563, -17.0764}, {-149.567, \
-17.073}, {-149.571, -17.0696}, {-149.574, -17.0661}, {-149.577, -17.0627}, \
{-149.579, -17.0594}, {-149.581, -17.0562}, {-149.582, -17.0532}, {-149.582, \
-17.0503}, {-149.583, -17.0476}, {-149.582, -17.0451}, {-149.581, -17.043}, \
{-149.58, -17.0411}, {-149.578, -17.0395}, {-149.576, -17.0382}, {-149.573, \
-17.0373}, {-149.569, -17.0368}, {-149.566, -17.0366}, {-149.562, -17.0367}, \
{-149.557, -17.0372}, {-149.553, -17.0381}, {-149.548, -17.0393}, {-149.543, \
-17.0408}, {-149.538, -17.0427}, {-149.533, -17.0448}, {-149.528, -17.0472}, \
{-149.523, -17.0499}, {-149.518, -17.0527}, {-149.513, -17.0558}, {-149.509, \
-17.0589}, {-149.505, -17.0622}, {-149.501, -17.0656}, {-149.497, -17.069}, \
{-149.494, -17.0725}, {-149.492, -17.0759}, {-149.489, -17.0792}, {-149.488, \
-17.0824}, {-149.486, -17.0854}, {-149.486, -17.0883}, {-149.486, -17.091}, \
{-149.486, -17.0935}, {-149.487, -17.0956}, {-149.488, -17.0975}, {-149.49, \
-17.0991}, {-149.493, -17.1004}, {-149.495, -17.1013}, {-149.499, -17.1018}, \
{-149.502, -17.102}, {-149.506, -17.1019}, {-149.511, -17.1014}, {-149.515, \
-17.1005}, {-149.52, -17.0993}, {-149.525, -17.0978}, {-149.53, -17.0959}, \
{-149.535, -17.0938}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"FrenchPolynesia\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXAdQVFkW/RY1VcaZNZTruuOUoRTjGhGHwbwGQAwMRqJgGsUAIqILAiJK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              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXAdQVFkW/RY1VcaZNZTruuOUoRTjGhGHwbwGQAwMRqJgGsUAIqILAiJK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          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["FrenchPolynesia", "Panel", Background -> None]}, {{
        Top, Left}}], Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztXAdQVFkW/RY1VcaZNZTruuOUoRTjGhGHwbwGQAwMRqJgGsUAIqILAiJK
FBppBKUlqoCSVRZUoMkoUVRQCaKSaZrupnP/z97PZ7BFtGZD1Qf3nTpQj8d7
r/ue//rc+343TDE7rmemgmHYdvhyhC+yXTP5T4iIiIiIiIiIiIiIiIiIiIiI
iIiIiIiIiIiIiIiIiIj/JUV5WYg0sgsB4d+ETI63csWVb7mZJQ23U9+E3n+V
UVzPF8rofl7fMnCCKK5sdQ8vXWYWN3R5EMWJm8JH/z2498fVvyX6RpU3tArp
frLfINp4kt12jybp3qSk/uumiD32j2H/v6ht3+ucMWd39PCVLCA0tp99WPC8
me7n+42Ay5eAt9zLrotnv43NqA2+V3nYI2uP3WPXsJKQe6+CkyqD4isDY18w
7zw/eIl94BLbLazEM6IMvl8KLbmfUyeX43RHMIgRGPdy2IqgXnuhOGZd8ESd
8D6dX+ISk5h3TQK64xisqKnn2zILtK2SZ+2Knqgd/vO++H0X2YmZdU9fth7x
yF5xKHHyllvjN4ap7Y218Mwuqmh9/KTewP4xJAVQfoJ22Nw9d4565QjFcrrj
GHzIKmm09s3v5YFLmQYOaScZ+cqdwKOeOWD+lt55yp37L7L1zzw0dkq38unp
P+1XALmb7pgGDcqrON+vuaFsI9P0bq08lDhuQ5hy54iVLDXT2KVmsaNWsz7v
B+eBdNzbOWr1jVd1XLojGxwAxzZ1Sp+mdxt0m/rrbXOXjGaOCPoTMt9ChTlR
J+KnLTfXWiRdiXouEMmkMjwytQpqoTm7ov+iEw79ftFkf0enFIrVlYcSRqxi
jV0futk6pbqeT3dkgwBRj6rA84GW3rk6lg+sffPO+D9hlzS8fv36urNzhB+T
XfD6RtKrY145yp5jxciFU9iL6raEyCj/s2dzsrLYxQ0wEZxH3zYVHIlaMzn3
Hd3xDWgUv2ql7GLs+pAlJrHgOWPWhWqdeOB19ETc1KliDONgGHPOnHhWuOaB
BGXPUTeLzc4pc9HUrFZRwTHsybhx9rpbNx4jp8Mii41jxq4LgWE/rA1G5dBX
cD/nnfreWCOHNGjgONFFJuKGa3b2b1VUujCslyGTJpWXlB90zdTYl6BuHmfk
mFbfzHPW0FAeI8Mwp41aMB0WgaWSc9/DsrB4Sh56CfQPuQK38cs/4p4NdmF6
PgMsXc82NSi2lDVtGiWpHMPyMKwIwwQY5q6jc8a/wNAh7ZBrlhOrKMjOrhHD
KjAsHcP4v1+CyuHDL7qFbrVJ2W3/2MQpff/FTFgcBtMd6ABFYuZbqNiNndLm
GdyhXGX4iiDb097t3WIGT5jgbmgeHpwYEhTn8tsp3QkTvCMK4Qiw/GCCR0SZ
8dy5tnpGAd5h0XfTfSys3VRVJd2zHPWNx60PpVabuSMKFl9sEvvmfQfdsQ5E
BMa+UHR7DpQ0l0KKoYbfCM5vYAIyxowdW5aVJZEpdCyToTSdoBV2wC6mvLCQ
miiVSk2PBkzSjRi56saaw0mdYnlHe7vXnDkw0W/Zsq02qdtOp0Au7vz9IJZd
2khbkIMNTAMDkJE5ZUp5dXvus6acsiYrn1zwE/0zqfdz6jKKG9KL6qGq2X42
dec/Hh1yY6cWfEgteA/9zA0byIlLl9IdweAAQRBc+6F9KHpgzdy9m5RRVdUu
4KmFRzbwqGc2FJ/HL+ecuJwLNSpcjpOMPGuKvnmnruRDEjl37amvtg45cckS
YYx535XPDYOHozvigQVCIuhf/127SBnnzm1ubrazs3NwcMjPz/fw8LCysioq
KmIwGMeOHaupqXF2dra1tS0pKXFzc7O2thaJRMxt28iJixYJ75h8vjKBo5tC
n0DBqe5f/x07SBkXLoQxW7duVVNTg4a6uvqmTZugsWDBgp07d0Jj7dq1q1at
goaGhoa2tjY0eiYuWNAZZdCP/jIRndEOPMhqMvrXX1+fsvG2trbly5eD8snJ
yVQjPT0dGsuWLSstLaUaaWlpmpqa8Kva2lqmoSE5cf78zts7+9FfjEqgT4Dz
6qVPrsvK78qrHik+FOGcakLU3kXgTD09Sn+5XM7j8err64VCIYfDaWlpgUZr
aytcF4lEwuVyGxsbwXbgV+BUCoWiR/9587pwBSHk4JwqxYdC+ZuHsvI78ECE
tJPuiAcWCFwB4ktyGKJkG3AMwfVVPK8ZwvjDPTaupibOuCQIWivJ9pG/L1Ce
COI/TknxPX7cz9oa532QPmXx/dXFD+2Ze/Z0dd+sgAV5l2cKbqwXxuwTpzlL
i0Pl1enI//uAIHCuw4g+LiGM3c/csoWUcfFiaWWy8J5lx/kxYrYbVC/FhYVX
bWwYurqBs2aVDx1KjtHWFrPded6zJVmX8baqnsQ9a5Yw0aLPsh0e0+gOdyAC
Nnw/+uvqUvkX2tDD910A2vpYWGSNGCFTuttD6Q9JnO+n1jORyr8zZ4r+adtn
2c5oY7pjHYgQhG3ulQj8R/LkGqQAhpYWeYydPx8k5Qcul5bclOT5MQ8c6PpU
fEp/Sb6/JP+qIHQTDPbrTtyM6dPB/OXv8oXRxlzHUdTikoJAumMdiJA+jwH3
AIuG5It3vIPihx+gERPgnz906Jk1a6TPomUv4kFDcaYHc//+/vXPvULKm+kl
LWT52djUYZjdZt0O1x87I3dD/sUFTeJ0F577FEXTc7pjHYigzqSK5ufCu2Zc
h5GkUbv+GOHq8lJFxXbhQllFEtfpB+gUp19k7tv3Ff3JMQ/PeRoaNmKYM+jv
9hPZ6ThKdN+K6GztUsjQ4fdLkL1M4J4b1utCPC9VlqP9u+++O7loUeetHWSn
w0hFQynT3Lxf/fG2Nx3nR5MX7sJ4dyNDDoZd2KwLG/5j5r0wXt74jO4oBy4I
EbfXpUn9PabFsa4nDxlyUl+f5zmdPJGlnAWRmWZm/eovr2FLsr2puQHnTpUO
GeKo/2uH87iPC/otIXD0iayvQXjfqkcrxt/w9trXqYGRF62TPc7Aa4HnM1da
fldaFvkl/aH+lJVFQprmOn5ffMPhlp1FdriTvCqt9yUge/OI7vgGOgiZiOcz
D45aUPz0bmbqpiVsbzhbSYtCmHv3fq7/FS0tGA+XCQwK9P9Ybd7UJ/iNghAd
Qagu3cENDuDtNV1yCexz5VwgTDgie5nYXT0GME1NlZVPGD3ac8MGdng4db0k
WV5wWP6k4I8yINOuBL3z/keBCznc82M/+rb7FEgNsPlJebO9mSYmveKXDR8e
z2JB8dThOqknybr8mRA08ZlLlfM4LmqnO6ZBBlnFPe75MT2+XZFIbX6qtlTW
30VHhxqv/D6LKOm4orGMKmL5gStwAfo4+n8CRUsFz3dhZ+Qe2N7U5ie1TTzK
NDKixIcK8xaDQQ2Wld/56DlQprZUiB85CuMOETIxvVEMahAyIfi2rPJBr7b8
qz/7W1qKuvWH7wFWVj0joXZVuoMnjD/cRaBS838DuAritAv8AE3IyDyPqZy2
1guqqoruS3Bz8uQHoaHUkVYQtAYugeCmPngXgSvoftbfICCN4pwaaLS2tPia
mV355Rfm7NnmM2bYmJq2NDUp2t6gN7YQEAYRaP8D8P9z0v4PEBARERERERER
EREREREREREREREREREREREREREREb8B/gvTWj6J
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], 
      "FrenchPolynesia"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{9.8, 1.}, {8.716666666666667, -0.6333333333333333}, {
      11.166666666666666`, -3.9499999999999997`}, {
      11.583333333333334`, -2.3333333333333335`}, {14.45, -1.9}, {14.5, 
      0.9333333333333333}, {13.166666666666666`, 1.2333333333333334`}, {
      13.299999999999999`, 2.1666666666666665`}, {11.333333333333334`, 
      2.1666666666666665`}, {11.35, 1.}, {9.8, 1.}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Gabon\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztxkEJgEAURdEHJrGEQWbpcvZiBatMD/sYQ8cYHw6cC3ftZ+tLkn12zf7P
cQMAAAAAAAAAAAAAlPA+AQAAAAAAAAAAAAAoYRsAAAAAAAAAAAAAADV8w3t/
7Q==
              "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztxkEJgEAURdEHJrGEQWbpcvZiBatMD/sYQ8cYHw6cC3ftZ+tLkn12zf7P
cQMAAAAAAAAAAAAAlPA+AQAAAAAAAAAAAAAoYRsAAAAAAAAAAAAAADV8w3t/
7Q==
          "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], {
        Style["Gabon", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztxkEJgEAURdEHJrGEQWbpcvZiBatMD/sYQ8cYHw6cC3ftZ+tLkn12zf7P
cQMAAAAAAAAAAAAAlPA+AQAAAAAAAAAAAAAoYRsAAAAAAAAAAAAAADV8w3t/
7Q==
        "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}], "Gabon"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-16.566666666666666`, 
      13.583333333333334`}, {-15.299999999999999`, 13.45}, {-16.75, 
      13.033333333333333`}, {-16.75, 
      13.066666666666666`}, {-13.799999999999999`, 
      13.383333333333333`}, {-16.566666666666666`, 13.583333333333334`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Gambia\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2UsJgFAQQNEBC9hArCRYwAJWsIYrV65fJHfW8JNieHouZ2AiDEw/zcPU
RMT4zPLMu8cKAAAAAAAAAAAAQE3KUUh0SZJ+WdftJMq/wAAAAAAAAL6lbTcS
Zf8/JUlJnSeZIgAAAAAAAAAAAACoyA2B4bJ4
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2UsJgFAQQNEBC9hArCRYwAJWsIYrV65fJHfW8JNieHouZ2AiDEw/zcPU
RMT4zPLMu8cKAAAAAAAAAAAAQE3KUUh0SZJ+WdftJMq/wAAAAAAAAL6lbTcS
Zf8/JUlJnSeZIgAAAAAAAAAAAACoyA2B4bJ4
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Gambia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2UsJgFAQQNEBC9hArCRYwAJWsIYrV65fJHfW8JNieHouZ2AiDEw/zcPU
RMT4zPLMu8cKAAAAAAAAAAAAQE3KUUh0SZJ+WdftJMq/wAAAAAAAAL6lbTcS
Zf8/JUlJnSeZIgAAAAAAAAAAAACoyA2B4bJ4
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Gambia"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{34.0734, 31.2784}, {34.112, 31.2908}, {34.2306, 31.3699}, {
      34.4738, 31.5893}, {34.5387, 31.6578}, {34.6148, 31.5928}, {34.5863, 
      31.4347}, {34.515, 31.3677}, {34.3724, 31.2034}, {34.1772, 31.0677}, {
      34.1552, 31.1011}, {34.0734, 31.2784}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"GazaStrip\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3LFNA1EQRdEvUYkTUmLkZGugBDeA5ArogNg1kLmBXwJVkG5ASLKsNfRw
x7x7NV/a+Lx8D6fXl9PDGGPZ39v+bt/zcSznMS4ec9u4nSuw/q7Qwd8VOvi7
Qgd/V+jg7wod/F2hg78rdPB3hQ7+rtDB3xU6+LtCB39X6ODvCh38XaGDvyt0
8HeFDv6u0MHfFTr4u0IH/7r1+enz431+zdhj/f9uWbY5t8xw/PAVcPbwFXDw
8BVw6vAVcOTwFXDe8BVw2PAVcNLwFXDM8BVwRv3v7v6HfIVjxspXOGmsfIXD
xspXOG+sfIUjx8pXOHWsfIWDx8pXOHusfIXK/xyP39frGhwlP+s3CPEpz6Y8
m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrP9AhcW
Obo=
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3LFNA1EQRdEvUYkTUmLkZGugBDeA5ArogNg1kLmBXwJVkG5ASLKsNfRw
x7x7NV/a+Lx8D6fXl9PDGGPZ39v+bt/zcSznMS4ec9u4nSuw/q7Qwd8VOvi7
Qgd/V+jg7wod/F2hg78rdPB3hQ7+rtDB3xU6+LtCB39X6ODvCh38XaGDvyt0
8HeFDv6u0MHfFTr4u0IH/7r1+enz431+zdhj/f9uWbY5t8xw/PAVcPbwFXDw
8BVw6vAVcOTwFXDe8BVw2PAVcNLwFXDM8BVwRv3v7v6HfIVjxspXOGmsfIXD
xspXOG+sfIUjx8pXOHWsfIWDx8pXOHusfIXK/xyP39frGhwlP+s3CPEpz6Y8
m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrP9AhcW
Obo=
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["GazaStrip", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3LFNA1EQRdEvUYkTUmLkZGugBDeA5ArogNg1kLmBXwJVkG5ASLKsNfRw
x7x7NV/a+Lx8D6fXl9PDGGPZ39v+bt/zcSznMS4ec9u4nSuw/q7Qwd8VOvi7
Qgd/V+jg7wod/F2hg78rdPB3hQ7+rtDB3xU6+LtCB39X6ODvCh38XaGDvyt0
8HeFDv6u0MHfFTr4u0IH/7r1+enz431+zdhj/f9uWbY5t8xw/PAVcPbwFXDw
8BVw6vAVcOTwFXDe8BVw2PAVcNLwFXDM8BVwRv3v7v6HfIVjxspXOGmsfIXD
xspXOG+sfIUjx8pXOHWsfIWDx8pXOHusfIXK/xyP39frGhwlP+s3CPEpz6Y8
m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrMpz6Y8m/JsyrP9AhcW
Obo=
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "GazaStrip"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{40., 43.38333333333333}, {43.95, 42.71666666666667}, {46.3,
       41.81666666666666}, {47.05, 40.75}, {45.016666666666666`, 41.2}, {
      43.166666666666664`, 40.583333333333336`}, {41.53333333333333, 
      41.516666666666666`}, {40., 43.38333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Georgia\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnXtIU28Yx3WpREGkZWgWGIRdqDSI0LKw/ojoThQRdlEz0ujyR1FRUimB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              "], {{0, 0}, {128, 96}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 96}, PlotRange -> {{0, 128}, {0, 96}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnXtIU28Yx3WpREGkZWgWGIRdqDSI0LKw/ojoThQRdlEz0ujyR1FRUimB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          "], {{0, 0}, {128, 96}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 96}, PlotRange -> {{0, 128}, {0, 96}}]], {
        Style["Georgia", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnXtIU28Yx3WpREGkZWgWGIRdqDSI0LKw/ojoThQRdlEz0ujyR1FRUimB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        "], {{0, 0}, {128, 96}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 96}, PlotRange -> {{0, 128}, {0, 96}}], "Georgia"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{7.2, 53.233333333333334`}, {9.833333333333334, 
      53.53333333333333}, {8.666666666666666, 54.916666666666664`}, {9.45, 
      54.81666666666666}, {9.45, 54.833333333333336`}, {10.9, 
      53.949999999999996`}, {14.266666666666666`, 53.733333333333334`}, {
      14.233333333333333`, 53.93333333333333}, {14.833333333333334`, 
      50.86666666666667}, {12.1, 50.31666666666666}, {13.833333333333334`, 
      48.766666666666666`}, {13.049999999999999`, 47.5}, {9.733333333333333, 
      47.53333333333333}, {9.566666666666666, 47.53333333333333}, {
      7.583333333333333, 47.583333333333336`}, {8.233333333333333, 
      48.96666666666667}, {6.366666666666666, 49.46666666666667}, {
      6.133333333333333, 50.13333333333333}, {6.016666666666667, 50.75}, {7.2,
       53.233333333333334`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Germany\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztxkENgDAABMFLUIKMeuAFDmoAC2jlgQ1oLfTTkMxmLrm1nntdkmxtV1v/
7wMAAAAAAAAAAMCQozBTAgAAAAAAAAAA/NRdChNFkiRJkiRJkiRJkiRJkjTU
Bw7iFqQ=
              "], {{0, 0}, {128, 76}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 76}, PlotRange -> {{0, 128}, {0, 76}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztxkENgDAABMFLUIKMeuAFDmoAC2jlgQ1oLfTTkMxmLrm1nntdkmxtV1v/
7wMAAAAAAAAAAMCQozBTAgAAAAAAAAAA/NRdChNFkiRJkiRJkiRJkiRJkjTU
Bw7iFqQ=
          "], {{0, 0}, {128, 76}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 76}, PlotRange -> {{0, 128}, {0, 76}}]], {
        Style["Germany", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztxkENgDAABMFLUIKMeuAFDmoAC2jlgQ1oLfTTkMxmLrm1nntdkmxtV1v/
7wMAAAAAAAAAAMCQozBTAgAAAAAAAAAA/NRdChNFkiRJkiRJkiRJkiRJkjTU
Bw7iFqQ=
        "], {{0, 0}, {128, 76}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 76}, PlotRange -> {{0, 128}, {0, 76}}], "Germany"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-3.1, 5.083333333333333}, {0., 5.616666666666666}, {1.2, 
      6.1}, {0., 10.6}, {-0.08333333333333333, 10.7}, {0., 11.1}, {-0.15, 
      11.133333333333333`}, {-2.8333333333333335`, 11.}, {-2.683333333333333, 
      9.483333333333333}, {-3.1, 5.083333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Ghana\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2WtIU2Ecx/Gzc7apm9M2dW7uonPzUioZRNDLIDIKii5G2ItEiCAptQJt
RUjQmwgiIi+lplHRhDClMutNRBHNCgx7lQT1orTSQs1upD1r5WVup+NEnnN2
fg8fYbIj/P2Cf89RR0nZ5hKOYZhC8lFNPnyvU6vWAi0Zh9dQn0HO0B/95czl
Rn/0ly/0R385c7oLqM8gZ+iP/nKG/pT7H0J/9Jcv9Ed/OUN/utLRH/1lDP3R
X84cVeiP/vKF/ugvZ+hPVxrtAWQO/an3v+HNv+HNFehm9wK61Z0TVF2rq7Et
I9S7Ib/K47zSlTX5aeeTBXR7HiZGXROjdjH7NmgzJrFnTurHR2xCrv/52Vbt
js/OVFKfXBix9ye2b9UwDLO+IHrglYX/yr7n5pUr1OTiyoo46mNHTH9PSwLz
55iMbGdbUqjLmmoNuliF/8rH95Kpjx0x/Uf6rdFR/q4M6VteqiNLafoFH19b
tmyMYf4du5UTuKxEQAL9iQ3rpvKSszRX1es1+d+622G0mLnp75bt0VEfWDAn
7QEEaa43MDMP+YlorDHs36tTMIHnfpeR+sAR1n/wjUWlnBU62Ek2sr+GpbJ8
JNOfWL0qWkj/3SWx1EeNyP41p/RC+t9pD3mDJEqS6f+2z8LO3vUzj0HP/vgk
oeUjmf7fh2wH9gX5VRtwtBrF9auJ1KeNsP4ve8zLl6mFLB//2VWsHftgpT52
ZPS/1JAw+VQr/OQuUb3oNlMfXoB02gOERB57i3do51p+8mhiFOQBgfp3IdH+
zx6asjKE3fHznqJtmuF3Yt5Fous/PmI7fUIfNYd9/5+T4VQ+fWCi/n1Joj95
dC0v1eXnqfJyVDmLVdmZSlIvPU2ZauOsKZw5mTUmsWpVkMiJCawrXel0KB2p
XJqdI9fbrZzNwlnMXIrJ92m7R5z3ReLqL0RlRdzs/jx/lxY36fUnyyQgvn4R
Sx4QqA8mk/4EWUrT++8s0lIfSVb93QdnrKCOVnHu9ojt3/NoagXF6RQB/w6T
FEn2J8itkb8/ucOnPowM+x+t+ruCrl2W7vKRcP9er28FaTWKL+/F/Hgbsf0J
8oBWuEnSy0fa/Y8dife0JFAfYz7GLpq+tiTxaeZ1gVcTr0ZeDbzO+/QeNwyd
TfS/noNziTzG6nnV8arlVRNEP6MGAAAAAAAAAAAAAAAAAAAAAAAAAKBPERY2
XFxYlGEaUIVFHdxvYEWCTQ==
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2WtIU2Ecx/Gzc7apm9M2dW7uonPzUioZRNDLIDIKii5G2ItEiCAptQJt
RUjQmwgiIi+lplHRhDClMutNRBHNCgx7lQT1orTSQs1upD1r5WVup+NEnnN2
fg8fYbIj/P2Cf89RR0nZ5hKOYZhC8lFNPnyvU6vWAi0Zh9dQn0HO0B/95czl
Rn/0ly/0R385c7oLqM8gZ+iP/nKG/pT7H0J/9Jcv9Ed/OUN/utLRH/1lDP3R
X84cVeiP/vKF/ugvZ+hPVxrtAWQO/an3v+HNv+HNFehm9wK61Z0TVF2rq7Et
I9S7Ib/K47zSlTX5aeeTBXR7HiZGXROjdjH7NmgzJrFnTurHR2xCrv/52Vbt
js/OVFKfXBix9ye2b9UwDLO+IHrglYX/yr7n5pUr1OTiyoo46mNHTH9PSwLz
55iMbGdbUqjLmmoNuliF/8rH95Kpjx0x/Uf6rdFR/q4M6VteqiNLafoFH19b
tmyMYf4du5UTuKxEQAL9iQ3rpvKSszRX1es1+d+622G0mLnp75bt0VEfWDAn
7QEEaa43MDMP+YlorDHs36tTMIHnfpeR+sAR1n/wjUWlnBU62Ek2sr+GpbJ8
JNOfWL0qWkj/3SWx1EeNyP41p/RC+t9pD3mDJEqS6f+2z8LO3vUzj0HP/vgk
oeUjmf7fh2wH9gX5VRtwtBrF9auJ1KeNsP4ve8zLl6mFLB//2VWsHftgpT52
ZPS/1JAw+VQr/OQuUb3oNlMfXoB02gOERB57i3do51p+8mhiFOQBgfp3IdH+
zx6asjKE3fHznqJtmuF3Yt5Fous/PmI7fUIfNYd9/5+T4VQ+fWCi/n1Joj95
dC0v1eXnqfJyVDmLVdmZSlIvPU2ZauOsKZw5mTUmsWpVkMiJCawrXel0KB2p
XJqdI9fbrZzNwlnMXIrJ92m7R5z3ReLqL0RlRdzs/jx/lxY36fUnyyQgvn4R
Sx4QqA8mk/4EWUrT++8s0lIfSVb93QdnrKCOVnHu9ojt3/NoagXF6RQB/w6T
FEn2J8itkb8/ucOnPowM+x+t+ruCrl2W7vKRcP9er28FaTWKL+/F/Hgbsf0J
8oBWuEnSy0fa/Y8dife0JFAfYz7GLpq+tiTxaeZ1gVcTr0ZeDbzO+/QeNwyd
TfS/noNziTzG6nnV8arlVRNEP6MGAAAAAAAAAAAAAAAAAAAAAAAAAKBPERY2
XFxYlGEaUIVFHdxvYEWCTQ==
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Ghana", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2WtIU2Ecx/Gzc7apm9M2dW7uonPzUioZRNDLIDIKii5G2ItEiCAptQJt
RUjQmwgiIi+lplHRhDClMutNRBHNCgx7lQT1orTSQs1upD1r5WVup+NEnnN2
fg8fYbIj/P2Cf89RR0nZ5hKOYZhC8lFNPnyvU6vWAi0Zh9dQn0HO0B/95czl
Rn/0ly/0R385c7oLqM8gZ+iP/nKG/pT7H0J/9Jcv9Ed/OUN/utLRH/1lDP3R
X84cVeiP/vKF/ugvZ+hPVxrtAWQO/an3v+HNv+HNFehm9wK61Z0TVF2rq7Et
I9S7Ib/K47zSlTX5aeeTBXR7HiZGXROjdjH7NmgzJrFnTurHR2xCrv/52Vbt
js/OVFKfXBix9ye2b9UwDLO+IHrglYX/yr7n5pUr1OTiyoo46mNHTH9PSwLz
55iMbGdbUqjLmmoNuliF/8rH95Kpjx0x/Uf6rdFR/q4M6VteqiNLafoFH19b
tmyMYf4du5UTuKxEQAL9iQ3rpvKSszRX1es1+d+622G0mLnp75bt0VEfWDAn
7QEEaa43MDMP+YlorDHs36tTMIHnfpeR+sAR1n/wjUWlnBU62Ek2sr+GpbJ8
JNOfWL0qWkj/3SWx1EeNyP41p/RC+t9pD3mDJEqS6f+2z8LO3vUzj0HP/vgk
oeUjmf7fh2wH9gX5VRtwtBrF9auJ1KeNsP4ve8zLl6mFLB//2VWsHftgpT52
ZPS/1JAw+VQr/OQuUb3oNlMfXoB02gOERB57i3do51p+8mhiFOQBgfp3IdH+
zx6asjKE3fHznqJtmuF3Yt5Fous/PmI7fUIfNYd9/5+T4VQ+fWCi/n1Joj95
dC0v1eXnqfJyVDmLVdmZSlIvPU2ZauOsKZw5mTUmsWpVkMiJCawrXel0KB2p
XJqdI9fbrZzNwlnMXIrJ92m7R5z3ReLqL0RlRdzs/jx/lxY36fUnyyQgvn4R
Sx4QqA8mk/4EWUrT++8s0lIfSVb93QdnrKCOVnHu9ojt3/NoagXF6RQB/w6T
FEn2J8itkb8/ucOnPowM+x+t+ruCrl2W7vKRcP9er28FaTWKL+/F/Hgbsf0J
8oBWuEnSy0fa/Y8dife0JFAfYz7GLpq+tiTxaeZ1gVcTr0ZeDbzO+/QeNwyd
TfS/noNziTzG6nnV8arlVRNEP6MGAAAAAAAAAAAAAAAAAAAAAAAAAKBPERY2
XFxYlGEaUIVFHdxvYEWCTQ==
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Ghana"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-5.34003, 36.1598}, {-5.34164, 36.1448}, {-5.33969, 
      36.1382}, {-5.34307, 36.1234}, {-5.33965, 36.1153}, {-5.34378, 
      36.1124}, {-5.34903, 36.1169}, {-5.35107, 36.1258}, {-5.35553, 
      36.1314}, {-5.35664, 36.1382}, {-5.35537, 36.1419}, {-5.35726, 
      36.147}, {-5.35249, 36.1551}, {-5.35322, 36.1598}, {-5.34003, 
      36.1598}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Gibraltar\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXGtQVdcVdqb9n/vgJQ8BARGEjJAEVALYmjRGDSSO05mWqMT0kWY60z99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              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXGtQVdcVdqb9n/vgJQ8BARGEjJAEVALYmjRGDSSO05mWqMT0kWY60z99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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Gibraltar", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztXGtQVdcVdqb9n/vgJQ8BARGEjJAEVALYmjRGDSSO05mWqMT0kWY60z99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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "Gibraltar"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{26.03333333333333, 40.733333333333334`}, {23.7, 
      40.71666666666667}, {22.583333333333332`, 40.46666666666667}, {
      22.516666666666666`, 38.85}, {24.066666666666666`, 38.2}, {
      22.716666666666665`, 37.56666666666666}, {23.2, 36.43333333333333}, {
      21.1, 37.85}, {22.216666666666665`, 38.18333333333333}, {
      23.233333333333334`, 38.15}, {20.383333333333333`, 39.28333333333333}, {
      20.016666666666666`, 39.68333333333333}, {20.983333333333334`, 40.85}, {
      22.933333333333334`, 41.35}, {26.366666666666667`, 41.71666666666667}, {
      26.03333333333333, 40.733333333333334`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Greece\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztmLFKA0EURRf8AT8hfkD+RQJp7EwZC0UsLSLYB1JZ2AXELqhVSBEsLENS
KIKNFmJjkSJL3OzsJsbSwkWGuHfNO4czMNUrzlRvtmr7ldpGEATV5Wksz9c9
2J0gIiIiIiJiDja7MQpdAAAAAACAGVwyR6HyBRwREREREdGInYFDoer/DwAA
AAAAyI+bofNx5O6efrR37zVz6B5e03E4N6Xf1rxZn2S86cFFJN/r11v609+y
9Ke/ZelPf8vSn/6W/aP+e+2o/5iYslD9m91Zxti1hP5a6K+F/lror4X+Wuiv
hf5atltTD3fOphkzz29jv7GtXvw2Tk2Z20P/BoMfF+rk36C/Fvprob8W+muh
vxb6a6G/FoP9S0ehh+XjMCPjyVXkN/b0Onp+T03p92r8/6wK+muhvxb6a6G/
Fvprob8W+mspVP/Dy4/BS2LKQvVH+v8L6U9/y9Kf/palP/0tS/9V+QkaCp7E

              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztmLFKA0EURRf8AT8hfkD+RQJp7EwZC0UsLSLYB1JZ2AXELqhVSBEsLENS
KIKNFmJjkSJL3OzsJsbSwkWGuHfNO4czMNUrzlRvtmr7ldpGEATV5Wksz9c9
2J0gIiIiIiJiDja7MQpdAAAAAACAGVwyR6HyBRwREREREdGInYFDoer/DwAA
AAAAyI+bofNx5O6efrR37zVz6B5e03E4N6Xf1rxZn2S86cFFJN/r11v609+y
9Ke/ZelPf8vSn/6W/aP+e+2o/5iYslD9m91Zxti1hP5a6K+F/lror4X+Wuiv
hf5atltTD3fOphkzz29jv7GtXvw2Tk2Z20P/BoMfF+rk36C/Fvprob8W+muh
vxb6a6G/FoP9S0ehh+XjMCPjyVXkN/b0Onp+T03p92r8/6wK+muhvxb6a6G/
Fvprob8W+mspVP/Dy4/BS2LKQvVH+v8L6U9/y9Kf/palP/0tS/9V+QkaCp7E

          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Greece", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztmLFKA0EURRf8AT8hfkD+RQJp7EwZC0UsLSLYB1JZ2AXELqhVSBEsLENS
KIKNFmJjkSJL3OzsJsbSwkWGuHfNO4czMNUrzlRvtmr7ldpGEATV5Wksz9c9
2J0gIiIiIiJiDja7MQpdAAAAAACAGVwyR6HyBRwREREREdGInYFDoer/DwAA
AAAAyI+bofNx5O6efrR37zVz6B5e03E4N6Xf1rxZn2S86cFFJN/r11v609+y
9Ke/ZelPf8vSn/6W/aP+e+2o/5iYslD9m91Zxti1hP5a6K+F/lror4X+Wuiv
hf5atltTD3fOphkzz29jv7GtXvw2Tk2Z20P/BoMfF+rk36C/Fvprob8W+muh
vxb6a6G/FoP9S0ehh+XjMCPjyVXkN/b0Onp+T03p92r8/6wK+muhvxb6a6G/
Fvprob8W+mspVP/Dy4/BS2LKQvVH+v8L6U9/y9Kf/palP/0tS/9V+QkaCp7E

        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Greece"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[PolygonBox[{CompressedData["
1:eJxNVDtoFFEUHQVBxCaIgogQRTCVSOKuDpOFG5Kd3ZnEybyZt9hYiOAHgx9I
kSIgKhpSiCBWURQtFFwbt46RJ1gEUUEbsVgRGwUhFlayjTP3nI0eWB5v3r3n
nnvefbvn5MXs1EbP8xrFr1wXS/wYc7oupvKlW6Ambq7EfiO6Hg7cXoWRd28L
TFWdV+KKkRFFzd1dKmHkWbvAOd8NlPhgRD8vjYJ/cyb6/XbFaZ375LvpI39n
Br7ZwOn345mgzqH1vebtrrpWiceZvFgu0Bt2v9YKPMhE1wtVpzreZKJxrRHw
f87QzxzzKzn5hsE/mgt0Vp3yzvTPD6LfQQs9UnETJfZZ+jHkTiss+Y/QL7vu
l9a7YaE38OmfRb+5sJ6FP6YCvicW9VfGEP/cwt+2D/6PVnS9xvv6zvrHGvD/
Ffl/j8OPNvV/DXHe6dcLwX/Jwr+1JvjOsF58FHoWLO7Tn0I/LeYPJNA/z3qz
Ke57lX4OZeB/mIv6dj3F/kQOvZ+M07zxHPoGDfg35ai/JYHeDTn7mUS9nwb8
qzH07eB81CLEPzLsbxL3/9TA/108v8rzTox62znP2yLw9/geujH8/pYifz4C
35+UfsWYv/fcH4g4f4zvxZiX1+Rbod6FFP16EfJfMn6ZfJdT0bgwwns5n6Lf
JvlsPz/G/G79x4d3S76A/XamOc9N3M/ZBOf3Qod3mkD/rZDvNeH7rJOf8UEd
eroJ/LpT531OM38C9RvU+9//y1/eXwRC
       "], {{-54.3, 70.31666666666666}, {-51.833333333333336`, 
       69.63333333333333}, {-53.56666666666666, 69.23333333333333}, {-54.3, 
       70.31666666666666}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Greenland\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnD1oE3EYh2MbFQVBF4WCYEXExU9QRFAnKTgoZtKiCA4iOBRB1EkERQfB
CuKiQgURBxcXEaXgokVxEKIIitCmzeWrNkmTmLTJ5V7vPS1+R5vc/365+78P
PEib3Nf72DZ3vab7SF/kSGcoFOq1PWcbth0OhUgURVEURVEURVEURVEURVEU
RVEURVEURdFzOzootnQpxdevp2RPD2UOHHD+5Y/58/w4fB9F1xxZuJDSkQgV
79yhWjxOlmlSI/hxfh4/n5fj5dHHIM7ScJgyBw/S5wcPqF4uN+z9L3h5Xg+v
j9cLPzaxoel9+6j6/n1Lzf8Gr5fXjz5G8XcTW7dS5dkzJd1/hbfD20Mfs2jb
2UmTV6960v1XeLu8ffgMNDW2ZAmVnzyBtJ+Bt8/7gZ6FbsbXrKHqhw/Q9jPw
fvD+oGeii8amTVTP59HZf4L3x9i4ET6boDva1eWcn7cjtdFRii1bBp9RUB1Z
sICmXr1CZ25I5flzGp43Dz6rwDlnDpXu30fn/S8KAwP4eQXMT8eOobPOisz+
/fCZBUW+Bl9LJNBJZ0X140canjsXPrsgmD1zBp2zKfh7Fnp2fje2eDGZ2Sw6
ZVPUDMN5zYqeoZ/NXbiAztgSEydPwmfoZ2uxGDphS0xHo/AZ+lW+zhcExlat
gs/Sj+bOn0enc4WJU6fgs/Sj02/fotO5wtSLF/BZ+s2x7m50NtewLOvrvaVt
MFe/mNy1C53NVYwtW+Az9ZOZQ4fQyVwltWcPfKZ+kl8zBYnxo0fhM/WT+StX
0MlcJXv2LHymbhtbvpzGVqxQYuHWLed+iqDI94qqmhVCbp/L5ZR9vYwfPgz/
/+2mE319ymaFgNur7J89fRrezE3zly4pmxUC1f0n+/vhzdy0ODCgbFYIVPcv
3bsHb+am5UePlM0Kger+ladP4c3cdPr1a2WzQqC6v5lKOfd8oru54cj8+VQv
FpXNCoHq/kxi2zZ4OzdM7d6tdE4IvOifv3wZ3s4NCzdvKp0TAi/61/ge2jbo
15IdHWSm00rnhMCL/oyxdi2+YQsmt29XPiMEXvWfvHYN3rAV+X2EgohX/a1q
lcZWroR3bEZj3Tqiel35jBB41Z8p3b0Lb9mM5YcPPZkPAi/7k2WRsWEDvOds
TO7Y4c1sQHja36YyOOib60Ej4TBNvXzp2WwQeN2fyV+8CG/7PxauX/d0LggQ
/ZlMby+8byP99nfqzYLqb1UqlNi8Gd75TyZ37nTOV3QA1Z8xDYPiq1fDe/8o
vz41x8ch80CA7M/U7W2nenrg3dn03r1klUqwWSBA93cwTZo4cQLanu9TC+o1
nka0Rf9v8L1VsUWLPO3O2yvevo0+dBjt1J8xMxn6dPy4c+6tsjuvn7fD29OZ
dus/g/Me7ZGImp/z9npVvbe832jX/jNMv3njvH+Ac67Y7HVDezlentfD6xO+
0+79f8RMJKhw44Zz7Yh/H8+/T+R78n76vm5/zJ/nx/l5/HzTZ+855yV+6v83
+Hy9+u6dVuftbhGE/kLzSH+9kf56I/31RvrrjfTXG+mvN9Jfb6S/3kh/vZH+
eiP99Ub664301xvprzfcfmhoaDAajT4W9ZPbhwRBEARB0I4vDYeBAg==
              "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnD1oE3EYh2MbFQVBF4WCYEXExU9QRFAnKTgoZtKiCA4iOBRB1EkERQfB
CuKiQgURBxcXEaXgokVxEKIIitCmzeWrNkmTmLTJ5V7vPS1+R5vc/365+78P
PEib3Nf72DZ3vab7SF/kSGcoFOq1PWcbth0OhUgURVEURVEURVEURVEURVEU
RVEURVEURdFzOzootnQpxdevp2RPD2UOHHD+5Y/58/w4fB9F1xxZuJDSkQgV
79yhWjxOlmlSI/hxfh4/n5fj5dHHIM7ScJgyBw/S5wcPqF4uN+z9L3h5Xg+v
j9cLPzaxoel9+6j6/n1Lzf8Gr5fXjz5G8XcTW7dS5dkzJd1/hbfD20Mfs2jb
2UmTV6960v1XeLu8ffgMNDW2ZAmVnzyBtJ+Bt8/7gZ6FbsbXrKHqhw/Q9jPw
fvD+oGeii8amTVTP59HZf4L3x9i4ET6boDva1eWcn7cjtdFRii1bBp9RUB1Z
sICmXr1CZ25I5flzGp43Dz6rwDlnDpXu30fn/S8KAwP4eQXMT8eOobPOisz+
/fCZBUW+Bl9LJNBJZ0X140canjsXPrsgmD1zBp2zKfh7Fnp2fje2eDGZ2Sw6
ZVPUDMN5zYqeoZ/NXbiAztgSEydPwmfoZ2uxGDphS0xHo/AZ+lW+zhcExlat
gs/Sj+bOn0enc4WJU6fgs/Sj02/fotO5wtSLF/BZ+s2x7m50NtewLOvrvaVt
MFe/mNy1C53NVYwtW+Az9ZOZQ4fQyVwltWcPfKZ+kl8zBYnxo0fhM/WT+StX
0MlcJXv2LHymbhtbvpzGVqxQYuHWLed+iqDI94qqmhVCbp/L5ZR9vYwfPgz/
/+2mE319ymaFgNur7J89fRrezE3zly4pmxUC1f0n+/vhzdy0ODCgbFYIVPcv
3bsHb+am5UePlM0Kger+ladP4c3cdPr1a2WzQqC6v5lKOfd8oru54cj8+VQv
FpXNCoHq/kxi2zZ4OzdM7d6tdE4IvOifv3wZ3s4NCzdvKp0TAi/61/ge2jbo
15IdHWSm00rnhMCL/oyxdi2+YQsmt29XPiMEXvWfvHYN3rAV+X2EgohX/a1q
lcZWroR3bEZj3Tqiel35jBB41Z8p3b0Lb9mM5YcPPZkPAi/7k2WRsWEDvOds
TO7Y4c1sQHja36YyOOib60Ej4TBNvXzp2WwQeN2fyV+8CG/7PxauX/d0LggQ
/ZlMby+8byP99nfqzYLqb1UqlNi8Gd75TyZ37nTOV3QA1Z8xDYPiq1fDe/8o
vz41x8ch80CA7M/U7W2nenrg3dn03r1klUqwWSBA93cwTZo4cQLanu9TC+o1
nka0Rf9v8L1VsUWLPO3O2yvevo0+dBjt1J8xMxn6dPy4c+6tsjuvn7fD29OZ
dus/g/Me7ZGImp/z9npVvbe832jX/jNMv3njvH+Ac67Y7HVDezlentfD6xO+
0+79f8RMJKhw44Zz7Yh/H8+/T+R78n76vm5/zJ/nx/l5/HzTZ+855yV+6v83
+Hy9+u6dVuftbhGE/kLzSH+9kf56I/31RvrrjfTXG+mvN9Jfb6S/3kh/vZH+
eiP99Ub664301xvprzfcfmhoaDAajT4W9ZPbhwRBEARB0I4vDYeBAg==
          "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}]], {
        Style["Greenland", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnD1oE3EYh2MbFQVBF4WCYEXExU9QRFAnKTgoZtKiCA4iOBRB1EkERQfB
CuKiQgURBxcXEaXgokVxEKIIitCmzeWrNkmTmLTJ5V7vPS1+R5vc/365+78P
PEib3Nf72DZ3vab7SF/kSGcoFOq1PWcbth0OhUgURVEURVEURVEURVEURVEU
RVEURVEURdFzOzootnQpxdevp2RPD2UOHHD+5Y/58/w4fB9F1xxZuJDSkQgV
79yhWjxOlmlSI/hxfh4/n5fj5dHHIM7ScJgyBw/S5wcPqF4uN+z9L3h5Xg+v
j9cLPzaxoel9+6j6/n1Lzf8Gr5fXjz5G8XcTW7dS5dkzJd1/hbfD20Mfs2jb
2UmTV6960v1XeLu8ffgMNDW2ZAmVnzyBtJ+Bt8/7gZ6FbsbXrKHqhw/Q9jPw
fvD+oGeii8amTVTP59HZf4L3x9i4ET6boDva1eWcn7cjtdFRii1bBp9RUB1Z
sICmXr1CZ25I5flzGp43Dz6rwDlnDpXu30fn/S8KAwP4eQXMT8eOobPOisz+
/fCZBUW+Bl9LJNBJZ0X140canjsXPrsgmD1zBp2zKfh7Fnp2fje2eDGZ2Sw6
ZVPUDMN5zYqeoZ/NXbiAztgSEydPwmfoZ2uxGDphS0xHo/AZ+lW+zhcExlat
gs/Sj+bOn0enc4WJU6fgs/Sj02/fotO5wtSLF/BZ+s2x7m50NtewLOvrvaVt
MFe/mNy1C53NVYwtW+Az9ZOZQ4fQyVwltWcPfKZ+kl8zBYnxo0fhM/WT+StX
0MlcJXv2LHymbhtbvpzGVqxQYuHWLed+iqDI94qqmhVCbp/L5ZR9vYwfPgz/
/+2mE319ymaFgNur7J89fRrezE3zly4pmxUC1f0n+/vhzdy0ODCgbFYIVPcv
3bsHb+am5UePlM0Kger+ladP4c3cdPr1a2WzQqC6v5lKOfd8oru54cj8+VQv
FpXNCoHq/kxi2zZ4OzdM7d6tdE4IvOifv3wZ3s4NCzdvKp0TAi/61/ge2jbo
15IdHWSm00rnhMCL/oyxdi2+YQsmt29XPiMEXvWfvHYN3rAV+X2EgohX/a1q
lcZWroR3bEZj3Tqiel35jBB41Z8p3b0Lb9mM5YcPPZkPAi/7k2WRsWEDvOds
TO7Y4c1sQHja36YyOOib60Ej4TBNvXzp2WwQeN2fyV+8CG/7PxauX/d0LggQ
/ZlMby+8byP99nfqzYLqb1UqlNi8Gd75TyZ37nTOV3QA1Z8xDYPiq1fDe/8o
vz41x8ch80CA7M/U7W2nenrg3dn03r1klUqwWSBA93cwTZo4cQLanu9TC+o1
nka0Rf9v8L1VsUWLPO3O2yvevo0+dBjt1J8xMxn6dPy4c+6tsjuvn7fD29OZ
dus/g/Me7ZGImp/z9npVvbe832jX/jNMv3njvH+Ac67Y7HVDezlentfD6xO+
0+79f8RMJKhw44Zz7Yh/H8+/T+R78n76vm5/zJ/nx/l5/HzTZ+855yV+6v83
+Hy9+u6dVuftbhGE/kLzSH+9kf56I/31RvrrjfTXG+mvN9Jfb6S/3kh/vZH+
eiP99Ub664301xvprzfcfmhoaDAajT4W9ZPbhwRBEARB0I4vDYeBAg==
        "], {{0, 0}, {128, 90}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 90}, PlotRange -> {{0, 128}, {0, 90}}], 
      "Greenland"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.7245, 12.}, {-61.7391, 11.9881}, {-61.7535, 
      11.9725}, {-61.7828, 11.9567}, {-61.8286, 11.9641}, {-61.8393, 
      11.9772}, {-61.8361, 11.9913}, {-61.8294, 12.}, {-61.7847, 
      12.0363}, {-61.7807, 12.1007}, {-61.7542, 12.1333}, {-61.7066, 
      12.1624}, {-61.6524, 12.1791}, {-61.6259, 12.1756}, {-61.6034, 
      12.1606}, {-61.5995, 12.1359}, {-61.6206, 12.0557}, {-61.6206, 
      12.0302}, {-61.6392, 12.0196}, {-61.6987, 12.0125}, {-61.7245, 12.}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Grenada\"", "Panel", Background -> None, StripOnInput -> False],
            "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnWtsFFUUx/+0UFJqsKIVfDSFflAwjTGKz4CCaFKaNCnER0KUkvpAg4IJ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              "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnWtsFFUUx/+0UFJqsKIVfDSFflAwjTGKz4CCaFKaNCnER0KUkvpAg4IJ
kmhUgg8EY+SlEuxjWyivFm1LW2gFaqGlLCUFovHxBY1f1JiAMdEQMMDxzJ0d
mKHblt25d+/scpN/k5nt7Lnn/HZ27py7596ZULZodlk6gGL+W8Z/1jYZGRmp
1lTQRGc7D1Tk22ApKMvZLgTd4s/a9aDZzvZIUJluXNI1AXQY9BTocVA36F7f
Bl8CNYIKQG+D9oKG+TbI1j4ETQLVgZboxqVCO0HHhJj/cN/WChxrrHdkuPea
y+CDullJVy6o2YmuE3SHP2t8tj/twvU56Dp/BjNAK10G5+jGJVePinP+mEu9
4loUnzW+1H/htcbqEFe2+AzyubGtn8EVoFG6uUnRCNA9oMlCe5yLv72b5c/y
eAHqTd8eTnT8+cg5+e1dn316ALUYtFyqwUYZXflF3Q06IE4Y7aAUiS/706Ua
5LvQNHnWuFt5WTcirz54Ee11ON5qFI8YHQP0w3/aYoyswMIG/NkDOmJ0pWJc
DI3RMUCf/FFuKasSb+3E32H9oQVcjIhBMS6bmyz+tsZUYWULTh/WH2YAxVgY
DiNyE5PL39ZNIazfjf969YccEDEKBsJY+rNSwd9Wfg1q23H+6v4UOHyGwCgG
oqSOv62CTWjaq5+DFnHgHP7gfFTzt3X/ZnR06AeSMHGwHPKVkEkMf1sztqK3
Uz8cpeIAOcwrZ5JI/rZK6vD9Af2gpIuD4tBipZF4/qy0cszdgV+69UOTIg6E
w0mLnYMu/rZGlGNBA/5I5sSZnecQRsRLQC9/W6Mq8EYT/jqkH2ZMYofZbXbe
Z/ja+dvKrsLyFvybDMMX7CS7ml0lJ/CA8Lc1NoR1u3A2qMMX7Bi7NzZaGpsa
/G3lVaO6DeeClDizM+wSOyY92ADytzVpI77co588i91gZxSFGVj+tibX4ut9
2shz0+yA0gADzj/i5FYcSmzizM1NiyWNTW3+toq341v1iTM3wQ0lLKgk4g+R
OM+pxwk1iTObZePxpbHB5F9Qi0/b0dPlK0Psr+HlmP8Vfhs8cd4FWiOKBteC
uoYgz6bY4PDEklfKf0wI69tx7qhVsDRzC4oXYMoS6/WovwHFp8wKvN6Ik/0T
5/2gx7x+ZogSu9Yo5PntbCTTdxobKP7jQvg5HKnT62vFj+OsI9dNxwNbsLZN
sv+jK/FuM/65mDg3iFLqqN5eA3r/Enl+C79xdKVkf4LAP9x1qU7ywhORI6sf
Ql83dn2jJIqcKqxqxRnuF24TzeV6iwPTQPeJjXRQDc4ctg7OkTSAEDT+/F2+
cNRVp3pr5Mi+Zdbudz0KY/msyHHsWnEVmim2bwaFQM9F/nUqD/n6rjYJ4D9x
o7dOOFMcWRj5UH7vVRVI+gacdldmhkTra53KatdFqehV/djV8c+r8fLPBs0X
c1vEbud+VYHcudTrW6nLhwbPv5YW68eujj/3aB7+XZ7d1bL734sqnedyLB9U
72o37JlN0HiXfuzq+A8rj9x2RtWselWBFC50vJoFOhSt9dWiXwA2PKwfuzr+
rFO90eHX71MYyA2fCJeynMkRrEWi3Z2uV8Zbxzz/rH7sSvmfCHuwnzyCNW1W
Lqw6lh9yve7dCOJv4gLPi+fTMHWFfuxK+f8kvv7nj6K9E0/uQIb6+72ckHVL
f7ZG3OG7PdwEut37yjzn/l/qz1iB4v9rGB/vRm51Ivy/PP99xevhDO8ufxY9
qZ//yvptenANOP6zCpTTz1VOgZ8RucBVMP6jWpHxz4MDD2l2gN4DzQVNAZWI
6erbBh3/PJhq45+KZMb/NfI3v3/p4m9+/9XF36p/0DdxgJu+ausfTP2PLv55
NUGtfxt4Gldq8Df1n7r4W/XPzclT/9ycOvXPkfr/ZCDvFjuc7PX/Zv6LLv5m
/pdG/iXbU3f+Y+yJs5n/K1fBnP9r5r/r4m+t/xCMNDbx4sA1rv9g1j8hTeuf
mPV/LlPC1v8x618NIqXrX1nrvzWZ9d+GlrX+W5PM9d8i6x8m2wICesW4pKx/
aK3/WY/jLUbxiNH5XP/TKEVknn+hV+b5F9plnn+hUeb5Fxplnn+hUdKff5Em
znbuUIoFqHWiZx8r+s34PDTPv4hPfBVqAz0iz6B5/kWsekEqruA9/0K+/N/5
qLOmwuBQ+h9saadG
          "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], {
        Style["Grenada", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnWtsFFUUx/+0UFJqsKIVfDSFflAwjTGKz4CCaFKaNCnER0KUkvpAg4IJ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        "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}], "Grenada"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-61.6069, 16.0991}, {-61.5872, 15.9472}, {-61.618, 
       15.8651}, {-61.6538, 15.8404}, {-61.6919, 15.8405}, {-61.724, 
       15.8552}, {-61.7696, 15.916}, {-61.8102, 16.049}, {-61.8188, 
       16.2181}, {-61.7955, 16.2789}, {-61.7634, 16.3002}, {-61.7326, 
       16.3035}, {-61.7141, 16.3018}, {-61.6464, 16.2649}, {-61.6119, 
       16.2567}, {-61.5811, 16.26}, {-61.5367, 16.2895}, {-61.5293, 
       16.3109}, {-61.5601, 16.3626}, {-61.5613, 16.3881}, {-61.5281, 
       16.4135}, {-61.4665, 16.4324}, {-61.4258, 16.4267}, {-61.4061, 
       16.4045}, {-61.4073, 16.3544}, {-61.395, 16.3355}, {-61.3297, 
       16.2945}, {-61.3002, 16.2682}, {-61.2238, 16.2419}, {-61.2016, 
       16.2288}, {-61.2102, 16.2082}, {-61.2472, 16.1959}, {-61.4382, 
       16.1877}, {-61.5404, 16.2}, {-61.591, 16.2017}, {-61.623, 
       16.1918}, {-61.6328, 16.1746}, {-61.6328, 16.1541}, {-61.6193, 
       16.1245}, {-61.6069, 16.0991}}, {{-61.1798, 15.9371}, {-61.1777, 
       15.9202}, {-61.1856, 15.9064}, {-61.2062, 15.8915}, {-61.2322, 
       15.8851}, {-61.2727, 15.8822}, {-61.3096, 15.8847}, {-61.3453, 
       15.8988}, {-61.3646, 15.9149}, {-61.3658, 15.9294}, {-61.3507, 
       15.942}, {-61.3211, 15.9537}, {-61.2654, 15.9557}, {-61.211, 
       15.9504}, {-61.1798, 15.9371}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Guadeloupe\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXAd0FVUavumEkgQiIYYACaGZhCA1lBA6CR0RQhOQ0AxSBQyo9ABiEEVX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              "], {{0, 0}, {120, 80}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {120, 80}, PlotRange -> {{0, 120}, {0, 80}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXAd0FVUavumEkgQiIYYACaGZhCA1lBA6CR0RQhOQ0AxSBQyo9ABiEEVX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          "], {{0, 0}, {120, 80}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {120, 80}, PlotRange -> {{0, 120}, {0, 80}}]], {
        Style["Guadeloupe", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztXAd0FVUavumEkgQiIYYACaGZhCA1lBA6CR0RQhOQ0AxSBQyo9ABiEEVX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        "], {{0, 0}, {120, 80}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {120, 80}, PlotRange -> {{0, 120}, {0, 80}}], 
      "Guadeloupe"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{144.634, 13.4367}, {144.624, 13.4568}, {144.628, 
      13.4758}, {144.648, 13.4885}, {144.738, 13.5215}, {144.79, 13.5649}, {
      144.843, 13.6436}, {144.852, 13.6521}, {144.886, 13.6423}, {144.957, 
      13.6155}, {144.988, 13.5915}, {144.982, 13.5683}, {144.952, 13.5415}, {
      144.849, 13.4782}, {144.831, 13.4465}, {144.795, 13.3803}, {144.779, 
      13.3212}, {144.742, 13.288}, {144.705, 13.2773}, {144.669, 13.2865}, {
      144.655, 13.3027}, {144.663, 13.3381}, {144.634, 13.4367}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Guam\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztnHlQE1ccx6m2VatO7fSkRTvWjng0cYCRohEQGJDDhkvwrDOCMCparMWj
gEoVSuSwgKCAHCJHOAJCDAQSEhIIIbtACIEEw316UZVRqNXRaX9xKWUq/3XG
JZud+SSz2exv5vs+7+17bxkmy30CPXzmGhgYbIZXGLy0x0IDYxISPSfrQ9tQ
ih/JGwOET/cfbvw9bVc2yRsDhJP+Sf96C+mf9K/PkP5J//oM6Z/0r8+Q/kn/
+gwB/AdYBHHmm5QuWu9jdRr3MHrl38E9OfUzR4gt374DdfaAg8tG39l5puIe
TB/8uzvHlixcL5y7avDS0ZfPsoCBmAD4WLzYws3lIu7xiO0fDFfNo4oXU0c5
ZzH5GA8E58WfmHHfoXo5RuEekqj+rb0zyg1pYkPzh00Xp8vH+KMvUfI1jb3A
1IV+CfeohPSfRt0mMDAuS2eVq9oUQzW3H5Y9e5o9vQvGpAyYiPI/2GS5/Rru
aQnmP3BDEOTUHNqlucOr7FDcaOsoVykFnc3sdlVZu1rU1fT7GAu6oCd0P1x2
jrIP98BE8u/smiiYt1b6lcXzR2nYUH/x57WxJwWdd6v4t1qKlRpuR+vYWM7j
0dQXE5moqbVgzip351m9FuuW/8h1+yDkfX7E6BgL6ZeIuhph2IP2ao185EEZ
MD6RV5Fziplw9NHdlMctMTBNXVyzG/fYxPAPkzl3kRmPSgfhRaLqgqLU/OtR
zNSzGAVlOXC+kM9mJgXxRDlwRzwZZ8qtHQQLKDZeabiHJ4D/A7RTkJBzNkHr
v6qUV8sXyeUCRRunpkbahLBYacWonJkWxpIhcAHAVqmQOAaUBFsF4R6eAP5z
lzoJ5lNKGlowvcMPnrx89hfGnYfjcKaAlVbEY2PfToIqBYtMyr6wxT28rvt3
8EiGeDXuAXXdAxhI7/Dzpy9Bfv/ocAKamMSPyswJiUMS/gPL1R0K6VvjcW+C
Tvv3dtDOJNILVxv7R6YYn3g++miioXfQrzL8zGVfer4/Q8oMq82IrM8JFiX7
cM8lIKWJRw9A4V6bX3Bvgk77998UDPEaMoqn5Df1j9x7OI4do72D7KKk6V0z
BZRA4Q/mx3Bvgk77P2ESAPFknJopsfKB21PHtc0Ij18yo39ZlQQKz6z1xb0J
Ou0/YuUeiIegbZNifwxvPRKmGLqjYKR0pBdWi7nqLjXiH9y0+5gi+qryBKM1
KEI+qO0gpK0TCmOXe+HeBJ32H79Mu4yimj7MvzI0tr1B3jZyT8lIURdUCGsr
Jc2y+1K57Hhk84nIPoG0L5U5dQsI36WkGDrh3gSd9o/lROqaMaUKZWeXSAYj
vCP/ZjtfIuKUiBvrb/UMIU0qZUll+8i9jhs8bPyjqm4ojCHH//8jyPSwdv5n
ls84yfOFbFgCZvwKqW6AwtBv/HBvgk77328Zot1/Rqe/bjhdzuNXl9bJG3ka
9Qz7n2w2FB62mKWPwLri39MpGuJJAn+d7lbYdQvePcuCAlkhnMYasxzv1/3X
R6VB4R67cNyboNP+bbzS+HPWiL/1mu72YBVD1jf0s+jKxuteQZUxB6oYcPJK
480bqsZ/t6aeRwQGxlvcr+DeBJ32D8R96QEmETE65TZamm9X5HdafHVlhqNN
/j5OR8txYaJtoa+4u3vyuay9SzifkmzojHt4AvjfbRcOCesOnwOxPI2qtrsH
G+0WeTtXZDjYF/ofqrrgxw0XdXVOdZCUkQolvlahuIcngH+g4H2a8FMa2jsk
6endwwn1r4zw5Z43yfYE/6uuuaQ0VSB9w7LewVyFWNY7AP5FJm6lC9dv2pGF
e3Ji+P/J7Mj0XVC+UpLVIihRoTDnmOZsgx4xz91BzXKjlwRqdz55N+HiEMos
3Xnqon9YhYsXmle/t05WO7nCstXN+7nnnViHwmoz45ESvkYN3YH2D6NyteDj
DRXz1tl7zNKVVxf90179IRo2QjVUV7R7MKOFB3uevFaxZf5eeD8pTArgRWln
nr5hkbW2XQc3nsQ9MMH80/55FsYWYozVmVtL27V3RKmqSdrTXx/yG1wQv8wN
96iE9A8kGtFhLyo5FglDHbRvYR2EBwFtX/QN15+MEby1OusjW2vvDNxzEtW/
3bbUvCWWEFi0xRdV99S92ouiSo3YXvsPKrlLrOw9UnAPSWD/tFdrcfLnLpCZ
v8IBqWuWcWurjazh4yUj+mbvdNzjEd4/ABv7YKo/b84aLDz3bQosDbSd13EP
pif+Mehb4xKWusYu93J0S8I9jB7612lI/6R/fYb0T/rXZ0j/pH99hvRP+tdn
SP+kf32G9D+r/JO/P4zv7w+TkOgnfwM6h2Ho
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztnHlQE1ccx6m2VatO7fSkRTvWjng0cYCRohEQGJDDhkvwrDOCMCparMWj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          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["Guam", "Panel", Background -> None]}, {{Top, Left}}], Editable -> 
      False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJztnHlQE1ccx6m2VatO7fSkRTvWjng0cYCRohEQGJDDhkvwrDOCMCparMWj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        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], "Guam"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-88.91666666666667, 15.9}, {-88.21666666666667, 
      15.716666666666667`}, {-89.35, 14.433333333333334`}, {-90.1, 
      13.75}, {-92.25, 14.549999999999999`}, {-91.73333333333333, 
      16.066666666666666`}, {-90.43333333333334, 16.1}, {-90.98333333333333, 
      17.816666666666666`}, {-89.13333333333333, 
      17.816666666666666`}, {-88.91666666666667, 15.9}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Guatemala\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2FtMWnccB3CTPextT8uSPixbly1Zolk2s2wPPuyhPizN0nQ+bFo7tznX
au0ttJE2uuKlnbZeKtYwL6WzR8EbXigqchFBBZGLCAgKKmAtdYjgDURQ6f7d
SahZFmfF5Dyc3z9fkvP//f/nH/I5J4f/4Xj6laT0N2JiYk6jTz76vDyOOfeC
wJxmvCC2oS9ArAD4E44A/qQN+IM/4QjgT9qAP/gTjgD+pA34gz/hCOBP2oA/
+BOOAP6kDfiDP+EI4E/agD/4E44A/qQN+IM/4QjgT9qAP/gTjgD+pA34gz/h
COBP2ryWf2hnWz2r6xsX/SF4hLrBYFCr1RoMBp/PJzJIr2O3BBMD7GHO1nYQ
/I/c37k4j0lbuEoevZMuUkq0kzqn02m1Wi0Wi1AoVBk0LeIORncxraVYoRta
dtjB/wj9bSplzkfvdovb2oWYQXHvNisnpzEfH5LL5Vwu90FbZSXroqC/iM5l
XD35JeWDY+suF/gflb/Xu/RbQjwtMaGqt1Y+9ojXQ5tyWCKjyP8mrYjRXMjo
Ksy8eSb7rTevJX2Fnkjgf1T+CosqrzaP8smHPbV01A1th0QKzZJnBR81Wm3U
/Ds1dbXPPYtX4o6zKZfvtVYWccqC2yHwj9I/ENqady9MTBsYfUyL1Vh39aLN
4cCHZGq907WsmbRoTdZQKJSYmCiWSLBrl5bW3GwZR6YdqeAxxm0G8I/Gf9W/
ViNsKGutQhubl7e6WtXZ+Hh7awsfbeQK+4bG8GNuI3Y2NXVjbXU3vHuJSa3h
MZlilmvVDf6H9t/Z3enVCkta7tcPNG4ENvDijGKk/fb5/o4b46P02an2aTNf
bxxymjUVp74+n5ERDofRnN5xYRW/tohdere7CvwP7Y/aM89zvlzQPMLZW/yz
+swT7LsJya8LusuRWDX3s7KyVCoVmrDmX38sbe6W9aATIxcO/F/X3xfwjc1o
RGOSXo0wUlx0e7jcGnZdOjK3q7JfXQJ9blpaWkVFBT4N/WSP6dVNQ22mhWnw
P5w/av26gSZRm9Qkx7u74bB/M4AOHGNVZuHP2uYUbVvqRMdZ5L808+DhQyaF
QsFnUpvyb2F3kP/+64P//k1nN+Y3laBd0N5i0P90Tn5hSvjLZO9PanayruMH
BTPJ71GLRKKIf5OsjVKfyxrm/Neq4H9Q/xXfaiHr7pBZsbe4ZKVPcFK1rSnq
lhQ9N212JHPRVBAOb3d1dbFYLHyOSD/YJGp9uuwE/2j89Y5JpUFVyCl1ehfx
SmB9KvLMn5Nnzckz7cqsns5qNESlUl3//O3g9a2iLWinjNeh5IF/NP6oYZIW
agMNvQXge8sZA7uUdoJd861Reg6/Cn9NlQgE/eXl5QUFBfgpWpuexiru14gX
4P6Pzn/e/UzvME1bp2cXbagrlUr5PKzq92/0g682n1Oj2XpDb0JCAoZhAoEA
TUN7HoPZKDPJ7a558I/GH73MSiaHMXFzWVd1t/iJ3W73er2RUUbuhYyE9z77
8cTH8XFoyO12o+fPqHI0q/56j7K/YZD9P6uD/wGeP65Vd/NIxw1mfjG7Al2O
SD2w6fv+i3diT8bHff4pwo/UzbbpPGZRl6pn/zcv8D+gP2pbwS3jnMmz4d1b
9Kx4337/WHJyst/v/9f8SYd5M7B5kJXBP5oWGxvL5/OjWQH8iW3gD/7gT9qA
P/gTjgD+pA34gz/hCOBP2oA/+BOOAP6kDfiDP+EI4E/agD/4E44A/qQN+IM/
4QjgT9qAP/gTjgD+pA34gz/hCOBP2oA/+BOOAP4E5m83Ue+Z
              "], {{0, 0}, {128, 80}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 80}, PlotRange -> {{0, 128}, {0, 80}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2FtMWnccB3CTPextT8uSPixbly1Zolk2s2wPPuyhPizN0nQ+bFo7tznX
au0ttJE2uuKlnbZeKtYwL6WzR8EbXigqchFBBZGLCAgKKmAtdYjgDURQ6f7d
SahZFmfF5Dyc3z9fkvP//f/nH/I5J4f/4Xj6laT0N2JiYk6jTz76vDyOOfeC
wJxmvCC2oS9ArAD4E44A/qQN+IM/4QjgT9qAP/gTjgD+pA34gz/hCOBP2oA/
+BOOAP6kDfiDP+EI4E/agD/4E44A/qQN+IM/4QjgT9qAP/gTjgD+pA34gz/h
COBP2ryWf2hnWz2r6xsX/SF4hLrBYFCr1RoMBp/PJzJIr2O3BBMD7GHO1nYQ
/I/c37k4j0lbuEoevZMuUkq0kzqn02m1Wi0Wi1AoVBk0LeIORncxraVYoRta
dtjB/wj9bSplzkfvdovb2oWYQXHvNisnpzEfH5LL5Vwu90FbZSXroqC/iM5l
XD35JeWDY+suF/gflb/Xu/RbQjwtMaGqt1Y+9ojXQ5tyWCKjyP8mrYjRXMjo
Ksy8eSb7rTevJX2Fnkjgf1T+CosqrzaP8smHPbV01A1th0QKzZJnBR81Wm3U
/Ds1dbXPPYtX4o6zKZfvtVYWccqC2yHwj9I/ENqady9MTBsYfUyL1Vh39aLN
4cCHZGq907WsmbRoTdZQKJSYmCiWSLBrl5bW3GwZR6YdqeAxxm0G8I/Gf9W/
ViNsKGutQhubl7e6WtXZ+Hh7awsfbeQK+4bG8GNuI3Y2NXVjbXU3vHuJSa3h
MZlilmvVDf6H9t/Z3enVCkta7tcPNG4ENvDijGKk/fb5/o4b46P02an2aTNf
bxxymjUVp74+n5ERDofRnN5xYRW/tohdere7CvwP7Y/aM89zvlzQPMLZW/yz
+swT7LsJya8LusuRWDX3s7KyVCoVmrDmX38sbe6W9aATIxcO/F/X3xfwjc1o
RGOSXo0wUlx0e7jcGnZdOjK3q7JfXQJ9blpaWkVFBT4N/WSP6dVNQ22mhWnw
P5w/av26gSZRm9Qkx7u74bB/M4AOHGNVZuHP2uYUbVvqRMdZ5L808+DhQyaF
QsFnUpvyb2F3kP/+64P//k1nN+Y3laBd0N5i0P90Tn5hSvjLZO9PanayruMH
BTPJ71GLRKKIf5OsjVKfyxrm/Neq4H9Q/xXfaiHr7pBZsbe4ZKVPcFK1rSnq
lhQ9N212JHPRVBAOb3d1dbFYLHyOSD/YJGp9uuwE/2j89Y5JpUFVyCl1ehfx
SmB9KvLMn5Nnzckz7cqsns5qNESlUl3//O3g9a2iLWinjNeh5IF/NP6oYZIW
agMNvQXge8sZA7uUdoJd861Reg6/Cn9NlQgE/eXl5QUFBfgpWpuexiru14gX
4P6Pzn/e/UzvME1bp2cXbagrlUr5PKzq92/0g682n1Oj2XpDb0JCAoZhAoEA
TUN7HoPZKDPJ7a558I/GH73MSiaHMXFzWVd1t/iJ3W73er2RUUbuhYyE9z77
8cTH8XFoyO12o+fPqHI0q/56j7K/YZD9P6uD/wGeP65Vd/NIxw1mfjG7Al2O
SD2w6fv+i3diT8bHff4pwo/UzbbpPGZRl6pn/zcv8D+gP2pbwS3jnMmz4d1b
9Kx4337/WHJyst/v/9f8SYd5M7B5kJXBP5oWGxvL5/OjWQH8iW3gD/7gT9qA
P/gTjgD+pA34gz/hCOBP2oA/+BOOAP6kDfiDP+EI4E/agD/4E44A/qQN+IM/
4QjgT9qAP/gTjgD+pA34gz/hCOBP2oA/+BOOAP4E5m83Ue+Z
          "], {{0, 0}, {128, 80}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 80}, PlotRange -> {{0, 128}, {0, 80}}]], {
        Style["Guatemala", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2FtMWnccB3CTPextT8uSPixbly1Zolk2s2wPPuyhPizN0nQ+bFo7tznX
au0ttJE2uuKlnbZeKtYwL6WzR8EbXigqchFBBZGLCAgKKmAtdYjgDURQ6f7d
SahZFmfF5Dyc3z9fkvP//f/nH/I5J4f/4Xj6laT0N2JiYk6jTz76vDyOOfeC
wJxmvCC2oS9ArAD4E44A/qQN+IM/4QjgT9qAP/gTjgD+pA34gz/hCOBP2oA/
+BOOAP6kDfiDP+EI4E/agD/4E44A/qQN+IM/4QjgT9qAP/gTjgD+pA34gz/h
COBP2ryWf2hnWz2r6xsX/SF4hLrBYFCr1RoMBp/PJzJIr2O3BBMD7GHO1nYQ
/I/c37k4j0lbuEoevZMuUkq0kzqn02m1Wi0Wi1AoVBk0LeIORncxraVYoRta
dtjB/wj9bSplzkfvdovb2oWYQXHvNisnpzEfH5LL5Vwu90FbZSXroqC/iM5l
XD35JeWDY+suF/gflb/Xu/RbQjwtMaGqt1Y+9ojXQ5tyWCKjyP8mrYjRXMjo
Ksy8eSb7rTevJX2Fnkjgf1T+CosqrzaP8smHPbV01A1th0QKzZJnBR81Wm3U
/Ds1dbXPPYtX4o6zKZfvtVYWccqC2yHwj9I/ENqady9MTBsYfUyL1Vh39aLN
4cCHZGq907WsmbRoTdZQKJSYmCiWSLBrl5bW3GwZR6YdqeAxxm0G8I/Gf9W/
ViNsKGutQhubl7e6WtXZ+Hh7awsfbeQK+4bG8GNuI3Y2NXVjbXU3vHuJSa3h
MZlilmvVDf6H9t/Z3enVCkta7tcPNG4ENvDijGKk/fb5/o4b46P02an2aTNf
bxxymjUVp74+n5ERDofRnN5xYRW/tohdere7CvwP7Y/aM89zvlzQPMLZW/yz
+swT7LsJya8LusuRWDX3s7KyVCoVmrDmX38sbe6W9aATIxcO/F/X3xfwjc1o
RGOSXo0wUlx0e7jcGnZdOjK3q7JfXQJ9blpaWkVFBT4N/WSP6dVNQ22mhWnw
P5w/av26gSZRm9Qkx7u74bB/M4AOHGNVZuHP2uYUbVvqRMdZ5L808+DhQyaF
QsFnUpvyb2F3kP/+64P//k1nN+Y3laBd0N5i0P90Tn5hSvjLZO9PanayruMH
BTPJ71GLRKKIf5OsjVKfyxrm/Neq4H9Q/xXfaiHr7pBZsbe4ZKVPcFK1rSnq
lhQ9N212JHPRVBAOb3d1dbFYLHyOSD/YJGp9uuwE/2j89Y5JpUFVyCl1ehfx
SmB9KvLMn5Nnzckz7cqsns5qNESlUl3//O3g9a2iLWinjNeh5IF/NP6oYZIW
agMNvQXge8sZA7uUdoJd861Reg6/Cn9NlQgE/eXl5QUFBfgpWpuexiru14gX
4P6Pzn/e/UzvME1bp2cXbagrlUr5PKzq92/0g682n1Oj2XpDb0JCAoZhAoEA
TUN7HoPZKDPJ7a558I/GH73MSiaHMXFzWVd1t/iJ3W73er2RUUbuhYyE9z77
8cTH8XFoyO12o+fPqHI0q/56j7K/YZD9P6uD/wGeP65Vd/NIxw1mfjG7Al2O
SD2w6fv+i3diT8bHff4pwo/UzbbpPGZRl6pn/zcv8D+gP2pbwS3jnMmz4d1b
9Kx4337/WHJyst/v/9f8SYd5M7B5kJXBP5oWGxvL5/OjWQH8iW3gD/7gT9qA
P/gTjgD+pA34gz/hCOBP2oA/+BOOAP6kDfiDP+EI4E/agD/4E44A/qQN+IM/
4QjgT9qAP/gTjgD+pA34gz/hCOBP2oA/+BOOAP4E5m83Ue+Z
        "], {{0, 0}, {128, 80}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 80}, PlotRange -> {{0, 128}, {0, 80}}], 
      "Guatemala"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-2.74065, 49.4329}, {-2.70755, 49.4445}, {-2.6658, 
       49.4735}, {-2.6449, 49.4817}, {-2.6188, 49.4828}, {-2.6101, 
       49.4689}, {-2.6136, 49.4109}, {-2.631, 49.397}, {-2.6571, 
       49.383}, {-2.7215, 49.3819}, {-2.7511, 49.3854}, {-2.77195, 
       49.3923}, {-2.77195, 49.4074}, {-2.7528, 49.4283}, {-2.74065, 
       49.4329}}, {{-2.4448, 49.4329}, {-2.4204, 49.4329}, {-2.4065, 
       49.4306}, {-2.3856, 49.4144}, {-2.3856, 49.3993}, {-2.403, 
       49.3877}, {-2.42565, 49.3877}, {-2.4465, 49.3912}, {-2.4535, 
       49.4109}, {-2.4587, 49.4248}, {-2.4448, 49.4329}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Guernsey\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt3UFKQkEAh3GhLtAmWgWBQpuuYFeIoEXL9ABtO0odqwO0byG6cFOrlxMI
j5hRe+jMvM/vg/9KQ978KEkUrybP95OTwWBwt9rLaqerNZA+z272Oqsrfdnp
y05fdvqy05edvuz0ZacvO33ZtW1m4+vm6/2i+f4432nhvuFn9K23v79/uxrH
bPWtr9jf2G3GKVt96yv1PLqYDJO+4Taff/tRymn+OEr6htv07Uf6stOXnb7s
9GWnLzt92enLTl92+rLTl52+7PRlpy87fdnpGy91fZR19XX9mL7s6Vtms9v4
+9qIvrmutab9vncxw3WX9g3XGK619HnnXjjfHMYlfde24bFKn3cJ37Xx4mnY
zB9GB9ny9TLpu3y7PNjjhmtqv/e69HmX8j2WlT5vffXVV1999dWXv9LnrW8e
X/8/Ym5tm/r87b5W9PWN8fG+vpHDtrRv27j0eedeDtsafHNe6zGuBl+nr9O3
yyjt29fqSl92+rLTl52+7PRlpy87fdnpy05fdvqy05edvuz0ZacvO33ZpZwW
0w3frzH1+zX6Usyo/fnb2DZ9/tjq6r+224ytrrrYbjK2uko9j3ad1ZW+7PRl
py87fdnpy05fdvqy05edvvF+ABJjAPg=
              "], {{0, 0}, {120, 80}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {120, 80}, PlotRange -> {{0, 120}, {0, 80}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt3UFKQkEAh3GhLtAmWgWBQpuuYFeIoEXL9ABtO0odqwO0byG6cFOrlxMI
j5hRe+jMvM/vg/9KQ978KEkUrybP95OTwWBwt9rLaqerNZA+z272Oqsrfdnp
y05fdvqy05edvuz0ZacvO33ZtW1m4+vm6/2i+f4432nhvuFn9K23v79/uxrH
bPWtr9jf2G3GKVt96yv1PLqYDJO+4Taff/tRymn+OEr6htv07Uf6stOXnb7s
9GWnLzt92enLTl92+rLTl52+7PRlpy87fdnpGy91fZR19XX9mL7s6Vtms9v4
+9qIvrmutab9vncxw3WX9g3XGK619HnnXjjfHMYlfde24bFKn3cJ37Xx4mnY
zB9GB9ny9TLpu3y7PNjjhmtqv/e69HmX8j2WlT5vffXVV1999dWXv9LnrW8e
X/8/Ym5tm/r87b5W9PWN8fG+vpHDtrRv27j0eedeDtsafHNe6zGuBl+nr9O3
yyjt29fqSl92+rLTl52+7PRlpy87fdnpy05fdvqy05edvuz0ZacvO33ZpZwW
0w3frzH1+zX6Usyo/fnb2DZ9/tjq6r+224ytrrrYbjK2uko9j3ad1ZW+7PRl
py87fdnpy05fdvqy05edvvF+ABJjAPg=
          "], {{0, 0}, {120, 80}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {120, 80}, PlotRange -> {{0, 120}, {0, 80}}]], {
        Style["Guernsey", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt3UFKQkEAh3GhLtAmWgWBQpuuYFeIoEXL9ABtO0odqwO0byG6cFOrlxMI
j5hRe+jMvM/vg/9KQ978KEkUrybP95OTwWBwt9rLaqerNZA+z272Oqsrfdnp
y05fdvqy05edvuz0ZacvO33ZtW1m4+vm6/2i+f4432nhvuFn9K23v79/uxrH
bPWtr9jf2G3GKVt96yv1PLqYDJO+4Taff/tRymn+OEr6htv07Uf6stOXnb7s
9GWnLzt92enLTl92+rLTl52+7PRlpy87fdnpGy91fZR19XX9mL7s6Vtms9v4
+9qIvrmutab9vncxw3WX9g3XGK619HnnXjjfHMYlfde24bFKn3cJ37Xx4mnY
zB9GB9ny9TLpu3y7PNjjhmtqv/e69HmX8j2WlT5vffXVV1999dWXv9LnrW8e
X/8/Ym5tm/r87b5W9PWN8fG+vpHDtrRv27j0eedeDtsafHNe6zGuBl+nr9O3
yyjt29fqSl92+rLTl52+7PRlpy87fdnpy05fdvqy05edvuz0ZacvO33ZpZwW
0w3frzH1+zX6Usyo/fnb2DZ9/tjq6r+224ytrrrYbjK2uko9j3ad1ZW+7PRl
py87fdnpy05fdvqy05edvvF+ABJjAPg=
        "], {{0, 0}, {120, 80}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {120, 80}, PlotRange -> {{0, 120}, {0, 80}}], "Guernsey"],
      "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-13.299999999999999`, 
      9.033333333333333}, {-15.016666666666666`, 
      10.95}, {-13.716666666666667`, 12.683333333333334`}, {-11.35, 
      12.466666666666667`}, {-11.366666666666667`, 12.4}, {-8.983333333333333,
       12.4}, {-7.983333333333333, 10.15}, {-7.966666666666667, 
      10.166666666666666`}, {-8.466666666666667, 
      7.566666666666666}, {-10.266666666666666`, 
      8.483333333333333}, {-11.216666666666667`, 10.}, {-13.299999999999999`, 
      9.033333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Guinea\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt0EEJgEAURdEPJjHFxBAEC0wBK7iyg01s953BEH9z4D5467P2c+9LRBxj
19j8WdvdMqOw7W3xRGH8+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz//vA1tYBE0=
              "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt0EEJgEAURdEPJjHFxBAEC0wBK7iyg01s953BEH9z4D5467P2c+9LRBxj
19j8WdvdMqOw7W3xRGH8+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz//vA1tYBE0=
          "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}]], {
        Style["Guinea", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt0EEJgEAURdEPJjHFxBAEC0wBK7iyg01s953BEH9z4D5467P2c+9LRBxj
19j8WdvdMqOw7W3xRGH8+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPnz58/f/78+fPn
z58/f/78+fPnz58/f/78+fPnz//vA1tYBE0=
        "], {{0, 0}, {128, 85}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 85}, PlotRange -> {{0, 128}, {0, 85}}], "Guinea"], 
     "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-16.716666666666665`, 12.316666666666666`}, {-15., 
      11.966666666666667`}, {-15.5, 
      11.333333333333334`}, {-15.016666666666666`, 
      10.95}, {-13.716666666666667`, 
      12.683333333333334`}, {-16.716666666666665`, 12.316666666666666`}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"GuineaBissau\"", "Panel", Background -> None, StripOnInput -> 
            False], "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJzt2z9Im0EcxvHn/XOCRdBughhJ6SB2KrbgoKLQoVOhQii41bFLXJQOHbI5
tXRzcXETVFxEHAQ3wUKHihk6WDqERgVx6dLJni9G2zfJ6733vuSO4zm+ASEv
GT6+7+8uQ4pz5Zm5AMCUfFXk6/rvU3TZWX3w0dD7l85n3Jn+dkZ/+tPf+Yw7
09/O6E9/+jufcWf62xn96U9/5zPuTH87oz/96e98xp3pb2f0pz/9nc+4M/3t
jP4JHUJ8RnDvZVsINxDSP3f/OkQ/8Ar+d4iWF9Qg5uGHwFGbC+ifxV/2Fj6A
AWCr6Q6XT8coPPnuc3jan0//5NYh7+7rJaHL8GuN+3wZQQ9uVkVhRtFfLwne
h7v1FN4ewlL0UNyuQ93hQ3+V3vyvHVsjGYYP/VVabYyglmshw/Chv0o/IR60
99/XPXnSX7FthA/b+y9nu//PCt0Hx8POp4fzC2IRQZAwfaIlN4gT3S34vNB9
9bvgfBoyXyHGouO9yioCu1qDiP4tW0HYq0jfWHKT/oCgnvJBoH+sHxCziQfO
5DUB71uafwH9Y32B2ETY3BrC2DFU7rwtr0x1IqK/etP/bAePc/pNH/3V+4i7
o1AZPv077F+FuN0Y9rJ97aK/XuPRCCrk94Ni+qdqKRpB73IaPvRP2xGEfAB2
cho+9NfoNfy0X7Lon6N/NT98+huP/vSnv/MZd6a/ndGf/vR3PuPO9Lcz+tOf
/s5n3Jn+dkZ/+tPf+Yw709/O6E//DnQx9aITTT65mBxO1WXp2dWfT873F/El
+LE=
              "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJzt2z9Im0EcxvHn/XOCRdBughhJ6SB2KrbgoKLQoVOhQii41bFLXJQOHbI5
tXRzcXETVFxEHAQ3wUKHihk6WDqERgVx6dLJni9G2zfJ6733vuSO4zm+ASEv
GT6+7+8uQ4pz5Zm5AMCUfFXk6/rvU3TZWX3w0dD7l85n3Jn+dkZ/+tPf+Yw7
09/O6E9/+jufcWf62xn96U9/5zPuTH87oz/96e98xp3pb2f0pz/9nc+4M/3t
jP4JHUJ8RnDvZVsINxDSP3f/OkQ/8Ar+d4iWF9Qg5uGHwFGbC+ifxV/2Fj6A
AWCr6Q6XT8coPPnuc3jan0//5NYh7+7rJaHL8GuN+3wZQQ9uVkVhRtFfLwne
h7v1FN4ewlL0UNyuQ93hQ3+V3vyvHVsjGYYP/VVabYyglmshw/Chv0o/IR60
99/XPXnSX7FthA/b+y9nu//PCt0Hx8POp4fzC2IRQZAwfaIlN4gT3S34vNB9
9bvgfBoyXyHGouO9yioCu1qDiP4tW0HYq0jfWHKT/oCgnvJBoH+sHxCziQfO
5DUB71uafwH9Y32B2ETY3BrC2DFU7rwtr0x1IqK/etP/bAePc/pNH/3V+4i7
o1AZPv077F+FuN0Y9rJ97aK/XuPRCCrk94Ni+qdqKRpB73IaPvRP2xGEfAB2
cho+9NfoNfy0X7Lon6N/NT98+huP/vSnv/MZd6a/ndGf/vR3PuPO9Lcz+tOf
/s5n3Jn+dkZ/+tPf+Yw709/O6E//DnQx9aITTT65mBxO1WXp2dWfT873F/El
+LE=
          "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
         ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}]], {
        Style["GuineaBissau", "Panel", Background -> None]}, {{Top, Left}}], 
      Editable -> False, Selectable -> False]],
    Annotation[#, 
     Panel[
      Graphics[
       Raster[CompressedData["
1:eJzt2z9Im0EcxvHn/XOCRdBughhJ6SB2KrbgoKLQoVOhQii41bFLXJQOHbI5
tXRzcXETVFxEHAQ3wUKHihk6WDqERgVx6dLJni9G2zfJ6733vuSO4zm+ASEv
GT6+7+8uQ4pz5Zm5AMCUfFXk6/rvU3TZWX3w0dD7l85n3Jn+dkZ/+tPf+Yw7
09/O6E9/+jufcWf62xn96U9/5zPuTH87oz/96e98xp3pb2f0pz/9nc+4M/3t
jP4JHUJ8RnDvZVsINxDSP3f/OkQ/8Ar+d4iWF9Qg5uGHwFGbC+ifxV/2Fj6A
AWCr6Q6XT8coPPnuc3jan0//5NYh7+7rJaHL8GuN+3wZQQ9uVkVhRtFfLwne
h7v1FN4ewlL0UNyuQ93hQ3+V3vyvHVsjGYYP/VVabYyglmshw/Chv0o/IR60
99/XPXnSX7FthA/b+y9nu//PCt0Hx8POp4fzC2IRQZAwfaIlN4gT3S34vNB9
9bvgfBoyXyHGouO9yioCu1qDiP4tW0HYq0jfWHKT/oCgnvJBoH+sHxCziQfO
5DUB71uafwH9Y32B2ETY3BrC2DFU7rwtr0x1IqK/etP/bAePc/pNH/3V+4i7
o1AZPv077F+FuN0Y9rJ97aK/XuPRCCrk94Ni+qdqKRpB73IaPvRP2xGEfAB2
cho+9NfoNfy0X7Lon6N/NT98+huP/vSnv/MZd6a/ndGf/vR3PuPO9Lcz+tOf
/s5n3Jn+dkZ/+tPf+Yw709/O6E//DnQx9aITTT65mBxO1WXp2dWfT873F/El
+LE=
        "], {{0, 0}, {128, 64}}, {0, 255}, ColorFunction -> RGBColor], 
       ImageSize -> {128, 64}, PlotRange -> {{0, 128}, {0, 64}}], 
      "GuineaBissau"], "Tooltip"]& ], 
   TagBox[
    TooltipBox[
     PolygonBox[{{{-57.25, 5.483333333333333}, {-58.68333333333333, 
      6.383333333333333}, {-58.483333333333334`, 
      7.366666666666666}, {-59.983333333333334`, 
      8.533333333333333}, {-61.38333333333333, 5.95}, {-60.733333333333334`, 
      5.2}, {-59.666666666666664`, 4.383333333333333}, {-59.25, 
      1.3833333333333333`}, {-56.46666666666667, 1.95}, {-58.05, 4.}, {-57.25,
       5.483333333333333}}}],
     InterpretationBox[
      GridBox[{{
         ItemBox[
          TagBox[
           StyleBox[
           "\"Guyana\"", "Panel", Background -> None, StripOnInput -> False], 
           "Labeled", Editable -> True, Selectable -> True], 
          Alignment -> {Left, Inherited}]}, {
         TagBox[
          TagBox[
           PanelBox[
            GraphicsBox[
             RasterBox[CompressedData["
1:eJztXXdYVFcWf1MYYJiCgIgyNKPGqFmNRnftxpZVV0yI5UNXjCWJJvaNGl2V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              "], {{0, 0}, {128, 77}}, {0, 255}, ColorFunction -> RGBColor], 
             ImageSize -> {128, 77}, PlotRange -> {{0, 128}, {0, 77}}]], 
           "Labeled", Editable -> True, Selectable -> True], 
          "SkipImageSizeLevel"]}}, RowAlignments -> Center, ColumnAlignments -> 
       Center, BaselinePosition -> {2, 1}, ColumnWidths -> Automatic], 
      Labeled[
       Panel[
        Graphics[
         Raster[CompressedData["
1:eJztXXdYVFcWf1MYYJiCgIgyNKPGqFmNRnftxpZVV0yI5UNXjCWJJvaNGl2V
aNSs0Y2rWLGiYo/GICqCsWBBFBsiFnrvdahTzr6ZJ+O8N+8RhJm5bzD3+/F9
8+d7v3POfef+7jkHr2nzfKbxMAwbjf99j/9pfk+dPuXUvd3LLvgO2eXUe6vN
nzAzcBPIZLKQkJBaZc3t1Es/XZ3jvf8d5E/19gCrW76+vnl5eaBd8bkxgVGr
/Y71Qv54zR6Y3nJylAQfPgR6K7ss9eSj7XN/Hdlvuwj5ozZLdLDiYuQ1aqh7
+ouDoK7RN4S8pjT8xYmVYX7DAlshf+bmhOee0oX2NgKyCSQibMcakTpnMshP
g6pC3xAKleJu+pWfry/8NKgD8odvBkjysscR4SruacOjBMKAnpwXlwWQbA85
46E8GFQlQF4JBbH7otdNO9EX+VtYLgj+cSR6Stc52oq5HH0T4IGxfglf+dIa
kmwgSQTZo6FsHyjzKIbIk2eeid29MGTMgO0S5G9kWdDxTyDKTTJCaEUJhO6d
OQ9DBVoTEBBC1jAo2QaKdIohKmvlVxLOrA6f8fHuNshfzSJA4Z/ALme7VjxS
IPB52LKvedXx1npW0CKzPxRvhNpEiiGUKuWDzMgtN5aMO9QZ+TuyGbT843jk
If2nmPJZxjq25dw4IaCagED6h1C0BmqegMFKLnp2MGbDl6cG9dlqi/x92QYm
/gmcbC1qR05Q8aiY7ccrjzUIBB3SukDhcqi+Z2iIworc3+IOLA4dO2hnC+Qv
zhLUzz+OZ57S+fY2lE+CRxvs4gErRhMQSG0PBd9CVSSoVRRDVCsqI5POrbs8
c+Red+QMsJx/AuGu4g+tqQmq36fcwvvMgaBDijvkfwMV4aCupRhCrVbHZkdt
v7XCN7gbcirYzD+RoP6AJ6ikzzLm7Iid2PpHgfDaEC6QNx3kIaCqMtyd0ksS
jzz436zTw/puEyKnhYX8E7jtJhlukKB+MoybFdWAQNAh2RFyJ0H5CVCVGxqi
tKrwfPzht0QSf1P+CexwFjqTE1R7MbbnR/4bmOCVIaSQ7QNlB0FZaGgIjSSe
EvbT