(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13477,        451]
NotebookOptionsPosition[      7717,        272]
NotebookOutlinePosition[     11555,        381]
CellTagsIndexPosition[     11475,        376]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Front End Tokens", "Title",
 CellTags->"FrontEndTokenIntro",
 CellID->1511],

Cell["\<\
Front end tokens let you perform kernel commands that would normally be done \
using the menus. Front end tokens are particularly convenient for writing \
programs to manipulate notebooks.\
\>", "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->32125],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 " is a kernel command that identifies its argument as a front end token. ",
 Cell[BoxData[
  ButtonBox["FrontEndExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndExecute"]], "InlineFormula"],
 " is a kernel command that sends its argument to the front end for \
execution. For example, the following command creates a new notebook."
}], "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->11838],

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", "\"\<New\>\"", "]"}], "]"}]], "Input",
 CellTags->"FrontEndTokenIntro",
 CellLabel->"In[10]:=",
 CellID->27296],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrontEndExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndExecute"]], "InlineFormula"],
 " can take a list as its argument, allowing you to execute multiple tokens \
in a single evaluation. When you evaluate the following command, the front \
end creates a new notebook and then pastes the contents of the clipboard into \
that notebook."
}], "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->18939],

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FrontEndToken", "[", "\"\<New\>\"", "]"}], ",", " ", 
    RowBox[{"FrontEndToken", "[", "\"\<Paste\>\"", "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->11544],

Cell[CellGroupData[{

Cell["Simple and Compound Front End Tokens ", "Section",
 CellTags->"FrontEndTokenIntro",
 CellID->1056],

Cell["\<\
Front end tokens are divided into two classes: simple tokens and compound \
tokens that take parameters.\
\>", "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->12826],

Cell[CellGroupData[{

Cell["Simple Tokens", "Subsection",
 CellTags->"FrontEndTokenIntro",
 CellID->12902],

Cell[TextData[{
 "For simple tokens, ",
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 " can have one or two arguments."
}], "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->26758],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 " has one argument, the token operates on the input notebook. The following \
examples use the front end token ",
 Cell[BoxData[
  ButtonBox["\"\<Save\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/Save"]], "InlineFormula"],
 ". The result is the same as using ",
 StyleBox[ButtonBox["File",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FileMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Save",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Save"], "MenuName"],
 "."
}], "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->24588],

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", "\"\<Save\>\"", "]"}], "]"}]], "Input",
 CellTags->"FrontEndTokenIntro",
 CellLabel->"In[12]:=",
 CellID->12021],

Cell[TextData[{
 "With two arguments, the arguments of ",
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " and a front end token. For example, to save the notebook containing the \
current evaluation, the first argument of ",
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 " is the notebook object ",
 Cell[BoxData[
  ButtonBox["EvaluationNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluationNotebook"]], "InlineFormula"],
 " , and the second argument is the front end token ",
 Cell[BoxData[
  ButtonBox["\"\<Save\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/Save"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->22586],

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{
    RowBox[{"FrontEnd`EvaluationNotebook", "[", "]"}], ",", " ", 
    "\"\<Save\>\""}], "]"}], "]"}]], "Input",
 CellTags->"FrontEndTokenIntro",
 CellLabel->"In[3]:=",
 CellID->14108],

Cell[TextData[{
 "You can execute a simple, one-argument front end token with the command ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndTokenExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndTokenExecute"], "[", 
   StyleBox["token", "TI"], "]"}]], "InlineFormula"],
 ". This is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"], "[", 
   RowBox[{
    ButtonBox["FrontEndToken",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrontEndToken"], "[", 
    StyleBox["token", "TI"], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->29777],

Cell["\<\
For example, the following command will save the input notebook.\
\>", "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->12628],

Cell[BoxData[
 RowBox[{"FrontEndTokenExecute", "[", "\"\<Save\>\"", "]"}]], "Input",
 CellTags->"FrontEndTokenIntro",
 CellLabel->"In[5]:=",
 CellID->21979]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compound Tokens", "Subsection",
 CellTags->"FrontEndTokenIntro",
 CellID->26947],

Cell[TextData[{
 "Compound tokens have a token parameter that controls some aspect of their \
behavior. For a compound token, the three arguments of ",
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ", the front end token, and the selected token parameter."
}], "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->12549],

Cell["For example, this saves the selected notebook as plain text.", "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->1280],

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"{", 
   RowBox[{"FrontEndToken", "[", 
    RowBox[{
     RowBox[{"FrontEnd`InputNotebook", "[", "]"}], ",", " ", 
     "\"\<SaveRenameSpecial\>\"", ",", " ", "\"\<Text\>\""}], "]"}], "}"}], 
  "]"}]], "Input",
 CellTags->"FrontEndTokenIntro",
 CellLabel->"In[6]:=",
 CellID->13245]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Front End Tokens - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 12.6751736}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Front end tokens let you perform kernel commands that would normally be \
done using the menus. Front end tokens are particularly convenient for \
writing programs to manipulate notebooks. FrontEndToken is a kernel command \
that identifies its argument as a front end token. FrontEndExecute is a \
kernel command that sends its argument to the front end for execution. For \
example, the following command creates a new notebook. FrontEndExecute can \
take a list as its argument, allowing you to execute multiple tokens in a \
single evaluation. When you evaluate the following command, the front end \
creates a new notebook and then pastes the contents of the clipboard into \
that notebook.", "synonyms" -> {}, "title" -> "Front End Tokens", "type" -> 
    "Tutorial", "uri" -> "tutorial/FrontEndTokens"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FrontEndTokenIntro"->{
  Cell[728, 29, 81, 2, 70, "Title",
   CellTags->"FrontEndTokenIntro",
   CellID->1511],
  Cell[812, 33, 261, 6, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->32125],
  Cell[1076, 41, 556, 14, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->11838],
  Cell[1635, 57, 191, 5, 70, "Input",
   CellTags->"FrontEndTokenIntro",
   CellID->27296],
  Cell[1829, 64, 460, 11, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->18939],
  Cell[2585, 89, 104, 2, 70, "Section",
   CellTags->"FrontEndTokenIntro",
   CellID->1056],
  Cell[2692, 93, 177, 5, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->12826],
  Cell[2894, 102, 84, 2, 70, "Subsection",
   CellTags->"FrontEndTokenIntro",
   CellID->12902],
  Cell[2981, 106, 264, 9, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->26758],
  Cell[3248, 117, 773, 23, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->24588],
  Cell[4024, 142, 192, 5, 70, "Input",
   CellTags->"FrontEndTokenIntro",
   CellID->12021],
  Cell[4219, 149, 1007, 30, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->22586],
  Cell[5229, 181, 276, 8, 70, "Input",
   CellTags->"FrontEndTokenIntro",
   CellID->14108],
  Cell[5508, 191, 700, 22, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->29777],
  Cell[6211, 215, 137, 4, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->12628],
  Cell[6351, 221, 156, 4, 70, "Input",
   CellTags->"FrontEndTokenIntro",
   CellID->21979],
  Cell[6544, 230, 86, 2, 70, "Subsection",
   CellTags->"FrontEndTokenIntro",
   CellID->26947],
  Cell[6633, 234, 548, 15, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->12549],
  Cell[7184, 251, 124, 2, 70, "Text",
   CellTags->"FrontEndTokenIntro",
   CellID->1280],
  Cell[7311, 255, 340, 10, 70, "Input",
   CellTags->"FrontEndTokenIntro",
   CellID->13245]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FrontEndTokenIntro", 9597, 312}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 103, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[728, 29, 81, 2, 70, "Title",
 CellTags->"FrontEndTokenIntro",
 CellID->1511],
Cell[812, 33, 261, 6, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->32125],
Cell[1076, 41, 556, 14, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->11838],
Cell[1635, 57, 191, 5, 70, "Input",
 CellTags->"FrontEndTokenIntro",
 CellID->27296],
Cell[1829, 64, 460, 11, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->18939],
Cell[2292, 77, 268, 8, 70, "Input",
 CellID->11544],
Cell[CellGroupData[{
Cell[2585, 89, 104, 2, 70, "Section",
 CellTags->"FrontEndTokenIntro",
 CellID->1056],
Cell[2692, 93, 177, 5, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->12826],
Cell[CellGroupData[{
Cell[2894, 102, 84, 2, 70, "Subsection",
 CellTags->"FrontEndTokenIntro",
 CellID->12902],
Cell[2981, 106, 264, 9, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->26758],
Cell[3248, 117, 773, 23, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->24588],
Cell[4024, 142, 192, 5, 70, "Input",
 CellTags->"FrontEndTokenIntro",
 CellID->12021],
Cell[4219, 149, 1007, 30, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->22586],
Cell[5229, 181, 276, 8, 70, "Input",
 CellTags->"FrontEndTokenIntro",
 CellID->14108],
Cell[5508, 191, 700, 22, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->29777],
Cell[6211, 215, 137, 4, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->12628],
Cell[6351, 221, 156, 4, 70, "Input",
 CellTags->"FrontEndTokenIntro",
 CellID->21979]
}, Open  ]],
Cell[CellGroupData[{
Cell[6544, 230, 86, 2, 70, "Subsection",
 CellTags->"FrontEndTokenIntro",
 CellID->26947],
Cell[6633, 234, 548, 15, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->12549],
Cell[7184, 251, 124, 2, 70, "Text",
 CellTags->"FrontEndTokenIntro",
 CellID->1280],
Cell[7311, 255, 340, 10, 70, "Input",
 CellTags->"FrontEndTokenIntro",
 CellID->13245]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7690, 270, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

