(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18034,        617]
NotebookOptionsPosition[     12248,        445]
NotebookOutlinePosition[     15939,        538]
CellTagsIndexPosition[     15766,        530]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Transformation Rules and Definitions" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Functions That Remember Values They Have Found", "Title",
 CellTags->{"S2.5.9", "9.1"},
 CellID->20084],

Cell[TextData[{
 "When you make a function definition using ",
 Cell[BoxData[":="], "InlineFormula"],
 ", the value of the function is recomputed every time you ask for it. In \
some kinds of calculations, you may end up asking for the same function value \
many times. You can save time in these cases by having ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " remember all the function values it finds. Here is an \
\[OpenCurlyDoubleQuote]idiom\[CloseCurlyDoubleQuote] for defining a function \
that does this. "
}], "Text",
 CellID->24160],

Cell[BoxData[GridBox[{
   {
    RowBox[{"f", "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "]", ":=", "f", "[", 
     StyleBox["x", "TI"], "]", "=", 
     StyleBox["rhs", "TI"]}], Cell[
    "define a function which remembers values that it finds", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31122],

Cell["Defining a function that remembers values it finds. ", "Caption",
 CellID->26053],

Cell[TextData[{
 "This defines a function ",
 Cell[BoxData["f"], "InlineFormula"],
 " which stores all values that it finds. "
}], "MathCaption",
 CellID->19397],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", "-", "1"}], "]"}], "+", 
    RowBox[{"f", "[", 
     RowBox[{"x", "-", "2"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11822],

Cell[TextData[{
 "Here are the end conditions for the recursive function ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "0", "]"}], "=", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], "=", "1"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21337],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3747947]
}, Open  ]],

Cell[TextData[{
 "Here is the original definition of ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4931],

Cell[CellGroupData[{

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3370258165-7930524",
 CellID->351433434],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "0", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "1", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], "=", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"x", "-", "1"}], "]"}], "+", 
           RowBox[{"f", "[", 
            RowBox[{"x", "-", "2"}], "]"}]}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3370258165-7930524",
 CellID->1659199488]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "This computes ",
 Cell[BoxData[
  RowBox[{"f", "[", "5", "]"}]], "InlineFormula"],
 ". The computation involves finding the sequence of values ",
 Cell[BoxData[
  RowBox[{"f", "[", "5", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"f", "[", "4", "]"}]], "InlineFormula"],
 ", \[Ellipsis] ",
 Cell[BoxData[
  RowBox[{"f", "[", "2", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "5", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->10357],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->306972933]
}, Open  ]],

Cell[TextData[{
 "All the values of ",
 Cell[BoxData["f"], "InlineFormula"],
 " found so far are explicitly stored. "
}], "MathCaption",
 CellID->28290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1898],

Cell[CellGroupData[{

Cell["Global`f", "Print", "PrintUsage",
 CellTags->"Info3370258167-4949047",
 CellID->566939055],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "0", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "1", "]"}], "=", "1"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "2", "]"}], "=", "2"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "3", "]"}], "=", "3"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "4", "]"}], "=", "5"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "5", "]"}], "=", "8"}]},
       {" "},
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], "=", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"x", "-", "1"}], "]"}], "+", 
           RowBox[{"f", "[", 
            RowBox[{"x", "-", "2"}], "]"}]}]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3370258167-4949047",
 CellID->2096109910]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "If you ask for ",
 Cell[BoxData[
  RowBox[{"f", "[", "5", "]"}]], "InlineFormula"],
 " again, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can just look up the value immediately; it does not have to recompute it."
}], "MathCaption",
 CellID->1084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "5", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->592],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->146626805]
}, Open  ]],

Cell[TextData[{
 "You can see how a definition like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "=", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "+", 
     RowBox[{"f", "[", 
      RowBox[{"x", "-", "2"}], "]"}]}]}]}]], "InlineFormula"],
 " works. The function ",
 Cell[BoxData[
  RowBox[{"f", "[", "x_", "]"}]], "InlineFormula"],
 " is defined to be the \
\[OpenCurlyDoubleQuote]program\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], "=", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", "-", "1"}], "]"}], "+", 
    RowBox[{"f", "[", 
     RowBox[{"x", "-", "2"}], "]"}]}]}]], "InlineFormula"],
 ". When you ask for a value of the function ",
 Cell[BoxData["f"], "InlineFormula"],
 ", the \[OpenCurlyDoubleQuote]program\[CloseCurlyDoubleQuote] is executed. \
The program first calculates the value of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", "-", "1"}], "]"}], "+", 
   RowBox[{"f", "[", 
    RowBox[{"x", "-", "2"}], "]"}]}]], "InlineFormula"],
 ", then saves the result as ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->8996],

Cell[TextData[{
 "It is often a good idea to use functions that remember values when you \
implement mathematical ",
 StyleBox["recursion relations",
  FontSlant->"Italic"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In a typical case, a recursion relation gives the value of a function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " with an integer argument ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " in terms of values of the same function with arguments ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "-", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "-", "2"}], TraditionalForm]], "InlineMath"],
 ", etc. The Fibonacci function definition ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "x", ")"}], "=", 
    RowBox[{
     RowBox[{"f", "(", 
      RowBox[{"x", "-", "1"}], ")"}], "+", 
     RowBox[{"f", "(", 
      RowBox[{"x", "-", "2"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 " used above is an example of this kind of recursion relation. The point is \
that if you calculate say ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", 
    RowBox[{"(", "10", ")"}]}], TraditionalForm]], "InlineMath"],
 " by just applying the recursion relation over and over again, you end up \
having to recalculate quantities like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "5", ")"}], TraditionalForm]], "InlineMath"],
 " many times. In a case like this, it is therefore better just to ",
 StyleBox["remember",
  FontSlant->"Italic"],
 " the value of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "5", ")"}], TraditionalForm]], "InlineMath"],
 ", and look it up when you need it, rather than having to recalculate it. "
}], "Text",
 CellID->29855],

Cell["\<\
There is of course a trade\[Hyphen]off involved in remembering values. It is \
faster to find a particular value, but it takes more memory space to store \
all of them. You should usually define functions to remember values only if \
the total number of different values that will be produced is comparatively \
small, or the expense of recomputing them is very great. \
\>", "Text",
 CellID->24828],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->407425646],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions That Remember Values They Have Found - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ImmediateAndDelayedDefinitions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 18.0503112}", "context" -> "", 
    "keywords" -> {
     "caching", "dynamic programming", "Fibonacci function", "functions", 
      "memo functions", "recomputation", "recursion", "recursive functions", 
      "remembering previously computed values", "saving"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "When you make a function definition using :=, the value of the function \
is recomputed every time you ask for it. In some kinds of calculations, you \
may end up asking for the same function value many times. You can save time \
in these cases by having Mathematica remember all the function values it \
finds. Here is an 'idiom' for defining a function that does this. Defining a \
function that remembers values it finds. This defines a function f which \
stores all values that it finds. ", "synonyms" -> {"2.5.9"}, "title" -> 
    "Functions That Remember Values They Have Found", "type" -> "Tutorial", 
    "uri" -> "tutorial/FunctionsThatRememberValuesTheyHaveFound"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.9"->{
  Cell[1309, 44, 109, 2, 70, "Title",
   CellTags->{"S2.5.9", "9.1"},
   CellID->20084]},
 "9.1"->{
  Cell[1309, 44, 109, 2, 70, "Title",
   CellTags->{"S2.5.9", "9.1"},
   CellID->20084]},
 "Info3370258165-7930524"->{
  Cell[3917, 144, 96, 2, 70, "Print",
   CellTags->"Info3370258165-7930524",
   CellID->351433434],
  Cell[4016, 148, 1168, 37, 70, "Print",
   CellTags->"Info3370258165-7930524",
   CellID->1659199488]},
 "Info3370258167-4949047"->{
  Cell[6217, 237, 96, 2, 70, "Print",
   CellTags->"Info3370258167-4949047",
   CellID->566939055],
  Cell[6316, 241, 1536, 53, 70, "Print",
   CellTags->"Info3370258167-4949047",
   CellID->2096109910]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.9", 15085, 505},
 {"9.1", 15185, 509},
 {"Info3370258165-7930524", 15304, 513},
 {"Info3370258167-4949047", 15538, 520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 684, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1309, 44, 109, 2, 70, "Title",
 CellTags->{"S2.5.9", "9.1"},
 CellID->20084],
Cell[1421, 48, 548, 12, 70, "Text",
 CellID->24160],
Cell[1972, 62, 593, 16, 70, "DefinitionBox",
 CellID->31122],
Cell[2568, 80, 87, 1, 70, "Caption",
 CellID->26053],
Cell[2658, 83, 161, 5, 70, "MathCaption",
 CellID->19397],
Cell[2822, 90, 306, 11, 70, "Input",
 CellID->11822],
Cell[3131, 103, 154, 5, 70, "MathCaption",
 CellID->19750],
Cell[CellGroupData[{
Cell[3310, 112, 168, 6, 28, "Input",
 CellID->21337],
Cell[3481, 120, 156, 5, 36, "Output",
 CellID->3747947]
}, Open  ]],
Cell[3652, 128, 133, 5, 70, "MathCaption",
 CellID->4006],
Cell[CellGroupData[{
Cell[3810, 137, 82, 3, 70, "Input",
 CellID->4931],
Cell[CellGroupData[{
Cell[3917, 144, 96, 2, 70, "Print",
 CellTags->"Info3370258165-7930524",
 CellID->351433434],
Cell[4016, 148, 1168, 37, 70, "Print",
 CellTags->"Info3370258165-7930524",
 CellID->1659199488]
}, Open  ]]
}, Open  ]],
Cell[5211, 189, 428, 15, 70, "MathCaption",
 CellID->29236],
Cell[CellGroupData[{
Cell[5664, 208, 93, 3, 70, "Input",
 CellID->10357],
Cell[5760, 213, 158, 5, 36, "Output",
 CellID->306972933]
}, Open  ]],
Cell[5933, 221, 152, 5, 70, "MathCaption",
 CellID->28290],
Cell[CellGroupData[{
Cell[6110, 230, 82, 3, 70, "Input",
 CellID->1898],
Cell[CellGroupData[{
Cell[6217, 237, 96, 2, 70, "Print",
 CellTags->"Info3370258167-4949047",
 CellID->566939055],
Cell[6316, 241, 1536, 53, 70, "Print",
 CellTags->"Info3370258167-4949047",
 CellID->2096109910]
}, Open  ]]
}, Open  ]],
Cell[7879, 298, 275, 9, 70, "MathCaption",
 CellID->1084],
Cell[CellGroupData[{
Cell[8179, 311, 91, 3, 70, "Input",
 CellID->592],
Cell[8273, 316, 158, 5, 36, "Output",
 CellID->146626805]
}, Open  ]],
Cell[8446, 324, 1253, 40, 70, "Text",
 CellID->8996],
Cell[9702, 366, 1777, 52, 70, "Text",
 CellID->29855],
Cell[11482, 420, 409, 7, 70, "Text",
 CellID->24828],
Cell[CellGroupData[{
Cell[11916, 431, 72, 1, 70, "RelatedTutorialsSection",
 CellID->407425646],
Cell[11991, 434, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[12221, 443, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

