(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12258,        403]
NotebookOptionsPosition[      7979,        280]
NotebookOutlinePosition[     11017,        356]
CellTagsIndexPosition[     10925,        350]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and External Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FilesAndExternalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Files and External Operations\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CForm" :> Documentation`HelpLookup["paclet:ref/CForm"], 
          "Compile" :> Documentation`HelpLookup["paclet:ref/Compile"], 
          "FortranForm" :> 
          Documentation`HelpLookup["paclet:ref/FortranForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CForm\"\>", 2->"\<\"Compile\"\>", 
       3->"\<\"FortranForm\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Generating C and Fortran Expressions", "Title",
 CellTags->{"S1.11.8", "8.1"},
 CellID->18129],

Cell[TextData[{
 "If you have special\[Hyphen]purpose programs written in C or Fortran, you \
may want to take formulas you have generated in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and insert them into the source code of your programs. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to convert mathematical expressions into C and Fortran \
expressions."
}], "Text",
 CellID->21358],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["CForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "write out ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " so it can be used in a C program"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FortranForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FortranForm"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "write out ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " for Fortran"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1436],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output for programming languages. "
}], "Caption",
 CellID->28469],

Cell[TextData[{
 "Here is an expression, written out in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " form. "
}], "MathCaption",
 CellID->22897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x", "+", "y"}], ")"}], "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->28504],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"2", " ", "y"}], "+", 
  RowBox[{"2", " ", "x", " ", "y"}], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->4798]
}, Open  ]],

Cell["Here is the expression in Fortran form. ", "MathCaption",
 CellID->4202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->23105],

Cell["1 + 2*x + x**2 + 2*y + 2*x*y + y**2", "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FortranForm= ",
 CellID->1238]
}, Open  ]],

Cell[TextData[{
 "Here is the same expression in C form. Macros for objects like ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " are defined in the C header file ",
 Cell[BoxData[
  RowBox[{"mdefs", ".", "h"}]], "InlineFormula"],
 " that comes with most versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->15032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->20065],

Cell["1 + 2*x + Power(x,2) + 2*y + 2*x*y + Power(y,2)", "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//CForm= ",
 CellID->12516]
}, Open  ]],

Cell[TextData[{
 "You should realize that there are many differences between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and C or Fortran. As a result, expressions you translate may not work \
exactly the same as they do in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In addition, there are so many differences in programming constructs that \
no attempt is made to translate these automatically. "
}], "Text",
 CellID->14481],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Compile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Compile"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "compile an expression into efficient internal code", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->15579],

Cell[TextData[{
 "A way to compile ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Caption",
 CellID->9023],

Cell[TextData[{
 "One of the common motivations for converting ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions into C or Fortran is to try to make them faster to evaluate \
numerically. But the single most important reason that C and Fortran can \
potentially be more efficient than ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that in these languages one always specifies up front what type each \
variable one uses will be\[LongDash]integer, real number, array, and so on."
}], "Text",
 CellID->1727],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " makes such assumptions within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", and generates highly efficient internal code. Usually this code runs not \
much if at all slower than custom C or Fortran. "
}], "Text",
 CellID->1771],

Cell[TextData[ButtonBox["Files and External Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FilesAndExternalOperationsOverview"]], "RelatedTutorials",
 CellID->16088632]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Generating C and Fortran Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Files and External Operations", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/FilesAndExternalOperationsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExchangingMaterialWithTheWeb"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/SplicingMathematicaOutputIntoExternalFiles"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 25.7067572}", "context" -> "", 
    "keywords" -> {
     "CForm", "C language", "code generation", "compilation", "compile", 
      "efficiency", "external programs", "Fortran", "FortranForm", "mdef", 
      "macro definition compiler", "numerical computation", "output", 
      "programs", "speed"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "If you have special-purpose programs written in C or Fortran, you may \
want to take formulas you have generated in Mathematica and insert them into \
the source code of your programs. Mathematica allows you to convert \
mathematical expressions into C and Fortran expressions. Mathematica output \
for programming languages. Here is an expression, written out in standard \
Mathematica form. ", "synonyms" -> {"1.11.8"}, "title" -> 
    "Generating C and Fortran Expressions", "type" -> "Tutorial", "uri" -> 
    "tutorial/GeneratingCAndFortranExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.11.8"->{
  Cell[2034, 62, 100, 2, 70, "Title",
   CellTags->{"S1.11.8", "8.1"},
   CellID->18129]},
 "8.1"->{
  Cell[2034, 62, 100, 2, 70, "Title",
   CellTags->{"S1.11.8", "8.1"},
   CellID->18129]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.11.8", 10710, 339},
 {"8.1", 10811, 343}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1409, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2034, 62, 100, 2, 70, "Title",
 CellTags->{"S1.11.8", "8.1"},
 CellID->18129],
Cell[2137, 66, 416, 11, 70, "Text",
 CellID->21358],
Cell[2556, 79, 955, 31, 70, "DefinitionBox",
 CellID->1436],
Cell[3514, 112, 134, 5, 70, "Caption",
 CellID->28469],
Cell[3651, 119, 162, 6, 70, "MathCaption",
 CellID->22897],
Cell[CellGroupData[{
Cell[3838, 129, 181, 6, 28, "Input",
 CellID->28504],
Cell[4022, 137, 344, 11, 36, "Output",
 CellID->4798]
}, Open  ]],
Cell[4381, 151, 78, 1, 70, "MathCaption",
 CellID->4202],
Cell[CellGroupData[{
Cell[4484, 156, 104, 3, 28, "Input",
 CellID->23105],
Cell[4591, 161, 193, 5, 50, "Output",
 CellID->1238]
}, Open  ]],
Cell[4799, 169, 429, 14, 70, "MathCaption",
 CellID->15032],
Cell[CellGroupData[{
Cell[5253, 187, 98, 3, 70, "Input",
 CellID->20065],
Cell[5354, 192, 200, 5, 50, "Output",
 CellID->12516]
}, Open  ]],
Cell[5569, 200, 449, 11, 70, "Text",
 CellID->14481],
Cell[6021, 213, 603, 17, 70, "DefinitionBox",
 CellID->15579],
Cell[6627, 232, 134, 6, 70, "Caption",
 CellID->9023],
Cell[6764, 240, 534, 12, 70, "Text",
 CellID->1727],
Cell[7301, 254, 446, 15, 70, "Text",
 CellID->1771],
Cell[7750, 271, 187, 4, 70, "RelatedTutorials",
 CellID->16088632]
}, Open  ]],
Cell[7952, 278, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

