(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35803,        915]
NotebookOptionsPosition[     30441,        752]
NotebookOutlinePosition[     33458,        826]
CellTagsIndexPosition[     33365,        820]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Print" :> Documentation`HelpLookup["paclet:ref/Print"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Print\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Generating Unstructured Output", "Title",
 CellTags->{"S2.9.18", "18.1"},
 CellID->32271],

Cell[TextData[{
 "The functions described in the preceding tutorials on ",
 ButtonBox["textual input and output",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TextualInputAndOutputOverview"],
 " determine ",
 StyleBox["how",
  FontSlant->"Italic"],
 " expressions should be formatted when they are printed, but they do not \
actually cause anything to be printed. "
}], "Text",
 CellID->23283],

Cell[TextData[{
 "In the most common way of using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " you never in fact explicitly have to issue a command to generate output. \
Usually, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically prints out the final result that it gets from processing \
input you gave. Sometimes, however, you may want to get ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to print out expressions at intermediate stages in its operation. You can \
do this using the function ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->4364],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Print",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Print"], "[", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "print the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", with no spaces in between, but with a newline (line feed) at the end"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->27038],

Cell["Printing expressions. ", "Caption",
 CellID->3012],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " prints its arguments, with no spaces in between, but with a newline (line \
feed) at the end. "
}], "MathCaption",
 CellID->3184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"a", ",", "b"}], "]"}], ";", 
  RowBox[{"Print", "[", "c", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21759],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"a", "\[InvisibleSpace]", "b"}],
  SequenceForm[$CellContext`a, $CellContext`b],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->198746696],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->998648587]
}, Open  ]]
}, Open  ]],

Cell["\<\
This prints a table of the first five integers and their squares. \
\>", "MathCaption",
 CellID->28733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"i", ",", "\"\< \>\"", ",", 
     RowBox[{"i", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5059],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm[1, " ", 1],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1702100404],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"2", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "4"}],
  SequenceForm[2, " ", 4],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->571828341],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "9"}],
  SequenceForm[3, " ", 9],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->729606862],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"4", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "16"}],
  SequenceForm[4, " ", 16],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->370905264],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"5", "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "25"}],
  SequenceForm[5, " ", 25],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1807228454]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " simply takes the arguments you give, and prints them out one after the \
other, with no spaces in between. In many cases, you will need to print \
output in a more complicated format. You can do this by giving an output form \
as an argument to ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 "."
}], "Text",
 CellID->20416],

Cell["This prints the matrix in the form of a table. ", "MathCaption",
 CellID->15377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"Grid", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1052],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"3", "4"}
   }],
  "Grid"]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->79923210]
}, Open  ]],

Cell[TextData[{
 "Here the output format is specified using ",
 Cell[BoxData[
  ButtonBox["StringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"StringForm", "[", 
   RowBox[{"\"\<x = ``, y = ``\>\"", ",", 
    RowBox[{"a", "^", "2"}], ",", 
    RowBox[{"b", "^", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->138],

Cell[BoxData[
 InterpretationBox["\<\"x = \\!\\(a\\^2\\), y = \\!\\(b\\^2\\)\"\>",
  StringForm["x = ``, y = ``", $CellContext`a^2, $CellContext`b^2],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->1092111095]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " also allows mixing of text and graphics."
}], "MathCaption",
 CellID->38199187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"\"\<A sine wave:\>\"", ",", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", 
       RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->600739395],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"A sine wave:\"\>", "\[InvisibleSpace]", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF8sKaWF3qeyFYmSNiFUSIiSJJVKSLKlki0V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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->
     NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
       0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}],
  SequenceForm["A sine wave:", 
   Graphics[{{{}, {}, {
       Hue[0.67, 0.6, 0.6], 
       Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF8sKaWF3qeyFYmSNiFUSIiSJJVKSLKlki0V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        "]]}}}, {
    AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
     PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {
       Scaled[0.02], 
       Scaled[0.02]}}]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->568442756]
}, Open  ]],

Cell[TextData[{
 "The output generated by ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " is usually given in the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output format. You can however explicitly specify that some other output \
format should be used. "
}], "Text",
 CellID->20967],

Cell[TextData[{
 "This prints output in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input form. "
}], "MathCaption",
 CellID->15055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Print", "[", 
  RowBox[{"InputForm", "[", 
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"b", "^", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->13787],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    RowBox[{"a", "^", "2"}], " ", "+", " ", 
    RowBox[{"b", "^", "2"}]}],
   ShowStringCharacters->True,
   NumberMarks->True],
  InputForm[$CellContext`a^2 + $CellContext`b^2],
  AutoDelete->True,
  Editable->True]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1810138236]
}, Open  ]],

Cell[TextData[{
 "You should realize that ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " is only one of several mechanisms available in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for generating output. Another is the function ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " described in \"",
 ButtonBox["Messages\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Messages"],
 ", used for generating named messages. There are also a variety of lower\
\[Hyphen]level functions described in \"",
 ButtonBox["Streams and Low-Level Input and Output\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"],
 " which allow you to produce output in various formats both as part of an \
interactive session, and for files and external programs."
}], "Text",
 CellID->18222],

Cell[TextData[{
 "Another command which works exactly like ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 ", but only shows the printed output until the final evaluation is finished, \
is ",
 Cell[BoxData[
  ButtonBox["PrintTemporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrintTemporary"]], "InlineFormula"],
 "."
}], "Text",
 CellID->261203781],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->318977810],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Generating Unstructured Output - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/LowLevelInputAndOutputRules"],
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RequestingInput"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 26.1911446}", "context" -> "", 
    "keywords" -> {
     "display", "output", "print", "StringForm", "type", "write"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The functions described in the preceding tutorials on textual input and \
output determine how expressions should be formatted when they are printed, \
but they do not actually cause anything to be printed. In the most common way \
of using Mathematica you never in fact explicitly have to issue a command to \
generate output. Usually, Mathematica automatically prints out the final \
result that it gets from processing input you gave. Sometimes, however, you \
may want to get Mathematica to print out expressions at intermediate stages \
in its operation. You can do this using the function Print. Printing \
expressions. ", "synonyms" -> {"2.9.18"}, "title" -> 
    "Generating Unstructured Output", "type" -> "Tutorial", "uri" -> 
    "tutorial/GeneratingUnstructuredOutput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.18"->{
  Cell[1807, 58, 95, 2, 70, "Title",
   CellTags->{"S2.9.18", "18.1"},
   CellID->32271]},
 "18.1"->{
  Cell[1807, 58, 95, 2, 70, "Title",
   CellTags->{"S2.9.18", "18.1"},
   CellID->32271]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.18", 33149, 809},
 {"18.1", 33251, 813}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1182, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1807, 58, 95, 2, 70, "Title",
 CellTags->{"S2.9.18", "18.1"},
 CellID->32271],
Cell[1905, 62, 400, 11, 70, "Text",
 CellID->23283],
Cell[2308, 75, 679, 20, 70, "Text",
 CellID->4364],
Cell[2990, 97, 872, 26, 70, "DefinitionBox",
 CellID->27038],
Cell[3865, 125, 56, 1, 70, "Caption",
 CellID->3012],
Cell[3924, 128, 261, 8, 70, "MathCaption",
 CellID->3184],
Cell[CellGroupData[{
Cell[4210, 140, 176, 6, 70, "Input",
 CellID->21759],
Cell[CellGroupData[{
Cell[4411, 150, 218, 6, 70, "Print",
 CellID->198746696],
Cell[4632, 158, 91, 2, 70, "Print",
 CellID->998648587]
}, Open  ]]
}, Open  ]],
Cell[4750, 164, 113, 3, 70, "MathCaption",
 CellID->28733],
Cell[CellGroupData[{
Cell[4888, 171, 267, 9, 70, "Input",
 CellID->5059],
Cell[CellGroupData[{
Cell[5180, 184, 232, 6, 70, "Print",
 CellID->1702100404],
Cell[5415, 192, 231, 6, 70, "Print",
 CellID->571828341],
Cell[5649, 200, 231, 6, 70, "Print",
 CellID->729606862],
Cell[5883, 208, 233, 6, 70, "Print",
 CellID->370905264],
Cell[6119, 216, 234, 6, 70, "Print",
 CellID->1807228454]
}, Open  ]]
}, Open  ]],
Cell[6380, 226, 525, 15, 70, "Text",
 CellID->20416],
Cell[6908, 243, 86, 1, 70, "MathCaption",
 CellID->15377],
Cell[CellGroupData[{
Cell[7019, 248, 282, 10, 70, "Input",
 CellID->1052],
Cell[7304, 260, 153, 7, 70, "Print",
 CellID->79923210]
}, Open  ]],
Cell[7472, 270, 226, 8, 70, "MathCaption",
 CellID->19891],
Cell[CellGroupData[{
Cell[7723, 282, 237, 7, 70, "Input",
 CellID->138],
Cell[7963, 291, 245, 5, 70, "Print",
 CellID->1092111095]
}, Open  ]],
Cell[8223, 299, 211, 7, 70, "MathCaption",
 CellID->38199187],
Cell[CellGroupData[{
Cell[8459, 310, 343, 10, 70, "Input",
 CellID->600739395],
Cell[8805, 322, 18771, 320, 70, "Print",
 CellID->568442756]
}, Open  ]],
Cell[27591, 645, 376, 12, 70, "Text",
 CellID->20967],
Cell[27970, 659, 143, 6, 70, "MathCaption",
 CellID->15055],
Cell[CellGroupData[{
Cell[28138, 669, 207, 7, 70, "Input",
 CellID->13787],
Cell[28348, 678, 351, 12, 70, "Print",
 CellID->1810138236]
}, Open  ]],
Cell[28714, 693, 964, 26, 70, "Text",
 CellID->18222],
Cell[29681, 721, 428, 14, 70, "Text",
 CellID->261203781],
Cell[CellGroupData[{
Cell[30134, 739, 72, 1, 70, "RelatedTutorialsSection",
 CellID->318977810],
Cell[30209, 742, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]]
}, Open  ]],
Cell[30414, 750, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

