(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21524,        663]
NotebookOptionsPosition[     16238,        506]
NotebookOutlinePosition[     19766,        598]
CellTagsIndexPosition[     19552,        589]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Using the Mathematica System" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/UsingTheMathematicaSystemOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Using the Mathematica System\"\>"}, "\<\"related tutorials\"\>",
       
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Getting Help with a Text\[Hyphen]Based Interface\
\>", "Title",
 CellTags->{"S1.3.9", "9.1"},
 CellID->7813],

Cell[BoxData[GridBox[{
   {
    RowBox[{"?", 
     StyleBox["Name", "TI"]}], Cell[TextData[{
     "show information on ",
     Cell[BoxData[
      StyleBox["Name", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"??", 
     StyleBox["Name", "TI"]}], Cell[TextData[{
     "show extra information on ",
     Cell[BoxData[
      StyleBox["Name", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"?", 
     StyleBox["Aaaa", "TI"], 
     StyleBox["*", "MR"]}], Cell[TextData[{
     "show information on all objects whose names begin with ",
     Cell[BoxData[
      StyleBox["Aaaa", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->14907],

Cell[TextData[{
 "Ways to get information directly from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. "
}], "Caption",
 CellID->29554],

Cell[TextData[{
 "This gives information on the built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Log"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\\!\\(\\*RowBox[{\\\"Log\\\", \\\"[\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"], \\\"]\\\"}]\\) gives the natural logarithm of \\!\\(\\*StyleBox[\
\\\"z\\\", \\\"TI\\\"]\\) (logarithm to base \\!\\(\\*StyleBox[\\\"e\\\", \
\\\"TI\\\"]\\)). \\n\\!\\(\\*RowBox[{\\\"Log\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"b\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"]}], \\\"]\\\"}]\\) gives the logarithm to base \
\\!\\(\\*StyleBox[\\\"b\\\", \\\"TI\\\"]\\). \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]}]], "Print", "PrintUsage",
 CellTags->"Info3370259497-9159438",
 CellID->413956951]
}, Open  ]],

Cell[TextData[{
 "You can ask for information about any object, whether it is built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", has been read in from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package, or has been introduced by you. "
}], "Text",
 CellID->25429],

Cell[TextData[{
 "When you use ",
 Cell[BoxData["?"], "InlineFormula"],
 " to get information, you must make sure that the question mark appears as \
the first character in your input line. You need to do this so that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can tell when you are requesting information rather than giving ordinary \
input for evaluation. "
}], "Text",
 CellID->2264],

Cell[TextData[{
 "You can get extra information by using ",
 Cell[BoxData["??"], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Attributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Attributes"]], "InlineFormula"],
 " will be discussed in \"",
 ButtonBox["Attributes\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/Attributes"],
 ". "
}], "MathCaption",
 CellID->15966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "Log"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\\!\\(\\*RowBox[{\\\"Log\\\", \\\"[\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"], \\\"]\\\"}]\\) gives the natural logarithm of \\!\\(\\*StyleBox[\
\\\"z\\\", \\\"TI\\\"]\\) (logarithm to base \\!\\(\\*StyleBox[\\\"e\\\", \
\\\"TI\\\"]\\)). \\n\\!\\(\\*RowBox[{\\\"Log\\\", \\\"[\\\", \
RowBox[{StyleBox[\\\"b\\\", \\\"TI\\\"], \\\",\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"]}], \\\"]\\\"}]\\) gives the logarithm to base \
\\!\\(\\*StyleBox[\\\"b\\\", \\\"TI\\\"]\\). \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]}]], "Print", "PrintUsage",
 CellTags->"Info3370259499-5802841",
 CellID->1789040891],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Log", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
       "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Log"],
  Editable->False]], "Print",
 CellTags->"Info3370259499-5802841",
 CellID->839380464]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "This gives information on all ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " objects whose names begin with ",
 Cell[BoxData["Lo"], "InlineFormula"],
 ". When there is more than one object, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just lists their names. "
}], "MathCaption",
 CellID->19522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Lo*"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31155],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["System`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["System`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["LocalizeVariables",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LocalizeVariables"},
          ButtonNote->"System`"], 
         ButtonBox["Log",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`Log"},
          ButtonNote->"System`"], 
         ButtonBox["LogPlot",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LogPlot"},
          ButtonNote->"System`"], 
         ButtonBox["LongRightArrow",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LongRightArrow"},
          ButtonNote->"System`"]},
        {
         ButtonBox["Locator",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`Locator"},
          ButtonNote->"System`"], 
         ButtonBox["LogGamma",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LogGamma"},
          ButtonNote->"System`"], 
         ButtonBox["LogSeriesDistribution",
          BaseStyle->"Hyperlink",
          
          ButtonData:>{
           "Info3370259500-4214274", "System`LogSeriesDistribution"},
          ButtonNote->"System`"], 
         ButtonBox["Loopback",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`Loopback"},
          ButtonNote->"System`"]},
        {
         ButtonBox["LocatorAutoCreate",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LocatorAutoCreate"},
          ButtonNote->"System`"], 
         ButtonBox["LogicalExpand",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LogicalExpand"},
          ButtonNote->"System`"], 
         ButtonBox["LongEqual",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LongEqual"},
          ButtonNote->"System`"], 
         ButtonBox["LowerCaseQ",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LowerCaseQ"},
          ButtonNote->"System`"]},
        {
         ButtonBox["LocatorBox",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LocatorBox"},
          ButtonNote->"System`"], 
         ButtonBox["LogIntegral",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LogIntegral"},
          ButtonNote->"System`"], 
         ButtonBox["Longest",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`Longest"},
          ButtonNote->"System`"], 
         ButtonBox["LowerLeftArrow",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LowerLeftArrow"},
          ButtonNote->"System`"]},
        {
         ButtonBox["LocatorBoxOptions",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LocatorBoxOptions"},
          ButtonNote->"System`"], 
         ButtonBox["LogisticDistribution",
          BaseStyle->"Hyperlink",
          
          ButtonData:>{
           "Info3370259500-4214274", "System`LogisticDistribution"},
          ButtonNote->"System`"], 
         ButtonBox["LongestMatch",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LongestMatch"},
          ButtonNote->"System`"], 
         ButtonBox["LowerRightArrow",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LowerRightArrow"},
          ButtonNote->"System`"]},
        {
         ButtonBox["LocatorCentering",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LocatorCentering"},
          ButtonNote->"System`"], 
         ButtonBox["LogLinearPlot",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LogLinearPlot"},
          ButtonNote->"System`"], 
         ButtonBox["LongForm",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LongForm"},
          ButtonNote->"System`"], ""},
        {
         ButtonBox["LocatorRegion",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LocatorRegion"},
          ButtonNote->"System`"], 
         ButtonBox["LogLogPlot",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LogLogPlot"},
          ButtonNote->"System`"], 
         ButtonBox["LongLeftArrow",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LongLeftArrow"},
          ButtonNote->"System`"], ""},
        {
         ButtonBox["Locked",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`Locked"},
          ButtonNote->"System`"], 
         ButtonBox["LogNormalDistribution",
          BaseStyle->"Hyperlink",
          
          ButtonData:>{
           "Info3370259500-4214274", "System`LogNormalDistribution"},
          ButtonNote->"System`"], 
         ButtonBox["LongLeftRightArrow",
          BaseStyle->"Hyperlink",
          ButtonData:>{"Info3370259500-4214274", "System`LongLeftRightArrow"},
          
          ButtonNote->"System`"], ""}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.2375]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->Automatic]]], "Print", "InfoCell",
 CellID->1680439252]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["Aaaa", "TI"]}]], "InlineFormula"],
 " will give you information on the particular object whose name you specify. \
Using the \[OpenCurlyDoubleQuote]metacharacter\[CloseCurlyDoubleQuote] ",
 Cell[BoxData["*"], "InlineFormula"],
 ", however, you can get information on collections of objects with similar \
names. The rule is that ",
 Cell[BoxData["*"], "InlineFormula"],
 " is a \[OpenCurlyDoubleQuote]wild card\[CloseCurlyDoubleQuote] that can \
stand for any sequence of ordinary characters. So, for example, ",
 Cell[BoxData[
  RowBox[{"?", "Lo*"}]], "InlineFormula"],
 " gets information on all objects whose names consist of the letters ",
 Cell[BoxData["Lo"], "InlineFormula"],
 ", followed by any sequence of characters."
}], "Text",
 CellID->15257],

Cell[TextData[{
 "You can put ",
 Cell[BoxData["*"], "InlineFormula"],
 " anywhere in the string you ask ",
 Cell[BoxData["?"], "InlineFormula"],
 " about. For example, ",
 Cell[BoxData[
  RowBox[{"?", "*Expand"}]], "InlineFormula"],
 " would give you all objects whose names ",
 StyleBox["end",
  FontSlant->"Italic"],
 " with ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ". Similarly, ",
 Cell[BoxData[
  RowBox[{"?", "x*0"}]], "InlineFormula"],
 " would give you objects whose names start with ",
 Cell[BoxData["x"], "InlineFormula"],
 ", end with ",
 Cell[BoxData["0"], "InlineFormula"],
 ", and have any sequence of characters in between. (You may notice that the \
way you use ",
 Cell[BoxData["*"], "InlineFormula"],
 " to specify names in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is similar to the way you use ",
 Cell[BoxData["*"], "InlineFormula"],
 " in Unix and other operating systems to specify file names.) "
}], "Text",
 CellID->23158],

Cell[TextData[{
 "You can ask for information on most of the special input forms that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses. This asks for information about the ",
 Cell[BoxData[":="], "InlineFormula"],
 " operator. "
}], "MathCaption",
 CellID->4464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", ":="}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13762],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\\!\\(\\*RowBox[{StyleBox[\\\"lhs\\\", \\\"TI\\\"], \
\\\":=\\\", StyleBox[\\\"rhs\\\", \\\"TI\\\"]}]\\) assigns \\!\\(\\*StyleBox[\
\\\"rhs\\\", \\\"TI\\\"]\\) to be the delayed value of \
\\!\\(\\*StyleBox[\\\"lhs\\\", \\\"TI\\\"]\\). \\!\\(\\*StyleBox[\\\"rhs\\\", \
\\\"TI\\\"]\\) is maintained in an unevaluated form. When \
\\!\\(\\*StyleBox[\\\"lhs\\\", \\\"TI\\\"]\\) appears, it is replaced by \
\\!\\(\\*StyleBox[\\\"rhs\\\", \\\"TI\\\"]\\), evaluated afresh each time. \"\
\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"]}]], "Print", "PrintUsage",
 CellTags->"Info3370259502-1872892",
 CellID->1552407446]
}, Open  ]],

Cell[TextData[{
 "When you are using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " through the notebook-based interface, ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 " gives you similar usage information, additionally with a link into a \
full-featured help system."
}], "Text",
 CellID->604586947],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->621996872],

Cell[TextData[{
 ButtonBox["Using the ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"],
  FontSlant->"Italic"],
 ButtonBox[" System",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/UsingTheMathematicaSystemOverview"]
}], "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Getting Help with a Text-Based Interface - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Using the Mathematica System", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/UsingTheMathematicaSystemOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/HyperlinksAndActiveText"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/MathematicaPackages"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 29.2068468}", "context" -> "", 
    "keywords" -> {
     "??", "?", "*", "assistance", "asterisk", "explanations of functions", 
      "functions", "help", "information", "Metacharacters", "names", 
      "options", "queries", "question mark", "regular expressions", 
      "special forms", "star", "symbols", "Unix"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Ways to get information directly from the Mathematica kernel. This gives \
information on the built-in function Log. You can ask for information about \
any object, whether it is built into Mathematica, has been read in from a \
Mathematica package, or has been introduced by you. ", 
    "synonyms" -> {"1.3.9"}, "title" -> 
    "Getting Help with a Text-Based Interface", "type" -> "Tutorial", "uri" -> 
    "tutorial/GettingHelpWithATextBasedInterface"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.3.9"->{
  Cell[1289, 44, 118, 4, 70, "Title",
   CellTags->{"S1.3.9", "9.1"},
   CellID->7813]},
 "9.1"->{
  Cell[1289, 44, 118, 4, 70, "Title",
   CellTags->{"S1.3.9", "9.1"},
   CellID->7813]},
 "Info3370259497-9159438"->{
  Cell[2605, 101, 728, 15, 70, "Print",
   CellTags->"Info3370259497-9159438",
   CellID->413956951]},
 "Info3370259499-5802841"->{
  Cell[4572, 167, 729, 15, 70, "Print",
   CellTags->"Info3370259499-5802841",
   CellID->1789040891],
  Cell[5304, 184, 505, 16, 70, "Print",
   CellTags->"Info3370259499-5802841",
   CellID->839380464]},
 "Info3370259502-1872892"->{
  Cell[14535, 451, 758, 16, 70, "Print",
   CellTags->"Info3370259502-1872892",
   CellID->1552407446]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.3.9", 18840, 563},
 {"9.1", 18939, 567},
 {"Info3370259497-9159438", 19057, 571},
 {"Info3370259499-5802841", 19189, 575},
 {"Info3370259502-1872892", 19424, 582}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 664, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1289, 44, 118, 4, 70, "Title",
 CellTags->{"S1.3.9", "9.1"},
 CellID->7813],
Cell[1410, 50, 697, 24, 70, "DefinitionBox",
 CellID->14907],
Cell[2110, 76, 155, 6, 70, "Caption",
 CellID->29554],
Cell[2268, 84, 226, 8, 70, "MathCaption",
 CellID->31476],
Cell[CellGroupData[{
Cell[2519, 96, 83, 3, 70, "Input",
 CellID->617],
Cell[2605, 101, 728, 15, 70, "Print",
 CellTags->"Info3370259497-9159438",
 CellID->413956951]
}, Open  ]],
Cell[3348, 119, 293, 9, 70, "Text",
 CellID->25429],
Cell[3644, 130, 398, 10, 70, "Text",
 CellID->2264],
Cell[4045, 142, 391, 14, 70, "MathCaption",
 CellID->15966],
Cell[CellGroupData[{
Cell[4461, 160, 86, 3, 70, "Input",
 CellID->19531],
Cell[CellGroupData[{
Cell[4572, 167, 729, 15, 70, "Print",
 CellTags->"Info3370259499-5802841",
 CellID->1789040891],
Cell[5304, 184, 505, 16, 70, "Print",
 CellTags->"Info3370259499-5802841",
 CellID->839380464]
}, Open  ]]
}, Open  ]],
Cell[5836, 204, 331, 11, 70, "MathCaption",
 CellID->19522],
Cell[CellGroupData[{
Cell[6192, 219, 85, 3, 70, "Input",
 CellID->31155],
Cell[6280, 224, 5995, 152, 70, "Print",
 CellID->1680439252]
}, Open  ]],
Cell[12290, 379, 815, 18, 70, "Text",
 CellID->15257],
Cell[13108, 399, 1039, 33, 70, "Text",
 CellID->23158],
Cell[14150, 434, 273, 8, 70, "MathCaption",
 CellID->4464],
Cell[CellGroupData[{
Cell[14448, 446, 84, 3, 70, "Input",
 CellID->13762],
Cell[14535, 451, 758, 16, 70, "Print",
 CellTags->"Info3370259502-1872892",
 CellID->1552407446]
}, Open  ]],
Cell[15308, 470, 345, 11, 70, "Text",
 CellID->604586947],
Cell[CellGroupData[{
Cell[15678, 485, 72, 1, 70, "RelatedTutorialsSection",
 CellID->621996872],
Cell[15753, 488, 431, 12, 70, "RelatedTutorials",
 CellID->344194261]
}, Open  ]]
}, Open  ]],
Cell[16211, 504, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

