(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7623,        220]
NotebookOptionsPosition[      4199,        130]
NotebookOutlinePosition[      7105,        201]
CellTagsIndexPosition[      7013,        195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Manipulating Notebooks" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/ManipulatingNotebooksOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Manipulating Notebooks\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Global Options for the Front End", "Title",
 CellTags->{"S2.11.14", "14.1"},
 CellID->29681],

Cell[TextData[{
 "In the standard notebook front end, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows you to set a large number of global options. The values of all \
these options are by default saved in a \[OpenCurlyDoubleQuote]preferences \
file\[CloseCurlyDoubleQuote], and are automatically reused when you run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " again. These options include all of the settings which can be made using \
the ",
 "Preferences",
 " dialog."
}], "Text",
 CellID->4879],

Cell[BoxData[GridBox[{
   {Cell["style definitions", "TableText"], Cell[
    "default style definitions to use for new notebooks", "TableText"]},
   {Cell["file locations", "TableText"], Cell[
    "directories for finding notebooks and system files", "TableText"]},
   {Cell["data export options", "TableText"], Cell[
    "how to export data in various formats", "TableText"]},
   {Cell["character encoding options", "TableText"], Cell[
    "how to encode special characters", "TableText"]},
   {Cell["language options", "TableText"], Cell[
    "what language to use for text", "TableText"]},
   {Cell["message options", "TableText"], Cell[TextData[{
     "how to handle messages generated by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["dialog settings", "TableText"], Cell[
    "choices made in dialog boxes", "TableText"]},
   {Cell["system configuration", "TableText"], Cell[
    "private options for specific computer systems", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21108],

Cell["Some typical categories of global options for the front end.", "Caption",
 CellID->17207],

Cell[TextData[{
 "You can access global front end options from the kernel by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   RowBox[{
    ButtonBox["$FrontEnd",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$FrontEnd"], ",", "name"}], "]"}]], 
  "InlineFormula"],
 ". But more often, you will want to access these options interactively using \
the Option Inspector in the front end. "
}], "Text",
 CellID->5259],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->14105591],

Cell[TextData[ButtonBox["Manipulating Notebooks",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksOverview"]], "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Global Options for the Front End - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Manipulating Notebooks", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/ManipulatingNotebooksOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OptionsForNotebooks"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 32.9569428}", "context" -> "", 
    "keywords" -> {
     "DefaultStyleDefinitions", "dialog settings", "export options", 
      "file locations", "global options", "language options", "menu settings",
       "message options", "notebook directories", "options", 
      "preferences file"}, "index" -> True, "label" -> "Mathematica Tutorial",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In the standard notebook front end, Mathematica allows you to set a \
large number of global options. The values of all these options are by \
default saved in a 'preferences file', and are automatically reused when you \
run Mathematica again. These options include all of the settings which can be \
made using the Preferences dialog. Some typical categories of global options \
for the front end. You can access global front end options from the kernel by \
using Options[$FrontEnd,name]. But more often, you will want to access these \
options interactively using the Option Inspector in the front end. ", 
    "synonyms" -> {"2.11.14"}, "title" -> "Global Options for the Front End", 
    "type" -> "Tutorial", "uri" -> "tutorial/GlobalOptionsForTheFrontEnd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.11.14"->{
  Cell[1266, 43, 98, 2, 70, "Title",
   CellTags->{"S2.11.14", "14.1"},
   CellID->29681]},
 "14.1"->{
  Cell[1266, 43, 98, 2, 70, "Title",
   CellTags->{"S2.11.14", "14.1"},
   CellID->29681]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.11.14", 6795, 184},
 {"14.1", 6898, 188}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 98, 2, 70, "Title",
 CellTags->{"S2.11.14", "14.1"},
 CellID->29681],
Cell[1367, 47, 521, 14, 70, "Text",
 CellID->4879],
Cell[1891, 63, 1379, 30, 70, "DefinitionBox",
 CellID->21108],
Cell[3273, 95, 95, 1, 70, "Caption",
 CellID->17207],
Cell[3371, 98, 500, 15, 70, "Text",
 CellID->5259],
Cell[CellGroupData[{
Cell[3896, 117, 71, 1, 70, "RelatedTutorialsSection",
 CellID->14105591],
Cell[3970, 120, 175, 4, 70, "RelatedTutorials",
 CellID->81824477]
}, Open  ]]
}, Open  ]],
Cell[4172, 128, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

