(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1524361,      41579]
NotebookOptionsPosition[   1467392,      39624]
NotebookOutlinePosition[   1489732,      40321]
CellTagsIndexPosition[   1489306,      40307]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Operations on Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalOperationsOnDataOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Operations on Data\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"],
           "GraphPlot" :> Documentation`HelpLookup["paclet:ref/GraphPlot"], 
          "GraphPlot3D" :> Documentation`HelpLookup["paclet:ref/GraphPlot3D"],
           "high-dimensional embedding" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphDrawingIntroduction#105832149"], 
          "radial drawing" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphDrawingIntroduction#437048596"], 
          "spring-electrical embedding" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphDrawingIntroduction#425607435"], 
          "spring embedding" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphDrawingIntroduction#301083942"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 
       2->"\<\"GraphPlot\"\>", 3->"\<\"GraphPlot3D\"\>", 
       4->"\<\"high-dimensional embedding\"\>", 5->"\<\"radial drawing\"\>", 
       6->"\<\"spring-electrical embedding\"\>", 
       7->"\<\"spring embedding\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["General Graph Drawing", "Title",
 CellTags->{"graphplot", "i:3", "b:0.1"},
 CellID->672278587],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " calculate and plot a visually appealing 2D/3D layout of a graph. The \
functions are designed to work with very large graphs and handle both \
connected and disconnected graphs. "
}], "Text",
 CellID->621106430],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphPlot"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i1", "TI"]], "->", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["j1", "TI"]]}], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i2", "TI"]], "->", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["j2", "TI"]]}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "generate a plot of the graph in which vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["ik", "TI"]]], "InlineFormula"],
     " is connected to vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["jk", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphPlot"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["i1", "TI"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["j1", "TI"]]}], ",", 
         SubscriptBox[
          StyleBox["lbl", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "associate labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " with edges in the graph"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphPlot"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "generate a plot of the graph represented by the adjacency matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphPlot3D"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i1", "TI"]], "->", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["j1", "TI"]]}], ",", 
       RowBox[{
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["i2", "TI"]], "->", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["j2", "TI"]]}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "generate a 3D plot of the graph in which vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["ik", "TI"]]], "InlineFormula"],
     " is connected to vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["jk", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphPlot3D"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["i1", "TI"]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["j1", "TI"]]}], ",", 
         SubscriptBox[
          StyleBox["lbl", "TI"], 
          StyleBox["1", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "associate labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " with edges in the graph"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GraphPlot3D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphPlot3D"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "generate a 3D plot of the graph represented by the adjacency matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellTags->"b:0.1",
 CellID->25485965],

Cell["Graph drawing functions.", "Caption",
 CellTags->"b:0.1",
 CellID->164814425],

Cell["This plots a graph specified by a rule list.", "MathCaption",
 CellTags->"b:0.1",
 CellID->26060231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<d\>\"", "\[Rule]", "\"\<c\>\""}], ",", 
     RowBox[{"\"\<e\>\"", "\[Rule]", "\"\<b\>\""}], ",", 
     RowBox[{"\"\<e\>\"", "\[Rule]", "\"\<c\>\""}], ",", 
     RowBox[{"\"\<e\>\"", "\[Rule]", "\"\<d\>\""}], ",", 
     RowBox[{"\"\<f\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
     RowBox[{"\"\<f\>\"", "\[Rule]", "\"\<b\>\""}], ",", 
     RowBox[{"\"\<f\>\"", "\[Rule]", "\"\<d\>\""}], ",", 
     RowBox[{"\"\<f\>\"", "\[Rule]", "\"\<e\>\""}], ",", 
     RowBox[{"\"\<g\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
     RowBox[{"\"\<g\>\"", "\[Rule]", "\"\<b\>\""}], ",", 
     RowBox[{"\"\<g\>\"", "\[Rule]", "\"\<c\>\""}], ",", 
     RowBox[{"\"\<g\>\"", "\[Rule]", "\"\<e\>\""}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129836502],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.0004335335542559049, 1.252010024273976}, {0., 
    0.16472198410657235`}, {0.607551375114222, 0.7079936305106868}, {
    1.4689784640966628`, 0.7079994981255698}, {1.1820028697220653`, 
    1.4170427432350747`}, {2.1975667099280676`, 0.7080939445782499}, {
    1.181868075917291, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 2}, {3, 1}, {5, 6}, {5, 4}, {5, 1}, {5, 
       3}, {7, 6}, {7, 4}, {7, 2}, {7, 3}}]}, {InsetBox[
       FrameBox["\<\"d\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"c\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"e\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"b\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["\<\"f\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["\<\"a\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["\<\"g\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.0004335335542559049, 1.252010024273976}, {0.,
      0.16472198410657235`}, {0.607551375114222, 0.7079936305106868}, {
     1.4689784640966628`, 0.7079994981255698}, {1.1820028697220653`, 
     1.4170427432350747`}, {2.1975667099280676`, 0.7080939445782499}, {
     1.181868075917291, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{242., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{246, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1789943041]
}, Open  ]],

Cell["\<\
For disconnected graphs, individual components are laid out in a visually \
appealing way and assembled.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->467241818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "2"}], ",", "129"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "128"}], "}"}]}], "]"}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[2]:=",
 CellID->390885444],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxNV3k8lGsbtpfs+5IZYwYz86LhFG303pEUnTindGxR6ig6kZKKdoRS2bJU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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141,
         142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 1}, {2, 153, 
        154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
        168, 169, 170, 171, 172, 173, 174, 175, 2}, {3, 4}, {4, 7}, {5, 6}, {
        6, 16}, {7, 28}, {8, 9}, {9, 43}, {10, 176, 177, 178, 179, 180, 181, 
        182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 11}, {11, 192, 193, 
        194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 
        10}, {12, 13}, {13, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
        218, 219, 220, 221, 222, 223, 59}, {14, 15}, {15, 39}, {16, 74}, {17, 
        18}, {18, 26}, {19, 20}, {20, 15}, {21, 22}, {22, 27}, {23, 24}, {24, 
        63}, {25, 26}, {26, 34}, {27, 54}, {28, 4}, {29, 30}, {30, 51}, {31, 
        32}, {32, 86}, {33, 34}, {34, 30}, {35, 23}, {36, 37}, {37, 78}, {38, 
        39}, {39, 20}, {40, 23}, {41, 42}, {42, 82}, {43, 23}, {44, 30}, {45, 
        46}, {46, 70}, {47, 17}, {48, 26}, {49, 50}, {50, 6}, {51, 17}, {52, 
        20}, {53, 54}, {54, 41}, {55, 56}, {56, 9}, {57, 15}, {58, 59}, {59, 
        224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 
        238, 239, 13}, {60, 9}, {61, 62}, {62, 46}, {63, 56}, {64, 4}, {65, 
        66}, {66, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 
        252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 66}, {67, 263, 
        264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 
        278, 279, 280, 281, 282, 283, 284, 285, 67}, {68, 2}, {69, 70}, {70, 
        62}, {71, 63}, {72, 7}, {73, 74}, {74, 32}, {75, 13}, {76, 36}, {77, 
        18}, {78, 36}, {79, 51}, {80, 24}, {81, 28}, {82, 22}, {83, 43}, {84, 
        34}, {85, 86}, {86, 50}, {87, 39}, {88, 43}, {89, 82}, {90, 28}, {91, 
        17}, {92, 41}, {93, 24}, {94, 51}, {95, 78}, {96, 18}, {97, 56}, {98, 
        59}, {99, 7}, {100, 63}, {101, 2}, {102, 67}, {103, 4}, {104, 63}, {
        105, 9}, {106, 59}, {107, 10}, {108, 15}, {109, 56}, {110, 51}, {111, 
        17}, {112, 43}, {113, 42}, {114, 23}, {115, 39}, {116, 37}, {117, 
        34}, {118, 30}, {119, 28}, {120, 27}, {121, 26}, {122, 24}, {123, 
        20}, {124, 18}, {125, 16}, {126, 13}, {127, 11}, {128, 7}, {129, 
        2}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "121"],
       Annotation[#, 121, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "127"],
       Annotation[#, 127, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "103"],
       Annotation[#, 103, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "109"],
       Annotation[#, 109, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "126"],
       Annotation[#, 126, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "124"],
       Annotation[#, 124, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "102"],
       Annotation[#, 102, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "111"],
       Annotation[#, 111, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "117"],
       Annotation[#, 117, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "101"],
       Annotation[#, 101, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "104"],
       Annotation[#, 104, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "105"],
       Annotation[#, 105, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "106"],
       Annotation[#, 106, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "107"],
       Annotation[#, 107, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "108"],
       Annotation[#, 108, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "110"],
       Annotation[#, 110, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "112"],
       Annotation[#, 112, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "113"],
       Annotation[#, 113, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "114"],
       Annotation[#, 114, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "115"],
       Annotation[#, 115, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "116"],
       Annotation[#, 116, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "118"],
       Annotation[#, 118, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        "119"],
       Annotation[#, 119, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "120"],
       Annotation[#, 120, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "122"],
       Annotation[#, 122, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "123"],
       Annotation[#, 123, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[128],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[129],
        "128"],
       Annotation[#, 128, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNVXs81HkXNuNSYZiZxm0yY8xgbmyUS8nu75SoRluzW8qtbPKKSlKykt7I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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{197., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{201, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[2]=",
 CellID->536350139]
}, Open  ]],

Cell[TextData[{
 "This is a larger graph defined by a sparse adjacency matrix from a \
structural engineering application. The matrix comes from the ",
 ButtonBox["Harwell\[Dash]Boeing Collection",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://math.nist.gov/MatrixMarket/data/Harwell-Boeing/dwt/dwt_1005.\
html"], None}],
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->539868986],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\<LinearAlgebraExamples/Data/dwt_1005.psa\>\"", ",", 
     "\"\<HarwellBoeing\>\""}], "]"}]}], ";"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[3]:=",
 CellID->132832097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"a", ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[4]:=",
 CellID->2356310],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{268, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[4]=",
 CellID->19834935]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " may produce slightly different output on different platforms, due to \
floating-point differences."
}], "Text",
 CellTags->"b:0.1",
 CellID->379372821],

Cell[CellGroupData[{

Cell["Options for GraphPlot and GraphPlot3D", "Section",
 CellTags->{"Options_for_GraphPlot", "b:0.1"},
 CellID->267311437],

Cell[TextData[{
 "The following options are accepted for ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " (",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 " and",
 " ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " options are only valid for ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 "), in addition, options for ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " are accepted."
}], "Text",
 CellTags->"b:0.1",
 CellID->66806916],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["DirectedEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DirectedEdges"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to show edges as directed arrows", "TableText"]},
   {
    ButtonBox["EdgeLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeLabeling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include labels given for edges", "TableText"]},
   {
    ButtonBox["EdgeRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for edges", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method used to lay out the graph", "TableText"]},
   {
    ButtonBox["MultiedgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MultiedgeStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw multiple edges between vertices", "TableText"]},
   {
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much padding to put around the plot", "TableText"]},
   {
    ButtonBox["PackingMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PackingMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], 
    StyleBox[
     RowBox[{
     "method", " ", "to", " ", "use", " ", "for", " ", "packing", " ", 
      "components"}],
     FontFamily->"Verdana",
     FontSize->10]},
   {
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style in which objects are drawn", "TableText"]},
   {
    ButtonBox["SelfLoopStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SelfLoopStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw edges linking a vertex to itself", "TableText"]},
   {
    ButtonBox["VertexCoordinateRules",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexCoordinateRules"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "rules for explicit vertex coordinates", "TableText"]},
   {
    ButtonBox["VertexLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexLabeling"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to show vertex names as labels", "TableText"]},
   {
    ButtonBox["VertexRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for vertices", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1",
 CellID->34662378],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.1",
 CellID->428527873],

Cell[CellGroupData[{

Cell["DirectedEdges", "Subsection",
 CellTags->"b:0.1",
 CellID->94783224],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 " specifies whether to draw edges as arrows. Possible values for this option \
are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". The default value for this option is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Text",
 CellID->4330256],

Cell["This shows a graph with edges represented by arrows.", "MathCaption",
 CellID->65768921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"3", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"4", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", " ", "True"}], ",", 
   RowBox[{"VertexLabeling", " ", "\[Rule]", " ", "True"}]}], "]"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->286869807],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.36327126408405364`, 1.8090169944118928`}, {
    0.9510565163256759, 1.}, {0., 0.6909830057189905}, {0.951056516190987, 
    0.}, {1.902113032568109, 0.6909830054627958}, {1.5388417687852298`, 
    1.809016994253556}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03444668289820355, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 2}], ArrowBox[{4, 2}], ArrowBox[{5, 2}], 
      ArrowBox[{6, 2}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.36327126408405364`, 1.8090169944118928`}, {
     0.9510565163256759, 1.}, {0., 0.6909830057189905}, {0.951056516190987, 
     0.}, {1.902113032568109, 0.6909830054627958}, {1.5388417687852298`, 
     1.809016994253556}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{173., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{177, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->275198367]
}, Open  ]],

Cell["This makes the arrow heads larger.", "MathCaption",
 CellID->38953110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"GraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "6"}], ",", 
       RowBox[{"2", "\[Rule]", " ", "6"}], ",", 
       RowBox[{"3", "\[Rule]", " ", "6"}], ",", 
       RowBox[{"4", "\[Rule]", " ", "6"}], ",", 
       RowBox[{"5", "\[Rule]", " ", "6"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
     RowBox[{"DirectedEdges", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"True", ",", 
        RowBox[{"\"\<ArrowheadsSize\>\"", "\[Rule]", "asize"}]}], "}"}]}], 
     ",", 
     RowBox[{"VertexLabeling", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"asize", ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.1", ",", "0.15"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->503553477],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24666800]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EdgeLabeling", "Subsection",
 CellTags->"b:0.1",
 CellID->73118839],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " specifies whether and how to display labels given for the edges. Possible \
values for this option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". The default value for this option is",
 " ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", which displays the supplied edge labels on the graph. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the labels are shown as tooltips."
}], "Text",
 CellID->1357462998],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " displays the supplied label for the edge between vertices 3 and 6",
 "."
}], "MathCaption",
 CellID->436860255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<edge 3->6\>\""}], "}"}], 
     ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->158922999],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.1493322121100826`, 0.00024224688259011362`}, {
    1.9450835562462694`, 0.8705665189068674}, {1.074095746585374, 
    0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
    0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{2, 3}], LineBox[{4, 5}], LineBox[{4, 3}], LineBox[{5, 3}], 
      LineBox[{6, 5}], LineBox[{6, 2}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"edge 3->6\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 3}]}}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.1493322121100826`, 
     0.00024224688259011362`}, {1.9450835562462694`, 0.8705665189068674}, {
     1.074095746585374, 0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
     0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{221., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{225, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1774274401]
}, Open  ]],

Cell["\<\
This displays the edge label as a tooltip. Place the cursor over the edge \
between vertices 3 and 6 to see the tooltip.\
\>", "MathCaption",
 CellID->18324741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<edge 3->6\>\""}], "}"}], 
     ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "Automatic"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->387051984],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.1493322121100826`, 0.00024224688259011362`}, {
    1.9450835562462694`, 0.8705665189068674}, {1.074095746585374, 
    0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
    0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{2, 3}], LineBox[{4, 5}], LineBox[{4, 3}], LineBox[{5, 3}], 
      LineBox[{6, 5}], LineBox[{6, 2}], 
      TagBox[
       TooltipBox[LineBox[{6, 3}],
        "\"edge 3->6\""],
       Annotation[#, "edge 3->6", "Tooltip"]& ]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.1493322121100826`, 
     0.00024224688259011362`}, {1.9450835562462694`, 0.8705665189068674}, {
     1.074095746585374, 0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
     0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{237., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{241, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->461647175]
}, Open  ]],

Cell[TextData[{
 "Alternatively, use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["i", "TI"]], "->", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["j", "TI"]]}], ",", 
    StyleBox["lbl", "TI"]}], "]"}]], "InlineFormula"],
 " to specify a tooltip for an edge. Place the cursor over the edge between \
vertices 3 and 6, as well as over the edge label on the edge between vertices \
3 and 5, to see the tooltips",
 "."
}], "MathCaption",
 CellID->442920185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"Tooltip", "[", " ", 
        RowBox[{"\"\<edge 3->5\>\"", ",", "\"\<3->5\>\""}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "6"}], ",", " ", "\"\<3->6\>\""}], "]"}], ",", 
     
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->231011357],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.1493322121100826`, 0.00024224688259011362`}, {
    1.9450835562462694`, 0.8705665189068674}, {1.074095746585374, 
    0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
    0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{2, 3}], LineBox[{4, 5}], LineBox[{4, 3}], LineBox[{5, 3}], 
      LineBox[{6, 5}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox[
                TagBox[
                 TooltipBox["\"edge 3->5\"", "\"3->5\""], 
                 Annotation[#, "3->5", "Tooltip"]& ], StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 2}]}, 
      TagBox[
       TooltipBox[LineBox[{6, 3}],
        "\"3->6\""],
       Annotation[#, "3->6", "Tooltip"]& ]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.1493322121100826`, 
     0.00024224688259011362`}, {1.9450835562462694`, 0.8705665189068674}, {
     1.074095746585374, 0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
     0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{229., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{233, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->261579151]
}, Open  ]],

Cell[TextData[{
 "To display the supplied label for the edge in 3D, ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " needs to be used. See ",
 ButtonBox["the following",
  BaseStyle->"Hyperlink",
  ButtonData->"EdgeLabel3D"],
 "."
}], "Text",
 CellID->1694807378]
}, Open  ]],

Cell[CellGroupData[{

Cell["EdgeRenderingFunction", "Subsection",
 CellTags->"b:0.1",
 CellID->229062904],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " specifies graphical representation of the graph edges. Possible values for \
this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or a function that gives a proper combination of graphics primitives and \
directives. With the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a dark red line is drawn for each edge. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", edges are not drawn."
}], "Text",
 CellTags->"b:0.1",
 CellID->1564098284],

Cell["This draws vertices only.", "MathCaption",
 CellTags->"b:0.1",
 CellID->683565354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "30", "}"}]}], "]"}], ",", " ", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[9]:=",
 CellID->115400586],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.2637400368258884`, 1.33132944386964}, {0., 
    1.0122792160539114`}, {0.501361683705464, 1.6206889701496907`}, {
    1.1304490166458183`, 1.5925007482801976`}, {0.6310534045340972, 
    1.342469471720966}, {1.6372673438668572`, 0.8417464441100854}, {
    1.4751015194386556`, 0.2650244658022096}, {0.012075058143842576`, 
    0.7525088989862943}, {0.6293169246052006, 0.3196259941692873}, {
    0.9243758702546352, 0.6678911026849398}, {0.6760250320495527, 
    0.995155568431079}, {0.7634481530712454, 0.}, {0.33504369469325807`, 
    1.3490132464245992`}, {0.9448268014877536, 1.3044812110337927`}, {
    0.8229128292379534, 1.6257312000192252`}, {0.3069100340239362, 
    0.5957389119331039}, {0.02816412132253776, 0.4648885644593926}, {
    1.2564130195727667`, 0.7067621151870775}, {0.45866480845870833`, 
    0.06485077144282869}, {1.052061506953173, 1.0122827442255402`}, {
    0.5814289850802787, 0.6194931479876431}, {1.240633684788401, 
    0.31172716333111417`}, {1.5208650345766785`, 1.295984777252058}, {
    0.9433437327262558, 0.2947390894067644}, {0.3331908796482032, 
    1.0029991383836303`}, {0.08837873177579003, 1.3217308222482897`}, {
    1.541321351868358, 0.5658786955224331}, {1.4451999417048813`, 
    1.027677055006469}, {0.2308901744853944, 0.23918627208796917`}, {
    1.0895204039826893`, 0.017196833947416112`}}, {
     {RGBColor[0.5, 0., 0.]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2637400368258884`, 1.33132944386964}, {0., 
     1.0122792160539114`}, {0.501361683705464, 1.6206889701496907`}, {
     1.1304490166458183`, 1.5925007482801976`}, {0.6310534045340972, 
     1.342469471720966}, {1.6372673438668572`, 0.8417464441100854}, {
     1.4751015194386556`, 0.2650244658022096}, {0.012075058143842576`, 
     0.7525088989862943}, {0.6293169246052006, 0.3196259941692873}, {
     0.9243758702546352, 0.6678911026849398}, {0.6760250320495527, 
     0.995155568431079}, {0.7634481530712454, 0.}, {0.33504369469325807`, 
     1.3490132464245992`}, {0.9448268014877536, 1.3044812110337927`}, {
     0.8229128292379534, 1.6257312000192252`}, {0.3069100340239362, 
     0.5957389119331039}, {0.02816412132253776, 0.4648885644593926}, {
     1.2564130195727667`, 0.7067621151870775}, {0.45866480845870833`, 
     0.06485077144282869}, {1.052061506953173, 1.0122827442255402`}, {
     0.5814289850802787, 0.6194931479876431}, {1.240633684788401, 
     0.31172716333111417`}, {1.5208650345766785`, 1.295984777252058}, {
     0.9433437327262558, 0.2947390894067644}, {0.3331908796482032, 
     1.0029991383836303`}, {0.08837873177579003, 1.3217308222482897`}, {
     1.541321351868358, 0.5658786955224331}, {1.4451999417048813`, 
     1.027677055006469}, {0.2308901744853944, 0.23918627208796917`}, {
     1.0895204039826893`, 0.017196833947416112`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{159., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{163, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[9]=",
 CellID->215069822]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each edge is rendered with the graphics primitives and directives given \
by the function ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " that can take three or more arguments, in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    SubscriptBox[
     StyleBox["lbl", "TI"], 
     StyleBox["ij", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the coordinates of the beginning and ending points of the edge, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["j", "TI"]]], "InlineFormula"],
 " are the beginning and ending vertices, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is any label specified for the edge or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ". Explicit settings for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->270347621],

Cell["\<\
This plots the edges as gray arrows with ends set back from vertices by a \
distance 0.1 (in the graph's coordinate system).\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->361895683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"12", "\[Rule]", "13"}], ",", 
     RowBox[{"13", "\[Rule]", "14"}], ",", 
     RowBox[{"14", "\[Rule]", "15"}], ",", 
     RowBox[{"15", "\[Rule]", "16"}], ",", 
     RowBox[{"16", "\[Rule]", "17"}], ",", 
     RowBox[{"17", "\[Rule]", "11"}], ",", 
     RowBox[{"1", "\[Rule]", "11"}], ",", 
     RowBox[{"2", "\[Rule]", "12"}], ",", 
     RowBox[{"3", "\[Rule]", "13"}], ",", 
     RowBox[{"4", "\[Rule]", "14"}], ",", 
     RowBox[{"5", "\[Rule]", "15"}], ",", 
     RowBox[{"6", "\[Rule]", "16"}], ",", 
     RowBox[{"7", "\[Rule]", "17"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#1", ",", "0.1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[10]:=",
 CellID->445960829],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {GrayLevel[0.5], 
       ArrowBox[{{1.5064677869962946`, 0.}, {0.6820526030999533, 
        0.7980048888232217}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.5064677869962946`, 0.}, {0.8762236981961349, 
        0.03885967636246468}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.6820526030999533, 0.7980048888232217}, {
        0.6654409219985038, 1.9079730518134361`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.6820526030999533, 0.7980048888232217}, {
        0.016313516035854514`, 0.7740356514674346}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.6654409219985038, 1.9079730518134361`}, {
        1.4653347518559192`, 2.7305034299828264`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.6654409219985038, 1.9079730518134361`}, {0., 
        1.9137818351401907`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.4653347518559192`, 2.7305034299828264`}, {
        2.583169249570491, 2.4416743353854846`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.4653347518559192`, 2.7305034299828264`}, {
        0.835712802142118, 2.6746903215794324`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.583169249570491, 2.4416743353854846`}, {3.061300934457917,
         1.3891940801745701`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.583169249570491, 2.4416743353854846`}, {
        1.9493453215911614`, 2.356057907445103}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{3.061300934457917, 1.3891940801745701`}, {2.615566425474272,
         0.3224815475706573}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{3.061300934457917, 1.3891940801745701`}, {2.408775449597713,
         1.3801682026644264`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.615566425474272, 0.3224815475706573}, {
        1.5064677869962946`, 0.}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.615566425474272, 0.3224815475706573}, {
        1.9779664918855286`, 0.3908296500159092}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.8762236981961349, 0.03885967636246468}, {
        0.016313516035854514`, 0.7740356514674346}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.016313516035854514`, 0.7740356514674346}, {0., 
        1.9137818351401907`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0., 1.9137818351401907`}, {0.835712802142118, 
        2.6746903215794324`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.835712802142118, 2.6746903215794324`}, {
        1.9493453215911614`, 2.356057907445103}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.9493453215911614`, 2.356057907445103}, {2.408775449597713,
         1.3801682026644264`}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{2.408775449597713, 1.3801682026644264`}, {
        1.9779664918855286`, 0.3908296500159092}}, 0.1]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.9779664918855286`, 0.3908296500159092}, {
        0.8762236981961349, 0.03885967636246468}}, 0.1]}}, 
     GraphicsComplexBox[{{1.5064677869962946`, 0.}, {0.6820526030999533, 
      0.7980048888232217}, {0.6654409219985038, 1.9079730518134361`}, {
      1.4653347518559192`, 2.7305034299828264`}, {2.583169249570491, 
      2.4416743353854846`}, {3.061300934457917, 1.3891940801745701`}, {
      2.615566425474272, 0.3224815475706573}, {0.8762236981961349, 
      0.03885967636246468}, {0.016313516035854514`, 0.7740356514674346}, {0., 
      1.9137818351401907`}, {0.835712802142118, 2.6746903215794324`}, {
      1.9493453215911614`, 2.356057907445103}, {2.408775449597713, 
      1.3801682026644264`}, {1.9779664918855286`, 0.3908296500159092}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "7"],
        Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "11"],
        Annotation[#, 11, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[9],
         "12"],
        Annotation[#, 12, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[10],
         "13"],
        Annotation[#, 13, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[11],
         "14"],
        Annotation[#, 14, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[12],
         "15"],
        Annotation[#, 15, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[13],
         "16"],
        Annotation[#, 16, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[14],
         "17"],
        Annotation[#, 17, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.5064677869962946`, 0.}, {0.6820526030999533, 
     0.7980048888232217}, {0.6654409219985038, 1.9079730518134361`}, {
     1.4653347518559192`, 2.7305034299828264`}, {2.583169249570491, 
     2.4416743353854846`}, {3.061300934457917, 1.3891940801745701`}, {
     2.615566425474272, 0.3224815475706573}, {0.8762236981961349, 
     0.03885967636246468}, {0.016313516035854514`, 0.7740356514674346}, {0., 
     1.9137818351401907`}, {0.835712802142118, 2.6746903215794324`}, {
     1.9493453215911614`, 2.356057907445103}, {2.408775449597713, 
     1.3801682026644264`}, {1.9779664918855286`, 0.3908296500159092}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{221., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{225, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[10]=",
 CellID->1800095291]
}, Open  ]],

Cell["\<\
This generates edge labels or displays the ones supplied in the description \
of the graph.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->241829550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "5"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "6"}], ",", 
      RowBox[{"3", "\[Rule]", "4"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"3", "\[Rule]", "6"}], ",", "\"\<edge 3->6\>\""}], "}"}], ",",
       
      RowBox[{"4", "\[Rule]", "6"}], ",", 
      RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
    RowBox[{"EdgeRenderingFunction", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"Line", "[", "#1", "]"}]}], "}"}], ",", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"#3", "===", "None"}], ",", "#2", ",", "#3"}], "]"}], 
           ",", 
           RowBox[{
            RowBox[{"Total", "[", "#1", "]"}], "/", "2."}], ",", 
           RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], 
       "&"}], ")"}]}], ",", 
    RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}], "\n"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->875867714],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{218, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->276074021]
}, Open  ]],

Cell[TextData[{
 "This draws straight edges in black and other edges (two multiedges and a \
self-loop) in red. The function ",
 Cell[BoxData[
  ButtonBox["LineScaledCoordinate",
   BaseStyle->"Link",
   ButtonData->"paclet:GraphUtilities/ref/LineScaledCoordinate"]], 
  "InlineFormula"],
 " from the package ",
 Cell[BoxData["GraphUtilities"], "InlineFormula"],
 " is used to place labels at 70% of the length of the edge."
}], "MathCaption",
 CellTags->"EdgeLabel3D",
 CellID->1664266962],

Cell[BoxData[
 RowBox[{"<<", "GraphUtilities`"}]], "Input",
 CellTags->"EdgeLabel3D",
 CellLabel->"In[12]:=",
 CellID->44356416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"2", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"3", "\[Rule]", "4"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "1"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "2"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "#1", "]"}], ">", "2"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Line", "[", "#1", "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"First", "[", "#1", "]"}], "===", 
               RowBox[{"Last", "[", "#1", "]"}]}], ",", "\"\<loop\>\"", ",", 
              "\"\<multiedge\>\""}], "]"}], ",", 
            RowBox[{"LineScaledCoordinate", "[", 
             RowBox[{"#1", ",", ".7"}], "]"}], ",", 
            RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], ",",
         
        RowBox[{"Line", "[", "#1", "]"}]}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"EdgeLabel3D",
 CellLabel->"In[13]:=",
 CellID->300897750],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{285, 236},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"EdgeLabel3D",
 CellLabel->"Out[13]=",
 CellID->376909276]
}, Open  ]],

Cell["\<\
This plots a 3D graph using spheres for vertices and cylinders for edges.\
\>", "MathCaption",
 CellID->96589048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"11", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"16", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"21", "\[Rule]", "4"}], ",", 
     RowBox[{"26", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}], ",", 
     RowBox[{"10", "\[Rule]", "6"}], ",", 
     RowBox[{"8", "\[Rule]", "7"}], ",", 
     RowBox[{"30", "\[Rule]", "7"}], ",", 
     RowBox[{"9", "\[Rule]", "8"}], ",", 
     RowBox[{"42", "\[Rule]", "8"}], ",", 
     RowBox[{"10", "\[Rule]", "9"}], ",", 
     RowBox[{"38", "\[Rule]", "9"}], ",", 
     RowBox[{"12", "\[Rule]", "10"}], ",", 
     RowBox[{"12", "\[Rule]", "11"}], ",", 
     RowBox[{"15", "\[Rule]", "11"}], ",", 
     RowBox[{"13", "\[Rule]", "12"}], ",", 
     RowBox[{"14", "\[Rule]", "13"}], ",", 
     RowBox[{"37", "\[Rule]", "13"}], ",", 
     RowBox[{"15", "\[Rule]", "14"}], ",", 
     RowBox[{"33", "\[Rule]", "14"}], ",", 
     RowBox[{"17", "\[Rule]", "15"}], ",", 
     RowBox[{"17", "\[Rule]", "16"}], ",", 
     RowBox[{"20", "\[Rule]", "16"}], ",", 
     RowBox[{"18", "\[Rule]", "17"}], ",", 
     RowBox[{"19", "\[Rule]", "18"}], ",", 
     RowBox[{"32", "\[Rule]", "18"}], ",", 
     RowBox[{"20", "\[Rule]", "19"}], ",", 
     RowBox[{"53", "\[Rule]", "19"}], ",", 
     RowBox[{"22", "\[Rule]", "20"}], ",", 
     RowBox[{"22", "\[Rule]", "21"}], ",", 
     RowBox[{"25", "\[Rule]", "21"}], ",", 
     RowBox[{"23", "\[Rule]", "22"}], ",", 
     RowBox[{"24", "\[Rule]", "23"}], ",", 
     RowBox[{"52", "\[Rule]", "23"}], ",", 
     RowBox[{"25", "\[Rule]", "24"}], ",", 
     RowBox[{"48", "\[Rule]", "24"}], ",", 
     RowBox[{"27", "\[Rule]", "25"}], ",", 
     RowBox[{"27", "\[Rule]", "26"}], ",", 
     RowBox[{"30", "\[Rule]", "26"}], ",", 
     RowBox[{"28", "\[Rule]", "27"}], ",", 
     RowBox[{"29", "\[Rule]", "28"}], ",", 
     RowBox[{"47", "\[Rule]", "28"}], ",", 
     RowBox[{"30", "\[Rule]", "29"}], ",", 
     RowBox[{"43", "\[Rule]", "29"}], ",", 
     RowBox[{"32", "\[Rule]", "31"}], ",", 
     RowBox[{"35", "\[Rule]", "31"}], ",", 
     RowBox[{"54", "\[Rule]", "31"}], ",", 
     RowBox[{"33", "\[Rule]", "32"}], ",", 
     RowBox[{"34", "\[Rule]", "33"}], ",", 
     RowBox[{"35", "\[Rule]", "34"}], ",", 
     RowBox[{"36", "\[Rule]", "34"}], ",", 
     RowBox[{"56", "\[Rule]", "35"}], ",", 
     RowBox[{"37", "\[Rule]", "36"}], ",", 
     RowBox[{"40", "\[Rule]", "36"}], ",", 
     RowBox[{"38", "\[Rule]", "37"}], ",", 
     RowBox[{"39", "\[Rule]", "38"}], ",", 
     RowBox[{"40", "\[Rule]", "39"}], ",", 
     RowBox[{"41", "\[Rule]", "39"}], ",", 
     RowBox[{"57", "\[Rule]", "40"}], ",", 
     RowBox[{"42", "\[Rule]", "41"}], ",", 
     RowBox[{"45", "\[Rule]", "41"}], ",", 
     RowBox[{"43", "\[Rule]", "42"}], ",", 
     RowBox[{"44", "\[Rule]", "43"}], ",", 
     RowBox[{"45", "\[Rule]", "44"}], ",", 
     RowBox[{"46", "\[Rule]", "44"}], ",", 
     RowBox[{"58", "\[Rule]", "45"}], ",", 
     RowBox[{"47", "\[Rule]", "46"}], ",", 
     RowBox[{"50", "\[Rule]", "46"}], ",", 
     RowBox[{"48", "\[Rule]", "47"}], ",", 
     RowBox[{"49", "\[Rule]", "48"}], ",", 
     RowBox[{"50", "\[Rule]", "49"}], ",", 
     RowBox[{"51", "\[Rule]", "49"}], ",", 
     RowBox[{"59", "\[Rule]", "50"}], ",", 
     RowBox[{"52", "\[Rule]", "51"}], ",", 
     RowBox[{"55", "\[Rule]", "51"}], ",", 
     RowBox[{"53", "\[Rule]", "52"}], ",", 
     RowBox[{"54", "\[Rule]", "53"}], ",", 
     RowBox[{"55", "\[Rule]", "54"}], ",", 
     RowBox[{"60", "\[Rule]", "55"}], ",", 
     RowBox[{"57", "\[Rule]", "56"}], ",", 
     RowBox[{"60", "\[Rule]", "56"}], ",", 
     RowBox[{"58", "\[Rule]", "57"}], ",", 
     RowBox[{"59", "\[Rule]", "58"}], ",", 
     RowBox[{"60", "\[Rule]", "59"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Cylinder", "[", 
        RowBox[{"#1", ",", ".1"}], "]"}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Sphere", "[", 
        RowBox[{"#", ",", ".25"}], "]"}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->250920945],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     CylinderBox[{{3.4034867403936513`, 1.4619004888421065`, 
      0.35185221628081154`}, {3.6164810096371696`, 0.7592905178567695, 
      0.9992876799464905}}, 0.1], 
     CylinderBox[{{4.377483610272962, 1.078633671218928, 
      1.5367524631844947`}, {3.6164810096371696`, 0.7592905178567695, 
      0.9992876799464905}}, 0.1], 
     CylinderBox[{{4.377483610272962, 1.078633671218928, 
      1.5367524631844947`}, {4.632479871671187, 1.9800271984387146`, 
      1.2316762958624239`}}, 0.1], 
     CylinderBox[{{2.8457904130454126`, 0.21537542821665978`, 
      1.427846942437405}, {3.6164810096371696`, 0.7592905178567695, 
      0.9992876799464905}}, 0.1], 
     CylinderBox[{{4.031062680042262, 2.211795677886746, 
      0.49810933103024846`}, {3.4034867403936513`, 1.4619004888421065`, 
      0.35185221628081154`}}, 0.1], 
     CylinderBox[{{2.3998551762630354`, 1.6406168827871337`, 
      0.09709691453739566}, {3.4034867403936513`, 1.4619004888421065`, 
      0.35185221628081154`}}, 0.1], 
     CylinderBox[{{4.632479871671187, 1.9800271984387146`, 
      1.2316762958624239`}, {4.031062680042262, 2.211795677886746, 
      0.49810933103024846`}}, 0.1], 
     CylinderBox[{{3.68664430101476, 3.183471526538956, 0.3943000414643798}, {
      4.031062680042262, 2.211795677886746, 0.49810933103024846`}}, 0.1], 
     CylinderBox[{{4.9285880046412665`, 2.6989779939962126`, 
      1.9102700024496815`}, {4.632479871671187, 1.9800271984387146`, 
      1.2316762958624239`}}, 0.1], 
     CylinderBox[{{4.410733522300111, 0.8543857737247285, 
      2.5419443073413737`}, {4.377483610272962, 1.078633671218928, 
      1.5367524631844947`}}, 0.1], 
     CylinderBox[{{2.884959587382348, 0., 2.3770382477292165`}, {
      2.8457904130454126`, 0.21537542821665978`, 1.427846942437405}}, 0.1], 
     CylinderBox[{{1.9028591735835318`, 0.3899421046218916, 
      1.189414329039538}, {2.8457904130454126`, 0.21537542821665978`, 
      1.427846942437405}}, 0.1], 
     CylinderBox[{{1.9028591735835318`, 0.3899421046218916, 
      1.189414329039538}, {1.3460696565802874`, 0.2817284459552658, 
      1.9889129198641486`}}, 0.1], 
     CylinderBox[{{1.9598315371915127`, 0.0436993497445366, 
      2.7241239949923237`}, {2.884959587382348, 0., 2.3770382477292165`}}, 
      0.1], CylinderBox[{{3.688502225544336, 0.33018731164920645`, 
      2.944204002605743}, {2.884959587382348, 0., 2.3770382477292165`}}, 0.1],
      CylinderBox[{{3.688502225544336, 0.33018731164920645`, 
      2.944204002605743}, {4.410733522300111, 0.8543857737247285, 
      2.5419443073413737`}}, 0.1], 
     CylinderBox[{{3.688502225544336, 0.33018731164920645`, 
      2.944204002605743}, {3.519995621836008, 0.6908245573681508, 
      3.8382209088443644`}}, 0.1], 
     CylinderBox[{{1.3460696565802874`, 0.2817284459552658, 
      1.9889129198641486`}, {1.9598315371915127`, 0.0436993497445366, 
      2.7241239949923237`}}, 0.1], 
     CylinderBox[{{1.780546358389316, 0.42425149638695014`, 
      3.6679671276707095`}, {1.9598315371915127`, 0.0436993497445366, 
      2.7241239949923237`}}, 0.1], 
     CylinderBox[{{1.780546358389316, 0.42425149638695014`, 
      3.6679671276707095`}, {1.008953923008002, 1.015911693944087, 
      3.8165555288175}}, 0.1], 
     CylinderBox[{{0.5248613151277925, 0.9034502000587514, 
      2.1505599679681175`}, {1.3460696565802874`, 0.2817284459552658, 
      1.9889129198641486`}}, 0.1], 
     CylinderBox[{{0.5248613151277925, 0.9034502000587514, 
      2.1505599679681175`}, {0.30564165356941997`, 1.5990723948260257`, 
      1.499981052372282}}, 0.1], 
     CylinderBox[{{1.6680141747404733`, 1.1234304104060013`, 
      0.5008393428425015}, {1.9028591735835318`, 0.3899421046218916, 
      1.189414329039538}}, 0.1], 
     CylinderBox[{{1.6680141747404733`, 1.1234304104060013`, 
      0.5008393428425015}, {2.3998551762630354`, 1.6406168827871337`, 
      0.09709691453739566}}, 0.1], 
     CylinderBox[{{2.0794184164961953`, 2.5615088041160656`, 0.}, {
      2.3998551762630354`, 1.6406168827871337`, 0.09709691453739566}}, 0.1], 
     CylinderBox[{{2.0794184164961953`, 2.5615088041160656`, 0.}, {
      1.156390548732867, 2.5961692502720024`, 0.34663964542008774`}}, 0.1], 
     CylinderBox[{{0.8960056620265022, 1.7070928663108378`, 
      0.6565231159936362}, {1.6680141747404733`, 1.1234304104060013`, 
      0.5008393428425015}}, 0.1], 
     CylinderBox[{{1.156390548732867, 2.5961692502720024`, 
      0.34663964542008774`}, {0.8960056620265022, 1.7070928663108378`, 
      0.6565231159936362}}, 0.1], 
     CylinderBox[{{0.30564165356941997`, 1.5990723948260257`, 
      1.499981052372282}, {0.8960056620265022, 1.7070928663108378`, 
      0.6565231159936362}}, 0.1], 
     CylinderBox[{{0.30564165356941997`, 1.5990723948260257`, 
      1.499981052372282}, {0., 2.383475126170589, 1.991479586533965}}, 0.1], 
     CylinderBox[{{0.8271794585196637, 3.4306620247960136`, 
      0.8681465326420856}, {1.156390548732867, 2.5961692502720024`, 
      0.34663964542008774`}}, 0.1], 
     CylinderBox[{{0.8271794585196637, 3.4306620247960136`, 
      0.8681465326420856}, {1.444933402620398, 4.1815607347412005`, 
      1.008865987501248}}, 0.1], 
     CylinderBox[{{2.7406029273991255`, 3.3495926313372735`, 
      0.15132718833059178`}, {2.0794184164961953`, 2.5615088041160656`, 0.}}, 
      0.1], CylinderBox[{{2.7406029273991255`, 3.3495926313372735`, 
      0.15132718833059178`}, {3.68664430101476, 3.183471526538956, 
      0.3943000414643798}}, 0.1], 
     CylinderBox[{{3.959381379609775, 3.8604799117966424`, 
      1.0357095253667745`}, {3.68664430101476, 3.183471526538956, 
      0.3943000414643798}}, 0.1], 
     CylinderBox[{{3.959381379609775, 3.8604799117966424`, 
      1.0357095253667745`}, {3.185866710602895, 4.450823648839172, 
      1.1808656958515629`}}, 0.1], 
     CylinderBox[{{2.4263282369986148`, 4.138111581863305, 
      0.6406624913413066}, {2.7406029273991255`, 3.3495926313372735`, 
      0.15132718833059178`}}, 0.1], 
     CylinderBox[{{3.185866710602895, 4.450823648839172, 
      1.1808656958515629`}, {2.4263282369986148`, 4.138111581863305, 
      0.6406624913413066}}, 0.1], 
     CylinderBox[{{1.444933402620398, 4.1815607347412005`, 
      1.008865987501248}, {2.4263282369986148`, 4.138111581863305, 
      0.6406624913413066}}, 0.1], 
     CylinderBox[{{1.444933402620398, 4.1815607347412005`, 
      1.008865987501248}, {1.2721235005047489`, 4.54058103505592, 
      1.9030042607128768`}}, 0.1], 
     CylinderBox[{{3.0033464403364545`, 4.8305381638712195`, 
      2.1231563970605682`}, {3.185866710602895, 4.450823648839172, 
      1.1808656958515629`}}, 0.1], 
     CylinderBox[{{3.0033464403364545`, 4.8305381638712195`, 
      2.1231563970605682`}, {3.616716009027653, 4.593159029957341, 
      2.8586861816587943`}}, 0.1], 
     CylinderBox[{{4.601750225849726, 3.612335047832206, 
      1.8113601080434023`}, {3.959381379609775, 3.8604799117966424`, 
      1.0357095253667745`}}, 0.1], 
     CylinderBox[{{4.601750225849726, 3.612335047832206, 
      1.8113601080434023`}, {4.9285880046412665`, 2.6989779939962126`, 
      1.9102700024496815`}}, 0.1], 
     CylinderBox[{{4.959308632264222, 2.486104551614644, 
      2.8620913310094536`}, {4.9285880046412665`, 2.6989779939962126`, 
      1.9102700024496815`}}, 0.1], 
     CylinderBox[{{4.959308632264222, 2.486104551614644, 
      2.8620913310094536`}, {4.657220284209961, 3.2736443140255975`, 
      3.3504357246873098`}}, 0.1], 
     CylinderBox[{{4.438327296888265, 3.9704224305722833`, 
      2.7014279552146707`}, {4.601750225849726, 3.612335047832206, 
      1.8113601080434023`}}, 0.1], 
     CylinderBox[{{4.657220284209961, 3.2736443140255975`, 
      3.3504357246873098`}, {4.438327296888265, 3.9704224305722833`, 
      2.7014279552146707`}}, 0.1], 
     CylinderBox[{{3.616716009027653, 4.593159029957341, 
      2.8586861816587943`}, {4.438327296888265, 3.9704224305722833`, 
      2.7014279552146707`}}, 0.1], 
     CylinderBox[{{3.616716009027653, 4.593159029957341, 
      2.8586861816587943`}, {3.0584784035535737`, 4.485903167956385, 
      3.6551931251947307`}}, 0.1], 
     CylinderBox[{{4.067909178208931, 3.168117583354923, 4.191274318114679}, {
      4.657220284209961, 3.2736443140255975`, 3.3504357246873098`}}, 0.1], 
     CylinderBox[{{4.067909178208931, 3.168117583354923, 4.191274318114679}, {
      3.8097752962396525`, 2.2791292728959522`, 4.500247705335074}}, 0.1], 
     CylinderBox[{{4.693222920497938, 1.54134187981996, 
      3.1860547064468565`}, {4.959308632264222, 2.486104551614644, 
      2.8620913310094536`}}, 0.1], 
     CylinderBox[{{4.693222920497938, 1.54134187981996, 
      3.1860547064468565`}, {4.410733522300111, 0.8543857737247285, 
      2.5419443073413737`}}, 0.1], 
     CylinderBox[{{4.135501050033915, 1.4411803534626932`, 
      3.980989935862838}, {4.693222920497938, 1.54134187981996, 
      3.1860547064468565`}}, 0.1], 
     CylinderBox[{{3.519995621836008, 0.6908245573681508, 
      3.8382209088443644`}, {4.135501050033915, 1.4411803534626932`, 
      3.980989935862838}}, 0.1], 
     CylinderBox[{{3.8097752962396525`, 2.2791292728959522`, 
      4.500247705335074}, {4.135501050033915, 1.4411803534626932`, 
      3.980989935862838}}, 0.1], 
     CylinderBox[{{3.8097752962396525`, 2.2791292728959522`, 
      4.500247705335074}, {2.8892235683883074`, 2.318027942663011, 
      4.844725655439624}}, 0.1], 
     CylinderBox[{{2.541943767761933, 0.7383051350389527, 
      4.206233552592459}, {3.519995621836008, 0.6908245573681508, 
      3.8382209088443644`}}, 0.1], 
     CylinderBox[{{2.541943767761933, 0.7383051350389527, 
      4.206233552592459}, {1.780546358389316, 0.42425149638695014`, 
      3.6679671276707095`}}, 0.1], 
     CylinderBox[{{0.5481451150537624, 4.015396213479794, 
      2.306390792279977}, {1.2721235005047489`, 4.54058103505592, 
      1.9030042607128768`}}, 0.1], 
     CylinderBox[{{0.5481451150537624, 4.015396213479794, 
      2.306390792279977}, {0.26586923663857753`, 3.3276813709572957`, 
      1.6640512304566444`}}, 0.1], 
     CylinderBox[{{2.076008209216276, 4.872786817647196, 2.468404500939503}, {
      1.2721235005047489`, 4.54058103505592, 1.9030042607128768`}}, 0.1], 
     CylinderBox[{{2.076008209216276, 4.872786817647196, 2.468404500939503}, {
      3.0033464403364545`, 4.8305381638712195`, 2.1231563970605682`}}, 0.1], 
     CylinderBox[{{0.26586923663857753`, 3.3276813709572957`, 
      1.6640512304566444`}, {0.8271794585196637, 3.4306620247960136`, 
      0.8681465326420856}}, 0.1], 
     CylinderBox[{{0., 2.383475126170589, 1.991479586533965}, {
      0.26586923663857753`, 3.3276813709572957`, 1.6640512304566444`}}, 0.1], 
     CylinderBox[{{0.581985323962513, 3.791913594977766, 
      3.3115818632194753`}, {0.5481451150537624, 4.015396213479794, 
      2.306390792279977}}, 0.1], 
     CylinderBox[{{0.03182139272153295, 2.1719258918278763`, 
      2.944208633564714}, {0., 2.383475126170589, 1.991479586533965}}, 0.1], 
     CylinderBox[{{0.03182139272153295, 2.1719258918278763`, 
      2.944208633564714}, {0.36248267768338094`, 1.2613167223300004`, 
      3.043309302948768}}, 0.1], 
     CylinderBox[{{0.36248267768338094`, 1.2613167223300004`, 
      3.043309302948768}, {0.5248613151277925, 0.9034502000587514, 
      2.1505599679681175`}}, 0.1], 
     CylinderBox[{{1.008953923008002, 1.015911693944087, 3.8165555288175}, {
      0.36248267768338094`, 1.2613167223300004`, 3.043309302948768}}, 0.1], 
     CylinderBox[{{0.3275859312286631, 2.891174130261359, 
      3.620579593049852}, {0.03182139272153295, 2.1719258918278763`, 
      2.944208633564714}}, 0.1], 
     CylinderBox[{{0.3275859312286631, 2.891174130261359, 
      3.620579593049852}, {0.581985323962513, 3.791913594977766, 
      3.3115818632194753`}}, 0.1], 
     CylinderBox[{{1.2846133182213855`, 1.6966759504021955`, 
      4.455250038985797}, {1.008953923008002, 1.015911693944087, 
      3.8165555288175}}, 0.1], 
     CylinderBox[{{1.2846133182213855`, 1.6966759504021955`, 
      4.455250038985797}, {2.231032469188314, 1.5298385574810456`, 
      4.694096194584354}}, 0.1], 
     CylinderBox[{{2.231032469188314, 1.5298385574810456`, 
      4.694096194584354}, {2.541943767761933, 0.7383051350389527, 
      4.206233552592459}}, 0.1], 
     CylinderBox[{{2.8892235683883074`, 2.318027942663011, 
      4.844725655439624}, {2.231032469188314, 1.5298385574810456`, 
      4.694096194584354}}, 0.1], 
     CylinderBox[{{0.9337026676822708, 2.6640556205231998`, 
      4.351656577086752}, {1.2846133182213855`, 1.6966759504021955`, 
      4.455250038985797}}, 0.1], 
     CylinderBox[{{0.9337026676822708, 2.6640556205231998`, 
      4.351656577086752}, {0.3275859312286631, 2.891174130261359, 
      3.620579593049852}}, 0.1], 
     CylinderBox[{{2.5649048229505382`, 3.237761864369345, 
      4.7472048050668985`}, {2.8892235683883074`, 2.318027942663011, 
      4.844725655439624}}, 0.1], 
     CylinderBox[{{2.5649048229505382`, 3.237761864369345, 
      4.7472048050668985`}, {3.295692630044463, 3.753657339833035, 
      4.343777551291854}}, 0.1], 
     CylinderBox[{{3.295692630044463, 3.753657339833035, 4.343777551291854}, {
      4.067909178208931, 3.168117583354923, 4.191274318114679}}, 0.1], 
     CylinderBox[{{3.0584784035535737`, 4.485903167956385, 
      3.6551931251947307`}, {3.295692630044463, 3.753657339833035, 
      4.343777551291854}}, 0.1], 
     CylinderBox[{{1.5599904724883296`, 3.414866324784323, 
      4.494070266295018}, {2.5649048229505382`, 3.237761864369345, 
      4.7472048050668985`}}, 0.1], 
     CylinderBox[{{1.5599904724883296`, 3.414866324784323, 
      4.494070266295018}, {0.9337026676822708, 2.6640556205231998`, 
      4.351656577086752}}, 0.1], 
     CylinderBox[{{2.1139793406804293`, 4.658525801439229, 
      3.416721729409986}, {3.0584784035535737`, 4.485903167956385, 
      3.6551931251947307`}}, 0.1], 
     CylinderBox[{{2.1139793406804293`, 4.658525801439229, 
      3.416721729409986}, {2.076008209216276, 4.872786817647196, 
      2.468404500939503}}, 0.1], 
     CylinderBox[{{1.3427683189210762`, 4.114637877127366, 
      3.845443127701759}, {2.1139793406804293`, 4.658525801439229, 
      3.416721729409986}}, 0.1], 
     CylinderBox[{{1.3427683189210762`, 4.114637877127366, 
      3.845443127701759}, {0.581985323962513, 3.791913594977766, 
      3.3115818632194753`}}, 0.1], 
     CylinderBox[{{1.3427683189210762`, 4.114637877127366, 
      3.845443127701759}, {1.5599904724883296`, 3.414866324784323, 
      4.494070266295018}}, 0.1]}, {
     SphereBox[{3.4034867403936513`, 1.4619004888421065`, 
      0.35185221628081154`}, 0.25], 
     SphereBox[{3.6164810096371696`, 0.7592905178567695, 0.9992876799464905}, 
      0.25], SphereBox[{4.377483610272962, 1.078633671218928, 
      1.5367524631844947`}, 0.25], 
     SphereBox[{2.8457904130454126`, 0.21537542821665978`, 1.427846942437405},
       0.25], SphereBox[{4.031062680042262, 2.211795677886746, 
      0.49810933103024846`}, 0.25], 
     SphereBox[{2.3998551762630354`, 1.6406168827871337`, 
      0.09709691453739566}, 0.25], 
     SphereBox[{4.632479871671187, 1.9800271984387146`, 1.2316762958624239`}, 
      0.25], SphereBox[{3.68664430101476, 3.183471526538956, 
      0.3943000414643798}, 0.25], 
     SphereBox[{4.9285880046412665`, 2.6989779939962126`, 
      1.9102700024496815`}, 0.25], 
     SphereBox[{4.410733522300111, 0.8543857737247285, 2.5419443073413737`}, 
      0.25], SphereBox[{2.884959587382348, 0., 2.3770382477292165`}, 0.25], 
     SphereBox[{1.9028591735835318`, 0.3899421046218916, 1.189414329039538}, 
      0.25], SphereBox[{1.9598315371915127`, 0.0436993497445366, 
      2.7241239949923237`}, 0.25], 
     SphereBox[{3.688502225544336, 0.33018731164920645`, 2.944204002605743}, 
      0.25], SphereBox[{1.3460696565802874`, 0.2817284459552658, 
      1.9889129198641486`}, 0.25], 
     SphereBox[{1.780546358389316, 0.42425149638695014`, 3.6679671276707095`},
       0.25], SphereBox[{0.5248613151277925, 0.9034502000587514, 
      2.1505599679681175`}, 0.25], 
     SphereBox[{1.6680141747404733`, 1.1234304104060013`, 0.5008393428425015},
       0.25], SphereBox[{2.0794184164961953`, 2.5615088041160656`, 0.}, 0.25],
      SphereBox[{0.8960056620265022, 1.7070928663108378`, 0.6565231159936362},
       0.25], SphereBox[{1.156390548732867, 2.5961692502720024`, 
      0.34663964542008774`}, 0.25], 
     SphereBox[{0.30564165356941997`, 1.5990723948260257`, 1.499981052372282},
       0.25], SphereBox[{0.8271794585196637, 3.4306620247960136`, 
      0.8681465326420856}, 0.25], 
     SphereBox[{2.7406029273991255`, 3.3495926313372735`, 
      0.15132718833059178`}, 0.25], 
     SphereBox[{3.959381379609775, 3.8604799117966424`, 1.0357095253667745`}, 
      0.25], SphereBox[{2.4263282369986148`, 4.138111581863305, 
      0.6406624913413066}, 0.25], 
     SphereBox[{3.185866710602895, 4.450823648839172, 1.1808656958515629`}, 
      0.25], 
     SphereBox[{1.444933402620398, 4.1815607347412005`, 1.008865987501248}, 
      0.25], SphereBox[{3.0033464403364545`, 4.8305381638712195`, 
      2.1231563970605682`}, 0.25], 
     SphereBox[{4.601750225849726, 3.612335047832206, 1.8113601080434023`}, 
      0.25], SphereBox[{4.959308632264222, 2.486104551614644, 
      2.8620913310094536`}, 0.25], 
     SphereBox[{4.438327296888265, 3.9704224305722833`, 2.7014279552146707`}, 
      0.25], SphereBox[{4.657220284209961, 3.2736443140255975`, 
      3.3504357246873098`}, 0.25], 
     SphereBox[{3.616716009027653, 4.593159029957341, 2.8586861816587943`}, 
      0.25], SphereBox[{4.067909178208931, 3.168117583354923, 
      4.191274318114679}, 0.25], 
     SphereBox[{4.693222920497938, 1.54134187981996, 3.1860547064468565`}, 
      0.25], SphereBox[{4.135501050033915, 1.4411803534626932`, 
      3.980989935862838}, 0.25], 
     SphereBox[{3.519995621836008, 0.6908245573681508, 3.8382209088443644`}, 
      0.25], SphereBox[{3.8097752962396525`, 2.2791292728959522`, 
      4.500247705335074}, 0.25], 
     SphereBox[{2.541943767761933, 0.7383051350389527, 4.206233552592459}, 
      0.25], SphereBox[{1.2721235005047489`, 4.54058103505592, 
      1.9030042607128768`}, 0.25], 
     SphereBox[{0.5481451150537624, 4.015396213479794, 2.306390792279977}, 
      0.25], SphereBox[{2.076008209216276, 4.872786817647196, 
      2.468404500939503}, 0.25], 
     SphereBox[{0.26586923663857753`, 3.3276813709572957`, 
      1.6640512304566444`}, 0.25], 
     SphereBox[{0., 2.383475126170589, 1.991479586533965}, 0.25], 
     SphereBox[{0.581985323962513, 3.791913594977766, 3.3115818632194753`}, 
      0.25], SphereBox[{0.03182139272153295, 2.1719258918278763`, 
      2.944208633564714}, 0.25], 
     SphereBox[{0.36248267768338094`, 1.2613167223300004`, 3.043309302948768},
       0.25], SphereBox[{1.008953923008002, 1.015911693944087, 
      3.8165555288175}, 0.25], 
     SphereBox[{0.3275859312286631, 2.891174130261359, 3.620579593049852}, 
      0.25], SphereBox[{1.2846133182213855`, 1.6966759504021955`, 
      4.455250038985797}, 0.25], 
     SphereBox[{2.231032469188314, 1.5298385574810456`, 4.694096194584354}, 
      0.25], SphereBox[{2.8892235683883074`, 2.318027942663011, 
      4.844725655439624}, 0.25], 
     SphereBox[{0.9337026676822708, 2.6640556205231998`, 4.351656577086752}, 
      0.25], SphereBox[{2.5649048229505382`, 3.237761864369345, 
      4.7472048050668985`}, 0.25], 
     SphereBox[{3.295692630044463, 3.753657339833035, 4.343777551291854}, 
      0.25], SphereBox[{3.0584784035535737`, 4.485903167956385, 
      3.6551931251947307`}, 0.25], 
     SphereBox[{1.5599904724883296`, 3.414866324784323, 4.494070266295018}, 
      0.25], SphereBox[{2.1139793406804293`, 4.658525801439229, 
      3.416721729409986}, 0.25], 
     SphereBox[{1.3427683189210762`, 4.114637877127366, 3.845443127701759}, 
      0.25]}},
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9k4k3FAgcx8ecDMbMUIQcFaFIZW1Z9fvJuV7Pqk2sJNREEUXhYYRVG2Kx
osMxrEjZHDtrozYmVqwjRkRKk7Ny32dm7Xu9/b73+QO+7/v5anr4HeYQCQSC
6RqkNWR6k80cTaRRyuGHmsmT83BNFKZTGd0BuBh0M35MBqP9G3gqBz/Ait06
Hb2lcZhMM2fGRbFQuHrSfd2BSTBoNK6KSV0Afc/b1fo1VJwot6L7JDXACY6i
VGDnHJzJ3jbQrM5E74KiMUGJBH7oyZulvH8HUtxvLYd2kVDJXZY7D0tAoId+
cOx+BAvC4qZ7P7HxvmBIbPhQDKON6kZT/GkQPqW6Qrgs6nZfGK4MkkIsKN9n
bNoF15M21r4rk0fJ361qI9Mo2NxqaB2UuAqBt9YfSctlYbBibLuG4zA0W+UM
DDqQcfIPwxKOAg0JXxLOX+JtJ5Nw++zcJVX/VahrelDxYqYT6gbqD72iTUNf
lKt98DExRDwhv3l2Ig9cRjlXJBooaMz1uygbJYu8W5Zz9ZrtsD9e3FYRT8Nk
T/bRiJhZmKjxreygCUFwLdU5VSgGM36uvhp3Bc7zEyvHtbshz9BMW+woi3Mb
RmcKGkQg3PL6FPPjCOxReFnnZCSB5zjp2TuKl0DsFaGXvDgJhSKBiYgqglUv
H/W8HAIWCSa+X+CS/+/B/zDKVCgcgexfCelovwxRjpI1psQBGHIzd/slYgpi
Tll5zNSQ0b53i6zTjg54xLxJzPm5DWzOhY433liE9RN1miPiefAJsWGYBX+C
HdTIsdUL0hhSWGHa/XwYLIgWJoIRCmpo8vfMN9DRkHU+sNi1Gl5eYWi1FMrh
bayyNe9loGJpubZF8gQIdJ2fq50h4bzRcfVz8UzMLSPy7CL64X3OnaL8MCk8
qDpRltvEwotnYs+19U+B4gVhmL/aPJCb8xnD5Uz0aecU2G+ZgHKfzMuvqZIY
yyu6GXxYHp86NXnvXSGgbyzLeKcXGy3ZA5/kBmWQ8NWNJ0eWVyDDPYbg0CGP
aothdbF9JDRvrt2cOEDFdYdmejqrWPh58GW7T7UcntKPPHA1nYKnGx84r/LY
ePGFiq+PIR0DGM/3lzTRUeV6fJPkuAz+ufhAgXOCjc4k1zepPVR8TGlejrFk
YtkmeUk7JylkBu8++7aaiTaRJSZv/mYjL8pF+WjBAmzNWwY6VwrTRDH1VbFM
/KjjoikvNw8efe7I6pJD73/GAqd1ZLDYT0vZVGUQqkOmdH/jM5B6PyDYO4SB
CgltGve+ISIf944jgY2vg4wz/vO3R2CguIs3BF19vn0GbUy0Mpvaluk8Aw/T
deUTdNl4ICn8Jn/NY6PnbVmese+B8iOHWiPHxGJlCpkbQMQWrvbO+3cI2FLa
2faYK491hYPdtpUkFBGVPAnkVqDoqp1RzKJjvui1wUzW2i+/JKBb3+sYi4R6
9NHSDW/FEB58tygrqxdSLnMbOhwYyPGryVYLpyPylZ/12/KA3X/jobKbBG5S
TDD7a+0XwczIuE+7XsHx3ugLzgYz4Lxn//VSJ0nU7vTsKVzb2VDYmrndbAKW
VN+a211jIM/Pfllv/iXsVSUPqWvSMKyM4jc1J4OGlm9KauNn4NlO34c3tJbB
v36aqS9kYYtQJX5rlwQm5Netfh2yADZsja2CWjbahkqC5kYaWmcMfXM4jojW
Qo1qsZs8si2enO0XjYL6Ut6ple8oqCftVaDkxULR6XetI9FkdMncVzI+KIWZ
/FyzzZ/Z6Ff4WSnlOB2N6l9d5tIYSE4b30NzW/PXOvBqdZAkzqVk3EqcZCHV
6H5/+z5Z3BjXkfRodgECbWL87h6SRlq+XcLoIgtXN2kRfD8SsIYUkHokh43Z
9RW7/R2k0Xb8c/ZS6Cx4pPCzT15ionZ3VVFQNQP/BXJ+i9Q=
     "]]& ],
  AspectRatio->Automatic,
  ImageSize->{251., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{255, 270},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->1352651317,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
This plots a graph with edges displayed as springs and vertices as spheres.\
\>", "MathCaption",
 CellID->242067083],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Spring", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x0_", ",", "y0_"}], "}"}], ",", 
     RowBox[{"n_:", "10"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"x0", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y0", "-", "x0"}], ")"}], "*", "0.05"}]}]}], ",", 
       RowBox[{"y", "=", 
        RowBox[{"y0", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x0", "-", "y0"}], ")"}], "*", "0.1"}]}]}], ",", "theta", 
       ",", "t"}], "}"}], ",", 
     RowBox[{
      RowBox[{"theta", "=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"y0", "-", "x0"}], ")"}], "[", 
           RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0."}], ",", 
         RowBox[{"Pi", "/", "2."}], ",", 
         RowBox[{"ArcTan", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"y0", "-", "x0"}], ")"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"y0", "-", "x0"}], ")"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ")"}]}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Line", "[", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"{", "x0", "}"}], ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"x", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"y", "-", "x"}], ")"}], "*", "t"}], "+", 
            RowBox[{"0.05", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Cos", "[", " ", 
                RowBox[{
                 RowBox[{"2", " ", "Pi", " ", "n", " ", "t"}], "+", "theta"}],
                 "]"}], ",", 
               RowBox[{"Sin", "[", 
                RowBox[{
                 RowBox[{"2", "  ", "Pi", " ", "n", " ", "t"}], "+", 
                 "theta"}], "]"}], ",", "0"}], "}"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", "0", ",", "1", ",", ".005"}], "}"}]}], "]"}], 
         ",", 
         RowBox[{"{", "y0", "}"}]}], "]"}], "]"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Spring", "[", "#1", "]"}]}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sphere", "[", 
       RowBox[{"#1", ",", "0.1"}], "]"}], "&"}], ")"}]}]}], "]"}]}], "Input",
 CellLabel->"In[15]:=",
 CellID->983004564],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{215, 249},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->640007851]
}, Open  ]],

Cell["This plots the benzene molecule.", "MathCaption",
 CellID->831977605],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"normal", "[", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "y_"}], "}"}], "]"}], ":=", 
   RowBox[{"0.03", "*", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "y"}], ",", "x"}], "}"}], "/", 
     RowBox[{"Norm", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "8"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}], ",", 
     RowBox[{"4", "\[Rule]", "10"}], ",", 
     RowBox[{"5", "\[Rule]", "11"}], ",", 
     RowBox[{"6", "\[Rule]", "12"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"#2", "\[LessEqual]", "6"}], ",", "\"\<C\>\"", ",", 
            "\"\<H\>\""}], "]"}], ",", "Bold"}], "]"}], ",", "#1", ",", 
        RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], "&"}], ")"}]}], 
   ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Length", "[", "#1", "]"}], ">", "2"}], ",", 
        RowBox[{
         RowBox[{"norm", "=", 
          RowBox[{"normal", "[", 
           RowBox[{
            RowBox[{"First", "[", "#1", "]"}], "-", 
            RowBox[{"Last", "[", "#1", "]"}]}], "]"}]}], ";", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"First", "[", "#1", "]"}], "+", "norm"}], ",", 
              RowBox[{
               RowBox[{"Last", "[", "#1", "]"}], "+", "norm"}]}], "}"}], 
            "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"First", "[", "#1", "]"}], "-", "norm"}], ",", 
              RowBox[{
               RowBox[{"Last", "[", "#1", "]"}], "-", "norm"}]}], "}"}], 
            "]"}]}], "}"}]}], ",", 
        RowBox[{"Line", "[", "#1", "]"}]}], "]"}], "&"}], ")"}]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[17]:=",
 CellID->19458235],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWD1MI1cQ3sO7lpDIhUiIM4oOWRFKHIcD29wFc4nBlyiBJhIldDhWEp90
VsjdFXQpKCgpKShoToKOClFSUFAiKkqgoqSk3Hxv5u3O7NuFwzlLXr8375uf
NzNvdp5/a73v/NFtvX/dbhXn37ZWO6/b74q//v0WpNwjz/M+4LtZ8DAOMaLv
hzDE76c/x/HMQWCf/Z1x5pOEeoZnn6Wa3x+ceaVHVN6u5v8H78dRD9vTc/PM
3dzchPTxuoq6urqaQa1UKqenpy716Oio2Wya4fcR7+bmphnSuveCqIuLi/v7
+zE1B0EQZ4YvFOr6+rpYLN7e3lqUcDGKNWxsbKytrZlhjeaAABhbYFGQUiqV
Li4uvGo0r9fr0OtNE2ra4SVjcjCdN29RdaIuLCwcHh6a4URkJ6zHk9ctCrKh
wVg/4XiCUTMOddzhmlEozOEJo2Hc8QSjXhJ1Z2dnZWXFDMs0h5Ew1QxpnfJD
x+1bZ65REpGS4wla934kaqfT2draMsNvaA4Xw0hB/Rnx2vxhaktlIO0tsdqw
q0WVzZ4hWFQj1u+uDg4Oej4eBUy9HMHo81OCw8dvAJN0tg/btTTy6b2yvrK/
GjGXQOiVaEckmE2GtxrxrjXePMeiWCf8wz7FIcNRc6mSPUz9y8mxlypbJGs5
W+ANDl8CJbzf0RzhRtAl82Ycvc+cnNK5LlnLqJOTE3AJqu5kLVWmHFIaie2e
QdEwGe3G1gp9niVrq85c1wbZeS3KSIg/Pz9PoMQTU2GyVuiaBS7wGjsyK12K
ynPUJVgQV7pULeXdoMyh2MUWpOrwdGS9rRWMmsqKW253d3dpackMac+yc8vL
VQDhQZBi/1mUeMKtFYyqOhFpOFwVhRJPNJysZFTFyZR/FC9v2wwppN67kCtH
IUy+4R7T6oBDjVA/h9l1ZjhMvk0/JymfOdTCHdzNUGrIFwgkVed/6eP1mYeq
C/drIKTlfEycOBFN+lAZ0JJ+0VppDdg7tPoJjflMTbD5iD6UjFmavuzJS350
3qyXZsN0lSz0JNELYk4MkE3eqzBdSYcfnBFapnFLPn92dpbIuuXl5XK5LFlX
jfbU39+/t7dn34zckrhnYm5ubnt7e2BggE9OAC5MwAWJkKtz3qxB+/Hx8djY
WLvd5nrsY4fVahUc0KYkB9A3MjICW33fBydXyQBz4PAcGhpaX1/Xp9hnEssj
tI8BpixJVYUA2mDl1dUVZB0cHHA9TFGZYyolidA+BpiyNlWXgsvLS/YxA7im
yW6wBoSudwF8AY/AL1gzO60lPcmqdbX1OTAoIPPz87WUF1X1DpgCWfCiiXsl
aaP1ouo+fQ5Ot9sdHR2tZO/d+iuODToU035QVxjAc9Do+JYrecLKiZQX1Xsu
tXvqEgPYCovFi+r9KWucH/x2t55iIerNndBbTtmmOoEgjos9DaVMD6qu1ee4
8LEopTyoepEgjgt8DY97Xyc9yB7QXWzqVHCXyrabIWO5S2JHCPX3UHep0oXx
6mx4d5dqNFEViLs69+3w1NJfJVCmOvpUtfHitNVw2KmOGRxUmdFBWNlPMmVn
daqzCURmp6pqaCPed3afKhZor7p+Y6rcoPSdg68OZsg3E+kqNUr6Qe5bpa/Q
dyHpSbhvlR5Po6S/4XuVdEm6b5VOj29yTsdlO1LpnSYdCzRKOtCKsxt18lXv
5PZSGiW3r5ojW9+PxY6pyE7b3WqU3CeeO3vWfatzt1bdm+5I5a7NdkpPrFFi
bd2JY01plF7hDVH5fxpzf7jvPw2KEz3v+39kskeU/p+mV96Pox62p0//j8t7
9B/vLpkq\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{164, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->436667384]
}, Open  ]],

Cell["Draw text along edges.", "MathCaption",
 CellID->1802332408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrow", "[", "#", "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{"\"\<Mathematica\>\"", ",", 
          RowBox[{"Mean", "[", "#1", "]"}], ",", "Automatic", ",", 
          "Automatic", ",", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", 
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->933490243],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       ArrowBox[{{1.4875669188038463`, 1.7455699225238166`}, {
        1.9996460459354313`, 0.8861424682559871}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {1.7436064823696387`, 1.3158561953899017`}, 
        Automatic, Automatic, {-0.512079127131585, 0.8594274542678295},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.9996460459354313`, 0.8861424682559871}, {
        1.511583448071915, 0.013316663859109679`}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {1.7556147470036731`, 0.4497295660575484}, Automatic,
         Automatic, {0.48806259786351625`, 0.8728258043968774},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{1.511583448071915, 0.013316663859109679`}, {
        0.5114456436282868, 0.}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {1.011514545850101, 0.006658331929554839}, Automatic,
         Automatic, {1.0001378044436282`, 0.013316663859109679`},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0.5114456436282868, 0.}, {0., 0.8594781450938977}}], 
       InsetBox[
        TagBox["Mathematica",
         "InsetString"], {0.2557228218141434, 0.4297390725469489}, Automatic, 
        Automatic, {0.5114456436282868, -0.8594781450938977},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0., 0.8594781450938977}, {0.48875342845363157`, 
        1.7322387782110364`}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {0.24437671422681578`, 1.295858461652467}, Automatic,
         Automatic, {-0.48875342845363157`, -0.8727606331171387},
        Background->GrayLevel[1]]}, {
       ArrowBox[{{0.48875342845363157`, 1.7322387782110364`}, {
        1.4875669188038463`, 1.7455699225238166`}}], InsetBox[
        TagBox["Mathematica",
         "InsetString"], {0.9881601736287389, 1.7389043503674264`}, Automatic,
         Automatic, {-0.9988134903502147, -0.013331144312780152`},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{1.4875669188038463`, 1.7455699225238166`}, {
      1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
      0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
      0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "6"],
        Annotation[#, 6, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{250., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{254, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->504615442]
}, Open  ]],

Cell["Draw graphics on each edge.", "MathCaption",
 CellID->862702349],

Cell[BoxData[
 RowBox[{
  RowBox[{"arrow", "=", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

     "], {{0, 0}, {47, 47}},
     ColorFunction->(Apply[RGBColor, 
       Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
        "], #]]& ),
     ColorFunctionScaling->False],
    Background->None,
    ImageSize->{47, 47},
    PlotRange->{{0, 47}, {0, 47}}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1666566159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Line", "[", "#", "]"}], ",", 
        RowBox[{"Inset", "[", 
         RowBox[{"arrow", ",", 
          RowBox[{"Mean", "[", "#1", "]"}], ",", "Automatic", ",", 
          "Automatic", ",", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "-", 
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}], "&"}],
      ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1802305556],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{{
       LineBox[{{2.1493322121100826`, 0.00024224688259011362`}, {
        1.9450835562462694`, 0.8705665189068674}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {2.0472078841781762`, 0.43540438289472877`},
         Automatic, Automatic, {0.20424865586381324`, -0.8703242720242773},
        Background->GrayLevel[1]]}, {
       LineBox[{{2.1493322121100826`, 0.00024224688259011362`}, {
        1.074095746585374, 0.4054020904812563}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {1.6117139793477282`, 0.2028221686819232},
         Automatic, Automatic, {1.0752364655247086`, -0.4051598435986662},
        Background->GrayLevel[1]]}, {
       LineBox[{{1.9450835562462694`, 0.8705665189068674}, {1.074095746585374,
         0.4054020904812563}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {1.5095896514158218`, 0.6379843046940619},
         Automatic, Automatic, {0.8709878096608954, 0.4651644284256111},
        Background->GrayLevel[1]]}, {
       LineBox[{{0., 0.}, {0.20349925371016586`, 0.8704676975181331}}], 
       InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {0.10174962685508293`, 0.43523384875906657`},
         Automatic, Automatic, {-0.20349925371016586`, -0.8704676975181331},
        Background->GrayLevel[1]]}, {
       LineBox[{{0., 0.}, {1.074095746585374, 0.4054020904812563}}], 
       InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {0.537047873292687, 0.20270104524062815`},
         Automatic, Automatic, {-1.074095746585374, -0.4054020904812563},
        Background->GrayLevel[1]]}, {
       LineBox[{{0.20349925371016586`, 0.8704676975181331}, {
        1.074095746585374, 0.4054020904812563}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {0.6387975001477699, 0.6379348939996947},
         Automatic, Automatic, {-0.8705964928752081, 0.4650656070368768},
        Background->GrayLevel[1]]}, {
       LineBox[{{1.0743632004180812`, 1.3355245671965388`}, {
        0.20349925371016586`, 0.8704676975181331}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {0.6389312270641235, 1.1029961323573358`},
         Automatic, Automatic, {0.8708639467079153, 0.46505686967840565`},
        Background->GrayLevel[1]]}, {
       LineBox[{{1.0743632004180812`, 1.3355245671965388`}, {
        1.9450835562462694`, 0.8705665189068674}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {1.5097233783321753`, 1.103045543051703},
         Automatic, Automatic, {-0.8707203558281882, 0.46495804828967136`},
        Background->GrayLevel[1]]}, {
       LineBox[{{1.0743632004180812`, 1.3355245671965388`}, {
        1.074095746585374, 0.4054020904812563}}], InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztlf9TmmAYwAujlhppV1vbslmUUIvSGpa6NStGX3DlygpBQp11MteUheYq
zv70vXyzldxiP+yX3T533D13fN6H53nhfZgoVveLUFdX14J5pf9RUBT9ExmC
IMcrgI2wLEJCznyUZOOqGscRRz4KsaIEwxIdZ6H7BaF2aPZKuFjaplWcvPP1
hshaDdGpaegRLtLblXB4OlSSVLzW9qEaglNUPB4XAXEDLRyWvKGd8Gbl+FT3
rQZYShymJQAMkAy00FsKJZu5xubOcbK0TlNWw2K/BO7c0Y6TG4HmHtGING9n
S962379QSn4GbDwgEDg6uuzx+y8iU7fvQ15aZHX/LHD8enf3WycrlUpYkK+I
nsjU9ydJ0IC+oWdPt7a23toQ3rx5TsjR8fmeyJeJ6dPSuoqD/GfXl725m1cd
NBrzflln/iKn+WUY5E/PXJ9MznH+cRuiUTkDkAks1zsxPVKGRcTU5ejVfaKA
cTlDAPx+QpgD/myZptIzL06WnmGE+eB7gMwuAMif4fZ6m8sjsGjoSoqww2UC
1mn5l9+plu56BOHNpI9ftrIPDv7OTXFYorrk4+tm7Qo3mLLDkFOCclDNM1l3
H2voCYGzw8whKAXNPuxjSfCaYkueAkj/EAGg+RywPXlm8bzMkmi6/0c22Kpy
o/sPGBgYzWAYeASWKHiCvsU17ZvUdSaYb3k6qBYSioIJQmIM2O5u1TghVDmb
jfk6YRgmqBWpjLWCMXeRNc8rQq2t2vKhXv9YTXzV7PoQYk0D7WBbQBYgRii6
zLcOXK1gdvVT27afGtrgQFSYz4O6s4dq7fHJhJIUvci0GP5ccmCDKYarfCzG
d+NObKAjOM/zL38ZSY/5q+4hhHQ4sbVpSEKQ4z+CsUMO5f/8XX4C3itGoQ==

          "], {{0, 0}, {47, 47}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx1l/dqVFEQxoP4APZe8BVUVCzMM9gbKgj+rWIXRR/B3tsj2EtiA0EQSUg2
u5st2WzfZJNs7CXRRJ0595uDc8gPwmF3cu+ZM+ebsot27123Z0JTU9Ppf38T
//1dOM+8ocuXmLd08QITpybhI42NMo1ghb0zxpToymWmV7/Heuc2k6cDQple
vmD885uFXn1++CfTp/bZQpryPQI9e8p4+0GhQok4U6Enj5ma2mcKXbRNyNBi
oaT2q1eYvmifOv0aYfrVHusQaIMQ13PA3pUUaKGQp+ctzIDa4Q/Oaf3vyTGN
IG5Yc93MoK6jv5lB418xur9a8Hy8U6Dr15gMpboYf0+Im/UL606hR8+H+4b9
7BmmPfo+RvuEgtqvXWXqwQr7OqGkcUWcYF8ilHW1z0Mfzo8CzRN8fEaGmTrd
vsUMBeebIpQ0Dq9fMR/UjnN/+sgUAp3PFd7TAqGNtggptW8V0jRZKAb54/Kt
QoeFGrU0M15/jx8xVWp+xtQD/8+dZYrqvz2n+z5ON28w3UH8NgqJKA9Skc4r
Qf649/ZoPGH/M8YMBSvsTpdJ1R/O87//HVp3rH6mC1VaJtQonWK8TvH/jx4y
lSA+3VlmQFerD/jj8rhGv38xPn8nCQVaKxSjeFWD8+GeHz5gfH1w+3XT/XtM
Mdjf1d9ykJdYpwrl6B5C+3Khl54+YXpppeD1g/xFftj73y5k1Z5JM3Wzf6fW
uUsXGX/+GUKSbt1kcsHz0B3y3OWJ18cOoUEnhUb0Hp8f378xVTou9AfnP3+O
ianOUQ9hR92HH85fXydR11FHbJydbvs1L12+Dxj/c7ReKAf+YV/o1NZZ6GO+
kKPPnxjvv8u7tqhOxaijnfH5sUvIa305JPj7QV4kE0xV+xzsTg/vzJoO9AV9
HhP886hfm4RaUB8Qt2yG6acb1xmbX+2RPmK0X/DnR39G3lt9FfKC1vFVgn//
HCGj+sR5YEffxL1jP9hnCSnNE8QRdujOnS8TPA/d//jOhP3ZvS+h+jsieP/Q
T7A/4g07dIPzrxYGg33GW6E3+Ik+AvuL58z474N+XR6WonnP9083f5TpqBDO
F87/1kjX7XqfVl+4N+vPNCGuddjqB/UcdfeE4J93edsZ6bsrqA/or/be7f6o
j7a/IT7oH1af9+4yhSBvsbq8Smpe2jkP9d7VOZ9nsLt6nVD9o57Bjr6M/vTq
JTMU6BNzAPoJ7EsFX19sfuJ7+G37N/SBPm/rI/oy5i47X9vfJXb+QL/Cva4Q
/PtR11ye9QX9EefGPdr4u36Q1bjYPMd9nBI+BPeLuuvupzWaU7LBfIv9bX6i
PqC/2PxYIzR0RZ+FHe9z80s4X2IuQ345vfv9se/XL0w5ioOPP+ZGOxdhxe8H
zBn29xk+Iz9cv/NxdHry9XG833/IH5tnqBfYx94vPtu5HCv6L/IbcxjsyG/M
cfgdBzvyBX3T7mPjb8+H76E/O5/Y+mjj+xfoHbtL
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{47, 47},
         PlotRange->{{0, 47}, {0, 47}}], {1.0742294735017275`, 0.8704633288388975},
         Automatic, Automatic, {0.00026745383270720957`, 0.9301224767152825},
        Background->GrayLevel[1]]}}, 
     GraphicsComplexBox[{{2.1493322121100826`, 0.00024224688259011362`}, {
      1.9450835562462694`, 0.8705665189068674}, {1.074095746585374, 
      0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
      0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "3"],
        Annotation[#, 3, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{2.1493322121100826`, 
     0.00024224688259011362`}, {1.9450835562462694`, 0.8705665189068674}, {
     1.074095746585374, 0.4054020904812563}, {0., 0.}, {0.20349925371016586`, 
     0.8704676975181331}, {1.0743632004180812`, 1.3355245671965388`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{316., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{320, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1309962454]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method", "Subsection",
 CellTags->"b:0.1",
 CellID->204623697],

Cell[TextData[{
 "Algorithms to be used in ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " can be specified using the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option, either as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
     RowBox[{
      SubscriptBox[
       StyleBox["opt", "TI"], 
       StyleBox["1", "TR"]], "->", 
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["opt", "TI"], 
    StyleBox["i", "TI"]], "->", " ", 
   SubscriptBox[
    StyleBox["val", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 " are method-specific options, described in separate ",
 ButtonBox["sections",
  BaseStyle->"Hyperlink",
  ButtonData->"method_option_forced_directed"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<RadialDrawing\>\""], "InlineFormula"],
 " method for trees and ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 " otherwise."
}], "Text",
 CellTags->"b:0.1",
 CellID->43508600],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "a method suitable for the problem is chosen automatically", 
     "TableText"]},
   {"\"\<CircularEmbedding\>\"", Cell[
    "lays out the vertices in a circle", "TableText"]},
   {"\"\<HighDimensionalEmbedding\>\"", Cell[TextData[{
     "invoke the ",
     ButtonBox["high-dimensional embedding",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/GraphDrawingIntroduction#105832149"],
     " method, in which the graph is first laid out in a high-dimensional \
space based on the graph distances of the vertices to ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " centers; this layout is then projected to 2D or 3D space by linear \
combination of the high-dimensional coordinates using principal component \
analysis"
    }], "TableText"]},
   {"\"\<RadialDrawing\>\"", Cell[TextData[{
     "invoke the ",
     ButtonBox["radial drawing",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/GraphDrawingIntroduction#437048596"],
     " method, which is most suitable for tree or tree-like graphs; if the \
graph is not a tree, a spanning tree is first constructed, and a radial \
drawing of the spanning tree is used to derive the drawing for the graph"
    }], "TableText"]},
   {"\"\<RandomEmbedding\>\"", Cell[
    "lays out vertices randomly", "TableText"]},
   {"\"\<SpiralEmbedding\>\"", Cell["\<\
lays out the vertices in a spiral; in 3D, this distributes vertices uniformly \
on a sphere\
\>", "TableText"]},
   {"\"\<SpringElectricalEmbedding\>\"", Cell[TextData[{
     "invoke the ",
     ButtonBox["spring-electrical embedding",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/GraphDrawingIntroduction#425607435"],
     " method, in which neighboring vertices are subject to an attractive \
spring force that is proportional to their physical distance, and all \
vertices are subject to a repulsive electrical force that is inversely \
proportional to their distance; the overall energy is minimized"
    }], "TableText"]},
   {"\"\<SpringEmbedding\>\"", Cell[TextData[{
     "invoke the ",
     ButtonBox["spring embedding",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/GraphDrawingIntroduction#301083942"],
     " method, in which a vertex is subject to either attractive or repulsive \
force from another vertex, as though they are connected by a spring; the \
spring has an ideal length equal to the graph distance between",
     StyleBox[" ",
      FontSlant->"Italic"],
     "the vertices; the total spring energy is minimized"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->377874746],

Cell[TextData[{
 "Valid values of the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option."
}], "Caption",
 CellID->515118509],

Cell["This draws the Petersen graph using the default method.", "MathCaption",
 CellTags->"b:0.1",
 CellID->483852068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", " ", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "10"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "9"}], ",", 
     RowBox[{"5", "\[Rule]", "10"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[19]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.0122303406161803`, 1.352991288530645}, {
    1.0343930965768335`, 1.0781020856986554`}, {1.5245407691319455`, 
    1.7096996395289517`}, {0.4054268756553773, 1.7224532054417425`}, {0., 
    0.9909004633439503}, {1.357674407184545, 0.6296220987756667}, {
    0.5119608792059847, 0.6884725970000887}, {1.2340412539002854`, 0.}, {
    1.8101398237419923`, 0.42962544960731214`}, {0.6762312506254575, 
    0.10051765268637802`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.0122303406161803`, 1.352991288530645}, {
     1.0343930965768335`, 1.0781020856986554`}, {1.5245407691319455`, 
     1.7096996395289517`}, {0.4054268756553773, 1.7224532054417425`}, {0., 
     0.9909004633439503}, {1.357674407184545, 0.6296220987756667}, {
     0.5119608792059847, 0.6884725970000887}, {1.2340412539002854`, 0.}, {
     1.8101398237419923`, 0.42962544960731214`}, {0.6762312506254575, 
     0.10051765268637802`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{189., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{193, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->357213078]
}, Open  ]],

Cell[TextData[{
 "This draws the graph using the ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 " algorithm",
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"8", "\[Rule]", "9"}], ",", 
      RowBox[{"9", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "10"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"2", "\[Rule]", "7"}], ",", 
      RowBox[{"3", "\[Rule]", "8"}], ",", 
      RowBox[{"4", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "10"}]}], "}"}],
    Short[#, 1000]& ], ",", 
   RowBox[{"Method", "\[Rule]", " ", "\"\<SpringEmbedding\>\""}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[20]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.5441166092897437, 1.7290808001413414`}, {
    1.2001880590966867`, 1.7281883976482477`}, {0.8210804320759417, 0.}, {
    0.3218482339362243, 0.19208897427950378`}, {1.6865117231827154`, 
    1.2878487206527054`}, {0.12044128736467352`, 1.3744305143844167`}, {0., 
    0.7515321328026353}, {0.8858209412870136, 0.917384959508828}, {
    1.4333584750586268`, 0.19839682147095472`}, {1.7619907541382775`, 
    0.743543273683796}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.5441166092897437, 1.7290808001413414`}, {
     1.2001880590966867`, 1.7281883976482477`}, {0.8210804320759417, 0.}, {
     0.3218482339362243, 0.19208897427950378`}, {1.6865117231827154`, 
     1.2878487206527054`}, {0.12044128736467352`, 1.3744305143844167`}, {0., 
     0.7515321328026353}, {0.8858209412870136, 0.917384959508828}, {
     1.4333584750586268`, 0.19839682147095472`}, {1.7619907541382775`, 
     0.743543273683796}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{180., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->585851411]
}, Open  ]],

Cell[TextData[{
 "This draws the graph using the ",
 Cell[BoxData["\"\<HighDimensionalEmbedding\>\""], "InlineFormula"],
 " algorithm",
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"8", "\[Rule]", "9"}], ",", 
      RowBox[{"9", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "10"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"2", "\[Rule]", "7"}], ",", 
      RowBox[{"3", "\[Rule]", "8"}], ",", 
      RowBox[{"4", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "10"}]}], "}"}],
    Short[#, 1000]& ], ",", 
   RowBox[{"Method", "\[Rule]", " ", "\"\<HighDimensionalEmbedding\>\""}], 
   ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[21]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.9510189620515086`, 0.23805685431282242`}, {
    1.3610800452047682`, 0.2955153942942961}, {1.8258461543813842`, 
    1.7738896962399342`}, {0.3263059885764601, 1.7649344975344312`}, {
    0.6250773005858441, 1.1447757737180235`}, {0.8887102288561244, 0.}, {0., 
    0.6776172637978815}, {0.9096012489581842, 0.7440310024848578}, {
    1.673138670144184, 1.6022465806140878`}, {1.0623087331953842`, 
    0.9156741181107039}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.9510189620515086`, 0.23805685431282242`}, {
     1.3610800452047682`, 0.2955153942942961}, {1.8258461543813842`, 
     1.7738896962399342`}, {0.3263059885764601, 1.7649344975344312`}, {
     0.6250773005858441, 1.1447757737180235`}, {0.8887102288561244, 0.}, {0., 
     0.6776172637978815}, {0.9096012489581842, 0.7440310024848578}, {
     1.673138670144184, 1.6022465806140878`}, {1.0623087331953842`, 
     0.9156741181107039}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{195., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{199, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->1555159106]
}, Open  ]],

Cell[TextData[{
 "This draws the complete graph of 30 vertices using the ",
 Cell[BoxData["\"\<CircularEmbedding\>\""], "InlineFormula"],
 " method",
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "30", "}"}]}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", " ", "\"\<CircularEmbedding\>\""}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[22]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.390443574307614, 0.6914132894715279}, {
    1.375251310237037, 0.8359580267279495}, {1.330338492865724, 
    0.9741854653640221}, {1.2576680278282981`, 1.1000544030228516`}, {
    1.160415963158294, 1.208063763142887}, {1.0428326807487314`, 
    1.2934930184007385`}, {0.9100571342678041, 1.3526085004068022`}, {
    0.7678922522241587, 1.3828265789300054`}, {0.6225513221455394, 
    1.3828265789365304`}, {0.4803864400991806, 1.3526085004260928`}, {
    0.3476108936129453, 1.2934930184319513`}, {0.23002761119571152`, 
    1.2080637631846582`}, {0.1327755465160091, 1.1000544030733552`}, {
    0.060105081467280996`, 0.9741854654210511}, {0.015192264083556006`, 
    0.8359580267890113}, {0., 0.6914132895339541}, {0.015192264057597882`, 
    0.5468685522761683}, {0.06010508141649917, 0.4086411136360628}, {
    0.1327755464426228, 0.2827721759707079}, {0.2300276111029284, 
    0.1747628158419401}, {0.34761089350481994`, 0.08933356057353059}, {
    0.4803864399804391, 0.03021807855554448}, {0.6225513220213713, 
    1.957589645940061*^-11}, {0.7678922520999907, 0.}, {0.9100571341490631, 
    0.03021807849767244}, {1.042832680640606, 0.08933356047989138}, {
    1.1604159630655109`, 0.17476281571662644`}, {1.257668027754912, 
    0.28277217581919667`}, {1.330338492814942, 0.4086411134649759}, {
    1.375251310211079, 0.5468685520929828}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
       9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 
       17}, {1, 18}, {1, 19}, {1, 20}, {1, 21}, {1, 22}, {1, 23}, {1, 24}, {1,
        25}, {1, 26}, {1, 27}, {1, 28}, {1, 29}, {1, 30}, {2, 3}, {2, 4}, {2, 
       5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 
       13}, {2, 14}, {2, 15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {2,
        21}, {2, 22}, {2, 23}, {2, 24}, {2, 25}, {2, 26}, {2, 27}, {2, 28}, {
       2, 29}, {2, 30}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
       10}, {3, 11}, {3, 12}, {3, 13}, {3, 14}, {3, 15}, {3, 16}, {3, 17}, {3,
        18}, {3, 19}, {3, 20}, {3, 21}, {3, 22}, {3, 23}, {3, 24}, {3, 25}, {
       3, 26}, {3, 27}, {3, 28}, {3, 29}, {3, 30}, {4, 5}, {4, 6}, {4, 7}, {4,
        8}, {4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 14}, {4, 15}, {4, 
       16}, {4, 17}, {4, 18}, {4, 19}, {4, 20}, {4, 21}, {4, 22}, {4, 23}, {4,
        24}, {4, 25}, {4, 26}, {4, 27}, {4, 28}, {4, 29}, {4, 30}, {5, 6}, {5,
        7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 
       15}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {5, 20}, {5, 21}, {5, 22}, {5,
        23}, {5, 24}, {5, 25}, {5, 26}, {5, 27}, {5, 28}, {5, 29}, {5, 30}, {
       6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6,
        15}, {6, 16}, {6, 17}, {6, 18}, {6, 19}, {6, 20}, {6, 21}, {6, 22}, {
       6, 23}, {6, 24}, {6, 25}, {6, 26}, {6, 27}, {6, 28}, {6, 29}, {6, 
       30}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {7, 
       15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7, 20}, {7, 21}, {7, 22}, {7,
        23}, {7, 24}, {7, 25}, {7, 26}, {7, 27}, {7, 28}, {7, 29}, {7, 30}, {
       8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8, 16}, {
       8, 17}, {8, 18}, {8, 19}, {8, 20}, {8, 21}, {8, 22}, {8, 23}, {8, 
       24}, {8, 25}, {8, 26}, {8, 27}, {8, 28}, {8, 29}, {8, 30}, {9, 10}, {9,
        11}, {9, 12}, {9, 13}, {9, 14}, {9, 15}, {9, 16}, {9, 17}, {9, 18}, {
       9, 19}, {9, 20}, {9, 21}, {9, 22}, {9, 23}, {9, 24}, {9, 25}, {9, 
       26}, {9, 27}, {9, 28}, {9, 29}, {9, 30}, {10, 11}, {10, 12}, {10, 
       13}, {10, 14}, {10, 15}, {10, 16}, {10, 17}, {10, 18}, {10, 19}, {10, 
       20}, {10, 21}, {10, 22}, {10, 23}, {10, 24}, {10, 25}, {10, 26}, {10, 
       27}, {10, 28}, {10, 29}, {10, 30}, {11, 12}, {11, 13}, {11, 14}, {11, 
       15}, {11, 16}, {11, 17}, {11, 18}, {11, 19}, {11, 20}, {11, 21}, {11, 
       22}, {11, 23}, {11, 24}, {11, 25}, {11, 26}, {11, 27}, {11, 28}, {11, 
       29}, {11, 30}, {12, 13}, {12, 14}, {12, 15}, {12, 16}, {12, 17}, {12, 
       18}, {12, 19}, {12, 20}, {12, 21}, {12, 22}, {12, 23}, {12, 24}, {12, 
       25}, {12, 26}, {12, 27}, {12, 28}, {12, 29}, {12, 30}, {13, 14}, {13, 
       15}, {13, 16}, {13, 17}, {13, 18}, {13, 19}, {13, 20}, {13, 21}, {13, 
       22}, {13, 23}, {13, 24}, {13, 25}, {13, 26}, {13, 27}, {13, 28}, {13, 
       29}, {13, 30}, {14, 15}, {14, 16}, {14, 17}, {14, 18}, {14, 19}, {14, 
       20}, {14, 21}, {14, 22}, {14, 23}, {14, 24}, {14, 25}, {14, 26}, {14, 
       27}, {14, 28}, {14, 29}, {14, 30}, {15, 16}, {15, 17}, {15, 18}, {15, 
       19}, {15, 20}, {15, 21}, {15, 22}, {15, 23}, {15, 24}, {15, 25}, {15, 
       26}, {15, 27}, {15, 28}, {15, 29}, {15, 30}, {16, 17}, {16, 18}, {16, 
       19}, {16, 20}, {16, 21}, {16, 22}, {16, 23}, {16, 24}, {16, 25}, {16, 
       26}, {16, 27}, {16, 28}, {16, 29}, {16, 30}, {17, 18}, {17, 19}, {17, 
       20}, {17, 21}, {17, 22}, {17, 23}, {17, 24}, {17, 25}, {17, 26}, {17, 
       27}, {17, 28}, {17, 29}, {17, 30}, {18, 19}, {18, 20}, {18, 21}, {18, 
       22}, {18, 23}, {18, 24}, {18, 25}, {18, 26}, {18, 27}, {18, 28}, {18, 
       29}, {18, 30}, {19, 20}, {19, 21}, {19, 22}, {19, 23}, {19, 24}, {19, 
       25}, {19, 26}, {19, 27}, {19, 28}, {19, 29}, {19, 30}, {20, 21}, {20, 
       22}, {20, 23}, {20, 24}, {20, 25}, {20, 26}, {20, 27}, {20, 28}, {20, 
       29}, {20, 30}, {21, 22}, {21, 23}, {21, 24}, {21, 25}, {21, 26}, {21, 
       27}, {21, 28}, {21, 29}, {21, 30}, {22, 23}, {22, 24}, {22, 25}, {22, 
       26}, {22, 27}, {22, 28}, {22, 29}, {22, 30}, {23, 24}, {23, 25}, {23, 
       26}, {23, 27}, {23, 28}, {23, 29}, {23, 30}, {24, 25}, {24, 26}, {24, 
       27}, {24, 28}, {24, 29}, {24, 30}, {25, 26}, {25, 27}, {25, 28}, {25, 
       29}, {25, 30}, {26, 27}, {26, 28}, {26, 29}, {26, 30}, {27, 28}, {27, 
       29}, {27, 30}, {28, 29}, {28, 30}, {29, 30}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["14",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["15",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["16",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["17",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["18",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["19",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["20",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20], InsetBox[
       FrameBox["21",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 21], InsetBox[
       FrameBox["22",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 22], InsetBox[
       FrameBox["23",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 23], InsetBox[
       FrameBox["24",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 24], InsetBox[
       FrameBox["25",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 25], InsetBox[
       FrameBox["26",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 26], InsetBox[
       FrameBox["27",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 27], InsetBox[
       FrameBox["28",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 28], InsetBox[
       FrameBox["29",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 29], InsetBox[
       FrameBox["30",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 30]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.390443574307614, 0.6914132894715279}, {
     1.375251310237037, 0.8359580267279495}, {1.330338492865724, 
     0.9741854653640221}, {1.2576680278282981`, 1.1000544030228516`}, {
     1.160415963158294, 1.208063763142887}, {1.0428326807487314`, 
     1.2934930184007385`}, {0.9100571342678041, 1.3526085004068022`}, {
     0.7678922522241587, 1.3828265789300054`}, {0.6225513221455394, 
     1.3828265789365304`}, {0.4803864400991806, 1.3526085004260928`}, {
     0.3476108936129453, 1.2934930184319513`}, {0.23002761119571152`, 
     1.2080637631846582`}, {0.1327755465160091, 1.1000544030733552`}, {
     0.060105081467280996`, 0.9741854654210511}, {0.015192264083556006`, 
     0.8359580267890113}, {0., 0.6914132895339541}, {0.015192264057597882`, 
     0.5468685522761683}, {0.06010508141649917, 0.4086411136360628}, {
     0.1327755464426228, 0.2827721759707079}, {0.2300276111029284, 
     0.1747628158419401}, {0.34761089350481994`, 0.08933356057353059}, {
     0.4803864399804391, 0.03021807855554448}, {0.6225513220213713, 
     1.957589645940061*^-11}, {0.7678922520999907, 0.}, {0.9100571341490631, 
     0.03021807849767244}, {1.042832680640606, 0.08933356047989138}, {
     1.1604159630655109`, 0.17476281571662644`}, {1.257668027754912, 
     0.28277217581919667`}, {1.330338492814942, 0.4086411134649759}, {
     1.375251310211079, 0.5468685520929828}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{225., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->344212016]
}, Open  ]],

Cell[TextData[{
 "This draws the complete graph of 30 vertices using the ",
 Cell[BoxData["\"\<SpiralEmbedding\>\""], "InlineFormula"],
 " method in 3D",
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "30", "}"}]}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", " ", "\"\<SpiralEmbedding\>\""}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[23]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{268, 296},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->393613624]
}, Open  ]],

Cell[TextData[{
 "This draws the complete graph using the ",
 Cell[BoxData["\"\<RandomEmbedding\>\""], "InlineFormula"],
 " method",
 "."
}], "MathCaption"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "30", "}"}], ",", 
     RowBox[{"{", "30", "}"}]}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", " ", "\"\<RandomEmbedding\>\""}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[24]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.8611659914338285, 1.1078299115677936`}, {
    1.7575877229938215`, 1.3327366057343772`}, {1.7307431340680937`, 
    1.2010791648553758`}, {1.6857669303323437`, 1.4873321920708595`}, {
    0.6689139676956068, 0.7870719788244581}, {0.8125552913184474, 
    1.3543645447012675`}, {0., 1.599403417128958}, {0.5795997505740258, 
    1.655470977323454}, {0.6707693760667571, 1.6197126186523692`}, {
    1.3790466487458997`, 1.3785987319024948`}, {0.24837436522749756`, 
    0.6234936084148457}, {1.215500976246545, 0.9740282211205278}, {
    0.5556048944718719, 1.032728802351427}, {0.276270401724507, 
    0.797569385991688}, {1.769932932981341, 0.6220264729594381}, {
    0.07995407417623013, 1.625393454159627}, {0.7832062892506013, 
    0.13664297837347056`}, {1.6818363301038666`, 1.2143507230887163`}, {
    0.40591970561469015`, 0.8576555398067204}, {0.5160434980061431, 0.}, {
    0.921189472196319, 0.9880612496049102}, {1.0021334724475264`, 
    0.2572126186651117}, {1.7907272513157628`, 1.1729030396937217`}, {
    0.5879005537057816, 1.1601943829027919`}, {0.3204170786066756, 
    0.8734871422729432}, {0.4988704055358805, 1.1983264074740185`}, {
    1.0780770986173882`, 1.3182193978129455`}, {1.3006808407020372`, 
    0.9551414545722023}, {0.29228894695621094`, 1.7420151026283424`}, {
    0.8152002275510151, 1.510085178477463}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1, 
       9}, {1, 10}, {1, 11}, {1, 12}, {1, 13}, {1, 14}, {1, 15}, {1, 16}, {1, 
       17}, {1, 18}, {1, 19}, {1, 20}, {1, 21}, {1, 22}, {1, 23}, {1, 24}, {1,
        25}, {1, 26}, {1, 27}, {1, 28}, {1, 29}, {1, 30}, {2, 3}, {2, 4}, {2, 
       5}, {2, 6}, {2, 7}, {2, 8}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 
       13}, {2, 14}, {2, 15}, {2, 16}, {2, 17}, {2, 18}, {2, 19}, {2, 20}, {2,
        21}, {2, 22}, {2, 23}, {2, 24}, {2, 25}, {2, 26}, {2, 27}, {2, 28}, {
       2, 29}, {2, 30}, {3, 4}, {3, 5}, {3, 6}, {3, 7}, {3, 8}, {3, 9}, {3, 
       10}, {3, 11}, {3, 12}, {3, 13}, {3, 14}, {3, 15}, {3, 16}, {3, 17}, {3,
        18}, {3, 19}, {3, 20}, {3, 21}, {3, 22}, {3, 23}, {3, 24}, {3, 25}, {
       3, 26}, {3, 27}, {3, 28}, {3, 29}, {3, 30}, {4, 5}, {4, 6}, {4, 7}, {4,
        8}, {4, 9}, {4, 10}, {4, 11}, {4, 12}, {4, 13}, {4, 14}, {4, 15}, {4, 
       16}, {4, 17}, {4, 18}, {4, 19}, {4, 20}, {4, 21}, {4, 22}, {4, 23}, {4,
        24}, {4, 25}, {4, 26}, {4, 27}, {4, 28}, {4, 29}, {4, 30}, {5, 6}, {5,
        7}, {5, 8}, {5, 9}, {5, 10}, {5, 11}, {5, 12}, {5, 13}, {5, 14}, {5, 
       15}, {5, 16}, {5, 17}, {5, 18}, {5, 19}, {5, 20}, {5, 21}, {5, 22}, {5,
        23}, {5, 24}, {5, 25}, {5, 26}, {5, 27}, {5, 28}, {5, 29}, {5, 30}, {
       6, 7}, {6, 8}, {6, 9}, {6, 10}, {6, 11}, {6, 12}, {6, 13}, {6, 14}, {6,
        15}, {6, 16}, {6, 17}, {6, 18}, {6, 19}, {6, 20}, {6, 21}, {6, 22}, {
       6, 23}, {6, 24}, {6, 25}, {6, 26}, {6, 27}, {6, 28}, {6, 29}, {6, 
       30}, {7, 8}, {7, 9}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {7, 
       15}, {7, 16}, {7, 17}, {7, 18}, {7, 19}, {7, 20}, {7, 21}, {7, 22}, {7,
        23}, {7, 24}, {7, 25}, {7, 26}, {7, 27}, {7, 28}, {7, 29}, {7, 30}, {
       8, 9}, {8, 10}, {8, 11}, {8, 12}, {8, 13}, {8, 14}, {8, 15}, {8, 16}, {
       8, 17}, {8, 18}, {8, 19}, {8, 20}, {8, 21}, {8, 22}, {8, 23}, {8, 
       24}, {8, 25}, {8, 26}, {8, 27}, {8, 28}, {8, 29}, {8, 30}, {9, 10}, {9,
        11}, {9, 12}, {9, 13}, {9, 14}, {9, 15}, {9, 16}, {9, 17}, {9, 18}, {
       9, 19}, {9, 20}, {9, 21}, {9, 22}, {9, 23}, {9, 24}, {9, 25}, {9, 
       26}, {9, 27}, {9, 28}, {9, 29}, {9, 30}, {10, 11}, {10, 12}, {10, 
       13}, {10, 14}, {10, 15}, {10, 16}, {10, 17}, {10, 18}, {10, 19}, {10, 
       20}, {10, 21}, {10, 22}, {10, 23}, {10, 24}, {10, 25}, {10, 26}, {10, 
       27}, {10, 28}, {10, 29}, {10, 30}, {11, 12}, {11, 13}, {11, 14}, {11, 
       15}, {11, 16}, {11, 17}, {11, 18}, {11, 19}, {11, 20}, {11, 21}, {11, 
       22}, {11, 23}, {11, 24}, {11, 25}, {11, 26}, {11, 27}, {11, 28}, {11, 
       29}, {11, 30}, {12, 13}, {12, 14}, {12, 15}, {12, 16}, {12, 17}, {12, 
       18}, {12, 19}, {12, 20}, {12, 21}, {12, 22}, {12, 23}, {12, 24}, {12, 
       25}, {12, 26}, {12, 27}, {12, 28}, {12, 29}, {12, 30}, {13, 14}, {13, 
       15}, {13, 16}, {13, 17}, {13, 18}, {13, 19}, {13, 20}, {13, 21}, {13, 
       22}, {13, 23}, {13, 24}, {13, 25}, {13, 26}, {13, 27}, {13, 28}, {13, 
       29}, {13, 30}, {14, 15}, {14, 16}, {14, 17}, {14, 18}, {14, 19}, {14, 
       20}, {14, 21}, {14, 22}, {14, 23}, {14, 24}, {14, 25}, {14, 26}, {14, 
       27}, {14, 28}, {14, 29}, {14, 30}, {15, 16}, {15, 17}, {15, 18}, {15, 
       19}, {15, 20}, {15, 21}, {15, 22}, {15, 23}, {15, 24}, {15, 25}, {15, 
       26}, {15, 27}, {15, 28}, {15, 29}, {15, 30}, {16, 17}, {16, 18}, {16, 
       19}, {16, 20}, {16, 21}, {16, 22}, {16, 23}, {16, 24}, {16, 25}, {16, 
       26}, {16, 27}, {16, 28}, {16, 29}, {16, 30}, {17, 18}, {17, 19}, {17, 
       20}, {17, 21}, {17, 22}, {17, 23}, {17, 24}, {17, 25}, {17, 26}, {17, 
       27}, {17, 28}, {17, 29}, {17, 30}, {18, 19}, {18, 20}, {18, 21}, {18, 
       22}, {18, 23}, {18, 24}, {18, 25}, {18, 26}, {18, 27}, {18, 28}, {18, 
       29}, {18, 30}, {19, 20}, {19, 21}, {19, 22}, {19, 23}, {19, 24}, {19, 
       25}, {19, 26}, {19, 27}, {19, 28}, {19, 29}, {19, 30}, {20, 21}, {20, 
       22}, {20, 23}, {20, 24}, {20, 25}, {20, 26}, {20, 27}, {20, 28}, {20, 
       29}, {20, 30}, {21, 22}, {21, 23}, {21, 24}, {21, 25}, {21, 26}, {21, 
       27}, {21, 28}, {21, 29}, {21, 30}, {22, 23}, {22, 24}, {22, 25}, {22, 
       26}, {22, 27}, {22, 28}, {22, 29}, {22, 30}, {23, 24}, {23, 25}, {23, 
       26}, {23, 27}, {23, 28}, {23, 29}, {23, 30}, {24, 25}, {24, 26}, {24, 
       27}, {24, 28}, {24, 29}, {24, 30}, {25, 26}, {25, 27}, {25, 28}, {25, 
       29}, {25, 30}, {26, 27}, {26, 28}, {26, 29}, {26, 30}, {27, 28}, {27, 
       29}, {27, 30}, {28, 29}, {28, 30}, {29, 30}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10], InsetBox[
       FrameBox["11",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 11], InsetBox[
       FrameBox["12",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 12], InsetBox[
       FrameBox["13",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 13], InsetBox[
       FrameBox["14",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 14], InsetBox[
       FrameBox["15",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 15], InsetBox[
       FrameBox["16",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 16], InsetBox[
       FrameBox["17",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 17], InsetBox[
       FrameBox["18",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 18], InsetBox[
       FrameBox["19",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 19], InsetBox[
       FrameBox["20",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 20], InsetBox[
       FrameBox["21",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 21], InsetBox[
       FrameBox["22",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 22], InsetBox[
       FrameBox["23",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 23], InsetBox[
       FrameBox["24",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 24], InsetBox[
       FrameBox["25",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 25], InsetBox[
       FrameBox["26",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 26], InsetBox[
       FrameBox["27",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 27], InsetBox[
       FrameBox["28",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 28], InsetBox[
       FrameBox["29",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 29], InsetBox[
       FrameBox["30",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 30]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8611659914338285, 1.1078299115677936`}, {
     1.7575877229938215`, 1.3327366057343772`}, {1.7307431340680937`, 
     1.2010791648553758`}, {1.6857669303323437`, 1.4873321920708595`}, {
     0.6689139676956068, 0.7870719788244581}, {0.8125552913184474, 
     1.3543645447012675`}, {0., 1.599403417128958}, {0.5795997505740258, 
     1.655470977323454}, {0.6707693760667571, 1.6197126186523692`}, {
     1.3790466487458997`, 1.3785987319024948`}, {0.24837436522749756`, 
     0.6234936084148457}, {1.215500976246545, 0.9740282211205278}, {
     0.5556048944718719, 1.032728802351427}, {0.276270401724507, 
     0.797569385991688}, {1.769932932981341, 0.6220264729594381}, {
     0.07995407417623013, 1.625393454159627}, {0.7832062892506013, 
     0.13664297837347056`}, {1.6818363301038666`, 1.2143507230887163`}, {
     0.40591970561469015`, 0.8576555398067204}, {0.5160434980061431, 0.}, {
     0.921189472196319, 0.9880612496049102}, {1.0021334724475264`, 
     0.2572126186651117}, {1.7907272513157628`, 1.1729030396937217`}, {
     0.5879005537057816, 1.1601943829027919`}, {0.3204170786066756, 
     0.8734871422729432}, {0.4988704055358805, 1.1983264074740185`}, {
     1.0780770986173882`, 1.3182193978129455`}, {1.3006808407020372`, 
     0.9551414545722023}, {0.29228894695621094`, 1.7420151026283424`}, {
     0.8152002275510151, 1.510085178477463}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{244., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{248, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->1358928147]
}, Open  ]],

Cell[TextData[{
 "This draws a graph specified in ",
 StyleBox["Combinatorica",
  FontSlant->"Italic"],
 " format using coordinates that come with it",
 "."
}], "MathCaption",
 CellID->1060524416],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<Combinatorica`\>\"", "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->1559565747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"PetersenGraph", ",", 
   RowBox[{"Method", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->627898082],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.30901699437494745`, 
    0.9510565162951535}, {-0.8090169943749473, 
    0.5877852522924732}, {-0.8090169943749476, -0.587785252292473}, {
    0.30901699437494723`, -0.9510565162951536}, {1., 0.}, {0.6180339887498949,
     1.902113032590307}, {-1.6180339887498947`, 
    1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
    0.6180339887498945, -1.9021130325903073`}, {2., 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 3}, {1, 4}, {1, 6}, {2, 4}, {2, 5}, {2, 7}, {3, 5}, {3, 
       8}, {4, 9}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.30901699437494745`, 
     0.9510565162951535}, {-0.8090169943749473, 
     0.5877852522924732}, {-0.8090169943749476, -0.587785252292473}, {
     0.30901699437494723`, -0.9510565162951536}, {1., 0.}, {
     0.6180339887498949, 1.902113032590307}, {-1.6180339887498947`, 
     1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
     0.6180339887498945, -1.9021130325903073`}, {2., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{193., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{197, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->2055201855]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MultiedgeStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->82725606],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["MultiedgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiedgeStyle"]], "InlineFormula"],
 " specifies whether to draw multiple edges between two vertices. Possible \
values for ",
 Cell[BoxData[
  ButtonBox["MultiedgeStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiedgeStyle"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or a positive real number. With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", multiple edges are shown for a graph specified by a list of rules, but \
not shown if specified by an adjacency matrix. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"], "->", 
   StyleBox["\[Delta]", "TR"]}]], "InlineFormula"],
 ", the multiedges are spread out to a scaled distance of ",
 Cell[BoxData[
  StyleBox["\[Delta]", "TR"]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:0.1",
 CellID->154685702],

Cell["\<\
By default, multiple edges are shown if a graph is given as a list of rules.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->239623524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->1649349271],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxdk3tMUwcYxbvyqMCGjofxAUrrIFopQ+eQ4uQUDFR5FBGGAkGnAuLEzdry
dlMRlQioCGwiAgOFCKJZkFAwMgQJKiBOxUWeokBECrQFYu+9bW939+++5MuX
k++/c36He+DnXXFsFovlz+x/V6UTEDbPtOhVce8PzOgwOy4YyKWNqN64TCaO
nsanIL7T8a8JiDbx9nb45eBve57Po5hRsP43/7QXh7w5pUSvRVvSA/FbHEkN
Z4sUOhx1W1aqMBJ4eUq+IayZQkOim2LfThLx9k1j4jgKiuG8aMsyEpK753ek
WFOQ2re4l0+SsFhefE3fQCI2aLTP3J3C4fy08fk9JPhm1hN8OYVE7/bP0ikC
rh1hpp8aKFjHf55fV0yAX53wPmyOgsTtlrLGg8BFD/axUCENpXeisqBxDllB
Vc/dZDT4E0MrM0LncLulKjethkbNIce+I1MaXO6+UuE0RMPh7p8Hz53WoFX1
pcDOyohpyak7yqUa1Mf3J/t5GOGyKs+xpVaNpKvBC9UxRvzWJi9z2KpG6XRr
kOtpI1gu5Y6R11XwfeaUr3tAwCdtgr22jMK1W60CGYsE7RkQftGbwri+eaLT
l8TvrPffrRsh0VUwFLZwhkSAyeBm/QkSSnWhI/mIRMHzkseWK0nU23HmX7Ip
xAxXJu1pIuA8xLt0UkShciDu5WQ4gWF9k0J/gsINhXtSq1oLcd4uP+qRAZ5P
FuQ1x+Yw4rqu289oQEbWE91Tqzkssl1yIYbx51WL0MqzWoPKpIUEHKeRww6R
aKEBFbMQ+ZHxhzO5N9mqX4271dKoyFFGf5jxSpWqEZ7/lSzP3oh2OifSx0KN
/fOCpjM7jBCLYte/FqmQPiNY4ZBJwPyjbtg2g8K5kM37bBoJxFvyVmy1oeDq
NZXiryTA5T30NK8l8S7zUGojlwSXG2I4zvgiPHLo8A+RJErN9zmfH2Q4eha4
3fcKiYhAeYJ/EgHDvY2cqB4Sd7ImUhoWEygIs8ir4lDQiJrpvlotjGOVK25I
DDgb+gv9F38OClPhNqccRrttryjq1GBdT/jbnicGdK23op0PaqBRdTZUc2gU
CG3qZCwNbINP/npbTGPY7NWWzDI1iLGK6TfZNC4u6vH4nsnb1/P6TdduGjv/
eOw92qxCse0Wn5vWRnSvzn9XR81CWr/t20nmX75ElhXRMYv1csFKUQaN1A/K
1UcTVVhr0ptcJKDRF+XC53yhxk/dZRWsMQOWq+36T8ercaIww3C1xIDmlE2X
LrSrcW8weEa+24DGLqXUlMvw6LCot2apAXY3Kt6/YHht8JpXBfbr0Tdglt03
rsHO2sgDEsavzV0+2VOxWkQVNrKlTI+INS92m3Rp8c2aRj8XHom0isvlNhsI
SOyfup9UEeBEGxYTTJ9WaXZU5Twk4HFf0HnFlIRremZ0VBEB/ZRTRNsxEj9u
tx4hjhLIFQtf72f49VkoOSsLYPJMHhkPDabwLwrgPpk=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384776350671539, 0.7}}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 2}], 
      ArrowBox[{1, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
        38, 2}], 
      ArrowBox[{1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
        54, 2}], 
      ArrowBox[{2, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
        70, 1}], ArrowBox[{2, 3}], ArrowBox[{3, 4}], ArrowBox[{4, 5}], 
      ArrowBox[{5, 6}], ArrowBox[{6, 1}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{195., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{199, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->355653439]
}, Open  ]],

Cell["\<\
But multiple edges are not shown for graphs specified by an adjacency matrix.\
\
\>", "MathCaption",
 CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "3", "0", "0", "0", "0"},
      {"1", "0", "1", "0", "0", "0"},
      {"0", "0", "0", "1", "0", "0"},
      {"0", "0", "0", "0", "1", "0"},
      {"0", "0", "0", "0", "0", "1"},
      {"1", "0", "0", "0", "0", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], ")"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[28]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.4875669188038463`, 1.7455699225238166`}, {
    1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
    0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
    0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 1}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 1}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{188., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{192, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->743623605]
}, Open  ]],

Cell["This spreads multiple edges by the specified amount.", "MathCaption",
 CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "1"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[29]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxdkmtMU3cAxe8uCIJUNokioijVYgCxiGDqRM6/IFiRh/giijwmKCo+EFlF
xYkaFEHwuYkSByKrAQMY8YVoZC0+NoUpEIboAglYhWpbe2lv6W3p2Ned5OT3
4Xz4fTmem/es3kJTFBUx1v+o4fyMk1pZtGk8H/Z84aAe8Os5PWqFLGDqvuUJ
n2GI8pmVJTSCBPKTWsKL8HoyX6xI7AP1v3TJL8d256nQ5vD7j4+W9yIjZy1N
7nPQei2VaJpGcUw5objQzoL2A+L9Ur4Vc6SV41U8Czo8MurkBVZkvXWSddlY
oOi3K+pTWbE0Ib7j0iczhBnvXQ7OoUjHgsEn7CMzPlXkTL8RQ5Gjt7+UiI6Z
ES4ep8U+ivSLy5ycvjfjscP6uEXnKKLQDvucVI753/Cn3g2kSfI3jT57txoQ
0Hnrue9KmuT7+1eaHQyYkRj/IXcDTX5uqp4bdkOPZ97CxpBkmrhOD22aIdbD
bcPC5ohNNCnQLL72U88wUmt9lTWraLItf1VFgnQYne5t/c3BNCl8utCr1HUY
8zTyp+6eNCn12Mlomhm46fe2PxeZcM63NLzIhUNBpj7+ToUJVd2OK+wHTbgQ
vP7IRxsOcVmmRzvvmLAsdVF8+g8c+Esv+BKpCYJvJ6+UPOAgucgL9hCaUB/S
m11vb4aSmOY+7B2BoC6npTPGjAXyevZdwQhk0r9Y22IzFNGRhUm+I3Cy355P
d1qRlDSxUHKTQVbvROkqW4pE5xh3uUoYpLjNPXDRjSI2ZdvPzOvTYYol9v4l
b4q8XH1bXpytA7k2q3tBIEVOphX4R9rpIJa7CySLKXLH703N/l++wkFnedUq
oggtu64Ven3FxPEOti0BFBlo2PKp+J4Witcr/nTdyiJknaRImzaCV+Zkke1G
Fp6pjsdj9EYkbppT4LyBxe5371/Y5RuR9Os0fnAqi7IqQVjgZCMalE2pmTks
4u9xt7QyFjPqeH3SUhYzdy8biFvCgvMMUY7KWXSdvTsuvcOA9re6qKssi5aa
8sGgTANEO073XAnhkNyUOjhTq0VjQD/vZS4HXcToocrzWggrcxO1Cg7BLxpW
tiwZ219HnIx3MaNhkOxp7tbgymHBIdEOM6jSoLO5kRpEVY1b8+C5GVV+6btm
t6mxLnPrQZWPBVxKxDp1mhrPVIPWv89bMLvJd5PSWQ11o0fhLecRIHxZ60fv
ITilT0vwrjbCInDt8nIfwgS5dvY/oUakJIeWxQqH4G5Zu/xJL4tXCbWkdcsQ
8hyv19w8xqK87lQ67/EQeOU7LsfNZyGuzfujKECFNUlxupkfDDhSImgbkKuQ
1lovXFhtQLN/1jn19s8YDZ5SGbSZgcJeL+HdZXBAZAqVBDG42n34zdHvhiHz
qrWXTWVQHG0btSR7GGuLLcl8HoMJXzIepIz9vXa+Pm6SC4MrbtntVqKH6wlb
u0gfBg+PJ3bwf9NjUfUTR4/VDErDDkYrbQw4QXdFbDvFoHBInFey0YB/ATcF
Hgg=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03384776350671539, 0.7}}], 
      ArrowBox[{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
       22, 2}], 
      ArrowBox[{1, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
        38, 2}], 
      ArrowBox[{1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
        54, 2}], 
      ArrowBox[{2, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
        70, 1}], ArrowBox[{2, 3}], ArrowBox[{3, 4}], ArrowBox[{4, 5}], 
      ArrowBox[{5, 6}], ArrowBox[{6, 1}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.4875669188038463`, 1.7455699225238166`}, {
     1.9996460459354313`, 0.8861424682559871}, {1.511583448071915, 
     0.013316663859109679`}, {0.5114456436282868, 0.}, {0., 
     0.8594781450938977}, {0.48875342845363157`, 1.7322387782110364`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{222., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{226, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->342515528]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PackingMethod", "Subsection",
 CellTags->"b:0.1",
 CellID->1079530539],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["PackingMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PackingMethod"]], "InlineFormula"],
 " specifies the method used for packing disconnected components. Possible \
values for the option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData["\"\<ClosestPacking\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ClosestPackingCenter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Layered\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<LayeredLeft\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<LayeredTop\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<NestedGrid\>\""], "InlineFormula"],
 ". With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", 
   "\"\<ClosestPacking\>\""}]], "InlineFormula"],
 ", components are packed as close together as possible using a polyomino \
method [6], starting from the top left. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", 
   "\"\<ClosestPackingCenter\>\""}]], "InlineFormula"],
 ", components are packed starting from the center. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<Layered\>\""}]], 
  "InlineFormula"],
 ", components are packed in layers starting from top left. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<LayeredLeft\>\""}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<LayeredTop\>\""}]], 
  "InlineFormula"],
 ", components are packed in layers starting from the top/left respectively. \
With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<NestedGrid\>\""}]], 
  "InlineFormula"],
 ", components are arranged in a nested grid. The typical effective default \
setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", "\"\<Layered\>\""}]], 
  "InlineFormula"],
 ", and the packing starts with the components of the largest bounding box \
area."
}], "Text",
 CellID->1733232121],

Cell["\<\
This shows the packing of disconnected components by the default method.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->792188815],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "=", " ", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", " ", 
          RowBox[{"{", 
           RowBox[{"50", " ", "+", " ", "1"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{"i", " ", "+", " ", "1"}], "]"}], "]"}], " ", "->", " ", 
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"i", "^", "2"}], ",", " ", "50"}], "]"}], " ", "+", 
             " ", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", " ", "0", ",", " ", "50"}], "}"}]}], "]"}]}], ",",
       " ", 
      RowBox[{"{", "10", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->1387662881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->1017045768],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{223, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->106296626]
}, Open  ]],

Cell[TextData[{
 "This shows the packing of disconnected components using the ",
 Cell[BoxData["\"\<ClosestPackingCenter\>\""], "InlineFormula"],
 " method."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->134849000],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "=", " ", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", " ", 
          RowBox[{"{", 
           RowBox[{"50", " ", "+", " ", "1"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{"i", " ", "+", " ", "1"}], "]"}], "]"}], " ", "->", " ", 
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"i", "^", "2"}], ",", " ", "50"}], "]"}], " ", "+", 
             " ", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", " ", "0", ",", " ", "50"}], "}"}]}], "]"}]}], ",",
       " ", 
      RowBox[{"{", "10", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->754755199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"PackingMethod", "\[Rule]", "\"\<ClosestPackingCenter\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->1761064761],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9XWuUVcWVvvR99pN+0HQ33Q1tg9KAICBPdRCToCIiqIigPGN4KRKCCoZE
EEEJYoIvBgVEjShGkYfQYqKJ4yuMk0xciTNLVrImyYxZKzNrspY/5kd+zA/m
q/rq7Nqn7rndMD/iWjb33FO1a1fVrv3edWcuvXflsruX3rvqjqUd16xbunbl
qjvu6bj6m+vwVbpPKpX6HP//S3MKn8/ik/3/87Nn8e/f/u9w8ze9ffvvUqkT
K1f+JjUyeL64l/etFsoA9e3S2z9OVdvnjo6f4rlQ6E4NDHpV6ff5k6l2+7x1
82dJ73vpn8+diGHBb7PpYw6Ll3a9P7Tm6eef/w8HZdCgd92ohHLq1H8NKfxg
985fOSzaW992o/L9kVfODM495vu7UXX/YfXP7FjX7bBoNn9zxHXGjE+unPLR
LRUz//evf7Wts+/ef/+H27f7mbSo1ngGsIubD2y54xXbOvfF6dP7J03CR2nQ
VNT+worHn3rkE7b/xZ49J1euxMeHt37OBhZ+VrAZ3fHKhllPEvPcX7/88rHm
ZqAm4Jr9DPJuHcuOnt6167aLH3T4Vqjxb7zsYGPFIW5Bi+7T58jba9feNesl
3SfPPtOHPQUM69MvuDVuivd7b/PmJZO/n9Bv5qXPHZ43r67sedeP69Y+4BSe
c+ljq298mZ10n691PAo86jMvuj56dli4qVN//viWj9CiTrDh7Nqau0lBezcd
QyNsfYvqA0rBijTkXnJUwBFJVVgtbAEoht3c7NgPm4TZeWzYb2Dbj9nvs0OH
Th7/wvXj7NDv7y77h82LXnSrnH2zIr5awOPwC79xfTi7togmx3UdWXPF5lS5
ec78+dNP7xm1ZMoVH6Bhh/0GLS6f8O43uu768g9/KNhvQAffnnzXxFEn0WZQ
1AaPq8beh1dsg8aAc8Wkn2k4AAs4GMKOld40bQPGNhhZXNyp+fT5548tWWKn
ZZ/R/IWpU0GBqSH2GZDxjL/uPYZ8dfbs3506lRpsn/EJz/jWvfft2R+Q8Ayo
qbx9xmAY0ny0pzrFGeGrhZduJ6WU2W9IKVcN2AYAF0VzvKVzfXGbaRfsBBIX
2m/wYf7wTYlw0J1wADARzrVDnwAaFp+UXcN0c9/D+D6TeiNVhmOWStemnnMc
qsu+J42E73PZN1ND7fsBjW8mvM9L/0ED30nqnznO8R0WL+x4p6v2782+WWzT
oCzwRfPcFfDJsugZ7Xdu+InDwreX9x2pR2L9XXt5T1YXw+IP772HfTQfy6J9
frzDvmoMZECdfcZLNPHt0RkgzMfaoH1DAC9t/2BBztr/Un2D9v0DeGUBXQ06
D6x5Ys2OnRvWXrKdG9at/U84rnI+WK9f9mM3V7bavP6f3HNjtENOXui1NPK9
TD3ffsPbblZ+hxsCeLq9eSa83esOggIMhTQG8HT7OVe9HqMQzhUcM1WGaabS
/fIH3dzrglEMlDLw3HD0SrXGCk7hZbdH1QlwUnlZ07NKHKdqeEKtzhDCMie4
MhGWcMMYrLqe8II+06E4GTnxhIvfxHKXAa9UBud3/PBj5NZ2fbOO6tLHIlrA
WqSy+ITnpurX3KoRQ3DtMZ2v2tMZQZs05hT5utUWqijhwDXwDb7gcmCsz48e
7V/1IwKrjjgfcAMyGreJI08AGl5ZGVYluKE7vpAFAfCmmtcJjeux4/bvj2r7
YRyz0W9hnmDCpOaB0RmJSRAvMewZqQJ1QnBBmqLVddVLMcQVtRuh/+DxydUH
IGhBiBXBacmejcuWyggSZCfOxTOjR19ftwyQpjY/9L3aWgwHkqaUrQp6hlKv
PIKEgcED0RUAZjWvBrDLqzcA8K4Vz1LO1joqDuWinTVlbEz6UFJrCWXXMSNS
5Ms//rFS9aI8KkQ7JzKLe9nW8pbp1ecIBq6Jj4XJsBc+SK/KCA5VNQihOtXr
hnEHMBPRNwRDagpWf8789+efN1mBiL7Ud1qtfCPl+dNC/B68duPg7M75DXOP
LlpUEY3d0nCMR9npZlb+4USB1nx/akarWmdCe7+xbBrWoDo6WS31R8l+2V+0
TNCf72/1jMxHO3Yszk++qOrJbwy9szaa14B+x9kh0A2h44liHtNGCRX0+HRX
1/2T7xrRuM9wRfYGjQD8uqt3gCi89qj5ylUtW1NloIpUes4F9znollpy5MAT
89/a9NX7OrM7IwrPk7OvuGQdenmd2s6o4Kii60nggs2a3XI3QRYUplP6bYI8
2njFGmdZCVRgfvflm0DjXsPPKqjod2ThQpg0C0ZvI1RaIrT8gOcDwDPz6N7d
ZwTiuGFHvz5kRUz3VyuXE2sMTwevvRZkT4gwsmBq4SPUEp5IrtjA9p84zlwW
PNsVy5JWMApNKWcpifw9fvj3PJXUMnk6DE5lwXNBY5c7gSdAA0zCA5pAFh9h
KpDzkNOQUvKCnX+m9ehs10I3ATjsQHHgY6B7GBBgTICmV4jWB77kIi9fRn6u
pHNNJL05Na+fuWeuDOHMmfNLJ6OrFAUuvPEd0kAaC8TlLoJSiGPDjncs+kfC
4blYtvQXbJeEDRbqub3/5lZCY2M0BMpsUe7pCyBHcfqzt+hDv4J/jvkVxC8h
NFHktwj7EwvvQdBYyMy938A9D+zlfft59q8OnomF9vqMVXvn/Sn+OdnfUvp9
qDGNVaPQOim9+kLTRasf87dAF64OdpOjXGLpSsYWM4TQvPenNd6ObPXxLR+F
XiAri7zHBFrRfTN+EM1w7vfwbKBx7H5q3kYvzgTrUKe4AMQRjiiYeKRRZckR
Al9QxrXOHIcgNHKfZ1wsDGlOzw5XA6uD1mDYxDMLdvA/f/6zh1wf4EU8vb+t
n59NRvRPMD1aG821b2gN23Dly8b9ZO1V2zDMDY2rUtozxHM8e+KLjeWvcBvF
dwK+sHHOHiA5q/+duk/kGRr+NBQvLzfEBzKu68jykWupsi2+5T3dZ2rTlrfX
rm3I/tD1qVcUYzTmdKQROIW80K1mWiH+HOqN+A7LDXWTx6ZfJM05/UgbydFa
x/48t7WbLdsV7zf2g9Yasulj0Cy8R4j6GqUO1hjgy7WOYH06P9r7S9e6XuEJ
LZEqMpXKV3afVnjS0+R9F1C0LPfPkI9qPw8kI5R99hUfDh6hUUM/Eo2u2F8k
OIiuKP4iUu6aOa+KZtjkJVC6wVpo5kTTQwtUoAKAQJ1WjFWnrHa+HK/j8j1p
32jN1vuifElaPzftW5VMh87qNAWLS/adDRuWlF8OUwLKorESiMvGNR+g7dxp
R+0wkU2M5aNXw2upEHm0P9jiq+3bMSw9H8u+usfJRN2C62AxyqLpqgHXj2h6
bm7VrNfmzCFGjgq1ZgyZDjPgt93dok83K4o2M0pbm9DrgaFXpFbx3CQbOeQE
DQp+aHPmQcu10Y59cfq0JVSFM2YIigHCQPuf9+4V4avOWFq4meM5nns3R3zX
+RjIa0KfAH2xpj0xKe2l0mff0FpDwNdDr1Xf6MSAI4Ecsfr5QN4QYyrzBgM9
Ly9dM8GzPQtp+vnNx8gL0T/Av1bRdtROe3rqA/w5Ljm7bw/M3c7QOoOJQXqF
MZHvBVPOZ6L91tu8cXw9fr3hy/X2ni0+e09VWfC+JjpfEkOwpzs1QVHo9WP2
8Uw5WWXOJfHyviuLV4HPOINoDVEoyq2mdyOhLVYF8TShNZZPXoc0pjFyPBtn
kGeE9og5M8SIRqfRCokRBSDeozVITJy69QqaePgKrU0npTX21LlwcyfCVSdG
Q4JTXBPR8tqu2yCagXqZ4trQX0CLdpwciAe2FJqBEd7W71ZIG2oM2AeQAE6f
ow3pP3ns25AeeG3PSx4fAOvO9lmXDDy4eOBSqDCGj9PyBQGtH7f8yikf6fEl
OtC3h5l4rkA9CzvofDmhN9/ONItn6gOXV28AxRNbw2WhDXiNpFxJE3R3sLxf
yFqEOby5OjOPJwanFkCIO1QzAVUdyJ1cJHegzhksaUHd+/W33Mh6bp6atNcF
mgs6EkNvtVAvxIywR57zUcp5q4IW0r1LDMXMn9HtPBlgxeJPKUR7CubsbEhQ
mrMxxZqhRbxl469S1gvk4Oj4h22RBWQKHCgzZrftvOiHLPJsyv6e1Z5Ny3mc
7n31kB/U9TmQUv4ViWdhgb1/hHOgWgtFY+SAF8waZpN4mtcgwV68n4D6Gt2J
kEDCE+zuZXDKABbGAYzKEGpeQYUui10OoLq4XegTsthUinQEnVHz27bydWC2
4pp9rt0FfgXzYh2Qr3MBHbekDml4ClfQafvZNw88fIpE5f0kVksGfXpMyyMO
DYIyH6vj4/3lzJkVTdPpfnBrBeu9M/MopLEoGOJ1BBEYDaxWw7AeuW2zHxo7
5LWYF6ir7+77rvu+8QKJnpJRtCey1WrXVp1GE7UmzldLCwOLz5AwthePd3fO
4XAWQpEfoCricmiKjyePf0E3QktR62kX7HTWEl3Z9OrGoq+kBpJk5KlI8CyF
cjWkJs7MxjGzWDCGjrF45ixxj0IPhI+EJNvAnpL43vOK0LdzqR87g/EW5ybB
6l3UtrgiwpHsuoTt7d9XK6nlbffk/ua9Gtes76EbbsABgOoLgeM1P7c+o4Ln
kcEzYdlVLHfZAGP24QnzAQGJg9LFh0rnqtzm4ShM04EE6gi4bbLvI3nHjIYx
Q43i55AOnjkKztvg3GPi1VK+EFlfl1sS2x/o5SH3DT0wloZT1yi+C0lxNuYj
ze65/7UR/ffzNIS5KDhLOO50glZFvIG4yiBtCiej4Yc0onDw2SQ4l7cM3pBK
zCYhqw6yScBj0WfesAdSxT6Day7cBRSpaYm/zftucPSh47hT/uTqA5AhfrZN
CjvZF5BUcxR8cNg5O77s6K4Vz5JBtMT7GIc/IxRi+3MfYa9h9cRNQOxi3iBy
nkq9S9NP0OAAAsTQ0lOCHQ9OAl4Y5GIEdrzO6RgYYQ2Nbs0Vm6EZzOy3MrYP
7VGsZ9O0DexDDGZGciQWX/NWebLVjjcQseaZ7xm3NTyMegajhHSn0UPJ80rX
thmHNA/9HHBNDM1qkBUSbQJ7ZCiSK0eL3OZeVGirncFPHbW6MFot8C7GEfMR
xi5ax3iUzX0z+hDoD43AwKgPMW8Ki4xvzPwtXgW6iUAnEFiwepy+X+huCE6m
1f8LEhPCiNIai5Nsn/u1pdzUs2mP40qdFXqx4MpvpvTbJLgqK9vlH4iOqv0B
5kyLFepyOcSKdlZpzOrG3orXbO6F36bBZqPOaTnaLm7Jvea58bl0PGv5yIZS
GneZojnzUax75z2oj2g0liexrVAAKuZjmKHQqGjSzJNYbp39kM71c1h6H0NV
sBrEUrLuHJYea7MaBnIydt425nuftdEv2JXQ1tbY+W+rA6g1ipaM5cxR6aWL
vL4eu9LZGg2J2JX2BGjsPNRQjvZVlGNyk9I69wm8XJ+br0FXq1cUk5QrpU/O
zVNedTt8bli6/BmhQ6dn41m8FJLWJpJcU56JENKPgSONowo5Qv9Sok0sNrWl
H5PlSQcdTCBaoJz7PYtPuJ0jdS69fJfWQWJZt96rH0So80AF1AlRcUn7Swta
FkB9NbYvo7kYCgPCmh896GW84+DOLgztZpjWUN7MR+aDoOXtl2ylMgYTTXIl
wReZFBFFd835iNnNgQVehbUjt4YRCpHx0q73CQmoigUusXUKexxZrgm5rpG8
ek1CH57Xq7KKf8LgB2riO8Dsve9AW3Jox1XDd/R/+HZ5BY8ZgqFNTz4Mg765
7kgqcvrH8DJ4Uh+nqQFDx8lIgLv1oo0ExG+wPi67IHOcdoaPYFuKy3LfvNah
PUGQ+9jQdr9SMSlYFq2x6Aw6Km1GyKrToay68L1ogNruBx2L5cNMDdEJcUj5
DbbgO1d+C0zvkbuPhVaUpZ28nG/Msda6EcQmzzBtA7Qg+apotGXGA4zzhfBq
FJUbyUqvivc0MZvbagI5aSUfQt9qol+it/c52sNYkIOPfwDDG8q12NATRp7A
iQTvksPkMMQhZM4UZ+C1ZHwLVsONcxod4HSmd6ye9J1rCwtSNrwuuhmo2DhW
6bvcsOIdWgiODpmesWjOz1zsuD2ijLmWGtHQ6lkxe9p4kIJ8BCEUbVGzNRQU
yYnH2fjs0CFPRa1qp2eMegb8OsiazonHiIuDeTXF8WQHkEJXwA9oC5DdwEJw
u9GqWoklk6WkDFp53wfYFoh1/PBjsfWGjbF50YsSlm2KU9HLM2YsKVw2qvXF
2/vPBxUNjajC5TpQgntrXiL/LveB770Hr12tq3gqogyPLH3iHv8mf+4rNMcC
wUPj/suZM+I/HB9Qa2iRu0xM67NOiuy3nBMvbg3kVW/2e1OERcznEERe3Kil
TyJ7la416Qiw7NH+B7Um5z6Mtt+WriXpiLDC8zOPf1ZU0SL2P+nJjUIO53Mf
Rir+ei7VIANUe5xuPJHfsb3ouUGOgXR3vkmejrVdt0GP8fb0aI/R/6OeY4Du
V3YUCsWCMQ8n9IMUAa+QhFPns3AZ7n2OLBq/g/xA94H8hooljsYYpudfmzFA
9cOzSVekbRPUgkBHxQwlITTmVdy7+4zLUXSyMC96MAT8Y0ufcvyAmI6JJHUP
1RihlVkV9Qm8BuDKEBKXXnQYfWqCPn2LNAXqMsBnROM+4JwaZ/EZFPQL9U7K
kNIVG43B2aiJ3sNyNvqnyCiaHLGceHPi6gLJTVnsswiqIikArgYLMKracHj7
k068nY89iof0UtsRRnG5ZjoDNuiDV2J7apvZ4Ce6ne4D7Q9Tod0h9SogYTWH
GC2URRhIxgZ5SemqEPLRMLJLtbKovdQg+MhtvZJCSVUlXBPYHUzMwVfE3fpE
c0IXkgzN/S9dP5KMb+lMgGR8S2cCEN7+B9+8qPopH/XttLO4d6mRxVe1bAWe
fSM6LWHFkzZ8FPDcIvzc9SXzPnB2denakOQIaqeiYhOdru0FS3v6VEyv7ChY
WBHsEFdLwyZ6wdQQDAQIJWL8YN4AWRpjSwdZwF7ZfJ1xyZZf//qtt7q2pb0Q
drWqMCrTbRheY/nbjnXdGFPMY9J/6eoWK7+M1UlIOHBgPCAnJoMBqpzlsCZI
42R8/bXBSOqM+hyZf//wQ2AHSayrz5yfIbFuJB/xuCxWDqh53xmtCK8FEAoN
S3sSLZQGyfZhRju20JnJkc3oNUz6LqU2wCzE1KmChpxkSQgq5qT5KDqpMmWk
CqC4DmTSJd2UR6xRATeAxHty9QF3lkM7qTLig/SiQAlmPgggQYuWWtYsbY69
m45BATJnPNHaq9ASE7RsCHPHO+OGvrF08HIAsGNVStQXm7bn/teged81cSNw
vH/VT1NF0dse9ExKwbACxEtB8R1CSzBSj2cpzDHweUT0ygASCNRbbj5TIvSt
0CYWCxNDMBtSvE0Scx2jpI+u69CZAJ2K8n2uAFAVd2KHgsLsBqlEETknud0u
6iy75HQk4jM6Gj2ow3D6WPoYQPozSX1MYlw4Z0GsXp2qNtUWHNdkxViXRCHS
3RwNmwgbdZ2Rqkfpqoem59ZM2QJtw2evBvostvmugbOZmuNsxYNPfDg4uxM2
vjiTghpqbP3W2Q+NavthbCz0WX7xN0HriyfuLNa8z6PigLEyoVfsOg6/0+0p
g5yGhrUJIuJ4UnnMOdIouIRLgSp0a4x6z/gfpGgL587hQHburVdGG7+77uda
w80J75VhRnsa6iFzX3MwlbkvuiDtr9KVA4xJtwXyIRNIGomyl8jcD3lImLnf
W2WAxiLMesYGStZzmC+WHBm3cMJsYzIsKTMP87XOJzpu3s/wvNPnC2OMsIY4
udJCkvZj78X720PFQqvi2U7qQley0szbz3G6zrJ2IIiPZ4SMzzJ6UhVROS15
AdaauBLhnRUWb6MLrWiajqPudKEhihMwirxo3PdS2p/Ms+3iZYDWEu8BGbB8
2rO6h+MAOKUipqUuJZZjIE4E7QH12sxvu7tZ6qi1GVpggM2S0JRUP+LZyLZC
xL1o+wJzx3fFo7flO5/i+bKq9SZQMfAgGukdNFyiQsFgmKF/5aspbXezLWCA
O26atmHS6Le8HA4oIyv+Hwpcx02YbYaPTAuP8q9jJyxJ32FGGWaK3jgtWGfu
EtYCmgNTOiXekWDJ+yxYp3MpX2RN1EcseVrlZLZm72sCyuJcSBvGJ2J3afmy
T4PKCTB5vwvB7REldBrOExoEk24mpO/mPLHzzMecXHGvyWpKzJfMUhfykYm+
EfRYlbnXkBhbwRHbMuMBdpFKNWe5ydnDa5y9wKficvSsp9bPodnLJnfzgqyZ
21HDTyR6V+q+CCxCg+MArHAF7dw8cF1xW2b2hxFe2VVghblLVazWUNsUpr3F
oOkR85aEq7kQ691HgeuVpCuqMpeIv89Aqz+r64/97pxbDFryDYY1PCs13Old
K551tjaxk2yIWL6Bbw8tHdzV5xuIVuv6l6zAAGKDzgPP0vkG9REPBX8Cn77n
6h046nisjTgf8w2dtQ0OCWI3HxnhBcMzQdaOV2BKACBIJVbrLznlfhc6FNal
Y+jJWRLMHxYqM1yNcZKvtD4M1mTqyiKKpWYO9loTrE/oNRAtkpEkqMJM/SYk
rJNosXKqe7ztw+arGOuv3vqIsPXGRrLn1li9ZEwMDfaax8CzhJm5dI60ix16
jlgTrGPoWxA7WViGhiA5/b3eqzHM/K2UfCSgxFourAMUC6+x6+jytAt2SjkX
NBt8Fvdj7KaKpOofqfkAdUFoY5jkKKdUF8TvpxAPATR40DVUKzDREMJ5zDwd
5pqLQeAkic9f5Ht/bwlnCnsbfGL72hOuGmv/g2921e0xugmpCjTiPEuNiluO
G3Y08jAYTgE6M9KEMwebdvUyTWrPb7zsoOMs5BT+jpFhwezPN65bEZ1InEAj
8cMbJFjBFrfaDXcdqvhauE/mmdhdp+QKcI5q8RT8TtVCWeFqv6xu6XwzxbUi
1Pu5pzp7FNYyrXEgU6FOkzmPNgqZF70Y4/RjRqZY1Ywn453zVoa3NXkO1q5G
loqbbTYtC+w/FivpcwRs1p+pQAMGvPXjlrtqXeqYzsvV5wjzVtCpXa0WPR/l
ircYrbPN45MVv4WLg1madZWtt1TMlIsnYtWr9GyAFMBdQImV0ffkjq44On9S
R+aws4k3fmVSb0Dv9nyPmsx0RddSCZ+l4yaMcAvHca2YR+5bDVDrDja6Z/2r
TPkV3Xvy2LeXDl6ur3xxWIQWZqfmn2Jf01PpI9thXruPCbVFK07MnJZOrClq
PNYaA+/Z7AxOZmhbh1X1yba3+JWiGUgt9AA1qo9FbE2c98njXziPF3sNClar
p9qZiUHbUAeYEOA93I9QpS1Ikx5imR2OoUmathQGysslycIii75ElT52LvSB
hP1VzLBKNHUgYK4esQk8RE/yx3KB5A0po7iOn+ZrVbTSTKQpstnC7PRxav9W
Nl8HffO78/d7j00s7u7r/nUOCH101D29nS28bN3C4ynv1zMwY3cJMB/dwCQm
rJVA70eqqn50003QJ8UGyspsYxF4eul8xVQYz9VWN5jnh9u3hxFutoVauK1Q
cAQhXtMgnutxoJIYq50Jsx90rQZUxT998gmW5I/vvy8GEuWii9tjHensW3r7
x7G4fd9vx+qZOD9/x4pYQuOHH1s+cq2bk3Ma2yywUC57qgokCQjQ15E4j4St
i5s+/GmHQP6kmpui/3TA2bIRh2deQVxqxmrdfE5BTcBFagKpKJYwJGFgCbuY
pvaO8HzVy60InE+j9ZbAtj1++PeEQc0A2+nyPIeq+ZWuXCkobYGWa3jvI200
bzvRlgZKIqypRb29di16m4/hrXjCi2O3WOrbGehJ2T9pEhAnDdqMtJTJXCqT
Wm6v9TQEOLFGl5E1bA40dXTiUYZyGEaQQ+sw0tqof9OIgrYFZZNYkCd7zlB8
/yNzINbMNbewLV/2qcMHFHBR5RPQC2AYAbzchMYV5UlfeNO7XK9i74SykYix
t5OHKrx8zrWO3Bst00agTZ4aBmfwnoHe5Oiw90nwnhPYIS6mbBN/ovzmNDlL
Uc52FH0Mb5L0Es1ZjGJBOj+RHa0K7IwLf3n1BozGwxTEb6sS8Q68AFV4zx7Y
QqjtLNmECAFUSb7keQP5AQefc+DrKEIriXRQqrZeYp/o4LyIkj0b1vKVxl4i
n9CD2ctbVl7O1bgx0wEN69i28Zxw7fsHvD+jKM/n4JWaEYNIW2Y8MKL//iTr
iDNaO/+NVHJeu8wIULDWQ2ueNrlxSTZt6RmFNN8/iV97jyuWSM/ZaNDp4PRy
b3G4T+/aZWw61rhgH+hkk1z0JvEmkn9B3cf3Roo3JfGD0IORA/gVTdOhJKwa
ex/9NBf6GVToTO2zNhFdp3nrWSZVUzBfl3anv1+muErftnN2Z9KJpb9XJDtY
uPHvEw4QEy+Q1WaomWelGovppu6GDH+WRMI4bj9EcUvasGF91pCI/8lNNjIT
8axXBPseenSIYYuiGXNneEtMfnjaYvWcnAtMw9/xKXXzczru5esLEuSFjs2X
BxQdUniweqs7buqq23Nzbvq/Hj7sPB/at1xeJA0Y55YqRBDTXe2zYpnKTi3p
c0RKibUe7yP8OhtuvKJGsSTfWr366a6ufRMmHJo5k8lSkQ8wJ3kyUhpHDZm2
I+xLCd6KtQz7cu/uMzg4YHFRRkYOrB1m6BMPfexSOPMn9a2JMGdwcMIMcVcL
kD4mWvhYhb2OkoOeQFiaHxB70dRAqEPKd0GVIzbM4YVtIE40bVvPGPWM04zp
ZAisVK9x4uR8a/iCWLY+57lp4QtimymcVZYEeTJauzzofCQnHLex1JSVrPKY
vs76X09pdYpTGYdY7A4csZr8HW7lES90Y9VEO8exKIwks59RSj8a58P7sSkr
AAbI5dUKzhyzz43q+aPVxzJoDnuL2WW54MSIxujsbGqpJCSOoe8wvnpIZIX5
3K1xcdykjjJ5Rbw9TNxoPaA5cGN+G8am9sBSh1i9m5cR3lPA8d2N3lEJcCqs
Mwm9FNRUndsa0p+3pfta29pe+utRvT4n+f7OuhgcvJ8caAmtCorXT1jX77Xo
zuB9+NsTyRFyQvW+e527YHLwwhy9uqD98GD/kn+1gaO4ioaolqoHr0uVkhv5
KF6ocCcWTpeTUUvD0zZ2+DsNwg6lOT1ezF7grTd3ts+CJrqgZQHOm44HJ+Wu
kI8xJoVOco2P0Ia+IcvXCF7c8ryvH6zoZQxdO9/D7zPEfguCsxqs5BuODnh7
WXSeYlZ6ZYSti4OGcdGCWlEJV6WK7/bJBzvR023fFmZCVWBYPVgohZu21kv+
vkPyb0mo1SmquPN5SxwpiNup5/COs/BOIPs+uus7ujmci4FJGsM1kpKFREx8
ZlB5IiaeG0iFguiexXcWtKk5l9aWOCdf0WN3MCcjSwpJeOtlz+16Ga9Kdk/u
E7+y/4MQflD5xJdZ6AXS+WEk5V2ORmUt8Z+XY2HeKVcHiqerGmSExepylRIR
AdJUlOZdc1x8bpLpktAOFqOcXX+zo9wWTu/rOfTLkN6i+h1zN9k8o+TN/Zrx
yT3W3CxaluQU9/qrGpybZBsZoo3uYsNncX+5uSW2i508Vsquap0Je5Q3hbee
Y89MRCl0KHx26BC9cNAq0Q78SEhBy5PSv9RBubuqZUZn5tFFbYvdmfrm0Pl4
nl83h6vubre7fsw+bPrHO3cKy2TEY82Ft3Zmd5rWPIHrxy1H77lVs8Rf01vs
fpLlrGDMu4cP3z9p0r7x482tPpRgWIo9I0fiW+p2Lu7k+VNZ8NwW9QIsdHG9
CAsEC2UPXz05ZAhEnJOpvUWirfeoXKxHEAyWPXZPUE61ABfHO7bw3mlahdCw
w7usdRTHQ8AYwDUGIZfUQhOv0xh6m42OWifVWoXRm3Tie6/98L2PpsTeizc7
5OKl4Yf3jybXgpWGX2L8mPeq918GaQqg6GwDP4qnunTi+9I+797el2tZGMA3
+DQG44V3oYZ5wuc7vtb4Sv9ySFORxCUc77nnOOCQTjfme++pkXrl2J2tr+w+
DX5h6gMboxGC6jSd1TY6gtnLr3rQJyBy7GxUq0q/hFT/naW/ZoT71y6tVJbx
Bnzxu0jy2pizPf2mxoC4pAGZVUZj0hdyw7gD1grJSCkSGrMXXSD0Wl2i5NM5
/PJFmh53n43orrqAdeFuKZEsHv5SBvOY+dscoyLIyb89YeUNI1o+c4AVAEcW
LlyYmTB2yGvzam/2OVhAdnFu0qVD38C3ZmVG2G/xflnDtDGdr0IMmsXmHmGq
EI4jmp6DefD8lClAwrbu6VcdQB9LO5claP+WRiu0TKf1/p+//rWwTs1bsa7Q
wqF2/emTT3ze1FDVwlRgffABWkiAR/iWz2oGeMgZEJj2d9lcoN5+c0FcHwp/
lZeu7z0szYk85xiqOYXw62RO4jORfSU+cT51Tr+OIPX0PWX79sB1hvbyvrEX
+CMCrpj86wmvBb16/3WDv+XfVJ//A4YAVC8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{215, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->269840585]
}, Open  ]],

Cell[TextData[{
 "Users can adjust the packing by suboptions of ",
 Cell[BoxData[
  ButtonBox["PackingMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PackingMethod"]], "InlineFormula"],
 ". Suboption ",
 Cell[BoxData["\"\<Padding\>\""], "InlineFormula"],
 " specifies the amount of space to allow between components; possible values \
are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), or a non-negative number. Suboption ",
 Cell[BoxData["\"\<PaddingFunction\>\""], "InlineFormula"],
 ", which overrides ",
 Cell[BoxData["\"\<Padding\>\""], "InlineFormula"],
 ", also specifies the amount of space to allow between components. It takes \
a list of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["1", "TR"]], ",", " ", 
      SubscriptBox[
       StyleBox["h", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", which are the width and height of the bounding box of the components, and \
returns a nonnegative number. Options ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", 
   "\"\<ClosestPacking\>\""}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"], "->", 
   "\"\<ClosestPackingCenter\>\""}]], "InlineFormula"],
 " also accept a ",
 Cell[BoxData["\"\<PolyominoNumber\>\""], "InlineFormula"],
 " suboption, which specifies the average number of polyominos used to \
approximate each disconnected component. Possible values for ",
 Cell[BoxData["\"\<PolyominoNumber\>\""], "InlineFormula"],
 " suboption are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default, which usually sets ",
 Cell[BoxData["\"\<PolyominoNumber\>\""], "InlineFormula"],
 " to 100), or a positive integer. A smaller ",
 Cell[BoxData["\"\<PolyominoNumber\>\""], "InlineFormula"],
 " typically has the effect of not allowing smaller components to embed in \
between large components."
}], "Text",
 CellID->1901375873],

Cell["This specifies a space of one polyomino between components.", \
"MathCaption",
 CellTags->"b:0.1",
 CellID->1204295578],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "=", " ", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", " ", 
          RowBox[{"{", 
           RowBox[{"50", " ", "+", " ", "1"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{"i", " ", "+", " ", "1"}], "]"}], "]"}], " ", "->", " ", 
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"i", "^", "2"}], ",", " ", "50"}], "]"}], " ", "+", 
             " ", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", " ", "0", ",", " ", "50"}], "}"}]}], "]"}]}], ",",
       " ", 
      RowBox[{"{", "10", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->1153768386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"PackingMethod", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ClosestPackingCenter\>\"", ",", 
      RowBox[{"\"\<Padding\>\"", "\[Rule]", "1"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->693840740],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{221, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->157924095]
}, Open  ]],

Cell["\<\
This specifies that an average of five polyominos are used to approximate \
each component.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1630972093],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "=", " ", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", " ", 
          RowBox[{"{", 
           RowBox[{"50", " ", "+", " ", "1"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{"i", " ", "+", " ", "1"}], "]"}], "]"}], " ", "->", " ", 
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"Mod", "[", 
              RowBox[{
               RowBox[{"i", "^", "2"}], ",", " ", "50"}], "]"}], " ", "+", 
             " ", "1"}], "]"}], "]"}]}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"i", ",", " ", "0", ",", " ", "50"}], "}"}]}], "]"}]}], ",",
       " ", 
      RowBox[{"{", "10", "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->279699590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"PackingMethod", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<ClosestPackingCenter\>\"", ",", 
      RowBox[{"\"\<PolyominoNumber\>\"", "\[Rule]", "5"}], ",", 
      RowBox[{"\"\<Padding\>\"", "\[Rule]", "1"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->1455033611],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{215, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->60914005]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlotRangePadding", "Subsection",
 CellTags->"b:0.1"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " is a common option for graphics functions inherited by ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PlotStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->43937672],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " is a common option for graphics functions inherited by ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ". The option ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " specifies the style in which objects are drawn."
}], "Text",
 CellTags->"b:0.1",
 CellID->752136885],

Cell["\<\
Draw edges with thicker lines, and both edges and vertex labels in red.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->2146788540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"9", "\[Rule]", "8"}], ",", 
     RowBox[{"10", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "3"}], ",", 
     RowBox[{"12", "\[Rule]", "11"}], ",", 
     RowBox[{"13", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "1"}], ",", 
     RowBox[{"15", "\[Rule]", "14"}], ",", 
     RowBox[{"16", "\[Rule]", "14"}], ",", 
     RowBox[{"14", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[38]:=",
 CellID->793185],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{161, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[38]=",
 CellID->250733136]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SelfLoopStyle", "Subsection",
 CellTags->"b:0.1",
 CellID->84930587],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["SelfLoopStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelfLoopStyle"]], "InlineFormula"],
 " specifies whether and how to draw loops for vertices that are linked to \
themselves. Possible values of the option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", or a positive real number. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", self-loops are shown if the graph is specified by a list of rules, but \
not by an adjacency matrix. With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SelfLoopStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelfLoopStyle"], "->", 
   StyleBox["\[Delta]", "TR"]}]], "InlineFormula"],
 ", the self-loops are drawn with a diameter of ",
 Cell[BoxData[
  StyleBox["\[Delta]", "TR"]], "InlineFormula"],
 " (relative to the average edge length). "
}], "Text",
 CellID->988897229],

Cell["\<\
By default, self-loops are displayed for a graph specified by a list of \
rules.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1974872317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->1448363387],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWmtsXEcVvt177/qxa3vt+BU7TjZ2SM2rTUko4Q/qDwT9U1SpQioFtQkt
ktsCCWmRwqNqfwBBiFBAFUGIkKgCtaJEiUSklodIJaSmqJYsVImoqYnTR+Sk
MTjGr8auu3znnJk7s2fvrteUH4k2NzN3z3znfebMbG7b/fDIl76y++H7791d
/PS+3XtH7r/3oeKn9uzDq/C6IAgO4+83ewOMSxjx38OlEv6tfH6cnuE7i/9c
nv8HPkGOHjQv8Z/gDqbayVSl0uiVs/fMvbE/yNMjvHJ2VxWqV76AZ5CnR8iT
a4oqg0cIozTURR0zFdmwNErD6JpbRcNM3fqEike2rlWR4VEfdeKHX9966+zk
ZC2qCJNXn332ieHhsSNHrmeKN06fPvXoo0dvuSUI+fH07bf/9cCBybGxYJBx
PsZUZ44fF6ighdUQmRanp0/s2iVsh4guAuzPt2375c6dwIwmTp0KYqz88/79
eAl0jIMio97M1CACOwFuWZ4/ETQkuuJPIqisicAEwGAI4Zr4DRhgPT4QZCPj
7qBnFlMIBXTGGZ197aEWzqHZ1x4xlszwel/+AdYTiBAVNiE9RW/wnJ6YCPj7
YDu/hQCggnxBM8/x/Y+LLGSO507yfp5fPnMG9OSbNjsHKs03MOpH+O3LTz1l
eOUUar5C2l6mwBvg0op260tYeXlxUfgG23gd5idHRn53550YMFIIgB/2MkSr
kreH56CFMDTs4DkCAj6kYR/j3mhRwO2lQ4eMVo9RlJcS1DJ5Oz270XAdzyEQ
NCQ7CO4NygcFhVtQ0goK/M/hWQqEy+nHH39u714armfUD9u3kJZ4tSvU9gpp
C1a67xcKZM0u5Q/B/aClgrnA0EgDEhA6HZ20bVY7yEHDbkXPDgk+4EUMnGB0
clSdnrQS+S3KR93KKoL7fi+egW50crjd9ntIS5FNkZJBCklEgBlUcGjD/Fby
FyKY1RAZLqZhj81YGBRrQdJcE2+rjWfYBkTylgoSzJVYPMQSI11Tqs4a9X1e
1FExWq9Q+yqkbLBW4LpUqtBLcLfwW0S+yVfGCQEC0Wi4QUmbVVnXZSPnO42N
Lp4GvWzFB4N+pdVAhbyxkq9TyS/Im1W+DijcTUreSKF0Ki6CWrTxjFWUrRsV
arFC2lDhdCg+UgU2eflKsSVzOBrupuGgkjZjsxPARN9u56bGSi0csBFmsnWz
iUf2ZYMvJV68/vzB10/dRZ3Xd/Hd+W9d/fefpFhIhJK2Urk32GwFL8rWQYPK
8RwnMi5O/XR+8ntBnva4LEaLU8+AQJbha9lb+lWGDqkY3+rZc3HqCXx4T495
fAy8zDrZCSUmoanJ0C3WalCShpTBGYsRYfDiwc+I/mzvoFFi5vx+bMm07+fo
Ec+8+sV337kiVoCHTN5WQQ0xmBw9mMSCwfzPuQdXlv5CBDnmjfmFv/1RUvT6
1fCg6Sp4NP/tHZ+kvBy2EWoqrkWLTE8aW/tBSrgBfqPIyFAfFEkDQb6bnu6t
zW1p9k2LnsYttc+MxeLChSyZoQKVFSnwFpUCJoA7u2vzXlm6vGbenh0bbM2R
UAXvrjXwc/t5vfykX5KGk6JyXSo3OjNE1j8VXN0+XC/XpCsz3VFHKle/Vw/q
4J7sLijWcFdQjyR5VfHaUyWJUlGqS8IVMYvKgECCF+ETVHlMbay7s4STpMXW
B6yhYSFVEq1PaCU5c+xXVFulq3C9FNeerMSTRDE4IIrDKnksUgDJ9MdrkCKL
70+OfA4ssBYlEkV5q5KGq3OMrEAqoZXD0+7GabK02n3HdI9tVWMziJwsJk6a
E+8gIFCzUYvBEXsNDAHFBpVkvINmYRgIDiciLkEHszXWlM15PF22sMzXLl54
321AvmGLghF8k5ndFa8gJQ253tAJStobhBO0AWPJoYWLPwAsHaZyfKLCZOHi
kUQir59srauOcP1pSDWZ2Q9V5xtDBZCAEFlH8otlSisvLM8do+01R48Qk9LK
vJPLnWjqk6u5hsXajSWOwjf40OZ5LAiff+QT0+OH3Xxx6oTxNWPFSZ0QUcTO
kWgnvY3ujOuTtLWGBaXaYOHM+H2IpSBHj3Dh0sGZ8Qfpq0ZbN7DWrxs9qrqn
9e2+dLPnHvC7hHDm7D3vinTtNezYZKWDMk4znn+NTVZRS7AQKcOdTZz0RZKw
QXX5EAGjPTWsFK8iR5haRbhni5OzhJR0IwU4QEEnhZwEXSfXX2EVWB9KuG5W
SdOUSFNZMlzNldNqibtUjEUWHDHkZZks7izC+d8AWNgRVgY59BD2cmeUxeTy
3+/za4GcJ9wullFa61OIVCt5605fjEK9BwiFYflehXeXXrqbIkV6V6QPwtPx
c5VakN2J1+fneskhZdkqldzz/BZVgdLPLy5PCh5fd3uwdr6yAj6BxdlIPEd0
wEFJVhEH8KWOX7qILpUBg/8jX2fXWM0LloPxg8/X9Z5pfEPfq2Xc3KmZ92VK
5VAClt7lrKZIV8Se6RflVO72rM2Ko7511XoOKg812vxECNPNZ87Gr38HY7i6
c6jmaqM3nZvzHte9WKJGjo3UCbOtYwQavAdDIpiTWxrD2cWD5qwrlnB0vR3r
EyGTZOeE4fiuNwIcghv+hPO4WlTUr2JdnNSuH8MtQJQPadHnYSN0kMg1sWfG
9zgtXc9zg4cCDnhLvktQ9B53afQuh+K4CkqvqhibTHqPosEhgDyjvHJ8n6nY
RUXvo7g6l9yImEzIq1UbVdzd6KFgDr+4+w7M4R46xUqPjG/8873HRVDWqxq5
Uc1bbQwh6oj3gIoRHwXOBy8aDiheBaXxBlURBUXuHiA+2NGwX2nUoTKpT3l6
m4eidk1PI9nJUu4ITb33URx2n9Ko01rX3KSvVz4TlH7Fq1dp1G3tZk6Y8j3c
LPdJZShOQqFyFbtHfd+tZL3JQ3FR1KPqi44EqiHUwfGvDMZjjmeX1R+aJDfx
hG7uubqUh2/yUBxPvff0W6ubOzjddYgsEl2ujq9TqDr6OpR9fBQXTR1KI8kn
t4u1K1l9FFdjOxSV5LY7RxSUhwVFss7Vz4LSaLO1rtm521S+bfdQ1EnU02jI
WtfceLYaD+/wVrsK2aY02aJyuEXJLDJsUnnQojTZanjmrWwwBQ13eKvlrEbD
vNJAbjDc3t+s6H0UVxnzSpNhlbvN6ntBKap8aFaayC8uCG+YgOzVpKLSR3Ge
alIafUhp0GBRTW/4UUYR/7vK2Kgklt+qXFXOGivfnKymWaPSQFYtzZw2p7A8
n8LmLhBEKak+ej9NfpUwdy/y69vVK08uXDzg9mOe/6KUZL7kyfLc2Oz5b9D1
eIYe4fjvPzv18tdpGPN84g+ff2vsy2//6+SaUK9OH51789vuFL/41k8WJn/m
NKwTpSrVtYySfue3VlT+TTKS/kuo0m8kV8Mt79kddcFGvTR3/BM8V2REJf1u
Rz/pc16jYrv/U4CUeSwI8AkifiC38F64hWV3vavJlX4fie/PPfcAs+YHUtDw
j/DIEk+q1N47zrkymZFNRqeQH1IMXZ6U28a/J9Y2ei+So354lh1SGOX3e6tx
rEatI29tqKvF6f8nrqta6z3lYLWovvbqwtLMb2rW8npQ6N5ru0f99tSh2XMj
3t3txFfnL/yIvtrjUZVWXliae6bsJnVlecpRVf6vtuC6/wIfGGz1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{157, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->8407819]
}, Open  ]],

Cell["\<\
Self-loops are not shown if the graph is specified by an adjacency matrix.\
\>", "MathCaption",
 CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0"},
       {"1", "0", "0", "1", "0", "0"},
       {"0", "0", "0", "2", "0", "0"},
       {"0", "1", "0", "1", "0", "0"},
       {"1", "1", "1", "1", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[40]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.3721930765519931, 1.6756703417588095`}, {0., 
    0.6651221179585963}, {1.4489535189469431`, 1.636011926205641}, {
    1.7419937486769734`, 0.598723486614879}, {0.8475798594912739, 0.}, {
    0.881229395099189, 0.9152000715566394}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 1}, {3, 4}, {5, 2}, {5, 4}, {6, 1}, {6, 2}, {6, 
       3}, {6, 4}, {6, 5}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.3721930765519931, 1.6756703417588095`}, {0., 
     0.6651221179585963}, {1.4489535189469431`, 1.636011926205641}, {
     1.7419937486769734`, 0.598723486614879}, {0.8475798594912739, 0.}, {
     0.881229395099189, 0.9152000715566394}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{188., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{192, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->391719023]
}, Open  ]],

Cell["\<\
This shows self-loops with the diameter as big as the average length of the \
edges.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->735821658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[41]:=",
 CellID->51804372],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.3721930765519931, 1.6756703417588095`}, {0., 
    0.6651221179585963}, {1.4489535189469431`, 1.636011926205641}, {
    1.7419937486769734`, 0.598723486614879}, {0.8475798594912739, 0.}, {
    0.881229395099189, 0.9152000715566394}, {1.722041899878854, 
    0.9582381201746307}, {1.7274507129181222`, 1.0548262544284435`}, {
    1.7540643630084516`, 1.1478329023951124`}, {1.8005676776292932`, 
    1.232661934373565}, {1.8646625923927795`, 1.3051213356862152`}, {
    1.9431817149901622`, 1.3616303643777754`}, {2.032244848904722, 
    1.3993965015173286`}, {2.1274507419248754`, 1.4165534497121974`}, {
    2.2240945837796, 1.412253360331105}, {2.3174005047683397`, 
    1.3867087318239342`}, {2.4027575859501615`, 1.341181908639726}, {
    2.475947717925433, 1.277922699677167}, {2.5333540480631727`, 
    1.2000571989901285`}, {2.572139715292222, 1.1114333029195782`}, {
    2.5903880398802763`, 1.016430557765265}, {2.587197240412054, 
    0.919743734796052}, {2.5627249973171446`, 0.8261508277195543}, {
    2.5181806607420096`, 0.7402769375304669}, {2.4557654878314166`, 
    0.6663657128912613}, {2.378563862726537, 0.6080696408255385}, {
    2.2903908748846615`, 0.5682695509743482}, {2.1956037879757755`, 
    0.5489322530128007}, {2.0988867160384395`, 0.5510133423896362}, {
    2.044614060119224, 0.40360866114879396`}, {2.1195886451392303`, 
    0.3424749181077842}, {2.1792048999775804`, 0.26628814040866383`}, {
    2.220516755234726, 0.17881326657429336`}, {2.241482693996501, 
    0.08437306142328874}, {2.241066637918395, -0.01236550293687814}, {
    2.219289147333886, -0.1066218758830507}, {
    2.1772264052199812`, -0.193738169783707}, {
    2.116957035229558, -0.26940933984261217`}, {
    2.041459381895333, -0.32989592743152724`}, {
    1.954464329131916, -0.3722088537285428}, {
    1.8602709303359595`, -0.39425713167472654`}, {
    1.7635339611317402`, -0.3949511967352696}, {
    1.6690338933142481`, -0.3742567501464923}, {
    1.5814406572373327`, -0.3331964538652908}, {
    1.505082866852228, -0.2737993934613377}, {
    1.4437339116528023`, -0.1990008063552624}, {
    1.4004254862682697`, -0.11249703055421059`}, {
    1.377297772551951, -0.018562841914597384`}, {1.3754936777503006`, 
    0.07815979338383179}, {1.3951023552075437`, 0.17289111188782016`}, {
    1.435154798655523, 0.2609497554781733}, {1.493671727806686, 
    0.33798411105958936`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 1}, {4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 
        16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 4}, {4, 30, 
        31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
        48, 49, 50, 51, 52, 4}, {5, 4}, {5, 2}, {6, 4}, {6, 2}, {6, 1}, {6, 
        3}, {6, 5}}]}, {InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.3721930765519931, 1.6756703417588095`}, {0., 
     0.6651221179585963}, {1.4489535189469431`, 1.636011926205641}, {
     1.7419937486769734`, 0.598723486614879}, {0.8475798594912739, 0.}, {
     0.881229395099189, 0.9152000715566394}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{184., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{188, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[41]=",
 CellID->1826611455]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexCoordinateRules", "Subsection",
 CellTags->"b:0.1",
 CellID->405721262],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 " specifies the coordinates of the vertices. Possible values are",
 " ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", a list of coordinates, or a list of rules specifying the coordinates of \
selected or all vertices."
}], "Text",
 CellTags->"b:0.1",
 CellID->544211538],

Cell["This draws the Petersen graph using known coordinates.", "MathCaption",
 CellTags->"b:0.1",
 CellID->369012665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"8", "\[Rule]", "9"}], ",", 
      RowBox[{"9", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "10"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"2", "\[Rule]", "7"}], ",", 
      RowBox[{"3", "\[Rule]", "8"}], ",", 
      RowBox[{"4", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "10"}]}], "}"}],
    Short[#, 1000]& ], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.309", ",", "0.951"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.809"}], ",", 
         RowBox[{"-", "0.587"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.309", ",", 
         RowBox[{"-", "0.951"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.809"}], ",", "0.587"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.618", ",", "1.902"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.618"}], ",", "1.175"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.618"}], ",", 
         RowBox[{"-", "1.175"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.618", ",", 
         RowBox[{"-", "1.902"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.`", ",", "0"}], "}"}]}], "}"}],
     Short[#, 1000]& ]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[42]:=",
 CellID->533487069],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.30901699437494745`, 
    0.9510565162951535}, {-0.8090169943749476, -0.587785252292473}, {
    0.30901699437494723`, -0.9510565162951536}, {-0.8090169943749473, 
    0.5877852522924732}, {1., 0.}, {0.6180339887498949, 
    1.902113032590307}, {-1.6180339887498947`, 
    1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
    0.6180339887498945, -1.9021130325903073`}, {2., 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.30901699437494745`, 
     0.9510565162951535}, {-0.8090169943749476, -0.587785252292473}, {
     0.30901699437494723`, -0.9510565162951536}, {-0.8090169943749473, 
     0.5877852522924732}, {1., 0.}, {0.6180339887498949, 
     1.902113032590307}, {-1.6180339887498947`, 
     1.1755705045849465`}, {-1.6180339887498951`, -1.175570504584946}, {
     0.6180339887498945, -1.9021130325903073`}, {2., 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{160., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{164, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[42]=",
 CellID->340296139]
}, Open  ]],

Cell[TextData[{
 "This computes vertex coordinates of the same graph using the ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 " algorithm",
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->25398730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"8", "\[Rule]", "9"}], ",", 
      RowBox[{"9", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "10"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"2", "\[Rule]", "7"}], ",", 
      RowBox[{"3", "\[Rule]", "8"}], ",", 
      RowBox[{"4", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "10"}]}], "}"}],
    Short[#, 1000]& ], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], "]"}]], "Input",\

 CellTags->"b:0.1",
 CellLabel->"In[43]:=",
 CellID->611320946],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.5441166092897437, 1.7290808001413414`}, {
    1.2001880590966867`, 1.7281883976482477`}, {0.8210804320759417, 0.}, {
    0.3218482339362243, 0.19208897427950378`}, {1.6865117231827154`, 
    1.2878487206527054`}, {0.12044128736467352`, 1.3744305143844167`}, {0., 
    0.7515321328026353}, {0.8858209412870136, 0.917384959508828}, {
    1.4333584750586268`, 0.19839682147095472`}, {1.7619907541382775`, 
    0.743543273683796}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.5441166092897437, 1.7290808001413414`}, {
     1.2001880590966867`, 1.7281883976482477`}, {0.8210804320759417, 0.}, {
     0.3218482339362243, 0.19208897427950378`}, {1.6865117231827154`, 
     1.2878487206527054`}, {0.12044128736467352`, 1.3744305143844167`}, {0., 
     0.7515321328026353}, {0.8858209412870136, 0.917384959508828}, {
     1.4333584750586268`, 0.19839682147095472`}, {1.7619907541382775`, 
     0.743543273683796}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{167., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{171, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[43]=",
 CellID->1412939345]
}, Open  ]],

Cell["This specifies coordinates for one vertex.", "MathCaption",
 CellTags->"b:0.1",
 CellID->83658406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "4"}], ",", 
      RowBox[{"4", "\[Rule]", "1"}]}], "}"}],
    Short[#, 1000]& ], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->1886502330],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1., 1.}, {2., 3.}, {0.9854843798327821, 
    2.88239229192817}, {0.48415202229829907`, 1.8821925569869045`}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}, {3, 4}, {4, 1}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1., 1.}, {2., 3.}, {0.9854843798327821, 
     2.88239229192817}, {0.48415202229829907`, 1.8821925569869045`}}]& ],
  AspectRatio->Automatic,
  Frame->True,
  FrameTicks->True,
  ImageSize->{176.804738985367, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->2014049433]
}, Open  ]],

Cell[TextData[{
 "This specifies only ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinates."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->354658770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"1", "\[Rule]", "3"}]}], "}"}],
    Short[#, 1000]& ], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "1"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "1"}], "}"}]}], ",", 
      RowBox[{"3", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "2"}], "}"}]}], ",", 
      RowBox[{"4", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "2"}], "}"}]}], ",", 
      RowBox[{"5", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "2"}], "}"}]}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1842510561],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.868301666051157, 1.}, {3.345178152069519, 
    2.}, {1.4901493470342864`, 1.}, {2.1792255065427217`, 2.}, {
    1.0132728610159243`, 2.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 4}, {3, 4}, {3, 5}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.868301666051157, 1.}, {3.345178152069519, 
     2.}, {1.4901493470342864`, 1.}, {2.1792255065427217`, 2.}, {
     1.0132728610159243`, 2.}}]& ],
  AspectRatio->Automatic,
  Frame->True,
  FrameTicks->True,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->2067145851]
}, Open  ]],

Cell[TextData[{
 "This draws a bipartite graph by fixing ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates. \"Anchors\" are added to connect disconnected components."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->1539446762],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bipartite", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "b"}], ",", 
     RowBox[{"2", "\[Rule]", "a"}], ",", 
     RowBox[{"3", "\[Rule]", "a"}], ",", 
     RowBox[{"3", "\[Rule]", "d"}], ",", 
     RowBox[{"4", "\[Rule]", "c"}], ",", 
     RowBox[{"4", "\[Rule]", "a"}], ",", 
     RowBox[{"4", "\[Rule]", "b"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"bipartite", ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Left", "\[Rule]", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "&"}], ",", "bipartite"}],
       "]"}], ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Right", "\[Rule]", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}], ",", "bipartite"}],
       "]"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->516942635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"left", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"right", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}]}], ",", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "Automatic"}], "}"}]}], ",", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"1", ",", "Automatic"}], "}"}]}]}], "}"}], ")"}], 
           "&"}], ",", "bipartite"}], "]"}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#2", "=!=", "Left"}], "&&", 
         RowBox[{"#2", "=!=", "Right"}]}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1", ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"!", 
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Left", ",", "Right"}], "}"}], ",", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "&&", 
         RowBox[{"!", 
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Left", ",", "Right"}], "}"}], ",", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], ",", 
        RowBox[{"Line", "[", "#1", "]"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->904668580],

Cell[BoxData[
 GraphicsBox[
  TagBox[{{LineBox[{{-1., 0.644655155410459}, {1., 0.8524017257711314}}], 
     LineBox[{{-1., 3.1286520987039004`}, {1., 2.685415965320806}}], 
     LineBox[{{-1., 2.3786292022395523`}, {1., 2.685415965320806}}], 
     LineBox[{{-1., 2.3786292022395523`}, {1., 1.6800777434366059`}}], 
     LineBox[{{-1., 1.7269971877174135`}, {1., 2.1347046173874284`}}], 
     LineBox[{{-1., 1.7269971877174135`}, {1., 2.685415965320806}}], 
     LineBox[{{-1., 1.7269971877174135`}, {1., 
      0.8524017257711314}}], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}}, {InsetBox["1", {-1., 0.644655155410459},
      Background->GrayLevel[1]], InsetBox["b", {1., 0.8524017257711314},
      Background->GrayLevel[1]], InsetBox["2", {-1., 3.1286520987039004`},
      Background->GrayLevel[1]], InsetBox["a", {1., 2.685415965320806},
      Background->GrayLevel[1]], InsetBox["3", {-1., 2.3786292022395523`},
      Background->GrayLevel[1]], InsetBox["d", {1., 1.6800777434366059`},
      Background->GrayLevel[1]], InsetBox["4", {-1., 1.7269971877174135`},
      Background->GrayLevel[1]], InsetBox["c", {1., 2.1347046173874284`},
      Background->GrayLevel[1]], {}, {}}},
   Annotation[#, 
    VertexCoordinateRules -> {{-1., 0.644655155410459}, {1., 
     0.8524017257711314}, {-1., 3.1286520987039004`}, {1., 
     2.685415965320806}, {-1., 2.3786292022395523`}, {1., 
     1.6800777434366059`}, {-1., 1.7269971877174135`}, {1., 
     2.1347046173874284`}, {-1.6987860440426268`, 1.902707515900454}, {
     1.7940574279664374`, 1.7588638953744478`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{167.02136100743564`, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{171, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1496599589]
}, Open  ]],

Cell["\<\
When the bipartite graph is connected, it works even better without \
augmenting it with \"Left\" and \"Right\" anchors.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1075574406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"bipartite", ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "Automatic"}], "}"}]}], ",", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"1", ",", "Automatic"}], "}"}]}]}], "}"}], ")"}], "&"}], 
       ",", "bipartite"}], "]"}], "]"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->57634983],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-1., 5.397474910049245}, {1., 
    4.073411004347803}, {-1., -0.7742771888840154}, {
    1., -0.4873503431998326}, {-1., -2.6096624786562903`}, {
    1., -3.9337263844922425`}, {-1., 1.951098868968232}, {1., 
    2.238025714685654}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {5, 4}, {5, 6}, {7, 8}, {7, 4}, {7, 2}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["b",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["a",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["d",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["c",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-1., 5.397474910049245}, {1., 
     4.073411004347803}, {-1., -0.7742771888840154}, {
     1., -0.4873503431998326}, {-1., -2.6096624786562903`}, {
     1., -3.9337263844922425`}, {-1., 1.951098868968232}, {1., 
     2.238025714685654}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{75.64042056448005, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{80, 346},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1966734888]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexLabeling", "Subsection",
 CellTags->"b:0.1"],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 " specifies whether to show vertex names as labels. Possible values for this \
option are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default) and ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", "True"}]], 
  "InlineFormula"],
 " shows the labels. For graphs specified by an adjacency matrix, vertex \
labels are taken to be successive integers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", ",", "2", ",", "\[Ellipsis]", ",", "n"}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the size of the matrix. For graphs specified by a list of rules, labels \
are the expressions used in the rules. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " displays each vertex as a point. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"]}]], "InlineFormula"],
 " displays each vertex as a point, but gives its name in a tooltip. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " displays each vertex as a point, giving its name in a tooltip if the \
number of vertices is not too large. You can also use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["lbl", "TI"]]}], "]"}]], "InlineFormula"],
 " anywhere in the list of rules to specify an alternative tooltip for a \
vertex ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 ". "
}], "Text",
 CellTags->"b:0.1",
 CellID->659301986],

Cell["\<\
This draws the graph with labels given as indices of the adjacency matrix.\
\>", "MathCaption",
 CellID->1601243868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "1", "0", "0", "0"},
      {"0", "0", "0", "0", "0"},
      {"1", "1", "0", "0", "0"},
      {"0", "1", "0", "0", "0"},
      {"0", "1", "0", "0", "0"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[45]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.4322945363076125}, {0.9443685976902727, 
    0.8053683937984101}, {0.002039855487186326, 1.179360021193507}, {
    1.6813210456539793`, 1.6106199560744496`}, {1.6811673587196472`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 1}, {3, 2}, {4, 2}, {5, 2}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.4322945363076125}, {0.9443685976902727, 
     0.8053683937984101}, {0.002039855487186326, 1.179360021193507}, {
     1.6813210456539793`, 1.6106199560744496`}, {1.6811673587196472`, 
     0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{162., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{166, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->801172729]
}, Open  ]],

Cell["This uses the labels specified in the list of rules.", "MathCaption",
 CellID->97622059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<B\>\""}], ",", 
     RowBox[{"\"\<A\>\"", "\[Rule]", "\"\<a\>\""}], ",", 
     RowBox[{"\"\<B\>\"", "\[Rule]", "\"\<C\>\""}], ",", 
     RowBox[{"\"\<C\>\"", "\[Rule]", "\"\<A\>\""}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[46]:=",
 CellID->1544203859],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.114106091981332, 0.4233436731114936}, {
    2.0310932122960255`, 0.8470830608193822}, {0., 0.423442022028793}, {
    2.0314813862038417`, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 3}, {2, 4}, {4, 1}}]}, {
      InsetBox[
       FrameBox["\<\"A\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["\<\"B\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["\<\"a\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["\<\"C\"\>",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.114106091981332, 0.4233436731114936}, {
     2.0310932122960255`, 0.8470830608193822}, {0., 0.423442022028793}, {
     2.0314813862038417`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{162., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{166, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]=",
 CellID->1280748724]
}, Open  ]],

Cell["\<\
This specifies alternative labels for vertices 3 and 5. Place the cursor \
above the vertices to see the labels.\
\>", "MathCaption",
 CellID->1931165082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", 
      RowBox[{"Tooltip", "[", 
       RowBox[{"3", ",", "\"\<number 3\>\""}], "]"}]}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "3"}], ",", 
     RowBox[{"7", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->1876869922],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.036501778392792, 0.}, {1.1690731639707779`, 
    0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
    3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
    1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
    1.2966250642465846`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 5}, {3, 1}, {6, 7}, {6, 5}, {6, 2}, {6, 
       3}}]}, {InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.036501778392792, 0.}, {1.1690731639707779`, 
     0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
     3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
     1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
     1.2966250642465846`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{244., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{248, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->639350348]
}, Open  ]],

Cell["\<\
This plots vertices as points, and displays vertex names in tooltips. Place \
the cursor above the vertices to see the labels.\
\>", "MathCaption",
 CellID->992105691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "3"}], ",", 
     RowBox[{"7", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}]}], "]"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->1385740362],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.036501778392792, 0.}, {1.1690731639707779`, 
    0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
    3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
    1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
    1.2966250642465846`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 5}, {3, 1}, {6, 7}, {6, 5}, {6, 2}, {6, 
       3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.036501778392792, 0.}, {1.1690731639707779`, 
     0.001212502969759166}, {2.1591171605888846`, 1.0132185606387485`}, {
     3.212678181911226, 1.2938098576292074`}, {1.6059139978132668`, 
     1.7039138434713532`}, {1.0523468691746776`, 1.0148265846091196`}, {0., 
     1.2966250642465846`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{243., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{247, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->1753834712]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["VertexRenderingFunction", "Subsection",
 CellTags->"b:0.1",
 CellID->283881111],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " specifies graphical representation of the graph edges. Possible values for \
this option are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", or a function that gives a proper combination of graphics primitives and \
directives. With the default setting of ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", vertices are displayed as points, with their names given in tooltips. "
}], "Text",
 CellID->1022272051],

Cell["\<\
By default, vertices are displayed as points and, for small graphs, labeled \
in tooltips. Point the cursor at a vertex to see the tooltip.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->328737679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"5", "\[Rule]", "3"}], ",", 
    RowBox[{"5", "\[Rule]", "4"}], ",", 
    RowBox[{"6", "\[Rule]", "2"}], ",", 
    RowBox[{"6", "\[Rule]", "4"}], ",", 
    RowBox[{"7", "\[Rule]", "1"}], ",", 
    RowBox[{"7", "\[Rule]", "4"}], ",", 
    RowBox[{"7", "\[Rule]", "5"}], ",", 
    RowBox[{"7", "\[Rule]", "6"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[49]:="],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.0076902354289485`, 1.6517610519810615`}, {0., 
    1.9452109980952486`}, {1.9264398587050013`, 1.8098735783474036`}, {
    2.8443264130714514`, 1.652243896522438}, {3.8508026568364793`, 
    1.9466630712533632`}, {1.9259016684523775`, 1.066480305484164}, {
    1.9279705930790716`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 5}, {4, 3}, {6, 7}, {6, 3}, {6, 1}, {6, 
       4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.0076902354289485`, 1.6517610519810615`}, {0.,
      1.9452109980952486`}, {1.9264398587050013`, 1.8098735783474036`}, {
     2.8443264130714514`, 1.652243896522438}, {3.8508026568364793`, 
     1.9466630712533632`}, {1.9259016684523775`, 1.066480305484164}, {
     1.9279705930790716`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{194., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{198, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->1809798549]
}, Open  ]],

Cell["This draws no vertices at all.", "MathCaption",
 CellTags->"b:0.1",
 CellID->1311086603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "1"}], ",", 
     RowBox[{"7", "\[Rule]", "4"}], ",", 
     RowBox[{"7", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->271336278],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.0076902354289485`, 1.6517610519810615`}, {0., 
    1.9452109980952486`}, {1.9264398587050013`, 1.8098735783474036`}, {
    2.8443264130714514`, 1.652243896522438}, {3.8508026568364793`, 
    1.9466630712533632`}, {1.9259016684523775`, 1.066480305484164}, {
    1.9279705930790716`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 5}, {4, 3}, {6, 7}, {6, 3}, {6, 1}, {6, 
       4}}]}, 
     {RGBColor[0, 0, 0.7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.0076902354289485`, 1.6517610519810615`}, {0.,
      1.9452109980952486`}, {1.9264398587050013`, 1.8098735783474036`}, {
     2.8443264130714514`, 1.652243896522438}, {3.8508026568364793`, 
     1.9466630712533632`}, {1.9259016684523775`, 1.066480305484164}, {
     1.9279705930790716`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{237., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{241, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->407835845]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each vertex is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["i", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the coordinate of the vertex and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the label of the vertex. Explicit settings for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1"],

Cell["This shows vertices as yellow disks.", "MathCaption",
 CellTags->"b:0.1",
 CellID->1113992127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"8", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "9"}], ",", 
     RowBox[{"2", "\[Rule]", "9"}], ",", 
     RowBox[{"3", "\[Rule]", "10"}], ",", 
     RowBox[{"4", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "11"}], ",", 
     RowBox[{"5", "\[Rule]", "11"}], ",", 
     RowBox[{"7", "\[Rule]", "12"}], ",", 
     RowBox[{"8", "\[Rule]", "12"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "Yellow", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"#1", ",", "0.2"}], "]"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[51]:=",
 CellID->1950334],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.8391269830789694, 0.12138662951413726`}, {
      0.1142773945894231, 0.8563072202606672}, {0.11969485730565244`, 
      2.084180918103611}, {0.8517429114949044, 2.808668600780761}, {
      2.079311907483209, 2.800777504695416}, {2.8052846635151383`, 
      2.067147543676492}, {2.7999444377920746`, 0.8387393724669082}, {
      2.066623718278995, 0.11376009579341195`}, {0., 0.01849001411169393}, {
      0.01439321512867564, 2.9223345263640246`}, {2.918180466418588, 
      2.9043984501897935`}, {2.9043104168861964`, 0.}}, 
      {RGBColor[0.5, 0., 0.], 
       LineBox[{{1, 2}, {1, 9}, {2, 3}, {2, 9}, {3, 4}, {3, 10}, {4, 5}, {4, 
        10}, {5, 6}, {5, 11}, {6, 7}, {6, 11}, {7, 8}, {7, 12}, {8, 1}, {8, 
        12}}]}], {
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8391269830789694, 0.12138662951413726`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["1", {0.8391269830789694, 0.12138662951413726`}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.1142773945894231, 0.8563072202606672}, 0.2], 
       {GrayLevel[0], 
        InsetBox["2", {0.1142773945894231, 0.8563072202606672}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.11969485730565244`, 2.084180918103611}, 0.2], 
       {GrayLevel[0], 
        InsetBox["3", {0.11969485730565244`, 2.084180918103611}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.8517429114949044, 2.808668600780761}, 0.2], 
       {GrayLevel[0], 
        InsetBox["4", {0.8517429114949044, 2.808668600780761}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.079311907483209, 2.800777504695416}, 0.2], 
       {GrayLevel[0], 
        InsetBox["5", {2.079311907483209, 2.800777504695416}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.8052846635151383`, 2.067147543676492}, 0.2], 
       {GrayLevel[0], 
        InsetBox["6", {2.8052846635151383`, 2.067147543676492}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.7999444377920746`, 0.8387393724669082}, 0.2], 
       {GrayLevel[0], 
        InsetBox["7", {2.7999444377920746`, 0.8387393724669082}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.066623718278995, 0.11376009579341195`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["8", {2.066623718278995, 0.11376009579341195`}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0., 0.01849001411169393}, 0.2], 
       {GrayLevel[0], InsetBox["9", {0., 0.01849001411169393}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{0.01439321512867564, 2.9223345263640246`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["10", {0.01439321512867564, 2.9223345263640246`}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.918180466418588, 2.9043984501897935`}, 0.2], 
       {GrayLevel[0], 
        InsetBox["11", {2.918180466418588, 2.9043984501897935`}]}}, 
      {RGBColor[1, 1, 0], EdgeForm[GrayLevel[0]], 
       DiskBox[{2.9043104168861964`, 0.}, 0.2], 
       {GrayLevel[0], InsetBox["12", {2.9043104168861964`, 0.}]}}}},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8391269830789694, 0.12138662951413726`}, {
     0.1142773945894231, 0.8563072202606672}, {0.11969485730565244`, 
     2.084180918103611}, {0.8517429114949044, 2.808668600780761}, {
     2.079311907483209, 2.800777504695416}, {2.8052846635151383`, 
     2.067147543676492}, {2.7999444377920746`, 0.8387393724669082}, {
     2.066623718278995, 0.11376009579341195`}, {0., 0.01849001411169393}, {
     0.01439321512867564, 2.9223345263640246`}, {2.918180466418588, 
     2.9043984501897935`}, {2.9043104168861964`, 0.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{179., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{183, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[51]=",
 CellID->337497063]
}, Open  ]],

Cell["This renders vertices using a predefined graphic.", "MathCaption",
 CellID->1304032312],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", " ", "=", " ", 
   GraphicsBox[{{}, 
     GeometricTransformationBox[
      RasterBox[{{146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 
       146, 146, 146, 146, 146}, {146, 146, 146, 146, 146, 146, 86, 86, 86, 
       86, 86, 146, 146, 146, 146, 146, 146}, {146, 146, 146, 146, 102, 128, 
       114, 56, 48, 54, 108, 124, 98, 146, 146, 146, 146}, {146, 146, 146, 
       111, 130, 119, 76, 50, 63, 60, 68, 117, 134, 106, 146, 146, 146}, {146,
        146, 84, 95, 78, 46, 47, 57, 57, 65, 65, 80, 105, 115, 90, 146, 
       146}, {146, 146, 45, 23, 35, 43, 48, 48, 48, 53, 65, 67, 71, 74, 83, 
       146, 146}, {146, 61, 26, 28, 42, 42, 42, 66, 107, 118, 122, 97, 70, 79,
        75, 86, 146}, {146, 20, 22, 30, 40, 37, 31, 93, 144, 144, 144, 129, 
       77, 69, 69, 86, 146}, {146, 36, 92, 39, 21, 25, 32, 110, 144, 140, 144,
        138, 94, 44, 72, 86, 146}, {146, 113, 136, 99, 29, 14, 41, 125, 144, 
       141, 144, 144, 96, 38, 103, 86, 146}, {146, 112, 139, 137, 82, 8, 17, 
       64, 121, 142, 142, 101, 33, 33, 120, 86, 146}, {146, 146, 131, 143, 81,
        6, 11, 2, 18, 88, 87, 19, 9, 27, 100, 146, 146}, {146, 146, 104, 123, 
       59, 4, 7, 3, 1, 1, 1, 5, 5, 24, 85, 146, 146}, {146, 146, 146, 62, 15, 
       1, 1, 12, 55, 89, 52, 13, 10, 51, 146, 146, 146}, {146, 146, 146, 146, 
       49, 16, 34, 116, 133, 145, 132, 91, 58, 146, 146, 146, 146}, {146, 146,
        146, 146, 146, 146, 73, 126, 135, 127, 109, 146, 146, 146, 146, 146, 
       146}, {146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146, 146,
        146, 146, 146, 146}}, {{0, 0}, {17, 17}},
       ColorFunction->(Apply[RGBColor, 
         Part[CompressedData["
1:eJztl8mOHEUQhhvkB2AxuzHiFdhX5yuAzb5KSJxBCJBYZDhy9DK2x/Z4OXDg
hGzANvKMZ2yBLbMYa7p7etz7TK/TPd0NeF84QETkH6WKVGEu3Oq7hLq+yMis
qsys7Pvfemft2zdm/uGGTGZFBvzhkuJCnfj9ut7GpLyjM0TkP2Oi63v3EJF/
k4m8bQ+PeB8T+TeYkROiPPj1zMjVa8TI7dlNjBK9rQ8/M00kt7cRfjUzcmuY
kf6Gf5oZ6nXcD3ytSgzd9BFiqL/hqxVi4HbvIoZ6H0kedeDvZYY6jteZsD48
8uGfYgbazt7/X9eIZa2DCP8aM3BHpoiB2zVBDIL6uI58+KlJYjnIg5/YSSy7
VUzY3nqM1/pKmYgi/LWrRF+vP8lEvlwi+jpO9AM/eZjoaz9J7V9llt0nTOjR
znqMD/4eJvQ2wn/M9LUfjNeOH9G2f4VJ9jt3EP2gDvzVK0Qv0ZeKROQxXviX
mZ57gulrf/CPMz3tZ8d2oqf+ymViyX3E9LQe/F1MT+vgN/yZeaKrdez4X2KW
1BfPEEvqvz9EdN1jzJK7k4n8+Daiq9cvXyK66p9n2uo/ZaL59yLT1TqI8Lcx
bb0PrDP4O5iue5Tpaj34SxeJjuZZ/yHT0bz5AtFRj9+IyIM/dJDoBHnwLzAd
zUOE/+5boqntsE5te4wTEf52Jrq+bSsR+bHNRFOv2/m/kmm5R5hOMP8OHiDa
7uIFoq392fdbmCOiPNse3rb/gIk8oq2PPNSDv3CeaGkeIvzDTDvRoz3mGWKS
t+23jBGtIMKvZRpuLk+0gvX1PhO1Qx78c0wryLPvDx758A8xyf78OaKp15Fv
PfpBTPK2/jqm6fI5ohm0f5Bp6jqw/d/CNHQe2/kl57m6O3eWaAT7j5zH6i6X
JRrB/iXf64p67NO2/weYhr5P+Owssajx7J/Eovpv9hORRz14+a6V3M3MYrB/
yHmq5vbvIxbce0zU/hlmwW3cQCxoHrycF2v6HPC84OW8V9N+kA8v571qUAde
znVVf36saT68nLcq/nxW1Qgv91vQdnb+y3mh7M8tFX1f8HczJX/+KQf3h/Zy
vin7c0zZrN+85mEe2Po2wst+MOe/6yV93/ByPihqO+TF12/en1NKwfyS731R
o+zPRfP9nPff/dDL+supf5aJxrd1CzHnvzMF/50oqJd5Oate/p/UAy/7ekHn
E7y8z7z2I9/hebO/5TUPzxNe1n1O3xPmi31+sr/k9De8vM+su5XJaT3rbV58
fc+6zZuIrH8/WbM/ZNUjwsvzntWIevb5ISIPXv7vnPLr7JRfh7+pl/d1Qj2e
Z3z+/uzXz69aD172w5Nu+zhx0q+TX8z54oSfPz/593/ajP+YjkPW32mzvn70
7/+4/44eVy/1ZtymjcQx//x/MOM/7Pe3o1onvr4n/f1NaT146e9AEOFvYvbp
ddnHps3/5681Ij8+/77UKM/zK1N/b6KXcU9oRH68/phG5MXf33iQF+9/g15H
frz9F5qHCJ/xyPXPg/qZf8W2f1f7i/ukeD3+e/+pT33qU5/61Kc+9alPfepT
n/r/1/8NYarCTQ==
          "], #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{17, 17},
    PlotRange->{{0, 17}, {0, 17}}]}], ";"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->876584969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "\[Rule]", "2"}], ",", 
     RowBox[{"4", "\[Rule]", "3"}], ",", 
     RowBox[{"5", "\[Rule]", "1"}], ",", 
     RowBox[{"5", "\[Rule]", "3"}], ",", 
     RowBox[{"6", "\[Rule]", "1"}], ",", 
     RowBox[{"6", "\[Rule]", "2"}], ",", 
     RowBox[{"6", "\[Rule]", "4"}], ",", 
     RowBox[{"6", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"gr", ",", "#1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->280649582],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->164359319]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common Suboptions of All Methods ", "Section",
 CellTags->{"method_option_forced_directed", "b:0.1"},
 CellID->720389883],

Cell[TextData[{
 "All graph drawing methods accept the method suboption ",
 Cell[BoxData["\"\<Rotation\>\""], "InlineFormula"],
 ", which specifies the desired amount of clockwise rotation in radians from \
the default orientation. The option takes any numeric values, or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". The default is 0. "
}], "Text",
 ShowStringCharacters->True,
 CellTags->"b:0.1",
 CellID->2015612515],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ", the default orientation is derived by an alignment step where the \
principal axis is found and the graph drawing is aligned with the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinate. However if ",
 Cell[BoxData[
  RowBox[{"\"\<Rotation\>\"", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is specified, this step is skipped."
}], "Text",
 ShowStringCharacters->True,
 CellTags->"b:0.1",
 CellID->328066750],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"\"\<Rotation\>\"", "0", Cell[
    "amount of clockwise rotation to apply to the drawing", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->{"S3.8.2", "b:0.1"},
 CellID->896449417],

Cell["Common suboptions for all methods.", "Caption",
 CellTags->"b:0.1",
 CellID->666594119],

Cell[TextData[{
 "This rotates a plot of a graph by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["\[Pi]", "TR"], "/", "2"}]], "InlineFormula",
  ShowStringCharacters->False],
 ", ",
 Cell[BoxData["0"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", 
    StyleBox["\[Pi]", "TR"]}], "/", "2"}]], "InlineFormula"],
 " clockwise",
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->179929672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"GraphPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"4", "\[Rule]", "3"}], ",", 
        RowBox[{"5", "\[Rule]", "3"}], ",", 
        RowBox[{"5", "\[Rule]", "4"}], ",", 
        RowBox[{"6", "\[Rule]", "3"}], ",", 
        RowBox[{"6", "\[Rule]", "4"}], ",", 
        RowBox[{"6", "\[Rule]", "5"}], ",", 
        RowBox[{"7", "\[Rule]", "1"}], ",", 
        RowBox[{"7", "\[Rule]", "2"}], ",", 
        RowBox[{"7", "\[Rule]", "3"}], ",", 
        RowBox[{"7", "\[Rule]", "4"}], ",", 
        RowBox[{"7", "\[Rule]", "5"}], ",", 
        RowBox[{"7", "\[Rule]", "6"}]}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Automatic\>\"", ",", 
         RowBox[{"\"\<Rotation\>\"", "\[Rule]", "rot"}]}], "}"}]}]}], "]"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"rot", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "Pi"}], "/", "2"}], ",", "0", ",", 
        RowBox[{"Pi", "/", "2"}]}], "}"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26550486],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0.3424308475772724, 0.5503681702276014}, {
        1.1160751191591594`, 0.0020374970992195207`}, {0.4896909123651999, 
        0.}, {1.2630694031121643`, 0.5492410815885727}, {0.8028808806176642, 
        1.2481209142340521`}, {1.603846814556103, 2.3274046414099314`}, {0., 
        2.3245292350032}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0.3424308475772724, 0.5503681702276014}, {
         1.1160751191591594`, 0.0020374970992195207`}, {0.4896909123651999, 
         0.}, {1.2630694031121643`, 0.5492410815885727}, {0.8028808806176642, 
         1.2481209142340521`}, {1.603846814556103, 2.3274046414099314`}, {0., 
         2.3245292350032}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], {13.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0.5503681702276013, 1.26141596697883}, {
        0.0020374970992198538`, 0.48777169539694315`}, {0., 
        1.1141559021909024`}, {0.5492410815885729, 0.34077741144393814`}, {
        1.2481209142340521`, 0.8009659339384386}, {2.327404641409932, 0.}, {
        2.3245292350032, 1.603846814556103}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0.5503681702276013, 1.26141596697883}, {
         0.0020374970992198538`, 0.48777169539694315`}, {0., 
         1.1141559021909024`}, {0.5492410815885729, 0.34077741144393814`}, {
         1.2481209142340521`, 0.8009659339384386}, {2.327404641409932, 0.}, {
         2.3245292350032, 1.603846814556103}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], {400.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.2614159669788296`, 1.7770364711823305`}, {
        0.48777169539694254`, 2.325367144310712}, {1.1141559021909018`, 
        2.327404641409932}, {0.34077741144393764`, 1.7781635598213588`}, {
        0.8009659339384383, 1.0792837271758795`}, {0., 0.}, {
        1.603846814556103, 0.002875406406731784}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.2614159669788296`, 
         1.7770364711823305`}, {0.48777169539694254`, 2.325367144310712}, {
         1.1141559021909018`, 2.327404641409932}, {0.34077741144393764`, 
         1.7781635598213588`}, {0.8009659339384383, 1.0792837271758795`}, {0.,
          0.}, {1.603846814556103, 0.002875406406731784}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], {787.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}]}, {{}, 
    StyleBox[{{}, {}, {}, {}, {{}, {}, {}}, {{}, {}, {}}},
     Antialiasing->False]}},
  PlotRange->{{0, 1161.}, {0, -378.}},
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->907534885]
}, Open  ]],

Cell["This shows the evolution of a graph layout process.", "MathCaption",
 CellTags->"b:0.1",
 CellID->442928912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"GraphPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"4", "\[Rule]", "3"}], ",", 
          RowBox[{"5", "\[Rule]", "3"}], ",", 
          RowBox[{"5", "\[Rule]", "4"}], ",", 
          RowBox[{"6", "\[Rule]", "3"}], ",", 
          RowBox[{"6", "\[Rule]", "4"}], ",", 
          RowBox[{"6", "\[Rule]", "5"}], ",", 
          RowBox[{"7", "\[Rule]", "1"}], ",", 
          RowBox[{"7", "\[Rule]", "2"}], ",", 
          RowBox[{"7", "\[Rule]", "3"}], ",", 
          RowBox[{"7", "\[Rule]", "4"}], ",", 
          RowBox[{"7", "\[Rule]", "5"}], ",", 
          RowBox[{"7", "\[Rule]", "6"}]}], "}"}], ",", 
        RowBox[{"Method", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
           RowBox[{"\"\<Rotation\>\"", "\[Rule]", "False"}], ",", 
           RowBox[{"\"\<RecursionMethod\>\"", "\[Rule]", "None"}], ",", 
           RowBox[{"MaxIterations", "\[Rule]", "i"}]}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "15"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->195129566],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.8354879846693741`, 2.309766272768702}, {
        0.4362799407107154, 1.776200762645008}, {0.6610601462480888, 
        1.7748704351733697`}, {0.8965859455309401, 1.8817975993669576`}, {
        1.0720474637139408`, 1.393741576082677}, {0.10348524924734581`, 0.}, {
        0., 1.0751779845576044`}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.8354879846693741`, 2.309766272768702}, {
         0.4362799407107154, 1.776200762645008}, {0.6610601462480888, 
         1.7748704351733697`}, {0.8965859455309401, 1.8817975993669576`}, {
         1.0720474637139408`, 1.393741576082677}, {0.10348524924734581`, 
         0.}, {0., 1.0751779845576044`}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.0073508748763047`, 1.5572620813689997`}, {0., 
        2.246719908022187}, {0.7017654654545195, 2.678088029262503}, {
        0.7872094837973443, 2.7178225945427665`}, {0.5216500214432661, 
        2.00678529213223}, {0.541350504384211, 1.389229181232289}, {
        0.5268655882154318, 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.0073508748763047`, 
         1.5572620813689997`}, {0., 2.246719908022187}, {0.7017654654545195, 
         2.678088029262503}, {0.7872094837973443, 2.7178225945427665`}, {
         0.5216500214432661, 2.00678529213223}, {0.541350504384211, 
         1.389229181232289}, {0.5268655882154318, 0.}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0.861104351266633, 1.4164761816503182`}, {
        0.7420041355896774, 1.88350473895795}, {0., 1.6025895073632341`}, {
        0.7039201344397616, 2.2239634785518048`}, {0.14729084975071316`, 
        0.5251370087131637}, {0.7246378495454573, 0.09418879272194824}, {
        0.24848336676601304`, 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0.861104351266633, 1.4164761816503182`}, {
         0.7420041355896774, 1.88350473895795}, {0., 1.6025895073632341`}, {
         0.7039201344397616, 2.2239634785518048`}, {0.14729084975071316`, 
         0.5251370087131637}, {0.7246378495454573, 0.09418879272194824}, {
         0.24848336676601304`, 0.}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 1.0116602215003174`}, {0.6113444986140995, 
        0.73550360995221}, {1.2873700088843383`, 1.9889388261713488`}, {
        0.7901808512069516, 1.373376753642596}, {0.9347774601204406, 
        1.1043777090288178`}, {1.8928187112569441`, 0.2097973539156902}, {
        0.7662573773196737, 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 1.0116602215003174`}, {
         0.6113444986140995, 0.73550360995221}, {1.2873700088843383`, 
         1.9889388261713488`}, {0.7901808512069516, 1.373376753642596}, {
         0.9347774601204406, 1.1043777090288178`}, {1.8928187112569441`, 
         0.2097973539156902}, {0.7662573773196737, 0.}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 1.5909029289118382`}, {0.35894291509634946`, 
        0.8236064124177778}, {0.9126690945044349, 1.909605642620357}, {
        0.7523679963158587, 2.0763004308234168`}, {0.7009229431836528, 
        1.5267776153162427`}, {1.7897913784728225`, 1.307080358840604}, {
        1.756822183755824, 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 1.5909029289118382`}, {
         0.35894291509634946`, 0.8236064124177778}, {0.9126690945044349, 
         1.909605642620357}, {0.7523679963158587, 2.0763004308234168`}, {
         0.7009229431836528, 1.5267776153162427`}, {1.7897913784728225`, 
         1.307080358840604}, {1.756822183755824, 0.}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]},
    {
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 1.5989987679570683`}, {0.6813173761718698, 
        1.204932735264231}, {1.0642842445246163`, 1.2915116172934087`}, {
        0.8873228248477152, 2.0898773918593903`}, {0.7953916758007418, 
        0.9401142669852091}, {2.1300421586989535`, 1.0939724907780315`}, {
        2.2485434727033935`, 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 1.5989987679570683`}, {
         0.6813173761718698, 1.204932735264231}, {1.0642842445246163`, 
         1.2915116172934087`}, {0.8873228248477152, 2.0898773918593903`}, {
         0.7953916758007418, 0.9401142669852091}, {2.1300421586989535`, 
         1.0939724907780315`}, {2.2485434727033935`, 0.}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 1.3972500732972348`}, {0.8101591601419674, 
        1.09548389546721}, {1.3581981973998907`, 1.4219672744428058`}, {
        0.9036737457820535, 1.6466562324862877`}, {1.120489527418093, 
        1.1228166029654878`}, {2.523355602876947, 1.1759776383821}, {
        2.677740983471305, 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 1.3972500732972348`}, {
         0.8101591601419674, 1.09548389546721}, {1.3581981973998907`, 
         1.4219672744428058`}, {0.9036737457820535, 1.6466562324862877`}, {
         1.120489527418093, 1.1228166029654878`}, {2.523355602876947, 
         1.1759776383821}, {2.677740983471305, 0.}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 0.8383258850050276}, {0.6561389432520623, 
        0.07997727968173884}, {1.189694973676867, 1.274713173848927}, {
        0.7437545514498732, 1.2200432781643582`}, {0.8703169223676519, 
        0.6264803714989009}, {2.0255875263457424`, 0.9268786258560966}, {
        2.140580537805196, 0.}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 0.8383258850050276}, {
         0.6561389432520623, 0.07997727968173884}, {1.189694973676867, 
         1.274713173848927}, {0.7437545514498732, 1.2200432781643582`}, {
         0.8703169223676519, 0.6264803714989009}, {2.0255875263457424`, 
         0.9268786258560966}, {2.140580537805196, 0.}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 0.8872826870595891}, {0.3702506531607985, 
        0.}, {0.9580044758026635, 1.1760594980899788`}, {0.468786452590985, 
        1.2799619140291512`}, {0.6210088096384995, 0.6919415131455487}, {
        1.9418769828229827`, 1.1615184977689317`}, {2.068161414946892, 
        0.11573447073825527`}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 0.8872826870595891}, {
         0.3702506531607985, 0.}, {0.9580044758026635, 1.1760594980899788`}, {
         0.468786452590985, 1.2799619140291512`}, {0.6210088096384995, 
         0.6919415131455487}, {1.9418769828229827`, 1.1615184977689317`}, {
         2.068161414946892, 0.11573447073825527`}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 0.8851121281512746}, {0.368607524754629, 
        0.}, {0.9670787045122817, 1.0073979906389372`}, {0.466937274225156, 
        1.3609292316894677`}, {0.6189523386278185, 0.6671388206560596}, {
        1.9376010070759948`, 1.3178483641632508`}, {2.0640288629351384`, 
        0.2852359506473723}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 0.8851121281512746}, {
         0.368607524754629, 0.}, {0.9670787045122817, 1.0073979906389372`}, {
         0.466937274225156, 1.3609292316894677`}, {0.6189523386278185, 
         0.6671388206560596}, {1.9376010070759948`, 1.3178483641632508`}, {
         2.0640288629351384`, 0.2852359506473723}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]},
    {
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 1.005879726953416}, {0.3697208405889786, 
        0.}, {0.9748176214548214, 0.8670856858530795}, {0.4611356985274298, 
        1.3779043652557659`}, {0.6055172905361288, 0.7839995091588303}, {
        1.8999083557186767`, 1.5565604110407225`}, {2.018873779020261, 
        0.45490720299080073`}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 1.005879726953416}, {
         0.3697208405889786, 0.}, {0.9748176214548214, 0.8670856858530795}, {
         0.4611356985274298, 1.3779043652557659`}, {0.6055172905361288, 
         0.7839995091588303}, {1.8999083557186767`, 1.5565604110407225`}, {
         2.018873779020261, 0.45490720299080073`}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 0.9255125087505407}, {0.3564082349914468, 
        0.}, {1.0325894176233947`, 0.4071736965714195}, {0.44880549002936315`,
         1.2678933198509692`}, {0.5930744807970381, 0.9383899826517761}, {
        1.8513050055488662`, 1.7066677486272714`}, {1.9678527894964346`, 
        0.6460912660268964}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 0.9255125087505407}, {
         0.3564082349914468, 0.}, {1.0325894176233947`, 0.4071736965714195}, {
         0.44880549002936315`, 1.2678933198509692`}, {0.5930744807970381, 
         0.9383899826517761}, {1.8513050055488662`, 1.7066677486272714`}, {
         1.9678527894964346`, 0.6460912660268964}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 0.7919367023465871}, {0.3222309869304616, 
        0.}, {1.025163869072895, 0.14718926448606084`}, {0.39986711986147067`,
         1.2963956538916908`}, {0.6284802407467399, 0.5995329618079617}, {
        1.756976926794852, 1.534685405185654}, {1.8676681074326191`, 
        0.5276981155006556}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 0.7919367023465871}, {
         0.3222309869304616, 0.}, {1.025163869072895, 0.14718926448606084`}, {
         0.39986711986147067`, 1.2963956538916908`}, {0.6284802407467399, 
         0.5995329618079617}, {1.756976926794852, 1.534685405185654}, {
         1.8676681074326191`, 0.5276981155006556}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 0.8524575281943756}, {0.33935591915142116`, 
        0.}, {1.071164141600186, 0.1403588705920027}, {0.5223962530233053, 
        1.035873582376532}, {0.6572788555932857, 1.0097697203532119`}, {
        1.8246223342106553`, 1.9566514168832263`}, {1.9326004346764445`, 
        0.8580514662699348}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 0.8524575281943756}, {
         0.33935591915142116`, 0.}, {1.071164141600186, 0.1403588705920027}, {
         0.5223962530233053, 1.035873582376532}, {0.6572788555932857, 
         1.0097697203532119`}, {1.8246223342106553`, 1.9566514168832263`}, {
         1.9326004346764445`, 0.8580514662699348}}]& ],
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 0.8081726193792559}, {0.32573029776852747`, 
        0.}, {1.0415815330634872`, 0.13405063000181705`}, {
        0.48175101903715045`, 1.161077049796915}, {0.7728817879223352, 
        0.6519297518251668}, {1.8258177477688722`, 1.7532354175259566`}, {
        2.1215553542049173`, 0.6052374330921474}}, {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 2}, {3, 2}, {3, 1}, {4, 2}, {4, 1}, {4, 3}, {5, 6}, {5,
            7}, {5, 2}, {5, 1}, {5, 3}, {5, 4}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "2"],
           Annotation[#, 2, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 0.8081726193792559}, {
         0.32573029776852747`, 0.}, {1.0415815330634872`, 
         0.13405063000181705`}, {0.48175101903715045`, 1.161077049796915}, {
         0.7728817879223352, 0.6519297518251668}, {1.8258177477688722`, 
         1.7532354175259566`}, {2.1215553542049173`, 0.6052374330921474}}]& ],
      
      AspectRatio->Automatic,
      FrameTicks->None,
      ImageSize->50,
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]}
   }],
  "Grid"]], "Output",
 ImageSize->{286, 243},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->790666738]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Common Suboptions of \"SpringEmbedding\" and \"SpringElectricalEmbedding\" \
Methods\
\>", "Section",
 CellTags->{"method_option_forced_directed", "b:0.1"},
 CellID->155533424],

Cell[TextData[{
 "Both the ",
 Cell[BoxData["SpringEmbedding"], "InlineFormula"],
 " and ",
 Cell[BoxData["SpringElectricalEmbedding"], "InlineFormula"],
 " methods belong to the family of so-called force-directed methods. These \
methods work by calculating the force on each vertex, and iteratively moving \
the vertex along the force in an effort to minimize the overall system\
\[CloseCurlyQuote]s energy. See [8] for algorithmic details. These two \
methods have the following common options. "
}], "Text",
 CellTags->"b:0.1",
 CellID->3022990],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"\"\<EnergyControl\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how the energy function is controlled during minimization ", 
     "TableText"]},
   {"\"\<InferentialDistance\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
cut-off distance beyond which the force calculation ignores inference from \
faraway vertices \
\>", "TableText"]},
   {"MaxIterations", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
maximum number of iterations to be used in attempting to minimize the energy \
\
\>", "TableText"]},
   {"\"\<RandomSeed\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
seed to use in the random generator for initial vertex placement\
\>", "TableText"]},
   {"\"\<RecursionMethod\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether a multilevel algorithm is used to lay out the graph", 
     "TableText"]},
   {"\"\<StepControl\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how step lengths are modified during energy minimization ", 
     "TableText"]},
   {"\"\<StepLength\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "initial step length used in moving the vertices", "TableText"]},
   {"\"\<Tolerance\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
tolerance used in terminating the energy minimization process \
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellTags->{"S3.8.2", "b:0.1"},
 CellID->105886246],

Cell[TextData[{
 "Common suboptions for ",
 Cell[BoxData["SpringEmbedding"], "InlineFormula"],
 " and ",
 Cell[BoxData["SpringElectricalEmbedding"], "InlineFormula"],
 " methods. "
}], "Caption",
 CellTags->"b:0.1",
 CellID->189467971],

Cell[CellGroupData[{

Cell["\"EnergyControl\"", "Subsection",
 CellTags->"b:0.1",
 CellID->395879928],

Cell[TextData[{
 "The suboption ",
 Cell[BoxData["\"\<EnergyControl\>\""], "InlineFormula"],
 " specifies limitations on the total energy of the system during \
minimization. Possible values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData["\"\<Monotonic\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<NonMonotonic\>\""], "InlineFormula"],
 ". When the value is ",
 Cell[BoxData["\"\<Monotonic\>\""], "InlineFormula"],
 ", a step along the force will only be accepted if the energy is lowered. \
When the value is ",
 Cell[BoxData["\"\<NonMonotonic\>\""], "InlineFormula"],
 ", a step along the force will be accepted even if the energy is not \
lowered."
}], "Text",
 CellTags->"b:0.1",
 CellID->937709861]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"InferentialDistance\"", "Subsection",
 CellTags->{"b:0.1", "InferentialDistance"},
 CellID->73926998],

Cell[TextData[{
 "The suboption ",
 Cell[BoxData["\"\<InferentialDistance\>\""], "InlineFormula"],
 " specifies a cut-off distance beyond which the interaction between vertices \
is assumed to be nonexistent. Possible values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default) or a positive numeric value. For the ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 " method, if the graph distance between a vertex ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and a vertex ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " is greater than the option value of ",
 Cell[BoxData["\"\<InferentialDistance\>\""], "InlineFormula"],
 ", the repulsive and attractive spring force between ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " is ignored. For the ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 " method, if the Euclidean distance between a vertex ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and a vertex ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " is greater than the option value of ",
 Cell[BoxData["\"\<InferentialDistance\>\""], "InlineFormula"],
 ", the repulsive force between ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " is ignored. "
}], "Text",
 CellTags->"b:0.1",
 CellID->884097504],

Cell[TextData[{
 "This draws a tree using the ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 " method",
 "."
}], "MathCaption",
 CellTags->"b:0.1"],

Cell[BoxData[
 RowBox[{"<<", "Combinatorica`"}]], "Input",
 CellLabel->"In[55]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"RandomTree", "[", "1000", "]"}]}]], "Input",
 CellLabel->"In[56]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[SkeletonIndicator]Graph:<\"\>", "\[InvisibleSpace]", "999", 
   "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", "1000", 
   "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", "\<\"Undirected\"\>", 
   "\[InvisibleSpace]", "\<\">\[SkeletonIndicator]\"\>"}],
  SequenceForm[
  "\[SkeletonIndicator]Graph:<", 999, ", ", 1000, ", ", "Undirected", 
   ">\[SkeletonIndicator]"],
  Editable->False]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[56]=",
 CellID->1612745736]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<SpringElectricalEmbedding\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->1004992162],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->69375313]
}, Open  ]],

Cell[TextData[{
 "This uses a small ",
 Cell[BoxData["\"\<InferentialDistance\>\""], "InlineFormula"],
 " option value; now the graph fills more space",
 "."
}], "MathCaption",
 CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
      RowBox[{"\"\<InferentialDistance\>\"", "\[Rule]", "0.5"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[58]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{396, 250},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->293517146]
}, Open  ]],

Cell[TextData[{
 "A similar effect can be achieved using a smaller (more negative) ",
 Cell[BoxData["\"\<RepulsiveForcePower\>\""], "InlineFormula"],
 " option value (see the ",
 ButtonBox["next section",
  BaseStyle->"Hyperlink",
  ButtonData->"RepulsiveForcePower"],
 ")",
 "."
}], "MathCaption",
 CellTags->"b:0.1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
      RowBox[{"\"\<RepulsiveForcePower\>\"", "\[Rule]", 
       RowBox[{"-", "4"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[59]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[59]=",
 CellID->276163103]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MaxIterations", "Subsection",
 CellTags->"b:0.1",
 CellID->234039913],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 " specifies the maximum number of iterations to be used in attempting to \
minimize the energy. Possible values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default) or a positive integer."
}], "Text",
 CellTags->"b:0.1",
 CellID->476941531]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"RandomSeed\"", "Subsection",
 CellTags->"b:0.1",
 CellID->139703664],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<RandomSeed\>\""], "InlineFormula"],
 " specifies a seed for the random number generator that computes the initial \
vertex placement. Changing this option usually affects the orientation of the \
drawing of the graph, but it can also change the layout. Possible values are \
",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or an integer."
}], "Text",
 CellTags->"b:0.1",
 CellID->153654978],

Cell["\<\
This shows the effect of different random seed values on drawing the Petersen \
graph.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->838968340],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "4"}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"3", "\[Rule]", "5"}], ",", 
      RowBox[{"6", "\[Rule]", "7"}], ",", 
      RowBox[{"7", "\[Rule]", "8"}], ",", 
      RowBox[{"8", "\[Rule]", "9"}], ",", 
      RowBox[{"9", "\[Rule]", "10"}], ",", 
      RowBox[{"6", "\[Rule]", "10"}], ",", 
      RowBox[{"1", "\[Rule]", "6"}], ",", 
      RowBox[{"2", "\[Rule]", "7"}], ",", 
      RowBox[{"3", "\[Rule]", "8"}], ",", 
      RowBox[{"4", "\[Rule]", "9"}], ",", 
      RowBox[{"5", "\[Rule]", "10"}]}], "}"}],
    Short[#, 1000]& ]}], ";"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[60]:=",
 CellID->211116278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
      RowBox[{"\"\<RandomSeed\>\"", "\[Rule]", "Automatic"}]}], "}"}]}], ",", 
   
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[61]:=",
 CellID->589646260],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.0122303406161803`, 1.352991288530645}, {
    1.0343930965768335`, 1.0781020856986554`}, {1.5245407691319455`, 
    1.7096996395289517`}, {0.4054268756553773, 1.7224532054417425`}, {0., 
    0.9909004633439503}, {1.357674407184545, 0.6296220987756667}, {
    0.5119608792059847, 0.6884725970000887}, {1.2340412539002854`, 0.}, {
    1.8101398237419923`, 0.42962544960731214`}, {0.6762312506254575, 
    0.10051765268637802`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.0122303406161803`, 1.352991288530645}, {
     1.0343930965768335`, 1.0781020856986554`}, {1.5245407691319455`, 
     1.7096996395289517`}, {0.4054268756553773, 1.7224532054417425`}, {0., 
     0.9909004633439503}, {1.357674407184545, 0.6296220987756667}, {
     0.5119608792059847, 0.6884725970000887}, {1.2340412539002854`, 0.}, {
     1.8101398237419923`, 0.42962544960731214`}, {0.6762312506254575, 
     0.10051765268637802`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{207., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{211, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[61]=",
 CellID->1756682824]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
      RowBox[{"\"\<RandomSeed\>\"", "\[Rule]", "4321"}]}], "}"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[62]:=",
 CellID->1760315608],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.2201954613037467`, 0.7115653581737844}, {
    0.7089283514321749, 1.6465132901127237`}, {0.8951369746074128, 0.}, {0., 
    0.6728792167761416}, {0.05257997759011457, 1.7847765830861562`}, {
    1.7882291107712183`, 1.6366708088327473`}, {0.8019780962365662, 
    1.084902231240987}, {1.5713864283339656`, 1.2205001878659791`}, {
    1.8240102857776461`, 0.6627584959707827}, {1.2606562710082876`, 
    1.9473462852033872`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {2, 5}, {2, 8}, {3, 9}, {4, 3}, {4, 
       5}, {4, 7}, {5, 10}, {6, 7}, {6, 10}, {7, 8}, {8, 9}, {9, 10}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["8",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8], InsetBox[
       FrameBox["9",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 9], InsetBox[
       FrameBox["10",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 10]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2201954613037467`, 0.7115653581737844}, {
     0.7089283514321749, 1.6465132901127237`}, {0.8951369746074128, 0.}, {0., 
     0.6728792167761416}, {0.05257997759011457, 1.7847765830861562`}, {
     1.7882291107712183`, 1.6366708088327473`}, {0.8019780962365662, 
     1.084902231240987}, {1.5713864283339656`, 1.2205001878659791`}, {
     1.8240102857776461`, 0.6627584959707827}, {1.2606562710082876`, 
     1.9473462852033872`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{210., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{214, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[62]=",
 CellID->905622419]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"RecursionMethod\"", "Subsection",
 CellTags->"b:0.1",
 CellID->116818267],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<RecursionMethod\>\""], "InlineFormula"],
 " specifies whether the graph layout should be produced by a recursive \
procedure. Possible values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData["\"\<Multilevel\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ". In a ",
 Cell[BoxData["\"\<Multilevel\>\""], "InlineFormula"],
 " algorithm, the graph is successively coarsened into graphs with a smaller \
and smaller number of vertices. The coarser graphs are laid out first, and \
those layouts are interpolated into the finer graphs and then further \
refined. "
}], "Text",
 CellTags->"b:0.1",
 CellID->1007989369],

Cell[BoxData[GridBox[{
   {Cell["suboption name", "TableHeader"], Cell[
    "default value", "TableHeader"], ""},
   {"\"\<Randomization\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to inspect vertices in random order", "TableText"]},
   {"\"\<MinSize\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "minimal number of vertices in a coarsened graph", "TableText"]},
   {"\"\<CoarseningScheme\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how graphs are coarsened", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1",
 CellID->95871813],

Cell[TextData[{
 "Suboptions for ",
 Cell[BoxData["\"\<Multilevel\>\""], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.1",
 CellID->189969144],

Cell[TextData[{
 "For the option ",
 Cell[BoxData["\"\<Randomize\>\""], "InlineFormula"],
 ", possible values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". For ",
 Cell[BoxData["\"\<MinSize\>\""], "InlineFormula"],
 ", possible values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a positive number. For ",
 Cell[BoxData["\"\<CoarseningScheme\>\""], "InlineFormula"],
 ", the implemented algorithms are based on either a maximal independent \
vertex set, which forms the coarse vertices, or a maximal independent edge \
set, also called a matching. In a matching, two vertices that form an edge \
are merged to form a coarse graph vertex. The following are possible values \
for ",
 Cell[BoxData["\"\<CoarseningScheme\>\""], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->857467036],

Cell[BoxData[GridBox[{
   {"\"\<MaximalIndependentVertexSet\>\"", Cell["\<\
link vertices in the maximal independent set if their graph distance is 3 or \
less\
\>", "TableText"]},
   {"\"\<MaximalIndependentVertexSetInjection\>\"", "\[SpanFromLeft]"},
   {"", Cell["\<\
link vertices in the maximal independent set if their graph distance is 1 or \
2\
\>", "TableText"]},
   {"\"\<MaximalIndependentVertexSetRugeStuben\>\"", "\[SpanFromLeft]"},
   {"", Cell["\<\
generate maximal independent vertex set, giving priority to vertices with \
more neighbors not in the set, then link vertices in the set if their graph \
distance is 3 or less\
\>", "TableText"]},
   {"\"\<MaximalIndependentVertexSetRugeStubenInjection\>\"", 
    "\[SpanFromLeft]"},
   {"", Cell["\<\
link vertices if their graph distance is 1 or 2, giving priority to vertices \
with more neighbors\
\>", "TableText"]},
   {"\"\<MaximalIndependentEdgeSet\>\"", Cell[
    "consider edges in their natural order when matching", "TableText"]},
   {"\"\<MaximalIndependentEdgeSetHeadyEdge\>\"", "\[SpanFromLeft]"},
   {"", Cell["\<\
give priority to edges with higher edge weight (i.e., edges that represent a \
larger number of edges in the original graph) when matching\
\>", "TableText"]},
   {"\"\<MaximalIndependentEdgeSetSmallestVertexWeight\>\"", 
    "\[SpanFromLeft]"},
   {"", Cell["\<\
give priority to matchings of vertices with neighbors that have the smallest \
vertex weight\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->17406585]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"StepControl\"", "Subsection",
 CellTags->"b:0.1",
 CellID->178476337],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<StepControl\>\""], "InlineFormula"],
 " defines how step length is modified during energy minimization. It can be \
",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default),",
 " ",
 Cell[BoxData["\"\<Monotonic\>\""], "InlineFormula"],
 " (where step length can only be decreased), ",
 Cell[BoxData["\"\<NonMonotonic\>\""], "InlineFormula"],
 " (where step length can be made larger or smaller), or ",
 Cell[BoxData["\"\<StrictlyMonotonic\>\""], "InlineFormula"],
 " (where step length is strictly reduced between iterations)."
}], "Text",
 CellTags->"b:0.1",
 CellID->518892592]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"StepLength\"", "Subsection",
 CellTags->"b:0.1",
 CellID->273747200],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<StepLength\>\""], "InlineFormula"],
 " gives the initial step length used in moving the vertices around. Possible \
values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default) or a positive real number."
}], "Text",
 CellTags->"b:0.1",
 CellID->981313867]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tolerance", "Subsection",
 CellTags->"b:0.1",
 CellID->885253642],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " specifies the tolerance used in terminating the energy minimization \
process. If the average change of coordinates of each vertex is less than the \
tolerance, the energy minimization process is terminated and the current \
coordinates are given as output. Possible values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a positive real number."
}], "Text",
 CellTags->"b:0.1",
 CellID->370065386]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method Suboptions of \"SpringElectricalEmbedding\" Method", "Section",
 CellTags->"b:0.1",
 CellID->88856448],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["value", "TableHeader"], ""},
   {"\"\<Octree\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to use an octree data structure (in three dimensions) or a quadtree \
data structure (in two dimensions) in the calculation of repulsive force\
\>", "TableText"]},
   {"\"\<RepulsiveForcePower\[NegativeVeryThinSpace]\>\"", 
    RowBox[{"-", "1"}], Cell[
    "how fast the repulsive force decays over distance", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1",
 CellID->147603550],

Cell[TextData[{
 "Method options for ",
 Cell[BoxData["SpringElectricalEmbedding"], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.1",
 CellID->202072803],

Cell[CellGroupData[{

Cell["\"Octree\"", "Subsection",
 CellTags->"b:0.1",
 CellID->701083749],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<Octree\>\""], "InlineFormula"],
 " option specifies whether to use an octree data structure (in three \
dimensions) or a quadtree data structure (in two dimensions) in the \
calculation of repulsive force. Possible values are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". Use of an octree/quadtree data structure minimizes the complexity of \
computation by approximating the long-range repulsive force. However, it \
introduces an approximation to the force calculation. Therefore, in a few \
cases the result may not be as good."
}], "Text",
 CellTags->"b:0.1",
 CellID->242314557]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"RepulsiveForcePower\"", "Subsection",
 CellTags->{"b:0.1", "RepulsiveForcePower"},
 CellID->63316084],

Cell[TextData[{
 "Possible values are negative real numbers, with -1 as the default. In the \
spring-electrical embedding, the repulsive force between two vertices ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["K", "2"], "/", 
    SubscriptBox["d", 
     RowBox[{"i", "\[InvisibleSpace]", "j"}]]}], TraditionalForm]], 
  "InlineMath"],
 " by default. If the value of ",
 Cell[BoxData["RepulsiveForcePower"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " (with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "<", "0"}], TraditionalForm]], "InlineMath"],
 "), then the repulsive force is defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["K", 
     RowBox[{"1", "-", "r"}]], 
    SuperscriptBox[
     SubscriptBox["d", 
      RowBox[{"i", "\[InvisibleSpace]", "j"}]], "r"]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["d", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is the distance between the vertices and ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is a constant coefficient."
}], "Text",
 CellTags->{"b:0.1", "RepulsiveForcePower"},
 CellID->644503519],

Cell[TextData[{
 "A strong long-range repulsive force over long distance often has the \
boundary effect that vertices in the periphery are closer to each other than \
those in the center are. Specifying a weaker long-range repulsive force can \
sometimes alleviate this effect. This option can also be useful in drawing a \
graph so that it fills up more space. (See the ",
 Cell[BoxData[
  ButtonBox["\"\<InferentialDistance\>\"",
   BaseStyle->"Hyperlink",
   ButtonData->"InferentialDistance"]], "InlineFormula"],
 " method option for details.) "
}], "Text",
 CellTags->{"b:0.1", "RepulsiveForcePower"},
 CellID->1577729],

Cell["\<\
With a repulsive force power of -2, the boundary vertices are not as close to \
each other as they are with the default value of -1.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->1651562662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"GridGraph", "[", 
    RowBox[{"20", ",", "20"}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<SpringElectricalEmbedding\>\""}]}], 
  "]"}]], "Input",
 CellTags->{"b:0.1", "RepulsiveForcePower"},
 CellLabel->"In[63]:=",
 CellID->463838568],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{205, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:0.1", "RepulsiveForcePower"},
 CellLabel->"Out[63]=",
 CellID->77637902]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"GridGraph", "[", 
    RowBox[{"20", ",", "20"}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
      RowBox[{"\"\<RepulsiveForcePower\>\"", "\[Rule]", 
       RowBox[{"-", "2"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->{"b:0.1", "RepulsiveForcePower"},
 CellLabel->"In[64]:=",
 CellID->29946197],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{198, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"b:0.1", "RepulsiveForcePower"},
 CellLabel->"Out[64]=",
 CellID->123047643]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Method Suboption of \"HighDimensionalEmbedding\" ", "Section",
 CellTags->"b:0.1",
 CellID->184705428],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"\"\<RefinementMethod\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
whether the result should be further refined, and which method should be used \
for refinement\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 ShowStringCharacters->True,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}}},
 CellTags->"b:0.1",
 CellID->4826076],

Cell[TextData[{
 "Method option for ",
 Cell[BoxData["\"\<HighDimensionalEmbedding\>\""], "InlineFormula"],
 "."
}], "Caption",
 CellTags->"b:0.1",
 CellID->171747900],

Cell[CellGroupData[{

Cell["\"RefinementMethod\"", "Subsection",
 CellTags->"b:0.1",
 CellID->215750623],

Cell[TextData[{
 "The option ",
 Cell[BoxData["\"\<RefinementMethod\>\""], "InlineFormula"],
 " specifies whether the result should be further refined, and which method \
should be used to refine it. Possible values are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " (the default), ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<SpringElectricalEmbedding\>\""], "InlineFormula"],
 "."
}], "Text",
 CellTags->"b:0.1",
 CellID->720326416],

Cell[TextData[{
 "This shows a case where the ",
 Cell[BoxData["\"\<HighDimensionalEmbedding\>\""], "InlineFormula"],
 " method placed vertices 5 and 6 at the same position. Specifying a ",
 Cell[BoxData["\"\<RefinementMethod\>\""], "InlineFormula"],
 " option helps to draw the graph better",
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->47966665],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "7"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[65]:=",
 CellID->809820478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "->", "\"\<HighDimensionalEmbedding\>\""}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[66]:=",
 CellID->1000780256],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.9522887281257895`, 0.983652179356439}, {
    0.9761443640628945, 0.}, {0., 0.5048602798043041}, {0.9761443640628946, 
    1.4885124591607433`}, {2.440360910157237, 0.5048602798043043}, {
    2.4403609101572368`, 0.504860279804304}, {1.4642165460943422`, 
    1.5561405648735147`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 7}, {2, 3}, {3, 4}, {4, 1}, {4, 
       7}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.9522887281257895`, 0.983652179356439}, {
     0.9761443640628945, 0.}, {0., 0.5048602798043041}, {0.9761443640628946, 
     1.4885124591607433`}, {2.440360910157237, 0.5048602798043043}, {
     2.4403609101572368`, 0.504860279804304}, {1.4642165460943422`, 
     1.5561405648735147`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{232., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{236, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[66]=",
 CellID->1045295334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<HighDimensionalEmbedding\>\"", ",", 
      RowBox[{
      "\"\<RefinementMethod\>\"", "\[Rule]", 
       "\"\<SpringElectricalEmbedding\>\""}]}], "}"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[67]:=",
 CellID->871071866],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.7028878058465269`, 0.834292420239805}, {
    0.763199015312834, 0.23073753079143478`}, {0., 0.6634470585460883}, {
    0.7540694416795857, 1.2472063951772723`}, {2.7362304941929096`, 
    1.2216045216591944`}, {2.412203252167516, 0.}, {1.3663421097810102`, 
    1.752253607909938}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 5}, {1, 6}, {1, 7}, {2, 3}, {3, 4}, {4, 1}, {4, 
       7}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.7028878058465269`, 0.834292420239805}, {
     0.763199015312834, 0.23073753079143478`}, {0., 0.6634470585460883}, {
     0.7540694416795857, 1.2472063951772723`}, {2.7362304941929096`, 
     1.2216045216591944`}, {2.412203252167516, 0.}, {1.3663421097810102`, 
     1.752253607909938}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{235., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{239, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[67]=",
 CellID->1852696593]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Advanced Topics", "Section",
 CellTags->"b:0.1",
 CellID->806578725],

Cell[CellGroupData[{

Cell["Drawing a Graph to Fill up More Space", "Subsection",
 CellTags->"b:0.1",
 CellID->437210322],

Cell[TextData[{
 "While the default setting for ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " works well in general, for graphs that have a wide range of values for the \
vertex degree, it is often necessary to use a setting that helps the vertices \
to occupy less space."
}], "Text",
 CellID->2092167033],

Cell["The default method usually works well.", "MathCaption",
 CellTags->"b:0.1",
 CellID->149911509],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeedRandom", "[", "321", "]"}], ";"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[18]:=",
 CellID->45706166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "52"}], "}"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "52"}], "}"}]}], "]"}]}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[19]:=",
 CellID->1465000578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "11"}], ",", 
   RowBox[{"2", "\[Rule]", "27"}], ",", 
   RowBox[{"3", "\[Rule]", "15"}], ",", 
   RowBox[{"4", "\[Rule]", "18"}], ",", 
   RowBox[{"5", "\[Rule]", "11"}], ",", 
   RowBox[{"6", "\[Rule]", "44"}], ",", 
   RowBox[{"7", "\[Rule]", "11"}], ",", 
   RowBox[{"8", "\[Rule]", "50"}], ",", 
   RowBox[{"9", "\[Rule]", "51"}], ",", 
   RowBox[{"10", "\[Rule]", "6"}], ",", 
   RowBox[{"11", "\[Rule]", "52"}], ",", 
   RowBox[{"12", "\[Rule]", "31"}], ",", 
   RowBox[{"13", "\[Rule]", "23"}], ",", 
   RowBox[{"14", "\[Rule]", "50"}], ",", 
   RowBox[{"15", "\[Rule]", "37"}], ",", 
   RowBox[{"16", "\[Rule]", "6"}], ",", 
   RowBox[{"17", "\[Rule]", "31"}], ",", 
   RowBox[{"18", "\[Rule]", "19"}], ",", 
   RowBox[{"19", "\[Rule]", "40"}], ",", 
   RowBox[{"20", "\[Rule]", "21"}], ",", 
   RowBox[{"21", "\[Rule]", "43"}], ",", 
   RowBox[{"22", "\[Rule]", "49"}], ",", 
   RowBox[{"23", "\[Rule]", "11"}], ",", 
   RowBox[{"24", "\[Rule]", "16"}], ",", 
   RowBox[{"25", "\[Rule]", "27"}], ",", 
   RowBox[{"26", "\[Rule]", "46"}], ",", 
   RowBox[{"27", "\[Rule]", "16"}], ",", 
   RowBox[{"28", "\[Rule]", "4"}], ",", 
   RowBox[{"29", "\[Rule]", "11"}], ",", 
   RowBox[{"30", "\[Rule]", "17"}], ",", 
   RowBox[{"31", "\[Rule]", "3"}], ",", 
   RowBox[{"32", "\[Rule]", "25"}], ",", 
   RowBox[{"33", "\[Rule]", "44"}], ",", 
   RowBox[{"34", "\[Rule]", "51"}], ",", 
   RowBox[{"35", "\[Rule]", "27"}], ",", 
   RowBox[{"36", "\[Rule]", "29"}], ",", 
   RowBox[{"37", "\[Rule]", "22"}], ",", 
   RowBox[{"38", "\[Rule]", "42"}], ",", 
   RowBox[{"39", "\[Rule]", "8"}], ",", 
   RowBox[{"40", "\[Rule]", "21"}], ",", 
   RowBox[{"41", "\[Rule]", "46"}], ",", 
   RowBox[{"42", "\[Rule]", "2"}], ",", 
   RowBox[{"43", "\[Rule]", "23"}], ",", 
   RowBox[{"44", "\[Rule]", "45"}], ",", 
   RowBox[{"45", "\[Rule]", "23"}], ",", 
   RowBox[{"46", "\[Rule]", "4"}], ",", 
   RowBox[{"47", "\[Rule]", "14"}], ",", 
   RowBox[{"48", "\[Rule]", "8"}], ",", 
   RowBox[{"49", "\[Rule]", "52"}], ",", 
   RowBox[{"50", "\[Rule]", "30"}], ",", 
   RowBox[{"51", "\[Rule]", "8"}], ",", 
   RowBox[{"52", "\[Rule]", "19"}]}], "}"}]], "Output",
 ImageSize->{490, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[19]=",
 CellID->336246972]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", "g", "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[20]:=",
 CellID->1750758193],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{15.80517066753671, 5.9041157627824745`}, {
    16.216050040722635`, 5.560170145242705}, {25.691410429824906`, 
    7.416191136305358}, {24.701059052455378`, 7.3617832917068355`}, {
    7.754416346818945, 6.1232579938700855`}, {9.082390888175404, 
    5.9147798178396895`}, {14.339281198718242`, 1.5458831110817703`}, {
    14.654728716803573`, 2.6141180174690266`}, {16.579834629327763`, 
    5.920078488786393}, {22.12858001714299, 6.665094318815522}, {
    20.727357056828282`, 6.326306117400704}, {15.936003228671037`, 
    5.258947076980728}, {1.5861192991867679`, 6.918690812836326}, {
    2.742714632335087, 6.9532616862987915`}, {0.08884734499725688, 
    7.223047987846444}, {0.6102003604886104, 6.935675704309413}, {
    22.554688652138246`, 6.611195762660193}, {14.788554317447858`, 
    4.928180943853535}, {6.1258559758488484`, 6.058556925254807}, {
    6.442860221742983, 6.320424604246871}, {18.263180162211913`, 
    5.685947793279979}, {17.763594273523942`, 5.5560788373289505`}, {
    2.5638216052543115`, 7.552545413703207}, {10.442059759485451`, 
    5.694414204380055}, {23.45697128965545, 7.00634071675464}, {
    5.177989392648387, 6.538369350029789}, {15.00777229589508, 
    3.7440504085739432`}, {15.907763349890567`, 3.7860314698057955`}, {
    17.126403100832587`, 3.5277477305644487`}, {16.79518453972534, 
    4.024004966569473}, {17.375016621309648`, 4.735663783787768}, {
    11.839842015348184`, 5.458505975794043}, {13.28598609506457, 
    5.203989446574989}, {23.879281009219532`, 6.860606419797006}, {
    25.15271730486834, 7.99428098487138}, {13.560491184768107`, 
    0.19215155894567193`}, {13.990001417593996`, 0.6384285657792867}, {
    14.43788800499203, 1.067201514307996}, {16.119658318486625`, 
    6.404568615603188}, {3.949182796714597, 6.742717185298083}, {
    25.529678633727933`, 8.474875082387001}, {21.05087713721889, 
    6.612799642371774}, {0., 6.721692749333274}, {25.12777743518275, 
    7.080580152424331}, {16.045796897578118`, 7.032977200429752}, {
    27.134622467094886`, 7.557492219135092}, {26.514956993464157`, 
    7.481656803249026}, {1.2055524015063366`, 7.273012363004465}, {
    14.01493838415029, 0.}, {19.274408259266213`, 5.94805457264173}, {
    2.4265523457448737`, 8.072816869904237}, {1.2724421693910646`, 
    6.493781118717266}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 18}, {3, 4}, {4, 25}, {5, 6}, {6, 24}, {7, 8}, {8, 
       27}, {9, 2}, {10, 11}, {11, 50}, {12, 2}, {13, 14}, {14, 40}, {15, 
       16}, {16, 13}, {17, 10}, {18, 27}, {19, 20}, {20, 5}, {21, 22}, {22, 
       2}, {23, 14}, {24, 32}, {25, 10}, {26, 20}, {27, 28}, {28, 30}, {29, 
       30}, {30, 31}, {31, 22}, {32, 33}, {33, 18}, {34, 25}, {35, 4}, {36, 
       37}, {37, 7}, {38, 7}, {39, 2}, {40, 26}, {41, 35}, {42, 11}, {43, 
       16}, {44, 4}, {45, 39}, {46, 47}, {47, 3}, {48, 13}, {49, 37}, {50, 
       22}, {51, 23}, {52, 13}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "48"],
       Annotation[#, 48, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{15.80517066753671, 5.9041157627824745`}, {
     16.216050040722635`, 5.560170145242705}, {25.691410429824906`, 
     7.416191136305358}, {24.701059052455378`, 7.3617832917068355`}, {
     7.754416346818945, 6.1232579938700855`}, {9.082390888175404, 
     5.9147798178396895`}, {14.339281198718242`, 1.5458831110817703`}, {
     14.654728716803573`, 2.6141180174690266`}, {16.579834629327763`, 
     5.920078488786393}, {22.12858001714299, 6.665094318815522}, {
     20.727357056828282`, 6.326306117400704}, {15.936003228671037`, 
     5.258947076980728}, {1.5861192991867679`, 6.918690812836326}, {
     2.742714632335087, 6.9532616862987915`}, {0.08884734499725688, 
     7.223047987846444}, {0.6102003604886104, 6.935675704309413}, {
     22.554688652138246`, 6.611195762660193}, {14.788554317447858`, 
     4.928180943853535}, {6.1258559758488484`, 6.058556925254807}, {
     6.442860221742983, 6.320424604246871}, {18.263180162211913`, 
     5.685947793279979}, {17.763594273523942`, 5.5560788373289505`}, {
     2.5638216052543115`, 7.552545413703207}, {10.442059759485451`, 
     5.694414204380055}, {23.45697128965545, 7.00634071675464}, {
     5.177989392648387, 6.538369350029789}, {15.00777229589508, 
     3.7440504085739432`}, {15.907763349890567`, 3.7860314698057955`}, {
     17.126403100832587`, 3.5277477305644487`}, {16.79518453972534, 
     4.024004966569473}, {17.375016621309648`, 4.735663783787768}, {
     11.839842015348184`, 5.458505975794043}, {13.28598609506457, 
     5.203989446574989}, {23.879281009219532`, 6.860606419797006}, {
     25.15271730486834, 7.99428098487138}, {13.560491184768107`, 
     0.19215155894567193`}, {13.990001417593996`, 0.6384285657792867}, {
     14.43788800499203, 1.067201514307996}, {16.119658318486625`, 
     6.404568615603188}, {3.949182796714597, 6.742717185298083}, {
     25.529678633727933`, 8.474875082387001}, {21.05087713721889, 
     6.612799642371774}, {0., 6.721692749333274}, {25.12777743518275, 
     7.080580152424331}, {16.045796897578118`, 7.032977200429752}, {
     27.134622467094886`, 7.557492219135092}, {26.514956993464157`, 
     7.481656803249026}, {1.2055524015063366`, 7.273012363004465}, {
     14.01493838415029, 0.}, {19.274408259266213`, 5.94805457264173}, {
     2.4265523457448737`, 8.072816869904237}, {1.2724421693910646`, 
     6.493781118717266}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{Automatic, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{364, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[20]=",
 CellID->762845246]
}, Open  ]],

Cell[TextData[{
 "However, sometimes ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 " produces a drawing that occupies more space",
 "."
}], "MathCaption",
 CellID->2013318103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], "]"}]], "Input",\

 CellTags->"b:0.1",
 CellLabel->"In[21]:=",
 CellID->620434323],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{8.423621949813857, 5.527342639817174}, {
    8.00123332114979, 5.139383840137936}, {1.8661175715942049`, 
    7.031819052665448}, {2.855802234960742, 7.147293803354181}, {
    12.950060777083335`, 5.0287260582858195`}, {12.048198639109533`, 
    5.021632114958738}, {9.361009003599198, 1.6633065325420078`}, {
    8.796239876574049, 2.4190150454258146`}, {7.961587693230609, 
    5.90300105530837}, {4.717804631906603, 7.063462115297799}, {
    5.581002193222834, 6.775572059790918}, {8.893545246890977, 
    5.697273780870517}, {16.199860650913724`, 7.438809159874631}, {
    16.04504889536042, 6.517583220661226}, {15.885392388508214`, 
    9.30804237337635}, {16.354764426034464`, 8.36154570458809}, {
    5.003349762497021, 8.113110833373245}, {8.626847439712604, 
    4.337428243626529}, {14.1897726350001, 3.844865439424965}, {
    13.839491334037426`, 4.910201966008257}, {6.147462346012045, 
    5.097167572358197}, {6.960498255973874, 5.211888487340116}, {
    16.816253650458187`, 5.799009659989305}, {11.225333096821629`, 
    4.845051331428443}, {3.764444447876029, 6.8352740721961744`}, {
    14.489124750553968`, 5.4040561595660845`}, {8.416450708496269, 
    3.318582917874761}, {7.40202732213382, 2.8330985395594386`}, {
    5.826062670956363, 2.5723873045770946`}, {6.502067484202535, 
    3.258175333895771}, {6.449932807136174, 4.298436482618958}, {
    10.71976232263048, 4.03534977469765}, {9.686021325066207, 
    4.261166226904272}, {3.794974952012862, 5.708817667678491}, {
    2.608144691314502, 8.170085914532965}, {9.785939491588875, 0.}, {
    9.341397175757976, 0.7805111809103007}, {10.468452603033379`, 
    1.9332481645798119`}, {8.4706344203863, 6.295818383918449}, {
    15.256405155605776`, 5.979652000357969}, {2.7636771099247177`, 
    9.078933413445633}, {6.405777034533505, 7.702593211830469}, {
    17.089843436434613`, 9.126693891154945}, {2.5251183505507644`, 
    6.199538389622003}, {8.731251644805994, 7.324555460216509}, {0., 
    7.030573292940144}, {0.8766649614906719, 6.821572499762056}, {
    15.231710132811704`, 7.83360676157549}, {8.475080675551418, 
    0.1547503387708744}, {6.2432978997064525`, 5.967479682240349}, {
    17.373499827603638`, 5.004406804479016}, {17.257680937906624`, 
    7.543850337994093}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 18}, {3, 4}, {4, 25}, {5, 6}, {6, 24}, {7, 8}, {8, 
       27}, {9, 2}, {10, 11}, {11, 50}, {12, 2}, {13, 14}, {14, 40}, {15, 
       16}, {16, 13}, {17, 10}, {18, 27}, {19, 20}, {20, 5}, {21, 22}, {22, 
       2}, {23, 14}, {24, 32}, {25, 10}, {26, 20}, {27, 28}, {28, 30}, {29, 
       30}, {30, 31}, {31, 22}, {32, 33}, {33, 18}, {34, 25}, {35, 4}, {36, 
       37}, {37, 7}, {38, 7}, {39, 2}, {40, 26}, {41, 35}, {42, 11}, {43, 
       16}, {44, 4}, {45, 39}, {46, 47}, {47, 3}, {48, 13}, {49, 37}, {50, 
       22}, {51, 23}, {52, 13}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "48"],
       Annotation[#, 48, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{8.423621949813857, 5.527342639817174}, {
     8.00123332114979, 5.139383840137936}, {1.8661175715942049`, 
     7.031819052665448}, {2.855802234960742, 7.147293803354181}, {
     12.950060777083335`, 5.0287260582858195`}, {12.048198639109533`, 
     5.021632114958738}, {9.361009003599198, 1.6633065325420078`}, {
     8.796239876574049, 2.4190150454258146`}, {7.961587693230609, 
     5.90300105530837}, {4.717804631906603, 7.063462115297799}, {
     5.581002193222834, 6.775572059790918}, {8.893545246890977, 
     5.697273780870517}, {16.199860650913724`, 7.438809159874631}, {
     16.04504889536042, 6.517583220661226}, {15.885392388508214`, 
     9.30804237337635}, {16.354764426034464`, 8.36154570458809}, {
     5.003349762497021, 8.113110833373245}, {8.626847439712604, 
     4.337428243626529}, {14.1897726350001, 3.844865439424965}, {
     13.839491334037426`, 4.910201966008257}, {6.147462346012045, 
     5.097167572358197}, {6.960498255973874, 5.211888487340116}, {
     16.816253650458187`, 5.799009659989305}, {11.225333096821629`, 
     4.845051331428443}, {3.764444447876029, 6.8352740721961744`}, {
     14.489124750553968`, 5.4040561595660845`}, {8.416450708496269, 
     3.318582917874761}, {7.40202732213382, 2.8330985395594386`}, {
     5.826062670956363, 2.5723873045770946`}, {6.502067484202535, 
     3.258175333895771}, {6.449932807136174, 4.298436482618958}, {
     10.71976232263048, 4.03534977469765}, {9.686021325066207, 
     4.261166226904272}, {3.794974952012862, 5.708817667678491}, {
     2.608144691314502, 8.170085914532965}, {9.785939491588875, 0.}, {
     9.341397175757976, 0.7805111809103007}, {10.468452603033379`, 
     1.9332481645798119`}, {8.4706344203863, 6.295818383918449}, {
     15.256405155605776`, 5.979652000357969}, {2.7636771099247177`, 
     9.078933413445633}, {6.405777034533505, 7.702593211830469}, {
     17.089843436434613`, 9.126693891154945}, {2.5251183505507644`, 
     6.199538389622003}, {8.731251644805994, 7.324555460216509}, {0., 
     7.030573292940144}, {0.8766649614906719, 6.821572499762056}, {
     15.231710132811704`, 7.83360676157549}, {8.475080675551418, 
     0.1547503387708744}, {6.2432978997064525`, 5.967479682240349}, {
     17.373499827603638`, 5.004406804479016}, {17.257680937906624`, 
     7.543850337994093}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->{300., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{304, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[21]=",
 CellID->1925652821]
}, Open  ]],

Cell[TextData[{
 "A similar effect can be achieved with a repulsive force power smaller than \
the default (",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 "), so that the repulsive force decays more quickly over distance",
 "."
}], "MathCaption",
 CellTags->{"RepulsiveForcePowerTreeExample", "b:0.1"},
 CellID->230952551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
      RowBox[{"\"\<RepulsiveForcePower\>\"", "\[Rule]", 
       RowBox[{"-", "1.8"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[23]:=",
 CellID->295414904],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{10.444653173418654`, 6.224720076886472}, {
    9.710280413007599, 6.181641593837315}, {1.366280273545696, 
    7.300707552654578}, {2.04793895333016, 6.517644053485734}, {
    16.539088381499706`, 6.192041023171525}, {15.47509476827371, 
    6.000538115770539}, {11.00912496572808, 1.7110871229463687`}, {
    10.778078854637839`, 2.7921271307306905`}, {9.56344538830698, 
    7.020913322645416}, {4.457109578601138, 6.565757323512655}, {
    5.719637301897153, 6.449541821121856}, {9.048668092262865, 
    6.611702737200567}, {21.86010457614107, 6.161959431522909}, {
    20.87347033104522, 6.693972659745555}, {23.606688913765097`, 
    5.959930119101908}, {22.832880678294217`, 5.764580072074904}, {
    4.284127381096075, 7.272040545258293}, {10.780248070181205`, 
    5.178410859277518}, {17.57533232247539, 7.147690205470106}, {
    17.62319458880001, 6.4453816880616905`}, {8.703799878379886, 
    5.514598871888544}, {8.268937519766352, 5.857470658082869}, {
    21.024508941440267`, 7.552349642509058}, {14.389850642191789`, 
    5.802503351070809}, {3.2429987785797296`, 6.432276867872967}, {
    18.72312881785436, 6.490468862579779}, {10.504272279599517`, 
    3.9315535950088236`}, {9.566268933473804, 3.8057451166914706`}, {
    8.098396656806322, 3.36973910562738}, {8.62874565782899, 
    3.9592508979739813`}, {8.254531573962712, 4.820043779410842}, {
    13.268962880425171`, 5.596358670651836}, {12.072107613403114`, 
    5.380840486400013}, {3.263356437762579, 5.722560682452215}, {
    1.5936223165334553`, 5.679737833728435}, {10.421380543940836`, 
    0.07411076385438076}, {10.93589497534644, 0.6743797691511695}, {
    11.723155405481357`, 1.571988696477475}, {10.281890278040253`, 
    7.138516708657999}, {19.787194567694186`, 6.5989139776501835`}, {
    1.1127808013490448`, 5.078964044002362}, {5.801341237163518, 
    7.151013901147228}, {23.23114328484607, 5.079875900925572}, {
    1.336938058838486, 6.4694685348952765`}, {10.60796504631136, 
    7.897401937427221}, {0., 8.177974757473535}, {0.6450788491572457, 
    7.810319115224194}, {22.2744427630573, 6.728226108930643}, {
    11.36719757677854, 0.}, {6.965536359670488, 6.1489300618350295`}, {
    21.153538353290934`, 8.290068806781846}, {21.667431061651385`, 
    5.440338458389151}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 18}, {3, 4}, {4, 25}, {5, 6}, {6, 24}, {7, 8}, {8, 
       27}, {9, 2}, {10, 11}, {11, 50}, {12, 2}, {13, 14}, {14, 40}, {15, 
       16}, {16, 13}, {17, 10}, {18, 27}, {19, 20}, {20, 5}, {21, 22}, {22, 
       2}, {23, 14}, {24, 32}, {25, 10}, {26, 20}, {27, 28}, {28, 30}, {29, 
       30}, {30, 31}, {31, 22}, {32, 33}, {33, 18}, {34, 25}, {35, 4}, {36, 
       37}, {37, 7}, {38, 7}, {39, 2}, {40, 26}, {41, 35}, {42, 11}, {43, 
       16}, {44, 4}, {45, 39}, {46, 47}, {47, 3}, {48, 13}, {49, 37}, {50, 
       22}, {51, 23}, {52, 13}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "48"],
       Annotation[#, 48, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{10.444653173418654`, 6.224720076886472}, {
     9.710280413007599, 6.181641593837315}, {1.366280273545696, 
     7.300707552654578}, {2.04793895333016, 6.517644053485734}, {
     16.539088381499706`, 6.192041023171525}, {15.47509476827371, 
     6.000538115770539}, {11.00912496572808, 1.7110871229463687`}, {
     10.778078854637839`, 2.7921271307306905`}, {9.56344538830698, 
     7.020913322645416}, {4.457109578601138, 6.565757323512655}, {
     5.719637301897153, 6.449541821121856}, {9.048668092262865, 
     6.611702737200567}, {21.86010457614107, 6.161959431522909}, {
     20.87347033104522, 6.693972659745555}, {23.606688913765097`, 
     5.959930119101908}, {22.832880678294217`, 5.764580072074904}, {
     4.284127381096075, 7.272040545258293}, {10.780248070181205`, 
     5.178410859277518}, {17.57533232247539, 7.147690205470106}, {
     17.62319458880001, 6.4453816880616905`}, {8.703799878379886, 
     5.514598871888544}, {8.268937519766352, 5.857470658082869}, {
     21.024508941440267`, 7.552349642509058}, {14.389850642191789`, 
     5.802503351070809}, {3.2429987785797296`, 6.432276867872967}, {
     18.72312881785436, 6.490468862579779}, {10.504272279599517`, 
     3.9315535950088236`}, {9.566268933473804, 3.8057451166914706`}, {
     8.098396656806322, 3.36973910562738}, {8.62874565782899, 
     3.9592508979739813`}, {8.254531573962712, 4.820043779410842}, {
     13.268962880425171`, 5.596358670651836}, {12.072107613403114`, 
     5.380840486400013}, {3.263356437762579, 5.722560682452215}, {
     1.5936223165334553`, 5.679737833728435}, {10.421380543940836`, 
     0.07411076385438076}, {10.93589497534644, 0.6743797691511695}, {
     11.723155405481357`, 1.571988696477475}, {10.281890278040253`, 
     7.138516708657999}, {19.787194567694186`, 6.5989139776501835`}, {
     1.1127808013490448`, 5.078964044002362}, {5.801341237163518, 
     7.151013901147228}, {23.23114328484607, 5.079875900925572}, {
     1.336938058838486, 6.4694685348952765`}, {10.60796504631136, 
     7.897401937427221}, {0., 8.177974757473535}, {0.6450788491572457, 
     7.810319115224194}, {22.2744427630573, 6.728226108930643}, {
     11.36719757677854, 0.}, {6.965536359670488, 6.1489300618350295`}, {
     21.153538353290934`, 8.290068806781846}, {21.667431061651385`, 
     5.440338458389151}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->{338., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{342, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[23]=",
 CellID->1383703949]
}, Open  ]],

Cell["Alternatively, specify a cut-off distance.", "MathCaption",
 CellTags->{"RepulsiveForcePowerTreeExample", "b:0.1"},
 CellID->1091789254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
      RowBox[{"\"\<InferentialDistance\>\"", "\[Rule]", "4"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[24]:=",
 CellID->1717854886],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{13.083641117604571`, 6.038077254500394}, {
    13.780559210155861`, 5.8587167176265815`}, {22.02501778990166, 
    5.876934655031559}, {21.177424400915413`, 6.48411761199378}, {
    7.310123219006149, 6.022844984098198}, {8.351192726491602, 
    5.7854176696805215`}, {11.27715863975995, 1.5088959517578715`}, {
    11.96563654018196, 2.4477681248686127`}, {13.374693441240948`, 
    6.498720961695904}, {18.734286060521338`, 6.1643811429618784`}, {
    17.54427749146545, 6.01868091126896}, {14.286223849775814`, 
    6.339393591849904}, {1.8219336214456678`, 6.089976285982464}, {
    2.8982842696129154`, 6.653788877072703}, {0., 5.861586596522617}, {
    0.7437773550807343, 5.708400278877779}, {18.534751797535783`, 
    6.763105820912059}, {12.651961217991959`, 4.85590819003112}, {
    6.20850842493408, 6.962731145217533}, {6.249255702929559, 
    6.350276032348022}, {15.669945593423202`, 4.929036690182198}, {
    15.108024557171895`, 5.251781678514477}, {2.8377733392582787`, 
    7.5646963912405205`}, {9.300115911556494, 5.557846400338328}, {
    20.00328639431997, 6.143141263815835}, {5.1448686330175875`, 
    6.452074326578725}, {12.647073592830575`, 3.4933900915248546`}, {
    13.616486674068135`, 3.151544009353318}, {15.075165079775871`, 
    2.6306946111000302`}, {14.592231158829954`, 3.2172221909433785`}, {
    14.942902778894434`, 4.139985523859743}, {10.320240278699606`, 
    5.3669349970376}, {11.443190478105064`, 5.1512600823946695`}, {
    20.205653160099775`, 5.477569387908732}, {21.179958990139912`, 
    7.418665782305543}, {10.23958859130682, 0.}, {10.506659249645725`, 
    0.7396707800606155}, {11.556352030715894`, 0.9540465131987723}, {
    13.863178752722485`, 7.072945137059914}, {4.0362750593466625`, 
    6.565459414361906}, {21.233358900035235`, 8.15570033103593}, {
    17.46660023885078, 6.677975994985277}, {0.11717896581981968`, 
    5.1783898202396355`}, {21.74290769588668, 6.777258172396019}, {
    13.85645781108754, 7.951841652386172}, {23.40123242279602, 
    5.018290527340784}, {22.78387514570506, 5.387725211912351}, {
    1.4659905459932396`, 6.589556028344763}, {9.842252789463265, 
    0.5419565472047001}, {16.379857229811485`, 5.63390677052289}, {
    2.752273255126612, 8.29912323754623}, {1.9130789355120843`, 
    5.395486441109347}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 18}, {3, 4}, {4, 25}, {5, 6}, {6, 24}, {7, 8}, {8, 
       27}, {9, 2}, {10, 11}, {11, 50}, {12, 2}, {13, 14}, {14, 40}, {15, 
       16}, {16, 13}, {17, 10}, {18, 27}, {19, 20}, {20, 5}, {21, 22}, {22, 
       2}, {23, 14}, {24, 32}, {25, 10}, {26, 20}, {27, 28}, {28, 30}, {29, 
       30}, {30, 31}, {31, 22}, {32, 33}, {33, 18}, {34, 25}, {35, 4}, {36, 
       37}, {37, 7}, {38, 7}, {39, 2}, {40, 26}, {41, 35}, {42, 11}, {43, 
       16}, {44, 4}, {45, 39}, {46, 47}, {47, 3}, {48, 13}, {49, 37}, {50, 
       22}, {51, 23}, {52, 13}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "48"],
       Annotation[#, 48, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{13.083641117604571`, 6.038077254500394}, {
     13.780559210155861`, 5.8587167176265815`}, {22.02501778990166, 
     5.876934655031559}, {21.177424400915413`, 6.48411761199378}, {
     7.310123219006149, 6.022844984098198}, {8.351192726491602, 
     5.7854176696805215`}, {11.27715863975995, 1.5088959517578715`}, {
     11.96563654018196, 2.4477681248686127`}, {13.374693441240948`, 
     6.498720961695904}, {18.734286060521338`, 6.1643811429618784`}, {
     17.54427749146545, 6.01868091126896}, {14.286223849775814`, 
     6.339393591849904}, {1.8219336214456678`, 6.089976285982464}, {
     2.8982842696129154`, 6.653788877072703}, {0., 5.861586596522617}, {
     0.7437773550807343, 5.708400278877779}, {18.534751797535783`, 
     6.763105820912059}, {12.651961217991959`, 4.85590819003112}, {
     6.20850842493408, 6.962731145217533}, {6.249255702929559, 
     6.350276032348022}, {15.669945593423202`, 4.929036690182198}, {
     15.108024557171895`, 5.251781678514477}, {2.8377733392582787`, 
     7.5646963912405205`}, {9.300115911556494, 5.557846400338328}, {
     20.00328639431997, 6.143141263815835}, {5.1448686330175875`, 
     6.452074326578725}, {12.647073592830575`, 3.4933900915248546`}, {
     13.616486674068135`, 3.151544009353318}, {15.075165079775871`, 
     2.6306946111000302`}, {14.592231158829954`, 3.2172221909433785`}, {
     14.942902778894434`, 4.139985523859743}, {10.320240278699606`, 
     5.3669349970376}, {11.443190478105064`, 5.1512600823946695`}, {
     20.205653160099775`, 5.477569387908732}, {21.179958990139912`, 
     7.418665782305543}, {10.23958859130682, 0.}, {10.506659249645725`, 
     0.7396707800606155}, {11.556352030715894`, 0.9540465131987723}, {
     13.863178752722485`, 7.072945137059914}, {4.0362750593466625`, 
     6.565459414361906}, {21.233358900035235`, 8.15570033103593}, {
     17.46660023885078, 6.677975994985277}, {0.11717896581981968`, 
     5.1783898202396355`}, {21.74290769588668, 6.777258172396019}, {
     13.85645781108754, 7.951841652386172}, {23.40123242279602, 
     5.018290527340784}, {22.78387514570506, 5.387725211912351}, {
     1.4659905459932396`, 6.589556028344763}, {9.842252789463265, 
     0.5419565472047001}, {16.379857229811485`, 5.63390677052289}, {
     2.752273255126612, 8.29912323754623}, {1.9130789355120843`, 
     5.395486441109347}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{284., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{288, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[24]=",
 CellID->1961275256]
}, Open  ]],

Cell[TextData[{
 "For such tree-like graphs, a tree-drawing algorithm may be preferable. See \
",
 ButtonBox["Tree Drawing",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/TreeDrawing"],
 " for greater control over tree layout."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->237112631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"Method", "\[Rule]", "\"\<RadialDrawing\>\""}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[25]:=",
 CellID->244408064],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{4.378615608172658, 3.8753004707567498`}, {
    4.415691215592198, 2.6249267227382655`}, {0.9848995885648248, 
    1.7308418638896779`}, {1.6974268820887786`, 1.1760939619584427`}, {
    6.945908735641519, 4.093737923518157}, {6.5636684860077725`, 
    3.7625248619278686`}, {6.7417999835363345`, 1.2399246786814988`}, {
    6.410586921928885, 1.6221649283003745`}, {4.2022632936784525`, 
    3.678187061939044}, {2.627307095843218, 1.5742918907580827`}, {
    3.187856480712836, 1.574568011763415}, {4.0628185513378225`, 
    3.453444990673438}, {8.838628092604498, 5.770999814569817}, {
    8.17366275002266, 5.730699846965775}, {10.503827081377862`, 
    5.022024001895081}, {9.811108533897784, 5.2733458890092475`}, {
    1.8819712299468607`, 2.5723750575326028`}, {5.034707487502529, 
    2.4376726155323905`}, {8.403793121270157, 3.30545242323001}, {
    7.3281489852752655`, 4.424950985108446}, {3.4803752064102813`, 
    3.354242015708149}, {3.97537727453498, 2.2954282800092076`}, {
    6.957525790965542, 7.052249426504302}, {6.1814282363740265`, 
    3.4313118003375798`}, {2.2962199781553565`, 1.0968409456059804`}, {
    7.484483996793628, 4.990246304513581}, {6.1814282361361, 
    2.106459553701843}, {6.872814254745995, 2.3414046971250473`}, {
    7.843391933172302, 2.056417377103744}, {7.358103093959148, 
    2.198911037114396}, {3.4081500331311982`, 3.009066846761771}, {
    5.7991879867402805`, 3.100098738747291}, {5.416947737106534, 
    2.768885677157002}, {2.4665082875072044`, 0.}, {1.2324867752115587`, 
    0.9769949975586247}, {6.67759023230224, 0.008463658479846536}, {
    6.784164391635389, 0.6414550355658473}, {7.5443783782680045`, 
    1.401669021959545}, {4.732388423590098, 1.4147564913882902`}, {
    7.829073373408145, 5.360473075739678}, {0.7675466683343393, 
    0.777896033158805}, {3.5983449675424506`, 0.33951679030083737`}, {
    9.947886424578563, 5.997440831393499}, {1.6072166907460552`, 
    0.27759382278673295`}, {4.504201985751286, 0.9633800961320527}, {0., 
    1.5001654609413835`}, {0.492449794282412, 1.6155036624155306`}, {
    8.86284150325169, 6.471153389417969}, {7.404226106751237, 
    0.47544417944374917`}, {3.6336747319915754`, 1.8134315448421325`}, {
    7.1287011302832095`, 7.528178731987335}, {8.049371847831024, 
    7.087602310843968}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 18}, {3, 4}, {4, 25}, {5, 6}, {6, 24}, {7, 8}, {8, 
       27}, {9, 2}, {10, 11}, {11, 50}, {12, 2}, {13, 14}, {14, 40}, {15, 
       16}, {16, 13}, {17, 10}, {18, 27}, {19, 20}, {20, 5}, {21, 22}, {22, 
       2}, {23, 14}, {24, 32}, {25, 10}, {26, 20}, {27, 28}, {28, 30}, {29, 
       30}, {30, 31}, {31, 22}, {32, 33}, {33, 18}, {34, 25}, {35, 4}, {36, 
       37}, {37, 7}, {38, 7}, {39, 2}, {40, 26}, {41, 35}, {42, 11}, {43, 
       16}, {44, 4}, {45, 39}, {46, 47}, {47, 3}, {48, 13}, {49, 37}, {50, 
       22}, {51, 23}, {52, 13}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "48"],
       Annotation[#, 48, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{4.378615608172658, 3.8753004707567498`}, {
     4.415691215592198, 2.6249267227382655`}, {0.9848995885648248, 
     1.7308418638896779`}, {1.6974268820887786`, 1.1760939619584427`}, {
     6.945908735641519, 4.093737923518157}, {6.5636684860077725`, 
     3.7625248619278686`}, {6.7417999835363345`, 1.2399246786814988`}, {
     6.410586921928885, 1.6221649283003745`}, {4.2022632936784525`, 
     3.678187061939044}, {2.627307095843218, 1.5742918907580827`}, {
     3.187856480712836, 1.574568011763415}, {4.0628185513378225`, 
     3.453444990673438}, {8.838628092604498, 5.770999814569817}, {
     8.17366275002266, 5.730699846965775}, {10.503827081377862`, 
     5.022024001895081}, {9.811108533897784, 5.2733458890092475`}, {
     1.8819712299468607`, 2.5723750575326028`}, {5.034707487502529, 
     2.4376726155323905`}, {8.403793121270157, 3.30545242323001}, {
     7.3281489852752655`, 4.424950985108446}, {3.4803752064102813`, 
     3.354242015708149}, {3.97537727453498, 2.2954282800092076`}, {
     6.957525790965542, 7.052249426504302}, {6.1814282363740265`, 
     3.4313118003375798`}, {2.2962199781553565`, 1.0968409456059804`}, {
     7.484483996793628, 4.990246304513581}, {6.1814282361361, 
     2.106459553701843}, {6.872814254745995, 2.3414046971250473`}, {
     7.843391933172302, 2.056417377103744}, {7.358103093959148, 
     2.198911037114396}, {3.4081500331311982`, 3.009066846761771}, {
     5.7991879867402805`, 3.100098738747291}, {5.416947737106534, 
     2.768885677157002}, {2.4665082875072044`, 0.}, {1.2324867752115587`, 
     0.9769949975586247}, {6.67759023230224, 0.008463658479846536}, {
     6.784164391635389, 0.6414550355658473}, {7.5443783782680045`, 
     1.401669021959545}, {4.732388423590098, 1.4147564913882902`}, {
     7.829073373408145, 5.360473075739678}, {0.7675466683343393, 
     0.777896033158805}, {3.5983449675424506`, 0.33951679030083737`}, {
     9.947886424578563, 5.997440831393499}, {1.6072166907460552`, 
     0.27759382278673295`}, {4.504201985751286, 0.9633800961320527}, {0., 
     1.5001654609413835`}, {0.492449794282412, 1.6155036624155306`}, {
     8.86284150325169, 6.471153389417969}, {7.404226106751237, 
     0.47544417944374917`}, {3.6336747319915754`, 1.8134315448421325`}, {
     7.1287011302832095`, 7.528178731987335}, {8.049371847831024, 
     7.087602310843968}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[25]=",
 CellID->1900567234]
}, Open  ]],

Cell["This draws a graph from power network modeling.", "MathCaption",
 CellTags->"b:0.1",
 CellID->625785435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"ExampleData", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Matrix\>\"", ",", "\"\<HB/1138Bus\>\""}], "}"}], ",", 
     "\"\<Matrix\>\""}], "]"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
      RowBox[{"\"\<InferentialDistance\>\"", "\[Rule]", "4"}], ",", 
      RowBox[{"\"\<RepulsiveForcePower\>\"", "\[Rule]", 
       RowBox[{"-", "1.8"}]}]}], "}"}]}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->1111747723],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->3496884]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Improving Performance for Drawing Very Large Graphs", "Subsection",
 CellTags->"b:0.1",
 CellID->377159957],

Cell["\<\
Although the default option set usually ensures a very good performance, it \
is often possible to further increase drawing speed and reduce memory usage \
by selecting specific option combinations for a particular task. For example, \
speed and/or memory usage can be improved using a smaller number of \
iterations, a smaller inferential distance, or a lower tolerance. These \
settings tend to reduce quality, but still frequently offer an acceptable \
compromise.\
\>", "Text",
 CellID->142516187],

Cell["This is a drawing with default option settings.", "MathCaption",
 CellTags->"b:0.1",
 CellID->189025476],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
   "Import", "[", "\"\<LinearAlgebraExamples/Data/nos6.mtx\>\"", "]"}]}], 
  ";"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[75]:=",
 CellID->47939454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", "g", "]"}], "//", "Timing"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[76]:=",
 CellID->1967967150],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{262, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[76]=",
 CellID->224863661]
}, Open  ]],

Cell["\<\
A coarsening scheme based on the maximal independent vertex set is often \
faster and uses less memory, and yet offers a comparable layout quality.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->80048070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", 
       RowBox[{"\"\<RecursionMethod\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Multilevel\>\"", ",", 
          RowBox[{
          "\"\<CoarseningScheme\>\"", "\[Rule]", 
           "\"\<MaximalIndependentVertexSetRugeStuben\>\""}]}], "}"}]}]}], 
      "}"}]}]}], "]"}], "//", "Timing"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[77]:=",
 CellID->452193830],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{262, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[77]=",
 CellID->12565440]
}, Open  ]],

Cell["\<\
By reducing the number of iterations to 30, you can get a result still \
faster.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->272902236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", " ", 
       RowBox[{"MaxIterations", "\[Rule]", "30"}]}], "}"}]}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[78]:=",
 CellID->653846390],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{262, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[78]=",
 CellID->286506744]
}, Open  ]],

Cell["\<\
A combination of the inferential distance of 2 and the number of iterations \
of 40 is also faster than the default.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->419881207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", " ", 
       RowBox[{"\"\<InferentialDistance\>\"", "\[Rule]", "2"}], ",", " ", 
       RowBox[{"MaxIterations", "\[Rule]", "40"}]}], "}"}]}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[79]:=",
 CellID->449865991],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{255, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[79]=",
 CellID->40156132]
}, Open  ]],

Cell["\<\
By further reducing the number of iterations to 20, you get a result much \
faster.\
\>", "MathCaption",
 CellTags->"b:0.1",
 CellID->53388386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", " ", 
       RowBox[{"\"\<InferentialDistance\>\"", "\[Rule]", "2"}], ",", " ", 
       RowBox[{"MaxIterations", "\[Rule]", "20"}]}], "}"}]}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[80]:=",
 CellID->258302704],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{255, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[80]=",
 CellID->105359857]
}, Open  ]],

Cell["A combination of the previous options is still faster.", "MathCaption",
 CellTags->"b:0.1",
 CellID->108330592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<SpringElectricalEmbedding\>\"", ",", " ", 
       RowBox[{"\"\<InferentialDistance\>\"", "\[Rule]", "2"}], ",", " ", 
       RowBox[{"MaxIterations", "\[Rule]", "20"}], ",", 
       RowBox[{"\"\<RecursionMethod\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Multilevel\>\"", ",", 
          RowBox[{
          "\"\<CoarseningScheme\>\"", "\[Rule]", 
           "\"\<MaximalIndependentVertexSetRugeStuben\>\""}]}], "}"}]}]}], 
      "}"}]}]}], "]"}], "//", "Timing"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[81]:=",
 CellID->630565266],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{262, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[81]=",
 CellID->144458245]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\"\<HighDimensionalEmbedding\>\""], "InlineFormula"],
 " tends to be the fastest method, but the quality of the drawing often \
suffers."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->76193304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<HighDimensionalEmbedding\>\""}]}], 
   "]"}], "//", "Timing"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[82]:=",
 CellID->528282868],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{262, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[82]=",
 CellID->321578091]
}, Open  ]],

Cell[TextData[{
 "For comparison, ",
 Cell[BoxData["\"\<SpringEmbedding\>\""], "InlineFormula"],
 " is the slowest method, but it is the only one that draws the mesh using \
orthogonal lines",
 "."
}], "MathCaption",
 CellTags->"b:0.1",
 CellID->13930621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GraphPlot", "[", 
   RowBox[{"g", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<SpringEmbedding\>\""}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[83]:=",
 CellID->637909555],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{255, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[83]=",
 CellID->82617852]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extracting Vertex Coordinates from Output", "Subsection",
 CellTags->"b:0.1",
 CellID->769360549],

Cell[TextData[{
 "In most cases, you will deal with the output of ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " just as with a usual ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " expression. However, you may sometimes want to take advantage of the \
additional information encapsulated in the output expression, which has the \
form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["Annotation",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Annotation"], "[", 
    RowBox[{
     StyleBox["data", "TI"], ",", 
     RowBox[{
      ButtonBox["VertexCoordinateRules",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexCoordinateRules"], "->", 
      StyleBox["rules", "TI"]}]}], "]"}], "]"}]], "InlineFormula"],
 ". Particularly, it is sometimes useful to extract coordinates of graph \
vertices."
}], "Text",
 CellID->1225542167],

Cell["Here is a simple graph.", "MathCaption",
 CellID->110040222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"3", "\[Rule]", "2"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"4", "\[Rule]", "3"}], ",", 
    RowBox[{"5", "\[Rule]", "1"}], ",", 
    RowBox[{"5", "\[Rule]", "2"}], ",", 
    RowBox[{"5", "\[Rule]", "4"}], ",", 
    RowBox[{"6", "\[Rule]", "1"}], ",", 
    RowBox[{"6", "\[Rule]", "2"}], ",", 
    RowBox[{"6", "\[Rule]", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[84]:=",
 CellID->2127088116],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.5787833901030038, 1.1722156202269587`}, {
    0.5788370325404935, 0.}, {1.717960482472845, 1.1183616166571815`}, {
    1.150212137341374, 0.585401049539689}, {1.7182137452070165`, 
    0.05404825483476372}, {0., 0.5859461561842646}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {3, 1}, {5, 4}, {5, 2}, {5, 3}, {6, 4}, {6, 
       2}, {6, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.5787833901030038, 1.1722156202269587`}, {
     0.5788370325404935, 0.}, {1.717960482472845, 1.1183616166571815`}, {
     1.150212137341374, 0.585401049539689}, {1.7182137452070165`, 
     0.05404825483476372}, {0., 0.5859461561842646}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{250., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{254, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[84]=",
 CellID->55596467]
}, Open  ]],

Cell["This extracts the coordinates of vertices.", "MathCaption",
 CellID->1604097771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VertexCoordinateRules", " ", "/.", " ", 
  RowBox[{"Cases", "[", 
   RowBox[{"%", ",", " ", "_Rule", ",", " ", "Infinity"}], "]"}]}]], "Input",
 CellLabel->"In[85]:=",
 CellID->702938698],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.5787833901030038`", ",", "1.1722156202269587`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5788370325404935`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.717960482472845`", ",", "1.1183616166571815`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.150212137341374`", ",", "0.585401049539689`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.7182137452070165`", ",", "0.05404825483476372`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.5859461561842646`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{403, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[85]=",
 CellID->2103357976]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example Gallery", "Section",
 CellTags->"b:0.1",
 CellID->816276110],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["E. coli",
  FontSlant->"Italic"],
 " Transcription Networks"
}], "Subsection",
 CellTags->"b:0.1",
 CellID->262520287],

Cell["\<\
In a graph representation of a transcriptional regulation network that \
controls gene expression in cells, nodes (vertices) are operons, which are \
one or more genes transcribed on the same messenger ribonucleic acid (mRNA). \
Edges of the graph are directed from an operon that encodes a transcription \
factor to an operon that it directly regulates [1]. \
\>", "Text",
 CellID->1726929887],

Cell[CellGroupData[{

Cell["Data", "Subsubsubsection",
 CellID->549636594],

Cell["This is the network [2] described as rules.", "Text",
 CellID->729958748],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<acrR\>\"", "\[Rule]", "\"\<acrAB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ada_alkB\>\"", "\[Rule]", "\"\<aidB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ada_alkB\>\"", "\[Rule]", "\"\<alkA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<adiA_adiY\>\"", "\[Rule]", "\"\<adiA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<alpA\>\"", "\[Rule]", "\"\<slp\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<appY\>\"", "\[Rule]", "\"\<appCBA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<araC\>\"", "\[Rule]", "\"\<araBAD\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<araC\>\"", "\[Rule]", "\"\<araE\>\""}], ",", "3"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<araC\>\"", "\[Rule]", "\"\<araFG_araH_1H_2\>\""}], ",", 
       "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<araC\>\"", "\[Rule]", "\"\<araJ\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<aceBAK\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<appCBA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<appY\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<betIBA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<cydAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<cyoABCDE\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<dctA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<fadBA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<focA_pflB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<fumA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<fumC\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<glcDEFGB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<glpACB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<gltA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<icdA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<lctPRD\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<mdh\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<nuoABCEFGHIJKLMN\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<sdhCDAB_b0725_sucABCD\>\""}], 
       ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arcA\>\"", "\[Rule]", "\"\<sodA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<argR\>\"", "\[Rule]", "\"\<argCBH\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<argR\>\"", "\[Rule]", "\"\<argD\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<argR\>\"", "\[Rule]", "\"\<argE\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<argR\>\"", "\[Rule]", "\"\<argF\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<argR\>\"", "\[Rule]", "\"\<argI\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<argR\>\"", "\[Rule]", "\"\<carAB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<arsR\>\"", "\[Rule]", "\"\<arsEFG\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<asnC\>\"", "\[Rule]", "\"\<asnA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<atoC\>\"", "\[Rule]", "\"\<atoDAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<atoC\>\"", "\[Rule]", "\"\<atoDAE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<betIBA\>\"", "\[Rule]", "\"\<betT\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<birA_murA\>\"", "\[Rule]", "\"\<bioA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<birA_murA\>\"", "\[Rule]", "\"\<bioBFCD\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cadC\>\"", "\[Rule]", "\"\<cadBA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<caiF\>\"", "\[Rule]", "\"\<caiTABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<caiF\>\"", "\[Rule]", "\"\<fixABCX\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cbl\>\"", "\[Rule]", "\"\<ssuEADCB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cbl\>\"", "\[Rule]", "\"\<tauABCD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<cpxP\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<dsbA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<ecfI\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<htrA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<motABcheAW\>\""}], ",", "2"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<rotA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<skp_lpxDA_fabZ\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<tsr\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cpxAR\>\"", "\[Rule]", "\"\<xprB_dsbC_recJ\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<acs\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<aldB\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<ansB\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<araBAD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<araC\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<araE\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<araFG_araH_1H_2\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<araJ\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<caiF\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<caiTABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<cirA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<cpdB\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<cyaA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<dadAX\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<dctA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<dcuB_fumB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<deoCABD\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<dsdXA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<ebgAC\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<epd_pgk\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<fadL\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<fixABCX\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<flhDC\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<focA_pflB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<fucAO\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<fucPIKUR\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<fur\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<galETKM\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<galS\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<glgCAP\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<glgS\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<glnALG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<glpACB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<glpD\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<glpFK\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<glpTQ\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<gltA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<gntKU\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<gntT\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<ivbL_ilvBN\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<lacZYA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<malEFG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<malI\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<malK_lamB_malM\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<malS\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<malT\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<malXY\>\""}], ",", "3"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<manXYZ\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<melAB\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<melR\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<mglBAC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<nagBACD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<nagE\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<nupG\>\""}], ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<ompA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<ppiA\>\""}], ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<proP\>\""}], ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<ptsHI_crr\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<rhaBAD\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<rhaT\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<rpoH\>\""}], ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<sdhCDAB_b0725_sucABCD\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<speC\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<srlAEBD_gutM_srlR_gutQ\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<tdcABCDEFG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<tnaLAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<tsx\>\""}], ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<ubiG\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<udp\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<uhpT\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<yhfA\>\""}], ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<crp\>\"", "\[Rule]", "\"\<yiaKLMNOPQRS\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<csgDEFG\>\"", "\[Rule]", "\"\<csgBA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cspA\>\"", "\[Rule]", "\"\<gyrA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cspA\>\"", "\[Rule]", "\"\<hns\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cynR\>\"", "\[Rule]", "\"\<cynTSX\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cysB\>\"", "\[Rule]", "\"\<cysDNC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cysB\>\"", "\[Rule]", "\"\<cysJIH\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cysB\>\"", "\[Rule]", "\"\<cysK\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cysB\>\"", "\[Rule]", "\"\<cysPUWAM\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cysB\>\"", "\[Rule]", "\"\<tauABCD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cytR\>\"", "\[Rule]", "\"\<deoCABD\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cytR\>\"", "\[Rule]", "\"\<nupC\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cytR\>\"", "\[Rule]", "\"\<nupG\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cytR\>\"", "\[Rule]", "\"\<ppiA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cytR\>\"", "\[Rule]", "\"\<rpoH\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cytR\>\"", "\[Rule]", "\"\<tsx\>\""}], ",", "3"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<cytR\>\"", "\[Rule]", "\"\<udp\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<deoR\>\"", "\[Rule]", "\"\<deoCABD\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<deoR\>\"", "\[Rule]", "\"\<nupG\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<deoR\>\"", "\[Rule]", "\"\<tsx\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<dnaA\>\"", "\[Rule]", "\"\<nrdAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<dnaA\>\"", "\[Rule]", "\"\<rpoH\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<dsdC\>\"", "\[Rule]", "\"\<dsdXA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ebgR\>\"", "\[Rule]", "\"\<ebgAC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<envY_ompT\>\"", "\[Rule]", "\"\<ompC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<envY_ompT\>\"", "\[Rule]", "\"\<ompF\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<evgA\>\"", "\[Rule]", "\"\<ompC\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<exuR\>\"", "\[Rule]", "\"\<exuT\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<exuR\>\"", "\[Rule]", "\"\<uxaCA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<exuR\>\"", "\[Rule]", "\"\<uxuABR\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fadR\>\"", "\[Rule]", "\"\<fabA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fadR\>\"", "\[Rule]", "\"\<fadBA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fadR\>\"", "\[Rule]", "\"\<fadL\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fadR\>\"", "\[Rule]", "\"\<iclMR\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fadR\>\"", "\[Rule]", "\"\<uspA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fecIR\>\"", "\[Rule]", "\"\<fecABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fhlA\>\"", "\[Rule]", "\"\<fdhF\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fhlA\>\"", "\[Rule]", "\"\<hycABCDEFGH\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fhlA\>\"", "\[Rule]", "\"\<hypABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<flhDC\>\"", "\[Rule]", "\"\<flgAMN\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<flhDC\>\"", "\[Rule]", "\"\<flgBCDEFGHIJK\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<flhDC\>\"", "\[Rule]", "\"\<flhBAE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<flhDC\>\"", "\[Rule]", "\"\<fliAZY\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<flhDC\>\"", "\[Rule]", "\"\<fliE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<flhDC\>\"", "\[Rule]", "\"\<fliFGHIJK\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<flhDC\>\"", "\[Rule]", "\"\<fliLMNOPQR\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<flgBCDEFGHIJK\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<flgKL\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<flgMN\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<flhBAE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<fliC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<fliDST\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<fliE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<fliFGHIJK\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<fliLMNOPQR\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<motABcheAW\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<tarTapcheRBYZ\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fliAZY\>\"", "\[Rule]", "\"\<tsr\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<acs\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<ansB\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<arcA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<aspA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<caiF\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<cydAB\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<cyoABCDE\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<dcuB_fumB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<dmsABC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<fdnGHI\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<focA_pflB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<frdABCD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<glpACB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<hypABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<icdA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<narGHJI\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<narK\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<ndh\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<nirBDC_cysG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<nuoABCEFGHIJKLMN\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<sdhCDAB_b0725_sucABCD\>\""}], 
       ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fnr\>\"", "\[Rule]", "\"\<tdcABCDEFG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<FruR\>\"", "\[Rule]", "\"\<aceBAK\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<FruR\>\"", "\[Rule]", "\"\<adhE\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<FruR\>\"", "\[Rule]", "\"\<fruBKA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<FruR\>\"", "\[Rule]", "\"\<icdA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<FruR\>\"", "\[Rule]", "\"\<ppsA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<FruR\>\"", "\[Rule]", "\"\<ptsHI_crr\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<FruR\>\"", "\[Rule]", "\"\<pykF\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fucPIKUR\>\"", "\[Rule]", "\"\<fucAO\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<cirA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<entCEBA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<fecIR\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<fepA_entD\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<fepB\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<fepDGC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<fhuACDB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<sodA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<fur\>\"", "\[Rule]", "\"\<tonB\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<GalR\>\"", "\[Rule]", "\"\<galETKM\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<GalR\>\"", "\[Rule]", "\"\<galS\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<galS\>\"", "\[Rule]", "\"\<mglBAC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<gatR_1\>\"", "\[Rule]", "\"\<gatYZABCDR_2\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<gcvA\>\"", "\[Rule]", "\"\<gcvTHP\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<gcvR\>\"", "\[Rule]", "\"\<gcvTHP\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<glcC\>\"", "\[Rule]", "\"\<glcDEFGB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<glnALG\>\"", "\[Rule]", "\"\<glnHPQ\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<glnALG\>\"", "\[Rule]", "\"\<nac\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<glpR\>\"", "\[Rule]", "\"\<glpACB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<glpR\>\"", "\[Rule]", "\"\<glpD\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<glpR\>\"", "\[Rule]", "\"\<glpFK\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<glpR\>\"", "\[Rule]", "\"\<glpTQ\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<gntR\>\"", "\[Rule]", "\"\<edd_eda\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<gntR\>\"", "\[Rule]", "\"\<gntKU\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<gntR\>\"", "\[Rule]", "\"\<gntT\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hcaR\>\"", "\[Rule]", "\"\<hcaA1A2CBD_yphA\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<aceBAK\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<caiTABCDE\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<carAB\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<dps\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<ecpD_htrE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<focA_pflB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<glcDEFGB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<glnHPQ\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<himD\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<hycABCDEFGH\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<hypABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<narGHJI\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<narK\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<nuoABCEFGHIJKLMN\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<ompC\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<ompF\>\""}], ",", "3"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<ompR_envZ\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<osmE\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<pspABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<sodA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<himA\>\"", "\[Rule]", "\"\<tdcABCDEFG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hns\>\"", "\[Rule]", "\"\<caiF\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hns\>\"", "\[Rule]", "\"\<flhDC\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hns\>\"", "\[Rule]", "\"\<fliAZY\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hns\>\"", "\[Rule]", "\"\<nhaA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hns\>\"", "\[Rule]", "\"\<osmC\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hns\>\"", "\[Rule]", "\"\<rcsAB\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hns\>\"", "\[Rule]", "\"\<stpA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<hydHG\>\"", "\[Rule]", "\"\<zraP\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<iclMR\>\"", "\[Rule]", "\"\<aceBAK\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<iclMR\>\"", "\[Rule]", "\"\<acs\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ilvY\>\"", "\[Rule]", "\"\<ilvC\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<kdpDE\>\"", "\[Rule]", "\"\<kdpABC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lacI\>\"", "\[Rule]", "\"\<lacZYA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<leuO\>\"", "\[Rule]", "\"\<leuLABCD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<polB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<recA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<recN\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<rpsU_dnaG_rpoD\>\""}], 
       ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<ssb\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<sulA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<umuDC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<uvrA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<uvrB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<uvrC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lexA_dinF\>\"", "\[Rule]", "\"\<uvrD\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<gcvTHP\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<gltBDF\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<ilvIH\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<kbl_tdh\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<livJ\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<livKHMGF\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<lysU\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<ompC\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<ompF\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<oppABCDF\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<osmC\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<sdaA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<serA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lrp\>\"", "\[Rule]", "\"\<stpA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lysR\>\"", "\[Rule]", "\"\<lysA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<lysR\>\"", "\[Rule]", "\"\<tdcABCDEFG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<malI\>\"", "\[Rule]", "\"\<malXY\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<malT\>\"", "\[Rule]", "\"\<malEFG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<malT\>\"", "\[Rule]", "\"\<malK_lamB_malM\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<malT\>\"", "\[Rule]", "\"\<malPQ\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<malT\>\"", "\[Rule]", "\"\<malS\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<malT\>\"", "\[Rule]", "\"\<malZ\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<marRAB\>\"", "\[Rule]", "\"\<fpr\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<marRAB\>\"", "\[Rule]", "\"\<fumC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<marRAB\>\"", "\[Rule]", "\"\<nfo\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<marRAB\>\"", "\[Rule]", "\"\<sodA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<marRAB\>\"", "\[Rule]", "\"\<zwf\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<melR\>\"", "\[Rule]", "\"\<melAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<metJ\>\"", "\[Rule]", "\"\<metA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<metJ\>\"", "\[Rule]", "\"\<metC\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<metJ\>\"", "\[Rule]", "\"\<metF\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<metJ\>\"", "\[Rule]", "\"\<metR\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<metR\>\"", "\[Rule]", "\"\<glyA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<metR\>\"", "\[Rule]", "\"\<metA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<metR\>\"", "\[Rule]", "\"\<metH\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<mhpR\>\"", "\[Rule]", "\"\<mhpABCDFE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<mlc\>\"", "\[Rule]", "\"\<malT\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<mlc\>\"", "\[Rule]", "\"\<manXYZ\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<mlc\>\"", "\[Rule]", "\"\<ptsG\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<mlc\>\"", "\[Rule]", "\"\<ptsHI_crr\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<modE\>\"", "\[Rule]", "\"\<modABC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nac\>\"", "\[Rule]", "\"\<gdhA\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nac\>\"", "\[Rule]", "\"\<putAP\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nadR\>\"", "\[Rule]", "\"\<nadB\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nadR\>\"", "\[Rule]", "\"\<pncB\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nagBACD\>\"", "\[Rule]", "\"\<glmUS\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nagBACD\>\"", "\[Rule]", "\"\<manXYZ\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nagBACD\>\"", "\[Rule]", "\"\<nagE\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<adhE\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<caiF\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<dcuB_fumB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<dmsABC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<fdnGHI\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<focA_pflB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<frdABCD\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<narGHJI\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<narK\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<nirBDC_cysG\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<nrfABCDEFG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<nuoABCEFGHIJKLMN\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<narL\>\"", "\[Rule]", "\"\<torCAD\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nhaR\>\"", "\[Rule]", "\"\<nhaA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<acs\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<adhE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<aldB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<alkA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<appY\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<cpxAR\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<dps\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<ftsQAZ\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<katG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<narZYWV\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<nhaA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<osmC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<osmY\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<nlpD_rpoS\>\"", "\[Rule]", "\"\<proP\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ompR_envZ\>\"", "\[Rule]", "\"\<csgBA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ompR_envZ\>\"", "\[Rule]", "\"\<csgDEFG\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ompR_envZ\>\"", "\[Rule]", "\"\<fadL\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ompR_envZ\>\"", "\[Rule]", "\"\<flhDC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ompR_envZ\>\"", "\[Rule]", "\"\<ompC\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<ompR_envZ\>\"", "\[Rule]", "\"\<ompF\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<oxyR\>\"", "\[Rule]", "\"\<ahpCF\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<oxyR\>\"", "\[Rule]", "\"\<dps\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<oxyR\>\"", "\[Rule]", "\"\<gorA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<oxyR\>\"", "\[Rule]", "\"\<katG\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "\"\<phoBR\>\"", "\[Rule]", "\"\<phnCDE_f73_phnFGHIJKLMNOP\>\""}], ",",
        "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<phoBR\>\"", "\[Rule]", "\"\<phoA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<phoBR\>\"", "\[Rule]", "\"\<phoE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<phoBR\>\"", "\[Rule]", "\"\<pstSCAB_phoU\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<pspF\>\"", "\[Rule]", "\"\<pspABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<codBA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<cvpA_purF_ubiX\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<gcvTHP\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<glnB\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<glyA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<guaBA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<prsA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<purC\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<purEK\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<purHD\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<purL\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<purMN\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<pyrC\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<pyrD\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<speA\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<purR\>\"", "\[Rule]", "\"\<ycfC_purB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rbsR\>\"", "\[Rule]", "\"\<rbsDACBK\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rcsA\>\"", "\[Rule]", "\"\<ftsQAZ\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rcsA\>\"", "\[Rule]", "\"\<wza_wzb_b2060_wcaA_wcaB\>\""}],
        ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rhaSR\>\"", "\[Rule]", "\"\<rhaBAD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rhaSR\>\"", "\[Rule]", "\"\<rhaT\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<aslB\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<fumC\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<galETKM\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<inaA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<marRAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<mdlA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<nfo\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<sodA\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<ybaO\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<ybiS\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<yfhD\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rob\>\"", "\[Rule]", "\"\<zwf\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpiR_alsBACEK\>\"", "\[Rule]", "\"\<rpiB\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<cutC\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<dapA_nlpB_purA\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfABC\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfD\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfF\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfG\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfH\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfI\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfJ\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfK\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ecfLM\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<fkpA\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<htrA\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ksgA_epaG_epaH\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<lpxDA_fabZ\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<mdoGH\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<nlpB_purA\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<ostA_surA_pdxA\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<rfaDFCL\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<rpoD\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<rpoH\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<skp_lpxDA_fabZ\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<uppS_cdsA_ecfE\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoE_rseABC\>\"", "\[Rule]", "\"\<xprB_dsbC_recJ\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<clpP\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<dnaKJ\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<grpE\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<hflB\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<htpG\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<htpY\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<ibpAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<lon\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<mopA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoH\>\"", "\[Rule]", "\"\<mopB\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<atoC\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<dctA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<fdhF\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<fhlA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<glnALG\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<glnHPQ\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<hycABCDEFGH\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<hypA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<nac\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<nycA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<pspABCDE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<rtcR\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rpoN\>\"", "\[Rule]", "\"\<zraP\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<rtcR\>\"", "\[Rule]", "\"\<rtcAB\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<soxR\>\"", "\[Rule]", "\"\<soxS\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<soxS\>\"", "\[Rule]", "\"\<acnA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<soxS\>\"", "\[Rule]", "\"\<fpr\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<soxS\>\"", "\[Rule]", "\"\<fumC\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<soxS\>\"", "\[Rule]", "\"\<nfo\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<soxS\>\"", "\[Rule]", "\"\<sodA\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<soxS\>\"", "\[Rule]", "\"\<zwf\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<tdcAR\>\"", "\[Rule]", "\"\<tdcABCDEFG\>\""}], ",", "1"}],
       "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<torR\>\"", "\[Rule]", "\"\<torCAD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<treR\>\"", "\[Rule]", "\"\<treBC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<trpR\>\"", "\[Rule]", "\"\<aroH\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<trpR\>\"", "\[Rule]", "\"\<aroL_yaiA_aroM\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<trpR\>\"", "\[Rule]", "\"\<mtr\>\""}], ",", "2"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<trpR\>\"", "\[Rule]", "\"\<trpLEDCBA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<tyrR\>\"", "\[Rule]", "\"\<aroF_tyrA\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<tyrR\>\"", "\[Rule]", "\"\<aroG\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<tyrR\>\"", "\[Rule]", "\"\<aroL_yaiA_aroM\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<tyrR\>\"", "\[Rule]", "\"\<aroP\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<tyrR\>\"", "\[Rule]", "\"\<mtr\>\""}], ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<tyrR\>\"", "\[Rule]", "\"\<tyrB\>\""}], ",", "2"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<tyrR\>\"", "\[Rule]", "\"\<tyrP\>\""}], ",", "3"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<uhpA\>\"", "\[Rule]", "\"\<uhpT\>\""}], ",", "1"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<uidR\>\"", "\[Rule]", "\"\<uidRABC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<uxuABR\>\"", "\[Rule]", "\"\<uidRABC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<xapR\>\"", "\[Rule]", "\"\<xapAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<xylFGHR\>\"", "\[Rule]", "\"\<xylAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<adhE\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<alaWX\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<aldB\>\""}], ",", "3"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<argU\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<argW\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<argX_hisR_leuT_proM\>\""}],
        ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<aspV\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<leuQPV\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<leuX\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<lysT_valT_lysW\>\""}], ",",
        "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "\"\<yhdG_fis\>\"", "\[Rule]", "\"\<metT_leuW_glnUW_metU_glnVX\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<metY_yhbC_nusA_infB\>\""}],
        ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<nrdAB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<pdhR_aceEF_lpdA\>\""}], 
       ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<pheU\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<pheV\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<proK\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<proL\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<proP\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "\"\<yhdG_fis\>\"", "\[Rule]", "\"\<sdhCDAB_b0725_sucABCD\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<serT\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<serX\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<thrU_tyrU_glyT_thrT\>\""}],
        ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<thrW\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<tyrTV\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yhdG_fis\>\"", "\[Rule]", "\"\<valUXY_lysV\>\""}], ",", 
       "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yiaJ\>\"", "\[Rule]", "\"\<yiaKLMNOPQRS\>\""}], ",", 
       "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yjbK\>\"", "\[Rule]", "\"\<znuABC\>\""}], ",", "2"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yjdHG\>\"", "\[Rule]", "\"\<dctA\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yjdHG\>\"", "\[Rule]", "\"\<dcuB_fumB\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<yjdHG\>\"", "\[Rule]", "\"\<frdABCD\>\""}], ",", "1"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<zntR\>\"", "\[Rule]", "\"\<zntA\>\""}], ",", "1"}], 
      "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[86]:=",
 CellID->106839369]
}, Closed]],

Cell[CellGroupData[{

Cell["Drawing the Network", "Subsubsubsection",
 CellID->463872852],

Cell["\<\
The network consists of many components. Mouse over vertices to see the \
labels.\
\>", "MathCaption",
 CellID->260890007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}]}], "]"}]], "Input",
 CellLabel->"In[87]:=",
 CellID->1169813756],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxNl3k8VW3Xx2We53k+B2ceTUXKMhbKXVGhyFwoCSUNKpU0ihSiIkWK6CbF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    "], {
     {RGBColor[0.5, 0., 0.], 
      TagBox[
       TooltipBox[LineBox[{1, 2}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{3, 4}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{3, 5}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6, 7}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8, 9}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{10, 11}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12, 13}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12, 14}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12, 15}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12, 16}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 18}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 11}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 10}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 19}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 20}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 21}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 22}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 23}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 24}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 25}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 26}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 27}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 28}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 29}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 30}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 31}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 32}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 33}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 34}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 35}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{19, 50}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 37}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 38}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 39}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 40}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 41}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 42}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{43, 44}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{45, 46}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{47, 48}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{47, 49}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{51, 52}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{51, 53}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{54, 55}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{56, 57}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{56, 58}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{59, 60}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{59, 61}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 63}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 64}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 65}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 66}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 67}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 68}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 69}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 70}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 71}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 73}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 74}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 75}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 13}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 12}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 14}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 15}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 16}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 56}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 57}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 76}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 77}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 78}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 79}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 22}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 80}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 81}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 82}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 83}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 84}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 85}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 58}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 86}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 24}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 87}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 88}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 89}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 90}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 91}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 92}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 93}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 94}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 28}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 95}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 96}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 97}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 29}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 98}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 99}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 100}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 101}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 102}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 103}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 104}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 105}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 106}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 107}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 108}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 109}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 110}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 111}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 112}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 113}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 114}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 115}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 116}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 117}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 118}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 119}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 120}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 121}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 34}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 122}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 123}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 124}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 125}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 126}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 127}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 128}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 129}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 130}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 131}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 169}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 170}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 171}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 172}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 173}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 174}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 175}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{88, 87}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 76}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 195}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 163}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 196}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 197}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 198}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 199}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 35}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{89, 200}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{91, 111}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{94, 208}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{94, 209}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{103, 107}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{106, 102}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{106, 104}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{106, 259}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{106, 105}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{106, 260}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{110, 109}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{112, 283}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{112, 108}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{112, 113}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 351}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 352}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 353}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 354}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 355}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 356}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 357}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 358}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 359}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 360}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{132, 133}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{134, 135}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{134, 136}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{136, 56}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{136, 86}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{136, 172}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{136, 222}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{136, 223}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{136, 224}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{136, 225}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{137, 138}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{139, 140}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{139, 141}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{139, 142}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{139, 143}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{139, 61}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{144, 81}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{144, 145}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{144, 114}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{144, 116}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{144, 121}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{144, 126}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{144, 128}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{146, 81}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{146, 114}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{146, 126}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{147, 148}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{147, 121}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{149, 82}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{150, 83}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{151, 152}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{151, 153}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{154, 152}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{155, 156}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{155, 157}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{155, 158}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{158, 386}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{159, 160}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{159, 23}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{159, 85}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{159, 161}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{159, 162}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{161, 18}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{161, 73}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{163, 164}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{165, 166}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{165, 167}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{165, 168}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 170}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 176}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 177}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 171}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 178}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 179}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 173}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 174}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 175}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 67}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 180}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{172, 70}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 73}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 75}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 17}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 182}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 56}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 20}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 21}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 80}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 183}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 184}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 24}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 185}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 28}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 168}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 30}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 186}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 187}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 188}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 189}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 33}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 34}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{181, 124}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{190, 18}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{190, 191}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{190, 192}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{190, 30}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{190, 193}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{190, 118}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{190, 194}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{201, 90}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{201, 91}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{202, 203}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{204, 205}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{206, 205}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{207, 27}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{209, 278}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{209, 279}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{210, 28}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{210, 95}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{210, 96}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{210, 97}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{211, 212}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{211, 98}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{211, 99}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{213, 214}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 18}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 57}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 42}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 216}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 217}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 24}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 27}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 208}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 218}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 167}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 168}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 186}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 187}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 33}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 152}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 153}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 219}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 220}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 221}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 35}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{215, 124}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{219, 133}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{219, 132}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{219, 85}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{219, 86}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{219, 152}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{219, 153}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{226, 227}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{228, 229}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{230, 231}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{232, 101}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{233, 234}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 236}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 237}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 238}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 239}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 240}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 241}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 242}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 243}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 244}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 245}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{235, 246}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 205}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 248}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 249}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 250}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 251}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 252}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 253}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 152}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 153}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 254}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 223}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 255}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 256}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{247, 225}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{257, 258}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{257, 124}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{261, 262}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{261, 26}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{261, 263}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{261, 35}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{261, 264}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{265, 266}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{265, 267}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{265, 268}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{265, 269}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{269, 270}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{269, 266}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{269, 271}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{272, 273}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{274, 106}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{274, 108}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{274, 275}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{274, 118}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{276, 277}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{280, 281}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{280, 282}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 191}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 56}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 80}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 183}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 184}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 24}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 185}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 186}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 187}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 189}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 285}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 33}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{284, 286}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{287, 222}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 73}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 191}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 74}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 5}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 10}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 62}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 216}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 289}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 290}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 291}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 222}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 223}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 292}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{288, 117}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{293, 294}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{293, 216}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{293, 295}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{293, 290}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{296, 297}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{296, 298}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{296, 299}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{296, 300}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{301, 221}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 303}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 304}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 205}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 305}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 270}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 306}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 307}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 308}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 309}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 310}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 311}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 312}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 313}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 314}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 315}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{302, 316}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{317, 318}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{319, 289}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{319, 320}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{321, 119}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{321, 120}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 323}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 26}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 90}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 324}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 261}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 325}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 263}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 35}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 326}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 327}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 328}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{322, 264}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{329, 330}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 332}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 333}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 334}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 335}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 336}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 337}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 338}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 65}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 339}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 340}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 341}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 342}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 66}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 343}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 344}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 345}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 346}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 347}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 348}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 349}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 121}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 69}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 350}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{331, 71}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 47}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 22}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 166}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 165}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 94}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 208}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 167}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 362}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 209}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 363}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 221}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 364}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{361, 227}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{364, 365}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{366, 367}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{367, 368}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{367, 262}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{367, 26}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{367, 263}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{367, 35}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{367, 264}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{369, 124}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{370, 286}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{371, 372}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{373, 374}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{373, 375}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{373, 376}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{373, 377}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{378, 379}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{378, 380}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{378, 375}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{378, 381}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{378, 376}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{378, 382}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{378, 383}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{384, 129}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{385, 386}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{387, 388}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{389, 390}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 191}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 392}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 74}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 393}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 394}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 395}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 396}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 397}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 398}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 399}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 400}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 401}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 148}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 402}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 403}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 404}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 405}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 406}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 117}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 34}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 407}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 408}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 409}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 410}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 411}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{391, 412}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{413, 131}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{414, 415}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{416, 22}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{416, 80}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{416, 185}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{417, 418}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "\"acrR\""],
       Annotation[#, "acrR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "\"acrAB\""],
       Annotation[#, "acrAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "\"ada_alkB\""],
       Annotation[#, "ada_alkB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "\"aidB\""],
       Annotation[#, "aidB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "\"alkA\""],
       Annotation[#, "alkA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "\"adiA_adiY\""],
       Annotation[#, "adiA_adiY", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "\"adiA\""],
       Annotation[#, "adiA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "\"alpA\""],
       Annotation[#, "alpA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "\"slp\""],
       Annotation[#, "slp", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "\"appY\""],
       Annotation[#, "appY", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "\"appCBA\""],
       Annotation[#, "appCBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "\"araC\""],
       Annotation[#, "araC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "\"araBAD\""],
       Annotation[#, "araBAD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "\"araE\""],
       Annotation[#, "araE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "\"araFG_araH_1H_2\""],
       Annotation[#, "araFG_araH_1H_2", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "\"araJ\""],
       Annotation[#, "araJ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "\"arcA\""],
       Annotation[#, "arcA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "\"aceBAK\""],
       Annotation[#, "aceBAK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "\"betIBA\""],
       Annotation[#, "betIBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "\"cydAB\""],
       Annotation[#, "cydAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "\"cyoABCDE\""],
       Annotation[#, "cyoABCDE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "\"dctA\""],
       Annotation[#, "dctA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "\"fadBA\""],
       Annotation[#, "fadBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "\"focA_pflB\""],
       Annotation[#, "focA_pflB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "\"fumA\""],
       Annotation[#, "fumA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "\"fumC\""],
       Annotation[#, "fumC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "\"glcDEFGB\""],
       Annotation[#, "glcDEFGB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "\"glpACB\""],
       Annotation[#, "glpACB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "\"gltA\""],
       Annotation[#, "gltA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "\"icdA\""],
       Annotation[#, "icdA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "\"lctPRD\""],
       Annotation[#, "lctPRD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "\"mdh\""],
       Annotation[#, "mdh", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "\"nuoABCEFGHIJKLMN\""],
       Annotation[#, "nuoABCEFGHIJKLMN", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "\"sdhCDAB_b0725_sucABCD\""],
       Annotation[#, "sdhCDAB_b0725_sucABCD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "\"sodA\""],
       Annotation[#, "sodA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "\"argR\""],
       Annotation[#, "argR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "\"argCBH\""],
       Annotation[#, "argCBH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "\"argD\""],
       Annotation[#, "argD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "\"argE\""],
       Annotation[#, "argE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "\"argF\""],
       Annotation[#, "argF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "\"argI\""],
       Annotation[#, "argI", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "\"carAB\""],
       Annotation[#, "carAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "\"arsR\""],
       Annotation[#, "arsR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "\"arsEFG\""],
       Annotation[#, "arsEFG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "\"asnC\""],
       Annotation[#, "asnC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "\"asnA\""],
       Annotation[#, "asnA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "\"atoC\""],
       Annotation[#, "atoC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "\"atoDAB\""],
       Annotation[#, "atoDAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "\"atoDAE\""],
       Annotation[#, "atoDAE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "\"betT\""],
       Annotation[#, "betT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "\"birA_murA\""],
       Annotation[#, "birA_murA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "\"bioA\""],
       Annotation[#, "bioA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "\"bioBFCD\""],
       Annotation[#, "bioBFCD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "\"cadC\""],
       Annotation[#, "cadC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "\"cadBA\""],
       Annotation[#, "cadBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "\"caiF\""],
       Annotation[#, "caiF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "\"caiTABCDE\""],
       Annotation[#, "caiTABCDE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "\"fixABCX\""],
       Annotation[#, "fixABCX", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "\"cbl\""],
       Annotation[#, "cbl", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "\"ssuEADCB\""],
       Annotation[#, "ssuEADCB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "\"tauABCD\""],
       Annotation[#, "tauABCD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "\"cpxAR\""],
       Annotation[#, "cpxAR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "\"cpxP\""],
       Annotation[#, "cpxP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "\"dsbA\""],
       Annotation[#, "dsbA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "\"ecfI\""],
       Annotation[#, "ecfI", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "\"htrA\""],
       Annotation[#, "htrA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "\"motABcheAW\""],
       Annotation[#, "motABcheAW", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "\"rotA\""],
       Annotation[#, "rotA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "\"skp_lpxDA_fabZ\""],
       Annotation[#, "skp_lpxDA_fabZ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "\"tsr\""],
       Annotation[#, "tsr", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "\"xprB_dsbC_recJ\""],
       Annotation[#, "xprB_dsbC_recJ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "\"crp\""],
       Annotation[#, "crp", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "\"acs\""],
       Annotation[#, "acs", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "\"aldB\""],
       Annotation[#, "aldB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "\"ansB\""],
       Annotation[#, "ansB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "\"cirA\""],
       Annotation[#, "cirA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "\"cpdB\""],
       Annotation[#, "cpdB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "\"cyaA\""],
       Annotation[#, "cyaA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "\"dadAX\""],
       Annotation[#, "dadAX", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "\"dcuB_fumB\""],
       Annotation[#, "dcuB_fumB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "\"deoCABD\""],
       Annotation[#, "deoCABD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "\"dsdXA\""],
       Annotation[#, "dsdXA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "\"ebgAC\""],
       Annotation[#, "ebgAC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "\"epd_pgk\""],
       Annotation[#, "epd_pgk", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "\"fadL\""],
       Annotation[#, "fadL", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "\"flhDC\""],
       Annotation[#, "flhDC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "\"fucAO\""],
       Annotation[#, "fucAO", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "\"fucPIKUR\""],
       Annotation[#, "fucPIKUR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "\"fur\""],
       Annotation[#, "fur", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "\"galETKM\""],
       Annotation[#, "galETKM", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "\"galS\""],
       Annotation[#, "galS", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "\"glgCAP\""],
       Annotation[#, "glgCAP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "\"glgS\""],
       Annotation[#, "glgS", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "\"glnALG\""],
       Annotation[#, "glnALG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "\"glpD\""],
       Annotation[#, "glpD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "\"glpFK\""],
       Annotation[#, "glpFK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "\"glpTQ\""],
       Annotation[#, "glpTQ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "\"gntKU\""],
       Annotation[#, "gntKU", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "\"gntT\""],
       Annotation[#, "gntT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "\"ivbL_ilvBN\""],
       Annotation[#, "ivbL_ilvBN", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "\"lacZYA\""],
       Annotation[#, "lacZYA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "\"malEFG\""],
       Annotation[#, "malEFG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "\"malI\""],
       Annotation[#, "malI", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "\"malK_lamB_malM\""],
       Annotation[#, "malK_lamB_malM", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "\"malS\""],
       Annotation[#, "malS", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "\"malT\""],
       Annotation[#, "malT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "\"malXY\""],
       Annotation[#, "malXY", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "\"manXYZ\""],
       Annotation[#, "manXYZ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "\"melAB\""],
       Annotation[#, "melAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "\"melR\""],
       Annotation[#, "melR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "\"mglBAC\""],
       Annotation[#, "mglBAC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "\"nagBACD\""],
       Annotation[#, "nagBACD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "\"nagE\""],
       Annotation[#, "nagE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "\"nupG\""],
       Annotation[#, "nupG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "\"ompA\""],
       Annotation[#, "ompA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "\"ppiA\""],
       Annotation[#, "ppiA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "\"proP\""],
       Annotation[#, "proP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "\"ptsHI_crr\""],
       Annotation[#, "ptsHI_crr", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "\"rhaBAD\""],
       Annotation[#, "rhaBAD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "\"rhaT\""],
       Annotation[#, "rhaT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "\"rpoH\""],
       Annotation[#, "rpoH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "\"speC\""],
       Annotation[#, "speC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "\"srlAEBD_gutM_srlR_gutQ\""],
       Annotation[#, "srlAEBD_gutM_srlR_gutQ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        "\"tdcABCDEFG\""],
       Annotation[#, "tdcABCDEFG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "\"tnaLAB\""],
       Annotation[#, "tnaLAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "\"tsx\""],
       Annotation[#, "tsx", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "\"ubiG\""],
       Annotation[#, "ubiG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[128],
        "\"udp\""],
       Annotation[#, "udp", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[129],
        "\"uhpT\""],
       Annotation[#, "uhpT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[130],
        "\"yhfA\""],
       Annotation[#, "yhfA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[131],
        "\"yiaKLMNOPQRS\""],
       Annotation[#, "yiaKLMNOPQRS", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[132],
        "\"csgDEFG\""],
       Annotation[#, "csgDEFG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[133],
        "\"csgBA\""],
       Annotation[#, "csgBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[134],
        "\"cspA\""],
       Annotation[#, "cspA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[135],
        "\"gyrA\""],
       Annotation[#, "gyrA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[136],
        "\"hns\""],
       Annotation[#, "hns", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[137],
        "\"cynR\""],
       Annotation[#, "cynR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[138],
        "\"cynTSX\""],
       Annotation[#, "cynTSX", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[139],
        "\"cysB\""],
       Annotation[#, "cysB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[140],
        "\"cysDNC\""],
       Annotation[#, "cysDNC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[141],
        "\"cysJIH\""],
       Annotation[#, "cysJIH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[142],
        "\"cysK\""],
       Annotation[#, "cysK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[143],
        "\"cysPUWAM\""],
       Annotation[#, "cysPUWAM", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[144],
        "\"cytR\""],
       Annotation[#, "cytR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[145],
        "\"nupC\""],
       Annotation[#, "nupC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[146],
        "\"deoR\""],
       Annotation[#, "deoR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[147],
        "\"dnaA\""],
       Annotation[#, "dnaA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[148],
        "\"nrdAB\""],
       Annotation[#, "nrdAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[149],
        "\"dsdC\""],
       Annotation[#, "dsdC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[150],
        "\"ebgR\""],
       Annotation[#, "ebgR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[151],
        "\"envY_ompT\""],
       Annotation[#, "envY_ompT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[152],
        "\"ompC\""],
       Annotation[#, "ompC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[153],
        "\"ompF\""],
       Annotation[#, "ompF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[154],
        "\"evgA\""],
       Annotation[#, "evgA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[155],
        "\"exuR\""],
       Annotation[#, "exuR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[156],
        "\"exuT\""],
       Annotation[#, "exuT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[157],
        "\"uxaCA\""],
       Annotation[#, "uxaCA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[158],
        "\"uxuABR\""],
       Annotation[#, "uxuABR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[159],
        "\"fadR\""],
       Annotation[#, "fadR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[160],
        "\"fabA\""],
       Annotation[#, "fabA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[161],
        "\"iclMR\""],
       Annotation[#, "iclMR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[162],
        "\"uspA\""],
       Annotation[#, "uspA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[163],
        "\"fecIR\""],
       Annotation[#, "fecIR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[164],
        "\"fecABCDE\""],
       Annotation[#, "fecABCDE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[165],
        "\"fhlA\""],
       Annotation[#, "fhlA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[166],
        "\"fdhF\""],
       Annotation[#, "fdhF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[167],
        "\"hycABCDEFGH\""],
       Annotation[#, "hycABCDEFGH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[168],
        "\"hypABCDE\""],
       Annotation[#, "hypABCDE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[169],
        "\"flgAMN\""],
       Annotation[#, "flgAMN", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[170],
        "\"flgBCDEFGHIJK\""],
       Annotation[#, "flgBCDEFGHIJK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[171],
        "\"flhBAE\""],
       Annotation[#, "flhBAE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[172],
        "\"fliAZY\""],
       Annotation[#, "fliAZY", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[173],
        "\"fliE\""],
       Annotation[#, "fliE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[174],
        "\"fliFGHIJK\""],
       Annotation[#, "fliFGHIJK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[175],
        "\"fliLMNOPQR\""],
       Annotation[#, "fliLMNOPQR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[176],
        "\"flgKL\""],
       Annotation[#, "flgKL", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[177],
        "\"flgMN\""],
       Annotation[#, "flgMN", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[178],
        "\"fliC\""],
       Annotation[#, "fliC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[179],
        "\"fliDST\""],
       Annotation[#, "fliDST", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[180],
        "\"tarTapcheRBYZ\""],
       Annotation[#, "tarTapcheRBYZ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[181],
        "\"fnr\""],
       Annotation[#, "fnr", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[182],
        "\"aspA\""],
       Annotation[#, "aspA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[183],
        "\"dmsABC\""],
       Annotation[#, "dmsABC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[184],
        "\"fdnGHI\""],
       Annotation[#, "fdnGHI", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[185],
        "\"frdABCD\""],
       Annotation[#, "frdABCD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[186],
        "\"narGHJI\""],
       Annotation[#, "narGHJI", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[187],
        "\"narK\""],
       Annotation[#, "narK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[188],
        "\"ndh\""],
       Annotation[#, "ndh", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[189],
        "\"nirBDC_cysG\""],
       Annotation[#, "nirBDC_cysG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[190],
        "\"FruR\""],
       Annotation[#, "FruR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[191],
        "\"adhE\""],
       Annotation[#, "adhE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[192],
        "\"fruBKA\""],
       Annotation[#, "fruBKA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[193],
        "\"ppsA\""],
       Annotation[#, "ppsA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[194],
        "\"pykF\""],
       Annotation[#, "pykF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[195],
        "\"entCEBA\""],
       Annotation[#, "entCEBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[196],
        "\"fepA_entD\""],
       Annotation[#, "fepA_entD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[197],
        "\"fepB\""],
       Annotation[#, "fepB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[198],
        "\"fepDGC\""],
       Annotation[#, "fepDGC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[199],
        "\"fhuACDB\""],
       Annotation[#, "fhuACDB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[200],
        "\"tonB\""],
       Annotation[#, "tonB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[201],
        "\"GalR\""],
       Annotation[#, "GalR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[202],
        "\"gatR_1\""],
       Annotation[#, "gatR_1", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[203],
        "\"gatYZABCDR_2\""],
       Annotation[#, "gatYZABCDR_2", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[204],
        "\"gcvA\""],
       Annotation[#, "gcvA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[205],
        "\"gcvTHP\""],
       Annotation[#, "gcvTHP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[206],
        "\"gcvR\""],
       Annotation[#, "gcvR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[207],
        "\"glcC\""],
       Annotation[#, "glcC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[208],
        "\"glnHPQ\""],
       Annotation[#, "glnHPQ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[209],
        "\"nac\""],
       Annotation[#, "nac", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[210],
        "\"glpR\""],
       Annotation[#, "glpR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[211],
        "\"gntR\""],
       Annotation[#, "gntR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[212],
        "\"edd_eda\""],
       Annotation[#, "edd_eda", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[213],
        "\"hcaR\""],
       Annotation[#, "hcaR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[214],
        "\"hcaA1A2CBD_yphA\""],
       Annotation[#, "hcaA1A2CBD_yphA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[215],
        "\"himA\""],
       Annotation[#, "himA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[216],
        "\"dps\""],
       Annotation[#, "dps", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[217],
        "\"ecpD_htrE\""],
       Annotation[#, "ecpD_htrE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[218],
        "\"himD\""],
       Annotation[#, "himD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[219],
        "\"ompR_envZ\""],
       Annotation[#, "ompR_envZ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[220],
        "\"osmE\""],
       Annotation[#, "osmE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[221],
        "\"pspABCDE\""],
       Annotation[#, "pspABCDE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[222],
        "\"nhaA\""],
       Annotation[#, "nhaA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[223],
        "\"osmC\""],
       Annotation[#, "osmC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[224],
        "\"rcsAB\""],
       Annotation[#, "rcsAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[225],
        "\"stpA\""],
       Annotation[#, "stpA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[226],
        "\"hydHG\""],
       Annotation[#, "hydHG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[227],
        "\"zraP\""],
       Annotation[#, "zraP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[228],
        "\"ilvY\""],
       Annotation[#, "ilvY", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[229],
        "\"ilvC\""],
       Annotation[#, "ilvC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[230],
        "\"kdpDE\""],
       Annotation[#, "kdpDE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[231],
        "\"kdpABC\""],
       Annotation[#, "kdpABC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[232],
        "\"lacI\""],
       Annotation[#, "lacI", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[233],
        "\"leuO\""],
       Annotation[#, "leuO", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[234],
        "\"leuLABCD\""],
       Annotation[#, "leuLABCD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[235],
        "\"lexA_dinF\""],
       Annotation[#, "lexA_dinF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[236],
        "\"polB\""],
       Annotation[#, "polB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[237],
        "\"recA\""],
       Annotation[#, "recA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[238],
        "\"recN\""],
       Annotation[#, "recN", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[239],
        "\"rpsU_dnaG_rpoD\""],
       Annotation[#, "rpsU_dnaG_rpoD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[240],
        "\"ssb\""],
       Annotation[#, "ssb", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[241],
        "\"sulA\""],
       Annotation[#, "sulA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[242],
        "\"umuDC\""],
       Annotation[#, "umuDC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[243],
        "\"uvrA\""],
       Annotation[#, "uvrA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[244],
        "\"uvrB\""],
       Annotation[#, "uvrB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[245],
        "\"uvrC\""],
       Annotation[#, "uvrC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[246],
        "\"uvrD\""],
       Annotation[#, "uvrD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[247],
        "\"lrp\""],
       Annotation[#, "lrp", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[248],
        "\"gltBDF\""],
       Annotation[#, "gltBDF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[249],
        "\"ilvIH\""],
       Annotation[#, "ilvIH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[250],
        "\"kbl_tdh\""],
       Annotation[#, "kbl_tdh", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[251],
        "\"livJ\""],
       Annotation[#, "livJ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[252],
        "\"livKHMGF\""],
       Annotation[#, "livKHMGF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[253],
        "\"lysU\""],
       Annotation[#, "lysU", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[254],
        "\"oppABCDF\""],
       Annotation[#, "oppABCDF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[255],
        "\"sdaA\""],
       Annotation[#, "sdaA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[256],
        "\"serA\""],
       Annotation[#, "serA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[257],
        "\"lysR\""],
       Annotation[#, "lysR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[258],
        "\"lysA\""],
       Annotation[#, "lysA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[259],
        "\"malPQ\""],
       Annotation[#, "malPQ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[260],
        "\"malZ\""],
       Annotation[#, "malZ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[261],
        "\"marRAB\""],
       Annotation[#, "marRAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[262],
        "\"fpr\""],
       Annotation[#, "fpr", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[263],
        "\"nfo\""],
       Annotation[#, "nfo", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[264],
        "\"zwf\""],
       Annotation[#, "zwf", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[265],
        "\"metJ\""],
       Annotation[#, "metJ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[266],
        "\"metA\""],
       Annotation[#, "metA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[267],
        "\"metC\""],
       Annotation[#, "metC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[268],
        "\"metF\""],
       Annotation[#, "metF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[269],
        "\"metR\""],
       Annotation[#, "metR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[270],
        "\"glyA\""],
       Annotation[#, "glyA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[271],
        "\"metH\""],
       Annotation[#, "metH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[272],
        "\"mhpR\""],
       Annotation[#, "mhpR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[273],
        "\"mhpABCDFE\""],
       Annotation[#, "mhpABCDFE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[274],
        "\"mlc\""],
       Annotation[#, "mlc", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[275],
        "\"ptsG\""],
       Annotation[#, "ptsG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[276],
        "\"modE\""],
       Annotation[#, "modE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[277],
        "\"modABC\""],
       Annotation[#, "modABC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[278],
        "\"gdhA\""],
       Annotation[#, "gdhA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[279],
        "\"putAP\""],
       Annotation[#, "putAP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[280],
        "\"nadR\""],
       Annotation[#, "nadR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[281],
        "\"nadB\""],
       Annotation[#, "nadB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[282],
        "\"pncB\""],
       Annotation[#, "pncB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[283],
        "\"glmUS\""],
       Annotation[#, "glmUS", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[284],
        "\"narL\""],
       Annotation[#, "narL", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[285],
        "\"nrfABCDEFG\""],
       Annotation[#, "nrfABCDEFG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[286],
        "\"torCAD\""],
       Annotation[#, "torCAD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[287],
        "\"nhaR\""],
       Annotation[#, "nhaR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[288],
        "\"nlpD_rpoS\""],
       Annotation[#, "nlpD_rpoS", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[289],
        "\"ftsQAZ\""],
       Annotation[#, "ftsQAZ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[290],
        "\"katG\""],
       Annotation[#, "katG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[291],
        "\"narZYWV\""],
       Annotation[#, "narZYWV", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[292],
        "\"osmY\""],
       Annotation[#, "osmY", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[293],
        "\"oxyR\""],
       Annotation[#, "oxyR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[294],
        "\"ahpCF\""],
       Annotation[#, "ahpCF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[295],
        "\"gorA\""],
       Annotation[#, "gorA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[296],
        "\"phoBR\""],
       Annotation[#, "phoBR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[297],
        "\"phnCDE_f73_phnFGHIJKLMNOP\""],
       Annotation[#, "phnCDE_f73_phnFGHIJKLMNOP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[298],
        "\"phoA\""],
       Annotation[#, "phoA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[299],
        "\"phoE\""],
       Annotation[#, "phoE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[300],
        "\"pstSCAB_phoU\""],
       Annotation[#, "pstSCAB_phoU", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[301],
        "\"pspF\""],
       Annotation[#, "pspF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[302],
        "\"purR\""],
       Annotation[#, "purR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[303],
        "\"codBA\""],
       Annotation[#, "codBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[304],
        "\"cvpA_purF_ubiX\""],
       Annotation[#, "cvpA_purF_ubiX", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[305],
        "\"glnB\""],
       Annotation[#, "glnB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[306],
        "\"guaBA\""],
       Annotation[#, "guaBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[307],
        "\"prsA\""],
       Annotation[#, "prsA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[308],
        "\"purC\""],
       Annotation[#, "purC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[309],
        "\"purEK\""],
       Annotation[#, "purEK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[310],
        "\"purHD\""],
       Annotation[#, "purHD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[311],
        "\"purL\""],
       Annotation[#, "purL", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[312],
        "\"purMN\""],
       Annotation[#, "purMN", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[313],
        "\"pyrC\""],
       Annotation[#, "pyrC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[314],
        "\"pyrD\""],
       Annotation[#, "pyrD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[315],
        "\"speA\""],
       Annotation[#, "speA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[316],
        "\"ycfC_purB\""],
       Annotation[#, "ycfC_purB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[317],
        "\"rbsR\""],
       Annotation[#, "rbsR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[318],
        "\"rbsDACBK\""],
       Annotation[#, "rbsDACBK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[319],
        "\"rcsA\""],
       Annotation[#, "rcsA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[320],
        "\"wza_wzb_b2060_wcaA_wcaB\""],
       Annotation[#, "wza_wzb_b2060_wcaA_wcaB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[321],
        "\"rhaSR\""],
       Annotation[#, "rhaSR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[322],
        "\"rob\""],
       Annotation[#, "rob", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[323],
        "\"aslB\""],
       Annotation[#, "aslB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[324],
        "\"inaA\""],
       Annotation[#, "inaA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[325],
        "\"mdlA\""],
       Annotation[#, "mdlA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[326],
        "\"ybaO\""],
       Annotation[#, "ybaO", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[327],
        "\"ybiS\""],
       Annotation[#, "ybiS", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[328],
        "\"yfhD\""],
       Annotation[#, "yfhD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[329],
        "\"rpiR_alsBACEK\""],
       Annotation[#, "rpiR_alsBACEK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[330],
        "\"rpiB\""],
       Annotation[#, "rpiB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[331],
        "\"rpoE_rseABC\""],
       Annotation[#, "rpoE_rseABC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[332],
        "\"cutC\""],
       Annotation[#, "cutC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[333],
        "\"dapA_nlpB_purA\""],
       Annotation[#, "dapA_nlpB_purA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[334],
        "\"ecfABC\""],
       Annotation[#, "ecfABC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[335],
        "\"ecfD\""],
       Annotation[#, "ecfD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[336],
        "\"ecfF\""],
       Annotation[#, "ecfF", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[337],
        "\"ecfG\""],
       Annotation[#, "ecfG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[338],
        "\"ecfH\""],
       Annotation[#, "ecfH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[339],
        "\"ecfJ\""],
       Annotation[#, "ecfJ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[340],
        "\"ecfK\""],
       Annotation[#, "ecfK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[341],
        "\"ecfLM\""],
       Annotation[#, "ecfLM", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[342],
        "\"fkpA\""],
       Annotation[#, "fkpA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[343],
        "\"ksgA_epaG_epaH\""],
       Annotation[#, "ksgA_epaG_epaH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[344],
        "\"lpxDA_fabZ\""],
       Annotation[#, "lpxDA_fabZ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[345],
        "\"mdoGH\""],
       Annotation[#, "mdoGH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[346],
        "\"nlpB_purA\""],
       Annotation[#, "nlpB_purA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[347],
        "\"ostA_surA_pdxA\""],
       Annotation[#, "ostA_surA_pdxA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[348],
        "\"rfaDFCL\""],
       Annotation[#, "rfaDFCL", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[349],
        "\"rpoD\""],
       Annotation[#, "rpoD", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[350],
        "\"uppS_cdsA_ecfE\""],
       Annotation[#, "uppS_cdsA_ecfE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[351],
        "\"clpP\""],
       Annotation[#, "clpP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[352],
        "\"dnaKJ\""],
       Annotation[#, "dnaKJ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[353],
        "\"grpE\""],
       Annotation[#, "grpE", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[354],
        "\"hflB\""],
       Annotation[#, "hflB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[355],
        "\"htpG\""],
       Annotation[#, "htpG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[356],
        "\"htpY\""],
       Annotation[#, "htpY", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[357],
        "\"ibpAB\""],
       Annotation[#, "ibpAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[358],
        "\"lon\""],
       Annotation[#, "lon", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[359],
        "\"mopA\""],
       Annotation[#, "mopA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[360],
        "\"mopB\""],
       Annotation[#, "mopB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[361],
        "\"rpoN\""],
       Annotation[#, "rpoN", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[362],
        "\"hypA\""],
       Annotation[#, "hypA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[363],
        "\"nycA\""],
       Annotation[#, "nycA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[364],
        "\"rtcR\""],
       Annotation[#, "rtcR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[365],
        "\"rtcAB\""],
       Annotation[#, "rtcAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[366],
        "\"soxR\""],
       Annotation[#, "soxR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[367],
        "\"soxS\""],
       Annotation[#, "soxS", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[368],
        "\"acnA\""],
       Annotation[#, "acnA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[369],
        "\"tdcAR\""],
       Annotation[#, "tdcAR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[370],
        "\"torR\""],
       Annotation[#, "torR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[371],
        "\"treR\""],
       Annotation[#, "treR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[372],
        "\"treBC\""],
       Annotation[#, "treBC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[373],
        "\"trpR\""],
       Annotation[#, "trpR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[374],
        "\"aroH\""],
       Annotation[#, "aroH", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[375],
        "\"aroL_yaiA_aroM\""],
       Annotation[#, "aroL_yaiA_aroM", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[376],
        "\"mtr\""],
       Annotation[#, "mtr", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[377],
        "\"trpLEDCBA\""],
       Annotation[#, "trpLEDCBA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[378],
        "\"tyrR\""],
       Annotation[#, "tyrR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[379],
        "\"aroF_tyrA\""],
       Annotation[#, "aroF_tyrA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[380],
        "\"aroG\""],
       Annotation[#, "aroG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[381],
        "\"aroP\""],
       Annotation[#, "aroP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[382],
        "\"tyrB\""],
       Annotation[#, "tyrB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[383],
        "\"tyrP\""],
       Annotation[#, "tyrP", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[384],
        "\"uhpA\""],
       Annotation[#, "uhpA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[385],
        "\"uidR\""],
       Annotation[#, "uidR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[386],
        "\"uidRABC\""],
       Annotation[#, "uidRABC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[387],
        "\"xapR\""],
       Annotation[#, "xapR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[388],
        "\"xapAB\""],
       Annotation[#, "xapAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[389],
        "\"xylFGHR\""],
       Annotation[#, "xylFGHR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[390],
        "\"xylAB\""],
       Annotation[#, "xylAB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[391],
        "\"yhdG_fis\""],
       Annotation[#, "yhdG_fis", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[392],
        "\"alaWX\""],
       Annotation[#, "alaWX", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[393],
        "\"argU\""],
       Annotation[#, "argU", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[394],
        "\"argW\""],
       Annotation[#, "argW", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[395],
        "\"argX_hisR_leuT_proM\""],
       Annotation[#, "argX_hisR_leuT_proM", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[396],
        "\"aspV\""],
       Annotation[#, "aspV", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[397],
        "\"leuQPV\""],
       Annotation[#, "leuQPV", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[398],
        "\"leuX\""],
       Annotation[#, "leuX", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[399],
        "\"lysT_valT_lysW\""],
       Annotation[#, "lysT_valT_lysW", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[400],
        "\"metT_leuW_glnUW_metU_glnVX\""],
       Annotation[#, "metT_leuW_glnUW_metU_glnVX", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[401],
        "\"metY_yhbC_nusA_infB\""],
       Annotation[#, "metY_yhbC_nusA_infB", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[402],
        "\"pdhR_aceEF_lpdA\""],
       Annotation[#, "pdhR_aceEF_lpdA", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[403],
        "\"pheU\""],
       Annotation[#, "pheU", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[404],
        "\"pheV\""],
       Annotation[#, "pheV", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[405],
        "\"proK\""],
       Annotation[#, "proK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[406],
        "\"proL\""],
       Annotation[#, "proL", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[407],
        "\"serT\""],
       Annotation[#, "serT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[408],
        "\"serX\""],
       Annotation[#, "serX", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[409],
        "\"thrU_tyrU_glyT_thrT\""],
       Annotation[#, "thrU_tyrU_glyT_thrT", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[410],
        "\"thrW\""],
       Annotation[#, "thrW", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[411],
        "\"tyrTV\""],
       Annotation[#, "tyrTV", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[412],
        "\"valUXY_lysV\""],
       Annotation[#, "valUXY_lysV", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[413],
        "\"yiaJ\""],
       Annotation[#, "yiaJ", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[414],
        "\"yjbK\""],
       Annotation[#, "yjbK", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[415],
        "\"znuABC\""],
       Annotation[#, "znuABC", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[416],
        "\"yjdHG\""],
       Annotation[#, "yjdHG", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[417],
        "\"zntR\""],
       Annotation[#, "zntR", "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[418],
        "\"zntA\""],
       Annotation[#, "zntA", "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNl3k8VW3Xx2We53k+B2ceTUXKMhbKXVGhyFwoCSUNKpU0ihSiIkWK6CbF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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[87]=",
 CellID->172167522]
}, Open  ]],

Cell["Use a different component packing method.", "MathCaption",
 CellID->1342652139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}], ",", 
   RowBox[{"PackingMethod", "\[Rule]", "\"\<ClosestPackingCenter\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[88]:=",
 CellID->1597561413],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxVmXs8lNv3x8dgGNdhzMV9VC5FckSp5FnVhIQoSkKIilQqlUpROXSRKEml
Qm6hqCRK7V0JCamDEELINXcNkd8c5by+v/lnXu/XXnuvvffzedZeaz9q7nvX
e5JJJFKCAIn0778Hr+pegf0kCmp3CIioooP+RNfGljQK9t7nOM0xy+Ov3dlC
Be/xY93dgaI4ZlPl+V/eFFBJjXPQXy2FeVtnm/DcJeGgya2MdjcSnhnvsB5D
dk0QG8+MdyGJ/j8sB3ThAaekKoU//mgweXFwmoU8uWNdgTJQAdJxLWIdBDn2
/afP4zIwp1M9QXP4B5Eo3uX/7hcDSK2BjUd0EtC880nczfsYgCM16dk+r1Fu
8T4vZWUmcKzeUp0t36J6iiH1zismkKILNKty8lB+msKWxgwGBL3KN3u05jmx
ckzOelGiLIz7jaeGuQrA99omA9REgzmnRKsUqieI0sDvZrFf6ZDIylmsKyIG
Klm3TY7PkwWtiTcBjzYLwqvb+0raovnzjSrUK9EUhEuNxILOZBmQuOS/+M0L
Ekws+1b1rU4SjJ5w41eFTRDJHt6pAx4yoBeS9tcqz1HCNGXStqdWBnjDRm2Y
JwK6h0LVIh7JAan+dm2jmQQMS/W6BdySADygEBToIAQede5lK6fokL8jWG7+
yChhIBTZzmqQg4rzS7z/GfxBKImPmXd20MHazblcXFgANuZIPbU4KQuJXhvs
7gmIwim2aSJ5Ph3Y3+4l3z0jAkKNSGa/iDQYF/o/k3acIizmZ5b4B7OA53gu
peDDAFE5rz3naxIdalr2Ro0UiwJHVzV205NPRDl3HvGiRgY4u9+5jPL+QZzZ
9mStYDoEFdWUvzd9gxTMOeR5G/nryDUQq9HNIsLsXgaGXONzYKDKo+Q7aI4w
5fnNUb79J4arbE0hMhH/hUIs6eCqzNtBfBkjmoae9c49RoUzJf/qhI29kxJ6
rtv/IH6zEqZ/SJ3mtUddT20gqfynp9+s8J+edN5W6ru1U2BPUmysCPDXsVpN
+LaVMCj05dOWCDDhzI145wNiFPC/p+1Vd5wJp8LrLe6TGbDz69T+kk3Sf8aT
gBn9/mYhuKMgO80ay/VeziXJgtsz5jSbPEviz0sQX/MoTxHQVobfLI5P972f
ZogIl95jRAPYlEs0Fn4hNPLtdaowX2+FpVzynX5iT0HjPvsXshDU3rB527dP
xO7cJVZRu5k4lbJ65aNLsthxKJ3XWcfCurTSxfU3aDjoeFG8CYmB1SafW547
K4fdh491xWjRoVG3rshpmIqX6oW8vhIiC/6HFsQ2l0jjeVY6jxVV6bD9cPNU
+pA0zmrfMJSfzgSdsN7v0W40POtrvGsDwYTVo82UyHAaznVD3YZuUpAvtfud
QQEF7y/W2LOuTwZakkS7pSKksffTmwbKB5hQVtZvrdhAw3POplhzhiThDZnC
fXdABAflhd24Q2HCxZiPzbOFZXC/qa3M64VMwPnkpvqxJsKxOeDu08cyYKN5
NbHA+QsRsNWwRnaCBXGn3LMXhFWj8ckvYv4RdNip9Sz3Qv4AEXta7Mh7fzbM
8VocvvTVOKFR/n2WYTkT/KWSds+nDxEWR9f9ZGMWcBLCLbB6EXFf9tXlT3n8
9//HxIZHVb2E67aVJpKe/Lj2UsvrKxohXn1Q/2i+jA2c60dKX2q3oFiGOmPV
OwUgiXta1NQUE75r9TZHHmHAmY2T5RHpLYhr+vOXPYkBWapvK3/WVBHBKOtx
5jMpSG2NcdoW2kbEXJwbFGApDiTmcMoLtS60cXGga3oZX/e/3mlIXH2JcjeK
GUk+5rPNjmqnxENEyX2J4tgkeTCul5s8iIWgfL4J77A2C/B6PYsNOoIwTGL9
HWfFhuBtyH/F1R9E6aYliRM1bIDDG8p7GtqJRSmXKsJfsiGLQbsr+KSXiPAZ
8zROoUGJwIPbJ8iC0KJZIVjFYgD754pY/8puIuw+aXFnLgNiVkiM/as3rRaL
QxsC5IDtPBzlkf2NMF8T/YgcqwBnvi/I0l4wSCy9LuLk7aIARpEtKv/kDRF+
rtz3dhQWwPUjPsF/I4Jb8/VuzjYmVBw3tTwo2YoiHIKTY7rkwbc7abzjbBtR
1622xkyGv78yj56oL+0hfKtF365Okwec9fj+4fW9hCyEaoi+5vOxuMZzOp3E
i1bXCDNPRYjp8fNPdusl9Jb6XxYKZUHu8WCkueM7YbHtsEi8qwL4GmSYGC1o
JmgSPVHlPDa4fvV54080EZYNweajW9mAP4SyO/Y0Eo1b7e8o67HB3KevsLNu
kPA11dDeeZjvD3ksyOAiVL+vKXkbsIEE4H5B5jTKmL+urKOVBbRnr5WGBFpR
Tz1JT8uPDRFkrXbNhgriaVHjw+cpbIg7+rnpSlUdcldnH2j6yYIKp8n9W3d/
RB3ZHrITE3x/uWrdCaQRwqFz5ZUt2fJA8pplarE4mbC46y1hNyAPcTlSlroH
CgjX3hFZ4WoFOKa+c7fhKBl/1JCTdfnGAiNj4UQHu1aiKVH6mouGHNg8kClL
jftM1Fzb+3P7SWnIKFh+TXPNEBF8z7/pCIWvp7Ir3lORVwjfn2prZW+zIVfo
ttuus81Iw+8vD0JRDuI+n2El3CkhJvJP2fyMZUGWrVT006tNqJ4pnc54TIeI
Kqkcma3/oES34OHdCvLQ/9Rb2IBaTXBN37sIchUgrlfvB1kTo4q5yLyscoJw
TRadFHKqI4qX+QoLVUwQvp+Fdh/SbyHMv+Q6re0YI9gvB9njt0YRTWocC776
Tty3fxc7YjeJMiSf3H0QKQSpokaPn7O6kNS8f+Oi4kx8xL9ZdSZ+4iChjaMd
l+g4MGjxJrcgJr61/bzUiVvyeEndXPI9KhPHWpZMx7+VKQXi8R7y+KONsOEU
P45J6S+YblcKaLS4rC6Lzzu/n46X5sskv23aJg+8Js8ES8shRG6RV7k3SxH2
pyzrsB2dQLjw2WzyOF8P+x2PjWr0owrB+2HXt6qAzl43j9LcKZR175V6V4sq
GKd47lxsP4j8Vhz7kJmrDKR3VbypHQhZas97xJzLAIem2ZH0NyMIi63+EVDQ
S/DQjqKmhh4ibix37637o4TN0dQHP3E34RoF0TdVecROTnSY0GAnASvLUqnJ
rURxHMuz0LyfeGA4ciIoUBg7Vmz99xzC8Kpy4OhdMVzheSn7qpQg/jTCkgix
5+ddZqxUkSOy+Km0zDTfsjvQISdMxRUyzucGkkUha/2C5F1VQ4S/i/yvTcfJ
EPE90u3dqyHCx3Dp5YBZUgDZx0PNSgeIIM028r0YMuDUUuJl3igRfPdr8ehy
ZbCplchLLxEHc+rzpb0ZqhDyIXuWvCkNXJex1Up/UaB0R8S2hVeoYGO9P7xz
nTAU7Pa67NIoCa4CzBD5DAoYvHAh9aZSQOu9kM7YoBhkzKpzsRgigxKy3Sy2
hAIScNq6acEg4tVUu0fTRUBO8NLGgPQx5DF3U/cO/vkdVKx1Ia/jB9JDa/rq
XETA55/arQINJCx6cv2owEJR0KN033O4yUP5pq9Pn7WiQmvEdtvlq8eRRPHX
66MgCj6Z0s1tcePIwGed4XsTQbB6aKM9n5+XpmZm2QmGk+H8uSn5yYvCOEz5
UgehRIYddsd9f+0WwkGXdvaqCArD7cv6owriIhhO2XTOXcWP03PzGyu+CGOV
I7Wv7x+UAVr/lwWy18YJI+ceI4tYSVgknHb12GoBqK/grRUKlAZX1cyyqrSf
hB+np30NmwYBI7P2m5GmCL1zS0gvpmQga4niNr9ZJLDUkrdxF5KEM9mVNme/
ThAGPkeDDDmSkPjwISM/bpzQPzM2kn6OBhnba8ONyUJwqrvpnN4lGoTQLIZH
A0jg62hrQ1Fhgk3O2uiChEnil6p+Z/BJ/vkXsGgDa6SReHrg/NJ/NrKhov5E
4MOrgtC6aMtCJX0WyH30Bp2/hKG4fiGzs54f/wJedMeECoFSOMlIOEEJbIzH
nH9WiED51c0yDd8VYafJ3S8Pa0RhZ7Ghh8w1JegYPZ5UIE8Fp/WUFitlRejP
f71pTEQcjFFXG81dEXwGbB0dpqiwlBHyIEdQCdhvqqeivcVg54acDSZO8hCk
GP553h0BeKNwevGPNEWYiQe/mQUz8aBCqdiIs0wc17xaJzul3oH0pVOc5pyn
4CBKT5mbSAvaaAc6IgHi2PxqQFu8dDMK6j7SFvFdFDqS2bY+O6mQnW/2xe6Q
GNQ7VKRteCoMIO/MNa2RgDOdqaMrF0uCXV7n5u3+ctDz8eF7r1sDRP7ruXfO
nVCGoNUHJzjEOKH7qVvg+hoOVPprvg+/SYKK2uVlmfZK+PPFk/x5UqGj51b7
p3kcnJkUPM388zSmY6MoJMZGLpg8OUnkUrJWFaVQAUwsn3b6vif0+sTb7ATJ
wEkum/NXngAYu932vi0uCA7RXnKGCWTgWimMUA348VJYaMMzkxYi0Tjiavgx
MiwqkYfIxyTI6C/WGjguBAah+MqWQBFQGmqLZjtTQemKRHsZdQjp2AR4eq8m
QZx2sgHXoRl19FwUnJf9i/CfLdnBOjGEIvwbEnjpA4RDajr3iGkzOuPspVm7
SBBST++zV/aVgzNDfedqngiDyUfrNw2NMv+tV7UgfdA5SPW/9VLX3Ztm0vSv
ifjD+A+jP/b4V1fGY7PrTBiWXNy1VOgHmqkXZ+xn6sUZ+7dbFxf1zGPiaMZR
5TR+Xvq8Q9Js11oWdhUY9l3AVABKw81f7/Xksdk3r97ljWw4qf8iNIijgBuE
YtmeH5iQ+4WxeVu5PI43/nLRLFoO8oJsQs7ZsXF/RHiYUYssaGYt+Z/xZSF4
9izRdQJy2JsWNt1OLnU0PBQqi4cpn6f7H2rNpGw2lMW6vlenx8+uK7tIVafj
rh3bp/3LbXcy2yPGwDGPBqfnR1p36NHiOIzAirWi7NpT5BDmEhC8pRcF8bqv
X5WqQk3kNzopem3I9cnBa2uHmxFnYUXS49puhB11hSbOPyXiXlJVDre2o6Yi
0rWXxzCKUc61nr+rF5Hwmn2OqwoR6fM7Oru4HcG4UI+mSzVq+j6mPVH6Dbm6
DlWHtRQSNLc0jhbuQjaUYwEv478gTuTy7AvtfP82Vj4PxeJRUP3oheTX/Pga
FOFdEfqD4HEdOr/5kSBRN6feUv8n4WPRkhGepQITudva7nX3E6So0ZfioSrA
s1DReJs5TPi+ppiEajDALrhM94QtDQ5JJ1ayFstBligreNE+GcjhFDZkPGDw
69uH3FZ/WXDJGBBuUOfn/9zw1RL2snAqYO67PXc4OEfr2ArW1wk0Xl61RYLg
YJLj00wf5i9Elrb2aX+hhlW8thxUj5lAI9Y6beQQNeyeMJbaRyPhoxcrDb3W
quB60yOsIr9xNHHWs8FxQB7rdY1OJq0eRVFP6h5eXM0fz8Xr4MM7Y+jPfQP+
/3qT+09vvlvsrjfdUgIPXW2FrfMGieEPIxSRDlWwOWS/ZaPoCPFHnzDT/49+
iZn+PWtbBF7Ki8G8Ewvzc9fz63qF2z8revhxkD7I1u6Q+fN+kEgz9elv6kff
FIb/l4m5R/umOU7++Sfj5woQdFav9H7Sd+T+bJ1jyhwZ0Gnec6pkhEf0eEQ3
nKyQgiyHXOGQNgEgaUg4ro2SBh1ORrNXuDDUBNu4y3KEwIMhv6akYxwZ7di5
a4QsA/12mWWN2V0IdtsuvyYuDT7K7xUDhkg4QtSEvvMJFUhpQzzKqQ5kzLU/
seAiDeLej0eWB/NQ1jmRga+XpQGfrKN6zfuBSMuuTkgbCUIQ8DxMdRpRcV+R
q67NT4KzwD1Ync3XXRFpxeW948QZ9b0PuUQrWrSyhb9/H4nPgYum3zsfFelD
jtF1aLDQc7xmIx2vp+hPs6mYcBRpio0Ps5ojpUf7CEEb0WneMiV46V/OkvCa
tjfa/ZYVPPmL8CsrjvryUBxUBDM2O2szsI/BcO4e4X7kqGK4ql6UjZWKw8lu
qkPIDy2J5JqwsV+ZbymX1o/6n1P3cRTZuELvYrU6twtxOzSX9iawMFt44Mae
6+1ovH4raeEDFuauXhzhXjqCzAWTz4Rps3Ax63aaZv0PFCUZYn1tPxNnJOfF
WnzjIbuiwABSChPrbRCa+yxyGFnn7IdlVQwc2xL9JuHxKNLBtYOluiwcpHUu
7sGBQRSiLeV/JpuJzbud5n6/0YUse80bTPYyccQPtuNX6lekU71EWXAvCxvd
s/abz+5Dwz0Htn1Ywp/fkRDxwWstKOpsBl93ythQ2H06PyzhbhzTxRzs1ucy
zXHPNP7aoiMBlQn1O+4FULGR6bzLUxQx0PcY/dRwWhpDe6gn9Z0i0FyGrhwn
V6DC+LZq2ncmzBF6zV2aTgPyxMkEdQ82WBqdmh/sT4fRe4rxO0XY4Hdg7vt4
KznwuR7xgRbPguzns1ofvKNDacdk7GAhGwJyQzyOdtGhbhlbmbpQHjIoDUbr
V9DBKc/qkasqC6K+unloGclB7pZifv5OxwNLJPl5K+cPs/D2qd+8qMVfeE+P
PJxubNR9oULHw9uXz6mtlIerw3VFxiJMPCdUQtj/tAL8DOAaTLAZ2Ij1UnvF
cnm49Cjp0sp4BjbO+RK4clIReHHiASti5HC5GbuqiKcAxWZqj/NHGPjWruGh
bg9FOCo9lmhizMC84vl3doQozNwH4dJjOhesVOT5+WvrQ7vvcvjWzjpVlQ0K
cNtAry8XM3DG4/XDad1K8FMCb1hiIYcrPzrM/nBQCSKoQbs63Rh4/FTafdHL
iuBynpmxcxkT2yV03yjoUQTPjhznNXcYuPhc+Mb7F9iw7/CpydilTKxfTTVe
YqYIQfW77l88KYfxvjG3Wn69uv76g7r0fUzs8FnI3/aZEuRd/SJa2SqHLfJY
1rwHbHhzwKxWv5aBm7w9xe3t+fkYq+Z+IFkOp8WOnHZ4qQjVXV2sC2uomEc1
jGIEKsHK5fPJcUpU7Bc/S8y2WhlWHX3fxiynYCHdkwfrVZQhzCN0W8Z5UZx4
835Gm7sSXMDSc7osRLDRrr+tLnYpgYSG/l6aFgWv3zzEix1SgMxliiM+j0Rx
pb8D3MpUBq3nK1227RfGibbRKMdEGWTsdWgWW0TwHq/Su+uyFSEM77A2+8Yf
z5fxqecYP2/KScxT/ywOWQIBBpP5/HqhMiHN9wUNJuwjnb7NFwbHUzST75Y0
CLssaq7ULgiJeU/dnz6TgeIBGZ6JMQkSdvckl++XA+8THzWrGCzQ5YDNwFJZ
6D+aXSivxoDxZlpZIY8GK9ekJUZZM2D/4QIlES7/nEoZzrzWRwUJsYPWRYf4
+d5E85ETtlIQs/Hy2aIJcXBYosiWSFfB89XeTteZGbH/6lINr4r+fe/mWnXy
MfnCBPoolp++Lp0MqSuivs3i9qGAs+vbbthToDEwwltQhoI1xmpfsJ8JwafM
HwcM+KzjF93+8gYJtDIrRfSs+pDGshVH9/yaJDJ9G/wDO6VwjVFcWncaGdIS
9zmvZkhj/YzqTX9xxEBs4aOLzN107Ld5rebPu2SY8FO+uYwujT1jfqVr7Bol
6oJ3VZx2kMWWFrEfC8VEgWY28I/ZJllcUpWkOufyOJG10GGNSr0M4FlRD1zt
u5BHvfw1LqUDlTvcmq4nK0M26bM2jaKc6jPW1VTKTP5GfIwsUGno4szkd8hs
05tpnjkPZ9pnzsOZdqdxoSPBq1Qh6O9nGoei7iLH/arXai3UgHQVxw9fL0G6
860L5tdwoF/iecaiHzWo1XvoIemqGjQtjCy0pf+DWhi3Q6XH+H7DBUPn0GII
7k7znIi/1QCGp5YaF3xGButILXJ/qUGE/JGDn2JrZvIFCFpEozmT4tGrikup
LEU1SL2pfagYtaL2zGJsVcyBiAMP6O+c2pGd3cmw4OtqoCfxeuR45gfCxT5E
h+bE75/3pDHuSyry7vu7OtxBDXBPy5htRS1RXnHDM/Mxfz4GYCWwtxlt/9AV
tniCAxVFoqle5+sJB+0jR5Ed3/6o3Yk19/IIKTVFjZJODgA3hWYlVIJyLC8o
rDXgt591um9rWEFIZR5prt2kBll7Xs/bdqEZyT71oYU/4a9vLevTbY8iNNi9
+euSDP5+6TFMTjx9RrhHVzsX1/P9D0krWOwrJfzrDx472aYEuVwl4vOqVjTz
fWXmecx8X5l5Hl3nrVTbWHQwclavGRmY+u/+fMZ+5v58xv7/AP6RC30=
    "], {
     {RGBColor[0.5, 0., 0.], 
      TagBox[
       TooltipBox[LineBox[{1, 2}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{3, 4}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{3, 5}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6, 7}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8, 9}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{10, 11}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12, 13}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12, 14}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12, 15}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{12, 16}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 18}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 11}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 10}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 19}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 20}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 21}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 22}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 23}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 24}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 25}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 26}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 27}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 28}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 29}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 30}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 31}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 32}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 33}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 34}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{17, 35}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{19, 50}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 37}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 38}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 39}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 40}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 41}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 42}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{43, 44}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{45, 46}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{47, 48}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{47, 49}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{51, 52}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{51, 53}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{54, 55}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{56, 57}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{56, 58}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{59, 60}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{59, 61}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 63}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 64}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 65}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 66}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 67}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 68}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 69}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 70}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{62, 71}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 73}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 74}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 75}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 13}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 12}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 14}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 15}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 16}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 56}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 57}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 76}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 77}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 78}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 79}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 22}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 80}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 81}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 82}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 83}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 84}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 85}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 58}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 86}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 24}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 87}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 88}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 89}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 90}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 91}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 92}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 93}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 94}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 28}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 95}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 96}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 97}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 29}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 98}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 99}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 100}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 101}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 102}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 103}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 104}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 105}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 106}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 107}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 108}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 109}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 110}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 111}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 112}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 113}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 114}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 115}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 116}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 117}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 118}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 119}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 120}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 121}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 34}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 122}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 123}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 124}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 125}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 126}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 127}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 128}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 129}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 130}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{72, 131}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 169}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 170}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 171}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{86, 172}],
        