(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15252,        547]
NotebookOptionsPosition[     10565,        400]
NotebookOutlinePosition[     13307,        472]
CellTagsIndexPosition[     13214,        466]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsOverview"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Lists\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partition" :> Documentation`HelpLookup["paclet:ref/Partition"],
           "Split" :> Documentation`HelpLookup["paclet:ref/Split"], "Tuples" :> 
          Documentation`HelpLookup["paclet:ref/Tuples"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Partition\"\>", 2->"\<\"Split\"\>", 
       3->"\<\"Tuples\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Grouping and Combining Elements of Lists", "Title",
 CellTags->{"S1.8.10", "10.1"},
 CellID->16859],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "partition ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]element pieces"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "use offset ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " for successive pieces"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Split",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Split"], "[", 
     StyleBox["list", "TI"], "]"}], Cell[TextData[{
     "split ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " into pieces consisting of runs of identical elements"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8871],

Cell["Functions for grouping together elements of lists. ", "Caption",
 CellID->14016],

Cell["Here is a list. ", "MathCaption",
 CellID->8172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->22832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->24441]
}, Open  ]],

Cell["\<\
This groups the elements of the list in pairs, throwing away the single \
element left at the end. \
\>", "MathCaption",
 CellID->17683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"t", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->16088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->22015]
}, Open  ]],

Cell["\<\
This groups elements in triples. There is no overlap between the triples. \
\>", "MathCaption",
 CellID->13976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"t", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->18516],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->18298]
}, Open  ]],

Cell["\<\
This makes triples of elements, with each successive triple offset by just \
one element. \
\>", "MathCaption",
 CellID->39],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{"t", ",", "3", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31283],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "g"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->3205]
}, Open  ]],

Cell["This splits up the list into runs of identical elements. ", \
"MathCaption",
 CellID->19997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", 
  RowBox[{"{", 
   RowBox[{
   "a", ",", "a", ",", "b", ",", "b", ",", "b", ",", "a", ",", "a", ",", "a", 
    ",", "b"}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->29146],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", "b", "}"}]}], "}"}]], "Output",
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->5769]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Tuples",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tuples"], "[", 
     StyleBox["list", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "generate all possible ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]tuples of elements from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Tuples",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tuples"], "[", "{", 
     SubscriptBox[
      StyleBox["list", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "generate all tuples whose ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula"],
     " element is from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23675],

Cell["Finding possible tuples of elements in lists. ", "Caption",
 CellID->917],

Cell["\<\
This gives all possible ways of picking two elements out of the list. \
\>", "MathCaption",
 CellID->9387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->15020],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->6030]
}, Open  ]],

Cell["\<\
This gives all possible ways of picking one element from each list. \
\>", "MathCaption",
 CellID->17442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->21735],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->32389]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->53890296],

Cell[TextData[ButtonBox["Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsOverview"]], "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Grouping and Combining Elements of Lists - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Lists", "OverviewNavText"], BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ListsOverview"]], "Text", FontFamily -> "Verdana"], 
    "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/RearrangingLists"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/OrderingInLists"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 58.0200844}", "context" -> "", 
    "keywords" -> {
     "blocking lists", "combinations", "encoding", 
      "gathering elements in lists", "generating tuples", "lists", 
      "ordered pairs", "pairs", "partition", "reshape in APL", 
      "run length encoding", "split", "Sublists", "triples", "Tuples", 
      "Unflatten"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Functions for grouping together elements of lists. Here is a list. This \
groups the elements of the list in pairs, throwing away the single element \
left at the end. ", "synonyms" -> {"1.8.10"}, "title" -> 
    "Grouping and Combining Elements of Lists", "type" -> "Tutorial", "uri" -> 
    "tutorial/GroupingAndCombiningElementsOfLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.8.10"->{
  Cell[1931, 59, 105, 2, 70, "Title",
   CellTags->{"S1.8.10", "10.1"},
   CellID->16859]},
 "10.1"->{
  Cell[1931, 59, 105, 2, 70, "Title",
   CellTags->{"S1.8.10", "10.1"},
   CellID->16859]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.8.10", 12996, 455},
 {"10.1", 13099, 459}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1306, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1931, 59, 105, 2, 70, "Title",
 CellTags->{"S1.8.10", "10.1"},
 CellID->16859],
Cell[2039, 63, 1485, 48, 70, "DefinitionBox",
 CellID->8871],
Cell[3527, 113, 86, 1, 70, "Caption",
 CellID->14016],
Cell[3616, 116, 54, 1, 70, "MathCaption",
 CellID->8172],
Cell[CellGroupData[{
Cell[3695, 121, 190, 6, 28, "Input",
 CellID->22832],
Cell[3888, 129, 254, 8, 36, "Output",
 CellID->24441]
}, Open  ]],
Cell[4157, 140, 146, 4, 70, "MathCaption",
 CellID->17683],
Cell[CellGroupData[{
Cell[4328, 148, 125, 4, 28, "Input",
 CellID->16088],
Cell[4456, 154, 358, 13, 36, "Output",
 CellID->22015]
}, Open  ]],
Cell[4829, 170, 121, 3, 70, "MathCaption",
 CellID->13976],
Cell[CellGroupData[{
Cell[4975, 177, 125, 4, 28, "Input",
 CellID->18516],
Cell[5103, 183, 319, 11, 36, "Output",
 CellID->18298]
}, Open  ]],
Cell[5437, 197, 134, 4, 70, "MathCaption",
 CellID->39],
Cell[CellGroupData[{
Cell[5596, 205, 135, 4, 70, "Input",
 CellID->31283],
Cell[5734, 211, 525, 17, 36, "Output",
 CellID->3205]
}, Open  ]],
Cell[6274, 231, 98, 2, 70, "MathCaption",
 CellID->19997],
Cell[CellGroupData[{
Cell[6397, 237, 224, 7, 70, "Input",
 CellID->29146],
Cell[6624, 246, 411, 14, 36, "Output",
 CellID->5769]
}, Open  ]],
Cell[7050, 263, 1444, 45, 70, "DefinitionBox",
 CellID->23675],
Cell[8497, 310, 79, 1, 70, "Caption",
 CellID->917],
Cell[8579, 313, 116, 3, 70, "MathCaption",
 CellID->9387],
Cell[CellGroupData[{
Cell[8720, 320, 171, 6, 70, "Input",
 CellID->15020],
Cell[8894, 328, 416, 15, 36, "Output",
 CellID->6030]
}, Open  ]],
Cell[9325, 346, 115, 3, 70, "MathCaption",
 CellID->17442],
Cell[CellGroupData[{
Cell[9465, 353, 258, 9, 70, "Input",
 CellID->21735],
Cell[9726, 364, 535, 19, 36, "Output",
 CellID->32389]
}, Open  ]],
Cell[CellGroupData[{
Cell[10298, 388, 71, 1, 70, "RelatedTutorialsSection",
 CellID->53890296],
Cell[10372, 391, 139, 3, 70, "RelatedTutorials",
 CellID->27407539]
}, Open  ]]
}, Open  ]],
Cell[10538, 398, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

