(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74710,       2705]
NotebookOptionsPosition[     59969,       2235]
NotebookOutlinePosition[     63951,       2326]
CellTagsIndexPosition[     63857,       2320]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MLCheckFunction" :> 
          Documentation`HelpLookup["paclet:ref/c/MLCheckFunction"], 
          "MLDisownInteger32Array" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDisownIntegerArray"], 
          "MLDisownInteger32List" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDisownIntegerList"], 
          "MLDisownRealArray" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDisownRealArray"], 
          "MLDisownRealList" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDisownRealList"], 
          "MLDisownString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDisownString"], 
          "MLDisownSymbol" :> 
          Documentation`HelpLookup["paclet:ref/c/MLDisownSymbol"], 
          "MLGetFunction" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetFunction"], 
          "MLGetInteger32" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetInteger"], 
          "MLGetInteger32Array" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetIntegerArray"], 
          "MLGetInteger32List" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetIntegerList"], 
          "MLGetReal" :> Documentation`HelpLookup["paclet:ref/c/MLGetReal"], 
          "MLGetRealArray" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetRealArray"], 
          "MLGetRealList" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetRealList"], 
          "MLGetString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetString"], "MLGetSymbol" :> 
          Documentation`HelpLookup["paclet:ref/c/MLGetSymbol"], 
          "MLPutFunction" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutFunction"], 
          "MLPutInteger32" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutInteger"], 
          "MLPutInteger32Array" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutIntegerArray"], 
          "MLPutInteger32List" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutIntegerList"], 
          "MLPutReal" :> Documentation`HelpLookup["paclet:ref/c/MLPutReal"], 
          "MLPutRealArray" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutRealArray"], 
          "MLPutRealList" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutRealList"], 
          "MLPutString" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutString"], "MLPutSymbol" :> 
          Documentation`HelpLookup["paclet:ref/c/MLPutSymbol"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MLCheckFunction\"\>", 
       2->"\<\"MLDisownInteger32Array\"\>", 
       3->"\<\"MLDisownInteger32List\"\>", 4->"\<\"MLDisownRealArray\"\>", 
       5->"\<\"MLDisownRealList\"\>", 6->"\<\"MLDisownString\"\>", 
       7->"\<\"MLDisownSymbol\"\>", 8->"\<\"MLGetFunction\"\>", 
       9->"\<\"MLGetInteger32\"\>", 10->"\<\"MLGetInteger32Array\"\>", 
       11->"\<\"MLGetInteger32List\"\>", 12->"\<\"MLGetReal\"\>", 
       13->"\<\"MLGetRealArray\"\>", 14->"\<\"MLGetRealList\"\>", 
       15->"\<\"MLGetString\"\>", 16->"\<\"MLGetSymbol\"\>", 
       17->"\<\"MLPutFunction\"\>", 18->"\<\"MLPutInteger32\"\>", 
       19->"\<\"MLPutInteger32Array\"\>", 20->"\<\"MLPutInteger32List\"\>", 
       21->"\<\"MLPutReal\"\>", 22->"\<\"MLPutRealArray\"\>", 
       23->"\<\"MLPutRealList\"\>", 24->"\<\"MLPutString\"\>", 
       25->"\<\"MLPutSymbol\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Handling Lists, Arrays and Other Expressions", "Title",
 CellTags->{"S2.13.4", "4.1"},
 CellID->411266683],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " allows you to exchange data of any type with external programs. For more \
common types of data, you simply need to give appropriate ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ArgumentTypes", ":"}]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ReturnType", ":"}]}]], "InlineFormula"],
 " specifications in your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file. "
}], "Text",
 CellID->286793771],

Cell[BoxData[GridBox[{
   {Cell["Mathematica specification", "TableHeader"], "", Cell[
    "C specification", "TableHeader"]},
   {
    ButtonBox["Integer",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integer"], Cell["integer", "TableText"], "int"},
   {
    ButtonBox["Real",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Real"], Cell[
    "floating\[Hyphen]point number", "TableText"], "double"},
   {"IntegerList", Cell["list of integers", "TableText"], 
    RowBox[{
     RowBox[{"int", "*"}], ",", "long"}]},
   {"RealList", Cell["list of floating\[Hyphen]point numbers", "TableText"], 
    RowBox[{
     RowBox[{"double", "*"}], ",", "long"}]},
   {
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], Cell["character string", "TableText"], 
    
    RowBox[{"char", "*"}]},
   {
    ButtonBox["Symbol",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Symbol"], Cell["symbol name", "TableText"], 
    RowBox[{"char", "*"}]},
   {
    ButtonBox["Manual",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Manual"], Cell[TextData[{
     "call ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " routines directly"
    }], "TableText"], "void"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, False, {True}, False}, 
   "RowsIndexed" -> {}}},
 CellID->568072851],

Cell["Basic type specifications. ", "Caption",
 CellID->50271946],

Cell[TextData[{
 "Here is the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template for a function that takes a list of integers as its argument. "
}], "MathCaption",
 CellID->316862481],

Cell["\<\
:Begin:
:Function:       h
:Pattern:        h[a_List]
:Arguments:      {a}
:ArgumentTypes:  {IntegerList}
:ReturnType:     Integer
:End:
\
\>", "Program",
 CellID->243738654],

Cell[TextData[{
 "Here is the C source code for the function. Note the extra argument ",
 Cell[BoxData["alen"], "InlineFormula"],
 " which is used to pass the length of the list. "
}], "MathCaption",
 CellID->97825824],

Cell["\<\
int h(int *a, long alen) {

   int i, tot=0;

   for(i=0; i<alen; i++)
      tot += a[i];

   return tot;
}\
\>", "Program",
 CellID->184759401],

Cell[TextData[{
 "This installs an external program containing the specifications for the \
function ",
 Cell[BoxData["h"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Install", "[", "\"\<hprog\>\"", "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->15713],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"./hprog\"\>", ",", "11", ",", "8"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->30935]
}, Open  ]],

Cell["This calls the external code. ", "MathCaption",
 CellID->19735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "5", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->30883],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->2186]
}, Open  ]],

Cell[TextData[{
 "This does not match the pattern ",
 Cell[BoxData[
  RowBox[{"h", "[", "a_List", "]"}]], "InlineFormula"],
 " so does not call the external code. "
}], "MathCaption",
 CellID->16096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", "67", "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->20648],

Cell[BoxData[
 RowBox[{"h", "[", "67", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->2085]
}, Open  ]],

Cell[TextData[{
 "The pattern is matched, but the elements in the list are of the wrong type \
for the external code, so ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " is returned. "
}], "MathCaption",
 CellID->14752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->521],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->9260]
}, Open  ]],

Cell[TextData[{
 "You can mix basic types of arguments in any way you want. Whenever you use \
",
 Cell[BoxData["IntegerList"], "InlineFormula"],
 " or ",
 Cell[BoxData["RealList"], "InlineFormula"],
 ", however, you have to include an extra argument in your C program to \
represent the length of the list. "
}], "Text",
 CellID->21982],

Cell[TextData[{
 "Here is an ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ArgumentTypes", ":"}]}]], "InlineFormula"],
 " specification. "
}], "MathCaption",
 CellID->7688],

Cell["\<\
:ArgumentTypes:  {IntegerList, RealList, Integer}
\
\>", "Program",
 CellID->19919],

Cell["Here is a possible corresponding C function declaration. ", \
"MathCaption",
 CellID->17236],

Cell["void f(int *a, long alen, double *b, long blen, int c)", "Program",
 CellID->26792],

Cell[TextData[{
 "Note that when a list is passed to a C program by ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " its first element is assumed to be at position 0, as is standard in C, \
rather than at position 1, as is standard in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->19278],

Cell[TextData[{
 "In addition, following C standards, character strings specified by ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " are passed as ",
 Cell[BoxData[
  RowBox[{"char", "*"}]], "InlineFormula"],
 " objects, terminated by ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "0"}]], "InlineFormula"],
 " null bytes.\[NonBreakingSpace]\"",
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 " discusses how to handle special characters. "
}], "Text",
 CellID->4198],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLPutInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutInteger"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"int", " ", 
        StyleBox["i", "TI"]}]}], ")"}]}], Cell[
    "put a single integer", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutReal"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"double", " ", 
        StyleBox["x", "TI"]}]}], ")"}]}], Cell["\<\
put a single floating\[Hyphen]point number\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutInteger32List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutIntegerList"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"int", "*", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "put a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " integers starting from location\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutRealList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutRealList"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"double", "*", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "put a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " floating\[Hyphen]point numbers starting from location\
\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutIntegerArray"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"int", "*", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["dims", "TI"]}], ",", "NULL", ",", 
       RowBox[{"int", " ", 
        StyleBox["d", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "put an array of integers to form a depth ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " list with dimensions ",
     Cell[BoxData[
      StyleBox["dims", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutRealArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutRealArray"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"double", "*", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["dims", "TI"]}], ",", "NULL", ",", 
       RowBox[{"int", " ", 
        StyleBox["d", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
put an array of floating\[Hyphen]point numbers\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "*", 
        StyleBox["s", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["put a character string", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutSymbol"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "*", 
        StyleBox["s", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["put a character string as a symbol name", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLPutFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLPutFunction"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "*", 
        StyleBox["s", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "begin putting a function with head ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " arguments"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, True, False, False, False, True, False, False, False, True, 
     False, False, False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->31496],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions for sending data to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->26386],

Cell[TextData[{
 "When you use a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file, what ",
 Cell[BoxData[
  ButtonBox["mprep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mprep"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 " actually do is to create a C program that includes explicit calls to ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions. If you want to see an example of how to use the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions directly, you can look at the source code of this \
program. Note when you use ",
 Cell[BoxData[
  ButtonBox["mcc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mcc"]], "InlineFormula"],
 ", you typically need to give a ",
 Cell[BoxData[
  RowBox[{"-", "g"}]], "InlineFormula"],
 " option, otherwise the source code that is generated is automatically \
deleted."
}], "Text",
 CellID->21011],

Cell[TextData[{
 "If your external function just returns a single integer or \
floating\[Hyphen]point number, then you can specify this just by giving ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " as the ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ReturnType", ":"}]}]], "InlineFormula"],
 " in your ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file. But because of the way memory allocation and deallocation \
work in C, you cannot directly give ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ReturnType", ":"}]}]], "InlineFormula"],
 " specifications such as ",
 Cell[BoxData["IntegerList"], "InlineFormula"],
 " or ",
 Cell[BoxData["RealList"], "InlineFormula"],
 ". And instead, to return such structures, you must explicitly call ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions within your C program, and give ",
 Cell[BoxData[
  ButtonBox["Manual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manual"]], "InlineFormula"],
 " as the ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ReturnType", ":"}]}]], "InlineFormula"],
 " specification. "
}], "Text",
 CellID->10976],

Cell[TextData[{
 "Here is the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template for a function that takes an integer as an argument, and returns \
its value using explicit ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions. "
}], "MathCaption",
 CellID->12121],

Cell["\<\
:Begin:
:Function:       bits
:Pattern:        bits[i_Integer]
:Arguments:      {i}
:ArgumentTypes:  {Integer}
:ReturnType:     Manual
:End:
\
\>", "Program",
 CellID->23202],

Cell[TextData[{
 "The return type of the function is declared as ",
 Cell[BoxData["void"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7245],

Cell["\<\
void bits(int i) {

   int a[32], k;
\
\>", "Program",
 CellID->6702],

Cell[TextData[{
 "This puts values into the C array ",
 Cell[BoxData["a"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->28564],

Cell["\<\
   for(k=0; k<32; k++) {
       a[k] = i%2;
       i >>= 1;
       if (i==0) break;
   }

   if (k<32) k++;
\
\>", "Program",
 CellID->31539],

Cell[TextData[{
 "This sends ",
 Cell[BoxData["k"], "InlineFormula"],
 " elements of the array ",
 Cell[BoxData["a"], "InlineFormula"],
 " back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->2572],

Cell["\<\
    MLPutInteger32List(stdlink, a, k);
    return ;
}\
\>", "Program",
 CellID->2257],

Cell[TextData[{
 "This installs the program containing the external function ",
 Cell[BoxData["bits"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Install", "[", "\"\<bitsprog\>\"", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->31654],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"bitsprog", ",", "5", ",", "5"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->19359]
}, Open  ]],

Cell["The external function now returns a list of bits. ", "MathCaption",
 CellID->11080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bits", "[", "14", "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->7298],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->23391]
}, Open  ]],

Cell[TextData[{
 "If you declare an array in C as ",
 Cell[BoxData[
  RowBox[{"int", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["a", "TI"], "[", 
      StyleBox["n1", "TI"], "]"}], "[", 
     StyleBox["n2", "TI"], "]"}], "[", 
    StyleBox["n3", "TI"], "]"}]}]], "InlineFormula"],
 " then you can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutInteger32Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutInteger"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to send it to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a depth 3 list. "
}], "Text",
 CellID->23960],

Cell["\<\
Here is a declaration for a 3\[Hyphen]dimensional C array.\
\>", "MathCaption",
 CellID->25867],

Cell["   int a[8][16][100];", "Program",
 CellID->22033],

Cell[TextData[{
 "This sets up the array ",
 Cell[BoxData["dims"], "InlineFormula"],
 " and initializes it to the dimensions of ",
 Cell[BoxData["a"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1675],

Cell["   int dims[] = {8, 16, 100};", "Program",
 CellID->12136],

Cell[TextData[{
 "This sends the 3\[Hyphen]dimensional array ",
 Cell[BoxData["a"], "InlineFormula"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", creating a depth 3 list. "
}], "MathCaption",
 CellID->17775],

Cell["    MLPutInteger32Array(stdlink, a, dims, NULL, 3);", "Program",
 CellID->25790],

Cell[TextData[{
 "You can use ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions to create absolutely any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. The basic idea is to call a sequence of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions that correspond directly to the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " representation of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. "
}], "Text",
 CellID->20272],

Cell[TextData[{
 "This sets up the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " with 2 arguments. "
}], "MathCaption",
 CellID->5086],

Cell["MLPutFunction(stdlink, \"Plus\", 2);", "Program",
 CellID->20967],

Cell[TextData[{
 "This specifies that the first argument is the integer ",
 Cell[BoxData["77"], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->9515],

Cell["MLPutInteger32(stdlink, 77);", "Program",
 CellID->23542],

Cell[TextData[{
 "And this specifies that the second argument is the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23495],

Cell["MLPutSymbol(stdlink, \"x\");", "Program",
 CellID->3566],

Cell[TextData[{
 "In general, you first call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutFunction"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ", giving the head of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function you want to create, and the number of arguments it has. Then you \
call other ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions to fill in each of these arguments in turn. ",
 ButtonBox["Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ExpressionsOverview"],
 " discusses the general structure of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions and the notion of heads. "
}], "Text",
 CellID->14186],

Cell[TextData[{
 "This creates a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list with 2 elements. "
}], "MathCaption",
 CellID->19198],

Cell["MLPutFunction(stdlink, \"List\", 2);", "Program",
 CellID->12626],

Cell[TextData[{
 "The first element of the ",
 "list",
 " is a list of 10 integers from the C array ",
 Cell[BoxData["r"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->18364],

Cell["MLPutInteger32List(stdlink, r, 10);", "Program",
 CellID->1085],

Cell["\<\
The second element of the main list is itself a list with 2 elements. \
\>", "MathCaption",
 CellID->31665],

Cell["MLPutFunction(stdlink, \"List\", 2);", "Program",
 CellID->18908],

Cell["\<\
The first element of this sublist is a floating\[Hyphen]point number. \
\>", "MathCaption",
 CellID->20340],

Cell["MLPutReal(stdlink, 4.5);", "Program",
 CellID->1360],

Cell["The second element is an integer. ", "MathCaption",
 CellID->2814],

Cell["MLPutInteger32(stdlink, 11);", "Program",
 CellID->21154],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutInteger32Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutIntegerArray"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutRealArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutRealArray"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " allow you to send arrays which are laid out in memory in the \
one\[Hyphen]dimensional way that C pre\[Hyphen]allocates them. But if you \
create arrays during the execution of a C program, it is more common to set \
them up as nested collections of pointers. You can send such arrays to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by using a sequence of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutFunction"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " calls, ending with an ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutInteger32List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutIntegerList"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " call. "
}], "Text",
 CellID->19752],

Cell[TextData[{
 "This declares ",
 Cell[BoxData["a"], "InlineFormula"],
 " to be a nested list of lists of lists of integers. "
}], "MathCaption",
 CellID->12525],

Cell["int ***a;", "Program",
 CellID->30630],

Cell[TextData[{
 "This creates a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list with ",
 Cell[BoxData["n1"], "InlineFormula"],
 " elements. "
}], "MathCaption",
 CellID->23179],

Cell["MLPutFunction(stdlink, \"List\", n1);", "Program",
 CellID->3079],

Cell["for (i=0; i<n1; i++) {", "Program",
 CellID->8313],

Cell[TextData[{
 "This creates a sublist with ",
 Cell[BoxData["n2"], "InlineFormula"],
 " elements. "
}], "MathCaption",
 CellID->28838],

Cell["    MLPutFunction(stdlink, \"List\", n2);", "Program",
 CellID->32517],

Cell["    for (j=0; j<n2; j++) {", "Program",
 CellID->8421],

Cell["This writes out lists of integers. ", "MathCaption",
 CellID->14145],

Cell["        MLPutInteger32List(stdlink, a[i][j], n3);", "Program",
 CellID->5991],

Cell["\<\
    }
}\
\>", "Program",
 CellID->1969],

Cell[TextData[{
 "It is important to realize that any expression you create using ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions will be evaluated as soon as it is sent to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". This means, for example, that if you wanted to transpose an array that \
you were sending back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", all you would need to do is to wrap a ",
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " around the expression representing the array. You can then do this simply \
by calling ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["MLPutFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/c/MLPutFunction"], 
    RowBox[{"(", 
     RowBox[{"stdlink", ",", "\"\<Transpose\>\"", ",", "1"}], ")"}]}], ";"}]],
   "InlineFormula"],
 " just before you start creating the expression that represents the array. "
}], "Text",
 CellID->16565],

Cell[TextData[{
 "The idea of post\[Hyphen]processing data that you send back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has many uses. One example is as a way of sending lists whose length you \
do not know in advance."
}], "Text",
 CellID->23762],

Cell[TextData[{
 "This creates a list in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by explicitly appending successive elements. "
}], "MathCaption",
 CellID->19473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{"Append", "[", 
      RowBox[{"t", ",", 
       RowBox[{"i", "^", "2"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], ";", "t"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->23681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->21970]
}, Open  ]],

Cell["\<\
This creates a list in which each successive element is in a nested sublist. \
\
\>", "MathCaption",
 CellID->23147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"t", "=", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"i", "^", "2"}]}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], ";", "t"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->27053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "}"}], ",", "1"}], "}"}], ",", "4"}], "}"}], ",", 
       "9"}], "}"}], ",", "16"}], "}"}], ",", "25"}], "}"}]], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->22708]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Flatten",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flatten"]], "InlineFormula"],
 " flattens out the list. "
}], "MathCaption",
 CellID->6508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "t", "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->16715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->4429]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " automatically flattens itself. "
}], "MathCaption",
 CellID->31066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Sequence", "[", 
   RowBox[{"1", ",", 
    RowBox[{"Sequence", "[", 
     RowBox[{"4", ",", 
      RowBox[{"Sequence", "[", "]"}]}], "]"}]}], "]"}], "}"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->27689],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->14663]
}, Open  ]],

Cell[TextData[{
 "In order to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutInteger32List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutIntegerList"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ", you need to know the length of the list you want to send. But by creating \
a sequence of nested ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects, you can avoid having to know the length of your whole list in \
advance. "
}], "Text",
 CellID->11771],

Cell[TextData[{
 "This sets up the ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " around your result. "
}], "MathCaption",
 CellID->16259],

Cell["MLPutFunction(stdlink, \"List\", 1);", "Program",
 CellID->18631],

Cell[TextData[{
 "while(",
 StyleBox[" condition", "MO"],
 " ) {\n    ",
 StyleBox[" /* generate an element */", "MO"]
}], "Program",
 CellID->23572],

Cell[TextData[{
 "Create the next level ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->2514],

Cell["    MLPutFunction(stdlink, \"Sequence\", 2);", "Program",
 CellID->10966],

Cell["Put the element. ", "MathCaption",
 CellID->25988],

Cell[TextData[{
 "    MLPutInteger32(stdlink, ",
 StyleBox[" i", "MO"],
 " );"
}], "Program",
 CellID->18170],

Cell["}", "Program",
 CellID->28168],

Cell[TextData[{
 "This closes off your last ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " object. "
}], "MathCaption",
 CellID->22199],

Cell["MLPutFunction(stdlink, \"Sequence\", 0);", "Program",
 CellID->655],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLGetInteger32",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetInteger"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"int", "*", 
        StyleBox["i", "TI"]}]}], ")"}]}], Cell[TextData[{
     "get an integer, storing it at address ",
     Cell[BoxData[
      FormBox["i", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetReal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetReal"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"double", "*", 
        StyleBox["x", "TI"]}]}], ")"}]}], Cell[TextData[{
     "get a floating\[Hyphen]point number, storing it at address ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->13444],

Cell[TextData[{
 "Basic functions for explicitly getting data from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->12936],

Cell[TextData[{
 "Just as ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " provides functions like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLPutInteger32",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLPutInteger"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to send data from an external program into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so also ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " provides functions like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetInteger32",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetInteger"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " that allow you to get data from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " into an external program. "
}], "Text",
 CellID->16278],

Cell[TextData[{
 "The list that you give for ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ArgumentTypes", ":"}]}]], "InlineFormula"],
 " in a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template can end with ",
 Cell[BoxData[
  ButtonBox["Manual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manual"]], "InlineFormula"],
 ", indicating that after other arguments have been received, you will call \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions to get additional expressions. "
}], "Text",
 CellID->19406],

Cell["\<\
:Begin:
:Function:       f\
\>", "Program",
 CellID->10313],

Cell[TextData[{
 "The function ",
 Cell[BoxData["f"], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes 3 arguments. "
}], "MathCaption",
 CellID->7523],

Cell[":Pattern:        f[i_Integer, x_Real, y_Real]", "Program",
 CellID->32371],

Cell["\<\
All these arguments are passed directly to the external program.\
\>", "MathCaption",
 CellID->23327],

Cell[":Arguments:      {i, x, y}", "Program",
 CellID->17073],

Cell["\<\
Only the first argument is sent directly to the external function. \
\>", "MathCaption",
 CellID->23461],

Cell[":ArgumentTypes:  {Integer, Manual}", "Program",
 CellID->2173],

Cell["\<\
:ReturnType:     Real
:End:
\
\>", "Program",
 CellID->9934],

Cell["The external function only takes one explicit argument. ", "MathCaption",
 CellID->31102],

Cell["\<\
double f(int i) {
\
\>", "Program",
 CellID->25587],

Cell[TextData[{
 "This declares the variables ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31417],

Cell["\<\
   double x, y;
\
\>", "Program",
 CellID->31463],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetReal"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " explicitly gets data from the link. "
}], "MathCaption",
 CellID->6153],

Cell["\<\
   MLGetReal(stdlink, &x);
   MLGetReal(stdlink, &y);
\
\>", "Program",
 CellID->26126],

Cell["\<\
   return i+x+y;
}\
\>", "Program",
 CellID->20595],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " functions such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetInteger32",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetInteger"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["link", "TI"], ",", 
     StyleBox["pi", "TI"]}], ")"}]}]], "InlineFormula"],
 " work much like standard C library functions such as ",
 Cell[BoxData[
  RowBox[{"fscanf", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["fp", "TI"], ",", "\"\<%d\>\"", ",", 
     StyleBox["pi", "TI"]}], ")"}]}]], "InlineFormula"],
 ". The first argument specifies the link from which to get data. The last \
argument gives the address at which the data that is obtained should be \
stored. "
}], "Text",
 CellID->29213],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLCheckFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLCheckFunction"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
       RowBox[{"int", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
check the head of a function and store how many arguments it has\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2406],

Cell[TextData[{
 "Getting a function via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->27370],

Cell["\<\
:Begin:
:Function:       f\
\>", "Program",
 CellID->23305],

Cell[TextData[{
 "The function ",
 Cell[BoxData["f"], "InlineFormula"],
 " in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes a list of integers as an argument. "
}], "MathCaption",
 CellID->22496],

Cell[":Pattern:        f[a:{___Integer}]", "Program",
 CellID->24833],

Cell["The list is passed directly to the external program.", "MathCaption",
 CellID->24223],

Cell[":Arguments:      {a}", "Program",
 CellID->4852],

Cell["\<\
The argument is to be retrieved manually by the external program. \
\>", "MathCaption",
 CellID->17879],

Cell[":ArgumentTypes:  {Manual}", "Program",
 CellID->30519],

Cell["\<\
:ReturnType:     Integer
:End:
\
\>", "Program",
 CellID->6126],

Cell["The external function takes no explicit arguments. ", "MathCaption",
 CellID->7793],

Cell["\<\
int f(void) {
\
\>", "Program",
 CellID->31585],

Cell["This declares local variables. ", "MathCaption",
 CellID->21465],

Cell["\<\
    int n, i;
    int a[MAX];
\
\>", "Program",
 CellID->31371],

Cell[TextData[{
 "This checks that the function being sent is a list, and stores how many \
elements it has in ",
 Cell[BoxData["n"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15444],

Cell["\<\
    MLCheckFunction(stdlink, \"List\", &n);
\
\>", "Program",
 CellID->17107],

Cell[TextData[{
 "This gets each element in the list, storing it in ",
 Cell[BoxData[
  RowBox[{"a", "[", "i", "]"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->17271],

Cell["\<\
   for (i=0; i<n; i++)
      MLGetInteger32(stdlink, a+i);\
\>", "Program",
 CellID->24087],

Cell[TextData[{
 "In simple cases, it is usually possible to ensure on the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " side that the data you send to an external program has the structure that \
is expected. But in general the return value from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLCheckFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLCheckFunction"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " will be MLSUCCESS only if the data consists of a function with the name \
you specify. "
}], "Text",
 CellID->8596],

Cell[TextData[{
 "Note that if you want to get a nested collection of lists or other objects, \
you can do this by making an appropriate sequence of calls to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLCheckFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLCheckFunction"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5715],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLGetInteger32List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetIntegerList"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"int", "**", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
get a list of integers, allocating the memory needed to store\
\[NonBreakingSpace]it\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetRealList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetRealList"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"double", "**", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
get a list of floating\[Hyphen]point numbers\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLDisownInteger32List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownIntegerList"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"int", "*", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[
    "disown the memory associated with a list of integers", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLDisownRealList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownRealList"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"double", "*", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
disown the memory associated with a list of floating\[Hyphen]point numbers\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, False, False, {False}, False},
    "RowsIndexed" -> {}}},
 CellID->17552],

Cell["Getting lists of numbers. ", "Caption",
 CellID->22492],

Cell[TextData[{
 "When an external program gets data from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it must set up a place to store the data. If the data consists of a \
single integer, as in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetInteger32",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetInteger"], 
   RowBox[{"(", 
    RowBox[{"stdlink", ",", 
     RowBox[{"&", 
      StyleBox["n", "TI"]}]}], ")"}]}]], "InlineFormula"],
 ", then it suffices just to have declared this integer using ",
 Cell[BoxData[
  RowBox[{"int", "n"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14753],

Cell["\<\
But when the data consists of a list of integers of potentially any length, \
memory must be allocated to store this list at the time when the external \
program is actually called. \
\>", "Text",
 CellID->8257],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetInteger32List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetIntegerList"], 
   RowBox[{"(", 
    RowBox[{"stdlink", ",", 
     RowBox[{"&", 
      StyleBox["a", "TI"]}], ",", 
     RowBox[{"&", 
      StyleBox["n", "TI"]}]}], ")"}]}]], "InlineFormula"],
 " will automatically do this allocation, setting ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " to be a pointer to the result. Note that memory allocated by functions \
like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetInteger32List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetIntegerList"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " is always in a special reserved area, so you cannot modify or free it \
directly. "
}], "Text",
 CellID->27590],

Cell["\<\
Here is an external program that will be sent a list of integers. \
\>", "MathCaption",
 CellID->13357],

Cell["\<\
int f(void) {
\
\>", "Program",
 CellID->10886],

Cell[TextData[{
 "This declares local variables. ",
 Cell[BoxData["a"], "InlineFormula"],
 " is an array of integers. "
}], "MathCaption",
 CellID->7809],

Cell["\<\
    int n;
    int *a;
\
\>", "Program",
 CellID->5865],

Cell[TextData[{
 "This gets a list of integers, making ",
 Cell[BoxData["a"], "InlineFormula"],
 " be a pointer to the result. "
}], "MathCaption",
 CellID->25686],

Cell["\<\
    MLGetInteger32List(stdlink, &a, &n);
\
\>", "Program",
 CellID->32019],

Cell["This disowns the memory used to store the list of integers. ", \
"MathCaption",
 CellID->22313],

Cell["    MLDisownInteger32List(stdlink, a, n);", "Program",
 CellID->2435],

Cell["\<\
...
}\
\>", "Program",
 CellID->1028],

Cell[TextData[{
 "If you use ",
 Cell[BoxData["IntegerList"], "InlineFormula"],
 " as an ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ArgumentTypes", ":"}]}]], "InlineFormula"],
 " specification, then ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will automatically disown the memory used for the list after your external \
function exits. But if you get a list of integers explicitly using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetInteger32List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetIntegerList"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ", then you must not forget to disown the memory used to store the list \
after you have finished with it. "
}], "Text",
 CellID->10468],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLGetInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetIntegerArray"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"int", "**", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", "**", 
        StyleBox["dims", "TI"]}], ",", 
       RowBox[{
        RowBox[{"char", "**"}], "*", 
        StyleBox["heads", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["d", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["get an array of integers of any depth", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetRealArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetRealArray"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"double", "**", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", "**", 
        StyleBox["dims", "TI"]}], ",", 
       RowBox[{
        RowBox[{"char", "**"}], "*", 
        StyleBox["heads", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["d", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
get an array of floating\[Hyphen]point numbers of any depth\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLDisownInteger32Array",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownIntegerArray"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"int", "*", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["dims", "TI"]}], ",", 
       RowBox[{"char", "**", 
        StyleBox["heads", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["d", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["disown memory associated with an integer array", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLDisownRealArray",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownRealArray"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"double", "*", 
        StyleBox["a", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["dims", "TI"]}], ",", 
       RowBox[{"char", "**", 
        StyleBox["heads", "TI"]}], ",", 
       RowBox[{"int", " ", 
        StyleBox["d", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell["\<\
disown memory associated with a floating\[Hyphen]point array\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, False, False, {False}, False},
    "RowsIndexed" -> {}}},
 CellID->22869],

Cell["Getting arrays of numbers. ", "Caption",
 CellID->456],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetInteger32List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetIntegerList"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " extracts a one\[Hyphen]dimensional array of integers from a single ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " list. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetInteger32Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetIntegerArray"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " extracts an array of integers from a collection of lists or other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions nested to any depth. "
}], "Text",
 CellID->6731],

Cell[TextData[{
 "The name of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function at level ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " in the structure is stored as a string in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["heads", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ". The size of the structure at level ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " is stored in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["dims", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ", while the total depth is stored in ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7578],

Cell[TextData[{
 "If you pass a list of complex numbers to your external program, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetRealArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetRealArray"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " will create a two\[Hyphen]dimensional array containing a sequence of pairs \
of real and imaginary parts. In this case, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["heads", "TI"], "[", "0", "]"}]], "InlineFormula"],
 " will be ",
 Cell[BoxData[
  ButtonBox["\"\<List\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/List"]], "InlineFormula"],
 " while ",
 Cell[BoxData[
  RowBox[{
   StyleBox["heads", "TI"], "[", "1", "]"}]], "InlineFormula"],
 " will be ",
 Cell[BoxData["\"\<Complex\>\""], "InlineFormula"],
 ". "
}], "Text",
 CellID->26074],

Cell[TextData[{
 "Note that you can conveniently exchange arbitrary\[Hyphen]precision numbers \
with external programs by converting them to lists of digits in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 "."
}], "Text",
 CellID->11395],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLGetString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "**", 
        StyleBox["s", "TI"]}]}], ")"}]}], Cell[
    "get a character string", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLGetSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetSymbol"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "**", 
        StyleBox["s", "TI"]}]}], ")"}]}], Cell[
    "get a symbol name", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLDisownString",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownString"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "*", 
        StyleBox["s", "TI"]}]}], ")"}]}], Cell[
    "disown memory associated with a character string", "TableText"]},
   {
    RowBox[{
     ButtonBox["MLDisownSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownSymbol"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "*", 
        StyleBox["s", "TI"]}]}], ")"}]}], Cell[
    "disown memory associated with a symbol name", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, False, False, {False}, False},
    "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30843],

Cell["Getting character strings and symbol names. ", "Caption",
 CellID->31274],

Cell[TextData[{
 "If you use ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " as an ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"ArgumentTypes", ":"}]}]], "InlineFormula"],
 " specification, then ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will automatically disown the memory that is used to store the string \
after your function exits. This means that if you want to continue to refer \
to the string, you must allocate memory for it, and explicitly copy each \
character in it. "
}], "Text",
 CellID->13316],

Cell[TextData[{
 "If you get a string using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ", however, then ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " will not automatically disown the memory used for the string when your \
function exits. As a result, you can continue referring to the string. Be \
careful not to modify the contents of the string by writing to the memory \
that is returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". When you no longer need the string, you must nevertheless explicitly call \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLDisownString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLDisownString"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " in order to disown the memory associated with it."
}], "Text",
 CellID->15024],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MLGetFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLGetFunction"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "**", 
        StyleBox["s", "TI"]}], ",", 
       RowBox[{"int", "*", 
        StyleBox["n", "TI"]}]}], ")"}]}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "begin getting a function, storing the name of the head in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " and the number of arguments in ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MLDisownSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/c/MLDisownSymbol"], 
     RowBox[{"(", 
      RowBox[{"stdlink", ",", 
       RowBox[{"char", "*", 
        StyleBox["s", "TI"]}]}], ")"}]}], Cell[
    "disown memory associated with a function name", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, True, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30511],

Cell["Getting an arbitrary function. ", "Caption",
 CellID->18585],

Cell[TextData[{
 "If you know what function to expect in your external program, then it is \
usually simpler to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLCheckFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLCheckFunction"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". But if you do not know what function to expect, you have no choice but to \
call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetFunction"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". If you do this, you need to be sure to call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLDisownSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLDisownSymbol"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " to disown the memory associated with the name of the function that is \
found by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MLGetFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/c/MLGetFunction"], 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5722],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->19422832],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Handling Lists, Arrays and Other Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
SettingUpExternalFunctionsToBeCalledFromMathematica"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PortabilityOfMathLinkPrograms"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 36, 58.6138496}", "context" -> "", 
    "keywords" -> {
     "allocating memory", "arbitrary length", "arbitrary precision numbers", 
      "array origins", "arrays", "Bignums", "complex numbers", 
      "deallocating MathLink memory", "declarations", 
      "disowning MathLink memory", "expressions", "generated files", 
      "getting data in MathLink", "IntegerList MathLink type", 
      "intermediate files", "lists", "manual MathLink type", "MathLink", 
      "memory", "memory allocation", "MLCheckFunction()", 
      "MLDisownIntegerArray()", "MLDisownIntegerList()", 
      "MLDisownRealArray()", "MLDisownRealList()", "MLDisownString()", 
      "MLDisownSymbol()", "MLGetFunction()", "MLGetInteger()", 
      "MLGetIntegerArray()", "MLGetIntegerList()", "MLGetReal()", 
      "MLGetRealArray", "MLGetRealArray()", "MLGetRealList()", 
      "MLGetString()", "MLGetSymbol()", "MLPutFunction()", "MLPutInteger()", 
      "MLPutIntegerArray()", "MLPutIntegerList()", "MLPutReal()", 
      "MLPutRealArray()", "MLPutRealList()", "MLPutString()", "MLPutSymbol()",
       "numbers", "putting data in MathLink", "RealList MathLink type", 
      "reserved memory", "sequence", "size", "strings", "tmc files"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MathLink allows you to exchange data of any type with external programs. \
For more common types of data, you simply need to give appropriate \
:ArgumentTypes: or :ReturnType: specifications in your MathLink template \
file. Basic type specifications. Here is the MathLink template for a function \
that takes a list of integers as its argument. ", "synonyms" -> {"2.13.4"}, 
    "title" -> "Handling Lists, Arrays and Other Expressions", "type" -> 
    "Tutorial", "uri" -> "tutorial/HandlingListsArraysAndOtherExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.4"->{
  Cell[5060, 116, 112, 2, 70, "Title",
   CellTags->{"S2.13.4", "4.1"},
   CellID->411266683]},
 "4.1"->{
  Cell[5060, 116, 112, 2, 70, "Title",
   CellTags->{"S2.13.4", "4.1"},
   CellID->411266683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.4", 63632, 2309},
 {"4.1", 63738, 2313}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 4435, 89, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5060, 116, 112, 2, 70, "Title",
 CellTags->{"S2.13.4", "4.1"},
 CellID->411266683],
Cell[5175, 120, 507, 17, 70, "Text",
 CellID->286793771],
Cell[5685, 139, 1461, 44, 70, "DefinitionBox3Col",
 CellID->568072851],
Cell[7149, 185, 65, 1, 70, "Caption",
 CellID->50271946],
Cell[7217, 188, 193, 6, 70, "MathCaption",
 CellID->316862481],
Cell[7413, 196, 184, 10, 70, "Program",
 CellID->243738654],
Cell[7600, 208, 218, 5, 70, "MathCaption",
 CellID->97825824],
Cell[7821, 215, 154, 11, 70, "Program",
 CellID->184759401],
Cell[7978, 228, 182, 6, 70, "MathCaption",
 CellID->16085],
Cell[CellGroupData[{
Cell[8185, 238, 112, 3, 70, "Input",
 CellID->15713],
Cell[8300, 243, 240, 7, 36, "Output",
 CellID->30935]
}, Open  ]],
Cell[8555, 253, 69, 1, 70, "MathCaption",
 CellID->19735],
Cell[CellGroupData[{
Cell[8649, 258, 151, 5, 70, "Input",
 CellID->30883],
Cell[8803, 265, 155, 5, 36, "Output",
 CellID->2186]
}, Open  ]],
Cell[8973, 273, 199, 6, 70, "MathCaption",
 CellID->16096],
Cell[CellGroupData[{
Cell[9197, 283, 95, 3, 70, "Input",
 CellID->20648],
Cell[9295, 288, 182, 6, 36, "Output",
 CellID->2085]
}, Open  ]],
Cell[9492, 297, 293, 9, 70, "MathCaption",
 CellID->14752],
Cell[CellGroupData[{
Cell[9810, 310, 149, 5, 70, "Input",
 CellID->521],
Cell[9962, 317, 160, 5, 36, "Output",
 CellID->9260]
}, Open  ]],
Cell[10137, 325, 337, 9, 70, "Text",
 CellID->21982],
Cell[10477, 336, 172, 7, 70, "MathCaption",
 CellID->7688],
Cell[10652, 345, 93, 4, 70, "Program",
 CellID->19919],
Cell[10748, 351, 98, 2, 70, "MathCaption",
 CellID->17236],
Cell[10849, 355, 89, 1, 70, "Program",
 CellID->26792],
Cell[10941, 358, 323, 10, 70, "Text",
 CellID->19278],
Cell[11267, 370, 858, 25, 70, "Text",
 CellID->4198],
Cell[12128, 397, 4554, 145, 70, "DefinitionBox",
 CellID->31496],
Cell[16685, 544, 183, 8, 70, "Caption",
 CellID->26386],
Cell[16871, 554, 1019, 32, 70, "Text",
 CellID->21011],
Cell[17893, 588, 1313, 42, 70, "Text",
 CellID->10976],
Cell[19209, 632, 282, 10, 70, "MathCaption",
 CellID->12121],
Cell[19494, 644, 184, 10, 70, "Program",
 CellID->23202],
Cell[19681, 656, 148, 5, 70, "MathCaption",
 CellID->7245],
Cell[19832, 663, 79, 6, 70, "Program",
 CellID->6702],
Cell[19914, 671, 132, 5, 70, "MathCaption",
 CellID->28564],
Cell[20049, 678, 151, 10, 70, "Program",
 CellID->31539],
Cell[20203, 690, 238, 10, 70, "MathCaption",
 CellID->2572],
Cell[20444, 702, 95, 5, 70, "Program",
 CellID->2257],
Cell[20542, 709, 161, 5, 70, "MathCaption",
 CellID->21920],
Cell[CellGroupData[{
Cell[20728, 718, 115, 3, 70, "Input",
 CellID->31654],
Cell[20846, 723, 232, 7, 36, "Output",
 CellID->19359]
}, Open  ]],
Cell[21093, 733, 89, 1, 70, "MathCaption",
 CellID->11080],
Cell[CellGroupData[{
Cell[21207, 738, 97, 3, 70, "Input",
 CellID->7298],
Cell[21307, 743, 220, 7, 36, "Output",
 CellID->23391]
}, Open  ]],
Cell[21542, 753, 617, 23, 70, "Text",
 CellID->23960],
Cell[22162, 778, 105, 3, 70, "MathCaption",
 CellID->25867],
Cell[22270, 783, 56, 1, 70, "Program",
 CellID->22033],
Cell[22329, 786, 208, 7, 70, "MathCaption",
 CellID->1675],
Cell[22540, 795, 64, 1, 70, "Program",
 CellID->12136],
Cell[22607, 798, 225, 8, 70, "MathCaption",
 CellID->17775],
Cell[22835, 808, 86, 1, 70, "Program",
 CellID->25790],
Cell[22924, 811, 561, 20, 70, "Text",
 CellID->20272],
Cell[23488, 833, 269, 11, 70, "MathCaption",
 CellID->5086],
Cell[23760, 846, 71, 1, 70, "Program",
 CellID->20967],
Cell[23834, 849, 152, 5, 70, "MathCaption",
 CellID->9515],
Cell[23989, 856, 63, 1, 70, "Program",
 CellID->23542],
Cell[24055, 859, 157, 5, 70, "MathCaption",
 CellID->23495],
Cell[24215, 866, 62, 1, 70, "Program",
 CellID->3566],
Cell[24280, 869, 757, 24, 70, "Text",
 CellID->14186],
Cell[25040, 895, 146, 6, 70, "MathCaption",
 CellID->19198],
Cell[25189, 903, 71, 1, 70, "Program",
 CellID->12626],
Cell[25263, 906, 181, 7, 70, "MathCaption",
 CellID->18364],
Cell[25447, 915, 69, 1, 70, "Program",
 CellID->1085],
Cell[25519, 918, 117, 3, 70, "MathCaption",
 CellID->31665],
Cell[25639, 923, 71, 1, 70, "Program",
 CellID->18908],
Cell[25713, 926, 117, 3, 70, "MathCaption",
 CellID->20340],
Cell[25833, 931, 58, 1, 70, "Program",
 CellID->1360],
Cell[25894, 934, 72, 1, 70, "MathCaption",
 CellID->2814],
Cell[25969, 937, 63, 1, 70, "Program",
 CellID->21154],
Cell[26035, 940, 1168, 36, 70, "Text",
 CellID->19752],
Cell[27206, 978, 163, 5, 70, "MathCaption",
 CellID->12525],
Cell[27372, 985, 44, 1, 70, "Program",
 CellID->30630],
Cell[27419, 988, 189, 8, 70, "MathCaption",
 CellID->23179],
Cell[27611, 998, 71, 1, 70, "Program",
 CellID->3079],
Cell[27685, 1001, 56, 1, 70, "Program",
 CellID->8313],
Cell[27744, 1004, 137, 5, 70, "MathCaption",
 CellID->28838],
Cell[27884, 1011, 76, 1, 70, "Program",
 CellID->32517],
Cell[27963, 1014, 60, 1, 70, "Program",
 CellID->8421],
Cell[28026, 1017, 74, 1, 70, "MathCaption",
 CellID->14145],
Cell[28103, 1020, 83, 1, 70, "Program",
 CellID->5991],
Cell[28189, 1023, 49, 4, 70, "Program",
 CellID->1969],
Cell[28241, 1029, 1017, 29, 70, "Text",
 CellID->16565],
Cell[29261, 1060, 263, 7, 70, "Text",
 CellID->23762],
Cell[29527, 1069, 177, 6, 70, "MathCaption",
 CellID->19473],
Cell[CellGroupData[{
Cell[29729, 1079, 361, 13, 70, "Input",
 CellID->23681],
Cell[30093, 1094, 233, 7, 36, "Output",
 CellID->21970]
}, Open  ]],
Cell[30341, 1104, 126, 4, 70, "MathCaption",
 CellID->23147],
Cell[CellGroupData[{
Cell[30492, 1112, 351, 13, 70, "Input",
 CellID->27053],
Cell[30846, 1127, 458, 17, 36, "Output",
 CellID->22708]
}, Open  ]],
Cell[31319, 1147, 194, 7, 70, "MathCaption",
 CellID->6508],
Cell[CellGroupData[{
Cell[31538, 1158, 100, 3, 70, "Input",
 CellID->16715],
Cell[31641, 1163, 232, 7, 36, "Output",
 CellID->4429]
}, Open  ]],
Cell[31888, 1173, 205, 7, 70, "MathCaption",
 CellID->31066],
Cell[CellGroupData[{
Cell[32118, 1184, 246, 8, 70, "Input",
 CellID->27689],
Cell[32367, 1194, 201, 7, 36, "Output",
 CellID->14663]
}, Open  ]],
Cell[32583, 1204, 554, 17, 70, "Text",
 CellID->11771],
Cell[33140, 1223, 208, 8, 70, "MathCaption",
 CellID->16259],
Cell[33351, 1233, 71, 1, 70, "Program",
 CellID->18631],
Cell[33425, 1236, 149, 6, 70, "Program",
 CellID->23572],
Cell[33577, 1244, 208, 8, 70, "MathCaption",
 CellID->2514],
Cell[33788, 1254, 79, 1, 70, "Program",
 CellID->10966],
Cell[33870, 1257, 56, 1, 70, "MathCaption",
 CellID->25988],
Cell[33929, 1260, 109, 5, 70, "Program",
 CellID->18170],
Cell[34041, 1267, 36, 1, 70, "Program",
 CellID->28168],
Cell[34080, 1270, 213, 8, 70, "MathCaption",
 CellID->22199],
Cell[34296, 1280, 73, 1, 70, "Program",
 CellID->655],
Cell[34372, 1283, 881, 28, 70, "DefinitionBox",
 CellID->13444],
Cell[35256, 1313, 155, 6, 70, "Caption",
 CellID->12936],
Cell[35414, 1321, 781, 29, 70, "Text",
 CellID->16278],
Cell[36198, 1352, 535, 19, 70, "Text",
 CellID->19406],
Cell[36736, 1373, 69, 4, 70, "Program",
 CellID->10313],
Cell[36808, 1379, 187, 8, 70, "MathCaption",
 CellID->7523],
Cell[36998, 1389, 80, 1, 70, "Program",
 CellID->32371],
Cell[37081, 1392, 111, 3, 70, "MathCaption",
 CellID->23327],
Cell[37195, 1397, 61, 1, 70, "Program",
 CellID->17073],
Cell[37259, 1400, 114, 3, 70, "MathCaption",
 CellID->23461],
Cell[37376, 1405, 68, 1, 70, "Program",
 CellID->2173],
Cell[37447, 1408, 70, 5, 70, "Program",
 CellID->9934],
Cell[37520, 1415, 95, 1, 70, "MathCaption",
 CellID->31102],
Cell[37618, 1418, 61, 4, 70, "Program",
 CellID->25587],
Cell[37682, 1424, 175, 7, 70, "MathCaption",
 CellID->31417],
Cell[37860, 1433, 59, 4, 70, "Program",
 CellID->31463],
Cell[37922, 1439, 253, 9, 70, "MathCaption",
 CellID->6153],
Cell[38178, 1450, 97, 5, 70, "Program",
 CellID->26126],
Cell[38278, 1457, 61, 4, 70, "Program",
 CellID->20595],
Cell[38342, 1463, 756, 24, 70, "Text",
 CellID->29213],
Cell[39101, 1489, 887, 25, 70, "DefinitionBox",
 CellID->2406],
Cell[39991, 1516, 126, 6, 70, "Caption",
 CellID->27370],
Cell[40120, 1524, 69, 4, 70, "Program",
 CellID->23305],
Cell[40192, 1530, 210, 8, 70, "MathCaption",
 CellID->22496],
Cell[40405, 1540, 69, 1, 70, "Program",
 CellID->24833],
Cell[40477, 1543, 91, 1, 70, "MathCaption",
 CellID->24223],
Cell[40571, 1546, 54, 1, 70, "Program",
 CellID->4852],
Cell[40628, 1549, 113, 3, 70, "MathCaption",
 CellID->17879],
Cell[40744, 1554, 60, 1, 70, "Program",
 CellID->30519],
Cell[40807, 1557, 73, 5, 70, "Program",
 CellID->6126],
Cell[40883, 1564, 89, 1, 70, "MathCaption",
 CellID->7793],
Cell[40975, 1567, 57, 4, 70, "Program",
 CellID->31585],
Cell[41035, 1573, 70, 1, 70, "MathCaption",
 CellID->21465],
Cell[41108, 1576, 73, 5, 70, "Program",
 CellID->31371],
Cell[41184, 1583, 192, 6, 70, "MathCaption",
 CellID->15444],
Cell[41379, 1591, 87, 4, 70, "Program",
 CellID->17107],
Cell[41469, 1597, 176, 6, 70, "MathCaption",
 CellID->17271],
Cell[41648, 1605, 101, 4, 70, "Program",
 CellID->24087],
Cell[41752, 1611, 552, 15, 70, "Text",
 CellID->8596],
Cell[42307, 1628, 368, 11, 70, "Text",
 CellID->5715],
Cell[42678, 1641, 2024, 63, 70, "DefinitionBox",
 CellID->17552],
Cell[44705, 1706, 61, 1, 70, "Caption",
 CellID->22492],
Cell[44769, 1709, 616, 20, 70, "Text",
 CellID->14753],
Cell[45388, 1731, 221, 5, 70, "Text",
 CellID->8257],
Cell[45612, 1738, 816, 26, 70, "Text",
 CellID->27590],
Cell[46431, 1766, 113, 3, 70, "MathCaption",
 CellID->13357],
Cell[46547, 1771, 57, 4, 70, "Program",
 CellID->10886],
Cell[46607, 1777, 153, 5, 70, "MathCaption",
 CellID->7809],
Cell[46763, 1784, 65, 5, 70, "Program",
 CellID->5865],
Cell[46831, 1791, 163, 5, 70, "MathCaption",
 CellID->25686],
Cell[46997, 1798, 84, 4, 70, "Program",
 CellID->32019],
Cell[47084, 1804, 101, 2, 70, "MathCaption",
 CellID->22313],
Cell[47188, 1808, 75, 1, 70, "Program",
 CellID->2435],
Cell[47266, 1811, 47, 4, 70, "Program",
 CellID->1028],
Cell[47316, 1817, 717, 21, 70, "Text",
 CellID->10468],
Cell[48036, 1840, 2573, 77, 70, "DefinitionBox",
 CellID->22869],
Cell[50612, 1919, 60, 1, 70, "Caption",
 CellID->456],
Cell[50675, 1922, 693, 22, 70, "Text",
 CellID->6731],
Cell[51371, 1946, 683, 25, 70, "Text",
 CellID->7578],
Cell[52057, 1973, 820, 26, 70, "Text",
 CellID->26074],
Cell[52880, 2001, 518, 17, 70, "Text",
 CellID->11395],
Cell[53401, 2020, 1750, 53, 70, "DefinitionBox",
 CellID->30843],
Cell[55154, 2075, 79, 1, 70, "Caption",
 CellID->31274],
Cell[55236, 2078, 592, 18, 70, "Text",
 CellID->13316],
Cell[55831, 2098, 1036, 31, 70, "Text",
 CellID->15024],
Cell[56870, 2131, 1428, 41, 70, "DefinitionBox",
 CellID->30511],
Cell[58301, 2174, 66, 1, 70, "Caption",
 CellID->18585],
Cell[58370, 2177, 1068, 34, 70, "Text",
 CellID->5722],
Cell[CellGroupData[{
Cell[59463, 2215, 71, 1, 70, "RelatedTutorialsSection",
 CellID->19422832],
Cell[59537, 2218, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[59942, 2233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

