(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16663,        606]
NotebookOptionsPosition[     11878,        457]
NotebookOutlinePosition[     14675,        529]
CellTagsIndexPosition[     14584,        523]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Textual Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TextualInputAndOutputOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Textual Input and Output\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Input" :> Documentation`HelpLookup["paclet:ref/Input"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Input\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["How Input and Output Work", "Title",
 CellTags->{"S2.9.2", "2.1"},
 CellID->8971],

Cell[BoxData[GridBox[{
   {Cell[TextData[ButtonBox["Input",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Input"]], "TableText"], Cell[
    "convert from a textual form to an expression", "TableText"]},
   {Cell["Processing", "TableText"], Cell[
    "do computations on the expression", "TableText"]},
   {Cell["Output", "TableText"], Cell[
    "convert the resulting expression to textual form", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10057],

Cell[TextData[{
 "Steps in the operation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->14095],

Cell[TextData[{
 "When you type something like ",
 Cell[BoxData[
  RowBox[{"x", "^", "2"}]], "InlineFormula"],
 " what ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " at first sees is just the string of characters ",
 Cell[BoxData["x"], "InlineFormula"],
 ", ",
 Cell[BoxData["^"], "InlineFormula"],
 ", ",
 Cell[BoxData["2"], "InlineFormula"],
 ". But with the usual way that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is set up, it immediately knows to convert this string of characters into \
the expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{"x", ",", "2"}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->8174],

Cell[TextData[{
 "Then, after whatever processing is possible has been done, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes the expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{"x", ",", "2"}], "]"}]], "InlineFormula"],
 " and converts it into some kind of textual representation for output. "
}], "Text",
 CellID->5038],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reads the string of characters ",
 Cell[BoxData["x"], "InlineFormula"],
 ", ",
 Cell[BoxData["^"], "InlineFormula"],
 ", ",
 Cell[BoxData["2"], "InlineFormula"],
 " and converts it to the expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{"x", ",", "2"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "^", "2"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->26658],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->17295]
}, Open  ]],

Cell["This shows the expression in Fortran form. ", "MathCaption",
 CellID->25722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FortranForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->16983],

Cell["x**2", "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FortranForm= ",
 CellID->6231]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 " is just a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote]: the \
value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", "2", "]"}]], "InlineFormula"],
 " is still the expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{"x", ",", "2"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->29503],

Cell[CellGroupData[{

Cell[BoxData["%"], "Input",
 CellLabel->"In[3]:= ",
 CellID->2232],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->24300]
}, Open  ]],

Cell[TextData[{
 "It is important to understand that in a typical ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " record only the underlying expressions that are processed, not the textual \
representations that happen to be used for their input or output. "
}], "Text",
 CellID->15590],

Cell[TextData[{
 "If you explicitly request a particular kind of output, say by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ", then what you get will be labeled with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Out",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Out"], "[", 
    StyleBox["n", "TI"], "]"}], "//", 
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"]}]], "InlineFormula"],
 ". This indicates that what you are seeing is ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "//", 
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"]}]], "InlineFormula"],
 ", even though the value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " itself is just ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21480],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also allows you to specify globally that you want output to be displayed \
in a particular form. And if you do this, then the form will no longer be \
indicated explicitly in the label for each line. But it is still the case \
that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " will record only underlying expressions, not the textual representations \
used for their input and output. "
}], "Text",
 CellID->17408],

Cell[TextData[{
 "This sets ",
 Cell[BoxData["t"], "InlineFormula"],
 " to be an expression with ",
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 " explicitly wrapped around it. "
}], "MathCaption",
 CellID->15505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"FortranForm", "[", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->32702],

Cell["x**2 + y**2", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FortranForm= ",
 CellID->22858]
}, Open  ]],

Cell["The result on the previous line is just the expression. ", "MathCaption",
 CellID->9818],

Cell[CellGroupData[{

Cell[BoxData["%"], "Input",
 CellLabel->"In[5]:= ",
 CellID->10557],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->15561]
}, Open  ]],

Cell[TextData[{
 "But ",
 Cell[BoxData["t"], "InlineFormula"],
 " contains the ",
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 " wrapper, and so is displayed in ",
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24120],

Cell[CellGroupData[{

Cell[BoxData["t"], "Input",
 CellLabel->"In[6]:= ",
 CellID->5028],

Cell["x**2 + y**2", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//FortranForm= ",
 CellID->23656]
}, Open  ]],

Cell[TextData[{
 "Wherever ",
 Cell[BoxData["t"], "InlineFormula"],
 " appears, it is formatted in ",
 Cell[BoxData[
  ButtonBox["FortranForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FortranForm"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"t", "^", "2"}], ",", 
   RowBox[{"1", "/", "t"}]}], "}"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->3332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"x", "**", "2"}], " ", "+", " ", 
       RowBox[{"y", "**", "2"}]}],
      ShowStringCharacters->True,
      NumberMarks->True],
     FortranForm[x^2 + y^2],
     AutoDelete->True,
     Editable->True], "2"], ",", 
   FractionBox["1", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       RowBox[{"x", "**", "2"}], " ", "+", " ", 
       RowBox[{"y", "**", "2"}]}],
      ShowStringCharacters->True,
      NumberMarks->True],
     FortranForm[x^2 + y^2],
     AutoDelete->True,
     Editable->True]]}], "}"}]], "Output",
 ImageSize->{211, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->23092]
}, Open  ]],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TextualInputAndOutputOverview"]], "RelatedTutorials",
 CellID->364580606]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"How Input and Output Work - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Textual Input and Output", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/TextualInputAndOutputOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FormsOfInputAndOutput"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/TheRepresentationOfTextualForms"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 0.0045102}", "context" -> "", 
    "keywords" -> {"wrappers"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Steps in the operation of Mathematica. When you type something like x^2 \
what Mathematica at first sees is just the string of characters x, ^, 2. But \
with the usual way that Mathematica is set up, it immediately knows to \
convert this string of characters into the expression Power[x,2]. Then, after \
whatever processing is possible has been done, Mathematica takes the \
expression Power[x,2] and converts it into some kind of textual \
representation for output. ", "synonyms" -> {"2.9.2"}, "title" -> 
    "How Input and Output Work", "type" -> "Tutorial", "uri" -> 
    "tutorial/HowInputAndOutputWork"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.9.2"->{
  Cell[1807, 58, 87, 2, 70, "Title",
   CellTags->{"S2.9.2", "2.1"},
   CellID->8971]},
 "2.1"->{
  Cell[1807, 58, 87, 2, 70, "Title",
   CellTags->{"S2.9.2", "2.1"},
   CellID->8971]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.9.2", 14375, 512},
 {"2.1", 14473, 516}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1182, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1807, 58, 87, 2, 70, "Title",
 CellTags->{"S2.9.2", "2.1"},
 CellID->8971],
Cell[1897, 62, 752, 17, 70, "DefinitionBox",
 CellID->10057],
Cell[2652, 81, 132, 6, 70, "Caption",
 CellID->14095],
Cell[2787, 89, 733, 26, 70, "Text",
 CellID->8174],
Cell[3523, 117, 424, 13, 70, "Text",
 CellID->5038],
Cell[3950, 132, 477, 18, 70, "MathCaption",
 CellID->2183],
Cell[CellGroupData[{
Cell[4452, 154, 89, 3, 28, "Input",
 CellID->26658],
Cell[4544, 159, 178, 6, 36, "Output",
 CellID->17295]
}, Open  ]],
Cell[4737, 168, 82, 1, 70, "MathCaption",
 CellID->25722],
Cell[CellGroupData[{
Cell[4844, 173, 104, 3, 28, "Input",
 CellID->16983],
Cell[4951, 178, 161, 5, 50, "Output",
 CellID->6231]
}, Open  ]],
Cell[5127, 186, 606, 21, 70, "MathCaption",
 CellID->29503],
Cell[CellGroupData[{
Cell[5758, 211, 66, 2, 70, "Input",
 CellID->2232],
Cell[5827, 215, 178, 6, 36, "Output",
 CellID->24300]
}, Open  ]],
Cell[6020, 224, 635, 21, 70, "Text",
 CellID->15590],
Cell[6658, 247, 1148, 38, 70, "Text",
 CellID->21480],
Cell[7809, 287, 771, 23, 70, "Text",
 CellID->17408],
Cell[8583, 312, 294, 10, 70, "MathCaption",
 CellID->15505],
Cell[CellGroupData[{
Cell[8902, 326, 201, 7, 70, "Input",
 CellID->32702],
Cell[9106, 335, 169, 5, 50, "Output",
 CellID->22858]
}, Open  ]],
Cell[9290, 343, 94, 1, 70, "MathCaption",
 CellID->9818],
Cell[CellGroupData[{
Cell[9409, 348, 67, 2, 70, "Input",
 CellID->10557],
Cell[9479, 352, 225, 8, 36, "Output",
 CellID->15561]
}, Open  ]],
Cell[9719, 363, 410, 15, 70, "MathCaption",
 CellID->24120],
Cell[CellGroupData[{
Cell[10154, 382, 66, 2, 70, "Input",
 CellID->5028],
Cell[10223, 386, 169, 5, 50, "Output",
 CellID->23656]
}, Open  ]],
Cell[10407, 394, 267, 10, 70, "MathCaption",
 CellID->25713],
Cell[CellGroupData[{
Cell[10699, 408, 159, 6, 70, "Input",
 CellID->3332],
Cell[10861, 416, 782, 29, 53, "Output",
 CellID->23092]
}, Open  ]],
Cell[11658, 448, 178, 4, 70, "RelatedTutorials",
 CellID->364580606]
}, Open  ]],
Cell[11851, 455, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

