(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14272,        480]
NotebookOptionsPosition[      9752,        356]
NotebookOutlinePosition[     12983,        433]
CellTagsIndexPosition[     12891,        427]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"MathLink and External Program Communication" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]},\
 #, 2]& , Evaluator -> Automatic], {
      1->"\<\"MathLink and External Program Communication\"\>"}, "\<\"related \
tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "How ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Is Used"
}], "Title",
 CellTags->{"S2.13.1", "1.1"},
 CellID->17182],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " provides a mechanism through which ",
 "programs",
 " can interact with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->26467],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Calling functions in an external program from \
within ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Calling ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " from within an external program."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Setting up alternative front ends to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Exchanging data between ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " and external programs."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Exchanging data between concurrent ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " processes."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11320],

Cell[TextData[{
 "Some typical uses of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->7358],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " provides a general interface for external programs to communicate with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Many standard software systems now have ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " compatibility either built in or available in add\[Hyphen]on modules. "
}], "Text",
 CellID->21074],

Cell[TextData[{
 "In addition, the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit bundled with most versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides the tools you need to create your own ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible programs. "
}], "Text",
 CellID->3987],

Cell[TextData[{
 "Once you have a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible program, you can transparently establish a link between \
it and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->9094],

Cell["\<\
The link can either be on a single computer, or it can be over a network, \
potentially with a different type of computer at each end. \
\>", "Text",
 CellID->4983],

Cell[BoxData[GridBox[{
   {Cell["\<\
\[FilledSmallSquare] Implementing inner loops in a low\[Hyphen]level \
language.\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Handling large volumes of data external to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Sending ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " graphics or other data for special processing."
    }], "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Connecting to a system with an existing user interface.\
\>", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21364],

Cell[TextData[{
 "A few uses of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible programs. "
}], "Caption",
 CellID->27264],

Cell[TextData[{
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible programs range from very simple to very complex. A \
minimal ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible program is just a few lines long. But it is also \
possible to build very large and sophisticated ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible programs. Indeed, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook front end is one example of a sophisticated ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible program. "
}], "Text",
 CellID->19714],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " is a mechanism for exchanging ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expressions between programs."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26746],

Cell[TextData[{
 "The basic idea of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->24390],

Cell[TextData[{
 "Much of the power of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " comes from its use of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. The basic idea is that ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " provides a way to exchange ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions between programs, and such expressions can represent \
absolutely any kind of data. "
}], "Text",
 CellID->10425],

Cell[BoxData[GridBox[{
   {Cell["\[FilledSmallSquare] An array of numbers.", "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] A collection of geometrical objects.\
\>", "TableText"]},
   {Cell["\[FilledSmallSquare] A sequence of commands.", "TableText"]},
   {Cell["\[FilledSmallSquare] A stream of text.", "TableText"]},
   {Cell["\[FilledSmallSquare] Records in a database.", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] The cells of a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebook."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26255],

Cell[TextData[{
 "A few examples of data represented by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->13163],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library consists of a collection of routines that allow external programs \
to send and receive ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions using the fundamental C data types."
}], "Text",
 CellID->31467],

Cell[TextData[{
 "The ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " Developer Kit provides utilities for incorporating these routines into \
external programs. Utilities are included for a variety of languages, \
although here we discuss mainly the case of C. "
}], "Text",
 CellID->5792],

Cell[TextData[{
 "An important feature of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library is that it is completely platform independent: it can \
transparently use any interprogram communication mechanism that exists on \
your computer system."
}], "Text",
 CellID->14231],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->47566739],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"How MathLink Is Used - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 0.5670246}", "context" -> "", 
    "keywords" -> {
     "add-in programs", "Apple events", "AppleTalk", "communication", 
      "concurrent Mathematica sessions", "C program interface", "DDE", 
      "developer kit", "distributed processing", "external functions", 
      "Fortran", "front ends", "functions", "graphics", "inner loops", 
      "interprocess communication", "IPC", "IPX", "Java", "library", "links", 
      "MathLink", "messaging mechanisms", "named pipes", "Novell networks", 
      "open architecture", "OpenMath", "OpenTransport", 
      "parallel Mathematica sessions", "Pascal", "pipes", "plug-in programs", 
      "plugins", "plug-ins", "programming interface to Mathematica", 
      "programprogram communication", "programs", "protocol", "routines", 
      "software bus", "transport mechanism", "WINSOCK", "XCMDs", "XFUNs"}, 
    "index" -> True, "label" -> "Mathematica Tutorial", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MathLink provides a mechanism through which programs can interact with \
Mathematica. Some typical uses of MathLink. MathLink provides a general \
interface for external programs to communicate with Mathematica. Many \
standard software systems now have MathLink compatibility either built in or \
available in add-on modules. ", "synonyms" -> {"2.13.1"}, "title" -> 
    "How MathLink Is Used", "type" -> "Tutorial", "uri" -> 
    "tutorial/HowMathLinkIsUsed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.1"->{
  Cell[1322, 44, 142, 7, 70, "Title",
   CellTags->{"S2.13.1", "1.1"},
   CellID->17182]},
 "1.1"->{
  Cell[1322, 44, 142, 7, 70, "Title",
   CellTags->{"S2.13.1", "1.1"},
   CellID->17182]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.1", 12676, 416},
 {"1.1", 12777, 420}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 697, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1322, 44, 142, 7, 70, "Title",
 CellTags->{"S2.13.1", "1.1"},
 CellID->17182],
Cell[1467, 53, 221, 10, 70, "Text",
 CellID->26467],
Cell[1691, 65, 1288, 41, 70, "FramedBox",
 CellID->11320],
Cell[2982, 108, 123, 6, 70, "Caption",
 CellID->7358],
Cell[3108, 116, 383, 11, 70, "Text",
 CellID->21074],
Cell[3494, 129, 342, 12, 70, "Text",
 CellID->3987],
Cell[3839, 143, 254, 10, 70, "Text",
 CellID->9094],
Cell[4096, 155, 174, 4, 70, "Text",
 CellID->4983],
Cell[4273, 161, 962, 28, 70, "FramedBox",
 CellID->21364],
Cell[5238, 191, 145, 6, 70, "Caption",
 CellID->27264],
Cell[5386, 199, 624, 19, 70, "Text",
 CellID->19714],
Cell[6013, 220, 598, 18, 70, "FramedBox",
 CellID->26746],
Cell[6614, 240, 121, 6, 70, "Caption",
 CellID->24390],
Cell[6738, 248, 463, 16, 70, "Text",
 CellID->10425],
Cell[7204, 266, 911, 23, 70, "FramedBox",
 CellID->26255],
Cell[8118, 291, 211, 9, 70, "Caption",
 CellID->13163],
Cell[8332, 302, 301, 10, 70, "Text",
 CellID->31467],
Cell[8636, 314, 294, 8, 70, "Text",
 CellID->5792],
Cell[8933, 324, 288, 8, 70, "Text",
 CellID->14231],
Cell[CellGroupData[{
Cell[9246, 336, 71, 1, 70, "RelatedTutorialsSection",
 CellID->47566739],
Cell[9320, 339, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[9725, 354, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

