(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33851,       1243]
NotebookOptionsPosition[     25408,        964]
NotebookOutlinePosition[     28635,       1042]
CellTagsIndexPosition[     28542,       1036]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Modularity and the Naming of Things" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"], 
          "Basic Internal Architecture" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BasicInternalArchitecture"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Modularity and the Naming of Things\"\>", 
       2->"\<\"Basic Internal Architecture\"\>"}, "\<\"related tutorials\"\>",
        
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Module" :> Documentation`HelpLookup["paclet:ref/Module"], 
          "Unique" :> Documentation`HelpLookup["paclet:ref/Unique"], 
          "$ModuleNumber" :> 
          Documentation`HelpLookup["paclet:ref/$ModuleNumber"], "$SessionID" :> 
          Documentation`HelpLookup["paclet:ref/$SessionID"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Module\"\>", 2->"\<\"Unique\"\>", 
       3->"\<\"$ModuleNumber\"\>", 
       4->"\<\"$SessionID\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["How Modules Work", "Title",
 CellTags->{"S2.7.3", "3.1"},
 CellID->22619],

Cell[TextData[{
 "The way modules work in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is basically very simple. Every time any module is used, a new symbol is \
created to represent each of its local variables. The new symbol is given a \
unique name which cannot conflict with any other names. The name is formed by \
taking the name you specify for the local variable, followed by ",
 Cell[BoxData["$"], "InlineFormula"],
 ", with a unique \[OpenCurlyDoubleQuote]serial \
number\[CloseCurlyDoubleQuote] appended. "
}], "Text",
 CellID->2880],

Cell[TextData[{
 "The serial number is found from the value of the global variable ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 ". This variable counts the total number of times any ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " of any form has been used. "
}], "Text",
 CellID->4718],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      ButtonBox["Module",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Module"]], "InlineFormula"],
     " generates symbols with names of the form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["$", "MR"], 
       StyleBox["nnn", "TI"]}]], "InlineFormula"],
     " to represent each local variable."
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16128],

Cell[TextData[{
 "The basic principle of modules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->19948],

Cell[TextData[{
 "This shows the symbol generated for ",
 Cell[BoxData["t"], "InlineFormula"],
 " within the module. "
}], "MathCaption",
 CellID->4720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{"Print", "[", "t", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->9079],

Cell[BoxData["t$1"], "Print",
 CellID->32091]
}, Open  ]],

Cell["The symbols are different every time any module is used. ", \
"MathCaption",
 CellID->3766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", "u"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "t", "]"}], ";", 
    RowBox[{"Print", "[", "u", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->27587],

Cell[CellGroupData[{

Cell[BoxData["t$2"], "Print",
 CellID->5808],

Cell[BoxData["u$2"], "Print",
 CellID->12126]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "For most purposes, you will never have to deal directly with the actual \
symbols generated inside modules. However, if for example you start up a \
dialog while a module is being executed, then you will see these symbols. The \
same is true whenever you use functions like ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " to watch the evaluation of modules. "
}], "Text",
 CellID->14825],

Cell[TextData[{
 "You see the symbols that are generated inside modules when you use ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "t", "}"}], ",", 
    RowBox[{"t", "=", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->17518],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{"t", "=", "3"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"t$3", "=", "3"}],
      HoldForm], ",", 
     TagBox["3",
      HoldForm]}], "}"}], ",", 
   TagBox["3",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->3220]
}, Open  ]],

Cell["This starts a dialog inside a module. ", "MathCaption",
 CellID->10035],

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{
    RowBox[{"t", "=", "6"}], ";", 
    RowBox[{"Dialog", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->31314],

Cell[TextData[{
 "Inside the dialog, you see the symbols generated for local variables such \
as ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stack", "[", "_", "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->24147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       RowBox[{"t", "=", "6"}], ";", 
       RowBox[{"Dialog", "[", "]"}]}]}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"t$4", "=", "6"}], ";", 
     RowBox[{"Dialog", "[", "]"}]}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Dialog", "[", "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->29156]
}, Open  ]],

Cell["\<\
You can work with these symbols as you would with any other symbols. \
\>", "MathCaption",
 CellID->30134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t$4", "+", "1"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->3360],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->751]
}, Open  ]],

Cell["This returns from the dialog. ", "MathCaption",
 CellID->16208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{"t$4", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->31478],

Cell[BoxData["36"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22294]
}, Open  ]],

Cell["\<\
Under some circumstances, it is convenient explicitly to return symbols that \
are generated inside modules. \
\>", "Text",
 CellID->12589],

Cell["\<\
You can explicitly return symbols that are generated inside modules. \
\>", "MathCaption",
 CellID->17524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "t", "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->7976],

Cell[BoxData["t$6"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->9694]
}, Open  ]],

Cell["You can treat these symbols as you would any others. ", "MathCaption",
 CellID->4090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "^", "2"}], "+", "1"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->20189],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["t$6", "2"]}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->29372]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Unique",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unique"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "generate a new symbol with a unique name of the form ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["$", "MR"], 
       StyleBox["nnn", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Unique",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unique"], "[", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[
    "generate a list of new symbols", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7419],

Cell["Generating new symbols with unique names. ", "Caption",
 CellID->30301],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 " allows you to generate new symbols in the same way as ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " does. Each time you call ",
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " is incremented, so that the names of new symbols are guaranteed to be \
unique. "
}], "Text",
 CellID->21702],

Cell[TextData[{
 "This generates a unique new symbol whose name starts with ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "x", "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->20523],

Cell[BoxData["x$7"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->26539]
}, Open  ]],

Cell[TextData[{
 "Each time you call ",
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 " you get a symbol with a larger serial number. "
}], "MathCaption",
 CellID->20609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Unique", "[", "x", "]"}], ",", 
   RowBox[{"Unique", "[", "x", "]"}], ",", 
   RowBox[{"Unique", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->11827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x$8", ",", "x$9", ",", "x$10"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->6637]
}, Open  ]],

Cell[TextData[{
 "If you call ",
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 " with a list of names, you get the same serial number for each of the \
symbols. "
}], "MathCaption",
 CellID->8186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "xa", ",", "xb"}], "}"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->27416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x$11", ",", "xa$11", ",", "xb$11"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->1827]
}, Open  ]],

Cell[TextData[{
 "You can use the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["name", "TI"]}]], "InlineFormula"],
 " mechanism to get information on symbols that were generated inside modules \
or by the function ",
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15169],

Cell[TextData[{
 "Executing this module generates the symbol ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"q$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "q", "}"}], ",", 
   RowBox[{
    RowBox[{"q", "^", "2"}], "+", "1"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->14899],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["q$12", "2"]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->22514]
}, Open  ]],

Cell["You can see the generated symbol here. ", "MathCaption",
 CellID->10415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "q*"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->3644],

Cell["q    q$12", "Print",
 CellID->5436]
}, Open  ]],

Cell[TextData[{
 "Symbols generated by ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " behave in exactly the same way as other symbols for the purposes of \
evaluation. However, these symbols carry the attribute ",
 Cell[BoxData[
  ButtonBox["Temporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Temporary"]], "InlineFormula"],
 ", which specifies that they should be removed completely from the system \
when they are no longer used. Thus most symbols that are generated inside \
modules are removed when the execution of those modules is finished. The \
symbols survive only if they are explicitly returned. "
}], "Text",
 CellID->23669],

Cell[TextData[{
 "This shows a new ",
 Cell[BoxData["q"], "InlineFormula"],
 " variable generated inside a module. "
}], "MathCaption",
 CellID->10378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "q", "}"}], ",", 
   RowBox[{"Print", "[", "q", "]"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->31676],

Cell[BoxData["q$13"], "Print",
 CellID->17858]
}, Open  ]],

Cell["\<\
The new variable is removed when the execution of the module is finished, so \
it does not show up here. \
\>", "MathCaption",
 CellID->7952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "q*"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->9846],

Cell["q    q$12", "Print",
 CellID->27137]
}, Open  ]],

Cell[TextData[{
 "You should realize that the use of names such as ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 " for generated symbols is purely a convention. You can in principle give \
any symbol a name of this form. But if you do, the symbol may collide with \
one that is produced by ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->5915],

Cell[TextData[{
 "An important point to note is that symbols generated by ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " are in general unique only within a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. The variable ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " which determines the serial numbers for these symbols is always reset at \
the beginning of each session. "
}], "Text",
 CellID->22988],

Cell["\<\
This means in particular that if you save expressions containing generated \
symbols in a file, and then read them into another session, there is no \
guarantee that conflicts will not occur. \
\>", "Text",
 CellID->24616],

Cell[TextData[{
 "One way to avoid such conflicts is explicitly to set ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " differently at the beginning of each session. In particular, if you set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$ModuleNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ModuleNumber"], "=", 
   RowBox[{
    RowBox[{"10", "^", "10"}], " ", 
    ButtonBox["$SessionID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SessionID"]}]}]], "InlineFormula"],
 ", you should avoid any conflicts. The global variable ",
 Cell[BoxData[
  ButtonBox["$SessionID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SessionID"]], "InlineFormula"],
 " should give a unique number which characterizes a particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session on a particular computer. The value of this variable is determined \
from such quantities as the absolute date and time, the ID of your computer, \
and, if appropriate, the ID of the particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process. "
}], "Text",
 CellID->7288],

Cell[BoxData[GridBox[{
   {
    ButtonBox["$ModuleNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$ModuleNumber"], Cell[TextData[{
     "the serial number for symbols generated by ",
     Cell[BoxData[
      ButtonBox["Module",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Module"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Unique",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Unique"]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["$SessionID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SessionID"], Cell[TextData[{
     "a number that should be different for every ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2382],

Cell["\<\
Variables to be used in determining serial numbers for generated symbols. \
\>", "Caption",
 CellID->28074],

Cell[TextData[{
 "Having generated appropriate symbols to represent the local variables you \
have specified, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "[", 
   RowBox[{
    StyleBox["vars", "TI"], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " then has to evaluate ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 " using these symbols. The first step is to take the actual expression ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 " as it appears inside the module, and effectively to use ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " to replace all occurrences of each local variable name with the \
appropriate generated symbol. After this is done, ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " actually performs the evaluation of the resulting expression. "
}], "Text",
 CellID->20333],

Cell[TextData[{
 "An important point to note is that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "[", 
   RowBox[{
    StyleBox["vars", "TI"], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 " inserts generated symbols only into the actual expression ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ". It does not, for example, insert such symbols into code that is called \
from ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ", but does not explicitly appear in ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->3915],

Cell[TextData[{
 ButtonBox["\"Blocks and Local Values\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/BlocksAndLocalValues"],
 " will discuss how you can use ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " to set up \[OpenCurlyDoubleQuote]local values\[CloseCurlyDoubleQuote] \
which work in a different way. "
}], "Text",
 CellID->11056],

Cell[TextData[{
 "Since ",
 Cell[BoxData["x"], "InlineFormula"],
 " does not appear explicitly in the body of the module, the local value is \
not used. "
}], "MathCaption",
 CellID->25656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}]}], ";", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "=", "4"}], "}"}], ",", "tmp"}], "]"}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->30062],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->9616]
}, Open  ]],

Cell[TextData[{
 "Most of the time, you will probably set up modules by giving explicit ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "[", 
   RowBox[{
    StyleBox["vars", "TI"], ",", 
    StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
 ". Since the function ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", the form of ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 " will usually be kept unevaluated until the module is executed. "
}], "Text",
 CellID->24524],

Cell[TextData[{
 "It is, however, possible to build modules dynamically in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". The generation of new symbols, and their insertion into ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 " are always done only when a module is actually executed, not when the \
module is first given as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Text",
 CellID->12129],

Cell[TextData[{
 "This evaluates the body of the module immediately, making ",
 Cell[BoxData["x"], "InlineFormula"],
 " appear explicitly. "
}], "MathCaption",
 CellID->27442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}]}], ";", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "=", "4"}], "}"}], ",", 
    RowBox[{"Evaluate", "[", "tmp", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->1984],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->4872]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->4588307],

Cell[TextData[ButtonBox["Modularity and the Naming of Things",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], \
"RelatedTutorials",
 CellID->405226890],

Cell[TextData[ButtonBox["Basic Internal Architecture",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicInternalArchitecture"]], "RelatedTutorials",\

 CellID->10046906]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"How Modules Work - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Modularity and the Naming of Things", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/ModularityAndTheNamingOfThingsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/LocalConstants"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/VariablesInPureFunctionsAndRules"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 1.7076788}", "context" -> "", 
    "keywords" -> {
     "dialogs", "garbage collection", "gensym", "ID", "module", "modules", 
      "names", "persistent objects", "program equals data", "runs", "saving", 
      "serial number", "sessions", "symbols", "temporary", "trace", "unique", 
      "unique number", "unique symbols", "ModuleNumber", "SessionID", 
      "symbols"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "The way modules work in Mathematica is basically very simple. Every time \
any module is used, a new symbol is created to represent each of its local \
variables. The new symbol is given a unique name which cannot conflict with \
any other names. The name is formed by taking the name you specify for the \
local variable, followed by $, with a unique 'serial number' appended. The \
serial number is found from the value of the global variable $ModuleNumber. \
This variable counts the total number of times any Module of any form has \
been used. The basic principle of modules in Mathematica. ", 
    "synonyms" -> {"2.7.3"}, "title" -> "How Modules Work", "type" -> 
    "Tutorial", "uri" -> "tutorial/HowModulesWork"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.7.3"->{
  Cell[2353, 67, 79, 2, 70, "Title",
   CellTags->{"S2.7.3", "3.1"},
   CellID->22619]},
 "3.1"->{
  Cell[2353, 67, 79, 2, 70, "Title",
   CellTags->{"S2.7.3", "3.1"},
   CellID->22619]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.7.3", 28331, 1025},
 {"3.1", 28430, 1029}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1728, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2353, 67, 79, 2, 70, "Title",
 CellTags->{"S2.7.3", "3.1"},
 CellID->22619],
Cell[2435, 71, 554, 12, 70, "Text",
 CellID->2880],
Cell[2992, 85, 446, 13, 70, "Text",
 CellID->4718],
Cell[3441, 100, 776, 23, 70, "FramedBox",
 CellID->16128],
Cell[4220, 125, 140, 6, 70, "Caption",
 CellID->19948],
Cell[4363, 133, 152, 5, 70, "MathCaption",
 CellID->4720],
Cell[CellGroupData[{
Cell[4540, 142, 178, 6, 70, "Input",
 CellID->9079],
Cell[4721, 150, 45, 1, 70, "Print",
 CellID->32091]
}, Open  ]],
Cell[4781, 154, 97, 2, 70, "MathCaption",
 CellID->3766],
Cell[CellGroupData[{
Cell[4903, 160, 263, 9, 70, "Input",
 CellID->27587],
Cell[CellGroupData[{
Cell[5191, 173, 44, 1, 70, "Print",
 CellID->5808],
Cell[5238, 176, 45, 1, 70, "Print",
 CellID->12126]
}, Open  ]]
}, Open  ]],
Cell[5310, 181, 476, 11, 70, "Text",
 CellID->14825],
Cell[5789, 194, 241, 8, 70, "MathCaption",
 CellID->31159],
Cell[CellGroupData[{
Cell[6055, 206, 205, 7, 70, "Input",
 CellID->17518],
Cell[6263, 215, 515, 22, 36, "Output",
 CellID->3220]
}, Open  ]],
Cell[6793, 240, 77, 1, 70, "MathCaption",
 CellID->10035],
Cell[6873, 243, 225, 8, 70, "Input",
 CellID->31314],
Cell[7101, 253, 178, 6, 70, "MathCaption",
 CellID->25456],
Cell[CellGroupData[{
Cell[7304, 263, 98, 3, 70, "Input",
 CellID->24147],
Cell[7405, 268, 579, 23, 36, "Output",
 CellID->29156]
}, Open  ]],
Cell[7999, 294, 116, 3, 70, "MathCaption",
 CellID->30134],
Cell[CellGroupData[{
Cell[8140, 301, 90, 3, 70, "Input",
 CellID->3360],
Cell[8233, 306, 153, 5, 36, "Output",
 CellID->751]
}, Open  ]],
Cell[8401, 314, 69, 1, 70, "MathCaption",
 CellID->16208],
Cell[CellGroupData[{
Cell[8495, 319, 124, 4, 70, "Input",
 CellID->31478],
Cell[8622, 325, 156, 5, 36, "Output",
 CellID->22294]
}, Open  ]],
Cell[8793, 333, 149, 4, 70, "Text",
 CellID->12589],
Cell[8945, 339, 116, 3, 70, "MathCaption",
 CellID->17524],
Cell[CellGroupData[{
Cell[9086, 346, 145, 5, 70, "Input",
 CellID->7976],
Cell[9234, 353, 156, 5, 36, "Output",
 CellID->9694]
}, Open  ]],
Cell[9405, 361, 91, 1, 70, "MathCaption",
 CellID->4090],
Cell[CellGroupData[{
Cell[9521, 366, 112, 4, 70, "Input",
 CellID->20189],
Cell[9636, 372, 203, 7, 36, "Output",
 CellID->29372]
}, Open  ]],
Cell[9854, 382, 1014, 31, 70, "DefinitionBox",
 CellID->7419],
Cell[10871, 415, 77, 1, 70, "Caption",
 CellID->30301],
Cell[10951, 418, 718, 24, 70, "Text",
 CellID->21702],
Cell[11672, 444, 157, 5, 70, "MathCaption",
 CellID->24844],
Cell[CellGroupData[{
Cell[11854, 453, 100, 3, 70, "Input",
 CellID->20523],
Cell[11957, 458, 157, 5, 36, "Output",
 CellID->26539]
}, Open  ]],
Cell[12129, 466, 240, 8, 70, "MathCaption",
 CellID->20609],
Cell[CellGroupData[{
Cell[12394, 478, 225, 7, 70, "Input",
 CellID->11827],
Cell[12622, 487, 217, 7, 36, "Output",
 CellID->6637]
}, Open  ]],
Cell[12854, 497, 266, 9, 70, "MathCaption",
 CellID->8186],
Cell[CellGroupData[{
Cell[13145, 510, 159, 5, 70, "Input",
 CellID->27416],
Cell[13307, 517, 221, 7, 36, "Output",
 CellID->1827]
}, Open  ]],
Cell[13543, 527, 430, 16, 70, "Text",
 CellID->15169],
Cell[13976, 545, 198, 8, 70, "MathCaption",
 CellID->17623],
Cell[CellGroupData[{
Cell[14199, 557, 196, 7, 70, "Input",
 CellID->14899],
Cell[14398, 566, 205, 7, 36, "Output",
 CellID->22514]
}, Open  ]],
Cell[14618, 576, 78, 1, 70, "MathCaption",
 CellID->10415],
Cell[CellGroupData[{
Cell[14721, 581, 85, 3, 70, "Input",
 CellID->3644],
Cell[14809, 586, 41, 1, 70, "Print",
 CellID->5436]
}, Open  ]],
Cell[14865, 590, 720, 17, 70, "Text",
 CellID->23669],
Cell[15588, 609, 151, 5, 70, "MathCaption",
 CellID->10378],
Cell[CellGroupData[{
Cell[15764, 618, 180, 6, 70, "Input",
 CellID->31676],
Cell[15947, 626, 46, 1, 70, "Print",
 CellID->17858]
}, Open  ]],
Cell[16008, 630, 151, 4, 70, "MathCaption",
 CellID->7952],
Cell[CellGroupData[{
Cell[16184, 638, 85, 3, 70, "Input",
 CellID->9846],
Cell[16272, 643, 42, 1, 70, "Print",
 CellID->27137]
}, Open  ]],
Cell[16329, 647, 517, 16, 70, "Text",
 CellID->5915],
Cell[16849, 665, 589, 17, 70, "Text",
 CellID->22988],
Cell[17441, 684, 232, 5, 70, "Text",
 CellID->24616],
Cell[17676, 691, 1173, 32, 70, "Text",
 CellID->7288],
Cell[18852, 725, 1071, 33, 70, "DefinitionBox",
 CellID->2382],
Cell[19926, 760, 117, 3, 70, "Caption",
 CellID->28074],
Cell[20046, 765, 1057, 30, 70, "Text",
 CellID->20333],
Cell[21106, 797, 676, 22, 70, "Text",
 CellID->3915],
Cell[21785, 821, 417, 12, 70, "Text",
 CellID->11056],
Cell[22205, 835, 189, 6, 70, "MathCaption",
 CellID->25656],
Cell[CellGroupData[{
Cell[22419, 845, 274, 10, 70, "Input",
 CellID->30062],
Cell[22696, 857, 201, 7, 36, "Output",
 CellID->9616]
}, Open  ]],
Cell[22912, 867, 838, 28, 70, "Text",
 CellID->24524],
Cell[23753, 897, 441, 13, 70, "Text",
 CellID->12129],
Cell[24197, 912, 175, 5, 70, "MathCaption",
 CellID->27442],
Cell[CellGroupData[{
Cell[24397, 921, 310, 11, 70, "Input",
 CellID->1984],
Cell[24710, 934, 156, 5, 36, "Output",
 CellID->4872]
}, Open  ]],
Cell[CellGroupData[{
Cell[24903, 944, 70, 1, 70, "RelatedTutorialsSection",
 CellID->4588307],
Cell[24976, 947, 200, 5, 70, "RelatedTutorials",
 CellID->405226890],
Cell[25179, 954, 175, 4, 70, "RelatedTutorials",
 CellID->10046906]
}, Open  ]]
}, Open  ]],
Cell[25381, 962, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

