(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40065,       1525]
NotebookOptionsPosition[     30176,       1196]
NotebookOutlinePosition[     33554,       1276]
CellTagsIndexPosition[     33461,       1270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expand" :> Documentation`HelpLookup["paclet:ref/Expand"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Expand\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Immediate and Delayed Definitions", "Title",
 CellTags->{"S2.5.8", "8.1"},
 CellID->29979],

Cell[TextData[{
 "You may have noticed that there are two different ways to make assignments \
in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". The basic difference between these forms is ",
 StyleBox["when",
  FontSlant->"Italic"],
 " the expression ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " is evaluated. ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " is an ",
 StyleBox["immediate assignment",
  FontSlant->"Italic"],
 ", in which ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " is evaluated at the time when the assignment is made. ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ", on the other hand, is a ",
 StyleBox["delayed assignment",
  FontSlant->"Italic"],
 ", in which ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " is not evaluated when the assignment is made, but is instead evaluated \
each time the value of ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " is requested. "
}], "Text",
 CellID->7299],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["lhs", "TI"], "=", 
     StyleBox["rhs", "TI"], Cell[" (immediate assignment)", "TableText"]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     StyleBox["rhs", "TI"],
     " is evaluated when the assignment is made"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":=", 
     StyleBox["rhs", "TI"], Cell[" (delayed assignment)", "TableText"]}], 
    Cell[TextData[{
     StyleBox["rhs", "TI"],
     " is evaluated each time the value of ",
     StyleBox["lhs", "TI"],
     " is requested"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12322],

Cell[TextData[{
 "The two types of assignments in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->22902],

Cell[TextData[{
 "This uses the ",
 Cell[BoxData[":="], "InlineFormula"],
 " operator to define the function ",
 Cell[BoxData["ex"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27602],

Cell[BoxData[
 RowBox[{
  RowBox[{"ex", "[", "x_", "]"}], ":=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->6369],

Cell[TextData[{
 "Because ",
 Cell[BoxData[":="], "InlineFormula"],
 " was used, the definition is maintained in an unevaluated form. "
}], "MathCaption",
 CellID->30654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ex"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->12729],

Cell[CellGroupData[{

Cell[BoxData["\<\"Global`ex\"\>"], "Print",
 CellID->9734],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"ex", "[", "x_", "]"}], ":=", 
         RowBox[{"Expand", "[", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "x"}], ")"}], "2"], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[ex],
  Editable->False]], "Print",
 CellID->12438]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "When you make an assignment with the ",
 Cell[BoxData["="], "InlineFormula"],
 " operator, the right\[Hyphen]hand side is evaluated immediately. "
}], "MathCaption",
 CellID->12274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"iex", "[", "x_", "]"}], "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], "]"}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->5226],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->16463]
}, Open  ]],

Cell[TextData[{
 "The definition now stored is the result of the ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " command. "
}], "MathCaption",
 CellID->28134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "iex"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->22972],

Cell[CellGroupData[{

Cell[BoxData["\<\"Global`iex\"\>"], "Print",
 CellID->24348],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"iex", "[", "x_", "]"}], "=", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "x"}], "+", 
          SuperscriptBox["x", "2"]}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[iex],
  Editable->False]], "Print",
 CellID->16453]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "When you execute ",
 Cell[BoxData["ex"], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " is performed. "
}], "MathCaption",
 CellID->9503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ex", "[", 
  RowBox[{"y", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->2307],

Cell[BoxData[
 RowBox[{"9", "+", 
  RowBox[{"6", " ", "y"}], "+", 
  SuperscriptBox["y", "2"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->25518]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["iex"], "InlineFormula"],
 " simply substitutes its argument into the already expanded form, giving a \
different answer. "
}], "MathCaption",
 CellID->18333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"iex", "[", 
  RowBox[{"y", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->27437],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "y"}], ")"}]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", "y"}], ")"}], "2"]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->20695]
}, Open  ]],

Cell[TextData[{
 "As you can see from the example above, both ",
 Cell[BoxData["="], "InlineFormula"],
 " and ",
 Cell[BoxData[":="], "InlineFormula"],
 " can be useful in defining functions, but they have different meanings, and \
you must be careful about which one to use in a particular case. "
}], "Text",
 CellID->13179],

Cell[TextData[{
 "One rule of thumb is the following. If you think of an assignment as giving \
the final \[OpenCurlyDoubleQuote]value\[CloseCurlyDoubleQuote] of an \
expression, use the ",
 Cell[BoxData["="], "InlineFormula"],
 " operator. If instead you think of the assignment as specifying a \
\[OpenCurlyDoubleQuote]command\[CloseCurlyDoubleQuote] for finding the value, \
use the ",
 Cell[BoxData[":="], "InlineFormula"],
 " operator. If in doubt, it is usually better to use the ",
 Cell[BoxData[":="], "InlineFormula"],
 " operator than the ",
 Cell[BoxData["="], "InlineFormula"],
 " one. "
}], "Text",
 CellID->661],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["lhs", "TI"], "=", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     StyleBox["rhs", "TI"],
     " is intended to be the \[OpenCurlyDoubleQuote]final value\
\[CloseCurlyDoubleQuote] of ",
     StyleBox["lhs", "TI"],
     " (e.g., ",
     "f",
     "[",
     "x_",
     "]",
     "=",
     "1",
     "-",
     "x",
     "^",
     "2",
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":=", 
     StyleBox["rhs", "TI"]}], 
    RowBox[{
     StyleBox["rhs", "TI"], Cell["\<\
 gives a \[OpenCurlyDoubleQuote]command\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]program\[CloseCurlyDoubleQuote] to be executed \
whenever you ask for the value of \
\>", "TableText"], 
     StyleBox["lhs", "TI"], Cell[" (e.g., ", "TableText"], "f", "[", "x_", 
     "]", ":=", 
     ButtonBox["Expand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expand"], "[", "1", "-", "x", "^", "2", "]", 
     Cell[")", "TableText"]}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23144],

Cell[TextData[{
 "Interpretations of assignments with the ",
 StyleBox["=", "MR"],
 " and ",
 StyleBox[":=", "MR"],
 " operators. "
}], "Caption",
 CellID->17659],

Cell[TextData[{
 "Although ",
 Cell[BoxData[":="], "InlineFormula"],
 " is probably used more often than ",
 Cell[BoxData["="], "InlineFormula"],
 " in defining functions, there is one important case in which you must use \
",
 Cell[BoxData["="], "InlineFormula"],
 " to define a function. If you do a calculation, and get an answer in terms \
of a symbolic parameter ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", you often want to go on and find results for various specific values of \
",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". One way to do this is to use the ",
 Cell[BoxData["/."], "InlineFormula"],
 " operator to apply appropriate rules for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " in each case. It is usually more convenient however, to use ",
 Cell[BoxData["="], "InlineFormula"],
 " to define a function whose argument is ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->10961],

Cell[TextData[{
 "Here is an expression involving ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}], "^", "2"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->6576],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cot", "[", "x", "]"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}]}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->13472]
}, Open  ]],

Cell[TextData[{
 "This defines a function whose argument is the value to be taken for\
\[NonBreakingSpace]",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"dlog", "[", "x_", "]"}], "=", "%"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->3592],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cot", "[", "x", "]"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}]}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->628]
}, Open  ]],

Cell[TextData[{
 "Here is the result when ",
 Cell[BoxData["x"], "InlineFormula"],
 " is taken to be ",
 Cell[BoxData[
  RowBox[{"1", "+", "a"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dlog", "[", 
  RowBox[{"1", "+", "a"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->6811],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cot", "[", 
   RowBox[{"1", "+", "a"}], "]"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{"Sin", "[", 
    RowBox[{"1", "+", "a"}], "]"}], "]"}]}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->15535]
}, Open  ]],

Cell[TextData[{
 "An important point to notice in the example above is that there is nothing \
special about the name ",
 Cell[BoxData["x"], "InlineFormula"],
 " that appears in the ",
 Cell[BoxData["x_"], "InlineFormula"],
 " pattern. It is just a symbol, indistinguishable from an ",
 Cell[BoxData["x"], "InlineFormula"],
 " that appears in any other expression. "
}], "Text",
 CellID->15835],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["x", "TI"], 
     StyleBox["_", "MR"], "]", "=", 
     StyleBox["expr", "TI"]}], Cell[TextData[{
     "define a function which gives the value ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " for any particular value of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1229],

Cell["Defining functions for evaluating expressions. ", "Caption",
 CellID->3716],

Cell[TextData[{
 "You can use ",
 Cell[BoxData["="], "InlineFormula"],
 " and ",
 Cell[BoxData[":="], "InlineFormula"],
 " not only to define functions, but also to assign values to variables. If \
you type ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  StyleBox["value", "TI"]], "InlineFormula"],
 " is immediately evaluated, and the result is assigned to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". On the other hand, if you type ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ":=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  StyleBox["value", "TI"]], "InlineFormula"],
 " is not immediately evaluated. Instead, it is maintained in an unevaluated \
form, and is evaluated afresh each time ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is used. "
}], "Text",
 CellID->23532],

Cell[TextData[{
 "This evaluates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"], "[", "]"}]], "InlineFormula"],
 " to find a pseudorandom number, then assigns this number to ",
 Cell[BoxData["r1"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24956],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r1", "=", 
  RowBox[{"RandomReal", "[", "]"}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->16158],

Cell[BoxData["0.056070794834861534`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->29749]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"], "[", "]"}]], "InlineFormula"],
 " is maintained in an unevaluated form, to be evaluated afresh each time ",
 Cell[BoxData["r2"], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->24620],

Cell[BoxData[
 RowBox[{"r2", ":=", 
  RowBox[{"RandomReal", "[", "]"}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->23296],

Cell[TextData[{
 "Here are values for ",
 Cell[BoxData["r1"], "InlineFormula"],
 " and ",
 Cell[BoxData["r2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->19724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r1", ",", "r2"}], "}"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->13120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.056070794834861534`", ",", "0.630299795779359`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->24526]
}, Open  ]],

Cell[TextData[{
 "The value of ",
 Cell[BoxData["r1"], "InlineFormula"],
 " never changes. Every time ",
 Cell[BoxData["r2"], "InlineFormula"],
 " is used, however, a new pseudorandom number is generated. "
}], "MathCaption",
 CellID->16406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r1", ",", "r2"}], "}"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->8983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.056070794834861534`", ",", "0.3598942942214413`"}], 
  "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->3445]
}, Open  ]],

Cell["\<\
The distinction between immediate and delayed assignments is particularly \
important when you set up chains of assignments. \
\>", "Text",
 CellID->30574],

Cell[TextData[{
 "This defines ",
 Cell[BoxData["a"], "InlineFormula"],
 " to be ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", "1"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->26588],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->30538]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  RowBox[{"a", "+", "2"}]], "InlineFormula"],
 " is evaluated to give ",
 Cell[BoxData["3"], "InlineFormula"],
 ", and the result is assigned to be the value of\[NonBreakingSpace]",
 Cell[BoxData["ri"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ri", "=", 
  RowBox[{"a", "+", "2"}]}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->18104],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->20877]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  RowBox[{"a", "+", "2"}]], "InlineFormula"],
 " is maintained in an unevaluated form, to be evaluated every time the value \
of ",
 Cell[BoxData["rd"], "InlineFormula"],
 " is requested. "
}], "MathCaption",
 CellID->20353],

Cell[BoxData[
 RowBox[{"rd", ":=", 
  RowBox[{"a", "+", "2"}]}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->2942],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData["ri"], "InlineFormula"],
 " and ",
 Cell[BoxData["rd"], "InlineFormula"],
 " give the same values. "
}], "MathCaption",
 CellID->17004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ri", ",", "rd"}], "}"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->30623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->14852]
}, Open  ]],

Cell[TextData[{
 "Now the value of ",
 Cell[BoxData["a"], "InlineFormula"],
 " is changed. "
}], "MathCaption",
 CellID->15625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", "2"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->17611],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->27842]
}, Open  ]],

Cell[TextData[{
 "Now ",
 Cell[BoxData["rd"], "InlineFormula"],
 " uses the new value for ",
 Cell[BoxData["a"], "InlineFormula"],
 ", while ",
 Cell[BoxData["ri"], "InlineFormula"],
 " keeps its original value. "
}], "MathCaption",
 CellID->8724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ri", ",", "rd"}], "}"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->31149],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->20135]
}, Open  ]],

Cell[TextData[{
 "You can use delayed assignments such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["t", "TI"], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " to set up variables whose values you can find in a variety of different \
\[OpenCurlyDoubleQuote]environments\[CloseCurlyDoubleQuote]. Every time you \
ask for ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ", the expression ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " is evaluated using the current values of the objects on which it depends. \
"
}], "Text",
 CellID->13590],

Cell["\<\
The right\[Hyphen]hand side of the delayed assignment is maintained in an \
unevaluated form. \
\>", "MathCaption",
 CellID->10146],

Cell[BoxData[
 RowBox[{"t", ":=", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{"x", "^", "a"}], "-", "1"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->7328],

Cell[TextData[{
 "This sets ",
 Cell[BoxData["a"], "InlineFormula"],
 " to ",
 Cell[BoxData["4"], "InlineFormula"],
 ", then finds the value of\[NonBreakingSpace]",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "4"}], ";", "t"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->27804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{178, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->31741]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData["a"], "InlineFormula"],
 " is 6. "
}], "MathCaption",
 CellID->16909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "6"}], ";", "t"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->19381],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{266, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->12779]
}, Open  ]],

Cell[TextData[{
 "In the example above, the symbol ",
 Cell[BoxData["a"], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]global variable\[CloseCurlyDoubleQuote], \
whose value affects the value of ",
 Cell[BoxData["t"], "InlineFormula"],
 ". When you have a large number of parameters, many of which change only \
occasionally, you may find this kind of setup convenient. However, you should \
realize that implicit or hidden dependence of one variable on others can \
often become quite confusing. When possible, you should make all dependencies \
explicit, by defining functions which take all necessary parameters as \
arguments. "
}], "Text",
 CellID->29102],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     StyleBox["rhs", "TI"],
     " is evaluated when the rule is given"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["lhs", "TI"], ":>", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     StyleBox["rhs", "TI"],
     " is evaluated when the rule is used"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10083],

Cell[TextData[{
 "Two types of transformation rules in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->692],

Cell[TextData[{
 "Just as you can make immediate and delayed assignments in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", so you can also set up immediate and delayed transformation rules. "
}], "Text",
 CellID->10532],

Cell["\<\
The right\[Hyphen]hand side of this rule is evaluated when you give the rule. \
\
\>", "MathCaption",
 CellID->17312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "->", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], "]"}]}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->26099],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "\[Rule]", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->6161]
}, Open  ]],

Cell["A rule like this is probably not particularly useful. ", "MathCaption",
 CellID->11047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "->", 
  RowBox[{"Expand", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->22405],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "\[Rule]", "x"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]= ",
 CellID->15290]
}, Open  ]],

Cell["\<\
Here the right\[Hyphen]hand side of the rule is maintained in an unevaluated \
form, to be evaluated every time the rule is used. \
\>", "MathCaption",
 CellID->17569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":>", 
  RowBox[{"Expand", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->29959],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "\[RuleDelayed]", 
  RowBox[{"Expand", "[", "x", "]"}]}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->32628]
}, Open  ]],

Cell["Applying the rule causes the expansion to be done. ", "MathCaption",
 CellID->22139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "p"}], ")"}], "^", "2"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":>", 
   RowBox[{"Expand", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->21228],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "p"}], "+", 
  SuperscriptBox["p", "2"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->27580]
}, Open  ]],

Cell[TextData[{
 "In analogy with assignments, you should typically use ",
 Cell[BoxData["->"], "InlineFormula"],
 " when you want to replace an expression with a definite value, and you \
should use ",
 Cell[BoxData[":>"], "InlineFormula"],
 " when you want to give a command for finding the value. "
}], "Text",
 CellID->32471],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->285764164],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Immediate and Delayed Definitions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/TheOrderingOfDefinitions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/FunctionsThatRememberValuesTheyHaveFound"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 3.1608410}", "context" -> "", 
    "keywords" -> {
     "=.", ":>", "->", ":=", "=", "assignments", "chains of assignments", 
      "current values", "definitions", "delayed definitions", "delayed rules",
       "dependencies", "environments", "evaluation", "functions", 
      "global variables", "immediate definitions", "lazy evaluation", 
      "delayed assignment", "replacements", "rule", "RuleDelayed", "rules", 
      "set", "SetDelayed", "values"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "You may have noticed that there are two different ways to make \
assignments in Mathematica: lhs=rhs and lhs:=rhs. The basic difference \
between these forms is when the expression rhs is evaluated. lhs=rhs is an \
immediate assignment, in which rhs is evaluated at the time when the \
assignment is made. lhs:=rhs, on the other hand, is a delayed assignment, in \
which rhs is not evaluated when the assignment is made, but is instead \
evaluated each time the value of lhs is requested. The two types of \
assignments in Mathematica. This uses the := operator to define the function \
ex. ", "synonyms" -> {"2.5.8"}, "title" -> 
    "Immediate and Delayed Definitions", "type" -> "Tutorial", "uri" -> 
    "tutorial/ImmediateAndDelayedDefinitions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.8"->{
  Cell[1849, 59, 96, 2, 70, "Title",
   CellTags->{"S2.5.8", "8.1"},
   CellID->29979]},
 "8.1"->{
  Cell[1849, 59, 96, 2, 70, "Title",
   CellTags->{"S2.5.8", "8.1"},
   CellID->29979]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.8", 33250, 1259},
 {"8.1", 33349, 1263}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1224, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1849, 59, 96, 2, 70, "Title",
 CellTags->{"S2.5.8", "8.1"},
 CellID->29979],
Cell[1948, 63, 1355, 49, 70, "Text",
 CellID->7299],
Cell[3306, 114, 1055, 31, 70, "DefinitionBox",
 CellID->12322],
Cell[4364, 147, 138, 6, 70, "Caption",
 CellID->22902],
Cell[4505, 155, 191, 7, 70, "MathCaption",
 CellID->27602],
Cell[4699, 164, 227, 8, 70, "Input",
 CellID->6369],
Cell[4929, 174, 170, 5, 70, "MathCaption",
 CellID->30654],
Cell[CellGroupData[{
Cell[5124, 183, 85, 3, 70, "Input",
 CellID->12729],
Cell[CellGroupData[{
Cell[5234, 190, 58, 1, 70, "Print",
 CellID->9734],
Cell[5295, 193, 842, 25, 70, "Print",
 CellID->12438]
}, Open  ]]
}, Open  ]],
Cell[6164, 222, 199, 5, 70, "MathCaption",
 CellID->12274],
Cell[CellGroupData[{
Cell[6388, 231, 227, 8, 70, "Input",
 CellID->5226],
Cell[6618, 241, 234, 8, 36, "Output",
 CellID->16463]
}, Open  ]],
Cell[6867, 252, 231, 8, 70, "MathCaption",
 CellID->28134],
Cell[CellGroupData[{
Cell[7123, 264, 86, 3, 70, "Input",
 CellID->22972],
Cell[CellGroupData[{
Cell[7234, 271, 60, 1, 70, "Print",
 CellID->24348],
Cell[7297, 274, 809, 24, 70, "Print",
 CellID->16453]
}, Open  ]]
}, Open  ]],
Cell[8133, 302, 255, 10, 70, "MathCaption",
 CellID->9503],
Cell[CellGroupData[{
Cell[8413, 316, 117, 4, 70, "Input",
 CellID->2307],
Cell[8533, 322, 234, 8, 36, "Output",
 CellID->25518]
}, Open  ]],
Cell[8782, 333, 188, 5, 70, "MathCaption",
 CellID->18333],
Cell[CellGroupData[{
Cell[8995, 342, 119, 4, 70, "Input",
 CellID->27437],
Cell[9117, 348, 333, 12, 36, "Output",
 CellID->20695]
}, Open  ]],
Cell[9465, 363, 326, 8, 70, "Text",
 CellID->13179],
Cell[9794, 373, 625, 15, 70, "Text",
 CellID->661],
Cell[10422, 390, 1318, 46, 70, "DefinitionBox",
 CellID->23144],
Cell[11743, 438, 162, 7, 70, "Caption",
 CellID->17659],
Cell[11908, 447, 1015, 28, 70, "Text",
 CellID->10961],
Cell[12926, 477, 131, 5, 70, "MathCaption",
 CellID->21907],
Cell[CellGroupData[{
Cell[13082, 486, 208, 8, 70, "Input",
 CellID->6576],
Cell[13293, 496, 279, 9, 36, "Output",
 CellID->13472]
}, Open  ]],
Cell[13587, 508, 187, 6, 70, "MathCaption",
 CellID->20645],
Cell[CellGroupData[{
Cell[13799, 518, 120, 4, 70, "Input",
 CellID->3592],
Cell[13922, 524, 277, 9, 36, "Output",
 CellID->628]
}, Open  ]],
Cell[14214, 536, 205, 8, 70, "MathCaption",
 CellID->24196],
Cell[CellGroupData[{
Cell[14444, 548, 119, 4, 70, "Input",
 CellID->6811],
Cell[14566, 554, 328, 11, 36, "Output",
 CellID->15535]
}, Open  ]],
Cell[14909, 568, 394, 10, 70, "Text",
 CellID->15835],
Cell[15306, 580, 749, 22, 70, "DefinitionBox",
 CellID->1229],
Cell[16058, 604, 81, 1, 70, "Caption",
 CellID->3716],
Cell[16142, 607, 958, 31, 70, "Text",
 CellID->23532],
Cell[17103, 640, 329, 11, 70, "MathCaption",
 CellID->24956],
Cell[CellGroupData[{
Cell[17457, 655, 123, 4, 70, "Input",
 CellID->16158],
Cell[17583, 661, 176, 5, 36, "Output",
 CellID->29749]
}, Open  ]],
Cell[17774, 669, 339, 11, 70, "MathCaption",
 CellID->24620],
Cell[18116, 682, 124, 4, 70, "Input",
 CellID->23296],
Cell[18243, 688, 169, 7, 70, "MathCaption",
 CellID->19724],
Cell[CellGroupData[{
Cell[18437, 699, 115, 4, 70, "Input",
 CellID->13120],
Cell[18555, 705, 242, 8, 36, "Output",
 CellID->24526]
}, Open  ]],
Cell[18812, 716, 241, 7, 70, "MathCaption",
 CellID->16406],
Cell[CellGroupData[{
Cell[19078, 727, 114, 4, 70, "Input",
 CellID->8983],
Cell[19195, 733, 242, 8, 36, "Output",
 CellID->3445]
}, Open  ]],
Cell[19452, 744, 165, 4, 70, "Text",
 CellID->30574],
Cell[19620, 750, 162, 7, 70, "MathCaption",
 CellID->21691],
Cell[CellGroupData[{
Cell[19807, 761, 90, 3, 70, "Input",
 CellID->26588],
Cell[19900, 766, 156, 5, 36, "Output",
 CellID->30538]
}, Open  ]],
Cell[20071, 774, 302, 10, 70, "MathCaption",
 CellID->20664],
Cell[CellGroupData[{
Cell[20398, 788, 114, 4, 70, "Input",
 CellID->18104],
Cell[20515, 794, 156, 5, 36, "Output",
 CellID->20877]
}, Open  ]],
Cell[20686, 802, 265, 9, 70, "MathCaption",
 CellID->20353],
Cell[20954, 813, 114, 4, 70, "Input",
 CellID->2942],
Cell[21071, 819, 184, 7, 70, "MathCaption",
 CellID->17004],
Cell[CellGroupData[{
Cell[21280, 830, 115, 4, 70, "Input",
 CellID->30623],
Cell[21398, 836, 201, 7, 36, "Output",
 CellID->14852]
}, Open  ]],
Cell[21614, 846, 127, 5, 70, "MathCaption",
 CellID->15625],
Cell[CellGroupData[{
Cell[21766, 855, 90, 3, 70, "Input",
 CellID->17611],
Cell[21859, 860, 156, 5, 36, "Output",
 CellID->27842]
}, Open  ]],
Cell[22030, 868, 247, 9, 70, "MathCaption",
 CellID->8724],
Cell[CellGroupData[{
Cell[22302, 881, 115, 4, 70, "Input",
 CellID->31149],
Cell[22420, 887, 201, 7, 36, "Output",
 CellID->20135]
}, Open  ]],
Cell[22636, 897, 584, 17, 70, "Text",
 CellID->13590],
Cell[23223, 916, 141, 4, 70, "MathCaption",
 CellID->10146],
Cell[23367, 922, 225, 8, 70, "Input",
 CellID->7328],
Cell[23595, 932, 243, 9, 70, "MathCaption",
 CellID->23855],
Cell[CellGroupData[{
Cell[23863, 945, 113, 4, 70, "Input",
 CellID->27804],
Cell[23979, 951, 439, 16, 39, "Output",
 CellID->31741]
}, Open  ]],
Cell[24433, 970, 109, 5, 70, "MathCaption",
 CellID->16909],
Cell[CellGroupData[{
Cell[24567, 979, 113, 4, 70, "Input",
 CellID->19381],
Cell[24683, 985, 548, 19, 39, "Output",
 CellID->12779]
}, Open  ]],
Cell[25246, 1007, 669, 13, 70, "Text",
 CellID->29102],
Cell[25918, 1022, 722, 23, 70, "DefinitionBox",
 CellID->10083],
Cell[26643, 1047, 141, 6, 70, "Caption",
 CellID->692],
Cell[26787, 1055, 228, 6, 70, "Text",
 CellID->10532],
Cell[27018, 1063, 127, 4, 70, "MathCaption",
 CellID->17312],
Cell[CellGroupData[{
Cell[27170, 1071, 228, 8, 70, "Input",
 CellID->26099],
Cell[27401, 1081, 295, 10, 36, "Output",
 CellID->6161]
}, Open  ]],
Cell[27711, 1094, 93, 1, 70, "MathCaption",
 CellID->11047],
Cell[CellGroupData[{
Cell[27829, 1099, 153, 5, 70, "Input",
 CellID->22405],
Cell[27985, 1106, 213, 7, 36, "Output",
 CellID->15290]
}, Open  ]],
Cell[28213, 1116, 177, 4, 70, "MathCaption",
 CellID->17569],
Cell[CellGroupData[{
Cell[28415, 1124, 153, 5, 70, "Input",
 CellID->29959],
Cell[28571, 1131, 254, 8, 36, "Output",
 CellID->32628]
}, Open  ]],
Cell[28840, 1142, 90, 1, 70, "MathCaption",
 CellID->22139],
Cell[CellGroupData[{
Cell[28955, 1147, 282, 10, 70, "Input",
 CellID->21228],
Cell[29240, 1159, 235, 8, 36, "Output",
 CellID->27580]
}, Open  ]],
Cell[29490, 1170, 329, 8, 70, "Text",
 CellID->32471],
Cell[CellGroupData[{
Cell[29844, 1182, 72, 1, 70, "RelatedTutorialsSection",
 CellID->285764164],
Cell[29919, 1185, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]]
}, Open  ]],
Cell[30149, 1194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

