(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    238933,       8323]
NotebookOptionsPosition[    222119,       7759]
NotebookOutlinePosition[    228594,       7947]
CellTagsIndexPosition[    227932,       7919]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Representation of Boxes\"\>"}, "\<\"related tutorials\"\
\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AngleBracket" :> 
          Documentation`HelpLookup["paclet:ref/AngleBracket"], "Blank" :> 
          Documentation`HelpLookup["paclet:ref/Blank"], "BlankNullSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankNullSequence"], 
          "BlankSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankSequence"], 
          "BracketingBar" :> 
          Documentation`HelpLookup["paclet:ref/BracketingBar"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"], 
          "DoubleBracketingBar" :> 
          Documentation`HelpLookup["paclet:ref/DoubleBracketingBar"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "FormBox" :> 
          Documentation`HelpLookup["paclet:ref/FormBox"], "FractionBox" :> 
          Documentation`HelpLookup["paclet:ref/FractionBox"], "List" :> 
          Documentation`HelpLookup["paclet:ref/List"], "Optional" :> 
          Documentation`HelpLookup["paclet:ref/Optional"], "Out" :> 
          Documentation`HelpLookup["paclet:ref/Out"], "OverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/OverscriptBox"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Pattern" :> 
          Documentation`HelpLookup["paclet:ref/Pattern"], "RowBox" :> 
          Documentation`HelpLookup["paclet:ref/RowBox"], "Slot" :> 
          Documentation`HelpLookup["paclet:ref/Slot"], "SlotSequence" :> 
          Documentation`HelpLookup["paclet:ref/SlotSequence"], "SqrtBox" :> 
          Documentation`HelpLookup["paclet:ref/SqrtBox"], "SubscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubscriptBox"], 
          "SubsuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubsuperscriptBox"], 
          "SuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SuperscriptBox"], 
          "UnderoverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderoverscriptBox"], 
          "UnderscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderscriptBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AngleBracket\"\>", 
       2->"\<\"Blank\"\>", 3->"\<\"BlankNullSequence\"\>", 
       4->"\<\"BlankSequence\"\>", 5->"\<\"BracketingBar\"\>", 
       6->"\<\"Ceiling\"\>", 7->"\<\"DoubleBracketingBar\"\>", 
       8->"\<\"Floor\"\>", 9->"\<\"FormBox\"\>", 10->"\<\"FractionBox\"\>", 
       11->"\<\"List\"\>", 12->"\<\"Optional\"\>", 13->"\<\"Out\"\>", 
       14->"\<\"OverscriptBox\"\>", 15->"\<\"Part\"\>", 16->"\<\"Pattern\"\>",
        17->"\<\"RowBox\"\>", 18->"\<\"Slot\"\>", 19->"\<\"SlotSequence\"\>", 
       20->"\<\"SqrtBox\"\>", 21->"\<\"SubscriptBox\"\>", 
       22->"\<\"SubsuperscriptBox\"\>", 23->"\<\"SuperscriptBox\"\>", 
       24->"\<\"UnderoverscriptBox\"\>", 
       25->"\<\"UnderscriptBox\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Input Syntax", "Title",
 CellID->1365697167],

Cell[CellGroupData[{

Cell["Entering Characters", "Section",
 CellTags->{"SA.2.1", "1.1"},
 CellID->29301],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Enter it directly (e.g. ",
     Cell[BoxData["+"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Enter it by full name (e.g. ",
     Cell[BoxData[
      RowBox[{"\[Backslash]", 
       RowBox[{"[", "Alpha", "]"}]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Enter it by alias (e.g. ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]a\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"],
     ") (notebook front end only)"
    }], "TableText"]},
   {Cell["\<\
\[FilledSmallSquare] Enter it by choosing from a palette (notebook front end \
only)\
\>", "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] Enter it by character code (e.g. ",
     Cell[BoxData[
      RowBox[{"\[Backslash]", 
       RowBox[{":", 
        RowBox[{"03", "b1"}]}]}]], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22363],

Cell["Typical ways to enter characters. ", "Caption",
 CellID->7721],

Cell[TextData[{
 "All printable ASCII characters can be entered directly. Those that are not \
alphanumeric are assigned explicit names in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", allowing them to be entered even on keyboards where they do not \
explicitly appear. "
}], "Text",
 CellID->3565],

Cell[BoxData[GridBox[{
   {GridBox[{
      {" ", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawSpace", "]"}]}]},
      {"!", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawExclamation", "]"}]}]},
      {"\"\<\>", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawDoubleQuote", "]"}]}]},
      {"#", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawNumberSign", "]"}]}]},
      {"$", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawDollar", "]"}]}]},
      {"%", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawPercent", "]"}]}]},
      {"&", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawAmpersand", "]"}]}]},
      {"'", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawQuote", "]"}]}]},
      {"(", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawLeftParenthesis", "]"}]}]},
      {")", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawRightParenthesis", "]"}]}]},
      {"*", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawStar", "]"}]}]},
      {"+", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawPlus", "]"}]}]},
      {",", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawComma", "]"}]}]},
      {"-", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawDash", "]"}]}]},
      {".", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawDot", "]"}]}]},
      {"/", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawSlash", "]"}]}]},
      {":", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawColon", "]"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {";", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawSemicolon", "]"}]}]},
      {"<", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawLess", "]"}]}]},
      {"=", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawEqual", "]"}]}]},
      {">", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawGreater", "]"}]}]},
      {"?", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawQuestion", "]"}]}]},
      {"@", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawAt", "]"}]}]},
      {"[", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawLeftBracket", "]"}]}]},
      {"\[Backslash]", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawBackslash", "]"}]}]},
      {"]", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawRightBracket", "]"}]}]},
      {"^", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawWedge", "]"}]}]},
      {"_", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawUnderscore", "]"}]}]},
      {"`", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawBackquote", "]"}]}]},
      {"{", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawLeftBrace", "]"}]}]},
      {"|", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawVerticalBar", "]"}]}]},
      {"}", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawRightBrace", "]"}]}]},
      {"~", 
       RowBox[{"\[Backslash]", 
        RowBox[{"[", "RawTilde", "]"}]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->17421],

Cell["\<\
Full names for non\[Hyphen]alphanumeric printable ASCII characters. \
\>", "Caption",
 CellID->23445],

Cell[TextData[{
 "All characters which are entered into the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel are interpreted according to the setting for the ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 " option for the stream from which they came. "
}], "Text",
 CellID->18610],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", "[", 
     StyleBox["Name", "TI"], "]"}], Cell[
    "a character with the specified full name", "TableText"]},
   {
    RowBox[{"\[Backslash]", 
     StyleBox[
      RowBox[{"nnn", " "}], "TI"]}], Cell[TextData[{
     "a character with octal code ",
     Cell[BoxData[
      StyleBox["nnn", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"\[Backslash]", 
     RowBox[{".", 
      StyleBox[
       RowBox[{"nn", " "}], "TI"]}]}], Cell[TextData[{
     "a character with hexadecimal code ",
     Cell[BoxData[
      StyleBox["nn", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"\[Backslash]", 
     RowBox[{":", 
      StyleBox[
       RowBox[{"nnnn", " "}], "TI"]}]}], Cell[TextData[{
     "a character with hexadecimal code ",
     Cell[BoxData[
      StyleBox["nnnn", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->16741],

Cell["Ways to enter characters. ", "Caption",
 CellID->15022],

Cell[TextData[{
 "Codes for characters can be generated using ",
 Cell[BoxData[
  ButtonBox["ToCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFormula"],
 ". The Unicode standard is followed, with various extensions. "
}], "Text",
 CellID->31812],

Cell[TextData[{
 "8\[Hyphen]bit characters have codes less than 256; 16\[Hyphen]bit \
characters have codes between 256 and 65535. Approximately 900 characters are \
assigned explicit names in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Other characters must be entered using their character codes. "
}], "Text",
 CellID->29151],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", "\[Backslash]"}], Cell[
    "single backslash (decimal code 92)", "TableText"]},
   {
    RowBox[{"\[Backslash]", "b"}], Cell[TextData[{
     "backspace or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["H", "KeyEvent"],
     " (decimal code 8)"
    }], "TableText"]},
   {
    RowBox[{"\[Backslash]", "t"}], Cell[TextData[{
     "tab or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["I", "KeyEvent"],
     " (decimal code 9)"
    }], "TableText"]},
   {
    RowBox[{"\[Backslash]", "n"}], Cell[TextData[{
     "newline or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["J", "KeyEvent"],
     " (decimal code 10; full name ",
     Cell[BoxData[
      RowBox[{"\[Backslash]", 
       RowBox[{"[", "NewLine", "]"}]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{"\[Backslash]", "f"}], Cell[TextData[{
     "form feed or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["L", "KeyEvent"],
     " (decimal code 12)"
    }], "TableText"]},
   {
    RowBox[{"\[Backslash]", "r"}], Cell[TextData[{
     "carriage return or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["M", "KeyEvent"],
     " (decimal code 13)"
    }], "TableText"]},
   {
    RowBox[{"\[Backslash]", "000"}], Cell["null byte (code 0)", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->23015],

Cell["\<\
Some special 8\[Hyphen]bit characters. \
\>", "Caption",
 CellID->8055]
}, Open  ]],

Cell[CellGroupData[{

Cell["Types of Input Syntax", "Section",
 CellTags->{"SA.2.2", "2.1"},
 CellID->24487],

Cell[TextData[{
 "The standard input syntax used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the one used by default in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". You can modify the syntax by making definitions for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MakeExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeExpression"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7030],

Cell["\<\
Options can be set to specify what form of input should be accepted by a \
particular cell in a notebook or from a particular stream. \
\>", "Text",
 CellID->22345],

Cell[TextData[{
 "The input syntax in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", for example, is different from that in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->22716],

Cell[TextData[{
 "In general, what input syntax does is to determine how a particular string \
or collection of boxes should be interpreted as an expression. When boxes are \
set up, say with the notebook front end, there can be hidden ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " objects which modify the interpretation of the boxes. "
}], "Text",
 CellID->28044]
}, Open  ]],

Cell[CellGroupData[{

Cell["Character Strings", "Section",
 CellTags->{"SA.2.3", "3.1"},
 CellID->1570],

Cell[BoxData[GridBox[{
   {Cell[TextData[Cell[BoxData["\"\<\!\(\*
StyleBox[\"characters\", \"TI\"]\)\>\""], "InlineFormula"]], "InlineFormula"],
     Cell["a character string", "TableText"]},
   {Cell[TextData[Cell[BoxData[
     RowBox[{"\[Backslash]", "\"\< \>"}]], "InlineFormula"]], "TableText"], 
    Cell[TextData[{
     "a literal ",
     Cell[BoxData["\"\<\>"], "InlineFormula"],
     " in a character string"
    }], "TableText"]},
   {Cell[TextData[Cell[BoxData[
     RowBox[{"\[Backslash]", "\[Backslash]"}]], "InlineFormula"]], 
     "TableText"], Cell[TextData[{
     "a literal ",
     Cell[BoxData["\[Backslash]"], "InlineFormula"],
     " in a character string"
    }], "TableText"]},
   {Cell[TextData[{
     Cell[BoxData["\[Backslash]"], "InlineFormula"],
     " (at end of line)"
    }], "TableText"], Cell["ignore the following newline", "TableText"]},
   {Cell[TextData[Cell[BoxData[
     RowBox[{"\[Backslash]", 
      RowBox[{"!", 
       RowBox[{"\[Backslash]", 
        RowBox[{"(", 
         RowBox[{
          StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]}]}]], 
     "InlineFormula"]], "TableText"], Cell["\<\
a substring representing two\[Hyphen]dimensional boxes\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->8636],

Cell["Entering character strings. ", "Caption",
 CellID->9458],

Cell["\<\
Character strings can contain any sequence of 8\[Hyphen] or 16\[Hyphen]bit \
characters. Characters entered by name or character code are stored the same \
as if they were entered directly. \
\>", "Text",
 CellID->25967],

Cell[TextData[{
 "In a notebook front end, text pasted into a string by default automatically \
has appropriate \[Backslash] characters inserted so that the string stored in \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reproduces the text that was pasted."
}], "Text",
 CellID->8456],

Cell[TextData[{
 "Within ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"!", 
    RowBox[{"\[Backslash]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]}]}]], 
  "InlineFormula"],
 " any box structures represented using backslash sequences can be used. "
}], "Text",
 CellID->11531],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
 " objects can be used to represent strings that contain symbolic constructs, \
such as pattern elements. "
}], "Text",
 CellID->29962]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbol Names and Contexts", "Section",
 CellTags->{"SA.2.4", "4.1"},
 CellID->6562],

Cell[BoxData[GridBox[{
   {
    StyleBox["name", "TI"], Cell["symbol name", "TableText"]},
   {
    RowBox[{
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"]}], Cell[
    "symbol name in current context", "TableText"]},
   {
    RowBox[{
     StyleBox["context", "TI"], 
     StyleBox["`", "MR"], 
     StyleBox["name", "TI"]}], Cell[
    "symbol name in specified context", "TableText"]},
   {
    StyleBox["context`", "TI"], Cell["context name", "TableText"]},
   {
    StyleBox["context1`context2`", "TI"], Cell[
    "compound context name", "TableText"]},
   {
    StyleBox["`context`", "TI"], Cell[
    "context relative to the current context", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3576],

Cell["Symbol names and contexts. ", "Caption",
 CellID->4854],

Cell[TextData[{
 "Symbol names and contexts can contain any characters that are treated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as letters or letter\[Hyphen]like forms. They can contain digits but \
cannot start with them. Contexts must end in a backquote ",
 Cell[BoxData["`"], "InlineFormula"],
 ". "
}], "Text",
 CellID->20072]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numbers", "Section",
 CellTags->{"SA.2.5", "5.1"},
 CellID->7977],

Cell[BoxData[GridBox[{
   {
    StyleBox["digits", "TI"], Cell["integer", "TableText"]},
   {
    RowBox[{
     StyleBox["digits", "TI"], ".", 
     StyleBox["digits", "TI"]}], Cell["approximate number", "TableText"]},
   {
    RowBox[{
     StyleBox["base", "TI"], "^", "^", 
     StyleBox["digits", "TI"]}], Cell[
    "integer in specified base", "TableText"]},
   {
    RowBox[{
     StyleBox["base", "TI"], "^", "^", 
     StyleBox["digits", "TI"], ".", 
     StyleBox["digits", "TI"]}], Cell[
    "approximate number in specified base", "TableText"]},
   {
    RowBox[{
     StyleBox["mantissa", "TI"], "*", "^", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "scientific notation (",
     Cell[BoxData[
      RowBox[{
       StyleBox["mantissa", "TI"], "\[Cross]", 
       SuperscriptBox["10", 
        StyleBox["n", "TI"]]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["base", "TI"], "^", "^", 
     StyleBox["mantissa", "TI"], "*", "^", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "scientific notation in specified base (",
     Cell[BoxData[
      RowBox[{
       StyleBox["mantissa", "TI"], "\[Cross]", 
       SuperscriptBox[
        StyleBox["base", "TI"], 
        StyleBox["n", "TI"]]}]], "InlineFormula"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["number", "TI"], 
     StyleBox["`", "MR"]}], Cell["\<\
machine\[Hyphen]precision approximate number\
\>", "TableText"]},
   {
    RowBox[{
     StyleBox["number", "TI"], 
     StyleBox["`", "MR"], 
     StyleBox["s", "TI"]}], Cell[TextData[{
     "arbitrary\[Hyphen]precision number with precision ",
     Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
        StyleBox["s", "TI"]], "InlineFormula"]], "InlineFormula"], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["number", "TI"], 
     StyleBox["``", "MR"], 
     StyleBox["s", "TI"]}], Cell[TextData[{
     "arbitrary\[Hyphen]precision number with accuracy ",
     Cell[BoxData[
      FormBox[Cell[TextData[Cell[BoxData[
        StyleBox["s", "TI"]], "InlineFormula"]], "InlineFormula"], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11457],

Cell["Input forms for numbers. ", "Caption",
 CellID->24385],

Cell[TextData[{
 "Numbers can be entered with the notation ",
 Cell[BoxData[
  RowBox[{
   StyleBox["base", "TI"], "^", 
   RowBox[{"^", 
    StyleBox["digits", "TI"]}]}]], "InlineFormula"],
 " in any base from ",
 Cell[BoxData["2"], "InlineFormula"],
 " to ",
 Cell[BoxData["36"], "InlineFormula"],
 ". The base itself is given in decimal. For bases larger than ",
 Cell[BoxData["10"], "InlineFormula"],
 ", additional digits are chosen from the letters ",
 Cell[BoxData["a"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["z"], "InlineFormula"],
 " or ",
 Cell[BoxData["A"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["Z"], "InlineFormula"],
 ". Upper\[Hyphen] and lower\[Hyphen]case letters are equivalent for these \
purposes. Floating\[Hyphen]point numbers can be specified by including ",
 Cell[BoxData["."], "InlineFormula"],
 " in the ",
 Cell[BoxData[
  StyleBox["digits", "TI"]], "InlineFormula"],
 " sequence."
}], "Text",
 CellID->19293],

Cell[TextData[{
 "In scientific notation, ",
 Cell[BoxData[
  StyleBox["mantissa", "TI"]], "InlineFormula"],
 " can contain ",
 Cell[BoxData["`"], "InlineFormula"],
 " marks. The exponent ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " must always be an integer, specified in decimal."
}], "Text",
 CellID->31716],

Cell[TextData[{
 "The precision or accuracy ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " can be any real number; it does not need to be an integer. "
}], "Text",
 CellID->19628],

Cell[TextData[{
 "In the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["base", "TI"], "^", 
   RowBox[{"^", 
    StyleBox[
     RowBox[{
      StyleBox["number", "TI"], "`", 
      StyleBox["s", "TI"]}]]}]}]], "InlineFormula"],
 " the precision ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " is given in decimal, but it gives the effective number of digits of \
precision in the specified base, not in base 10. "
}], "Text",
 CellID->12394],

Cell[TextData[{
 "An approximate number ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is taken to be machine precision if the number of digits given in it is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Ceiling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Ceiling"], "[", 
    ButtonBox["$MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MachinePrecision"], "]"}], "+", "1"}]], 
  "InlineFormula"],
 " or less. If more digits are given, then ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is taken to be an arbitrary\[Hyphen]precision number. The accuracy of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " is taken to be the number of digits that appear to the right of the \
decimal point, while its precision is taken to be ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    RowBox[{"10", ",", 
     RowBox[{
      ButtonBox["Abs",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Abs"], "[", 
      StyleBox["x", "TI"], "]"}]}], "]"}], "+", 
   RowBox[{
    ButtonBox["Accuracy",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Accuracy"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->19291],

Cell[TextData[{
 "A number entered in the form ",
 Cell[BoxData[
  RowBox[{"\<\"0``\"\>", 
   StyleBox["s", "TI"]}]], "InlineFormula",
  ShowStringCharacters->False],
 " is taken to have precision 0 and accuracy ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->3771]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bracketed Objects", "Section",
 CellTags->{"SA.2.6", "6.1"},
 CellID->30109],

Cell[TextData[{
 "Bracketed objects use explicit left and right delimiters to indicate their \
extent. They can appear anywhere within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input, and can be nested in any way. "
}], "Text",
 CellID->17984],

Cell[TextData[{
 "The delimiters in bracketed objects are ",
 StyleBox["matchfix operators",
  FontSlant->"Italic"],
 ". But since these delimiters explicitly enclose all operands, no precedence \
need be assigned to such operators. "
}], "Text",
 CellID->11969],

Cell[BoxData[GridBox[{
   {
    RowBox[{"(*", 
     StyleBox["any", "TI"], " ", 
     StyleBox["text", "TI"], "*)"}], Cell["comment", "TableText"]},
   {
    RowBox[{"(", 
     StyleBox["expr", "TI"], ")"}], Cell[
    "parenthesization: grouping of input", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28978],

Cell["\<\
Bracketed objects without comma\[Hyphen]separated elements. \
\>", "Caption",
 CellID->21617],

Cell["\<\
Comments can be nested, and can continue for any number of lines. They can \
contain any 8\[Hyphen] or 16\[Hyphen]bit characters.\
\>", "Text",
 CellID->4015],

Cell[TextData[{
 "Parentheses must enclose a single complete expression; neither ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    StyleBox["e", "TI"]}], ")"}]], "InlineFormula"],
 " nor ",
 Cell[BoxData[
  RowBox[{"(", ")"}]], "InlineFormula"],
 " are allowed. "
}], "Text",
 CellID->16626],

Cell[BoxData[GridBox[{
   {
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], 
    RowBox[{
     ButtonBox["List",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/List"], "[", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{"\[LeftAngleBracket]", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "\[RightAngleBracket]"}], 
    RowBox[{
     ButtonBox["AngleBracket",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AngleBracket"], "[", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{"\[LeftFloor]", 
     StyleBox["expr", "TI"], "\[RightFloor]"}], 
    RowBox[{
     ButtonBox["Floor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Floor"], "[", 
     StyleBox["expr", "TI"], "]"}]},
   {
    RowBox[{"\[LeftCeiling]", 
     StyleBox["expr", "TI"], "\[RightCeiling]"}], 
    RowBox[{
     ButtonBox["Ceiling",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Ceiling"], "[", 
     StyleBox["expr", "TI"], "]"}]},
   {
    RowBox[{"\[LeftBracketingBar]", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "\[RightBracketingBar]"}], 
    RowBox[{
     ButtonBox["BracketingBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BracketingBar"], "[", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{"\[LeftDoubleBracketingBar]", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "\[RightDoubleBracketingBar]"}], 
    RowBox[{
     ButtonBox["DoubleBracketingBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DoubleBracketingBar"], "[", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{"\[Backslash]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["input", "TI"], "\[Backslash]"}], ")"}]}], Cell[
    "input or grouping of boxes", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3684],

Cell["\<\
Bracketed objects that allow comma\[Hyphen]separated elements. \
\>", "Caption",
 CellID->9168],

Cell[TextData[{
 "The notation ",
 Cell[BoxData[
  StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
 " is used to stand for any sequence of expressions. "
}], "Text",
 CellID->17906],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " can include any number of elements, with successive elements separated by \
commas. "
}], "Text",
 CellID->25928],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["List",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/List"], "[", "]"}]], "InlineFormula"],
 ", a list with zero elements. "
}], "Text",
 CellID->12097],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "\[RightAngleBracket]"}]], 
  "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "LeftAngleBracket", "]"}]}], 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]]}], ",", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["2", "TR"]], ",", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], "\[Backslash]", 
    RowBox[{"[", "RightAngleBracket", "]"}]}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->28118],

Cell[TextData[{
 "The character ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", "InvisibleComma", "]"}]}]], "InlineFormula"],
 " can be used interchangeably with ordinary commas; the only difference is \
that ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", "InvisibleComma", "]"}]}]], "InlineFormula"],
 " will not be displayed. "
}], "Text",
 CellID->24390],

Cell[TextData[{
 "When the delimiters are special characters, it is a convention that they \
are named ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", 
    StyleBox[
     RowBox[{"Left", 
      StyleBox["Name", "TI"]}]], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", 
    StyleBox[
     RowBox[{"Right", 
      StyleBox["Name", "TI"]}]], "]"}]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15199],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 " is used to enter boxes using one\[Hyphen]dimensional strings. Note that \
within the outermost ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 " in a piece of input the syntax used is slightly different from outside, as \
described in\[NonBreakingSpace]\"",
 ButtonBox["Input of Boxes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#30487"],
 "\". "
}], "Text",
 CellID->11785],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["h", "TI"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "standard expression", "TableText"]},
   {
    RowBox[{
     StyleBox["e", "TI"], "[", "[", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]", "]"}], 
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      StyleBox["e", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}]},
   {
    RowBox[{
     StyleBox["e", "TI"], "\[LeftDoubleBracket]", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "\[RightDoubleBracket]"}], 
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      StyleBox["e", "TI"], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14486],

Cell["Bracketed objects with heads. ", "Caption",
 CellID->19199],

Cell["\<\
Bracketed objects with heads explicitly delimit all their operands except the \
head. A precedence must be assigned to define the extent of the head. \
\>", "Text",
 CellID->12420],

Cell[TextData[{
 "The precedence of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " is high enough that ",
 Cell[BoxData[
  RowBox[{"!", 
   RowBox[{
    StyleBox["h", "TI"], "[", 
    StyleBox["e", "TI"], "]"}]}]], "InlineFormula"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"], "[", 
   RowBox[{
    StyleBox["h", "TI"], "[", 
    StyleBox["e", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". However, ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["h", "TI"], "_", 
     StyleBox["s", "TI"]}]], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    StyleBox[
     RowBox[{
      StyleBox["h", "TI"], "_", 
      StyleBox["s", "TI"]}]], ")"}], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20710]
}, Open  ]],

Cell[CellGroupData[{

Cell["Operator Input Forms", "Section",
 CellTags->{"SA.2.7", "7.1"},
 CellID->23301],

Cell[TextData[{
 "Characters that are not letters, letter\[Hyphen]like forms or structural \
elements are treated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as ",
 StyleBox["operators",
  FontSlant->"Italic"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has built\[Hyphen]in rules for interpreting all operators. The functions \
to which these operators correspond may or may not, however, have built\
\[Hyphen]in evaluation or other rules. Cases in which built\[Hyphen]in \
meanings are by default defined are indicated by ",
 Cell[BoxData["\[LeftTriangle]"], "InlineFormula"],
 " in the tables below. "
}], "Text",
 CellID->24535],

Cell[TextData[{
 "Operators that construct two\[Hyphen]dimensional boxes\[LongDash]all of \
which have names beginning with backslash\[LongDash]can only be used inside \
",
 Cell[BoxData[
  RowBox[{"\\(", 
   StyleBox["\[Ellipsis]", "TR"], "\\)"}]], "InlineFormula"],
 ". The table below gives the interpretations of these operators within ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"!", 
    RowBox[{"\[Backslash]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]}]}]], 
  "InlineFormula"],
 ".\[NonBreakingSpace]\"",
 ButtonBox["Input of Boxes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#30487"],
 "\" gives interpretations when no ",
 Cell[BoxData["\\!"], "InlineFormula"],
 " is included. "
}], "Text",
 CellID->9502],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], Cell[" and ", "TableText"], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["i", "TI"]]}], Cell["any expression", "TableText"]},
   {
    StyleBox["symb", "TI"], Cell["any symbol", "TableText"]},
   {
    StyleBox["patt", "TI"], Cell["any pattern object", "TableText"]},
   {
    RowBox[{
     StyleBox["string", "TI"], Cell[" and ", "TableText"], 
     SubscriptBox[
      StyleBox["string", "TI"], 
      StyleBox["i", "TI"]]}], Cell[TextData[{
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"cccc\", \"TI\"]\)\>\""], "InlineFormula"],
     " or a sequence of letters, letter\[Hyphen]like forms and digits"
    }], "TableText"]},
   {
    StyleBox["filename", "TI"], Cell[TextData[{
     "like ",
     Cell[BoxData[
      StyleBox["string", "TI"]], "InlineFormula"],
     ", but can include additional characters described below"
    }], "TableText"]},
   {"\[LeftTriangle]", Cell["built\[Hyphen]in meanings exist", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.25], {
      Scaled[0.750000000000001]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->8963],

Cell["Objects used in the tables of operator input forms. ", "Caption",
 CellID->9564],

Cell[BoxData[GridBox[{
   {Cell["operator form", "TableHeader"], Cell["full form", "TableHeader"], 
    Cell["grouping", "TableHeader"], ""},
   {Cell[TextData[{
     "forms representing numbers (see\[NonBreakingSpace]\"",
     ButtonBox["Numbers",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/InputSyntax#7977"],
     "\")"
    }], "TableText"], "\[SpanFromLeft]", "\[SpanFromLeft]", 
    "\[LeftTriangle]"},
   {Cell[TextData[{
     "forms representing symbols (see\[NonBreakingSpace]\"",
     ButtonBox["Symbol Names and Contexts",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/InputSyntax#6562"],
     "\")"
    }], "TableText"], "\[SpanFromLeft]", "\[SpanFromLeft]", 
    "\[LeftTriangle]"},
   {Cell[TextData[{
     "forms representing character strings (see\[NonBreakingSpace]\"",
     ButtonBox["Character Strings",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/InputSyntax#1570"],
     "\")"
    }], "TableText"], "\[SpanFromLeft]", "\[SpanFromLeft]", 
    "\[LeftTriangle]"},
   {GridBox[{
      {
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["11", "TR"]], 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["12", "TR"]], 
       StyleBox["\[Ellipsis]", "TR"]},
      {
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["21", "TR"]], 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["22", "TR"]], 
       StyleBox["\[Ellipsis]", "TR"]},
      {
       StyleBox["\[Ellipsis]", "TR"], "", ""}
     },
     GridBoxDividers->{},
     GridBoxItemSize->{}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["12", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["21", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["22", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], "", "\[LeftTriangle]"},
   {
    RowBox[{"\[Piecewise]", GridBox[{
       {
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["11", "TR"]], 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["12", "TR"]]},
       {
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["21", "TR"]], 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["22", "TR"]]},
       {
        StyleBox["\[Ellipsis]", "TR"], ""}
      },
      GridBoxDividers->{},
      GridBoxItemSize->{}]}], 
    RowBox[{
     ButtonBox["Piecewise",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Piecewise"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["11", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["12", "TR"]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["21", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["22", "TR"]]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "::", 
     StyleBox["string", "TI"]}], 
    RowBox[{
     ButtonBox["MessageName",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MessageName"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "::", 
     SubscriptBox[
      StyleBox["string", "TI"], 
      StyleBox["1", "TR"]], "::", 
     SubscriptBox[
      StyleBox["string", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["MessageName",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MessageName"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"string\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"string\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "]"}], "", "\[LeftTriangle]"},
   {Cell[TextData[{
     "forms containing ",
     Cell[BoxData["#"], "InlineFormula"],
     " (see ",
     ButtonBox["Additional Input Forms",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/InputSyntax#6349"],
     ")"
    }], "TableText"], "\[SpanFromLeft]", "\[SpanFromLeft]", 
    "\[LeftTriangle]"},
   {Cell[TextData[{
     "forms containing ",
     Cell[BoxData["%"], "InlineFormula"],
     " (see ",
     ButtonBox["Additional Input Forms",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/InputSyntax#6349"],
     ")"
    }], "TableText"], "\[SpanFromLeft]", "\[SpanFromLeft]", 
    "\[LeftTriangle]"},
   {Cell[TextData[{
     "forms containing ",
     Cell[BoxData["_"], "InlineFormula"],
     " (see ",
     ButtonBox["Additional Input Forms",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/InputSyntax#6349"],
     ")"
    }], "TableText"], "\[SpanFromLeft]", "\[SpanFromLeft]", 
    "\[LeftTriangle]"},
   {
    RowBox[{"<<", 
     StyleBox["filename", "TI"]}], 
    RowBox[{
     ButtonBox["Get",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Get"], "[", "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", "]"}], "", "\[LeftTriangle]"},
   {
    OverscriptBox[
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]], 
    RowBox[{
     ButtonBox["Overscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Overscript"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    OverscriptBox[
     StyleBox["e", "TI"], 
     RowBox[{"(", 
      OverscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["e", "TI"]], ")"}]], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\&", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Overscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Overscript"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\\&", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\\&", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    UnderscriptBox[
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]], 
    RowBox[{
     ButtonBox["Underscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Underscript"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    UnderscriptBox[
     StyleBox["e", "TI"], 
     RowBox[{"(", 
      AdjustmentBox[
       UnderscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["e", "TI"]],
       BoxBaselineShift->-1], ")"}]], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\+", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Underscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Underscript"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\\+", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\\+", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    UnderoverscriptBox[
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]], 
    RowBox[{"UnderOverscript", "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], "", ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\+", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], "\\%", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}]}], 
    RowBox[{"UnderOverscript", "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], "", ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\&", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], "\\%", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}]}], 
    RowBox[{"UnderOverscript", "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], "", ""},
   {
    SubscriptBox[
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]], 
    RowBox[{
     ButtonBox["Subscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subscript"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    SubscriptBox[
     StyleBox["e", "TI"], 
     RowBox[{"(", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["e", "TI"]], ")"}]], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\_", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Subscript",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subscript"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\\_", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\\_", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\_", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], "\\%", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}]}], 
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Subscript",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subscript"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]]}], "]"}], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{"\\!", 
     StyleBox["boxes", "TI"]}], Cell[TextData[{
     "(interpreted version of ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"], "", ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "?", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["PatternTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PatternTest"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], " ", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], 
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "[", 
       StyleBox["e", "TI"], "]"}], ")"}], "[", 
     StyleBox["e", "TI"], "]"}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "[", 
     RowBox[{"[", 
      RowBox[{
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}], 
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "[", 
       RowBox[{"[", 
        StyleBox["e", "TI"], "]"}], "]"}], ")"}], "[", 
     RowBox[{"[", 
      StyleBox["e", "TI"], "]"}], "]"}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[LeftDoubleBracket]", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "\[RightDoubleBracket]"}], 
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[LeftDoubleBracket]", 
       StyleBox["e", "TI"], "\[RightDoubleBracket]"}], ")"}], 
     "\[LeftDoubleBracket]", 
     StyleBox["e", "TI"], "\[RightDoubleBracket]"}], "\[LeftTriangle]"},
   {
    SubscriptBox[
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], 
     RowBox[{"\[LeftDoubleBracket]", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], "\[RightDoubleBracket]"}]], 
    RowBox[{
     ButtonBox["Part",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Part"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       RowBox[{"\[LeftDoubleBracket]", 
        StyleBox["e", "TI"], "\[RightDoubleBracket]"}]], ")"}], 
     RowBox[{"\[LeftDoubleBracket]", 
      StyleBox["e", "TI"], "\[RightDoubleBracket]"}]], "\[LeftTriangle]"},
   {
    RowBox[{"\\*", 
     StyleBox["expr", "TI"]}], Cell[TextData[{
     "(boxes constructed from ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ")"
    }], "TableText"], "", ""},
   {
    RowBox[{
     StyleBox["expr", "TI"], "++"}], 
    RowBox[{
     ButtonBox["Increment",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Increment"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "--"}], 
    RowBox[{
     ButtonBox["Decrement",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Decrement"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{"++", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["PreIncrement",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PreIncrement"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{"--", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["PreDecrement",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PreDecrement"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "@", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "[", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "@", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "@", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], Cell[TextData[{
     "(invisible application, input as ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]@\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"],
     " ",
     Cell[BoxData[
      RowBox[{" ", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}]], "InlineFormula"],
     ")"
    }], "TableText"], "\[SpanFromLeft]", "\[LeftTriangle]"},
   {"", 
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "[", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "]"}], "", ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "~", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "~", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "~", 
       StyleBox["e", "TI"], "~", 
       StyleBox["e", "TI"]}], ")"}], "~", 
     StyleBox["e", "TI"], "~", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "/@", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Map",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Map"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "/@", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "/@", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "//@", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["MapAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapAll"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "//@", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "//@", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "@@", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Apply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Apply"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "@@", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "@@", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "@@@", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Apply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Apply"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "@@@", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "@@@", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "!"}], 
    RowBox[{
     ButtonBox["Factorial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factorial"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "!!"}], 
    RowBox[{
     ButtonBox["Factorial2",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factorial2"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "\[Conjugate]"}], 
    RowBox[{
     ButtonBox["Conjugate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Conjugate"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "\[Transpose]"}], 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "\[ConjugateTranspose]"}], 
    RowBox[{
     ButtonBox["ConjugateTranspose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "\[HermitianConjugate]"}], 
    RowBox[{
     ButtonBox["ConjugateTranspose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "'"}], 
    RowBox[{
     RowBox[{
      ButtonBox["Derivative",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Derivative"], "[", "1", "]"}], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], "''"}], 
     RowBox[{
      StyleBox["\[Ellipsis]", "TR"], "'"}], Cell[TextData[{
      " ",
      "(",
      Cell[BoxData[
       StyleBox["n", "TI"]], "InlineFormula"],
      " times)"
     }], "TableText"]}], 
    RowBox[{
     RowBox[{
      ButtonBox["Derivative",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Derivative"], "[", 
      StyleBox["n", "TI"], "]"}], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "<>", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "<>", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["StringJoin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringJoin"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "<>", 
     StyleBox["e", "TI"], "<>", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "^", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "^", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "^", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    SuperscriptBox[
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]], 
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    SuperscriptBox[
     StyleBox["e", "TI"], 
     RowBox[{"(", 
      SuperscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["e", "TI"]], ")"}]], "\[LeftTriangle]"},
   {
    SubsuperscriptBox[
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]], 
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Subscript",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subscript"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]]}], "]"}], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\^", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], "\\%", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}]}], 
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", 
     RowBox[{
      RowBox[{
       ButtonBox["Subscript",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subscript"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["3", "TR"]]}], "]"}], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], "", "\[LeftTriangle]"},
   {Cell["vertical arrow and vector operators", "TableText"], 
    "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {
    SqrtBox[
     StyleBox["expr", "TI"]], 
    RowBox[{
     ButtonBox["Sqrt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sqrt"], "[", 
     StyleBox["expr", "TI"], "]"}], 
    SqrtBox[
     RowBox[{"(", 
      SqrtBox[
       StyleBox["e", "TI"]], ")"}]], "\[LeftTriangle]"},
   {
    RowBox[{"\\@", " ", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Sqrt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sqrt"], "[", 
     StyleBox["expr", "TI"], "]"}], 
    RowBox[{"\\@", 
     RowBox[{"(", 
      RowBox[{"\\@", " ", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{"\\@", " ", 
     RowBox[{
      StyleBox["expr", "TI"], "\\%", 
      StyleBox["n", "TI"]}]}], 
    RowBox[{
     ButtonBox["Power",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Power"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"1", "/", 
       StyleBox["n", "TI"]}]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{"\[Integral]", " ", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], 
      RowBox[{"\[DifferentialD]", " ", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}]}]}], 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{"\[Integral]", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Integral]", " ", 
        RowBox[{
         StyleBox["e", "TI"], 
         RowBox[{"\[DifferentialD]", " ", 
          StyleBox["e", "TI"]}]}]}], ")"}], 
      RowBox[{"\[DifferentialD]", " ", 
       StyleBox["e", "TI"]}]}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["1", "TR"]], 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["2", "TR"]]], 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["3", "TR"]], 
      RowBox[{"\[DifferentialD]", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["4", "TR"]]}]}]}], 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["3", "TR"]], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["4", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]}], "]"}], 
    RowBox[{"\[Integral]", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Integral]", " ", 
        RowBox[{
         StyleBox["e", "TI"], 
         RowBox[{"\[DifferentialD]", " ", 
          StyleBox["e", "TI"]}]}]}], ")"}], 
      RowBox[{"\[DifferentialD]", " ", 
       StyleBox["e", "TI"]}]}]}], "\[LeftTriangle]"},
   {Cell[TextData[{
     "other integration operators (see\[NonBreakingSpace]\"",
     ButtonBox["Operator Input Forms",
      BaseStyle->"Link",
      ButtonData->"paclet:tutorial/InputSyntax#23301"],
     "\")"
    }], "TableText"], "\[SpanFromLeft]", "\[SpanFromLeft]", 
    "\[SpanFromLeft]"},
   {
    RowBox[{
     SubscriptBox["\[PartialD]", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["D",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/D"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], 
    RowBox[{
     SubscriptBox["\[PartialD]", 
      StyleBox["e", "TI"]], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[PartialD]", 
        StyleBox["e", "TI"]], 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{"\[Del]", " ", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Del",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Del"], "[", 
     StyleBox["expr", "TI"], "]"}], 
    RowBox[{"\[Del]", 
     RowBox[{"(", 
      RowBox[{"\[Del]", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    RowBox[{"\[Square]", " ", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Square",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Square"], "[", 
     StyleBox["expr", "TI"], "]"}], 
    RowBox[{"\[Square]", 
     RowBox[{"(", 
      RowBox[{"\[Square]", " ", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[SmallCircle]", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[SmallCircle]", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["SmallCircle",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SmallCircle"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[SmallCircle]", " ", 
     StyleBox["e", "TI"], "\[SmallCircle]", " ", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[CircleDot]", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[CircleDot]", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["CircleDot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CircleDot"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], 
     StyleBox[" ", "TI"], "\[CircleDot]", " ", 
     StyleBox["e", "TI"], 
     StyleBox[" ", "TI"], "\[CircleDot]", " ", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "**", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "**", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["NonCommutativeMultiply",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NonCommutativeMultiply"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "**", 
     StyleBox["e", "TI"], "**", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Cross]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Cross]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Cross",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cross"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Cross]", 
     StyleBox["e", "TI"], "\[Cross]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ".", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], ".", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Dot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dot"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], ".", 
     StyleBox["e", "TI"], ".", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{"-", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      StyleBox["expr", "TI"]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{"+", 
     StyleBox["expr", "TI"]}], 
    StyleBox["expr", "TI"], "", "\[LeftTriangle]"},
   {
    RowBox[{"\[PlusMinus]", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["PlusMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlusMinus"], "[", 
     StyleBox["expr", "TI"], "]"}], "", ""},
   {
    RowBox[{"\[MinusPlus]", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["MinusPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MinusPlus"], "[", 
     StyleBox["expr", "TI"], "]"}], "", ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "/", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], 
     RowBox[{
      RowBox[{"(", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]], ")"}], "^", 
      RowBox[{"-", "1"}]}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "/", 
       StyleBox["e", "TI"]}], ")"}], "/", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Divide]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Divide",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Divide"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[Divide]", 
       StyleBox["e", "TI"]}], ")"}], "\[Divide]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\/", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Divide",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Divide"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\\/", 
       StyleBox["e", "TI"]}], ")"}], "\\/", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\\", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Backslash",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Backslash"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\\", 
     StyleBox["e", "TI"], "\\", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Diamond]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Diamond]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Diamond",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Diamond"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Diamond]", 
     StyleBox["e", "TI"], "\[Diamond]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Wedge]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Wedge]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Wedge",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Wedge"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Wedge]", 
     StyleBox["e", "TI"], "\[Wedge]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Vee]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Vee]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Vee",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Vee"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Vee]", 
     StyleBox["e", "TI"], "\[Vee]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[CircleTimes]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[CircleTimes]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["CircleTimes",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CircleTimes"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[CircleTimes]", 
     StyleBox["e", "TI"], "\[CircleTimes]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[CenterDot]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[CenterDot]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["CenterDot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CenterDot"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[CenterDot]", 
     StyleBox["e", "TI"], "\[CenterDot]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], " ", 
     StyleBox["e", "TI"], " ", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "*", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "*", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "*", 
     StyleBox["e", "TI"], "*", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Times]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Times]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Times",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Times"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Times]", 
     StyleBox["e", "TI"], "\[Times]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Star]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Star]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Star",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Star"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Star]", 
     StyleBox["e", "TI"], "\[Star]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     UnderoverscriptBox["\[Product]", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], "=", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]]}], 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["3", "TR"]]], 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["4", "TR"]]}], 
    RowBox[{
     ButtonBox["Product",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Product"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["4", "TR"]], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], 
    RowBox[{"\[Product]", 
     RowBox[{"(", 
      RowBox[{"\[Product]", " ", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[VerticalTilde]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[VerticalTilde]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["VerticalTilde",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VerticalTilde"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[VerticalTilde]", 
     StyleBox["e", "TI"], "\[VerticalTilde]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Coproduct]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Coproduct]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Coproduct",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Coproduct"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Coproduct]", 
     StyleBox["e", "TI"], "\[Coproduct]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Cap]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Cap]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Cap",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cap"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Cap]", 
     StyleBox["e", "TI"], "\[Cap]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Cup]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Cup]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Cup",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cup"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Cup]", 
     StyleBox["e", "TI"], "\[Cup]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[CirclePlus]", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[CirclePlus]", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["CirclePlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CirclePlus"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[CirclePlus]", 
     StyleBox["e", "TI"], "\[CirclePlus]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[CircleMinus]", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["CircleMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CircleMinus"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], 
       StyleBox[" ", "TI"], "\[CircleMinus]", " ", 
       StyleBox["e", "TI"]}], ")"}], "\[CircleMinus]", " ", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], "=", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]]}], 
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["3", "TR"]]], 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["4", "TR"]]}], 
    RowBox[{
     ButtonBox["Sum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sum"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["4", "TR"]], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["3", "TR"]]}], "}"}]}], "]"}], 
    RowBox[{"\[Sum]", 
     RowBox[{"(", 
      RowBox[{"\[Sum]", " ", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "+", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "+", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Plus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Plus"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "+", 
     StyleBox["e", "TI"], "+", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "-", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "+", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "-", 
       StyleBox["e", "TI"]}], ")"}], "-", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[PlusMinus]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["PlusMinus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PlusMinus"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[PlusMinus]", 
       StyleBox["e", "TI"]}], ")"}], "\[PlusMinus]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[MinusPlus]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["MinusPlus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MinusPlus"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[MinusPlus]", 
       StyleBox["e", "TI"]}], ")"}], "\[MinusPlus]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Intersection]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Intersection",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Intersection"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Intersection]", 
     StyleBox["e", "TI"], "\[Intersection]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {Cell["other intersection operators", "TableText"], "\[SpanFromLeft]", 
    "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Union]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Union",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Union"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Union]", 
     StyleBox["e", "TI"], "\[Union]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {Cell["other union operators", "TableText"], "\[SpanFromLeft]", 
    "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {
    RowBox[{
     StyleBox["i", "TI"], ";;", 
     StyleBox["j", "TI"], ";;", 
     StyleBox["k", "TI"]}], 
    RowBox[{
     ButtonBox["Span",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Span"], "[", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], ";;", 
     StyleBox["e", "TI"], ";;", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "==", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Equal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Equal"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "==", 
     StyleBox["e", "TI"], "==", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "==", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Equal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Equal"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "==", 
     StyleBox["e", "TI"], "==", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[LongEqual]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Equal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Equal"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[LongEqual]", 
     StyleBox["e", "TI"], "\[LongEqual]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "!=", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Unequal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unequal"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "!=", 
     StyleBox["e", "TI"], "!=", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "!=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Unequal",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unequal"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "!=", 
     StyleBox["e", "TI"], "!=", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {Cell["other equality and similarity operators", "TableText"], 
    "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ">", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Greater",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Greater"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], ">", 
     StyleBox["e", "TI"], ">", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ">=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["GreaterEqual",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GreaterEqual"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], ">=", 
     StyleBox["e", "TI"], ">=", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[GreaterEqual]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["GreaterEqual",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GreaterEqual"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[GreaterEqual]", 
     StyleBox["e", "TI"], "\[GreaterEqual]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[GreaterSlantEqual]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["GreaterEqual",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GreaterEqual"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[GreaterSlantEqual]", 
     StyleBox["e", "TI"], "\[GreaterSlantEqual]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "<", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Less",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Less"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "<", 
     StyleBox["e", "TI"], "<", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "<=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["LessEqual",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LessEqual"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "<=", 
     StyleBox["e", "TI"], "<=", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[LessEqual]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["LessEqual",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LessEqual"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[LessEqual]", 
     StyleBox["e", "TI"], "\[LessEqual]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[LessSlantEqual]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["LessEqual",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LessEqual"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[LessSlantEqual]", 
     StyleBox["e", "TI"], "\[LessSlantEqual]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {Cell["other ordering operators", "TableText"], "\[SpanFromLeft]", 
    "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[VerticalBar]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["VerticalBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VerticalBar"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[VerticalBar]", 
     StyleBox["e", "TI"], "\[VerticalBar]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[NotVerticalBar]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["NotVerticalBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotVerticalBar"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[NotVerticalBar]", 
     StyleBox["e", "TI"], "\[NotVerticalBar]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[DoubleVerticalBar]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["DoubleVerticalBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DoubleVerticalBar"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[DoubleVerticalBar]", 
     StyleBox["e", "TI"], "\[DoubleVerticalBar]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[NotDoubleVerticalBar]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["NotDoubleVerticalBar",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotDoubleVerticalBar"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[NotDoubleVerticalBar]", 
     StyleBox["e", "TI"], "\[NotDoubleVerticalBar]", 
     StyleBox["e", "TI"]}], ""},
   {Cell["horizontal arrow and vector operators", "TableText"], 
    "\[SpanFromLeft]", "\[SpanFromLeft]", "\[SpanFromLeft]"},
   {Cell["diagonal arrow operators", "TableText"], "", "", ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "===", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["SameQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SameQ"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "===", 
     StyleBox["e", "TI"], "===", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "=!=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["UnsameQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnsameQ"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "=!=", 
     StyleBox["e", "TI"], "=!=", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Element]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Element",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Element"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Element]", 
     StyleBox["e", "TI"], "\[Element]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[NotElement]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["NotElement",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotElement"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[NotElement]", 
     StyleBox["e", "TI"], "\[NotElement]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Subset]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Subset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subset"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Subset]", 
     StyleBox["e", "TI"], "\[Subset]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Superset]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Superset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Superset"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Superset]", 
     StyleBox["e", "TI"], "\[Superset]", 
     StyleBox["e", "TI"]}], ""},
   {Cell["other set relation operators", "TableText"], "\[SpanFromLeft]", 
    "\[SpanFromLeft]", ""},
   {
    RowBox[{
     SubscriptBox["\[ForAll]", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["ForAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ForAll"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     SubscriptBox["\[ForAll]", 
      StyleBox["e", "TI"]], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[ForAll]", 
        StyleBox["e", "TI"]], 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox["\[Exists]", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Exists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exists"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     SubscriptBox["\[Exists]", 
      StyleBox["e", "TI"]], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Exists]", 
        StyleBox["e", "TI"]], 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox["\[NotExists]", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["NotExists",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotExists"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     SubscriptBox["\[NotExists]", 
      StyleBox["e", "TI"]], 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[NotExists]", 
        StyleBox["e", "TI"]], 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    RowBox[{"!", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Not",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Not"], "[", 
     StyleBox["expr", "TI"], "]"}], 
    RowBox[{"!", 
     RowBox[{"(", 
      RowBox[{"!", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{"\[Not]", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Not",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Not"], "[", 
     StyleBox["expr", "TI"], "]"}], 
    RowBox[{"\[Not]", 
     RowBox[{"(", 
      RowBox[{"\[Not]", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "&&", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "&&", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["And",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/And"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "&&", 
     StyleBox["e", "TI"], "&&", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[And]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[And]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["And",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/And"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[And]", 
     StyleBox["e", "TI"], "\[And]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Nand]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Nand]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Nand",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nand"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Nand]", 
     StyleBox["e", "TI"], "\[Nand]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Xor]", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], "\[Xor]", 
     SubscriptBox[
      StyleBox["expr", "TI"], "3"]}], 
    RowBox[{
     ButtonBox["Xor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Xor"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Xor]", 
     StyleBox["e", "TI"], "\[Xor]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "||", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "||", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Or",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Or"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "||", 
     StyleBox["e", "TI"], "||", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Or]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Or]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Or",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Or"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Or]", 
     StyleBox["e", "TI"], "\[Or]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Nor]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "\[Nor]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["Nor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nor"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Nor]", 
     StyleBox["e", "TI"], "\[Nor]", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Implies]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Implies",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Implies"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Implies]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[Implies]", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[RoundImplies]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Implies",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Implies"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[RoundImplies]", 
     RowBox[{
      StyleBox["e", "TI"], "\[RoundImplies]", 
      StyleBox["e", "TI"]}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[RightTee]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{"RightTee", "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[RightTee]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[RightTee]", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[DoubleRightTee]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{"DoubleRightTee", "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[DoubleRightTee]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[DoubleRightTee]", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[LeftTee]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{"LeftTee", "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[LeftTee]", 
       StyleBox["e", "TI"]}], ")"}], "\[LeftTee]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[DoubleLeftTee]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{"DoubleLeftTee", "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[DoubleLeftTee]", 
       StyleBox["e", "TI"]}], ")"}], "\[DoubleLeftTee]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[SuchThat]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["SuchThat",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuchThat"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[SuchThat]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[SuchThat]", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    RowBox[{
     StyleBox["expr", "TI"], ".."}], 
    RowBox[{
     ButtonBox["Repeated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Repeated"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "..."}], 
    RowBox[{
     ButtonBox["RepeatedNull",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RepeatedNull"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "|", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Alternatives",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Alternatives"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "|", 
     StyleBox["e", "TI"], "|", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["symb", "TI"], ":", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Pattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pattern"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      StyleBox["expr", "TI"]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["patt", "TI"], ":", 
     StyleBox["expr", "TI"]}], 
    RowBox[{
     ButtonBox["Optional",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Optional"], "[", 
     RowBox[{
      StyleBox["patt", "TI"], ",", 
      StyleBox["expr", "TI"]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "~~", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "~~", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["StringExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StringExpression"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "~~", 
     StyleBox["e", "TI"], "~~", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "/;", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Condition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Condition"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "/;", 
       StyleBox["e", "TI"]}], ")"}], "/;", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Rule",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rule"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "->", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "->", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Rule]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Rule",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rule"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[Rule]", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ":>", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["RuleDelayed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RuleDelayed"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], ":>", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], ":>", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[RuleDelayed]", " ", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["RuleDelayed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RuleDelayed"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[RuleDelayed]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[RuleDelayed]", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "/.", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["ReplaceAll",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplaceAll"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "/.", 
       StyleBox["e", "TI"]}], ")"}], "/.", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "//.", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["ReplaceRepeated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplaceRepeated"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "//.", 
       StyleBox["e", "TI"]}], ")"}], "//.", 
     StyleBox["e", "TI"]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "+=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["AddTo",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AddTo"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "+=", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "+=", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "-=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["SubtractFrom",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubtractFrom"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "-=", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "-=", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "*=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["TimesBy",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TimesBy"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "*=", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "*=", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "/=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["DivideBy",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DivideBy"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "/=", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "/=", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "&"}], 
    RowBox[{
     ButtonBox["Function",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Function"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ":", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Colon",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Colon"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ":", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], ":", 
     RowBox[{
      StyleBox["e", "TI"], ":", 
      StyleBox["e", "TI"]}]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "//", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], "[", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "//", 
       StyleBox["e", "TI"]}], ")"}], "//", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[VerticalSeparator]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["VerticalSeparator",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/VerticalSeparator"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[VerticalSeparator]", 
     StyleBox["e", "TI"], "\[VerticalSeparator]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Therefore]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Therefore",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Therefore"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\[Therefore]", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[Therefore]", 
       StyleBox["e", "TI"]}], ")"}]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\[Because]", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Because",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Because"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\[Because]", 
       StyleBox["e", "TI"]}], ")"}], "\[Because]", 
     StyleBox["e", "TI"]}], ""},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["Set",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Set"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "=", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "=", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ":=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["SetDelayed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SetDelayed"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], ":=", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], ":=", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "^=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["UpSet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UpSet"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "^=", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "^=", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "^:=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["UpSetDelayed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UpSetDelayed"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "^:=", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "^:=", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["symb", "TI"], "/:", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["TagSet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TagSet"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["symb", "TI"], "/:", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ":=", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["TagSetDelayed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TagSetDelayed"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], "=."}], 
    RowBox[{
     ButtonBox["Unset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unset"], "[", 
     StyleBox["expr", "TI"], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["symb", "TI"], "/:", 
     RowBox[{
      StyleBox["expr", "TI"], "=."}]}], 
    RowBox[{
     ButtonBox["TagUnset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TagUnset"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      StyleBox["expr", "TI"]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], ">>", 
     StyleBox["filename", "TI"]}], 
    RowBox[{
     ButtonBox["Put",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Put"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\""}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     StyleBox["expr", "TI"], ">>>", 
     StyleBox["filename", "TI"]}], 
    RowBox[{
     ButtonBox["PutAppend",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PutAppend"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\""}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ";", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], ";", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["CompoundExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CompoundExpression"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["3", "TR"]]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], ";", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]], ";"}], 
    RowBox[{
     ButtonBox["CompoundExpression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CompoundExpression"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      ButtonBox["Null",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Null"]}], "]"}], "", "\[LeftTriangle]"},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["1", "TR"]], "\\`", 
     SubscriptBox[
      StyleBox["expr", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["FormBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormBox"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], 
    RowBox[{
     StyleBox["e", "TI"], "\\`", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["e", "TI"], "\\`", 
       StyleBox["e", "TI"]}], ")"}]}], "\[LeftTriangle]"}
  }]], "PrecedenceTable",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, True, False, True, False, True, True, True, 
     True, True, False, False, False, False, False, False, True, False, False,
      True, True, True, False, False, False, True, False, False, True, False, 
     True, False, False, True, True, False, False, False, True, False, True, 
     False, False, False, True, False, True, True, False, False, False, True, 
     True, False, False, True, False, False, True, False, True, False, True, 
     True, True, True, True, False, False, False, True, False, False, True, 
     True, True, True, True, True, True, False, False, True, True, True, True,
      True, False, True, False, True, True, False, False, False, True, False, 
     True, False, True, True, False, False, False, False, False, False, False,
      False, False, False, False, False, False, False, False, False, False, 
     False, False, True, False, False, True, False, False, False, False, True,
      False, False, True, False, True, False, False, True, True, False, False,
      True, False, True, False, False, False, True, True, False, True, True, 
     False, True, True, True, False, False, False, True, False, True, False, 
     False, False, True, True, True, True, True, False, True, False, False, 
     False, False, False, False, False, True, False, True, False, {True}, 
     False}, "RowsIndexed" -> {}}},
 CellID->15012],

Cell["Operator input forms, in order of decreasing precedence.", "Caption",
 CellID->13440],

Cell[BoxData[GridBox[{
   {Cell["special input form", "TableHeader"], Cell[
    "full form", "TableHeader"]},
   {"#", 
    RowBox[{
     ButtonBox["Slot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Slot"], "[", "1", "]"}]},
   {
    RowBox[{"#", 
     StyleBox["n", "TI"]}], 
    RowBox[{
     ButtonBox["Slot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Slot"], "[", 
     StyleBox["n", "TI"], "]"}]},
   {"##", 
    RowBox[{
     ButtonBox["SlotSequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SlotSequence"], "[", "1", "]"}]},
   {
    RowBox[{"##", 
     StyleBox["n", "TI"]}], 
    RowBox[{
     ButtonBox["SlotSequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SlotSequence"], "[", 
     StyleBox["n", "TI"], "]"}]},
   {"%", 
    RowBox[{
     ButtonBox["Out",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Out"], "[", " ", "]"}]},
   {"%%", 
    RowBox[{
     ButtonBox["Out",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Out"], "[", 
     RowBox[{"-", "2"}], "]"}]},
   {
    RowBox[{"%%", 
     StyleBox["\[Ellipsis]", "TR"], "%", Cell[TextData[{
      " (",
      Cell[BoxData[
       StyleBox["n", "TI"]], "InlineFormula"],
      " times)"
     }], "TableText"]}], 
    RowBox[{
     ButtonBox["Out",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Out"], "[", 
     RowBox[{"-", 
      StyleBox["n", "TI"]}], "]"}]},
   {
    RowBox[{"%", 
     StyleBox["n", "TI"]}], 
    RowBox[{
     ButtonBox["Out",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Out"], "[", 
     StyleBox["n", "TI"], "]"}]},
   {"_", 
    RowBox[{
     ButtonBox["Blank",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Blank"], "[", " ", "]"}]},
   {
    StyleBox[
     RowBox[{"_", 
      StyleBox["expr", "TI"]}]], 
    RowBox[{
     ButtonBox["Blank",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Blank"], "[", 
     StyleBox["expr", "TI"], "]"}]},
   {"__", 
    RowBox[{
     ButtonBox["BlankSequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BlankSequence"], "[", " ", "]"}]},
   {
    StyleBox[
     RowBox[{"__", 
      StyleBox["expr", "TI"]}]], 
    RowBox[{
     ButtonBox["BlankSequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BlankSequence"], "[", 
     StyleBox["expr", "TI"], "]"}]},
   {"___", 
    RowBox[{
     ButtonBox["BlankNullSequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BlankNullSequence"], "[", " ", "]"}]},
   {
    StyleBox[
     RowBox[{"___", 
      StyleBox["expr", "TI"]}]], 
    RowBox[{
     ButtonBox["BlankNullSequence",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BlankNullSequence"], "[", 
     StyleBox["expr", "TI"], "]"}]},
   {"_.", 
    RowBox[{
     ButtonBox["Optional",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Optional"], "[", 
     RowBox[{
      ButtonBox["Blank",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Blank"], "[", " ", "]"}], "]"}]},
   {
    StyleBox[
     RowBox[{
      StyleBox["symb", "TI"], "_"}]], 
    RowBox[{
     ButtonBox["Pattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pattern"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      RowBox[{
       ButtonBox["Blank",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blank"], "[", " ", "]"}]}], "]"}]},
   {
    StyleBox[
     RowBox[{
      StyleBox["symb", "TI"], "_", 
      StyleBox["expr", "TI"]}]], 
    RowBox[{
     ButtonBox["Pattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pattern"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      RowBox[{
       ButtonBox["Blank",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Blank"], "[", 
       StyleBox["expr", "TI"], "]"}]}], "]"}]},
   {
    StyleBox[
     RowBox[{
      StyleBox["symb", "TI"], "__"}]], 
    RowBox[{
     ButtonBox["Pattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pattern"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      RowBox[{
       ButtonBox["BlankSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlankSequence"], "[", " ", "]"}]}], "]"}]},
   {
    StyleBox[
     RowBox[{
      StyleBox["symb", "TI"], "__", 
      StyleBox["expr", "TI"]}]], 
    RowBox[{
     ButtonBox["Pattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pattern"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      RowBox[{
       ButtonBox["BlankSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlankSequence"], "[", 
       StyleBox["expr", "TI"], "]"}]}], "]"}]},
   {
    StyleBox[
     RowBox[{
      StyleBox["symb", "TI"], "___"}]], 
    RowBox[{
     ButtonBox["Pattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pattern"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      RowBox[{
       ButtonBox["BlankNullSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlankNullSequence"], "[", " ", "]"}]}], 
     "]"}]},
   {
    StyleBox[
     RowBox[{
      StyleBox["symb", "TI"], "___", 
      StyleBox["expr", "TI"]}]], 
    RowBox[{
     ButtonBox["Pattern",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pattern"], "[", 
     RowBox[{
      StyleBox["symb", "TI"], ",", 
      RowBox[{
       ButtonBox["BlankNullSequence",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/BlankNullSequence"], "[", 
       StyleBox["expr", "TI"], "]"}]}], "]"}]},
   {
    StyleBox[
     RowBox[{
      StyleBox["symb", "TI"], "_."}]], 
    RowBox[{
     ButtonBox["Optional",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Optional"], "[", 
     RowBox[{
      ButtonBox["Pattern",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Pattern"], "[", 
      RowBox[{
       StyleBox["symb", "TI"], ",", 
       RowBox[{
        ButtonBox["Blank",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Blank"], "[", " ", "]"}]}], "]"}], "]"}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, True, False, False, False, True, False, False, False, True, False, 
     False, False, False, False, False, False, False, False, False, False, 
     False, {False}, False}, "RowsIndexed" -> {}}},
 CellID->6349],

Cell["Additional input forms, in order of decreasing precedence. ", "Caption",
 CellID->1951],

Cell[CellGroupData[{

Cell["Special Characters", "Subsection",
 CellID->11350],

Cell[TextData[{
 "Special characters that appear in operators usually have names that \
correspond to the names of the functions they represent. Thus the character \
",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 " has name ",
 Cell[BoxData[
  ButtonBox["\\[CirclePlus]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/CirclePlus"]], "InlineCharacterName"],
 " and yields the function ",
 Cell[BoxData[
  ButtonBox["CirclePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CirclePlus"]], "InlineFormula"],
 ". Exceptions are ",
 Cell[BoxData[
  ButtonBox["\\[GreaterSlantEqual]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/GreaterSlantEqual"]], 
  "InlineCharacterName"],
 ", ",
 Cell[BoxData[
  ButtonBox["\\[LessSlantEqual]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/LessSlantEqual"]], 
  "InlineCharacterName"],
 " and ",
 Cell[BoxData[
  ButtonBox["\\[RoundImplies]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/RoundImplies"]], "InlineCharacterName"],
 ". "
}], "Text",
 CellID->27606],

Cell[TextData[{
 "The delimiters in matchfix operators have names ",
 Cell[BoxData[
  RowBox[{"\\[", 
   StyleBox[
    RowBox[{"Left", 
     StyleBox["Name", "TI"]}]], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\\[", 
   StyleBox[
    RowBox[{"Right", 
     StyleBox["Name", "TI"]}]], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->24795],

Cell[TextData[{
 ButtonBox["Listing of All Special Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ListingOfNamedCharacters"],
 " gives a complete listing of special characters that appear in operators. "
}], "Text",
 CellID->29171],

Cell[BoxData[GridBox[{
   {GridBox[{
      {Cell["keyboard characters", "TableHeader"], Cell[
       "special character", "TableHeader"]},
      {"->", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Rule]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Rule"]], "InlineCharacterName"], 
        " ", Cell[BoxData[
         FormBox["\[Rule]", TraditionalForm]], "InlineFormula"]}]},
      {":>", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RuleDelayed]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RuleDelayed"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[RuleDelayed]"], "InlineFormula"]}]},
      {"==", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Equal]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Equal"]], "InlineCharacterName"], 
        " ", Cell[BoxData["\[Equal]"], "InlineFormula"]}]},
      {"!=", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[NotEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/NotEqual"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[NotEqual]"], "InlineFormula"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {Cell["keyboard characters", "TableHeader"], Cell[
       "special character", "TableHeader"]},
      {">=", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[GreaterEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterEqual"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[GreaterEqual]"], "InlineFormula"]}]},
      {">=", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[GreaterSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/GreaterSlantEqual"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[GreaterSlantEqual]"], "InlineFormula"]}]},
      {"<=", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[LessEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessEqual"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[LessEqual]"], "InlineFormula"]}]},
      {"<=", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[LessSlantEqual]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LessSlantEqual"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[LessSlantEqual]"], "InlineFormula"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  },
  GridBoxAlignment->{
   "Columns" -> {Center, {Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
     "RowsIndexed" -> {}}]], "DoubleBox",
 CellFrame->0.5,
 CellID->3621],

Cell["\<\
Keyboard and special characters with the same interpretations. \
\>", "Caption",
 CellID->11088],

Cell[BoxData[GridBox[{
   {GridBox[{
      {Cell["keyboard character", "TableHeader"], Cell[
       "special character", "TableHeader"]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawColon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawColon"]], 
         "InlineCharacterName"], " ", ":"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Colon]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Colon"]], "InlineCharacterName"], 
        " ", Cell[BoxData["\[Colon]"], "InlineFormula"]}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawTilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawTilde"]], 
         "InlineCharacterName"], " ", "~"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Tilde]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Tilde"]], "InlineCharacterName"], 
        " ", Cell[BoxData["\[Tilde]"], "InlineFormula"]}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawWedge]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawWedge"]], 
         "InlineCharacterName"], " ", "^"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Wedge]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"], 
        " ", Cell[BoxData["\[Wedge]"], "InlineFormula"]}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawWedge]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawWedge"]], 
         "InlineCharacterName"], " ", "^"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[And]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"], 
        " ", Cell[BoxData["\[And]"], "InlineFormula"]}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawStar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawStar"]], 
         "InlineCharacterName"], " ", "*"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Star]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Star"]], "InlineCharacterName"], 
        " ", Cell[BoxData["\[Star]"], "InlineFormula"]}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawBackslash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawBackslash"]], 
         "InlineCharacterName"], " ", "\[Backslash]"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Backslash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Backslash"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[Backslash]"], "InlineFormula"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {Cell["keyboard character", "TableHeader"], Cell[
       "special character", "TableHeader"]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawDot"]], "InlineCharacterName"],
         " ", "."}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[CenterDot]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/CenterDot"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[CenterDot]"], "InlineFormula"]}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawVerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawVerticalBar"]], 
         "InlineCharacterName"], " ", "|"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[VerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalBar"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[VerticalBar]"], "InlineFormula"], " "}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawVerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawVerticalBar"]], 
         "InlineCharacterName"], " ", "|"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[VerticalSeparator]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/VerticalSeparator"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[VerticalSeparator]"], "InlineFormula"]}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawVerticalBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawVerticalBar"]], 
         "InlineCharacterName"], " ", "|"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[LeftBracketingBar]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/LeftBracketingBar"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
        "\[LeftBracketingBar]"], "InlineFormula"]}]},
      {
       RowBox[{Cell[BoxData[
         ButtonBox["\\[RawDash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/RawDash"]], 
         "InlineCharacterName"], " ", "-"}], 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Dash]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Dash"]], "InlineCharacterName"], 
        " ", Cell[BoxData["\[Dash]"], "InlineFormula"]}]},
      {"...", 
       RowBox[{Cell[BoxData[
         ButtonBox["\\[Ellipsis]",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/character/Ellipsis"]], 
         "InlineCharacterName"], " ", Cell[BoxData[
         StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  },
  GridBoxAlignment->{
   "Columns" -> {Center, {Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
     "RowsIndexed" -> {}}]], "DoubleBox",
 CellFrame->0.5,
 CellID->7675],

Cell["\<\
Some keyboard and special characters with different interpretations.\
\>", "Caption",
 CellID->18725]
}, Open  ]],

Cell[CellGroupData[{

Cell["Precedence and the Ordering of Input Forms", "Subsection",
 CellID->22807],

Cell[TextData[{
 "The tables of input forms are arranged in decreasing order of precedence. \
Input forms in the same box have the same precedence. Each page in the table \
begins a new box. As discussed in \"",
 ButtonBox["Special Ways to Input Expressions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SpecialWaysToInputExpressions"],
 ", precedence determines how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " groups terms in input expressions. The general rule is that if ",
 Cell[BoxData[
  FormBox["\[CircleTimes]", TraditionalForm]], "InlineMath"],
 " has higher precedence than ",
 Cell[BoxData[
  FormBox["\[CirclePlus]", TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[CirclePlus]", "b", "\[CircleTimes]", "c"}], 
   TraditionalForm]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[CirclePlus]", 
    RowBox[{"(", 
     RowBox[{"b", "\[CircleTimes]", "c"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[CircleTimes]", "b", "\[CirclePlus]", "c"}], 
   TraditionalForm]], "InlineMath"],
 " is interpreted as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "\[CircleTimes]", "b"}], ")"}], "\[CirclePlus]", "c"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->25628]
}, Open  ]],

Cell[CellGroupData[{

Cell["Grouping of Input Forms", "Subsection",
 CellID->1265],

Cell[TextData[{
 "The third columns in the tables show how multiple occurrences of a single \
input form, or of several input forms with the same precedence, are grouped. \
For example, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a", "/", "b"}], "/", "c"}]], "InlineFormula"],
 " is grouped as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "/", "b"}], ")"}], "/", "c"}]], "InlineFormula"],
 " (\[OpenCurlyDoubleQuote]left associative\[CloseCurlyDoubleQuote]), while \
",
 Cell[BoxData[
  RowBox[{"a", "^", 
   RowBox[{"b", "^", "c"}]}]], "InlineFormula"],
 " is grouped as ",
 Cell[BoxData[
  RowBox[{"a", "^", 
   RowBox[{"(", 
    RowBox[{"b", "^", "c"}], ")"}]}]], "InlineFormula"],
 " (\[OpenCurlyDoubleQuote]right associative\[CloseCurlyDoubleQuote]). No \
grouping is needed in an expression like ",
 Cell[BoxData[
  RowBox[{"a", "+", "b", "+", "c"}]], "InlineFormula"],
 ", since ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " is fully associative, as represented by the attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 "."
}], "Text",
 CellID->17786]
}, Open  ]],

Cell[CellGroupData[{

Cell["Precedence of Integration Operators", "Subsection",
 CellID->8373],

Cell[TextData[{
 "Forms such as ",
 Cell[BoxData[
  FormBox["\[Integral]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["expr", "TI"], "1"], TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox["\[DifferentialD]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["expr", "TI"], "2"], TraditionalForm]], "InlineMath"],
 " have an \[OpenCurlyDoubleQuote]outer\[CloseCurlyDoubleQuote] precedence \
just below ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ", as indicated in the table above, but an \[OpenCurlyDoubleQuote]inner\
\[CloseCurlyDoubleQuote] precedence just above ",
 Cell[BoxData[
  FormBox["\[Sum]", TraditionalForm]], "InlineMath"],
 ". The outer precedence determines when ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["expr", "TI"], "2"], TraditionalForm]], "InlineMath"],
 " needs to be parenthesized; the inner precedence determines when ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["expr", "TI"], "1"], TraditionalForm]], "InlineMath"],
 " needs to be parenthesized. "
}], "Text",
 CellID->26289],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\\[ContourIntegral]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ContourIntegral"]], 
  "InlineCharacterName"],
 ", ",
 Cell[BoxData[
  ButtonBox["\\[ClockwiseContourIntegral]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ClockwiseContourIntegral"]], 
  "InlineCharacterName"],
 " and ",
 Cell[BoxData[
  ButtonBox["\\[DoubleContourIntegral]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/DoubleContourIntegral"]], 
  "InlineCharacterName"],
 " work the same as ",
 Cell[BoxData[
  ButtonBox["\\[Integral]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Integral"]], "InlineCharacterName"],
 ". "
}], "Text",
 CellID->17185],

Cell[TextData[{
 "See\[NonBreakingSpace]",
 ButtonBox["Two-Dimensional Input Forms",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InputSyntax#15273"],
 " for two\[Hyphen]dimensional input forms associated with integration \
operators. "
}], "Text",
 CellID->16981]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spaces and Multiplication", "Subsection",
 CellID->26655],

Cell[TextData[{
 "Spaces in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " denote multiplication, just as they do in standard mathematical notation. \
In addition, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " takes complete expressions that are adjacent, not necessarily separated by \
spaces, to be multiplied together."
}], "Text",
 CellID->10687],

Cell[BoxData[GridBox[{
   {Cell["\[FilledSmallSquare] x y z \[LongRightArrow] x*y*z"]},
   {Cell["\[FilledSmallSquare] 2x \[LongRightArrow] 2*x"]},
   {Cell["\[FilledSmallSquare] 2(x+1) \[LongRightArrow] 2*(x+1)"]},
   {Cell["\[FilledSmallSquare] c(x+1) \[LongRightArrow] c*(x+1)"]},
   {Cell["\[FilledSmallSquare] (x+1)(y+2) \[LongRightArrow] (x+1)*(y+2)"]},
   {Cell["\[FilledSmallSquare] x! y \[LongRightArrow] x!*y"]},
   {Cell["\[FilledSmallSquare] x!y \[LongRightArrow] x!*y"]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}}]], "FramedBox",
 CellID->13394],

Cell["Alternative forms for multiplication. ", "Caption",
 CellID->11506],

Cell[TextData[{
 "An expression like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "!"}], "y"}]], "InlineFormula"],
 " could potentially mean either ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "!"}], ")"}], "*", "y"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"x", "*", 
   RowBox[{"(", 
    RowBox[{"!", "y"}], ")"}]}]], "InlineFormula"],
 ". The first interpretation is chosen because ",
 Cell[BoxData[
  ButtonBox["Factorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial"]], "InlineFormula"],
 " has higher precedence than ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->9716],

Cell[TextData[{
 "Spaces within single input forms are ignored. Thus, for example, ",
 Cell[BoxData[
  RowBox[{"a", "+", "b"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"a", "+", "b"}]], "InlineFormula"],
 ". You will often want to insert spaces around lower precedence operators to \
improve readability. "
}], "Text",
 CellID->20091],

Cell["\<\
You can give a \[OpenCurlyDoubleQuote]coefficient\[CloseCurlyDoubleQuote] for \
a symbol by preceding it with any sequence of digits. When you use numbers in \
bases larger than 10, the digits can include letters. (In bases other than \
10, there must be a space between the end of the coefficient, and the \
beginning of the symbol name.)\
\>", "Text",
 CellID->9651],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"x", "^", "2"}], "y"}]], "InlineFormula"],
     ", like ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", "y"}]], "InlineFormula"],
     ", means ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "^", "2"}], ")"}], " ", "y"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"x", "/", "2"}], "y"}]], "InlineFormula"],
     ", like ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"x", "/", "2"}], " ", "y"}]], "InlineFormula"],
     ", means ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "/", "2"}], ")"}], " ", "y"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData["xy"], "InlineFormula"],
     " is a single symbol, not ",
     Cell[BoxData[
      RowBox[{"x", "*", "y"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "FramedBox",
 CellID->19287],

Cell["Some cases to be careful about. ", "Caption",
 CellID->16242]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spaces to Avoid", "Subsection",
 CellID->16182],

Cell[TextData[{
 "You should avoid inserting any spaces between the different characters in \
composite operators such as ",
 Cell[BoxData["/."], "InlineFormula"],
 ", ",
 Cell[BoxData["=."], "InlineFormula"],
 " and ",
 Cell[BoxData[">="], "InlineFormula"],
 ". Although in some cases such spaces are allowed, they are liable to lead \
to confusion. "
}], "Text",
 CellID->18971],

Cell[TextData[{
 "Another case where spaces must be avoided is between the characters of the \
pattern object ",
 Cell[BoxData["x_"], "InlineFormula"],
 ". If you type ",
 Cell[BoxData[
  RowBox[{"x", "_"}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will interpret this as ",
 Cell[BoxData[
  RowBox[{"x", "*", "_"}]], "InlineFormula"],
 ", rather than the single named pattern object ",
 Cell[BoxData["x_"], "InlineFormula"],
 ". "
}], "Text",
 CellID->28552],

Cell[TextData[{
 "Similarly, you should not insert any spaces inside pattern objects like ",
 Cell[BoxData[
  RowBox[{
   StyleBox[
    RowBox[{
     StyleBox["x", "TI"], "_:"}]], 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16095]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spacing Characters", "Subsection",
 CellID->7221],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] Ordinary keyboard space (",
     Cell[BoxData[
      ButtonBox["\\[RawSpace]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/RawSpace"]], "InlineCharacterName"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      ButtonBox["\\[VeryThinSpace]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/VeryThinSpace"]], 
      "InlineCharacterName"],
     ", ",
     Cell[BoxData[
      ButtonBox["\\[ThinSpace]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/ThinSpace"]], "InlineCharacterName"],
     
     ", ..., ",
     Cell[BoxData[
      ButtonBox["\\[ThickSpace]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/ThickSpace"]], 
      "InlineCharacterName"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      ButtonBox["\\[NegativeVeryThinSpace]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/NegativeVeryThinSpace"]], 
      "InlineCharacterName"],
     ", ",
     Cell[BoxData[
      ButtonBox["\\[NegativeThinSpace]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/NegativeThinSpace"]], 
      "InlineCharacterName"],
     ", ..., ",
     Cell[BoxData[
      ButtonBox["\\[NegativeThickSpace]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/NegativeThickSpace"]], 
      "InlineCharacterName"]
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] ",
     Cell[BoxData[
      FormBox["\[SpaceIndicator]", TraditionalForm]], "InlineFormula"],
     " (",
     Cell[BoxData[
      ButtonBox["\\[SpaceIndicator]",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/character/SpaceIndicator"]], 
      "InlineCharacterName"],
     ")"
    }], "TableText"]}
  }]], "FramedBox",
 CellID->17301],

Cell["\<\
Spacing characters equivalent to an ordinary keyboard space. \
\>", "Caption",
 CellID->27387]
}, Open  ]],

Cell[CellGroupData[{

Cell["Relational Operators", "Subsection",
 CellID->18727],

Cell[TextData[{
 "Relational operators can be mixed. An expression like ",
 Cell[BoxData[
  RowBox[{"a", ">", "b", ">=", "c"}]], "InlineFormula"],
 " is converted to ",
 Cell[BoxData[
  RowBox[{"Inequality", "[", 
   RowBox[{"a", ",", 
    ButtonBox["Greater",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Greater"], ",", "b", ",", 
    ButtonBox["GreaterEqual",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GreaterEqual"], ",", "c"}], "]"}]], 
  "InlineFormula"],
 ", which effectively evaluates as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", ">", "b"}], ")"}], "&&", 
   RowBox[{"(", 
    RowBox[{"b", ">=", "c"}], ")"}]}]], "InlineFormula"],
 ". (The reason for the intermediate ",
 Cell[BoxData["Inequality"], "InlineFormula"],
 " form is that it prevents objects from being evaluated twice when input \
like ",
 Cell[BoxData[
  RowBox[{"a", ">", "b", ">=", "c"}]], "InlineFormula"],
 " is processed.)"
}], "Text",
 CellID->27325]
}, Open  ]],

Cell[CellGroupData[{

Cell["File Names", "Subsection",
 CellID->26140],

Cell[TextData[{
 "Any file name can be given in quotes after ",
 Cell[BoxData["<<"], "InlineFormula"],
 ", ",
 Cell[BoxData[">>"], "InlineFormula"],
 " and ",
 Cell[BoxData[">>>"], "InlineFormula"],
 ". File names can also be given without quotes if they contain only \
alphanumeric characters, special characters and the characters ",
 Cell[BoxData["`"], "InlineFormula"],
 ", ",
 Cell[BoxData["/"], "InlineFormula"],
 ", ",
 Cell[BoxData["."], "InlineFormula"],
 ", ",
 Cell[BoxData["\[Backslash]"], "InlineFormula"],
 ", ",
 Cell[BoxData["!"], "InlineFormula"],
 ", ",
 Cell[BoxData["-"], "InlineFormula"],
 ", ",
 Cell[BoxData["_"], "InlineFormula"],
 ", ",
 Cell[BoxData[":"], "InlineFormula"],
 ", ",
 Cell[BoxData["$"], "InlineFormula"],
 ", ",
 Cell[BoxData["*"], "InlineFormula"],
 ", ",
 Cell[BoxData["~"], "InlineFormula"],
 " and ",
 Cell[BoxData["?"], "InlineFormula"],
 ", together with matched pairs of square brackets enclosing any characters \
other than spaces, tabs and newlines. Note that file names given without \
quotes can be followed only by spaces, tabs or newlines, or by the characters \
",
 Cell[BoxData[")"], "InlineFormula"],
 ", ",
 Cell[BoxData["]"], "InlineFormula"],
 ", ",
 Cell[BoxData["}"], "InlineFormula"],
 ", as well as semicolon and comma. "
}], "Text",
 CellID->22091]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Two\[Hyphen]Dimensional Input Forms", "Section",
 CellTags->{"SA.2.8", "8.1"},
 CellID->15273],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       SuperscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["y", "TI"]], 
       RowBox[{
        ButtonBox["Power",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Power"], "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "]"}]},
      {
       FractionBox[
        StyleBox["x", "TI"], 
        StyleBox["y", "TI"]], 
       RowBox[{
        ButtonBox["Divide",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Divide"], "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "]"}]},
      {
       SqrtBox[
        StyleBox["x", "TI"]], 
       RowBox[{
        ButtonBox["Sqrt",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Sqrt"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       RadicalBox[
        StyleBox["x", "TI"], 
        StyleBox["n", "TI"]], 
       RowBox[{
        ButtonBox["Power",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Power"], "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         RowBox[{"1", "/", 
          StyleBox["n", "TI"]}]}], "]"}]},
      {GridBox[{
         {
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["11", "TR"]], 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["12", "TR"]], 
          StyleBox["\[Ellipsis]", "TR"]},
         {
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["21", "TR"]], 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["22", "TR"]], 
          StyleBox["\[Ellipsis]", "TR"]}
        }], 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["12", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["21", "TR"]], ",", 
           SubscriptBox[
            StyleBox["a", "TI"], 
            StyleBox["22", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]},
      {
       RowBox[{
        SubscriptBox["\[PartialD]", 
         StyleBox["x", "TI"]], 
        StyleBox["y", "TI"]}], 
       RowBox[{
        ButtonBox["D",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/D"], "[", 
        RowBox[{
         StyleBox["y", "TI"], ",", 
         StyleBox["x", "TI"]}], "]"}]},
      {
       RowBox[{
        SubscriptBox["\[PartialD]", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}]], 
        StyleBox["y", "TI"]}], 
       RowBox[{
        ButtonBox["D",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/D"], "[", 
        RowBox[{
         StyleBox["y", "TI"], ",", 
         StyleBox["x", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["min", "TI"]], 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["max", "TI"]]], 
        RowBox[{
         StyleBox["y", "TI"], "\[MediumSpace]", 
         RowBox[{"\[DifferentialD]", 
          StyleBox["x", "TI"]}]}]}], 
       RowBox[{
        ButtonBox["Integrate",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Integrate"], "[", 
        RowBox[{
         StyleBox["y", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["x", "TI"], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["min", "TI"]], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["max", "TI"]]}], "}"}]}], "]"}]},
      {
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["min", "TI"]], 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["max", "TI"]]], 
        RowBox[{
         StyleBox["y", "TI"], "\[MediumSpace]", 
         StyleBox["w", "TI"], 
         FractionBox["\[DifferentialD]", 
          StyleBox[
           RowBox[{"x", "z"}], "TI"]]}]}], 
       RowBox[{
        ButtonBox["Integrate",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Integrate"], "[", 
        RowBox[{
         RowBox[{
          StyleBox["y", "TI"], " ", 
          RowBox[{
           StyleBox["w", "TI"], "/", 
           StyleBox["z", "TI"]}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["x", "TI"], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["min", "TI"]], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["max", "TI"]]}], "}"}]}], "]"}]},
      {
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{
          StyleBox["x", "TI"], "=", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]]}], 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["max", "TI"]],
         LimitsPositioning->False], 
        StyleBox["y", "TI"]}], 
       RowBox[{
        ButtonBox["Sum",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Sum"], "[", 
        RowBox[{
         StyleBox["y", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["x", "TI"], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["min", "TI"]], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["max", "TI"]]}], "}"}]}], "]"}]},
      {
       RowBox[{
        UnderoverscriptBox["\[Product]", 
         RowBox[{
          StyleBox["x", "TI"], "=", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]]}], 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["max", "TI"]],
         LimitsPositioning->False], 
        StyleBox["y", "TI"]}], 
       RowBox[{
        ButtonBox["Product",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Product"], "[", 
        RowBox[{
         StyleBox["y", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["x", "TI"], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["min", "TI"]], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["max", "TI"]]}], "}"}]}], "]"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->8034],

Cell["\<\
Two\[Hyphen]dimensional input forms with built\[Hyphen]in evaluation rules. \
\>", "Caption",
 CellID->32133],

Cell[TextData[{
 "Any array of expressions represented by a ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " is interpreted as a list of lists. Even if the ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " has only one row, the interpretation is still ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["a", "2"], ",", "\[Ellipsis]"}], "}"}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->25191],

Cell[TextData[{
 "In the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     SubscriptBox["x", 
      StyleBox["min", "TI",
       FontSlant->"Italic"]], 
     SubscriptBox["x", 
      StyleBox["max", "TI",
       FontSlant->"Italic"]]], 
    RowBox[{"y", "w", 
     FractionBox[
      RowBox[{"\[DifferentialD]", "x"}], "z"]}]}], TraditionalForm]], 
  "InlineMath"],
 " the limits ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["min", "TI"]], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", 
    StyleBox["max", "TI"]], TraditionalForm]], "InlineMath"],
 " can be omitted, as can ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["w", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->9301],

Cell[BoxData[GridBox[{
   {GridBox[{
      {
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["y", "TI"]], 
       RowBox[{
        ButtonBox["Subscript",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Subscript"], "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "]"}]},
      {
       SubscriptBox[
        StyleBox["x", "TI"], "+"], 
       RowBox[{
        ButtonBox["SubPlus",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SubPlus"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       SubscriptBox[
        StyleBox["x", "TI"], "-"], 
       RowBox[{
        ButtonBox["SubMinus",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SubMinus"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       SubscriptBox[
        StyleBox["x", "TI"], "*"], 
       RowBox[{
        ButtonBox["SubStar",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SubStar"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       SuperscriptBox[
        StyleBox["x", "TI"], "+"], 
       RowBox[{
        ButtonBox["SuperPlus",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SuperPlus"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       SuperscriptBox[
        StyleBox["x", "TI"], "-"], 
       RowBox[{
        ButtonBox["SuperMinus",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SuperMinus"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       SuperscriptBox[
        StyleBox["x", "TI"], "*"], 
       RowBox[{
        ButtonBox["SuperStar",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SuperStar"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       SuperscriptBox[
        StyleBox["x", "TI"], "\[Dagger]"], 
       RowBox[{
        ButtonBox["SuperDagger",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/SuperDagger"], "[", 
        StyleBox["x", "TI"], "]"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}], GridBox[{
      {
       OverscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["y", "TI"]], 
       RowBox[{
        ButtonBox["Overscript",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Overscript"], "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "]"}]},
      {
       UnderscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["y", "TI"]], 
       RowBox[{
        ButtonBox["Underscript",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Underscript"], "[", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "]"}]},
      {
       OverscriptBox[
        StyleBox["x", "TI"], "_"], 
       RowBox[{
        ButtonBox["OverBar",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/OverBar"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       OverscriptBox[
        StyleBox["x", "TI"], "\[RightVector]"], 
       RowBox[{
        ButtonBox["OverVector",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/OverVector"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       OverscriptBox[
        StyleBox["x", "TI"], "~"], 
       RowBox[{
        ButtonBox["OverTilde",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/OverTilde"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       OverscriptBox[
        StyleBox["x", "TI"], "^"], 
       RowBox[{
        ButtonBox["OverHat",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/OverHat"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       OverscriptBox[
        StyleBox["x", "TI"], "."], 
       RowBox[{
        ButtonBox["OverDot",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/OverDot"], "[", 
        StyleBox["x", "TI"], "]"}]},
      {
       UnderscriptBox[
        StyleBox["x", "TI"], "_"], 
       RowBox[{
        ButtonBox["UnderBar",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/UnderBar"], "[", 
        StyleBox["x", "TI"], "]"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
       "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]}
  }]], "DoubleBox",
 CellFrame->0.5,
 CellID->413152760],

Cell["\<\
Two\[Hyphen]dimensional input forms without built\[Hyphen]in evaluation \
rules. \
\>", "Caption",
 CellID->25387],

Cell[TextData[{
 "There is no issue of precedence for forms such as ",
 Cell[BoxData[
  FormBox[
   SqrtBox["x"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "^"], TraditionalForm]], "InlineMath"],
 " in which operands are effectively spanned by the operator. For forms such \
as ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "y"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "\[Dagger]"], TraditionalForm]], "InlineMath"],
 " a left precedence does need to be specified, so such forms are included in \
the main table of precedences above. "
}], "Text",
 CellID->27879]
}, Open  ]],

Cell[CellGroupData[{

Cell["Input of Boxes", "Section",
 CellTags->{"SA.2.9", "9.1"},
 CellID->30487],

Cell[BoxData[GridBox[{
   {Cell["\[FilledSmallSquare] Use a palette", "TableText"]},
   {Cell["\[FilledSmallSquare] Use control keys", "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->5943],

Cell["Ways to input boxes. ", "Caption",
 CellID->15347],

Cell[CellGroupData[{

Cell["Control Keys", "Subsection",
 CellID->18584],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["2", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["@", "KeyEvent"]
    }], "TableText"], Cell["square root", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["5", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["%", "KeyEvent"]
    }], "TableText"], Cell[
    "switch to alternate position (e.g. subscript to superscript)", 
     "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["6", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["^", "KeyEvent"]
    }], "TableText"], Cell["superscript", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["7", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["&", "KeyEvent"]
    }], "TableText"], Cell["overscript", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["9", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["(", "KeyEvent"]
    }], "TableText"], Cell[
    "begin a new cell within an existing cell", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["0", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox[")", "KeyEvent"]
    }], "TableText"], Cell[
    "end a new cell within an existing cell", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["-", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["_", "KeyEvent"]
    }], "TableText"], Cell["subscript", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["=", "KeyEvent"],
     " or ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Plus", "KeyEvent"]
    }], "TableText"], Cell["underscript", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Return", "KeyEvent"]
    }], "TableText"], Cell["create a new row in a table", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox[",", "KeyEvent"]
    }], "TableText"], Cell["create a new column in a table", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox[".", "KeyEvent"]
    }], "TableText"], Cell["expand current selection", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["/", "KeyEvent"]
    }], "TableText"], Cell["fraction", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Space", "KeyEvent"]
    }], "TableText"], Cell[
    "return from current position or state", "TableText"]},
   {Cell[TextData[{
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["LeftArrow", "KeyEvent"],
     ", ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["RightArrow", "KeyEvent"],
     ", ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["UpArrow", "KeyEvent"],
     ", ",
     StyleBox["Ctrl", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["DownArrow", "KeyEvent"]
    }], "TableText"], "\[SpanFromLeft]"},
   {"", Cell[
    "move an object by minimal increments on the screen", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->21389],

Cell["Standard control keys. ", "Caption",
 CellID->31668],

Cell["\<\
On English\[Hyphen]language keyboards both forms will work where alternates \
are given. On other keyboards the first form should work but the second may \
not. \
\>", "Text",
 CellID->21788]
}, Open  ]],

Cell[CellGroupData[{

Cell["Boxes Constructed from Text", "Subsection",
 CellID->3198],

Cell[TextData[{
 "When textual input that you give is used to construct boxes, as in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " cells in a notebook, the input is handled slightly differently from when \
it is fed directly to the kernel. "
}], "Text",
 CellID->12280],

Cell[TextData[{
 "The input is broken into ",
 StyleBox["tokens",
  FontSlant->"Italic"],
 ", and then each token is included in the box structure as a separate \
character string. Thus, for example, ",
 Cell[BoxData[
  RowBox[{"xx", "+", "yyy"}]], "InlineFormula"],
 " is broken into the tokens ",
 Cell[BoxData["\"\<xx\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<+\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<yyy\>\""], "InlineFormula"],
 ". "
}], "Text",
 CellID->27479],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "\[FilledSmallSquare] symbol name (e.g. ",
     Cell[BoxData["x123"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] number (e.g. ",
     Cell[BoxData["12.345"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] operator (e.g. ",
     Cell[BoxData["+="], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] spacing (e.g. ",
     Cell[BoxData["\[SpaceIndicator]"], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell[TextData[{
     "\[FilledSmallSquare] character string (e.g. ",
     Cell[BoxData["\"\<text\>\""], "InlineFormula"],
     ")"
    }], "TableText"]}
  }]], "FramedBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32707],

Cell["Types of tokens in text used to construct boxes. ", "Caption",
 CellID->1813],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " is constructed to hold each operator and its operands. The nesting of ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " objects is determined by the precedence of the operators in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax. "
}], "Text",
 CellID->6860],

Cell["\<\
Note that spacing characters are not automatically discarded. Instead, each \
sequence of consecutive such characters is made into a separate token. \
\>", "Text",
 CellID->15447]
}, Open  ]],

Cell[CellGroupData[{

Cell["String\[Hyphen]Based Input", "Subsection",
 CellID->29846],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", "(", 
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]", ")"}], Cell[
    "input raw boxes", "TableText"]},
   {
    RowBox[{"\[Backslash]", "!", "\[Backslash]", "(", 
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]", ")"}], Cell[
    "input and interpret boxes", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7271],

Cell["Inputting raw and interpreted boxes. ", "Caption",
 CellID->32182],

Cell[TextData[{
 "Any textual input that you give between ",
 Cell[BoxData["\\("], "InlineFormula"],
 " and ",
 Cell[BoxData["\\)"], "InlineFormula"],
 " is taken to specify boxes to construct. The boxes are only interpreted if \
you specify with ",
 Cell[BoxData["\\!"], "InlineFormula"],
 " that this should be done. Otherwise ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\\^", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " is left for example as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", and is not converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->12344],

Cell[TextData[{
 "Within the outermost ",
 Cell[BoxData[
  RowBox[{"\\(", 
   RowBox[{
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 ", further ",
 Cell[BoxData[
  RowBox[{"\\(", 
   RowBox[{
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 " specify grouping and lead to the insertion of ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 " objects. "
}], "Text",
 CellID->13142],

Cell[BoxData[GridBox[{
   {
    RowBox[{"\[Backslash]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox[
        StyleBox["box", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["box", "TI"], 
        StyleBox["2", "TR"]], ",", 
       RowBox[{
        StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}]}], ")"}]}], 
    RowBox[{
     ButtonBox["RowBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RowBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], "\[Backslash]", "^", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["SuperscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], "\[Backslash]", "_", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["SubscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], "\[Backslash]", "_", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], "\[Backslash]", "%", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["SubsuperscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubsuperscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["3", "TR"]], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], "\[Backslash]", "&", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["OverscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], "\[Backslash]", "+", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["UnderscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], "\[Backslash]", "+", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], "\[Backslash]", "%", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["3", "TR"]]}], 
    RowBox[{
     ButtonBox["UnderoverscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderoverscriptBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["3", "TR"]], "]"}]},
   {
    RowBox[{
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], "\[Backslash]", "/", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]]}], 
    RowBox[{
     ButtonBox["FractionBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FractionBox"], "[", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["box", "TI"], 
      StyleBox["2", "TR"]], "]"}]},
   {
    RowBox[{"\\@", 
     StyleBox["box", "TI"]}], 
    RowBox[{
     ButtonBox["SqrtBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SqrtBox"], "[", 
     StyleBox["box", "TI"], "]"}]},
   {
    RowBox[{
     StyleBox["form", "TI"], "\[Backslash]", "`", " ", 
     StyleBox["box", "TI"]}], 
    RowBox[{
     ButtonBox["FormBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormBox"], "[", 
     StyleBox["box", "TI"], ",", 
     StyleBox["form", "TI"], "]"}]},
   {
    RowBox[{"\\*", 
     StyleBox["input", "TI"]}], Cell[TextData[{
     "construct box by interpreting ",
     Cell[BoxData[
      StyleBox["input", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{"\\", "\[SpaceIndicator]"}], Cell[
    "insert a space", "TableText"]},
   {"\\n", Cell["insert a newline", "TableText"]},
   {
    RowBox[{"\\", "t"}], Cell[
    "indent at the beginning of a line", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     True, True, False, {False}, False}, "RowsIndexed" -> {}}},
 CellID->16448],

Cell["\<\
String\[Hyphen]based ways of constructing raw boxes. \
\>", "Caption",
 CellID->25636],

Cell[TextData[{
 "In string\[Hyphen]based input between ",
 Cell[BoxData["\\("], "InlineFormula"],
 " and ",
 Cell[BoxData["\\)"], "InlineFormula"],
 " spaces, tabs and newlines are discarded. ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "\[SpaceIndicator]"}]], "InlineFormula"],
 " can be used to insert a single space. Special spacing characters such as \
",
 Cell[BoxData[
  ButtonBox["\\[ThinSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ThinSpace"]], "InlineCharacterName"],
 ", ",
 Cell[BoxData[
  ButtonBox["\\[ThickSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/ThickSpace"]], "InlineCharacterName"],
 " or ",
 Cell[BoxData[
  ButtonBox["\\[NegativeThinSpace]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/NegativeThinSpace"]], 
  "InlineCharacterName"],
 " are not discarded. "
}], "Text",
 CellID->12353],

Cell[TextData[{
 "When you input typesetting forms into a string, the internal representation \
of the string uses the above forms. The front end displays the typeset form, \
but uses the ",
 Cell[BoxData[
  RowBox[{"\\(", 
   RowBox[{
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], "\[Backslash]"}], ")"}]}]], 
  "InlineFormula"],
 " notation when saving the content to a file or when sending the string to \
the kernel for evaluation."
}], "Text",
 CellID->19615526]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Extent of Input Expressions", "Section",
 CellTags->{"SA.2.10", "10.1"},
 CellID->14153],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will treat all input that you give on a single line as being part of the \
same expression. "
}], "Text",
 CellID->22151],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " allows a single expression to continue for several lines. In general, it \
treats the input that you give on successive lines as belonging to the same \
expression whenever no complete expression would be formed without doing \
this. "
}], "Text",
 CellID->31794],

Cell[TextData[{
 "Thus, for example, if one line ends with ",
 Cell[BoxData["="], "InlineFormula"],
 ", then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will assume that the expression must continue on the next line. It will do \
the same if for example parentheses or other matchfix operators remain open \
at the end of the line. "
}], "Text",
 CellID->5041],

Cell[TextData[{
 "If at the end of a particular line the input you have given so far \
corresponds to a complete expression, then ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will normally begin immediately to process that expression. "
}], "Text",
 CellID->15264],

Cell[TextData[{
 "You can however explicitly tell ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that a particular expression is incomplete by putting a \[Backslash] or a \
",
 Cell[BoxData[
  FormBox["\[Continuation]", TraditionalForm]], "InlineMath"],
 " (",
 Cell[BoxData[
  ButtonBox["\\[Continuation]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/character/Continuation"]], "InlineCharacterName"],
 ") at the end of the line. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will then include the next line in the same expression, discarding any \
spaces or tabs that occur at the beginning of that line. "
}], "Text",
 CellID->8383]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Input", "Section",
 CellTags->{"SA.2.11", "11.1"},
 CellID->20851],

Cell[BoxData[GridBox[{
   {
    RowBox[{"?", 
     StyleBox["symbol", "TI"]}], Cell["get information", "TableText"]},
   {
    RowBox[{"??", 
     StyleBox["symbol", "TI"]}], Cell["get more information", "TableText"]},
   {
    RowBox[{"?", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], 
      StyleBox["\[Ellipsis]", "TR"], "  "}]}], Cell[
    "get information on several objects", "TableText"]},
   {
    RowBox[{"!", 
     StyleBox["command", "TI"]}], Cell[
    "execute an external command (text-based interface only)", "TableText"]},
   {
    RowBox[{"!!", 
     StyleBox["file", "TI"]}], Cell["\<\
display the contents of an external file (text-based interface only)\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32271],

Cell["Special input lines. ", "Caption",
 CellID->23283],

Cell[TextData[{
 "In most implementations of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you can give a line of special input anywhere in your input. The only \
constraint is that the special input must start at the beginning of a line."
}], "Text",
 CellID->4364],

Cell[TextData[{
 "Some implementations of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may not allow you to execute external commands using ",
 Cell[BoxData[
  RowBox[{"!", 
   StyleBox["command", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->27038]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End Files", "Section",
 CellTags->{"SA.2.12", "12.1"},
 CellID->17916],

Cell[TextData[{
 "Notebook files as well as front end initialization files can contain a \
subset of standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language syntax. This syntax includes: "
}], "Text",
 CellID->6716],

Cell[TextData[{
 "Any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression in ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25328],

Cell[TextData[{
 "Lists in ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["\[Ellipsis]", "TR"], "}"}]], "InlineFormula"],
 " form. The operators ",
 Cell[BoxData["->"], "InlineFormula"],
 ", ",
 Cell[BoxData[":>"], "InlineFormula"],
 " and ",
 Cell[BoxData["&"], "InlineFormula"],
 ". Function slots in ",
 Cell[BoxData["#"], "InlineFormula"],
 " form."
}], "Notes",
 CellID->625477406],

Cell[TextData[{
 "Various ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " operators such as ",
 Cell[BoxData["+"], "InlineFormula"],
 ", ",
 Cell[BoxData["*"], "InlineFormula"],
 ", ",
 Cell[BoxData[";"], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->93938196],

Cell[TextData[{
 "Special characters in ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{"[", 
    StyleBox["Name", "TI"], "]"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{":", 
    StyleBox["nnnn", "TI"]}]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", 
   RowBox[{".", 
    StyleBox["xx", "TI"]}]}]], "InlineFormula"],
 " form."
}], "Notes",
 CellID->130229530],

Cell[TextData[{
 "String representation of boxes involving ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", "("}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"\[Backslash]", ")"}]], "InlineFormula"],
 " and other backslash operators."
}], "Notes",
 CellID->219271328],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " comments delimited by ",
 Cell[BoxData["(*"], "InlineFormula"],
 " and ",
 Cell[BoxData["*)"], "InlineFormula"],
 "."
}], "Notes",
 CellID->371208823],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->234108159],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StringRepresentationOfBoxes"]], "RelatedTutorials",
 CellID->1952089178]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Input Syntax - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 20.8800446}", "context" -> "", 
    "keywords" -> {
     "`", "~~", ";;", "::", ">>>", "<>", ">>", "<<", "<=", "<", ">=", ">", 
      ";", "}", "{", "]]", "[[", "|", "||", "&&", "&", "___", "__", "_", ":", 
      "/=", "*=", "-=", "+=", "--", "++", "**", "##", "#", "/;", "//.", "/.", 
      "@@@", "@@", "//@", "/@", "@", "...", "..", "%%", "%", "=!=", "!=", 
      "===", "==", "/:", "^:=", "^=", "=.", ":=", "=", ":>", "->", "^^", "/", 
      "!!", "!", "??", "?", "(*", "*)", "application", "backslash", "bases", 
      "binary numbers", "boxes", "braces", "bracketed objects", "brackets", 
      "comments", "context mark", "context separator", "continuation", 
      "curly braces", "digits", "empty list", "exponential notation", 
      "expressions", "function application", "heads", "hexadecimal numbers", 
      "hyphenation", "information", "initialization", "input", "input forms", 
      "input raw boxes", "lexical analysis", "line feed", "line continuation",
       "linear syntax", "list brackets", "lists", "literal backslash", 
      "literal quotes", "mantissa", "Matchfix operators", 
      "Multiline expressions", "named characters", "newlines", 
      "\\nn (special characters)", "\\nnn (special characters)", 
      "\\nnnn (special characters)", "notation", "notebook files", 
      "null list", "number base", "number mark", "number marks", "numbers", 
      "numerical input", "octal numbers", "parentheses", "parser", "pasting", 
      "precision", "return characters", "scientific notation", "shell escape",
       "shell escapes", "show file", "standard form", "string delimiters", 
      "string input", "syntax", "ternary numbers", "tokens", 
      "two-dimensional string"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Typical ways to enter characters. All printable ASCII characters can be \
entered directly. Those that are not alphanumeric are assigned explicit names \
in Mathematica, allowing them to be entered even on keyboards where they do \
not explicitly appear. Full names for non-alphanumeric printable ASCII \
characters. ", 
    "synonyms" -> {
     "A.2.1", "A.2.2", "A.2.3", "A.2.4", "A.2.5", "A.2.6", "A.2.7", "A.2.8", 
      "A.2.9", "A.2.10", "A.2.11", "A.2.12"}, "title" -> "Input Syntax", 
    "type" -> "Tutorial", "uri" -> "tutorial/InputSyntax"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "SA.2.1"->{
  Cell[4570, 106, 84, 2, 70, "Section",
   CellTags->{"SA.2.1", "1.1"},
   CellID->29301]},
 "1.1"->{
  Cell[4570, 106, 84, 2, 70, "Section",
   CellTags->{"SA.2.1", "1.1"},
   CellID->29301]},
 "SA.2.2"->{
  Cell[14260, 430, 86, 2, 70, "Section",
   CellTags->{"SA.2.2", "2.1"},
   CellID->24487]},
 "2.1"->{
  Cell[14260, 430, 86, 2, 70, "Section",
   CellTags->{"SA.2.2", "2.1"},
   CellID->24487]},
 "SA.2.3"->{
  Cell[16389, 507, 81, 2, 70, "Section",
   CellTags->{"SA.2.3", "3.1"},
   CellID->1570]},
 "3.1"->{
  Cell[16389, 507, 81, 2, 70, "Section",
   CellTags->{"SA.2.3", "3.1"},
   CellID->1570]},
 "SA.2.4"->{
  Cell[19315, 601, 89, 2, 70, "Section",
   CellTags->{"SA.2.4", "4.1"},
   CellID->6562]},
 "4.1"->{
  Cell[19315, 601, 89, 2, 70, "Section",
   CellTags->{"SA.2.4", "4.1"},
   CellID->6562]},
 "SA.2.5"->{
  Cell[20863, 654, 71, 2, 70, "Section",
   CellTags->{"SA.2.5", "5.1"},
   CellID->7977]},
 "5.1"->{
  Cell[20863, 654, 71, 2, 70, "Section",
   CellTags->{"SA.2.5", "5.1"},
   CellID->7977]},
 "SA.2.6"->{
  Cell[27242, 875, 82, 2, 70, "Section",
   CellTags->{"SA.2.6", "6.1"},
   CellID->30109]},
 "6.1"->{
  Cell[27242, 875, 82, 2, 70, "Section",
   CellTags->{"SA.2.6", "6.1"},
   CellID->30109]},
 "SA.2.7"->{
  Cell[38989, 1310, 85, 2, 70, "Section",
   CellTags->{"SA.2.7", "7.1"},
   CellID->23301]},
 "7.1"->{
  Cell[38989, 1310, 85, 2, 70, "Section",
   CellTags->{"SA.2.7", "7.1"},
   CellID->23301]},
 "SA.2.8"->{
  Cell[183795, 6404, 100, 2, 70, "Section",
   CellTags->{"SA.2.8", "8.1"},
   CellID->15273]},
 "8.1"->{
  Cell[183795, 6404, 100, 2, 70, "Section",
   CellTags->{"SA.2.8", "8.1"},
   CellID->15273]},
 "SA.2.9"->{
  Cell[197739, 6895, 79, 2, 70, "Section",
   CellTags->{"SA.2.9", "9.1"},
   CellID->30487]},
 "9.1"->{
  Cell[197739, 6895, 79, 2, 70, "Section",
   CellTags->{"SA.2.9", "9.1"},
   CellID->30487]},
 "SA.2.10"->{
  Cell[215750, 7509, 98, 2, 70, "Section",
   CellTags->{"SA.2.10", "10.1"},
   CellID->14153]},
 "10.1"->{
  Cell[215750, 7509, 98, 2, 70, "Section",
   CellTags->{"SA.2.10", "10.1"},
   CellID->14153]},
 "SA.2.11"->{
  Cell[217722, 7576, 80, 2, 70, "Section",
   CellTags->{"SA.2.11", "11.1"},
   CellID->20851]},
 "11.1"->{
  Cell[217722, 7576, 80, 2, 70, "Section",
   CellTags->{"SA.2.11", "11.1"},
   CellID->20851]},
 "SA.2.12"->{
  Cell[219611, 7644, 82, 2, 70, "Section",
   CellTags->{"SA.2.12", "12.1"},
   CellID->17916]},
 "12.1"->{
  Cell[219611, 7644, 82, 2, 70, "Section",
   CellTags->{"SA.2.12", "12.1"},
   CellID->17916]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"SA.2.1", 225380, 7820},
 {"1.1", 225482, 7824},
 {"SA.2.2", 225587, 7828},
 {"2.1", 225690, 7832},
 {"SA.2.3", 225796, 7836},
 {"3.1", 225898, 7840},
 {"SA.2.4", 226003, 7844},
 {"4.1", 226105, 7848},
 {"SA.2.5", 226210, 7852},
 {"5.1", 226312, 7856},
 {"SA.2.6", 226417, 7860},
 {"6.1", 226520, 7864},
 {"SA.2.7", 226626, 7868},
 {"7.1", 226730, 7872},
 {"SA.2.8", 226837, 7876},
 {"8.1", 226943, 7880},
 {"SA.2.9", 227052, 7884},
 {"9.1", 227157, 7888},
 {"SA.2.10", 227266, 7892},
 {"10.1", 227374, 7896},
 {"SA.2.11", 227485, 7900},
 {"11.1", 227593, 7904},
 {"SA.2.12", 227704, 7908},
 {"12.1", 227812, 7912}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3870, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4495, 101, 50, 1, 70, "Title",
 CellID->1365697167],
Cell[CellGroupData[{
Cell[4570, 106, 84, 2, 70, "Section",
 CellTags->{"SA.2.1", "1.1"},
 CellID->29301],
Cell[4657, 110, 1352, 41, 70, "FramedBox",
 CellID->22363],
Cell[6012, 153, 68, 1, 70, "Caption",
 CellID->7721],
Cell[6083, 156, 308, 8, 70, "Text",
 CellID->3565],
Cell[6394, 166, 3399, 111, 70, "DoubleBox",
 CellID->17421],
Cell[9796, 279, 111, 3, 70, "Caption",
 CellID->23445],
Cell[9910, 284, 387, 11, 70, "Text",
 CellID->18610],
Cell[10300, 297, 1249, 39, 70, "DefinitionBox",
 CellID->16741],
Cell[11552, 338, 61, 1, 70, "Caption",
 CellID->15022],
Cell[11616, 341, 290, 8, 70, "Text",
 CellID->31812],
Cell[11909, 351, 340, 8, 70, "Text",
 CellID->29151],
Cell[12252, 361, 1887, 59, 70, "DefinitionBox",
 CellID->23015],
Cell[14142, 422, 81, 3, 70, "Caption",
 CellID->8055]
}, Open  ]],
Cell[CellGroupData[{
Cell[14260, 430, 86, 2, 70, "Section",
 CellTags->{"SA.2.2", "2.1"},
 CellID->24487],
Cell[14349, 434, 723, 25, 70, "Text",
 CellID->7030],
Cell[15075, 461, 174, 4, 70, "Text",
 CellID->22345],
Cell[15252, 467, 511, 18, 70, "Text",
 CellID->22716],
Cell[15766, 487, 586, 15, 70, "Text",
 CellID->28044]
}, Open  ]],
Cell[CellGroupData[{
Cell[16389, 507, 81, 2, 70, "Section",
 CellTags->{"SA.2.3", "3.1"},
 CellID->1570],
Cell[16473, 511, 1574, 41, 70, "DefinitionBox",
 CellID->8636],
Cell[18050, 554, 62, 1, 70, "Caption",
 CellID->9458],
Cell[18115, 557, 230, 5, 70, "Text",
 CellID->25967],
Cell[18348, 564, 295, 8, 70, "Text",
 CellID->8456],
Cell[18646, 574, 343, 12, 70, "Text",
 CellID->11531],
Cell[18992, 588, 286, 8, 70, "Text",
 CellID->29962]
}, Open  ]],
Cell[CellGroupData[{
Cell[19315, 601, 89, 2, 70, "Section",
 CellTags->{"SA.2.4", "4.1"},
 CellID->6562],
Cell[19407, 605, 1004, 30, 70, "DefinitionBox",
 CellID->3576],
Cell[20414, 637, 61, 1, 70, "Caption",
 CellID->4854],
Cell[20478, 640, 348, 9, 70, "Text",
 CellID->20072]
}, Open  ]],
Cell[CellGroupData[{
Cell[20863, 654, 71, 2, 70, "Section",
 CellTags->{"SA.2.5", "5.1"},
 CellID->7977],
Cell[20937, 658, 2584, 82, 70, "DefinitionBox",
 CellID->11457],
Cell[23524, 742, 60, 1, 70, "Caption",
 CellID->24385],
Cell[23587, 745, 948, 29, 70, "Text",
 CellID->19293],
Cell[24538, 776, 335, 11, 70, "Text",
 CellID->31716],
Cell[24876, 789, 202, 6, 70, "Text",
 CellID->19628],
Cell[25081, 797, 463, 16, 70, "Text",
 CellID->12394],
Cell[25547, 815, 1344, 42, 70, "Text",
 CellID->19291],
Cell[26894, 859, 311, 11, 70, "Text",
 CellID->3771]
}, Open  ]],
Cell[CellGroupData[{
Cell[27242, 875, 82, 2, 70, "Section",
 CellTags->{"SA.2.6", "6.1"},
 CellID->30109],
Cell[27327, 879, 256, 7, 70, "Text",
 CellID->17984],
Cell[27586, 888, 262, 7, 70, "Text",
 CellID->11969],
Cell[27851, 897, 584, 17, 70, "DefinitionBox",
 CellID->28978],
Cell[28438, 916, 103, 3, 70, "Caption",
 CellID->21617],
Cell[28544, 921, 168, 4, 70, "Text",
 CellID->4015],
Cell[28715, 927, 322, 12, 70, "Text",
 CellID->16626],
Cell[29040, 941, 3382, 112, 70, "DefinitionBox",
 CellID->3684],
Cell[32425, 1055, 105, 3, 70, "Caption",
 CellID->9168],
Cell[32533, 1060, 183, 6, 70, "Text",
 CellID->17906],
Cell[32719, 1068, 394, 14, 70, "Text",
 CellID->25928],
Cell[33116, 1084, 278, 11, 70, "Text",
 CellID->12097],
Cell[33397, 1097, 777, 29, 70, "Text",
 CellID->28118],
Cell[34177, 1128, 384, 12, 70, "Text",
 CellID->24390],
Cell[34564, 1142, 462, 18, 70, "Text",
 CellID->15199],
Cell[35029, 1162, 684, 22, 70, "Text",
 CellID->11785],
Cell[35716, 1186, 2000, 68, 70, "DefinitionBox",
 CellID->14486],
Cell[37719, 1256, 65, 1, 70, "Caption",
 CellID->19199],
Cell[37787, 1259, 190, 4, 70, "Text",
 CellID->12420],
Cell[37980, 1265, 972, 40, 70, "Text",
 CellID->20710]
}, Open  ]],
Cell[CellGroupData[{
Cell[38989, 1310, 85, 2, 70, "Section",
 CellTags->{"SA.2.7", "7.1"},
 CellID->23301],
Cell[39077, 1314, 662, 18, 70, "Text",
 CellID->24535],
Cell[39742, 1334, 807, 24, 70, "Text",
 CellID->9502],
Cell[40552, 1360, 1227, 34, 70, "DefinitionBox",
 CellID->8963],
Cell[41782, 1396, 86, 1, 70, "Caption",
 CellID->9564],
Cell[41871, 1399, 109671, 3930, 70, "PrecedenceTable",
 CellID->15012],
Cell[151545, 5331, 91, 1, 70, "Caption",
 CellID->13440],
Cell[151639, 5334, 6306, 230, 70, "DefinitionBox",
 CellID->6349],
Cell[157948, 5566, 93, 1, 70, "Caption",
 CellID->1951],
Cell[CellGroupData[{
Cell[158066, 5571, 56, 1, 70, "Subsection",
 CellID->11350],
Cell[158125, 5574, 1089, 35, 70, "Text",
 CellID->27606],
Cell[159217, 5611, 363, 15, 70, "Text",
 CellID->24795],
Cell[159583, 5628, 246, 6, 70, "Text",
 CellID->29171],
Cell[159832, 5636, 2884, 74, 70, "DoubleBox",
 CellID->3621],
Cell[162719, 5712, 106, 3, 70, "Caption",
 CellID->11088],
Cell[162828, 5717, 5979, 152, 70, "DoubleBox",
 CellID->7675],
Cell[168810, 5871, 111, 3, 70, "Caption",
 CellID->18725]
}, Open  ]],
Cell[CellGroupData[{
Cell[168958, 5879, 80, 1, 70, "Subsection",
 CellID->22807],
Cell[169041, 5882, 1377, 42, 70, "Text",
 CellID->25628]
}, Open  ]],
Cell[CellGroupData[{
Cell[170455, 5929, 60, 1, 70, "Subsection",
 CellID->1265],
Cell[170518, 5932, 1218, 38, 70, "Text",
 CellID->17786]
}, Open  ]],
Cell[CellGroupData[{
Cell[171773, 5975, 72, 1, 70, "Subsection",
 CellID->8373],
Cell[171848, 5978, 1220, 39, 70, "Text",
 CellID->26289],
Cell[173071, 6019, 726, 25, 70, "Text",
 CellID->17185],
Cell[173800, 6046, 271, 8, 70, "Text",
 CellID->16981]
}, Open  ]],
Cell[CellGroupData[{
Cell[174108, 6059, 63, 1, 70, "Subsection",
 CellID->26655],
Cell[174174, 6062, 367, 11, 70, "Text",
 CellID->10687],
Cell[174544, 6075, 642, 12, 70, "FramedBox",
 CellID->13394],
Cell[175189, 6089, 73, 1, 70, "Caption",
 CellID->11506],
Cell[175265, 6092, 715, 27, 70, "Text",
 CellID->9716],
Cell[175983, 6121, 361, 10, 70, "Text",
 CellID->20091],
Cell[176347, 6133, 378, 7, 70, "Text",
 CellID->9651],
Cell[176728, 6142, 1115, 39, 70, "FramedBox",
 CellID->19287],
Cell[177846, 6183, 67, 1, 70, "Caption",
 CellID->16242]
}, Open  ]],
Cell[CellGroupData[{
Cell[177950, 6189, 53, 1, 70, "Subsection",
 CellID->16182],
Cell[178006, 6192, 380, 11, 70, "Text",
 CellID->18971],
Cell[178389, 6205, 496, 17, 70, "Text",
 CellID->28552],
Cell[178888, 6224, 263, 10, 70, "Text",
 CellID->16095]
}, Open  ]],
Cell[CellGroupData[{
Cell[179188, 6239, 55, 1, 70, "Subsection",
 CellID->7221],
Cell[179246, 6242, 1926, 62, 70, "FramedBox",
 CellID->17301],
Cell[181175, 6306, 104, 3, 70, "Caption",
 CellID->27387]
}, Open  ]],
Cell[CellGroupData[{
Cell[181316, 6314, 58, 1, 70, "Subsection",
 CellID->18727],
Cell[181377, 6317, 969, 30, 70, "Text",
 CellID->27325]
}, Open  ]],
Cell[CellGroupData[{
Cell[182383, 6352, 48, 1, 70, "Subsection",
 CellID->26140],
Cell[182434, 6355, 1312, 43, 70, "Text",
 CellID->22091]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[183795, 6404, 100, 2, 70, "Section",
 CellTags->{"SA.2.8", "8.1"},
 CellID->15273],
Cell[183898, 6408, 7039, 237, 70, "DoubleBox",
 CellID->8034],
Cell[190940, 6647, 119, 3, 70, "Caption",
 CellID->32133],
Cell[191062, 6652, 650, 22, 70, "Text",
 CellID->25191],
Cell[191715, 6676, 850, 34, 70, "Text",
 CellID->9301],
Cell[192568, 6712, 4333, 149, 70, "DoubleBox",
 CellID->413152760],
Cell[196904, 6863, 124, 4, 70, "Caption",
 CellID->25387],
Cell[197031, 6869, 671, 21, 70, "Text",
 CellID->27879]
}, Open  ]],
Cell[CellGroupData[{
Cell[197739, 6895, 79, 2, 70, "Section",
 CellTags->{"SA.2.9", "9.1"},
 CellID->30487],
Cell[197821, 6899, 485, 11, 70, "FramedBox",
 CellID->5943],
Cell[198309, 6912, 56, 1, 70, "Caption",
 CellID->15347],
Cell[CellGroupData[{
Cell[198390, 6917, 50, 1, 70, "Subsection",
 CellID->18584],
Cell[198443, 6920, 4540, 130, 70, "DefinitionBox",
 CellID->21389],
Cell[202986, 7052, 58, 1, 70, "Caption",
 CellID->31668],
Cell[203047, 7055, 201, 5, 70, "Text",
 CellID->21788]
}, Open  ]],
Cell[CellGroupData[{
Cell[203285, 7065, 64, 1, 70, "Subsection",
 CellID->3198],
Cell[203352, 7068, 498, 14, 70, "Text",
 CellID->12280],
Cell[203853, 7084, 487, 16, 70, "Text",
 CellID->27479],
Cell[204343, 7102, 1109, 35, 70, "FramedBox",
 CellID->32707],
Cell[205455, 7139, 83, 1, 70, "Caption",
 CellID->1813],
Cell[205541, 7142, 492, 16, 70, "Text",
 CellID->6860],
Cell[206036, 7160, 189, 4, 70, "Text",
 CellID->15447]
}, Open  ]],
Cell[CellGroupData[{
Cell[206262, 7169, 64, 1, 70, "Subsection",
 CellID->29846],
Cell[206329, 7172, 649, 17, 70, "DefinitionBox",
 CellID->7271],
Cell[206981, 7191, 72, 1, 70, "Caption",
 CellID->32182],
Cell[207056, 7194, 966, 33, 70, "Text",
 CellID->12344],
Cell[208025, 7229, 551, 22, 70, "Text",
 CellID->13142],
Cell[208579, 7253, 5676, 201, 70, "DefinitionBox",
 CellID->16448],
Cell[214258, 7456, 96, 3, 70, "Caption",
 CellID->25636],
Cell[214357, 7461, 871, 27, 70, "Text",
 CellID->12353],
Cell[215231, 7490, 470, 13, 70, "Text",
 CellID->19615526]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[215750, 7509, 98, 2, 70, "Section",
 CellTags->{"SA.2.10", "10.1"},
 CellID->14153],
Cell[215851, 7513, 189, 6, 70, "Text",
 CellID->22151],
Cell[216043, 7521, 331, 8, 70, "Text",
 CellID->31794],
Cell[216377, 7531, 371, 10, 70, "Text",
 CellID->5041],
Cell[216751, 7543, 274, 7, 70, "Text",
 CellID->15264],
Cell[217028, 7552, 657, 19, 70, "Text",
 CellID->8383]
}, Open  ]],
Cell[CellGroupData[{
Cell[217722, 7576, 80, 2, 70, "Section",
 CellTags->{"SA.2.11", "11.1"},
 CellID->20851],
Cell[217805, 7580, 1160, 35, 70, "DefinitionBox",
 CellID->32271],
Cell[218968, 7617, 56, 1, 70, "Caption",
 CellID->23283],
Cell[219027, 7620, 276, 7, 70, "Text",
 CellID->4364],
Cell[219306, 7629, 268, 10, 70, "Text",
 CellID->27038]
}, Open  ]],
Cell[CellGroupData[{
Cell[219611, 7644, 82, 2, 70, "Section",
 CellTags->{"SA.2.12", "12.1"},
 CellID->17916],
Cell[219696, 7648, 232, 7, 70, "Text",
 CellID->6716],
Cell[219931, 7657, 246, 11, 70, "Notes",
 CellID->25328],
Cell[220180, 7670, 385, 15, 70, "Notes",
 CellID->625477406],
Cell[220568, 7687, 271, 12, 70, "Notes",
 CellID->93938196],
Cell[220842, 7701, 434, 18, 70, "Notes",
 CellID->130229530],
Cell[221279, 7721, 270, 9, 70, "Notes",
 CellID->219271328],
Cell[221552, 7732, 218, 9, 70, "Notes",
 CellID->371208823],
Cell[CellGroupData[{
Cell[221795, 7745, 72, 1, 70, "RelatedTutorialsSection",
 CellID->234108159],
Cell[221870, 7748, 183, 4, 70, "RelatedTutorials",
 CellID->1952089178]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[222092, 7757, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

