(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     71613,       1466]
NotebookOptionsPosition[     66975,       1324]
NotebookOutlinePosition[     69634,       1394]
CellTagsIndexPosition[     69540,       1388]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"The Structure of Graphics and Sound\"\>", 
       2->"\<\"Graphics and Sound\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inset" :> Documentation`HelpLookup["paclet:ref/Inset"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Inset\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Insetting Objects in Graphics", "Title",
 CellTags->{"S2.10.6", "6.1"},
 CellID->6502],

Cell[TextData[{
 ButtonBox["\"Redrawing and Combining Plots\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"],
 " described how you can make regular arrays of plots using ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid",
   ButtonNote->"ObsLink: GraphicsArray -> GraphicsGrid (Grid)"]], 
  "InlineFormula"],
 ". Using the ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " graphics primitive, however, you can combine and superimpose plots in any \
way. "
}], "Text",
 CellID->28541],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Inset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inset"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", " ", 
      StyleBox["pos", "TI"]}], "]"}], Cell[TextData[{
     "specifies that the inset should be placed at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in the graphic"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Inset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inset"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["pos", "TI"], 
      StyleBox[",", "TI"], 
      StyleBox[" ", "TI"], 
      StyleBox["opos", "TI"], 
      StyleBox[",", "TI"], 
      StyleBox[" ", "TI"], 
      StyleBox["size", "TI"]}], "]"}], Cell[TextData[{
     "render an object with a given ",
     Cell[BoxData[
      FormBox[
       StyleBox["size", "TI"], TraditionalForm]]],
     " so that point ",
     Cell[BoxData[
      StyleBox["opos", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " is positioned at point ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in the containing graphic"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Inset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Inset"], "[", 
     RowBox[{
      StyleBox["obj", "TI"], ",", 
      StyleBox["pos", "TI"], 
      StyleBox[",", "TI"], 
      StyleBox[" ", "TI"], 
      StyleBox["opos", "TI"], 
      StyleBox[",", "TI"], 
      StyleBox[" ", "TI"], 
      StyleBox["size", "TI"], 
      StyleBox[",", "TI"], 
      StyleBox[" ", "TI"], 
      StyleBox["dirs", "TI"]}], "]"}], Cell[TextData[{
     "specifies that the axes of the inset should be oriented in directions ",
     
     Cell[BoxData[
      StyleBox["dirs", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->7804],

Cell["Creating an inset. ", "Caption",
 CellID->25573],

Cell["Here is a plot. ", "MathCaption",
 CellID->1569328037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "x"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"ImageSize", "\[Rule]", "200"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"Background", "\[Rule]", "LightYellow"}]}], "]"}]}]], "Input",
 CellLabel->"In[34]:=",
 CellID->1842620327],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->25771404]
}, Open  ]],

Cell["This creates a plot within a parametric plot.", "MathCaption",
 CellID->1859618796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Inset", "[", 
     RowBox[{"p1", ",", 
      RowBox[{"{", 
       RowBox[{".3", ",", 
        RowBox[{"-", ".5"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->111092728],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->11435515]
}, Open  ]],

Cell["\<\
Here is a three\[Hyphen]dimensional plot. \
\>", "MathCaption",
 CellID->10733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p3", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], " ", 
     RowBox[{"Exp", "[", "y", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11452],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->323003762]
}, Open  ]],

Cell["\<\
This creates a two\[Hyphen]dimensional graphics object which contains two \
sized copies of the three\[Hyphen]dimensional plot. \
\>", "MathCaption",
 CellID->12229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{"p3", ",", 
       RowBox[{"-", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], ",", "Center", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Inset", "[", 
      RowBox[{"p3", ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5"}], "}"}], ",", "Center", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->2224],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->224398532]
}, Open  ]],

Cell["Here are rotated and skewed plots inset in a graphic.", "MathCaption",
 CellID->2085025999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{"p1", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", "Center", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Inset", "[", 
     RowBox[{"p1", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0"}], "}"}], ",", "Center", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", "}"}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->1117583446],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->49499014]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can render plots, arbitrary 2D or 3D graphics, cells, and text within an \
",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 ". Notice that in general the display area for graphics objects will be \
sized so as to touch at least one pair of edges of the ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->9983],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->238159410],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "TutorialMoreAbout",
 CellID->15691519]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->77308027],

Cell[TextData[ButtonBox["The Structure of Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], \
"RelatedTutorials",
 CellID->1229394717],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "RelatedTutorials",\

 CellID->554462182]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Insetting Objects in Graphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["The Structure of Graphics and Sound", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TheStructureOfGraphicsAndSoundOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/LabelingTwoDimensionalGraphics"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/DensityAndContourPlots"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 23.9582484}", "context" -> "", 
    "keywords" -> {
     "combining plots", "plots", "rectangle", "subplots", "Windows"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"Redrawing and Combining Plots\" described how you can make regular \
arrays of plots using GraphicsGrid. Using the Inset graphics primitive, \
however, you can combine and superimpose plots in any way. Creating an inset. \
Here is a plot. ", "synonyms" -> {}, "title" -> 
    "Insetting Objects in Graphics", "type" -> "Tutorial", "uri" -> 
    "tutorial/InsettingObjectsInGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.10.6"->{
  Cell[2602, 77, 92, 2, 70, "Title",
   CellTags->{"S2.10.6", "6.1"},
   CellID->6502]},
 "6.1"->{
  Cell[2602, 77, 92, 2, 70, "Title",
   CellTags->{"S2.10.6", "6.1"},
   CellID->6502]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.10.6", 69329, 1377},
 {"6.1", 69428, 1381}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1977, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2602, 77, 92, 2, 70, "Title",
 CellTags->{"S2.10.6", "6.1"},
 CellID->6502],
Cell[2697, 81, 646, 19, 70, "Text",
 CellID->28541],
Cell[3346, 102, 2228, 73, 70, "DefinitionBox",
 CellID->7804],
Cell[5577, 177, 54, 1, 70, "Caption",
 CellID->25573],
Cell[5634, 180, 60, 1, 70, "MathCaption",
 CellID->1569328037],
Cell[CellGroupData[{
Cell[5719, 185, 538, 16, 47, "Input",
 CellID->1842620327],
Cell[6260, 203, 5154, 89, 150, "Output",
 Evaluatable->False,
 CellID->25771404]
}, Open  ]],
Cell[11429, 295, 89, 1, 70, "MathCaption",
 CellID->1859618796],
Cell[CellGroupData[{
Cell[11543, 300, 542, 18, 28, "Input",
 CellID->111092728],
Cell[12088, 320, 6487, 110, 197, "Output",
 Evaluatable->False,
 CellID->11435515]
}, Open  ]],
Cell[18590, 433, 89, 3, 70, "MathCaption",
 CellID->10733],
Cell[CellGroupData[{
Cell[18704, 440, 413, 14, 28, "Input",
 CellID->11452],
Cell[19120, 456, 21868, 363, 172, "Output",
 Evaluatable->False,
 CellID->323003762]
}, Open  ]],
Cell[41003, 822, 175, 4, 70, "MathCaption",
 CellID->12229],
Cell[CellGroupData[{
Cell[41203, 830, 641, 20, 47, "Input",
 CellID->2224],
Cell[41847, 852, 16789, 279, 201, "Output",
 Evaluatable->False,
 CellID->224398532]
}, Open  ]],
Cell[58651, 1134, 97, 1, 70, "MathCaption",
 CellID->2085025999],
Cell[CellGroupData[{
Cell[58773, 1139, 866, 26, 83, "Input",
 CellID->1117583446],
Cell[59642, 1167, 5983, 102, 237, "Output",
 Evaluatable->False,
 CellID->49499014]
}, Open  ]],
Cell[65640, 1272, 537, 17, 70, "Text",
 CellID->9983],
Cell[CellGroupData[{
Cell[66202, 1293, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->238159410],
Cell[66271, 1296, 169, 3, 70, "TutorialMoreAbout",
 CellID->15691519]
}, Open  ]],
Cell[CellGroupData[{
Cell[66477, 1304, 71, 1, 70, "RelatedTutorialsSection",
 CellID->77308027],
Cell[66551, 1307, 201, 5, 70, "RelatedTutorials",
 CellID->1229394717],
Cell[66755, 1314, 166, 4, 70, "RelatedTutorials",
 CellID->554462182]
}, Open  ]]
}, Open  ]],
Cell[66948, 1322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

