(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13837,        465]
NotebookOptionsPosition[      9500,        337]
NotebookOutlinePosition[     12491,        414]
CellTagsIndexPosition[     12399,        408]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "Uninstall" :> Documentation`HelpLookup["paclet:ref/Uninstall"], 
          "$Path" :> Documentation`HelpLookup["paclet:ref/$Path"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Install\"\>", 
       2->"\<\"Uninstall\"\>", 3->"\<\"$Path\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing Existing ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-Compatible Programs"
}], "Title",
 CellTags->{"S2.13.2", "2.1"},
 CellID->7549],

Cell[TextData[{
 "One of the most common uses of ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " is to allow you to call functions in an external program from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Once the external program has been set up, all you need do to be able to \
use it is to \[OpenCurlyDoubleQuote]install\[CloseCurlyDoubleQuote] it in \
your current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Text",
 CellID->13888],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}], Cell[TextData[{
     "install a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     "\[Hyphen]compatible external program"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Uninstall",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Uninstall"], "[", 
     StyleBox["link", "TI"], "]"}], Cell[
    "uninstall the program", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2823],

Cell[TextData[{
 "Setting up external programs with functions to be called from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->11825],

Cell[TextData[{
 "This installs a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "\[Hyphen]compatible external program called ",
 Cell[BoxData["bitprog"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->9251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Install", "[", "\"\<bitprog\>\"", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[1]:= ",
 CellID->6190],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"./bitprog\"\>", ",", "6", ",", "5"}], "]"}]], "Output", \
"ConversionLockdown",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->7639]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["BitShift"], "InlineFormula"],
 " is one of the functions inside ",
 Cell[BoxData["bitprog"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->32046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BitShift", "[", 
  RowBox[{"111", ",", "3"}], "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[2]:= ",
 CellID->3362],

Cell[BoxData["13"], "Output", "ConversionLockdown",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->5775]
}, Open  ]],

Cell[TextData[{
 "You can use it just as you would a function within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "MathCaption",
 CellID->17624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"BitShift", "[", 
    RowBox[{"111", ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3", ",", "8"}], "}"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellLabel->"In[3]:= ",
 CellID->14078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"13", ",", "6", ",", "3", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Output", "ConversionLockdown",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->4985]
}, Open  ]],

Cell[TextData[{
 "When you have a package written in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language a single version will run unchanged on any computer system. But \
external programs typically need to be compiled separately for every \
different type of computer. "
}], "Text",
 CellID->10103],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a convention of keeping versions of external programs in directories \
that are named after the types of computers on which they will run. And \
assuming that this convention has been followed, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " should always install the version of ",
 Cell[BoxData[
  StyleBox["prog", "TI"]], "InlineFormula"],
 " appropriate for the particular kind of computer that you are currently \
using. "
}], "Text",
 CellID->26781],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Install",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Install"], "[", "\"\<name`\>\"", "]"}], Cell[
    TextData[{
     "install a program found anywhere on ",
     Cell[BoxData[
      ButtonBox["$Path",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Path"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->377],

Cell["Using context names to specify programs to install. ", "Caption",
 CellID->26350],

Cell[TextData[{
 "When you ask to read in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language file using ",
 Cell[BoxData[
  RowBox[{"<<", 
   StyleBox[
    RowBox[{
     StyleBox["name", "TI"], "`"}]]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically search all directories in the list ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " in order to find a file with the appropriate name. Similarly, if you use \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"name\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically search all directories in ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " in order to find an external program with the name ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", "exe"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"name\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
 " allows you to install programs that are stored in a central directory \
without explicitly having to specify their location."
}], "Text",
 CellID->6048],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->619893903],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Installing Existing MathLink-Compatible Programs - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox[
        "MathLink and External Program Communication", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]], 
      "Text", FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/HowMathLinkIsUsed"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/\
SettingUpExternalFunctionsToBeCalledFromMathematica"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 26.9583252}", "context" -> "", 
    "keywords" -> {
     "exe files", "install", "LinkObject", "path", 
      "running external programs", "Uninstall", "path"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "One of the most common uses of MathLink is to allow you to call \
functions in an external program from within Mathematica. Once the external \
program has been set up, all you need do to be able to use it is to 'install' \
it in your current Mathematica session. Setting up external programs with \
functions to be called from within Mathematica. This installs a \
MathLink-compatible external program called bitprog. ", 
    "synonyms" -> {"2.13.2"}, "title" -> 
    "Installing Existing MathLink-Compatible Programs", "type" -> "Tutorial", 
    "uri" -> "tutorial/InstallingExistingMathLinkCompatiblePrograms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.13.2"->{
  Cell[2051, 61, 169, 7, 70, "Title",
   CellTags->{"S2.13.2", "2.1"},
   CellID->7549]},
 "2.1"->{
  Cell[2051, 61, 169, 7, 70, "Title",
   CellTags->{"S2.13.2", "2.1"},
   CellID->7549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.13.2", 12186, 397},
 {"2.1", 12286, 401}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1426, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2051, 61, 169, 7, 70, "Title",
 CellTags->{"S2.13.2", "2.1"},
 CellID->7549],
Cell[2223, 70, 483, 14, 70, "Text",
 CellID->13888],
Cell[2709, 86, 865, 27, 70, "DefinitionBox",
 CellID->2823],
Cell[3577, 115, 175, 6, 70, "Caption",
 CellID->11825],
Cell[3755, 123, 215, 8, 70, "MathCaption",
 CellID->9251],
Cell[CellGroupData[{
Cell[3995, 135, 135, 3, 28, "Input",
 CellID->6190],
Cell[4133, 140, 264, 8, 36, "Output",
 CellID->7639]
}, Open  ]],
Cell[4412, 151, 182, 6, 70, "MathCaption",
 CellID->32046],
Cell[CellGroupData[{
Cell[4619, 161, 147, 4, 28, "Input",
 CellID->3362],
Cell[4769, 167, 177, 5, 36, "Output",
 CellID->5775]
}, Open  ]],
Cell[4961, 175, 161, 6, 70, "MathCaption",
 CellID->17624],
Cell[CellGroupData[{
Cell[5147, 185, 267, 9, 70, "Input",
 CellID->14078],
Cell[5417, 196, 266, 8, 36, "Output",
 CellID->4985]
}, Open  ]],
Cell[5698, 207, 315, 8, 70, "Text",
 CellID->10103],
Cell[6016, 217, 674, 18, 70, "Text",
 CellID->26781],
Cell[6693, 237, 694, 21, 70, "DefinitionBox",
 CellID->377],
Cell[7390, 260, 87, 1, 70, "Caption",
 CellID->26350],
Cell[7480, 263, 1488, 50, 70, "Text",
 CellID->6048],
Cell[CellGroupData[{
Cell[8993, 317, 72, 1, 70, "RelatedTutorialsSection",
 CellID->619893903],
Cell[9068, 320, 378, 11, 70, "RelatedTutorials",
 CellID->239218697]
}, Open  ]]
}, Open  ]],
Cell[9473, 335, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

