(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54057,       1914]
NotebookOptionsPosition[     31710,       1164]
NotebookOutlinePosition[     44610,       1569]
CellTagsIndexPosition[     44119,       1547]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"System Administration for Network Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
         "System Administration for Single-User Licenses" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]\
}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"System Administration for Network Licenses\"\>", 
      2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on Unix and Linux"
}], "Title",
 CellTags->{"b:3.0", "net: 1"},
 CellID->356726414],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for Network Licenses"
}], "Section",
 CellTags->{"i:1a", "b:3.0", "net: 1"},
 CellID->653439790],

Cell[CellGroupData[{

Cell["Requirements", "Subsection",
 CellTags->{"b:3.3", "i:14", "net: 1"},
 CellID->588938517],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is available for Windows, Unix, Linux, and Mac OS X. For a complete list \
of platform availability, visit ",
 ButtonBox["www.wolfram.com/products/mathematica/platforms.html",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.wolfram.com/products/mathematica/platforms.html"], 
    None}],
 ". Any supported machine can act as a client for running ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", provided the following two conditions are met: "
}], "Text",
 CellTags->{"b:3.3", "i:15"},
 CellID->376880962],

Cell[TextData[{
 "The client has access to the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " files, either locally or from a file server on the network."
}], "BulletedText",
 CellTags->"b:3.3",
 CellID->779467028],

Cell[CellGroupData[{

Cell[TextData[{
 "The license server running ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " is available on the TCP/IP network."
}], "BulletedText",
 CellTags->"b:3.3",
 CellID->774837737],

Cell["\<\
A license server can also function as its own client. However, this is not \
recommended. If the machine has to be rebooted for any reason, the serving of \
licenses to all other clients on the network may be disrupted. \
\>", "Text",
 CellTags->"b:3.3",
 CellID->451522550],

Cell[TextData[{
 "Before you install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as a license server client, ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " should already be installed and running on a license server on the network \
(see Installing ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "on Windows and Installing ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " on Unix, Linux, and Mac OS X for details). To complete the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation, you will need to know the name or IP address of the license \
server running ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->"b:3.3",
 CellID->164620833],

Cell[TextData[{
 "To install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on Unix and Linux, you may need ",
 StyleBox["root", "InlineCode"],
 " privileges. "
}], "Text",
 CellTags->"b:3.1",
 CellID->175429623]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "To install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "Subsection",
 CellID->49441506],

Cell[TextData[{
 "Mount the CD. For information on mounting a CD, see \"",
 ButtonBox["Mounting a CD on Unix and Linux\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MountingACDOnUnixAndLinux"],
 "."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:3.1",
 CellID->84795167],

Cell[TextData[{
 StyleBox["Note:",
  FontWeight->"Bold"],
 " This step may not be required on some Linux and Unix platforms, as some \
operating systems automatically handle mounting."
}], "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->220765989],

Cell[TextData[{
 "Change directory to /",
 Cell[BoxData[
  StyleBox["cdrom", "TI"]], "InlineFormula"],
 "/Unix/Installer. Note that the exact location of the CD mount point might \
be different for your platform."
}], "ItemizedText",
 CellTags->"b:3.1",
 CellID->356896806],

Cell[TextData[{
 StyleBox["cd /", "InlineCode"],
 StyleBox["cdrom", "TI"],
 StyleBox["/Unix/Installer", "InlineCode"]
}], "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->126247212],

Cell["Run the installer.", "ItemizedText",
 CellTags->"b:3.1",
 CellID->603935396],

Cell[CellGroupData[{

Cell[TextData[StyleBox["./MathInstaller", "InlineCode"]], \
"ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->38437854],

Cell["\<\
-----------------------------------------------------------------
                  Mathematica 6.0 Installer
-----------------------------------------------------------------

Copyright (c) 2007 Wolfram Research, Inc. All rights reserved.

WARNING: Mathematica 6.0 is protected by copyright law and international
treaties. Unauthorized reproduction or distribution may result in severe \
civil
and criminal penalties, and will be prosecuted to the maximum extent possible
under law.\
\>", "Program",
 CellTags->"b:3.1",
 CellID->18934754]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "You are asked to select the platforms for which you are doing the \
installation. Select one or more of the available options and press ",
 StyleBox["Enter", "KeyEvent"],
 " to continue."
}], "ItemizedText",
 CellTags->"b:3.1",
 CellID->141971909],

Cell["\<\
For which of the following platforms would you like to install 
Mathematica?\
\>", "Program",
 CellTags->"b:3.1",
 CellID->411620491],

Cell["\<\
Type your selection (multiple choices can be separated with spaces), or press
ENTER to select (1):\
\>", "Program",
 CellTags->"b:3.1",
 CellID->652040264]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The installer prompts you to specify the directory in which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should be installed. The default location is ",
 "/usr/local/Wolfram/Mathematica/6.0",
 ". Press ",
 StyleBox["Enter", "KeyEvent"],
 " to accept the default, or type in a new location and then press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "ItemizedText",
 CellTags->{"i:6", "b:3.1"},
 CellID->455233511],

Cell["\<\
Enter the installation directory, or press ENTER to select
/usr/local/Wolfram/Mathematica/6.0:\
\>", "Program",
 CellTags->"b:3.1",
 CellID->35678095]
}, Open  ]],

Cell[TextData[{
 StyleBox["Note:",
  FontWeight->"Bold"],
 " If you specify a directory that does not exist, the installer will give \
you the option of creating the directory. If a copy of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " already exists in the directory you specify, the installer will inform you \
before overwriting the files. "
}], "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->260380307],

Cell[CellGroupData[{

Cell["\<\
Once you have answered all the questions, the installer begins copying files \
from the CD to the directory you specified. The progress is indicated by a \
progress bar on the screen. \
\>", "ItemizedText",
 CellTags->"b:3.1",
 CellID->471205016],

Cell["\<\
Now installing...

[***************                                                    ]\
\>", "Program",
 CellTags->"b:3.1",
 CellID->94304291]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "You are asked for the location in which to copy the executable scripts. You \
should choose a directory that is present on each user\[CloseCurlyQuote]s \
PATH. The scripts are also installed in the ",
 StyleBox["Executables", "InlineCode"],
 " subdirectory of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation directory. Type a location or accept the default and press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "ItemizedText",
 CellTags->"b:3.1",
 CellID->55595927],

Cell["\<\
Type the directory path in which the Mathematica scripts will be created,
or press ENTER to select /usr/local/bin:\
\>", "Program",
 CellTags->"b:3.1",
 CellID->208447403]
}, Open  ]],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " The installer checks to see if any other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scripts exist in the specified directory. If they do, you are given the \
chance to rename the scripts. "
}], "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->354081158],

Cell[CellGroupData[{

Cell[TextData[{
 "You are given several options for configuring the password. Type ",
 StyleBox["2", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 " to run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a network license."
}], "ItemizedText",
 CellTags->"b:3.1",
 CellID->16633248],

Cell["\<\
Please choose how you want to configure the password for Mathematica 6.0.

(1) Single machine
    Install a password specific to this machine. Mathematica will launch
    and you can enter your password.

(2) Network license
    Obtain a license from a MathLM license server on your network each time
    Mathematica is launched.

(3) Enter license information later
    Input your password and register when you start Mathematica.

Type your selection, or press ENTER to select (1):2\
\>", "Program",
 CellTags->"b:3.1",
 CellID->234198761]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Type the hostname of the server running ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 ", as given by the ",
 StyleBox["hostname", "InlineCode"],
 " command. In some cases, this includes the domain name. Or, enter the IP \
address of the ",
 StyleBox[ButtonBox["MathLM",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mathlm"],
  FontSlant->"Italic"],
 " server. Press ",
 StyleBox["Enter", "KeyEvent"],
 " to continue. "
}], "ItemizedText",
 CellTags->"b:3.1",
 CellID->146274385],

Cell["\<\
Enter the hostname of the machine on which your MathLM license manager
is running:\
\>", "Program",
 CellTags->"b:3.1",
 CellID->180566055]
}, Open  ]],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " The installer does not attempt to verify the server name you type in. If \
you prefer, you may type any arbitrary text here and press ",
 StyleBox["Enter", "KeyEvent"],
 ". This creates the ",
 StyleBox["mathpass", "InlineCode"],
 " file with an invalid password entry. You may then edit the ",
 StyleBox["mathpass", "InlineCode"],
 " file manually to add a correct password later. More information on the ",
 StyleBox["mathpass", "InlineCode"],
 " file is given in \"",
 ButtonBox["Registration and Passwords\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->883460457],

Cell[CellGroupData[{

Cell[TextData[{
 "The installer creates the ",
 StyleBox["mathpass", "InlineCode"],
 " file and displays its location. The installation is now complete. "
}], "ItemizedText",
 CellTags->"b:3.1",
 CellID->243611692],

Cell["\<\
Configuring Network Password...

Adding password file entry to /usr/share/Mathematica/Licensing/mathpass.

See the Wolfram Mathematica Products System Administration Guide if you need \
to set up a sitewide password file.

Installation complete.\
\>", "Program",
 CellTags->"b:3.1",
 CellID->129750318]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for Single-User Licenses"
}], "Section",
 CellTags->{"i:10", "b:5.0.3", "net: 1"},
 CellID->147916860],

Cell[TextData[{
 "Follow these instructions to install a stand-alone copy of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that does not get a license from the license server. Depending on your \
license type, this may require contacting Wolfram Research to purchase \
additional licenses. "
}], "Text",
 CellTags->"b:6.0.3",
 CellID->590120230],

Cell[TextData[{
 "To run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", you must register with Wolfram Research and receive a password. See",
 " \"",
 ButtonBox["Registration and Passwords\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 ButtonBox[" ",
  BaseStyle->"GettingStartedLink",
  ButtonData:>{"Registration and Passwords"}],
 "for further information."
}], "Text",
 CellTags->"b:6.0.3",
 CellID->141537769],

Cell[TextData[{
 "To install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on Unix and Linux, you may need ",
 StyleBox["root", "InlineCode"],
 " privileges. "
}], "Text",
 CellTags->"b:6.0.3",
 CellID->20026948],

Cell[CellGroupData[{

Cell[TextData[{
 "To install a single-machine copy of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on Unix and Linux:"
}], "Subsection",
 CellTags->"b:6.0.3",
 CellID->9283949],

Cell[TextData[{
 "Mount the CD. For information on mounting a CD, see \"",
 ButtonBox["Mounting a CD on Unix and Linux\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MountingACDOnUnixAndLinux"],
 "."
}], "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.0.3",
 CellID->49879284],

Cell[TextData[{
 StyleBox["Note: ", "TB"],
 "This step may not be required on some Linux and Unix platforms, as some",
 " ",
 "operating systems automatically handle mounting."
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->33386777],

Cell[TextData[{
 "Change directory to /",
 Cell[BoxData[
  StyleBox["cdrom", "TI"]], "InlineFormula"],
 "/Unix/Installer. Note that the exact location of the CD mount point might \
be different for your platform."
}], "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->204472622],

Cell[TextData[{
 StyleBox["cd /", "InlineCode"],
 StyleBox["cdrom", "MO"],
 StyleBox["/Unix/Installer", "InlineCode"]
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->320513031],

Cell["Run the installer.", "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->423861716],

Cell[CellGroupData[{

Cell[TextData[StyleBox["./MathInstaller", "InlineCode"]], \
"ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->612250391],

Cell["\<\
----------------------------------------------------------------- 
                 Mathematica 6.0 Installer  \
-----------------------------------------------------------------

Copyright (c) 2007 Wolfram Research, Inc. All rights reserved.

WARNING: Mathematica 6.0 is protected by copyright law and international
treaties. Unauthorized reproduction or distribution may result in severe \
civil
and criminal penalties, and will be prosecuted to the maximum extent possible \

under law.\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->150339242]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "You are asked to select the platform for which you are doing the \
installation. Select one of the available options and press ",
 StyleBox["Enter", "KeyEvent"],
 " to continue. "
}], "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->270984937],

Cell["\<\
For which of the following platforms would you like to install 
Mathematica?\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->41603671],

Cell["\<\
Type your selection (multiple choices can be separated with spaces), or press
ENTER to select (1):\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->62385416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The installer prompts you to specify the directory in which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should be installed. The default location is ",
 "/usr/local/Wolfram/Mathematica/6.0",
 ". Press ",
 StyleBox["Enter", "KeyEvent"],
 " to accept the default, or type in a new location and then press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->34807422],

Cell["\<\
Enter the installation directory, or press ENTER to select
/usr/local/Wolfram/Mathematica/6.0:\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->735567131]
}, Open  ]],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " If you specify a directory that does not exist, the installer will give \
you the option of creating the directory. If a copy of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " already exists in the directory you specify, the installer will inform",
 " ",
 "you before overwriting the files. "
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->275552294],

Cell[CellGroupData[{

Cell["\<\
Once you have answered all the questions, the installer begins copying files \
from the CD to the directory you specified. The progress is indicated by a \
progress bar on the screen. \
\>", "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->12076595],

Cell["\<\
Now installing...
[***************                                                    ]\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->271803200]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "You are asked for the location in which to copy the executable scripts. You \
should choose a directory that is present on each user\[CloseCurlyQuote]s \
PATH. The scripts are also installed in the ",
 StyleBox["Executables", "InlineCode"],
 " subdirectory of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation directory. Type a location or accept the default and press ",
 StyleBox["Enter", "KeyEvent"],
 "."
}], "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->12073611],

Cell["\<\
Type the directory path in which the Mathematica scripts will be created,
or press ENTER to select /usr/local/bin:\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->104968151]
}, Open  ]],

Cell[TextData[{
 StyleBox["Note:", "TB"],
 " The installer checks to see if any other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " scripts exist in the specified directory. If they do, you are given the",
 " ",
 "chance to rename the scripts. "
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->153597371],

Cell[CellGroupData[{

Cell[TextData[{
 "You are given several options for configuring the password. Type ",
 StyleBox["1", "InlineCode"],
 " and press ",
 StyleBox["Enter", "KeyEvent"],
 " to run ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using a single-machine license."
}], "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->637572970],

Cell["\<\
Please choose how you want to configure the password for Mathematica 6.0.

(1) Single machine
    Install a password specific to this machine. Mathematica will launch
    and you can enter your password.

(2) Network license
    Obtain a license from a MathLM License Server on your network each time 
    Mathematica is launched.

(3) Enter license information later
    Input your password and register when you start Mathematica.

Type your selection, or press ENTER to select (1):1\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->159075424]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Your machine name and MathID number are displayed. To obtain your password, \
contact Wolfram Research (see",
 " \"",
 ButtonBox["Registration and Passwords\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/RegistrationAndPasswords"],
 " for details). You will need to supply your MathID number and the license \
ID number printed on your license certificate."
}], "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->510651104],

Cell["\<\
Configuring Single-Machine Password...

Mathematica 6.0 for Linux
Copyright 1988-2007 Wolfram Research, Inc.

You will need to get a password from your
license certificate or from Wolfram Research
(register.wolfram.com).
Machine name: hostname
MathID:\txxxx-xxxxx-xxxxx

You will need a valid license ID and password in order
to proceed. Go to register.wolfram.com or
consult your Getting Started documentation.\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->35890626]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Enter your name, the name of your organization, your license ID number \
(printed on your license certificate), and your password, and press ",
 StyleBox["Enter", "KeyEvent"],
 " when you are done."
}], "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->494561908],

Cell["\<\
Enter your name:

Enter the name of your organization:

Enter your license ID [format Lxxxx-xxxx]:

Enter your password:\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->475435402]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "The installer creates the ",
 StyleBox["mathpass", "InlineCode"],
 " file and displays its location. The installation is now complete. "
}], "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->461885621],

Cell["\<\
Creating password file entry in
/usr/share/Mathematica/Licensing/mathpass.

See your Getting Started documentation if you need to
set up a sitewide password file.\
\>", "Program",
 CellTags->"b:6.0.3",
 CellID->70134754]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a File Server"
}], "Section",
 CellTags->"i:1f",
 CellID->56384100],

Cell[TextData[{
 "One convenient way to install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on a client is to run the installer remotely from a file server. This is \
an efficient way of making ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " available to a large number of users without having to supply a CD to each \
one. You can install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a file server on a client running any supported Unix or Linux \
platform. It is not necessary that the client platform be the same as the",
 " ",
 "file server platform."
}], "Text",
 CellTags->"b:6.0.0",
 CellID->107635592],

Cell[TextData[{
 "To install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a file server, you first must make the installer and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " files available to the clients. You can do this by copying the contents of \
the CD to the file server and exporting the directory, or by exporting the CD \
mount point on the file server. Then, mount the directory with the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " distribution on the client and change to this directory, and run ",
 StyleBox["MathInstaller", "InlineCode"],
 " to install ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on the client machines. (Note that you must run ",
 StyleBox["MathInstaller", "InlineCode"],
 " from the directory in which it is located.) If you are installing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in a mixed-platform environment, you may need to use the ",
 StyleBox["MathInstaller", "InlineCode"],
 " option ",
 StyleBox["-platform", "InlineCode"],
 " to ensure that the correct files for your platform are installed."
}], "Text",
 CellTags->{"i:45", "b:6.0.0"},
 CellID->122929521]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Installing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " from a Script"
}], "Section",
 CellTags->"i:1g",
 CellID->475862381],

Cell[TextData[{
 "If you are installing ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " on multiple machines, it can be time-consuming to respond to all of the \
installer prompts on each individual machine. By supplying command-line \
options to the ",
 StyleBox["MathInstaller", "InlineCode"],
 " command, you can customize various features of the installation process",
 " ",
 "or automate it entirely. "
}], "Text",
 CellTags->"b:6.0.2",
 CellID->697047239],

Cell[TextData[{
 "The ",
 StyleBox["MathInstaller", "InlineCode"],
 " command supports the following command-line options. "
}], "Text",
 CellTags->{"i:5", "b:6.0.2"},
 CellID->65317061],

Cell[TextData[StyleBox["-auto", "InlineCode"]], "IndentedText",
 CellTags->"b:6.0.2",
 CellID->442199493],

Cell["\<\
Causes the installation to proceed automatically without prompting the user \
for any information. Default values are used for any options that are not \
specified explicitly on the command line. \
\>", "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->304699508],

Cell[TextData[{
 StyleBox["-createddir=", "InlineCode"],
 StyleBox["value", "TI"]
}], "IndentedText",
 CellTags->"b:6.0.2",
 CellID->55001493],

Cell[TextData[{
 "Specifies whether any directories required for the installation should be \
created if they do not exist. The allowed values are ",
 StyleBox["y", "InlineCode"],
 " or ",
 StyleBox["n", "InlineCode"],
 ", with ",
 StyleBox["y", "InlineCode"],
 " as the default value. This option only works with an automatic",
 " ",
 "installation (that is, when one of the options ",
 StyleBox["-auto", "InlineCode"],
 " or ",
 StyleBox["-silent", "InlineCode"],
 " is also specified)."
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->312402175],

Cell[TextData[{
 StyleBox["-execdir=", "InlineCode"],
 StyleBox["dir", "TI"]
}], "IndentedText",
 CellTags->"b:6.0.2",
 CellID->104512171],

Cell[TextData[{
 "Specifies the path to be used for the symbolic links to the executable",
 " ",
 "scripts. The default is ",
 StyleBox["/usr/local/bin", "InlineCode"],
 ". This option only works with an automatic installation."
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->733361189],

Cell[TextData[StyleBox["-help", "InlineCode"]], "IndentedText",
 CellTags->"b:6.0.2",
 CellID->134378819],

Cell["Displays information about the installer options.", \
"ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->242838915],

Cell[TextData[{
 StyleBox["-overwrite=", "InlineCode"],
 StyleBox["value", "TI"]
}], "IndentedText",
 CellTags->"b:6.0.2",
 CellID->898240766],

Cell[TextData[{
 "Specifies whether the installer should overwrite any files that already \
exist in the target directory. The allowed values are ",
 StyleBox["y", "InlineCode"],
 " or ",
 StyleBox["n", "InlineCode"],
 ", with ",
 StyleBox["y", "InlineCode"],
 " as the default value. This option only works with an automatic \
installation."
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->107354220],

Cell[TextData[{
 StyleBox["-platforms=", "InlineCode"],
 StyleBox["value", "TI"]
}], "IndentedText",
 CellTags->{"i:40", "b:6.0.2"},
 CellID->415048268],

Cell["\<\
Specifies the system ID of the Unix platform or platforms (e.g., Linux, \
Solaris, and so forth) for which you want to do the installation. The default \
value is the system you are installing on, if that information is available \
to the installer. This option only works with an automatic installation.\
\>", "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->70409953],

Cell[TextData[StyleBox["-silent", "InlineCode"]], "IndentedText",
 CellTags->"b:6.0.2",
 CellID->530268862],

Cell[TextData[{
 "Forces an automatic installation (equivalent to using the ",
 StyleBox["-auto", "InlineCode"],
 " option) and suppresses any output from being displayed on the screen. The \
output is instead written to a file named ",
 StyleBox["InstallerLog-", "InlineCode"],
 StyleBox["number", "TI"],
 ". If the installation is unsuccessful, the log file is saved in the ",
 StyleBox["/tmp", "InlineCode"],
 " directory. Otherwise, the file is moved to the target directory and",
 " ",
 "renamed ",
 StyleBox["InstallerLog", "InlineCode"],
 "."
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->27994144],

Cell[TextData[{
 StyleBox["-targetdir=", "InlineCode"],
 StyleBox["dir", "TI"]
}], "IndentedText",
 CellTags->"b:6.0.2",
 CellID->309326224],

Cell[TextData[{
 "Specifies the directory where the installed files will be copied. This",
 " ",
 "corresponds to the value of the global variable ",
 StyleBox["$InstallationDirectory", "InlineCode"],
 ". The default value is ",
 StyleBox["/usr/local/Wolfram/Mathematica/6.0", "InlineCode"],
 ". This option only works with an automatic installation."
}], "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->220121075],

Cell[TextData[StyleBox["-verbose", "InlineCode"]], "IndentedText",
 CellTags->"b:6.0.2",
 CellID->815474144],

Cell[CellGroupData[{

Cell["\<\
Displays detailed information about the files and directories being \
installed. \
\>", "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->117556442],

Cell["\<\
To complete the installation in one step, run a command like the following.\
\>", "Text",
 CellTags->"b:6.0.2",
 CellID->144585591],

Cell[TextData[StyleBox["./MathInstaller -auto -targetdir=/home/mathematica", \
"InlineCode"]], "Text",
 CellTags->"b:6.0.2",
 CellID->306283463],

Cell[TextData[{
 "This allows you to complete the installation automatically in one step, \
while still being able to customize various details such as the directory to \
install to. You are not prompted to enter your password using this method, \
so",
 " ",
 "you will need to enter a password the first time ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is launched."
}], "Text",
 CellTags->"b:6.0.2",
 CellID->867294139],

Cell[TextData[{
 "If you are doing many installations, you might find it convenient to \
include the ",
 StyleBox["MathInstaller", "InlineCode"],
 " command with all the relevant options in a shell script. Running the shell \
script is then an easy way to do an identical customized installation on \
multiple machines. You can further simplify the installation process by \
including a line in your script that copies an existing ",
 StyleBox["mathpass", "InlineCode"],
 " file to the appropriate location on the newly installed machine. Note that \
",
 StyleBox["MathInstaller", "InlineCode"],
 " must be run from the directory in which it is located, so your script \
may",
 " ",
 "require a command to change directory. "
}], "Text",
 CellTags->"b:6.0.2",
 CellID->79552590]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->916833560],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"RelatedTutorials",
 CellID->13855348],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Installing Mathematica on Unix and Linux - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 29.1615066}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica is available for Windows, Unix, Linux, and Mac OS X. For a \
complete list of platform availability, visit \
www.wolfram.com/products/mathematica/platforms.html. Any supported machine \
can act as a client for running Mathematica, provided the following two \
conditions are met: A license server can also function as its own client. \
However, this is not recommended. If the machine has to be rebooted for any \
reason, the serving of licenses to all other clients on the network may be \
disrupted. Before you install Mathematica as a license server client, MathLM \
should already be installed and running on a license server on the network \
(see Installing MathLM on Windows and Installing MathLM on Unix, Linux, and \
Mac OS X for details). To complete the Mathematica installation, you will \
need to know the name or IP address of the license server running MathLM.", 
    "synonyms" -> {}, "title" -> "Installing Mathematica on Unix and Linux", 
    "type" -> "Tutorial", "uri" -> 
    "tutorial/InstallingMathematicaOnUnixAndLinux"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "b:3.0"->{
  Cell[1565, 48, 167, 7, 70, "Title",
   CellTags->{"b:3.0", "net: 1"},
   CellID->356726414],
  Cell[1757, 59, 180, 7, 70, "Section",
   CellTags->{"i:1a", "b:3.0", "net: 1"},
   CellID->653439790]},
 "net: 1"->{
  Cell[1565, 48, 167, 7, 70, "Title",
   CellTags->{"b:3.0", "net: 1"},
   CellID->356726414],
  Cell[1757, 59, 180, 7, 70, "Section",
   CellTags->{"i:1a", "b:3.0", "net: 1"},
   CellID->653439790],
  Cell[1962, 70, 94, 2, 70, "Subsection",
   CellTags->{"b:3.3", "i:14", "net: 1"},
   CellID->588938517],
  Cell[12903, 480, 186, 7, 70, "Section",
   CellTags->{"i:10", "b:5.0.3", "net: 1"},
   CellID->147916860]},
 "i:1a"->{
  Cell[1757, 59, 180, 7, 70, "Section",
   CellTags->{"i:1a", "b:3.0", "net: 1"},
   CellID->653439790]},
 "b:3.3"->{
  Cell[1962, 70, 94, 2, 70, "Subsection",
   CellTags->{"b:3.3", "i:14", "net: 1"},
   CellID->588938517],
  Cell[2059, 74, 594, 16, 70, "Text",
   CellTags->{"b:3.3", "i:15"},
   CellID->376880962],
  Cell[2656, 92, 222, 7, 70, "BulletedText",
   CellTags->"b:3.3",
   CellID->779467028],
  Cell[2903, 103, 266, 9, 70, "BulletedText",
   CellTags->"b:3.3",
   CellID->774837737],
  Cell[3172, 114, 284, 6, 70, "Text",
   CellTags->"b:3.3",
   CellID->451522550],
  Cell[3459, 122, 1035, 34, 70, "Text",
   CellTags->"b:3.3",
   CellID->164620833]},
 "i:14"->{
  Cell[1962, 70, 94, 2, 70, "Subsection",
   CellTags->{"b:3.3", "i:14", "net: 1"},
   CellID->588938517]},
 "i:15"->{
  Cell[2059, 74, 594, 16, 70, "Text",
   CellTags->{"b:3.3", "i:15"},
   CellID->376880962]},
 "b:3.1"->{
  Cell[4497, 158, 220, 9, 70, "Text",
   CellTags->"b:3.1",
   CellID->175429623],
  Cell[4891, 181, 311, 9, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:3.1",
   CellID->84795167],
  Cell[5205, 192, 253, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:3.1",
   CellID->220765989],
  Cell[5461, 201, 273, 8, 70, "ItemizedText",
   CellTags->"b:3.1",
   CellID->356896806],
  Cell[5737, 211, 186, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:3.1",
   CellID->126247212],
  Cell[5926, 219, 82, 2, 70, "ItemizedText",
   CellTags->"b:3.1",
   CellID->603935396],
  Cell[6033, 225, 123, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:3.1",
   CellID->38437854],
  Cell[6159, 230, 549, 14, 70, "Program",
   CellTags->"b:3.1",
   CellID->18934754],
  Cell[6745, 249, 265, 7, 70, "ItemizedText",
   CellTags->"b:3.1",
   CellID->141971909],
  Cell[7013, 258, 143, 5, 70, "Program",
   CellTags->"b:3.1",
   CellID->411620491],
  Cell[7159, 265, 165, 5, 70, "Program",
   CellTags->"b:3.1",
   CellID->652040264],
  Cell[7361, 275, 440, 13, 70, "ItemizedText",
   CellTags->{"i:6", "b:3.1"},
   CellID->455233511],
  Cell[7804, 290, 160, 5, 70, "Program",
   CellTags->"b:3.1",
   CellID->35678095],
  Cell[7979, 298, 422, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:3.1",
   CellID->260380307],
  Cell[8426, 313, 256, 6, 70, "ItemizedText",
   CellTags->"b:3.1",
   CellID->471205016],
  Cell[8685, 321, 154, 6, 70, "Program",
   CellTags->"b:3.1",
   CellID->94304291],
  Cell[8876, 332, 507, 13, 70, "ItemizedText",
   CellTags->"b:3.1",
   CellID->55595927],
  Cell[9386, 347, 181, 5, 70, "Program",
   CellTags->"b:3.1",
   CellID->208447403],
  Cell[9582, 355, 315, 9, 70, "ItemizedTextParagraph",
   CellTags->"b:3.1",
   CellID->354081158],
  Cell[9922, 368, 313, 11, 70, "ItemizedText",
   CellTags->"b:3.1",
   CellID->16633248],
  Cell[10238, 381, 551, 17, 70, "Program",
   CellTags->"b:3.1",
   CellID->234198761],
  Cell[10826, 403, 583, 19, 70, "ItemizedText",
   CellTags->"b:3.1",
   CellID->146274385],
  Cell[11412, 424, 149, 5, 70, "Program",
   CellTags->"b:3.1",
   CellID->180566055],
  Cell[11576, 432, 712, 18, 70, "ItemizedTextParagraph",
   CellTags->"b:3.1",
   CellID->883460457],
  Cell[12313, 454, 214, 6, 70, "ItemizedText",
   CellTags->"b:3.1",
   CellID->243611692],
  Cell[12530, 462, 312, 11, 70, "Program",
   CellTags->"b:3.1",
   CellID->129750318]},
 "i:6"->{
  Cell[7361, 275, 440, 13, 70, "ItemizedText",
   CellTags->{"i:6", "b:3.1"},
   CellID->455233511]},
 "i:10"->{
  Cell[12903, 480, 186, 7, 70, "Section",
   CellTags->{"i:10", "b:5.0.3", "net: 1"},
   CellID->147916860]},
 "b:5.0.3"->{
  Cell[12903, 480, 186, 7, 70, "Section",
   CellTags->{"i:10", "b:5.0.3", "net: 1"},
   CellID->147916860]},
 "b:6.0.3"->{
  Cell[13092, 489, 354, 9, 70, "Text",
   CellTags->"b:6.0.3",
   CellID->590120230],
  Cell[13449, 500, 461, 15, 70, "Text",
   CellTags->"b:6.0.3",
   CellID->141537769],
  Cell[13913, 517, 221, 9, 70, "Text",
   CellTags->"b:6.0.3",
   CellID->20026948],
  Cell[14159, 530, 186, 7, 70, "Subsection",
   CellTags->"b:6.0.3",
   CellID->9283949],
  Cell[14348, 539, 313, 9, 70, "ItemizedText",
   CounterAssignments->{{"ItemizedList", 0}},
   CellTags->"b:6.0.3",
   CellID->49879284],
  Cell[14664, 550, 246, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.3",
   CellID->33386777],
  Cell[14913, 559, 275, 8, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->204472622],
  Cell[15191, 569, 188, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.3",
   CellID->320513031],
  Cell[15382, 577, 84, 2, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->423861716],
  Cell[15491, 583, 126, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.3",
   CellID->612250391],
  Cell[15620, 588, 558, 15, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->150339242],
  Cell[16215, 608, 259, 7, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->270984937],
  Cell[16477, 617, 144, 5, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->41603671],
  Cell[16624, 624, 166, 5, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->62385416],
  Cell[16827, 634, 432, 13, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->34807422],
  Cell[17262, 649, 163, 5, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->735567131],
  Cell[17440, 657, 416, 11, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.3",
   CellID->275552294],
  Cell[17881, 672, 257, 6, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->12076595],
  Cell[18141, 680, 156, 5, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->271803200],
  Cell[18334, 690, 509, 13, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->12073611],
  Cell[18846, 705, 183, 5, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->104968151],
  Cell[19044, 713, 325, 10, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.3",
   CellID->153597371],
  Cell[19394, 727, 323, 11, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->637572970],
  Cell[19720, 740, 554, 17, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->159075424],
  Cell[20311, 762, 446, 11, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->510651104],
  Cell[20760, 775, 479, 17, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->35890626],
  Cell[21276, 797, 278, 7, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->494561908],
  Cell[21557, 806, 189, 10, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->475435402],
  Cell[21783, 821, 216, 6, 70, "ItemizedText",
   CellTags->"b:6.0.3",
   CellID->461885621],
  Cell[22002, 829, 230, 8, 70, "Program",
   CellTags->"b:6.0.3",
   CellID->70134754]},
 "i:1f"->{
  Cell[22293, 844, 156, 7, 70, "Section",
   CellTags->"i:1f",
   CellID->56384100]},
 "b:6.0.0"->{
  Cell[22452, 853, 642, 18, 70, "Text",
   CellTags->"b:6.0.0",
   CellID->107635592],
  Cell[23097, 873, 1158, 29, 70, "Text",
   CellTags->{"i:45", "b:6.0.0"},
   CellID->122929521]},
 "i:45"->{
  Cell[23097, 873, 1158, 29, 70, "Text",
   CellTags->{"i:45", "b:6.0.0"},
   CellID->122929521]},
 "i:1g"->{
  Cell[24292, 907, 152, 7, 70, "Section",
   CellTags->"i:1g",
   CellID->475862381]},
 "b:6.0.2"->{
  Cell[24447, 916, 468, 13, 70, "Text",
   CellTags->"b:6.0.2",
   CellID->697047239],
  Cell[24918, 931, 186, 6, 70, "Text",
   CellTags->{"i:5", "b:6.0.2"},
   CellID->65317061],
  Cell[25107, 939, 105, 2, 70, "IndentedText",
   CellTags->"b:6.0.2",
   CellID->442199493],
  Cell[25215, 943, 279, 6, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->304699508],
  Cell[25497, 951, 142, 5, 70, "IndentedText",
   CellTags->"b:6.0.2",
   CellID->55001493],
  Cell[25642, 958, 560, 17, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->312402175],
  Cell[26205, 977, 138, 5, 70, "IndentedText",
   CellTags->"b:6.0.2",
   CellID->104512171],
  Cell[26346, 984, 299, 8, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->733361189],
  Cell[26648, 994, 105, 2, 70, "IndentedText",
   CellTags->"b:6.0.2",
   CellID->134378819],
  Cell[26756, 998, 126, 3, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->242838915],
  Cell[26885, 1003, 142, 5, 70, "IndentedText",
   CellTags->"b:6.0.2",
   CellID->898240766],
  Cell[27030, 1010, 413, 12, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->107354220],
  Cell[27446, 1024, 152, 5, 70, "IndentedText",
   CellTags->{"i:40", "b:6.0.2"},
   CellID->415048268],
  Cell[27601, 1031, 386, 7, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->70409953],
  Cell[27990, 1040, 107, 2, 70, "IndentedText",
   CellTags->"b:6.0.2",
   CellID->530268862],
  Cell[28100, 1044, 619, 16, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->27994144],
  Cell[28722, 1062, 140, 5, 70, "IndentedText",
   CellTags->"b:6.0.2",
   CellID->309326224],
  Cell[28865, 1069, 422, 10, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->220121075],
  Cell[29290, 1081, 108, 2, 70, "IndentedText",
   CellTags->"b:6.0.2",
   CellID->815474144],
  Cell[29423, 1087, 164, 5, 70, "ItemizedTextParagraph",
   CellTags->"b:6.0.2",
   CellID->117556442],
  Cell[29590, 1094, 141, 4, 70, "Text",
   CellTags->"b:6.0.2",
   CellID->144585591],
  Cell[29734, 1100, 144, 3, 70, "Text",
   CellTags->"b:6.0.2",
   CellID->306283463],
  Cell[29881, 1105, 432, 12, 70, "Text",
   CellTags->"b:6.0.2",
   CellID->867294139],
  Cell[30316, 1119, 778, 18, 70, "Text",
   CellTags->"b:6.0.2",
   CellID->79552590]},
 "i:5"->{
  Cell[24918, 931, 186, 6, 70, "Text",
   CellTags->{"i:5", "b:6.0.2"},
   CellID->65317061]},
 "i:40"->{
  Cell[27446, 1024, 152, 5, 70, "IndentedText",
   CellTags->{"i:40", "b:6.0.2"},
   CellID->415048268]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"b:3.0", 33849, 1209},
 {"net: 1", 34063, 1216},
 {"i:1a", 34491, 1229},
 {"b:3.3", 34609, 1233},
 {"i:14", 35170, 1252},
 {"i:15", 35289, 1256},
 {"b:3.1", 35395, 1260},
 {"i:6", 37835, 1340},
 {"i:10", 37948, 1344},
 {"b:5.0.3", 38072, 1348},
 {"b:6.0.3", 38196, 1352},
 {"i:1f", 41041, 1444},
 {"b:6.0.0", 41141, 1448},
 {"i:45", 41338, 1455},
 {"i:1g", 41448, 1459},
 {"b:6.0.2", 41549, 1463},
 {"i:5", 43884, 1536},
 {"i:40", 43990, 1540}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 940, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1565, 48, 167, 7, 70, "Title",
 CellTags->{"b:3.0", "net: 1"},
 CellID->356726414],
Cell[CellGroupData[{
Cell[1757, 59, 180, 7, 70, "Section",
 CellTags->{"i:1a", "b:3.0", "net: 1"},
 CellID->653439790],
Cell[CellGroupData[{
Cell[1962, 70, 94, 2, 70, "Subsection",
 CellTags->{"b:3.3", "i:14", "net: 1"},
 CellID->588938517],
Cell[2059, 74, 594, 16, 70, "Text",
 CellTags->{"b:3.3", "i:15"},
 CellID->376880962],
Cell[2656, 92, 222, 7, 70, "BulletedText",
 CellTags->"b:3.3",
 CellID->779467028],
Cell[CellGroupData[{
Cell[2903, 103, 266, 9, 70, "BulletedText",
 CellTags->"b:3.3",
 CellID->774837737],
Cell[3172, 114, 284, 6, 70, "Text",
 CellTags->"b:3.3",
 CellID->451522550],
Cell[3459, 122, 1035, 34, 70, "Text",
 CellTags->"b:3.3",
 CellID->164620833],
Cell[4497, 158, 220, 9, 70, "Text",
 CellTags->"b:3.1",
 CellID->175429623]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4766, 173, 122, 6, 70, "Subsection",
 CellID->49441506],
Cell[4891, 181, 311, 9, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:3.1",
 CellID->84795167],
Cell[5205, 192, 253, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->220765989],
Cell[5461, 201, 273, 8, 70, "ItemizedText",
 CellTags->"b:3.1",
 CellID->356896806],
Cell[5737, 211, 186, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->126247212],
Cell[5926, 219, 82, 2, 70, "ItemizedText",
 CellTags->"b:3.1",
 CellID->603935396],
Cell[CellGroupData[{
Cell[6033, 225, 123, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->38437854],
Cell[6159, 230, 549, 14, 70, "Program",
 CellTags->"b:3.1",
 CellID->18934754]
}, Open  ]],
Cell[CellGroupData[{
Cell[6745, 249, 265, 7, 70, "ItemizedText",
 CellTags->"b:3.1",
 CellID->141971909],
Cell[7013, 258, 143, 5, 70, "Program",
 CellTags->"b:3.1",
 CellID->411620491],
Cell[7159, 265, 165, 5, 70, "Program",
 CellTags->"b:3.1",
 CellID->652040264]
}, Open  ]],
Cell[CellGroupData[{
Cell[7361, 275, 440, 13, 70, "ItemizedText",
 CellTags->{"i:6", "b:3.1"},
 CellID->455233511],
Cell[7804, 290, 160, 5, 70, "Program",
 CellTags->"b:3.1",
 CellID->35678095]
}, Open  ]],
Cell[7979, 298, 422, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->260380307],
Cell[CellGroupData[{
Cell[8426, 313, 256, 6, 70, "ItemizedText",
 CellTags->"b:3.1",
 CellID->471205016],
Cell[8685, 321, 154, 6, 70, "Program",
 CellTags->"b:3.1",
 CellID->94304291]
}, Open  ]],
Cell[CellGroupData[{
Cell[8876, 332, 507, 13, 70, "ItemizedText",
 CellTags->"b:3.1",
 CellID->55595927],
Cell[9386, 347, 181, 5, 70, "Program",
 CellTags->"b:3.1",
 CellID->208447403]
}, Open  ]],
Cell[9582, 355, 315, 9, 70, "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->354081158],
Cell[CellGroupData[{
Cell[9922, 368, 313, 11, 70, "ItemizedText",
 CellTags->"b:3.1",
 CellID->16633248],
Cell[10238, 381, 551, 17, 70, "Program",
 CellTags->"b:3.1",
 CellID->234198761]
}, Open  ]],
Cell[CellGroupData[{
Cell[10826, 403, 583, 19, 70, "ItemizedText",
 CellTags->"b:3.1",
 CellID->146274385],
Cell[11412, 424, 149, 5, 70, "Program",
 CellTags->"b:3.1",
 CellID->180566055]
}, Open  ]],
Cell[11576, 432, 712, 18, 70, "ItemizedTextParagraph",
 CellTags->"b:3.1",
 CellID->883460457],
Cell[CellGroupData[{
Cell[12313, 454, 214, 6, 70, "ItemizedText",
 CellTags->"b:3.1",
 CellID->243611692],
Cell[12530, 462, 312, 11, 70, "Program",
 CellTags->"b:3.1",
 CellID->129750318]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12903, 480, 186, 7, 70, "Section",
 CellTags->{"i:10", "b:5.0.3", "net: 1"},
 CellID->147916860],
Cell[13092, 489, 354, 9, 70, "Text",
 CellTags->"b:6.0.3",
 CellID->590120230],
Cell[13449, 500, 461, 15, 70, "Text",
 CellTags->"b:6.0.3",
 CellID->141537769],
Cell[13913, 517, 221, 9, 70, "Text",
 CellTags->"b:6.0.3",
 CellID->20026948],
Cell[CellGroupData[{
Cell[14159, 530, 186, 7, 70, "Subsection",
 CellTags->"b:6.0.3",
 CellID->9283949],
Cell[14348, 539, 313, 9, 70, "ItemizedText",
 CounterAssignments->{{"ItemizedList", 0}},
 CellTags->"b:6.0.3",
 CellID->49879284],
Cell[14664, 550, 246, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->33386777],
Cell[14913, 559, 275, 8, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->204472622],
Cell[15191, 569, 188, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->320513031],
Cell[15382, 577, 84, 2, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->423861716],
Cell[CellGroupData[{
Cell[15491, 583, 126, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->612250391],
Cell[15620, 588, 558, 15, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->150339242]
}, Open  ]],
Cell[CellGroupData[{
Cell[16215, 608, 259, 7, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->270984937],
Cell[16477, 617, 144, 5, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->41603671],
Cell[16624, 624, 166, 5, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->62385416]
}, Open  ]],
Cell[CellGroupData[{
Cell[16827, 634, 432, 13, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->34807422],
Cell[17262, 649, 163, 5, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->735567131]
}, Open  ]],
Cell[17440, 657, 416, 11, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->275552294],
Cell[CellGroupData[{
Cell[17881, 672, 257, 6, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->12076595],
Cell[18141, 680, 156, 5, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->271803200]
}, Open  ]],
Cell[CellGroupData[{
Cell[18334, 690, 509, 13, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->12073611],
Cell[18846, 705, 183, 5, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->104968151]
}, Open  ]],
Cell[19044, 713, 325, 10, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.3",
 CellID->153597371],
Cell[CellGroupData[{
Cell[19394, 727, 323, 11, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->637572970],
Cell[19720, 740, 554, 17, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->159075424]
}, Open  ]],
Cell[CellGroupData[{
Cell[20311, 762, 446, 11, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->510651104],
Cell[20760, 775, 479, 17, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->35890626]
}, Open  ]],
Cell[CellGroupData[{
Cell[21276, 797, 278, 7, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->494561908],
Cell[21557, 806, 189, 10, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->475435402]
}, Open  ]],
Cell[CellGroupData[{
Cell[21783, 821, 216, 6, 70, "ItemizedText",
 CellTags->"b:6.0.3",
 CellID->461885621],
Cell[22002, 829, 230, 8, 70, "Program",
 CellTags->"b:6.0.3",
 CellID->70134754]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22293, 844, 156, 7, 70, "Section",
 CellTags->"i:1f",
 CellID->56384100],
Cell[22452, 853, 642, 18, 70, "Text",
 CellTags->"b:6.0.0",
 CellID->107635592],
Cell[23097, 873, 1158, 29, 70, "Text",
 CellTags->{"i:45", "b:6.0.0"},
 CellID->122929521]
}, Open  ]],
Cell[CellGroupData[{
Cell[24292, 907, 152, 7, 70, "Section",
 CellTags->"i:1g",
 CellID->475862381],
Cell[24447, 916, 468, 13, 70, "Text",
 CellTags->"b:6.0.2",
 CellID->697047239],
Cell[24918, 931, 186, 6, 70, "Text",
 CellTags->{"i:5", "b:6.0.2"},
 CellID->65317061],
Cell[25107, 939, 105, 2, 70, "IndentedText",
 CellTags->"b:6.0.2",
 CellID->442199493],
Cell[25215, 943, 279, 6, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->304699508],
Cell[25497, 951, 142, 5, 70, "IndentedText",
 CellTags->"b:6.0.2",
 CellID->55001493],
Cell[25642, 958, 560, 17, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->312402175],
Cell[26205, 977, 138, 5, 70, "IndentedText",
 CellTags->"b:6.0.2",
 CellID->104512171],
Cell[26346, 984, 299, 8, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->733361189],
Cell[26648, 994, 105, 2, 70, "IndentedText",
 CellTags->"b:6.0.2",
 CellID->134378819],
Cell[26756, 998, 126, 3, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->242838915],
Cell[26885, 1003, 142, 5, 70, "IndentedText",
 CellTags->"b:6.0.2",
 CellID->898240766],
Cell[27030, 1010, 413, 12, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->107354220],
Cell[27446, 1024, 152, 5, 70, "IndentedText",
 CellTags->{"i:40", "b:6.0.2"},
 CellID->415048268],
Cell[27601, 1031, 386, 7, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->70409953],
Cell[27990, 1040, 107, 2, 70, "IndentedText",
 CellTags->"b:6.0.2",
 CellID->530268862],
Cell[28100, 1044, 619, 16, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->27994144],
Cell[28722, 1062, 140, 5, 70, "IndentedText",
 CellTags->"b:6.0.2",
 CellID->309326224],
Cell[28865, 1069, 422, 10, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->220121075],
Cell[29290, 1081, 108, 2, 70, "IndentedText",
 CellTags->"b:6.0.2",
 CellID->815474144],
Cell[CellGroupData[{
Cell[29423, 1087, 164, 5, 70, "ItemizedTextParagraph",
 CellTags->"b:6.0.2",
 CellID->117556442],
Cell[29590, 1094, 141, 4, 70, "Text",
 CellTags->"b:6.0.2",
 CellID->144585591],
Cell[29734, 1100, 144, 3, 70, "Text",
 CellTags->"b:6.0.2",
 CellID->306283463],
Cell[29881, 1105, 432, 12, 70, "Text",
 CellTags->"b:6.0.2",
 CellID->867294139],
Cell[30316, 1119, 778, 18, 70, "Text",
 CellTags->"b:6.0.2",
 CellID->79552590]
}, Open  ]],
Cell[CellGroupData[{
Cell[31131, 1142, 72, 1, 70, "RelatedTutorialsSection",
 CellID->916833560],
Cell[31206, 1145, 214, 5, 70, "RelatedTutorials",
 CellID->13855348],
Cell[31423, 1152, 221, 5, 70, "RelatedTutorials",
 CellID->37939478]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[31683, 1162, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

