(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    149874,       5422]
NotebookOptionsPosition[    125166,       4591]
NotebookOutlinePosition[    130197,       4696]
CellTagsIndexPosition[    130102,       4690]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalFunctionsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematical Functions\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BitAnd" :> Documentation`HelpLookup["paclet:ref/BitAnd"], 
          "BitClear" :> Documentation`HelpLookup["paclet:ref/BitClear"], 
          "BitGet" :> Documentation`HelpLookup["paclet:ref/BitGet"], 
          "BitLength" :> Documentation`HelpLookup["paclet:ref/BitLength"], 
          "BitNot" :> Documentation`HelpLookup["paclet:ref/BitNot"], "BitOr" :> 
          Documentation`HelpLookup["paclet:ref/BitOr"], "BitSet" :> 
          Documentation`HelpLookup["paclet:ref/BitSet"], "BitShiftLeft" :> 
          Documentation`HelpLookup["paclet:ref/BitShiftLeft"], 
          "BitShiftRight" :> 
          Documentation`HelpLookup["paclet:ref/BitShiftRight"], "BitXor" :> 
          Documentation`HelpLookup["paclet:ref/BitXor"], "CarmichaelLambda" :> 
          Documentation`HelpLookup["paclet:ref/CarmichaelLambda"], 
          "ChineseRemainder" :> 
          Documentation`HelpLookup["paclet:ref/ChineseRemainder"], 
          "ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], 
          "Convergents" :> Documentation`HelpLookup["paclet:ref/Convergents"],
           "CoprimeQ" :> Documentation`HelpLookup["paclet:ref/CoprimeQ"], 
          "DigitCount" :> Documentation`HelpLookup["paclet:ref/DigitCount"], 
          "Divisible" :> Documentation`HelpLookup["paclet:ref/Divisible"], 
          "Divisors" :> Documentation`HelpLookup["paclet:ref/Divisors"], 
          "DivisorSigma" :> 
          Documentation`HelpLookup["paclet:ref/DivisorSigma"], "EulerPhi" :> 
          Documentation`HelpLookup["paclet:ref/EulerPhi"], "ExtendedGCD" :> 
          Documentation`HelpLookup["paclet:ref/ExtendedGCD"], "FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], "False" :> 
          Documentation`HelpLookup["paclet:ref/False"], 
          "FromContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/FromContinuedFraction"], 
          "GaussianIntegers" :> 
          Documentation`HelpLookup["paclet:ref/GaussianIntegers"], "GCD" :> 
          Documentation`HelpLookup["paclet:ref/GCD"], "HermiteDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/HermiteDecomposition"], 
          "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "IntegerExponent" :> 
          Documentation`HelpLookup["paclet:ref/IntegerExponent"], 
          "JacobiSymbol" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSymbol"], 
          "KroneckerDelta" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerDelta"], 
          "LatticeReduce" :> 
          Documentation`HelpLookup["paclet:ref/LatticeReduce"], "LCM" :> 
          Documentation`HelpLookup["paclet:ref/LCM"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "MoebiusMu" :> 
          Documentation`HelpLookup["paclet:ref/MoebiusMu"], 
          "MultiplicativeOrder" :> 
          Documentation`HelpLookup["paclet:ref/MultiplicativeOrder"], 
          "NextPrime" :> Documentation`HelpLookup["paclet:ref/NextPrime"], 
          "PowerMod" :> Documentation`HelpLookup["paclet:ref/PowerMod"], 
          "PowersRepresentations" :> 
          Documentation`HelpLookup["paclet:ref/PowersRepresentations"], 
          "Prime" :> Documentation`HelpLookup["paclet:ref/Prime"], "PrimePi" :> 
          Documentation`HelpLookup["paclet:ref/PrimePi"], "PrimePowerQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimePowerQ"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"], "PrimitiveRoot" :> 
          Documentation`HelpLookup["paclet:ref/PrimitiveRoot"], 
          "QuadraticIrrationalQ" :> 
          Documentation`HelpLookup["paclet:ref/QuadraticIrrationalQ"], 
          "Quotient" :> Documentation`HelpLookup["paclet:ref/Quotient"], 
          "QuotientRemainder" :> 
          Documentation`HelpLookup["paclet:ref/QuotientRemainder"], 
          "RandomPrime" :> Documentation`HelpLookup["paclet:ref/RandomPrime"],
           "Rationalize" :> 
          Documentation`HelpLookup["paclet:ref/Rationalize"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"], "SquareFreeQ" :> 
          Documentation`HelpLookup["paclet:ref/SquareFreeQ"], "SquaresR" :> 
          Documentation`HelpLookup["paclet:ref/SquaresR"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BitAnd\"\>", 2->"\<\"BitClear\"\>", 
       3->"\<\"BitGet\"\>", 4->"\<\"BitLength\"\>", 5->"\<\"BitNot\"\>", 
       6->"\<\"BitOr\"\>", 7->"\<\"BitSet\"\>", 8->"\<\"BitShiftLeft\"\>", 
       9->"\<\"BitShiftRight\"\>", 10->"\<\"BitXor\"\>", 
       11->"\<\"CarmichaelLambda\"\>", 12->"\<\"ChineseRemainder\"\>", 
       13->"\<\"ContinuedFraction\"\>", 14->"\<\"Convergents\"\>", 
       15->"\<\"CoprimeQ\"\>", 16->"\<\"DigitCount\"\>", 
       17->"\<\"Divisible\"\>", 18->"\<\"Divisors\"\>", 
       19->"\<\"DivisorSigma\"\>", 20->"\<\"EulerPhi\"\>", 
       21->"\<\"ExtendedGCD\"\>", 22->"\<\"FactorInteger\"\>", 
       23->"\<\"False\"\>", 24->"\<\"FromContinuedFraction\"\>", 
       25->"\<\"GaussianIntegers\"\>", 26->"\<\"GCD\"\>", 
       27->"\<\"HermiteDecomposition\"\>", 28->"\<\"IntegerDigits\"\>", 
       29->"\<\"IntegerExponent\"\>", 30->"\<\"JacobiSymbol\"\>", 
       31->"\<\"KroneckerDelta\"\>", 32->"\<\"LatticeReduce\"\>", 
       33->"\<\"LCM\"\>", 34->"\<\"Mod\"\>", 35->"\<\"MoebiusMu\"\>", 
       36->"\<\"MultiplicativeOrder\"\>", 37->"\<\"NextPrime\"\>", 
       38->"\<\"PowerMod\"\>", 39->"\<\"PowersRepresentations\"\>", 
       40->"\<\"Prime\"\>", 41->"\<\"PrimePi\"\>", 42->"\<\"PrimePowerQ\"\>", 
       43->"\<\"PrimeQ\"\>", 44->"\<\"PrimitiveRoot\"\>", 
       45->"\<\"QuadraticIrrationalQ\"\>", 46->"\<\"Quotient\"\>", 
       47->"\<\"QuotientRemainder\"\>", 48->"\<\"RandomPrime\"\>", 
       49->"\<\"Rationalize\"\>", 50->"\<\"RealDigits\"\>", 
       51->"\<\"SquareFreeQ\"\>", 52->"\<\"SquaresR\"\>", 
       53->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\<\
Integer and Number\[Hyphen]Theoretical Functions\
\>", "Title",
 CellTags->{"S3.2.5", "5.1"},
 CellID->20170],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " modulo ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " (remainder from dividing ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " by ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Quotient",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quotient"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the quotient of ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " (truncation of ",
     Cell[BoxData[
      FormBox[
       RowBox[{"m", "/", "n"}], TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["QuotientRemainder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/QuotientRemainder"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[
    "a list of the quotient and the remainder", "TableText"]},
   {
    RowBox[{
     ButtonBox["Divisible",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Divisible"], "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " is divisible by ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CoprimeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CoprimeQ"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[TextData[{
     "test whether the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
     " are pairwise relatively prime"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GCD"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "the greatest common divisor of ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["LCM",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LCM"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "the least common multiple of ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["KroneckerDelta",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/KroneckerDelta"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "the Kronecker delta ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["n", "1"], 
         SubscriptBox["n", "2"], "\[Ellipsis]"}]], TraditionalForm]], 
      "InlineMath"],
     " equal to 1 if all the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
     " are equal, and 0 otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerDigits"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "the digits of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IntegerExponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/IntegerExponent"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "the highest power of ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     " that divides ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->18494],

Cell["Some integer functions.", "Caption",
 CellID->20216],

Cell[TextData[{
 "The remainder on dividing ",
 Cell[BoxData[
  FormBox["17", TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->12729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"17", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29726],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5929171]
}, Open  ]],

Cell[TextData[{
 "The integer part of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"17", "/", "3"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->29915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quotient", "[", 
  RowBox[{"17", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28672],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->656088]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " also works with real numbers. "
}], "MathCaption",
 CellID->15862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"5.6", ",", "1.2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6421],

Cell[BoxData["0.7999999999999998`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->38124542]
}, Open  ]],

Cell[TextData[{
 "The result from ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " always has the same sign as the second argument. "
}], "MathCaption",
 CellID->11128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"-", "5.6"}], ",", "1.2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21465],

Cell[BoxData["0.40000000000000013`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->9747796]
}, Open  ]],

Cell[TextData[{
 "For any integers ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", it is always true that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["b", "TI"], "*", 
    RowBox[{
     ButtonBox["Quotient",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quotient"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}]}], "+", 
   RowBox[{
    ButtonBox["Mod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mod"], "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "]"}]}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->259],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "result in the range 0 to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", "-", "1"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], ",", "1", "]"}], Cell[TextData[{
     "result in the range 1 to ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], ",", "-", 
     StyleBox["n", "TI"], "/", "2", "]"}], Cell[TextData[{
     "result in the range ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[LeftCeiling]", 
        RowBox[{
         RowBox[{"-", "n"}], "/", "2"}], "\[RightCeiling]"}], 
       TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[LeftFloor]", 
        RowBox[{
         RowBox[{"+", "n"}], "/", "2"}], "\[RightFloor]"}], TraditionalForm]],
       "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Mod"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "result in the range ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     " to ",
     Cell[BoxData[
      FormBox[
       RowBox[{"d", "+", "n", "-", "1"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24082],

Cell["Integer remainders with offsets. ", "Caption",
 CellID->5389],

Cell[TextData[{
 "Particularly when you are using ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " to get indices for parts of objects, you will often find it convenient to \
specify an offset. "
}], "Text",
 CellID->24986],

Cell[TextData[{
 "This effectively extracts the 18",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " part of the list, with the list treated cyclically. "
}], "MathCaption",
 CellID->21419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Part", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Mod", "[", 
    RowBox[{"18", ",", "3", ",", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->12735],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->607838148]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["greatest common divisor", "TB"],
 " function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives the largest integer that divides all the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " exactly. When you enter a ratio of two integers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " effectively uses ",
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " to cancel out common factors, and give a rational number in lowest terms."
}], "Text",
 CellID->18666],

Cell[TextData[{
 "The ",
 StyleBox["least common multiple", "TB"],
 " function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LCM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LCM"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives the smallest integer that contains all the factors of each of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->13632],

Cell["The largest integer that divides both 24 and 15 is 3. ", "MathCaption",
 CellID->13485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"24", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->15822],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->476737240]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Kronecker delta", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is equal to 1 if all the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " are equal, and is 0 otherwise. ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Delta]", 
    RowBox[{
     SubscriptBox["n", "1"], 
     SubscriptBox["n", "2"], "\[Ellipsis]", " "}]], TraditionalForm]], 
  "InlineMath"],
 " can be thought of as a totally symmetric tensor. "
}], "Text",
 CellID->5161],

Cell["This gives a totally symmetric tensor of rank 3. ", "MathCaption",
 CellID->11896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"KroneckerDelta", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->26141],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtOAjEQ7bIiqAEXn3zEn9EnP2JDTODBSJC/028RH9TfWDtdMHjSpdPb
AqEkLJ1u53LOzEI7PJbL6dNzuZxNyvHDopxPZ5PX8f3LQk7lmRDZmxDi7lbI
cSVH6k2vd/muh/Xoiq755m4lzkC+APnaIKP+ZWB7GK+vPVO8tnwULfNhsofx
2PKR08XICt3vSLFYf440Vmge7XD1MOsmPR0KnX8TjpvAOJr0RkwcKHdY2SHv
JHZhvmc5j3b7TD/n8tKVIupz/WBNx8JjwufLaz8wr23lrynupryGqVq1qvsn
K53aFz0pPce76JFWY33t9oyr3Xwi+nbQctCHzEM/Yh72VwHNqDh88p4Ok5Vc
G8PAYhaf5gHLA+4feLaH0aNHfhCND3/DgPzFz5A+Wsyb7W9hpuy4fWfbYEaL
GLfeA68q0TbujcNHb0Ljw58+z278xc8Qryrb3EmkqkxVmaoyVWWqykPAnKrS
j7/jrkpTF5pW5Wtv25+4Dvtn23qb/pxOD/t8XH8m/yYcTfHswuGCv6j+82C7
+6+7wDTE/w/sR7YVcmr/QKwUS7ml1rF04D+d0FEd23SQQ3dAff3sq4P94cR2
U5dsfx23kJ4Pp/O6Uus7ltnQdoWidpR8PLTf+fuqQtR8/P2Uj4f2973fidXE
amL15Fl1Od9tn7xcTm679EKd3H4UOhpyzjAi+wXZgFZZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{443, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->192970065]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FactorInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorInteger"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "a list of the prime factors of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     ", and their exponents"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Divisors",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Divisors"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "a list of the integers that divide ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Prime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Prime"], "[", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " prime number"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimePi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimePi"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "the number of primes less than or equal to ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimeQ"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " is a prime, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FactorInteger",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorInteger"], "[", 
     StyleBox["n", "TI"], ",", 
     ButtonBox["GaussianIntegers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GaussianIntegers"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "a list of the Gaussian prime factors of the Gaussian integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     ", and their exponents"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimeQ"], "[", 
     StyleBox["n", "TI"], ",", 
     ButtonBox["GaussianIntegers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GaussianIntegers"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " is a Gaussian prime, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28432],

Cell["Integer factoring and related functions.", "Caption",
 CellID->5872],

Cell[TextData[{
 "This gives the factors of 24 as ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", "3"], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["3", "1"], TraditionalForm]], "InlineMath"],
 ". The first element in each list is the factor; the second is its exponent. \
"
}], "MathCaption",
 CellID->32361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "24", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->4770],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->528529576]
}, Open  ]],

Cell["Here are the factors of a larger integer. ", "MathCaption",
 CellID->27165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "111111111111111111", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->25645],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"37", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"52579", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"333667", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{506, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->183957873]
}, Open  ]],

Cell[TextData[{
 "You should realize that according to current mathematical thinking, integer \
factoring is a fundamentally difficult computational problem. As a result, \
you can easily type in an integer that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will not be able to factor in anything short of an astronomical length of \
time. But as long as the integers you give are less than about 50 digits \
long, ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " should have no trouble. And in special cases it will be able to deal with \
much longer integers."
}], "Text",
 CellID->1810],

Cell["Here is a rather special long integer. ", "MathCaption",
 CellID->32128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"30", "!"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->25970],

Cell[BoxData["265252859812191058636308480000000"], "Output",
 ImageSize->{257, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->28191979]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can easily factor this special integer. "
}], "MathCaption",
 CellID->3596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "%", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->15004],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "26"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"13", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"17", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"19", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"29", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{567, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->80691484]
}, Open  ]],

Cell[TextData[{
 "Although ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may not be able to factor a large integer, it can often still test whether \
or not the integer is a prime. In addition, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a fast way of finding the ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " prime number. "
}], "Text",
 CellID->20799],

Cell["\<\
It is often much faster to test whether a number is prime than to factor it. \
\
\>", "MathCaption",
 CellID->23210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", "234242423", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->25269],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->176686160]
}, Open  ]],

Cell["Here is a plot of the first 100 primes. ", "MathCaption",
 CellID->32235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->471],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1Elu1EAYBlCLFUsvWLBg0SCEEEKomWdiAoEwmzCFQaIJCSCGxMwz1BH6
CD6Cj+Aj+AhesvQRAPnVwh0p+vLy+XecripvX9lYWtuUJMnqv+//2X91c37I
hrl5JrfIVG6b+f0uuVXumbluvxzJg3KHPCp3ytMz952Tu/sM88O/E87zXl7g
fXyRx3x5+FzhGh/g68PnrHM+xDf5cJ/ZEh/R3xr+X/VtPub6u3ycl/kE3+eT
5qNP8QP2OWUP+Qw/Yp9b/ZizPieTPgOPnujP6jlwuaKf77PluA7lU/0586t6
bjmxTuWanifP9Nat5LiO7XP9Bc/7Qs8lJ9a5jT1PXuoX9a/0PHmtv+R+HHj0
Rm/ftBz30Whdf8X9NvScFvqrfRYcuIm9fdjFnvO3evtyynGfVrG/4fp3eh6/
19vHBWc85cANx31ffTBv36cfzXPFgRuO5yT9ZN45KTiem44D55/Nc8WJc9Vx
xvkX89xwPIfpV/PO4ZQzHn8zzznHc9txcsf9vpvnggNXXMfrf5h37qcc3wMN
B+645vFP8/f0nHHxyzxXXPP4t3nvmYLje6fhwIvBPC9z4j30J2R/AZmOuZY=

     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {0., 541.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->616549603]
}, Open  ]],

Cell["This is the millionth prime. ", "MathCaption",
 CellID->11830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Prime", "[", "1000000", "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->6382],

Cell[BoxData["15485863"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->37544849]
}, Open  ]],

Cell[TextData[{
 "Particularly in number theory, it is often more important to know the \
distribution of primes than their actual values. The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimePi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimePi"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives the number of primes ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " that are less than or equal to ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->26395],

Cell["This gives the number of primes less than a billion. ", "MathCaption",
 CellID->27151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimePi", "[", 
  RowBox[{"10", "^", "9"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->20666],

Cell[BoxData["50847534"], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->382747224]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " allows only real integers. But with the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", it also handles ",
 StyleBox["Gaussian integers", "TB"],
 ", which are complex numbers with integer real and imaginary parts. Just as \
it is possible to factor uniquely in terms of real primes, it is also \
possible to factor uniquely in terms of Gaussian primes. There is \
nevertheless some potential ambiguity in the choice of Gaussian primes. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", they are always chosen to have positive real parts, and \
non\[Hyphen]negative imaginary parts, except for a possible initial factor of \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[PlusMinus]", "i"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->28710],

Cell[TextData[{
 "Over the Gaussian integers, 2 can be factored as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "i"}], ")"}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "i"}], ")"}], "2"]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->26758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"2", ",", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->7372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "\[ImaginaryI]"}], ",", "2"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->592688173]
}, Open  ]],

Cell["Here are the factors of a Gaussian integer. ", "MathCaption",
 CellID->17906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{
   RowBox[{"111", "+", 
    RowBox[{"78", " ", "I"}]}], ",", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->30014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "\[ImaginaryI]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"20", "+", 
      RowBox[{"3", " ", "\[ImaginaryI]"}]}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->161268052]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PowerMod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PowerMod"], "[", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the power ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["a", "b"], TraditionalForm]], "InlineMath"],
     " modulo ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EulerPhi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/EulerPhi"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the Euler totient function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Phi]", "(", "n", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MoebiusMu",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MoebiusMu"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the M\[ODoubleDot]bius function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Mu]", "(", "n", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DivisorSigma",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DivisorSigma"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the divisor function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Sigma]", "k"], "(", "n", ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["JacobiSymbol",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JacobiSymbol"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "the Jacobi symbol ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        FractionBox["n", "m"], ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExtendedGCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExtendedGCD"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "the extended gcd of ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], ",", 
        SubscriptBox["n", "2"], ",", "\[Ellipsis]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MultiplicativeOrder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the multiplicative order of ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " modulo ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MultiplicativeOrder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
     StyleBox["k", "TI"], ",", 
     StyleBox["n", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["r", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["r", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "the generalized multiplicative order with residues ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["r", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["CarmichaelLambda",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CarmichaelLambda"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "the Carmichael function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Lambda]", "(", "n", ")"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PrimitiveRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimitiveRoot"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "a primitive root of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->20284],

Cell["Some functions from number theory.", "Caption",
 CellID->29905],

Cell[TextData[{
 "The ",
 StyleBox["modular power function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " gives exactly the same results as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["a", "TI"], "^", 
     StyleBox["b", "TI"]}], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", ">", "0"}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 " is much more efficient, however, because it avoids generating the full \
form of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "^", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25812],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 " not only to find positive modular powers, but also to find ",
 StyleBox["modular inverses", "TB"],
 ". For negative ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " gives, if possible, an integer ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", 
    SuperscriptBox["a", 
     RowBox[{"-", "b"}]], "\[Congruent]", "1", "mod", "n"}], 
   TraditionalForm]], "InlineMath"],
 ". (Whenever such an integer exists, it is guaranteed to be unique modulo ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ".) If no such integer ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " exists, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " leaves ",
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 " unevaluated. "
}], "Text",
 CellID->28021],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 " is equivalent to using ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 ", but is much more efficient. "
}], "MathCaption",
 CellID->6341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"2", ",", "13451", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->6575],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->372444908]
}, Open  ]],

Cell["This gives the modular inverse of 3 modulo 7. ", "MathCaption",
 CellID->17525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   RowBox[{"-", "1"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->6611],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->291527303]
}, Open  ]],

Cell["Multiplying the inverse by 3 modulo 7 gives 1, as expected. ", \
"MathCaption",
 CellID->26982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"3", "%"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->5783],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->243450473]
}, Open  ]],

Cell[TextData[{
 "This finds the smallest non\[Hyphen]negative integer ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " so that ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "mod", " ", "11"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->10503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   RowBox[{"1", "/", "2"}], ",", "11"}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->10948],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->297098584]
}, Open  ]],

Cell["This verifies the result. ", "MathCaption",
 CellID->30738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   SuperscriptBox["5", "2"], ",", "11"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->9126],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->410309483]
}, Open  ]],

Cell["\<\
This returns all integers less than 11 which satisfy the relation. \
\>", "MathCaption",
 CellID->9086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerModList", "[", 
  RowBox[{"3", ",", 
   RowBox[{"1", "/", "2"}], ",", "11"}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->8444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "6"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->293698761]
}, Open  ]],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " does not have a square root modulo ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"], "[", 
   RowBox[{
    StyleBox["d", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " will remain unevaluated and ",
 Cell[BoxData[
  ButtonBox["PowerModList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerModList"]], "InlineFormula"],
 " will return an empty list. "
}], "MathCaption",
 CellID->5025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   RowBox[{"1", "/", "2"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->11681],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerMod", "::", "\<\"root\"\>"}], ":", 
  " ", "\<\"The equation x^\\!\\(2\\) = \\!\\(3\\) (mod \\!\\(5\\)) has no \
integer solutions.\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[24]:=",
 CellID->844675230],

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   FractionBox["1", "2"], ",", "5"}], "]"}]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->150593292]
}, Open  ]],

Cell["This checks that 3 is not a square modulo 5. ", "MathCaption",
 CellID->798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}], "2"], ",", 
   "5"}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->9337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "4", ",", "4", ",", "1"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->123600801]
}, Open  ]],

Cell["\<\
Even for large modulus, the square root can be computed fairly quickly. \
\>", "MathCaption",
 CellID->31584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerMod", "[", 
   RowBox[{"2", ",", 
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{
     SuperscriptBox["10", "64"], "+", "57"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->15702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.009999999999997043`", ",", 
   "876504467496681643735926111996546100401033611976777074909122865"}], 
  "}"}]], "Output",
 ImageSize->{541, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->103617394]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PowerMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerMod"], "[", 
   RowBox[{
    StyleBox["d", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " also works for composite ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->7997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", 
   RowBox[{"1", "/", "2"}], ",", 
   SuperscriptBox["11", "3"]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->12686],

Cell[BoxData["578"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->181994226]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Euler totient function", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " gives the number of integers less than ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " that are relatively prime to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". An important relation (Fermat\[CloseCurlyQuote]s Little Theorem) is that \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["a", 
     RowBox[{"\[Phi]", 
      RowBox[{"(", "n", ")"}]}]], "\[Congruent]", "1", "mod", "n"}], 
   TraditionalForm]], "InlineMath"],
 " for all ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " relatively prime to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->28793],

Cell[TextData[{
 "The ",
 StyleBox["M\[ODoubleDot]bius function", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Mu]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "k"], TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is a product of ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " distinct primes, and ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " contains a squared factor (other than 1). An important relation is the M\
\[ODoubleDot]bius inversion formula, which states that if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"g", "(", "n", ")"}], "=", 
    RowBox[{
     UnderscriptBox["\[Sum]", 
      RowBox[{"d", " ", "\[VerticalSeparator]", " ", "n"}],
      LimitsPositioning->True], 
     RowBox[{"f", "(", "d", ")"}]}]}], TraditionalForm]], "InlineMath"],
 " for all ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", then ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "n", ")"}], "=", 
    RowBox[{
     UnderscriptBox["\[Sum]", 
      RowBox[{"d", " ", "\[VerticalSeparator]", " ", "n"}],
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{"\[Mu]", "(", "d", ")"}], 
      RowBox[{"g", "(", 
       RowBox[{"n", "/", "d"}], ")"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where the sums are over all positive integers ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " that divide ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->28050],

Cell[TextData[{
 "The ",
 StyleBox["divisor function", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", "k"], "(", "n", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is the sum of the ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " powers of the divisors of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", "0"], "(", "n", ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the total number of divisors of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", and is variously denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Tau]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 ". The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", "1"], "(", "n", ")"}], TraditionalForm]], 
  "InlineMath"],
 ", equal to the sum of the divisors of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", is often denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sigma]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->19679],

Cell[TextData[{
 "For prime ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[Phi]", "(", "n", ")"}], "=", 
    RowBox[{"n", "-", "1"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->18268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerPhi", "[", "17", "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->31274],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->586431333]
}, Open  ]],

Cell["\<\
The result is 1, as guaranteed by Fermat\[CloseCurlyQuote]s Little Theorem. \
\>", "MathCaption",
 CellID->32629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerMod", "[", 
  RowBox[{"3", ",", "%", ",", "17"}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->20335],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->114926512]
}, Open  ]],

Cell["This gives a list of all the divisors of 24. ", "MathCaption",
 CellID->24105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Divisors", "[", "24", "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->21511],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "6", ",", "8", ",", "12", ",", 
   "24"}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->66759079]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", "0"], "(", "n", ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the total number of distinct divisors of 24. "
}], "MathCaption",
 CellID->27824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DivisorSigma", "[", 
  RowBox[{"0", ",", "24"}], "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->27550],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->44236300]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["Jacobi symbol", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSymbol"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " reduces to the ",
 StyleBox["Legendre symbol", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    FractionBox["n", "m"], ")"}], TraditionalForm]], "InlineMath"],
 " when ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is an odd prime. The Legendre symbol is equal to zero if ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is divisible by ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", otherwise it is equal to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is a quadratic residue modulo the prime ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", and to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " if it is not. An integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " relatively prime to ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is said to be a quadratic residue modulo ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " if there exists an integer ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["k", "2"], "\[Congruent]", "n", "mod", "m"}], 
   TraditionalForm]], "InlineMath"],
 ". The full Jacobi symbol is a product of the Legendre symbols ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    FractionBox["n", 
     SubscriptBox["p", "i"]], ")"}], TraditionalForm]], "InlineMath"],
 " for each of the prime factors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["p", "i"], TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", 
    UnderscriptBox["\[Product]", "i",
     LimitsPositioning->True], 
    SubscriptBox["p", "i"]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->8060],

Cell[TextData[{
 "The ",
 StyleBox["extended gcd", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExtendedGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExtendedGCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives a list ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"g", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["r", "1"], ",", 
       SubscriptBox["r", "2"], ",", "\[Ellipsis]"}], "}"}]}], "}"}], 
   TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " is the greatest common divisor of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 ", and the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["r", "i"], TraditionalForm]], "InlineMath"],
 " are integers such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "=", 
    SubscriptBox["r", "1"], 
    SubscriptBox["n", "1"], "+", 
    SubscriptBox["r", "2"], 
    SubscriptBox["n", "2"], "+", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ". The extended gcd is important in finding integer solutions to linear \
Diophantine equations."
}], "Text",
 CellID->19801],

Cell["The first number in the list is the gcd of 105 and 196. ", "MathCaption",
 CellID->30759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExtendedGCD", "[", 
  RowBox[{"105", ",", "196"}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->29309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "13"}], ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->546704338]
}, Open  ]],

Cell[TextData[{
 "The second pair of numbers satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{"g", "=", "r", "m", "+", "s", "n"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->67],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "13"}], " ", "105"}], "+", 
  RowBox[{"7", " ", "196"}]}]], "Input",
 CellLabel->"In[33]:=",
 CellID->7300],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->126672561]
}, Open  ]],

Cell[TextData[{
 "The ",
 StyleBox["multiplicative order function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiplicativeOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
   RowBox[{
    StyleBox["k", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " gives the smallest integer ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["k", "m"], "\[Congruent]", "1", "mod", "n"}], 
   TraditionalForm]], "InlineMath"],
 ". The function is sometimes known as the ",
 StyleBox["index", "TB"],
 " or ",
 StyleBox["discrete log", "TB"],
 " of ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 ". The notation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["ord", "n"], "(", "k", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is occasionally used. "
}], "Text",
 CellID->8256],

Cell[TextData[{
 "The ",
 StyleBox["generalized multiplicative order function", "TB"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiplicativeOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
   RowBox[{
    StyleBox["k", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the smallest integer ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["k", "m"], "\[Congruent]", 
    SubscriptBox["r", "i"], "mod", "n"}], TraditionalForm]], "InlineMath"],
 " for some ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MultiplicativeOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiplicativeOrder"], "[", 
   RowBox[{
    StyleBox["k", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 " is sometimes known as the ",
 StyleBox["suborder function", "TB"],
 " of ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " modulo ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ", denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["sord", "n"], "(", "k", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Text",
 CellID->19140],

Cell[TextData[{
 "The ",
 StyleBox["Carmichael function", "TB"],
 " or ",
 StyleBox["least universal exponent", "TB"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Lambda]", 
    RowBox[{"(", "n", ")"}]}], TraditionalForm]], "InlineMath"],
 " gives the smallest integer ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["k", "m"], "\[Congruent]", "1", "mod", "n"}], 
   TraditionalForm]], "InlineMath"],
 " for all integers ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " relatively prime to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->10048],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ContinuedFraction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ContinuedFraction"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "generate the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " terms in the continued fraction representation of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FromContinuedFraction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FromContinuedFraction"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["\<\
reconstruct a number from its continued fraction representation\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Rationalize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Rationalize"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["dx", "TI"], "]"}], Cell[TextData[{
     "find a rational approximation to ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " with tolerance ",
     Cell[BoxData[
      FormBox[
       RowBox[{"d", "\[InvisibleSpace]", "x"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30270],

Cell["Continued fractions. ", "Caption",
 CellID->1725],

Cell[TextData[{
 "This generates the first 10 terms in the continued fraction representation \
for ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->5519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Pi", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->4809],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->386311201]
}, Open  ]],

Cell["\<\
This reconstructs the number represented by the list of continued fraction \
terms. \
\>", "MathCaption",
 CellID->6631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", "%", "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->8324],

Cell[BoxData[
 FractionBox["1146408", "364913"]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->39510906]
}, Open  ]],

Cell[TextData[{
 "The result is close to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->12725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->22301],

Cell[BoxData["3.141592653591404`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->252603283]
}, Open  ]],

Cell[TextData[{
 "This gives directly a rational approximation to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->3969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{"Pi", ",", 
   RowBox[{"1", "/", "1000"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->12488],

Cell[BoxData[
 FractionBox["201", "64"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->55132842]
}, Open  ]],

Cell[TextData[{
 StyleBox["Continued fractions", "TB"],
 " appear in many number\[Hyphen]theoretical settings. Rational numbers have \
terminating continued fraction representations. Quadratic irrational numbers \
have continued fraction representations that become repetitive. "
}], "Text",
 CellID->13963],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ContinuedFraction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ContinuedFraction"], "[", 
     StyleBox["x", "TI"], "]"}], Cell["\<\
the complete continued fraction representation for a rational or quadratic \
irrational number\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["QuadraticIrrationalQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/QuadraticIrrationalQ"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " is a quadratic irrational"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RealDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RealDigits"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[
    "the complete digit sequence for a rational number", "TableText"]},
   {
    RowBox[{
     ButtonBox["RealDigits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RealDigits"], "[", 
     StyleBox["x", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "the complete digit sequence in base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24124],

Cell["Complete representations for numbers. ", "Caption",
 CellID->7534],

Cell[TextData[{
 "The continued fraction representation of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["79"], TraditionalForm]], "InlineMath"],
 " starts with the term 8, then involves a sequence of terms that repeat \
forever. "
}], "MathCaption",
 CellID->27770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Sqrt", "[", "79", "]"}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->2851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "7", ",", "1", ",", "16"}], "}"}]}], "}"}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->26539852]
}, Open  ]],

Cell[TextData[{
 "This reconstructs ",
 Cell[BoxData[
  FormBox[
   SqrtBox["79"], TraditionalForm]], "InlineMath"],
 " from its continued fraction representation. "
}], "MathCaption",
 CellID->23724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", "%", "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->29511],

Cell[BoxData[
 SqrtBox["79"]], "Output",
 ImageSize->{35, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->388157477]
}, Open  ]],

Cell["This number is a quadratic irrational. ", "MathCaption",
 CellID->231086810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"QuadraticIrrationalQ", "[", " ", 
  RowBox[{"Sqrt", "[", "79", "]"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->416413754],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->595734826]
}, Open  ]],

Cell[TextData[{
 "This shows the recurring sequence of decimal digits in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "/", "7"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->30265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"3", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->20840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "8", ",", "5", ",", "7", ",", "1"}], "}"}], 
    "}"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->771287748]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromDigits"]], "InlineFormula"],
 " reconstructs the original number. "
}], "MathCaption",
 CellID->24955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", "%", "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->16028],

Cell[BoxData[
 FractionBox["3", "7"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->244165091]
}, Open  ]],

Cell[TextData[{
 StyleBox["Continued fraction convergents", "TB"],
 " are often used to approximate irrational numbers by rational ones. Those \
approximations alternate from above and below, and converge exponentially in \
the number of terms. Furthermore, a convergent ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "/", "q"}], TraditionalForm]], "InlineMath"],
 " of a simple continued fraction is better than any other rational \
approximation with denominator less than or equal to ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->150583992],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Convergents",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Convergents"], "[", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "give a list of rational approximations of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Convergents",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Convergents"], "[", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "give only the first ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " approximations"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.2800000000000001, {0.56}, 0.2800000000000001}, 
   "ColumnsIndexed" -> {}, "Rows" -> {0.2, {0.16}, 0.2}, 
   "RowsIndexed" -> {}}},
 CellID->256522711],

Cell["Continued fraction convergents. ", "Caption",
 CellID->317717459],

Cell["\<\
This gives a list of rational approximations of 101/9801, derived from its \
continued fraction expansion.\
\>", "MathCaption",
 CellID->433405108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", " ", 
  RowBox[{"101", "/", "9801"}], " ", "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->494608285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", "97"], ",", 
   FractionBox["25", "2426"], ",", 
   FractionBox["101", "9801"]}], "}"}]], "Output",
 ImageSize->{141, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->374975094]
}, Open  ]],

Cell["This lists only the first 10 convergents.", "MathCaption",
 CellID->467587602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", " ", 
  RowBox[{
   RowBox[{"10201", "/", "96059601"}], ",", " ", "10"}], " ", "]"}]], "Input",\

 CellLabel->"In[44]:=",
 CellID->165733916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", "9416"], ",", 
   FractionBox["1", "9417"], ",", 
   FractionBox["3", "28250"], ",", 
   FractionBox["16", "150667"], ",", 
   FractionBox["19", "178917"], ",", 
   FractionBox["92", "866335"], ",", 
   FractionBox["203", "1911587"], ",", 
   FractionBox["498", "4689509"], ",", 
   FractionBox["701", "6601096"]}], "}"}]], "Output",
 ImageSize->{549, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->64987589]
}, Open  ]],

Cell[TextData[{
 "This lists successive rational approximations to ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ", until the numerical precision is exhausted."
}], "MathCaption",
 CellID->359100584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", " ", 
  RowBox[{"N", "[", " ", "Pi", " ", "]"}], " ", "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->308489576],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   FractionBox["22", "7"], ",", 
   FractionBox["333", "106"], ",", 
   FractionBox["355", "113"], ",", 
   FractionBox["103993", "33102"], ",", 
   FractionBox["104348", "33215"], ",", 
   FractionBox["208341", "66317"], ",", 
   FractionBox["312689", "99532"], ",", 
   FractionBox["833719", "265381"], ",", 
   FractionBox["1146408", "364913"], ",", 
   FractionBox["4272943", "1360120"], ",", 
   FractionBox["5419351", "1725033"], ",", 
   FractionBox["80143857", "25510582"]}], "}"}]], "Output",
 ImageSize->{407, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->126230974]
}, Open  ]],

Cell["\<\
With an exact irrational number, you have to explicitly ask for a certain \
number of terms.\
\>", "MathCaption",
 CellID->386353913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Convergents", "[", " ", 
  RowBox[{"Pi", ",", " ", "10"}], " ", "]"}]], "Input",
 CellLabel->"In[46]:=",
 CellID->143034996],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   FractionBox["22", "7"], ",", 
   FractionBox["333", "106"], ",", 
   FractionBox["355", "113"], ",", 
   FractionBox["103993", "33102"], ",", 
   FractionBox["104348", "33215"], ",", 
   FractionBox["208341", "66317"], ",", 
   FractionBox["312689", "99532"], ",", 
   FractionBox["833719", "265381"], ",", 
   FractionBox["1146408", "364913"]}], "}"}]], "Output",
 ImageSize->{493, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]=",
 CellID->754097649]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LatticeReduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LatticeReduce"], "[", "{", 
     SubscriptBox[
      StyleBox["v", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "a reduced lattice basis for the set of integer vectors ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["v", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["HermiteDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HermiteDecomposition"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "the echelon form for the set of integer ",
     "vectors ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["v", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, {
     False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->1045986489],

Cell["Functions for integer lattices.", "Caption",
 CellID->217379925],

Cell[TextData[{
 "The lattice reduction function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LatticeReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LatticeReduce"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " is used in several kinds of modern algorithms. The basic idea is to think \
of the vectors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "k"], TraditionalForm]], "InlineMath"],
 " of integers as defining a mathematical ",
 StyleBox["lattice",
  FontSlant->"Italic"],
 ". Any vector representing a point in the lattice can be written as a linear \
combination of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sum]", 
    SubscriptBox["c", "k"], " ", 
    SubscriptBox["v", "k"]}], TraditionalForm]], "InlineMath"],
 ", where the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["c", "k"], TraditionalForm]], "InlineMath"],
 " are integers. For a particular lattice, there are many possible choices of \
the \[OpenCurlyDoubleQuote]basis vectors\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "k"], TraditionalForm]], "InlineMath"],
 ". What ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " does is to find a reduced set of basis vectors ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    OverscriptBox["v", "_"], "k"], TraditionalForm]], "InlineMath"],
 " for the lattice, with certain special properties. "
}], "Text",
 CellID->31655],

Cell["\<\
Three unit vectors along the three coordinate axes already form a reduced \
basis. \
\>", "MathCaption",
 CellID->1807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LatticeReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->14449],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->42777745]
}, Open  ]],

Cell["\<\
This gives the reduced basis for a lattice in four\[Hyphen]dimensional space \
specified by three vectors. \
\>", "MathCaption",
 CellID->18760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"l", "=", 
  RowBox[{"LatticeReduce", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "12345"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "12435"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "12354"}], "}"}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[48]:=",
 CellID->24382],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "1", ",", 
     RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"85", ",", 
     RowBox[{"-", "143"}], ",", "59", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[48]=",
 CellID->286031805]
}, Open  ]],

Cell[TextData[{
 "Notice that in the last example, ",
 Cell[BoxData[
  ButtonBox["LatticeReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LatticeReduce"]], "InlineFormula"],
 " replaces vectors that are nearly parallel by vectors that are more \
perpendicular. In the process, it finds some quite short basis vectors. "
}], "Text",
 CellID->30219],

Cell[TextData[{
 "For a matrix ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  ButtonBox["HermiteDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteDecomposition"]], "InlineFormula"],
 " gives matrices ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " is unimodular,",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"u", ".", "m"}], "=", "r"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " is in reduced row echelon form. In contrast to ",
 Cell[BoxData[
  ButtonBox["RowReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowReduce"]], "InlineFormula"],
 ", pivots may be larger than 1 because there are no fractions in the ring of \
integers. Entries above a pivot are minimized by subtracting appropriate \
multiples of the pivot row. "
}], "Text",
 CellID->217495362],

Cell["\<\
In this case, the original matrix is recovered because it was in row echelon \
form.\
\>", "MathCaption",
 CellID->223567287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "r"}], "}"}], "=", 
  RowBox[{"HermiteDecomposition", "[", "l", "]"}]}]], "Input",
 CellLabel->"In[49]:=",
 CellID->133222340],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1371", ",", "143", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1381", ",", "144", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1372", ",", "143", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "12345"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "12435"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "12354"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{372, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->255667519]
}, Open  ]],

Cell["This satisfies the required identities. ", "MathCaption",
 CellID->44750455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Det", "[", "u", "]"}], "]"}], "\[Equal]", "1"}], ",", 
   RowBox[{
    RowBox[{"u", ".", "l"}], "\[Equal]", "r"}]}], "}"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->57119199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->70210096]
}, Open  ]],

Cell["\<\
Here the second matrix has some pivots larger than 1, and nonzero entries \
over pivots.\
\>", "MathCaption",
 CellID->151137100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "9", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "4"}], ",", "2", ",", 
      RowBox[{"-", "11"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->204512874],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "11", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "23", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "13"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{475, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]=",
 CellID->260358485]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DigitCount",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DigitCount"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "the number of ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     " digits in the base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     " representation of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2432],

Cell["Digit count function. ", "Caption",
 CellID->18227],

Cell["\<\
Here are the digits in the base 2 representation of the number 77. \
\>", "MathCaption",
 CellID->30160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"77", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->16139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->500837272]
}, Open  ]],

Cell["\<\
This directly computes the number of ones in the base 2 representation. \
\>", "MathCaption",
 CellID->22237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DigitCount", "[", 
  RowBox[{"77", ",", "2", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->32048],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->128837515]
}, Open  ]],

Cell["\<\
The plot of the digit count function is self\[Hyphen]similar.\
\>", "MathCaption",
 CellID->24404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DigitCount", "[", 
     RowBox[{"n", ",", "2", ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "128"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[54]:=",
 CellID->7946703],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlUtOQkEQRV8cOXTgwIEDNcYYY4z/v9IioiKigICAfGLi2C3U0mpJLEGN
fQd1SEzneOr27X4vhNXP79bXXFEU9vv3t/5/ZqW4FinyfIr/X4BfhF8CL6e4
zwrya5hfB28gvwm/Bb8N3sG5d9G/h/32wQfY7xD+CP4YfIL+U+TPMH8OvkD+
Ev4K/hpcyqveU8prvr+JdZ6byCZWXxm+DH8b2cQ6TwX5Spwv7pAXK1+Fr8Lf
Rzax7v+AfrH6H7G/WPvX4GvwT+gXq7+OfD3OF8/Ii5VvwDfgXyKbWN/L17zm
95/Eeh5gF+v5NKNPzegN7GLdr4V8K84b2MXKt6NP7egN7GI9nzf0i9UPdrH6
O+jvRG9gF6u/i3w3zhvYxcr3ok+96A3sYr3/97zq/mLdH+xi3b+P8/ejN7CL
df4B8oM4b2AXKz+MPg2jN7CLdf8P9IvVD3ax+kfoH0VvYBerf4z8OM4b2MXK
T6JPk+gN7GL9Dk/zOiv9AOXFlIU=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0., 128.}, {1., 7.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[54]=",
 CellID->440221745]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["BitAnd",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitAnd"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "bitwise AND of the integers ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitOr",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitOr"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "bitwise OR of the integers ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitXor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitXor"], "[", 
     SubscriptBox[
      StyleBox["n", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["n", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[TextData[{
     "bitwise XOR of the integers ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitNot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitNot"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "bitwise NOT of the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitLength",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitLength"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "number of binary bits in the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitSet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitSet"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[TextData[{
     "set bit ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " to 1 in the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitGet",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitGet"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[TextData[{
     "get bit ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " from the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitClear",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitClear"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[TextData[{
     "set bit ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " to 0 in the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitShiftLeft",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitShiftLeft"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[TextData[{
     "shift the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " to the left by ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " bits, padding with zeros"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["BitShiftRight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/BitShiftRight"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"]}], "]"}], Cell[TextData[{
     "shift to the right, dropping the last ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " bits"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28221],

Cell["Bitwise operations. ", "Caption",
 CellID->22133],

Cell[TextData[{
 "Bitwise operations act on integers represented as binary bits. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitAnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitAnd"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " yields the integer whose binary bit representation has ones at positions \
where the binary bit representations of all of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " have ones. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitOr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitOr"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " yields the integer with ones at positions where any of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " have ones. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitXor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitXor"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " yields the integer with ones at positions where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "2"], TraditionalForm]], "InlineMath"],
 " but not both have ones. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitXor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitXor"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " has ones where an odd number of the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " have ones. "
}], "Text",
 CellID->13175],

Cell["\<\
This finds the bitwise AND of the numbers 23 and 29 entered in base 2. \
\>", "MathCaption",
 CellID->6241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"BitAnd", "[", 
    RowBox[{"2^^10111", ",", "2^^11101"}], "]"}], ",", "2"}], "]"}]], "Input",\

 CellLabel->"In[55]:=",
 CellID->32514],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"10101\"\>", "\<\"2\"\>"],
   21,
   Editable->False],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[55]//BaseForm=",
 CellID->564008673]
}, Open  ]],

Cell[TextData[{
 "Bitwise operations are used in various combinatorial algorithms. They are \
also commonly used in manipulating bitfields in low\[Hyphen]level computer \
languages. In such languages, however, integers normally have a limited \
number of digits, typically a multiple of 8. Bitwise operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in effect allow integers to have an unlimited number of digits. When an \
integer is negative, it is taken to be represented in two\[CloseCurlyQuote]s \
complement form, with an infinite sequence of ones on the left. This allows \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BitNot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitNot"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " to be equivalent simply to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "-", "n"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->17362],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SquareFreeQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SquareFreeQ"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " does not contain a squared factor, ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->26641],

Cell["Testing for a squared factor. ", "Caption",
 CellID->3578],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SquareFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquareFreeQ"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " checks to see if ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " has a square prime factor. This is done by computing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MoebiusMu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MoebiusMu"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " and seeing if the result is zero; if it is, then ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is not squarefree, otherwise it is. Computing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MoebiusMu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MoebiusMu"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " involves finding the smallest prime factor ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". If ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " has a small prime factor (less than or equal to ",
 Cell[BoxData[
  FormBox["1223", TraditionalForm]], "InlineMath"],
 "), this is very fast. Otherwise, ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " is used to find ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->5656],

Cell["This product of primes contains no squared factors. ", "MathCaption",
 CellID->21057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{"2", " ", "3", " ", "5", " ", "7"}], "]"}]], "Input",
 CellLabel->"In[56]:=",
 CellID->24592],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[56]=",
 CellID->265118806]
}, Open  ]],

Cell[TextData[{
 "The square number ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineMath"],
 " divides ",
 Cell[BoxData[
  FormBox["60", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->2039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", "60", "]"}]], "Input",
 CellLabel->"In[57]:=",
 CellID->3446],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[57]=",
 CellID->293385022]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SquareFreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SquareFreeQ"]], "InlineFormula"],
 " can handle large integers. "
}], "MathCaption",
 CellID->2232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SquareFreeQ", "[", 
  RowBox[{
   SuperscriptBox["2", "101"], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->6999],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[58]=",
 CellID->331952130]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NextPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NextPrime"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the smallest prime larger than ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomPrime"], "[", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["min", "TI"], ",", 
       StyleBox["max", "TI"]}], "}"}], "]"}], Cell[TextData[{
     "return a random prime number between ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomPrime"], "[", 
     StyleBox["max", "TI"], "]"}], Cell[TextData[{
     "return a random prime number between less than or equal to ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomPrime"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["min", "TI"], ",", 
        StyleBox["max", "TI"]}], "}"}], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "return ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " random prime numbers between ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RandomPrime",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RandomPrime"], "[", 
     RowBox[{
      StyleBox["max", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "return ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " random prime numbers",
     " ",
     "less than or equal to ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1578],

Cell["Finding prime numbers. ", "Caption",
 CellID->21735],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NextPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NextPrime"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " finds the smallest prime ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", ">", "n"}], TraditionalForm]], "InlineMath"],
 ". For ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " less than 20 digits, the algorithm does a direct search using ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 " on the odd numbers greater than ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ". For ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " with more than 20 digits, the algorithm builds a small sieve and first \
checks to see whether the candidate prime is divisible by a small prime \
before using ",
 Cell[BoxData[
  ButtonBox["PrimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
 ". This seems to be slightly faster than a direct search."
}], "Text",
 CellID->3080],

Cell[TextData[{
 "This gives the next prime after ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->24394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NextPrime", "[", "10", "]"}]], "Input",
 CellLabel->"In[59]:=",
 CellID->4996],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[59]=",
 CellID->123920150]
}, Open  ]],

Cell["\<\
Even for large numbers, the next prime can be computed rather quickly. \
\>", "MathCaption",
 CellID->32102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NextPrime", "[", 
   SuperscriptBox["10", "100"], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[60]:=",
 CellID->18251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.05999999999999944`", ",", 
   "10000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000267"}], "}"}]], "Output",
 ImageSize->{590, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[60]=",
 CellID->420566719]
}, Open  ]],

Cell[TextData[{
 "This gives the largest prime less than ",
 Cell[BoxData[
  FormBox["34", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->18597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"NextPrime", "[", 
   RowBox[{"-", "34"}], "]"}]}]], "Input",
 CellLabel->"In[61]:=",
 CellID->30342],

Cell[BoxData["31"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[61]=",
 CellID->40296029]
}, Open  ]],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["min", "TI"], ",", 
     StyleBox["max", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 StyleBox[" ", "MR"],
 "and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomPrime"], "[", 
   StyleBox["max", "TI"], "]"}]], "InlineFormula"],
 ", a random prime ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is obtained by randomly selecting from a prime lookup table if ",
 StyleBox["max",
  FontSlant->"Italic"],
 " is small and by a random search of integers in the range if ",
 StyleBox["max",
  FontSlant->"Italic"],
 " is large. If no prime exists in the specified range, the input is returned \
unevaluated with an error message. "
}], "Text",
 CellID->24158],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s a random prime between ",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["100", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->14746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomPrime", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "100"}], "}"}], "]"}]], "Input",
 CellLabel->"In[62]:=",
 CellID->20671],

Cell[BoxData["79"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[62]=",
 CellID->635074538]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PrimePowerQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimePowerQ"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "determine whether ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " is a positive integer power of a rational prime"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->17129],

Cell["Testing for involving prime powers. ", "Caption",
 CellID->9228],

Cell[TextData[{
 "The algorithm for ",
 Cell[BoxData[
  ButtonBox["PrimePowerQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrimePowerQ"]], "InlineFormula"],
 " involves first computing the least prime factor ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " and then attempting division by ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " until either ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " is obtained, in which case ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is a prime power, or until division is no longer possible, in which case \
",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is not a prime power. "
}], "Text",
 CellID->8392],

Cell["Here is a number that is a power of a single prime. ", "MathCaption",
 CellID->23669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimePowerQ", "[", "12167", "]"}]], "Input",
 CellLabel->"In[63]:=",
 CellID->8564],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[63]=",
 CellID->55497200]
}, Open  ]],

Cell[TextData[{
 "Over the ",
 Cell[BoxData[
  ButtonBox["GaussianIntegers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GaussianIntegers"]], "InlineFormula"],
 " this is a prime power. "
}], "MathCaption",
 CellID->15452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimePowerQ", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[64]:=",
 CellID->22721],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[64]=",
 CellID->200531377]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ChineseRemainder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ChineseRemainder"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[TextData[{
     "give the smallest non-negative integer ",
     Cell[BoxData[
      FormBox["r", TraditionalForm]], "InlineMath"],
     " with ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        ButtonBox["Mod",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Mod"], "[", 
        RowBox[{
         StyleBox["r", "TI"], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]]}], "]"}], "==", 
       SubscriptBox[
        StyleBox["list", "TI"], 
        StyleBox["1", "TR"]]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->5065],

Cell["Solving simultaneous congruences. ", "Caption",
 CellID->20068],

Cell[TextData[{
 "The ",
 "Chinese Remainder Theorem",
 " states that a certain class of simultaneous congruences always has a \
solution. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ChineseRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChineseRemainder"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " finds the smallest non\[Hyphen]negative integer ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " such that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list",
     FontSlant->"Italic"], "1"], TraditionalForm]], "InlineMath"],
 ". The solution is unique modulo the least common multiple of the elements \
of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["list",
     FontSlant->"Italic"], "2"], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->17697],

Cell[TextData[{
 "This means that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"244", "\[Congruent]", 
    RowBox[{"0", " ", "mod", " ", "4"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"244", "\[Congruent]", 
    RowBox[{"1", " ", "mod", " ", "9"}]}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"244", "\[Congruent]", 
    RowBox[{"2", " ", "mod", " ", "121"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "MathCaption",
 CellID->7533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "9", ",", "121"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[65]:=",
 CellID->3691],

Cell[BoxData["244"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[65]=",
 CellID->114800479]
}, Open  ]],

Cell["This confirms the result. ", "MathCaption",
 CellID->2821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"244", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "9", ",", "121"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[66]:=",
 CellID->2902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[66]=",
 CellID->136990314]
}, Open  ]],

Cell["Longer lists are still quite fast. ", "MathCaption",
 CellID->17601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], ",", 
   RowBox[{"Prime", "[", 
    RowBox[{"Range", "[", "20", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[67]:=",
 CellID->14222],

Cell[BoxData["169991099649125127278835143"], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[67]=",
 CellID->21814270]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PrimitiveRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PrimitiveRoot"], "[", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give a primitive root of ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " is a prime power or twice a prime power"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->6879],

Cell["Computing primitive roots. ", "Caption",
 CellID->5815],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PrimitiveRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimitiveRoot"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " returns a generator for the group of numbers relatively prime to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " under multiplication ",
 Cell[BoxData[
  FormBox[
   RowBox[{"mod", " ", "n"}], TraditionalForm]], "InlineMath"],
 ". This has a generator if and only if ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is 2, 4, a power of an odd prime, or twice a power of an odd prime. If ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is a prime or prime power, the least positive primitive root will be \
returned. "
}], "Text",
 CellID->29159],

Cell[TextData[{
 "Here is a primitive root of ",
 Cell[BoxData[
  FormBox["5", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->10847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", "5", "]"}]], "Input",
 CellLabel->"In[68]:=",
 CellID->16462],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[68]=",
 CellID->6667889]
}, Open  ]],

Cell["This confirms that it does generate the group. ", "MathCaption",
 CellID->31862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"Range", "[", "4", "]"}]], ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[69]:=",
 CellID->279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[69]=",
 CellID->483775748]
}, Open  ]],

Cell["Here is a primitive root of a prime power. ", "MathCaption",
 CellID->28541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", 
  SuperscriptBox["1093", "3"], "]"}]], "Input",
 CellLabel->"In[70]:=",
 CellID->29359],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[70]=",
 CellID->344128405]
}, Open  ]],

Cell["Here is a primitive root of twice a prime power. ", "MathCaption",
 CellID->20622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", 
  RowBox[{"2", " ", 
   SuperscriptBox["5", "5"]}], "]"}]], "Input",
 CellLabel->"In[71]:=",
 CellID->1878],

Cell[BoxData["3127"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[71]=",
 CellID->711622727]
}, Open  ]],

Cell["\<\
If the argument is composite and not a prime power or twice a prime power, \
the function does not evaluate. \
\>", "MathCaption",
 CellID->3908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", 
  RowBox[{"11", " ", "13"}], "]"}]], "Input",
 CellLabel->"In[72]:=",
 CellID->8402],

Cell[BoxData[
 RowBox[{"PrimitiveRoot", "[", "143", "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[72]=",
 CellID->238245695]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SquaresR",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SquaresR"], "[", 
     RowBox[{
      StyleBox["d", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "give the number of representations of an integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " as a sum of ",
     Cell[BoxData[
      FormBox["d", TraditionalForm]], "InlineMath"],
     " squares"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PowersRepresentations",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PowersRepresentations"], "[", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      StyleBox["k", "TI"], ",", 
      StyleBox["p", "TI"]}], "]"}], Cell[TextData[{
     "give the distinct representations of the integer ",
     Cell[BoxData[
      FormBox["n", TraditionalForm]], "InlineMath"],
     " as a sum of ",
     Cell[BoxData[
      FormBox["k", TraditionalForm]], "InlineMath"],
     " non-negative ",
     Cell[BoxData[
      FormBox["p", TraditionalForm]], "InlineMath"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " integer powers"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->12436],

Cell["\<\
Representing an integer as a sum of squares or other powers. \
\>", "Caption",
 CellID->21903],

Cell[TextData[{
 "Here are the representations of ",
 Cell[BoxData[
  FormBox["100", TraditionalForm]], "InlineMath"],
 " as a sum of ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineMath"],
 " squares. "
}], "MathCaption",
 CellID->17980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowersRepresentations", "[", 
  RowBox[{"101", ",", "3", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[73]:=",
 CellID->14589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "7"}], "}"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[73]=",
 CellID->213732321]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->43426385],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MathematicalFunctionsOverview"]], "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integer and Number-Theoretical Functions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Mathematical Functions", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/MathematicalFunctionsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PseudorandomNumbers"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/CombinatorialFunctions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 37, 35.2241618}", "context" -> "", 
    "keywords" -> {
     "add", "algebraic extensions", "aliquant", "and", "approximation", 
      "arithmetic", "arithmetical functions", "arrays", "basis vectors", 
      "BitAnd", "BitClear", "bit count", "bit fields", "BitGet", "BitLength", 
      "BitNot", "bit operations", "BitOr", "BitSet", "BitShiftLeft", 
      "BitShiftRight", "bitwise operations", "BitXor", "CarmichaelLambda", 
      "carry", "combinatorial algorithms", "common denominator", 
      "complex integers", "ContinuedFraction", "continued fractions", 
      "Convergents", "coprime", "CoprimeQ", "count of digits", 
      "cyclic indices", "decomposition into primes", "delta", "digital sums", 
      "DigitCount", "digit operations", "digit sequences", 
      "Diophantine equations", "discrete log", "Divisible", "division", 
      "divisor function", "divisors", "DivisorSigma", "EulerPhi", "exponent", 
      "ExtendedGCD", "factoring", "FactorInteger", "Fermat Little Theorem", 
      "finite fields", "fractal", "FromContinuedFraction", "functions", 
      "Gaussian integers", "GaussianIntegers", "GCD", "GCF", 
      "greatest common divisor", "greatest dividing exponent", "group order", 
      "half adder", "hamming weight", "height", "highest common factor", 
      "index function", "IntegerDigits", "IntegerExponent", 
      "integer factoring", "integers", "inverses in finite fields", 
      "JacobiSymbol", "KroneckerDelta", "lambda function", "LatticeReduce", 
      "LCM", "least common multiple", "least universal exponent", 
      "Legendre symbol", "Lenstra-Lenstra-Lovasz algorithm", 
      "linear congruences", "logarithm", "lowest terms", "mask", 
      "Mobius function", "Mobius inversion formula", "mod", 
      "modular inverses", "modular powers", "modular root", "modulo", 
      "MoebiusMu", "MultiplicativeOrder", "Nim addition", "not", 
      "number representation", "number theory", "one-origin arrays", "ones", 
      "or", "order", "origin", "partial quotients", "population count", 
      "power", "PowerMod", "Primality testing", "prime", "prime factors", 
      "PrimePi", "PrimeQ", "primes", "primitive root", 
      "quadratic irrationals", "quadratic residues", "quotient", 
      "rational approximation", "rationalize", "RealDigits", 
      "recurring decimals", "relative primality", "remainder", 
      "representation", "residue", "Root", "ruler function", "self-similar", 
      "smallest universal exponent", "Submultiples", "Surds", 
      "Totient function", "two's complement representation", 
      "universal exponent", "wraparound", "xor", "zero-origin arrays", 
      "zeros"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Some integer functions. The remainder on dividing 17 by 3. The integer \
part of 17/3. ", "synonyms" -> {"3.2.5"}, "title" -> 
    "Integer and Number-Theoretical Functions", "type" -> "Tutorial", "uri" -> 
    "tutorial/IntegerAndNumberTheoreticalFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.2.5"->{
  Cell[7673, 149, 119, 4, 70, "Title",
   CellTags->{"S3.2.5", "5.1"},
   CellID->20170]},
 "5.1"->{
  Cell[7673, 149, 119, 4, 70, "Title",
   CellTags->{"S3.2.5", "5.1"},
   CellID->20170]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.2.5", 129887, 4679},
 {"5.1", 129988, 4683}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 7048, 122, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[7673, 149, 119, 4, 70, "Title",
 CellTags->{"S3.2.5", "5.1"},
 CellID->20170],
Cell[7795, 155, 5060, 171, 70, "DefinitionBox",
 CellID->18494],
Cell[12858, 328, 58, 1, 70, "Caption",
 CellID->20216],
Cell[12919, 331, 225, 9, 70, "MathCaption",
 CellID->12729],
Cell[CellGroupData[{
Cell[13169, 344, 119, 4, 28, "Input",
 CellID->29726],
Cell[13291, 350, 156, 5, 36, "Output",
 CellID->5929171]
}, Open  ]],
Cell[13462, 358, 170, 7, 70, "MathCaption",
 CellID->29915],
Cell[CellGroupData[{
Cell[13657, 369, 124, 4, 28, "Input",
 CellID->28672],
Cell[13784, 375, 155, 5, 36, "Output",
 CellID->656088]
}, Open  ]],
Cell[13954, 383, 194, 7, 70, "MathCaption",
 CellID->15862],
Cell[CellGroupData[{
Cell[14173, 394, 121, 4, 28, "Input",
 CellID->6421],
Cell[14297, 400, 175, 5, 36, "Output",
 CellID->38124542]
}, Open  ]],
Cell[14487, 408, 234, 8, 70, "MathCaption",
 CellID->11128],
Cell[CellGroupData[{
Cell[14746, 420, 141, 5, 70, "Input",
 CellID->21465],
Cell[14890, 427, 175, 5, 36, "Output",
 CellID->9747796]
}, Open  ]],
Cell[15080, 435, 792, 31, 70, "Text",
 CellID->259],
Cell[15875, 468, 2175, 71, 70, "DefinitionBox",
 CellID->24082],
Cell[18053, 541, 67, 1, 70, "Caption",
 CellID->5389],
Cell[18123, 544, 289, 9, 70, "Text",
 CellID->24986],
Cell[18415, 555, 226, 7, 70, "MathCaption",
 CellID->21419],
Cell[CellGroupData[{
Cell[18666, 566, 245, 8, 70, "Input",
 CellID->12735],
Cell[18914, 576, 158, 5, 36, "Output",
 CellID->607838148]
}, Open  ]],
Cell[19087, 584, 906, 31, 70, "Text",
 CellID->18666],
Cell[19996, 617, 621, 23, 70, "Text",
 CellID->13632],
Cell[20620, 642, 93, 1, 70, "MathCaption",
 CellID->13485],
Cell[CellGroupData[{
Cell[20738, 647, 120, 4, 70, "Input",
 CellID->15822],
Cell[20861, 653, 158, 5, 36, "Output",
 CellID->476737240]
}, Open  ]],
Cell[21034, 661, 852, 31, 70, "Text",
 CellID->5161],
Cell[21889, 694, 88, 1, 70, "MathCaption",
 CellID->11896],
Cell[CellGroupData[{
Cell[22002, 699, 192, 6, 28, "Input",
 CellID->26141],
Cell[22197, 707, 927, 19, 54, "Output",
 Evaluatable->False,
 CellID->192970065]
}, Open  ]],
Cell[23139, 729, 3900, 126, 70, "DefinitionBox",
 CellID->28432],
Cell[27042, 857, 74, 1, 70, "Caption",
 CellID->5872],
Cell[27119, 860, 354, 12, 70, "MathCaption",
 CellID->32361],
Cell[CellGroupData[{
Cell[27498, 876, 105, 3, 70, "Input",
 CellID->4770],
Cell[27606, 881, 302, 11, 36, "Output",
 CellID->528529576]
}, Open  ]],
Cell[27923, 895, 81, 1, 70, "MathCaption",
 CellID->27165],
Cell[CellGroupData[{
Cell[28029, 900, 122, 3, 70, "Input",
 CellID->25645],
Cell[28154, 905, 669, 23, 36, "Output",
 CellID->183957873]
}, Open  ]],
Cell[28838, 931, 684, 16, 70, "Text",
 CellID->1810],
Cell[29525, 949, 78, 1, 70, "MathCaption",
 CellID->32128],
Cell[CellGroupData[{
Cell[29628, 954, 85, 3, 70, "Input",
 CellID->25970],
Cell[29716, 959, 191, 5, 36, "Output",
 CellID->28191979]
}, Open  ]],
Cell[29922, 967, 143, 5, 70, "MathCaption",
 CellID->3596],
Cell[CellGroupData[{
Cell[30090, 976, 106, 3, 70, "Input",
 CellID->15004],
Cell[30199, 981, 782, 27, 36, "Output",
 CellID->80691484]
}, Open  ]],
Cell[30996, 1011, 483, 16, 70, "Text",
 CellID->20799],
Cell[31482, 1029, 126, 4, 70, "MathCaption",
 CellID->23210],
Cell[CellGroupData[{
Cell[31633, 1037, 107, 3, 70, "Input",
 CellID->25269],
Cell[31743, 1042, 163, 5, 36, "Output",
 CellID->176686160]
}, Open  ]],
Cell[31921, 1050, 79, 1, 70, "MathCaption",
 CellID->32235],
Cell[CellGroupData[{
Cell[32025, 1055, 242, 8, 70, "Input",
 CellID->471],
Cell[32270, 1065, 1080, 27, 134, "Output",
 CellID->616549603]
}, Open  ]],
Cell[33365, 1095, 68, 1, 70, "MathCaption",
 CellID->11830],
Cell[CellGroupData[{
Cell[33458, 1100, 103, 3, 70, "Input",
 CellID->6382],
Cell[33564, 1105, 165, 5, 36, "Output",
 CellID->37544849]
}, Open  ]],
Cell[33744, 1113, 587, 18, 70, "Text",
 CellID->26395],
Cell[34334, 1133, 92, 1, 70, "MathCaption",
 CellID->27151],
Cell[CellGroupData[{
Cell[34451, 1138, 124, 4, 70, "Input",
 CellID->20666],
Cell[34578, 1144, 166, 5, 36, "Output",
 CellID->382747224]
}, Open  ]],
Cell[34759, 1152, 1231, 35, 70, "Text",
 CellID->28710],
Cell[35993, 1189, 321, 13, 70, "MathCaption",
 CellID->26758],
Cell[CellGroupData[{
Cell[36339, 1206, 171, 5, 70, "Input",
 CellID->7372],
Cell[36513, 1213, 377, 14, 36, "Output",
 CellID->592688173]
}, Open  ]],
Cell[36905, 1230, 83, 1, 70, "MathCaption",
 CellID->17906],
Cell[CellGroupData[{
Cell[37013, 1235, 224, 7, 70, "Input",
 CellID->30014],
Cell[37240, 1244, 469, 17, 36, "Output",
 CellID->161268052]
}, Open  ]],
Cell[37724, 1264, 4701, 150, 70, "DefinitionBox",
 CellID->20284],
Cell[42428, 1416, 69, 1, 70, "Caption",
 CellID->29905],
Cell[42500, 1419, 1060, 41, 70, "Text",
 CellID->25812],
Cell[43563, 1462, 1349, 47, 70, "Text",
 CellID->28021],
Cell[44915, 1511, 465, 17, 70, "MathCaption",
 CellID->6341],
Cell[CellGroupData[{
Cell[45405, 1532, 137, 4, 70, "Input",
 CellID->6575],
Cell[45545, 1538, 159, 5, 36, "Output",
 CellID->372444908]
}, Open  ]],
Cell[45719, 1546, 85, 1, 70, "MathCaption",
 CellID->17525],
Cell[CellGroupData[{
Cell[45829, 1551, 152, 5, 70, "Input",
 CellID->6611],
Cell[45984, 1558, 159, 5, 36, "Output",
 CellID->291527303]
}, Open  ]],
Cell[46158, 1566, 101, 2, 70, "MathCaption",
 CellID->26982],
Cell[CellGroupData[{
Cell[46284, 1572, 137, 5, 70, "Input",
 CellID->5783],
Cell[46424, 1579, 159, 5, 36, "Output",
 CellID->243450473]
}, Open  ]],
Cell[46598, 1587, 395, 14, 70, "MathCaption",
 CellID->10503],
Cell[CellGroupData[{
Cell[47018, 1605, 159, 5, 70, "Input",
 CellID->10948],
Cell[47180, 1612, 159, 5, 36, "Output",
 CellID->297098584]
}, Open  ]],
Cell[47354, 1620, 65, 1, 70, "MathCaption",
 CellID->30738],
Cell[CellGroupData[{
Cell[47444, 1625, 144, 5, 70, "Input",
 CellID->9126],
Cell[47591, 1632, 159, 5, 36, "Output",
 CellID->410309483]
}, Open  ]],
Cell[47765, 1640, 113, 3, 70, "MathCaption",
 CellID->9086],
Cell[CellGroupData[{
Cell[47903, 1647, 162, 5, 70, "Input",
 CellID->8444],
Cell[48068, 1654, 204, 7, 36, "Output",
 CellID->293698761]
}, Open  ]],
Cell[48287, 1664, 642, 23, 70, "MathCaption",
 CellID->5025],
Cell[CellGroupData[{
Cell[48954, 1691, 158, 5, 70, "Input",
 CellID->11681],
Cell[49115, 1698, 263, 6, 70, "Message",
 CellID->844675230],
Cell[49381, 1706, 249, 8, 51, "Output",
 CellID->150593292]
}, Open  ]],
Cell[49645, 1717, 82, 1, 70, "MathCaption",
 CellID->798],
Cell[CellGroupData[{
Cell[49752, 1722, 228, 8, 70, "Input",
 CellID->9337],
Cell[49983, 1732, 234, 7, 36, "Output",
 CellID->123600801]
}, Open  ]],
Cell[50232, 1742, 119, 3, 70, "MathCaption",
 CellID->31584],
Cell[CellGroupData[{
Cell[50376, 1749, 247, 9, 70, "Input",
 CellID->15702],
Cell[50626, 1760, 297, 10, 36, "Output",
 CellID->103617394]
}, Open  ]],
Cell[50938, 1773, 366, 14, 70, "MathCaption",
 CellID->7997],
Cell[CellGroupData[{
Cell[51329, 1791, 184, 6, 70, "Input",
 CellID->12686],
Cell[51516, 1799, 161, 5, 36, "Output",
 CellID->181994226]
}, Open  ]],
Cell[51692, 1807, 857, 30, 70, "Text",
 CellID->28793],
Cell[52552, 1839, 1781, 61, 70, "Text",
 CellID->28050],
Cell[54336, 1902, 1464, 54, 70, "Text",
 CellID->19679],
Cell[55803, 1958, 290, 12, 70, "MathCaption",
 CellID->18268],
Cell[CellGroupData[{
Cell[56118, 1974, 102, 3, 70, "Input",
 CellID->31274],
Cell[56223, 1979, 160, 5, 36, "Output",
 CellID->586431333]
}, Open  ]],
Cell[56398, 1987, 123, 3, 70, "MathCaption",
 CellID->32629],
Cell[CellGroupData[{
Cell[56546, 1994, 135, 4, 70, "Input",
 CellID->20335],
Cell[56684, 2000, 159, 5, 36, "Output",
 CellID->114926512]
}, Open  ]],
Cell[56858, 2008, 84, 1, 70, "MathCaption",
 CellID->24105],
Cell[CellGroupData[{
Cell[56967, 2013, 102, 3, 70, "Input",
 CellID->21511],
Cell[57072, 2018, 273, 9, 36, "Output",
 CellID->66759079]
}, Open  ]],
Cell[57360, 2030, 233, 8, 70, "MathCaption",
 CellID->27824],
Cell[CellGroupData[{
Cell[57618, 2042, 129, 4, 70, "Input",
 CellID->27550],
Cell[57750, 2048, 158, 5, 36, "Output",
 CellID->44236300]
}, Open  ]],
Cell[57923, 2056, 2233, 78, 70, "Text",
 CellID->8060],
Cell[60159, 2136, 1375, 50, 70, "Text",
 CellID->19801],
Cell[61537, 2188, 95, 1, 70, "MathCaption",
 CellID->30759],
Cell[CellGroupData[{
Cell[61657, 2193, 131, 4, 70, "Input",
 CellID->29309],
Cell[61791, 2199, 275, 10, 36, "Output",
 CellID->546704338]
}, Open  ]],
Cell[62081, 2212, 206, 8, 70, "MathCaption",
 CellID->67],
Cell[CellGroupData[{
Cell[62312, 2224, 158, 6, 70, "Input",
 CellID->7300],
Cell[62473, 2232, 159, 5, 36, "Output",
 CellID->126672561]
}, Open  ]],
Cell[62647, 2240, 955, 36, 70, "Text",
 CellID->8256],
Cell[63605, 2278, 1655, 61, 70, "Text",
 CellID->19140],
Cell[65263, 2341, 704, 27, 70, "Text",
 CellID->10048],
Cell[65970, 2370, 1592, 47, 70, "DefinitionBox",
 CellID->30270],
Cell[67565, 2419, 55, 1, 70, "Caption",
 CellID->1725],
Cell[67623, 2422, 209, 7, 70, "MathCaption",
 CellID->5519],
Cell[CellGroupData[{
Cell[67857, 2433, 134, 4, 70, "Input",
 CellID->4809],
Cell[67994, 2439, 295, 9, 36, "Output",
 CellID->386311201]
}, Open  ]],
Cell[68304, 2451, 130, 4, 70, "MathCaption",
 CellID->6631],
Cell[CellGroupData[{
Cell[68459, 2459, 113, 3, 70, "Input",
 CellID->8324],
Cell[68575, 2464, 189, 6, 51, "Output",
 CellID->39510906]
}, Open  ]],
Cell[68779, 2473, 152, 6, 70, "MathCaption",
 CellID->12725],
Cell[CellGroupData[{
Cell[68956, 2483, 94, 3, 70, "Input",
 CellID->22301],
Cell[69053, 2488, 176, 5, 36, "Output",
 CellID->252603283]
}, Open  ]],
Cell[69244, 2496, 176, 6, 70, "MathCaption",
 CellID->3969],
Cell[CellGroupData[{
Cell[69445, 2506, 155, 5, 70, "Input",
 CellID->12488],
Cell[69603, 2513, 181, 6, 51, "Output",
 CellID->55132842]
}, Open  ]],
Cell[69799, 2522, 307, 6, 70, "Text",
 CellID->13963],
Cell[70109, 2530, 1568, 47, 70, "DefinitionBox",
 CellID->24124],
Cell[71680, 2579, 72, 1, 70, "Caption",
 CellID->7534],
Cell[71755, 2582, 260, 8, 70, "MathCaption",
 CellID->27770],
Cell[CellGroupData[{
Cell[72040, 2594, 141, 4, 70, "Input",
 CellID->2851],
Cell[72184, 2600, 274, 9, 36, "Output",
 CellID->26539852]
}, Open  ]],
Cell[72473, 2612, 200, 7, 70, "MathCaption",
 CellID->23724],
Cell[CellGroupData[{
Cell[72698, 2623, 114, 3, 70, "Input",
 CellID->29511],
Cell[72815, 2628, 171, 6, 38, "Output",
 CellID->388157477]
}, Open  ]],
Cell[73001, 2637, 82, 1, 70, "MathCaption",
 CellID->231086810],
Cell[CellGroupData[{
Cell[73108, 2642, 154, 4, 70, "Input",
 CellID->416413754],
Cell[73265, 2648, 162, 5, 36, "Output",
 CellID->595734826]
}, Open  ]],
Cell[73442, 2656, 204, 7, 70, "MathCaption",
 CellID->30265],
Cell[CellGroupData[{
Cell[73671, 2667, 126, 4, 70, "Input",
 CellID->20840],
Cell[73800, 2673, 325, 11, 36, "Output",
 CellID->771287748]
}, Open  ]],
Cell[74140, 2687, 212, 7, 70, "MathCaption",
 CellID->24955],
Cell[CellGroupData[{
Cell[74377, 2698, 103, 3, 70, "Input",
 CellID->16028],
Cell[74483, 2703, 179, 6, 51, "Output",
 CellID->244165091]
}, Open  ]],
Cell[74677, 2712, 588, 14, 70, "Text",
 CellID->150583992],
Cell[75268, 2728, 1080, 33, 70, "DefinitionBox",
 CellID->256522711],
Cell[76351, 2763, 71, 1, 70, "Caption",
 CellID->317717459],
Cell[76425, 2766, 157, 4, 70, "MathCaption",
 CellID->433405108],
Cell[CellGroupData[{
Cell[76607, 2774, 146, 4, 70, "Input",
 CellID->494608285],
Cell[76756, 2780, 301, 10, 51, "Output",
 CellID->374975094]
}, Open  ]],
Cell[77072, 2793, 84, 1, 70, "MathCaption",
 CellID->467587602],
Cell[CellGroupData[{
Cell[77181, 2798, 184, 6, 70, "Input",
 CellID->165733916],
Cell[77368, 2806, 534, 16, 51, "Output",
 CellID->64987589]
}, Open  ]],
Cell[77917, 2825, 225, 6, 70, "MathCaption",
 CellID->359100584],
Cell[CellGroupData[{
Cell[78167, 2835, 157, 4, 70, "Input",
 CellID->308489576],
Cell[78327, 2841, 683, 19, 81, "Output",
 CellID->126230974]
}, Open  ]],
Cell[79025, 2863, 143, 4, 70, "MathCaption",
 CellID->386353913],
Cell[CellGroupData[{
Cell[79193, 2871, 148, 4, 70, "Input",
 CellID->143034996],
Cell[79344, 2877, 549, 16, 51, "Output",
 CellID->754097649]
}, Open  ]],
Cell[79908, 2896, 1661, 49, 70, "DefinitionBox",
 CellID->1045986489],
Cell[81572, 2947, 70, 1, 70, "Caption",
 CellID->217379925],
Cell[81645, 2950, 1699, 52, 70, "Text",
 CellID->31655],
Cell[83347, 3004, 129, 4, 70, "MathCaption",
 CellID->1807],
Cell[CellGroupData[{
Cell[83501, 3012, 346, 11, 70, "Input",
 CellID->14449],
Cell[83850, 3025, 391, 13, 36, "Output",
 CellID->42777745]
}, Open  ]],
Cell[84256, 3041, 154, 4, 70, "MathCaption",
 CellID->18760],
Cell[CellGroupData[{
Cell[84435, 3049, 423, 13, 70, "Input",
 CellID->24382],
Cell[84861, 3064, 490, 16, 36, "Output",
 CellID->286031805]
}, Open  ]],
Cell[85366, 3083, 356, 9, 70, "Text",
 CellID->30219],
Cell[85725, 3094, 1091, 36, 70, "Text",
 CellID->217495362],
Cell[86819, 3132, 135, 4, 70, "MathCaption",
 CellID->223567287],
Cell[CellGroupData[{
Cell[86979, 3140, 187, 6, 70, "Input",
 CellID->133222340],
Cell[87169, 3148, 761, 24, 54, "Output",
 CellID->255667519]
}, Open  ]],
Cell[87945, 3175, 82, 1, 70, "MathCaption",
 CellID->44750455],
Cell[CellGroupData[{
Cell[88052, 3180, 267, 9, 70, "Input",
 CellID->57119199],
Cell[88322, 3191, 209, 7, 36, "Output",
 CellID->70210096]
}, Open  ]],
Cell[88546, 3201, 139, 4, 70, "MathCaption",
 CellID->151137100],
Cell[CellGroupData[{
Cell[88710, 3209, 424, 14, 70, "Input",
 CellID->204512874],
Cell[89137, 3225, 727, 24, 36, "Output",
 CellID->260358485]
}, Open  ]],
Cell[89879, 3252, 892, 27, 70, "DefinitionBox",
 CellID->2432],
Cell[90774, 3281, 57, 1, 70, "Caption",
 CellID->18227],
Cell[90834, 3284, 114, 3, 70, "MathCaption",
 CellID->30160],
Cell[CellGroupData[{
Cell[90973, 3291, 130, 4, 70, "Input",
 CellID->16139],
Cell[91106, 3297, 258, 8, 36, "Output",
 CellID->500837272]
}, Open  ]],
Cell[91379, 3308, 119, 3, 70, "MathCaption",
 CellID->22237],
Cell[CellGroupData[{
Cell[91523, 3315, 137, 4, 70, "Input",
 CellID->32048],
Cell[91663, 3321, 159, 5, 36, "Output",
 CellID->128837515]
}, Open  ]],
Cell[91837, 3329, 108, 3, 70, "MathCaption",
 CellID->24404],
Cell[CellGroupData[{
Cell[91970, 3336, 291, 9, 70, "Input",
 CellID->7946703],
Cell[92264, 3347, 984, 25, 146, "Output",
 CellID->440221745]
}, Open  ]],
Cell[93263, 3375, 4441, 148, 70, "DefinitionBox",
 CellID->28221],
Cell[97707, 3525, 55, 1, 70, "Caption",
 CellID->22133],
Cell[97765, 3528, 2273, 79, 70, "Text",
 CellID->13175],
Cell[100041, 3609, 117, 3, 70, "MathCaption",
 CellID->6241],
Cell[CellGroupData[{
Cell[100183, 3616, 199, 7, 70, "Input",
 CellID->32514],
Cell[100385, 3625, 291, 11, 50, "Output",
 CellID->564008673]
}, Open  ]],
Cell[100691, 3639, 941, 24, 70, "Text",
 CellID->17362],
Cell[101635, 3665, 675, 23, 70, "DefinitionBox",
 CellID->26641],
Cell[102313, 3690, 64, 1, 70, "Caption",
 CellID->3578],
Cell[102380, 3693, 1519, 49, 70, "Text",
 CellID->5656],
Cell[103902, 3744, 91, 1, 70, "MathCaption",
 CellID->21057],
Cell[CellGroupData[{
Cell[104018, 3749, 147, 4, 70, "Input",
 CellID->24592],
Cell[104168, 3755, 162, 5, 36, "Output",
 CellID->265118806]
}, Open  ]],
Cell[104345, 3763, 221, 9, 70, "MathCaption",
 CellID->2039],
Cell[CellGroupData[{
Cell[104591, 3776, 104, 3, 70, "Input",
 CellID->3446],
Cell[104698, 3781, 163, 5, 36, "Output",
 CellID->293385022]
}, Open  ]],
Cell[104876, 3789, 206, 7, 70, "MathCaption",
 CellID->2232],
Cell[CellGroupData[{
Cell[105107, 3800, 153, 5, 70, "Input",
 CellID->6999],
Cell[105263, 3807, 162, 5, 36, "Output",
 CellID->331952130]
}, Open  ]],
Cell[105440, 3815, 2251, 76, 70, "DefinitionBox",
 CellID->1578],
Cell[107694, 3893, 58, 1, 70, "Caption",
 CellID->21735],
Cell[107755, 3896, 1189, 37, 70, "Text",
 CellID->3080],
Cell[108947, 3935, 158, 6, 70, "MathCaption",
 CellID->24394],
Cell[CellGroupData[{
Cell[109130, 3945, 102, 3, 70, "Input",
 CellID->4996],
Cell[109235, 3950, 160, 5, 36, "Output",
 CellID->123920150]
}, Open  ]],
Cell[109410, 3958, 118, 3, 70, "MathCaption",
 CellID->32102],
Cell[CellGroupData[{
Cell[109553, 3965, 159, 5, 70, "Input",
 CellID->18251],
Cell[109715, 3972, 333, 10, 71, "Output",
 CellID->420566719]
}, Open  ]],
Cell[110063, 3985, 165, 6, 70, "MathCaption",
 CellID->18597],
Cell[CellGroupData[{
Cell[110253, 3995, 140, 5, 70, "Input",
 CellID->30342],
Cell[110396, 4002, 159, 5, 36, "Output",
 CellID->40296029]
}, Open  ]],
Cell[110570, 4010, 934, 31, 70, "Text",
 CellID->24158],
Cell[111507, 4043, 249, 9, 70, "MathCaption",
 CellID->14746],
Cell[CellGroupData[{
Cell[111781, 4056, 154, 5, 70, "Input",
 CellID->20671],
Cell[111938, 4063, 160, 5, 36, "Output",
 CellID->635074538]
}, Open  ]],
Cell[112113, 4071, 412, 13, 70, "DefinitionBox",
 CellID->17129],
Cell[112528, 4086, 70, 1, 70, "Caption",
 CellID->9228],
Cell[112601, 4089, 835, 27, 70, "Text",
 CellID->8392],
Cell[113439, 4118, 91, 1, 70, "MathCaption",
 CellID->23669],
Cell[CellGroupData[{
Cell[113555, 4123, 107, 3, 70, "Input",
 CellID->8564],
Cell[113665, 4128, 161, 5, 36, "Output",
 CellID->55497200]
}, Open  ]],
Cell[113841, 4136, 227, 8, 70, "MathCaption",
 CellID->15452],
Cell[CellGroupData[{
Cell[114093, 4148, 176, 6, 70, "Input",
 CellID->22721],
Cell[114272, 4156, 162, 5, 36, "Output",
 CellID->200531377]
}, Open  ]],
Cell[114449, 4164, 971, 33, 70, "DefinitionBox",
 CellID->5065],
Cell[115423, 4199, 69, 1, 70, "Caption",
 CellID->20068],
Cell[115495, 4202, 1252, 46, 70, "Text",
 CellID->17697],
Cell[116750, 4250, 513, 19, 70, "MathCaption",
 CellID->7533],
Cell[CellGroupData[{
Cell[117288, 4273, 251, 8, 70, "Input",
 CellID->3691],
Cell[117542, 4283, 161, 5, 36, "Output",
 CellID->114800479]
}, Open  ]],
Cell[117718, 4291, 64, 1, 70, "MathCaption",
 CellID->2821],
Cell[CellGroupData[{
Cell[117807, 4296, 181, 6, 70, "Input",
 CellID->2902],
Cell[117991, 4304, 214, 7, 36, "Output",
 CellID->136990314]
}, Open  ]],
Cell[118220, 4314, 74, 1, 70, "MathCaption",
 CellID->17601],
Cell[CellGroupData[{
Cell[118319, 4319, 234, 7, 70, "Input",
 CellID->14222],
Cell[118556, 4328, 185, 5, 36, "Output",
 CellID->21814270]
}, Open  ]],
Cell[118756, 4336, 503, 16, 70, "DefinitionBox",
 CellID->6879],
Cell[119262, 4354, 61, 1, 70, "Caption",
 CellID->5815],
Cell[119326, 4357, 809, 23, 70, "Text",
 CellID->29159],
Cell[120138, 4382, 153, 6, 70, "MathCaption",
 CellID->10847],
Cell[CellGroupData[{
Cell[120316, 4392, 106, 3, 70, "Input",
 CellID->16462],
Cell[120425, 4397, 157, 5, 36, "Output",
 CellID->6667889]
}, Open  ]],
Cell[120597, 4405, 86, 1, 70, "MathCaption",
 CellID->31862],
Cell[CellGroupData[{
Cell[120708, 4410, 210, 7, 70, "Input",
 CellID->279],
Cell[120921, 4419, 224, 7, 36, "Output",
 CellID->483775748]
}, Open  ]],
Cell[121160, 4429, 82, 1, 70, "MathCaption",
 CellID->28541],
Cell[CellGroupData[{
Cell[121267, 4434, 133, 4, 70, "Input",
 CellID->29359],
Cell[121403, 4440, 159, 5, 36, "Output",
 CellID->344128405]
}, Open  ]],
Cell[121577, 4448, 88, 1, 70, "MathCaption",
 CellID->20622],
Cell[CellGroupData[{
Cell[121690, 4453, 153, 5, 70, "Input",
 CellID->1878],
Cell[121846, 4460, 162, 5, 36, "Output",
 CellID->711622727]
}, Open  ]],
Cell[122023, 4468, 155, 4, 70, "MathCaption",
 CellID->3908],
Cell[CellGroupData[{
Cell[122203, 4476, 130, 4, 70, "Input",
 CellID->8402],
Cell[122336, 4482, 201, 6, 36, "Output",
 CellID->238245695]
}, Open  ]],
Cell[122552, 4491, 1276, 41, 70, "DefinitionBox",
 CellID->12436],
Cell[123831, 4534, 104, 3, 70, "Caption",
 CellID->21903],
Cell[123938, 4539, 249, 9, 70, "MathCaption",
 CellID->17980],
Cell[CellGroupData[{
Cell[124212, 4552, 149, 4, 70, "Input",
 CellID->14589],
Cell[124364, 4558, 462, 15, 36, "Output",
 CellID->213732321]
}, Open  ]],
Cell[CellGroupData[{
Cell[124863, 4578, 71, 1, 70, "RelatedTutorialsSection",
 CellID->43426385],
Cell[124937, 4581, 175, 4, 70, "RelatedTutorials",
 CellID->13333267]
}, Open  ]]
}, Open  ]],
Cell[125139, 4589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

